/* tslint:disable */
/* eslint-disable */
/**
 * Halo
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: 2.20.10-SNAPSHOT
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


import type { Configuration } from '../configuration';
import type { AxiosPromise, AxiosInstance, RawAxiosRequestConfig } from 'axios';
import globalAxios from 'axios';
// Some imports not used depending on template conditions
// @ts-ignore
import { DUMMY_BASE_URL, assertParamExists, setApiKeyToObject, setBasicAuthToObject, setBearerAuthToObject, setOAuthToObject, setSearchParams, serializeDataIfNeeded, toPathString, createRequestFunction } from '../common';
// @ts-ignore
import { BASE_PATH, COLLECTION_FORMATS, RequestArgs, BaseAPI, RequiredError, operationServerMap } from '../base';
// @ts-ignore
import { JsonPatchInner } from '../models';
// @ts-ignore
import { Theme } from '../models';
// @ts-ignore
import { ThemeList } from '../models';
/**
 * ThemeV1alpha1Api - axios parameter creator
 * @export
 */
export const ThemeV1alpha1ApiAxiosParamCreator = function (configuration?: Configuration) {
    return {
        /**
         * Create Theme
         * @param {Theme} [theme] Fresh theme
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        createTheme: async (theme?: Theme, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            const localVarPath = `/apis/theme.halo.run/v1alpha1/themes`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'POST', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            localVarHeaderParameter['Content-Type'] = 'application/json';

            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};
            localVarRequestOptions.data = serializeDataIfNeeded(theme, localVarRequestOptions, configuration)

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Delete Theme
         * @param {string} name Name of theme
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        deleteTheme: async (name: string, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'name' is not null or undefined
            assertParamExists('deleteTheme', 'name', name)
            const localVarPath = `/apis/theme.halo.run/v1alpha1/themes/{name}`
                .replace(`{${"name"}}`, encodeURIComponent(String(name)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'DELETE', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Get Theme
         * @param {string} name Name of theme
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        getTheme: async (name: string, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'name' is not null or undefined
            assertParamExists('getTheme', 'name', name)
            const localVarPath = `/apis/theme.halo.run/v1alpha1/themes/{name}`
                .replace(`{${"name"}}`, encodeURIComponent(String(name)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'GET', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * List Theme
         * @param {number} [page] Page number. Default is 0.
         * @param {number} [size] Size number. Default is 0.
         * @param {Array<string>} [labelSelector] Label selector. e.g.: hidden!&#x3D;true
         * @param {Array<string>} [fieldSelector] Field selector. e.g.: metadata.name&#x3D;&#x3D;halo
         * @param {Array<string>} [sort] Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        listTheme: async (page?: number, size?: number, labelSelector?: Array<string>, fieldSelector?: Array<string>, sort?: Array<string>, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            const localVarPath = `/apis/theme.halo.run/v1alpha1/themes`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'GET', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)

            if (page !== undefined) {
                localVarQueryParameter['page'] = page;
            }

            if (size !== undefined) {
                localVarQueryParameter['size'] = size;
            }

            if (labelSelector) {
                localVarQueryParameter['labelSelector'] = labelSelector;
            }

            if (fieldSelector) {
                localVarQueryParameter['fieldSelector'] = fieldSelector;
            }

            if (sort) {
                localVarQueryParameter['sort'] = sort;
            }


    
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Patch Theme
         * @param {string} name Name of theme
         * @param {Array<JsonPatchInner>} [jsonPatchInner] 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        patchTheme: async (name: string, jsonPatchInner?: Array<JsonPatchInner>, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'name' is not null or undefined
            assertParamExists('patchTheme', 'name', name)
            const localVarPath = `/apis/theme.halo.run/v1alpha1/themes/{name}`
                .replace(`{${"name"}}`, encodeURIComponent(String(name)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'PATCH', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            localVarHeaderParameter['Content-Type'] = 'application/json-patch+json';

            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};
            localVarRequestOptions.data = serializeDataIfNeeded(jsonPatchInner, localVarRequestOptions, configuration)

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Update Theme
         * @param {string} name Name of theme
         * @param {Theme} [theme] Updated theme
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        updateTheme: async (name: string, theme?: Theme, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'name' is not null or undefined
            assertParamExists('updateTheme', 'name', name)
            const localVarPath = `/apis/theme.halo.run/v1alpha1/themes/{name}`
                .replace(`{${"name"}}`, encodeURIComponent(String(name)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'PUT', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            localVarHeaderParameter['Content-Type'] = 'application/json';

            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};
            localVarRequestOptions.data = serializeDataIfNeeded(theme, localVarRequestOptions, configuration)

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
    }
};

/**
 * ThemeV1alpha1Api - functional programming interface
 * @export
 */
export const ThemeV1alpha1ApiFp = function(configuration?: Configuration) {
    const localVarAxiosParamCreator = ThemeV1alpha1ApiAxiosParamCreator(configuration)
    return {
        /**
         * Create Theme
         * @param {Theme} [theme] Fresh theme
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async createTheme(theme?: Theme, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<Theme>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.createTheme(theme, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['ThemeV1alpha1Api.createTheme']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Delete Theme
         * @param {string} name Name of theme
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async deleteTheme(name: string, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<void>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.deleteTheme(name, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['ThemeV1alpha1Api.deleteTheme']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Get Theme
         * @param {string} name Name of theme
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async getTheme(name: string, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<Theme>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.getTheme(name, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['ThemeV1alpha1Api.getTheme']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * List Theme
         * @param {number} [page] Page number. Default is 0.
         * @param {number} [size] Size number. Default is 0.
         * @param {Array<string>} [labelSelector] Label selector. e.g.: hidden!&#x3D;true
         * @param {Array<string>} [fieldSelector] Field selector. e.g.: metadata.name&#x3D;&#x3D;halo
         * @param {Array<string>} [sort] Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async listTheme(page?: number, size?: number, labelSelector?: Array<string>, fieldSelector?: Array<string>, sort?: Array<string>, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<ThemeList>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.listTheme(page, size, labelSelector, fieldSelector, sort, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['ThemeV1alpha1Api.listTheme']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Patch Theme
         * @param {string} name Name of theme
         * @param {Array<JsonPatchInner>} [jsonPatchInner] 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async patchTheme(name: string, jsonPatchInner?: Array<JsonPatchInner>, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<Theme>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.patchTheme(name, jsonPatchInner, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['ThemeV1alpha1Api.patchTheme']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Update Theme
         * @param {string} name Name of theme
         * @param {Theme} [theme] Updated theme
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async updateTheme(name: string, theme?: Theme, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<Theme>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.updateTheme(name, theme, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['ThemeV1alpha1Api.updateTheme']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
    }
};

/**
 * ThemeV1alpha1Api - factory interface
 * @export
 */
export const ThemeV1alpha1ApiFactory = function (configuration?: Configuration, basePath?: string, axios?: AxiosInstance) {
    const localVarFp = ThemeV1alpha1ApiFp(configuration)
    return {
        /**
         * Create Theme
         * @param {ThemeV1alpha1ApiCreateThemeRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        createTheme(requestParameters: ThemeV1alpha1ApiCreateThemeRequest = {}, options?: RawAxiosRequestConfig): AxiosPromise<Theme> {
            return localVarFp.createTheme(requestParameters.theme, options).then((request) => request(axios, basePath));
        },
        /**
         * Delete Theme
         * @param {ThemeV1alpha1ApiDeleteThemeRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        deleteTheme(requestParameters: ThemeV1alpha1ApiDeleteThemeRequest, options?: RawAxiosRequestConfig): AxiosPromise<void> {
            return localVarFp.deleteTheme(requestParameters.name, options).then((request) => request(axios, basePath));
        },
        /**
         * Get Theme
         * @param {ThemeV1alpha1ApiGetThemeRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        getTheme(requestParameters: ThemeV1alpha1ApiGetThemeRequest, options?: RawAxiosRequestConfig): AxiosPromise<Theme> {
            return localVarFp.getTheme(requestParameters.name, options).then((request) => request(axios, basePath));
        },
        /**
         * List Theme
         * @param {ThemeV1alpha1ApiListThemeRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        listTheme(requestParameters: ThemeV1alpha1ApiListThemeRequest = {}, options?: RawAxiosRequestConfig): AxiosPromise<ThemeList> {
            return localVarFp.listTheme(requestParameters.page, requestParameters.size, requestParameters.labelSelector, requestParameters.fieldSelector, requestParameters.sort, options).then((request) => request(axios, basePath));
        },
        /**
         * Patch Theme
         * @param {ThemeV1alpha1ApiPatchThemeRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        patchTheme(requestParameters: ThemeV1alpha1ApiPatchThemeRequest, options?: RawAxiosRequestConfig): AxiosPromise<Theme> {
            return localVarFp.patchTheme(requestParameters.name, requestParameters.jsonPatchInner, options).then((request) => request(axios, basePath));
        },
        /**
         * Update Theme
         * @param {ThemeV1alpha1ApiUpdateThemeRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        updateTheme(requestParameters: ThemeV1alpha1ApiUpdateThemeRequest, options?: RawAxiosRequestConfig): AxiosPromise<Theme> {
            return localVarFp.updateTheme(requestParameters.name, requestParameters.theme, options).then((request) => request(axios, basePath));
        },
    };
};

/**
 * Request parameters for createTheme operation in ThemeV1alpha1Api.
 * @export
 * @interface ThemeV1alpha1ApiCreateThemeRequest
 */
export interface ThemeV1alpha1ApiCreateThemeRequest {
    /**
     * Fresh theme
     * @type {Theme}
     * @memberof ThemeV1alpha1ApiCreateTheme
     */
    readonly theme?: Theme
}

/**
 * Request parameters for deleteTheme operation in ThemeV1alpha1Api.
 * @export
 * @interface ThemeV1alpha1ApiDeleteThemeRequest
 */
export interface ThemeV1alpha1ApiDeleteThemeRequest {
    /**
     * Name of theme
     * @type {string}
     * @memberof ThemeV1alpha1ApiDeleteTheme
     */
    readonly name: string
}

/**
 * Request parameters for getTheme operation in ThemeV1alpha1Api.
 * @export
 * @interface ThemeV1alpha1ApiGetThemeRequest
 */
export interface ThemeV1alpha1ApiGetThemeRequest {
    /**
     * Name of theme
     * @type {string}
     * @memberof ThemeV1alpha1ApiGetTheme
     */
    readonly name: string
}

/**
 * Request parameters for listTheme operation in ThemeV1alpha1Api.
 * @export
 * @interface ThemeV1alpha1ApiListThemeRequest
 */
export interface ThemeV1alpha1ApiListThemeRequest {
    /**
     * Page number. Default is 0.
     * @type {number}
     * @memberof ThemeV1alpha1ApiListTheme
     */
    readonly page?: number

    /**
     * Size number. Default is 0.
     * @type {number}
     * @memberof ThemeV1alpha1ApiListTheme
     */
    readonly size?: number

    /**
     * Label selector. e.g.: hidden!&#x3D;true
     * @type {Array<string>}
     * @memberof ThemeV1alpha1ApiListTheme
     */
    readonly labelSelector?: Array<string>

    /**
     * Field selector. e.g.: metadata.name&#x3D;&#x3D;halo
     * @type {Array<string>}
     * @memberof ThemeV1alpha1ApiListTheme
     */
    readonly fieldSelector?: Array<string>

    /**
     * Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.
     * @type {Array<string>}
     * @memberof ThemeV1alpha1ApiListTheme
     */
    readonly sort?: Array<string>
}

/**
 * Request parameters for patchTheme operation in ThemeV1alpha1Api.
 * @export
 * @interface ThemeV1alpha1ApiPatchThemeRequest
 */
export interface ThemeV1alpha1ApiPatchThemeRequest {
    /**
     * Name of theme
     * @type {string}
     * @memberof ThemeV1alpha1ApiPatchTheme
     */
    readonly name: string

    /**
     * 
     * @type {Array<JsonPatchInner>}
     * @memberof ThemeV1alpha1ApiPatchTheme
     */
    readonly jsonPatchInner?: Array<JsonPatchInner>
}

/**
 * Request parameters for updateTheme operation in ThemeV1alpha1Api.
 * @export
 * @interface ThemeV1alpha1ApiUpdateThemeRequest
 */
export interface ThemeV1alpha1ApiUpdateThemeRequest {
    /**
     * Name of theme
     * @type {string}
     * @memberof ThemeV1alpha1ApiUpdateTheme
     */
    readonly name: string

    /**
     * Updated theme
     * @type {Theme}
     * @memberof ThemeV1alpha1ApiUpdateTheme
     */
    readonly theme?: Theme
}

/**
 * ThemeV1alpha1Api - object-oriented interface
 * @export
 * @class ThemeV1alpha1Api
 * @extends {BaseAPI}
 */
export class ThemeV1alpha1Api extends BaseAPI {
    /**
     * Create Theme
     * @param {ThemeV1alpha1ApiCreateThemeRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof ThemeV1alpha1Api
     */
    public createTheme(requestParameters: ThemeV1alpha1ApiCreateThemeRequest = {}, options?: RawAxiosRequestConfig) {
        return ThemeV1alpha1ApiFp(this.configuration).createTheme(requestParameters.theme, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Delete Theme
     * @param {ThemeV1alpha1ApiDeleteThemeRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof ThemeV1alpha1Api
     */
    public deleteTheme(requestParameters: ThemeV1alpha1ApiDeleteThemeRequest, options?: RawAxiosRequestConfig) {
        return ThemeV1alpha1ApiFp(this.configuration).deleteTheme(requestParameters.name, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Get Theme
     * @param {ThemeV1alpha1ApiGetThemeRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof ThemeV1alpha1Api
     */
    public getTheme(requestParameters: ThemeV1alpha1ApiGetThemeRequest, options?: RawAxiosRequestConfig) {
        return ThemeV1alpha1ApiFp(this.configuration).getTheme(requestParameters.name, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * List Theme
     * @param {ThemeV1alpha1ApiListThemeRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof ThemeV1alpha1Api
     */
    public listTheme(requestParameters: ThemeV1alpha1ApiListThemeRequest = {}, options?: RawAxiosRequestConfig) {
        return ThemeV1alpha1ApiFp(this.configuration).listTheme(requestParameters.page, requestParameters.size, requestParameters.labelSelector, requestParameters.fieldSelector, requestParameters.sort, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Patch Theme
     * @param {ThemeV1alpha1ApiPatchThemeRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof ThemeV1alpha1Api
     */
    public patchTheme(requestParameters: ThemeV1alpha1ApiPatchThemeRequest, options?: RawAxiosRequestConfig) {
        return ThemeV1alpha1ApiFp(this.configuration).patchTheme(requestParameters.name, requestParameters.jsonPatchInner, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Update Theme
     * @param {ThemeV1alpha1ApiUpdateThemeRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof ThemeV1alpha1Api
     */
    public updateTheme(requestParameters: ThemeV1alpha1ApiUpdateThemeRequest, options?: RawAxiosRequestConfig) {
        return ThemeV1alpha1ApiFp(this.configuration).updateTheme(requestParameters.name, requestParameters.theme, options).then((request) => request(this.axios, this.basePath));
    }
}

