/* tslint:disable */
/* eslint-disable */
/**
 * Halo
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: 2.20.10-SNAPSHOT
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


import type { Configuration } from '../configuration';
import type { AxiosPromise, AxiosInstance, RawAxiosRequestConfig } from 'axios';
import globalAxios from 'axios';
// Some imports not used depending on template conditions
// @ts-ignore
import { DUMMY_BASE_URL, assertParamExists, setApiKeyToObject, setBasicAuthToObject, setBearerAuthToObject, setOAuthToObject, setSearchParams, serializeDataIfNeeded, toPathString, createRequestFunction } from '../common';
// @ts-ignore
import { BASE_PATH, COLLECTION_FORMATS, RequestArgs, BaseAPI, RequiredError, operationServerMap } from '../base';
// @ts-ignore
import { ConfigMap } from '../models';
// @ts-ignore
import { InstallFromUriRequest } from '../models';
// @ts-ignore
import { Setting } from '../models';
// @ts-ignore
import { Theme } from '../models';
// @ts-ignore
import { ThemeList } from '../models';
// @ts-ignore
import { UpgradeFromUriRequest } from '../models';
/**
 * ThemeV1alpha1ConsoleApi - axios parameter creator
 * @export
 */
export const ThemeV1alpha1ConsoleApiAxiosParamCreator = function (configuration?: Configuration) {
    return {
        /**
         * Activate a theme by name.
         * @param {string} name 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        activateTheme: async (name: string, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'name' is not null or undefined
            assertParamExists('activateTheme', 'name', name)
            const localVarPath = `/apis/api.console.halo.run/v1alpha1/themes/{name}/activation`
                .replace(`{${"name"}}`, encodeURIComponent(String(name)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'PUT', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Fetch the activated theme.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        fetchActivatedTheme: async (options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            const localVarPath = `/apis/api.console.halo.run/v1alpha1/themes/-/activation`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'GET', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Fetch configMap of theme by configured configMapName. It is deprecated.
         * @param {string} name 
         * @param {*} [options] Override http request option.
         * @deprecated
         * @throws {RequiredError}
         */
        fetchThemeConfig: async (name: string, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'name' is not null or undefined
            assertParamExists('fetchThemeConfig', 'name', name)
            const localVarPath = `/apis/api.console.halo.run/v1alpha1/themes/{name}/config`
                .replace(`{${"name"}}`, encodeURIComponent(String(name)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'GET', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Fetch converted json config of theme by configured configMapName.
         * @param {string} name 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        fetchThemeJsonConfig: async (name: string, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'name' is not null or undefined
            assertParamExists('fetchThemeJsonConfig', 'name', name)
            const localVarPath = `/apis/api.console.halo.run/v1alpha1/themes/{name}/json-config`
                .replace(`{${"name"}}`, encodeURIComponent(String(name)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'GET', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Fetch setting of theme.
         * @param {string} name 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        fetchThemeSetting: async (name: string, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'name' is not null or undefined
            assertParamExists('fetchThemeSetting', 'name', name)
            const localVarPath = `/apis/api.console.halo.run/v1alpha1/themes/{name}/setting`
                .replace(`{${"name"}}`, encodeURIComponent(String(name)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'GET', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Install a theme by uploading a zip file.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        installTheme: async (options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            const localVarPath = `/apis/api.console.halo.run/v1alpha1/themes/install`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'POST', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Install a theme from uri.
         * @param {InstallFromUriRequest} installFromUriRequest 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        installThemeFromUri: async (installFromUriRequest: InstallFromUriRequest, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'installFromUriRequest' is not null or undefined
            assertParamExists('installThemeFromUri', 'installFromUriRequest', installFromUriRequest)
            const localVarPath = `/apis/api.console.halo.run/v1alpha1/themes/-/install-from-uri`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'POST', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            localVarHeaderParameter['Content-Type'] = 'application/json';

            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};
            localVarRequestOptions.data = serializeDataIfNeeded(installFromUriRequest, localVarRequestOptions, configuration)

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Invalidate theme template cache.
         * @param {string} name 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        invalidateCache: async (name: string, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'name' is not null or undefined
            assertParamExists('invalidateCache', 'name', name)
            const localVarPath = `/apis/api.console.halo.run/v1alpha1/themes/{name}/invalidate-cache`
                .replace(`{${"name"}}`, encodeURIComponent(String(name)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'PUT', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * List themes.
         * @param {number} [page] Page number. Default is 0.
         * @param {number} [size] Size number. Default is 0.
         * @param {Array<string>} [labelSelector] Label selector. e.g.: hidden!&#x3D;true
         * @param {Array<string>} [fieldSelector] Field selector. e.g.: metadata.name&#x3D;&#x3D;halo
         * @param {boolean} [uninstalled] Whether to list uninstalled themes.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        listThemes: async (page?: number, size?: number, labelSelector?: Array<string>, fieldSelector?: Array<string>, uninstalled?: boolean, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            const localVarPath = `/apis/api.console.halo.run/v1alpha1/themes`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'GET', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)

            if (page !== undefined) {
                localVarQueryParameter['page'] = page;
            }

            if (size !== undefined) {
                localVarQueryParameter['size'] = size;
            }

            if (labelSelector) {
                localVarQueryParameter['labelSelector'] = labelSelector;
            }

            if (fieldSelector) {
                localVarQueryParameter['fieldSelector'] = fieldSelector;
            }

            if (uninstalled !== undefined) {
                localVarQueryParameter['uninstalled'] = uninstalled;
            }


    
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Reload theme setting.
         * @param {string} name 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        reload: async (name: string, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'name' is not null or undefined
            assertParamExists('reload', 'name', name)
            const localVarPath = `/apis/api.console.halo.run/v1alpha1/themes/{name}/reload`
                .replace(`{${"name"}}`, encodeURIComponent(String(name)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'PUT', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Reset the configMap of theme setting.
         * @param {string} name 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        resetThemeConfig: async (name: string, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'name' is not null or undefined
            assertParamExists('resetThemeConfig', 'name', name)
            const localVarPath = `/apis/api.console.halo.run/v1alpha1/themes/{name}/reset-config`
                .replace(`{${"name"}}`, encodeURIComponent(String(name)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'PUT', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Update the configMap of theme setting. It is deprecated.
         * @param {string} name 
         * @param {ConfigMap} configMap 
         * @param {*} [options] Override http request option.
         * @deprecated
         * @throws {RequiredError}
         */
        updateThemeConfig: async (name: string, configMap: ConfigMap, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'name' is not null or undefined
            assertParamExists('updateThemeConfig', 'name', name)
            // verify required parameter 'configMap' is not null or undefined
            assertParamExists('updateThemeConfig', 'configMap', configMap)
            const localVarPath = `/apis/api.console.halo.run/v1alpha1/themes/{name}/config`
                .replace(`{${"name"}}`, encodeURIComponent(String(name)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'PUT', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            localVarHeaderParameter['Content-Type'] = 'application/json';

            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};
            localVarRequestOptions.data = serializeDataIfNeeded(configMap, localVarRequestOptions, configuration)

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Update the configMap of theme setting.
         * @param {string} name 
         * @param {object} body 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        updateThemeJsonConfig: async (name: string, body: object, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'name' is not null or undefined
            assertParamExists('updateThemeJsonConfig', 'name', name)
            // verify required parameter 'body' is not null or undefined
            assertParamExists('updateThemeJsonConfig', 'body', body)
            const localVarPath = `/apis/api.console.halo.run/v1alpha1/themes/{name}/json-config`
                .replace(`{${"name"}}`, encodeURIComponent(String(name)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'PUT', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            localVarHeaderParameter['Content-Type'] = 'application/json';

            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};
            localVarRequestOptions.data = serializeDataIfNeeded(body, localVarRequestOptions, configuration)

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Upgrade theme
         * @param {string} name 
         * @param {File} file 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        upgradeTheme: async (name: string, file: File, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'name' is not null or undefined
            assertParamExists('upgradeTheme', 'name', name)
            // verify required parameter 'file' is not null or undefined
            assertParamExists('upgradeTheme', 'file', file)
            const localVarPath = `/apis/api.console.halo.run/v1alpha1/themes/{name}/upgrade`
                .replace(`{${"name"}}`, encodeURIComponent(String(name)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'POST', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;
            const localVarFormParams = new ((configuration && configuration.formDataCtor) || FormData)();

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


            if (file !== undefined) { 
                localVarFormParams.append('file', file as any);
            }
    
    
            localVarHeaderParameter['Content-Type'] = 'multipart/form-data';
    
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};
            localVarRequestOptions.data = localVarFormParams;

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Upgrade a theme from uri.
         * @param {string} name 
         * @param {UpgradeFromUriRequest} upgradeFromUriRequest 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        upgradeThemeFromUri: async (name: string, upgradeFromUriRequest: UpgradeFromUriRequest, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'name' is not null or undefined
            assertParamExists('upgradeThemeFromUri', 'name', name)
            // verify required parameter 'upgradeFromUriRequest' is not null or undefined
            assertParamExists('upgradeThemeFromUri', 'upgradeFromUriRequest', upgradeFromUriRequest)
            const localVarPath = `/apis/api.console.halo.run/v1alpha1/themes/{name}/upgrade-from-uri`
                .replace(`{${"name"}}`, encodeURIComponent(String(name)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'POST', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            localVarHeaderParameter['Content-Type'] = 'application/json';

            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};
            localVarRequestOptions.data = serializeDataIfNeeded(upgradeFromUriRequest, localVarRequestOptions, configuration)

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
    }
};

/**
 * ThemeV1alpha1ConsoleApi - functional programming interface
 * @export
 */
export const ThemeV1alpha1ConsoleApiFp = function(configuration?: Configuration) {
    const localVarAxiosParamCreator = ThemeV1alpha1ConsoleApiAxiosParamCreator(configuration)
    return {
        /**
         * Activate a theme by name.
         * @param {string} name 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async activateTheme(name: string, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<Theme>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.activateTheme(name, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['ThemeV1alpha1ConsoleApi.activateTheme']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Fetch the activated theme.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async fetchActivatedTheme(options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<Theme>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.fetchActivatedTheme(options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['ThemeV1alpha1ConsoleApi.fetchActivatedTheme']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Fetch configMap of theme by configured configMapName. It is deprecated.
         * @param {string} name 
         * @param {*} [options] Override http request option.
         * @deprecated
         * @throws {RequiredError}
         */
        async fetchThemeConfig(name: string, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<ConfigMap>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.fetchThemeConfig(name, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['ThemeV1alpha1ConsoleApi.fetchThemeConfig']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Fetch converted json config of theme by configured configMapName.
         * @param {string} name 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async fetchThemeJsonConfig(name: string, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<object>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.fetchThemeJsonConfig(name, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['ThemeV1alpha1ConsoleApi.fetchThemeJsonConfig']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Fetch setting of theme.
         * @param {string} name 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async fetchThemeSetting(name: string, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<Setting>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.fetchThemeSetting(name, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['ThemeV1alpha1ConsoleApi.fetchThemeSetting']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Install a theme by uploading a zip file.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async installTheme(options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<Theme>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.installTheme(options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['ThemeV1alpha1ConsoleApi.installTheme']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Install a theme from uri.
         * @param {InstallFromUriRequest} installFromUriRequest 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async installThemeFromUri(installFromUriRequest: InstallFromUriRequest, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<Theme>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.installThemeFromUri(installFromUriRequest, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['ThemeV1alpha1ConsoleApi.installThemeFromUri']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Invalidate theme template cache.
         * @param {string} name 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async invalidateCache(name: string, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<void>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.invalidateCache(name, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['ThemeV1alpha1ConsoleApi.invalidateCache']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * List themes.
         * @param {number} [page] Page number. Default is 0.
         * @param {number} [size] Size number. Default is 0.
         * @param {Array<string>} [labelSelector] Label selector. e.g.: hidden!&#x3D;true
         * @param {Array<string>} [fieldSelector] Field selector. e.g.: metadata.name&#x3D;&#x3D;halo
         * @param {boolean} [uninstalled] Whether to list uninstalled themes.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async listThemes(page?: number, size?: number, labelSelector?: Array<string>, fieldSelector?: Array<string>, uninstalled?: boolean, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<ThemeList>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.listThemes(page, size, labelSelector, fieldSelector, uninstalled, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['ThemeV1alpha1ConsoleApi.listThemes']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Reload theme setting.
         * @param {string} name 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async reload(name: string, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<Theme>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.reload(name, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['ThemeV1alpha1ConsoleApi.reload']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Reset the configMap of theme setting.
         * @param {string} name 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async resetThemeConfig(name: string, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<ConfigMap>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.resetThemeConfig(name, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['ThemeV1alpha1ConsoleApi.resetThemeConfig']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Update the configMap of theme setting. It is deprecated.
         * @param {string} name 
         * @param {ConfigMap} configMap 
         * @param {*} [options] Override http request option.
         * @deprecated
         * @throws {RequiredError}
         */
        async updateThemeConfig(name: string, configMap: ConfigMap, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<ConfigMap>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.updateThemeConfig(name, configMap, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['ThemeV1alpha1ConsoleApi.updateThemeConfig']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Update the configMap of theme setting.
         * @param {string} name 
         * @param {object} body 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async updateThemeJsonConfig(name: string, body: object, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<void>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.updateThemeJsonConfig(name, body, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['ThemeV1alpha1ConsoleApi.updateThemeJsonConfig']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Upgrade theme
         * @param {string} name 
         * @param {File} file 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async upgradeTheme(name: string, file: File, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<void>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.upgradeTheme(name, file, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['ThemeV1alpha1ConsoleApi.upgradeTheme']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Upgrade a theme from uri.
         * @param {string} name 
         * @param {UpgradeFromUriRequest} upgradeFromUriRequest 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async upgradeThemeFromUri(name: string, upgradeFromUriRequest: UpgradeFromUriRequest, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<Theme>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.upgradeThemeFromUri(name, upgradeFromUriRequest, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['ThemeV1alpha1ConsoleApi.upgradeThemeFromUri']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
    }
};

/**
 * ThemeV1alpha1ConsoleApi - factory interface
 * @export
 */
export const ThemeV1alpha1ConsoleApiFactory = function (configuration?: Configuration, basePath?: string, axios?: AxiosInstance) {
    const localVarFp = ThemeV1alpha1ConsoleApiFp(configuration)
    return {
        /**
         * Activate a theme by name.
         * @param {ThemeV1alpha1ConsoleApiActivateThemeRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        activateTheme(requestParameters: ThemeV1alpha1ConsoleApiActivateThemeRequest, options?: RawAxiosRequestConfig): AxiosPromise<Theme> {
            return localVarFp.activateTheme(requestParameters.name, options).then((request) => request(axios, basePath));
        },
        /**
         * Fetch the activated theme.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        fetchActivatedTheme(options?: RawAxiosRequestConfig): AxiosPromise<Theme> {
            return localVarFp.fetchActivatedTheme(options).then((request) => request(axios, basePath));
        },
        /**
         * Fetch configMap of theme by configured configMapName. It is deprecated.
         * @param {ThemeV1alpha1ConsoleApiFetchThemeConfigRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @deprecated
         * @throws {RequiredError}
         */
        fetchThemeConfig(requestParameters: ThemeV1alpha1ConsoleApiFetchThemeConfigRequest, options?: RawAxiosRequestConfig): AxiosPromise<ConfigMap> {
            return localVarFp.fetchThemeConfig(requestParameters.name, options).then((request) => request(axios, basePath));
        },
        /**
         * Fetch converted json config of theme by configured configMapName.
         * @param {ThemeV1alpha1ConsoleApiFetchThemeJsonConfigRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        fetchThemeJsonConfig(requestParameters: ThemeV1alpha1ConsoleApiFetchThemeJsonConfigRequest, options?: RawAxiosRequestConfig): AxiosPromise<object> {
            return localVarFp.fetchThemeJsonConfig(requestParameters.name, options).then((request) => request(axios, basePath));
        },
        /**
         * Fetch setting of theme.
         * @param {ThemeV1alpha1ConsoleApiFetchThemeSettingRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        fetchThemeSetting(requestParameters: ThemeV1alpha1ConsoleApiFetchThemeSettingRequest, options?: RawAxiosRequestConfig): AxiosPromise<Setting> {
            return localVarFp.fetchThemeSetting(requestParameters.name, options).then((request) => request(axios, basePath));
        },
        /**
         * Install a theme by uploading a zip file.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        installTheme(options?: RawAxiosRequestConfig): AxiosPromise<Theme> {
            return localVarFp.installTheme(options).then((request) => request(axios, basePath));
        },
        /**
         * Install a theme from uri.
         * @param {ThemeV1alpha1ConsoleApiInstallThemeFromUriRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        installThemeFromUri(requestParameters: ThemeV1alpha1ConsoleApiInstallThemeFromUriRequest, options?: RawAxiosRequestConfig): AxiosPromise<Theme> {
            return localVarFp.installThemeFromUri(requestParameters.installFromUriRequest, options).then((request) => request(axios, basePath));
        },
        /**
         * Invalidate theme template cache.
         * @param {ThemeV1alpha1ConsoleApiInvalidateCacheRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        invalidateCache(requestParameters: ThemeV1alpha1ConsoleApiInvalidateCacheRequest, options?: RawAxiosRequestConfig): AxiosPromise<void> {
            return localVarFp.invalidateCache(requestParameters.name, options).then((request) => request(axios, basePath));
        },
        /**
         * List themes.
         * @param {ThemeV1alpha1ConsoleApiListThemesRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        listThemes(requestParameters: ThemeV1alpha1ConsoleApiListThemesRequest = {}, options?: RawAxiosRequestConfig): AxiosPromise<ThemeList> {
            return localVarFp.listThemes(requestParameters.page, requestParameters.size, requestParameters.labelSelector, requestParameters.fieldSelector, requestParameters.uninstalled, options).then((request) => request(axios, basePath));
        },
        /**
         * Reload theme setting.
         * @param {ThemeV1alpha1ConsoleApiReloadRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        reload(requestParameters: ThemeV1alpha1ConsoleApiReloadRequest, options?: RawAxiosRequestConfig): AxiosPromise<Theme> {
            return localVarFp.reload(requestParameters.name, options).then((request) => request(axios, basePath));
        },
        /**
         * Reset the configMap of theme setting.
         * @param {ThemeV1alpha1ConsoleApiResetThemeConfigRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        resetThemeConfig(requestParameters: ThemeV1alpha1ConsoleApiResetThemeConfigRequest, options?: RawAxiosRequestConfig): AxiosPromise<ConfigMap> {
            return localVarFp.resetThemeConfig(requestParameters.name, options).then((request) => request(axios, basePath));
        },
        /**
         * Update the configMap of theme setting. It is deprecated.
         * @param {ThemeV1alpha1ConsoleApiUpdateThemeConfigRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @deprecated
         * @throws {RequiredError}
         */
        updateThemeConfig(requestParameters: ThemeV1alpha1ConsoleApiUpdateThemeConfigRequest, options?: RawAxiosRequestConfig): AxiosPromise<ConfigMap> {
            return localVarFp.updateThemeConfig(requestParameters.name, requestParameters.configMap, options).then((request) => request(axios, basePath));
        },
        /**
         * Update the configMap of theme setting.
         * @param {ThemeV1alpha1ConsoleApiUpdateThemeJsonConfigRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        updateThemeJsonConfig(requestParameters: ThemeV1alpha1ConsoleApiUpdateThemeJsonConfigRequest, options?: RawAxiosRequestConfig): AxiosPromise<void> {
            return localVarFp.updateThemeJsonConfig(requestParameters.name, requestParameters.body, options).then((request) => request(axios, basePath));
        },
        /**
         * Upgrade theme
         * @param {ThemeV1alpha1ConsoleApiUpgradeThemeRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        upgradeTheme(requestParameters: ThemeV1alpha1ConsoleApiUpgradeThemeRequest, options?: RawAxiosRequestConfig): AxiosPromise<void> {
            return localVarFp.upgradeTheme(requestParameters.name, requestParameters.file, options).then((request) => request(axios, basePath));
        },
        /**
         * Upgrade a theme from uri.
         * @param {ThemeV1alpha1ConsoleApiUpgradeThemeFromUriRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        upgradeThemeFromUri(requestParameters: ThemeV1alpha1ConsoleApiUpgradeThemeFromUriRequest, options?: RawAxiosRequestConfig): AxiosPromise<Theme> {
            return localVarFp.upgradeThemeFromUri(requestParameters.name, requestParameters.upgradeFromUriRequest, options).then((request) => request(axios, basePath));
        },
    };
};

/**
 * Request parameters for activateTheme operation in ThemeV1alpha1ConsoleApi.
 * @export
 * @interface ThemeV1alpha1ConsoleApiActivateThemeRequest
 */
export interface ThemeV1alpha1ConsoleApiActivateThemeRequest {
    /**
     * 
     * @type {string}
     * @memberof ThemeV1alpha1ConsoleApiActivateTheme
     */
    readonly name: string
}

/**
 * Request parameters for fetchThemeConfig operation in ThemeV1alpha1ConsoleApi.
 * @export
 * @interface ThemeV1alpha1ConsoleApiFetchThemeConfigRequest
 */
export interface ThemeV1alpha1ConsoleApiFetchThemeConfigRequest {
    /**
     * 
     * @type {string}
     * @memberof ThemeV1alpha1ConsoleApiFetchThemeConfig
     */
    readonly name: string
}

/**
 * Request parameters for fetchThemeJsonConfig operation in ThemeV1alpha1ConsoleApi.
 * @export
 * @interface ThemeV1alpha1ConsoleApiFetchThemeJsonConfigRequest
 */
export interface ThemeV1alpha1ConsoleApiFetchThemeJsonConfigRequest {
    /**
     * 
     * @type {string}
     * @memberof ThemeV1alpha1ConsoleApiFetchThemeJsonConfig
     */
    readonly name: string
}

/**
 * Request parameters for fetchThemeSetting operation in ThemeV1alpha1ConsoleApi.
 * @export
 * @interface ThemeV1alpha1ConsoleApiFetchThemeSettingRequest
 */
export interface ThemeV1alpha1ConsoleApiFetchThemeSettingRequest {
    /**
     * 
     * @type {string}
     * @memberof ThemeV1alpha1ConsoleApiFetchThemeSetting
     */
    readonly name: string
}

/**
 * Request parameters for installThemeFromUri operation in ThemeV1alpha1ConsoleApi.
 * @export
 * @interface ThemeV1alpha1ConsoleApiInstallThemeFromUriRequest
 */
export interface ThemeV1alpha1ConsoleApiInstallThemeFromUriRequest {
    /**
     * 
     * @type {InstallFromUriRequest}
     * @memberof ThemeV1alpha1ConsoleApiInstallThemeFromUri
     */
    readonly installFromUriRequest: InstallFromUriRequest
}

/**
 * Request parameters for invalidateCache operation in ThemeV1alpha1ConsoleApi.
 * @export
 * @interface ThemeV1alpha1ConsoleApiInvalidateCacheRequest
 */
export interface ThemeV1alpha1ConsoleApiInvalidateCacheRequest {
    /**
     * 
     * @type {string}
     * @memberof ThemeV1alpha1ConsoleApiInvalidateCache
     */
    readonly name: string
}

/**
 * Request parameters for listThemes operation in ThemeV1alpha1ConsoleApi.
 * @export
 * @interface ThemeV1alpha1ConsoleApiListThemesRequest
 */
export interface ThemeV1alpha1ConsoleApiListThemesRequest {
    /**
     * Page number. Default is 0.
     * @type {number}
     * @memberof ThemeV1alpha1ConsoleApiListThemes
     */
    readonly page?: number

    /**
     * Size number. Default is 0.
     * @type {number}
     * @memberof ThemeV1alpha1ConsoleApiListThemes
     */
    readonly size?: number

    /**
     * Label selector. e.g.: hidden!&#x3D;true
     * @type {Array<string>}
     * @memberof ThemeV1alpha1ConsoleApiListThemes
     */
    readonly labelSelector?: Array<string>

    /**
     * Field selector. e.g.: metadata.name&#x3D;&#x3D;halo
     * @type {Array<string>}
     * @memberof ThemeV1alpha1ConsoleApiListThemes
     */
    readonly fieldSelector?: Array<string>

    /**
     * Whether to list uninstalled themes.
     * @type {boolean}
     * @memberof ThemeV1alpha1ConsoleApiListThemes
     */
    readonly uninstalled?: boolean
}

/**
 * Request parameters for reload operation in ThemeV1alpha1ConsoleApi.
 * @export
 * @interface ThemeV1alpha1ConsoleApiReloadRequest
 */
export interface ThemeV1alpha1ConsoleApiReloadRequest {
    /**
     * 
     * @type {string}
     * @memberof ThemeV1alpha1ConsoleApiReload
     */
    readonly name: string
}

/**
 * Request parameters for resetThemeConfig operation in ThemeV1alpha1ConsoleApi.
 * @export
 * @interface ThemeV1alpha1ConsoleApiResetThemeConfigRequest
 */
export interface ThemeV1alpha1ConsoleApiResetThemeConfigRequest {
    /**
     * 
     * @type {string}
     * @memberof ThemeV1alpha1ConsoleApiResetThemeConfig
     */
    readonly name: string
}

/**
 * Request parameters for updateThemeConfig operation in ThemeV1alpha1ConsoleApi.
 * @export
 * @interface ThemeV1alpha1ConsoleApiUpdateThemeConfigRequest
 */
export interface ThemeV1alpha1ConsoleApiUpdateThemeConfigRequest {
    /**
     * 
     * @type {string}
     * @memberof ThemeV1alpha1ConsoleApiUpdateThemeConfig
     */
    readonly name: string

    /**
     * 
     * @type {ConfigMap}
     * @memberof ThemeV1alpha1ConsoleApiUpdateThemeConfig
     */
    readonly configMap: ConfigMap
}

/**
 * Request parameters for updateThemeJsonConfig operation in ThemeV1alpha1ConsoleApi.
 * @export
 * @interface ThemeV1alpha1ConsoleApiUpdateThemeJsonConfigRequest
 */
export interface ThemeV1alpha1ConsoleApiUpdateThemeJsonConfigRequest {
    /**
     * 
     * @type {string}
     * @memberof ThemeV1alpha1ConsoleApiUpdateThemeJsonConfig
     */
    readonly name: string

    /**
     * 
     * @type {object}
     * @memberof ThemeV1alpha1ConsoleApiUpdateThemeJsonConfig
     */
    readonly body: object
}

/**
 * Request parameters for upgradeTheme operation in ThemeV1alpha1ConsoleApi.
 * @export
 * @interface ThemeV1alpha1ConsoleApiUpgradeThemeRequest
 */
export interface ThemeV1alpha1ConsoleApiUpgradeThemeRequest {
    /**
     * 
     * @type {string}
     * @memberof ThemeV1alpha1ConsoleApiUpgradeTheme
     */
    readonly name: string

    /**
     * 
     * @type {File}
     * @memberof ThemeV1alpha1ConsoleApiUpgradeTheme
     */
    readonly file: File
}

/**
 * Request parameters for upgradeThemeFromUri operation in ThemeV1alpha1ConsoleApi.
 * @export
 * @interface ThemeV1alpha1ConsoleApiUpgradeThemeFromUriRequest
 */
export interface ThemeV1alpha1ConsoleApiUpgradeThemeFromUriRequest {
    /**
     * 
     * @type {string}
     * @memberof ThemeV1alpha1ConsoleApiUpgradeThemeFromUri
     */
    readonly name: string

    /**
     * 
     * @type {UpgradeFromUriRequest}
     * @memberof ThemeV1alpha1ConsoleApiUpgradeThemeFromUri
     */
    readonly upgradeFromUriRequest: UpgradeFromUriRequest
}

/**
 * ThemeV1alpha1ConsoleApi - object-oriented interface
 * @export
 * @class ThemeV1alpha1ConsoleApi
 * @extends {BaseAPI}
 */
export class ThemeV1alpha1ConsoleApi extends BaseAPI {
    /**
     * Activate a theme by name.
     * @param {ThemeV1alpha1ConsoleApiActivateThemeRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof ThemeV1alpha1ConsoleApi
     */
    public activateTheme(requestParameters: ThemeV1alpha1ConsoleApiActivateThemeRequest, options?: RawAxiosRequestConfig) {
        return ThemeV1alpha1ConsoleApiFp(this.configuration).activateTheme(requestParameters.name, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Fetch the activated theme.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof ThemeV1alpha1ConsoleApi
     */
    public fetchActivatedTheme(options?: RawAxiosRequestConfig) {
        return ThemeV1alpha1ConsoleApiFp(this.configuration).fetchActivatedTheme(options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Fetch configMap of theme by configured configMapName. It is deprecated.
     * @param {ThemeV1alpha1ConsoleApiFetchThemeConfigRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @deprecated
     * @throws {RequiredError}
     * @memberof ThemeV1alpha1ConsoleApi
     */
    public fetchThemeConfig(requestParameters: ThemeV1alpha1ConsoleApiFetchThemeConfigRequest, options?: RawAxiosRequestConfig) {
        return ThemeV1alpha1ConsoleApiFp(this.configuration).fetchThemeConfig(requestParameters.name, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Fetch converted json config of theme by configured configMapName.
     * @param {ThemeV1alpha1ConsoleApiFetchThemeJsonConfigRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof ThemeV1alpha1ConsoleApi
     */
    public fetchThemeJsonConfig(requestParameters: ThemeV1alpha1ConsoleApiFetchThemeJsonConfigRequest, options?: RawAxiosRequestConfig) {
        return ThemeV1alpha1ConsoleApiFp(this.configuration).fetchThemeJsonConfig(requestParameters.name, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Fetch setting of theme.
     * @param {ThemeV1alpha1ConsoleApiFetchThemeSettingRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof ThemeV1alpha1ConsoleApi
     */
    public fetchThemeSetting(requestParameters: ThemeV1alpha1ConsoleApiFetchThemeSettingRequest, options?: RawAxiosRequestConfig) {
        return ThemeV1alpha1ConsoleApiFp(this.configuration).fetchThemeSetting(requestParameters.name, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Install a theme by uploading a zip file.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof ThemeV1alpha1ConsoleApi
     */
    public installTheme(options?: RawAxiosRequestConfig) {
        return ThemeV1alpha1ConsoleApiFp(this.configuration).installTheme(options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Install a theme from uri.
     * @param {ThemeV1alpha1ConsoleApiInstallThemeFromUriRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof ThemeV1alpha1ConsoleApi
     */
    public installThemeFromUri(requestParameters: ThemeV1alpha1ConsoleApiInstallThemeFromUriRequest, options?: RawAxiosRequestConfig) {
        return ThemeV1alpha1ConsoleApiFp(this.configuration).installThemeFromUri(requestParameters.installFromUriRequest, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Invalidate theme template cache.
     * @param {ThemeV1alpha1ConsoleApiInvalidateCacheRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof ThemeV1alpha1ConsoleApi
     */
    public invalidateCache(requestParameters: ThemeV1alpha1ConsoleApiInvalidateCacheRequest, options?: RawAxiosRequestConfig) {
        return ThemeV1alpha1ConsoleApiFp(this.configuration).invalidateCache(requestParameters.name, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * List themes.
     * @param {ThemeV1alpha1ConsoleApiListThemesRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof ThemeV1alpha1ConsoleApi
     */
    public listThemes(requestParameters: ThemeV1alpha1ConsoleApiListThemesRequest = {}, options?: RawAxiosRequestConfig) {
        return ThemeV1alpha1ConsoleApiFp(this.configuration).listThemes(requestParameters.page, requestParameters.size, requestParameters.labelSelector, requestParameters.fieldSelector, requestParameters.uninstalled, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Reload theme setting.
     * @param {ThemeV1alpha1ConsoleApiReloadRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof ThemeV1alpha1ConsoleApi
     */
    public reload(requestParameters: ThemeV1alpha1ConsoleApiReloadRequest, options?: RawAxiosRequestConfig) {
        return ThemeV1alpha1ConsoleApiFp(this.configuration).reload(requestParameters.name, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Reset the configMap of theme setting.
     * @param {ThemeV1alpha1ConsoleApiResetThemeConfigRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof ThemeV1alpha1ConsoleApi
     */
    public resetThemeConfig(requestParameters: ThemeV1alpha1ConsoleApiResetThemeConfigRequest, options?: RawAxiosRequestConfig) {
        return ThemeV1alpha1ConsoleApiFp(this.configuration).resetThemeConfig(requestParameters.name, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Update the configMap of theme setting. It is deprecated.
     * @param {ThemeV1alpha1ConsoleApiUpdateThemeConfigRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @deprecated
     * @throws {RequiredError}
     * @memberof ThemeV1alpha1ConsoleApi
     */
    public updateThemeConfig(requestParameters: ThemeV1alpha1ConsoleApiUpdateThemeConfigRequest, options?: RawAxiosRequestConfig) {
        return ThemeV1alpha1ConsoleApiFp(this.configuration).updateThemeConfig(requestParameters.name, requestParameters.configMap, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Update the configMap of theme setting.
     * @param {ThemeV1alpha1ConsoleApiUpdateThemeJsonConfigRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof ThemeV1alpha1ConsoleApi
     */
    public updateThemeJsonConfig(requestParameters: ThemeV1alpha1ConsoleApiUpdateThemeJsonConfigRequest, options?: RawAxiosRequestConfig) {
        return ThemeV1alpha1ConsoleApiFp(this.configuration).updateThemeJsonConfig(requestParameters.name, requestParameters.body, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Upgrade theme
     * @param {ThemeV1alpha1ConsoleApiUpgradeThemeRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof ThemeV1alpha1ConsoleApi
     */
    public upgradeTheme(requestParameters: ThemeV1alpha1ConsoleApiUpgradeThemeRequest, options?: RawAxiosRequestConfig) {
        return ThemeV1alpha1ConsoleApiFp(this.configuration).upgradeTheme(requestParameters.name, requestParameters.file, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Upgrade a theme from uri.
     * @param {ThemeV1alpha1ConsoleApiUpgradeThemeFromUriRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof ThemeV1alpha1ConsoleApi
     */
    public upgradeThemeFromUri(requestParameters: ThemeV1alpha1ConsoleApiUpgradeThemeFromUriRequest, options?: RawAxiosRequestConfig) {
        return ThemeV1alpha1ConsoleApiFp(this.configuration).upgradeThemeFromUri(requestParameters.name, requestParameters.upgradeFromUriRequest, options).then((request) => request(this.axios, this.basePath));
    }
}

