/* tslint:disable */
/* eslint-disable */
/**
 * Halo
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: 2.20.10-SNAPSHOT
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


import type { Configuration } from '../configuration';
import type { AxiosPromise, AxiosInstance, RawAxiosRequestConfig } from 'axios';
import globalAxios from 'axios';
// Some imports not used depending on template conditions
// @ts-ignore
import { DUMMY_BASE_URL, assertParamExists, setApiKeyToObject, setBasicAuthToObject, setBearerAuthToObject, setOAuthToObject, setSearchParams, serializeDataIfNeeded, toPathString, createRequestFunction } from '../common';
// @ts-ignore
import { BASE_PATH, COLLECTION_FORMATS, RequestArgs, BaseAPI, RequiredError, operationServerMap } from '../base';
// @ts-ignore
import { JsonPatchInner } from '../models';
// @ts-ignore
import { Thumbnail } from '../models';
// @ts-ignore
import { ThumbnailList } from '../models';
/**
 * ThumbnailV1alpha1Api - axios parameter creator
 * @export
 */
export const ThumbnailV1alpha1ApiAxiosParamCreator = function (configuration?: Configuration) {
    return {
        /**
         * Create Thumbnail
         * @param {Thumbnail} [thumbnail] Fresh thumbnail
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        createThumbnail: async (thumbnail?: Thumbnail, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            const localVarPath = `/apis/storage.halo.run/v1alpha1/thumbnails`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'POST', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            localVarHeaderParameter['Content-Type'] = 'application/json';

            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};
            localVarRequestOptions.data = serializeDataIfNeeded(thumbnail, localVarRequestOptions, configuration)

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Delete Thumbnail
         * @param {string} name Name of thumbnail
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        deleteThumbnail: async (name: string, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'name' is not null or undefined
            assertParamExists('deleteThumbnail', 'name', name)
            const localVarPath = `/apis/storage.halo.run/v1alpha1/thumbnails/{name}`
                .replace(`{${"name"}}`, encodeURIComponent(String(name)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'DELETE', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Get Thumbnail
         * @param {string} name Name of thumbnail
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        getThumbnail: async (name: string, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'name' is not null or undefined
            assertParamExists('getThumbnail', 'name', name)
            const localVarPath = `/apis/storage.halo.run/v1alpha1/thumbnails/{name}`
                .replace(`{${"name"}}`, encodeURIComponent(String(name)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'GET', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * List Thumbnail
         * @param {number} [page] Page number. Default is 0.
         * @param {number} [size] Size number. Default is 0.
         * @param {Array<string>} [labelSelector] Label selector. e.g.: hidden!&#x3D;true
         * @param {Array<string>} [fieldSelector] Field selector. e.g.: metadata.name&#x3D;&#x3D;halo
         * @param {Array<string>} [sort] Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        listThumbnail: async (page?: number, size?: number, labelSelector?: Array<string>, fieldSelector?: Array<string>, sort?: Array<string>, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            const localVarPath = `/apis/storage.halo.run/v1alpha1/thumbnails`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'GET', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)

            if (page !== undefined) {
                localVarQueryParameter['page'] = page;
            }

            if (size !== undefined) {
                localVarQueryParameter['size'] = size;
            }

            if (labelSelector) {
                localVarQueryParameter['labelSelector'] = labelSelector;
            }

            if (fieldSelector) {
                localVarQueryParameter['fieldSelector'] = fieldSelector;
            }

            if (sort) {
                localVarQueryParameter['sort'] = sort;
            }


    
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Patch Thumbnail
         * @param {string} name Name of thumbnail
         * @param {Array<JsonPatchInner>} [jsonPatchInner] 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        patchThumbnail: async (name: string, jsonPatchInner?: Array<JsonPatchInner>, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'name' is not null or undefined
            assertParamExists('patchThumbnail', 'name', name)
            const localVarPath = `/apis/storage.halo.run/v1alpha1/thumbnails/{name}`
                .replace(`{${"name"}}`, encodeURIComponent(String(name)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'PATCH', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            localVarHeaderParameter['Content-Type'] = 'application/json-patch+json';

            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};
            localVarRequestOptions.data = serializeDataIfNeeded(jsonPatchInner, localVarRequestOptions, configuration)

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Update Thumbnail
         * @param {string} name Name of thumbnail
         * @param {Thumbnail} [thumbnail] Updated thumbnail
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        updateThumbnail: async (name: string, thumbnail?: Thumbnail, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'name' is not null or undefined
            assertParamExists('updateThumbnail', 'name', name)
            const localVarPath = `/apis/storage.halo.run/v1alpha1/thumbnails/{name}`
                .replace(`{${"name"}}`, encodeURIComponent(String(name)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'PUT', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            localVarHeaderParameter['Content-Type'] = 'application/json';

            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};
            localVarRequestOptions.data = serializeDataIfNeeded(thumbnail, localVarRequestOptions, configuration)

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
    }
};

/**
 * ThumbnailV1alpha1Api - functional programming interface
 * @export
 */
export const ThumbnailV1alpha1ApiFp = function(configuration?: Configuration) {
    const localVarAxiosParamCreator = ThumbnailV1alpha1ApiAxiosParamCreator(configuration)
    return {
        /**
         * Create Thumbnail
         * @param {Thumbnail} [thumbnail] Fresh thumbnail
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async createThumbnail(thumbnail?: Thumbnail, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<Thumbnail>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.createThumbnail(thumbnail, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['ThumbnailV1alpha1Api.createThumbnail']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Delete Thumbnail
         * @param {string} name Name of thumbnail
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async deleteThumbnail(name: string, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<void>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.deleteThumbnail(name, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['ThumbnailV1alpha1Api.deleteThumbnail']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Get Thumbnail
         * @param {string} name Name of thumbnail
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async getThumbnail(name: string, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<Thumbnail>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.getThumbnail(name, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['ThumbnailV1alpha1Api.getThumbnail']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * List Thumbnail
         * @param {number} [page] Page number. Default is 0.
         * @param {number} [size] Size number. Default is 0.
         * @param {Array<string>} [labelSelector] Label selector. e.g.: hidden!&#x3D;true
         * @param {Array<string>} [fieldSelector] Field selector. e.g.: metadata.name&#x3D;&#x3D;halo
         * @param {Array<string>} [sort] Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async listThumbnail(page?: number, size?: number, labelSelector?: Array<string>, fieldSelector?: Array<string>, sort?: Array<string>, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<ThumbnailList>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.listThumbnail(page, size, labelSelector, fieldSelector, sort, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['ThumbnailV1alpha1Api.listThumbnail']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Patch Thumbnail
         * @param {string} name Name of thumbnail
         * @param {Array<JsonPatchInner>} [jsonPatchInner] 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async patchThumbnail(name: string, jsonPatchInner?: Array<JsonPatchInner>, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<Thumbnail>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.patchThumbnail(name, jsonPatchInner, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['ThumbnailV1alpha1Api.patchThumbnail']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Update Thumbnail
         * @param {string} name Name of thumbnail
         * @param {Thumbnail} [thumbnail] Updated thumbnail
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async updateThumbnail(name: string, thumbnail?: Thumbnail, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<Thumbnail>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.updateThumbnail(name, thumbnail, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['ThumbnailV1alpha1Api.updateThumbnail']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
    }
};

/**
 * ThumbnailV1alpha1Api - factory interface
 * @export
 */
export const ThumbnailV1alpha1ApiFactory = function (configuration?: Configuration, basePath?: string, axios?: AxiosInstance) {
    const localVarFp = ThumbnailV1alpha1ApiFp(configuration)
    return {
        /**
         * Create Thumbnail
         * @param {ThumbnailV1alpha1ApiCreateThumbnailRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        createThumbnail(requestParameters: ThumbnailV1alpha1ApiCreateThumbnailRequest = {}, options?: RawAxiosRequestConfig): AxiosPromise<Thumbnail> {
            return localVarFp.createThumbnail(requestParameters.thumbnail, options).then((request) => request(axios, basePath));
        },
        /**
         * Delete Thumbnail
         * @param {ThumbnailV1alpha1ApiDeleteThumbnailRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        deleteThumbnail(requestParameters: ThumbnailV1alpha1ApiDeleteThumbnailRequest, options?: RawAxiosRequestConfig): AxiosPromise<void> {
            return localVarFp.deleteThumbnail(requestParameters.name, options).then((request) => request(axios, basePath));
        },
        /**
         * Get Thumbnail
         * @param {ThumbnailV1alpha1ApiGetThumbnailRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        getThumbnail(requestParameters: ThumbnailV1alpha1ApiGetThumbnailRequest, options?: RawAxiosRequestConfig): AxiosPromise<Thumbnail> {
            return localVarFp.getThumbnail(requestParameters.name, options).then((request) => request(axios, basePath));
        },
        /**
         * List Thumbnail
         * @param {ThumbnailV1alpha1ApiListThumbnailRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        listThumbnail(requestParameters: ThumbnailV1alpha1ApiListThumbnailRequest = {}, options?: RawAxiosRequestConfig): AxiosPromise<ThumbnailList> {
            return localVarFp.listThumbnail(requestParameters.page, requestParameters.size, requestParameters.labelSelector, requestParameters.fieldSelector, requestParameters.sort, options).then((request) => request(axios, basePath));
        },
        /**
         * Patch Thumbnail
         * @param {ThumbnailV1alpha1ApiPatchThumbnailRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        patchThumbnail(requestParameters: ThumbnailV1alpha1ApiPatchThumbnailRequest, options?: RawAxiosRequestConfig): AxiosPromise<Thumbnail> {
            return localVarFp.patchThumbnail(requestParameters.name, requestParameters.jsonPatchInner, options).then((request) => request(axios, basePath));
        },
        /**
         * Update Thumbnail
         * @param {ThumbnailV1alpha1ApiUpdateThumbnailRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        updateThumbnail(requestParameters: ThumbnailV1alpha1ApiUpdateThumbnailRequest, options?: RawAxiosRequestConfig): AxiosPromise<Thumbnail> {
            return localVarFp.updateThumbnail(requestParameters.name, requestParameters.thumbnail, options).then((request) => request(axios, basePath));
        },
    };
};

/**
 * Request parameters for createThumbnail operation in ThumbnailV1alpha1Api.
 * @export
 * @interface ThumbnailV1alpha1ApiCreateThumbnailRequest
 */
export interface ThumbnailV1alpha1ApiCreateThumbnailRequest {
    /**
     * Fresh thumbnail
     * @type {Thumbnail}
     * @memberof ThumbnailV1alpha1ApiCreateThumbnail
     */
    readonly thumbnail?: Thumbnail
}

/**
 * Request parameters for deleteThumbnail operation in ThumbnailV1alpha1Api.
 * @export
 * @interface ThumbnailV1alpha1ApiDeleteThumbnailRequest
 */
export interface ThumbnailV1alpha1ApiDeleteThumbnailRequest {
    /**
     * Name of thumbnail
     * @type {string}
     * @memberof ThumbnailV1alpha1ApiDeleteThumbnail
     */
    readonly name: string
}

/**
 * Request parameters for getThumbnail operation in ThumbnailV1alpha1Api.
 * @export
 * @interface ThumbnailV1alpha1ApiGetThumbnailRequest
 */
export interface ThumbnailV1alpha1ApiGetThumbnailRequest {
    /**
     * Name of thumbnail
     * @type {string}
     * @memberof ThumbnailV1alpha1ApiGetThumbnail
     */
    readonly name: string
}

/**
 * Request parameters for listThumbnail operation in ThumbnailV1alpha1Api.
 * @export
 * @interface ThumbnailV1alpha1ApiListThumbnailRequest
 */
export interface ThumbnailV1alpha1ApiListThumbnailRequest {
    /**
     * Page number. Default is 0.
     * @type {number}
     * @memberof ThumbnailV1alpha1ApiListThumbnail
     */
    readonly page?: number

    /**
     * Size number. Default is 0.
     * @type {number}
     * @memberof ThumbnailV1alpha1ApiListThumbnail
     */
    readonly size?: number

    /**
     * Label selector. e.g.: hidden!&#x3D;true
     * @type {Array<string>}
     * @memberof ThumbnailV1alpha1ApiListThumbnail
     */
    readonly labelSelector?: Array<string>

    /**
     * Field selector. e.g.: metadata.name&#x3D;&#x3D;halo
     * @type {Array<string>}
     * @memberof ThumbnailV1alpha1ApiListThumbnail
     */
    readonly fieldSelector?: Array<string>

    /**
     * Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.
     * @type {Array<string>}
     * @memberof ThumbnailV1alpha1ApiListThumbnail
     */
    readonly sort?: Array<string>
}

/**
 * Request parameters for patchThumbnail operation in ThumbnailV1alpha1Api.
 * @export
 * @interface ThumbnailV1alpha1ApiPatchThumbnailRequest
 */
export interface ThumbnailV1alpha1ApiPatchThumbnailRequest {
    /**
     * Name of thumbnail
     * @type {string}
     * @memberof ThumbnailV1alpha1ApiPatchThumbnail
     */
    readonly name: string

    /**
     * 
     * @type {Array<JsonPatchInner>}
     * @memberof ThumbnailV1alpha1ApiPatchThumbnail
     */
    readonly jsonPatchInner?: Array<JsonPatchInner>
}

/**
 * Request parameters for updateThumbnail operation in ThumbnailV1alpha1Api.
 * @export
 * @interface ThumbnailV1alpha1ApiUpdateThumbnailRequest
 */
export interface ThumbnailV1alpha1ApiUpdateThumbnailRequest {
    /**
     * Name of thumbnail
     * @type {string}
     * @memberof ThumbnailV1alpha1ApiUpdateThumbnail
     */
    readonly name: string

    /**
     * Updated thumbnail
     * @type {Thumbnail}
     * @memberof ThumbnailV1alpha1ApiUpdateThumbnail
     */
    readonly thumbnail?: Thumbnail
}

/**
 * ThumbnailV1alpha1Api - object-oriented interface
 * @export
 * @class ThumbnailV1alpha1Api
 * @extends {BaseAPI}
 */
export class ThumbnailV1alpha1Api extends BaseAPI {
    /**
     * Create Thumbnail
     * @param {ThumbnailV1alpha1ApiCreateThumbnailRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof ThumbnailV1alpha1Api
     */
    public createThumbnail(requestParameters: ThumbnailV1alpha1ApiCreateThumbnailRequest = {}, options?: RawAxiosRequestConfig) {
        return ThumbnailV1alpha1ApiFp(this.configuration).createThumbnail(requestParameters.thumbnail, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Delete Thumbnail
     * @param {ThumbnailV1alpha1ApiDeleteThumbnailRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof ThumbnailV1alpha1Api
     */
    public deleteThumbnail(requestParameters: ThumbnailV1alpha1ApiDeleteThumbnailRequest, options?: RawAxiosRequestConfig) {
        return ThumbnailV1alpha1ApiFp(this.configuration).deleteThumbnail(requestParameters.name, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Get Thumbnail
     * @param {ThumbnailV1alpha1ApiGetThumbnailRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof ThumbnailV1alpha1Api
     */
    public getThumbnail(requestParameters: ThumbnailV1alpha1ApiGetThumbnailRequest, options?: RawAxiosRequestConfig) {
        return ThumbnailV1alpha1ApiFp(this.configuration).getThumbnail(requestParameters.name, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * List Thumbnail
     * @param {ThumbnailV1alpha1ApiListThumbnailRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof ThumbnailV1alpha1Api
     */
    public listThumbnail(requestParameters: ThumbnailV1alpha1ApiListThumbnailRequest = {}, options?: RawAxiosRequestConfig) {
        return ThumbnailV1alpha1ApiFp(this.configuration).listThumbnail(requestParameters.page, requestParameters.size, requestParameters.labelSelector, requestParameters.fieldSelector, requestParameters.sort, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Patch Thumbnail
     * @param {ThumbnailV1alpha1ApiPatchThumbnailRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof ThumbnailV1alpha1Api
     */
    public patchThumbnail(requestParameters: ThumbnailV1alpha1ApiPatchThumbnailRequest, options?: RawAxiosRequestConfig) {
        return ThumbnailV1alpha1ApiFp(this.configuration).patchThumbnail(requestParameters.name, requestParameters.jsonPatchInner, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Update Thumbnail
     * @param {ThumbnailV1alpha1ApiUpdateThumbnailRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof ThumbnailV1alpha1Api
     */
    public updateThumbnail(requestParameters: ThumbnailV1alpha1ApiUpdateThumbnailRequest, options?: RawAxiosRequestConfig) {
        return ThumbnailV1alpha1ApiFp(this.configuration).updateThumbnail(requestParameters.name, requestParameters.thumbnail, options).then((request) => request(this.axios, this.basePath));
    }
}

