/* tslint:disable */
/* eslint-disable */
/**
 * Halo
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: 2.20.10-SNAPSHOT
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


import type { Configuration } from '../configuration';
import type { AxiosPromise, AxiosInstance, RawAxiosRequestConfig } from 'axios';
import globalAxios from 'axios';
// Some imports not used depending on template conditions
// @ts-ignore
import { DUMMY_BASE_URL, assertParamExists, setApiKeyToObject, setBasicAuthToObject, setBearerAuthToObject, setOAuthToObject, setSearchParams, serializeDataIfNeeded, toPathString, createRequestFunction } from '../common';
// @ts-ignore
import { BASE_PATH, COLLECTION_FORMATS, RequestArgs, BaseAPI, RequiredError, operationServerMap } from '../base';
// @ts-ignore
import { JsonPatchInner } from '../models';
// @ts-ignore
import { UserConnection } from '../models';
// @ts-ignore
import { UserConnectionList } from '../models';
/**
 * UserConnectionV1alpha1Api - axios parameter creator
 * @export
 */
export const UserConnectionV1alpha1ApiAxiosParamCreator = function (configuration?: Configuration) {
    return {
        /**
         * Create UserConnection
         * @param {UserConnection} [userConnection] Fresh userconnection
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        createUserConnection: async (userConnection?: UserConnection, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            const localVarPath = `/apis/auth.halo.run/v1alpha1/userconnections`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'POST', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            localVarHeaderParameter['Content-Type'] = 'application/json';

            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};
            localVarRequestOptions.data = serializeDataIfNeeded(userConnection, localVarRequestOptions, configuration)

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Delete UserConnection
         * @param {string} name Name of userconnection
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        deleteUserConnection: async (name: string, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'name' is not null or undefined
            assertParamExists('deleteUserConnection', 'name', name)
            const localVarPath = `/apis/auth.halo.run/v1alpha1/userconnections/{name}`
                .replace(`{${"name"}}`, encodeURIComponent(String(name)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'DELETE', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Get UserConnection
         * @param {string} name Name of userconnection
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        getUserConnection: async (name: string, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'name' is not null or undefined
            assertParamExists('getUserConnection', 'name', name)
            const localVarPath = `/apis/auth.halo.run/v1alpha1/userconnections/{name}`
                .replace(`{${"name"}}`, encodeURIComponent(String(name)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'GET', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * List UserConnection
         * @param {number} [page] Page number. Default is 0.
         * @param {number} [size] Size number. Default is 0.
         * @param {Array<string>} [labelSelector] Label selector. e.g.: hidden!&#x3D;true
         * @param {Array<string>} [fieldSelector] Field selector. e.g.: metadata.name&#x3D;&#x3D;halo
         * @param {Array<string>} [sort] Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        listUserConnection: async (page?: number, size?: number, labelSelector?: Array<string>, fieldSelector?: Array<string>, sort?: Array<string>, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            const localVarPath = `/apis/auth.halo.run/v1alpha1/userconnections`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'GET', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)

            if (page !== undefined) {
                localVarQueryParameter['page'] = page;
            }

            if (size !== undefined) {
                localVarQueryParameter['size'] = size;
            }

            if (labelSelector) {
                localVarQueryParameter['labelSelector'] = labelSelector;
            }

            if (fieldSelector) {
                localVarQueryParameter['fieldSelector'] = fieldSelector;
            }

            if (sort) {
                localVarQueryParameter['sort'] = sort;
            }


    
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Patch UserConnection
         * @param {string} name Name of userconnection
         * @param {Array<JsonPatchInner>} [jsonPatchInner] 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        patchUserConnection: async (name: string, jsonPatchInner?: Array<JsonPatchInner>, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'name' is not null or undefined
            assertParamExists('patchUserConnection', 'name', name)
            const localVarPath = `/apis/auth.halo.run/v1alpha1/userconnections/{name}`
                .replace(`{${"name"}}`, encodeURIComponent(String(name)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'PATCH', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            localVarHeaderParameter['Content-Type'] = 'application/json-patch+json';

            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};
            localVarRequestOptions.data = serializeDataIfNeeded(jsonPatchInner, localVarRequestOptions, configuration)

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Update UserConnection
         * @param {string} name Name of userconnection
         * @param {UserConnection} [userConnection] Updated userconnection
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        updateUserConnection: async (name: string, userConnection?: UserConnection, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'name' is not null or undefined
            assertParamExists('updateUserConnection', 'name', name)
            const localVarPath = `/apis/auth.halo.run/v1alpha1/userconnections/{name}`
                .replace(`{${"name"}}`, encodeURIComponent(String(name)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'PUT', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            localVarHeaderParameter['Content-Type'] = 'application/json';

            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};
            localVarRequestOptions.data = serializeDataIfNeeded(userConnection, localVarRequestOptions, configuration)

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
    }
};

/**
 * UserConnectionV1alpha1Api - functional programming interface
 * @export
 */
export const UserConnectionV1alpha1ApiFp = function(configuration?: Configuration) {
    const localVarAxiosParamCreator = UserConnectionV1alpha1ApiAxiosParamCreator(configuration)
    return {
        /**
         * Create UserConnection
         * @param {UserConnection} [userConnection] Fresh userconnection
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async createUserConnection(userConnection?: UserConnection, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<UserConnection>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.createUserConnection(userConnection, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['UserConnectionV1alpha1Api.createUserConnection']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Delete UserConnection
         * @param {string} name Name of userconnection
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async deleteUserConnection(name: string, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<void>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.deleteUserConnection(name, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['UserConnectionV1alpha1Api.deleteUserConnection']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Get UserConnection
         * @param {string} name Name of userconnection
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async getUserConnection(name: string, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<UserConnection>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.getUserConnection(name, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['UserConnectionV1alpha1Api.getUserConnection']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * List UserConnection
         * @param {number} [page] Page number. Default is 0.
         * @param {number} [size] Size number. Default is 0.
         * @param {Array<string>} [labelSelector] Label selector. e.g.: hidden!&#x3D;true
         * @param {Array<string>} [fieldSelector] Field selector. e.g.: metadata.name&#x3D;&#x3D;halo
         * @param {Array<string>} [sort] Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async listUserConnection(page?: number, size?: number, labelSelector?: Array<string>, fieldSelector?: Array<string>, sort?: Array<string>, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<UserConnectionList>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.listUserConnection(page, size, labelSelector, fieldSelector, sort, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['UserConnectionV1alpha1Api.listUserConnection']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Patch UserConnection
         * @param {string} name Name of userconnection
         * @param {Array<JsonPatchInner>} [jsonPatchInner] 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async patchUserConnection(name: string, jsonPatchInner?: Array<JsonPatchInner>, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<UserConnection>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.patchUserConnection(name, jsonPatchInner, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['UserConnectionV1alpha1Api.patchUserConnection']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Update UserConnection
         * @param {string} name Name of userconnection
         * @param {UserConnection} [userConnection] Updated userconnection
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async updateUserConnection(name: string, userConnection?: UserConnection, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<UserConnection>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.updateUserConnection(name, userConnection, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['UserConnectionV1alpha1Api.updateUserConnection']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
    }
};

/**
 * UserConnectionV1alpha1Api - factory interface
 * @export
 */
export const UserConnectionV1alpha1ApiFactory = function (configuration?: Configuration, basePath?: string, axios?: AxiosInstance) {
    const localVarFp = UserConnectionV1alpha1ApiFp(configuration)
    return {
        /**
         * Create UserConnection
         * @param {UserConnectionV1alpha1ApiCreateUserConnectionRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        createUserConnection(requestParameters: UserConnectionV1alpha1ApiCreateUserConnectionRequest = {}, options?: RawAxiosRequestConfig): AxiosPromise<UserConnection> {
            return localVarFp.createUserConnection(requestParameters.userConnection, options).then((request) => request(axios, basePath));
        },
        /**
         * Delete UserConnection
         * @param {UserConnectionV1alpha1ApiDeleteUserConnectionRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        deleteUserConnection(requestParameters: UserConnectionV1alpha1ApiDeleteUserConnectionRequest, options?: RawAxiosRequestConfig): AxiosPromise<void> {
            return localVarFp.deleteUserConnection(requestParameters.name, options).then((request) => request(axios, basePath));
        },
        /**
         * Get UserConnection
         * @param {UserConnectionV1alpha1ApiGetUserConnectionRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        getUserConnection(requestParameters: UserConnectionV1alpha1ApiGetUserConnectionRequest, options?: RawAxiosRequestConfig): AxiosPromise<UserConnection> {
            return localVarFp.getUserConnection(requestParameters.name, options).then((request) => request(axios, basePath));
        },
        /**
         * List UserConnection
         * @param {UserConnectionV1alpha1ApiListUserConnectionRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        listUserConnection(requestParameters: UserConnectionV1alpha1ApiListUserConnectionRequest = {}, options?: RawAxiosRequestConfig): AxiosPromise<UserConnectionList> {
            return localVarFp.listUserConnection(requestParameters.page, requestParameters.size, requestParameters.labelSelector, requestParameters.fieldSelector, requestParameters.sort, options).then((request) => request(axios, basePath));
        },
        /**
         * Patch UserConnection
         * @param {UserConnectionV1alpha1ApiPatchUserConnectionRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        patchUserConnection(requestParameters: UserConnectionV1alpha1ApiPatchUserConnectionRequest, options?: RawAxiosRequestConfig): AxiosPromise<UserConnection> {
            return localVarFp.patchUserConnection(requestParameters.name, requestParameters.jsonPatchInner, options).then((request) => request(axios, basePath));
        },
        /**
         * Update UserConnection
         * @param {UserConnectionV1alpha1ApiUpdateUserConnectionRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        updateUserConnection(requestParameters: UserConnectionV1alpha1ApiUpdateUserConnectionRequest, options?: RawAxiosRequestConfig): AxiosPromise<UserConnection> {
            return localVarFp.updateUserConnection(requestParameters.name, requestParameters.userConnection, options).then((request) => request(axios, basePath));
        },
    };
};

/**
 * Request parameters for createUserConnection operation in UserConnectionV1alpha1Api.
 * @export
 * @interface UserConnectionV1alpha1ApiCreateUserConnectionRequest
 */
export interface UserConnectionV1alpha1ApiCreateUserConnectionRequest {
    /**
     * Fresh userconnection
     * @type {UserConnection}
     * @memberof UserConnectionV1alpha1ApiCreateUserConnection
     */
    readonly userConnection?: UserConnection
}

/**
 * Request parameters for deleteUserConnection operation in UserConnectionV1alpha1Api.
 * @export
 * @interface UserConnectionV1alpha1ApiDeleteUserConnectionRequest
 */
export interface UserConnectionV1alpha1ApiDeleteUserConnectionRequest {
    /**
     * Name of userconnection
     * @type {string}
     * @memberof UserConnectionV1alpha1ApiDeleteUserConnection
     */
    readonly name: string
}

/**
 * Request parameters for getUserConnection operation in UserConnectionV1alpha1Api.
 * @export
 * @interface UserConnectionV1alpha1ApiGetUserConnectionRequest
 */
export interface UserConnectionV1alpha1ApiGetUserConnectionRequest {
    /**
     * Name of userconnection
     * @type {string}
     * @memberof UserConnectionV1alpha1ApiGetUserConnection
     */
    readonly name: string
}

/**
 * Request parameters for listUserConnection operation in UserConnectionV1alpha1Api.
 * @export
 * @interface UserConnectionV1alpha1ApiListUserConnectionRequest
 */
export interface UserConnectionV1alpha1ApiListUserConnectionRequest {
    /**
     * Page number. Default is 0.
     * @type {number}
     * @memberof UserConnectionV1alpha1ApiListUserConnection
     */
    readonly page?: number

    /**
     * Size number. Default is 0.
     * @type {number}
     * @memberof UserConnectionV1alpha1ApiListUserConnection
     */
    readonly size?: number

    /**
     * Label selector. e.g.: hidden!&#x3D;true
     * @type {Array<string>}
     * @memberof UserConnectionV1alpha1ApiListUserConnection
     */
    readonly labelSelector?: Array<string>

    /**
     * Field selector. e.g.: metadata.name&#x3D;&#x3D;halo
     * @type {Array<string>}
     * @memberof UserConnectionV1alpha1ApiListUserConnection
     */
    readonly fieldSelector?: Array<string>

    /**
     * Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.
     * @type {Array<string>}
     * @memberof UserConnectionV1alpha1ApiListUserConnection
     */
    readonly sort?: Array<string>
}

/**
 * Request parameters for patchUserConnection operation in UserConnectionV1alpha1Api.
 * @export
 * @interface UserConnectionV1alpha1ApiPatchUserConnectionRequest
 */
export interface UserConnectionV1alpha1ApiPatchUserConnectionRequest {
    /**
     * Name of userconnection
     * @type {string}
     * @memberof UserConnectionV1alpha1ApiPatchUserConnection
     */
    readonly name: string

    /**
     * 
     * @type {Array<JsonPatchInner>}
     * @memberof UserConnectionV1alpha1ApiPatchUserConnection
     */
    readonly jsonPatchInner?: Array<JsonPatchInner>
}

/**
 * Request parameters for updateUserConnection operation in UserConnectionV1alpha1Api.
 * @export
 * @interface UserConnectionV1alpha1ApiUpdateUserConnectionRequest
 */
export interface UserConnectionV1alpha1ApiUpdateUserConnectionRequest {
    /**
     * Name of userconnection
     * @type {string}
     * @memberof UserConnectionV1alpha1ApiUpdateUserConnection
     */
    readonly name: string

    /**
     * Updated userconnection
     * @type {UserConnection}
     * @memberof UserConnectionV1alpha1ApiUpdateUserConnection
     */
    readonly userConnection?: UserConnection
}

/**
 * UserConnectionV1alpha1Api - object-oriented interface
 * @export
 * @class UserConnectionV1alpha1Api
 * @extends {BaseAPI}
 */
export class UserConnectionV1alpha1Api extends BaseAPI {
    /**
     * Create UserConnection
     * @param {UserConnectionV1alpha1ApiCreateUserConnectionRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof UserConnectionV1alpha1Api
     */
    public createUserConnection(requestParameters: UserConnectionV1alpha1ApiCreateUserConnectionRequest = {}, options?: RawAxiosRequestConfig) {
        return UserConnectionV1alpha1ApiFp(this.configuration).createUserConnection(requestParameters.userConnection, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Delete UserConnection
     * @param {UserConnectionV1alpha1ApiDeleteUserConnectionRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof UserConnectionV1alpha1Api
     */
    public deleteUserConnection(requestParameters: UserConnectionV1alpha1ApiDeleteUserConnectionRequest, options?: RawAxiosRequestConfig) {
        return UserConnectionV1alpha1ApiFp(this.configuration).deleteUserConnection(requestParameters.name, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Get UserConnection
     * @param {UserConnectionV1alpha1ApiGetUserConnectionRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof UserConnectionV1alpha1Api
     */
    public getUserConnection(requestParameters: UserConnectionV1alpha1ApiGetUserConnectionRequest, options?: RawAxiosRequestConfig) {
        return UserConnectionV1alpha1ApiFp(this.configuration).getUserConnection(requestParameters.name, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * List UserConnection
     * @param {UserConnectionV1alpha1ApiListUserConnectionRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof UserConnectionV1alpha1Api
     */
    public listUserConnection(requestParameters: UserConnectionV1alpha1ApiListUserConnectionRequest = {}, options?: RawAxiosRequestConfig) {
        return UserConnectionV1alpha1ApiFp(this.configuration).listUserConnection(requestParameters.page, requestParameters.size, requestParameters.labelSelector, requestParameters.fieldSelector, requestParameters.sort, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Patch UserConnection
     * @param {UserConnectionV1alpha1ApiPatchUserConnectionRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof UserConnectionV1alpha1Api
     */
    public patchUserConnection(requestParameters: UserConnectionV1alpha1ApiPatchUserConnectionRequest, options?: RawAxiosRequestConfig) {
        return UserConnectionV1alpha1ApiFp(this.configuration).patchUserConnection(requestParameters.name, requestParameters.jsonPatchInner, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Update UserConnection
     * @param {UserConnectionV1alpha1ApiUpdateUserConnectionRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof UserConnectionV1alpha1Api
     */
    public updateUserConnection(requestParameters: UserConnectionV1alpha1ApiUpdateUserConnectionRequest, options?: RawAxiosRequestConfig) {
        return UserConnectionV1alpha1ApiFp(this.configuration).updateUserConnection(requestParameters.name, requestParameters.userConnection, options).then((request) => request(this.axios, this.basePath));
    }
}

