/* tslint:disable */
/* eslint-disable */
/**
 * Halo
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: 2.20.10-SNAPSHOT
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


import type { Configuration } from '../configuration';
import type { AxiosPromise, AxiosInstance, RawAxiosRequestConfig } from 'axios';
import globalAxios from 'axios';
// Some imports not used depending on template conditions
// @ts-ignore
import { DUMMY_BASE_URL, assertParamExists, setApiKeyToObject, setBasicAuthToObject, setBearerAuthToObject, setOAuthToObject, setSearchParams, serializeDataIfNeeded, toPathString, createRequestFunction } from '../common';
// @ts-ignore
import { BASE_PATH, COLLECTION_FORMATS, RequestArgs, BaseAPI, RequiredError, operationServerMap } from '../base';
// @ts-ignore
import { ChangeOwnPasswordRequest } from '../models';
// @ts-ignore
import { ChangePasswordRequest } from '../models';
// @ts-ignore
import { CreateUserRequest } from '../models';
// @ts-ignore
import { DetailedUser } from '../models';
// @ts-ignore
import { EmailVerifyRequest } from '../models';
// @ts-ignore
import { GrantRequest } from '../models';
// @ts-ignore
import { User } from '../models';
// @ts-ignore
import { UserEndpointListedUserList } from '../models';
// @ts-ignore
import { UserPermission } from '../models';
// @ts-ignore
import { VerifyCodeRequest } from '../models';
/**
 * UserV1alpha1ConsoleApi - axios parameter creator
 * @export
 */
export const UserV1alpha1ConsoleApiAxiosParamCreator = function (configuration?: Configuration) {
    return {
        /**
         * Change anyone password of user for admin.
         * @param {string} name Name of user. If the name is equal to \&#39;-\&#39;, it will change the password of current user.
         * @param {ChangePasswordRequest} changePasswordRequest 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        changeAnyonePassword: async (name: string, changePasswordRequest: ChangePasswordRequest, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'name' is not null or undefined
            assertParamExists('changeAnyonePassword', 'name', name)
            // verify required parameter 'changePasswordRequest' is not null or undefined
            assertParamExists('changeAnyonePassword', 'changePasswordRequest', changePasswordRequest)
            const localVarPath = `/apis/api.console.halo.run/v1alpha1/users/{name}/password`
                .replace(`{${"name"}}`, encodeURIComponent(String(name)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'PUT', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            localVarHeaderParameter['Content-Type'] = 'application/json';

            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};
            localVarRequestOptions.data = serializeDataIfNeeded(changePasswordRequest, localVarRequestOptions, configuration)

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Change own password of user.
         * @param {ChangeOwnPasswordRequest} changeOwnPasswordRequest 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        changeOwnPassword: async (changeOwnPasswordRequest: ChangeOwnPasswordRequest, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'changeOwnPasswordRequest' is not null or undefined
            assertParamExists('changeOwnPassword', 'changeOwnPasswordRequest', changeOwnPasswordRequest)
            const localVarPath = `/apis/api.console.halo.run/v1alpha1/users/-/password`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'PUT', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            localVarHeaderParameter['Content-Type'] = 'application/json';

            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};
            localVarRequestOptions.data = serializeDataIfNeeded(changeOwnPasswordRequest, localVarRequestOptions, configuration)

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Creates a new user.
         * @param {CreateUserRequest} createUserRequest 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        createUser: async (createUserRequest: CreateUserRequest, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'createUserRequest' is not null or undefined
            assertParamExists('createUser', 'createUserRequest', createUserRequest)
            const localVarPath = `/apis/api.console.halo.run/v1alpha1/users`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'POST', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            localVarHeaderParameter['Content-Type'] = 'application/json';

            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};
            localVarRequestOptions.data = serializeDataIfNeeded(createUserRequest, localVarRequestOptions, configuration)

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * delete user avatar
         * @param {string} name User name
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        deleteUserAvatar: async (name: string, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'name' is not null or undefined
            assertParamExists('deleteUserAvatar', 'name', name)
            const localVarPath = `/apis/api.console.halo.run/v1alpha1/users/{name}/avatar`
                .replace(`{${"name"}}`, encodeURIComponent(String(name)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'DELETE', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Get current user detail
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        getCurrentUserDetail: async (options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            const localVarPath = `/apis/api.console.halo.run/v1alpha1/users/-`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'GET', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Get permissions of user
         * @param {string} name User name
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        getPermissions: async (name: string, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'name' is not null or undefined
            assertParamExists('getPermissions', 'name', name)
            const localVarPath = `/apis/api.console.halo.run/v1alpha1/users/{name}/permissions`
                .replace(`{${"name"}}`, encodeURIComponent(String(name)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'GET', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Get user detail by name
         * @param {string} name User name
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        getUserDetail: async (name: string, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'name' is not null or undefined
            assertParamExists('getUserDetail', 'name', name)
            const localVarPath = `/apis/api.console.halo.run/v1alpha1/users/{name}`
                .replace(`{${"name"}}`, encodeURIComponent(String(name)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'GET', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Grant permissions to user
         * @param {string} name User name
         * @param {GrantRequest} grantRequest 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        grantPermission: async (name: string, grantRequest: GrantRequest, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'name' is not null or undefined
            assertParamExists('grantPermission', 'name', name)
            // verify required parameter 'grantRequest' is not null or undefined
            assertParamExists('grantPermission', 'grantRequest', grantRequest)
            const localVarPath = `/apis/api.console.halo.run/v1alpha1/users/{name}/permissions`
                .replace(`{${"name"}}`, encodeURIComponent(String(name)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'POST', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            localVarHeaderParameter['Content-Type'] = 'application/json';

            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};
            localVarRequestOptions.data = serializeDataIfNeeded(grantRequest, localVarRequestOptions, configuration)

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * List users
         * @param {number} [page] Page number. Default is 0.
         * @param {number} [size] Size number. Default is 0.
         * @param {Array<string>} [labelSelector] Label selector. e.g.: hidden!&#x3D;true
         * @param {Array<string>} [fieldSelector] Field selector. e.g.: metadata.name&#x3D;&#x3D;halo
         * @param {Array<string>} [sort] Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.
         * @param {string} [keyword] Keyword to search
         * @param {string} [role] Role name
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        listUsers: async (page?: number, size?: number, labelSelector?: Array<string>, fieldSelector?: Array<string>, sort?: Array<string>, keyword?: string, role?: string, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            const localVarPath = `/apis/api.console.halo.run/v1alpha1/users`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'GET', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)

            if (page !== undefined) {
                localVarQueryParameter['page'] = page;
            }

            if (size !== undefined) {
                localVarQueryParameter['size'] = size;
            }

            if (labelSelector) {
                localVarQueryParameter['labelSelector'] = labelSelector;
            }

            if (fieldSelector) {
                localVarQueryParameter['fieldSelector'] = fieldSelector;
            }

            if (sort) {
                localVarQueryParameter['sort'] = sort;
            }

            if (keyword !== undefined) {
                localVarQueryParameter['keyword'] = keyword;
            }

            if (role !== undefined) {
                localVarQueryParameter['role'] = role;
            }


    
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Send email verification code for user
         * @param {EmailVerifyRequest} emailVerifyRequest 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        sendEmailVerificationCode: async (emailVerifyRequest: EmailVerifyRequest, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'emailVerifyRequest' is not null or undefined
            assertParamExists('sendEmailVerificationCode', 'emailVerifyRequest', emailVerifyRequest)
            const localVarPath = `/apis/api.console.halo.run/v1alpha1/users/-/send-email-verification-code`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'POST', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            localVarHeaderParameter['Content-Type'] = 'application/json';

            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};
            localVarRequestOptions.data = serializeDataIfNeeded(emailVerifyRequest, localVarRequestOptions, configuration)

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Update current user profile, but password.
         * @param {User} user 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        updateCurrentUser: async (user: User, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'user' is not null or undefined
            assertParamExists('updateCurrentUser', 'user', user)
            const localVarPath = `/apis/api.console.halo.run/v1alpha1/users/-`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'PUT', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            localVarHeaderParameter['Content-Type'] = 'application/json';

            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};
            localVarRequestOptions.data = serializeDataIfNeeded(user, localVarRequestOptions, configuration)

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * upload user avatar
         * @param {string} name User name
         * @param {File} file 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        uploadUserAvatar: async (name: string, file: File, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'name' is not null or undefined
            assertParamExists('uploadUserAvatar', 'name', name)
            // verify required parameter 'file' is not null or undefined
            assertParamExists('uploadUserAvatar', 'file', file)
            const localVarPath = `/apis/api.console.halo.run/v1alpha1/users/{name}/avatar`
                .replace(`{${"name"}}`, encodeURIComponent(String(name)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'POST', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;
            const localVarFormParams = new ((configuration && configuration.formDataCtor) || FormData)();

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


            if (file !== undefined) { 
                localVarFormParams.append('file', file as any);
            }
    
    
            localVarHeaderParameter['Content-Type'] = 'multipart/form-data';
    
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};
            localVarRequestOptions.data = localVarFormParams;

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Verify email for user by code.
         * @param {VerifyCodeRequest} verifyCodeRequest 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        verifyEmail: async (verifyCodeRequest: VerifyCodeRequest, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'verifyCodeRequest' is not null or undefined
            assertParamExists('verifyEmail', 'verifyCodeRequest', verifyCodeRequest)
            const localVarPath = `/apis/api.console.halo.run/v1alpha1/users/-/verify-email`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'POST', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication basicAuth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            // authentication bearerAuth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)


    
            localVarHeaderParameter['Content-Type'] = 'application/json';

            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};
            localVarRequestOptions.data = serializeDataIfNeeded(verifyCodeRequest, localVarRequestOptions, configuration)

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
    }
};

/**
 * UserV1alpha1ConsoleApi - functional programming interface
 * @export
 */
export const UserV1alpha1ConsoleApiFp = function(configuration?: Configuration) {
    const localVarAxiosParamCreator = UserV1alpha1ConsoleApiAxiosParamCreator(configuration)
    return {
        /**
         * Change anyone password of user for admin.
         * @param {string} name Name of user. If the name is equal to \&#39;-\&#39;, it will change the password of current user.
         * @param {ChangePasswordRequest} changePasswordRequest 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async changeAnyonePassword(name: string, changePasswordRequest: ChangePasswordRequest, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<User>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.changeAnyonePassword(name, changePasswordRequest, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['UserV1alpha1ConsoleApi.changeAnyonePassword']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Change own password of user.
         * @param {ChangeOwnPasswordRequest} changeOwnPasswordRequest 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async changeOwnPassword(changeOwnPasswordRequest: ChangeOwnPasswordRequest, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<User>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.changeOwnPassword(changeOwnPasswordRequest, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['UserV1alpha1ConsoleApi.changeOwnPassword']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Creates a new user.
         * @param {CreateUserRequest} createUserRequest 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async createUser(createUserRequest: CreateUserRequest, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<User>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.createUser(createUserRequest, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['UserV1alpha1ConsoleApi.createUser']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * delete user avatar
         * @param {string} name User name
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async deleteUserAvatar(name: string, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<User>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.deleteUserAvatar(name, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['UserV1alpha1ConsoleApi.deleteUserAvatar']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Get current user detail
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async getCurrentUserDetail(options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<DetailedUser>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.getCurrentUserDetail(options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['UserV1alpha1ConsoleApi.getCurrentUserDetail']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Get permissions of user
         * @param {string} name User name
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async getPermissions(name: string, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<UserPermission>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.getPermissions(name, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['UserV1alpha1ConsoleApi.getPermissions']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Get user detail by name
         * @param {string} name User name
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async getUserDetail(name: string, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<DetailedUser>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.getUserDetail(name, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['UserV1alpha1ConsoleApi.getUserDetail']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Grant permissions to user
         * @param {string} name User name
         * @param {GrantRequest} grantRequest 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async grantPermission(name: string, grantRequest: GrantRequest, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<User>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.grantPermission(name, grantRequest, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['UserV1alpha1ConsoleApi.grantPermission']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * List users
         * @param {number} [page] Page number. Default is 0.
         * @param {number} [size] Size number. Default is 0.
         * @param {Array<string>} [labelSelector] Label selector. e.g.: hidden!&#x3D;true
         * @param {Array<string>} [fieldSelector] Field selector. e.g.: metadata.name&#x3D;&#x3D;halo
         * @param {Array<string>} [sort] Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.
         * @param {string} [keyword] Keyword to search
         * @param {string} [role] Role name
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async listUsers(page?: number, size?: number, labelSelector?: Array<string>, fieldSelector?: Array<string>, sort?: Array<string>, keyword?: string, role?: string, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<UserEndpointListedUserList>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.listUsers(page, size, labelSelector, fieldSelector, sort, keyword, role, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['UserV1alpha1ConsoleApi.listUsers']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Send email verification code for user
         * @param {EmailVerifyRequest} emailVerifyRequest 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async sendEmailVerificationCode(emailVerifyRequest: EmailVerifyRequest, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<void>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.sendEmailVerificationCode(emailVerifyRequest, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['UserV1alpha1ConsoleApi.sendEmailVerificationCode']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Update current user profile, but password.
         * @param {User} user 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async updateCurrentUser(user: User, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<User>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.updateCurrentUser(user, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['UserV1alpha1ConsoleApi.updateCurrentUser']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * upload user avatar
         * @param {string} name User name
         * @param {File} file 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async uploadUserAvatar(name: string, file: File, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<User>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.uploadUserAvatar(name, file, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['UserV1alpha1ConsoleApi.uploadUserAvatar']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Verify email for user by code.
         * @param {VerifyCodeRequest} verifyCodeRequest 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async verifyEmail(verifyCodeRequest: VerifyCodeRequest, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<void>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.verifyEmail(verifyCodeRequest, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['UserV1alpha1ConsoleApi.verifyEmail']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
    }
};

/**
 * UserV1alpha1ConsoleApi - factory interface
 * @export
 */
export const UserV1alpha1ConsoleApiFactory = function (configuration?: Configuration, basePath?: string, axios?: AxiosInstance) {
    const localVarFp = UserV1alpha1ConsoleApiFp(configuration)
    return {
        /**
         * Change anyone password of user for admin.
         * @param {UserV1alpha1ConsoleApiChangeAnyonePasswordRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        changeAnyonePassword(requestParameters: UserV1alpha1ConsoleApiChangeAnyonePasswordRequest, options?: RawAxiosRequestConfig): AxiosPromise<User> {
            return localVarFp.changeAnyonePassword(requestParameters.name, requestParameters.changePasswordRequest, options).then((request) => request(axios, basePath));
        },
        /**
         * Change own password of user.
         * @param {UserV1alpha1ConsoleApiChangeOwnPasswordRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        changeOwnPassword(requestParameters: UserV1alpha1ConsoleApiChangeOwnPasswordRequest, options?: RawAxiosRequestConfig): AxiosPromise<User> {
            return localVarFp.changeOwnPassword(requestParameters.changeOwnPasswordRequest, options).then((request) => request(axios, basePath));
        },
        /**
         * Creates a new user.
         * @param {UserV1alpha1ConsoleApiCreateUserRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        createUser(requestParameters: UserV1alpha1ConsoleApiCreateUserRequest, options?: RawAxiosRequestConfig): AxiosPromise<User> {
            return localVarFp.createUser(requestParameters.createUserRequest, options).then((request) => request(axios, basePath));
        },
        /**
         * delete user avatar
         * @param {UserV1alpha1ConsoleApiDeleteUserAvatarRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        deleteUserAvatar(requestParameters: UserV1alpha1ConsoleApiDeleteUserAvatarRequest, options?: RawAxiosRequestConfig): AxiosPromise<User> {
            return localVarFp.deleteUserAvatar(requestParameters.name, options).then((request) => request(axios, basePath));
        },
        /**
         * Get current user detail
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        getCurrentUserDetail(options?: RawAxiosRequestConfig): AxiosPromise<DetailedUser> {
            return localVarFp.getCurrentUserDetail(options).then((request) => request(axios, basePath));
        },
        /**
         * Get permissions of user
         * @param {UserV1alpha1ConsoleApiGetPermissionsRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        getPermissions(requestParameters: UserV1alpha1ConsoleApiGetPermissionsRequest, options?: RawAxiosRequestConfig): AxiosPromise<UserPermission> {
            return localVarFp.getPermissions(requestParameters.name, options).then((request) => request(axios, basePath));
        },
        /**
         * Get user detail by name
         * @param {UserV1alpha1ConsoleApiGetUserDetailRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        getUserDetail(requestParameters: UserV1alpha1ConsoleApiGetUserDetailRequest, options?: RawAxiosRequestConfig): AxiosPromise<DetailedUser> {
            return localVarFp.getUserDetail(requestParameters.name, options).then((request) => request(axios, basePath));
        },
        /**
         * Grant permissions to user
         * @param {UserV1alpha1ConsoleApiGrantPermissionRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        grantPermission(requestParameters: UserV1alpha1ConsoleApiGrantPermissionRequest, options?: RawAxiosRequestConfig): AxiosPromise<User> {
            return localVarFp.grantPermission(requestParameters.name, requestParameters.grantRequest, options).then((request) => request(axios, basePath));
        },
        /**
         * List users
         * @param {UserV1alpha1ConsoleApiListUsersRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        listUsers(requestParameters: UserV1alpha1ConsoleApiListUsersRequest = {}, options?: RawAxiosRequestConfig): AxiosPromise<UserEndpointListedUserList> {
            return localVarFp.listUsers(requestParameters.page, requestParameters.size, requestParameters.labelSelector, requestParameters.fieldSelector, requestParameters.sort, requestParameters.keyword, requestParameters.role, options).then((request) => request(axios, basePath));
        },
        /**
         * Send email verification code for user
         * @param {UserV1alpha1ConsoleApiSendEmailVerificationCodeRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        sendEmailVerificationCode(requestParameters: UserV1alpha1ConsoleApiSendEmailVerificationCodeRequest, options?: RawAxiosRequestConfig): AxiosPromise<void> {
            return localVarFp.sendEmailVerificationCode(requestParameters.emailVerifyRequest, options).then((request) => request(axios, basePath));
        },
        /**
         * Update current user profile, but password.
         * @param {UserV1alpha1ConsoleApiUpdateCurrentUserRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        updateCurrentUser(requestParameters: UserV1alpha1ConsoleApiUpdateCurrentUserRequest, options?: RawAxiosRequestConfig): AxiosPromise<User> {
            return localVarFp.updateCurrentUser(requestParameters.user, options).then((request) => request(axios, basePath));
        },
        /**
         * upload user avatar
         * @param {UserV1alpha1ConsoleApiUploadUserAvatarRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        uploadUserAvatar(requestParameters: UserV1alpha1ConsoleApiUploadUserAvatarRequest, options?: RawAxiosRequestConfig): AxiosPromise<User> {
            return localVarFp.uploadUserAvatar(requestParameters.name, requestParameters.file, options).then((request) => request(axios, basePath));
        },
        /**
         * Verify email for user by code.
         * @param {UserV1alpha1ConsoleApiVerifyEmailRequest} requestParameters Request parameters.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        verifyEmail(requestParameters: UserV1alpha1ConsoleApiVerifyEmailRequest, options?: RawAxiosRequestConfig): AxiosPromise<void> {
            return localVarFp.verifyEmail(requestParameters.verifyCodeRequest, options).then((request) => request(axios, basePath));
        },
    };
};

/**
 * Request parameters for changeAnyonePassword operation in UserV1alpha1ConsoleApi.
 * @export
 * @interface UserV1alpha1ConsoleApiChangeAnyonePasswordRequest
 */
export interface UserV1alpha1ConsoleApiChangeAnyonePasswordRequest {
    /**
     * Name of user. If the name is equal to \&#39;-\&#39;, it will change the password of current user.
     * @type {string}
     * @memberof UserV1alpha1ConsoleApiChangeAnyonePassword
     */
    readonly name: string

    /**
     * 
     * @type {ChangePasswordRequest}
     * @memberof UserV1alpha1ConsoleApiChangeAnyonePassword
     */
    readonly changePasswordRequest: ChangePasswordRequest
}

/**
 * Request parameters for changeOwnPassword operation in UserV1alpha1ConsoleApi.
 * @export
 * @interface UserV1alpha1ConsoleApiChangeOwnPasswordRequest
 */
export interface UserV1alpha1ConsoleApiChangeOwnPasswordRequest {
    /**
     * 
     * @type {ChangeOwnPasswordRequest}
     * @memberof UserV1alpha1ConsoleApiChangeOwnPassword
     */
    readonly changeOwnPasswordRequest: ChangeOwnPasswordRequest
}

/**
 * Request parameters for createUser operation in UserV1alpha1ConsoleApi.
 * @export
 * @interface UserV1alpha1ConsoleApiCreateUserRequest
 */
export interface UserV1alpha1ConsoleApiCreateUserRequest {
    /**
     * 
     * @type {CreateUserRequest}
     * @memberof UserV1alpha1ConsoleApiCreateUser
     */
    readonly createUserRequest: CreateUserRequest
}

/**
 * Request parameters for deleteUserAvatar operation in UserV1alpha1ConsoleApi.
 * @export
 * @interface UserV1alpha1ConsoleApiDeleteUserAvatarRequest
 */
export interface UserV1alpha1ConsoleApiDeleteUserAvatarRequest {
    /**
     * User name
     * @type {string}
     * @memberof UserV1alpha1ConsoleApiDeleteUserAvatar
     */
    readonly name: string
}

/**
 * Request parameters for getPermissions operation in UserV1alpha1ConsoleApi.
 * @export
 * @interface UserV1alpha1ConsoleApiGetPermissionsRequest
 */
export interface UserV1alpha1ConsoleApiGetPermissionsRequest {
    /**
     * User name
     * @type {string}
     * @memberof UserV1alpha1ConsoleApiGetPermissions
     */
    readonly name: string
}

/**
 * Request parameters for getUserDetail operation in UserV1alpha1ConsoleApi.
 * @export
 * @interface UserV1alpha1ConsoleApiGetUserDetailRequest
 */
export interface UserV1alpha1ConsoleApiGetUserDetailRequest {
    /**
     * User name
     * @type {string}
     * @memberof UserV1alpha1ConsoleApiGetUserDetail
     */
    readonly name: string
}

/**
 * Request parameters for grantPermission operation in UserV1alpha1ConsoleApi.
 * @export
 * @interface UserV1alpha1ConsoleApiGrantPermissionRequest
 */
export interface UserV1alpha1ConsoleApiGrantPermissionRequest {
    /**
     * User name
     * @type {string}
     * @memberof UserV1alpha1ConsoleApiGrantPermission
     */
    readonly name: string

    /**
     * 
     * @type {GrantRequest}
     * @memberof UserV1alpha1ConsoleApiGrantPermission
     */
    readonly grantRequest: GrantRequest
}

/**
 * Request parameters for listUsers operation in UserV1alpha1ConsoleApi.
 * @export
 * @interface UserV1alpha1ConsoleApiListUsersRequest
 */
export interface UserV1alpha1ConsoleApiListUsersRequest {
    /**
     * Page number. Default is 0.
     * @type {number}
     * @memberof UserV1alpha1ConsoleApiListUsers
     */
    readonly page?: number

    /**
     * Size number. Default is 0.
     * @type {number}
     * @memberof UserV1alpha1ConsoleApiListUsers
     */
    readonly size?: number

    /**
     * Label selector. e.g.: hidden!&#x3D;true
     * @type {Array<string>}
     * @memberof UserV1alpha1ConsoleApiListUsers
     */
    readonly labelSelector?: Array<string>

    /**
     * Field selector. e.g.: metadata.name&#x3D;&#x3D;halo
     * @type {Array<string>}
     * @memberof UserV1alpha1ConsoleApiListUsers
     */
    readonly fieldSelector?: Array<string>

    /**
     * Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.
     * @type {Array<string>}
     * @memberof UserV1alpha1ConsoleApiListUsers
     */
    readonly sort?: Array<string>

    /**
     * Keyword to search
     * @type {string}
     * @memberof UserV1alpha1ConsoleApiListUsers
     */
    readonly keyword?: string

    /**
     * Role name
     * @type {string}
     * @memberof UserV1alpha1ConsoleApiListUsers
     */
    readonly role?: string
}

/**
 * Request parameters for sendEmailVerificationCode operation in UserV1alpha1ConsoleApi.
 * @export
 * @interface UserV1alpha1ConsoleApiSendEmailVerificationCodeRequest
 */
export interface UserV1alpha1ConsoleApiSendEmailVerificationCodeRequest {
    /**
     * 
     * @type {EmailVerifyRequest}
     * @memberof UserV1alpha1ConsoleApiSendEmailVerificationCode
     */
    readonly emailVerifyRequest: EmailVerifyRequest
}

/**
 * Request parameters for updateCurrentUser operation in UserV1alpha1ConsoleApi.
 * @export
 * @interface UserV1alpha1ConsoleApiUpdateCurrentUserRequest
 */
export interface UserV1alpha1ConsoleApiUpdateCurrentUserRequest {
    /**
     * 
     * @type {User}
     * @memberof UserV1alpha1ConsoleApiUpdateCurrentUser
     */
    readonly user: User
}

/**
 * Request parameters for uploadUserAvatar operation in UserV1alpha1ConsoleApi.
 * @export
 * @interface UserV1alpha1ConsoleApiUploadUserAvatarRequest
 */
export interface UserV1alpha1ConsoleApiUploadUserAvatarRequest {
    /**
     * User name
     * @type {string}
     * @memberof UserV1alpha1ConsoleApiUploadUserAvatar
     */
    readonly name: string

    /**
     * 
     * @type {File}
     * @memberof UserV1alpha1ConsoleApiUploadUserAvatar
     */
    readonly file: File
}

/**
 * Request parameters for verifyEmail operation in UserV1alpha1ConsoleApi.
 * @export
 * @interface UserV1alpha1ConsoleApiVerifyEmailRequest
 */
export interface UserV1alpha1ConsoleApiVerifyEmailRequest {
    /**
     * 
     * @type {VerifyCodeRequest}
     * @memberof UserV1alpha1ConsoleApiVerifyEmail
     */
    readonly verifyCodeRequest: VerifyCodeRequest
}

/**
 * UserV1alpha1ConsoleApi - object-oriented interface
 * @export
 * @class UserV1alpha1ConsoleApi
 * @extends {BaseAPI}
 */
export class UserV1alpha1ConsoleApi extends BaseAPI {
    /**
     * Change anyone password of user for admin.
     * @param {UserV1alpha1ConsoleApiChangeAnyonePasswordRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof UserV1alpha1ConsoleApi
     */
    public changeAnyonePassword(requestParameters: UserV1alpha1ConsoleApiChangeAnyonePasswordRequest, options?: RawAxiosRequestConfig) {
        return UserV1alpha1ConsoleApiFp(this.configuration).changeAnyonePassword(requestParameters.name, requestParameters.changePasswordRequest, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Change own password of user.
     * @param {UserV1alpha1ConsoleApiChangeOwnPasswordRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof UserV1alpha1ConsoleApi
     */
    public changeOwnPassword(requestParameters: UserV1alpha1ConsoleApiChangeOwnPasswordRequest, options?: RawAxiosRequestConfig) {
        return UserV1alpha1ConsoleApiFp(this.configuration).changeOwnPassword(requestParameters.changeOwnPasswordRequest, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Creates a new user.
     * @param {UserV1alpha1ConsoleApiCreateUserRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof UserV1alpha1ConsoleApi
     */
    public createUser(requestParameters: UserV1alpha1ConsoleApiCreateUserRequest, options?: RawAxiosRequestConfig) {
        return UserV1alpha1ConsoleApiFp(this.configuration).createUser(requestParameters.createUserRequest, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * delete user avatar
     * @param {UserV1alpha1ConsoleApiDeleteUserAvatarRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof UserV1alpha1ConsoleApi
     */
    public deleteUserAvatar(requestParameters: UserV1alpha1ConsoleApiDeleteUserAvatarRequest, options?: RawAxiosRequestConfig) {
        return UserV1alpha1ConsoleApiFp(this.configuration).deleteUserAvatar(requestParameters.name, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Get current user detail
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof UserV1alpha1ConsoleApi
     */
    public getCurrentUserDetail(options?: RawAxiosRequestConfig) {
        return UserV1alpha1ConsoleApiFp(this.configuration).getCurrentUserDetail(options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Get permissions of user
     * @param {UserV1alpha1ConsoleApiGetPermissionsRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof UserV1alpha1ConsoleApi
     */
    public getPermissions(requestParameters: UserV1alpha1ConsoleApiGetPermissionsRequest, options?: RawAxiosRequestConfig) {
        return UserV1alpha1ConsoleApiFp(this.configuration).getPermissions(requestParameters.name, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Get user detail by name
     * @param {UserV1alpha1ConsoleApiGetUserDetailRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof UserV1alpha1ConsoleApi
     */
    public getUserDetail(requestParameters: UserV1alpha1ConsoleApiGetUserDetailRequest, options?: RawAxiosRequestConfig) {
        return UserV1alpha1ConsoleApiFp(this.configuration).getUserDetail(requestParameters.name, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Grant permissions to user
     * @param {UserV1alpha1ConsoleApiGrantPermissionRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof UserV1alpha1ConsoleApi
     */
    public grantPermission(requestParameters: UserV1alpha1ConsoleApiGrantPermissionRequest, options?: RawAxiosRequestConfig) {
        return UserV1alpha1ConsoleApiFp(this.configuration).grantPermission(requestParameters.name, requestParameters.grantRequest, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * List users
     * @param {UserV1alpha1ConsoleApiListUsersRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof UserV1alpha1ConsoleApi
     */
    public listUsers(requestParameters: UserV1alpha1ConsoleApiListUsersRequest = {}, options?: RawAxiosRequestConfig) {
        return UserV1alpha1ConsoleApiFp(this.configuration).listUsers(requestParameters.page, requestParameters.size, requestParameters.labelSelector, requestParameters.fieldSelector, requestParameters.sort, requestParameters.keyword, requestParameters.role, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Send email verification code for user
     * @param {UserV1alpha1ConsoleApiSendEmailVerificationCodeRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof UserV1alpha1ConsoleApi
     */
    public sendEmailVerificationCode(requestParameters: UserV1alpha1ConsoleApiSendEmailVerificationCodeRequest, options?: RawAxiosRequestConfig) {
        return UserV1alpha1ConsoleApiFp(this.configuration).sendEmailVerificationCode(requestParameters.emailVerifyRequest, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Update current user profile, but password.
     * @param {UserV1alpha1ConsoleApiUpdateCurrentUserRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof UserV1alpha1ConsoleApi
     */
    public updateCurrentUser(requestParameters: UserV1alpha1ConsoleApiUpdateCurrentUserRequest, options?: RawAxiosRequestConfig) {
        return UserV1alpha1ConsoleApiFp(this.configuration).updateCurrentUser(requestParameters.user, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * upload user avatar
     * @param {UserV1alpha1ConsoleApiUploadUserAvatarRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof UserV1alpha1ConsoleApi
     */
    public uploadUserAvatar(requestParameters: UserV1alpha1ConsoleApiUploadUserAvatarRequest, options?: RawAxiosRequestConfig) {
        return UserV1alpha1ConsoleApiFp(this.configuration).uploadUserAvatar(requestParameters.name, requestParameters.file, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Verify email for user by code.
     * @param {UserV1alpha1ConsoleApiVerifyEmailRequest} requestParameters Request parameters.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof UserV1alpha1ConsoleApi
     */
    public verifyEmail(requestParameters: UserV1alpha1ConsoleApiVerifyEmailRequest, options?: RawAxiosRequestConfig) {
        return UserV1alpha1ConsoleApiFp(this.configuration).verifyEmail(requestParameters.verifyCodeRequest, options).then((request) => request(this.axios, this.basePath));
    }
}

