import type { Meta, StoryObj } from "@storybook/vue3";

import { VCard } from ".";

const meta: Meta<typeof VCard> = {
  title: "Card",
  component: VCard,
  tags: ["autodocs"],
  render: (args) => ({
    components: { VCard },
    setup() {
      return { args };
    },
    template: `<VCard v-bind="args">${args.default}</VCard>`,
  }),
  argTypes: {
    default: {
      control: { type: "text" },
    },
  },
  args: {
    default: `      <!--      https://lofiui.co/-->
    <div class="p-3">
      <VCard title="Page Views">
        <div class="flex w-full flex-col items-center bg-white">
          <div class="flex w-full flex-grow items-end space-x-2 sm:space-x-3">
            <div
              class="group relative flex flex-grow flex-col items-center pb-5"
            >
              <span
                class="absolute top-0 -mt-6 hidden text-xs font-bold group-hover:block"
                >$37,500</span
              >
              <div class="flex w-full items-end">
                <div
                  class="relative flex h-8 flex-grow justify-center bg-indigo-200"
                ></div>
                <div
                  class="relative flex h-6 flex-grow justify-center bg-indigo-300"
                ></div>
                <div
                  class="relative flex h-16 flex-grow justify-center bg-indigo-400"
                ></div>
              </div>
              <span class="absolute bottom-0 text-xs font-bold">Jan</span>
            </div>
            <div
              class="group relative flex flex-grow flex-col items-center pb-5"
            >
              <span
                class="absolute top-0 -mt-6 hidden text-xs font-bold group-hover:block"
                >$45,000</span
              >
              <div class="flex w-full items-end">
                <div
                  class="relative flex h-10 flex-grow justify-center bg-indigo-200"
                ></div>
                <div
                  class="relative flex h-6 flex-grow justify-center bg-indigo-300"
                ></div>
                <div
                  class="relative flex h-20 flex-grow justify-center bg-indigo-400"
                ></div>
              </div>
              <span class="absolute bottom-0 text-xs font-bold">Feb</span>
            </div>
            <div
              class="group relative flex flex-grow flex-col items-center pb-5"
            >
              <span
                class="absolute top-0 -mt-6 hidden text-xs font-bold group-hover:block"
                >$47,500</span
              >
              <div class="flex w-full items-end">
                <div
                  class="relative flex h-10 flex-grow justify-center bg-indigo-200"
                ></div>
                <div
                  class="relative flex h-8 flex-grow justify-center bg-indigo-300"
                ></div>
                <div
                  class="relative flex h-20 flex-grow justify-center bg-indigo-400"
                ></div>
              </div>
              <span class="absolute bottom-0 text-xs font-bold">Mar</span>
            </div>
            <div
              class="group relative flex flex-grow flex-col items-center pb-5"
            >
              <span
                class="absolute top-0 -mt-6 hidden text-xs font-bold group-hover:block"
                >$50,000</span
              >
              <div class="flex w-full items-end">
                <div
                  class="relative flex h-10 flex-grow justify-center bg-indigo-200"
                ></div>
                <div
                  class="relative flex h-6 flex-grow justify-center bg-indigo-300"
                ></div>
                <div
                  class="relative flex h-24 flex-grow justify-center bg-indigo-400"
                ></div>
              </div>
              <span class="absolute bottom-0 text-xs font-bold">Apr</span>
            </div>
            <div
              class="group relative flex flex-grow flex-col items-center pb-5"
            >
              <span
                class="absolute top-0 -mt-6 hidden text-xs font-bold group-hover:block"
                >$47,500</span
              >
              <div class="flex w-full items-end">
                <div
                  class="relative flex h-10 flex-grow justify-center bg-indigo-200"
                ></div>
                <div
                  class="relative flex h-8 flex-grow justify-center bg-indigo-300"
                ></div>
                <div
                  class="relative flex h-20 flex-grow justify-center bg-indigo-400"
                ></div>
              </div>
              <span class="absolute bottom-0 text-xs font-bold">May</span>
            </div>
            <div
              class="group relative flex flex-grow flex-col items-center pb-5"
            >
              <span
                class="absolute top-0 -mt-6 hidden text-xs font-bold group-hover:block"
                >$55,000</span
              >
              <div class="flex w-full items-end">
                <div
                  class="relative flex h-12 flex-grow justify-center bg-indigo-200"
                ></div>
                <div
                  class="relative flex h-8 flex-grow justify-center bg-indigo-300"
                ></div>
                <div
                  class="relative flex h-24 flex-grow justify-center bg-indigo-400"
                ></div>
              </div>
              <span class="absolute bottom-0 text-xs font-bold">Jun</span>
            </div>
            <div
              class="group relative flex flex-grow flex-col items-center pb-5"
            >
              <span
                class="absolute top-0 -mt-6 hidden text-xs font-bold group-hover:block"
                >$60,000</span
              >
              <div class="flex w-full items-end">
                <div
                  class="relative flex h-12 flex-grow justify-center bg-indigo-200"
                ></div>
                <div
                  class="relative flex h-16 flex-grow justify-center bg-indigo-300"
                ></div>
                <div
                  class="relative flex h-20 flex-grow justify-center bg-indigo-400"
                ></div>
              </div>
              <span class="absolute bottom-0 text-xs font-bold">Jul</span>
            </div>
            <div
              class="group relative flex flex-grow flex-col items-center pb-5"
            >
              <span
                class="absolute top-0 -mt-6 hidden text-xs font-bold group-hover:block"
                >$57,500</span
              >
              <div class="flex w-full items-end">
                <div
                  class="relative flex h-12 flex-grow justify-center bg-indigo-200"
                ></div>
                <div
                  class="relative flex h-10 flex-grow justify-center bg-indigo-300"
                ></div>
                <div
                  class="relative flex h-24 flex-grow justify-center bg-indigo-400"
                ></div>
              </div>
              <span class="absolute bottom-0 text-xs font-bold">Aug</span>
            </div>
            <div
              class="group relative flex flex-grow flex-col items-center pb-5"
            >
              <span
                class="absolute top-0 -mt-6 hidden text-xs font-bold group-hover:block"
                >$67,500</span
              >
              <div class="flex w-full items-end">
                <div
                  class="relative flex h-12 flex-grow justify-center bg-indigo-200"
                ></div>
                <div
                  class="relative flex h-10 flex-grow justify-center bg-indigo-300"
                ></div>
                <div
                  class="relative flex h-32 flex-grow justify-center bg-indigo-400"
                ></div>
              </div>
              <span class="absolute bottom-0 text-xs font-bold">Sep</span>
            </div>
            <div
              class="group relative flex flex-grow flex-col items-center pb-5"
            >
              <span
                class="absolute top-0 -mt-6 hidden text-xs font-bold group-hover:block"
                >$65,000</span
              >
              <div class="flex w-full items-end">
                <div
                  class="relative flex h-12 flex-grow justify-center bg-indigo-200"
                ></div>
                <div
                  class="relative flex h-12 flex-grow justify-center bg-indigo-300"
                ></div>
                <div
                  class="relative flex h-28 flex-grow justify-center bg-indigo-400"
                ></div>
              </div>
              <span class="absolute bottom-0 text-xs font-bold">Oct</span>
            </div>
            <div
              class="group relative flex flex-grow flex-col items-center pb-5"
            >
              <span
                class="absolute top-0 -mt-6 hidden text-xs font-bold group-hover:block"
                >$70,000</span
              >
              <div class="flex w-full items-end">
                <div
                  class="relative flex h-8 flex-grow justify-center bg-indigo-200"
                ></div>
                <div
                  class="relative flex h-8 flex-grow justify-center bg-indigo-300"
                ></div>
                <div
                  class="relative flex h-40 flex-grow justify-center bg-indigo-400"
                ></div>
              </div>
              <span class="absolute bottom-0 text-xs font-bold">Nov</span>
            </div>
            <div
              class="group relative flex flex-grow flex-col items-center pb-5"
            >
              <span
                class="absolute top-0 -mt-6 hidden text-xs font-bold group-hover:block"
                >$75,000</span
              >
              <div class="flex w-full items-end">
                <div
                  class="relative flex h-12 flex-grow justify-center bg-indigo-200"
                ></div>
                <div
                  class="relative flex h-8 flex-grow justify-center bg-indigo-300"
                ></div>
                <div
                  class="relative flex h-40 flex-grow justify-center bg-indigo-400"
                ></div>
              </div>
              <span class="absolute bottom-0 text-xs font-bold">Dec</span>
            </div>
          </div>
          <div class="mt-3 flex w-full">
            <div class="ml-auto flex items-center">
              <span class="block h-4 w-4 bg-indigo-400"></span>
              <span class="ml-1 text-xs font-medium">Existing</span>
            </div>
            <div class="ml-4 flex items-center">
              <span class="block h-4 w-4 bg-indigo-300"></span>
              <span class="ml-1 text-xs font-medium">Upgrades</span>
            </div>
            <div class="ml-4 flex items-center">
              <span class="block h-4 w-4 bg-indigo-200"></span>
              <span class="ml-1 text-xs font-medium">New</span>
            </div>
          </div>
        </div>
      </VCard>
    </div>

    <!--      https://lofiui.co/-->
    <div class="p-3">
      <VCard title="Page Views">
        <div class="flex w-full flex-col items-center bg-white">
          <div class="flex w-full flex-grow items-end space-x-2 sm:space-x-3">
            <div
              class="group relative flex flex-grow flex-col items-center pb-5"
            >
              <span
                class="absolute top-0 -mt-6 hidden text-xs font-bold group-hover:block"
                >$37,500</span
              >
              <div
                class="relative flex h-8 w-full justify-center bg-indigo-200"
              ></div>
              <div
                class="relative flex h-6 w-full justify-center bg-indigo-300"
              ></div>
              <div
                class="relative flex h-16 w-full justify-center bg-indigo-400"
              ></div>
              <span class="absolute bottom-0 text-xs font-bold">Jan</span>
            </div>
            <div
              class="group relative flex flex-grow flex-col items-center pb-5"
            >
              <span
                class="absolute top-0 -mt-6 hidden text-xs font-bold group-hover:block"
                >$45,000</span
              >
              <div
                class="relative flex h-10 w-full justify-center bg-indigo-200"
              ></div>
              <div
                class="relative flex h-6 w-full justify-center bg-indigo-300"
              ></div>
              <div
                class="relative flex h-20 w-full justify-center bg-indigo-400"
              ></div>
              <span class="absolute bottom-0 text-xs font-bold">Feb</span>
            </div>
            <div
              class="group relative flex flex-grow flex-col items-center pb-5"
            >
              <span
                class="absolute top-0 -mt-6 hidden text-xs font-bold group-hover:block"
                >$47,500</span
              >
              <div
                class="relative flex h-10 w-full justify-center bg-indigo-200"
              ></div>
              <div
                class="relative flex h-8 w-full justify-center bg-indigo-300"
              ></div>
              <div
                class="relative flex h-20 w-full justify-center bg-indigo-400"
              ></div>
              <span class="absolute bottom-0 text-xs font-bold">Mar</span>
            </div>
            <div
              class="group relative flex flex-grow flex-col items-center pb-5"
            >
              <span
                class="absolute top-0 -mt-6 hidden text-xs font-bold group-hover:block"
                >$50,000</span
              >
              <div
                class="relative flex h-10 w-full justify-center bg-indigo-200"
              ></div>
              <div
                class="relative flex h-6 w-full justify-center bg-indigo-300"
              ></div>
              <div
                class="relative flex h-24 w-full justify-center bg-indigo-400"
              ></div>
              <span class="absolute bottom-0 text-xs font-bold">Apr</span>
            </div>
            <div
              class="group relative flex flex-grow flex-col items-center pb-5"
            >
              <span
                class="absolute top-0 -mt-6 hidden text-xs font-bold group-hover:block"
                >$47,500</span
              >
              <div
                class="relative flex h-10 w-full justify-center bg-indigo-200"
              ></div>
              <div
                class="relative flex h-8 w-full justify-center bg-indigo-300"
              ></div>
              <div
                class="relative flex h-20 w-full justify-center bg-indigo-400"
              ></div>
              <span class="absolute bottom-0 text-xs font-bold">May</span>
            </div>
            <div
              class="group relative flex flex-grow flex-col items-center pb-5"
            >
              <span
                class="absolute top-0 -mt-6 hidden text-xs font-bold group-hover:block"
                >$55,000</span
              >
              <div
                class="relative flex h-12 w-full justify-center bg-indigo-200"
              ></div>
              <div
                class="relative flex h-8 w-full justify-center bg-indigo-300"
              ></div>
              <div
                class="relative flex h-24 w-full justify-center bg-indigo-400"
              ></div>
              <span class="absolute bottom-0 text-xs font-bold">Jun</span>
            </div>
            <div
              class="group relative flex flex-grow flex-col items-center pb-5"
            >
              <span
                class="absolute top-0 -mt-6 hidden text-xs font-bold group-hover:block"
                >$60,000</span
              >
              <div
                class="relative flex h-12 w-full justify-center bg-indigo-200"
              ></div>
              <div
                class="relative flex h-16 w-full justify-center bg-indigo-300"
              ></div>
              <div
                class="relative flex h-20 w-full justify-center bg-indigo-400"
              ></div>
              <span class="absolute bottom-0 text-xs font-bold">Jul</span>
            </div>
            <div
              class="group relative flex flex-grow flex-col items-center pb-5"
            >
              <span
                class="absolute top-0 -mt-6 hidden text-xs font-bold group-hover:block"
                >$57,500</span
              >
              <div
                class="relative flex h-12 w-full justify-center bg-indigo-200"
              ></div>
              <div
                class="relative flex h-10 w-full justify-center bg-indigo-300"
              ></div>
              <div
                class="relative flex h-24 w-full justify-center bg-indigo-400"
              ></div>
              <span class="absolute bottom-0 text-xs font-bold">Aug</span>
            </div>
            <div
              class="group relative flex flex-grow flex-col items-center pb-5"
            >
              <span
                class="absolute top-0 -mt-6 hidden text-xs font-bold group-hover:block"
                >$67,500</span
              >
              <div
                class="relative flex h-12 w-full justify-center bg-indigo-200"
              ></div>
              <div
                class="relative flex h-10 w-full justify-center bg-indigo-300"
              ></div>
              <div
                class="relative flex h-32 w-full justify-center bg-indigo-400"
              ></div>
              <span class="absolute bottom-0 text-xs font-bold">Sep</span>
            </div>
            <div
              class="group relative flex flex-grow flex-col items-center pb-5"
            >
              <span
                class="absolute top-0 -mt-6 hidden text-xs font-bold group-hover:block"
                >$65,000</span
              >
              <div
                class="relative flex h-12 w-full justify-center bg-indigo-200"
              ></div>
              <div
                class="relative flex h-12 w-full justify-center bg-indigo-300"
              ></div>
              <div
                class="relative flex h-28 w-full justify-center bg-indigo-400"
              ></div>
              <span class="absolute bottom-0 text-xs font-bold">Oct</span>
            </div>
            <div
              class="group relative flex flex-grow flex-col items-center pb-5"
            >
              <span
                class="absolute top-0 -mt-6 hidden text-xs font-bold group-hover:block"
                >$70,000</span
              >
              <div
                class="relative flex h-8 w-full justify-center bg-indigo-200"
              ></div>
              <div
                class="relative flex h-8 w-full justify-center bg-indigo-300"
              ></div>
              <div
                class="relative flex h-40 w-full justify-center bg-indigo-400"
              ></div>
              <span class="absolute bottom-0 text-xs font-bold">Nov</span>
            </div>
            <div
              class="group relative flex flex-grow flex-col items-center pb-5"
            >
              <span
                class="absolute top-0 -mt-6 hidden text-xs font-bold group-hover:block"
                >$75,000</span
              >
              <div
                class="relative flex h-12 w-full justify-center bg-indigo-200"
              ></div>
              <div
                class="relative flex h-8 w-full justify-center bg-indigo-300"
              ></div>
              <div
                class="relative flex h-40 w-full justify-center bg-indigo-400"
              ></div>
              <span class="absolute bottom-0 text-xs font-bold">Dec</span>
            </div>
          </div>
          <div class="mt-3 flex w-full">
            <div class="ml-auto flex items-center">
              <span class="block h-4 w-4 bg-indigo-400"></span>
              <span class="ml-1 text-xs font-medium">Existing</span>
            </div>
            <div class="ml-4 flex items-center">
              <span class="block h-4 w-4 bg-indigo-300"></span>
              <span class="ml-1 text-xs font-medium">Upgrades</span>
            </div>
            <div class="ml-4 flex items-center">
              <span class="block h-4 w-4 bg-indigo-200"></span>
              <span class="ml-1 text-xs font-medium">New</span>
            </div>
          </div>
        </div>
      </VCard>
    </div>

    <div class="p-3">
      <div class="grid w-full gap-6 md:grid-cols-2 lg:grid-cols-3">
        <VCard>
          <div class="flex items-center bg-white">
            <div
              class="flex h-16 w-16 flex-shrink-0 items-center justify-center rounded bg-green-200"
            >
              <svg
                class="h-6 w-6 fill-current text-green-700"
                fill="currentColor"
                viewBox="0 0 20 20"
                xmlns="http://www.w3.org/2000/svg"
              >
                <path
                  clip-rule="evenodd"
                  d="M3.293 9.707a1 1 0 010-1.414l6-6a1 1 0 011.414 0l6 6a1 1 0 01-1.414 1.414L11 5.414V17a1 1 0 11-2 0V5.414L4.707 9.707a1 1 0 01-1.414 0z"
                  fill-rule="evenodd"
                />
              </svg>
            </div>
            <div class="ml-4 flex flex-grow flex-col">
              <span class="text-xl font-bold">$8,430</span>
              <div class="flex items-center justify-between">
                <span class="text-gray-500">Revenue last 30 days</span>
                <span class="ml-2 text-sm font-semibold text-green-500"
                  >+12.6%</span
                >
              </div>
            </div>
          </div>
        </VCard>

        <VCard>
          <div class="flex items-center bg-white">
            <div
              class="flex h-16 w-16 flex-shrink-0 items-center justify-center rounded bg-red-200"
            >
              <svg
                class="h-6 w-6 fill-current text-red-700"
                fill="currentColor"
                viewBox="0 0 20 20"
                xmlns="http://www.w3.org/2000/svg"
              >
                <path
                  clip-rule="evenodd"
                  d="M16.707 10.293a1 1 0 010 1.414l-6 6a1 1 0 01-1.414 0l-6-6a1 1 0 111.414-1.414L9 14.586V3a1 1 0 012 0v11.586l4.293-4.293a1 1 0 011.414 0z"
                  fill-rule="evenodd"
                />
              </svg>
            </div>
            <div class="ml-4 flex flex-grow flex-col">
              <span class="text-xl font-bold">211</span>
              <div class="flex items-center justify-between">
                <span class="text-gray-500">Sales last 30 days</span>
                <span class="ml-2 text-sm font-semibold text-red-500"
                  >-8.1%</span
                >
              </div>
            </div>
          </div>
        </VCard>

        <VCard>
          <div class="flex items-center bg-white">
            <div
              class="flex h-16 w-16 flex-shrink-0 items-center justify-center rounded bg-green-200"
            >
              <svg
                class="h-6 w-6 fill-current text-green-700"
                fill="currentColor"
                viewBox="0 0 20 20"
                xmlns="http://www.w3.org/2000/svg"
              >
                <path
                  clip-rule="evenodd"
                  d="M3.293 9.707a1 1 0 010-1.414l6-6a1 1 0 011.414 0l6 6a1 1 0 01-1.414 1.414L11 5.414V17a1 1 0 11-2 0V5.414L4.707 9.707a1 1 0 01-1.414 0z"
                  fill-rule="evenodd"
                />
              </svg>
            </div>
            <div class="ml-4 flex flex-grow flex-col">
              <span class="text-xl font-bold">140</span>
              <div class="flex items-center justify-between">
                <span class="text-gray-500">Customers last 30 days</span>
                <span class="ml-2 text-sm font-semibold text-green-500"
                  >+28.4%</span
                >
              </div>
            </div>
          </div>
        </VCard>
      </div>
    </div>`,
  },
};

export default meta;
type Story = StoryObj<typeof VCard>;

export const Default: Story = {
  args: {
    title: "Card",
  },
};
