-- Adminer 4.6.3 MySQL dump

SET NAMES utf8;
SET time_zone = '+00:00';
SET foreign_key_checks = 0;
SET sql_mode = 'NO_AUTO_VALUE_ON_ZERO';

DROP TABLE IF EXISTS `sl_address`;
CREATE TABLE `sl_address` (
  `A_id` int(11) NOT NULL AUTO_INCREMENT,
  `A_mid` int(11) NOT NULL DEFAULT '0',
  `A_address` text NOT NULL,
  `A_name` text NOT NULL,
  `A_phone` text NOT NULL,
  `A_del` int(11) NOT NULL DEFAULT '0',
  `A_default` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`A_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `sl_address` (`A_id`, `A_mid`, `A_address`, `A_name`, `A_phone`, `A_del`, `A_default`) VALUES
(1,	3,	'北京市XX区XX路XX小区XX号楼XX单元XXXX号',	'张三',	'15555555555',	0,	0),
(2,	3,	'上海市XX区XX路XX小区XX号楼XX单元XXXX号',	'李四',	'13333333333',	0,	1),
(3,	12,	'555',	'555',	'555',	0,	0),
(4,	12,	'5345345aa',	'435345aa',	'34534aa',	0,	1);

DROP TABLE IF EXISTS `sl_admin`;
CREATE TABLE `sl_admin` (
  `A_id` int(11) NOT NULL AUTO_INCREMENT,
  `A_login` text NOT NULL,
  `A_pwd` text NOT NULL,
  `A_del` int(11) NOT NULL DEFAULT '0',
  `A_head` text NOT NULL,
  `A_part` varchar(500) DEFAULT NULL,
  PRIMARY KEY (`A_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `sl_admin` (`A_id`, `A_login`, `A_pwd`, `A_del`, `A_head`, `A_part`) VALUES
(1,	'admin',	'7fef6171469e80d32c0559f88b377245',	0,	'201911192123112i.jpg',	'A0_0:1,A1_0:1,A1_1:1,A1_2:1,A1_3:1,A1_4:1,A1_5:1,A2_0:1,A2_1:1,A2_2:1,A2_3:1,A3_0:1,A3_1:1,A3_2:1,A3_3:1,A3_4:1,A4_0:1,A4_1:1,A4_2:1,A5_0:1,A5_1:1,A5_2:1,A5_3:1,A6_0:1,');

DROP TABLE IF EXISTS `sl_card`;
CREATE TABLE `sl_card` (
  `C_id` int(11) NOT NULL AUTO_INCREMENT,
  `C_content` text NOT NULL,
  `C_use` int(11) NOT NULL DEFAULT '0',
  `C_sort` int(11) NOT NULL DEFAULT '0',
  `C_del` int(11) NOT NULL DEFAULT '0',
  `C_mid` int(11) DEFAULT '0',
  `C_type` int(11) DEFAULT '0',
  PRIMARY KEY (`C_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `sl_card` (`C_id`, `C_content`, `C_use`, `C_sort`, `C_del`, `C_mid`, `C_type`) VALUES
(35,	'Ei70HZQs0n4ifHdZuIR0rxdk97dEFIkz',	1,	3,	0,	0,	0),
(36,	'h3X88BkTMvD0ZPaJxJtEgKWOukfstRwr',	1,	3,	0,	0,	0),
(37,	'2oD2zsIQf9ESD75qrT7UsHBfVWaDTmht',	1,	3,	0,	0,	0),
(38,	'xifMiFcPTPxncHiaMsp4DW87sgJkIDMh',	1,	3,	0,	0,	0),
(39,	'lklbrQNHLnmQIV57t8HSSkQgFRwh9lui',	1,	3,	0,	0,	0),
(40,	'5ENZUlmhqb3aFyblLDE4Xr65KznzoBa5',	1,	3,	0,	0,	0),
(41,	'FTNptKMNaPOfNBIJszcQvm47LuDbDD3m',	1,	3,	0,	0,	0),
(42,	'LUnlWS4keCYfVkIvH8a99Fu4CHbatP3N',	1,	3,	0,	0,	0),
(43,	'55kAcFQvAkoUdi3ZCKgVbmJJt1gopve2',	1,	3,	0,	0,	0),
(44,	'EPxxRrLWieabGkbZAUvwTZ2Ald7GG7Sp',	0,	3,	0,	0,	0),
(45,	'OsbORCneoXmqoXKXXdmxBy0xX8839gMk',	0,	3,	0,	0,	0),
(46,	'ztPLx6A15QkX1qBlDc4c5XlS5WII2oRU',	0,	3,	0,	0,	0),
(47,	'NXrkObI4h1M05BCtSOPADpNMUBP5zONc',	0,	3,	0,	0,	0),
(48,	'Q7yh2WeuRY0WQz3VKhubwNizhZXiKJdl',	0,	3,	0,	0,	0),
(49,	'i8LN0ZK0qzpDX7Iga0KdpBvqpyyoqZKC',	0,	3,	0,	0,	0),
(50,	'2m85mKNseRb12jKZ30FjgRViSB0ucyrd',	0,	3,	0,	0,	0),
(51,	'ept9NraQeVGvsodAFOcH7L7aH5wXpWRP',	0,	3,	0,	0,	0),
(52,	'2epfQ1xPJuHFK4pRxAv7ehgHKKFCh1Mq',	0,	3,	0,	0,	0),
(53,	'HIeuWDrRoSp4OoVUE87uNKeiqRYxA2z7',	0,	3,	0,	0,	0),
(54,	'9HMYyAIwYAdEH1YHp1qcdfwaIQeTrPFV',	0,	3,	0,	0,	0),
(55,	'6qaZMLD7zTnzkOUEgbZrk9OqrD49uCwB',	0,	3,	0,	0,	0),
(56,	'Y73ZuQxhm1weUGMUnTYchtQ3dGz5TRaP',	0,	3,	0,	0,	0),
(57,	'bs2JlA1cfijk4lakYQBzz3PG96kKBKFj',	0,	3,	0,	0,	0),
(58,	'dD0XOexrzQnBVB3SFd0bfxkx7QijoBTY',	0,	3,	0,	0,	0),
(59,	'pdmglJucJBIka2r5EivlLhDQ2Ouqvv3o',	0,	3,	0,	0,	0),
(60,	'6vmMaLF5mkRhZW5epl548vOo49wSf0en',	0,	3,	0,	0,	0),
(61,	'wtR5MyQKIkFVArRx6F3UjjE79oF88bvQ',	0,	3,	0,	0,	0),
(62,	'WSZYCjEavxJvreHc8OiUDgLFzm60kfci',	0,	3,	0,	0,	0),
(63,	'OwrK7twkm31uP7YRUflS2BxU5DGGgNLe',	0,	3,	0,	0,	0),
(64,	'DrDbERTuc237qD0WIDvJP6hiXM9VAhXc',	0,	3,	0,	0,	0),
(65,	'TUmsMyO0hTm555xtPoK3EBuJkqbBYrGg',	0,	3,	0,	0,	0),
(66,	'0xH8cQk3IFS9SIqOG0xpDHT1C6GkrmUv',	0,	3,	0,	0,	0),
(67,	'xbyDmfHhF9mni84lCQuoaR0x9mnk96lr',	0,	3,	0,	0,	0),
(68,	'hi0mQEwSxOkJd4uyyja59WNd4ee22Ids',	0,	3,	0,	0,	0),
(69,	'jAlH9790FvZ2F6Y4Cnq9NOpc70XJ68DY',	0,	3,	0,	0,	0),
(70,	'lXgXNxPeIybXLpzqjfozCJleEpn89339',	0,	3,	0,	0,	0),
(71,	'QJQmoqrZg55oRUGIJTZFqPmF4MKr8Tez',	0,	3,	0,	0,	0),
(72,	'30Pr1rcQFhOuFpyhWu8iJupN4tytSW3q',	0,	3,	0,	0,	0),
(73,	'qNOBFLgxJgIOM9KsP2xTqgVXPnzQR8p0',	0,	3,	0,	0,	0),
(74,	'1kt4iYMeqyPsnr5h2kUViXLFhiJpgBYk',	0,	3,	0,	0,	0),
(75,	'AND0TyqmN72DcYW4tTMgnAc8nh1FJ7of',	0,	3,	0,	0,	0),
(76,	'SpRah8H3lKYTQS4VwWezq5kk18GnMX0N',	0,	3,	0,	0,	0),
(77,	'ngB5aNTwVYFUsv6mCnXJBNQFyKwLRUfX',	0,	3,	0,	0,	0),
(78,	'qLL3nn0V1niZOi3PlZougCSQFjO23c4o',	0,	3,	0,	0,	0),
(79,	'0DEcA84SJ6JKJkKk5eppSs1OdiYblzue',	0,	3,	0,	0,	0),
(80,	'GwuRqh8evj82Lt4XQDcdlMCaQvRRUIMt',	0,	3,	0,	0,	0),
(81,	'kvyoLXBuPZvCuZDe8HmD43ZUlaLsf5iL',	0,	3,	0,	0,	0),
(82,	'Ua3Qcdefwk14AtHy9dhRNcaGq6YpFR82',	0,	3,	0,	0,	0),
(83,	'W0dEs9yISIOyJPo4HXmd71HKcXquA7vh',	0,	3,	0,	0,	0),
(84,	'sWbQBlfIPCEH0HrrL9csT62997KMtGPs',	0,	3,	0,	0,	0),
(85,	'oVPgZWdYACjf7ZKakiFh1yXwJzMCW905',	0,	2,	0,	0,	0),
(86,	'7gb7Ioc6mgm9eYzfpSkuCeOrrrOyZqrr',	0,	2,	0,	0,	0),
(87,	'dahNGuyWwSFjX4edJTnZCzVy1BdPJweV',	0,	2,	0,	0,	0),
(88,	'0pweC2ElblmcCViFvmDjH3faVz2jBMcg',	0,	2,	0,	0,	0),
(89,	'kKjaGjg6NZ2UulpxEblikTGYs3d5fygU',	0,	2,	0,	0,	0),
(90,	'dv0vzSzuCPMmZem2xZyGOWE9L2aKT3Il',	0,	2,	0,	0,	0),
(91,	'2Y9YJu27z4ktnJ2i7QV6k0b5Knxvj3tY',	0,	2,	0,	0,	0),
(92,	'1JRlHZfycRUE4HFEPgv8yjAMy52nCtKM',	0,	2,	0,	0,	0),
(93,	'ryvwVgZ3AGU1Ui5n6enWG7V4Fzew3RrH',	0,	2,	0,	0,	0),
(94,	'9KcbHOx96l4hs6d35rBq26jM8pCb71CN',	0,	2,	0,	0,	0),
(95,	'5sfpYKvGBxeW69nDJInqrt9RzwQ9vjMs',	0,	2,	0,	0,	0),
(96,	'Uu0fADyYy0GXneFgyQ1TV97Tkjap6Y0X',	0,	2,	0,	0,	0),
(97,	'Qsp35SKXcNoEzfUnVAOkb0iwUNrhpoo4',	0,	2,	0,	0,	0),
(98,	'tsF7XuWAIFgsfoV6O1FR9Ej1i33PTE2q',	0,	2,	0,	0,	0),
(99,	'wCpELl3PuQws6LjnxSCH7VOkKPiJ5WpT',	0,	2,	0,	0,	0),
(100,	'zRMghA0Gr5yLX9Zoa8GUOKgxWWPsCdDf',	0,	2,	0,	0,	0),
(101,	'V5sbCFeAYjMEcoSKekUqoHeo7FxQRWM0',	0,	2,	0,	0,	0),
(102,	'CYMVoph97nqtRisjAO5eeMqnxF7d0Kgt',	0,	2,	0,	0,	0),
(103,	'NtBLVuqKaOb8Yh4GggZbB7cG6iC1HFv5',	0,	2,	0,	0,	0),
(104,	'7ZJl60t75WqSeDKNz5I41YZkeILBzwUM',	0,	2,	0,	0,	0),
(105,	'OKBfSl7fHGTDEot08s6pVGJvNMKG1CgG',	0,	2,	0,	0,	0),
(106,	'M808RfpDwhBRetckog2V9KqFoxEuapS9',	0,	2,	0,	0,	0),
(107,	'pwQv6XCCdJDVf43hdjN2MWohSYv3c7v8',	0,	2,	0,	0,	0),
(108,	'uFIdTfgMy04IyqqvZYFVfadV1YrkVi2C',	0,	2,	0,	0,	0),
(109,	'B5yfu4SbyidmC71Hqj40CyzM9vHFo5Fy',	0,	2,	0,	0,	0),
(110,	'7iHlgsN8P7QuPYz9lS8cOQVYEA9L0wRl',	0,	2,	0,	0,	0),
(111,	'cdAZf9dhcIKKCqbeKJ1hBVUxDQls6KMz',	0,	2,	0,	0,	0),
(112,	'acQ0BBYQhVRD2ttGO32hGzAsKgtzn5cp',	0,	2,	0,	0,	0),
(113,	'bOZ6hhWpiJnc65MVa0uKaVGB7553wBx1',	0,	2,	0,	0,	0),
(114,	'zksbjG0sgynReym1Iuk3td7PSpMMaMJs',	0,	2,	0,	0,	0),
(115,	'tEdVLueHTj9SoebBQNksKN5F74vIKxKR',	0,	2,	0,	0,	0),
(116,	'bmSG0yq4ytekqlH86gItJIWk3lzb2g7X',	0,	2,	0,	0,	0),
(117,	'JqDH5WRcx0gsgAkWAaJut8mibOLa8XEd',	0,	2,	0,	0,	0),
(118,	'rqTdh5vZQfqrSJApsC3xxbZFFjF2GdUM',	0,	2,	0,	0,	0),
(119,	'uuO8rBLgStOVU8yize3suucJ8aTfvqCR',	0,	2,	0,	0,	0),
(120,	'YBvcUrXI3dw52dZ15hP7opko31XWmRqO',	0,	2,	0,	0,	0),
(121,	'naWYgS2hGqZeQcv6NsCAWrGwuxWsIpsY',	0,	2,	0,	0,	0),
(122,	'MzzigFCpvj4pIRR8rVMZI1canDmXKyZb',	0,	2,	0,	0,	0),
(123,	'GQT9SXllYuSzNzM6jOE6RGyItiTM6DOu',	0,	2,	0,	0,	0),
(124,	'tHPjSGYAH642sbd5rlSifAzYlfQaCo3j',	0,	2,	0,	0,	0),
(125,	'G98GBsTuiUwKeACKfx2JwipyOsEWA7CQ',	0,	2,	0,	0,	0),
(126,	'Wg9AcU6ButQhgvBlOp8XLoBPEgnEC4Wg',	0,	2,	0,	0,	0),
(127,	'GyxjWCAUZi6Zh6uNi56QER402Gwl3wF3',	0,	2,	0,	0,	0),
(128,	'HkRhLNPUWePJBAir6OubDfnpZ7nEYiM1',	0,	2,	0,	0,	0),
(129,	'rJigda2CXSF4LNVQ6CHfOKegPdZQx9Ee',	0,	2,	0,	0,	0),
(130,	'035epq4rZY0DiiUJq3F6Rh3FgO2LRoGQ',	0,	2,	0,	0,	0),
(131,	'9JGhhgy9mtZ3qyI5jdPy3qzFAF46UXHW',	0,	2,	0,	0,	0),
(132,	'mdqPfTrb54LepdqdgVwp7SytkF1K8en1',	0,	2,	0,	0,	0),
(133,	'wueKXr9fYshcD9QDEwQ9OVxDl6V48cwO',	0,	2,	0,	0,	0),
(134,	'WDs0apJWMBgkGP0zGSKEKLhZvMVzmm9P',	0,	2,	0,	0,	0),
(135,	'lwDhLEpjqVWF0NRzvnyWbS5htNfzb6ff',	1,	1,	0,	0,	0),
(136,	'TXkQnW5zzvbw0q8saweCOdDBV1ZdfBqz',	0,	1,	0,	0,	0),
(137,	'79WIWRHYHod8g1XhDpEIMviYHFw0OPXl',	0,	1,	0,	0,	0),
(138,	'tU5sIDPsyIgHzro1IGQEG1ejGfy5JQ0x',	0,	1,	0,	0,	0),
(139,	'O71AS64w1KjLSxAPMz5p78b4uv3Q2flK',	0,	1,	0,	0,	0),
(140,	'mZiONYCptyroOY5CJQSvfuAGnSEmK1BH',	0,	1,	0,	0,	0),
(141,	'kjKiH8C3pDoIfPNYJQjdobJQQSDISYkN',	0,	1,	0,	0,	0),
(142,	'YONlyUTWdJShHR5l4DvVhEGbQ4APkVow',	0,	1,	0,	0,	0),
(143,	'IWDdIeB19pYtO77k0pKKfpV4uRbsuMcS',	0,	1,	0,	0,	0),
(144,	'VyuzLW6aLNmlHEi4mPb9GQn4eP8WA1Kk',	0,	1,	0,	0,	0),
(145,	'uWUtck9lrQT0UOXmYxF8lWX6PzNfux18',	0,	1,	0,	0,	0),
(146,	'oiezOfduDxqTt4IaMfClX0LgFz9tHNLl',	0,	1,	0,	0,	0),
(147,	'AyNqDMCVJr01hwziz5MdOSbLVNb4qHPB',	0,	1,	0,	0,	0),
(148,	'IdZHsKnk4wLH4JdDEM31zUFGYXH1k7G1',	0,	1,	0,	0,	0),
(149,	'eG4QrNO60L9LVr0MznwjUyQtDfqOffwc',	0,	1,	0,	0,	0),
(150,	'jqpb6PKxFl8rk9j8pHu5cKXNJJXn5kYP',	0,	1,	0,	0,	0),
(151,	'QDuVPqNpJpieHuF9C2ygQUJiUQgAyXzs',	0,	1,	0,	0,	0),
(152,	'lEnmvD0aZRifPigSTE68l7aCE3eLBBL6',	0,	1,	0,	0,	0),
(153,	'Rh9HdjoUtA3AmZwhhsGOaSLW8MqKQhJ4',	0,	1,	0,	0,	0),
(154,	'9eyauqQ8dF1T3o2cSvqbPK72yVrfpgM9',	0,	1,	0,	0,	0),
(155,	'DJpYdUlPlphzXGWIJMnLAzNCARsIrZXk',	0,	1,	0,	0,	0),
(156,	'hUTyUz5PUYJvNZLnTWyXtPllWXyxLskN',	0,	1,	0,	0,	0),
(157,	'SFnPw7ZRG9pE6fhfKurjHfh0cu8aWXiK',	0,	1,	0,	0,	0),
(158,	'P4RuddnfhFVkQUEhVf1YqpoCFBet1ggc',	0,	1,	0,	0,	0),
(159,	'28Fcv21lp7rS6Sb8Q90kFt4IDWcbdtC0',	0,	1,	0,	0,	0),
(160,	'K4MJbMieShWTiBQs9mThhb33qn9ZVVRm',	0,	1,	0,	0,	0),
(161,	'HJb4mJx8S2FvHNOjw3gHkVgasutDpyJ4',	0,	1,	0,	0,	0),
(162,	'UslnRpOwiPw2A3d7CwK2rcvPE0jzB8QD',	0,	1,	0,	0,	0),
(163,	'jnRoNwhqj0nhvaQGNqEtMUIBsNRBTKki',	0,	1,	0,	0,	0),
(164,	'I4j7RXWh9931UNHWCPliqzFcUVBagZs5',	0,	1,	0,	0,	0),
(165,	'zJapiWXiCvQW5da5IzIMJT87Rk9QQ1cw',	0,	1,	0,	0,	0),
(166,	'rgMSXAWesfA6HOyenUOoLGw2ytMJdygL',	0,	1,	0,	0,	0),
(167,	'etxdnOK2HytdHUyLe7Nu4aYxAheaYf24',	0,	1,	0,	0,	0),
(168,	'uhVuVSsvlD8AKQfdpQsAaPKdsySuXFg3',	0,	1,	0,	0,	0),
(169,	'X2I1hN1bfgtX1284Km0QkDNw4xyUgAF6',	0,	1,	0,	0,	0),
(170,	'5joWzCgpcPJZmfW75OzweJ3jgD9lOHbW',	0,	1,	0,	0,	0),
(171,	'7YRwcZyXJ5A9bRy5UKa9h6VDvrmb6q3n',	0,	1,	0,	0,	0),
(172,	'DNUe5cAxnT1uHsdNWlZ6SVe47dthxIy0',	0,	1,	0,	0,	0),
(173,	'DICKIBJZGy4y3kI5IvgGVC21rcu23BTh',	0,	1,	0,	0,	0),
(174,	'zKPGRyk8VYZ9YHEXs3pj9U8YiYOQB46u',	0,	1,	0,	0,	0),
(175,	'ukOr9tBiHjQFcEGienEFdvEQxSghj5Tw',	0,	1,	0,	0,	0),
(176,	'5QeUGYOFkMN62EzAXUfeAUNHh85Z6fep',	0,	1,	0,	0,	0),
(177,	'XnE4MGCy3lwcXf1NoK531l0gOnu87Ife',	0,	1,	0,	0,	0),
(178,	'Dv4K4l0JTdRyeVlsVRG3kH91Yq8xNj3t',	0,	1,	0,	0,	0),
(179,	'u1siu5FCgIpPmTgcitzmmMI37lRIdwqX',	0,	1,	0,	0,	0),
(180,	'TZmylJPJKMIVhff53KQdXI52cZdOX9Ma',	0,	1,	0,	0,	0),
(181,	'bqO9hMyBcSIqtFNnIee1UDXOXi3dEKLf',	0,	1,	0,	0,	0),
(182,	'6mCsvZ4tqfYJOzEzYJkVuesuOgg9fW5m',	0,	1,	0,	0,	0),
(183,	'OtwgZdXh5DT7xvOQlLESvPPzafQdzxMu',	0,	1,	0,	0,	0),
(184,	'Ruj4kqjXvHTVPdXtOEYoTb5gcVXqiY1O',	0,	1,	0,	0,	0);

DROP TABLE IF EXISTS `sl_colletion`;
CREATE TABLE `sl_colletion` (
  `C_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `C_type` int(10) DEFAULT '0',
  `C_cid` int(10) DEFAULT '0',
  `C_mid` int(10) DEFAULT '0',
  PRIMARY KEY (`C_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `sl_config`;
CREATE TABLE `sl_config` (
  `C_id` int(11) NOT NULL AUTO_INCREMENT,
  `C_title` text NOT NULL,
  `C_keyword` text NOT NULL,
  `C_description` text NOT NULL,
  `C_copyright` text NOT NULL,
  `C_code` text NOT NULL,
  `C_alipay_pid` text NOT NULL,
  `C_alipay_pkey` text NOT NULL,
  `C_wx_appid` text NOT NULL,
  `C_wx_appsecret` text NOT NULL,
  `C_wx_mchid` text NOT NULL,
  `C_wx_key` text NOT NULL,
  `C_7pay_pid` text NOT NULL,
  `C_7pay_pkey` text NOT NULL,
  `C_logo` text NOT NULL,
  `C_ico` text NOT NULL,
  `C_vip1` decimal(10,2) NOT NULL DEFAULT '0.00',
  `C_vip2` decimal(10,2) NOT NULL DEFAULT '0.00',
  `C_vip3` decimal(10,2) NOT NULL DEFAULT '0.00',
  `C_vip6` decimal(10,2) NOT NULL DEFAULT '0.00',
  `C_vip12` decimal(10,2) NOT NULL DEFAULT '0.00',
  `C_vip0` decimal(10,2) NOT NULL DEFAULT '0.00',
  `C_p_discount` decimal(10,2) DEFAULT NULL,
  `C_n_discount` decimal(10,2) DEFAULT NULL,
  `C_alipayon` int(11) NOT NULL DEFAULT '0',
  `C_wxpayon` int(11) NOT NULL DEFAULT '0',
  `C_alicodeon` int(11) NOT NULL DEFAULT '0',
  `C_wxcodeon` int(11) NOT NULL DEFAULT '0',
  `C_kefu` text NOT NULL,
  `C_template` text NOT NULL,
  `C_qrcode` text NOT NULL,
  `C_email` text NOT NULL,
  `C_phone` text NOT NULL,
  `C_beian` text NOT NULL,
  `C_alicode` text NOT NULL,
  `C_wxcode` text NOT NULL,
  `C_qqid` text NOT NULL,
  `C_qqkey` text NOT NULL,
  `C_qqon` int(11) NOT NULL DEFAULT '0',
  `C_wxon` int(11) NOT NULL DEFAULT '0',
  `C_authcode` text NOT NULL,
  `C_7payon` int(11) DEFAULT '0',
  `C_rzon` int(11) DEFAULT '0',
  `C_fee` int(11) DEFAULT '0',
  `C_html` int(11) DEFAULT '0',
  `C_mailtype` int(11) DEFAULT '0',
  `C_mailcode` varchar(200) DEFAULT NULL,
  `C_smtp` varchar(200) DEFAULT NULL,
  `C_wxapp_id` varchar(200) DEFAULT NULL,
  `C_wxapp_key` varchar(200) DEFAULT NULL,
  `C_aliapp_id` varchar(200) DEFAULT NULL,
  `C_aliapp_key` varchar(200) DEFAULT NULL,
  `C_aliapp_key2` varchar(200) DEFAULT NULL,
  `C_bdapp_id` varchar(200) DEFAULT NULL,
  `C_bdapp_key` varchar(200) DEFAULT NULL,
  `C_bdapp_key2` varchar(200) DEFAULT NULL,
  `C_qqapp_id` varchar(200) DEFAULT NULL,
  `C_qqapp_key` varchar(200) DEFAULT NULL,
  `C_zjapp_id` varchar(200) DEFAULT NULL,
  `C_zjapp_key` varchar(200) DEFAULT NULL,
  `C_appt` varchar(200) DEFAULT NULL,
  `C_fx1` int(11) DEFAULT '0',
  `C_fx2` int(11) DEFAULT '0',
  `C_fx3` int(11) DEFAULT '0',
  `C_codepayon` int(11) DEFAULT '0',
  `C_codepay_id` varchar(200) DEFAULT NULL,
  `C_codepay_key` varchar(200) DEFAULT NULL,
  `C_p_discount2` decimal(10,2) DEFAULT NULL,
  `C_n_discount2` decimal(10,2) DEFAULT NULL,
  `C_memberon` int(11) DEFAULT '0',
  `C_rzfee` decimal(10,2) DEFAULT NULL,
  `C_wap` varchar(200) DEFAULT NULL,
  `C_zd` decimal(10,2) DEFAULT NULL,
  `C_rzfeetype` int(11) DEFAULT '0',
  `C_pwdcode` varchar(200) DEFAULT NULL,
  `C_twice` int(11) DEFAULT '0',
  `C_uncopy` int(11) DEFAULT '0',
  `C_slide` int(11) DEFAULT '0',
  `C_backup` int(11) DEFAULT '0',
  `C_mobile` varchar(200) DEFAULT NULL,
  `C_smssign` varchar(200) DEFAULT NULL,
  `C_userid` varchar(200) DEFAULT NULL,
  `C_codeid` varchar(200) DEFAULT NULL,
  `C_codekey` varchar(200) DEFAULT NULL,
  `C_payjson` int(11) DEFAULT '0',
  `C_payjs_id` varchar(200) DEFAULT NULL,
  `C_payjs_key` varchar(200) DEFAULT NULL,
  `C_kefuon` int(11) DEFAULT '0',
  `C_punsh` int(11) DEFAULT '0',
  `C_nunsh` int(11) DEFAULT '0',
  `C_dxon` int(11) DEFAULT '0',
  `C_notice` varchar(500) DEFAULT NULL,
  `C_admin` varchar(200) DEFAULT NULL,
  `C_dx1` int(11) DEFAULT '0',
  `C_dx2` int(11) DEFAULT '0',
  `C_dx3` int(11) DEFAULT '0',
  `C_dx4` int(11) DEFAULT '0',
  `C_dx5` int(11) DEFAULT '0',
  `C_hotwords` varchar(200) DEFAULT NULL,
  `C_dmfon` int(11) DEFAULT '0',
  `C_dmf_id` varchar(200) DEFAULT NULL,
  `C_dmf_key` varchar(2000) DEFAULT NULL,
  `C_dmf_key2` varchar(2000) DEFAULT NULL,
  `C_osson` int(11) DEFAULT '0',
  `C_oss_id` varchar(200) DEFAULT NULL,
  `C_oss_key` varchar(200) DEFAULT NULL,
  `C_bucket` varchar(200) DEFAULT NULL,
  `C_region` varchar(200) DEFAULT NULL,
  `C_m_logo` varchar(200) DEFAULT NULL,
  `C_m_position` int(11) DEFAULT '0',
  `C_m_width` int(11) DEFAULT '0',
  `C_m_height` int(11) DEFAULT '0',
  `C_m_transparent` int(11) DEFAULT '0',
  `C_regon` int(11) DEFAULT '0',
  `C_oss_domain` varchar(200) DEFAULT NULL,
  `C_fzon` int(11) DEFAULT '0',
  `C_fdomain` varchar(200) DEFAULT NULL,
  `C_fzk` int(11) DEFAULT '0',
  `C_format` varchar(500) DEFAULT NULL,
  `C_codepay_type` varchar(200) DEFAULT NULL,
  `C_bd_token` varchar(200) DEFAULT NULL,
  `C_fzvip` int(11) DEFAULT '0',
  `C_qpayon` int(11) DEFAULT '0',
  `C_qpay_appid` varchar(200) DEFAULT NULL,
  `C_qpay_mchid` varchar(200) DEFAULT NULL,
  `C_qpay_key` varchar(200) DEFAULT NULL,
  `C_ttpay_appid` varchar(200) DEFAULT NULL,
  `C_ttpay_mchid` varchar(200) DEFAULT NULL,
  `C_ttpay_secret` varchar(200) DEFAULT NULL,
  `C_epay_url` varchar(200) DEFAULT NULL,
  `C_epay_id` varchar(200) DEFAULT NULL,
  `C_epay_key` varchar(200) DEFAULT NULL,
  `C_epay_type` varchar(200) DEFAULT NULL,
  `C_kd` varchar(200) DEFAULT NULL,
  `C_zzk` int(11) DEFAULT '0',
  `C_c_discount` decimal(10,2) DEFAULT '0.00',
  `C_c_discount2` decimal(10,2) DEFAULT '0.00',
  `C_regr` varchar(200) DEFAULT NULL,
  `C_fen1` int(11) DEFAULT '0',
  `C_fen2` int(11) DEFAULT '0',
  `C_fen3` decimal(10,2) DEFAULT '0.00',
  `C_baoyou` decimal(10,2) DEFAULT '0.00',
  `C_postage` decimal(10,2) DEFAULT '0.00',
  `C_qqon2` int(11) DEFAULT '0',
  `C_wxon2` int(11) DEFAULT '0',
  `C_newsds` text,
  `C_buylimit` int(11) DEFAULT '0',
  `C_viplimit` int(11) DEFAULT '0',
  `C_cache` int(11) DEFAULT '0',
  `C_freetimes1` int(11) DEFAULT '0',
  `C_freetimes2` int(11) DEFAULT '0',
  `C_freetimes3` int(11) DEFAULT '0',
  `C_bondtype` int(11) DEFAULT '0',
  `C_bond` decimal(10,2) DEFAULT '0.00',
  `C_rate` decimal(10,2) DEFAULT '0.00',
  `C_paypal` text,
  `C_paypalon` int(11) DEFAULT '0',
  `C_money` text,
  `C_alipaynewon` int(11) DEFAULT '0',
  `C_reuseid` int(11) DEFAULT '0',
  `C_hupay_id` text,
  `C_hupay_key` text,
  `C_hupay_id2` text,
  `C_hupay_key2` text,
  `C_hupay_type` text,
  `C_jipay_id` text,
  `C_jipay_key` text,
  `C_jipay_type` text,
  `C_alipaynewid` text,
  `C_alipaynewkey` text,
  `C_alipaynewkey2` text,
  `C_payjs_type` text,
  `C_payjs_id2` text,
  `C_payjs_key2` text,
  PRIMARY KEY (`C_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `sl_config` (`C_id`, `C_title`, `C_keyword`, `C_description`, `C_copyright`, `C_code`, `C_alipay_pid`, `C_alipay_pkey`, `C_wx_appid`, `C_wx_appsecret`, `C_wx_mchid`, `C_wx_key`, `C_7pay_pid`, `C_7pay_pkey`, `C_logo`, `C_ico`, `C_vip1`, `C_vip2`, `C_vip3`, `C_vip6`, `C_vip12`, `C_vip0`, `C_p_discount`, `C_n_discount`, `C_alipayon`, `C_wxpayon`, `C_alicodeon`, `C_wxcodeon`, `C_kefu`, `C_template`, `C_qrcode`, `C_email`, `C_phone`, `C_beian`, `C_alicode`, `C_wxcode`, `C_qqid`, `C_qqkey`, `C_qqon`, `C_wxon`, `C_authcode`, `C_7payon`, `C_rzon`, `C_fee`, `C_html`, `C_mailtype`, `C_mailcode`, `C_smtp`, `C_wxapp_id`, `C_wxapp_key`, `C_aliapp_id`, `C_aliapp_key`, `C_aliapp_key2`, `C_bdapp_id`, `C_bdapp_key`, `C_bdapp_key2`, `C_qqapp_id`, `C_qqapp_key`, `C_zjapp_id`, `C_zjapp_key`, `C_appt`, `C_fx1`, `C_fx2`, `C_fx3`, `C_codepayon`, `C_codepay_id`, `C_codepay_key`, `C_p_discount2`, `C_n_discount2`, `C_memberon`, `C_rzfee`, `C_wap`, `C_zd`, `C_rzfeetype`, `C_pwdcode`, `C_twice`, `C_uncopy`, `C_slide`, `C_backup`, `C_mobile`, `C_smssign`, `C_userid`, `C_codeid`, `C_codekey`, `C_payjson`, `C_payjs_id`, `C_payjs_key`, `C_kefuon`, `C_punsh`, `C_nunsh`, `C_dxon`, `C_notice`, `C_admin`, `C_dx1`, `C_dx2`, `C_dx3`, `C_dx4`, `C_dx5`, `C_hotwords`, `C_dmfon`, `C_dmf_id`, `C_dmf_key`, `C_dmf_key2`, `C_osson`, `C_oss_id`, `C_oss_key`, `C_bucket`, `C_region`, `C_m_logo`, `C_m_position`, `C_m_width`, `C_m_height`, `C_m_transparent`, `C_regon`, `C_oss_domain`, `C_fzon`, `C_fdomain`, `C_fzk`, `C_format`, `C_codepay_type`, `C_bd_token`, `C_fzvip`, `C_qpayon`, `C_qpay_appid`, `C_qpay_mchid`, `C_qpay_key`, `C_ttpay_appid`, `C_ttpay_mchid`, `C_ttpay_secret`, `C_epay_url`, `C_epay_id`, `C_epay_key`, `C_epay_type`, `C_kd`, `C_zzk`, `C_c_discount`, `C_c_discount2`, `C_regr`, `C_fen1`, `C_fen2`, `C_fen3`, `C_baoyou`, `C_postage`, `C_qqon2`, `C_wxon2`, `C_newsds`, `C_buylimit`, `C_viplimit`, `C_cache`, `C_freetimes1`, `C_freetimes2`, `C_freetimes3`, `C_bondtype`, `C_bond`, `C_rate`, `C_paypal`, `C_paypalon`, `C_money`, `C_alipaynewon`, `C_reuseid`, `C_hupay_id`, `C_hupay_key`, `C_hupay_id2`, `C_hupay_key2`, `C_hupay_type`, `C_jipay_id`, `C_jipay_key`, `C_jipay_type`, `C_alipaynewid`, `C_alipaynewkey`, `C_alipaynewkey2`, `C_payjs_type`, `C_payjs_id2`, `C_payjs_key2`) VALUES
(1,	'您的网站名称',	'虚拟商品,自动发货,在线支付,付费阅读',	'发货100-虚拟商品自动发货系统',	'Copyright © 2014-2017 淄博闪灵网络科技有限公司 版权所有',	'',	'',	'',	'',	'',	'',	'',	'',	'',	'20191202214409zX.png',	'20191208113035eM.ico',	10.00,	20.00,	30.00,	60.00,	120.00,	999.00,	9.00,	5.00,	1,	1,	0,	0,	'123123123_qq_售前咨询|taobao_ww_售后服务|010-10086_phone_代理咨询',	't16',	'20191126224352Wf.jpg',	'',	'010-10086',	'鲁ICP备15015137号-2 ',	'',	'',	'',	'',	0,	0,	'',	0,	0,	10,	0,	0,	'',	'',	'',	'',	'',	'',	'',	'',	'',	'',	'',	'',	'',	'',	'shop',	0,	0,	0,	0,	'',	'',	1.00,	1.00,	1,	100.00,	't16',	100.00,	0,	'774123',	1,	0,	1,	1,	'',	'',	'0',	'',	'',	0,	'',	'',	1,	0,	0,	0,	'',	'admin',	0,	0,	0,	0,	0,	'点卡,教程,源码',	0,	'',	'',	'',	0,	'',	'',	'',	'',	'20191202214409zX.png',	0,	100,	0,	50,	1,	'',	0,	'fhdemo.s-cms.cn',	0,	'jpg,jpeg,png,gif,bmp,ico,xls,xlsx,txt,sql,csv,mp4,rar,apk,doc',	'',	'',	30,	0,	'',	'',	'',	'',	'',	'',	'',	'',	'',	'',	'',	0,	8.00,	2.00,	'email',	1,	1,	0.01,	99.00,	10.00,	0,	0,	'',	0,	0,	0,	0,	0,	0,	0,	0.00,	6.00,	'',	0,	'',	0,	0,	'',	'',	'',	'',	'alipay,wxpay',	'',	'',	'alipay,wxpay',	'',	'',	'',	'alipay,wxpay',	'',	'');

DROP TABLE IF EXISTS `sl_course`;
CREATE TABLE `sl_course` (
  `C_id` int(11) NOT NULL AUTO_INCREMENT,
  `C_title` text NOT NULL,
  `C_pic` text NOT NULL,
  `C_lesson` text NOT NULL,
  `C_time` datetime NOT NULL,
  `C_price` decimal(10,2) NOT NULL DEFAULT '0.00',
  `C_content` text NOT NULL,
  `C_order` int(11) NOT NULL DEFAULT '0',
  `C_del` int(11) NOT NULL DEFAULT '0',
  `C_sort` int(11) NOT NULL,
  `C_top` int(11) NOT NULL DEFAULT '0',
  `C_view` int(11) NOT NULL DEFAULT '0',
  `C_author` text NOT NULL,
  `C_mid` int(11) NOT NULL DEFAULT '0',
  `C_sh` int(11) NOT NULL DEFAULT '1',
  `C_shuxing` text NOT NULL,
  PRIMARY KEY (`C_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `sl_csort`;
CREATE TABLE `sl_csort` (
  `S_id` int(11) NOT NULL AUTO_INCREMENT,
  `S_title` text NOT NULL,
  `S_del` int(11) NOT NULL DEFAULT '0',
  `S_content` text NOT NULL,
  `S_mid` int(11) DEFAULT '0',
  `S_order` int(11) DEFAULT '0',
  `S_sub` int(11) DEFAULT '0',
  PRIMARY KEY (`S_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `sl_csort` (`S_id`, `S_title`, `S_del`, `S_content`, `S_mid`, `S_order`, `S_sub`) VALUES
(1,	'点卡充值',	0,	'',	0,	0,	9999),
(2,	'VIP会员帐号',	0,	'121212',	0,	0,	9999),
(3,	'激活码',	0,	'12',	0,	0,	9999),
(9999,	'主分类',	0,	'主分类',	0,	0,	0);

DROP TABLE IF EXISTS `sl_evaluate`;
CREATE TABLE `sl_evaluate` (
  `E_id` int(11) NOT NULL AUTO_INCREMENT,
  `E_mid` int(11) NOT NULL DEFAULT '0',
  `E_content` text NOT NULL,
  `E_oid` int(11) NOT NULL DEFAULT '0',
  `E_time` datetime NOT NULL,
  `E_reply` text NOT NULL,
  `E_del` int(11) NOT NULL DEFAULT '0',
  `E_star` int(11) NOT NULL DEFAULT '5',
  PRIMARY KEY (`E_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `sl_evaluate` (`E_id`, `E_mid`, `E_content`, `E_oid`, `E_time`, `E_reply`, `E_del`, `E_star`) VALUES
(1,	3,	'产品非常好',	28,	'2019-12-10 10:49:16',	'谢谢您的购买',	0,	5),
(2,	3,	'调然后柔荑花的个人复合弓的鬼地方',	29,	'2019-12-10 11:27:37',	'2222',	0,	5),
(3,	3,	'123123',	28,	'2019-12-10 15:00:34',	'现在的保罗打球进入了另一个境界，身体状态的下滑已无法避免，可保罗对场上局势的判断和清晰的头脑一直没变，在击败森林狼的比赛中保罗抓住对手延误比赛的机会帮助球队加上取胜，在对阵开拓者的比赛中同样指了安东尼一个技术犯规，在进攻端或许保罗已经无法攻城拔寨，但只要他在场就一定会给球队做出贡献。',	0,	5),
(4,	3,	'11122333',	26,	'0000-00-00 00:00:00',	'',	0,	3);

DROP TABLE IF EXISTS `sl_guestbook`;
CREATE TABLE `sl_guestbook` (
  `G_id` int(11) NOT NULL AUTO_INCREMENT,
  `G_name` text NOT NULL,
  `G_title` text NOT NULL,
  `G_phone` text NOT NULL,
  `G_msg` text NOT NULL,
  `G_sh` int(11) NOT NULL DEFAULT '0',
  `G_mail` text NOT NULL,
  `G_del` int(11) NOT NULL DEFAULT '0',
  `G_time` datetime NOT NULL,
  `G_reply` text NOT NULL,
  PRIMARY KEY (`G_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `sl_guestbook` (`G_id`, `G_name`, `G_title`, `G_phone`, `G_msg`, `G_sh`, `G_mail`, `G_del`, `G_time`, `G_reply`) VALUES
(1,	'2',	'1',	'15555555555',	'44',	0,	'',	0,	'2019-12-08 11:22:42',	'12121212');

DROP TABLE IF EXISTS `sl_history`;
CREATE TABLE `sl_history` (
  `H_id` int(11) NOT NULL AUTO_INCREMENT,
  `H_hid` int(11) NOT NULL DEFAULT '0',
  `H_hid2` int(11) NOT NULL DEFAULT '0',
  `H_type` int(11) NOT NULL DEFAULT '0',
  `H_mid` int(11) NOT NULL DEFAULT '0',
  `H_time` datetime DEFAULT NULL,
  PRIMARY KEY (`H_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;


DROP TABLE IF EXISTS `sl_link`;
CREATE TABLE `sl_link` (
  `L_id` int(11) NOT NULL AUTO_INCREMENT,
  `L_title` text NOT NULL,
  `L_link` text NOT NULL,
  `L_pic` text NOT NULL,
  `L_order` int(11) NOT NULL DEFAULT '0',
  `L_del` int(11) NOT NULL DEFAULT '0',
  `L_content` text NOT NULL,
  PRIMARY KEY (`L_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `sl_link` (`L_id`, `L_title`, `L_link`, `L_pic`, `L_order`, `L_del`, `L_content`) VALUES
(1,	'微信对话生成器',	'https://www.baituling.com',	'20220513/20220513222753Mc.png',	5,	0,	'微信对话生成器'),
(2,	'腾讯',	'http://www.qq.com',	'20191120222606G6.png',	1,	0,	''),
(4,	'新浪',	'http://www.sina.com',	'20191120223409Ld.png',	3,	0,	''),
(5,	'淘宝网',	'http://www.taobao.com',	'20191203142808Og.png',	2,	0,	'淘宝网'),
(6,	'360搜索',	'http://www.so.com',	'201912031428507G.png',	4,	0,	'360搜索'),
(7,	'企业建站系统',	'https://shanling.top',	'scms.png',	4,	0,	'企业建站系统'),
(8,	'发货100',	'http://fahuo100.cn',	'20191203142923qI.png',	6,	0,	'发货100');

DROP TABLE IF EXISTS `sl_list`;
CREATE TABLE `sl_list` (
  `L_id` int(11) NOT NULL AUTO_INCREMENT,
  `L_mid` int(11) NOT NULL DEFAULT '0',
  `L_no` text NOT NULL,
  `L_title` text NOT NULL,
  `L_money` decimal(10,2) NOT NULL DEFAULT '0.00',
  `L_del` int(11) NOT NULL DEFAULT '0',
  `L_time` datetime NOT NULL,
  `L_genkey` text NOT NULL,
  `L_sh` int(11) DEFAULT '1',
  `L_no2` varchar(200) DEFAULT NULL,
  `L_type` int(11) DEFAULT '0',
  PRIMARY KEY (`L_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `sl_list` (`L_id`, `L_mid`, `L_no`, `L_title`, `L_money`, `L_del`, `L_time`, `L_genkey`, `L_sh`, `L_no2`, `L_type`) VALUES
(14,	3,	'2019120116130010694885',	'购买商品-windows10正版激活码',	-50.00,	0,	'2019-12-01 16:13:00',	'',	1,	'',	0),
(15,	3,	'2019120116165372396850',	'购买商品-windows10正版激活码',	-180.00,	0,	'2019-12-01 16:16:53',	'',	1,	'',	0),
(16,	3,	'2019120119375484393920',	'阅读付费文章-斥资3.5亿 亨得利首次布局XX钟表2',	-1.00,	0,	'2019-12-01 19:37:54',	'',	1,	'',	0),
(17,	3,	'2019120200230970206084',	'阅读付费文章-共享单车的印度崛起：东方不亮西方亮？',	-0.02,	0,	'2019-12-02 00:23:09',	'',	1,	'',	0),
(18,	3,	'2019120200232641988067',	'购买商品-windows10正版激活码',	-100.00,	0,	'2019-12-02 00:23:26',	'',	1,	'',	0),
(19,	3,	'2019120208300140523467',	'购买商品-windows10正版激活码',	-100.00,	0,	'2019-12-02 08:30:01',	'',	1,	'',	0),
(20,	9,	'4200000465201912020604164980',	'帐号充值',	0.10,	0,	'2019-12-02 10:49:54',	'',	1,	'',	0),
(21,	11,	'2019120222001418110526796245',	'帐号充值',	0.10,	0,	'2019-12-02 12:14:45',	'',	1,	'',	0),
(22,	11,	'4200000465201912020137933601',	'帐号充值',	0.10,	0,	'2019-12-02 12:30:30',	'2',	1,	'',	0),
(23,	11,	'4200000468201912023846155876',	'帐号充值',	0.10,	0,	'2019-12-02 12:32:50',	'tMBgP9KufsylFkwAUcxW',	1,	'',	0),
(24,	11,	'2019120308004425117963',	'阅读付费文章-共享单车的印度崛起：东方不亮西方亮？',	-0.02,	0,	'2019-12-03 08:00:44',	'',	1,	'',	0),
(25,	3,	'2019120509135987579956',	'阅读付费文章-滴滴“官宣”巨亏——是卖惨，还是真难',	-1.00,	0,	'2019-12-05 09:13:59',	'',	1,	'',	0),
(26,	3,	'2019120509154543750000',	'阅读付费文章-抖音运营团队：抖音运营思维攻略',	-1.00,	0,	'2019-12-05 09:15:45',	'',	1,	'',	0),
(27,	3,	'2019120518454468798828',	'积分转余额',	1.00,	0,	'2019-12-05 18:45:44',	'',	1,	'',	0),
(28,	3,	'2019120519570612757568',	'阅读付费文章-咪蒙关停，靠“伪女权”挣钱还能撑多久',	-1.00,	0,	'2019-12-05 19:57:06',	'',	1,	'',	0),
(29,	3,	'2019120519590588370971',	'购买商品-短域名、缩短网址生成网站系统源码 可自行广告位',	-50.00,	0,	'2019-12-05 19:59:05',	'',	1,	'',	0),
(30,	3,	'2019120713381638050842',	'阅读付费文章-区块链未死！2019区块链+农业或将浴火重生',	-1.00,	0,	'2019-12-07 13:38:16',	'',	1,	'',	0),
(31,	3,	'2019120721551987231140',	'购买商品-梦幻西游2点卡100元梦幻西游点卡1000点网易一卡通100元自动充值',	-196.00,	0,	'2019-12-07 21:55:19',	'',	1,	'',	0),
(32,	3,	'2019120721563641261596',	'购买商品-梦幻西游2点卡100元梦幻西游点卡1000点网易一卡通100元自动充值',	-196.00,	0,	'2019-12-07 21:56:36',	'',	1,	'',	0),
(33,	3,	'2019120811395526946411',	'购买商品-photoshop教程 教你玩转photoshop教程|ps教程含色彩系统',	-9.80,	0,	'2019-12-08 11:39:55',	'',	1,	'',	0),
(34,	3,	'2019121021184993490600',	'购买商品-photoshop教程 教你玩转photoshop教程|ps教程含色彩系统',	-9.80,	0,	'2019-12-10 21:18:49',	'',	1,	'',	0),
(35,	3,	'2019121111082086596679',	'阅读付费文章-短视频的彷徨与退让：积蓄力量，正待春暖花开',	-1.00,	0,	'2019-12-11 11:08:20',	'',	1,	'',	0);

DROP TABLE IF EXISTS `sl_log`;
CREATE TABLE `sl_log` (
  `L_id` int(11) NOT NULL AUTO_INCREMENT,
  `L_time` text NOT NULL,
  `L_add` text NOT NULL,
  `L_ip` text NOT NULL,
  `L_title` text NOT NULL,
  `L_del` int(11) NOT NULL DEFAULT '0',
  `L_aid` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`L_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `sl_log` (`L_id`, `L_time`, `L_add`, `L_ip`, `L_title`, `L_del`, `L_aid`) VALUES
(260,	'2019-12-11 21:29:56',	'山东省',	'::1',	'后台登录成功',	0,	1),
(261,	'2019-12-11 21:30:07',	'山东省',	'::1',	'切换模板',	0,	1),
(262,	'2019-12-11 21:30:34',	'山东省',	'::1',	'编辑菜单',	0,	1),
(263,	'2019-12-11 21:30:55',	'山东省',	'::1',	'编辑菜单',	0,	1),
(264,	'2019-12-11 21:31:09',	'山东省',	'::1',	'编辑菜单',	0,	1),
(265,	'2019-12-11 21:31:16',	'山东省',	'::1',	'编辑菜单',	0,	1),
(266,	'2019-12-11 21:31:23',	'山东省',	'::1',	'编辑菜单',	0,	1),
(267,	'2019-12-11 21:31:48',	'山东省',	'::1',	'编辑菜单',	0,	1),
(268,	'2019-12-11 21:32:15',	'山东省',	'::1',	'编辑菜单',	0,	1),
(269,	'2019-12-11 21:32:26',	'山东省',	'::1',	'编辑菜单',	0,	1),
(270,	'2019-12-11 21:32:39',	'山东省',	'::1',	'编辑菜单',	0,	1),
(271,	'2019-12-11 21:32:47',	'山东省',	'::1',	'编辑菜单',	0,	1),
(272,	'2019-12-11 21:32:56',	'山东省',	'::1',	'编辑菜单',	0,	1),
(273,	'2019-12-11 21:33:09',	'山东省',	'::1',	'编辑菜单',	0,	1),
(274,	'2019-12-11 21:34:12',	'山东省',	'::1',	'新增菜单',	0,	1),
(275,	'2019-12-11 21:35:09',	'山东省',	'::1',	'新增菜单',	0,	1),
(276,	'2019-12-11 21:36:18',	'山东省',	'::1',	'新增菜单',	0,	1),
(277,	'2019-12-11 21:36:40',	'山东省',	'::1',	'新增菜单',	0,	1),
(278,	'2019-12-11 21:37:03',	'山东省',	'::1',	'新增菜单',	0,	1),
(279,	'2019-12-11 21:37:27',	'山东省',	'::1',	'编辑菜单',	0,	1),
(280,	'2019-12-11 21:37:44',	'山东省',	'::1',	'新增菜单',	0,	1),
(281,	'2019-12-11 21:38:01',	'山东省',	'::1',	'新增菜单',	0,	1),
(282,	'2019-12-11 21:38:12',	'山东省',	'::1',	'新增菜单',	0,	1),
(283,	'2019-12-11 21:38:29',	'山东省',	'::1',	'新增菜单',	0,	1),
(284,	'2019-12-11 21:38:50',	'山东省',	'::1',	'新增菜单',	0,	1),
(285,	'2019-12-11 21:39:06',	'山东省',	'::1',	'新增菜单',	0,	1),
(286,	'2019-12-11 21:39:22',	'山东省',	'::1',	'新增菜单',	0,	1),
(287,	'2019-12-11 21:39:43',	'山东省',	'::1',	'新增菜单',	0,	1),
(288,	'2019-12-11 21:39:57',	'山东省',	'::1',	'新增菜单',	0,	1),
(289,	'2019-12-11 21:40:13',	'山东省',	'::1',	'新增菜单',	0,	1),
(290,	'2019-12-11 21:40:28',	'山东省',	'::1',	'新增菜单',	0,	1),
(291,	'2019-12-11 21:40:40',	'山东省',	'::1',	'编辑菜单',	0,	1),
(292,	'2019-12-11 21:40:44',	'山东省',	'::1',	'编辑菜单',	0,	1),
(293,	'2019-12-11 21:41:05',	'山东省',	'::1',	'新增菜单',	0,	1),
(294,	'2019-12-11 21:41:27',	'山东省',	'::1',	'新增菜单',	0,	1),
(295,	'2019-12-11 21:41:48',	'山东省',	'::1',	'新增菜单',	0,	1),
(296,	'2019-12-11 21:42:02',	'山东省',	'::1',	'新增菜单',	0,	1),
(297,	'2019-12-11 21:42:36',	'山东省',	'::1',	'编辑焦点图',	0,	1),
(298,	'2019-12-11 21:42:43',	'山东省',	'::1',	'编辑焦点图',	0,	1),
(299,	'2019-12-11 21:42:49',	'山东省',	'::1',	'编辑焦点图',	0,	1),
(300,	'2020-03-02 09:57:19',	'山东省淄博市',	'::1',	'编辑基本设置',	0,	1),
(301,	'2020-03-02 21:57:36',	'山东省淄博市',	'::1',	'编辑基本设置',	0,	1),
(302,	'2020-04-03 09:04:41',	'山东省',	'::1',	'编辑基本设置',	0,	1),
(303,	'2020-04-08 22:31:27',	'山东省淄博市',	'::1',	'切换模板',	0,	1),
(304,	'2020-10-11 17:21:00',	'山东省',	'::1',	'后台登录成功',	0,	1),
(305,	'2020-11-30 14:29:13',	'山东省',	'::1',	'编辑基本设置',	0,	1),
(306,	'2020-12-18 10:18:14',	'山东省淄博市',	'::1',	'新增单页',	0,	1),
(307,	'2021-11-30 14:40:06',	'',	'112.227.104.168',	'后台登录成功',	0,	0),
(308,	'2021-11-30 14:40:20',	'山东省',	'112.227.104.168',	'后台登录成功',	0,	1),
(309,	'2021-11-30 14:43:41',	'山东省',	'112.227.104.168',	'切换模板',	0,	1),
(310,	'2021-11-30 14:43:41',	'山东省',	'112.227.104.168',	'切换模板',	0,	1),
(311,	'2021-11-30 14:50:25',	'山东省',	'112.227.104.168',	'编辑焦点图',	0,	1),
(312,	'2021-11-30 14:50:35',	'山东省',	'112.227.104.168',	'编辑焦点图',	0,	1),
(313,	'2021-11-30 14:51:25',	'山东省',	'112.227.104.168',	'编辑焦点图',	0,	1),
(314,	'2021-11-30 14:51:33',	'山东省',	'112.227.104.168',	'编辑焦点图',	0,	1),
(315,	'2021-12-05 18:23:13',	'山东省',	'::1',	'验证登录邮箱',	0,	1),
(316,	'2021-12-05 18:23:25',	'山东省',	'::1',	'后台登录成功',	0,	1),
(317,	'2022-04-30 18:47:29',	'山东省淄博市',	'::1',	'后台登录成功',	0,	1),
(318,	'2022-05-13 22:23:30',	'山东省淄博市',	'::1',	'后台登录成功',	0,	1),
(319,	'2022-05-13 22:27:31',	'山东省淄博市',	'::1',	'编辑友链',	0,	1),
(320,	'2022-05-13 22:27:54',	'山东省淄博市',	'::1',	'编辑友链',	0,	1);

DROP TABLE IF EXISTS `sl_member`;
CREATE TABLE `sl_member` (
  `M_id` int(11) NOT NULL AUTO_INCREMENT,
  `M_login` text NOT NULL,
  `M_pwd` text NOT NULL,
  `M_head` text NOT NULL,
  `M_money` decimal(10,2) NOT NULL DEFAULT '0.00',
  `M_regtime` datetime NOT NULL,
  `M_email` text NOT NULL,
  `M_del` int(11) NOT NULL DEFAULT '0',
  `M_viptime` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  `M_viplong` int(11) NOT NULL DEFAULT '0',
  `M_fen` int(11) NOT NULL DEFAULT '0',
  `M_pwdcode` text NOT NULL,
  `M_openid` text NOT NULL,
  `M_shop` varchar(200) DEFAULT NULL,
  `M_from` int(11) DEFAULT '0',
  `M_wxid` varchar(200) DEFAULT NULL,
  `M_type` int(11) DEFAULT '0',
  `M_sellertime` datetime DEFAULT NULL,
  `M_sellerlong` int(11) DEFAULT '0',
  `M_qq` varchar(200) DEFAULT NULL,
  `M_notice` varchar(500) DEFAULT NULL,
  `M_mobile` varchar(200) DEFAULT NULL,
  `M_webtitle` varchar(200) DEFAULT NULL,
  `M_keyword` varchar(200) DEFAULT NULL,
  `M_description` varchar(500) DEFAULT NULL,
  `M_logo` varchar(200) DEFAULT NULL,
  `M_ico` varchar(200) DEFAULT NULL,
  `M_domain` varchar(200) DEFAULT NULL,
  `M_priceup` int(11) DEFAULT '0',
  `M_beian` varchar(200) DEFAULT NULL,
  `M_copyright` varchar(500) DEFAULT NULL,
  `M_qrcode` varchar(500) DEFAULT NULL,
  `M_contact` varchar(1000) DEFAULT NULL,
  `M_kefu` varchar(1000) DEFAULT NULL,
  `M_code` varchar(5000) DEFAULT NULL,
  `M_template` varchar(200) DEFAULT NULL,
  `M_wap` varchar(200) DEFAULT NULL,
  `M_show` int(11) DEFAULT '0',
  `M_stop` int(11) DEFAULT '0',
  `M_stopinfo` varchar(500) DEFAULT NULL,
  `M_product` varchar(2000) DEFAULT NULL,
  `M_news` varchar(2000) DEFAULT NULL,
  `M_postage` decimal(10,2) DEFAULT '0.00',
  `M_baoyou` decimal(10,2) DEFAULT '0.00',
  `M_downloadtimes` int(11) DEFAULT '0',
  `M_freetime` datetime DEFAULT NULL,
  `M_bond` decimal(10,2) DEFAULT '0.00',
  PRIMARY KEY (`M_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `sl_member` (`M_id`, `M_login`, `M_pwd`, `M_head`, `M_money`, `M_regtime`, `M_email`, `M_del`, `M_viptime`, `M_viplong`, `M_fen`, `M_pwdcode`, `M_openid`, `M_shop`, `M_from`, `M_wxid`, `M_type`, `M_sellertime`, `M_sellerlong`, `M_qq`, `M_notice`, `M_mobile`, `M_webtitle`, `M_keyword`, `M_description`, `M_logo`, `M_ico`, `M_domain`, `M_priceup`, `M_beian`, `M_copyright`, `M_qrcode`, `M_contact`, `M_kefu`, `M_code`, `M_template`, `M_wap`, `M_show`, `M_stop`, `M_stopinfo`, `M_product`, `M_news`, `M_postage`, `M_baoyou`, `M_downloadtimes`, `M_freetime`, `M_bond`) VALUES
(1,	'未登录帐号',	'7fef6171469e80d32c0559f88b377245',	'head.jpg',	0.00,	'2019-11-16 13:02:41',	'222@qq.com',	0,	'1970-01-01 00:00:00',	0,	0,	'',	'',	'店铺名称',	0,	'',	0,	'2000-01-01 00:00:00',	0,	'',	'店铺公告',	'',	'网站名称',	'SEO网站关键词',	'SEO网站描述',	'nopic.png',	'',	'',	10,	'',	'',	'',	'',	'',	'',	'',	'',	0,	0,	'',	'',	'',	0.00,	0.00,	0,	'2000-01-01 00:00:00',	0.00),
(9,	'Q_闪灵Anchen',	'e2376380336559eb7f8a538ffe3c3827',	'20191201225749pw9.jpg',	0.30,	'2019-12-01 22:57:49',	'@qq.com',	0,	'1970-01-01 00:00:00',	0,	0,	'',	'DAAE6D665D3931C6C7A61145C97C7BF5',	'店铺名称',	0,	'',	0,	'2000-01-01 00:00:00',	0,	'',	'店铺公告',	'',	'网站名称',	'SEO网站关键词',	'SEO网站描述',	'nopic.png',	'',	'',	10,	'',	'',	'',	'',	'',	'',	'',	'',	0,	0,	'',	'',	'',	0.00,	0.00,	0,	'2000-01-01 00:00:00',	0.00),
(11,	'W_闪灵网络',	'bbd32490d09a1ef553e6d94c12772de0',	'20191202121243niR.jpg',	0.00,	'2019-12-02 12:12:43',	'未设置邮箱@qq.com',	0,	'2019-12-03 10:46:59',	31,	0,	'EnLAgDf25t57p69ftwAm',	'o9DdM0ffTbm_vecejmTJs4cBId9E',	'店铺名称',	0,	'',	0,	'2000-01-01 00:00:00',	0,	'',	'店铺公告',	'',	'网站名称',	'SEO网站关键词',	'SEO网站描述',	'nopic.png',	'',	'',	10,	'',	'',	'',	'',	'',	'',	'',	'',	0,	0,	'',	'',	'',	0.00,	0.00,	0,	'2000-01-01 00:00:00',	0.00),
(12,	'qqq',	'b2ca678b4c936f905fb82f2733f5297f',	'head.jpg',	0.00,	'2019-12-07 17:56:40',	'435345ewt@qq.com',	0,	'1970-01-01 00:00:00',	0,	0,	'',	'',	'店铺名称',	0,	'',	0,	'2000-01-01 00:00:00',	0,	'',	'店铺公告',	'',	'网站名称',	'SEO网站关键词',	'SEO网站描述',	'nopic.png',	'',	'',	10,	'',	'',	'',	'',	'',	'',	'',	'',	0,	0,	'',	'',	'',	0.00,	0.00,	0,	'2000-01-01 00:00:00',	0.00);

DROP TABLE IF EXISTS `sl_menu`;
CREATE TABLE `sl_menu` (
  `U_id` int(11) NOT NULL AUTO_INCREMENT,
  `U_title` text NOT NULL,
  `U_type` text NOT NULL,
  `U_typeid` int(11) NOT NULL DEFAULT '0',
  `U_order` int(11) NOT NULL DEFAULT '0',
  `U_sub` int(11) NOT NULL DEFAULT '0',
  `U_link` text NOT NULL,
  `U_del` int(11) NOT NULL DEFAULT '0',
  `U_hide` int(11) DEFAULT '0',
  `U_icon` text,
  PRIMARY KEY (`U_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `sl_menu` (`U_id`, `U_title`, `U_type`, `U_typeid`, `U_order`, `U_sub`, `U_link`, `U_del`, `U_hide`, `U_icon`) VALUES
(1,	'网站首页',	'index',	1,	1,	0,	'',	0,	0,	'nopic.png'),
(2,	'娱乐',	'news',	3,	4,	0,	'',	0,	0,	'nopic.png'),
(3,	'电影',	'news',	1,	2,	2,	'',	0,	0,	'nopic.png'),
(4,	'明星',	'news',	2,	1,	2,	'',	0,	0,	'nopic.png'),
(5,	'新闻',	'news',	4,	3,	0,	'',	0,	0,	'nopic.png'),
(6,	'国际',	'news',	5,	1,	5,	'',	0,	0,	'nopic.png'),
(7,	'联系',	'text',	3,	15,	0,	'http://www.baidu.com',	0,	0,	'nopic.png'),
(8,	'官方微博',	'link',	1,	6,	0,	'http://weibo.com',	1,	0,	'nopic.png'),
(9,	'关于',	'text',	2,	12,	0,	'',	0,	0,	'nopic.png'),
(10,	'品牌故事',	'text',	2,	1,	9,	'',	0,	0,	'nopic.png'),
(11,	'隐私申明',	'text',	1,	2,	9,	'',	0,	0,	'nopic.png'),
(12,	'社会',	'news',	6,	2,	5,	'',	0,	0,	'nopic.png'),
(13,	'加盟合作',	'text',	4,	3,	9,	'',	0,	0,	'nopic.png'),
(14,	'电视',	'news',	9,	3,	2,	'',	0,	0,	'nopic.png'),
(15,	'综艺',	'news',	8,	4,	2,	'',	0,	0,	'nopic.png'),
(16,	'网络安全',	'product',	17,	5,	2,	'',	1,	0,	'nopic.png'),
(17,	'在线留言',	'text',	5,	2,	7,	'',	0,	0,	'nopic.png'),
(18,	'联系方式',	'text',	3,	1,	7,	'',	0,	0,	'nopic.png'),
(23,	'科技',	'news',	10,	5,	0,	'',	0,	0,	'nopic.png'),
(22,	'时尚',	'news',	13,	6,	5,	'',	1,	0,	'nopic.png'),
(21,	'教育',	'news',	12,	5,	5,	'',	1,	0,	'nopic.png'),
(20,	'评论',	'news',	19,	4,	5,	'',	0,	0,	'nopic.png'),
(19,	'军事',	'news',	7,	3,	5,	'',	0,	0,	'nopic.png'),
(24,	'财经',	'news',	11,	6,	0,	'',	0,	0,	'nopic.png'),
(25,	'教育',	'news',	12,	7,	0,	'',	0,	0,	'nopic.png'),
(26,	'时尚',	'news',	13,	8,	0,	'',	0,	0,	'nopic.png'),
(27,	'数码',	'news',	15,	1,	23,	'',	0,	0,	'nopic.png'),
(28,	'手机',	'news',	16,	2,	23,	'',	0,	0,	'nopic.png'),
(29,	'探索',	'news',	17,	3,	23,	'',	0,	0,	'nopic.png'),
(30,	'互联网',	'news',	18,	4,	23,	'',	0,	0,	'nopic.png'),
(31,	'股票',	'news',	26,	1,	24,	'',	0,	0,	'nopic.png'),
(32,	'基金',	'news',	27,	2,	24,	'',	0,	0,	'nopic.png'),
(33,	'外汇',	'news',	28,	3,	24,	'',	0,	0,	'nopic.png'),
(34,	'理财',	'news',	29,	4,	24,	'',	0,	0,	'nopic.png'),
(35,	'出国',	'news',	30,	1,	25,	'',	0,	0,	'nopic.png'),
(36,	'公益',	'news',	31,	2,	25,	'',	0,	0,	'nopic.png'),
(37,	'高考',	'news',	32,	3,	25,	'',	0,	0,	'nopic.png'),
(38,	'EMBA',	'news',	33,	4,	25,	'',	0,	0,	'nopic.png'),
(39,	'女性',	'news',	34,	1,	26,	'',	0,	0,	'nopic.png'),
(40,	'健康',	'news',	35,	2,	26,	'',	0,	0,	'nopic.png'),
(41,	'育儿',	'news',	36,	3,	26,	'',	0,	0,	'nopic.png'),
(42,	'时装',	'news',	37,	4,	26,	'',	0,	0,	'nopic.png');

DROP TABLE IF EXISTS `sl_news`;
CREATE TABLE `sl_news` (
  `N_id` int(11) NOT NULL AUTO_INCREMENT,
  `N_title` text NOT NULL,
  `N_content` longtext,
  `N_pic` text NOT NULL,
  `N_price` decimal(10,2) NOT NULL DEFAULT '0.00',
  `N_sort` int(11) NOT NULL DEFAULT '0',
  `N_del` int(11) NOT NULL DEFAULT '0',
  `N_order` int(11) NOT NULL DEFAULT '0',
  `N_long` int(11) NOT NULL DEFAULT '0',
  `N_date` datetime NOT NULL,
  `N_author` text NOT NULL,
  `N_view` int(11) NOT NULL DEFAULT '0',
  `N_preview` int(11) NOT NULL DEFAULT '0',
  `N_mid` int(11) DEFAULT '0',
  `N_sh` int(11) DEFAULT '0',
  `N_tag` varchar(500) DEFAULT NULL,
  `N_fx` int(11) DEFAULT '0',
  `N_video` varchar(500) DEFAULT NULL,
  `N_top` int(11) DEFAULT '0',
  `N_tpl` int(11) DEFAULT '0',
  `N_shuxing` varchar(500) DEFAULT NULL,
  `N_keywords` varchar(200) DEFAULT NULL,
  `N_description` varchar(500) DEFAULT NULL,
  `N_price2` decimal(10,2) DEFAULT '0.00',
  `N_vshow` int(11) DEFAULT '0',
  `N_ds` int(11) DEFAULT '0',
  `N_dsintro` text,
  `N_uncopy` int(11) DEFAULT '0',
  `N_sort2` int(11) DEFAULT '0',
  `N_unlogin` int(11) DEFAULT '0',
  `N_viponly` int(11) DEFAULT '0',
  `N_vip` int(11) DEFAULT '1',
  PRIMARY KEY (`N_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `sl_news` (`N_id`, `N_title`, `N_content`, `N_pic`, `N_price`, `N_sort`, `N_del`, `N_order`, `N_long`, `N_date`, `N_author`, `N_view`, `N_preview`, `N_mid`, `N_sh`, `N_tag`, `N_fx`, `N_video`, `N_top`, `N_tpl`, `N_shuxing`, `N_keywords`, `N_description`, `N_price2`, `N_vshow`, `N_ds`, `N_dsintro`, `N_uncopy`, `N_sort2`, `N_unlogin`, `N_viponly`, `N_vip`) VALUES
(2,	'施一公：中国教育与美国相反 均值很高方差很小',	'<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	对于当下环境以及未来发展，马云认为未来充满不确定性，企业家可能是世界上真正把握不确定性的群体，把不确定性变成确定性，很多人做企业是把机会做成灾难，灾难变成机会。真正看清楚，就不会悲观或者乐观，而是去寻找解决方案。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	抱怨和躲避解决不了问题，在危机关头，只有熬过挑战的企业，才有抗体。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	董事长郭广昌也认为今年的冬天有些不一样，他认为经济的确会很困难，这个冬天会非常冷。世界上要有一个救世主，就是市场，但在市场里，我们只能自救。企业家们现在必须要做的一件事，就是反省、是扪心自问：现在我们必须认真想想我们遇到的问题是什么？前五年我们又做了些什么？\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	最后他相信中国的市场化程度一定会越来越高，民营企业的营商环境会越来越好。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	<strong>马云：熬过挑战的企业才有抗体</strong>\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	今年，鲁冠球、冯根生、沈爱琴等老一辈浙商相继辞世。马云在演讲中表示，“过去一年，我们一直都在告别，告别了浙商当中开先锋之先，开天辟地的一些人物。在告别的时候我们在想，我们这一代浙商应该从他们身上继承些什么？是传说中浙商的8000亿资本吗？我想我们继承的不是资产，而是在继承和发扬浙商‘敢为天下先’、吃苦耐劳、创新奋斗的精神。”\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	他特别提到了当下的发展环境：\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	“我们今天所遇到的困难其实和美国企业当年所经历的困难无法相比，和40年以前浙商面临的改革开放刚开始的困难环境无法相比，今天幸运得多。过去的40年，浙商是在中美合作的关系发展中起来的，<strong>未来的40年，我们浙商要在新型的中美关系中，在国内经济的转型升级当中，找到自己新的位置。</strong>这是挑战，也考验我们浙商的担当，也是浙商的自我升级迭代。这么多年来，浙商做得好，不仅是因为我们会吃苦，而是因为我们会学习，我们会应对变化。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	因为我们很清楚，只有变革才有我们的机会。任何变化，你把它当做灾难的时候，那就越来越不顺眼，当做机会的时候就越看越有意思。在危机关头，能够熬过困难，熬过挑战的企业才有抗体。总是抱怨自己没有遇上好的年代，这样的人永远不可能遇上更好的时代。”\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	“经过这一轮的洗礼，能够活下来的企业，活下来的浙商，肯定已经不是过去的浙商，一定是未来的浙商。”马云说，浙商要超越商人，告别野蛮生长的市场，“<strong>今天社会进步，商人不能有钱就要干，而要有所为有所不为，要从商人走向企业家，以国家利益为重，以社会利益为重，以未来为重。</strong>相信大家一起相信未来，看见未来，拥有未来”，希望浙商要依靠家国情怀、责任感和价值取向而闻名世界。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	在会上，谈到“风口论”时马云说，当一个还没有成立几天的小公司，就凭着几个故事、几个员工得到了几十亿美金的估值，什么都没有，还嫌少的时候，我们就进入了跨度期，要提前做准备；当一个企业拿自己公司80%的资产质押出去，拿钱去做与自己主业不一样的东西的时候，就要想到问题已经开始了。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	很少有企业能够越做越大、越做越好，因为很多人永远相信“赌博”，永远相信all in。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	<strong>郭广昌：这个冬天会非常冷，“过冬”要靠自己</strong>\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	在演讲中，郭广昌针对企业自身、企业创新、企业人才、企业发展四个方面，提了一些需要企业家们扪心自问的问题。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	<strong>以下为郭广昌演讲全文：</strong>\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	今年是改革开放40周年。在过去40年里，我们浙商靠着“四千”精神，吃苦耐劳、不懈努力，应该说一直走得比较顺。前几年，虽然我们每年都说困难、“年年难过”，但实际上还是“年年过”。但这个冬天，我感觉有些不一样。尤其今年很多企业家朋友都出了问题，而且不是小企业，有些企业很不错，甚至是上百亿市值的上市公司。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	我就在想，到底怎么了？刚才陈龙教授也给大家详细说了外部环境的变化，那我们自己呢？这么多年来，我们一直说我们要改变自己，那我们改变了多少呢？\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	所以我对现在经济的看法是：\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	第一，经济的确会很困难，这个冬天会非常冷。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	第二，世界上要有一个救世主，就是市场；而在市场里，能救你的只有你自己。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	所幸，党和国家已经很清楚的看到了这些问题和困难，也出台了一系列针对民营企业发展的政策和举措。所以，我判断未来的形势会好一些。但能否度过这个冬天，根本点还在于自己。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	作为我们自己，现在必须要做的一件事，是反省、是扪心自问。我觉得现在我们必须认真想想我们遇到的问题是什么？前五年我们又做了些什么？\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	以下这四个问题，是这几年我自己一直在扪心自问的：\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	1、我们要扪心自问，我们到底花了多少时间在客户身上？花了多少时间在了解自己的产品上？花了多少时间在提升产品服务上？\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	每个董事长，首先应该是自己公司的首席产品体验官。产品好不好，客户满意不满意？我们自己应该是最了解的。但这种了解绝不能依靠你的喜好和直觉，你需要花更多的时间跟客户去沟通。尤其产品销量不好，市场上又有很多竞争，你就特别需要更用心地体会产品。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	现在，我花时间最多的就是研究产品。经过这段时间的研究，我基本认为要造好产品，方法大致有两种：一种是做平台，但是能做成像阿里、腾讯这样大平台的企业毕竟是少数。第二就是花更多的时间去琢磨怎么做好产品。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	但如果做产品，我必须要强调一点：我们一定要做精品，一定要千锤百炼，一定要为客户创造价值。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	2、我们经常要扪心自问，我们花了多少钱在研发上？花了多少时间在学习新的业态上？花了多少时间去感受新的趋势和方向上？\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	我相信，现在大家都很重视移动互联网。但我想问：我们的制造企业，有多少人真正懂得了移动互联网吗？移动互联网只是在淘宝上卖东西吗？马校长已经把阿里这家互联网企业做得这么好，但他还是会花大量的时间在研究线下商业、实体制造。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	所以说，我们千万不能因为取得了成绩，就不学习了。永远只有比别人学得更快，我们才能比别人走得更好、更远。现在客户的需求变化非常快，我们也进入了一个科技研发能快速转化为成果的时代。在这样的时代，技术的进步、产业的进步、市场逻辑的进步，逼着我们要不断学习。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	另一方面，一定要重视科技研发和创新。我们很多出问题的企业，虽然他们的公司已经很大，但总体感觉他们生产的大部分产品还是同质化、低科技的产品，而且他们以前一直是靠低毛利来不断扩大销量。但这个时代变化太快了，很可能你生产出来的不是产品，直接就是库存。所以，现在尤其要用科技创新来引领。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	3、我们要扪心自问，我们花了多少精力在组织升级和人才培养上？我们花了多少精力在引进高级人才上？花了多少精力在年轻人身上？我们有没有在90后、00后身上学到了什么？\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	组织、人才，绝对是一家企业最核心的资产。因为所有的事都需要对的人去实现。而且根据市场的发展和变化，我们的组织需要不断升级，企业的人才要不断换仓。我们一定要吸收具备高能级、更在状态、更渴望成功的人。大家都有自己的团队，但我们花了多少精力在团队的升级上？\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	我举个例子。复星的狼队这个赛季从英冠踢到了英超。但我突然发觉，英冠虽然踢得好，但是到英超以后，却碰到了很多的问题。为什么？\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	因为英超要求我们球员的素质和英冠是不一样的。现在中国经济不管跟美国发生什么，都是一个比较长期且难以解决的问题。但不管怎么解决，中国经济已经在参与全球竞争了，客观上我们已经在踢“世界杯”了。这个时候，你的人才还是停留在原来的状态，不出问题不是很奇怪吗？\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	4、最后，我们还要扪心自问：我们到底愿意不愿意慢下来，去做点慢的事情？\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	改革开放40年，中国速度是大家津津乐道的，什么都发展得很快。这让我们已经习惯了快。比如我们看到马校长用十几年打造了一个世界级的巨无霸企业，大家都很想去复制他成功的路径。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	但全世界只有一个马云，谁都像他一样，这个世界还了得？所以你要知道，你自己该做什么，你有没有沉下心来做你该做的事？我们很多企业，我对他们做事的风格有一种感觉，就是All in，就是“赌”。这个“赌”不是说去赌场，而是说做企业很有“赌”性。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	之前的40年，因为整个市场在发展，一俊遮百丑，你很大概率赌成功了。但你千万不能把经济的大势当作你自己的能力，如果市场不好了，会怎么样？All in一下会很爽，但之后呢？\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	我相信我们真的要沉下心，做对的事情，做难的事情，做需要时间积累的事情。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	当然，讲了这么多困难和问题之后，我还是对未来始终充满信心：\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	我坚定地相信，中国的市场化程度一定会越来越高，我们民营企业的营商环境会越来越好。包括我相信，不久的将来一定会减税，以降低企业的成本、激发企业活力。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	我坚定地相信，中国的企业家，尤其浙商，都非常能吃苦，只要我们真的加大创新，我们的未来会得到更多的发展。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	我坚定地相信，我们一定会融入全球。对于我们来说，尤其浙商，这是未来我们重要的方向。我们浙商不害怕去全球竞争，在越来越开放、越规范的市场，在全球化的融合中，全球浙商只会越来越好。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	这就像中国足球一样。中国足球要踢世界杯，只有让我们球员去全球踢球，才能得到真正的锻炼，而不只是在中超拿高工资。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	我坚定地相信，我们浙商有这份期望，我们浙商有这份能力，让我们一起努力。\r\n</p>',	'doc.png',	1.00,	38,	0,	0,	0,	'2019-12-26 09:37:40',	'admin',	71,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	1.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	14,	1,	0,	1),
(3,	'共享单车的印度崛起：东方不亮西方亮？',	'<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	2015年，随着抢眼的小黄车突现北大校园，共享单车的概念迅速被普及，玩家接连冒头，巨额投资不断涌入，和高铁、移动支付、网购齐名<strong>“新四大发明”</strong>。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	热潮来得快，去得更快。今年，共享单车就进入了寒冬。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	4月，<strong>摩拜单车委身美团；小黄车ofo也节节败退，危机重重</strong>：海外业务全面收缩，并推出了多种激进的变现手段：公众号推送广告，将用户的押金与理财产品绑定，一再延迟押金退还期限。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	去年还大把烧钱的共享单车，转眼就凉凉了。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	共享单车出海遇阻，基础建设和政策规范是难以忽略的两大阻力。除了中国，世界上很难找到一个足够大的市场来支撑共享单车的盈利模式。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	但印度的创业者似乎有不同想法。<strong>从2017年开始，有近十年共享单车公司陆续出现，并先后拿到融资。</strong> \r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	班加罗尔的Yulu向Blume Ventures等投资者筹得资金，还获得Flipkart联合创始人Binny Bansal和谷歌前副总裁Amit Singhal的支持；另一家公司Bounce从红杉印度等投资者那里拿到了了总计1520万美元的资金；总部位于古尔冈的Mobycy去年12月也筹集了50万美元的种子资金。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\"> <strong>印度的共享单车市场正生机勃勃。</strong> \r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\"> <strong>融资热潮</strong> \r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	Amit Gupta是印度第一家独角兽Inmobi的联合创始人。在他创业十年、担任总裁级别职务的时候，他选择了急流勇退，<strong>创办了另一家公司，Yulu单车</strong>。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在班加罗尔地铁站和商务CBD附近，亮蓝色的Yulu单车随处可见。Amit告诉\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	志象网\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	，做共享单车，是为了<strong>“间接降低污染”</strong>。他出生和长大在印度北部的小城坎普尔，在今年6月被世界卫生组织盖章“全球污染最严重城市”，谈起家乡，他显得情绪激动。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	Yulu单车在前半个小时仅收费10卢比<strong>（约一元）</strong>，之后每半小时多收5卢比。用户下载Yulu应用扫码开车，结束骑行之后，需要将车子停放在离目的地最近的停车区。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	业内人士估计，印度的共享单车市场目前规模达12亿美元。<strong>主要的玩家除了Yulu，还有共享汽车公司Zoomca旗下的Pedl，Mobycy，Bounce和以及来自中国的摩拜单车。</strong> \r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“这个行业很有前景并且有利可图，Ola和Uber的成功证明了交通出行跟手机有可能同步发展。”Blume Ventures的投资人Sajith Pai对志象网说。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	最近入局的玩家是<strong>从踏板车共享起家的Bounce</strong>。今年6月，ofo退出印度市场，Bounce最近宣布收购了它在印度的资产。在收购之前，Bounce在就班加罗尔投放了500辆踏板车。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“从公交站或地铁站到办公室和家里的最后一英里的交通非常令人头疼，没有任何三轮车或出租车愿意走这么短的距离。”Bounce联合创始人Vivekananda HR告诉志象网。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“我们从ofo手中收购的自行车也将加入试点。”他说，45到60天内Bounce的应用将支持扫码使用单车。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	印度创业者从中国公司继承的，不仅是败局留下的遗产，还有先见之明的运营管理教训。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在浦那和班加罗尔，小蓝车Yulu和小绿车Pedl随处可见。一开始，用户可以把车停在任何地方，甚至是在路中间，引起了交通失序。Yulu不得已派出团队去搬运自行车并停放在适当的地方。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	这样一来，成本太高难以为继，Yulu吸取了教训，开始联合Pedl与当地政府合作，规划指定的停车区域。在班加罗尔，这样的停车区现在有500个，在全部的4个城市总数超过1000个。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\"> <strong>纠结的用户体验</strong> \r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	但也有的问题无法靠“继承”来解决，<strong>比如技术和运营失误</strong>。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在印度，<strong>共享单车的用户体验仍有待改善</strong>。志象网记者的亲身体验以及和其他用户交流后发现，包括刹车失灵、智能锁失灵、轮胎漏气等现象并不少见，而且停车区的分布也不够密集，有时候用户甚至需要在锁车之后再走一公里到目的地。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	Vivek Kumar是一名22岁的软件工程师，他最近刚从德里搬到了班加罗尔。刚到班加罗尔时，他一直骑着共享单车穿梭在城市中参加面试。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	一次去面试的路上，他发现单车的链条断了，这就十分尴尬了：他必须得先把车子停到指定的停车区域，否则软件会一直计费。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“我不得不把车子推到500米外的Pedl停车站，在锁这个坏车的时候又花了好多时间。”Kumar告诉志象网。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	但事实上，Yulu和Pedl也都有专人在维护单车，每隔四天维护一次，从而保持单车的良好运行状态。但Amit说，当公司进入一个区域时，维护的情况会不太稳定，“因为当地业务还没有完全稳定。”\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“在那些旧的区域，你会发现我们的自行车状况良好，大多数都能够很好运行。最近我们在电子城附近布局，那里聚集了一批大型IT公司，比如Infosys、Wipro等。我们需要四到六周的时间来完成布局。”Amit说。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	但相较中国，<strong>印度的交通基础设施普遍落后，这也给共享单车埋了一颗暗雷</strong>。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在印度，没有几个城市设置了自行车道；不像中国，骑行已经发展为一种健康、前卫的生活方式，印度的自行车还往往被视为穷人的通勤方式。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“我们之所以进入共享单车行业，是因为我们想成为一家多渠道出行平台。城市交通一直是政府和公民共同面临的挑战，我们希望能够大规模地解决这一问题并帮助完善基础设施建设。”Pedl运营增长部门负责人Rakshak N说。\r\n	</p>',	'doc.png',	0.00,	24,	0,	0,	1,	'2019-11-26 09:37:47',	'admin',	119,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	0.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	10,	1,	0,	1),
(4,	'兰州民百实控人朱宝良被抓 曾问鼎杭州桐庐首富',	'<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	互联网瞬息即变，互联网上的热点也是转变地相当的快，一个热点可能过了几天就不再有人关注了。这对于想凭借互联网走红的人或物来说，显然要付出更多的心血来维持热度。那么，各个引流渠道显然都在他们的考虑范围之内。对于商家而言，在互联网进行引流的最终目的不外乎都是卖货变现。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	因此，一些比较重要的引流渠道，都少不了商家们的身影；比如，。抖音作为2019年的平台，有着3.2亿日活跃用户，属于是自带。如今，抖音与微信、微博等巨大流量池并称，绝对是商家不容错过的流量池。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	商家在抖音平台上发布内容之后，就能通过发布内容来吸引用户前来关注，并进一步转化为粉丝，这样就能更方便商家引流变现。在抖音只能是通过发布优质内容来吸引用户关注，因为抖音采用的是智能社交推荐机制，只要发布的视频内容有趣，也可以获得大量的曝光。这就决定了粗制滥造的视频所获得的曝光量很少。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;text-align:center;\"=\"\"> <img src=\"http://demoall.adashuo.com/20090/uploads/allimg/c191107/15I0c2FD630-1E14.jpg\" width=\"450\" height=\"270\" border=\"0\" alt=\"抖音多闪培训：如何通过抖音进行带货-第1张图片-小七抖音培训\" title=\"抖音多闪培训：如何通过抖音进行带货-第1张图片-小七抖音培训\" style=\"height:270px;width:450px;\" /> \r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	因此，想要在抖音平台上获得大量的曝光，最简单的办法就是制作高质量的视频内容。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	拥有曝光，并不代表着是结束。恰恰相反，这只是开始，因为接下来的工作就是要引流变现了。目前，通过抖音引流的方式无非就只有这么几种：一是在视频内提及联系方式；二是在评论中回复；三是在私信回复等。但是，这几种引流方式都存在着被抖音删除、乃至封禁的风险。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	抖音多闪培训那么，到底有没有什么引流方式是没有风险的呢？或者换言之，有什么引流方式是抖音官方认可的呢？当然有!那就是抖音的电话拨打组件。这是抖音官方所推出的转化组件，经过设置就可以在抖音主页上展示，只要用户点击\"联系方式\"这个按钮就可以跳转至电话拨号界面，并显示相关号码，这无疑对商家引流变现提供了很大的便利。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	但比较遗憾的是，目前，这个功能并没有对所有的用户开放，只有认证了抖音企业蓝v号的用户才可以设置该功能。所以，商家如果是想开通\"电话拨打组件\"的功能，需要先开通抖音蓝v。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	抖音蓝v认证的申请流程如下：\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	第一，用需要认证蓝v的抖音账号登录抖音蓝v认证官网https://renzheng.douyin.com/。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	第二，填写企业认证公函，具体情况可以参考抖音官方的企业认证公函填写模板。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;text-align:center;\"=\"\"> <img src=\"http://demoall.adashuo.com/20090/uploads/allimg/c191107/15I0c2G0040-2J03.jpg\" width=\"450\" height=\"447\" border=\"0\" alt=\"抖音多闪培训：如何通过抖音进行带货-第2张图片-小七抖音培训\" title=\"抖音多闪培训：如何通过抖音进行带货-第2张图片-小七抖音培训\" style=\"height:447px;width:450px;\" /> \r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	第三，填写并提交认证资料，然后填写邀请码123456\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	第四，支付认证审核费用600元即可完成蓝v认证申请的提交。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	需要注意的是，抖音蓝v认证有部分禁入行业及需要额外提供认证资质证明的行业。禁入行业认证抖音蓝v将做认证失败处理。而需要额外提供认证资质证明的，如果碰巧没有，那么在提交认证申请后的30天内仍没有补充提交资质证明，也会当认证失败处理。而认证抖音蓝v失败，是不会进行退款的。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	认证抖音蓝v之后，除了可以获得电话拨打组件，还可以获得同步认证今日头条和、官网链接、商家页面、店铺POI地址、粉丝画像等蓝v权益。可以为天猫、淘宝、京东店铺以及线下店铺引流，构建企业商家的营销阵地，完成变现的目的。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;text-align:center;\"=\"\"> <img src=\"http://demoall.adashuo.com/20090/uploads/allimg/c191107/15I0c2G35440-31260.jpg\" width=\"450\" height=\"261\" border=\"0\" alt=\"抖音多闪培训：如何通过抖音进行带货-第3张图片-小七抖音培训\" title=\"抖音多闪培训：如何通过抖音进行带货-第3张图片-小七抖音培训\" style=\"height:261px;width:450px;\" /> \r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	抖音多闪培训因此，有意认证抖音蓝v的商家，最好是通过抖音蓝v认证代理商进行认证。\r\n</p>',	'doc.png',	0.00,	21,	0,	0,	0,	'2019-12-03 14:04:12',	'admin',	5,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	0.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	4,	1,	0,	1),
(5,	'人教社承认语文教材黄文中西湖名联出错:将更改',	'<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	众所周知，2017年至2018年，的大和商业价值日益凸显，各大机构纷纷注资抢占短视频市场，作为短视频流量增速最快的APP，其运营模式和商业市场更是备受关注。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	大数据，帮你快速打造抖音爆款\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	抖音作为新媒体的新洼地，虽然流量又达到一个新的峰值，但是入场抖音仍然是可以。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	而想在抖音机制中脱颖而出，关注的焦点更倾向于生产抖音内容的速度和质量，以及如何持续生产高质量的抖音内容。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	对于运营抖音而言，此时入场抖音阵地，更需要把控时间成本和运营方法。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	结合抖音大数据工具——西瓜短视频助手，在内容层面，可以在6小时内寻找到抖音视频爆款素材，结合热门迅速掌握抖音平台爆款元素，从而有效提升抖音成本。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	在领域定位上，可以根据榜单快速规划的运营方向，结合行业粉丝画像信息，进一步完善垂直领域差异化内容布局。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	抖音进阶创作技巧，及商业运作模式\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;text-align:center;\"=\"\"> <img src=\"http://demoall.adashuo.com/20090/uploads/allimg/c191107/15I0c2AcO0-53929.jpg\" width=\"450\" height=\"303\" border=\"0\" alt=\"抖音小店：抖音运营怎么进行流量变现-第1张图片-小七抖音培训\" title=\"抖音小店：抖音运营怎么进行流量变现-第1张图片-小七抖音培训\" style=\"height:303px;width:450px;\" /> \r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	根据对MCN机构平台发展中遇到各种情况，给现场的运营者和MCN机构提出以下3个方面建议：\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	1.稳扎稳打才是抖音号的运营之道\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	面对网络上出现的买粉刷量的现象，建议运营者和机构千万不要尝试。这样的行为，不仅影响抖音号的权重，也让后续陷入无效价值中。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	2.快速孵化KOL矩阵离不开内容运营\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	抖音小店面对快速内容运营的有效方法，也给出一些信息流量的操作模式，在信息的展示上，可以扩大挖掘地域，可以引入外国小众优质的平台信息资源，将优质内容分类整理成“剧本”分发旗下艺人进行高效运作，提升视频输出效率。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	3.强强合作是商业运作成型的有效方法\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	相比知识付费，广告和电商是抖音目前最有效的转化之一。在广告投放上，同MCN专业机构合作，会更有效的提升个人抖音号的商业价值转化能力。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	如何高格局快速转战短视频领域构建生态链\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	如何一手打造“从内容生产-IP孵化-推广产业化”短视频生态蓝图？\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;text-align:center;\"=\"\"> <img src=\"http://demoall.adashuo.com/20090/uploads/allimg/c191107/15I0c2B323F-B363.jpg\" width=\"450\" height=\"307\" border=\"0\" alt=\"抖音小店：抖音运营怎么进行流量变现-第2张图片-小七抖音培训\" title=\"抖音小店：抖音运营怎么进行流量变现-第2张图片-小七抖音培训\" style=\"height:307px;width:450px;\" /> \r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	a.建立完善的孵化流程。在常规签约流程上，增加达人定位分析和视频测试环节（颜值/技能/学习），保障达人较高的素质水平。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	b.专注用户市场资源。在媒体领域商业形式取决于上游形态，运营的方向取决于市场用户的需求，只有想明白定位，才能做清楚你的市场。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	c.专业商业变现评估。需要对行业的天花板有一定认知，对不具有的抖音大号，可以根据粉丝画像的年龄层，选择不同的市场的推广模式。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	最后，规范机构的商业合作模式，才能快速有效构建自己的商业帝国。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	网红大咖粉丝运营之道\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	抖音IP的成长过程3个关键点：\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	1、找准平台：分析各个平台的商业价值和受众群体，有效预估平台的价值的上升空间。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;text-align:center;\"=\"\"> <img src=\"http://demoall.adashuo.com/20090/uploads/allimg/c191107/15I0c2BC510-L234.jpg\" width=\"450\" height=\"303\" border=\"0\" alt=\"抖音小店：抖音运营怎么进行流量变现-第3张图片-小七抖音培训\" title=\"抖音小店：抖音运营怎么进行流量变现-第3张图片-小七抖音培训\" style=\"height:303px;width:450px;\" /> \r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	2.优质内容：视频种类，视频的风格，人设的塑造，再到更高层次基调定位，都是优质内容的保障。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	3.抓准用户心理：内容的输出上需要抓取社会的认同感，有共鸣的内容通常都可以引发用户的依赖性，可以在内容上找到归属感。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	抖音小店其次，需要制造亲切感，打造个舒服是场景内容更容易获取用户关注。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	最后，就是从心理学的角度出发，恰到好处运粉丝的独纵心理和占便宜的心态。\r\n	</p>',	'doc.png',	1.00,	29,	0,	0,	0,	'2019-12-03 14:07:30',	'admin',	3,	5,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	1.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	11,	1,	0,	1),
(21,	'北京市发布大风蓝色预警 阵风可达7级左右',	'<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	对于当下环境以及未来发展，马云认为未来充满不确定性，企业家可能是世界上真正把握不确定性的群体，把不确定性变成确定性，很多人做企业是把机会做成灾难，灾难变成机会。真正看清楚，就不会悲观或者乐观，而是去寻找解决方案。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	抱怨和躲避解决不了问题，在危机关头，只有熬过挑战的企业，才有抗体。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	董事长郭广昌也认为今年的冬天有些不一样，他认为经济的确会很困难，这个冬天会非常冷。世界上要有一个救世主，就是市场，但在市场里，我们只能自救。企业家们现在必须要做的一件事，就是反省、是扪心自问：现在我们必须认真想想我们遇到的问题是什么？前五年我们又做了些什么？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	最后他相信中国的市场化程度一定会越来越高，民营企业的营商环境会越来越好。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\"> <strong>马云：熬过挑战的企业才有抗体</strong> \r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	今年，鲁冠球、冯根生、沈爱琴等老一辈浙商相继辞世。马云在演讲中表示，“过去一年，我们一直都在告别，告别了浙商当中开先锋之先，开天辟地的一些人物。在告别的时候我们在想，我们这一代浙商应该从他们身上继承些什么？是传说中浙商的8000亿资本吗？我想我们继承的不是资产，而是在继承和发扬浙商‘敢为天下先’、吃苦耐劳、创新奋斗的精神。”\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	他特别提到了当下的发展环境：\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“我们今天所遇到的困难其实和美国企业当年所经历的困难无法相比，和40年以前浙商面临的改革开放刚开始的困难环境无法相比，今天幸运得多。过去的40年，浙商是在中美合作的关系发展中起来的，<strong>未来的40年，我们浙商要在新型的中美关系中，在国内经济的转型升级当中，找到自己新的位置。</strong>这是挑战，也考验我们浙商的担当，也是浙商的自我升级迭代。这么多年来，浙商做得好，不仅是因为我们会吃苦，而是因为我们会学习，我们会应对变化。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	因为我们很清楚，只有变革才有我们的机会。任何变化，你把它当做灾难的时候，那就越来越不顺眼，当做机会的时候就越看越有意思。在危机关头，能够熬过困难，熬过挑战的企业才有抗体。总是抱怨自己没有遇上好的年代，这样的人永远不可能遇上更好的时代。”\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“经过这一轮的洗礼，能够活下来的企业，活下来的浙商，肯定已经不是过去的浙商，一定是未来的浙商。”马云说，浙商要超越商人，告别野蛮生长的市场，“<strong>今天社会进步，商人不能有钱就要干，而要有所为有所不为，要从商人走向企业家，以国家利益为重，以社会利益为重，以未来为重。</strong>相信大家一起相信未来，看见未来，拥有未来”，希望浙商要依靠家国情怀、责任感和价值取向而闻名世界。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在会上，谈到“风口论”时马云说，当一个还没有成立几天的小公司，就凭着几个故事、几个员工得到了几十亿美金的估值，什么都没有，还嫌少的时候，我们就进入了跨度期，要提前做准备；当一个企业拿自己公司80%的资产质押出去，拿钱去做与自己主业不一样的东西的时候，就要想到问题已经开始了。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	很少有企业能够越做越大、越做越好，因为很多人永远相信“赌博”，永远相信all in。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\"> <strong>郭广昌：这个冬天会非常冷，“过冬”要靠自己</strong> \r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在演讲中，郭广昌针对企业自身、企业创新、企业人才、企业发展四个方面，提了一些需要企业家们扪心自问的问题。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\"> <strong>以下为郭广昌演讲全文：</strong> \r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	今年是改革开放40周年。在过去40年里，我们浙商靠着“四千”精神，吃苦耐劳、不懈努力，应该说一直走得比较顺。前几年，虽然我们每年都说困难、“年年难过”，但实际上还是“年年过”。但这个冬天，我感觉有些不一样。尤其今年很多企业家朋友都出了问题，而且不是小企业，有些企业很不错，甚至是上百亿市值的上市公司。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	我就在想，到底怎么了？刚才陈龙教授也给大家详细说了外部环境的变化，那我们自己呢？这么多年来，我们一直说我们要改变自己，那我们改变了多少呢？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	所以我对现在经济的看法是：\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	第一，经济的确会很困难，这个冬天会非常冷。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	第二，世界上要有一个救世主，就是市场；而在市场里，能救你的只有你自己。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	所幸，党和国家已经很清楚的看到了这些问题和困难，也出台了一系列针对民营企业发展的政策和举措。所以，我判断未来的形势会好一些。但能否度过这个冬天，根本点还在于自己。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	作为我们自己，现在必须要做的一件事，是反省、是扪心自问。我觉得现在我们必须认真想想我们遇到的问题是什么？前五年我们又做了些什么？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	以下这四个问题，是这几年我自己一直在扪心自问的：\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	1、我们要扪心自问，我们到底花了多少时间在客户身上？花了多少时间在了解自己的产品上？花了多少时间在提升产品服务上？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	每个董事长，首先应该是自己公司的首席产品体验官。产品好不好，客户满意不满意？我们自己应该是最了解的。但这种了解绝不能依靠你的喜好和直觉，你需要花更多的时间跟客户去沟通。尤其产品销量不好，市场上又有很多竞争，你就特别需要更用心地体会产品。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	现在，我花时间最多的就是研究产品。经过这段时间的研究，我基本认为要造好产品，方法大致有两种：一种是做平台，但是能做成像阿里、腾讯这样大平台的企业毕竟是少数。第二就是花更多的时间去琢磨怎么做好产品。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	但如果做产品，我必须要强调一点：我们一定要做精品，一定要千锤百炼，一定要为客户创造价值。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	2、我们经常要扪心自问，我们花了多少钱在研发上？花了多少时间在学习新的业态上？花了多少时间去感受新的趋势和方向上？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	我相信，现在大家都很重视移动互联网。但我想问：我们的制造企业，有多少人真正懂得了移动互联网吗？移动互联网只是在淘宝上卖东西吗？马校长已经把阿里这家互联网企业做得这么好，但他还是会花大量的时间在研究线下商业、实体制造。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	所以说，我们千万不能因为取得了成绩，就不学习了。永远只有比别人学得更快，我们才能比别人走得更好、更远。现在客户的需求变化非常快，我们也进入了一个科技研发能快速转化为成果的时代。在这样的时代，技术的进步、产业的进步、市场逻辑的进步，逼着我们要不断学习。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	另一方面，一定要重视科技研发和创新。我们很多出问题的企业，虽然他们的公司已经很大，但总体感觉他们生产的大部分产品还是同质化、低科技的产品，而且他们以前一直是靠低毛利来不断扩大销量。但这个时代变化太快了，很可能你生产出来的不是产品，直接就是库存。所以，现在尤其要用科技创新来引领。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	3、我们要扪心自问，我们花了多少精力在组织升级和人才培养上？我们花了多少精力在引进高级人才上？花了多少精力在年轻人身上？我们有没有在90后、00后身上学到了什么？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	组织、人才，绝对是一家企业最核心的资产。因为所有的事都需要对的人去实现。而且根据市场的发展和变化，我们的组织需要不断升级，企业的人才要不断换仓。我们一定要吸收具备高能级、更在状态、更渴望成功的人。大家都有自己的团队，但我们花了多少精力在团队的升级上？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	我举个例子。复星的狼队这个赛季从英冠踢到了英超。但我突然发觉，英冠虽然踢得好，但是到英超以后，却碰到了很多的问题。为什么？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	因为英超要求我们球员的素质和英冠是不一样的。现在中国经济不管跟美国发生什么，都是一个比较长期且难以解决的问题。但不管怎么解决，中国经济已经在参与全球竞争了，客观上我们已经在踢“世界杯”了。这个时候，你的人才还是停留在原来的状态，不出问题不是很奇怪吗？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	4、最后，我们还要扪心自问：我们到底愿意不愿意慢下来，去做点慢的事情？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	改革开放40年，中国速度是大家津津乐道的，什么都发展得很快。这让我们已经习惯了快。比如我们看到马校长用十几年打造了一个世界级的巨无霸企业，大家都很想去复制他成功的路径。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	但全世界只有一个马云，谁都像他一样，这个世界还了得？所以你要知道，你自己该做什么，你有没有沉下心来做你该做的事？我们很多企业，我对他们做事的风格有一种感觉，就是All in，就是“赌”。这个“赌”不是说去赌场，而是说做企业很有“赌”性。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	之前的40年，因为整个市场在发展，一俊遮百丑，你很大概率赌成功了。但你千万不能把经济的大势当作你自己的能力，如果市场不好了，会怎么样？All in一下会很爽，但之后呢？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	我相信我们真的要沉下心，做对的事情，做难的事情，做需要时间积累的事情。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	当然，讲了这么多困难和问题之后，我还是对未来始终充满信心：\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	我坚定地相信，中国的市场化程度一定会越来越高，我们民营企业的营商环境会越来越好。包括我相信，不久的将来一定会减税，以降低企业的成本、激发企业活力。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	我坚定地相信，中国的企业家，尤其浙商，都非常能吃苦，只要我们真的加大创新，我们的未来会得到更多的发展。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	我坚定地相信，我们一定会融入全球。对于我们来说，尤其浙商，这是未来我们重要的方向。我们浙商不害怕去全球竞争，在越来越开放、越规范的市场，在全球化的融合中，全球浙商只会越来越好。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	这就像中国足球一样。中国足球要踢世界杯，只有让我们球员去全球踢球，才能得到真正的锻炼，而不只是在中超拿高工资。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	我坚定地相信，我们浙商有这份期望，我们浙商有这份能力，让我们一起努力。\r\n</p>',	'doc.png',	1.00,	23,	0,	0,	0,	'2019-12-26 09:37:40',	'admin',	71,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	1.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	3,	1,	0,	1),
(6,	'三招甩掉肚子上的肥肉 早上吃鸡蛋有哪些好处',	'<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	带火了很多“爆款”产品，这些品牌和产品的销量大增，引得很多企业和品牌方们分外眼红。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	在这个为王的时代，早已成为了一个所有新媒体人无法避开的平台。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	抖音火遍大江南北，同时有无限的流量产生。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	大家撸粉的撸粉，变现的变现。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	但是现在越来越难了，\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;text-align:center;\"=\"\"> <img src=\"http://demoall.adashuo.com/20090/uploads/allimg/c191107/15I0c26340L0-1F53.jpg\" width=\"450\" height=\"198\" border=\"0\" alt=\"抖音运营团队：抖音运营思维攻略-第1张图片-小七抖音培训\" title=\"抖音运营团队：抖音运营思维攻略-第1张图片-小七抖音培训\" style=\"height:198px;width:450px;\" /> \r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	为什么？\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	竞争大呗！\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	团队拿到更好的权重才能有更多的曝光，才有上的机会。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	怎么拿到更多的曝光权重呢？\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	俗话说：知己知彼，百战不殆！\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	那我就先来了解一下抖音的排名算法是什么？\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	首先你要输出优质的内容，\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;text-align:center;\"=\"\"> <img src=\"http://demoall.adashuo.com/20090/uploads/allimg/c191107/15I0c263G60-26058.jpg\" width=\"450\" height=\"195\" border=\"0\" alt=\"抖音运营团队：抖音运营思维攻略-第2张图片-小七抖音培训\" title=\"抖音运营团队：抖音运营思维攻略-第2张图片-小七抖音培训\" style=\"height:195px;width:450px;\" /> \r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	关于内容今天就不讲了，本期讲的是抖音运营思维攻略。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	一、熟悉抖音\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	抖音运营团队熟悉抖音账号注册、认证、定位、布局、防封号/、最受欢迎内容等。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;text-align:center;\"=\"\"> <img src=\"http://demoall.adashuo.com/20090/uploads/allimg/c191107/15I0c26406150-31H2.jpg\" width=\"450\" height=\"266\" border=\"0\" alt=\"抖音运营团队：抖音运营思维攻略-第3张图片-小七抖音培训\" title=\"抖音运营团队：抖音运营思维攻略-第3张图片-小七抖音培训\" style=\"height:266px;width:450px;\" /> \r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	二、选题\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	1.选题的原则：关联性、热门性、新鲜感、人设感\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	2.选题来源：可从时事、同行火爆视频分析、段子、微博等渠道入手\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	3.拍摄及剧本套路\r\n</p>',	'doc.png',	1.00,	40,	0,	0,	0,	'2019-12-03 14:08:06',	'admin',	10,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	1.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	14,	1,	0,	1),
(7,	'舌尖上的中国第三季启动 预计明年春节期间播出',	'<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	怎么在做？ &nbsp;借助商品橱窗和购物车，电商新物种——抖商蓬勃发展，但作为以算法推荐分发的平台，抖音缺少社交基因，那么抖音就注定与社交电商无缘吗？\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	社交对电商有何价值？\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	社交电商是相对于传统电商的概念——社交本身自带去中心化属性，由此延伸出来两个特征：裂变与私域流量。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	裂变来源于社交背后的人脉关系，不仅转化率远高于传统电商，更是能基于信任进行快速传播，也就是裂变获客；\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	而私域流量于商家不仅意味着跳出平台限制自主营销获客，私域流量还具有免费、优质、高黏性、可重复转化的属性。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;text-align:center;\"=\"\"> <img src=\"http://demoall.adashuo.com/20090/uploads/allimg/c191107/15I0c25W3510-551O.png\" width=\"450\" height=\"328\" border=\"0\" alt=\"抖商研习社：如何在抖音做社交电商？-第1张图片-小七抖音培训\" title=\"抖商研习社：如何在抖音做社交电商？-第1张图片-小七抖音培训\" style=\"height:328px;width:450px;\" /> \r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	抖音也能做社交电商吗？\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	1、社交土壤\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	抖商研习社需要指出的是，抖音虽然并非社交产品，但有人的地方就有社交——抖音好友与好友间、粉丝与红人间都有着浓厚的社交氛围，只不过抖音是以陌生人关系链组成的社交平台。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	同时抖音庞大且优质的用户群——以18-28年龄为主，多分布于一二线城市，且女性占比超过60%——配合内容的高传达效率，使得社交裂变有了肥沃的用户土壤。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	2、裂变载体\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	裂变的前提是有足够的用户基础——背靠抖音数亿活跃用户池，好的视频依托推荐算法，及话题、热榜、群聊等流量分发入口，能迅速成为爆款，进而触达更多潜在用户。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	裂变的关键在二次分享，而商品橱窗与购物车并没有相匹配的能力，这就需要借助抖音小程序了：除了可以驱动用户“”挂载小程序二次传播外，小程序的营销插件也自带裂变能力，进而打通裂变的闭环。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	怎么裂变起来？\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;text-align:center;\"=\"\"> <img src=\"http://demoall.adashuo.com/20090/uploads/allimg/c191107/15I0c2593MP-E412.png\" width=\"450\" height=\"331\" border=\"0\" alt=\"抖商研习社：如何在抖音做社交电商？-第2张图片-小七抖音培训\" title=\"抖商研习社：如何在抖音做社交电商？-第2张图片-小七抖音培训\" style=\"height:331px;width:450px;\" /> \r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	1、爆款视频引流\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	抖音卖货的基本逻辑是爆款短视频引流+小程序交易，而爆款视频主要取决于算法推荐，判定标准主要为完播率、点赞评论分享率等，与其辛苦摸索做视频，更便捷的方式则是通过与红人大V合作，以种草视频的方式引流。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	2、给用户裂变的动机\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	抖商研习社有了流量并形成转化后，还需要二次分享才能形成裂变，这就需要给用户一个分享“动机”，可以是折扣、优惠券、返现、赠礼等等，而小程序的营销插件如拼团、砍价、抽奖、分销等，则可以为商家提供裂变营销工具。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;text-align:center;\"=\"\"> <img src=\"http://demoall.adashuo.com/20090/uploads/allimg/c191107/15I0c25a5020-II2.png\" width=\"450\" height=\"319\" border=\"0\" alt=\"抖商研习社：如何在抖音做社交电商？-第3张图片-小七抖音培训\" title=\"抖商研习社：如何在抖音做社交电商？-第3张图片-小七抖音培训\" style=\"height:319px;width:450px;\" /> \r\n</p>',	'doc.png',	1.00,	32,	0,	0,	0,	'2019-12-03 14:08:36',	'admin',	11,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	1.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	12,	1,	0,	1),
(8,	'台金融机构和企业可发起小额贷款公司?国台办回应',	'<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	10月19日，京东宣布今年11.11大促将首次推出“京东拼购”等玩法。10月19日，美团点评官方微信小程序也正式上线了“好货拼团”板块。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	事实上，此前已经有包括阿里、苏宁、今日头条等多家互联网巨头切入了社交拼团业务。而这一切，在笔者看来，巨头们完全已经将拼购当成了获取用户流量的下一个杀手锏。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;text-align:center;\"=\"\"> <img border=\"0\" src=\"http://demoall.adashuo.com/25707/uploads/allimg/c191120/15J2314405K20-1L320.jpg\" style=\"height:auto !important;\" /> \r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	拼购成“香饽饽”\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	根据艾媒咨询发布的《2018Q1中国社交电商行业市场研究报告》显示，2018年中国社交零售用户规模将突破3亿人，年均复合增长率将达到44.2%。这也意味着，未来社交电商或仍将有巨大的增长空间。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	而作为社交电商的集中展现形式，拼购正凸显着自身鲜活的能量。这其中，最值得注意的就是拼购已经成为巨头最新切入的业务。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	具体来看，巨头们正在尝试性地推出自家相关的拼购业务。如果让消费者直接说出某个巨头旗下的拼购业务，可能会非常轻松。因为这些巨头推出的拼购应用，名字上大同小异——手淘特价版、京东拼购、苏宁拼购、今日头条的“值点”……\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	此外，支付宝联合淘宝上线拼购小程序“每日必抢”，网易则推出了“网易一起拼”。总的来看，它们还都是以“拼”、特价为主要特性，为自己烙印下超值的标签。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	而从数据上看，拼购在近段时间以来也成为电商行业的一个热词。根据速途研究院发布的《2018上半年国内拼购电商市场研究报告》显示，在巨头的入场下，它们不仅让自身拥有了亮眼表现，还让拼购行业获得了整体提升。从微信指数和百度指数看，各个巨头的拼购业务都有着显著提升。这也意味着，以布局消费分级市场为目标的拼购，成为了当下巨头眼中的“香饽饽”。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	巨头在拼购行业的试水，还反应在将自身的资源不断向拼购业务倾斜。比如，很多巨头都举办了优惠活动来吸引消费者，并展现自身拼购业务的特性。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	比如：京东拼购频道此前公布了双11玩法，旨在以流量传播扩散+提升订单为目标，通过打造贯穿双11的拼购寻宝乐园，同时引爆11.8拼购玩法狂欢日，为拼购小程序引流，帮助平台转化新用户并提升订单量。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;text-align:center;\"=\"\"> <img border=\"0\" src=\"http://demoall.adashuo.com/25707/uploads/allimg/c191120/15J231440B4F-1U327.jpg\" style=\"height:auto !important;\" /> \r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	苏宁拼购则将重点在直采直销生鲜商品上发力。在刚刚过去的双十拼购日，苏宁拼购一天卖出了40万个柚子，这坚定了其发展生鲜拼购的战略构想。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	因此，我们可以看到，在巨头的不断试水下，拼购这一社交电商模式已经变得迅速火爆。对于消费者来说，这也是一个消费变得多元化的好兆头。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	品质化渐成主流\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	其实，如果不戴“有色眼镜”去看拼购的话，其身上还是有很多亮点的。拼购以低价引入流量，通过关系网对商品进行分裂曝光，在满足多数人追求“低价”需求的同时，又大幅度增加中小商家和尾货的曝光率和购买率。也正因为如此，拼购在当下俨然成为购物模式中的一股新势力。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	但值得注意的是，在拼多多一家独大的时候，其商品质量、售后等饱受诟病。山寨、造假的问题，也造成了诸多负面影响。而在巨头纷纷入场的情况下，实际上也意味着拼购将进入下半场。在下半场开启的同时，拼购也将迎来全新的发展拐点。拼购在展现品质化的同时，也将成为巨头业务的补充，让它们构建更为完善的商业生态矩阵。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	对消费者利好的消息，在于品质化将成为拼购的常态。同时，品质化也将是巨头拼购业务的竞争发力点。不管是为了稳固消费者群体，还是出于维护自身品牌形象的考虑，巨头都不会再去牺牲商品质量和售后来实现低价。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	它们会尽力展示自身的物流实力、电商交易技术能力、核心交易链路、消费保障制度等，将供应链优势发挥到极致。最终，巨头的拼购业务将让消费者享受到具有更高性价比的品质好货，并由此实现真正的消费升级。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	此外，拼购业务的上线也是对巨头自身实力的加强。以美团拼团为例，其让美团实现了从虚拟商品向实物商品的过度，完成了自身商业边界的扩张。中国社科院财经院互联网经济研究室主任李勇坚表示，“过去用户可能只有在吃饭等时候才想到打开美团，但如果增加了商品类拼团，既有用户可能会在APP上停留更多的时间用于浏览商品”。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	而对于巨头而言，以往虽然在努力强调业务之间的整合，但缺少了某个版块后，业务之间总会有割裂感。拼购业务的出现，或许就能成为“黏合剂”，让巨头的业务实现融合发展。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;text-align:center;\"=\"\"> <img border=\"0\" src=\"http://demoall.adashuo.com/25707/uploads/allimg/c191120/15J231440I050-1c916.jpg\" style=\"height:auto !important;\" /> \r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	值得注意的是，对于巨头来说，它们此前都面临着各自不同的发展瓶颈。而要寻找创新增长点，就必须在流量上痛下苦功。拓展流量的最佳做法，就是通过开辟新业务获取。而拼购身为“引流大户”，自然被巨头所看重。在拼购行业的下半场，它们将争抢中高端消费人群，不断攫取新的流量。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	相信随着巨头纷纷切入拼购领域，后者也在加速下沉。而就发展趋势来看，只拼价格不拼质量的原始拼购模式注定被淘汰。在被巨头开启的下半场，拼购有望与消费升级概念的成熟、人均消费能力的提升高度契合。届时，拼购业务也将成为巨头比拼的另一立脚点。\r\n</p>',	'doc.png',	1.00,	16,	0,	0,	0,	'2019-12-03 14:09:59',	'admin',	0,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	1.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	10,	1,	0,	1),
(9,	'发改委：欢迎台企积极参与大陆旅游基础设施建设',	'<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	11月5日，一项热搜出现在邦哥的微博首页，并且排名一路蹿升至第一，挂在榜首直至今日凌晨：6000多首歌从KTV下架。被下架歌曲中，《十年》、《泡沫》《死了都要爱》《听海》《K歌之王》等等大热歌曲赫然在列。许多媒体的标题用的是：你拿手的还能点么？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	而邦哥脑中也冒出了另一个问号：这些歌曲为什么被下架？谁主导了这次下架风波？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	一个民间组织，为何有权下架全国KTV的6000多首歌？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	这次下架风波毫无疑问是版权问题引起的：中国音像著作权集体管理协会（下称“音集协”）发出公告，要求KTV终端生产管理商和卡拉OK经营者在今年10月31日前，删除或者不向消费者提供6000多部音乐电视作品。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	乍一看这是一件好事，毕竟版权保护理应得到支持，即便6000多首歌的下架在短期内会给普通消费者带来一些麻烦，但依然有利于产业的良性发展。<strong>然而意外的是，邦哥就此与一位业内音乐创作者进行了解时，对方却对此次发出公告的“音集协”并不买账：这个协会其实不是国家的版权保护机构，之前还被央视曝光过收取高额版权费后，并没有给歌手支付费用，我对于之后钱的去向保留意见。</strong> \r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	业内人这样的评论，引起了邦哥的注意，我们随即找到了音集协官方微博，查看其回应此次事件的公告。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\"> <img alt=\"6609首歌从KTV下架，《十年》《泡沫》均中招，原因不止版权那么简单 \" border=\"0\" class=\"aligncenter\" src=\"http://demoall.adashuo.com/25707/uploads/allimg/c191120/15J231444420Z-10TG.jpg\" title=\"6609首歌从KTV下架，《十年》《泡沫》均中招，原因不止版权那么简单 \" style=\"height:auto !important;\" />众所周知，KTV使用他人音乐作品，需要依法取得授权。但全国KTV可以说是海量的，KTV所需要使用的作品也是海量的。实际经营中，要经营者自己去一对一地取得授权，说句实话，并不现实。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	音集协就是在这样的背景下成立的。我们查看了其官网资料，根据资料显示，该协会是会员制，注册会员后，协会可以帮助你进行统一的版权管理，对全国的KTV进行作品授权，或者进行相应的维权措施。但让邦哥十分惊诧的是，这次被下架的6609首歌，背后的版权所有者，没有一家是音集协的会员。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	换言之，<strong>音集协的权利范围本应是帮自己的会员授权和维权，这次却是向6609首他们本应管不着的歌，发放了“下架通知”</strong>……\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在音集协官方微博的回应公告中，这一消息得到了证实：\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\"> <img alt=\"6609首歌从KTV下架，《十年》《泡沫》均中招，原因不止版权那么简单 \" border=\"0\" class=\"aligncenter\" src=\"http://demoall.adashuo.com/25707/uploads/allimg/c191120/15J23144450T0-114138.jpg\" title=\"6609首歌从KTV下架，《十年》《泡沫》均中招，原因不止版权那么简单 \" style=\"height:auto !important;\" />这让邦哥不禁产生了一个疑问：不是音集协的会员，我的歌曲就不能在KTV里播放了么？音集协到底是一个什么样的组织，怎么会有这么大的权利，对非会员的作品也能进行下架处理？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	就此我们在其官网查找到了音集协的《协会章程》，章程总则中清晰地写明了音集协的性质：本团体是由依法享有音像节目著作权或者与著作权有关的权利人<strong>自愿结成的全国性、非营利性的社会组织</strong>。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	一个自愿结成的会员制民间组织，从法理上讲，应当并不具有行政执法权，按照常理本应无权对“非会员”的作品进行下架处理。而在音集协此次回应的公告中，对这一问题的描述如下：\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;text-align:center;\"=\"\"> <img alt=\"6609首歌从KTV下架，《十年》《泡沫》均中招，原因不止版权那么简单 \" border=\"0\" class=\"aligncenter\" src=\"http://demoall.adashuo.com/25707/uploads/allimg/c191120/15J2314445T30-12W41.jpg\" title=\"6609首歌从KTV下架，《十年》《泡沫》均中招，原因不止版权那么简单 \" style=\"height:auto !important;\" /> \r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	对此，邦哥咨询了法律方面的专家，对方表示：6000多首歌的权利人或其委托的代理公司对KTV经营者提起的单独诉讼，就法律关系上讲与音集协相互独立，并无关系。但公告中并未提到音集协与这6000多首歌的权利人或代理公司是否有委托关系，因此<strong>音集协此次的“下架通知”背后，是否有可能是接受了歌曲权利人本身的授权或委托，我们也不得而知。</strong> \r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	曾被众多媒体质疑、央视曝光高额版权费流向哪里？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\"> <strong>2006年，国家版权局规定，开始收取卡拉OK每包间一小时12元的歌曲版权费。我们日常去KTV的费用中，就包括了这部分版权费。</strong>那么这部分版权费收取后流向了哪里呢？根据文章开头从业者的说法，邦哥查阅了很多资料，发现这已经不是音集协第一次处于舆论中心。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	2009年，中央电视台连续多个栏目对音集协收取卡拉OK版权费的情况进行了报道；中央二套的《今日观察》栏目还播出了一期新闻专题节目《版权费还是保护费》，邀请两位专家，围绕卡拉OK版权收费及其分配问题。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	根据当时的报道，<strong>音集协自2007年开始收取KTV及卡拉OK版权费，至2009年，收取的版权费已达8000万元，但这笔钱的使用分配却很不透明，相当多歌手表示并未拿到应得的报酬，但作为集体管理组织的音集协却要收取高达50%的天价管理费。</strong> \r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在当时的采访中，音集协不愿详细说明收费方式以及对著作权人的返还方式。不过一位业内人士向央视记者透露，收费是通过一家叫做“天合文化”的公司进行的。根据公开资料，该公司成立于2007年8月，受音集协委托代收卡拉OK版权使用费。音集协负责授权，天合文化负责收费，二者形成一套KTV歌曲版权收费系统。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	而那时的国家版权局版权管理司王自强司长则认为音集协的做法有欠妥当，在接受记者采访时表示，“集体管理组织是一个非营利性机构，不能以组织企业来进行收费，只能建立自身的收费队伍。收费本体是你本身，你不能有一个第三者出来。”\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	那是音集协引起争议声浪最大的一次，此后也曾有过多家媒体跟踪报道过音集协收取版权费的相关内容。早在2008年就有北京中银律师事务所董正伟律师向国家工商总局、国家发改委举报，请求对音集协向KTV行业收取著作权使用费开展反垄断执法。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	而近两年，音集协受到的质疑更加密集了起来，2017年、2018年都有KTV联合状告天合公司（音集协的授权收费单位）进行行业和价格垄断，但最终都以天合的胜诉告终。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	有趣的是，<strong>音集协与天合文化的合作自2007年至2018年，11年间从未停止。但就在邦哥发稿前不久，音集协官网上出现了一份最新公告，终止了与天合文化的委托合作。</strong> \r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;text-align:center;\"=\"\"> <img alt=\"6609首歌从KTV下架，《十年》《泡沫》均中招，原因不止版权那么简单 \" border=\"0\" class=\"aligncenter\" src=\"http://demoall.adashuo.com/25707/uploads/allimg/c191120/15J231444A250-13U93.jpg\" title=\"6609首歌从KTV下架，《十年》《泡沫》均中招，原因不止版权那么简单 \" style=\"height:auto !important;\" /> \r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	被下架歌曲并非不能唱了，版权保护，路漫漫其修远兮\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	对于一个行业的健康发展来说，6609首无授权歌曲自KTV下架，理应得到支持。但版权收费的规范性、透明性，同样是应该得到重视领域。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在此次风波中，被认证为音集协副理事长的周亚平的微博发言，同样引发了相当多网友的不满：\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;text-align:center;\"=\"\"> <img alt=\"周亚平表示：希望权利人加入，而不加入的后果是“作品被摒弃在卡拉OK渠道之外”\" border=\"0\" class=\"aligncenter\" src=\"http://demoall.adashuo.com/25707/uploads/allimg/c191120/15J231444I530-14Kc.jpg\" title=\"6609首歌从KTV下架，《十年》《泡沫》均中招，原因不止版权那么简单 \" style=\"height:auto !important;\" /> \r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	周亚平表示：希望权利人加入，而不加入的后果是“作品被摒弃在卡拉OK渠道之外”\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在撰文的过程中，邦哥将此次下架的6609首歌曲完整名单下载了下来，发现实际上遭到下架的，只是该首歌曲的某些版本。例如周杰伦遭到下架的《告白气球》等歌，就仅限《中国新歌声》第一季播出版本被下架。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\"> <img alt=\"6609首歌从KTV下架，《十年》《泡沫》均中招，原因不止版权那么简单 \" border=\"0\" class=\"aligncenter\" src=\"http://demoall.adashuo.com/25707/uploads/allimg/c191120/15J231444PZ-15S59.jpg\" title=\"6609首歌从KTV下架，《十年》《泡沫》均中招，原因不止版权那么简单 \" style=\"height:auto !important;\" />虽然这样的版本限制让很多小伙伴产生了“虚惊一场”的感觉，但邦哥要提醒的是，<strong>版权制度的目的，以及所要保护的对象，是创作者和版权所有者的利益。权利人们的利益，决定了他们的生存环境。</strong>如果从业者无法生存，音乐产业的发展从何谈起？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	中国音乐版权保护之路，依然路漫漫其修远兮。\r\n	</p>',	'doc.png',	1.00,	26,	0,	0,	0,	'2019-12-03 14:10:31',	'admin',	3,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	1.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	11,	1,	0,	1),
(10,	'林铎:贯彻习近平新时代中国特色社会主义思想',	'<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	人工智能时代已来，雷军为小米找的下一个风口是什么？成立相机部门能“干翻”华为吗?\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;text-align:center;\"=\"\"><br />\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	▲雷军在在故宫发布滑盖手机MIX3\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	作者 |马婧\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	编辑 |赵泽 杨砺\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在喊出“今年相机部门有没有年终奖，就看能不能干翻华为”之后，小米董事长雷军又发新手机了，这一次是在故宫。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	2018年10月25日，在故宫发布磁动力滑盖手机MIX3乾清宫户外发布会，雷军在现场有点激动，一个人solo了将近一个半小时。雷军在介绍手机后置相机时，突然天空中传来两声乌鸦叫，雷军忍不住笑场，说连鸟都在肯定小米手机，“这是我们第一次办的户外的发布会，还这么有趣啊。”\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	25日早间，小米集团发布公告称，预计到10月底，手机出货量将突破1亿台，提前两个月完成2018年全年目标。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	雷军在发布会上谈到，今年手机大厂商和小厂商之间的差距会拉大，主要原因是各家在相机、AI方面投入成本不同所致。今年5月，雷军在内部信中宣布，在手机部内成立单独的相机部，集中全公司优势资源，提升小米手机的拍照品质。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	雷军曾对相机部门的同事说，今年相机部门有没有年终奖，就看能不能干翻华为。25日下午更新了最新成绩，小米MiX3以103的成绩超过了华为P20。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	小米如何“干翻”华为呢？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	▲MIX3故宫乌鸦捣乱小米发布会现场 雷军笑场：连鸟都肯定了\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	未来高增速或不靠手机靠IoT\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	新京报：小米过去8年保持了高速的增长，未来还能有非常高的增速吗？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	雷军：我们对小米未来的高速增长很有信心。首先手机行业是一个很大的市场，2017年全球共销售手机14.7亿台，小米销售了9000多万台。随着5G时代的到来，手机市场可能再次迎来增长，虽然不会像过去增长那么快了，但这个市场即便不再增长，对于小米来说仍然有巨大的成长空间。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	其次，手机之外，小米在智能硬件和消费升级领域布局广泛，已经进入了100多个品类，建成了全球最大的IoT物联网平台。随着AI时代的来临，AI+IoT将产生巨大的价值，小米已经具备了一些优势。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	另外，小米在海外市场有巨大的机遇。小米手机已经进入了74个国家和地区，还有很多市场有待进入，我们的很多品类也还没有进入全球市场。随着小米一步一步进入新的市场，把新的市场做好，我觉得小米未来还有十倍以上的成长空间。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	新京报：我们注意到小米还在布局智能家居。有观点认为智能家居是个伪命题？你怎么看这个问题？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	雷军：“智能家居”不是一个新词，二十年前在国外就有了，只是一直没有推动。我们觉得背后主要原因是商业通道和技术通道没有打通，比如以前智能家居的成本非常高，家里必须重新装修一遍，这对消费者难以负担，此外，不同厂家的产品之间也很难互联互通。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	小米做了两件事情来解决，首先我们把一个个的产品智能化了，消费者买回家后，突然发现实现了智能家居，这是商业通道理顺了。另外，我们做了互联互通的模组，在技术上也打通了，小米智能家居产品由很多不同的公司生产，但只要用了这个模组就可以互联互通。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	智能家居目前只是刚起步，小米也只是刚跨过门槛，今后智能家居的发展空间可能远超我们想像。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	新京报：有人说，小米生态产品只是在做微创新，你怎么看这个问题？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	雷军：从我们创业的经验来看，成功背后都有不为人知的艰辛，哪怕是一点点成绩，都要付出巨大的努力。所以我觉得我们不要小看微创新，为了提升消费者的体验，哪怕仅仅是1%，我们也投入了100%的精力。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	小米立志要成为一家伟大的互联网公司，让全球每个人都享受科技带来的美好生我没有。我们只有全力以赴做好每一件小事，才是走在正确的道路上。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	下一个互联网浪潮是人工智能\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	新京报：如何看待互联网这20年来在中国的发展，如果用几个关键的时间点来划分，你会怎么划分？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	雷军：我觉得2007年苹果推出iPhone是个很重要的事件，智能手机的出现极大的改变了互联网，我判断手机会逐渐替代个人电脑，移动互联网的时代将会来临。2010年小米成立，2011年推出了第一代小米手机，我们推动了智能手机在中国的快速普及和品质提升，移动支付、电商、社交网络、短视频等行业在中国的蓬勃发展，都有赖于庞大的移动互联网人口，这方面小米做了一点贡献。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	新京报：互联网下一个浪潮会是什么？在这个浪潮下，小米的机会是什么？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	雷军：人工智能的时代已经到来了，人工智能也是小米最重要的战略，我们拥有四项巨大的优势，用户群、海量设备、海量的数据、对整个AI时代的认知，很早就重视了云服务和大数据。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	小米选择的突破口是IoT，也就是万物互联，我认为AI与IoT结合将形成AIoT，也就是万物智慧互联，在这个领域未来有着巨大的发展空间。小米已经建成了全球最大的消费物联网，连接了1.15亿台智能设备（不包含手机、平板和笔记本电脑），小米人工智能助理小爱同学月活跃设备超3000万，月唤醒计数超10亿次，累计唤醒次数超50亿次。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“天使投资人经历让我学会找风口”\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	新京报：从金山时代开始，业界对你的评价就是IT劳模，怎么看待这一评价？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	雷军：如果我们要实现与众不同的梦想，付出的不比别人多，怎么可能成功呢？我现在还是这样认为，创业并不光鲜，成功的企业家也不像大家想的，轻轻松松就成功了，哪怕一点点成绩，背后都要付出极大的努力。在成功的路上，其实只有这一个秘诀认真拼命地工作。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	新京报：天使投资人的身份对于创办小米有哪些帮助？创业者和投资人的思维方式最大的不同之处是什么？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	雷军：因为天使投资人做的就是看大势，找风口。我觉得创业要想五年后是什么样子？十年后是什么样子？什么是正确的事情，什么是正确的时间点？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	我当年是一个手机发烧友，认为手机上网是未来的趋势，未来10年是移动互联网的天下，那我接着就想应该做些什么？所以我用投资人的身份，去看谁在做移动互联网，去搞清楚移动互联网到底是什么，这个过程中我们越来越坚信移动互联网的未来，最终在2010年决定创办小米。\r\n</p>',	'doc.png',	1.00,	17,	0,	0,	0,	'2019-12-03 14:11:24',	'admin',	1,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	1.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	10,	1,	0,	1),
(11,	'陈吉宁明查暗访空气重污染防治:打赢蓝天保卫战',	'<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	不在沉默中爆发，就在沉默中灭亡！\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	这句话来形容当下的区块链。2018年疯狂的区块链因受政策监管与打压，资本、媒体、甚至创业者都趋于冷静。或许，这就是黑暗里的爆发前夜吧。但这个前夜还很长很长…\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	最近一篇题为《业内人士：区块链逐步融入农业发展》文章引起我们的关注。该文提到：“截至目前，区块链已被应用于产品溯源、农业保险、农村金融、智能合约等多个场景。尽管目前区块链技术在农业领域的应用范围还较为有限，但是许多业内人士对于区块链在农业领域的未来发展前景仍然满怀期待”从种种迹象来看，业内人士非常看好区块链在农业领域和场景里的应用。另外，还有政府官员也为区块链+农业打CALL。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	内蒙古蒙草生态环境（集团）股份有限公司董事长王召明表示，作为农业大国，要利用物联网、大数据、移动互联网、人工智能、区块链等现代信息技术，大力推动农业全产业链改造升级，为实施乡村振兴战略插上互联网的翅膀。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	可以肯定：区块链没有倒下，区块链在等待机会。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	业内专家指出，2019年有望成为区块链技术真正落地应用，走向产业化的一年。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	区块链诞生之初，外界都追捧：区块链是各个行业的救命稻草。尤其金融行业、食品行业，当然也包括农业领域。我们聊聊区块链解决农业什么问题？我们认为个有以下几个问题！\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	1农业领域看好区块链\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	1农产品可溯源\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	农产品溯源一直是农业的一个痛点问题。而区块链技术利可以对记录实现不可篡改，因此从农产品的生产端到流通端、消费者都有详实的数据，可以实现消费者明明白白消费，提高消费者购买的意愿。农产品溯源可以提升农产品安全性以及食品的安全性。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	2信息透明\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	农业领域除了可溯源之外，生产者与需求方的信息也存在不透明的问题。一旦区块链技术应用与农业。大家就可以通过大数据分析，建立种植户、采购商的信用评级参考；利用智能合约在种植户和采购商之间保证公平交易。同时，区块链技术可以提高农产品买卖双方的契约精神。另外，随着食品供应链中区块链的出现，这可以简化这一过程，因为数据管理系统，将一系列农民、加工商、分销商、监管机构、零售商和消费者纳入其雷达范围的数据管理系统变得更加透明。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	3降低成本\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	区块链技术运用之后，生产、流通等2大环节的成本会大大降低。比如，区块链技术解决信息自动存贮和数据库的功能，如此就减少了人工的投入和其他设施的投入。另外，区块链及应用实现万物互联，帮助生产商和渠道商降低各项开支。同时，生产和流通成本的降低，也会降低农产品的价格，最终还是消费者获利。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	因此，区块链技术在农业领域的应用等到各级人士的认同。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	2现在的区块链农业玩家\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	从以下多个案例来看，这些企业的确把区块链技术应用到用户服务中。他们希望借助区块连技术解决食品安全和可溯源，从而提高消费者对品牌的认可度。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	1沃尔玛\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	沃尔玛公司在2017年内在区块链技术领域作出了大量尝试。沃尔玛一直在与IBM合作，共同开发针对食品安全问题的区块连解决方案。比如，沃尔玛把区块链放在芒果、猪肉等生鲜农产品上。沃尔玛食品安全副总裁Frank Yiannas曾表示：“我们的客户理应拥有更加透明的供应链。我们认为在21世纪，以前那种一步一步去追溯源头的方式已经过时了。这是一项由技术支持的明智举措，它将极大地造福我们的客户，并彻底改变食品体系，使所有的相关者受益。”\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	2 Dreyfus\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	大宗商品交易公司Louis Dreyfus（路易达孚）宣布已试用由ING（荷兰国际集团）等一批金融机构开发的基于区块链的交易系统。Dreyfus使用区块链平台来完成与中国供应商的大宗大豆交易，极大地缩短了交易时间。同时，据参与测试的公司表示，这次测试涉及从美国运到中国的大豆，并在平台内保存所有相关文件（包括销售合同和信用证）。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	3可口可乐\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	2018年，可口可乐正在与美国国务院、区块链信托加速器（BTA）、区块链技术公司Bitfury集团以及崛起币（Emercoin）共同合作，推出一项基于区块链技术的试点项目。同时，可口可乐公司建立区块里的平台，以帮助确保道德的糖生产。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	4家乐福\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	2018年，欧洲最大的零售商家乐福已经开始采用区块链账本技术去追踪鸡肉、鸡蛋和西红柿从农场送到商店的全过程，并将在未来几年在其所有生鲜产品线上部署这种技术。比如，2018年3月，家乐福中国首款区块链产品——琯溪蜜柚，获得用户疯抢。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	5 Smart农场\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	中国农业已经迎来4.0时代，高科技融合成为农业发展的方向。上海华中农投农业科技有限公司旗下Smart农场大力推动区块链的应用。将区块链技术与农业相结合后，能最大限度地消除信息不对称，提高整个产业链的信息透明度和及时反应能力，从而实现整个产业的增值。减少农药投入，提高农产品品质。解决农业的痛点，解决农产品的食品安全、食品供给问题，真的能让中国人都尝到放心的味道。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	3未来走向\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	区块链去中心化等特性，将大幅降低互联网维护成本，提升农业物联网的智能化和规模化水平。同时，基于区块链技术的农产品追溯系统，解决了消费者对于产品的信任危机，让人们的餐桌更健康，更安全。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	另据前瞻产业研究院发布的《中国区块链行业商业模式创新与投资机会深度分析报告》统计数据显示，随着区块链应用场景扩展，预计2019年具有投入产出的区块链企业超过600家，产业规模有望超过8亿人民币。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	有人预测：2019年，“区块链技术”正逐渐从幕后走向台前。我们从2个方面来看：区块链技术迎来利好！\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	1）从大背景来看，国家政策打击比特币，但支持区块链技术在各个行业的应用。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	2）从行业来看，目前大数据和人工智能的发展，区块链技术也将会逐步与其他高科技项目融合赋能产业。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在农业领域，区块链农业又将会呈现哪些趋势和走向呢？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	1物联网＋无人机＋区块链\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	中国农业已经迎来4.0时代，高科技融合成为农业发展的方向。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	物联网＋无人机＋区块链的结合将有利于精准农业的发展，减少农药投入，提高农产品品质。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	其中，物流确保万物互联，无人机提供生产管理服务，而区块链提供记录和可溯源等技术。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	2区块链+数据+人工智能\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	区块链应用于农业，能最大限度地消除信息不对称，提高整个产业链的信息透明度和及时反应能力，从而实现整个产业的增值。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	而区块链+数据+人工智能的融合发展，可以推动农业大数据的价值最大化，降低投入成本。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	3区块链+农业金融\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	2月初，中国政府发布了“关于农村金融服务振兴的指导意见”。此次提出的新框架，是国家农村振兴计划中金融服务效率提高计划的一部分。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	同时，该指南据称将有助于促进农村金融部门中如区块链等新技术的应用，以“改善农业信贷风险的识别、监测、预警和处置水平”。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	该公告还预测，新技术将鼓励金融机构“为农村电子商务开发专用贷款产品和小额支付结算功能，并开辟农村电子商务资本链”。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	区块链+农业金融将会为小农户贷款提供便捷途径，为农业金融机构的征信带来真实性和可预测性。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	4区块链+农村物流\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	随着区块链、物联网、大数据等新兴技术与物流行业的深度融合，供应链正成为区块链技术最具潜力的应用场景之一。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	由于农村物流的小散，导致包裹丢失、农产品上行困难等窘况。但区块链技术可以解决这些问题。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	西南交通大学交通运输与物流学院副院长罗霞指出示，农村振兴是今年党中央非常重要的战略部署，与农村物流高质量发展紧密相关。加强云计算、区块链、人工智能等供应链智能化技术在农村物流中的应用，为农产品的生产、检测、周转、销售、品控、管理等提供智力支持。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	5区块链+农业供应链\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	这一类应用就是各大商场嫁接区块链的原因。比如：沃尔玛、家乐福等大型超市把整个生鲜和食品供应链纳入区块链管理，从而降低成本，提高产品的安全性。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	目前，美国农业巨头嘉吉等都在大力发展区块链+农业供应链金融的应用。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	总结一下，2019年区块链在农业领域的应用将会再次迎来爆发。但我们还要明一点：区块链只是一项技术，而不是赚钱的工具。在整个农业发展中，区块链只做赋能者，而不是主导者。如此，路子才会越走越宽！\r\n</p>',	'doc.png',	1.00,	25,	0,	0,	0,	'2019-12-03 14:13:27',	'admin',	14,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	1.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	10,	1,	0,	1),
(12,	'巴铁海军远航非洲：军舰来自中国 7.5亿美元买了4艘',	'<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	电子商务飞速发展，快速增长的包裹数量与日渐减少的快递员数量已经不成正比。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	快递员的工资回报越来越高，为什么这个职业在近年来从事人员锐减呢？对此，有很多快递员反映，虽然能够得到很高的工资回报，但随着人们对服务水平的要求也越来越高，他们也越来越辛苦。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	同时，快递员的社会地位相对较低，随着人们文化水平及文化素养的逐渐提高，一些有学历有技能的人都已不太愿意做快递员。申通副总在7月25日召开的中国快递“最后一公里”峰会上就表示，现今快递行业的痛点已不仅是解决“最后一公里”的问题，而是怎样才能够招到更多的快递员。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	中国高速发展中，人口红利也在逐渐的减少，越来越多的事情都开始被智能化技术所取代，但快递行业是属于劳动密集型企业，非常依赖快递员。快递行业正处在用人难之际，双十一等各种电商狂欢节的到来无疑是让这些快递企业悲喜交加。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	智能快递柜提升末端物流配送能力，备受物流企业青睐\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	快递员不足是人口红利减少的必然结果，因此急切需要新兴技术缓解快递行业的压力，智能快递柜作为解决方案就这样“问世”了。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	智能快递柜在2012年萌芽，中邮速递易率先推出智能快递柜，在初期遭遇了很多的质疑和非议，但在包裹数量不断增长以及城市年轻劳动力不足的情况下，智能快递柜已经成为末端物流配送能力的重要补充，各路资本企业竞相涌入该市场，想分得一杯羹。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	2015年6月，顺丰、申通、中通、韵达、普洛斯投资5亿元成立丰巢科技；2016年10月，中集e栈、上海富友收件宝、江苏云柜组成创赢联盟，形成了以速递易、丰巢和创赢联盟为主的三巨头格局；2017年7月，中国邮政集团与驿宝网络入股速递易，中国邮政以50%股份控股速递易，“国家队”正式进入智能快递柜行业……智能快递柜已然成为物流企业人手必备的基础设施。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	国家邮政局10月17日发布的 《2018年9月中国快递发展指数报告》显示，快递企业与第三方创新末端投递形式，基本形成上门投递、智能箱投递、平台投递等多元末端服务体系，主要企业设立智能快件箱25万组，箱递率达到8.4%。高速增长的数据表明智能快递柜前期虽饱受争议，但后期已逐渐被民众所接受。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	智能快递柜突破派件瓶颈，效果显著\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	首先，智能快递柜降低了人力成本，减少了快递员的工作负荷。快递员的工作量和工作任务较为繁重，在人手不足的情况下一个快递员往往需要承担起更多的工作，经常超出本来的工作时间，因此快递公司需要对快递员支付较高的人力成本。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	智能快递了增加派件数量，在提高了快递员的工作效率的同时，也提高了他们的收入，在一定程度上缓解了“用人难”问题，降低人力成本。在这一点上，丰巢获取得的效果极为突出：在今年九月初，丰巢与链家进行合作并声称他们的日均派件量已高达900万+,这个数据对于快递行业来说无疑是一个巨大的进步。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	其次，智能快递柜提高了用户隐私保护力度，取件时间更随意。当今社会，人们对于隐私非常重视，而在传统的快递人员配送模式中，存在快递信息被其他人窃取或是快递在寄存的时候丢失等问题，智能快递柜保密性更强，能极大减少了这种问题的发生。再加上传统的配送模式中快递员配送的时间可能会和收件人在家的时间不对等，给收件人带来了困扰，智能快递柜投入使用使得忙碌的人们可以随时取件，极为方便。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	智能快递柜陷入困境：难盈利、争议大\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	智能快递柜诞生是时代进步的需要，也给我们的生活带来了巨大的改变，但很多问题也接踵而来。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	首先，盈利难。一方面是因为快递柜的设备生产成本高和在每一个小区内投放的租金比较高，快递柜的场地年租费也较高，同时维护费用也不低。过高的成本使智能快递柜不能为企业带来营收利润，这对每一个企业来说都是致命的打击。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	佼佼者丰巢和速递易均面临着巨大亏损：截止2017年9月30日，丰巢科技在该年9个月期间的营业收入为1.6亿元，净亏损从2016年的2.5亿元扩大到2.76亿元，负债总额扩大到12亿元；运营速递易项目的三泰科技也是出现常年亏损，2015 年亏损3792.8万元 ，2016 年亏损 12.69亿元，2017年第一季度亏损也将近3000万元。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	另一方面是用户往往不会愿意为此付费。用户认为在购买商品时已支付过运费，取快递时就不应该再支付额外的费用，使得快递柜的亏损日益增加。同时，蜂巢、速递易等快递柜也开始向快递员收取存放费用，其中速递易快递柜的收费标准为：大箱0.6元/件，中箱0.5元/件，小箱0.4元/件，但很多快递员不愿承担这些费用。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	其次，智能快递柜虽然提高了快递员配送快递的效率，但使得快递员很轻松的逃避了签收这一流程。用户无法进行当面进行签收，使得物品运输过程中出现的质量问题时的合法权益无法得到保障，收货时发现快递有问题不知该向谁反映。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	最后，在包裹数量的飞速增长的背景下，快递员如果像从前一样一件件把快递送到消费者手中显然是不太现实的事。所以现在的快递员在快递高峰时段一般都使用智能快递柜，不会打电话一一进行通知，在把物品投入快递柜时会由系统自动给用户发送取件通知，而如果快递员在放入物品时把用户的手机号输入错误，会导致用户无法接收到取件通知，从而超时取件。现在部分品牌快递柜超过一定的取件时限需要收取一定费用，这让用户难以接受。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	另外，有用户在使用丰巢快递柜时，页面会出现“打赏”等字样，价格以1、2、5元为不等，这样确实能为丰巢带来一定的收益，虽然不是强制收费并且设有“跳过”的字样，但由于字体过小，有引诱用户消费的嫌疑因此用户在使用过程易产生误解与不满。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	智能快递柜如何赢得“民心”？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	智能快递的问题柜已经严重影响后期的战略布局和发展，企业应当如何解决成了广泛关注的焦点。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	首先，智能快递柜最初出现时毫无营收利润，很大程度上是因为单纯的取件不可能有任何收入增长，但是现在智能快递柜的发展已涉及到寄件的环节，这意味着快递柜也可以从中赚取一定的利润。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	智能快递柜要想继续获得更大的盈利，应该继续为用户提供更多增值服务，让用户为此愿意付出相等的费用。比如，在各种人流量较大的公众场合，有很多用户因为手上提的东西过多有很大的不便，快递公司可以在这些场合投放寄存柜方便用户存放，并收取一定的费用，据了解蜂巢已经在试点，今年5月中标了杭州周边17个高铁站，总计36组寄存柜的订单。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	其次，面对快递柜无法当面签收的缺陷，快递柜企业应继续完善快递柜的基础硬件设施，比如在每一组快递柜上安装摄像头，用户在取包裹时可以将包裹在摄像头下展示，将来包裹质量出现问题时可以避免物流企业和用户之间产生不必要的纠纷。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	最后，针对部分用户不满快递员在未经允许的条件下投递快递柜的问题，早在2016年国家邮政局发布的《智能快件箱投递服务管理规定（暂行）》中就曾明确提出，“经营快递业务的企业在使用智能快件箱投递快件前，应当征得收件人明示同意”，同时用户有权利决定是否使用快递柜或是按指定地点取货，用户应该积极行使自己的权利。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	企业在这样的背景下应加大对快递人员基本服务知识的培训力度，同时加强对客服人员处理客诉的能力，及时处理客户问题并进行反馈。快递员在把包裹放入快递柜时应检查该快递是否为需要保鲜、即食类食品，一旦出现商品问题则由快递公司或快递员承担全部责任。面对取件通知收不到等问题，在首次投递后收件人未能提取的情况下，快递企业应及时取回快递，联系收件人后再提供投递服务。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	小结\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	时代与技术在发展中，任何行业的各个环节都应该往效率更高，成本更低道路上发展。物流末端的需求是多样化的，送货上门是主流，但智能快递柜的市场潜力也不可小觑。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	根据中商产业研究院发布的 《2018-2023年中国智能快递柜市场前景及投资机会研究报告》 ，预计2018年智能快递柜市场规模将达169亿元，到2020年，中国快递柜市场规模将达近300亿元。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	所以，丰巢等智能快递柜未来应加大沟通协调力度，在提高消费者满意度的同时，尽快解决盈利模式问题，尽可能地保证效率、成本、体验和信息的互动。\r\n</p>',	'doc.png',	0.00,	29,	0,	0,	0,	'2019-12-03 14:14:23',	'admin',	1,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	0.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	11,	1,	0,	1),
(13,	'智能大潮中的在线音频:增长乏力 谋上市是“良药”？',	'<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	今年5月，唱吧终于完成了将近一年半的上市辅导工作。网上有消息称，唱吧在一个月后，就会正式向证监会递交招股书，踏上A股创业板的上市征途。但眼看着2018年就快要过去，却迟迟未见唱吧上市的消息。对此，唱吧创始人陈华在接受媒体采访时表示，对唱吧上市问题不愿多谈，言外之意是唱吧在近期内可能不会寻求上市。这突如其来的转变，让人们疑惑不解。唱吧在完成一年多的漫长上市辅导期之后，为何不愿上市？其究竟打的是什么“算盘”？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	唱吧上市搁浅，原因为何？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	唱吧从2012年上线起，便风光无限。其在上线首日注册用户就超过10万，5天之内登顶AppStore排行榜。易观数据显示，直到2016年第3季度，唱吧还以53.6%用户渗透率位居移动K歌领域第一的位置。彼时，唱吧正如日中天，选择上市无疑是正确之举。然而世事无常，经过将近一年半的漫长辅导期，国内的在线K歌市场早已“物是人非”，唱吧已然错过了最佳的上市时机。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	其一，全民K歌抢了唱吧“风头”。众所周知，全民K歌背靠腾讯，可谓是含着“金钥匙”出生。全民K歌不仅拥有微信与QQ两大流量入口，还与QQ音乐共享丰富的音乐版权，在流量与音乐版权方面都有着天然的优势，是唱吧最强劲的对手。据了解，全民K歌自2014年上线起，其活跃人数一直高增猛涨，在2016年成功超越唱吧，并逐渐拉开差距。据易观数据，2018年第三季度，唱吧活跃用户为6560万人，而全民K歌活跃用户则为20705万人，是唱吧的三倍。面对全民K歌的“攻城略地”，唱吧显然处于不利地位。而全民K歌的赶超，可能打乱了唱吧的上市计划。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	其二，短视频平台的崛起，冲击整个互联网娱乐市场。近几年，由于快手、抖音等短视频平台的崛起，整个互联网娱乐市场变的更加“拥挤”，唱吧的K歌业务、直播业务等都受到了一定的影响。QuestMobile数据显示，2018年7月，短视频APP行业月度活跃用户规模为5.08亿人，而短视频APP行业总使用时长在移动互联网中的占比达到惊人的9.2%，要知道，就算是在线视频的占比也仅有9.5%。可见，短视频APP行业已经抢占了大量互联网用户的上网时长，唱吧无法视而不见。再加上全民K歌的存在，唱吧要想巩固自身地位并不容易，目前也很难有华丽的数据支撑，若是在此时上市，唱吧的估值可能并不理想。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	其三，互联网股市动荡不安。最近国内不少已经上市的互联网企业过的并不“如意”，如小米、拼多多和美团等企业都出现了市值大幅下滑的情况，就连腾讯、阿里巴巴等老牌互联网企业也没能避免。受此影响，唱吧此时选择不上市或许是明智之举。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	一方面，在国内互联网股市行情不利的情况下，唱吧此时上市无疑是逆水行舟，有着“流血破发”的风险；另一方面，今年国内的互联网公司纷纷申请上市形成了“上市潮”，如宝宝树、映客、小米和拼多多等，如此多的公司扎堆上市，吸引了不少资金注入，导致资本市场紧缩，也就是说投资人手里的钱越来越紧张。这也许会造成唱吧融资困难，难以得到理想的融资金额。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在这些问题影响下，唱吧暂时将上市的计划搁浅，等待更好的时机上市，或许是不错的选择。不过除了上述三个原因之外，也有业内人士猜测，唱吧之所以要搁浅上市，可能是其要放弃A股创业板，而选择赴港上市。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	港股市场火爆，令唱吧有所动摇？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	对于唱吧要赴港上市的猜测，也并不是没有依据。早在2015年，唱吧就曾想要赴美上市，但由于美国缺乏与唱吧对标的产品，而导致其估值过低，令唱吧有所顾虑。与之相比，当时国内的A股市场行情较好，且国内资本对互联网科技股也愈发青睐。所以再三思考后，唱吧毅然拆除了VIE架构，选择回国赶赴A股上市。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	时至今日，随着港交所在上市机制上的改革，首次接受同股不同权企业上市，为互联网企业打开了一扇大门，包括小米、美团点评、平安好医生和宝宝树等多家明星企业都选择在港股上市。而此时的唱吧或许面临着与三年前类似的选择题，是A股还是港股？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	据了解，上市A股要求较为严格，除了必须盈利三年才能申请IPO外，还必须同股同权。而现在的港股市场，除了支持同股不同权企业上市，其监管机构也更加独立透明和高效，公司一般在6到12个月就能完成上市过程，可以帮助企业更好地把握好上市时机。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	此外，A股实行的是“T+1”交易制度，股民们当天买进的股票当天不能卖出，且还有涨跌幅限制。而港股采用的则是“T+0”交易制度，在当天交易时段内，相关机构和股民们可以自由买卖，交易次数与涨跌幅均无限制，这种方式不仅能够提高市场的交易量，还能帮助投资者及时止损。所以二者相对比较来看，港股市场规则似乎更加灵活且合理化，能帮助企业有更好的发展。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	且从根本上来讲，企业上市无非就是希望借助资本的力量，获得更好、更快速的发展。而随着港交所改革，港股已经成为了众多互联网公司上市的首选。在此条件下，唱吧若是选择“跟风”，改赴港股上市，也不是没有可能。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	不过从目前来看，在市场竞争加剧、股市动荡等问题影响下，唱吧此时上市并不稳妥。所以暂时将上市计划搁浅，继续修炼“内功”，才是唱吧最好的选择。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	养精蓄锐，厚积薄发\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	目前，纵观整个移动K歌市场，已然是唱吧与全民K歌双雄称霸的局面，像天籁K歌、K米和酷狗唱唱等K歌产品已经难以给全民K歌、唱吧二者带来威胁。可见，唱吧在移动K歌领域还是有着非常明显的领先优势，只要其能够完善自身，加强功能创新，或许就能够摆脱全民K歌所带来的竞争压力，在互联网娱乐市场中走的更远，其上市之路也会变得更为平坦。对此，唱吧可以从以下三个方面入手。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	首先，丰富曲库资源，提高音乐品质。音乐版权是移动K歌行业的刚需，缺少相应的音乐版权，用户就无法得到理想的K歌体验。如在用户K歌时，一定会选择自己喜欢的音乐进行录唱，但用户若是在唱吧中搜不到自己想要唱的歌曲，在别无选择之下，用户就会选择用其他的K歌软件进行录唱，最终造成唱吧的用户流失。因此，唱吧要想缩小与全民K歌的差距，还需与相关的音乐版权公司合作，丰富自己的曲库资源。同时，唱吧还应继续提升APP内的伴唱、录音和修音等音乐品质，争取为用户提供更加优质的K歌享受，以此来留住和吸引更多用户。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	其次，加强线上、线下融合，丰富用户K歌体验。如今，唱吧正在大力布局线下市场，其不仅花费数千万元战略投资麦颂KTV，并实现了与麦颂KTV在社交、服务等多方面的合作，还大力布局线下移动迷你KTV业务，取得了不错的成效。据了解，唱吧不光在全国拥有400多家麦颂KTV门店，还在商场、超市和机场等公共场所布下了2万多台迷你K歌亭。不过唱吧虽然在线下布局极广，但其线下资源还未能与线上达到有效的结合。目前唱吧在APP内只提供了KTV包房预定、在线点歌和在线切歌等常用功能，还有很大的完善空间。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	对此，唱吧可以在APP内添加游戏点歌、K歌评比和K歌挑战赛等有趣功能，加强用户线下与线上的互动。同时，用户在麦颂KTV里演唱的歌曲最好也能保存在唱吧APP中，让用户可以在唱吧APP中发布并分享自己在麦颂KTV里的演唱歌曲，这不仅满足了用户的分享欲望，又加强了线上与线下的融合，可谓是一举两得。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	最后，走出海外，争夺更大的移动K歌市场。如今，唱吧已经在国内取得了不错的成绩，其知名度和影响力也都达到了一定的高点，所以唱吧要想再有突破，并不容易。在此情况下，唱吧若是向海外市场发起冲击不失为一个选择。一方面，目前海外的许多国家都缺少类似唱吧这样的K歌产品，还是一片蓝海，这对唱吧来说有着不错的发展机遇；另一方面，在全民K歌、抖音、快手等平台影响下，国内的互联网娱乐市场空间变窄，唱吧要想继续在此环境中发展将受到不小的阻碍。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	总的来说，虽然上市会为唱吧带来新的发展机遇，但在市场竞争加剧、股市动荡等问题影响下，此时上市，对唱吧来说有着较大风险。因此，唱吧只有继续精细化运营，加强线上线下融合，并等待时机成熟后再进行上市，才会迎来更好的发展。\r\n</p>',	'doc.png',	0.00,	21,	0,	0,	0,	'2019-12-03 14:17:25',	'admin',	3,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	0.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	4,	1,	0,	1),
(14,	'中国碳卫星数据正式对外共享 可在太空监测碳排放',	'<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	换上炫彩外壳，装上多变口味的烟弹，上市多年的电子烟今年突然热度飙升，成了备受追捧的创投领域。除了罗永浩在发布会上顺势推销的福禄电子烟，2018年末到2019年初，还有近10个新兴电子烟品牌出现。在深圳华强北电子市场，出售电子烟的广告牌更是如雨后春笋般涌现。但面对日趋严密的控烟大网，创业者们能否咽得下“这口烟”仍存在极大变数。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\"> <strong>电子烟突然变网红</strong> \r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	蓝莓、菠萝、水蜜桃、绿豆冰棒、柠檬茶……说到这些，不少人会联想到口香糖或是冰淇淋，却几乎没人能想到，这些全都是电子烟推出的新口味。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	精巧如U盘或是一根签字笔，也不用点火，从口袋里掏出来，打开开关就能用——近一年来，以电子产品形象出现的电子烟成了创投领域的新网红。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	今年1月，罗永浩在子弹短信新版本“聊天宝”发布会上，顺势推销了一款名为福禄、由锤子科技二号人物朱萧木创业推出的电子烟产品。紧接着，同道大叔创始人蔡跃栋与黄太吉创始人赫畅推出的“YOOZ柚子”，5位自媒体人组成创始团队的“灵犀&nbsp;LINX”也纷纷杀入。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	猪年春节，常年浸淫在科技圈、创投圈的自媒体人士陈女士惊讶地发现，平日里不抽烟的她，竟然收到了3种不同的电子烟产品作为新年礼物。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在深圳华强北，曾经卖VR眼镜、贴牌手机和智能家居产品的柜台，纷纷开始转售电子烟。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	突如其来烧起来的电子烟，背后是资本不断添柴加火。2018年，国内有十几家电子烟公司获得资本青睐，总融资额达数亿元。Wel鲸鱼、YOOZ柚子、魔笛MOTI、TRYMIX反正、GOIN谷云、APOC……新兴的电子烟品牌让人目不暇接，俨然造就了岁末年初最火热的创业领域。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\"> <strong>风口背后的同质化</strong> \r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“电子烟界的iPhone”、“颜值爆表一口解馋”、“重新定义吸烟”……在各家打出的广告语中，几百元一支的电子烟似乎成了可供电子发烧友们品玩一番的电子玩具。然而，花哨热闹的营销语言背后，电子烟的实质技术并没有太大区别。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“花几个月到半年时间，联系供应商、备货、外观设计，剩下就不需要你再做什么了，几乎没有任何硬性投入，本质上是个非常‘轻’（投入）的生意。”早期投资人付强向媒体透露，做一个电子烟项目，对技术等原创能力的要求几乎没有门槛。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	多位行业人士透露，由于国内电子烟供应链已经被电子烟发展较为成熟的国外市场培育得非常完备，因此很多新创立品牌都是通过代工生产。有技术爱好者对几款热门电子烟进行评测后发现，几个品牌在开关控制、烟油技术等方面相差无几，只是烟弹、外壳颜色、口味等进行了不同的排列组合与拼凑。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“电子烟的产品结构并不复杂，主要构成也就是充电电池（烟杆）、雾化器还有烟油三部分。”新晋电子烟品牌灵犀创始人章晋源坦言，电子烟的制造门槛并不高，确实存在行业同质化问题，“灵犀LINX当前着重聚焦于品牌环节，属于产业链下游，希望设计的首款产品具有品牌辨识度。”\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\"> <strong>电子烟也有多重风险</strong> \r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“清肺水果味”、“健康清肺蒸汽烟”……稍加留意就会发现，不少电子烟公司将产品与健康挂上了钩。在他们口中，因抽烟承受健康风险的烟民可以通过电子烟追求潮流文化、拥有“健康生活方式”。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	电子烟是否能够像一些公司所说的那样起到“代烟”、“辅助戒烟”的功效？目前尚无定论。令人担忧的是，一些原本不吸烟的人因为对电子烟的好奇而加入了烟民行列。在游戏公司工作的白先生告诉记者，他的同事和合作伙伴里出现了好几位新一代“电子烟民”——而他们过去根本不碰香烟。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	北京营养师协会理事顾中一提醒，电子烟中虽然没有普通烟草燃烧所产生的焦油、一氧化碳等有害物，但仍然含有有毒、成瘾的尼古丁，对普通人特别是儿童、青少年仍然有危害。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	记者在一家电子烟的天猫店铺内发现，虽然商品详情页面的底部用黑色背景的字体写着“未满十八岁不允许购买”，但一不留神就会错过这一信息。并且，记者在尝试下单时，店铺对身份信息、年龄等方面毫无要求，消费者可以随意下单购买。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	顾中一还提醒，由于目前市场监管并没有完全到位，缺乏相关国家标准，电子烟产品中用到的原料、调味剂、工艺都较为随意，厂家很可能为了增加新奇体验加入一些对人体有害的物质。“哪怕是一些比较常见的添加剂，正常食用是安全的，吸入肺部却可能带来潜在风险。比如丙二醇是很常见的食品添加剂，但是燃烧后容易刺激呼吸道，一些电子烟的烟雾中也可能含有重金属。”\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	对创业者来说，更大的考验来自于市场的不确定性。在控烟大势下，多地已经将电子烟列入了管控范围。今年2月，继杭州、南宁等城市在公共场所禁止使用电子烟之后，深圳在其控制吸烟条例征求意见稿中将电子烟纳入了控烟“黑名单”。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	意识到道德、法律等多重风险，一些科技上市公司急于与电子烟划清界限。今年2月中旬，小米公司官方微博就对“小米旗下生态链公司将进军电子烟领域”一事进行回应，称“小米不会做电子烟，此事纯属谣言”。\r\n	</p>',	'doc.png',	1.00,	23,	0,	0,	0,	'2019-12-03 14:18:03',	'admin',	2,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	1.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	3,	1,	0,	1),
(15,	'百箱齐发：2019智能音箱谁主沉浮？',	'<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	2018年可谓是中国智能音箱的元年。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	业内普遍认为，智能音箱是切入智能家居使用场景、并易于被用户接受的理想入口，而智能家居的开关一旦被打开，更多的产品和服务将快速进入消费者的日常生活，获得一个更多元的商业环境。因此，近两年国内外科技巨头、互联网巨头皆大力发展智能音箱，使得该领域得到飞跃式增长，并从小众逐渐走向大众。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	值得一提的是，智能音箱除了具有巨大的消费市场外，对于互联网巨头们来说更起到AI市场的“门票”的作用。在这个快节奏的时代，企业之间的竞争更加激烈，率先拥有某一行业的门票就相当于成功了一半。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	由此，继国外亚马逊、谷歌、Facebook、苹果等科技巨头布局智能音箱产业之后，国内如阿里、百度等巨头也纷纷入局，小度智能音箱、叮咚、天猫精灵等产品在市场活跃度直线上升，国内智能音箱市场一片繁荣，随后在去年打起了“智能音箱价格战”。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	全球互联网巨头共掀全球智能音箱浪潮\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	根据Strategy Analytics发布的《2018年第三季度全球智能音箱市场报告》，2018年第三季度全球智能音箱出货量达到2270万，同比增长197%，创历史新高。其中，亚马逊智能音箱的全球份额与2017年相比有大幅下降，但出货量一直在上涨，第三季度市场占有率依然最高，达到32%，而谷歌以23%的市场占有率紧追其后。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	值得一提的是，来自中国的阿里、百度、小米智能音箱出货量分别排在全球第三、第四、第五位。当中又以百度表现最为亮眼，其市场占有率从2018年Q2的1％增加到2018年Q3度的8％，超越小米，成为当之无愧的黑马。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	而根据eMarketer《2019年智能音箱市场趋势观察》的预测，2019年中国将拥有8550万智能音箱用户，超过美国7420万的用户数量。智能音箱在美国网民中的普及率为26.0%，远高中国的10.0%，因此未来中国智能音箱领域还有极大的发展空间。不过即便如此，国内企业想要在智能音箱领域进一步发展仍有极大挑战。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	首先，是亚马逊、谷歌、苹果等海外企业更加成熟的智能音箱产品的冲击。亚马逊于2014年11月发布了Echo音箱，揭开智能音箱的序幕，打了人工智能领域“领头羊”谷歌、设备领域“领导人”苹果一个措手不及，成为智能音箱领域的第一人，为其之后进军智能家居领域打下基础。随后谷歌、Facebook、苹果等科技公司纷纷跟进，相继推出GoogleHome、Portal、HomePod。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	而后，无论是亚马逊并购互联网路由器初创企业Eero，还是谷歌推出Google Wifi，都表明国外在智能家居领域发展正愈加成熟，由此给国内市场带来的冲击是巨大的。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	其次，是国内错综复杂的智能音箱市场而产生的原生阻力。国内智能音箱市场厂商繁杂，主要有五种类别：一是以BATJ等为主的互联网公司，希望通过语音这一入口建立智能生态，为既有的内容和服务寻找新市场；二是以科大讯飞为代表的，专注于技术开放平台建设的技术厂商；三是以喜马拉雅等内容厂商；四是主打智能家居的创业公司；五为以漫步者为代表的传统音箱厂家。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	与国外相比，国内智能音箱领域除了厂商更繁杂、竞争更激烈外，在时间上也有一定的滞后性。国内第一款智能音箱叮咚诞生于2015年，由京东与科大讯飞联合推出。此后国内智能音箱市场沉寂，直至2017年阿里试探性地推出天猫精灵，小米、百度等企业不甘落后，纷纷入场，国内智能音箱才进入密集发售期，一时间智能音箱领域热闹非凡，“百箱争鸣”。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	当先天不足遇上恶劣生存环境\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	当下，我们不能否认的是，随着家庭中联网设备的不断增加，有极大几率成为未来智能家居控制中枢的智能音箱有着非同一般的重要性。但古往今来，利益有多大，风险就有多大。对于如钥匙般的智能音箱领域来说，发展面前有三问需解答。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	首先，智能音箱如何“智能”？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	每当市场有了新的风口，就会出现无数跟风之人，智能音箱也不例外。为搭上智能音箱的顺风车，传统音箱厂家推出不少产品，只不过卖点都集中于音质，本末倒置。 另外，“语音识别技术”也是尚未完善，一方水土一方人，同一语种还有不同口音，更别提各地方言以及语境涉及到的自然语言理解问题。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	除此之外，还有人工智能和物联网领域中老生常谈的安全隐患问题，如数据存储、身份认证、敏感数据保护等，在此不多赘述。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	其次，智能音箱如何提高普及率与使用率？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	我们知道，物联网时代“未来智能家居的控制核心”这一定位是智能音箱如此火热的重要原因之一。而理想的智能家居生态并非是家居单品的智能化，而是彼此联动，达到互联互通互控的状态，但目前的智能家居系统仍旧处于互相独立的状态，使得智能音箱使用率不高，如同“鸡肋”。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	与国内相比，国外在此方面就先进得多，以美国为例，美国的智能家居行业有统一的标准协议，亚马逊的Echo可以直接接入各种智能家居设备，这也是为何美国智能音箱普及率远高中国的原因。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	最后，国内企业如何“走出去”？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在用户习惯方面，国内外有着不小的差异。以使用环境为例，国外用户居家环境多为开放式，美国家庭主妇在烹饪时都喜欢听音乐，因此智能音箱在国外的消费需求也相对较高。而国内，厨房客厅封闭性更高，生活环境相对嘈杂，相应地市场对智能音箱需求较低。此为国外厂家难以进入中国市场的重要原因之一，另一限制则是人机交互的“本土化”程度低。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	以苹果HomePod为例，虽然其Siri语音助手对中文的支持已经有一定成果，但在交互、理解能力等方面，与本土选手阿里、百度相比仍是落后。并且，以BAT为代表的国内企业拥有更多本土资源，境外企业如苹果，很难在中国有突破性进展。同理，国内企业想要走出去也会遇到同样的难题。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	综上，智能音箱可谓是“腹背受敌”，而现阶段各巨头发展智能音箱的主要目的并不是盈利，而是抢占更多的用户家庭，为未来AI生态建设进行数据铺垫。那么，中小企业如何在这场战争中存活呢？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	双重风暴下，智能音箱可靠内容过冬\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	前文提过，国内有一类以喜马拉雅为代表的注重内容的智能音箱厂商，笔者认为现阶段此类厂商可能更好存活。现今用户对智能音箱的主要需求还处于“听”的情况下，智能音箱很大程度上是内容生态之争。在此基础上，喜马拉雅以自身丰富的内容为基础，推出智能音箱小雅，将更容易在家庭场景中突围。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	虽然从整体上看，喜马拉雅与BATJ等互联网巨头在技术和未来AI整体布局上存在相当大的弱势，但由于各种原因的限制，国内用户对智能音箱的需求在接下来很长一段时间里，都将处于“听”的阶段。并且，智能音箱核心技术“语音识别”，从本质上来说也是内容的一部分。从另一角度看，喜马拉雅的竞争对手也并非是BATJ等互联网巨头，其在智能音箱领域的发展更多的是为了扩充自身音频业务，巩固自身在在线音频市场的地位。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	同样的，在内容资源上有着强大优势的还有腾讯，毕竟现阶段消费者购买智能音箱的主要用途就是内容消费和智能家居两方面。在此基础上，腾讯可将自身音乐、阅读和视频整合，为智能音箱做内容支持。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	除了内容消费，“智能音箱+教育”的模式发展空间也十分广阔，尤其是早教领域。抛开说烂了的在线教育，光是国人对子女教育的重视程度，就足以让智能音箱注意到“早教”这一领域。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	单从目前智能音箱市场情况来看，短时间内C端消费市场的表现都比不过B端。因此，如何在B端站稳脚跟再最终反哺C端，是智能音箱发展过程中相当重要的一点。站在这个角度上看，“智能音箱+早教”的未来十分令人期待。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	毕竟，国内早教行业师存在资水平有限，地域发展不平衡，多数幼师仅经过短期培训就上岗从业，专业化程度低等问题。若是将智能音箱与早教结合，它所承载的大量专业、系统、科学的早教课程，能完美弥补传统绘本、书籍、视频等的缺点，再加上其操作简单、安全性高、不损伤视力的优点，能让智能音箱成为早教过程中不可或缺的工具。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	当然，除了以上两个方向，智能音箱作为人工智能音频端的入口，能够发展的B端场景是十分丰富的。就此，在C端市场来临前，国内非巨头企业在智能音箱领域也有了新的突破口。那有没\r\n</p>',	'doc.png',	1.00,	20,	0,	0,	0,	'2019-12-03 14:18:52',	'admin',	4,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	1.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	4,	1,	0,	1),
(16,	'诈骗团伙分赃不均起内讧 有人报警求助被团灭',	'<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	社交网络下一步发展的未来在何方？6日，Facebook创始人扎克伯格给出了自己的答案。在一篇长达3200字的公开博客文章中，这家全球最大的社交网络的掌门人称，未来Facebook将专注于营造一个更为私密和安全的网络社交环境。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“当我思考网络的未来，我认为专注于隐私的通讯平台相比今天的开放平台，将变得更加重要，”扎克伯格写道：“今天我们已经看到私密消息、短故事分享和小规模群组是在线通讯交流发展最快的领域。”\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	尽管扎克伯格认为，开放社交网络在未来仍有一席之地，但更大的机会在于“建立一个首先专注于隐私的更为简单的平台。”\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	扎克伯格称，在过去15年间，Facebook和Instagram帮助建立了一个“数字化的公开广场“，但人们开始迫切需要更为私密的”数字化的客厅空间“。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	对于Facebook来说，这将是一个具有里程碑意义的转型，成立15年来，Facebook成功打造了全球最大的公开社交网络，并在此基础上建立起一家以广告业务为主的商业帝国。但近年来，随着一系列与用户数据隐私泄漏相关的丑闻接连爆发，Facebook开放社交模式遭遇到前所未有的严峻挑战。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	正是由于内外部坏境发生的变化，促使Facebook开始思考接下来的转型方向，如今，这家全球最大的社交网络通过其掌门人的一封公开信给出了解答。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“我认为未来的通讯将更多地转向私密的、加密的服务，这样人们在与别人交流时，对于信息的安全新、内容不会停留会更有信心，”扎克伯格说，“这是我希望我们能够帮助带来的未来。”\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	为了达成这一目标，扎克伯格称，Facebook即时通讯平台将向Whatsapp的模式靠拢，未来端到端的加密服务将贯穿于Facebook所有旗下包含即时通讯的业务功能，该表态印证了此前外界流传的Facebook计划打通旗下即时通讯功能的传言。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	扎克伯格称，计划按照打造WhatsApp的模式进行：专注于最为基本和私密的应用场景即时消息开始，让其尽可能的安全，然后在此之上建立更多让人们能够互动的方式，包括打电话、视频聊天、群组、故事、商业、支付最终成为更多私人服务的平台。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	为了实现这一转型目标，扎克伯格列出了数项准则，包括加密、缩短内容的存续、安全、互通和安全数据存储。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“我相信我们应该朝着建立这样一个未来世界而努力：人们可以私下说话并且知道他们的信息只会让他们希望看到的人看到并且不会永远存续下去，“扎克伯格说，”如果我们能够帮助世界朝着这个方向发展，我将会为我们所做出的努力感到自豪。“\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	以下为扎克伯格公开博客全文：\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	注重隐私的社交网络愿景\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	过去几年，我的重点一直是理解和应对Facebook面临的最大挑战。这意味着对关系到互联网未来的重要问题采取什么立场。在本文中，我将概述Facebook围绕建立以隐私为中心的信息和社交网络平台的愿景和原则。有许多的事情要做，在开发的进程中，我们承诺开放式的工作，并将与全社会的专家进行协商……\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	过去15年间，Facebook和Instagram一直在帮助人们与友人、社区和等同于数字城市广场中的兴趣联系在一起。但是人们也越来越想私下在相当于起居室的数字环境中进行交流。当我思考互联网的未来时，我认为一个注重隐私的交流平台将变得比今天的开放平台更加重要。隐私让人们有自由做自己，更自然地联系，而这些是我们建立社交网络的原因。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	今天，我们看到私有信息、短暂的故事和小型群组已成为在线通讯中增长最快的领域。这有许多原因。许多人更喜欢一对一交流，或者只是与几位朋友交流。人们对分享有永久记录的内容更加谨慎。我们也都希望能够私下和安全地进行支付。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	公共社交网络将继续在人们的生活中发挥重要作用--与你认识的每一个人联系；发现新的人、想法和内容；让人们有更广泛的发言权。人们每天都会发现有价值的内容，而且还有很多有用的服务可以构建在它们之上。但是现在，人们也想通过各种方式私下交流，这也让我们有机会打造一个首先专注于隐私、更简单的平台。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	我明白很多人不认为Facebook有能力、或者甚至不想构建这种以隐私为中心的平台，因为坦率地讲，我们目前在构建隐私保护服务方面没有很好的声誉，而且我们一直专注于更开放的共享工具。但是我们已多次表明，我们可以通过进化来打造人们真正想要的服务，包括私有信息和故事。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	我认为，通信的未来将越来越多地转向私有、加密服务。在此类服务中，人们可以确信他们对彼此说的话是安全的，他们的信息和内容不会永远存在。这是我希望我们能帮助实现的未来。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	我们计划用开发WhatsApp的方式来构建这一平台：专注于最基本和私有用例--消息--尽可能确保它的安全性，然后构建更多的方式让人们在此基础上进行互动，包括通话、视频聊天、群聊、故事、商业、支付、商务，最终成为许多其他类型的私有服务的平台。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	这个注重隐私的平台将围绕以下几个原则构建：\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	·私下互动：人们应该拥有简单、亲密的场所，在那里可以清楚地控制谁可以和他们交流，并且相信没有人可以接触到他们分享的内容。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	·加密：人们的私人通信应该是安全的。端到端加密防止任何人，包括我们在内，看到人们分享在我们服务中的内容。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	·减少永久性：人们应该感到自在，不应担心他们分享的内容会反过来伤害自己。因此，我们不会将信息或故事保留超过提供服务所需的时间，也不会超过人们希望它们留存的时间。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	·安全：人们应该期待我们会尽一切努力，在加密服务可能的范围内，确保他们在使用我们服务时的安全。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	·互操作：人们应该能够使用我们的任何应用联系他们的朋友，应该能够轻松安全地通过网络交流。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	·安全数据存储：人们应该期待我们不会在隐私和言论自由等人权记录薄弱的国家存储敏感数据，保护数据被不当访问。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	未来几年中，我们计划围绕这些想法重建更多的服务。在此行程中，我们面临的决定将意味着对关系到互联网未来的重要问题采取什么立场。我们清楚有很多权衡需要纠正，我们承诺与专家进行协商，并讨论最佳的前进方向。这需要一些时间，但我们不会关着门朝着这个方向发展。我们将尽可能以公开、合作地态度这样做，因为其中许多问题影响到社会的不同层面。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	私下互动是基础\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	要让一项服务感觉具备私密性质，绝不让用户怀疑在和谁交流。我们努力在所有产品中建立隐私属性，包括公共分享产品。消息服务的一个重要特性是，即使用户的联系人列表在扩充，用户的个人线程和群组仍然是私有的。随着时间的推移，用户的好友会逐渐发展，消息服务会优雅地发展，并保持亲密。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	这与更广泛的社交网络不同。在社交网络中，人们可以积累好友或追随者，直至服务更加公开。这非常适合许多重要的用途--告诉用户所有的朋友一些事情，在重要的话题上传递用户的声音，寻找有相似兴趣的人群，追踪创作者和媒体，买卖东西，组织筹款人，发展业务，或者让用户认识的每一个人在相同的地方得到好处。尽管如此，当用户一起看到所有这些经历时，感觉更像是一个城镇广场，而不是一个更私密的空间，比如客厅。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	我们有机会建立一个关注人们想要私下交流的所有方式的平台。这种隐私和亲密感不仅仅是技术特征--它被深深地融入到服务的整体感觉中。举例来说，在WhatsApp当中，我们的团队专注于在产品的各个方面创造一个亲密的环境。即使我们构建了允许更广泛分享的功能，这仍然是一种不太公开的体验。当团队开发群组功能时，他们设定了规模限制，以确保每一次互动都是私密的。当我们在WhatsApp上发布故事时，我们限制了公共内容，因为我们担心这种做法可能会削弱隐私感--即使这并没有真正改变用户和谁分享。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	几年后，我预计未来版本的Messenger和WhatsApp将成为人们在Facebook网络上交流的主要方式。我们致力于让这两款应用更快、更简单、更私密、更安全，包括端对端加密。然后，我们计划增加更多与好友、团体和企业私下交流的方式。如果这种进化成功，通过Facebook网络与用户的好友和家人互动，将会从根本上成为一种更加私密的体验。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	加密与安全\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	人们期望他们的私人通信是安全的，并且只被收方看到，而不是黑客、罪犯、过度干预的政府，甚至是操作正在使用的服务的人。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	人们越来越多的意识到，更多的实体可以访问自己的数据，就越容易被人滥用或被网络攻击泄露。一些人也越来越担心，技术可能会将权力集中在政府和像我们这样的公司手中。一些人担心我们的服务可能会访问他们的信息，并将其用于广告或其他他们不期望的方式。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	端到端加密是开发注重隐私的社交网络的重要工具。加密正在分散--它限制了像我们这样的服务看到流经的内容，并使其他人更难访问用户信息。这就是为什么加密在我们的网上生活中越来越重要，从银行到医疗健康服务。这也是为什么我们在收购WhatsApp后把端到端加密植入WhatsApp中的原因。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	去年，我曾与持不同政见者交流过。他们告诉我，加密是他们自由甚至活着的原因。一些政府经常对数据提出非法要求，当我们在法庭上驳回这些要求时，我们总存在败诉的可能--如果信息没有加密，我们要么必须交出数据，要么不遵守法庭规定导致员工被逮捕。这看起来很极端，但是我们曾有过这样的案例，一名员工就因为不提供对某人私有信息的访问而身陷囹圄。事实上，我们也无法访问这类信息，因为它是加密的。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	与此同时，在我们能够在所有消息服务中部署端到端加密之前，我们需要解决真正的安全问题。加密是保护隐私的有力工具，但也包括做坏事的人的隐私。当数十亿人使用同一服务连接时，他们中的一些人会将它滥用于真正可怕的事情，比如剥削儿童、恐怖主义和敲诈勒索。我们有责任与执法部门合作，并尽所能帮助防止这些行为。我们正努力通过检测活动模式或其他方式，来提高识别和阻止应用中不良行为的能力，即使我们看不到消息的内容，我们将继续对这项工作进行投资。但是我们面临着一个内在的权衡，因为当我们的安全系统能够看到这些信息时，我们永远也不会发现我们今天所做的所有潜在伤害。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	找到保护隐私和安全的正确方法，是社会在历史上一直努力解决的问题。这里还有许多悬而未决的问题，我们将与安全专家、执法部门和政府协商实施安全措施的最佳方式。我们还需要与其他平台合作，以确保整个行业能做出正确的事情。我们越是能创造一种共同的方法越好。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	总的来说，我相信为所有私人通信实施端到端加密是正确的。人们通过信息和电话完成一些最敏感的私人谈话，在网络安全威胁日益增加、许多国家政府干预过度的情况下，人们希望我们采取额外措施来保护他们最私密的数据。对我而言这似乎是对的，只要我们花时间构建适当的安全系统，尽可能在加密服务的范围内阻止不良行为。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	我们已开始在WhatsApp的基础上开发这些安全系统，在全面实施端到端加密之前，我们将在2019年及以后与专家讨论这些系统。随着我们从专家那里学到更多的知识，我们将最终确定如何推出这些系统。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	减少永久性\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	我们越来越相信在短时间内保存信息非常重要。人们想知道他们分享的信息不会反过来伤害他们，减少他们信息的存储和访问时间会有所帮助。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“永久性问题”开发社交工具的一个挑战是。随着时间的推移，我们积累了大量的信息和照片，它们在成为资产的同时，也成为了一种负担。例如而言，许多Facebook的老用户可能会有年轻时候的照片，这可能会让人尴尬。但是人们也非常喜欢记录他们的生活。如果Facebook和Instagram上的所有帖子都消失了，人们将无法获得他人分享的大量宝贵知识和经验。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	我认为有机会为私有通信平台设定一个新的标准--内容会自动过期或随时间归档。除非用户存档，否则故事会在24小时后过期，这让人们更自然地分享。这种理念可以扩展到所有私人内容。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	举例来说，在默认情况下，信息可以在一个月或一年后删除。这将降低用户的信息再次出现并让他以后尴尬的风险。当然，如果用户愿意，可以自己改变时间框架或者关闭线程的自动删除。如果用户愿意，我们还可以为用户提供选项，让他将个人信息在几秒钟或几分钟后设置为过期。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	限制我们存储消息元数据的时间也有意义。我们使用这些数据来运行我们的垃圾信息和安全系统，但我们并不总是需要长时间保留这些数据。解决方案的一个重要部分是首先收集较少的个人数据，这也是WhatsApp从一开始就建立的方式。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	互操作\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	人们希望能够选择他们用来与人交流的服务。然而，今天如果用户想在Facebook上给人们发信息，你必须使用Messenger；在Instagram上必须使用Direct；在WhatsApp上必须使用WhatsApp。我们想给人们一个选择，这样他们可以通过这些网络从他们喜欢的任何一款应用联系他们的朋友。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	互操作性有隐私和安全优势。举例来说，许多人使用Android上的Messenger收发短信。这些文本不能进行端到端加密，因为短息协议没有加密。然而，有了跨我们服务传递信息的能力，用户就可以从Messenger向WhatsApp中的某人的电话号码发送加密短信。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	这还可以提高许多体验中的便利性。在这些体验中，人们使用Facebook或Instagram作为他们的社交网络，WhatsApp作为他们首选的消息服务。举例来说，许多在市场上出售商品的人会列出他们的电话号码，这样人们就可以发送与购物相关的信息。这并不理想，因为用户要给陌生人提供电话号码。有了互操作性，用户就可以使用WhatsApp接收发送到Facebook账户的信息，而无需分享电话号码--买家也不用担心卖家是喜欢在哪个网络发信息。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	可以想象许多类似这样的简单体验--一个人在Instagram上发现了一家公司，并很容易过渡到他们喜欢的消息应用，以获得安全的支付和客户支持；另一个人想追上一个朋友，可以向他们发送一条消息，发送到他们喜欢的应用，而不必考虑这个人喜欢在哪里被联系；或者用户只需在Facebook和Instagram上发布一天的故事，就可以在一个地方得到好友的所有回复。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	今天，用户已可以通过Android上的Messenger发送和接收短信，我们希望在未来进一步扩展这一功能，或许包括新的电信RCS标准。然而，在这成为可能之前，我们需要解决几个问题。首先，苹果不允许应用在他们的设备上与短信交互操作，所以我们只能在Android上这样做。其次，我们需要确保互操作性不会损害人们已使用WhatsApp的加密预期。最后，它会在加密系统中造成安全漏洞和垃圾邮件漏洞，让人们从未知的应用中发送信息，因为我们的安全和安保系统看不到这些活动的模式。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	这些都是重大挑战，有许多问题需要进一步协商和讨论。但是，如果我们能够实现这一点，我们就可以给人们更多的选择，让他们使用喜欢的服务，以安全地联系到他们想要联系的人。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	安全数据存储\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	人们想知道他们的数据安全地存储在他们信任的地方。展望互联网和隐私的未来，我认为我们将做出的最重要的决定之一是：在哪里建立数据中心和存储人们的敏感数据。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在一个国家提供服务和在那里存储人们的数据有着重要的区别。当我们在世界各地建设基础设施时，我们选择不在有侵犯隐私或言论自由等人权记录的国家建设数据中心。如果我们在这些国家建立数据中心并存储敏感数据，而不仅仅是缓存非敏感数据，这可能会让这些政府更容易获取人们的信息。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	坚持这一原则可能意味着我们的服务在一些国家会受阻，或者我们不能很快进入其他国家。这是我们愿意做出的折衷。我们不认为在一些国家存储人们的数据是一个足够安全的基础，可以在其上建立如此重要的互联网基础设施。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	当然，保护最敏感数据的最佳方法是根本不存储它，这就是WhatsApp不存储任何加密密钥的原因，我们计划在以后的其他服务中也这样做。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	但是在更多国家存储数据也开创了一个先例，鼓励其他国家政府寻求更大程度地获取其公民的数据，从而削弱了全世界人民的隐私和安全保护。我认为，对于互联网和隐私的未来而言，我们的行业继续坚决反对把人们的数据存储在得不到安全保障的地方，这一点很重要。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	下一步举措\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在接下来的一年及以后，我们还要制定出与这些原则相关的许多细节和权衡。这项工作中的许多仍处于早期阶段，我们致力于与世界各国的专家、倡导者、行业合作伙伴和政府(包括执法部门和监管机构)协商，以正确做出这些决定。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	与此同时，通过这些原则开展工作只是构建以隐私为中心的社交平台的第一步。除此以外，我们还需要对在此基础上构建的所有服务进行深入思考--从人们如何支付和金融交易，到企业和广告的作用，再到我们如何为其他私人服务提供平台。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	但是，这些最初的问题得到正确答案是至关重要的。如果我们做得好，我们可以创建私人共享平台，这对于人们而言可能比我们建立的帮助他们更公开分享和联系的平台更重要。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	这意味着对关系到互联网未来的重要问题采取什么立场。作为一个社会，我们有机会阐明我们的立场，决定我们如何重视私人通信，以及谁来决定数据应该存储多长时间以及存储在哪里。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	我认为我们应该努力实现这样一个世界，让人们可以私下交谈，自由生活，知道他们的信息只会被他们想看到的人看到，而且不会永远停留在身边。如果我们能帮助世界朝着这个方向发展，我将为我们所取得的成就感到自豪。\r\n	</p>',	'doc.png',	1.00,	24,	0,	0,	0,	'2019-12-03 14:19:38',	'admin',	1,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	1.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	10,	1,	0,	1),
(17,	'日本九州一核电站起火 当局：未对环境造成影响',	'<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	今年两会期间，明星委员们的提案再次将炮火对准了劣迹艺人、明星及影视数据造假、身价片酬等行业乱象，不过前方固然慷慨激愤，后方还是其乐融融，#明星该不该吃粉丝送的食物#、#明星被认错#等话题频繁被推上热搜，娱乐氛围依旧。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	但今年还是有些许不同，2018年影视连续震荡所牵引出的政策新规，将在今年集中落地并被检验效果，前段时间，吴秀波、翟天临事件又掀起公众对娱乐圈造假的口诛笔伐。换句话说，娱乐产业规则改写的时机，可能已经同时具备了政策自上而下和舆论自下而上的两个必要条件。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	若是如此，数据造假将成第一个靶子，而往后推，数据造假的一环如果被铲除，是否能动摇当前畸形的粉丝经济呢？这是值得业界探讨的。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	造假产业链的逆向思考\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	2019年开年，《人民日报》发表文章，矛头直指流量明星锁场、刷榜、买粉丝，而后其又连续发表微博，感慨“明星流量数据节节攀升，8亿网民不够用”。随之跟进的还有《光明日报》《北京日报》，而“紫光阁”则从1月5日-9日，连发4条微博，痛批流量明星，呼吁“没有高质量作品做支撑，那些拙劣的表演终将被揭穿”。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	影视产业春寒料峭，一场“打假运动”的兴起，或许正是今年的新风向。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	微博已率先做出反应，宣布针对转发、评论计数显示方式在内做出种种调整，而更早之前，爱奇艺和优酷停止了播放量的展示。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	这对于影视数据脱水进而回归合理无疑是一个有利信号，视频及社交平台本身就是流量造星、粉丝运营的核心媒介，隐藏播放量起码减掉了数据造假的一个需求。虽然不得不承认，这一举措对整个行业来讲，也只是让数据造假不至于假得太“难看”，但其释放的市场信号是积极的：影视数据造假的乱象，今年或许不会止于揭露。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	以此为基础，我们再来看影视产业数据造假的产业链。一般来讲，卖方一端通过雇佣技术型或人工型水军，提供刷流量业务，至于买方一端，央视将明星数据造假的推手，归为自发组建的粉丝组织和经纪公司安排成立的明星微博数据站。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	两方需求契合，流量明星通过这一番操作获取一定的人气和地位，从而掠取演艺资源。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	而提供演艺资源的制片方、投资方以及媒体平台，又因流量明星的参与而收割商业利益，当然，这其中更少不了购买数据用以打榜、投票、转发的过程。无奈的是，这已成为市场优胜劣汰的“规则”，如果粉丝的偶像数据不好，就会被其他艺人的粉丝“唱衰”。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	由此可以看出，流量经济是一个参与方都可获得经济效益的模式，这也决定了很难从内部去戳破流量泡沫。但如今政策导向下，很有可能从外部强制性切断数据造假产业链，若是如此，会对以流量为基础的粉丝经济造成什么伤害？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	我们可以逆向推断，假使数据归真，流量明星及其所产出的内容，在市场的反应能够一目了然，首先最可能放弃他们的就是内容生产方。因为对比靠实力说话的演员，流量明星原本与之天差地别的流量优势，很大程度上被削弱了，而今口碑反噬又日渐严重，制片人也不再经得起多次的扑街。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	相应地，流量明星的演艺资源一旦被缩减，曝光度大大降低，广告商、媒体以及平台很快便“闻风而动”。更关键的是，明星本人新粉难增、旧粉流失，长此以往就更没有商业价值了。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	流量经济还是粉丝经济？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	当娱乐产业的优胜劣汰逐渐被流量所左右，如果从流量数据本身出发，一定程度上是可以约束某些行业乱象的滋生。但是流量缩减、粉丝仍在。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	蔡徐坤被央视点名时，震慑是对业内的，粉丝看似不惧。真爱粉们一面为爱豆打抱不平，力挺蔡徐坤确实是个专注音乐的好歌手，甚至表示之前做了那么多公益怎么不提？另一面又将攻击点集中到微博上，强烈要求整改。不过，前者是顾左右而言他，后面则是祸水东引，实则都没什么逻辑。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	从这件事直观地看，粉丝本身就是流量的一部分，即使最大程度地将流量数据脱水，蔡徐坤、鹿晗这类当前比较符合年轻群体审美的明星，也仍有不在少数的粉丝存留，他们才是饭圈的核心。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	换句话说，粉丝即使不花钱为他们的偶像刷流量，他们还是有其它方式向外界传达和证明自家爱豆的价值，甚至可以简单的说，只要粉丝愿意为爱豆花钱，在制片人和品牌方眼里，明星便有商业价值。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	这主要是因为当前的影视行业中，<strong>粉丝看似处于被收割的产业下游，实则主导着偶像的人气和商业吸引力。</strong> \r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\"> <strong>一方面，粉丝已经参与到偶像的职业规划中，用自己的力量为偶像争取好资源。</strong>而市场也认可了这种做法，现在广告商、制片方最看重的，不再是明星的业务水平，而是背后的粉丝力量。所以，纵然市场能抛开流量数据，演员和明星粉丝群体的差别，也无法使商业资源偏向前者。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\"> <strong>另一方面，如今流量明星的粉丝展现出强大而可怖的集体力量，如果不再允许数据造假，他们对舆论的影响也能帮助明星维持流量再造。</strong>极端一点，像粉丝骂战、撕逼这种普遍现象，一经推手，在当前这个碎片化时代便是天然的流量爆发点。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	所以，<strong>数据打假所能纠正的也只是流量经济，而触及不到更深层次的粉丝经济。</strong> \r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	时至今日，粉丝和流量的先后产生顺序已经模糊，这就是数据造假导致的，不过粉丝是基础，流量经济可以说是在资本介入、疯狂膜拜粉丝效应之后被放大的形态。这和移动互联网时代流量为王的思维，实则异曲同工。不过移动互联网进入下半场的服务升级，娱乐产业的流量经济反而日渐衰颓了。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	明星“死于”粉丝？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\"> <strong>围绕粉丝和明星的行业规则及利益链一旦形成，实际上就连一个环节的整治都很难，更不要指望其内部会自我改进。</strong>但值得庆幸的是，当前流量经济之所以逐渐露出真相，在于其外部的反对力量日益强大，也催促市场形成一套新的淘汰法则。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	最明显的是电影界，流量明星的多番试水，让投资方再也经不起折腾。2016年“小鲜肉+大IP”的模式备受追捧，2017年参与暑期档大战的流量明星只有杨洋、李易峰两人，而到2018年暑期档、春节档，杨洋、鹿晗等人早已不见踪影。李易峰的《动物世界》即使备受肯定，票房仍不能回本。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	数据显示，2018年全国电影票房已经超过2017年总票房559.11亿元，创下新纪录，但票房前十的影片主演中均不见小鲜肉身影。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	流量明星开始被排斥在大荧幕之外，而且他们在业内留下的印象一旦被定性，投资人只会对他们避之不及。而下一个排斥流量的便是观众，这很容易让流量明星丧失转型的时机，甚至是永久被划在攻击的范围之内。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	这是口碑反噬的副作用，比如《创业时代》开播之初，很多人还没看剧，只知道有杨颖主演便给出了一星评价，迪丽热巴则一个人把《声临其境》的评分拉到了4.3。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	一个经典角色可以成就一个明星，但一个明星也有可能毁了众多角色，观众便将不满全部发泄到流量明星身上，反而不会再客观考虑是不是剧本、导演不行。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	不过作品口碑败光的更多是路人缘，而且市场通过这种副作用反噬的方式淘汰流量明星，毕竟是一个相对缓慢的过程。关键是，他们背后的死忠粉依然是“东山再起”的资本。<strong>所以一个流量明星的消失或死亡，完全取决于粉丝。</strong> \r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	事实也是如此，我们看到，<strong>人设崩塌是最近常见的最快导致明星坠落的方式，而人设本质就是为迎合粉丝存在。</strong>粉丝心理假说认为，追星一种身份认同，粉丝通过对名人的“镜像”认识自己，塑造价值观，而一旦粉丝发现这种“镜像”是虚假的，认同感瞬间就消失了，而且会有上当受骗的感觉。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	当然，粉丝也是善变的，他们自然而然流失，流量明星们也就被市场抛弃了。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\"> <strong>流量数据的虚假泡沫被戳破总归是好的，但娱乐行业的乱象却无法根治，终究是粉丝把明星捧得太高了。</strong> \r\n	</p>',	'doc.png',	1.00,	40,	0,	0,	0,	'2019-12-03 14:20:16',	'admin',	3,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	1.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	14,	1,	0,	1),
(18,	'好消息 济南30个公共文化设施将实现图书通',	'<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	你可能不知道咪蒙，但却一定知道她有一个月薪5万的助理。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	年初，在“寒门状元”事件之后，咪蒙就曾宣布关停微信公众号两个月，并永久关停微博。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	不想仅仅过了不到一个月，2月21日咪蒙以及旗下“才华有限青年”等微信账号就宣布将被永久关停。旗下美妆账号改名为“李粒粒LiLiLi”，咪蒙小号“好疼的咪蒙”则清空了所有内容。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	从咪蒙公布之前公布的报价来看，其微信公众号头条广告报价一度到达80万元，二条也有40万元。这次的账号注销还包括今日头条、凤凰号等等，并称咪蒙“不得转世”。咪蒙的商业帝国几乎被连根拔起。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	除了自媒体，同时可能就此终结的还有咪蒙刚刚开始的编剧生涯。2018年3月，柠萌影业曾经宣布，由咪蒙担任编剧的网剧《长大成人》正在筹备中。现在咪蒙被封，这部“神似”《欢乐颂》的作品最终何去何从也被画上了问号。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\"> <strong>“毒鸡汤女权”，这不只是咪蒙的专利</strong> \r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	正如我们上文所说，咪蒙还在积极谋求走向影视圈，成为编剧便是第一部。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	了解咪蒙的人都知道，咪蒙的文章一向以宣扬所谓“女权”为导向，用一碗一碗的鸡汤，挑动着公号中近600万女性粉丝的内心。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	作为一个影视的门外汉，咪蒙之所以开始进军影视当编剧，其实和中国影视，特别是网台剧当中 “大女主”等题材层出不穷有着直接关系。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	从《欢乐颂》里的五个姐妹，到《我的前半生》里的罗子君，从楚乔到关皮皮，不一而足。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	然而，在这些所谓的“大女主”或者“女权”剧却很少体现真正的女权，而或多或少的会体现出“咪蒙式女权”的感觉。 男一都会对我不离不弃，男二都会生死相依，男三都会“我的眼里只有你的桥段大行其道，靠男人上位的情节也充斥其中，女权成为了寄居在男权上的笑话。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	再有，许多职业剧也会加入大量爱情桥段，“谈判官”改谈恋爱，“猎头”改“猎对象”的情况也多次发生。这也正如咪蒙的风格，看似让人“自强不息”，实则只想让你成为“坐在宝马里笑的人”；看似是在不断激励，实际只是找准了观众的七寸，然后一颗颗的吃下早预备好的“致幻药丸”。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	但这样的剧情虽然满足了女性观众对于爱情内容的需要的同时，本身也局限了内容的发展。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	首先，这样的剧所有内容几乎都必须围绕爱情展开，亲情、职场、宫斗、武侠等本应该更重要的戏份反而成了陪衬。由此，很多所谓的职场剧、宫斗剧到头来都变成了无限尴尬的爱情剧。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	更重要的是，“咪蒙式的女权剧”并不是真正的男女平权，当女性意识进一步觉醒之后，就会开始逐渐摒弃这种价值观。正如《致橡树》中所说，“我如果爱你，绝不学攀援的凌霄花”。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	再次，随着90后以及更年轻观众的崛起，单身才是社会更加主流的形态。生活方式的改变也会影响大家对于影视剧的观看喜好。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	更进一步说，“大女主”实际上是披着女性思维的外衣，但实际上却站在男性立场的表现。女性是白莲花、傻白甜，需要靠男性，甚至众多男性实现目的，这其实是一种变向的“被包养”。托名女权，实际宣扬的却是一种并不合理的价值观。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	咪蒙已经悄然落幕，但“伪女权”却依然大量存在于影视剧之中。但随着品质口碑成为了市场主流，真正的女权影视剧登上舞台恐怕也不会太远了。\r\n</p>',	'doc.png',	1.00,	33,	0,	0,	0,	'2019-12-03 14:21:05',	'admin',	10,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	1.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	12,	1,	0,	1),
(19,	'媒体:二三本高校能趁取消录取批次逆袭吗',	'<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	短视频行业的发展无疑已经进入到了深水区，以短视频变现为代表的全新发展正在把这个行业越来越多地放到了市场的前台。作为一种全新的内容表现形式，短视频在经历了资本乱战、巨头追捧之后，或许应该进入这个“年纪”。然而，变现并非易事，短视频变现更是难上加难。如果能够走出短视频变现的考验的泥淖，这个行业的发展无疑将会发展成熟。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	当然，如果仅仅只是一味地追求变现，而不去深究短视频本身的内在运行逻辑。所谓的短视频变现同样会陷入困境，火爆的短视频行业将会如同火爆的流量一样陷入表面的繁华。的确，几乎所有的商业模式都应该形成一个生态闭环，才能称得上是一个成熟的商业模式。如果仅仅只是停留在某个阶段的繁荣，所谓的商业模式仅仅只是一个概念，无法真正落地。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	我们看到当前以抖音、快手为代表的短视频行业巨头都在进行变现层面的探索，无论是社交，还是电商，对于短视频背后更加深层次的商业层面的探索正在成为一种发展的主流。不可否认的是，尽管短视频变现进行得如火如荼，但是依然逃不脱现实的尴尬，短视频行业的变现依然面临诸多挑战。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	从繁荣期到精耕期，短视频行业正在经历阵痛\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	作为一种在移动互联网时代的后半段崛起的内容表现形式，短视频行业的发展无疑备受追捧。无论是资本还是巨头，对于这种新式的内容展现形式都充满了好奇与期待。融资数额的不断增加、融资速度的不断加快都在说明市场对于短视频行业偏好程度。尽管短视频行业从一开始就被互联网巨头所青睐，但是，它的发展依然要经历所有的事物都会经历的阶段。从资本吹捧的繁荣期到商业变现的精耕期，短视频行业的发展无疑正在经历一次全新的阵痛。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	火爆的背后是短视频行业远离商业本质的尴尬。几乎所有的人都知道，短视频行业的发展一直都是一路高歌，无论是从用户获取上，还是用户日常的表现数据上，短视频行业的发展都是相当夺目耀眼。尽管短视频行业看上去异常火爆，但是火爆的背后却是变现困难的尴尬。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	从始至终短视频行业都在扮演着一种流量导流的角色，通过短视频将流量聚集在一起，再通过流量下沉到电商、社群等其他领域，从而实现真正意义上的变现。其实，从流量获取到流量导入已经有了许多的用户流失，再把这些流量落地到具体产品上又会有更多的流量流失。因此，仅仅只是将短视频看成是一个流量导入的工具，而不去从短视频本身着手，直接进行变现正在让短视频行业的发展陷入一种尴尬的境地里。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	当我们看到短视频平台动辄几亿的用户流量的时候，其实无法真正掩盖现实的尴尬。一味地看中短视频本身的流量价值，而忽略了更多新的探索，短视频行业正在陷入一场远离商业本质的尴尬。在流量红利已经见顶的大背景下，一味地去强调短视频行业的流量作用，无疑是一次与现实的抵抗。在流量已经被证明是一种无效资源的大背景下，短视频行业盲目地加大自身在流量上的作用，无疑是一场冒险。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	依附于巨头的怀抱让短视频缺少对于商业世界的认知。作为一种全新的内容展现形式，短视频行业从一开始就依附于互联网巨头。无论是资本投资，还是平台建设上，短视频始终都缺少自己独特的运行模式。虽然以互联网巨头作为靠山能够缓解在竞争激烈的市场当中沦陷的概率，但是如果仅仅只是一味地停留在巨头怀抱的温暖里，不去面对商业世界的残酷，短视频行业依然备受挑战。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	依附于巨头的怀抱，短视频行业仅仅只是一个内容层面的东西，它仅仅只是巨头的附庸，无法真正承担起自我寻找商业价值的重任。当巨头不再加持短视频行业的时候，它同样需要走入市场里，而不是一味地承担一个支撑者的角色。依附于互联网巨头的怀抱，短视频行业仅仅只是停留在表面繁荣的自嗨当中，不断增长的用后数据、不断增长的点赞数量、不断增加的用户浏览时长都让短视频行业感觉到自己是移动互联网后半段的王者。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	作为一种全新的内容展示形式，短视频始终都是一种内容。如果我们仅仅只是停留在巨头光环下的数据自嗨，而不去真正了解这些数据背后的真正原因。那么，当短视频行业真正进入到市场的时候，一切或许都将重新开始。当前，短视频行业正在经历的正是这样一个阶段。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	以内容为根本的短视频却无法具备内容的本质与意义。虽然短视频行业异常火爆，但是我们始终都不能忘记短视频始终都是一种内容表现形式。既然是一种内容，短视频行业从野蛮生长到精耕细作是一个必然的过程。在经历了几年的发展之后，我们却没有看到短视频行业的内容有显著提升的地方，有的仅仅只是在一些营销层面的小打小闹。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	当短视频在内容进化上出现瓶颈的时候，我们就去做商业变现上的相关尝试无疑将会把这个行业的问题和弊端全部都呈现在外面。作为一种内容展现形式，短视频行业在内容本身上缺少精耕细作和突破创新，只会把短视频行业的发展带入到一种相对艰难的境地里。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	我们看到现在的短视频的内容上依然缺少精细化的痕迹，有的仅仅只是千篇一律的雷同抑或是内容展现形式的俗套。如果仅仅只是把短视频行业仅仅停留在一种毫无进化的层面上，特别了缺少了作为内容本身所应该具备的特质，那么所谓的短视频必然将会失去原有的本质与意义。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在经历了早期的野蛮生长、资本助推、巨头拥抱等一系列的发展之后，短视频行业的发展正在经历一场前所未有的平静期。这从另外一个角度说明短视频行业的发展并未真正跳出原有的发展套路，仅仅只是将互联网式的发展模式在极致上更进一步。突破短视频行业的发展困境，需要真正让短视频告别自嗨式的繁荣，真正回归内容本身，真正进入到商业世界的现实中历练。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	进入下半场的深水区，短视频的彷徨与退让\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在告别了资本的加持之后，短视频行业的发展正在进入到下半场的深水区。早期的顺风顺水让短视频行业的发展难以抵挡现实的尴尬，一味地停留在数字上的繁荣，而忽略了内容本身的本质奥义，短视频行业的下半场无疑将会经历一场前所未有的彷徨与退让。但是，这并非是一件坏事，通过这种方式，我们增加能够知道短视频本质的东西是什么。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	短视频的彷徨：巨头扶持还是独立行走。短视频从诞生的那一天开始就始终没有摆脱巨头的光环，从某种意义上来讲是互联网巨头最终造就了短视频行业的今天。然而，一味地躲在互联网巨头建构的舒适区里，不去进行商业层面上的探索，所谓的短视频只会在自嗨的道路上越走越远。告别巨头的保护，真正进入到市场当中摸爬滚打，从而获得更多的生存技能或许对于短视频来讲至关重要。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	然而，如果摆脱互联网巨头的怀抱，短视频又很难在短时间内找到一条合适的路，对于处于变现关键期的短视频行业来讲，无疑是一个非常巨大的挑战。始终蜷曲在巨头的怀抱，毕竟不是一件长远的事情，短视频行业的真正未来依然在于本身的发展上。从这个逻辑来看，脱离巨头的怀抱，选择独立行走显然是一件非常明智的事情。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	可喜的是，深度参与到短视频行业发展中的人们早已明白了这其中的意义，我们看到以抖音、快手为代表的短视频平台开始更多地寻找基于自身优势和特色的发展道路，抖音做社交，快手做电商就是这一趋势的直接体现。尽管当下的发展态势不甚明朗，但是只要能够找到一条真正适合自己的发展道路，短视频行业的发展便会真正能够独立。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	短视频的退让：坚守流量还是回归商业。从当下的发展情况来看，短视频真正吸引人的地方还是它裹挟流量的能力。投资机构和互联网巨头之所以不断加持短视频行业的重要一点同样是因为短视频本身能够在获取流量的成本日渐高企的时刻依然能够持续获得源源不断的流量。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	然而，虽然流量给短视频赢得了鲜花和掌声，但是流量的变现依然是横在短视频头上的达摩克利斯之剑。谈及流量变现就必然要回归到商业本身，如果仅仅只是在流量的海洋里进行无谓的自嗨，所谓的短视频只能是一个充满了美妙幻想的乌托邦，无法真正实现真正意义上的落地。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	是坚守流量还是回归商业，或许在残酷的商业面前，短视频行业将会最终退让，真正演变成为以商业为主导的存在。尽管这个过程会略显艰难，但是这才算是真正回归到了商业本身，而非仅仅只是沉醉在流量的理想国里。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	当短视频市场的繁华落尽，回归商业本质或许是当下正道。告别表面的虚假逻辑，真正把短视频行业的发展落地到具体的商业上，探索一条真正适合商业本质的发展道路，或许才是真正能够推动短视频行业发展正道所在。从这个逻辑上来看，当下短视频行业正在经历的这场彷徨与退让或许更像是在积蓄继续前行的能量。\r\n</p>',	'doc.png',	1.00,	29,	0,	0,	0,	'2019-12-03 14:21:49',	'admin',	14,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	1.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	11,	1,	0,	1),
(20,	'波音今年以来已交付345架飞机 总量不到去年一半',	'<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	发展会掩盖一切问题，直到狂奔的脚步停下。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	2月15日，滴滴CEO程维对外表示，公司将做好过冬准备，并将对非主业进行“关停并转”，对业务重组带来的岗位重叠和绩效不达标的员工进行减员，整体裁员比例占到全员的15%，将涉及2000人左右。此外，从2012年创业以来一直处于亏损状态的滴滴，2018年仍然亏损，全年亏损总额高达109亿元，其中，补贴司机超过113亿元。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在收购优步中国以后，滴滴在网约车市场一家独大，市场占有率近九成；滴滴是全球融资额最大的未上市公司，一向“不差钱”；滴滴对每笔业务都会收取20%左右的抽成(Take Rate)，这也经常成为网约车司机抱怨甚至炮轰的对象……感觉“躺着就能把钱赚了”的滴滴，为何会如此巨亏？司机喊着不赚钱、平台又巨亏，网约车的问题究竟出在哪里？还有能走得通的商业模式吗？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	成立7年，融资20次，\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	融资额200亿美元\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	和其他公司多是被爆出后被迫承认窘境，或者裁员时只肯使用“优化、调整、末位淘汰”等字眼不同，滴滴主动“官宣”了巨亏和裁员的消息，数字还如此巨大。“地主家也没有余粮了？”“富家子都开始哭穷了？”社交媒体上一时哗然，有人唏嘘，有人不解。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在去年8月滴滴顺风车事件之后，程维也曾对外透露过一次滴滴的财务数据，他表示滴滴成立6年来，还没有实现过盈利，仅仅2018年上半年，公司的整体净亏损就超过40亿元人民币。滴滴出行业务对应的GMV(总交易额)平均Take Rate(抽成率)约为16%，但绝大部分作为补贴和红包返还给了司机和乘客，公司整体对应的GMV毛利率只有1.6%。他还透露，仅2018年上半年，包括司机高峰期补贴、接单和服务奖励、乘客优惠等在内的总补贴返还金额超过117亿元人民币。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	2017年，滴滴也曾透露过补贴总额，高达181亿元(包括司机端和乘客端)。但一些被媒体广泛引用、滴滴官方从未确认也从未辟谣的数据显示，2017年滴滴全年亏损额只有25亿元。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	一位滴滴内部人士告诉《中国经济周刊》记者：“公司虽然巨亏，但现在现金流应该是没问题的。即使一部分员工会面临被裁员，但公司给的补偿方案还是比较厚道的。说滴滴会成为下一个ofo那是不太可能的。”\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	据天眼查的统计数据显示，滴滴自2012年成立以来，截至目前已经完成了20次融资，金额总量超过200亿美元，是全球融资额最大的未上市公司。滴滴的估值也一度高达800亿美金，也是最快达到这个量级的独角兽公司。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	但这只独角兽也甚是烧钱。由于滴滴还不是上市公司，财务数据并不需要全部公开，但根据滴滴已公开的数据统计，滴滴6年来累计亏损额高达近390亿元。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	但上述人士也表示：“在2018年以前，利润和成本在滴滴确实不是重要的考核指标，市场占有率、日单量、用户数量、司机数量……这些才是关注的重点。但2018年开始，公司希望能够在年底冲刺整体盈利，至少实现‘微盈利’，所以对各个业务线也都提出了这样的要求。”\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	其实，这种变化也并不奇怪，因为彼时市场传闻，滴滴将会在2019年下半年实现IPO。但之后由于众所周知的原因，滴滴没能赶上这波上市热潮。“顺风车事件”背后的安全问题让滴滴停下了6年来一路狂奔的脚步。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	一年补贴113亿元，\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	司机感受到了吗？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	补贴仿佛是成就滴滴、也榨干滴滴的一道旋转门，补贴的打法让滴滴熬死了几乎所有竞争对手，并从尸骨堆中走出来，成为今天的滴滴；但现在，补贴似乎也正在熬干滴滴自己。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	与109亿元这个2018年滴滴全年亏损总额一同出现的还有一个数据：2018年滴滴补贴司机超过113亿元，这很容易让人认为两个数字之间有因果关系。但巨额亏损就是源于对司机的补贴吗？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	北京大学市场与网络经济研究中心研究员陈永伟对《中国经济周刊》分析认为，滴滴的亏损应该主要来自为了赢得用户信任和适应更强监管而付出的合规成本。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	陈永伟认为，滴滴的持续亏损主要有两方面的原因。“一是由滴滴本身的战略决定的，它的战略是先占有市场，然后利用规模效应去消化市场。滴滴的主业务是规模报酬递增的，这也决定了滴滴先占市场的模式。二是去年突发事件引发了监管加强，这让滴滴遭受了空前的监管压力，合规成本是巨大的，比如要求司机户口、车辆的轴距大小等。”他说。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	记者采访了几位滴滴司机，他们均表示，并没有觉得去年滴滴对司机的补贴突然增加了。一位滴滴“老司机”告诉记者，不同的司机能够拿到的补贴数量可能差别非常大。因为要想获得比较高的补贴收入并不容易，比如要在线时间长，至少10小时，这意味一定要是全职司机，身体要好还不能怕辛苦；再比如要在高峰时段多接单，也要多接受滴滴的派单，“这些活儿很多是根本不赚钱的，不给补贴，根本不会有人接。”他说。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在乘客端，很多人的感受则是：滴滴的车费越来越贵，但叫车却越来越难。记者对比了市场上最大的几家网约车公司的价格，以北京为例，相同时段和目的地，同档次车型，滴滴快车价格最低，其次是出租车价格，但两者差距已经不大了，相对最高的是易到易达车型的价格。而对于高端车型，滴滴礼橙专车也是最低的，其次是神州专车，首汽约车的价格则更高一些。这些高端车型的价格要高出普通车型50%左右。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在客户竞争层面，网约车平台的竞争无外乎两件事：价格和能否叫到车。而网约车平台要克服的最大难题就是高峰低谷时段的需求差异和城市潮汐效应的供给矛盾。因此，从逻辑上，网约车平台确实需要依赖补贴来调节运力，鼓励高峰时段有更多兼职司机补充运力，鼓励司机反潮汐增加热门地区的运力供给。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	根据中国信息通信研究院政策与经济研究所的调查显示，截至2018年7月，全国合规网约车数量约为17万辆，只占到总量的0.54%，而合规司机数量约为34万，只能占到司机总量的1.1%。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	据滴滴方面介绍，随着各地网约车新政的落地和执行越来越严格，运力不足问题日趋严重。而顺风车下线之后，兼职的网约车司机也大量减少。因此，滴滴为了吸引更多“合规”司机加入，以及运营中调整运力，不断出手补贴。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	滴滴收购ofo的可能性更小了\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	除了裁员，滴滴宣布要“关停并转”非主业的消息也引发了广泛的关注。到底哪些业务是滴滴的“非主业”，截至记者发稿，滴滴官方并未给出回应。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	一位滴滴前高管对《中国经济周刊》分析，对于滴滴“非主业”，很多人会首先想到外卖、酒旅、票务等“创新业务”，这确实可能是此次调整的重点，但应该还至于此，因为这些业务不足以涉及到2000人。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	据记者了解，2018年底，滴滴进行过一次架构调整。调整后，滴滴的主要业务被划为几大板块：网约车平台公司(快车、专车、豪华车事业部)、车主服务公司(小桔车服公司、汽车资产管理中心)、普惠出行与服务事业群(单车、电单车、公交、代驾、企业级业务)、出租车事业部、战略业务事业部(战略部、国际事业部、金融事业部)等。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	上述高管认为，普惠出行与服务事业群的业务也有可能被重点调整，“滴滴再去收购ofo的可能性更小了”。而国际业务和金融业务则会影响不大。“网约车这个生意受政策环境影响太大了，国际化等于给滴滴多设立几个backup，这边不亮可以那边亮，滴滴已经有完整完善的网约车技术和运营解决方案，在各国复制并不难。”他说。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	实际上，滴滴已经通过收购、投资本地出行平台的方式将业务拓展到东南亚、东欧、非洲、巴西、日本、美国、墨西哥、澳大利亚……程维也透露，安全技术、产品和线下司机管理及国际化等是滴滴未来的重点领域。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	陈永伟的看法是，滴滴确实涉足了不少并没有规模效应的行业，如果没有顺风车危机，可能也不会对滴滴带来太大的影响。但在严监管之下，安全合规成本大增，滴滴的顺风车业务还干脆就没了，这也带来商业损失。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	网约车也有赢利的商业模式\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	滴滴这头其实已经达到巨头规模的超级独角兽，至今仍未找到清晰的盈利模式。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	滴滴的设想是希望通过平台聚集大量用户，然后靠打造“出行生态”提供增值服务获得盈利。就像淘宝和微信，用户都可以免费使用，但同样可以赚得盆满钵满。于是，滴滴进行了很多尝试：做广告、做电商、做游戏、卖保险、卖理财、做金融……但这条路，至少现在，滴滴还并没有走通。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	但这并没有影响新选手们的热情。除了神州优车、易到、首汽约车等老运动员，2018年以来，美团、高德、携程、同程、嘀嗒、哈罗等都开始前赴后继地加入网约车混战，希望从滴滴的版图上咬下一块。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	此外，上汽、吉利、大众等在内的主机厂都已经进军网约车市场，宝马也成为首家在中国拿到网约车牌照的跨国品牌，赛道那端虽然通向哪里还不知道，但赛道仍然拥挤。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	虽然滴滴的日子不好过，易到更是彻底凉了，但行业内也有日子过得不错的玩家。比如神州优车，虽然此前也一直亏损，但到2017年，神州优车的亏损已大幅收窄了92.7%，仅亏损2.6亿元。而其2018年经营，截止到当年前三季度，神州优车营收达49.2亿元，利润总额2.8亿元，较上年同期增长149%，已经实现了4个季度的持续盈利。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“这其实也说明了网约车本身没问题，是有商业模式可以走得通的。不过行业发展还是需要政策支持。”陈永伟表示\r\n</p>',	'doc.png',	1.00,	7,	0,	0,	0,	'2019-12-03 14:22:37',	'admin',	26,	1,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	1.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	4,	1,	0,	1),
(22,	'黑猫投诉|羽绒服充绒量作假 微店卖家拖延时间不退货',	'<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	2015年，随着抢眼的小黄车突现北大校园，共享单车的概念迅速被普及，玩家接连冒头，巨额投资不断涌入，和高铁、移动支付、网购齐名<strong>“新四大发明”</strong>。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	热潮来得快，去得更快。今年，共享单车就进入了寒冬。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	4月，<strong>摩拜单车委身美团；小黄车ofo也节节败退，危机重重</strong>：海外业务全面收缩，并推出了多种激进的变现手段：公众号推送广告，将用户的押金与理财产品绑定，一再延迟押金退还期限。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	去年还大把烧钱的共享单车，转眼就凉凉了。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	共享单车出海遇阻，基础建设和政策规范是难以忽略的两大阻力。除了中国，世界上很难找到一个足够大的市场来支撑共享单车的盈利模式。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	但印度的创业者似乎有不同想法。<strong>从2017年开始，有近十年共享单车公司陆续出现，并先后拿到融资。</strong> \r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	班加罗尔的Yulu向Blume Ventures等投资者筹得资金，还获得Flipkart联合创始人Binny Bansal和谷歌前副总裁Amit Singhal的支持；另一家公司Bounce从红杉印度等投资者那里拿到了了总计1520万美元的资金；总部位于古尔冈的Mobycy去年12月也筹集了50万美元的种子资金。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\"> <strong>印度的共享单车市场正生机勃勃。</strong> \r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\"> <strong>融资热潮</strong> \r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	Amit Gupta是印度第一家独角兽Inmobi的联合创始人。在他创业十年、担任总裁级别职务的时候，他选择了急流勇退，<strong>创办了另一家公司，Yulu单车</strong>。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在班加罗尔地铁站和商务CBD附近，亮蓝色的Yulu单车随处可见。Amit告诉\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	志象网\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	，做共享单车，是为了<strong>“间接降低污染”</strong>。他出生和长大在印度北部的小城坎普尔，在今年6月被世界卫生组织盖章“全球污染最严重城市”，谈起家乡，他显得情绪激动。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	Yulu单车在前半个小时仅收费10卢比<strong>（约一元）</strong>，之后每半小时多收5卢比。用户下载Yulu应用扫码开车，结束骑行之后，需要将车子停放在离目的地最近的停车区。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	业内人士估计，印度的共享单车市场目前规模达12亿美元。<strong>主要的玩家除了Yulu，还有共享汽车公司Zoomca旗下的Pedl，Mobycy，Bounce和以及来自中国的摩拜单车。</strong> \r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“这个行业很有前景并且有利可图，Ola和Uber的成功证明了交通出行跟手机有可能同步发展。”Blume Ventures的投资人Sajith Pai对志象网说。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	最近入局的玩家是<strong>从踏板车共享起家的Bounce</strong>。今年6月，ofo退出印度市场，Bounce最近宣布收购了它在印度的资产。在收购之前，Bounce在就班加罗尔投放了500辆踏板车。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“从公交站或地铁站到办公室和家里的最后一英里的交通非常令人头疼，没有任何三轮车或出租车愿意走这么短的距离。”Bounce联合创始人Vivekananda HR告诉志象网。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“我们从ofo手中收购的自行车也将加入试点。”他说，45到60天内Bounce的应用将支持扫码使用单车。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	印度创业者从中国公司继承的，不仅是败局留下的遗产，还有先见之明的运营管理教训。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在浦那和班加罗尔，小蓝车Yulu和小绿车Pedl随处可见。一开始，用户可以把车停在任何地方，甚至是在路中间，引起了交通失序。Yulu不得已派出团队去搬运自行车并停放在适当的地方。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	这样一来，成本太高难以为继，Yulu吸取了教训，开始联合Pedl与当地政府合作，规划指定的停车区域。在班加罗尔，这样的停车区现在有500个，在全部的4个城市总数超过1000个。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\"> <strong>纠结的用户体验</strong> \r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	但也有的问题无法靠“继承”来解决，<strong>比如技术和运营失误</strong>。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在印度，<strong>共享单车的用户体验仍有待改善</strong>。志象网记者的亲身体验以及和其他用户交流后发现，包括刹车失灵、智能锁失灵、轮胎漏气等现象并不少见，而且停车区的分布也不够密集，有时候用户甚至需要在锁车之后再走一公里到目的地。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	Vivek Kumar是一名22岁的软件工程师，他最近刚从德里搬到了班加罗尔。刚到班加罗尔时，他一直骑着共享单车穿梭在城市中参加面试。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	一次去面试的路上，他发现单车的链条断了，这就十分尴尬了：他必须得先把车子停到指定的停车区域，否则软件会一直计费。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“我不得不把车子推到500米外的Pedl停车站，在锁这个坏车的时候又花了好多时间。”Kumar告诉志象网。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	但事实上，Yulu和Pedl也都有专人在维护单车，每隔四天维护一次，从而保持单车的良好运行状态。但Amit说，当公司进入一个区域时，维护的情况会不太稳定，“因为当地业务还没有完全稳定。”\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“在那些旧的区域，你会发现我们的自行车状况良好，大多数都能够很好运行。最近我们在电子城附近布局，那里聚集了一批大型IT公司，比如Infosys、Wipro等。我们需要四到六周的时间来完成布局。”Amit说。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	但相较中国，<strong>印度的交通基础设施普遍落后，这也给共享单车埋了一颗暗雷</strong>。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在印度，没有几个城市设置了自行车道；不像中国，骑行已经发展为一种健康、前卫的生活方式，印度的自行车还往往被视为穷人的通勤方式。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“我们之所以进入共享单车行业，是因为我们想成为一家多渠道出行平台。城市交通一直是政府和公民共同面临的挑战，我们希望能够大规模地解决这一问题并帮助完善基础设施建设。”Pedl运营增长部门负责人Rakshak N说。\r\n	</p>',	'doc.png',	0.00,	38,	0,	0,	1,	'2019-11-26 09:37:47',	'admin',	119,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	0.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	14,	1,	0,	1),
(23,	'较强冷空气影响北方地区 局地降温可达12℃以上',	'<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	互联网瞬息即变，互联网上的热点也是转变地相当的快，一个热点可能过了几天就不再有人关注了。这对于想凭借互联网走红的人或物来说，显然要付出更多的心血来维持热度。那么，各个引流渠道显然都在他们的考虑范围之内。对于商家而言，在互联网进行引流的最终目的不外乎都是卖货变现。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	因此，一些比较重要的引流渠道，都少不了商家们的身影；比如，。抖音作为2019年的平台，有着3.2亿日活跃用户，属于是自带。如今，抖音与微信、微博等巨大流量池并称，绝对是商家不容错过的流量池。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	商家在抖音平台上发布内容之后，就能通过发布内容来吸引用户前来关注，并进一步转化为粉丝，这样就能更方便商家引流变现。在抖音只能是通过发布优质内容来吸引用户关注，因为抖音采用的是智能社交推荐机制，只要发布的视频内容有趣，也可以获得大量的曝光。这就决定了粗制滥造的视频所获得的曝光量很少。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;text-align:center;\"=\"\"> <img src=\"http://demoall.adashuo.com/20090/uploads/allimg/c191107/15I0c2FD630-1E14.jpg\" width=\"450\" height=\"270\" border=\"0\" alt=\"抖音多闪培训：如何通过抖音进行带货-第1张图片-小七抖音培训\" title=\"抖音多闪培训：如何通过抖音进行带货-第1张图片-小七抖音培训\" style=\"height:270px;width:450px;\" /> \r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	因此，想要在抖音平台上获得大量的曝光，最简单的办法就是制作高质量的视频内容。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	拥有曝光，并不代表着是结束。恰恰相反，这只是开始，因为接下来的工作就是要引流变现了。目前，通过抖音引流的方式无非就只有这么几种：一是在视频内提及联系方式；二是在评论中回复；三是在私信回复等。但是，这几种引流方式都存在着被抖音删除、乃至封禁的风险。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	抖音多闪培训那么，到底有没有什么引流方式是没有风险的呢？或者换言之，有什么引流方式是抖音官方认可的呢？当然有!那就是抖音的电话拨打组件。这是抖音官方所推出的转化组件，经过设置就可以在抖音主页上展示，只要用户点击\"联系方式\"这个按钮就可以跳转至电话拨号界面，并显示相关号码，这无疑对商家引流变现提供了很大的便利。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	但比较遗憾的是，目前，这个功能并没有对所有的用户开放，只有认证了抖音企业蓝v号的用户才可以设置该功能。所以，商家如果是想开通\"电话拨打组件\"的功能，需要先开通抖音蓝v。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	抖音蓝v认证的申请流程如下：\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	第一，用需要认证蓝v的抖音账号登录抖音蓝v认证官网https://renzheng.douyin.com/。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	第二，填写企业认证公函，具体情况可以参考抖音官方的企业认证公函填写模板。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;text-align:center;\"=\"\"> <img src=\"http://demoall.adashuo.com/20090/uploads/allimg/c191107/15I0c2G0040-2J03.jpg\" width=\"450\" height=\"447\" border=\"0\" alt=\"抖音多闪培训：如何通过抖音进行带货-第2张图片-小七抖音培训\" title=\"抖音多闪培训：如何通过抖音进行带货-第2张图片-小七抖音培训\" style=\"height:447px;width:450px;\" /> \r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	第三，填写并提交认证资料，然后填写邀请码123456\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	第四，支付认证审核费用600元即可完成蓝v认证申请的提交。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	需要注意的是，抖音蓝v认证有部分禁入行业及需要额外提供认证资质证明的行业。禁入行业认证抖音蓝v将做认证失败处理。而需要额外提供认证资质证明的，如果碰巧没有，那么在提交认证申请后的30天内仍没有补充提交资质证明，也会当认证失败处理。而认证抖音蓝v失败，是不会进行退款的。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	认证抖音蓝v之后，除了可以获得电话拨打组件，还可以获得同步认证今日头条和、官网链接、商家页面、店铺POI地址、粉丝画像等蓝v权益。可以为天猫、淘宝、京东店铺以及线下店铺引流，构建企业商家的营销阵地，完成变现的目的。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;text-align:center;\"=\"\"> <img src=\"http://demoall.adashuo.com/20090/uploads/allimg/c191107/15I0c2G35440-31260.jpg\" width=\"450\" height=\"261\" border=\"0\" alt=\"抖音多闪培训：如何通过抖音进行带货-第3张图片-小七抖音培训\" title=\"抖音多闪培训：如何通过抖音进行带货-第3张图片-小七抖音培训\" style=\"height:261px;width:450px;\" /> \r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	抖音多闪培训因此，有意认证抖音蓝v的商家，最好是通过抖音蓝v认证代理商进行认证。\r\n</p>',	'doc.png',	0.00,	32,	0,	0,	0,	'2019-12-03 14:04:12',	'admin',	5,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	0.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	12,	1,	0,	1),
(24,	'法官方金刚殉职 最高法院长曾要求不惜代价抢救',	'<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	众所周知，2017年至2018年，的大和商业价值日益凸显，各大机构纷纷注资抢占短视频市场，作为短视频流量增速最快的APP，其运营模式和商业市场更是备受关注。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	大数据，帮你快速打造抖音爆款\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	抖音作为新媒体的新洼地，虽然流量又达到一个新的峰值，但是入场抖音仍然是可以。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	而想在抖音机制中脱颖而出，关注的焦点更倾向于生产抖音内容的速度和质量，以及如何持续生产高质量的抖音内容。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	对于运营抖音而言，此时入场抖音阵地，更需要把控时间成本和运营方法。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	结合抖音大数据工具——西瓜短视频助手，在内容层面，可以在6小时内寻找到抖音视频爆款素材，结合热门迅速掌握抖音平台爆款元素，从而有效提升抖音成本。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	在领域定位上，可以根据榜单快速规划的运营方向，结合行业粉丝画像信息，进一步完善垂直领域差异化内容布局。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	抖音进阶创作技巧，及商业运作模式\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;text-align:center;\"=\"\"> <img src=\"http://demoall.adashuo.com/20090/uploads/allimg/c191107/15I0c2AcO0-53929.jpg\" width=\"450\" height=\"303\" border=\"0\" alt=\"抖音小店：抖音运营怎么进行流量变现-第1张图片-小七抖音培训\" title=\"抖音小店：抖音运营怎么进行流量变现-第1张图片-小七抖音培训\" style=\"height:303px;width:450px;\" /> \r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	根据对MCN机构平台发展中遇到各种情况，给现场的运营者和MCN机构提出以下3个方面建议：\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	1.稳扎稳打才是抖音号的运营之道\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	面对网络上出现的买粉刷量的现象，建议运营者和机构千万不要尝试。这样的行为，不仅影响抖音号的权重，也让后续陷入无效价值中。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	2.快速孵化KOL矩阵离不开内容运营\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	抖音小店面对快速内容运营的有效方法，也给出一些信息流量的操作模式，在信息的展示上，可以扩大挖掘地域，可以引入外国小众优质的平台信息资源，将优质内容分类整理成“剧本”分发旗下艺人进行高效运作，提升视频输出效率。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	3.强强合作是商业运作成型的有效方法\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	相比知识付费，广告和电商是抖音目前最有效的转化之一。在广告投放上，同MCN专业机构合作，会更有效的提升个人抖音号的商业价值转化能力。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	如何高格局快速转战短视频领域构建生态链\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	如何一手打造“从内容生产-IP孵化-推广产业化”短视频生态蓝图？\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;text-align:center;\"=\"\"> <img src=\"http://demoall.adashuo.com/20090/uploads/allimg/c191107/15I0c2B323F-B363.jpg\" width=\"450\" height=\"307\" border=\"0\" alt=\"抖音小店：抖音运营怎么进行流量变现-第2张图片-小七抖音培训\" title=\"抖音小店：抖音运营怎么进行流量变现-第2张图片-小七抖音培训\" style=\"height:307px;width:450px;\" /> \r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	a.建立完善的孵化流程。在常规签约流程上，增加达人定位分析和视频测试环节（颜值/技能/学习），保障达人较高的素质水平。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	b.专注用户市场资源。在媒体领域商业形式取决于上游形态，运营的方向取决于市场用户的需求，只有想明白定位，才能做清楚你的市场。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	c.专业商业变现评估。需要对行业的天花板有一定认知，对不具有的抖音大号，可以根据粉丝画像的年龄层，选择不同的市场的推广模式。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	最后，规范机构的商业合作模式，才能快速有效构建自己的商业帝国。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	网红大咖粉丝运营之道\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	抖音IP的成长过程3个关键点：\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	1、找准平台：分析各个平台的商业价值和受众群体，有效预估平台的价值的上升空间。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;text-align:center;\"=\"\"> <img src=\"http://demoall.adashuo.com/20090/uploads/allimg/c191107/15I0c2BC510-L234.jpg\" width=\"450\" height=\"303\" border=\"0\" alt=\"抖音小店：抖音运营怎么进行流量变现-第3张图片-小七抖音培训\" title=\"抖音小店：抖音运营怎么进行流量变现-第3张图片-小七抖音培训\" style=\"height:303px;width:450px;\" /> \r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	2.优质内容：视频种类，视频的风格，人设的塑造，再到更高层次基调定位，都是优质内容的保障。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	3.抓准用户心理：内容的输出上需要抓取社会的认同感，有共鸣的内容通常都可以引发用户的依赖性，可以在内容上找到归属感。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	抖音小店其次，需要制造亲切感，打造个舒服是场景内容更容易获取用户关注。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	最后，就是从心理学的角度出发，恰到好处运粉丝的独纵心理和占便宜的心态。\r\n	</p>',	'doc.png',	1.00,	33,	0,	0,	0,	'2019-12-03 14:07:30',	'admin',	3,	5,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	1.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	12,	1,	0,	1),
(25,	'为何生活质量提高肿瘤也增多？ 多吃石榴能防癌抗癌？',	'<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	带火了很多“爆款”产品，这些品牌和产品的销量大增，引得很多企业和品牌方们分外眼红。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	在这个为王的时代，早已成为了一个所有新媒体人无法避开的平台。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	抖音火遍大江南北，同时有无限的流量产生。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	大家撸粉的撸粉，变现的变现。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	但是现在越来越难了，\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;text-align:center;\"=\"\"> <img src=\"http://demoall.adashuo.com/20090/uploads/allimg/c191107/15I0c26340L0-1F53.jpg\" width=\"450\" height=\"198\" border=\"0\" alt=\"抖音运营团队：抖音运营思维攻略-第1张图片-小七抖音培训\" title=\"抖音运营团队：抖音运营思维攻略-第1张图片-小七抖音培训\" style=\"height:198px;width:450px;\" /> \r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	为什么？\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	竞争大呗！\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	团队拿到更好的权重才能有更多的曝光，才有上的机会。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	怎么拿到更多的曝光权重呢？\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	俗话说：知己知彼，百战不殆！\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	那我就先来了解一下抖音的排名算法是什么？\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	首先你要输出优质的内容，\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;text-align:center;\"=\"\"> <img src=\"http://demoall.adashuo.com/20090/uploads/allimg/c191107/15I0c263G60-26058.jpg\" width=\"450\" height=\"195\" border=\"0\" alt=\"抖音运营团队：抖音运营思维攻略-第2张图片-小七抖音培训\" title=\"抖音运营团队：抖音运营思维攻略-第2张图片-小七抖音培训\" style=\"height:195px;width:450px;\" /> \r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	关于内容今天就不讲了，本期讲的是抖音运营思维攻略。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	一、熟悉抖音\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	抖音运营团队熟悉抖音账号注册、认证、定位、布局、防封号/、最受欢迎内容等。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;text-align:center;\"=\"\"> <img src=\"http://demoall.adashuo.com/20090/uploads/allimg/c191107/15I0c26406150-31H2.jpg\" width=\"450\" height=\"266\" border=\"0\" alt=\"抖音运营团队：抖音运营思维攻略-第3张图片-小七抖音培训\" title=\"抖音运营团队：抖音运营思维攻略-第3张图片-小七抖音培训\" style=\"height:266px;width:450px;\" /> \r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	二、选题\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	1.选题的原则：关联性、热门性、新鲜感、人设感\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	2.选题来源：可从时事、同行火爆视频分析、段子、微博等渠道入手\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	3.拍摄及剧本套路\r\n</p>',	'doc.png',	1.00,	30,	0,	0,	0,	'2019-12-03 14:08:06',	'admin',	10,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	1.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	12,	1,	0,	1),
(26,	'哈尔滨13名学生布鲁氏菌抗体阳性 1人确诊',	'<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	怎么在做？ &nbsp;借助商品橱窗和购物车，电商新物种——抖商蓬勃发展，但作为以算法推荐分发的平台，抖音缺少社交基因，那么抖音就注定与社交电商无缘吗？\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	社交对电商有何价值？\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	社交电商是相对于传统电商的概念——社交本身自带去中心化属性，由此延伸出来两个特征：裂变与私域流量。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	裂变来源于社交背后的人脉关系，不仅转化率远高于传统电商，更是能基于信任进行快速传播，也就是裂变获客；\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	而私域流量于商家不仅意味着跳出平台限制自主营销获客，私域流量还具有免费、优质、高黏性、可重复转化的属性。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;text-align:center;\"=\"\"> <img src=\"http://demoall.adashuo.com/20090/uploads/allimg/c191107/15I0c25W3510-551O.png\" width=\"450\" height=\"328\" border=\"0\" alt=\"抖商研习社：如何在抖音做社交电商？-第1张图片-小七抖音培训\" title=\"抖商研习社：如何在抖音做社交电商？-第1张图片-小七抖音培训\" style=\"height:328px;width:450px;\" /> \r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	抖音也能做社交电商吗？\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	1、社交土壤\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	抖商研习社需要指出的是，抖音虽然并非社交产品，但有人的地方就有社交——抖音好友与好友间、粉丝与红人间都有着浓厚的社交氛围，只不过抖音是以陌生人关系链组成的社交平台。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	同时抖音庞大且优质的用户群——以18-28年龄为主，多分布于一二线城市，且女性占比超过60%——配合内容的高传达效率，使得社交裂变有了肥沃的用户土壤。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	2、裂变载体\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	裂变的前提是有足够的用户基础——背靠抖音数亿活跃用户池，好的视频依托推荐算法，及话题、热榜、群聊等流量分发入口，能迅速成为爆款，进而触达更多潜在用户。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	裂变的关键在二次分享，而商品橱窗与购物车并没有相匹配的能力，这就需要借助抖音小程序了：除了可以驱动用户“”挂载小程序二次传播外，小程序的营销插件也自带裂变能力，进而打通裂变的闭环。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	怎么裂变起来？\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;text-align:center;\"=\"\"> <img src=\"http://demoall.adashuo.com/20090/uploads/allimg/c191107/15I0c2593MP-E412.png\" width=\"450\" height=\"331\" border=\"0\" alt=\"抖商研习社：如何在抖音做社交电商？-第2张图片-小七抖音培训\" title=\"抖商研习社：如何在抖音做社交电商？-第2张图片-小七抖音培训\" style=\"height:331px;width:450px;\" /> \r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	1、爆款视频引流\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	抖音卖货的基本逻辑是爆款短视频引流+小程序交易，而爆款视频主要取决于算法推荐，判定标准主要为完播率、点赞评论分享率等，与其辛苦摸索做视频，更便捷的方式则是通过与红人大V合作，以种草视频的方式引流。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	2、给用户裂变的动机\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	抖商研习社有了流量并形成转化后，还需要二次分享才能形成裂变，这就需要给用户一个分享“动机”，可以是折扣、优惠券、返现、赠礼等等，而小程序的营销插件如拼团、砍价、抽奖、分销等，则可以为商家提供裂变营销工具。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;text-align:center;\"=\"\"> <img src=\"http://demoall.adashuo.com/20090/uploads/allimg/c191107/15I0c25a5020-II2.png\" width=\"450\" height=\"319\" border=\"0\" alt=\"抖商研习社：如何在抖音做社交电商？-第3张图片-小七抖音培训\" title=\"抖商研习社：如何在抖音做社交电商？-第3张图片-小七抖音培训\" style=\"height:319px;width:450px;\" /> \r\n</p>',	'doc.png',	1.00,	28,	0,	0,	0,	'2019-12-03 14:08:36',	'admin',	11,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	1.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	11,	1,	0,	1),
(27,	'马来西亚又逮捕40名中国人:与上月破获诈骗案有关',	'<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	10月19日，京东宣布今年11.11大促将首次推出“京东拼购”等玩法。10月19日，美团点评官方微信小程序也正式上线了“好货拼团”板块。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	事实上，此前已经有包括阿里、苏宁、今日头条等多家互联网巨头切入了社交拼团业务。而这一切，在笔者看来，巨头们完全已经将拼购当成了获取用户流量的下一个杀手锏。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;text-align:center;\"=\"\"> <img border=\"0\" src=\"http://demoall.adashuo.com/25707/uploads/allimg/c191120/15J2314405K20-1L320.jpg\" style=\"height:auto !important;\" /> \r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	拼购成“香饽饽”\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	根据艾媒咨询发布的《2018Q1中国社交电商行业市场研究报告》显示，2018年中国社交零售用户规模将突破3亿人，年均复合增长率将达到44.2%。这也意味着，未来社交电商或仍将有巨大的增长空间。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	而作为社交电商的集中展现形式，拼购正凸显着自身鲜活的能量。这其中，最值得注意的就是拼购已经成为巨头最新切入的业务。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	具体来看，巨头们正在尝试性地推出自家相关的拼购业务。如果让消费者直接说出某个巨头旗下的拼购业务，可能会非常轻松。因为这些巨头推出的拼购应用，名字上大同小异——手淘特价版、京东拼购、苏宁拼购、今日头条的“值点”……\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	此外，支付宝联合淘宝上线拼购小程序“每日必抢”，网易则推出了“网易一起拼”。总的来看，它们还都是以“拼”、特价为主要特性，为自己烙印下超值的标签。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	而从数据上看，拼购在近段时间以来也成为电商行业的一个热词。根据速途研究院发布的《2018上半年国内拼购电商市场研究报告》显示，在巨头的入场下，它们不仅让自身拥有了亮眼表现，还让拼购行业获得了整体提升。从微信指数和百度指数看，各个巨头的拼购业务都有着显著提升。这也意味着，以布局消费分级市场为目标的拼购，成为了当下巨头眼中的“香饽饽”。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	巨头在拼购行业的试水，还反应在将自身的资源不断向拼购业务倾斜。比如，很多巨头都举办了优惠活动来吸引消费者，并展现自身拼购业务的特性。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	比如：京东拼购频道此前公布了双11玩法，旨在以流量传播扩散+提升订单为目标，通过打造贯穿双11的拼购寻宝乐园，同时引爆11.8拼购玩法狂欢日，为拼购小程序引流，帮助平台转化新用户并提升订单量。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;text-align:center;\"=\"\"> <img border=\"0\" src=\"http://demoall.adashuo.com/25707/uploads/allimg/c191120/15J231440B4F-1U327.jpg\" style=\"height:auto !important;\" /> \r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	苏宁拼购则将重点在直采直销生鲜商品上发力。在刚刚过去的双十拼购日，苏宁拼购一天卖出了40万个柚子，这坚定了其发展生鲜拼购的战略构想。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	因此，我们可以看到，在巨头的不断试水下，拼购这一社交电商模式已经变得迅速火爆。对于消费者来说，这也是一个消费变得多元化的好兆头。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	品质化渐成主流\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	其实，如果不戴“有色眼镜”去看拼购的话，其身上还是有很多亮点的。拼购以低价引入流量，通过关系网对商品进行分裂曝光，在满足多数人追求“低价”需求的同时，又大幅度增加中小商家和尾货的曝光率和购买率。也正因为如此，拼购在当下俨然成为购物模式中的一股新势力。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	但值得注意的是，在拼多多一家独大的时候，其商品质量、售后等饱受诟病。山寨、造假的问题，也造成了诸多负面影响。而在巨头纷纷入场的情况下，实际上也意味着拼购将进入下半场。在下半场开启的同时，拼购也将迎来全新的发展拐点。拼购在展现品质化的同时，也将成为巨头业务的补充，让它们构建更为完善的商业生态矩阵。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	对消费者利好的消息，在于品质化将成为拼购的常态。同时，品质化也将是巨头拼购业务的竞争发力点。不管是为了稳固消费者群体，还是出于维护自身品牌形象的考虑，巨头都不会再去牺牲商品质量和售后来实现低价。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	它们会尽力展示自身的物流实力、电商交易技术能力、核心交易链路、消费保障制度等，将供应链优势发挥到极致。最终，巨头的拼购业务将让消费者享受到具有更高性价比的品质好货，并由此实现真正的消费升级。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	此外，拼购业务的上线也是对巨头自身实力的加强。以美团拼团为例，其让美团实现了从虚拟商品向实物商品的过度，完成了自身商业边界的扩张。中国社科院财经院互联网经济研究室主任李勇坚表示，“过去用户可能只有在吃饭等时候才想到打开美团，但如果增加了商品类拼团，既有用户可能会在APP上停留更多的时间用于浏览商品”。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	而对于巨头而言，以往虽然在努力强调业务之间的整合，但缺少了某个版块后，业务之间总会有割裂感。拼购业务的出现，或许就能成为“黏合剂”，让巨头的业务实现融合发展。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;text-align:center;\"=\"\"> <img border=\"0\" src=\"http://demoall.adashuo.com/25707/uploads/allimg/c191120/15J231440I050-1c916.jpg\" style=\"height:auto !important;\" /> \r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	值得注意的是，对于巨头来说，它们此前都面临着各自不同的发展瓶颈。而要寻找创新增长点，就必须在流量上痛下苦功。拓展流量的最佳做法，就是通过开辟新业务获取。而拼购身为“引流大户”，自然被巨头所看重。在拼购行业的下半场，它们将争抢中高端消费人群，不断攫取新的流量。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	相信随着巨头纷纷切入拼购领域，后者也在加速下沉。而就发展趋势来看，只拼价格不拼质量的原始拼购模式注定被淘汰。在被巨头开启的下半场，拼购有望与消费升级概念的成熟、人均消费能力的提升高度契合。届时，拼购业务也将成为巨头比拼的另一立脚点。\r\n</p>',	'doc.png',	1.00,	34,	0,	0,	0,	'2019-12-03 14:09:59',	'admin',	0,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	1.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	13,	1,	0,	1),
(28,	'联合国人类发展指数公布:香港列第4 中国内地第85',	'<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	11月5日，一项热搜出现在邦哥的微博首页，并且排名一路蹿升至第一，挂在榜首直至今日凌晨：6000多首歌从KTV下架。被下架歌曲中，《十年》、《泡沫》《死了都要爱》《听海》《K歌之王》等等大热歌曲赫然在列。许多媒体的标题用的是：你拿手的还能点么？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	而邦哥脑中也冒出了另一个问号：这些歌曲为什么被下架？谁主导了这次下架风波？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	一个民间组织，为何有权下架全国KTV的6000多首歌？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	这次下架风波毫无疑问是版权问题引起的：中国音像著作权集体管理协会（下称“音集协”）发出公告，要求KTV终端生产管理商和卡拉OK经营者在今年10月31日前，删除或者不向消费者提供6000多部音乐电视作品。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	乍一看这是一件好事，毕竟版权保护理应得到支持，即便6000多首歌的下架在短期内会给普通消费者带来一些麻烦，但依然有利于产业的良性发展。<strong>然而意外的是，邦哥就此与一位业内音乐创作者进行了解时，对方却对此次发出公告的“音集协”并不买账：这个协会其实不是国家的版权保护机构，之前还被央视曝光过收取高额版权费后，并没有给歌手支付费用，我对于之后钱的去向保留意见。</strong> \r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	业内人这样的评论，引起了邦哥的注意，我们随即找到了音集协官方微博，查看其回应此次事件的公告。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\"> <img alt=\"6609首歌从KTV下架，《十年》《泡沫》均中招，原因不止版权那么简单 \" border=\"0\" class=\"aligncenter\" src=\"http://demoall.adashuo.com/25707/uploads/allimg/c191120/15J231444420Z-10TG.jpg\" title=\"6609首歌从KTV下架，《十年》《泡沫》均中招，原因不止版权那么简单 \" style=\"height:auto !important;\" />众所周知，KTV使用他人音乐作品，需要依法取得授权。但全国KTV可以说是海量的，KTV所需要使用的作品也是海量的。实际经营中，要经营者自己去一对一地取得授权，说句实话，并不现实。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	音集协就是在这样的背景下成立的。我们查看了其官网资料，根据资料显示，该协会是会员制，注册会员后，协会可以帮助你进行统一的版权管理，对全国的KTV进行作品授权，或者进行相应的维权措施。但让邦哥十分惊诧的是，这次被下架的6609首歌，背后的版权所有者，没有一家是音集协的会员。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	换言之，<strong>音集协的权利范围本应是帮自己的会员授权和维权，这次却是向6609首他们本应管不着的歌，发放了“下架通知”</strong>……\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在音集协官方微博的回应公告中，这一消息得到了证实：\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\"> <img alt=\"6609首歌从KTV下架，《十年》《泡沫》均中招，原因不止版权那么简单 \" border=\"0\" class=\"aligncenter\" src=\"http://demoall.adashuo.com/25707/uploads/allimg/c191120/15J23144450T0-114138.jpg\" title=\"6609首歌从KTV下架，《十年》《泡沫》均中招，原因不止版权那么简单 \" style=\"height:auto !important;\" />这让邦哥不禁产生了一个疑问：不是音集协的会员，我的歌曲就不能在KTV里播放了么？音集协到底是一个什么样的组织，怎么会有这么大的权利，对非会员的作品也能进行下架处理？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	就此我们在其官网查找到了音集协的《协会章程》，章程总则中清晰地写明了音集协的性质：本团体是由依法享有音像节目著作权或者与著作权有关的权利人<strong>自愿结成的全国性、非营利性的社会组织</strong>。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	一个自愿结成的会员制民间组织，从法理上讲，应当并不具有行政执法权，按照常理本应无权对“非会员”的作品进行下架处理。而在音集协此次回应的公告中，对这一问题的描述如下：\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;text-align:center;\"=\"\"> <img alt=\"6609首歌从KTV下架，《十年》《泡沫》均中招，原因不止版权那么简单 \" border=\"0\" class=\"aligncenter\" src=\"http://demoall.adashuo.com/25707/uploads/allimg/c191120/15J2314445T30-12W41.jpg\" title=\"6609首歌从KTV下架，《十年》《泡沫》均中招，原因不止版权那么简单 \" style=\"height:auto !important;\" /> \r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	对此，邦哥咨询了法律方面的专家，对方表示：6000多首歌的权利人或其委托的代理公司对KTV经营者提起的单独诉讼，就法律关系上讲与音集协相互独立，并无关系。但公告中并未提到音集协与这6000多首歌的权利人或代理公司是否有委托关系，因此<strong>音集协此次的“下架通知”背后，是否有可能是接受了歌曲权利人本身的授权或委托，我们也不得而知。</strong> \r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	曾被众多媒体质疑、央视曝光高额版权费流向哪里？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\"> <strong>2006年，国家版权局规定，开始收取卡拉OK每包间一小时12元的歌曲版权费。我们日常去KTV的费用中，就包括了这部分版权费。</strong>那么这部分版权费收取后流向了哪里呢？根据文章开头从业者的说法，邦哥查阅了很多资料，发现这已经不是音集协第一次处于舆论中心。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	2009年，中央电视台连续多个栏目对音集协收取卡拉OK版权费的情况进行了报道；中央二套的《今日观察》栏目还播出了一期新闻专题节目《版权费还是保护费》，邀请两位专家，围绕卡拉OK版权收费及其分配问题。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	根据当时的报道，<strong>音集协自2007年开始收取KTV及卡拉OK版权费，至2009年，收取的版权费已达8000万元，但这笔钱的使用分配却很不透明，相当多歌手表示并未拿到应得的报酬，但作为集体管理组织的音集协却要收取高达50%的天价管理费。</strong> \r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在当时的采访中，音集协不愿详细说明收费方式以及对著作权人的返还方式。不过一位业内人士向央视记者透露，收费是通过一家叫做“天合文化”的公司进行的。根据公开资料，该公司成立于2007年8月，受音集协委托代收卡拉OK版权使用费。音集协负责授权，天合文化负责收费，二者形成一套KTV歌曲版权收费系统。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	而那时的国家版权局版权管理司王自强司长则认为音集协的做法有欠妥当，在接受记者采访时表示，“集体管理组织是一个非营利性机构，不能以组织企业来进行收费，只能建立自身的收费队伍。收费本体是你本身，你不能有一个第三者出来。”\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	那是音集协引起争议声浪最大的一次，此后也曾有过多家媒体跟踪报道过音集协收取版权费的相关内容。早在2008年就有北京中银律师事务所董正伟律师向国家工商总局、国家发改委举报，请求对音集协向KTV行业收取著作权使用费开展反垄断执法。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	而近两年，音集协受到的质疑更加密集了起来，2017年、2018年都有KTV联合状告天合公司（音集协的授权收费单位）进行行业和价格垄断，但最终都以天合的胜诉告终。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	有趣的是，<strong>音集协与天合文化的合作自2007年至2018年，11年间从未停止。但就在邦哥发稿前不久，音集协官网上出现了一份最新公告，终止了与天合文化的委托合作。</strong> \r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;text-align:center;\"=\"\"> <img alt=\"6609首歌从KTV下架，《十年》《泡沫》均中招，原因不止版权那么简单 \" border=\"0\" class=\"aligncenter\" src=\"http://demoall.adashuo.com/25707/uploads/allimg/c191120/15J231444A250-13U93.jpg\" title=\"6609首歌从KTV下架，《十年》《泡沫》均中招，原因不止版权那么简单 \" style=\"height:auto !important;\" /> \r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	被下架歌曲并非不能唱了，版权保护，路漫漫其修远兮\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	对于一个行业的健康发展来说，6609首无授权歌曲自KTV下架，理应得到支持。但版权收费的规范性、透明性，同样是应该得到重视领域。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在此次风波中，被认证为音集协副理事长的周亚平的微博发言，同样引发了相当多网友的不满：\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;text-align:center;\"=\"\"> <img alt=\"周亚平表示：希望权利人加入，而不加入的后果是“作品被摒弃在卡拉OK渠道之外”\" border=\"0\" class=\"aligncenter\" src=\"http://demoall.adashuo.com/25707/uploads/allimg/c191120/15J231444I530-14Kc.jpg\" title=\"6609首歌从KTV下架，《十年》《泡沫》均中招，原因不止版权那么简单 \" style=\"height:auto !important;\" /> \r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	周亚平表示：希望权利人加入，而不加入的后果是“作品被摒弃在卡拉OK渠道之外”\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在撰文的过程中，邦哥将此次下架的6609首歌曲完整名单下载了下来，发现实际上遭到下架的，只是该首歌曲的某些版本。例如周杰伦遭到下架的《告白气球》等歌，就仅限《中国新歌声》第一季播出版本被下架。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\"> <img alt=\"6609首歌从KTV下架，《十年》《泡沫》均中招，原因不止版权那么简单 \" border=\"0\" class=\"aligncenter\" src=\"http://demoall.adashuo.com/25707/uploads/allimg/c191120/15J231444PZ-15S59.jpg\" title=\"6609首歌从KTV下架，《十年》《泡沫》均中招，原因不止版权那么简单 \" style=\"height:auto !important;\" />虽然这样的版本限制让很多小伙伴产生了“虚惊一场”的感觉，但邦哥要提醒的是，<strong>版权制度的目的，以及所要保护的对象，是创作者和版权所有者的利益。权利人们的利益，决定了他们的生存环境。</strong>如果从业者无法生存，音乐产业的发展从何谈起？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	中国音乐版权保护之路，依然路漫漫其修远兮。\r\n	</p>',	'doc.png',	1.00,	31,	0,	0,	0,	'2019-12-03 14:10:31',	'admin',	3,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	1.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	12,	1,	0,	1),
(29,	'外媒:中国人点餐蹭睡让宜家食品部门进账百亿元',	'<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	人工智能时代已来，雷军为小米找的下一个风口是什么？成立相机部门能“干翻”华为吗?\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;text-align:center;\"=\"\"><br />\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	▲雷军在在故宫发布滑盖手机MIX3\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	作者 |马婧\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	编辑 |赵泽 杨砺\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在喊出“今年相机部门有没有年终奖，就看能不能干翻华为”之后，小米董事长雷军又发新手机了，这一次是在故宫。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	2018年10月25日，在故宫发布磁动力滑盖手机MIX3乾清宫户外发布会，雷军在现场有点激动，一个人solo了将近一个半小时。雷军在介绍手机后置相机时，突然天空中传来两声乌鸦叫，雷军忍不住笑场，说连鸟都在肯定小米手机，“这是我们第一次办的户外的发布会，还这么有趣啊。”\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	25日早间，小米集团发布公告称，预计到10月底，手机出货量将突破1亿台，提前两个月完成2018年全年目标。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	雷军在发布会上谈到，今年手机大厂商和小厂商之间的差距会拉大，主要原因是各家在相机、AI方面投入成本不同所致。今年5月，雷军在内部信中宣布，在手机部内成立单独的相机部，集中全公司优势资源，提升小米手机的拍照品质。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	雷军曾对相机部门的同事说，今年相机部门有没有年终奖，就看能不能干翻华为。25日下午更新了最新成绩，小米MiX3以103的成绩超过了华为P20。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	小米如何“干翻”华为呢？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	▲MIX3故宫乌鸦捣乱小米发布会现场 雷军笑场：连鸟都肯定了\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	未来高增速或不靠手机靠IoT\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	新京报：小米过去8年保持了高速的增长，未来还能有非常高的增速吗？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	雷军：我们对小米未来的高速增长很有信心。首先手机行业是一个很大的市场，2017年全球共销售手机14.7亿台，小米销售了9000多万台。随着5G时代的到来，手机市场可能再次迎来增长，虽然不会像过去增长那么快了，但这个市场即便不再增长，对于小米来说仍然有巨大的成长空间。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	其次，手机之外，小米在智能硬件和消费升级领域布局广泛，已经进入了100多个品类，建成了全球最大的IoT物联网平台。随着AI时代的来临，AI+IoT将产生巨大的价值，小米已经具备了一些优势。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	另外，小米在海外市场有巨大的机遇。小米手机已经进入了74个国家和地区，还有很多市场有待进入，我们的很多品类也还没有进入全球市场。随着小米一步一步进入新的市场，把新的市场做好，我觉得小米未来还有十倍以上的成长空间。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	新京报：我们注意到小米还在布局智能家居。有观点认为智能家居是个伪命题？你怎么看这个问题？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	雷军：“智能家居”不是一个新词，二十年前在国外就有了，只是一直没有推动。我们觉得背后主要原因是商业通道和技术通道没有打通，比如以前智能家居的成本非常高，家里必须重新装修一遍，这对消费者难以负担，此外，不同厂家的产品之间也很难互联互通。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	小米做了两件事情来解决，首先我们把一个个的产品智能化了，消费者买回家后，突然发现实现了智能家居，这是商业通道理顺了。另外，我们做了互联互通的模组，在技术上也打通了，小米智能家居产品由很多不同的公司生产，但只要用了这个模组就可以互联互通。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	智能家居目前只是刚起步，小米也只是刚跨过门槛，今后智能家居的发展空间可能远超我们想像。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	新京报：有人说，小米生态产品只是在做微创新，你怎么看这个问题？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	雷军：从我们创业的经验来看，成功背后都有不为人知的艰辛，哪怕是一点点成绩，都要付出巨大的努力。所以我觉得我们不要小看微创新，为了提升消费者的体验，哪怕仅仅是1%，我们也投入了100%的精力。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	小米立志要成为一家伟大的互联网公司，让全球每个人都享受科技带来的美好生我没有。我们只有全力以赴做好每一件小事，才是走在正确的道路上。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	下一个互联网浪潮是人工智能\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	新京报：如何看待互联网这20年来在中国的发展，如果用几个关键的时间点来划分，你会怎么划分？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	雷军：我觉得2007年苹果推出iPhone是个很重要的事件，智能手机的出现极大的改变了互联网，我判断手机会逐渐替代个人电脑，移动互联网的时代将会来临。2010年小米成立，2011年推出了第一代小米手机，我们推动了智能手机在中国的快速普及和品质提升，移动支付、电商、社交网络、短视频等行业在中国的蓬勃发展，都有赖于庞大的移动互联网人口，这方面小米做了一点贡献。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	新京报：互联网下一个浪潮会是什么？在这个浪潮下，小米的机会是什么？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	雷军：人工智能的时代已经到来了，人工智能也是小米最重要的战略，我们拥有四项巨大的优势，用户群、海量设备、海量的数据、对整个AI时代的认知，很早就重视了云服务和大数据。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	小米选择的突破口是IoT，也就是万物互联，我认为AI与IoT结合将形成AIoT，也就是万物智慧互联，在这个领域未来有着巨大的发展空间。小米已经建成了全球最大的消费物联网，连接了1.15亿台智能设备（不包含手机、平板和笔记本电脑），小米人工智能助理小爱同学月活跃设备超3000万，月唤醒计数超10亿次，累计唤醒次数超50亿次。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“天使投资人经历让我学会找风口”\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	新京报：从金山时代开始，业界对你的评价就是IT劳模，怎么看待这一评价？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	雷军：如果我们要实现与众不同的梦想，付出的不比别人多，怎么可能成功呢？我现在还是这样认为，创业并不光鲜，成功的企业家也不像大家想的，轻轻松松就成功了，哪怕一点点成绩，背后都要付出极大的努力。在成功的路上，其实只有这一个秘诀认真拼命地工作。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	新京报：天使投资人的身份对于创办小米有哪些帮助？创业者和投资人的思维方式最大的不同之处是什么？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	雷军：因为天使投资人做的就是看大势，找风口。我觉得创业要想五年后是什么样子？十年后是什么样子？什么是正确的事情，什么是正确的时间点？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	我当年是一个手机发烧友，认为手机上网是未来的趋势，未来10年是移动互联网的天下，那我接着就想应该做些什么？所以我用投资人的身份，去看谁在做移动互联网，去搞清楚移动互联网到底是什么，这个过程中我们越来越坚信移动互联网的未来，最终在2010年决定创办小米。\r\n</p>',	'doc.png',	1.00,	22,	0,	0,	0,	'2019-12-03 14:11:24',	'admin',	1,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	1.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	3,	1,	0,	1),
(30,	'北五环洋房TOP1|销冠 11月北京房企排行',	'<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	不在沉默中爆发，就在沉默中灭亡！\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	这句话来形容当下的区块链。2018年疯狂的区块链因受政策监管与打压，资本、媒体、甚至创业者都趋于冷静。或许，这就是黑暗里的爆发前夜吧。但这个前夜还很长很长…\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	最近一篇题为《业内人士：区块链逐步融入农业发展》文章引起我们的关注。该文提到：“截至目前，区块链已被应用于产品溯源、农业保险、农村金融、智能合约等多个场景。尽管目前区块链技术在农业领域的应用范围还较为有限，但是许多业内人士对于区块链在农业领域的未来发展前景仍然满怀期待”从种种迹象来看，业内人士非常看好区块链在农业领域和场景里的应用。另外，还有政府官员也为区块链+农业打CALL。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	内蒙古蒙草生态环境（集团）股份有限公司董事长王召明表示，作为农业大国，要利用物联网、大数据、移动互联网、人工智能、区块链等现代信息技术，大力推动农业全产业链改造升级，为实施乡村振兴战略插上互联网的翅膀。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	可以肯定：区块链没有倒下，区块链在等待机会。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	业内专家指出，2019年有望成为区块链技术真正落地应用，走向产业化的一年。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	区块链诞生之初，外界都追捧：区块链是各个行业的救命稻草。尤其金融行业、食品行业，当然也包括农业领域。我们聊聊区块链解决农业什么问题？我们认为个有以下几个问题！\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	1农业领域看好区块链\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	1农产品可溯源\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	农产品溯源一直是农业的一个痛点问题。而区块链技术利可以对记录实现不可篡改，因此从农产品的生产端到流通端、消费者都有详实的数据，可以实现消费者明明白白消费，提高消费者购买的意愿。农产品溯源可以提升农产品安全性以及食品的安全性。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	2信息透明\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	农业领域除了可溯源之外，生产者与需求方的信息也存在不透明的问题。一旦区块链技术应用与农业。大家就可以通过大数据分析，建立种植户、采购商的信用评级参考；利用智能合约在种植户和采购商之间保证公平交易。同时，区块链技术可以提高农产品买卖双方的契约精神。另外，随着食品供应链中区块链的出现，这可以简化这一过程，因为数据管理系统，将一系列农民、加工商、分销商、监管机构、零售商和消费者纳入其雷达范围的数据管理系统变得更加透明。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	3降低成本\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	区块链技术运用之后，生产、流通等2大环节的成本会大大降低。比如，区块链技术解决信息自动存贮和数据库的功能，如此就减少了人工的投入和其他设施的投入。另外，区块链及应用实现万物互联，帮助生产商和渠道商降低各项开支。同时，生产和流通成本的降低，也会降低农产品的价格，最终还是消费者获利。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	因此，区块链技术在农业领域的应用等到各级人士的认同。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	2现在的区块链农业玩家\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	从以下多个案例来看，这些企业的确把区块链技术应用到用户服务中。他们希望借助区块连技术解决食品安全和可溯源，从而提高消费者对品牌的认可度。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	1沃尔玛\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	沃尔玛公司在2017年内在区块链技术领域作出了大量尝试。沃尔玛一直在与IBM合作，共同开发针对食品安全问题的区块连解决方案。比如，沃尔玛把区块链放在芒果、猪肉等生鲜农产品上。沃尔玛食品安全副总裁Frank Yiannas曾表示：“我们的客户理应拥有更加透明的供应链。我们认为在21世纪，以前那种一步一步去追溯源头的方式已经过时了。这是一项由技术支持的明智举措，它将极大地造福我们的客户，并彻底改变食品体系，使所有的相关者受益。”\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	2 Dreyfus\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	大宗商品交易公司Louis Dreyfus（路易达孚）宣布已试用由ING（荷兰国际集团）等一批金融机构开发的基于区块链的交易系统。Dreyfus使用区块链平台来完成与中国供应商的大宗大豆交易，极大地缩短了交易时间。同时，据参与测试的公司表示，这次测试涉及从美国运到中国的大豆，并在平台内保存所有相关文件（包括销售合同和信用证）。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	3可口可乐\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	2018年，可口可乐正在与美国国务院、区块链信托加速器（BTA）、区块链技术公司Bitfury集团以及崛起币（Emercoin）共同合作，推出一项基于区块链技术的试点项目。同时，可口可乐公司建立区块里的平台，以帮助确保道德的糖生产。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	4家乐福\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	2018年，欧洲最大的零售商家乐福已经开始采用区块链账本技术去追踪鸡肉、鸡蛋和西红柿从农场送到商店的全过程，并将在未来几年在其所有生鲜产品线上部署这种技术。比如，2018年3月，家乐福中国首款区块链产品——琯溪蜜柚，获得用户疯抢。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	5 Smart农场\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	中国农业已经迎来4.0时代，高科技融合成为农业发展的方向。上海华中农投农业科技有限公司旗下Smart农场大力推动区块链的应用。将区块链技术与农业相结合后，能最大限度地消除信息不对称，提高整个产业链的信息透明度和及时反应能力，从而实现整个产业的增值。减少农药投入，提高农产品品质。解决农业的痛点，解决农产品的食品安全、食品供给问题，真的能让中国人都尝到放心的味道。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	3未来走向\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	区块链去中心化等特性，将大幅降低互联网维护成本，提升农业物联网的智能化和规模化水平。同时，基于区块链技术的农产品追溯系统，解决了消费者对于产品的信任危机，让人们的餐桌更健康，更安全。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	另据前瞻产业研究院发布的《中国区块链行业商业模式创新与投资机会深度分析报告》统计数据显示，随着区块链应用场景扩展，预计2019年具有投入产出的区块链企业超过600家，产业规模有望超过8亿人民币。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	有人预测：2019年，“区块链技术”正逐渐从幕后走向台前。我们从2个方面来看：区块链技术迎来利好！\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	1）从大背景来看，国家政策打击比特币，但支持区块链技术在各个行业的应用。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	2）从行业来看，目前大数据和人工智能的发展，区块链技术也将会逐步与其他高科技项目融合赋能产业。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在农业领域，区块链农业又将会呈现哪些趋势和走向呢？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	1物联网＋无人机＋区块链\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	中国农业已经迎来4.0时代，高科技融合成为农业发展的方向。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	物联网＋无人机＋区块链的结合将有利于精准农业的发展，减少农药投入，提高农产品品质。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	其中，物流确保万物互联，无人机提供生产管理服务，而区块链提供记录和可溯源等技术。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	2区块链+数据+人工智能\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	区块链应用于农业，能最大限度地消除信息不对称，提高整个产业链的信息透明度和及时反应能力，从而实现整个产业的增值。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	而区块链+数据+人工智能的融合发展，可以推动农业大数据的价值最大化，降低投入成本。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	3区块链+农业金融\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	2月初，中国政府发布了“关于农村金融服务振兴的指导意见”。此次提出的新框架，是国家农村振兴计划中金融服务效率提高计划的一部分。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	同时，该指南据称将有助于促进农村金融部门中如区块链等新技术的应用，以“改善农业信贷风险的识别、监测、预警和处置水平”。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	该公告还预测，新技术将鼓励金融机构“为农村电子商务开发专用贷款产品和小额支付结算功能，并开辟农村电子商务资本链”。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	区块链+农业金融将会为小农户贷款提供便捷途径，为农业金融机构的征信带来真实性和可预测性。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	4区块链+农村物流\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	随着区块链、物联网、大数据等新兴技术与物流行业的深度融合，供应链正成为区块链技术最具潜力的应用场景之一。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	由于农村物流的小散，导致包裹丢失、农产品上行困难等窘况。但区块链技术可以解决这些问题。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	西南交通大学交通运输与物流学院副院长罗霞指出示，农村振兴是今年党中央非常重要的战略部署，与农村物流高质量发展紧密相关。加强云计算、区块链、人工智能等供应链智能化技术在农村物流中的应用，为农产品的生产、检测、周转、销售、品控、管理等提供智力支持。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	5区块链+农业供应链\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	这一类应用就是各大商场嫁接区块链的原因。比如：沃尔玛、家乐福等大型超市把整个生鲜和食品供应链纳入区块链管理，从而降低成本，提高产品的安全性。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	目前，美国农业巨头嘉吉等都在大力发展区块链+农业供应链金融的应用。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	总结一下，2019年区块链在农业领域的应用将会再次迎来爆发。但我们还要明一点：区块链只是一项技术，而不是赚钱的工具。在整个农业发展中，区块链只做赋能者，而不是主导者。如此，路子才会越走越宽！\r\n</p>',	'doc.png',	1.00,	17,	0,	0,	0,	'2019-12-03 14:13:27',	'admin',	14,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	1.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	10,	1,	0,	1),
(31,	'智能快递柜是否能成为物流末端的“主流”？',	'<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	电子商务飞速发展，快速增长的包裹数量与日渐减少的快递员数量已经不成正比。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	快递员的工资回报越来越高，为什么这个职业在近年来从事人员锐减呢？对此，有很多快递员反映，虽然能够得到很高的工资回报，但随着人们对服务水平的要求也越来越高，他们也越来越辛苦。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	同时，快递员的社会地位相对较低，随着人们文化水平及文化素养的逐渐提高，一些有学历有技能的人都已不太愿意做快递员。申通副总在7月25日召开的中国快递“最后一公里”峰会上就表示，现今快递行业的痛点已不仅是解决“最后一公里”的问题，而是怎样才能够招到更多的快递员。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	中国高速发展中，人口红利也在逐渐的减少，越来越多的事情都开始被智能化技术所取代，但快递行业是属于劳动密集型企业，非常依赖快递员。快递行业正处在用人难之际，双十一等各种电商狂欢节的到来无疑是让这些快递企业悲喜交加。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	智能快递柜提升末端物流配送能力，备受物流企业青睐\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	快递员不足是人口红利减少的必然结果，因此急切需要新兴技术缓解快递行业的压力，智能快递柜作为解决方案就这样“问世”了。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	智能快递柜在2012年萌芽，中邮速递易率先推出智能快递柜，在初期遭遇了很多的质疑和非议，但在包裹数量不断增长以及城市年轻劳动力不足的情况下，智能快递柜已经成为末端物流配送能力的重要补充，各路资本企业竞相涌入该市场，想分得一杯羹。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	2015年6月，顺丰、申通、中通、韵达、普洛斯投资5亿元成立丰巢科技；2016年10月，中集e栈、上海富友收件宝、江苏云柜组成创赢联盟，形成了以速递易、丰巢和创赢联盟为主的三巨头格局；2017年7月，中国邮政集团与驿宝网络入股速递易，中国邮政以50%股份控股速递易，“国家队”正式进入智能快递柜行业……智能快递柜已然成为物流企业人手必备的基础设施。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	国家邮政局10月17日发布的 《2018年9月中国快递发展指数报告》显示，快递企业与第三方创新末端投递形式，基本形成上门投递、智能箱投递、平台投递等多元末端服务体系，主要企业设立智能快件箱25万组，箱递率达到8.4%。高速增长的数据表明智能快递柜前期虽饱受争议，但后期已逐渐被民众所接受。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	智能快递柜突破派件瓶颈，效果显著\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	首先，智能快递柜降低了人力成本，减少了快递员的工作负荷。快递员的工作量和工作任务较为繁重，在人手不足的情况下一个快递员往往需要承担起更多的工作，经常超出本来的工作时间，因此快递公司需要对快递员支付较高的人力成本。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	智能快递了增加派件数量，在提高了快递员的工作效率的同时，也提高了他们的收入，在一定程度上缓解了“用人难”问题，降低人力成本。在这一点上，丰巢获取得的效果极为突出：在今年九月初，丰巢与链家进行合作并声称他们的日均派件量已高达900万+,这个数据对于快递行业来说无疑是一个巨大的进步。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	其次，智能快递柜提高了用户隐私保护力度，取件时间更随意。当今社会，人们对于隐私非常重视，而在传统的快递人员配送模式中，存在快递信息被其他人窃取或是快递在寄存的时候丢失等问题，智能快递柜保密性更强，能极大减少了这种问题的发生。再加上传统的配送模式中快递员配送的时间可能会和收件人在家的时间不对等，给收件人带来了困扰，智能快递柜投入使用使得忙碌的人们可以随时取件，极为方便。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	智能快递柜陷入困境：难盈利、争议大\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	智能快递柜诞生是时代进步的需要，也给我们的生活带来了巨大的改变，但很多问题也接踵而来。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	首先，盈利难。一方面是因为快递柜的设备生产成本高和在每一个小区内投放的租金比较高，快递柜的场地年租费也较高，同时维护费用也不低。过高的成本使智能快递柜不能为企业带来营收利润，这对每一个企业来说都是致命的打击。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	佼佼者丰巢和速递易均面临着巨大亏损：截止2017年9月30日，丰巢科技在该年9个月期间的营业收入为1.6亿元，净亏损从2016年的2.5亿元扩大到2.76亿元，负债总额扩大到12亿元；运营速递易项目的三泰科技也是出现常年亏损，2015 年亏损3792.8万元 ，2016 年亏损 12.69亿元，2017年第一季度亏损也将近3000万元。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	另一方面是用户往往不会愿意为此付费。用户认为在购买商品时已支付过运费，取快递时就不应该再支付额外的费用，使得快递柜的亏损日益增加。同时，蜂巢、速递易等快递柜也开始向快递员收取存放费用，其中速递易快递柜的收费标准为：大箱0.6元/件，中箱0.5元/件，小箱0.4元/件，但很多快递员不愿承担这些费用。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	其次，智能快递柜虽然提高了快递员配送快递的效率，但使得快递员很轻松的逃避了签收这一流程。用户无法进行当面进行签收，使得物品运输过程中出现的质量问题时的合法权益无法得到保障，收货时发现快递有问题不知该向谁反映。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	最后，在包裹数量的飞速增长的背景下，快递员如果像从前一样一件件把快递送到消费者手中显然是不太现实的事。所以现在的快递员在快递高峰时段一般都使用智能快递柜，不会打电话一一进行通知，在把物品投入快递柜时会由系统自动给用户发送取件通知，而如果快递员在放入物品时把用户的手机号输入错误，会导致用户无法接收到取件通知，从而超时取件。现在部分品牌快递柜超过一定的取件时限需要收取一定费用，这让用户难以接受。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	另外，有用户在使用丰巢快递柜时，页面会出现“打赏”等字样，价格以1、2、5元为不等，这样确实能为丰巢带来一定的收益，虽然不是强制收费并且设有“跳过”的字样，但由于字体过小，有引诱用户消费的嫌疑因此用户在使用过程易产生误解与不满。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	智能快递柜如何赢得“民心”？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	智能快递的问题柜已经严重影响后期的战略布局和发展，企业应当如何解决成了广泛关注的焦点。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	首先，智能快递柜最初出现时毫无营收利润，很大程度上是因为单纯的取件不可能有任何收入增长，但是现在智能快递柜的发展已涉及到寄件的环节，这意味着快递柜也可以从中赚取一定的利润。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	智能快递柜要想继续获得更大的盈利，应该继续为用户提供更多增值服务，让用户为此愿意付出相等的费用。比如，在各种人流量较大的公众场合，有很多用户因为手上提的东西过多有很大的不便，快递公司可以在这些场合投放寄存柜方便用户存放，并收取一定的费用，据了解蜂巢已经在试点，今年5月中标了杭州周边17个高铁站，总计36组寄存柜的订单。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	其次，面对快递柜无法当面签收的缺陷，快递柜企业应继续完善快递柜的基础硬件设施，比如在每一组快递柜上安装摄像头，用户在取包裹时可以将包裹在摄像头下展示，将来包裹质量出现问题时可以避免物流企业和用户之间产生不必要的纠纷。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	最后，针对部分用户不满快递员在未经允许的条件下投递快递柜的问题，早在2016年国家邮政局发布的《智能快件箱投递服务管理规定（暂行）》中就曾明确提出，“经营快递业务的企业在使用智能快件箱投递快件前，应当征得收件人明示同意”，同时用户有权利决定是否使用快递柜或是按指定地点取货，用户应该积极行使自己的权利。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	企业在这样的背景下应加大对快递人员基本服务知识的培训力度，同时加强对客服人员处理客诉的能力，及时处理客户问题并进行反馈。快递员在把包裹放入快递柜时应检查该快递是否为需要保鲜、即食类食品，一旦出现商品问题则由快递公司或快递员承担全部责任。面对取件通知收不到等问题，在首次投递后收件人未能提取的情况下，快递企业应及时取回快递，联系收件人后再提供投递服务。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	小结\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	时代与技术在发展中，任何行业的各个环节都应该往效率更高，成本更低道路上发展。物流末端的需求是多样化的，送货上门是主流，但智能快递柜的市场潜力也不可小觑。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	根据中商产业研究院发布的 《2018-2023年中国智能快递柜市场前景及投资机会研究报告》 ，预计2018年智能快递柜市场规模将达169亿元，到2020年，中国快递柜市场规模将达近300亿元。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	所以，丰巢等智能快递柜未来应加大沟通协调力度，在提高消费者满意度的同时，尽快解决盈利模式问题，尽可能地保证效率、成本、体验和信息的互动。\r\n</p>',	'doc.png',	0.00,	16,	0,	0,	0,	'2019-12-03 14:14:23',	'admin',	1,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	0.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	10,	1,	0,	1),
(32,	'刚宣布弹劾条款 民主党就送特朗普一次“胜利”',	'<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	今年5月，唱吧终于完成了将近一年半的上市辅导工作。网上有消息称，唱吧在一个月后，就会正式向证监会递交招股书，踏上A股创业板的上市征途。但眼看着2018年就快要过去，却迟迟未见唱吧上市的消息。对此，唱吧创始人陈华在接受媒体采访时表示，对唱吧上市问题不愿多谈，言外之意是唱吧在近期内可能不会寻求上市。这突如其来的转变，让人们疑惑不解。唱吧在完成一年多的漫长上市辅导期之后，为何不愿上市？其究竟打的是什么“算盘”？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	唱吧上市搁浅，原因为何？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	唱吧从2012年上线起，便风光无限。其在上线首日注册用户就超过10万，5天之内登顶AppStore排行榜。易观数据显示，直到2016年第3季度，唱吧还以53.6%用户渗透率位居移动K歌领域第一的位置。彼时，唱吧正如日中天，选择上市无疑是正确之举。然而世事无常，经过将近一年半的漫长辅导期，国内的在线K歌市场早已“物是人非”，唱吧已然错过了最佳的上市时机。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	其一，全民K歌抢了唱吧“风头”。众所周知，全民K歌背靠腾讯，可谓是含着“金钥匙”出生。全民K歌不仅拥有微信与QQ两大流量入口，还与QQ音乐共享丰富的音乐版权，在流量与音乐版权方面都有着天然的优势，是唱吧最强劲的对手。据了解，全民K歌自2014年上线起，其活跃人数一直高增猛涨，在2016年成功超越唱吧，并逐渐拉开差距。据易观数据，2018年第三季度，唱吧活跃用户为6560万人，而全民K歌活跃用户则为20705万人，是唱吧的三倍。面对全民K歌的“攻城略地”，唱吧显然处于不利地位。而全民K歌的赶超，可能打乱了唱吧的上市计划。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	其二，短视频平台的崛起，冲击整个互联网娱乐市场。近几年，由于快手、抖音等短视频平台的崛起，整个互联网娱乐市场变的更加“拥挤”，唱吧的K歌业务、直播业务等都受到了一定的影响。QuestMobile数据显示，2018年7月，短视频APP行业月度活跃用户规模为5.08亿人，而短视频APP行业总使用时长在移动互联网中的占比达到惊人的9.2%，要知道，就算是在线视频的占比也仅有9.5%。可见，短视频APP行业已经抢占了大量互联网用户的上网时长，唱吧无法视而不见。再加上全民K歌的存在，唱吧要想巩固自身地位并不容易，目前也很难有华丽的数据支撑，若是在此时上市，唱吧的估值可能并不理想。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	其三，互联网股市动荡不安。最近国内不少已经上市的互联网企业过的并不“如意”，如小米、拼多多和美团等企业都出现了市值大幅下滑的情况，就连腾讯、阿里巴巴等老牌互联网企业也没能避免。受此影响，唱吧此时选择不上市或许是明智之举。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	一方面，在国内互联网股市行情不利的情况下，唱吧此时上市无疑是逆水行舟，有着“流血破发”的风险；另一方面，今年国内的互联网公司纷纷申请上市形成了“上市潮”，如宝宝树、映客、小米和拼多多等，如此多的公司扎堆上市，吸引了不少资金注入，导致资本市场紧缩，也就是说投资人手里的钱越来越紧张。这也许会造成唱吧融资困难，难以得到理想的融资金额。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在这些问题影响下，唱吧暂时将上市的计划搁浅，等待更好的时机上市，或许是不错的选择。不过除了上述三个原因之外，也有业内人士猜测，唱吧之所以要搁浅上市，可能是其要放弃A股创业板，而选择赴港上市。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	港股市场火爆，令唱吧有所动摇？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	对于唱吧要赴港上市的猜测，也并不是没有依据。早在2015年，唱吧就曾想要赴美上市，但由于美国缺乏与唱吧对标的产品，而导致其估值过低，令唱吧有所顾虑。与之相比，当时国内的A股市场行情较好，且国内资本对互联网科技股也愈发青睐。所以再三思考后，唱吧毅然拆除了VIE架构，选择回国赶赴A股上市。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	时至今日，随着港交所在上市机制上的改革，首次接受同股不同权企业上市，为互联网企业打开了一扇大门，包括小米、美团点评、平安好医生和宝宝树等多家明星企业都选择在港股上市。而此时的唱吧或许面临着与三年前类似的选择题，是A股还是港股？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	据了解，上市A股要求较为严格，除了必须盈利三年才能申请IPO外，还必须同股同权。而现在的港股市场，除了支持同股不同权企业上市，其监管机构也更加独立透明和高效，公司一般在6到12个月就能完成上市过程，可以帮助企业更好地把握好上市时机。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	此外，A股实行的是“T+1”交易制度，股民们当天买进的股票当天不能卖出，且还有涨跌幅限制。而港股采用的则是“T+0”交易制度，在当天交易时段内，相关机构和股民们可以自由买卖，交易次数与涨跌幅均无限制，这种方式不仅能够提高市场的交易量，还能帮助投资者及时止损。所以二者相对比较来看，港股市场规则似乎更加灵活且合理化，能帮助企业有更好的发展。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	且从根本上来讲，企业上市无非就是希望借助资本的力量，获得更好、更快速的发展。而随着港交所改革，港股已经成为了众多互联网公司上市的首选。在此条件下，唱吧若是选择“跟风”，改赴港股上市，也不是没有可能。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	不过从目前来看，在市场竞争加剧、股市动荡等问题影响下，唱吧此时上市并不稳妥。所以暂时将上市计划搁浅，继续修炼“内功”，才是唱吧最好的选择。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	养精蓄锐，厚积薄发\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	目前，纵观整个移动K歌市场，已然是唱吧与全民K歌双雄称霸的局面，像天籁K歌、K米和酷狗唱唱等K歌产品已经难以给全民K歌、唱吧二者带来威胁。可见，唱吧在移动K歌领域还是有着非常明显的领先优势，只要其能够完善自身，加强功能创新，或许就能够摆脱全民K歌所带来的竞争压力，在互联网娱乐市场中走的更远，其上市之路也会变得更为平坦。对此，唱吧可以从以下三个方面入手。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	首先，丰富曲库资源，提高音乐品质。音乐版权是移动K歌行业的刚需，缺少相应的音乐版权，用户就无法得到理想的K歌体验。如在用户K歌时，一定会选择自己喜欢的音乐进行录唱，但用户若是在唱吧中搜不到自己想要唱的歌曲，在别无选择之下，用户就会选择用其他的K歌软件进行录唱，最终造成唱吧的用户流失。因此，唱吧要想缩小与全民K歌的差距，还需与相关的音乐版权公司合作，丰富自己的曲库资源。同时，唱吧还应继续提升APP内的伴唱、录音和修音等音乐品质，争取为用户提供更加优质的K歌享受，以此来留住和吸引更多用户。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	其次，加强线上、线下融合，丰富用户K歌体验。如今，唱吧正在大力布局线下市场，其不仅花费数千万元战略投资麦颂KTV，并实现了与麦颂KTV在社交、服务等多方面的合作，还大力布局线下移动迷你KTV业务，取得了不错的成效。据了解，唱吧不光在全国拥有400多家麦颂KTV门店，还在商场、超市和机场等公共场所布下了2万多台迷你K歌亭。不过唱吧虽然在线下布局极广，但其线下资源还未能与线上达到有效的结合。目前唱吧在APP内只提供了KTV包房预定、在线点歌和在线切歌等常用功能，还有很大的完善空间。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	对此，唱吧可以在APP内添加游戏点歌、K歌评比和K歌挑战赛等有趣功能，加强用户线下与线上的互动。同时，用户在麦颂KTV里演唱的歌曲最好也能保存在唱吧APP中，让用户可以在唱吧APP中发布并分享自己在麦颂KTV里的演唱歌曲，这不仅满足了用户的分享欲望，又加强了线上与线下的融合，可谓是一举两得。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	最后，走出海外，争夺更大的移动K歌市场。如今，唱吧已经在国内取得了不错的成绩，其知名度和影响力也都达到了一定的高点，所以唱吧要想再有突破，并不容易。在此情况下，唱吧若是向海外市场发起冲击不失为一个选择。一方面，目前海外的许多国家都缺少类似唱吧这样的K歌产品，还是一片蓝海，这对唱吧来说有着不错的发展机遇；另一方面，在全民K歌、抖音、快手等平台影响下，国内的互联网娱乐市场空间变窄，唱吧要想继续在此环境中发展将受到不小的阻碍。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	总的来说，虽然上市会为唱吧带来新的发展机遇，但在市场竞争加剧、股市动荡等问题影响下，此时上市，对唱吧来说有着较大风险。因此，唱吧只有继续精细化运营，加强线上线下融合，并等待时机成熟后再进行上市，才会迎来更好的发展。\r\n</p>',	'doc.png',	0.00,	41,	0,	0,	0,	'2019-12-03 14:17:25',	'admin',	3,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	0.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	14,	1,	0,	1),
(33,	'驻阿美军车队遭遇汽车炸弹袭击 恐造成多人伤亡',	'<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	换上炫彩外壳，装上多变口味的烟弹，上市多年的电子烟今年突然热度飙升，成了备受追捧的创投领域。除了罗永浩在发布会上顺势推销的福禄电子烟，2018年末到2019年初，还有近10个新兴电子烟品牌出现。在深圳华强北电子市场，出售电子烟的广告牌更是如雨后春笋般涌现。但面对日趋严密的控烟大网，创业者们能否咽得下“这口烟”仍存在极大变数。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\"> <strong>电子烟突然变网红</strong> \r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	蓝莓、菠萝、水蜜桃、绿豆冰棒、柠檬茶……说到这些，不少人会联想到口香糖或是冰淇淋，却几乎没人能想到，这些全都是电子烟推出的新口味。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	精巧如U盘或是一根签字笔，也不用点火，从口袋里掏出来，打开开关就能用——近一年来，以电子产品形象出现的电子烟成了创投领域的新网红。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	今年1月，罗永浩在子弹短信新版本“聊天宝”发布会上，顺势推销了一款名为福禄、由锤子科技二号人物朱萧木创业推出的电子烟产品。紧接着，同道大叔创始人蔡跃栋与黄太吉创始人赫畅推出的“YOOZ柚子”，5位自媒体人组成创始团队的“灵犀&nbsp;LINX”也纷纷杀入。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	猪年春节，常年浸淫在科技圈、创投圈的自媒体人士陈女士惊讶地发现，平日里不抽烟的她，竟然收到了3种不同的电子烟产品作为新年礼物。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在深圳华强北，曾经卖VR眼镜、贴牌手机和智能家居产品的柜台，纷纷开始转售电子烟。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	突如其来烧起来的电子烟，背后是资本不断添柴加火。2018年，国内有十几家电子烟公司获得资本青睐，总融资额达数亿元。Wel鲸鱼、YOOZ柚子、魔笛MOTI、TRYMIX反正、GOIN谷云、APOC……新兴的电子烟品牌让人目不暇接，俨然造就了岁末年初最火热的创业领域。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\"> <strong>风口背后的同质化</strong> \r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“电子烟界的iPhone”、“颜值爆表一口解馋”、“重新定义吸烟”……在各家打出的广告语中，几百元一支的电子烟似乎成了可供电子发烧友们品玩一番的电子玩具。然而，花哨热闹的营销语言背后，电子烟的实质技术并没有太大区别。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“花几个月到半年时间，联系供应商、备货、外观设计，剩下就不需要你再做什么了，几乎没有任何硬性投入，本质上是个非常‘轻’（投入）的生意。”早期投资人付强向媒体透露，做一个电子烟项目，对技术等原创能力的要求几乎没有门槛。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	多位行业人士透露，由于国内电子烟供应链已经被电子烟发展较为成熟的国外市场培育得非常完备，因此很多新创立品牌都是通过代工生产。有技术爱好者对几款热门电子烟进行评测后发现，几个品牌在开关控制、烟油技术等方面相差无几，只是烟弹、外壳颜色、口味等进行了不同的排列组合与拼凑。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“电子烟的产品结构并不复杂，主要构成也就是充电电池（烟杆）、雾化器还有烟油三部分。”新晋电子烟品牌灵犀创始人章晋源坦言，电子烟的制造门槛并不高，确实存在行业同质化问题，“灵犀LINX当前着重聚焦于品牌环节，属于产业链下游，希望设计的首款产品具有品牌辨识度。”\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\"> <strong>电子烟也有多重风险</strong> \r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“清肺水果味”、“健康清肺蒸汽烟”……稍加留意就会发现，不少电子烟公司将产品与健康挂上了钩。在他们口中，因抽烟承受健康风险的烟民可以通过电子烟追求潮流文化、拥有“健康生活方式”。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	电子烟是否能够像一些公司所说的那样起到“代烟”、“辅助戒烟”的功效？目前尚无定论。令人担忧的是，一些原本不吸烟的人因为对电子烟的好奇而加入了烟民行列。在游戏公司工作的白先生告诉记者，他的同事和合作伙伴里出现了好几位新一代“电子烟民”——而他们过去根本不碰香烟。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	北京营养师协会理事顾中一提醒，电子烟中虽然没有普通烟草燃烧所产生的焦油、一氧化碳等有害物，但仍然含有有毒、成瘾的尼古丁，对普通人特别是儿童、青少年仍然有危害。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	记者在一家电子烟的天猫店铺内发现，虽然商品详情页面的底部用黑色背景的字体写着“未满十八岁不允许购买”，但一不留神就会错过这一信息。并且，记者在尝试下单时，店铺对身份信息、年龄等方面毫无要求，消费者可以随意下单购买。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	顾中一还提醒，由于目前市场监管并没有完全到位，缺乏相关国家标准，电子烟产品中用到的原料、调味剂、工艺都较为随意，厂家很可能为了增加新奇体验加入一些对人体有害的物质。“哪怕是一些比较常见的添加剂，正常食用是安全的，吸入肺部却可能带来潜在风险。比如丙二醇是很常见的食品添加剂，但是燃烧后容易刺激呼吸道，一些电子烟的烟雾中也可能含有重金属。”\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	对创业者来说，更大的考验来自于市场的不确定性。在控烟大势下，多地已经将电子烟列入了管控范围。今年2月，继杭州、南宁等城市在公共场所禁止使用电子烟之后，深圳在其控制吸烟条例征求意见稿中将电子烟纳入了控烟“黑名单”。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	意识到道德、法律等多重风险，一些科技上市公司急于与电子烟划清界限。今年2月中旬，小米公司官方微博就对“小米旗下生态链公司将进军电子烟领域”一事进行回应，称“小米不会做电子烟，此事纯属谣言”。\r\n	</p>',	'doc.png',	1.00,	31,	0,	0,	0,	'2019-12-03 14:18:03',	'admin',	2,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	1.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	12,	1,	0,	1),
(34,	'专家预测未来5年中国经济:GDP超百万亿 增速重回7%',	'<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	2018年可谓是中国智能音箱的元年。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	业内普遍认为，智能音箱是切入智能家居使用场景、并易于被用户接受的理想入口，而智能家居的开关一旦被打开，更多的产品和服务将快速进入消费者的日常生活，获得一个更多元的商业环境。因此，近两年国内外科技巨头、互联网巨头皆大力发展智能音箱，使得该领域得到飞跃式增长，并从小众逐渐走向大众。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	值得一提的是，智能音箱除了具有巨大的消费市场外，对于互联网巨头们来说更起到AI市场的“门票”的作用。在这个快节奏的时代，企业之间的竞争更加激烈，率先拥有某一行业的门票就相当于成功了一半。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	由此，继国外亚马逊、谷歌、Facebook、苹果等科技巨头布局智能音箱产业之后，国内如阿里、百度等巨头也纷纷入局，小度智能音箱、叮咚、天猫精灵等产品在市场活跃度直线上升，国内智能音箱市场一片繁荣，随后在去年打起了“智能音箱价格战”。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	全球互联网巨头共掀全球智能音箱浪潮\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	根据Strategy Analytics发布的《2018年第三季度全球智能音箱市场报告》，2018年第三季度全球智能音箱出货量达到2270万，同比增长197%，创历史新高。其中，亚马逊智能音箱的全球份额与2017年相比有大幅下降，但出货量一直在上涨，第三季度市场占有率依然最高，达到32%，而谷歌以23%的市场占有率紧追其后。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	值得一提的是，来自中国的阿里、百度、小米智能音箱出货量分别排在全球第三、第四、第五位。当中又以百度表现最为亮眼，其市场占有率从2018年Q2的1％增加到2018年Q3度的8％，超越小米，成为当之无愧的黑马。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	而根据eMarketer《2019年智能音箱市场趋势观察》的预测，2019年中国将拥有8550万智能音箱用户，超过美国7420万的用户数量。智能音箱在美国网民中的普及率为26.0%，远高中国的10.0%，因此未来中国智能音箱领域还有极大的发展空间。不过即便如此，国内企业想要在智能音箱领域进一步发展仍有极大挑战。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	首先，是亚马逊、谷歌、苹果等海外企业更加成熟的智能音箱产品的冲击。亚马逊于2014年11月发布了Echo音箱，揭开智能音箱的序幕，打了人工智能领域“领头羊”谷歌、设备领域“领导人”苹果一个措手不及，成为智能音箱领域的第一人，为其之后进军智能家居领域打下基础。随后谷歌、Facebook、苹果等科技公司纷纷跟进，相继推出GoogleHome、Portal、HomePod。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	而后，无论是亚马逊并购互联网路由器初创企业Eero，还是谷歌推出Google Wifi，都表明国外在智能家居领域发展正愈加成熟，由此给国内市场带来的冲击是巨大的。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	其次，是国内错综复杂的智能音箱市场而产生的原生阻力。国内智能音箱市场厂商繁杂，主要有五种类别：一是以BATJ等为主的互联网公司，希望通过语音这一入口建立智能生态，为既有的内容和服务寻找新市场；二是以科大讯飞为代表的，专注于技术开放平台建设的技术厂商；三是以喜马拉雅等内容厂商；四是主打智能家居的创业公司；五为以漫步者为代表的传统音箱厂家。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	与国外相比，国内智能音箱领域除了厂商更繁杂、竞争更激烈外，在时间上也有一定的滞后性。国内第一款智能音箱叮咚诞生于2015年，由京东与科大讯飞联合推出。此后国内智能音箱市场沉寂，直至2017年阿里试探性地推出天猫精灵，小米、百度等企业不甘落后，纷纷入场，国内智能音箱才进入密集发售期，一时间智能音箱领域热闹非凡，“百箱争鸣”。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	当先天不足遇上恶劣生存环境\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	当下，我们不能否认的是，随着家庭中联网设备的不断增加，有极大几率成为未来智能家居控制中枢的智能音箱有着非同一般的重要性。但古往今来，利益有多大，风险就有多大。对于如钥匙般的智能音箱领域来说，发展面前有三问需解答。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	首先，智能音箱如何“智能”？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	每当市场有了新的风口，就会出现无数跟风之人，智能音箱也不例外。为搭上智能音箱的顺风车，传统音箱厂家推出不少产品，只不过卖点都集中于音质，本末倒置。 另外，“语音识别技术”也是尚未完善，一方水土一方人，同一语种还有不同口音，更别提各地方言以及语境涉及到的自然语言理解问题。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	除此之外，还有人工智能和物联网领域中老生常谈的安全隐患问题，如数据存储、身份认证、敏感数据保护等，在此不多赘述。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	其次，智能音箱如何提高普及率与使用率？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	我们知道，物联网时代“未来智能家居的控制核心”这一定位是智能音箱如此火热的重要原因之一。而理想的智能家居生态并非是家居单品的智能化，而是彼此联动，达到互联互通互控的状态，但目前的智能家居系统仍旧处于互相独立的状态，使得智能音箱使用率不高，如同“鸡肋”。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	与国内相比，国外在此方面就先进得多，以美国为例，美国的智能家居行业有统一的标准协议，亚马逊的Echo可以直接接入各种智能家居设备，这也是为何美国智能音箱普及率远高中国的原因。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	最后，国内企业如何“走出去”？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在用户习惯方面，国内外有着不小的差异。以使用环境为例，国外用户居家环境多为开放式，美国家庭主妇在烹饪时都喜欢听音乐，因此智能音箱在国外的消费需求也相对较高。而国内，厨房客厅封闭性更高，生活环境相对嘈杂，相应地市场对智能音箱需求较低。此为国外厂家难以进入中国市场的重要原因之一，另一限制则是人机交互的“本土化”程度低。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	以苹果HomePod为例，虽然其Siri语音助手对中文的支持已经有一定成果，但在交互、理解能力等方面，与本土选手阿里、百度相比仍是落后。并且，以BAT为代表的国内企业拥有更多本土资源，境外企业如苹果，很难在中国有突破性进展。同理，国内企业想要走出去也会遇到同样的难题。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	综上，智能音箱可谓是“腹背受敌”，而现阶段各巨头发展智能音箱的主要目的并不是盈利，而是抢占更多的用户家庭，为未来AI生态建设进行数据铺垫。那么，中小企业如何在这场战争中存活呢？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	双重风暴下，智能音箱可靠内容过冬\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	前文提过，国内有一类以喜马拉雅为代表的注重内容的智能音箱厂商，笔者认为现阶段此类厂商可能更好存活。现今用户对智能音箱的主要需求还处于“听”的情况下，智能音箱很大程度上是内容生态之争。在此基础上，喜马拉雅以自身丰富的内容为基础，推出智能音箱小雅，将更容易在家庭场景中突围。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	虽然从整体上看，喜马拉雅与BATJ等互联网巨头在技术和未来AI整体布局上存在相当大的弱势，但由于各种原因的限制，国内用户对智能音箱的需求在接下来很长一段时间里，都将处于“听”的阶段。并且，智能音箱核心技术“语音识别”，从本质上来说也是内容的一部分。从另一角度看，喜马拉雅的竞争对手也并非是BATJ等互联网巨头，其在智能音箱领域的发展更多的是为了扩充自身音频业务，巩固自身在在线音频市场的地位。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	同样的，在内容资源上有着强大优势的还有腾讯，毕竟现阶段消费者购买智能音箱的主要用途就是内容消费和智能家居两方面。在此基础上，腾讯可将自身音乐、阅读和视频整合，为智能音箱做内容支持。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	除了内容消费，“智能音箱+教育”的模式发展空间也十分广阔，尤其是早教领域。抛开说烂了的在线教育，光是国人对子女教育的重视程度，就足以让智能音箱注意到“早教”这一领域。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	单从目前智能音箱市场情况来看，短时间内C端消费市场的表现都比不过B端。因此，如何在B端站稳脚跟再最终反哺C端，是智能音箱发展过程中相当重要的一点。站在这个角度上看，“智能音箱+早教”的未来十分令人期待。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	毕竟，国内早教行业师存在资水平有限，地域发展不平衡，多数幼师仅经过短期培训就上岗从业，专业化程度低等问题。若是将智能音箱与早教结合，它所承载的大量专业、系统、科学的早教课程，能完美弥补传统绘本、书籍、视频等的缺点，再加上其操作简单、安全性高、不损伤视力的优点，能让智能音箱成为早教过程中不可或缺的工具。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	当然，除了以上两个方向，智能音箱作为人工智能音频端的入口，能够发展的B端场景是十分丰富的。就此，在C端市场来临前，国内非巨头企业在智能音箱领域也有了新的突破口。那有没\r\n</p>',	'doc.png',	1.00,	39,	0,	0,	0,	'2019-12-03 14:18:52',	'admin',	4,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	1.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	14,	1,	0,	1),
(35,	'十岁男孩不写作业老师告状 被父亲扔在火车站乞讨',	'<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	社交网络下一步发展的未来在何方？6日，Facebook创始人扎克伯格给出了自己的答案。在一篇长达3200字的公开博客文章中，这家全球最大的社交网络的掌门人称，未来Facebook将专注于营造一个更为私密和安全的网络社交环境。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“当我思考网络的未来，我认为专注于隐私的通讯平台相比今天的开放平台，将变得更加重要，”扎克伯格写道：“今天我们已经看到私密消息、短故事分享和小规模群组是在线通讯交流发展最快的领域。”\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	尽管扎克伯格认为，开放社交网络在未来仍有一席之地，但更大的机会在于“建立一个首先专注于隐私的更为简单的平台。”\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	扎克伯格称，在过去15年间，Facebook和Instagram帮助建立了一个“数字化的公开广场“，但人们开始迫切需要更为私密的”数字化的客厅空间“。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	对于Facebook来说，这将是一个具有里程碑意义的转型，成立15年来，Facebook成功打造了全球最大的公开社交网络，并在此基础上建立起一家以广告业务为主的商业帝国。但近年来，随着一系列与用户数据隐私泄漏相关的丑闻接连爆发，Facebook开放社交模式遭遇到前所未有的严峻挑战。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	正是由于内外部坏境发生的变化，促使Facebook开始思考接下来的转型方向，如今，这家全球最大的社交网络通过其掌门人的一封公开信给出了解答。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“我认为未来的通讯将更多地转向私密的、加密的服务，这样人们在与别人交流时，对于信息的安全新、内容不会停留会更有信心，”扎克伯格说，“这是我希望我们能够帮助带来的未来。”\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	为了达成这一目标，扎克伯格称，Facebook即时通讯平台将向Whatsapp的模式靠拢，未来端到端的加密服务将贯穿于Facebook所有旗下包含即时通讯的业务功能，该表态印证了此前外界流传的Facebook计划打通旗下即时通讯功能的传言。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	扎克伯格称，计划按照打造WhatsApp的模式进行：专注于最为基本和私密的应用场景即时消息开始，让其尽可能的安全，然后在此之上建立更多让人们能够互动的方式，包括打电话、视频聊天、群组、故事、商业、支付最终成为更多私人服务的平台。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	为了实现这一转型目标，扎克伯格列出了数项准则，包括加密、缩短内容的存续、安全、互通和安全数据存储。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“我相信我们应该朝着建立这样一个未来世界而努力：人们可以私下说话并且知道他们的信息只会让他们希望看到的人看到并且不会永远存续下去，“扎克伯格说，”如果我们能够帮助世界朝着这个方向发展，我将会为我们所做出的努力感到自豪。“\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	以下为扎克伯格公开博客全文：\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	注重隐私的社交网络愿景\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	过去几年，我的重点一直是理解和应对Facebook面临的最大挑战。这意味着对关系到互联网未来的重要问题采取什么立场。在本文中，我将概述Facebook围绕建立以隐私为中心的信息和社交网络平台的愿景和原则。有许多的事情要做，在开发的进程中，我们承诺开放式的工作，并将与全社会的专家进行协商……\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	过去15年间，Facebook和Instagram一直在帮助人们与友人、社区和等同于数字城市广场中的兴趣联系在一起。但是人们也越来越想私下在相当于起居室的数字环境中进行交流。当我思考互联网的未来时，我认为一个注重隐私的交流平台将变得比今天的开放平台更加重要。隐私让人们有自由做自己，更自然地联系，而这些是我们建立社交网络的原因。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	今天，我们看到私有信息、短暂的故事和小型群组已成为在线通讯中增长最快的领域。这有许多原因。许多人更喜欢一对一交流，或者只是与几位朋友交流。人们对分享有永久记录的内容更加谨慎。我们也都希望能够私下和安全地进行支付。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	公共社交网络将继续在人们的生活中发挥重要作用--与你认识的每一个人联系；发现新的人、想法和内容；让人们有更广泛的发言权。人们每天都会发现有价值的内容，而且还有很多有用的服务可以构建在它们之上。但是现在，人们也想通过各种方式私下交流，这也让我们有机会打造一个首先专注于隐私、更简单的平台。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	我明白很多人不认为Facebook有能力、或者甚至不想构建这种以隐私为中心的平台，因为坦率地讲，我们目前在构建隐私保护服务方面没有很好的声誉，而且我们一直专注于更开放的共享工具。但是我们已多次表明，我们可以通过进化来打造人们真正想要的服务，包括私有信息和故事。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	我认为，通信的未来将越来越多地转向私有、加密服务。在此类服务中，人们可以确信他们对彼此说的话是安全的，他们的信息和内容不会永远存在。这是我希望我们能帮助实现的未来。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	我们计划用开发WhatsApp的方式来构建这一平台：专注于最基本和私有用例--消息--尽可能确保它的安全性，然后构建更多的方式让人们在此基础上进行互动，包括通话、视频聊天、群聊、故事、商业、支付、商务，最终成为许多其他类型的私有服务的平台。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	这个注重隐私的平台将围绕以下几个原则构建：\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	·私下互动：人们应该拥有简单、亲密的场所，在那里可以清楚地控制谁可以和他们交流，并且相信没有人可以接触到他们分享的内容。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	·加密：人们的私人通信应该是安全的。端到端加密防止任何人，包括我们在内，看到人们分享在我们服务中的内容。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	·减少永久性：人们应该感到自在，不应担心他们分享的内容会反过来伤害自己。因此，我们不会将信息或故事保留超过提供服务所需的时间，也不会超过人们希望它们留存的时间。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	·安全：人们应该期待我们会尽一切努力，在加密服务可能的范围内，确保他们在使用我们服务时的安全。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	·互操作：人们应该能够使用我们的任何应用联系他们的朋友，应该能够轻松安全地通过网络交流。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	·安全数据存储：人们应该期待我们不会在隐私和言论自由等人权记录薄弱的国家存储敏感数据，保护数据被不当访问。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	未来几年中，我们计划围绕这些想法重建更多的服务。在此行程中，我们面临的决定将意味着对关系到互联网未来的重要问题采取什么立场。我们清楚有很多权衡需要纠正，我们承诺与专家进行协商，并讨论最佳的前进方向。这需要一些时间，但我们不会关着门朝着这个方向发展。我们将尽可能以公开、合作地态度这样做，因为其中许多问题影响到社会的不同层面。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	私下互动是基础\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	要让一项服务感觉具备私密性质，绝不让用户怀疑在和谁交流。我们努力在所有产品中建立隐私属性，包括公共分享产品。消息服务的一个重要特性是，即使用户的联系人列表在扩充，用户的个人线程和群组仍然是私有的。随着时间的推移，用户的好友会逐渐发展，消息服务会优雅地发展，并保持亲密。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	这与更广泛的社交网络不同。在社交网络中，人们可以积累好友或追随者，直至服务更加公开。这非常适合许多重要的用途--告诉用户所有的朋友一些事情，在重要的话题上传递用户的声音，寻找有相似兴趣的人群，追踪创作者和媒体，买卖东西，组织筹款人，发展业务，或者让用户认识的每一个人在相同的地方得到好处。尽管如此，当用户一起看到所有这些经历时，感觉更像是一个城镇广场，而不是一个更私密的空间，比如客厅。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	我们有机会建立一个关注人们想要私下交流的所有方式的平台。这种隐私和亲密感不仅仅是技术特征--它被深深地融入到服务的整体感觉中。举例来说，在WhatsApp当中，我们的团队专注于在产品的各个方面创造一个亲密的环境。即使我们构建了允许更广泛分享的功能，这仍然是一种不太公开的体验。当团队开发群组功能时，他们设定了规模限制，以确保每一次互动都是私密的。当我们在WhatsApp上发布故事时，我们限制了公共内容，因为我们担心这种做法可能会削弱隐私感--即使这并没有真正改变用户和谁分享。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	几年后，我预计未来版本的Messenger和WhatsApp将成为人们在Facebook网络上交流的主要方式。我们致力于让这两款应用更快、更简单、更私密、更安全，包括端对端加密。然后，我们计划增加更多与好友、团体和企业私下交流的方式。如果这种进化成功，通过Facebook网络与用户的好友和家人互动，将会从根本上成为一种更加私密的体验。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	加密与安全\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	人们期望他们的私人通信是安全的，并且只被收方看到，而不是黑客、罪犯、过度干预的政府，甚至是操作正在使用的服务的人。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	人们越来越多的意识到，更多的实体可以访问自己的数据，就越容易被人滥用或被网络攻击泄露。一些人也越来越担心，技术可能会将权力集中在政府和像我们这样的公司手中。一些人担心我们的服务可能会访问他们的信息，并将其用于广告或其他他们不期望的方式。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	端到端加密是开发注重隐私的社交网络的重要工具。加密正在分散--它限制了像我们这样的服务看到流经的内容，并使其他人更难访问用户信息。这就是为什么加密在我们的网上生活中越来越重要，从银行到医疗健康服务。这也是为什么我们在收购WhatsApp后把端到端加密植入WhatsApp中的原因。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	去年，我曾与持不同政见者交流过。他们告诉我，加密是他们自由甚至活着的原因。一些政府经常对数据提出非法要求，当我们在法庭上驳回这些要求时，我们总存在败诉的可能--如果信息没有加密，我们要么必须交出数据，要么不遵守法庭规定导致员工被逮捕。这看起来很极端，但是我们曾有过这样的案例，一名员工就因为不提供对某人私有信息的访问而身陷囹圄。事实上，我们也无法访问这类信息，因为它是加密的。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	与此同时，在我们能够在所有消息服务中部署端到端加密之前，我们需要解决真正的安全问题。加密是保护隐私的有力工具，但也包括做坏事的人的隐私。当数十亿人使用同一服务连接时，他们中的一些人会将它滥用于真正可怕的事情，比如剥削儿童、恐怖主义和敲诈勒索。我们有责任与执法部门合作，并尽所能帮助防止这些行为。我们正努力通过检测活动模式或其他方式，来提高识别和阻止应用中不良行为的能力，即使我们看不到消息的内容，我们将继续对这项工作进行投资。但是我们面临着一个内在的权衡，因为当我们的安全系统能够看到这些信息时，我们永远也不会发现我们今天所做的所有潜在伤害。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	找到保护隐私和安全的正确方法，是社会在历史上一直努力解决的问题。这里还有许多悬而未决的问题，我们将与安全专家、执法部门和政府协商实施安全措施的最佳方式。我们还需要与其他平台合作，以确保整个行业能做出正确的事情。我们越是能创造一种共同的方法越好。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	总的来说，我相信为所有私人通信实施端到端加密是正确的。人们通过信息和电话完成一些最敏感的私人谈话，在网络安全威胁日益增加、许多国家政府干预过度的情况下，人们希望我们采取额外措施来保护他们最私密的数据。对我而言这似乎是对的，只要我们花时间构建适当的安全系统，尽可能在加密服务的范围内阻止不良行为。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	我们已开始在WhatsApp的基础上开发这些安全系统，在全面实施端到端加密之前，我们将在2019年及以后与专家讨论这些系统。随着我们从专家那里学到更多的知识，我们将最终确定如何推出这些系统。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	减少永久性\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	我们越来越相信在短时间内保存信息非常重要。人们想知道他们分享的信息不会反过来伤害他们，减少他们信息的存储和访问时间会有所帮助。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“永久性问题”开发社交工具的一个挑战是。随着时间的推移，我们积累了大量的信息和照片，它们在成为资产的同时，也成为了一种负担。例如而言，许多Facebook的老用户可能会有年轻时候的照片，这可能会让人尴尬。但是人们也非常喜欢记录他们的生活。如果Facebook和Instagram上的所有帖子都消失了，人们将无法获得他人分享的大量宝贵知识和经验。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	我认为有机会为私有通信平台设定一个新的标准--内容会自动过期或随时间归档。除非用户存档，否则故事会在24小时后过期，这让人们更自然地分享。这种理念可以扩展到所有私人内容。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	举例来说，在默认情况下，信息可以在一个月或一年后删除。这将降低用户的信息再次出现并让他以后尴尬的风险。当然，如果用户愿意，可以自己改变时间框架或者关闭线程的自动删除。如果用户愿意，我们还可以为用户提供选项，让他将个人信息在几秒钟或几分钟后设置为过期。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	限制我们存储消息元数据的时间也有意义。我们使用这些数据来运行我们的垃圾信息和安全系统，但我们并不总是需要长时间保留这些数据。解决方案的一个重要部分是首先收集较少的个人数据，这也是WhatsApp从一开始就建立的方式。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	互操作\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	人们希望能够选择他们用来与人交流的服务。然而，今天如果用户想在Facebook上给人们发信息，你必须使用Messenger；在Instagram上必须使用Direct；在WhatsApp上必须使用WhatsApp。我们想给人们一个选择，这样他们可以通过这些网络从他们喜欢的任何一款应用联系他们的朋友。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	互操作性有隐私和安全优势。举例来说，许多人使用Android上的Messenger收发短信。这些文本不能进行端到端加密，因为短息协议没有加密。然而，有了跨我们服务传递信息的能力，用户就可以从Messenger向WhatsApp中的某人的电话号码发送加密短信。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	这还可以提高许多体验中的便利性。在这些体验中，人们使用Facebook或Instagram作为他们的社交网络，WhatsApp作为他们首选的消息服务。举例来说，许多在市场上出售商品的人会列出他们的电话号码，这样人们就可以发送与购物相关的信息。这并不理想，因为用户要给陌生人提供电话号码。有了互操作性，用户就可以使用WhatsApp接收发送到Facebook账户的信息，而无需分享电话号码--买家也不用担心卖家是喜欢在哪个网络发信息。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	可以想象许多类似这样的简单体验--一个人在Instagram上发现了一家公司，并很容易过渡到他们喜欢的消息应用，以获得安全的支付和客户支持；另一个人想追上一个朋友，可以向他们发送一条消息，发送到他们喜欢的应用，而不必考虑这个人喜欢在哪里被联系；或者用户只需在Facebook和Instagram上发布一天的故事，就可以在一个地方得到好友的所有回复。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	今天，用户已可以通过Android上的Messenger发送和接收短信，我们希望在未来进一步扩展这一功能，或许包括新的电信RCS标准。然而，在这成为可能之前，我们需要解决几个问题。首先，苹果不允许应用在他们的设备上与短信交互操作，所以我们只能在Android上这样做。其次，我们需要确保互操作性不会损害人们已使用WhatsApp的加密预期。最后，它会在加密系统中造成安全漏洞和垃圾邮件漏洞，让人们从未知的应用中发送信息，因为我们的安全和安保系统看不到这些活动的模式。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	这些都是重大挑战，有许多问题需要进一步协商和讨论。但是，如果我们能够实现这一点，我们就可以给人们更多的选择，让他们使用喜欢的服务，以安全地联系到他们想要联系的人。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	安全数据存储\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	人们想知道他们的数据安全地存储在他们信任的地方。展望互联网和隐私的未来，我认为我们将做出的最重要的决定之一是：在哪里建立数据中心和存储人们的敏感数据。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在一个国家提供服务和在那里存储人们的数据有着重要的区别。当我们在世界各地建设基础设施时，我们选择不在有侵犯隐私或言论自由等人权记录的国家建设数据中心。如果我们在这些国家建立数据中心并存储敏感数据，而不仅仅是缓存非敏感数据，这可能会让这些政府更容易获取人们的信息。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	坚持这一原则可能意味着我们的服务在一些国家会受阻，或者我们不能很快进入其他国家。这是我们愿意做出的折衷。我们不认为在一些国家存储人们的数据是一个足够安全的基础，可以在其上建立如此重要的互联网基础设施。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	当然，保护最敏感数据的最佳方法是根本不存储它，这就是WhatsApp不存储任何加密密钥的原因，我们计划在以后的其他服务中也这样做。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	但是在更多国家存储数据也开创了一个先例，鼓励其他国家政府寻求更大程度地获取其公民的数据，从而削弱了全世界人民的隐私和安全保护。我认为，对于互联网和隐私的未来而言，我们的行业继续坚决反对把人们的数据存储在得不到安全保障的地方，这一点很重要。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	下一步举措\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在接下来的一年及以后，我们还要制定出与这些原则相关的许多细节和权衡。这项工作中的许多仍处于早期阶段，我们致力于与世界各国的专家、倡导者、行业合作伙伴和政府(包括执法部门和监管机构)协商，以正确做出这些决定。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	与此同时，通过这些原则开展工作只是构建以隐私为中心的社交平台的第一步。除此以外，我们还需要对在此基础上构建的所有服务进行深入思考--从人们如何支付和金融交易，到企业和广告的作用，再到我们如何为其他私人服务提供平台。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	但是，这些最初的问题得到正确答案是至关重要的。如果我们做得好，我们可以创建私人共享平台，这对于人们而言可能比我们建立的帮助他们更公开分享和联系的平台更重要。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	这意味着对关系到互联网未来的重要问题采取什么立场。作为一个社会，我们有机会阐明我们的立场，决定我们如何重视私人通信，以及谁来决定数据应该存储多长时间以及存储在哪里。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	我认为我们应该努力实现这样一个世界，让人们可以私下交谈，自由生活，知道他们的信息只会被他们想看到的人看到，而且不会永远停留在身边。如果我们能帮助世界朝着这个方向发展，我将为我们所取得的成就感到自豪。\r\n	</p>',	'doc.png',	1.00,	35,	0,	0,	0,	'2019-12-03 14:19:38',	'admin',	1,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	1.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	13,	1,	0,	1),
(36,	'孟加拉为何买VT5 性能或比我军自用版15轻坦更先进',	'<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	今年两会期间，明星委员们的提案再次将炮火对准了劣迹艺人、明星及影视数据造假、身价片酬等行业乱象，不过前方固然慷慨激愤，后方还是其乐融融，#明星该不该吃粉丝送的食物#、#明星被认错#等话题频繁被推上热搜，娱乐氛围依旧。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	但今年还是有些许不同，2018年影视连续震荡所牵引出的政策新规，将在今年集中落地并被检验效果，前段时间，吴秀波、翟天临事件又掀起公众对娱乐圈造假的口诛笔伐。换句话说，娱乐产业规则改写的时机，可能已经同时具备了政策自上而下和舆论自下而上的两个必要条件。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	若是如此，数据造假将成第一个靶子，而往后推，数据造假的一环如果被铲除，是否能动摇当前畸形的粉丝经济呢？这是值得业界探讨的。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	造假产业链的逆向思考\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	2019年开年，《人民日报》发表文章，矛头直指流量明星锁场、刷榜、买粉丝，而后其又连续发表微博，感慨“明星流量数据节节攀升，8亿网民不够用”。随之跟进的还有《光明日报》《北京日报》，而“紫光阁”则从1月5日-9日，连发4条微博，痛批流量明星，呼吁“没有高质量作品做支撑，那些拙劣的表演终将被揭穿”。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	影视产业春寒料峭，一场“打假运动”的兴起，或许正是今年的新风向。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	微博已率先做出反应，宣布针对转发、评论计数显示方式在内做出种种调整，而更早之前，爱奇艺和优酷停止了播放量的展示。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	这对于影视数据脱水进而回归合理无疑是一个有利信号，视频及社交平台本身就是流量造星、粉丝运营的核心媒介，隐藏播放量起码减掉了数据造假的一个需求。虽然不得不承认，这一举措对整个行业来讲，也只是让数据造假不至于假得太“难看”，但其释放的市场信号是积极的：影视数据造假的乱象，今年或许不会止于揭露。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	以此为基础，我们再来看影视产业数据造假的产业链。一般来讲，卖方一端通过雇佣技术型或人工型水军，提供刷流量业务，至于买方一端，央视将明星数据造假的推手，归为自发组建的粉丝组织和经纪公司安排成立的明星微博数据站。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	两方需求契合，流量明星通过这一番操作获取一定的人气和地位，从而掠取演艺资源。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	而提供演艺资源的制片方、投资方以及媒体平台，又因流量明星的参与而收割商业利益，当然，这其中更少不了购买数据用以打榜、投票、转发的过程。无奈的是，这已成为市场优胜劣汰的“规则”，如果粉丝的偶像数据不好，就会被其他艺人的粉丝“唱衰”。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	由此可以看出，流量经济是一个参与方都可获得经济效益的模式，这也决定了很难从内部去戳破流量泡沫。但如今政策导向下，很有可能从外部强制性切断数据造假产业链，若是如此，会对以流量为基础的粉丝经济造成什么伤害？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	我们可以逆向推断，假使数据归真，流量明星及其所产出的内容，在市场的反应能够一目了然，首先最可能放弃他们的就是内容生产方。因为对比靠实力说话的演员，流量明星原本与之天差地别的流量优势，很大程度上被削弱了，而今口碑反噬又日渐严重，制片人也不再经得起多次的扑街。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	相应地，流量明星的演艺资源一旦被缩减，曝光度大大降低，广告商、媒体以及平台很快便“闻风而动”。更关键的是，明星本人新粉难增、旧粉流失，长此以往就更没有商业价值了。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	流量经济还是粉丝经济？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	当娱乐产业的优胜劣汰逐渐被流量所左右，如果从流量数据本身出发，一定程度上是可以约束某些行业乱象的滋生。但是流量缩减、粉丝仍在。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	蔡徐坤被央视点名时，震慑是对业内的，粉丝看似不惧。真爱粉们一面为爱豆打抱不平，力挺蔡徐坤确实是个专注音乐的好歌手，甚至表示之前做了那么多公益怎么不提？另一面又将攻击点集中到微博上，强烈要求整改。不过，前者是顾左右而言他，后面则是祸水东引，实则都没什么逻辑。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	从这件事直观地看，粉丝本身就是流量的一部分，即使最大程度地将流量数据脱水，蔡徐坤、鹿晗这类当前比较符合年轻群体审美的明星，也仍有不在少数的粉丝存留，他们才是饭圈的核心。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	换句话说，粉丝即使不花钱为他们的偶像刷流量，他们还是有其它方式向外界传达和证明自家爱豆的价值，甚至可以简单的说，只要粉丝愿意为爱豆花钱，在制片人和品牌方眼里，明星便有商业价值。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	这主要是因为当前的影视行业中，<strong>粉丝看似处于被收割的产业下游，实则主导着偶像的人气和商业吸引力。</strong> \r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\"> <strong>一方面，粉丝已经参与到偶像的职业规划中，用自己的力量为偶像争取好资源。</strong>而市场也认可了这种做法，现在广告商、制片方最看重的，不再是明星的业务水平，而是背后的粉丝力量。所以，纵然市场能抛开流量数据，演员和明星粉丝群体的差别，也无法使商业资源偏向前者。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\"> <strong>另一方面，如今流量明星的粉丝展现出强大而可怖的集体力量，如果不再允许数据造假，他们对舆论的影响也能帮助明星维持流量再造。</strong>极端一点，像粉丝骂战、撕逼这种普遍现象，一经推手，在当前这个碎片化时代便是天然的流量爆发点。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	所以，<strong>数据打假所能纠正的也只是流量经济，而触及不到更深层次的粉丝经济。</strong> \r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	时至今日，粉丝和流量的先后产生顺序已经模糊，这就是数据造假导致的，不过粉丝是基础，流量经济可以说是在资本介入、疯狂膜拜粉丝效应之后被放大的形态。这和移动互联网时代流量为王的思维，实则异曲同工。不过移动互联网进入下半场的服务升级，娱乐产业的流量经济反而日渐衰颓了。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	明星“死于”粉丝？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\"> <strong>围绕粉丝和明星的行业规则及利益链一旦形成，实际上就连一个环节的整治都很难，更不要指望其内部会自我改进。</strong>但值得庆幸的是，当前流量经济之所以逐渐露出真相，在于其外部的反对力量日益强大，也催促市场形成一套新的淘汰法则。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	最明显的是电影界，流量明星的多番试水，让投资方再也经不起折腾。2016年“小鲜肉+大IP”的模式备受追捧，2017年参与暑期档大战的流量明星只有杨洋、李易峰两人，而到2018年暑期档、春节档，杨洋、鹿晗等人早已不见踪影。李易峰的《动物世界》即使备受肯定，票房仍不能回本。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	数据显示，2018年全国电影票房已经超过2017年总票房559.11亿元，创下新纪录，但票房前十的影片主演中均不见小鲜肉身影。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	流量明星开始被排斥在大荧幕之外，而且他们在业内留下的印象一旦被定性，投资人只会对他们避之不及。而下一个排斥流量的便是观众，这很容易让流量明星丧失转型的时机，甚至是永久被划在攻击的范围之内。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	这是口碑反噬的副作用，比如《创业时代》开播之初，很多人还没看剧，只知道有杨颖主演便给出了一星评价，迪丽热巴则一个人把《声临其境》的评分拉到了4.3。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	一个经典角色可以成就一个明星，但一个明星也有可能毁了众多角色，观众便将不满全部发泄到流量明星身上，反而不会再客观考虑是不是剧本、导演不行。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	不过作品口碑败光的更多是路人缘，而且市场通过这种副作用反噬的方式淘汰流量明星，毕竟是一个相对缓慢的过程。关键是，他们背后的死忠粉依然是“东山再起”的资本。<strong>所以一个流量明星的消失或死亡，完全取决于粉丝。</strong> \r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	事实也是如此，我们看到，<strong>人设崩塌是最近常见的最快导致明星坠落的方式，而人设本质就是为迎合粉丝存在。</strong>粉丝心理假说认为，追星一种身份认同，粉丝通过对名人的“镜像”认识自己，塑造价值观，而一旦粉丝发现这种“镜像”是虚假的，认同感瞬间就消失了，而且会有上当受骗的感觉。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	当然，粉丝也是善变的，他们自然而然流失，流量明星们也就被市场抛弃了。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\"> <strong>流量数据的虚假泡沫被戳破总归是好的，但娱乐行业的乱象却无法根治，终究是粉丝把明星捧得太高了。</strong> \r\n	</p>',	'doc.png',	1.00,	16,	0,	0,	0,	'2019-12-03 14:20:16',	'admin',	3,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	1.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	10,	1,	0,	1),
(37,	'国足巴萨附体 1队踢大概率也输 姜至鹏大尺度飞踹',	'<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	你可能不知道咪蒙，但却一定知道她有一个月薪5万的助理。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	年初，在“寒门状元”事件之后，咪蒙就曾宣布关停微信公众号两个月，并永久关停微博。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	不想仅仅过了不到一个月，2月21日咪蒙以及旗下“才华有限青年”等微信账号就宣布将被永久关停。旗下美妆账号改名为“李粒粒LiLiLi”，咪蒙小号“好疼的咪蒙”则清空了所有内容。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	从咪蒙公布之前公布的报价来看，其微信公众号头条广告报价一度到达80万元，二条也有40万元。这次的账号注销还包括今日头条、凤凰号等等，并称咪蒙“不得转世”。咪蒙的商业帝国几乎被连根拔起。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	除了自媒体，同时可能就此终结的还有咪蒙刚刚开始的编剧生涯。2018年3月，柠萌影业曾经宣布，由咪蒙担任编剧的网剧《长大成人》正在筹备中。现在咪蒙被封，这部“神似”《欢乐颂》的作品最终何去何从也被画上了问号。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\"> <strong>“毒鸡汤女权”，这不只是咪蒙的专利</strong> \r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	正如我们上文所说，咪蒙还在积极谋求走向影视圈，成为编剧便是第一部。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	了解咪蒙的人都知道，咪蒙的文章一向以宣扬所谓“女权”为导向，用一碗一碗的鸡汤，挑动着公号中近600万女性粉丝的内心。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	作为一个影视的门外汉，咪蒙之所以开始进军影视当编剧，其实和中国影视，特别是网台剧当中 “大女主”等题材层出不穷有着直接关系。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	从《欢乐颂》里的五个姐妹，到《我的前半生》里的罗子君，从楚乔到关皮皮，不一而足。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	然而，在这些所谓的“大女主”或者“女权”剧却很少体现真正的女权，而或多或少的会体现出“咪蒙式女权”的感觉。 男一都会对我不离不弃，男二都会生死相依，男三都会“我的眼里只有你的桥段大行其道，靠男人上位的情节也充斥其中，女权成为了寄居在男权上的笑话。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	再有，许多职业剧也会加入大量爱情桥段，“谈判官”改谈恋爱，“猎头”改“猎对象”的情况也多次发生。这也正如咪蒙的风格，看似让人“自强不息”，实则只想让你成为“坐在宝马里笑的人”；看似是在不断激励，实际只是找准了观众的七寸，然后一颗颗的吃下早预备好的“致幻药丸”。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	但这样的剧情虽然满足了女性观众对于爱情内容的需要的同时，本身也局限了内容的发展。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	首先，这样的剧所有内容几乎都必须围绕爱情展开，亲情、职场、宫斗、武侠等本应该更重要的戏份反而成了陪衬。由此，很多所谓的职场剧、宫斗剧到头来都变成了无限尴尬的爱情剧。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	更重要的是，“咪蒙式的女权剧”并不是真正的男女平权，当女性意识进一步觉醒之后，就会开始逐渐摒弃这种价值观。正如《致橡树》中所说，“我如果爱你，绝不学攀援的凌霄花”。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	再次，随着90后以及更年轻观众的崛起，单身才是社会更加主流的形态。生活方式的改变也会影响大家对于影视剧的观看喜好。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	更进一步说，“大女主”实际上是披着女性思维的外衣，但实际上却站在男性立场的表现。女性是白莲花、傻白甜，需要靠男性，甚至众多男性实现目的，这其实是一种变向的“被包养”。托名女权，实际宣扬的却是一种并不合理的价值观。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	咪蒙已经悄然落幕，但“伪女权”却依然大量存在于影视剧之中。但随着品质口碑成为了市场主流，真正的女权影视剧登上舞台恐怕也不会太远了。\r\n</p>',	'doc.png',	1.00,	18,	0,	0,	0,	'2019-12-03 14:21:05',	'admin',	10,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	1.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	10,	1,	0,	1),
(38,	'振兴东北办原高官:东北地区政府干预市场力量过大',	'<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	短视频行业的发展无疑已经进入到了深水区，以短视频变现为代表的全新发展正在把这个行业越来越多地放到了市场的前台。作为一种全新的内容表现形式，短视频在经历了资本乱战、巨头追捧之后，或许应该进入这个“年纪”。然而，变现并非易事，短视频变现更是难上加难。如果能够走出短视频变现的考验的泥淖，这个行业的发展无疑将会发展成熟。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	当然，如果仅仅只是一味地追求变现，而不去深究短视频本身的内在运行逻辑。所谓的短视频变现同样会陷入困境，火爆的短视频行业将会如同火爆的流量一样陷入表面的繁华。的确，几乎所有的商业模式都应该形成一个生态闭环，才能称得上是一个成熟的商业模式。如果仅仅只是停留在某个阶段的繁荣，所谓的商业模式仅仅只是一个概念，无法真正落地。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	我们看到当前以抖音、快手为代表的短视频行业巨头都在进行变现层面的探索，无论是社交，还是电商，对于短视频背后更加深层次的商业层面的探索正在成为一种发展的主流。不可否认的是，尽管短视频变现进行得如火如荼，但是依然逃不脱现实的尴尬，短视频行业的变现依然面临诸多挑战。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	从繁荣期到精耕期，短视频行业正在经历阵痛\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	作为一种在移动互联网时代的后半段崛起的内容表现形式，短视频行业的发展无疑备受追捧。无论是资本还是巨头，对于这种新式的内容展现形式都充满了好奇与期待。融资数额的不断增加、融资速度的不断加快都在说明市场对于短视频行业偏好程度。尽管短视频行业从一开始就被互联网巨头所青睐，但是，它的发展依然要经历所有的事物都会经历的阶段。从资本吹捧的繁荣期到商业变现的精耕期，短视频行业的发展无疑正在经历一次全新的阵痛。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	火爆的背后是短视频行业远离商业本质的尴尬。几乎所有的人都知道，短视频行业的发展一直都是一路高歌，无论是从用户获取上，还是用户日常的表现数据上，短视频行业的发展都是相当夺目耀眼。尽管短视频行业看上去异常火爆，但是火爆的背后却是变现困难的尴尬。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	从始至终短视频行业都在扮演着一种流量导流的角色，通过短视频将流量聚集在一起，再通过流量下沉到电商、社群等其他领域，从而实现真正意义上的变现。其实，从流量获取到流量导入已经有了许多的用户流失，再把这些流量落地到具体产品上又会有更多的流量流失。因此，仅仅只是将短视频看成是一个流量导入的工具，而不去从短视频本身着手，直接进行变现正在让短视频行业的发展陷入一种尴尬的境地里。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	当我们看到短视频平台动辄几亿的用户流量的时候，其实无法真正掩盖现实的尴尬。一味地看中短视频本身的流量价值，而忽略了更多新的探索，短视频行业正在陷入一场远离商业本质的尴尬。在流量红利已经见顶的大背景下，一味地去强调短视频行业的流量作用，无疑是一次与现实的抵抗。在流量已经被证明是一种无效资源的大背景下，短视频行业盲目地加大自身在流量上的作用，无疑是一场冒险。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	依附于巨头的怀抱让短视频缺少对于商业世界的认知。作为一种全新的内容展现形式，短视频行业从一开始就依附于互联网巨头。无论是资本投资，还是平台建设上，短视频始终都缺少自己独特的运行模式。虽然以互联网巨头作为靠山能够缓解在竞争激烈的市场当中沦陷的概率，但是如果仅仅只是一味地停留在巨头怀抱的温暖里，不去面对商业世界的残酷，短视频行业依然备受挑战。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	依附于巨头的怀抱，短视频行业仅仅只是一个内容层面的东西，它仅仅只是巨头的附庸，无法真正承担起自我寻找商业价值的重任。当巨头不再加持短视频行业的时候，它同样需要走入市场里，而不是一味地承担一个支撑者的角色。依附于互联网巨头的怀抱，短视频行业仅仅只是停留在表面繁荣的自嗨当中，不断增长的用后数据、不断增长的点赞数量、不断增加的用户浏览时长都让短视频行业感觉到自己是移动互联网后半段的王者。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	作为一种全新的内容展示形式，短视频始终都是一种内容。如果我们仅仅只是停留在巨头光环下的数据自嗨，而不去真正了解这些数据背后的真正原因。那么，当短视频行业真正进入到市场的时候，一切或许都将重新开始。当前，短视频行业正在经历的正是这样一个阶段。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	以内容为根本的短视频却无法具备内容的本质与意义。虽然短视频行业异常火爆，但是我们始终都不能忘记短视频始终都是一种内容表现形式。既然是一种内容，短视频行业从野蛮生长到精耕细作是一个必然的过程。在经历了几年的发展之后，我们却没有看到短视频行业的内容有显著提升的地方，有的仅仅只是在一些营销层面的小打小闹。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	当短视频在内容进化上出现瓶颈的时候，我们就去做商业变现上的相关尝试无疑将会把这个行业的问题和弊端全部都呈现在外面。作为一种内容展现形式，短视频行业在内容本身上缺少精耕细作和突破创新，只会把短视频行业的发展带入到一种相对艰难的境地里。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	我们看到现在的短视频的内容上依然缺少精细化的痕迹，有的仅仅只是千篇一律的雷同抑或是内容展现形式的俗套。如果仅仅只是把短视频行业仅仅停留在一种毫无进化的层面上，特别了缺少了作为内容本身所应该具备的特质，那么所谓的短视频必然将会失去原有的本质与意义。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在经历了早期的野蛮生长、资本助推、巨头拥抱等一系列的发展之后，短视频行业的发展正在经历一场前所未有的平静期。这从另外一个角度说明短视频行业的发展并未真正跳出原有的发展套路，仅仅只是将互联网式的发展模式在极致上更进一步。突破短视频行业的发展困境，需要真正让短视频告别自嗨式的繁荣，真正回归内容本身，真正进入到商业世界的现实中历练。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	进入下半场的深水区，短视频的彷徨与退让\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在告别了资本的加持之后，短视频行业的发展正在进入到下半场的深水区。早期的顺风顺水让短视频行业的发展难以抵挡现实的尴尬，一味地停留在数字上的繁荣，而忽略了内容本身的本质奥义，短视频行业的下半场无疑将会经历一场前所未有的彷徨与退让。但是，这并非是一件坏事，通过这种方式，我们增加能够知道短视频本质的东西是什么。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	短视频的彷徨：巨头扶持还是独立行走。短视频从诞生的那一天开始就始终没有摆脱巨头的光环，从某种意义上来讲是互联网巨头最终造就了短视频行业的今天。然而，一味地躲在互联网巨头建构的舒适区里，不去进行商业层面上的探索，所谓的短视频只会在自嗨的道路上越走越远。告别巨头的保护，真正进入到市场当中摸爬滚打，从而获得更多的生存技能或许对于短视频来讲至关重要。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	然而，如果摆脱互联网巨头的怀抱，短视频又很难在短时间内找到一条合适的路，对于处于变现关键期的短视频行业来讲，无疑是一个非常巨大的挑战。始终蜷曲在巨头的怀抱，毕竟不是一件长远的事情，短视频行业的真正未来依然在于本身的发展上。从这个逻辑来看，脱离巨头的怀抱，选择独立行走显然是一件非常明智的事情。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	可喜的是，深度参与到短视频行业发展中的人们早已明白了这其中的意义，我们看到以抖音、快手为代表的短视频平台开始更多地寻找基于自身优势和特色的发展道路，抖音做社交，快手做电商就是这一趋势的直接体现。尽管当下的发展态势不甚明朗，但是只要能够找到一条真正适合自己的发展道路，短视频行业的发展便会真正能够独立。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	短视频的退让：坚守流量还是回归商业。从当下的发展情况来看，短视频真正吸引人的地方还是它裹挟流量的能力。投资机构和互联网巨头之所以不断加持短视频行业的重要一点同样是因为短视频本身能够在获取流量的成本日渐高企的时刻依然能够持续获得源源不断的流量。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	然而，虽然流量给短视频赢得了鲜花和掌声，但是流量的变现依然是横在短视频头上的达摩克利斯之剑。谈及流量变现就必然要回归到商业本身，如果仅仅只是在流量的海洋里进行无谓的自嗨，所谓的短视频只能是一个充满了美妙幻想的乌托邦，无法真正实现真正意义上的落地。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	是坚守流量还是回归商业，或许在残酷的商业面前，短视频行业将会最终退让，真正演变成为以商业为主导的存在。尽管这个过程会略显艰难，但是这才算是真正回归到了商业本身，而非仅仅只是沉醉在流量的理想国里。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	当短视频市场的繁华落尽，回归商业本质或许是当下正道。告别表面的虚假逻辑，真正把短视频行业的发展落地到具体的商业上，探索一条真正适合商业本质的发展道路，或许才是真正能够推动短视频行业发展正道所在。从这个逻辑上来看，当下短视频行业正在经历的这场彷徨与退让或许更像是在积蓄继续前行的能量。\r\n</p>',	'doc.png',	1.00,	37,	0,	0,	0,	'2019-12-03 14:21:49',	'admin',	14,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	1.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	13,	1,	0,	1),
(39,	'这座中国大桥合龙太震撼 外国网友看完吐槽本国',	'<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	发展会掩盖一切问题，直到狂奔的脚步停下。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	2月15日，滴滴CEO程维对外表示，公司将做好过冬准备，并将对非主业进行“关停并转”，对业务重组带来的岗位重叠和绩效不达标的员工进行减员，整体裁员比例占到全员的15%，将涉及2000人左右。此外，从2012年创业以来一直处于亏损状态的滴滴，2018年仍然亏损，全年亏损总额高达109亿元，其中，补贴司机超过113亿元。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在收购优步中国以后，滴滴在网约车市场一家独大，市场占有率近九成；滴滴是全球融资额最大的未上市公司，一向“不差钱”；滴滴对每笔业务都会收取20%左右的抽成(Take Rate)，这也经常成为网约车司机抱怨甚至炮轰的对象……感觉“躺着就能把钱赚了”的滴滴，为何会如此巨亏？司机喊着不赚钱、平台又巨亏，网约车的问题究竟出在哪里？还有能走得通的商业模式吗？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	成立7年，融资20次，\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	融资额200亿美元\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	和其他公司多是被爆出后被迫承认窘境，或者裁员时只肯使用“优化、调整、末位淘汰”等字眼不同，滴滴主动“官宣”了巨亏和裁员的消息，数字还如此巨大。“地主家也没有余粮了？”“富家子都开始哭穷了？”社交媒体上一时哗然，有人唏嘘，有人不解。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在去年8月滴滴顺风车事件之后，程维也曾对外透露过一次滴滴的财务数据，他表示滴滴成立6年来，还没有实现过盈利，仅仅2018年上半年，公司的整体净亏损就超过40亿元人民币。滴滴出行业务对应的GMV(总交易额)平均Take Rate(抽成率)约为16%，但绝大部分作为补贴和红包返还给了司机和乘客，公司整体对应的GMV毛利率只有1.6%。他还透露，仅2018年上半年，包括司机高峰期补贴、接单和服务奖励、乘客优惠等在内的总补贴返还金额超过117亿元人民币。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	2017年，滴滴也曾透露过补贴总额，高达181亿元(包括司机端和乘客端)。但一些被媒体广泛引用、滴滴官方从未确认也从未辟谣的数据显示，2017年滴滴全年亏损额只有25亿元。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	一位滴滴内部人士告诉《中国经济周刊》记者：“公司虽然巨亏，但现在现金流应该是没问题的。即使一部分员工会面临被裁员，但公司给的补偿方案还是比较厚道的。说滴滴会成为下一个ofo那是不太可能的。”\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	据天眼查的统计数据显示，滴滴自2012年成立以来，截至目前已经完成了20次融资，金额总量超过200亿美元，是全球融资额最大的未上市公司。滴滴的估值也一度高达800亿美金，也是最快达到这个量级的独角兽公司。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	但这只独角兽也甚是烧钱。由于滴滴还不是上市公司，财务数据并不需要全部公开，但根据滴滴已公开的数据统计，滴滴6年来累计亏损额高达近390亿元。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	但上述人士也表示：“在2018年以前，利润和成本在滴滴确实不是重要的考核指标，市场占有率、日单量、用户数量、司机数量……这些才是关注的重点。但2018年开始，公司希望能够在年底冲刺整体盈利，至少实现‘微盈利’，所以对各个业务线也都提出了这样的要求。”\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	其实，这种变化也并不奇怪，因为彼时市场传闻，滴滴将会在2019年下半年实现IPO。但之后由于众所周知的原因，滴滴没能赶上这波上市热潮。“顺风车事件”背后的安全问题让滴滴停下了6年来一路狂奔的脚步。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	一年补贴113亿元，\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	司机感受到了吗？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	补贴仿佛是成就滴滴、也榨干滴滴的一道旋转门，补贴的打法让滴滴熬死了几乎所有竞争对手，并从尸骨堆中走出来，成为今天的滴滴；但现在，补贴似乎也正在熬干滴滴自己。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	与109亿元这个2018年滴滴全年亏损总额一同出现的还有一个数据：2018年滴滴补贴司机超过113亿元，这很容易让人认为两个数字之间有因果关系。但巨额亏损就是源于对司机的补贴吗？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	北京大学市场与网络经济研究中心研究员陈永伟对《中国经济周刊》分析认为，滴滴的亏损应该主要来自为了赢得用户信任和适应更强监管而付出的合规成本。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	陈永伟认为，滴滴的持续亏损主要有两方面的原因。“一是由滴滴本身的战略决定的，它的战略是先占有市场，然后利用规模效应去消化市场。滴滴的主业务是规模报酬递增的，这也决定了滴滴先占市场的模式。二是去年突发事件引发了监管加强，这让滴滴遭受了空前的监管压力，合规成本是巨大的，比如要求司机户口、车辆的轴距大小等。”他说。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	记者采访了几位滴滴司机，他们均表示，并没有觉得去年滴滴对司机的补贴突然增加了。一位滴滴“老司机”告诉记者，不同的司机能够拿到的补贴数量可能差别非常大。因为要想获得比较高的补贴收入并不容易，比如要在线时间长，至少10小时，这意味一定要是全职司机，身体要好还不能怕辛苦；再比如要在高峰时段多接单，也要多接受滴滴的派单，“这些活儿很多是根本不赚钱的，不给补贴，根本不会有人接。”他说。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在乘客端，很多人的感受则是：滴滴的车费越来越贵，但叫车却越来越难。记者对比了市场上最大的几家网约车公司的价格，以北京为例，相同时段和目的地，同档次车型，滴滴快车价格最低，其次是出租车价格，但两者差距已经不大了，相对最高的是易到易达车型的价格。而对于高端车型，滴滴礼橙专车也是最低的，其次是神州专车，首汽约车的价格则更高一些。这些高端车型的价格要高出普通车型50%左右。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在客户竞争层面，网约车平台的竞争无外乎两件事：价格和能否叫到车。而网约车平台要克服的最大难题就是高峰低谷时段的需求差异和城市潮汐效应的供给矛盾。因此，从逻辑上，网约车平台确实需要依赖补贴来调节运力，鼓励高峰时段有更多兼职司机补充运力，鼓励司机反潮汐增加热门地区的运力供给。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	根据中国信息通信研究院政策与经济研究所的调查显示，截至2018年7月，全国合规网约车数量约为17万辆，只占到总量的0.54%，而合规司机数量约为34万，只能占到司机总量的1.1%。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	据滴滴方面介绍，随着各地网约车新政的落地和执行越来越严格，运力不足问题日趋严重。而顺风车下线之后，兼职的网约车司机也大量减少。因此，滴滴为了吸引更多“合规”司机加入，以及运营中调整运力，不断出手补贴。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	滴滴收购ofo的可能性更小了\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	除了裁员，滴滴宣布要“关停并转”非主业的消息也引发了广泛的关注。到底哪些业务是滴滴的“非主业”，截至记者发稿，滴滴官方并未给出回应。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	一位滴滴前高管对《中国经济周刊》分析，对于滴滴“非主业”，很多人会首先想到外卖、酒旅、票务等“创新业务”，这确实可能是此次调整的重点，但应该还至于此，因为这些业务不足以涉及到2000人。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	据记者了解，2018年底，滴滴进行过一次架构调整。调整后，滴滴的主要业务被划为几大板块：网约车平台公司(快车、专车、豪华车事业部)、车主服务公司(小桔车服公司、汽车资产管理中心)、普惠出行与服务事业群(单车、电单车、公交、代驾、企业级业务)、出租车事业部、战略业务事业部(战略部、国际事业部、金融事业部)等。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	上述高管认为，普惠出行与服务事业群的业务也有可能被重点调整，“滴滴再去收购ofo的可能性更小了”。而国际业务和金融业务则会影响不大。“网约车这个生意受政策环境影响太大了，国际化等于给滴滴多设立几个backup，这边不亮可以那边亮，滴滴已经有完整完善的网约车技术和运营解决方案，在各国复制并不难。”他说。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	实际上，滴滴已经通过收购、投资本地出行平台的方式将业务拓展到东南亚、东欧、非洲、巴西、日本、美国、墨西哥、澳大利亚……程维也透露，安全技术、产品和线下司机管理及国际化等是滴滴未来的重点领域。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	陈永伟的看法是，滴滴确实涉足了不少并没有规模效应的行业，如果没有顺风车危机，可能也不会对滴滴带来太大的影响。但在严监管之下，安全合规成本大增，滴滴的顺风车业务还干脆就没了，这也带来商业损失。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	网约车也有赢利的商业模式\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	滴滴这头其实已经达到巨头规模的超级独角兽，至今仍未找到清晰的盈利模式。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	滴滴的设想是希望通过平台聚集大量用户，然后靠打造“出行生态”提供增值服务获得盈利。就像淘宝和微信，用户都可以免费使用，但同样可以赚得盆满钵满。于是，滴滴进行了很多尝试：做广告、做电商、做游戏、卖保险、卖理财、做金融……但这条路，至少现在，滴滴还并没有走通。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	但这并没有影响新选手们的热情。除了神州优车、易到、首汽约车等老运动员，2018年以来，美团、高德、携程、同程、嘀嗒、哈罗等都开始前赴后继地加入网约车混战，希望从滴滴的版图上咬下一块。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	此外，上汽、吉利、大众等在内的主机厂都已经进军网约车市场，宝马也成为首家在中国拿到网约车牌照的跨国品牌，赛道那端虽然通向哪里还不知道，但赛道仍然拥挤。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	虽然滴滴的日子不好过，易到更是彻底凉了，但行业内也有日子过得不错的玩家。比如神州优车，虽然此前也一直亏损，但到2017年，神州优车的亏损已大幅收窄了92.7%，仅亏损2.6亿元。而其2018年经营，截止到当年前三季度，神州优车营收达49.2亿元，利润总额2.8亿元，较上年同期增长149%，已经实现了4个季度的持续盈利。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“这其实也说明了网约车本身没问题，是有商业模式可以走得通的。不过行业发展还是需要政策支持。”陈永伟表示\r\n</p>',	'doc.png',	1.00,	39,	0,	0,	0,	'2019-12-03 14:22:37',	'admin',	26,	1,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	1.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	14,	1,	0,	1),
(40,	'民主党公布两条“罪名” 能将特朗普弹劾下台吗',	'<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	对于当下环境以及未来发展，马云认为未来充满不确定性，企业家可能是世界上真正把握不确定性的群体，把不确定性变成确定性，很多人做企业是把机会做成灾难，灾难变成机会。真正看清楚，就不会悲观或者乐观，而是去寻找解决方案。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	抱怨和躲避解决不了问题，在危机关头，只有熬过挑战的企业，才有抗体。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	董事长郭广昌也认为今年的冬天有些不一样，他认为经济的确会很困难，这个冬天会非常冷。世界上要有一个救世主，就是市场，但在市场里，我们只能自救。企业家们现在必须要做的一件事，就是反省、是扪心自问：现在我们必须认真想想我们遇到的问题是什么？前五年我们又做了些什么？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	最后他相信中国的市场化程度一定会越来越高，民营企业的营商环境会越来越好。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\"> <strong>马云：熬过挑战的企业才有抗体</strong> \r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	今年，鲁冠球、冯根生、沈爱琴等老一辈浙商相继辞世。马云在演讲中表示，“过去一年，我们一直都在告别，告别了浙商当中开先锋之先，开天辟地的一些人物。在告别的时候我们在想，我们这一代浙商应该从他们身上继承些什么？是传说中浙商的8000亿资本吗？我想我们继承的不是资产，而是在继承和发扬浙商‘敢为天下先’、吃苦耐劳、创新奋斗的精神。”\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	他特别提到了当下的发展环境：\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“我们今天所遇到的困难其实和美国企业当年所经历的困难无法相比，和40年以前浙商面临的改革开放刚开始的困难环境无法相比，今天幸运得多。过去的40年，浙商是在中美合作的关系发展中起来的，<strong>未来的40年，我们浙商要在新型的中美关系中，在国内经济的转型升级当中，找到自己新的位置。</strong>这是挑战，也考验我们浙商的担当，也是浙商的自我升级迭代。这么多年来，浙商做得好，不仅是因为我们会吃苦，而是因为我们会学习，我们会应对变化。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	因为我们很清楚，只有变革才有我们的机会。任何变化，你把它当做灾难的时候，那就越来越不顺眼，当做机会的时候就越看越有意思。在危机关头，能够熬过困难，熬过挑战的企业才有抗体。总是抱怨自己没有遇上好的年代，这样的人永远不可能遇上更好的时代。”\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“经过这一轮的洗礼，能够活下来的企业，活下来的浙商，肯定已经不是过去的浙商，一定是未来的浙商。”马云说，浙商要超越商人，告别野蛮生长的市场，“<strong>今天社会进步，商人不能有钱就要干，而要有所为有所不为，要从商人走向企业家，以国家利益为重，以社会利益为重，以未来为重。</strong>相信大家一起相信未来，看见未来，拥有未来”，希望浙商要依靠家国情怀、责任感和价值取向而闻名世界。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在会上，谈到“风口论”时马云说，当一个还没有成立几天的小公司，就凭着几个故事、几个员工得到了几十亿美金的估值，什么都没有，还嫌少的时候，我们就进入了跨度期，要提前做准备；当一个企业拿自己公司80%的资产质押出去，拿钱去做与自己主业不一样的东西的时候，就要想到问题已经开始了。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	很少有企业能够越做越大、越做越好，因为很多人永远相信“赌博”，永远相信all in。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\"> <strong>郭广昌：这个冬天会非常冷，“过冬”要靠自己</strong> \r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在演讲中，郭广昌针对企业自身、企业创新、企业人才、企业发展四个方面，提了一些需要企业家们扪心自问的问题。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\"> <strong>以下为郭广昌演讲全文：</strong> \r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	今年是改革开放40周年。在过去40年里，我们浙商靠着“四千”精神，吃苦耐劳、不懈努力，应该说一直走得比较顺。前几年，虽然我们每年都说困难、“年年难过”，但实际上还是“年年过”。但这个冬天，我感觉有些不一样。尤其今年很多企业家朋友都出了问题，而且不是小企业，有些企业很不错，甚至是上百亿市值的上市公司。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	我就在想，到底怎么了？刚才陈龙教授也给大家详细说了外部环境的变化，那我们自己呢？这么多年来，我们一直说我们要改变自己，那我们改变了多少呢？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	所以我对现在经济的看法是：\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	第一，经济的确会很困难，这个冬天会非常冷。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	第二，世界上要有一个救世主，就是市场；而在市场里，能救你的只有你自己。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	所幸，党和国家已经很清楚的看到了这些问题和困难，也出台了一系列针对民营企业发展的政策和举措。所以，我判断未来的形势会好一些。但能否度过这个冬天，根本点还在于自己。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	作为我们自己，现在必须要做的一件事，是反省、是扪心自问。我觉得现在我们必须认真想想我们遇到的问题是什么？前五年我们又做了些什么？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	以下这四个问题，是这几年我自己一直在扪心自问的：\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	1、我们要扪心自问，我们到底花了多少时间在客户身上？花了多少时间在了解自己的产品上？花了多少时间在提升产品服务上？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	每个董事长，首先应该是自己公司的首席产品体验官。产品好不好，客户满意不满意？我们自己应该是最了解的。但这种了解绝不能依靠你的喜好和直觉，你需要花更多的时间跟客户去沟通。尤其产品销量不好，市场上又有很多竞争，你就特别需要更用心地体会产品。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	现在，我花时间最多的就是研究产品。经过这段时间的研究，我基本认为要造好产品，方法大致有两种：一种是做平台，但是能做成像阿里、腾讯这样大平台的企业毕竟是少数。第二就是花更多的时间去琢磨怎么做好产品。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	但如果做产品，我必须要强调一点：我们一定要做精品，一定要千锤百炼，一定要为客户创造价值。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	2、我们经常要扪心自问，我们花了多少钱在研发上？花了多少时间在学习新的业态上？花了多少时间去感受新的趋势和方向上？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	我相信，现在大家都很重视移动互联网。但我想问：我们的制造企业，有多少人真正懂得了移动互联网吗？移动互联网只是在淘宝上卖东西吗？马校长已经把阿里这家互联网企业做得这么好，但他还是会花大量的时间在研究线下商业、实体制造。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	所以说，我们千万不能因为取得了成绩，就不学习了。永远只有比别人学得更快，我们才能比别人走得更好、更远。现在客户的需求变化非常快，我们也进入了一个科技研发能快速转化为成果的时代。在这样的时代，技术的进步、产业的进步、市场逻辑的进步，逼着我们要不断学习。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	另一方面，一定要重视科技研发和创新。我们很多出问题的企业，虽然他们的公司已经很大，但总体感觉他们生产的大部分产品还是同质化、低科技的产品，而且他们以前一直是靠低毛利来不断扩大销量。但这个时代变化太快了，很可能你生产出来的不是产品，直接就是库存。所以，现在尤其要用科技创新来引领。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	3、我们要扪心自问，我们花了多少精力在组织升级和人才培养上？我们花了多少精力在引进高级人才上？花了多少精力在年轻人身上？我们有没有在90后、00后身上学到了什么？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	组织、人才，绝对是一家企业最核心的资产。因为所有的事都需要对的人去实现。而且根据市场的发展和变化，我们的组织需要不断升级，企业的人才要不断换仓。我们一定要吸收具备高能级、更在状态、更渴望成功的人。大家都有自己的团队，但我们花了多少精力在团队的升级上？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	我举个例子。复星的狼队这个赛季从英冠踢到了英超。但我突然发觉，英冠虽然踢得好，但是到英超以后，却碰到了很多的问题。为什么？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	因为英超要求我们球员的素质和英冠是不一样的。现在中国经济不管跟美国发生什么，都是一个比较长期且难以解决的问题。但不管怎么解决，中国经济已经在参与全球竞争了，客观上我们已经在踢“世界杯”了。这个时候，你的人才还是停留在原来的状态，不出问题不是很奇怪吗？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	4、最后，我们还要扪心自问：我们到底愿意不愿意慢下来，去做点慢的事情？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	改革开放40年，中国速度是大家津津乐道的，什么都发展得很快。这让我们已经习惯了快。比如我们看到马校长用十几年打造了一个世界级的巨无霸企业，大家都很想去复制他成功的路径。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	但全世界只有一个马云，谁都像他一样，这个世界还了得？所以你要知道，你自己该做什么，你有没有沉下心来做你该做的事？我们很多企业，我对他们做事的风格有一种感觉，就是All in，就是“赌”。这个“赌”不是说去赌场，而是说做企业很有“赌”性。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	之前的40年，因为整个市场在发展，一俊遮百丑，你很大概率赌成功了。但你千万不能把经济的大势当作你自己的能力，如果市场不好了，会怎么样？All in一下会很爽，但之后呢？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	我相信我们真的要沉下心，做对的事情，做难的事情，做需要时间积累的事情。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	当然，讲了这么多困难和问题之后，我还是对未来始终充满信心：\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	我坚定地相信，中国的市场化程度一定会越来越高，我们民营企业的营商环境会越来越好。包括我相信，不久的将来一定会减税，以降低企业的成本、激发企业活力。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	我坚定地相信，中国的企业家，尤其浙商，都非常能吃苦，只要我们真的加大创新，我们的未来会得到更多的发展。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	我坚定地相信，我们一定会融入全球。对于我们来说，尤其浙商，这是未来我们重要的方向。我们浙商不害怕去全球竞争，在越来越开放、越规范的市场，在全球化的融合中，全球浙商只会越来越好。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	这就像中国足球一样。中国足球要踢世界杯，只有让我们球员去全球踢球，才能得到真正的锻炼，而不只是在中超拿高工资。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	我坚定地相信，我们浙商有这份期望，我们浙商有这份能力，让我们一起努力。\r\n</p>',	'doc.png',	1.00,	21,	0,	0,	0,	'2019-12-26 09:37:40',	'admin',	71,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	1.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	4,	1,	0,	1),
(41,	'地球上为何会出现吸血生物？ 一只猫是如何欺负狗的',	'<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	2015年，随着抢眼的小黄车突现北大校园，共享单车的概念迅速被普及，玩家接连冒头，巨额投资不断涌入，和高铁、移动支付、网购齐名<strong>“新四大发明”</strong>。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	热潮来得快，去得更快。今年，共享单车就进入了寒冬。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	4月，<strong>摩拜单车委身美团；小黄车ofo也节节败退，危机重重</strong>：海外业务全面收缩，并推出了多种激进的变现手段：公众号推送广告，将用户的押金与理财产品绑定，一再延迟押金退还期限。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	去年还大把烧钱的共享单车，转眼就凉凉了。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	共享单车出海遇阻，基础建设和政策规范是难以忽略的两大阻力。除了中国，世界上很难找到一个足够大的市场来支撑共享单车的盈利模式。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	但印度的创业者似乎有不同想法。<strong>从2017年开始，有近十年共享单车公司陆续出现，并先后拿到融资。</strong> \r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	班加罗尔的Yulu向Blume Ventures等投资者筹得资金，还获得Flipkart联合创始人Binny Bansal和谷歌前副总裁Amit Singhal的支持；另一家公司Bounce从红杉印度等投资者那里拿到了了总计1520万美元的资金；总部位于古尔冈的Mobycy去年12月也筹集了50万美元的种子资金。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\"> <strong>印度的共享单车市场正生机勃勃。</strong> \r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\"> <strong>融资热潮</strong> \r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	Amit Gupta是印度第一家独角兽Inmobi的联合创始人。在他创业十年、担任总裁级别职务的时候，他选择了急流勇退，<strong>创办了另一家公司，Yulu单车</strong>。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在班加罗尔地铁站和商务CBD附近，亮蓝色的Yulu单车随处可见。Amit告诉\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	志象网\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	，做共享单车，是为了<strong>“间接降低污染”</strong>。他出生和长大在印度北部的小城坎普尔，在今年6月被世界卫生组织盖章“全球污染最严重城市”，谈起家乡，他显得情绪激动。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	Yulu单车在前半个小时仅收费10卢比<strong>（约一元）</strong>，之后每半小时多收5卢比。用户下载Yulu应用扫码开车，结束骑行之后，需要将车子停放在离目的地最近的停车区。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	业内人士估计，印度的共享单车市场目前规模达12亿美元。<strong>主要的玩家除了Yulu，还有共享汽车公司Zoomca旗下的Pedl，Mobycy，Bounce和以及来自中国的摩拜单车。</strong> \r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“这个行业很有前景并且有利可图，Ola和Uber的成功证明了交通出行跟手机有可能同步发展。”Blume Ventures的投资人Sajith Pai对志象网说。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	最近入局的玩家是<strong>从踏板车共享起家的Bounce</strong>。今年6月，ofo退出印度市场，Bounce最近宣布收购了它在印度的资产。在收购之前，Bounce在就班加罗尔投放了500辆踏板车。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“从公交站或地铁站到办公室和家里的最后一英里的交通非常令人头疼，没有任何三轮车或出租车愿意走这么短的距离。”Bounce联合创始人Vivekananda HR告诉志象网。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“我们从ofo手中收购的自行车也将加入试点。”他说，45到60天内Bounce的应用将支持扫码使用单车。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	印度创业者从中国公司继承的，不仅是败局留下的遗产，还有先见之明的运营管理教训。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在浦那和班加罗尔，小蓝车Yulu和小绿车Pedl随处可见。一开始，用户可以把车停在任何地方，甚至是在路中间，引起了交通失序。Yulu不得已派出团队去搬运自行车并停放在适当的地方。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	这样一来，成本太高难以为继，Yulu吸取了教训，开始联合Pedl与当地政府合作，规划指定的停车区域。在班加罗尔，这样的停车区现在有500个，在全部的4个城市总数超过1000个。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\"> <strong>纠结的用户体验</strong> \r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	但也有的问题无法靠“继承”来解决，<strong>比如技术和运营失误</strong>。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在印度，<strong>共享单车的用户体验仍有待改善</strong>。志象网记者的亲身体验以及和其他用户交流后发现，包括刹车失灵、智能锁失灵、轮胎漏气等现象并不少见，而且停车区的分布也不够密集，有时候用户甚至需要在锁车之后再走一公里到目的地。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	Vivek Kumar是一名22岁的软件工程师，他最近刚从德里搬到了班加罗尔。刚到班加罗尔时，他一直骑着共享单车穿梭在城市中参加面试。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	一次去面试的路上，他发现单车的链条断了，这就十分尴尬了：他必须得先把车子停到指定的停车区域，否则软件会一直计费。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“我不得不把车子推到500米外的Pedl停车站，在锁这个坏车的时候又花了好多时间。”Kumar告诉志象网。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	但事实上，Yulu和Pedl也都有专人在维护单车，每隔四天维护一次，从而保持单车的良好运行状态。但Amit说，当公司进入一个区域时，维护的情况会不太稳定，“因为当地业务还没有完全稳定。”\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“在那些旧的区域，你会发现我们的自行车状况良好，大多数都能够很好运行。最近我们在电子城附近布局，那里聚集了一批大型IT公司，比如Infosys、Wipro等。我们需要四到六周的时间来完成布局。”Amit说。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	但相较中国，<strong>印度的交通基础设施普遍落后，这也给共享单车埋了一颗暗雷</strong>。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在印度，没有几个城市设置了自行车道；不像中国，骑行已经发展为一种健康、前卫的生活方式，印度的自行车还往往被视为穷人的通勤方式。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“我们之所以进入共享单车行业，是因为我们想成为一家多渠道出行平台。城市交通一直是政府和公民共同面临的挑战，我们希望能够大规模地解决这一问题并帮助完善基础设施建设。”Pedl运营增长部门负责人Rakshak N说。\r\n	</p>',	'doc.png',	0.00,	2,	0,	0,	1,	'2019-11-26 09:37:47',	'admin',	119,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	0.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	3,	1,	0,	1),
(42,	'恶意诽谤公检法办案人员 黑龙江绥滨于淑丽被行拘',	'<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	互联网瞬息即变，互联网上的热点也是转变地相当的快，一个热点可能过了几天就不再有人关注了。这对于想凭借互联网走红的人或物来说，显然要付出更多的心血来维持热度。那么，各个引流渠道显然都在他们的考虑范围之内。对于商家而言，在互联网进行引流的最终目的不外乎都是卖货变现。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	因此，一些比较重要的引流渠道，都少不了商家们的身影；比如，。抖音作为2019年的平台，有着3.2亿日活跃用户，属于是自带。如今，抖音与微信、微博等巨大流量池并称，绝对是商家不容错过的流量池。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	商家在抖音平台上发布内容之后，就能通过发布内容来吸引用户前来关注，并进一步转化为粉丝，这样就能更方便商家引流变现。在抖音只能是通过发布优质内容来吸引用户关注，因为抖音采用的是智能社交推荐机制，只要发布的视频内容有趣，也可以获得大量的曝光。这就决定了粗制滥造的视频所获得的曝光量很少。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;text-align:center;\"=\"\"> <img src=\"http://demoall.adashuo.com/20090/uploads/allimg/c191107/15I0c2FD630-1E14.jpg\" width=\"450\" height=\"270\" border=\"0\" alt=\"抖音多闪培训：如何通过抖音进行带货-第1张图片-小七抖音培训\" title=\"抖音多闪培训：如何通过抖音进行带货-第1张图片-小七抖音培训\" style=\"height:270px;width:450px;\" /> \r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	因此，想要在抖音平台上获得大量的曝光，最简单的办法就是制作高质量的视频内容。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	拥有曝光，并不代表着是结束。恰恰相反，这只是开始，因为接下来的工作就是要引流变现了。目前，通过抖音引流的方式无非就只有这么几种：一是在视频内提及联系方式；二是在评论中回复；三是在私信回复等。但是，这几种引流方式都存在着被抖音删除、乃至封禁的风险。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	抖音多闪培训那么，到底有没有什么引流方式是没有风险的呢？或者换言之，有什么引流方式是抖音官方认可的呢？当然有!那就是抖音的电话拨打组件。这是抖音官方所推出的转化组件，经过设置就可以在抖音主页上展示，只要用户点击\"联系方式\"这个按钮就可以跳转至电话拨号界面，并显示相关号码，这无疑对商家引流变现提供了很大的便利。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	但比较遗憾的是，目前，这个功能并没有对所有的用户开放，只有认证了抖音企业蓝v号的用户才可以设置该功能。所以，商家如果是想开通\"电话拨打组件\"的功能，需要先开通抖音蓝v。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	抖音蓝v认证的申请流程如下：\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	第一，用需要认证蓝v的抖音账号登录抖音蓝v认证官网https://renzheng.douyin.com/。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	第二，填写企业认证公函，具体情况可以参考抖音官方的企业认证公函填写模板。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;text-align:center;\"=\"\"> <img src=\"http://demoall.adashuo.com/20090/uploads/allimg/c191107/15I0c2G0040-2J03.jpg\" width=\"450\" height=\"447\" border=\"0\" alt=\"抖音多闪培训：如何通过抖音进行带货-第2张图片-小七抖音培训\" title=\"抖音多闪培训：如何通过抖音进行带货-第2张图片-小七抖音培训\" style=\"height:447px;width:450px;\" /> \r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	第三，填写并提交认证资料，然后填写邀请码123456\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	第四，支付认证审核费用600元即可完成蓝v认证申请的提交。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	需要注意的是，抖音蓝v认证有部分禁入行业及需要额外提供认证资质证明的行业。禁入行业认证抖音蓝v将做认证失败处理。而需要额外提供认证资质证明的，如果碰巧没有，那么在提交认证申请后的30天内仍没有补充提交资质证明，也会当认证失败处理。而认证抖音蓝v失败，是不会进行退款的。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	认证抖音蓝v之后，除了可以获得电话拨打组件，还可以获得同步认证今日头条和、官网链接、商家页面、店铺POI地址、粉丝画像等蓝v权益。可以为天猫、淘宝、京东店铺以及线下店铺引流，构建企业商家的营销阵地，完成变现的目的。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;text-align:center;\"=\"\"> <img src=\"http://demoall.adashuo.com/20090/uploads/allimg/c191107/15I0c2G35440-31260.jpg\" width=\"450\" height=\"261\" border=\"0\" alt=\"抖音多闪培训：如何通过抖音进行带货-第3张图片-小七抖音培训\" title=\"抖音多闪培训：如何通过抖音进行带货-第3张图片-小七抖音培训\" style=\"height:261px;width:450px;\" /> \r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	抖音多闪培训因此，有意认证抖音蓝v的商家，最好是通过抖音蓝v认证代理商进行认证。\r\n</p>',	'doc.png',	0.00,	23,	0,	0,	0,	'2019-12-03 14:04:12',	'admin',	5,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	0.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	3,	1,	0,	1),
(43,	'安徽滁州:高层次人才购房最高可享100%政府补贴',	'<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	众所周知，2017年至2018年，的大和商业价值日益凸显，各大机构纷纷注资抢占短视频市场，作为短视频流量增速最快的APP，其运营模式和商业市场更是备受关注。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	大数据，帮你快速打造抖音爆款\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	抖音作为新媒体的新洼地，虽然流量又达到一个新的峰值，但是入场抖音仍然是可以。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	而想在抖音机制中脱颖而出，关注的焦点更倾向于生产抖音内容的速度和质量，以及如何持续生产高质量的抖音内容。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	对于运营抖音而言，此时入场抖音阵地，更需要把控时间成本和运营方法。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	结合抖音大数据工具——西瓜短视频助手，在内容层面，可以在6小时内寻找到抖音视频爆款素材，结合热门迅速掌握抖音平台爆款元素，从而有效提升抖音成本。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	在领域定位上，可以根据榜单快速规划的运营方向，结合行业粉丝画像信息，进一步完善垂直领域差异化内容布局。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	抖音进阶创作技巧，及商业运作模式\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;text-align:center;\"=\"\"> <img src=\"http://demoall.adashuo.com/20090/uploads/allimg/c191107/15I0c2AcO0-53929.jpg\" width=\"450\" height=\"303\" border=\"0\" alt=\"抖音小店：抖音运营怎么进行流量变现-第1张图片-小七抖音培训\" title=\"抖音小店：抖音运营怎么进行流量变现-第1张图片-小七抖音培训\" style=\"height:303px;width:450px;\" /> \r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	根据对MCN机构平台发展中遇到各种情况，给现场的运营者和MCN机构提出以下3个方面建议：\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	1.稳扎稳打才是抖音号的运营之道\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	面对网络上出现的买粉刷量的现象，建议运营者和机构千万不要尝试。这样的行为，不仅影响抖音号的权重，也让后续陷入无效价值中。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	2.快速孵化KOL矩阵离不开内容运营\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	抖音小店面对快速内容运营的有效方法，也给出一些信息流量的操作模式，在信息的展示上，可以扩大挖掘地域，可以引入外国小众优质的平台信息资源，将优质内容分类整理成“剧本”分发旗下艺人进行高效运作，提升视频输出效率。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	3.强强合作是商业运作成型的有效方法\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	相比知识付费，广告和电商是抖音目前最有效的转化之一。在广告投放上，同MCN专业机构合作，会更有效的提升个人抖音号的商业价值转化能力。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	如何高格局快速转战短视频领域构建生态链\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	如何一手打造“从内容生产-IP孵化-推广产业化”短视频生态蓝图？\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;text-align:center;\"=\"\"> <img src=\"http://demoall.adashuo.com/20090/uploads/allimg/c191107/15I0c2B323F-B363.jpg\" width=\"450\" height=\"307\" border=\"0\" alt=\"抖音小店：抖音运营怎么进行流量变现-第2张图片-小七抖音培训\" title=\"抖音小店：抖音运营怎么进行流量变现-第2张图片-小七抖音培训\" style=\"height:307px;width:450px;\" /> \r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	a.建立完善的孵化流程。在常规签约流程上，增加达人定位分析和视频测试环节（颜值/技能/学习），保障达人较高的素质水平。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	b.专注用户市场资源。在媒体领域商业形式取决于上游形态，运营的方向取决于市场用户的需求，只有想明白定位，才能做清楚你的市场。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	c.专业商业变现评估。需要对行业的天花板有一定认知，对不具有的抖音大号，可以根据粉丝画像的年龄层，选择不同的市场的推广模式。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	最后，规范机构的商业合作模式，才能快速有效构建自己的商业帝国。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	网红大咖粉丝运营之道\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	抖音IP的成长过程3个关键点：\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	1、找准平台：分析各个平台的商业价值和受众群体，有效预估平台的价值的上升空间。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;text-align:center;\"=\"\"> <img src=\"http://demoall.adashuo.com/20090/uploads/allimg/c191107/15I0c2BC510-L234.jpg\" width=\"450\" height=\"303\" border=\"0\" alt=\"抖音小店：抖音运营怎么进行流量变现-第3张图片-小七抖音培训\" title=\"抖音小店：抖音运营怎么进行流量变现-第3张图片-小七抖音培训\" style=\"height:303px;width:450px;\" /> \r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	2.优质内容：视频种类，视频的风格，人设的塑造，再到更高层次基调定位，都是优质内容的保障。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	3.抓准用户心理：内容的输出上需要抓取社会的认同感，有共鸣的内容通常都可以引发用户的依赖性，可以在内容上找到归属感。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	抖音小店其次，需要制造亲切感，打造个舒服是场景内容更容易获取用户关注。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	最后，就是从心理学的角度出发，恰到好处运粉丝的独纵心理和占便宜的心态。\r\n	</p>',	'doc.png',	1.00,	41,	0,	0,	0,	'2019-12-03 14:07:30',	'admin',	3,	5,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	1.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	14,	1,	0,	1),
(44,	'两名中国公民在怀特岛火山喷发中受伤 谁应负责',	'<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	对于当下环境以及未来发展，马云认为未来充满不确定性，企业家可能是世界上真正把握不确定性的群体，把不确定性变成确定性，很多人做企业是把机会做成灾难，灾难变成机会。真正看清楚，就不会悲观或者乐观，而是去寻找解决方案。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	抱怨和躲避解决不了问题，在危机关头，只有熬过挑战的企业，才有抗体。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	董事长郭广昌也认为今年的冬天有些不一样，他认为经济的确会很困难，这个冬天会非常冷。世界上要有一个救世主，就是市场，但在市场里，我们只能自救。企业家们现在必须要做的一件事，就是反省、是扪心自问：现在我们必须认真想想我们遇到的问题是什么？前五年我们又做了些什么？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	最后他相信中国的市场化程度一定会越来越高，民营企业的营商环境会越来越好。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\"> <strong>马云：熬过挑战的企业才有抗体</strong> \r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	今年，鲁冠球、冯根生、沈爱琴等老一辈浙商相继辞世。马云在演讲中表示，“过去一年，我们一直都在告别，告别了浙商当中开先锋之先，开天辟地的一些人物。在告别的时候我们在想，我们这一代浙商应该从他们身上继承些什么？是传说中浙商的8000亿资本吗？我想我们继承的不是资产，而是在继承和发扬浙商‘敢为天下先’、吃苦耐劳、创新奋斗的精神。”\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	他特别提到了当下的发展环境：\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“我们今天所遇到的困难其实和美国企业当年所经历的困难无法相比，和40年以前浙商面临的改革开放刚开始的困难环境无法相比，今天幸运得多。过去的40年，浙商是在中美合作的关系发展中起来的，<strong>未来的40年，我们浙商要在新型的中美关系中，在国内经济的转型升级当中，找到自己新的位置。</strong>这是挑战，也考验我们浙商的担当，也是浙商的自我升级迭代。这么多年来，浙商做得好，不仅是因为我们会吃苦，而是因为我们会学习，我们会应对变化。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	因为我们很清楚，只有变革才有我们的机会。任何变化，你把它当做灾难的时候，那就越来越不顺眼，当做机会的时候就越看越有意思。在危机关头，能够熬过困难，熬过挑战的企业才有抗体。总是抱怨自己没有遇上好的年代，这样的人永远不可能遇上更好的时代。”\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“经过这一轮的洗礼，能够活下来的企业，活下来的浙商，肯定已经不是过去的浙商，一定是未来的浙商。”马云说，浙商要超越商人，告别野蛮生长的市场，“<strong>今天社会进步，商人不能有钱就要干，而要有所为有所不为，要从商人走向企业家，以国家利益为重，以社会利益为重，以未来为重。</strong>相信大家一起相信未来，看见未来，拥有未来”，希望浙商要依靠家国情怀、责任感和价值取向而闻名世界。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在会上，谈到“风口论”时马云说，当一个还没有成立几天的小公司，就凭着几个故事、几个员工得到了几十亿美金的估值，什么都没有，还嫌少的时候，我们就进入了跨度期，要提前做准备；当一个企业拿自己公司80%的资产质押出去，拿钱去做与自己主业不一样的东西的时候，就要想到问题已经开始了。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	很少有企业能够越做越大、越做越好，因为很多人永远相信“赌博”，永远相信all in。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\"> <strong>郭广昌：这个冬天会非常冷，“过冬”要靠自己</strong> \r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在演讲中，郭广昌针对企业自身、企业创新、企业人才、企业发展四个方面，提了一些需要企业家们扪心自问的问题。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\"> <strong>以下为郭广昌演讲全文：</strong> \r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	今年是改革开放40周年。在过去40年里，我们浙商靠着“四千”精神，吃苦耐劳、不懈努力，应该说一直走得比较顺。前几年，虽然我们每年都说困难、“年年难过”，但实际上还是“年年过”。但这个冬天，我感觉有些不一样。尤其今年很多企业家朋友都出了问题，而且不是小企业，有些企业很不错，甚至是上百亿市值的上市公司。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	我就在想，到底怎么了？刚才陈龙教授也给大家详细说了外部环境的变化，那我们自己呢？这么多年来，我们一直说我们要改变自己，那我们改变了多少呢？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	所以我对现在经济的看法是：\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	第一，经济的确会很困难，这个冬天会非常冷。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	第二，世界上要有一个救世主，就是市场；而在市场里，能救你的只有你自己。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	所幸，党和国家已经很清楚的看到了这些问题和困难，也出台了一系列针对民营企业发展的政策和举措。所以，我判断未来的形势会好一些。但能否度过这个冬天，根本点还在于自己。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	作为我们自己，现在必须要做的一件事，是反省、是扪心自问。我觉得现在我们必须认真想想我们遇到的问题是什么？前五年我们又做了些什么？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	以下这四个问题，是这几年我自己一直在扪心自问的：\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	1、我们要扪心自问，我们到底花了多少时间在客户身上？花了多少时间在了解自己的产品上？花了多少时间在提升产品服务上？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	每个董事长，首先应该是自己公司的首席产品体验官。产品好不好，客户满意不满意？我们自己应该是最了解的。但这种了解绝不能依靠你的喜好和直觉，你需要花更多的时间跟客户去沟通。尤其产品销量不好，市场上又有很多竞争，你就特别需要更用心地体会产品。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	现在，我花时间最多的就是研究产品。经过这段时间的研究，我基本认为要造好产品，方法大致有两种：一种是做平台，但是能做成像阿里、腾讯这样大平台的企业毕竟是少数。第二就是花更多的时间去琢磨怎么做好产品。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	但如果做产品，我必须要强调一点：我们一定要做精品，一定要千锤百炼，一定要为客户创造价值。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	2、我们经常要扪心自问，我们花了多少钱在研发上？花了多少时间在学习新的业态上？花了多少时间去感受新的趋势和方向上？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	我相信，现在大家都很重视移动互联网。但我想问：我们的制造企业，有多少人真正懂得了移动互联网吗？移动互联网只是在淘宝上卖东西吗？马校长已经把阿里这家互联网企业做得这么好，但他还是会花大量的时间在研究线下商业、实体制造。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	所以说，我们千万不能因为取得了成绩，就不学习了。永远只有比别人学得更快，我们才能比别人走得更好、更远。现在客户的需求变化非常快，我们也进入了一个科技研发能快速转化为成果的时代。在这样的时代，技术的进步、产业的进步、市场逻辑的进步，逼着我们要不断学习。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	另一方面，一定要重视科技研发和创新。我们很多出问题的企业，虽然他们的公司已经很大，但总体感觉他们生产的大部分产品还是同质化、低科技的产品，而且他们以前一直是靠低毛利来不断扩大销量。但这个时代变化太快了，很可能你生产出来的不是产品，直接就是库存。所以，现在尤其要用科技创新来引领。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	3、我们要扪心自问，我们花了多少精力在组织升级和人才培养上？我们花了多少精力在引进高级人才上？花了多少精力在年轻人身上？我们有没有在90后、00后身上学到了什么？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	组织、人才，绝对是一家企业最核心的资产。因为所有的事都需要对的人去实现。而且根据市场的发展和变化，我们的组织需要不断升级，企业的人才要不断换仓。我们一定要吸收具备高能级、更在状态、更渴望成功的人。大家都有自己的团队，但我们花了多少精力在团队的升级上？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	我举个例子。复星的狼队这个赛季从英冠踢到了英超。但我突然发觉，英冠虽然踢得好，但是到英超以后，却碰到了很多的问题。为什么？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	因为英超要求我们球员的素质和英冠是不一样的。现在中国经济不管跟美国发生什么，都是一个比较长期且难以解决的问题。但不管怎么解决，中国经济已经在参与全球竞争了，客观上我们已经在踢“世界杯”了。这个时候，你的人才还是停留在原来的状态，不出问题不是很奇怪吗？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	4、最后，我们还要扪心自问：我们到底愿意不愿意慢下来，去做点慢的事情？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	改革开放40年，中国速度是大家津津乐道的，什么都发展得很快。这让我们已经习惯了快。比如我们看到马校长用十几年打造了一个世界级的巨无霸企业，大家都很想去复制他成功的路径。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	但全世界只有一个马云，谁都像他一样，这个世界还了得？所以你要知道，你自己该做什么，你有没有沉下心来做你该做的事？我们很多企业，我对他们做事的风格有一种感觉，就是All in，就是“赌”。这个“赌”不是说去赌场，而是说做企业很有“赌”性。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	之前的40年，因为整个市场在发展，一俊遮百丑，你很大概率赌成功了。但你千万不能把经济的大势当作你自己的能力，如果市场不好了，会怎么样？All in一下会很爽，但之后呢？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	我相信我们真的要沉下心，做对的事情，做难的事情，做需要时间积累的事情。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	当然，讲了这么多困难和问题之后，我还是对未来始终充满信心：\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	我坚定地相信，中国的市场化程度一定会越来越高，我们民营企业的营商环境会越来越好。包括我相信，不久的将来一定会减税，以降低企业的成本、激发企业活力。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	我坚定地相信，中国的企业家，尤其浙商，都非常能吃苦，只要我们真的加大创新，我们的未来会得到更多的发展。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	我坚定地相信，我们一定会融入全球。对于我们来说，尤其浙商，这是未来我们重要的方向。我们浙商不害怕去全球竞争，在越来越开放、越规范的市场，在全球化的融合中，全球浙商只会越来越好。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	这就像中国足球一样。中国足球要踢世界杯，只有让我们球员去全球踢球，才能得到真正的锻炼，而不只是在中超拿高工资。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	我坚定地相信，我们浙商有这份期望，我们浙商有这份能力，让我们一起努力。\r\n</p>',	'doc.png',	1.00,	20,	0,	0,	0,	'2019-12-26 09:37:40',	'admin',	72,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	1.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	4,	1,	0,	1),
(45,	'12月28日相约北京 共话产业发展“黄金十年”',	'<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	带火了很多“爆款”产品，这些品牌和产品的销量大增，引得很多企业和品牌方们分外眼红。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	在这个为王的时代，早已成为了一个所有新媒体人无法避开的平台。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	抖音火遍大江南北，同时有无限的流量产生。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	大家撸粉的撸粉，变现的变现。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	但是现在越来越难了，\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;text-align:center;\"=\"\"> <img src=\"http://demoall.adashuo.com/20090/uploads/allimg/c191107/15I0c26340L0-1F53.jpg\" width=\"450\" height=\"198\" border=\"0\" alt=\"抖音运营团队：抖音运营思维攻略-第1张图片-小七抖音培训\" title=\"抖音运营团队：抖音运营思维攻略-第1张图片-小七抖音培训\" style=\"height:198px;width:450px;\" /> \r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	为什么？\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	竞争大呗！\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	团队拿到更好的权重才能有更多的曝光，才有上的机会。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	怎么拿到更多的曝光权重呢？\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	俗话说：知己知彼，百战不殆！\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	那我就先来了解一下抖音的排名算法是什么？\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	首先你要输出优质的内容，\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;text-align:center;\"=\"\"> <img src=\"http://demoall.adashuo.com/20090/uploads/allimg/c191107/15I0c263G60-26058.jpg\" width=\"450\" height=\"195\" border=\"0\" alt=\"抖音运营团队：抖音运营思维攻略-第2张图片-小七抖音培训\" title=\"抖音运营团队：抖音运营思维攻略-第2张图片-小七抖音培训\" style=\"height:195px;width:450px;\" /> \r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	关于内容今天就不讲了，本期讲的是抖音运营思维攻略。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	一、熟悉抖音\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	抖音运营团队熟悉抖音账号注册、认证、定位、布局、防封号/、最受欢迎内容等。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;text-align:center;\"=\"\"> <img src=\"http://demoall.adashuo.com/20090/uploads/allimg/c191107/15I0c26406150-31H2.jpg\" width=\"450\" height=\"266\" border=\"0\" alt=\"抖音运营团队：抖音运营思维攻略-第3张图片-小七抖音培训\" title=\"抖音运营团队：抖音运营思维攻略-第3张图片-小七抖音培训\" style=\"height:266px;width:450px;\" /> \r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	二、选题\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	1.选题的原则：关联性、热门性、新鲜感、人设感\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	2.选题来源：可从时事、同行火爆视频分析、段子、微博等渠道入手\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	3.拍摄及剧本套路\r\n</p>',	'doc.png',	1.00,	24,	0,	0,	0,	'2019-12-03 14:08:06',	'admin',	10,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	1.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	10,	1,	0,	1),
(46,	'四名高中生因在寝室吃泡面被开除？教育局回应',	'<p style=\"color:#333333;font-family:&quot;font-size:16px;background-color:#FFFFFF;\">\r\n	怎么在做？ &nbsp;借助商品橱窗和购物车，电商新物种——抖商蓬勃发展，但作为以算法推荐分发的平台，抖音缺少社交基因，那么抖音就注定与社交电商无缘吗？ &nbsp;\r\n</p>\r\n<p style=\"color:#333333;font-family:&quot;font-size:16px;background-color:#FFFFFF;\">\r\n	社交对电商有何价值？ &nbsp;\r\n</p>\r\n<p style=\"color:#333333;font-family:&quot;font-size:16px;background-color:#FFFFFF;\">\r\n	社交电商是相对于传统电商的概念——社交本身自带去中心化属性，由此延伸出来两个特征：裂变与私域流量。 &nbsp;\r\n</p>\r\n<p style=\"color:#333333;font-family:&quot;font-size:16px;background-color:#FFFFFF;\">\r\n	裂变来源于社交背后的人脉关系，不仅转化率远高于传统电商，更是能基于信任进行快速传播，也就是裂变获客； &nbsp;\r\n</p>\r\n<p style=\"color:#333333;font-family:&quot;font-size:16px;background-color:#FFFFFF;\">\r\n	而私域流量于商家不仅意味着跳出平台限制自主营销获客，私域流量还具有免费、优质、高黏性、可重复转化的属性。\r\n</p>\r\n<p style=\"color:#333333;font-family:&quot;font-size:16px;background-color:#FFFFFF;text-align:center;\">\r\n	<img src=\"http://demoall.adashuo.com/20090/uploads/allimg/c191107/15I0c25W3510-551O.png\" width=\"450\" height=\"328\" border=\"0\" alt=\"抖商研习社：如何在抖音做社交电商？-第1张图片-小七抖音培训\" title=\"抖商研习社：如何在抖音做社交电商？-第1张图片-小七抖音培训\" style=\"height:328px;width:450px;\" />&nbsp;&nbsp;\r\n</p>\r\n<p style=\"color:#333333;font-family:&quot;font-size:16px;background-color:#FFFFFF;\">\r\n	抖音也能做社交电商吗？ &nbsp;\r\n</p>\r\n<p style=\"color:#333333;font-family:&quot;font-size:16px;background-color:#FFFFFF;\">\r\n	1、社交土壤 &nbsp;\r\n</p>\r\n<p style=\"color:#333333;font-family:&quot;font-size:16px;background-color:#FFFFFF;\">\r\n	抖商研习社需要指出的是，抖音虽然并非社交产品，但有人的地方就有社交——抖音好友与好友间、粉丝与红人间都有着浓厚的社交氛围，只不过抖音是以陌生人关系链组成的社交平台。 &nbsp;\r\n</p>\r\n<p style=\"color:#333333;font-family:&quot;font-size:16px;background-color:#FFFFFF;\">\r\n	同时抖音庞大且优质的用户群——以18-28年龄为主，多分布于一二线城市，且女性占比超过60%——配合内容的高传达效率，使得社交裂变有了肥沃的用户土壤。 &nbsp;\r\n</p>\r\n<p style=\"color:#333333;font-family:&quot;font-size:16px;background-color:#FFFFFF;\">\r\n	2、裂变载体 &nbsp;\r\n</p>\r\n<p style=\"color:#333333;font-family:&quot;font-size:16px;background-color:#FFFFFF;\">\r\n	裂变的前提是有足够的用户基础——背靠抖音数亿活跃用户池，好的视频依托推荐算法，及话题、热榜、群聊等流量分发入口，能迅速成为爆款，进而触达更多潜在用户。 &nbsp;\r\n</p>\r\n<p style=\"color:#333333;font-family:&quot;font-size:16px;background-color:#FFFFFF;\">\r\n	裂变的关键在二次分享，而商品橱窗与购物车并没有相匹配的能力，这就需要借助抖音小程序了：除了可以驱动用户“”挂载小程序二次传播外，小程序的营销插件也自带裂变能力，进而打通裂变的闭环。 &nbsp;\r\n</p>\r\n<p style=\"color:#333333;font-family:&quot;font-size:16px;background-color:#FFFFFF;\">\r\n	怎么裂变起来？ &nbsp;\r\n</p>\r\n<p style=\"color:#333333;font-family:&quot;font-size:16px;background-color:#FFFFFF;text-align:center;\">\r\n	<img src=\"http://demoall.adashuo.com/20090/uploads/allimg/c191107/15I0c2593MP-E412.png\" width=\"450\" height=\"331\" border=\"0\" alt=\"抖商研习社：如何在抖音做社交电商？-第2张图片-小七抖音培训\" title=\"抖商研习社：如何在抖音做社交电商？-第2张图片-小七抖音培训\" style=\"height:331px;width:450px;\" />\r\n</p>\r\n<p style=\"color:#333333;font-family:&quot;font-size:16px;background-color:#FFFFFF;\">\r\n	1、爆款视频引流 &nbsp;\r\n</p>\r\n<p style=\"color:#333333;font-family:&quot;font-size:16px;background-color:#FFFFFF;\">\r\n	抖音卖货的基本逻辑是爆款短视频引流+小程序交易，而爆款视频主要取决于算法推荐，判定标准主要为完播率、点赞评论分享率等，与其辛苦摸索做视频，更便捷的方式则是通过与红人大V合作，以种草视频的方式引流。 &nbsp;\r\n</p>\r\n<p style=\"color:#333333;font-family:&quot;font-size:16px;background-color:#FFFFFF;\">\r\n	2、给用户裂变的动机 &nbsp;\r\n</p>\r\n<p style=\"color:#333333;font-family:&quot;font-size:16px;background-color:#FFFFFF;\">\r\n	抖商研习社有了流量并形成转化后，还需要二次分享才能形成裂变，这就需要给用户一个分享“动机”，可以是折扣、优惠券、返现、赠礼等等，而小程序的营销插件如拼团、砍价、抽奖、分销等，则可以为商家提供裂变营销工具。\r\n</p>\r\n<p style=\"color:#333333;font-family:&quot;font-size:16px;background-color:#FFFFFF;text-align:center;\">\r\n	<img src=\"http://demoall.adashuo.com/20090/uploads/allimg/c191107/15I0c25a5020-II2.png\" width=\"450\" height=\"319\" border=\"0\" alt=\"抖商研习社：如何在抖音做社交电商？-第3张图片-小七抖音培训\" title=\"抖商研习社：如何在抖音做社交电商？-第3张图片-小七抖音培训\" style=\"height:319px;width:450px;\" />\r\n</p>',	'doc.png',	1.00,	5,	0,	0,	0,	'2019-12-03 14:08:36',	'admin',	11,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	1.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	4,	1,	0,	1),
(47,	'特朗普回击众院弹劾条款:民主党和条款“太弱了”',	'<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	10月19日，京东宣布今年11.11大促将首次推出“京东拼购”等玩法。10月19日，美团点评官方微信小程序也正式上线了“好货拼团”板块。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	事实上，此前已经有包括阿里、苏宁、今日头条等多家互联网巨头切入了社交拼团业务。而这一切，在笔者看来，巨头们完全已经将拼购当成了获取用户流量的下一个杀手锏。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;text-align:center;\"=\"\"> <img border=\"0\" src=\"http://demoall.adashuo.com/25707/uploads/allimg/c191120/15J2314405K20-1L320.jpg\" style=\"height:auto !important;\" /> \r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	拼购成“香饽饽”\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	根据艾媒咨询发布的《2018Q1中国社交电商行业市场研究报告》显示，2018年中国社交零售用户规模将突破3亿人，年均复合增长率将达到44.2%。这也意味着，未来社交电商或仍将有巨大的增长空间。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	而作为社交电商的集中展现形式，拼购正凸显着自身鲜活的能量。这其中，最值得注意的就是拼购已经成为巨头最新切入的业务。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	具体来看，巨头们正在尝试性地推出自家相关的拼购业务。如果让消费者直接说出某个巨头旗下的拼购业务，可能会非常轻松。因为这些巨头推出的拼购应用，名字上大同小异——手淘特价版、京东拼购、苏宁拼购、今日头条的“值点”……\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	此外，支付宝联合淘宝上线拼购小程序“每日必抢”，网易则推出了“网易一起拼”。总的来看，它们还都是以“拼”、特价为主要特性，为自己烙印下超值的标签。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	而从数据上看，拼购在近段时间以来也成为电商行业的一个热词。根据速途研究院发布的《2018上半年国内拼购电商市场研究报告》显示，在巨头的入场下，它们不仅让自身拥有了亮眼表现，还让拼购行业获得了整体提升。从微信指数和百度指数看，各个巨头的拼购业务都有着显著提升。这也意味着，以布局消费分级市场为目标的拼购，成为了当下巨头眼中的“香饽饽”。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	巨头在拼购行业的试水，还反应在将自身的资源不断向拼购业务倾斜。比如，很多巨头都举办了优惠活动来吸引消费者，并展现自身拼购业务的特性。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	比如：京东拼购频道此前公布了双11玩法，旨在以流量传播扩散+提升订单为目标，通过打造贯穿双11的拼购寻宝乐园，同时引爆11.8拼购玩法狂欢日，为拼购小程序引流，帮助平台转化新用户并提升订单量。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;text-align:center;\"=\"\"> <img border=\"0\" src=\"http://demoall.adashuo.com/25707/uploads/allimg/c191120/15J231440B4F-1U327.jpg\" style=\"height:auto !important;\" /> \r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	苏宁拼购则将重点在直采直销生鲜商品上发力。在刚刚过去的双十拼购日，苏宁拼购一天卖出了40万个柚子，这坚定了其发展生鲜拼购的战略构想。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	因此，我们可以看到，在巨头的不断试水下，拼购这一社交电商模式已经变得迅速火爆。对于消费者来说，这也是一个消费变得多元化的好兆头。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	品质化渐成主流\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	其实，如果不戴“有色眼镜”去看拼购的话，其身上还是有很多亮点的。拼购以低价引入流量，通过关系网对商品进行分裂曝光，在满足多数人追求“低价”需求的同时，又大幅度增加中小商家和尾货的曝光率和购买率。也正因为如此，拼购在当下俨然成为购物模式中的一股新势力。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	但值得注意的是，在拼多多一家独大的时候，其商品质量、售后等饱受诟病。山寨、造假的问题，也造成了诸多负面影响。而在巨头纷纷入场的情况下，实际上也意味着拼购将进入下半场。在下半场开启的同时，拼购也将迎来全新的发展拐点。拼购在展现品质化的同时，也将成为巨头业务的补充，让它们构建更为完善的商业生态矩阵。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	对消费者利好的消息，在于品质化将成为拼购的常态。同时，品质化也将是巨头拼购业务的竞争发力点。不管是为了稳固消费者群体，还是出于维护自身品牌形象的考虑，巨头都不会再去牺牲商品质量和售后来实现低价。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	它们会尽力展示自身的物流实力、电商交易技术能力、核心交易链路、消费保障制度等，将供应链优势发挥到极致。最终，巨头的拼购业务将让消费者享受到具有更高性价比的品质好货，并由此实现真正的消费升级。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	此外，拼购业务的上线也是对巨头自身实力的加强。以美团拼团为例，其让美团实现了从虚拟商品向实物商品的过度，完成了自身商业边界的扩张。中国社科院财经院互联网经济研究室主任李勇坚表示，“过去用户可能只有在吃饭等时候才想到打开美团，但如果增加了商品类拼团，既有用户可能会在APP上停留更多的时间用于浏览商品”。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	而对于巨头而言，以往虽然在努力强调业务之间的整合，但缺少了某个版块后，业务之间总会有割裂感。拼购业务的出现，或许就能成为“黏合剂”，让巨头的业务实现融合发展。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;text-align:center;\"=\"\"> <img border=\"0\" src=\"http://demoall.adashuo.com/25707/uploads/allimg/c191120/15J231440I050-1c916.jpg\" style=\"height:auto !important;\" /> \r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	值得注意的是，对于巨头来说，它们此前都面临着各自不同的发展瓶颈。而要寻找创新增长点，就必须在流量上痛下苦功。拓展流量的最佳做法，就是通过开辟新业务获取。而拼购身为“引流大户”，自然被巨头所看重。在拼购行业的下半场，它们将争抢中高端消费人群，不断攫取新的流量。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	相信随着巨头纷纷切入拼购领域，后者也在加速下沉。而就发展趋势来看，只拼价格不拼质量的原始拼购模式注定被淘汰。在被巨头开启的下半场，拼购有望与消费升级概念的成熟、人均消费能力的提升高度契合。届时，拼购业务也将成为巨头比拼的另一立脚点。\r\n</p>',	'doc.png',	1.00,	36,	0,	0,	0,	'2019-12-03 14:09:59',	'admin',	0,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	1.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	13,	1,	0,	1),
(48,	'台“反渗透法”径付二读 国台办：不得民心',	'<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	11月5日，一项热搜出现在邦哥的微博首页，并且排名一路蹿升至第一，挂在榜首直至今日凌晨：6000多首歌从KTV下架。被下架歌曲中，《十年》、《泡沫》《死了都要爱》《听海》《K歌之王》等等大热歌曲赫然在列。许多媒体的标题用的是：你拿手的还能点么？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	而邦哥脑中也冒出了另一个问号：这些歌曲为什么被下架？谁主导了这次下架风波？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	一个民间组织，为何有权下架全国KTV的6000多首歌？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	这次下架风波毫无疑问是版权问题引起的：中国音像著作权集体管理协会（下称“音集协”）发出公告，要求KTV终端生产管理商和卡拉OK经营者在今年10月31日前，删除或者不向消费者提供6000多部音乐电视作品。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	乍一看这是一件好事，毕竟版权保护理应得到支持，即便6000多首歌的下架在短期内会给普通消费者带来一些麻烦，但依然有利于产业的良性发展。<strong>然而意外的是，邦哥就此与一位业内音乐创作者进行了解时，对方却对此次发出公告的“音集协”并不买账：这个协会其实不是国家的版权保护机构，之前还被央视曝光过收取高额版权费后，并没有给歌手支付费用，我对于之后钱的去向保留意见。</strong> \r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	业内人这样的评论，引起了邦哥的注意，我们随即找到了音集协官方微博，查看其回应此次事件的公告。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\"> <img alt=\"6609首歌从KTV下架，《十年》《泡沫》均中招，原因不止版权那么简单 \" border=\"0\" class=\"aligncenter\" src=\"http://demoall.adashuo.com/25707/uploads/allimg/c191120/15J231444420Z-10TG.jpg\" title=\"6609首歌从KTV下架，《十年》《泡沫》均中招，原因不止版权那么简单 \" style=\"height:auto !important;\" />众所周知，KTV使用他人音乐作品，需要依法取得授权。但全国KTV可以说是海量的，KTV所需要使用的作品也是海量的。实际经营中，要经营者自己去一对一地取得授权，说句实话，并不现实。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	音集协就是在这样的背景下成立的。我们查看了其官网资料，根据资料显示，该协会是会员制，注册会员后，协会可以帮助你进行统一的版权管理，对全国的KTV进行作品授权，或者进行相应的维权措施。但让邦哥十分惊诧的是，这次被下架的6609首歌，背后的版权所有者，没有一家是音集协的会员。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	换言之，<strong>音集协的权利范围本应是帮自己的会员授权和维权，这次却是向6609首他们本应管不着的歌，发放了“下架通知”</strong>……\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在音集协官方微博的回应公告中，这一消息得到了证实：\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\"> <img alt=\"6609首歌从KTV下架，《十年》《泡沫》均中招，原因不止版权那么简单 \" border=\"0\" class=\"aligncenter\" src=\"http://demoall.adashuo.com/25707/uploads/allimg/c191120/15J23144450T0-114138.jpg\" title=\"6609首歌从KTV下架，《十年》《泡沫》均中招，原因不止版权那么简单 \" style=\"height:auto !important;\" />这让邦哥不禁产生了一个疑问：不是音集协的会员，我的歌曲就不能在KTV里播放了么？音集协到底是一个什么样的组织，怎么会有这么大的权利，对非会员的作品也能进行下架处理？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	就此我们在其官网查找到了音集协的《协会章程》，章程总则中清晰地写明了音集协的性质：本团体是由依法享有音像节目著作权或者与著作权有关的权利人<strong>自愿结成的全国性、非营利性的社会组织</strong>。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	一个自愿结成的会员制民间组织，从法理上讲，应当并不具有行政执法权，按照常理本应无权对“非会员”的作品进行下架处理。而在音集协此次回应的公告中，对这一问题的描述如下：\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;text-align:center;\"=\"\"> <img alt=\"6609首歌从KTV下架，《十年》《泡沫》均中招，原因不止版权那么简单 \" border=\"0\" class=\"aligncenter\" src=\"http://demoall.adashuo.com/25707/uploads/allimg/c191120/15J2314445T30-12W41.jpg\" title=\"6609首歌从KTV下架，《十年》《泡沫》均中招，原因不止版权那么简单 \" style=\"height:auto !important;\" /> \r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	对此，邦哥咨询了法律方面的专家，对方表示：6000多首歌的权利人或其委托的代理公司对KTV经营者提起的单独诉讼，就法律关系上讲与音集协相互独立，并无关系。但公告中并未提到音集协与这6000多首歌的权利人或代理公司是否有委托关系，因此<strong>音集协此次的“下架通知”背后，是否有可能是接受了歌曲权利人本身的授权或委托，我们也不得而知。</strong> \r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	曾被众多媒体质疑、央视曝光高额版权费流向哪里？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\"> <strong>2006年，国家版权局规定，开始收取卡拉OK每包间一小时12元的歌曲版权费。我们日常去KTV的费用中，就包括了这部分版权费。</strong>那么这部分版权费收取后流向了哪里呢？根据文章开头从业者的说法，邦哥查阅了很多资料，发现这已经不是音集协第一次处于舆论中心。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	2009年，中央电视台连续多个栏目对音集协收取卡拉OK版权费的情况进行了报道；中央二套的《今日观察》栏目还播出了一期新闻专题节目《版权费还是保护费》，邀请两位专家，围绕卡拉OK版权收费及其分配问题。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	根据当时的报道，<strong>音集协自2007年开始收取KTV及卡拉OK版权费，至2009年，收取的版权费已达8000万元，但这笔钱的使用分配却很不透明，相当多歌手表示并未拿到应得的报酬，但作为集体管理组织的音集协却要收取高达50%的天价管理费。</strong> \r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在当时的采访中，音集协不愿详细说明收费方式以及对著作权人的返还方式。不过一位业内人士向央视记者透露，收费是通过一家叫做“天合文化”的公司进行的。根据公开资料，该公司成立于2007年8月，受音集协委托代收卡拉OK版权使用费。音集协负责授权，天合文化负责收费，二者形成一套KTV歌曲版权收费系统。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	而那时的国家版权局版权管理司王自强司长则认为音集协的做法有欠妥当，在接受记者采访时表示，“集体管理组织是一个非营利性机构，不能以组织企业来进行收费，只能建立自身的收费队伍。收费本体是你本身，你不能有一个第三者出来。”\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	那是音集协引起争议声浪最大的一次，此后也曾有过多家媒体跟踪报道过音集协收取版权费的相关内容。早在2008年就有北京中银律师事务所董正伟律师向国家工商总局、国家发改委举报，请求对音集协向KTV行业收取著作权使用费开展反垄断执法。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	而近两年，音集协受到的质疑更加密集了起来，2017年、2018年都有KTV联合状告天合公司（音集协的授权收费单位）进行行业和价格垄断，但最终都以天合的胜诉告终。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	有趣的是，<strong>音集协与天合文化的合作自2007年至2018年，11年间从未停止。但就在邦哥发稿前不久，音集协官网上出现了一份最新公告，终止了与天合文化的委托合作。</strong> \r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;text-align:center;\"=\"\"> <img alt=\"6609首歌从KTV下架，《十年》《泡沫》均中招，原因不止版权那么简单 \" border=\"0\" class=\"aligncenter\" src=\"http://demoall.adashuo.com/25707/uploads/allimg/c191120/15J231444A250-13U93.jpg\" title=\"6609首歌从KTV下架，《十年》《泡沫》均中招，原因不止版权那么简单 \" style=\"height:auto !important;\" /> \r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	被下架歌曲并非不能唱了，版权保护，路漫漫其修远兮\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	对于一个行业的健康发展来说，6609首无授权歌曲自KTV下架，理应得到支持。但版权收费的规范性、透明性，同样是应该得到重视领域。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在此次风波中，被认证为音集协副理事长的周亚平的微博发言，同样引发了相当多网友的不满：\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;text-align:center;\"=\"\"> <img alt=\"周亚平表示：希望权利人加入，而不加入的后果是“作品被摒弃在卡拉OK渠道之外”\" border=\"0\" class=\"aligncenter\" src=\"http://demoall.adashuo.com/25707/uploads/allimg/c191120/15J231444I530-14Kc.jpg\" title=\"6609首歌从KTV下架，《十年》《泡沫》均中招，原因不止版权那么简单 \" style=\"height:auto !important;\" /> \r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	周亚平表示：希望权利人加入，而不加入的后果是“作品被摒弃在卡拉OK渠道之外”\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在撰文的过程中，邦哥将此次下架的6609首歌曲完整名单下载了下来，发现实际上遭到下架的，只是该首歌曲的某些版本。例如周杰伦遭到下架的《告白气球》等歌，就仅限《中国新歌声》第一季播出版本被下架。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\"> <img alt=\"6609首歌从KTV下架，《十年》《泡沫》均中招，原因不止版权那么简单 \" border=\"0\" class=\"aligncenter\" src=\"http://demoall.adashuo.com/25707/uploads/allimg/c191120/15J231444PZ-15S59.jpg\" title=\"6609首歌从KTV下架，《十年》《泡沫》均中招，原因不止版权那么简单 \" style=\"height:auto !important;\" />虽然这样的版本限制让很多小伙伴产生了“虚惊一场”的感觉，但邦哥要提醒的是，<strong>版权制度的目的，以及所要保护的对象，是创作者和版权所有者的利益。权利人们的利益，决定了他们的生存环境。</strong>如果从业者无法生存，音乐产业的发展从何谈起？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	中国音乐版权保护之路，依然路漫漫其修远兮。\r\n	</p>',	'doc.png',	1.00,	30,	0,	0,	0,	'2019-12-03 14:10:31',	'admin',	3,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	1.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	12,	1,	0,	1),
(49,	'中国投资数亿助力初创企业:欲成人工智能领跑者',	'<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	人工智能时代已来，雷军为小米找的下一个风口是什么？成立相机部门能“干翻”华为吗?\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;text-align:center;\"=\"\"><br />\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	▲雷军在在故宫发布滑盖手机MIX3\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	作者 |马婧\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	编辑 |赵泽 杨砺\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在喊出“今年相机部门有没有年终奖，就看能不能干翻华为”之后，小米董事长雷军又发新手机了，这一次是在故宫。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	2018年10月25日，在故宫发布磁动力滑盖手机MIX3乾清宫户外发布会，雷军在现场有点激动，一个人solo了将近一个半小时。雷军在介绍手机后置相机时，突然天空中传来两声乌鸦叫，雷军忍不住笑场，说连鸟都在肯定小米手机，“这是我们第一次办的户外的发布会，还这么有趣啊。”\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	25日早间，小米集团发布公告称，预计到10月底，手机出货量将突破1亿台，提前两个月完成2018年全年目标。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	雷军在发布会上谈到，今年手机大厂商和小厂商之间的差距会拉大，主要原因是各家在相机、AI方面投入成本不同所致。今年5月，雷军在内部信中宣布，在手机部内成立单独的相机部，集中全公司优势资源，提升小米手机的拍照品质。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	雷军曾对相机部门的同事说，今年相机部门有没有年终奖，就看能不能干翻华为。25日下午更新了最新成绩，小米MiX3以103的成绩超过了华为P20。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	小米如何“干翻”华为呢？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	▲MIX3故宫乌鸦捣乱小米发布会现场 雷军笑场：连鸟都肯定了\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	未来高增速或不靠手机靠IoT\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	新京报：小米过去8年保持了高速的增长，未来还能有非常高的增速吗？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	雷军：我们对小米未来的高速增长很有信心。首先手机行业是一个很大的市场，2017年全球共销售手机14.7亿台，小米销售了9000多万台。随着5G时代的到来，手机市场可能再次迎来增长，虽然不会像过去增长那么快了，但这个市场即便不再增长，对于小米来说仍然有巨大的成长空间。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	其次，手机之外，小米在智能硬件和消费升级领域布局广泛，已经进入了100多个品类，建成了全球最大的IoT物联网平台。随着AI时代的来临，AI+IoT将产生巨大的价值，小米已经具备了一些优势。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	另外，小米在海外市场有巨大的机遇。小米手机已经进入了74个国家和地区，还有很多市场有待进入，我们的很多品类也还没有进入全球市场。随着小米一步一步进入新的市场，把新的市场做好，我觉得小米未来还有十倍以上的成长空间。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	新京报：我们注意到小米还在布局智能家居。有观点认为智能家居是个伪命题？你怎么看这个问题？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	雷军：“智能家居”不是一个新词，二十年前在国外就有了，只是一直没有推动。我们觉得背后主要原因是商业通道和技术通道没有打通，比如以前智能家居的成本非常高，家里必须重新装修一遍，这对消费者难以负担，此外，不同厂家的产品之间也很难互联互通。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	小米做了两件事情来解决，首先我们把一个个的产品智能化了，消费者买回家后，突然发现实现了智能家居，这是商业通道理顺了。另外，我们做了互联互通的模组，在技术上也打通了，小米智能家居产品由很多不同的公司生产，但只要用了这个模组就可以互联互通。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	智能家居目前只是刚起步，小米也只是刚跨过门槛，今后智能家居的发展空间可能远超我们想像。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	新京报：有人说，小米生态产品只是在做微创新，你怎么看这个问题？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	雷军：从我们创业的经验来看，成功背后都有不为人知的艰辛，哪怕是一点点成绩，都要付出巨大的努力。所以我觉得我们不要小看微创新，为了提升消费者的体验，哪怕仅仅是1%，我们也投入了100%的精力。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	小米立志要成为一家伟大的互联网公司，让全球每个人都享受科技带来的美好生我没有。我们只有全力以赴做好每一件小事，才是走在正确的道路上。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	下一个互联网浪潮是人工智能\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	新京报：如何看待互联网这20年来在中国的发展，如果用几个关键的时间点来划分，你会怎么划分？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	雷军：我觉得2007年苹果推出iPhone是个很重要的事件，智能手机的出现极大的改变了互联网，我判断手机会逐渐替代个人电脑，移动互联网的时代将会来临。2010年小米成立，2011年推出了第一代小米手机，我们推动了智能手机在中国的快速普及和品质提升，移动支付、电商、社交网络、短视频等行业在中国的蓬勃发展，都有赖于庞大的移动互联网人口，这方面小米做了一点贡献。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	新京报：互联网下一个浪潮会是什么？在这个浪潮下，小米的机会是什么？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	雷军：人工智能的时代已经到来了，人工智能也是小米最重要的战略，我们拥有四项巨大的优势，用户群、海量设备、海量的数据、对整个AI时代的认知，很早就重视了云服务和大数据。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	小米选择的突破口是IoT，也就是万物互联，我认为AI与IoT结合将形成AIoT，也就是万物智慧互联，在这个领域未来有着巨大的发展空间。小米已经建成了全球最大的消费物联网，连接了1.15亿台智能设备（不包含手机、平板和笔记本电脑），小米人工智能助理小爱同学月活跃设备超3000万，月唤醒计数超10亿次，累计唤醒次数超50亿次。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“天使投资人经历让我学会找风口”\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	新京报：从金山时代开始，业界对你的评价就是IT劳模，怎么看待这一评价？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	雷军：如果我们要实现与众不同的梦想，付出的不比别人多，怎么可能成功呢？我现在还是这样认为，创业并不光鲜，成功的企业家也不像大家想的，轻轻松松就成功了，哪怕一点点成绩，背后都要付出极大的努力。在成功的路上，其实只有这一个秘诀认真拼命地工作。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	新京报：天使投资人的身份对于创办小米有哪些帮助？创业者和投资人的思维方式最大的不同之处是什么？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	雷军：因为天使投资人做的就是看大势，找风口。我觉得创业要想五年后是什么样子？十年后是什么样子？什么是正确的事情，什么是正确的时间点？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	我当年是一个手机发烧友，认为手机上网是未来的趋势，未来10年是移动互联网的天下，那我接着就想应该做些什么？所以我用投资人的身份，去看谁在做移动互联网，去搞清楚移动互联网到底是什么，这个过程中我们越来越坚信移动互联网的未来，最终在2010年决定创办小米。\r\n</p>',	'doc.png',	1.00,	32,	0,	0,	0,	'2019-12-03 14:11:24',	'admin',	1,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	1.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	12,	1,	0,	1),
(52,	'“直播带货”风口吹进批发市场 商贩摇身变网红',	'<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	今年5月，唱吧终于完成了将近一年半的上市辅导工作。网上有消息称，唱吧在一个月后，就会正式向证监会递交招股书，踏上A股创业板的上市征途。但眼看着2018年就快要过去，却迟迟未见唱吧上市的消息。对此，唱吧创始人陈华在接受媒体采访时表示，对唱吧上市问题不愿多谈，言外之意是唱吧在近期内可能不会寻求上市。这突如其来的转变，让人们疑惑不解。唱吧在完成一年多的漫长上市辅导期之后，为何不愿上市？其究竟打的是什么“算盘”？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	唱吧上市搁浅，原因为何？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	唱吧从2012年上线起，便风光无限。其在上线首日注册用户就超过10万，5天之内登顶AppStore排行榜。易观数据显示，直到2016年第3季度，唱吧还以53.6%用户渗透率位居移动K歌领域第一的位置。彼时，唱吧正如日中天，选择上市无疑是正确之举。然而世事无常，经过将近一年半的漫长辅导期，国内的在线K歌市场早已“物是人非”，唱吧已然错过了最佳的上市时机。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	其一，全民K歌抢了唱吧“风头”。众所周知，全民K歌背靠腾讯，可谓是含着“金钥匙”出生。全民K歌不仅拥有微信与QQ两大流量入口，还与QQ音乐共享丰富的音乐版权，在流量与音乐版权方面都有着天然的优势，是唱吧最强劲的对手。据了解，全民K歌自2014年上线起，其活跃人数一直高增猛涨，在2016年成功超越唱吧，并逐渐拉开差距。据易观数据，2018年第三季度，唱吧活跃用户为6560万人，而全民K歌活跃用户则为20705万人，是唱吧的三倍。面对全民K歌的“攻城略地”，唱吧显然处于不利地位。而全民K歌的赶超，可能打乱了唱吧的上市计划。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	其二，短视频平台的崛起，冲击整个互联网娱乐市场。近几年，由于快手、抖音等短视频平台的崛起，整个互联网娱乐市场变的更加“拥挤”，唱吧的K歌业务、直播业务等都受到了一定的影响。QuestMobile数据显示，2018年7月，短视频APP行业月度活跃用户规模为5.08亿人，而短视频APP行业总使用时长在移动互联网中的占比达到惊人的9.2%，要知道，就算是在线视频的占比也仅有9.5%。可见，短视频APP行业已经抢占了大量互联网用户的上网时长，唱吧无法视而不见。再加上全民K歌的存在，唱吧要想巩固自身地位并不容易，目前也很难有华丽的数据支撑，若是在此时上市，唱吧的估值可能并不理想。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	其三，互联网股市动荡不安。最近国内不少已经上市的互联网企业过的并不“如意”，如小米、拼多多和美团等企业都出现了市值大幅下滑的情况，就连腾讯、阿里巴巴等老牌互联网企业也没能避免。受此影响，唱吧此时选择不上市或许是明智之举。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	一方面，在国内互联网股市行情不利的情况下，唱吧此时上市无疑是逆水行舟，有着“流血破发”的风险；另一方面，今年国内的互联网公司纷纷申请上市形成了“上市潮”，如宝宝树、映客、小米和拼多多等，如此多的公司扎堆上市，吸引了不少资金注入，导致资本市场紧缩，也就是说投资人手里的钱越来越紧张。这也许会造成唱吧融资困难，难以得到理想的融资金额。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在这些问题影响下，唱吧暂时将上市的计划搁浅，等待更好的时机上市，或许是不错的选择。不过除了上述三个原因之外，也有业内人士猜测，唱吧之所以要搁浅上市，可能是其要放弃A股创业板，而选择赴港上市。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	港股市场火爆，令唱吧有所动摇？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	对于唱吧要赴港上市的猜测，也并不是没有依据。早在2015年，唱吧就曾想要赴美上市，但由于美国缺乏与唱吧对标的产品，而导致其估值过低，令唱吧有所顾虑。与之相比，当时国内的A股市场行情较好，且国内资本对互联网科技股也愈发青睐。所以再三思考后，唱吧毅然拆除了VIE架构，选择回国赶赴A股上市。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	时至今日，随着港交所在上市机制上的改革，首次接受同股不同权企业上市，为互联网企业打开了一扇大门，包括小米、美团点评、平安好医生和宝宝树等多家明星企业都选择在港股上市。而此时的唱吧或许面临着与三年前类似的选择题，是A股还是港股？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	据了解，上市A股要求较为严格，除了必须盈利三年才能申请IPO外，还必须同股同权。而现在的港股市场，除了支持同股不同权企业上市，其监管机构也更加独立透明和高效，公司一般在6到12个月就能完成上市过程，可以帮助企业更好地把握好上市时机。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	此外，A股实行的是“T+1”交易制度，股民们当天买进的股票当天不能卖出，且还有涨跌幅限制。而港股采用的则是“T+0”交易制度，在当天交易时段内，相关机构和股民们可以自由买卖，交易次数与涨跌幅均无限制，这种方式不仅能够提高市场的交易量，还能帮助投资者及时止损。所以二者相对比较来看，港股市场规则似乎更加灵活且合理化，能帮助企业有更好的发展。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	且从根本上来讲，企业上市无非就是希望借助资本的力量，获得更好、更快速的发展。而随着港交所改革，港股已经成为了众多互联网公司上市的首选。在此条件下，唱吧若是选择“跟风”，改赴港股上市，也不是没有可能。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	不过从目前来看，在市场竞争加剧、股市动荡等问题影响下，唱吧此时上市并不稳妥。所以暂时将上市计划搁浅，继续修炼“内功”，才是唱吧最好的选择。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	养精蓄锐，厚积薄发\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	目前，纵观整个移动K歌市场，已然是唱吧与全民K歌双雄称霸的局面，像天籁K歌、K米和酷狗唱唱等K歌产品已经难以给全民K歌、唱吧二者带来威胁。可见，唱吧在移动K歌领域还是有着非常明显的领先优势，只要其能够完善自身，加强功能创新，或许就能够摆脱全民K歌所带来的竞争压力，在互联网娱乐市场中走的更远，其上市之路也会变得更为平坦。对此，唱吧可以从以下三个方面入手。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	首先，丰富曲库资源，提高音乐品质。音乐版权是移动K歌行业的刚需，缺少相应的音乐版权，用户就无法得到理想的K歌体验。如在用户K歌时，一定会选择自己喜欢的音乐进行录唱，但用户若是在唱吧中搜不到自己想要唱的歌曲，在别无选择之下，用户就会选择用其他的K歌软件进行录唱，最终造成唱吧的用户流失。因此，唱吧要想缩小与全民K歌的差距，还需与相关的音乐版权公司合作，丰富自己的曲库资源。同时，唱吧还应继续提升APP内的伴唱、录音和修音等音乐品质，争取为用户提供更加优质的K歌享受，以此来留住和吸引更多用户。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	其次，加强线上、线下融合，丰富用户K歌体验。如今，唱吧正在大力布局线下市场，其不仅花费数千万元战略投资麦颂KTV，并实现了与麦颂KTV在社交、服务等多方面的合作，还大力布局线下移动迷你KTV业务，取得了不错的成效。据了解，唱吧不光在全国拥有400多家麦颂KTV门店，还在商场、超市和机场等公共场所布下了2万多台迷你K歌亭。不过唱吧虽然在线下布局极广，但其线下资源还未能与线上达到有效的结合。目前唱吧在APP内只提供了KTV包房预定、在线点歌和在线切歌等常用功能，还有很大的完善空间。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	对此，唱吧可以在APP内添加游戏点歌、K歌评比和K歌挑战赛等有趣功能，加强用户线下与线上的互动。同时，用户在麦颂KTV里演唱的歌曲最好也能保存在唱吧APP中，让用户可以在唱吧APP中发布并分享自己在麦颂KTV里的演唱歌曲，这不仅满足了用户的分享欲望，又加强了线上与线下的融合，可谓是一举两得。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	最后，走出海外，争夺更大的移动K歌市场。如今，唱吧已经在国内取得了不错的成绩，其知名度和影响力也都达到了一定的高点，所以唱吧要想再有突破，并不容易。在此情况下，唱吧若是向海外市场发起冲击不失为一个选择。一方面，目前海外的许多国家都缺少类似唱吧这样的K歌产品，还是一片蓝海，这对唱吧来说有着不错的发展机遇；另一方面，在全民K歌、抖音、快手等平台影响下，国内的互联网娱乐市场空间变窄，唱吧要想继续在此环境中发展将受到不小的阻碍。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	总的来说，虽然上市会为唱吧带来新的发展机遇，但在市场竞争加剧、股市动荡等问题影响下，此时上市，对唱吧来说有着较大风险。因此，唱吧只有继续精细化运营，加强线上线下融合，并等待时机成熟后再进行上市，才会迎来更好的发展。\r\n</p>',	'doc.png',	0.00,	2,	0,	0,	0,	'2019-12-03 14:17:25',	'admin',	3,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	0.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	3,	1,	0,	1),
(53,	'冒充公检法实施电信诈骗 28名境外嫌疑人押解回国',	'<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	换上炫彩外壳，装上多变口味的烟弹，上市多年的电子烟今年突然热度飙升，成了备受追捧的创投领域。除了罗永浩在发布会上顺势推销的福禄电子烟，2018年末到2019年初，还有近10个新兴电子烟品牌出现。在深圳华强北电子市场，出售电子烟的广告牌更是如雨后春笋般涌现。但面对日趋严密的控烟大网，创业者们能否咽得下“这口烟”仍存在极大变数。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\"> <strong>电子烟突然变网红</strong> \r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	蓝莓、菠萝、水蜜桃、绿豆冰棒、柠檬茶……说到这些，不少人会联想到口香糖或是冰淇淋，却几乎没人能想到，这些全都是电子烟推出的新口味。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	精巧如U盘或是一根签字笔，也不用点火，从口袋里掏出来，打开开关就能用——近一年来，以电子产品形象出现的电子烟成了创投领域的新网红。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	今年1月，罗永浩在子弹短信新版本“聊天宝”发布会上，顺势推销了一款名为福禄、由锤子科技二号人物朱萧木创业推出的电子烟产品。紧接着，同道大叔创始人蔡跃栋与黄太吉创始人赫畅推出的“YOOZ柚子”，5位自媒体人组成创始团队的“灵犀&nbsp;LINX”也纷纷杀入。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	猪年春节，常年浸淫在科技圈、创投圈的自媒体人士陈女士惊讶地发现，平日里不抽烟的她，竟然收到了3种不同的电子烟产品作为新年礼物。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在深圳华强北，曾经卖VR眼镜、贴牌手机和智能家居产品的柜台，纷纷开始转售电子烟。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	突如其来烧起来的电子烟，背后是资本不断添柴加火。2018年，国内有十几家电子烟公司获得资本青睐，总融资额达数亿元。Wel鲸鱼、YOOZ柚子、魔笛MOTI、TRYMIX反正、GOIN谷云、APOC……新兴的电子烟品牌让人目不暇接，俨然造就了岁末年初最火热的创业领域。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\"> <strong>风口背后的同质化</strong> \r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“电子烟界的iPhone”、“颜值爆表一口解馋”、“重新定义吸烟”……在各家打出的广告语中，几百元一支的电子烟似乎成了可供电子发烧友们品玩一番的电子玩具。然而，花哨热闹的营销语言背后，电子烟的实质技术并没有太大区别。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“花几个月到半年时间，联系供应商、备货、外观设计，剩下就不需要你再做什么了，几乎没有任何硬性投入，本质上是个非常‘轻’（投入）的生意。”早期投资人付强向媒体透露，做一个电子烟项目，对技术等原创能力的要求几乎没有门槛。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	多位行业人士透露，由于国内电子烟供应链已经被电子烟发展较为成熟的国外市场培育得非常完备，因此很多新创立品牌都是通过代工生产。有技术爱好者对几款热门电子烟进行评测后发现，几个品牌在开关控制、烟油技术等方面相差无几，只是烟弹、外壳颜色、口味等进行了不同的排列组合与拼凑。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“电子烟的产品结构并不复杂，主要构成也就是充电电池（烟杆）、雾化器还有烟油三部分。”新晋电子烟品牌灵犀创始人章晋源坦言，电子烟的制造门槛并不高，确实存在行业同质化问题，“灵犀LINX当前着重聚焦于品牌环节，属于产业链下游，希望设计的首款产品具有品牌辨识度。”\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\"> <strong>电子烟也有多重风险</strong> \r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“清肺水果味”、“健康清肺蒸汽烟”……稍加留意就会发现，不少电子烟公司将产品与健康挂上了钩。在他们口中，因抽烟承受健康风险的烟民可以通过电子烟追求潮流文化、拥有“健康生活方式”。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	电子烟是否能够像一些公司所说的那样起到“代烟”、“辅助戒烟”的功效？目前尚无定论。令人担忧的是，一些原本不吸烟的人因为对电子烟的好奇而加入了烟民行列。在游戏公司工作的白先生告诉记者，他的同事和合作伙伴里出现了好几位新一代“电子烟民”——而他们过去根本不碰香烟。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	北京营养师协会理事顾中一提醒，电子烟中虽然没有普通烟草燃烧所产生的焦油、一氧化碳等有害物，但仍然含有有毒、成瘾的尼古丁，对普通人特别是儿童、青少年仍然有危害。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	记者在一家电子烟的天猫店铺内发现，虽然商品详情页面的底部用黑色背景的字体写着“未满十八岁不允许购买”，但一不留神就会错过这一信息。并且，记者在尝试下单时，店铺对身份信息、年龄等方面毫无要求，消费者可以随意下单购买。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	顾中一还提醒，由于目前市场监管并没有完全到位，缺乏相关国家标准，电子烟产品中用到的原料、调味剂、工艺都较为随意，厂家很可能为了增加新奇体验加入一些对人体有害的物质。“哪怕是一些比较常见的添加剂，正常食用是安全的，吸入肺部却可能带来潜在风险。比如丙二醇是很常见的食品添加剂，但是燃烧后容易刺激呼吸道，一些电子烟的烟雾中也可能含有重金属。”\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	对创业者来说，更大的考验来自于市场的不确定性。在控烟大势下，多地已经将电子烟列入了管控范围。今年2月，继杭州、南宁等城市在公共场所禁止使用电子烟之后，深圳在其控制吸烟条例征求意见稿中将电子烟纳入了控烟“黑名单”。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	意识到道德、法律等多重风险，一些科技上市公司急于与电子烟划清界限。今年2月中旬，小米公司官方微博就对“小米旗下生态链公司将进军电子烟领域”一事进行回应，称“小米不会做电子烟，此事纯属谣言”。\r\n	</p>',	'doc.png',	1.00,	33,	0,	0,	0,	'2019-12-03 14:18:03',	'admin',	2,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	1.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	12,	1,	0,	1),
(54,	'郎永淳转行后常陪客户喝酒 曾称“只能去适应”',	'<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	2018年可谓是中国智能音箱的元年。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	业内普遍认为，智能音箱是切入智能家居使用场景、并易于被用户接受的理想入口，而智能家居的开关一旦被打开，更多的产品和服务将快速进入消费者的日常生活，获得一个更多元的商业环境。因此，近两年国内外科技巨头、互联网巨头皆大力发展智能音箱，使得该领域得到飞跃式增长，并从小众逐渐走向大众。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	值得一提的是，智能音箱除了具有巨大的消费市场外，对于互联网巨头们来说更起到AI市场的“门票”的作用。在这个快节奏的时代，企业之间的竞争更加激烈，率先拥有某一行业的门票就相当于成功了一半。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	由此，继国外亚马逊、谷歌、Facebook、苹果等科技巨头布局智能音箱产业之后，国内如阿里、百度等巨头也纷纷入局，小度智能音箱、叮咚、天猫精灵等产品在市场活跃度直线上升，国内智能音箱市场一片繁荣，随后在去年打起了“智能音箱价格战”。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	全球互联网巨头共掀全球智能音箱浪潮\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	根据Strategy Analytics发布的《2018年第三季度全球智能音箱市场报告》，2018年第三季度全球智能音箱出货量达到2270万，同比增长197%，创历史新高。其中，亚马逊智能音箱的全球份额与2017年相比有大幅下降，但出货量一直在上涨，第三季度市场占有率依然最高，达到32%，而谷歌以23%的市场占有率紧追其后。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	值得一提的是，来自中国的阿里、百度、小米智能音箱出货量分别排在全球第三、第四、第五位。当中又以百度表现最为亮眼，其市场占有率从2018年Q2的1％增加到2018年Q3度的8％，超越小米，成为当之无愧的黑马。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	而根据eMarketer《2019年智能音箱市场趋势观察》的预测，2019年中国将拥有8550万智能音箱用户，超过美国7420万的用户数量。智能音箱在美国网民中的普及率为26.0%，远高中国的10.0%，因此未来中国智能音箱领域还有极大的发展空间。不过即便如此，国内企业想要在智能音箱领域进一步发展仍有极大挑战。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	首先，是亚马逊、谷歌、苹果等海外企业更加成熟的智能音箱产品的冲击。亚马逊于2014年11月发布了Echo音箱，揭开智能音箱的序幕，打了人工智能领域“领头羊”谷歌、设备领域“领导人”苹果一个措手不及，成为智能音箱领域的第一人，为其之后进军智能家居领域打下基础。随后谷歌、Facebook、苹果等科技公司纷纷跟进，相继推出GoogleHome、Portal、HomePod。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	而后，无论是亚马逊并购互联网路由器初创企业Eero，还是谷歌推出Google Wifi，都表明国外在智能家居领域发展正愈加成熟，由此给国内市场带来的冲击是巨大的。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	其次，是国内错综复杂的智能音箱市场而产生的原生阻力。国内智能音箱市场厂商繁杂，主要有五种类别：一是以BATJ等为主的互联网公司，希望通过语音这一入口建立智能生态，为既有的内容和服务寻找新市场；二是以科大讯飞为代表的，专注于技术开放平台建设的技术厂商；三是以喜马拉雅等内容厂商；四是主打智能家居的创业公司；五为以漫步者为代表的传统音箱厂家。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	与国外相比，国内智能音箱领域除了厂商更繁杂、竞争更激烈外，在时间上也有一定的滞后性。国内第一款智能音箱叮咚诞生于2015年，由京东与科大讯飞联合推出。此后国内智能音箱市场沉寂，直至2017年阿里试探性地推出天猫精灵，小米、百度等企业不甘落后，纷纷入场，国内智能音箱才进入密集发售期，一时间智能音箱领域热闹非凡，“百箱争鸣”。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	当先天不足遇上恶劣生存环境\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	当下，我们不能否认的是，随着家庭中联网设备的不断增加，有极大几率成为未来智能家居控制中枢的智能音箱有着非同一般的重要性。但古往今来，利益有多大，风险就有多大。对于如钥匙般的智能音箱领域来说，发展面前有三问需解答。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	首先，智能音箱如何“智能”？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	每当市场有了新的风口，就会出现无数跟风之人，智能音箱也不例外。为搭上智能音箱的顺风车，传统音箱厂家推出不少产品，只不过卖点都集中于音质，本末倒置。 另外，“语音识别技术”也是尚未完善，一方水土一方人，同一语种还有不同口音，更别提各地方言以及语境涉及到的自然语言理解问题。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	除此之外，还有人工智能和物联网领域中老生常谈的安全隐患问题，如数据存储、身份认证、敏感数据保护等，在此不多赘述。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	其次，智能音箱如何提高普及率与使用率？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	我们知道，物联网时代“未来智能家居的控制核心”这一定位是智能音箱如此火热的重要原因之一。而理想的智能家居生态并非是家居单品的智能化，而是彼此联动，达到互联互通互控的状态，但目前的智能家居系统仍旧处于互相独立的状态，使得智能音箱使用率不高，如同“鸡肋”。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	与国内相比，国外在此方面就先进得多，以美国为例，美国的智能家居行业有统一的标准协议，亚马逊的Echo可以直接接入各种智能家居设备，这也是为何美国智能音箱普及率远高中国的原因。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	最后，国内企业如何“走出去”？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在用户习惯方面，国内外有着不小的差异。以使用环境为例，国外用户居家环境多为开放式，美国家庭主妇在烹饪时都喜欢听音乐，因此智能音箱在国外的消费需求也相对较高。而国内，厨房客厅封闭性更高，生活环境相对嘈杂，相应地市场对智能音箱需求较低。此为国外厂家难以进入中国市场的重要原因之一，另一限制则是人机交互的“本土化”程度低。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	以苹果HomePod为例，虽然其Siri语音助手对中文的支持已经有一定成果，但在交互、理解能力等方面，与本土选手阿里、百度相比仍是落后。并且，以BAT为代表的国内企业拥有更多本土资源，境外企业如苹果，很难在中国有突破性进展。同理，国内企业想要走出去也会遇到同样的难题。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	综上，智能音箱可谓是“腹背受敌”，而现阶段各巨头发展智能音箱的主要目的并不是盈利，而是抢占更多的用户家庭，为未来AI生态建设进行数据铺垫。那么，中小企业如何在这场战争中存活呢？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	双重风暴下，智能音箱可靠内容过冬\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	前文提过，国内有一类以喜马拉雅为代表的注重内容的智能音箱厂商，笔者认为现阶段此类厂商可能更好存活。现今用户对智能音箱的主要需求还处于“听”的情况下，智能音箱很大程度上是内容生态之争。在此基础上，喜马拉雅以自身丰富的内容为基础，推出智能音箱小雅，将更容易在家庭场景中突围。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	虽然从整体上看，喜马拉雅与BATJ等互联网巨头在技术和未来AI整体布局上存在相当大的弱势，但由于各种原因的限制，国内用户对智能音箱的需求在接下来很长一段时间里，都将处于“听”的阶段。并且，智能音箱核心技术“语音识别”，从本质上来说也是内容的一部分。从另一角度看，喜马拉雅的竞争对手也并非是BATJ等互联网巨头，其在智能音箱领域的发展更多的是为了扩充自身音频业务，巩固自身在在线音频市场的地位。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	同样的，在内容资源上有着强大优势的还有腾讯，毕竟现阶段消费者购买智能音箱的主要用途就是内容消费和智能家居两方面。在此基础上，腾讯可将自身音乐、阅读和视频整合，为智能音箱做内容支持。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	除了内容消费，“智能音箱+教育”的模式发展空间也十分广阔，尤其是早教领域。抛开说烂了的在线教育，光是国人对子女教育的重视程度，就足以让智能音箱注意到“早教”这一领域。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	单从目前智能音箱市场情况来看，短时间内C端消费市场的表现都比不过B端。因此，如何在B端站稳脚跟再最终反哺C端，是智能音箱发展过程中相当重要的一点。站在这个角度上看，“智能音箱+早教”的未来十分令人期待。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	毕竟，国内早教行业师存在资水平有限，地域发展不平衡，多数幼师仅经过短期培训就上岗从业，专业化程度低等问题。若是将智能音箱与早教结合，它所承载的大量专业、系统、科学的早教课程，能完美弥补传统绘本、书籍、视频等的缺点，再加上其操作简单、安全性高、不损伤视力的优点，能让智能音箱成为早教过程中不可或缺的工具。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	当然，除了以上两个方向，智能音箱作为人工智能音频端的入口，能够发展的B端场景是十分丰富的。就此，在C端市场来临前，国内非巨头企业在智能音箱领域也有了新的突破口。那有没\r\n</p>',	'doc.png',	1.00,	20,	0,	0,	0,	'2019-12-03 14:18:52',	'admin',	5,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	1.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	4,	1,	0,	1),
(55,	'内蒙古一旗县发生重大刑事案件 警方悬赏2万缉凶',	'<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	社交网络下一步发展的未来在何方？6日，Facebook创始人扎克伯格给出了自己的答案。在一篇长达3200字的公开博客文章中，这家全球最大的社交网络的掌门人称，未来Facebook将专注于营造一个更为私密和安全的网络社交环境。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	“当我思考网络的未来，我认为专注于隐私的通讯平台相比今天的开放平台，将变得更加重要，”扎克伯格写道：“今天我们已经看到私密消息、短故事分享和小规模群组是在线通讯交流发展最快的领域。”\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	尽管扎克伯格认为，开放社交网络在未来仍有一席之地，但更大的机会在于“建立一个首先专注于隐私的更为简单的平台。”\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	扎克伯格称，在过去15年间，Facebook和Instagram帮助建立了一个“数字化的公开广场“，但人们开始迫切需要更为私密的”数字化的客厅空间“。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	对于Facebook来说，这将是一个具有里程碑意义的转型，成立15年来，Facebook成功打造了全球最大的公开社交网络，并在此基础上建立起一家以广告业务为主的商业帝国。但近年来，随着一系列与用户数据隐私泄漏相关的丑闻接连爆发，Facebook开放社交模式遭遇到前所未有的严峻挑战。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	正是由于内外部坏境发生的变化，促使Facebook开始思考接下来的转型方向，如今，这家全球最大的社交网络通过其掌门人的一封公开信给出了解答。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	“我认为未来的通讯将更多地转向私密的、加密的服务，这样人们在与别人交流时，对于信息的安全新、内容不会停留会更有信心，”扎克伯格说，“这是我希望我们能够帮助带来的未来。”\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	为了达成这一目标，扎克伯格称，Facebook即时通讯平台将向Whatsapp的模式靠拢，未来端到端的加密服务将贯穿于Facebook所有旗下包含即时通讯的业务功能，该表态印证了此前外界流传的Facebook计划打通旗下即时通讯功能的传言。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	扎克伯格称，计划按照打造WhatsApp的模式进行：专注于最为基本和私密的应用场景即时消息开始，让其尽可能的安全，然后在此之上建立更多让人们能够互动的方式，包括打电话、视频聊天、群组、故事、商业、支付最终成为更多私人服务的平台。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	为了实现这一转型目标，扎克伯格列出了数项准则，包括加密、缩短内容的存续、安全、互通和安全数据存储。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	“我相信我们应该朝着建立这样一个未来世界而努力：人们可以私下说话并且知道他们的信息只会让他们希望看到的人看到并且不会永远存续下去，“扎克伯格说，”如果我们能够帮助世界朝着这个方向发展，我将会为我们所做出的努力感到自豪。“\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	以下为扎克伯格公开博客全文：\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	注重隐私的社交网络愿景\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	过去几年，我的重点一直是理解和应对Facebook面临的最大挑战。这意味着对关系到互联网未来的重要问题采取什么立场。在本文中，我将概述Facebook围绕建立以隐私为中心的信息和社交网络平台的愿景和原则。有许多的事情要做，在开发的进程中，我们承诺开放式的工作，并将与全社会的专家进行协商……\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	过去15年间，Facebook和Instagram一直在帮助人们与友人、社区和等同于数字城市广场中的兴趣联系在一起。但是人们也越来越想私下在相当于起居室的数字环境中进行交流。当我思考互联网的未来时，我认为一个注重隐私的交流平台将变得比今天的开放平台更加重要。隐私让人们有自由做自己，更自然地联系，而这些是我们建立社交网络的原因。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	今天，我们看到私有信息、短暂的故事和小型群组已成为在线通讯中增长最快的领域。这有许多原因。许多人更喜欢一对一交流，或者只是与几位朋友交流。人们对分享有永久记录的内容更加谨慎。我们也都希望能够私下和安全地进行支付。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	公共社交网络将继续在人们的生活中发挥重要作用--与你认识的每一个人联系；发现新的人、想法和内容；让人们有更广泛的发言权。人们每天都会发现有价值的内容，而且还有很多有用的服务可以构建在它们之上。但是现在，人们也想通过各种方式私下交流，这也让我们有机会打造一个首先专注于隐私、更简单的平台。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	我明白很多人不认为Facebook有能力、或者甚至不想构建这种以隐私为中心的平台，因为坦率地讲，我们目前在构建隐私保护服务方面没有很好的声誉，而且我们一直专注于更开放的共享工具。但是我们已多次表明，我们可以通过进化来打造人们真正想要的服务，包括私有信息和故事。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	我认为，通信的未来将越来越多地转向私有、加密服务。在此类服务中，人们可以确信他们对彼此说的话是安全的，他们的信息和内容不会永远存在。这是我希望我们能帮助实现的未来。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	我们计划用开发WhatsApp的方式来构建这一平台：专注于最基本和私有用例--消息--尽可能确保它的安全性，然后构建更多的方式让人们在此基础上进行互动，包括通话、视频聊天、群聊、故事、商业、支付、商务，最终成为许多其他类型的私有服务的平台。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	这个注重隐私的平台将围绕以下几个原则构建：\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	·私下互动：人们应该拥有简单、亲密的场所，在那里可以清楚地控制谁可以和他们交流，并且相信没有人可以接触到他们分享的内容。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	·加密：人们的私人通信应该是安全的。端到端加密防止任何人，包括我们在内，看到人们分享在我们服务中的内容。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	·减少永久性：人们应该感到自在，不应担心他们分享的内容会反过来伤害自己。因此，我们不会将信息或故事保留超过提供服务所需的时间，也不会超过人们希望它们留存的时间。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	·安全：人们应该期待我们会尽一切努力，在加密服务可能的范围内，确保他们在使用我们服务时的安全。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	·互操作：人们应该能够使用我们的任何应用联系他们的朋友，应该能够轻松安全地通过网络交流。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	·安全数据存储：人们应该期待我们不会在隐私和言论自由等人权记录薄弱的国家存储敏感数据，保护数据被不当访问。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	未来几年中，我们计划围绕这些想法重建更多的服务。在此行程中，我们面临的决定将意味着对关系到互联网未来的重要问题采取什么立场。我们清楚有很多权衡需要纠正，我们承诺与专家进行协商，并讨论最佳的前进方向。这需要一些时间，但我们不会关着门朝着这个方向发展。我们将尽可能以公开、合作地态度这样做，因为其中许多问题影响到社会的不同层面。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	私下互动是基础\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	要让一项服务感觉具备私密性质，绝不让用户怀疑在和谁交流。我们努力在所有产品中建立隐私属性，包括公共分享产品。消息服务的一个重要特性是，即使用户的联系人列表在扩充，用户的个人线程和群组仍然是私有的。随着时间的推移，用户的好友会逐渐发展，消息服务会优雅地发展，并保持亲密。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	这与更广泛的社交网络不同。在社交网络中，人们可以积累好友或追随者，直至服务更加公开。这非常适合许多重要的用途--告诉用户所有的朋友一些事情，在重要的话题上传递用户的声音，寻找有相似兴趣的人群，追踪创作者和媒体，买卖东西，组织筹款人，发展业务，或者让用户认识的每一个人在相同的地方得到好处。尽管如此，当用户一起看到所有这些经历时，感觉更像是一个城镇广场，而不是一个更私密的空间，比如客厅。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	我们有机会建立一个关注人们想要私下交流的所有方式的平台。这种隐私和亲密感不仅仅是技术特征--它被深深地融入到服务的整体感觉中。举例来说，在WhatsApp当中，我们的团队专注于在产品的各个方面创造一个亲密的环境。即使我们构建了允许更广泛分享的功能，这仍然是一种不太公开的体验。当团队开发群组功能时，他们设定了规模限制，以确保每一次互动都是私密的。当我们在WhatsApp上发布故事时，我们限制了公共内容，因为我们担心这种做法可能会削弱隐私感--即使这并没有真正改变用户和谁分享。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	几年后，我预计未来版本的Messenger和WhatsApp将成为人们在Facebook网络上交流的主要方式。我们致力于让这两款应用更快、更简单、更私密、更安全，包括端对端加密。然后，我们计划增加更多与好友、团体和企业私下交流的方式。如果这种进化成功，通过Facebook网络与用户的好友和家人互动，将会从根本上成为一种更加私密的体验。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	加密与安全\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	人们期望他们的私人通信是安全的，并且只被收方看到，而不是黑客、罪犯、过度干预的政府，甚至是操作正在使用的服务的人。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	人们越来越多的意识到，更多的实体可以访问自己的数据，就越容易被人滥用或被网络攻击泄露。一些人也越来越担心，技术可能会将权力集中在政府和像我们这样的公司手中。一些人担心我们的服务可能会访问他们的信息，并将其用于广告或其他他们不期望的方式。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	端到端加密是开发注重隐私的社交网络的重要工具。加密正在分散--它限制了像我们这样的服务看到流经的内容，并使其他人更难访问用户信息。这就是为什么加密在我们的网上生活中越来越重要，从银行到医疗健康服务。这也是为什么我们在收购WhatsApp后把端到端加密植入WhatsApp中的原因。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	去年，我曾与持不同政见者交流过。他们告诉我，加密是他们自由甚至活着的原因。一些政府经常对数据提出非法要求，当我们在法庭上驳回这些要求时，我们总存在败诉的可能--如果信息没有加密，我们要么必须交出数据，要么不遵守法庭规定导致员工被逮捕。这看起来很极端，但是我们曾有过这样的案例，一名员工就因为不提供对某人私有信息的访问而身陷囹圄。事实上，我们也无法访问这类信息，因为它是加密的。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	与此同时，在我们能够在所有消息服务中部署端到端加密之前，我们需要解决真正的安全问题。加密是保护隐私的有力工具，但也包括做坏事的人的隐私。当数十亿人使用同一服务连接时，他们中的一些人会将它滥用于真正可怕的事情，比如剥削儿童、恐怖主义和敲诈勒索。我们有责任与执法部门合作，并尽所能帮助防止这些行为。我们正努力通过检测活动模式或其他方式，来提高识别和阻止应用中不良行为的能力，即使我们看不到消息的内容，我们将继续对这项工作进行投资。但是我们面临着一个内在的权衡，因为当我们的安全系统能够看到这些信息时，我们永远也不会发现我们今天所做的所有潜在伤害。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	找到保护隐私和安全的正确方法，是社会在历史上一直努力解决的问题。这里还有许多悬而未决的问题，我们将与安全专家、执法部门和政府协商实施安全措施的最佳方式。我们还需要与其他平台合作，以确保整个行业能做出正确的事情。我们越是能创造一种共同的方法越好。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	总的来说，我相信为所有私人通信实施端到端加密是正确的。人们通过信息和电话完成一些最敏感的私人谈话，在网络安全威胁日益增加、许多国家政府干预过度的情况下，人们希望我们采取额外措施来保护他们最私密的数据。对我而言这似乎是对的，只要我们花时间构建适当的安全系统，尽可能在加密服务的范围内阻止不良行为。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	我们已开始在WhatsApp的基础上开发这些安全系统，在全面实施端到端加密之前，我们将在2019年及以后与专家讨论这些系统。随着我们从专家那里学到更多的知识，我们将最终确定如何推出这些系统。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	减少永久性\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	我们越来越相信在短时间内保存信息非常重要。人们想知道他们分享的信息不会反过来伤害他们，减少他们信息的存储和访问时间会有所帮助。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	“永久性问题”开发社交工具的一个挑战是。随着时间的推移，我们积累了大量的信息和照片，它们在成为资产的同时，也成为了一种负担。例如而言，许多Facebook的老用户可能会有年轻时候的照片，这可能会让人尴尬。但是人们也非常喜欢记录他们的生活。如果Facebook和Instagram上的所有帖子都消失了，人们将无法获得他人分享的大量宝贵知识和经验。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	我认为有机会为私有通信平台设定一个新的标准--内容会自动过期或随时间归档。除非用户存档，否则故事会在24小时后过期，这让人们更自然地分享。这种理念可以扩展到所有私人内容。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	举例来说，在默认情况下，信息可以在一个月或一年后删除。这将降低用户的信息再次出现并让他以后尴尬的风险。当然，如果用户愿意，可以自己改变时间框架或者关闭线程的自动删除。如果用户愿意，我们还可以为用户提供选项，让他将个人信息在几秒钟或几分钟后设置为过期。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	限制我们存储消息元数据的时间也有意义。我们使用这些数据来运行我们的垃圾信息和安全系统，但我们并不总是需要长时间保留这些数据。解决方案的一个重要部分是首先收集较少的个人数据，这也是WhatsApp从一开始就建立的方式。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	互操作\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	人们希望能够选择他们用来与人交流的服务。然而，今天如果用户想在Facebook上给人们发信息，你必须使用Messenger；在Instagram上必须使用Direct；在WhatsApp上必须使用WhatsApp。我们想给人们一个选择，这样他们可以通过这些网络从他们喜欢的任何一款应用联系他们的朋友。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	互操作性有隐私和安全优势。举例来说，许多人使用Android上的Messenger收发短信。这些文本不能进行端到端加密，因为短息协议没有加密。然而，有了跨我们服务传递信息的能力，用户就可以从Messenger向WhatsApp中的某人的电话号码发送加密短信。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	这还可以提高许多体验中的便利性。在这些体验中，人们使用Facebook或Instagram作为他们的社交网络，WhatsApp作为他们首选的消息服务。举例来说，许多在市场上出售商品的人会列出他们的电话号码，这样人们就可以发送与购物相关的信息。这并不理想，因为用户要给陌生人提供电话号码。有了互操作性，用户就可以使用WhatsApp接收发送到Facebook账户的信息，而无需分享电话号码--买家也不用担心卖家是喜欢在哪个网络发信息。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	可以想象许多类似这样的简单体验--一个人在Instagram上发现了一家公司，并很容易过渡到他们喜欢的消息应用，以获得安全的支付和客户支持；另一个人想追上一个朋友，可以向他们发送一条消息，发送到他们喜欢的应用，而不必考虑这个人喜欢在哪里被联系；或者用户只需在Facebook和Instagram上发布一天的故事，就可以在一个地方得到好友的所有回复。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	今天，用户已可以通过Android上的Messenger发送和接收短信，我们希望在未来进一步扩展这一功能，或许包括新的电信RCS标准。然而，在这成为可能之前，我们需要解决几个问题。首先，苹果不允许应用在他们的设备上与短信交互操作，所以我们只能在Android上这样做。其次，我们需要确保互操作性不会损害人们已使用WhatsApp的加密预期。最后，它会在加密系统中造成安全漏洞和垃圾邮件漏洞，让人们从未知的应用中发送信息，因为我们的安全和安保系统看不到这些活动的模式。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	这些都是重大挑战，有许多问题需要进一步协商和讨论。但是，如果我们能够实现这一点，我们就可以给人们更多的选择，让他们使用喜欢的服务，以安全地联系到他们想要联系的人。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	安全数据存储\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	人们想知道他们的数据安全地存储在他们信任的地方。展望互联网和隐私的未来，我认为我们将做出的最重要的决定之一是：在哪里建立数据中心和存储人们的敏感数据。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	在一个国家提供服务和在那里存储人们的数据有着重要的区别。当我们在世界各地建设基础设施时，我们选择不在有侵犯隐私或言论自由等人权记录的国家建设数据中心。如果我们在这些国家建立数据中心并存储敏感数据，而不仅仅是缓存非敏感数据，这可能会让这些政府更容易获取人们的信息。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	坚持这一原则可能意味着我们的服务在一些国家会受阻，或者我们不能很快进入其他国家。这是我们愿意做出的折衷。我们不认为在一些国家存储人们的数据是一个足够安全的基础，可以在其上建立如此重要的互联网基础设施。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	当然，保护最敏感数据的最佳方法是根本不存储它，这就是WhatsApp不存储任何加密密钥的原因，我们计划在以后的其他服务中也这样做。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	但是在更多国家存储数据也开创了一个先例，鼓励其他国家政府寻求更大程度地获取其公民的数据，从而削弱了全世界人民的隐私和安全保护。我认为，对于互联网和隐私的未来而言，我们的行业继续坚决反对把人们的数据存储在得不到安全保障的地方，这一点很重要。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	下一步举措\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	在接下来的一年及以后，我们还要制定出与这些原则相关的许多细节和权衡。这项工作中的许多仍处于早期阶段，我们致力于与世界各国的专家、倡导者、行业合作伙伴和政府(包括执法部门和监管机构)协商，以正确做出这些决定。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	与此同时，通过这些原则开展工作只是构建以隐私为中心的社交平台的第一步。除此以外，我们还需要对在此基础上构建的所有服务进行深入思考--从人们如何支付和金融交易，到企业和广告的作用，再到我们如何为其他私人服务提供平台。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	但是，这些最初的问题得到正确答案是至关重要的。如果我们做得好，我们可以创建私人共享平台，这对于人们而言可能比我们建立的帮助他们更公开分享和联系的平台更重要。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	这意味着对关系到互联网未来的重要问题采取什么立场。作为一个社会，我们有机会阐明我们的立场，决定我们如何重视私人通信，以及谁来决定数据应该存储多长时间以及存储在哪里。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	我认为我们应该努力实现这样一个世界，让人们可以私下交谈，自由生活，知道他们的信息只会被他们想看到的人看到，而且不会永远停留在身边。如果我们能帮助世界朝着这个方向发展，我将为我们所取得的成就感到自豪。\r\n</p>',	'doc.png',	1.00,	8,	0,	0,	0,	'2019-12-03 14:19:38',	'admin',	1,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	1.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	3,	1,	0,	1),
(56,	'朝鲜将白头山所在行政区提升为市 是金正日故乡',	'<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	今年两会期间，明星委员们的提案再次将炮火对准了劣迹艺人、明星及影视数据造假、身价片酬等行业乱象，不过前方固然慷慨激愤，后方还是其乐融融，#明星该不该吃粉丝送的食物#、#明星被认错#等话题频繁被推上热搜，娱乐氛围依旧。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	但今年还是有些许不同，2018年影视连续震荡所牵引出的政策新规，将在今年集中落地并被检验效果，前段时间，吴秀波、翟天临事件又掀起公众对娱乐圈造假的口诛笔伐。换句话说，娱乐产业规则改写的时机，可能已经同时具备了政策自上而下和舆论自下而上的两个必要条件。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	若是如此，数据造假将成第一个靶子，而往后推，数据造假的一环如果被铲除，是否能动摇当前畸形的粉丝经济呢？这是值得业界探讨的。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	造假产业链的逆向思考\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	2019年开年，《人民日报》发表文章，矛头直指流量明星锁场、刷榜、买粉丝，而后其又连续发表微博，感慨“明星流量数据节节攀升，8亿网民不够用”。随之跟进的还有《光明日报》《北京日报》，而“紫光阁”则从1月5日-9日，连发4条微博，痛批流量明星，呼吁“没有高质量作品做支撑，那些拙劣的表演终将被揭穿”。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	影视产业春寒料峭，一场“打假运动”的兴起，或许正是今年的新风向。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	微博已率先做出反应，宣布针对转发、评论计数显示方式在内做出种种调整，而更早之前，爱奇艺和优酷停止了播放量的展示。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	这对于影视数据脱水进而回归合理无疑是一个有利信号，视频及社交平台本身就是流量造星、粉丝运营的核心媒介，隐藏播放量起码减掉了数据造假的一个需求。虽然不得不承认，这一举措对整个行业来讲，也只是让数据造假不至于假得太“难看”，但其释放的市场信号是积极的：影视数据造假的乱象，今年或许不会止于揭露。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	以此为基础，我们再来看影视产业数据造假的产业链。一般来讲，卖方一端通过雇佣技术型或人工型水军，提供刷流量业务，至于买方一端，央视将明星数据造假的推手，归为自发组建的粉丝组织和经纪公司安排成立的明星微博数据站。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	两方需求契合，流量明星通过这一番操作获取一定的人气和地位，从而掠取演艺资源。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	而提供演艺资源的制片方、投资方以及媒体平台，又因流量明星的参与而收割商业利益，当然，这其中更少不了购买数据用以打榜、投票、转发的过程。无奈的是，这已成为市场优胜劣汰的“规则”，如果粉丝的偶像数据不好，就会被其他艺人的粉丝“唱衰”。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	由此可以看出，流量经济是一个参与方都可获得经济效益的模式，这也决定了很难从内部去戳破流量泡沫。但如今政策导向下，很有可能从外部强制性切断数据造假产业链，若是如此，会对以流量为基础的粉丝经济造成什么伤害？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	我们可以逆向推断，假使数据归真，流量明星及其所产出的内容，在市场的反应能够一目了然，首先最可能放弃他们的就是内容生产方。因为对比靠实力说话的演员，流量明星原本与之天差地别的流量优势，很大程度上被削弱了，而今口碑反噬又日渐严重，制片人也不再经得起多次的扑街。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	相应地，流量明星的演艺资源一旦被缩减，曝光度大大降低，广告商、媒体以及平台很快便“闻风而动”。更关键的是，明星本人新粉难增、旧粉流失，长此以往就更没有商业价值了。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	流量经济还是粉丝经济？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	当娱乐产业的优胜劣汰逐渐被流量所左右，如果从流量数据本身出发，一定程度上是可以约束某些行业乱象的滋生。但是流量缩减、粉丝仍在。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	蔡徐坤被央视点名时，震慑是对业内的，粉丝看似不惧。真爱粉们一面为爱豆打抱不平，力挺蔡徐坤确实是个专注音乐的好歌手，甚至表示之前做了那么多公益怎么不提？另一面又将攻击点集中到微博上，强烈要求整改。不过，前者是顾左右而言他，后面则是祸水东引，实则都没什么逻辑。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	从这件事直观地看，粉丝本身就是流量的一部分，即使最大程度地将流量数据脱水，蔡徐坤、鹿晗这类当前比较符合年轻群体审美的明星，也仍有不在少数的粉丝存留，他们才是饭圈的核心。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	换句话说，粉丝即使不花钱为他们的偶像刷流量，他们还是有其它方式向外界传达和证明自家爱豆的价值，甚至可以简单的说，只要粉丝愿意为爱豆花钱，在制片人和品牌方眼里，明星便有商业价值。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	这主要是因为当前的影视行业中，<strong>粉丝看似处于被收割的产业下游，实则主导着偶像的人气和商业吸引力。</strong> \r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\"> <strong>一方面，粉丝已经参与到偶像的职业规划中，用自己的力量为偶像争取好资源。</strong>而市场也认可了这种做法，现在广告商、制片方最看重的，不再是明星的业务水平，而是背后的粉丝力量。所以，纵然市场能抛开流量数据，演员和明星粉丝群体的差别，也无法使商业资源偏向前者。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\"> <strong>另一方面，如今流量明星的粉丝展现出强大而可怖的集体力量，如果不再允许数据造假，他们对舆论的影响也能帮助明星维持流量再造。</strong>极端一点，像粉丝骂战、撕逼这种普遍现象，一经推手，在当前这个碎片化时代便是天然的流量爆发点。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	所以，<strong>数据打假所能纠正的也只是流量经济，而触及不到更深层次的粉丝经济。</strong> \r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	时至今日，粉丝和流量的先后产生顺序已经模糊，这就是数据造假导致的，不过粉丝是基础，流量经济可以说是在资本介入、疯狂膜拜粉丝效应之后被放大的形态。这和移动互联网时代流量为王的思维，实则异曲同工。不过移动互联网进入下半场的服务升级，娱乐产业的流量经济反而日渐衰颓了。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	明星“死于”粉丝？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\"> <strong>围绕粉丝和明星的行业规则及利益链一旦形成，实际上就连一个环节的整治都很难，更不要指望其内部会自我改进。</strong>但值得庆幸的是，当前流量经济之所以逐渐露出真相，在于其外部的反对力量日益强大，也催促市场形成一套新的淘汰法则。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	最明显的是电影界，流量明星的多番试水，让投资方再也经不起折腾。2016年“小鲜肉+大IP”的模式备受追捧，2017年参与暑期档大战的流量明星只有杨洋、李易峰两人，而到2018年暑期档、春节档，杨洋、鹿晗等人早已不见踪影。李易峰的《动物世界》即使备受肯定，票房仍不能回本。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	数据显示，2018年全国电影票房已经超过2017年总票房559.11亿元，创下新纪录，但票房前十的影片主演中均不见小鲜肉身影。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	流量明星开始被排斥在大荧幕之外，而且他们在业内留下的印象一旦被定性，投资人只会对他们避之不及。而下一个排斥流量的便是观众，这很容易让流量明星丧失转型的时机，甚至是永久被划在攻击的范围之内。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	这是口碑反噬的副作用，比如《创业时代》开播之初，很多人还没看剧，只知道有杨颖主演便给出了一星评价，迪丽热巴则一个人把《声临其境》的评分拉到了4.3。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	一个经典角色可以成就一个明星，但一个明星也有可能毁了众多角色，观众便将不满全部发泄到流量明星身上，反而不会再客观考虑是不是剧本、导演不行。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	不过作品口碑败光的更多是路人缘，而且市场通过这种副作用反噬的方式淘汰流量明星，毕竟是一个相对缓慢的过程。关键是，他们背后的死忠粉依然是“东山再起”的资本。<strong>所以一个流量明星的消失或死亡，完全取决于粉丝。</strong> \r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	事实也是如此，我们看到，<strong>人设崩塌是最近常见的最快导致明星坠落的方式，而人设本质就是为迎合粉丝存在。</strong>粉丝心理假说认为，追星一种身份认同，粉丝通过对名人的“镜像”认识自己，塑造价值观，而一旦粉丝发现这种“镜像”是虚假的，认同感瞬间就消失了，而且会有上当受骗的感觉。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	当然，粉丝也是善变的，他们自然而然流失，流量明星们也就被市场抛弃了。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\"> <strong>流量数据的虚假泡沫被戳破总归是好的，但娱乐行业的乱象却无法根治，终究是粉丝把明星捧得太高了。</strong> \r\n	</p>',	'doc.png',	1.00,	20,	0,	0,	0,	'2019-12-03 14:20:16',	'admin',	3,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	1.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	4,	1,	0,	1),
(57,	'有人追求外国豪车 他们却宁愿为中国品牌排队等仨月',	'<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	你可能不知道咪蒙，但却一定知道她有一个月薪5万的助理。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	年初，在“寒门状元”事件之后，咪蒙就曾宣布关停微信公众号两个月，并永久关停微博。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	不想仅仅过了不到一个月，2月21日咪蒙以及旗下“才华有限青年”等微信账号就宣布将被永久关停。旗下美妆账号改名为“李粒粒LiLiLi”，咪蒙小号“好疼的咪蒙”则清空了所有内容。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	从咪蒙公布之前公布的报价来看，其微信公众号头条广告报价一度到达80万元，二条也有40万元。这次的账号注销还包括今日头条、凤凰号等等，并称咪蒙“不得转世”。咪蒙的商业帝国几乎被连根拔起。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	除了自媒体，同时可能就此终结的还有咪蒙刚刚开始的编剧生涯。2018年3月，柠萌影业曾经宣布，由咪蒙担任编剧的网剧《长大成人》正在筹备中。现在咪蒙被封，这部“神似”《欢乐颂》的作品最终何去何从也被画上了问号。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\"> <strong>“毒鸡汤女权”，这不只是咪蒙的专利</strong> \r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	正如我们上文所说，咪蒙还在积极谋求走向影视圈，成为编剧便是第一部。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	了解咪蒙的人都知道，咪蒙的文章一向以宣扬所谓“女权”为导向，用一碗一碗的鸡汤，挑动着公号中近600万女性粉丝的内心。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	作为一个影视的门外汉，咪蒙之所以开始进军影视当编剧，其实和中国影视，特别是网台剧当中 “大女主”等题材层出不穷有着直接关系。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	从《欢乐颂》里的五个姐妹，到《我的前半生》里的罗子君，从楚乔到关皮皮，不一而足。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	然而，在这些所谓的“大女主”或者“女权”剧却很少体现真正的女权，而或多或少的会体现出“咪蒙式女权”的感觉。 男一都会对我不离不弃，男二都会生死相依，男三都会“我的眼里只有你的桥段大行其道，靠男人上位的情节也充斥其中，女权成为了寄居在男权上的笑话。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	再有，许多职业剧也会加入大量爱情桥段，“谈判官”改谈恋爱，“猎头”改“猎对象”的情况也多次发生。这也正如咪蒙的风格，看似让人“自强不息”，实则只想让你成为“坐在宝马里笑的人”；看似是在不断激励，实际只是找准了观众的七寸，然后一颗颗的吃下早预备好的“致幻药丸”。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	但这样的剧情虽然满足了女性观众对于爱情内容的需要的同时，本身也局限了内容的发展。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	首先，这样的剧所有内容几乎都必须围绕爱情展开，亲情、职场、宫斗、武侠等本应该更重要的戏份反而成了陪衬。由此，很多所谓的职场剧、宫斗剧到头来都变成了无限尴尬的爱情剧。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	更重要的是，“咪蒙式的女权剧”并不是真正的男女平权，当女性意识进一步觉醒之后，就会开始逐渐摒弃这种价值观。正如《致橡树》中所说，“我如果爱你，绝不学攀援的凌霄花”。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	再次，随着90后以及更年轻观众的崛起，单身才是社会更加主流的形态。生活方式的改变也会影响大家对于影视剧的观看喜好。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	更进一步说，“大女主”实际上是披着女性思维的外衣，但实际上却站在男性立场的表现。女性是白莲花、傻白甜，需要靠男性，甚至众多男性实现目的，这其实是一种变向的“被包养”。托名女权，实际宣扬的却是一种并不合理的价值观。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	咪蒙已经悄然落幕，但“伪女权”却依然大量存在于影视剧之中。但随着品质口碑成为了市场主流，真正的女权影视剧登上舞台恐怕也不会太远了。\r\n</p>',	'doc.png',	1.00,	19,	0,	0,	0,	'2019-12-03 14:21:05',	'admin',	10,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	1.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	4,	1,	0,	1),
(58,	'美军车队在阿富汗遭遇汽车炸弹袭击',	'<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	短视频行业的发展无疑已经进入到了深水区，以短视频变现为代表的全新发展正在把这个行业越来越多地放到了市场的前台。作为一种全新的内容表现形式，短视频在经历了资本乱战、巨头追捧之后，或许应该进入这个“年纪”。然而，变现并非易事，短视频变现更是难上加难。如果能够走出短视频变现的考验的泥淖，这个行业的发展无疑将会发展成熟。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	当然，如果仅仅只是一味地追求变现，而不去深究短视频本身的内在运行逻辑。所谓的短视频变现同样会陷入困境，火爆的短视频行业将会如同火爆的流量一样陷入表面的繁华。的确，几乎所有的商业模式都应该形成一个生态闭环，才能称得上是一个成熟的商业模式。如果仅仅只是停留在某个阶段的繁荣，所谓的商业模式仅仅只是一个概念，无法真正落地。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	我们看到当前以抖音、快手为代表的短视频行业巨头都在进行变现层面的探索，无论是社交，还是电商，对于短视频背后更加深层次的商业层面的探索正在成为一种发展的主流。不可否认的是，尽管短视频变现进行得如火如荼，但是依然逃不脱现实的尴尬，短视频行业的变现依然面临诸多挑战。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	从繁荣期到精耕期，短视频行业正在经历阵痛\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	作为一种在移动互联网时代的后半段崛起的内容表现形式，短视频行业的发展无疑备受追捧。无论是资本还是巨头，对于这种新式的内容展现形式都充满了好奇与期待。融资数额的不断增加、融资速度的不断加快都在说明市场对于短视频行业偏好程度。尽管短视频行业从一开始就被互联网巨头所青睐，但是，它的发展依然要经历所有的事物都会经历的阶段。从资本吹捧的繁荣期到商业变现的精耕期，短视频行业的发展无疑正在经历一次全新的阵痛。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	火爆的背后是短视频行业远离商业本质的尴尬。几乎所有的人都知道，短视频行业的发展一直都是一路高歌，无论是从用户获取上，还是用户日常的表现数据上，短视频行业的发展都是相当夺目耀眼。尽管短视频行业看上去异常火爆，但是火爆的背后却是变现困难的尴尬。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	从始至终短视频行业都在扮演着一种流量导流的角色，通过短视频将流量聚集在一起，再通过流量下沉到电商、社群等其他领域，从而实现真正意义上的变现。其实，从流量获取到流量导入已经有了许多的用户流失，再把这些流量落地到具体产品上又会有更多的流量流失。因此，仅仅只是将短视频看成是一个流量导入的工具，而不去从短视频本身着手，直接进行变现正在让短视频行业的发展陷入一种尴尬的境地里。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	当我们看到短视频平台动辄几亿的用户流量的时候，其实无法真正掩盖现实的尴尬。一味地看中短视频本身的流量价值，而忽略了更多新的探索，短视频行业正在陷入一场远离商业本质的尴尬。在流量红利已经见顶的大背景下，一味地去强调短视频行业的流量作用，无疑是一次与现实的抵抗。在流量已经被证明是一种无效资源的大背景下，短视频行业盲目地加大自身在流量上的作用，无疑是一场冒险。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	依附于巨头的怀抱让短视频缺少对于商业世界的认知。作为一种全新的内容展现形式，短视频行业从一开始就依附于互联网巨头。无论是资本投资，还是平台建设上，短视频始终都缺少自己独特的运行模式。虽然以互联网巨头作为靠山能够缓解在竞争激烈的市场当中沦陷的概率，但是如果仅仅只是一味地停留在巨头怀抱的温暖里，不去面对商业世界的残酷，短视频行业依然备受挑战。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	依附于巨头的怀抱，短视频行业仅仅只是一个内容层面的东西，它仅仅只是巨头的附庸，无法真正承担起自我寻找商业价值的重任。当巨头不再加持短视频行业的时候，它同样需要走入市场里，而不是一味地承担一个支撑者的角色。依附于互联网巨头的怀抱，短视频行业仅仅只是停留在表面繁荣的自嗨当中，不断增长的用后数据、不断增长的点赞数量、不断增加的用户浏览时长都让短视频行业感觉到自己是移动互联网后半段的王者。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	作为一种全新的内容展示形式，短视频始终都是一种内容。如果我们仅仅只是停留在巨头光环下的数据自嗨，而不去真正了解这些数据背后的真正原因。那么，当短视频行业真正进入到市场的时候，一切或许都将重新开始。当前，短视频行业正在经历的正是这样一个阶段。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	以内容为根本的短视频却无法具备内容的本质与意义。虽然短视频行业异常火爆，但是我们始终都不能忘记短视频始终都是一种内容表现形式。既然是一种内容，短视频行业从野蛮生长到精耕细作是一个必然的过程。在经历了几年的发展之后，我们却没有看到短视频行业的内容有显著提升的地方，有的仅仅只是在一些营销层面的小打小闹。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	当短视频在内容进化上出现瓶颈的时候，我们就去做商业变现上的相关尝试无疑将会把这个行业的问题和弊端全部都呈现在外面。作为一种内容展现形式，短视频行业在内容本身上缺少精耕细作和突破创新，只会把短视频行业的发展带入到一种相对艰难的境地里。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	我们看到现在的短视频的内容上依然缺少精细化的痕迹，有的仅仅只是千篇一律的雷同抑或是内容展现形式的俗套。如果仅仅只是把短视频行业仅仅停留在一种毫无进化的层面上，特别了缺少了作为内容本身所应该具备的特质，那么所谓的短视频必然将会失去原有的本质与意义。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在经历了早期的野蛮生长、资本助推、巨头拥抱等一系列的发展之后，短视频行业的发展正在经历一场前所未有的平静期。这从另外一个角度说明短视频行业的发展并未真正跳出原有的发展套路，仅仅只是将互联网式的发展模式在极致上更进一步。突破短视频行业的发展困境，需要真正让短视频告别自嗨式的繁荣，真正回归内容本身，真正进入到商业世界的现实中历练。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	进入下半场的深水区，短视频的彷徨与退让\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在告别了资本的加持之后，短视频行业的发展正在进入到下半场的深水区。早期的顺风顺水让短视频行业的发展难以抵挡现实的尴尬，一味地停留在数字上的繁荣，而忽略了内容本身的本质奥义，短视频行业的下半场无疑将会经历一场前所未有的彷徨与退让。但是，这并非是一件坏事，通过这种方式，我们增加能够知道短视频本质的东西是什么。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	短视频的彷徨：巨头扶持还是独立行走。短视频从诞生的那一天开始就始终没有摆脱巨头的光环，从某种意义上来讲是互联网巨头最终造就了短视频行业的今天。然而，一味地躲在互联网巨头建构的舒适区里，不去进行商业层面上的探索，所谓的短视频只会在自嗨的道路上越走越远。告别巨头的保护，真正进入到市场当中摸爬滚打，从而获得更多的生存技能或许对于短视频来讲至关重要。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	然而，如果摆脱互联网巨头的怀抱，短视频又很难在短时间内找到一条合适的路，对于处于变现关键期的短视频行业来讲，无疑是一个非常巨大的挑战。始终蜷曲在巨头的怀抱，毕竟不是一件长远的事情，短视频行业的真正未来依然在于本身的发展上。从这个逻辑来看，脱离巨头的怀抱，选择独立行走显然是一件非常明智的事情。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	可喜的是，深度参与到短视频行业发展中的人们早已明白了这其中的意义，我们看到以抖音、快手为代表的短视频平台开始更多地寻找基于自身优势和特色的发展道路，抖音做社交，快手做电商就是这一趋势的直接体现。尽管当下的发展态势不甚明朗，但是只要能够找到一条真正适合自己的发展道路，短视频行业的发展便会真正能够独立。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	短视频的退让：坚守流量还是回归商业。从当下的发展情况来看，短视频真正吸引人的地方还是它裹挟流量的能力。投资机构和互联网巨头之所以不断加持短视频行业的重要一点同样是因为短视频本身能够在获取流量的成本日渐高企的时刻依然能够持续获得源源不断的流量。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	然而，虽然流量给短视频赢得了鲜花和掌声，但是流量的变现依然是横在短视频头上的达摩克利斯之剑。谈及流量变现就必然要回归到商业本身，如果仅仅只是在流量的海洋里进行无谓的自嗨，所谓的短视频只能是一个充满了美妙幻想的乌托邦，无法真正实现真正意义上的落地。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	是坚守流量还是回归商业，或许在残酷的商业面前，短视频行业将会最终退让，真正演变成为以商业为主导的存在。尽管这个过程会略显艰难，但是这才算是真正回归到了商业本身，而非仅仅只是沉醉在流量的理想国里。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	当短视频市场的繁华落尽，回归商业本质或许是当下正道。告别表面的虚假逻辑，真正把短视频行业的发展落地到具体的商业上，探索一条真正适合商业本质的发展道路，或许才是真正能够推动短视频行业发展正道所在。从这个逻辑上来看，当下短视频行业正在经历的这场彷徨与退让或许更像是在积蓄继续前行的能量。\r\n</p>',	'doc.png',	1.00,	38,	0,	0,	0,	'2019-12-03 14:21:49',	'admin',	14,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	1.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	14,	1,	0,	1),
(59,	'美总统弹劾案：参院多数党领袖提议快速审判',	'<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	发展会掩盖一切问题，直到狂奔的脚步停下。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	2月15日，滴滴CEO程维对外表示，公司将做好过冬准备，并将对非主业进行“关停并转”，对业务重组带来的岗位重叠和绩效不达标的员工进行减员，整体裁员比例占到全员的15%，将涉及2000人左右。此外，从2012年创业以来一直处于亏损状态的滴滴，2018年仍然亏损，全年亏损总额高达109亿元，其中，补贴司机超过113亿元。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在收购优步中国以后，滴滴在网约车市场一家独大，市场占有率近九成；滴滴是全球融资额最大的未上市公司，一向“不差钱”；滴滴对每笔业务都会收取20%左右的抽成(Take Rate)，这也经常成为网约车司机抱怨甚至炮轰的对象……感觉“躺着就能把钱赚了”的滴滴，为何会如此巨亏？司机喊着不赚钱、平台又巨亏，网约车的问题究竟出在哪里？还有能走得通的商业模式吗？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	成立7年，融资20次，\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	融资额200亿美元\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	和其他公司多是被爆出后被迫承认窘境，或者裁员时只肯使用“优化、调整、末位淘汰”等字眼不同，滴滴主动“官宣”了巨亏和裁员的消息，数字还如此巨大。“地主家也没有余粮了？”“富家子都开始哭穷了？”社交媒体上一时哗然，有人唏嘘，有人不解。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在去年8月滴滴顺风车事件之后，程维也曾对外透露过一次滴滴的财务数据，他表示滴滴成立6年来，还没有实现过盈利，仅仅2018年上半年，公司的整体净亏损就超过40亿元人民币。滴滴出行业务对应的GMV(总交易额)平均Take Rate(抽成率)约为16%，但绝大部分作为补贴和红包返还给了司机和乘客，公司整体对应的GMV毛利率只有1.6%。他还透露，仅2018年上半年，包括司机高峰期补贴、接单和服务奖励、乘客优惠等在内的总补贴返还金额超过117亿元人民币。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	2017年，滴滴也曾透露过补贴总额，高达181亿元(包括司机端和乘客端)。但一些被媒体广泛引用、滴滴官方从未确认也从未辟谣的数据显示，2017年滴滴全年亏损额只有25亿元。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	一位滴滴内部人士告诉《中国经济周刊》记者：“公司虽然巨亏，但现在现金流应该是没问题的。即使一部分员工会面临被裁员，但公司给的补偿方案还是比较厚道的。说滴滴会成为下一个ofo那是不太可能的。”\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	据天眼查的统计数据显示，滴滴自2012年成立以来，截至目前已经完成了20次融资，金额总量超过200亿美元，是全球融资额最大的未上市公司。滴滴的估值也一度高达800亿美金，也是最快达到这个量级的独角兽公司。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	但这只独角兽也甚是烧钱。由于滴滴还不是上市公司，财务数据并不需要全部公开，但根据滴滴已公开的数据统计，滴滴6年来累计亏损额高达近390亿元。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	但上述人士也表示：“在2018年以前，利润和成本在滴滴确实不是重要的考核指标，市场占有率、日单量、用户数量、司机数量……这些才是关注的重点。但2018年开始，公司希望能够在年底冲刺整体盈利，至少实现‘微盈利’，所以对各个业务线也都提出了这样的要求。”\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	其实，这种变化也并不奇怪，因为彼时市场传闻，滴滴将会在2019年下半年实现IPO。但之后由于众所周知的原因，滴滴没能赶上这波上市热潮。“顺风车事件”背后的安全问题让滴滴停下了6年来一路狂奔的脚步。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	一年补贴113亿元，\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	司机感受到了吗？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	补贴仿佛是成就滴滴、也榨干滴滴的一道旋转门，补贴的打法让滴滴熬死了几乎所有竞争对手，并从尸骨堆中走出来，成为今天的滴滴；但现在，补贴似乎也正在熬干滴滴自己。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	与109亿元这个2018年滴滴全年亏损总额一同出现的还有一个数据：2018年滴滴补贴司机超过113亿元，这很容易让人认为两个数字之间有因果关系。但巨额亏损就是源于对司机的补贴吗？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	北京大学市场与网络经济研究中心研究员陈永伟对《中国经济周刊》分析认为，滴滴的亏损应该主要来自为了赢得用户信任和适应更强监管而付出的合规成本。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	陈永伟认为，滴滴的持续亏损主要有两方面的原因。“一是由滴滴本身的战略决定的，它的战略是先占有市场，然后利用规模效应去消化市场。滴滴的主业务是规模报酬递增的，这也决定了滴滴先占市场的模式。二是去年突发事件引发了监管加强，这让滴滴遭受了空前的监管压力，合规成本是巨大的，比如要求司机户口、车辆的轴距大小等。”他说。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	记者采访了几位滴滴司机，他们均表示，并没有觉得去年滴滴对司机的补贴突然增加了。一位滴滴“老司机”告诉记者，不同的司机能够拿到的补贴数量可能差别非常大。因为要想获得比较高的补贴收入并不容易，比如要在线时间长，至少10小时，这意味一定要是全职司机，身体要好还不能怕辛苦；再比如要在高峰时段多接单，也要多接受滴滴的派单，“这些活儿很多是根本不赚钱的，不给补贴，根本不会有人接。”他说。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在乘客端，很多人的感受则是：滴滴的车费越来越贵，但叫车却越来越难。记者对比了市场上最大的几家网约车公司的价格，以北京为例，相同时段和目的地，同档次车型，滴滴快车价格最低，其次是出租车价格，但两者差距已经不大了，相对最高的是易到易达车型的价格。而对于高端车型，滴滴礼橙专车也是最低的，其次是神州专车，首汽约车的价格则更高一些。这些高端车型的价格要高出普通车型50%左右。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在客户竞争层面，网约车平台的竞争无外乎两件事：价格和能否叫到车。而网约车平台要克服的最大难题就是高峰低谷时段的需求差异和城市潮汐效应的供给矛盾。因此，从逻辑上，网约车平台确实需要依赖补贴来调节运力，鼓励高峰时段有更多兼职司机补充运力，鼓励司机反潮汐增加热门地区的运力供给。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	根据中国信息通信研究院政策与经济研究所的调查显示，截至2018年7月，全国合规网约车数量约为17万辆，只占到总量的0.54%，而合规司机数量约为34万，只能占到司机总量的1.1%。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	据滴滴方面介绍，随着各地网约车新政的落地和执行越来越严格，运力不足问题日趋严重。而顺风车下线之后，兼职的网约车司机也大量减少。因此，滴滴为了吸引更多“合规”司机加入，以及运营中调整运力，不断出手补贴。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	滴滴收购ofo的可能性更小了\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	除了裁员，滴滴宣布要“关停并转”非主业的消息也引发了广泛的关注。到底哪些业务是滴滴的“非主业”，截至记者发稿，滴滴官方并未给出回应。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	一位滴滴前高管对《中国经济周刊》分析，对于滴滴“非主业”，很多人会首先想到外卖、酒旅、票务等“创新业务”，这确实可能是此次调整的重点，但应该还至于此，因为这些业务不足以涉及到2000人。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	据记者了解，2018年底，滴滴进行过一次架构调整。调整后，滴滴的主要业务被划为几大板块：网约车平台公司(快车、专车、豪华车事业部)、车主服务公司(小桔车服公司、汽车资产管理中心)、普惠出行与服务事业群(单车、电单车、公交、代驾、企业级业务)、出租车事业部、战略业务事业部(战略部、国际事业部、金融事业部)等。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	上述高管认为，普惠出行与服务事业群的业务也有可能被重点调整，“滴滴再去收购ofo的可能性更小了”。而国际业务和金融业务则会影响不大。“网约车这个生意受政策环境影响太大了，国际化等于给滴滴多设立几个backup，这边不亮可以那边亮，滴滴已经有完整完善的网约车技术和运营解决方案，在各国复制并不难。”他说。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	实际上，滴滴已经通过收购、投资本地出行平台的方式将业务拓展到东南亚、东欧、非洲、巴西、日本、美国、墨西哥、澳大利亚……程维也透露，安全技术、产品和线下司机管理及国际化等是滴滴未来的重点领域。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	陈永伟的看法是，滴滴确实涉足了不少并没有规模效应的行业，如果没有顺风车危机，可能也不会对滴滴带来太大的影响。但在严监管之下，安全合规成本大增，滴滴的顺风车业务还干脆就没了，这也带来商业损失。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	网约车也有赢利的商业模式\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	滴滴这头其实已经达到巨头规模的超级独角兽，至今仍未找到清晰的盈利模式。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	滴滴的设想是希望通过平台聚集大量用户，然后靠打造“出行生态”提供增值服务获得盈利。就像淘宝和微信，用户都可以免费使用，但同样可以赚得盆满钵满。于是，滴滴进行了很多尝试：做广告、做电商、做游戏、卖保险、卖理财、做金融……但这条路，至少现在，滴滴还并没有走通。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	但这并没有影响新选手们的热情。除了神州优车、易到、首汽约车等老运动员，2018年以来，美团、高德、携程、同程、嘀嗒、哈罗等都开始前赴后继地加入网约车混战，希望从滴滴的版图上咬下一块。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	此外，上汽、吉利、大众等在内的主机厂都已经进军网约车市场，宝马也成为首家在中国拿到网约车牌照的跨国品牌，赛道那端虽然通向哪里还不知道，但赛道仍然拥挤。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	虽然滴滴的日子不好过，易到更是彻底凉了，但行业内也有日子过得不错的玩家。比如神州优车，虽然此前也一直亏损，但到2017年，神州优车的亏损已大幅收窄了92.7%，仅亏损2.6亿元。而其2018年经营，截止到当年前三季度，神州优车营收达49.2亿元，利润总额2.8亿元，较上年同期增长149%，已经实现了4个季度的持续盈利。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“这其实也说明了网约车本身没问题，是有商业模式可以走得通的。不过行业发展还是需要政策支持。”陈永伟表示\r\n</p>',	'doc.png',	1.00,	30,	0,	0,	0,	'2019-12-03 14:22:37',	'admin',	26,	1,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	1.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	12,	1,	0,	1),
(60,	'大众最新MPV对标GL8 国产钢炮标杆 实拍领克03',	'<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	2015年，随着抢眼的小黄车突现北大校园，共享单车的概念迅速被普及，玩家接连冒头，巨额投资不断涌入，和高铁、移动支付、网购齐名<strong>“新四大发明”</strong>。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	热潮来得快，去得更快。今年，共享单车就进入了寒冬。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	4月，<strong>摩拜单车委身美团；小黄车ofo也节节败退，危机重重</strong>：海外业务全面收缩，并推出了多种激进的变现手段：公众号推送广告，将用户的押金与理财产品绑定，一再延迟押金退还期限。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	去年还大把烧钱的共享单车，转眼就凉凉了。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	共享单车出海遇阻，基础建设和政策规范是难以忽略的两大阻力。除了中国，世界上很难找到一个足够大的市场来支撑共享单车的盈利模式。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	但印度的创业者似乎有不同想法。<strong>从2017年开始，有近十年共享单车公司陆续出现，并先后拿到融资。</strong> \r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	班加罗尔的Yulu向Blume Ventures等投资者筹得资金，还获得Flipkart联合创始人Binny Bansal和谷歌前副总裁Amit Singhal的支持；另一家公司Bounce从红杉印度等投资者那里拿到了了总计1520万美元的资金；总部位于古尔冈的Mobycy去年12月也筹集了50万美元的种子资金。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\"> <strong>印度的共享单车市场正生机勃勃。</strong> \r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\"> <strong>融资热潮</strong> \r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	Amit Gupta是印度第一家独角兽Inmobi的联合创始人。在他创业十年、担任总裁级别职务的时候，他选择了急流勇退，<strong>创办了另一家公司，Yulu单车</strong>。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在班加罗尔地铁站和商务CBD附近，亮蓝色的Yulu单车随处可见。Amit告诉\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	志象网\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	，做共享单车，是为了<strong>“间接降低污染”</strong>。他出生和长大在印度北部的小城坎普尔，在今年6月被世界卫生组织盖章“全球污染最严重城市”，谈起家乡，他显得情绪激动。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	Yulu单车在前半个小时仅收费10卢比<strong>（约一元）</strong>，之后每半小时多收5卢比。用户下载Yulu应用扫码开车，结束骑行之后，需要将车子停放在离目的地最近的停车区。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	业内人士估计，印度的共享单车市场目前规模达12亿美元。<strong>主要的玩家除了Yulu，还有共享汽车公司Zoomca旗下的Pedl，Mobycy，Bounce和以及来自中国的摩拜单车。</strong> \r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“这个行业很有前景并且有利可图，Ola和Uber的成功证明了交通出行跟手机有可能同步发展。”Blume Ventures的投资人Sajith Pai对志象网说。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	最近入局的玩家是<strong>从踏板车共享起家的Bounce</strong>。今年6月，ofo退出印度市场，Bounce最近宣布收购了它在印度的资产。在收购之前，Bounce在就班加罗尔投放了500辆踏板车。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“从公交站或地铁站到办公室和家里的最后一英里的交通非常令人头疼，没有任何三轮车或出租车愿意走这么短的距离。”Bounce联合创始人Vivekananda HR告诉志象网。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“我们从ofo手中收购的自行车也将加入试点。”他说，45到60天内Bounce的应用将支持扫码使用单车。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	印度创业者从中国公司继承的，不仅是败局留下的遗产，还有先见之明的运营管理教训。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在浦那和班加罗尔，小蓝车Yulu和小绿车Pedl随处可见。一开始，用户可以把车停在任何地方，甚至是在路中间，引起了交通失序。Yulu不得已派出团队去搬运自行车并停放在适当的地方。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	这样一来，成本太高难以为继，Yulu吸取了教训，开始联合Pedl与当地政府合作，规划指定的停车区域。在班加罗尔，这样的停车区现在有500个，在全部的4个城市总数超过1000个。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\"> <strong>纠结的用户体验</strong> \r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	但也有的问题无法靠“继承”来解决，<strong>比如技术和运营失误</strong>。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在印度，<strong>共享单车的用户体验仍有待改善</strong>。志象网记者的亲身体验以及和其他用户交流后发现，包括刹车失灵、智能锁失灵、轮胎漏气等现象并不少见，而且停车区的分布也不够密集，有时候用户甚至需要在锁车之后再走一公里到目的地。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	Vivek Kumar是一名22岁的软件工程师，他最近刚从德里搬到了班加罗尔。刚到班加罗尔时，他一直骑着共享单车穿梭在城市中参加面试。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	一次去面试的路上，他发现单车的链条断了，这就十分尴尬了：他必须得先把车子停到指定的停车区域，否则软件会一直计费。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“我不得不把车子推到500米外的Pedl停车站，在锁这个坏车的时候又花了好多时间。”Kumar告诉志象网。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	但事实上，Yulu和Pedl也都有专人在维护单车，每隔四天维护一次，从而保持单车的良好运行状态。但Amit说，当公司进入一个区域时，维护的情况会不太稳定，“因为当地业务还没有完全稳定。”\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“在那些旧的区域，你会发现我们的自行车状况良好，大多数都能够很好运行。最近我们在电子城附近布局，那里聚集了一批大型IT公司，比如Infosys、Wipro等。我们需要四到六周的时间来完成布局。”Amit说。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	但相较中国，<strong>印度的交通基础设施普遍落后，这也给共享单车埋了一颗暗雷</strong>。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在印度，没有几个城市设置了自行车道；不像中国，骑行已经发展为一种健康、前卫的生活方式，印度的自行车还往往被视为穷人的通勤方式。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“我们之所以进入共享单车行业，是因为我们想成为一家多渠道出行平台。城市交通一直是政府和公民共同面临的挑战，我们希望能够大规模地解决这一问题并帮助完善基础设施建设。”Pedl运营增长部门负责人Rakshak N说。\r\n	</p>',	'doc.png',	0.00,	25,	0,	0,	1,	'2019-11-26 09:37:47',	'admin',	119,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	0.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	10,	1,	0,	1),
(61,	'探访世界最深地下高铁站:全部中国自主知识产权',	'<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	互联网瞬息即变，互联网上的热点也是转变地相当的快，一个热点可能过了几天就不再有人关注了。这对于想凭借互联网走红的人或物来说，显然要付出更多的心血来维持热度。那么，各个引流渠道显然都在他们的考虑范围之内。对于商家而言，在互联网进行引流的最终目的不外乎都是卖货变现。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	因此，一些比较重要的引流渠道，都少不了商家们的身影；比如，。抖音作为2019年的平台，有着3.2亿日活跃用户，属于是自带。如今，抖音与微信、微博等巨大流量池并称，绝对是商家不容错过的流量池。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	商家在抖音平台上发布内容之后，就能通过发布内容来吸引用户前来关注，并进一步转化为粉丝，这样就能更方便商家引流变现。在抖音只能是通过发布优质内容来吸引用户关注，因为抖音采用的是智能社交推荐机制，只要发布的视频内容有趣，也可以获得大量的曝光。这就决定了粗制滥造的视频所获得的曝光量很少。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;text-align:center;\"=\"\"> <img src=\"http://demoall.adashuo.com/20090/uploads/allimg/c191107/15I0c2FD630-1E14.jpg\" width=\"450\" height=\"270\" border=\"0\" alt=\"抖音多闪培训：如何通过抖音进行带货-第1张图片-小七抖音培训\" title=\"抖音多闪培训：如何通过抖音进行带货-第1张图片-小七抖音培训\" style=\"height:270px;width:450px;\" /> \r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	因此，想要在抖音平台上获得大量的曝光，最简单的办法就是制作高质量的视频内容。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	拥有曝光，并不代表着是结束。恰恰相反，这只是开始，因为接下来的工作就是要引流变现了。目前，通过抖音引流的方式无非就只有这么几种：一是在视频内提及联系方式；二是在评论中回复；三是在私信回复等。但是，这几种引流方式都存在着被抖音删除、乃至封禁的风险。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	抖音多闪培训那么，到底有没有什么引流方式是没有风险的呢？或者换言之，有什么引流方式是抖音官方认可的呢？当然有!那就是抖音的电话拨打组件。这是抖音官方所推出的转化组件，经过设置就可以在抖音主页上展示，只要用户点击\"联系方式\"这个按钮就可以跳转至电话拨号界面，并显示相关号码，这无疑对商家引流变现提供了很大的便利。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	但比较遗憾的是，目前，这个功能并没有对所有的用户开放，只有认证了抖音企业蓝v号的用户才可以设置该功能。所以，商家如果是想开通\"电话拨打组件\"的功能，需要先开通抖音蓝v。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	抖音蓝v认证的申请流程如下：\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	第一，用需要认证蓝v的抖音账号登录抖音蓝v认证官网https://renzheng.douyin.com/。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	第二，填写企业认证公函，具体情况可以参考抖音官方的企业认证公函填写模板。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;text-align:center;\"=\"\"> <img src=\"http://demoall.adashuo.com/20090/uploads/allimg/c191107/15I0c2G0040-2J03.jpg\" width=\"450\" height=\"447\" border=\"0\" alt=\"抖音多闪培训：如何通过抖音进行带货-第2张图片-小七抖音培训\" title=\"抖音多闪培训：如何通过抖音进行带货-第2张图片-小七抖音培训\" style=\"height:447px;width:450px;\" /> \r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	第三，填写并提交认证资料，然后填写邀请码123456\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	第四，支付认证审核费用600元即可完成蓝v认证申请的提交。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	需要注意的是，抖音蓝v认证有部分禁入行业及需要额外提供认证资质证明的行业。禁入行业认证抖音蓝v将做认证失败处理。而需要额外提供认证资质证明的，如果碰巧没有，那么在提交认证申请后的30天内仍没有补充提交资质证明，也会当认证失败处理。而认证抖音蓝v失败，是不会进行退款的。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	认证抖音蓝v之后，除了可以获得电话拨打组件，还可以获得同步认证今日头条和、官网链接、商家页面、店铺POI地址、粉丝画像等蓝v权益。可以为天猫、淘宝、京东店铺以及线下店铺引流，构建企业商家的营销阵地，完成变现的目的。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;text-align:center;\"=\"\"> <img src=\"http://demoall.adashuo.com/20090/uploads/allimg/c191107/15I0c2G35440-31260.jpg\" width=\"450\" height=\"261\" border=\"0\" alt=\"抖音多闪培训：如何通过抖音进行带货-第3张图片-小七抖音培训\" title=\"抖音多闪培训：如何通过抖音进行带货-第3张图片-小七抖音培训\" style=\"height:261px;width:450px;\" /> \r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	抖音多闪培训因此，有意认证抖音蓝v的商家，最好是通过抖音蓝v认证代理商进行认证。\r\n</p>',	'doc.png',	0.00,	28,	0,	0,	0,	'2019-12-03 14:04:12',	'admin',	5,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	0.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	11,	1,	0,	1),
(62,	'美方将朝鲜驻沈阳总领事列入制裁名单 中方回应',	'<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	众所周知，2017年至2018年，的大和商业价值日益凸显，各大机构纷纷注资抢占短视频市场，作为短视频流量增速最快的APP，其运营模式和商业市场更是备受关注。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	大数据，帮你快速打造抖音爆款\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	抖音作为新媒体的新洼地，虽然流量又达到一个新的峰值，但是入场抖音仍然是可以。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	而想在抖音机制中脱颖而出，关注的焦点更倾向于生产抖音内容的速度和质量，以及如何持续生产高质量的抖音内容。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	对于运营抖音而言，此时入场抖音阵地，更需要把控时间成本和运营方法。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	结合抖音大数据工具——西瓜短视频助手，在内容层面，可以在6小时内寻找到抖音视频爆款素材，结合热门迅速掌握抖音平台爆款元素，从而有效提升抖音成本。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	在领域定位上，可以根据榜单快速规划的运营方向，结合行业粉丝画像信息，进一步完善垂直领域差异化内容布局。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	抖音进阶创作技巧，及商业运作模式\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;text-align:center;\"=\"\"> <img src=\"http://demoall.adashuo.com/20090/uploads/allimg/c191107/15I0c2AcO0-53929.jpg\" width=\"450\" height=\"303\" border=\"0\" alt=\"抖音小店：抖音运营怎么进行流量变现-第1张图片-小七抖音培训\" title=\"抖音小店：抖音运营怎么进行流量变现-第1张图片-小七抖音培训\" style=\"height:303px;width:450px;\" /> \r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	根据对MCN机构平台发展中遇到各种情况，给现场的运营者和MCN机构提出以下3个方面建议：\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	1.稳扎稳打才是抖音号的运营之道\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	面对网络上出现的买粉刷量的现象，建议运营者和机构千万不要尝试。这样的行为，不仅影响抖音号的权重，也让后续陷入无效价值中。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	2.快速孵化KOL矩阵离不开内容运营\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	抖音小店面对快速内容运营的有效方法，也给出一些信息流量的操作模式，在信息的展示上，可以扩大挖掘地域，可以引入外国小众优质的平台信息资源，将优质内容分类整理成“剧本”分发旗下艺人进行高效运作，提升视频输出效率。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	3.强强合作是商业运作成型的有效方法\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	相比知识付费，广告和电商是抖音目前最有效的转化之一。在广告投放上，同MCN专业机构合作，会更有效的提升个人抖音号的商业价值转化能力。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	如何高格局快速转战短视频领域构建生态链\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	如何一手打造“从内容生产-IP孵化-推广产业化”短视频生态蓝图？\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;text-align:center;\"=\"\"> <img src=\"http://demoall.adashuo.com/20090/uploads/allimg/c191107/15I0c2B323F-B363.jpg\" width=\"450\" height=\"307\" border=\"0\" alt=\"抖音小店：抖音运营怎么进行流量变现-第2张图片-小七抖音培训\" title=\"抖音小店：抖音运营怎么进行流量变现-第2张图片-小七抖音培训\" style=\"height:307px;width:450px;\" /> \r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	a.建立完善的孵化流程。在常规签约流程上，增加达人定位分析和视频测试环节（颜值/技能/学习），保障达人较高的素质水平。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	b.专注用户市场资源。在媒体领域商业形式取决于上游形态，运营的方向取决于市场用户的需求，只有想明白定位，才能做清楚你的市场。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	c.专业商业变现评估。需要对行业的天花板有一定认知，对不具有的抖音大号，可以根据粉丝画像的年龄层，选择不同的市场的推广模式。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	最后，规范机构的商业合作模式，才能快速有效构建自己的商业帝国。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	网红大咖粉丝运营之道\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	抖音IP的成长过程3个关键点：\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	1、找准平台：分析各个平台的商业价值和受众群体，有效预估平台的价值的上升空间。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;text-align:center;\"=\"\"> <img src=\"http://demoall.adashuo.com/20090/uploads/allimg/c191107/15I0c2BC510-L234.jpg\" width=\"450\" height=\"303\" border=\"0\" alt=\"抖音小店：抖音运营怎么进行流量变现-第3张图片-小七抖音培训\" title=\"抖音小店：抖音运营怎么进行流量变现-第3张图片-小七抖音培训\" style=\"height:303px;width:450px;\" /> \r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	2.优质内容：视频种类，视频的风格，人设的塑造，再到更高层次基调定位，都是优质内容的保障。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	3.抓准用户心理：内容的输出上需要抓取社会的认同感，有共鸣的内容通常都可以引发用户的依赖性，可以在内容上找到归属感。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	抖音小店其次，需要制造亲切感，打造个舒服是场景内容更容易获取用户关注。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	最后，就是从心理学的角度出发，恰到好处运粉丝的独纵心理和占便宜的心态。\r\n	</p>',	'doc.png',	1.00,	36,	0,	0,	0,	'2019-12-03 14:07:30',	'admin',	3,	5,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	1.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	13,	1,	0,	1),
(63,	'首个国产贝伐珠单抗生物类似药来了 药店新规推行',	'<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	带火了很多“爆款”产品，这些品牌和产品的销量大增，引得很多企业和品牌方们分外眼红。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	在这个为王的时代，早已成为了一个所有新媒体人无法避开的平台。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	抖音火遍大江南北，同时有无限的流量产生。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	大家撸粉的撸粉，变现的变现。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	但是现在越来越难了，\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;text-align:center;\"=\"\"> <img src=\"http://demoall.adashuo.com/20090/uploads/allimg/c191107/15I0c26340L0-1F53.jpg\" width=\"450\" height=\"198\" border=\"0\" alt=\"抖音运营团队：抖音运营思维攻略-第1张图片-小七抖音培训\" title=\"抖音运营团队：抖音运营思维攻略-第1张图片-小七抖音培训\" style=\"height:198px;width:450px;\" /> \r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	为什么？\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	竞争大呗！\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	团队拿到更好的权重才能有更多的曝光，才有上的机会。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	怎么拿到更多的曝光权重呢？\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	俗话说：知己知彼，百战不殆！\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	那我就先来了解一下抖音的排名算法是什么？\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	首先你要输出优质的内容，\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;text-align:center;\"=\"\"> <img src=\"http://demoall.adashuo.com/20090/uploads/allimg/c191107/15I0c263G60-26058.jpg\" width=\"450\" height=\"195\" border=\"0\" alt=\"抖音运营团队：抖音运营思维攻略-第2张图片-小七抖音培训\" title=\"抖音运营团队：抖音运营思维攻略-第2张图片-小七抖音培训\" style=\"height:195px;width:450px;\" /> \r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	关于内容今天就不讲了，本期讲的是抖音运营思维攻略。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	一、熟悉抖音\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	抖音运营团队熟悉抖音账号注册、认证、定位、布局、防封号/、最受欢迎内容等。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;text-align:center;\"=\"\"> <img src=\"http://demoall.adashuo.com/20090/uploads/allimg/c191107/15I0c26406150-31H2.jpg\" width=\"450\" height=\"266\" border=\"0\" alt=\"抖音运营团队：抖音运营思维攻略-第3张图片-小七抖音培训\" title=\"抖音运营团队：抖音运营思维攻略-第3张图片-小七抖音培训\" style=\"height:266px;width:450px;\" /> \r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	二、选题\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	1.选题的原则：关联性、热门性、新鲜感、人设感\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	2.选题来源：可从时事、同行火爆视频分析、段子、微博等渠道入手\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	3.拍摄及剧本套路\r\n</p>',	'doc.png',	1.00,	18,	0,	0,	0,	'2019-12-03 14:08:06',	'admin',	10,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	1.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	10,	1,	0,	1),
(64,	'美国11岁男孩长期遭祖父母虐待 烧伤送医后获救',	'<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	怎么在做？ &nbsp;借助商品橱窗和购物车，电商新物种——抖商蓬勃发展，但作为以算法推荐分发的平台，抖音缺少社交基因，那么抖音就注定与社交电商无缘吗？\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	社交对电商有何价值？\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	社交电商是相对于传统电商的概念——社交本身自带去中心化属性，由此延伸出来两个特征：裂变与私域流量。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	裂变来源于社交背后的人脉关系，不仅转化率远高于传统电商，更是能基于信任进行快速传播，也就是裂变获客；\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	而私域流量于商家不仅意味着跳出平台限制自主营销获客，私域流量还具有免费、优质、高黏性、可重复转化的属性。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;text-align:center;\"=\"\"> <img src=\"http://demoall.adashuo.com/20090/uploads/allimg/c191107/15I0c25W3510-551O.png\" width=\"450\" height=\"328\" border=\"0\" alt=\"抖商研习社：如何在抖音做社交电商？-第1张图片-小七抖音培训\" title=\"抖商研习社：如何在抖音做社交电商？-第1张图片-小七抖音培训\" style=\"height:328px;width:450px;\" /> \r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	抖音也能做社交电商吗？\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	1、社交土壤\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	抖商研习社需要指出的是，抖音虽然并非社交产品，但有人的地方就有社交——抖音好友与好友间、粉丝与红人间都有着浓厚的社交氛围，只不过抖音是以陌生人关系链组成的社交平台。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	同时抖音庞大且优质的用户群——以18-28年龄为主，多分布于一二线城市，且女性占比超过60%——配合内容的高传达效率，使得社交裂变有了肥沃的用户土壤。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	2、裂变载体\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	裂变的前提是有足够的用户基础——背靠抖音数亿活跃用户池，好的视频依托推荐算法，及话题、热榜、群聊等流量分发入口，能迅速成为爆款，进而触达更多潜在用户。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	裂变的关键在二次分享，而商品橱窗与购物车并没有相匹配的能力，这就需要借助抖音小程序了：除了可以驱动用户“”挂载小程序二次传播外，小程序的营销插件也自带裂变能力，进而打通裂变的闭环。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	怎么裂变起来？\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;text-align:center;\"=\"\"> <img src=\"http://demoall.adashuo.com/20090/uploads/allimg/c191107/15I0c2593MP-E412.png\" width=\"450\" height=\"331\" border=\"0\" alt=\"抖商研习社：如何在抖音做社交电商？-第2张图片-小七抖音培训\" title=\"抖商研习社：如何在抖音做社交电商？-第2张图片-小七抖音培训\" style=\"height:331px;width:450px;\" /> \r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	1、爆款视频引流\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	抖音卖货的基本逻辑是爆款短视频引流+小程序交易，而爆款视频主要取决于算法推荐，判定标准主要为完播率、点赞评论分享率等，与其辛苦摸索做视频，更便捷的方式则是通过与红人大V合作，以种草视频的方式引流。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	2、给用户裂变的动机\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	抖商研习社有了流量并形成转化后，还需要二次分享才能形成裂变，这就需要给用户一个分享“动机”，可以是折扣、优惠券、返现、赠礼等等，而小程序的营销插件如拼团、砍价、抽奖、分销等，则可以为商家提供裂变营销工具。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;text-align:center;\"=\"\"> <img src=\"http://demoall.adashuo.com/20090/uploads/allimg/c191107/15I0c25a5020-II2.png\" width=\"450\" height=\"319\" border=\"0\" alt=\"抖商研习社：如何在抖音做社交电商？-第3张图片-小七抖音培训\" title=\"抖商研习社：如何在抖音做社交电商？-第3张图片-小七抖音培训\" style=\"height:319px;width:450px;\" /> \r\n</p>',	'doc.png',	1.00,	27,	0,	0,	0,	'2019-12-03 14:08:36',	'admin',	11,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	1.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	11,	1,	0,	1),
(65,	'我国独立制造的第六代深水钻井平台顺利完成海试',	'<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	10月19日，京东宣布今年11.11大促将首次推出“京东拼购”等玩法。10月19日，美团点评官方微信小程序也正式上线了“好货拼团”板块。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	事实上，此前已经有包括阿里、苏宁、今日头条等多家互联网巨头切入了社交拼团业务。而这一切，在笔者看来，巨头们完全已经将拼购当成了获取用户流量的下一个杀手锏。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;text-align:center;\"=\"\"> <img border=\"0\" src=\"http://demoall.adashuo.com/25707/uploads/allimg/c191120/15J2314405K20-1L320.jpg\" style=\"height:auto !important;\" /> \r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	拼购成“香饽饽”\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	根据艾媒咨询发布的《2018Q1中国社交电商行业市场研究报告》显示，2018年中国社交零售用户规模将突破3亿人，年均复合增长率将达到44.2%。这也意味着，未来社交电商或仍将有巨大的增长空间。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	而作为社交电商的集中展现形式，拼购正凸显着自身鲜活的能量。这其中，最值得注意的就是拼购已经成为巨头最新切入的业务。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	具体来看，巨头们正在尝试性地推出自家相关的拼购业务。如果让消费者直接说出某个巨头旗下的拼购业务，可能会非常轻松。因为这些巨头推出的拼购应用，名字上大同小异——手淘特价版、京东拼购、苏宁拼购、今日头条的“值点”……\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	此外，支付宝联合淘宝上线拼购小程序“每日必抢”，网易则推出了“网易一起拼”。总的来看，它们还都是以“拼”、特价为主要特性，为自己烙印下超值的标签。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	而从数据上看，拼购在近段时间以来也成为电商行业的一个热词。根据速途研究院发布的《2018上半年国内拼购电商市场研究报告》显示，在巨头的入场下，它们不仅让自身拥有了亮眼表现，还让拼购行业获得了整体提升。从微信指数和百度指数看，各个巨头的拼购业务都有着显著提升。这也意味着，以布局消费分级市场为目标的拼购，成为了当下巨头眼中的“香饽饽”。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	巨头在拼购行业的试水，还反应在将自身的资源不断向拼购业务倾斜。比如，很多巨头都举办了优惠活动来吸引消费者，并展现自身拼购业务的特性。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	比如：京东拼购频道此前公布了双11玩法，旨在以流量传播扩散+提升订单为目标，通过打造贯穿双11的拼购寻宝乐园，同时引爆11.8拼购玩法狂欢日，为拼购小程序引流，帮助平台转化新用户并提升订单量。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;text-align:center;\"=\"\"> <img border=\"0\" src=\"http://demoall.adashuo.com/25707/uploads/allimg/c191120/15J231440B4F-1U327.jpg\" style=\"height:auto !important;\" /> \r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	苏宁拼购则将重点在直采直销生鲜商品上发力。在刚刚过去的双十拼购日，苏宁拼购一天卖出了40万个柚子，这坚定了其发展生鲜拼购的战略构想。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	因此，我们可以看到，在巨头的不断试水下，拼购这一社交电商模式已经变得迅速火爆。对于消费者来说，这也是一个消费变得多元化的好兆头。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	品质化渐成主流\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	其实，如果不戴“有色眼镜”去看拼购的话，其身上还是有很多亮点的。拼购以低价引入流量，通过关系网对商品进行分裂曝光，在满足多数人追求“低价”需求的同时，又大幅度增加中小商家和尾货的曝光率和购买率。也正因为如此，拼购在当下俨然成为购物模式中的一股新势力。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	但值得注意的是，在拼多多一家独大的时候，其商品质量、售后等饱受诟病。山寨、造假的问题，也造成了诸多负面影响。而在巨头纷纷入场的情况下，实际上也意味着拼购将进入下半场。在下半场开启的同时，拼购也将迎来全新的发展拐点。拼购在展现品质化的同时，也将成为巨头业务的补充，让它们构建更为完善的商业生态矩阵。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	对消费者利好的消息，在于品质化将成为拼购的常态。同时，品质化也将是巨头拼购业务的竞争发力点。不管是为了稳固消费者群体，还是出于维护自身品牌形象的考虑，巨头都不会再去牺牲商品质量和售后来实现低价。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	它们会尽力展示自身的物流实力、电商交易技术能力、核心交易链路、消费保障制度等，将供应链优势发挥到极致。最终，巨头的拼购业务将让消费者享受到具有更高性价比的品质好货，并由此实现真正的消费升级。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	此外，拼购业务的上线也是对巨头自身实力的加强。以美团拼团为例，其让美团实现了从虚拟商品向实物商品的过度，完成了自身商业边界的扩张。中国社科院财经院互联网经济研究室主任李勇坚表示，“过去用户可能只有在吃饭等时候才想到打开美团，但如果增加了商品类拼团，既有用户可能会在APP上停留更多的时间用于浏览商品”。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	而对于巨头而言，以往虽然在努力强调业务之间的整合，但缺少了某个版块后，业务之间总会有割裂感。拼购业务的出现，或许就能成为“黏合剂”，让巨头的业务实现融合发展。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;text-align:center;\"=\"\"> <img border=\"0\" src=\"http://demoall.adashuo.com/25707/uploads/allimg/c191120/15J231440I050-1c916.jpg\" style=\"height:auto !important;\" /> \r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	值得注意的是，对于巨头来说，它们此前都面临着各自不同的发展瓶颈。而要寻找创新增长点，就必须在流量上痛下苦功。拓展流量的最佳做法，就是通过开辟新业务获取。而拼购身为“引流大户”，自然被巨头所看重。在拼购行业的下半场，它们将争抢中高端消费人群，不断攫取新的流量。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	相信随着巨头纷纷切入拼购领域，后者也在加速下沉。而就发展趋势来看，只拼价格不拼质量的原始拼购模式注定被淘汰。在被巨头开启的下半场，拼购有望与消费升级概念的成熟、人均消费能力的提升高度契合。届时，拼购业务也将成为巨头比拼的另一立脚点。\r\n</p>',	'doc.png',	1.00,	36,	0,	0,	0,	'2019-12-03 14:09:59',	'admin',	0,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	1.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	13,	1,	0,	1),
(66,	'袁隆平又上热搜 这次网友却很担心',	'<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	11月5日，一项热搜出现在邦哥的微博首页，并且排名一路蹿升至第一，挂在榜首直至今日凌晨：6000多首歌从KTV下架。被下架歌曲中，《十年》、《泡沫》《死了都要爱》《听海》《K歌之王》等等大热歌曲赫然在列。许多媒体的标题用的是：你拿手的还能点么？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	而邦哥脑中也冒出了另一个问号：这些歌曲为什么被下架？谁主导了这次下架风波？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	一个民间组织，为何有权下架全国KTV的6000多首歌？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	这次下架风波毫无疑问是版权问题引起的：中国音像著作权集体管理协会（下称“音集协”）发出公告，要求KTV终端生产管理商和卡拉OK经营者在今年10月31日前，删除或者不向消费者提供6000多部音乐电视作品。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	乍一看这是一件好事，毕竟版权保护理应得到支持，即便6000多首歌的下架在短期内会给普通消费者带来一些麻烦，但依然有利于产业的良性发展。<strong>然而意外的是，邦哥就此与一位业内音乐创作者进行了解时，对方却对此次发出公告的“音集协”并不买账：这个协会其实不是国家的版权保护机构，之前还被央视曝光过收取高额版权费后，并没有给歌手支付费用，我对于之后钱的去向保留意见。</strong> \r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	业内人这样的评论，引起了邦哥的注意，我们随即找到了音集协官方微博，查看其回应此次事件的公告。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\"> <img alt=\"6609首歌从KTV下架，《十年》《泡沫》均中招，原因不止版权那么简单 \" border=\"0\" class=\"aligncenter\" src=\"http://demoall.adashuo.com/25707/uploads/allimg/c191120/15J231444420Z-10TG.jpg\" title=\"6609首歌从KTV下架，《十年》《泡沫》均中招，原因不止版权那么简单 \" style=\"height:auto !important;\" />众所周知，KTV使用他人音乐作品，需要依法取得授权。但全国KTV可以说是海量的，KTV所需要使用的作品也是海量的。实际经营中，要经营者自己去一对一地取得授权，说句实话，并不现实。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	音集协就是在这样的背景下成立的。我们查看了其官网资料，根据资料显示，该协会是会员制，注册会员后，协会可以帮助你进行统一的版权管理，对全国的KTV进行作品授权，或者进行相应的维权措施。但让邦哥十分惊诧的是，这次被下架的6609首歌，背后的版权所有者，没有一家是音集协的会员。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	换言之，<strong>音集协的权利范围本应是帮自己的会员授权和维权，这次却是向6609首他们本应管不着的歌，发放了“下架通知”</strong>……\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在音集协官方微博的回应公告中，这一消息得到了证实：\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\"> <img alt=\"6609首歌从KTV下架，《十年》《泡沫》均中招，原因不止版权那么简单 \" border=\"0\" class=\"aligncenter\" src=\"http://demoall.adashuo.com/25707/uploads/allimg/c191120/15J23144450T0-114138.jpg\" title=\"6609首歌从KTV下架，《十年》《泡沫》均中招，原因不止版权那么简单 \" style=\"height:auto !important;\" />这让邦哥不禁产生了一个疑问：不是音集协的会员，我的歌曲就不能在KTV里播放了么？音集协到底是一个什么样的组织，怎么会有这么大的权利，对非会员的作品也能进行下架处理？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	就此我们在其官网查找到了音集协的《协会章程》，章程总则中清晰地写明了音集协的性质：本团体是由依法享有音像节目著作权或者与著作权有关的权利人<strong>自愿结成的全国性、非营利性的社会组织</strong>。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	一个自愿结成的会员制民间组织，从法理上讲，应当并不具有行政执法权，按照常理本应无权对“非会员”的作品进行下架处理。而在音集协此次回应的公告中，对这一问题的描述如下：\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;text-align:center;\"=\"\"> <img alt=\"6609首歌从KTV下架，《十年》《泡沫》均中招，原因不止版权那么简单 \" border=\"0\" class=\"aligncenter\" src=\"http://demoall.adashuo.com/25707/uploads/allimg/c191120/15J2314445T30-12W41.jpg\" title=\"6609首歌从KTV下架，《十年》《泡沫》均中招，原因不止版权那么简单 \" style=\"height:auto !important;\" /> \r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	对此，邦哥咨询了法律方面的专家，对方表示：6000多首歌的权利人或其委托的代理公司对KTV经营者提起的单独诉讼，就法律关系上讲与音集协相互独立，并无关系。但公告中并未提到音集协与这6000多首歌的权利人或代理公司是否有委托关系，因此<strong>音集协此次的“下架通知”背后，是否有可能是接受了歌曲权利人本身的授权或委托，我们也不得而知。</strong> \r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	曾被众多媒体质疑、央视曝光高额版权费流向哪里？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\"> <strong>2006年，国家版权局规定，开始收取卡拉OK每包间一小时12元的歌曲版权费。我们日常去KTV的费用中，就包括了这部分版权费。</strong>那么这部分版权费收取后流向了哪里呢？根据文章开头从业者的说法，邦哥查阅了很多资料，发现这已经不是音集协第一次处于舆论中心。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	2009年，中央电视台连续多个栏目对音集协收取卡拉OK版权费的情况进行了报道；中央二套的《今日观察》栏目还播出了一期新闻专题节目《版权费还是保护费》，邀请两位专家，围绕卡拉OK版权收费及其分配问题。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	根据当时的报道，<strong>音集协自2007年开始收取KTV及卡拉OK版权费，至2009年，收取的版权费已达8000万元，但这笔钱的使用分配却很不透明，相当多歌手表示并未拿到应得的报酬，但作为集体管理组织的音集协却要收取高达50%的天价管理费。</strong> \r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在当时的采访中，音集协不愿详细说明收费方式以及对著作权人的返还方式。不过一位业内人士向央视记者透露，收费是通过一家叫做“天合文化”的公司进行的。根据公开资料，该公司成立于2007年8月，受音集协委托代收卡拉OK版权使用费。音集协负责授权，天合文化负责收费，二者形成一套KTV歌曲版权收费系统。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	而那时的国家版权局版权管理司王自强司长则认为音集协的做法有欠妥当，在接受记者采访时表示，“集体管理组织是一个非营利性机构，不能以组织企业来进行收费，只能建立自身的收费队伍。收费本体是你本身，你不能有一个第三者出来。”\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	那是音集协引起争议声浪最大的一次，此后也曾有过多家媒体跟踪报道过音集协收取版权费的相关内容。早在2008年就有北京中银律师事务所董正伟律师向国家工商总局、国家发改委举报，请求对音集协向KTV行业收取著作权使用费开展反垄断执法。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	而近两年，音集协受到的质疑更加密集了起来，2017年、2018年都有KTV联合状告天合公司（音集协的授权收费单位）进行行业和价格垄断，但最终都以天合的胜诉告终。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	有趣的是，<strong>音集协与天合文化的合作自2007年至2018年，11年间从未停止。但就在邦哥发稿前不久，音集协官网上出现了一份最新公告，终止了与天合文化的委托合作。</strong> \r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;text-align:center;\"=\"\"> <img alt=\"6609首歌从KTV下架，《十年》《泡沫》均中招，原因不止版权那么简单 \" border=\"0\" class=\"aligncenter\" src=\"http://demoall.adashuo.com/25707/uploads/allimg/c191120/15J231444A250-13U93.jpg\" title=\"6609首歌从KTV下架，《十年》《泡沫》均中招，原因不止版权那么简单 \" style=\"height:auto !important;\" /> \r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	被下架歌曲并非不能唱了，版权保护，路漫漫其修远兮\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	对于一个行业的健康发展来说，6609首无授权歌曲自KTV下架，理应得到支持。但版权收费的规范性、透明性，同样是应该得到重视领域。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在此次风波中，被认证为音集协副理事长的周亚平的微博发言，同样引发了相当多网友的不满：\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;text-align:center;\"=\"\"> <img alt=\"周亚平表示：希望权利人加入，而不加入的后果是“作品被摒弃在卡拉OK渠道之外”\" border=\"0\" class=\"aligncenter\" src=\"http://demoall.adashuo.com/25707/uploads/allimg/c191120/15J231444I530-14Kc.jpg\" title=\"6609首歌从KTV下架，《十年》《泡沫》均中招，原因不止版权那么简单 \" style=\"height:auto !important;\" /> \r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	周亚平表示：希望权利人加入，而不加入的后果是“作品被摒弃在卡拉OK渠道之外”\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在撰文的过程中，邦哥将此次下架的6609首歌曲完整名单下载了下来，发现实际上遭到下架的，只是该首歌曲的某些版本。例如周杰伦遭到下架的《告白气球》等歌，就仅限《中国新歌声》第一季播出版本被下架。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\"> <img alt=\"6609首歌从KTV下架，《十年》《泡沫》均中招，原因不止版权那么简单 \" border=\"0\" class=\"aligncenter\" src=\"http://demoall.adashuo.com/25707/uploads/allimg/c191120/15J231444PZ-15S59.jpg\" title=\"6609首歌从KTV下架，《十年》《泡沫》均中招，原因不止版权那么简单 \" style=\"height:auto !important;\" />虽然这样的版本限制让很多小伙伴产生了“虚惊一场”的感觉，但邦哥要提醒的是，<strong>版权制度的目的，以及所要保护的对象，是创作者和版权所有者的利益。权利人们的利益，决定了他们的生存环境。</strong>如果从业者无法生存，音乐产业的发展从何谈起？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	中国音乐版权保护之路，依然路漫漫其修远兮。\r\n	</p>',	'doc.png',	1.00,	17,	0,	0,	0,	'2019-12-03 14:10:31',	'admin',	3,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	1.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	10,	1,	0,	1),
(67,	'外媒：美式橄榄球在中国受欢迎 但专业解说难寻',	'<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	人工智能时代已来，雷军为小米找的下一个风口是什么？成立相机部门能“干翻”华为吗?\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;text-align:center;\"=\"\"><br />\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	▲雷军在在故宫发布滑盖手机MIX3\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	作者 |马婧\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	编辑 |赵泽 杨砺\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在喊出“今年相机部门有没有年终奖，就看能不能干翻华为”之后，小米董事长雷军又发新手机了，这一次是在故宫。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	2018年10月25日，在故宫发布磁动力滑盖手机MIX3乾清宫户外发布会，雷军在现场有点激动，一个人solo了将近一个半小时。雷军在介绍手机后置相机时，突然天空中传来两声乌鸦叫，雷军忍不住笑场，说连鸟都在肯定小米手机，“这是我们第一次办的户外的发布会，还这么有趣啊。”\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	25日早间，小米集团发布公告称，预计到10月底，手机出货量将突破1亿台，提前两个月完成2018年全年目标。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	雷军在发布会上谈到，今年手机大厂商和小厂商之间的差距会拉大，主要原因是各家在相机、AI方面投入成本不同所致。今年5月，雷军在内部信中宣布，在手机部内成立单独的相机部，集中全公司优势资源，提升小米手机的拍照品质。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	雷军曾对相机部门的同事说，今年相机部门有没有年终奖，就看能不能干翻华为。25日下午更新了最新成绩，小米MiX3以103的成绩超过了华为P20。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	小米如何“干翻”华为呢？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	▲MIX3故宫乌鸦捣乱小米发布会现场 雷军笑场：连鸟都肯定了\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	未来高增速或不靠手机靠IoT\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	新京报：小米过去8年保持了高速的增长，未来还能有非常高的增速吗？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	雷军：我们对小米未来的高速增长很有信心。首先手机行业是一个很大的市场，2017年全球共销售手机14.7亿台，小米销售了9000多万台。随着5G时代的到来，手机市场可能再次迎来增长，虽然不会像过去增长那么快了，但这个市场即便不再增长，对于小米来说仍然有巨大的成长空间。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	其次，手机之外，小米在智能硬件和消费升级领域布局广泛，已经进入了100多个品类，建成了全球最大的IoT物联网平台。随着AI时代的来临，AI+IoT将产生巨大的价值，小米已经具备了一些优势。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	另外，小米在海外市场有巨大的机遇。小米手机已经进入了74个国家和地区，还有很多市场有待进入，我们的很多品类也还没有进入全球市场。随着小米一步一步进入新的市场，把新的市场做好，我觉得小米未来还有十倍以上的成长空间。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	新京报：我们注意到小米还在布局智能家居。有观点认为智能家居是个伪命题？你怎么看这个问题？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	雷军：“智能家居”不是一个新词，二十年前在国外就有了，只是一直没有推动。我们觉得背后主要原因是商业通道和技术通道没有打通，比如以前智能家居的成本非常高，家里必须重新装修一遍，这对消费者难以负担，此外，不同厂家的产品之间也很难互联互通。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	小米做了两件事情来解决，首先我们把一个个的产品智能化了，消费者买回家后，突然发现实现了智能家居，这是商业通道理顺了。另外，我们做了互联互通的模组，在技术上也打通了，小米智能家居产品由很多不同的公司生产，但只要用了这个模组就可以互联互通。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	智能家居目前只是刚起步，小米也只是刚跨过门槛，今后智能家居的发展空间可能远超我们想像。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	新京报：有人说，小米生态产品只是在做微创新，你怎么看这个问题？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	雷军：从我们创业的经验来看，成功背后都有不为人知的艰辛，哪怕是一点点成绩，都要付出巨大的努力。所以我觉得我们不要小看微创新，为了提升消费者的体验，哪怕仅仅是1%，我们也投入了100%的精力。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	小米立志要成为一家伟大的互联网公司，让全球每个人都享受科技带来的美好生我没有。我们只有全力以赴做好每一件小事，才是走在正确的道路上。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	下一个互联网浪潮是人工智能\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	新京报：如何看待互联网这20年来在中国的发展，如果用几个关键的时间点来划分，你会怎么划分？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	雷军：我觉得2007年苹果推出iPhone是个很重要的事件，智能手机的出现极大的改变了互联网，我判断手机会逐渐替代个人电脑，移动互联网的时代将会来临。2010年小米成立，2011年推出了第一代小米手机，我们推动了智能手机在中国的快速普及和品质提升，移动支付、电商、社交网络、短视频等行业在中国的蓬勃发展，都有赖于庞大的移动互联网人口，这方面小米做了一点贡献。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	新京报：互联网下一个浪潮会是什么？在这个浪潮下，小米的机会是什么？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	雷军：人工智能的时代已经到来了，人工智能也是小米最重要的战略，我们拥有四项巨大的优势，用户群、海量设备、海量的数据、对整个AI时代的认知，很早就重视了云服务和大数据。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	小米选择的突破口是IoT，也就是万物互联，我认为AI与IoT结合将形成AIoT，也就是万物智慧互联，在这个领域未来有着巨大的发展空间。小米已经建成了全球最大的消费物联网，连接了1.15亿台智能设备（不包含手机、平板和笔记本电脑），小米人工智能助理小爱同学月活跃设备超3000万，月唤醒计数超10亿次，累计唤醒次数超50亿次。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“天使投资人经历让我学会找风口”\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	新京报：从金山时代开始，业界对你的评价就是IT劳模，怎么看待这一评价？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	雷军：如果我们要实现与众不同的梦想，付出的不比别人多，怎么可能成功呢？我现在还是这样认为，创业并不光鲜，成功的企业家也不像大家想的，轻轻松松就成功了，哪怕一点点成绩，背后都要付出极大的努力。在成功的路上，其实只有这一个秘诀认真拼命地工作。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	新京报：天使投资人的身份对于创办小米有哪些帮助？创业者和投资人的思维方式最大的不同之处是什么？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	雷军：因为天使投资人做的就是看大势，找风口。我觉得创业要想五年后是什么样子？十年后是什么样子？什么是正确的事情，什么是正确的时间点？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	我当年是一个手机发烧友，认为手机上网是未来的趋势，未来10年是移动互联网的天下，那我接着就想应该做些什么？所以我用投资人的身份，去看谁在做移动互联网，去搞清楚移动互联网到底是什么，这个过程中我们越来越坚信移动互联网的未来，最终在2010年决定创办小米。\r\n</p>',	'doc.png',	1.00,	32,	0,	0,	0,	'2019-12-03 14:11:24',	'admin',	1,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	1.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	12,	1,	0,	1),
(68,	'区块链未死！2019区块链+农业或将浴火重生',	'<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	不在沉默中爆发，就在沉默中灭亡！\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	这句话来形容当下的区块链。2018年疯狂的区块链因受政策监管与打压，资本、媒体、甚至创业者都趋于冷静。或许，这就是黑暗里的爆发前夜吧。但这个前夜还很长很长…\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	最近一篇题为《业内人士：区块链逐步融入农业发展》文章引起我们的关注。该文提到：“截至目前，区块链已被应用于产品溯源、农业保险、农村金融、智能合约等多个场景。尽管目前区块链技术在农业领域的应用范围还较为有限，但是许多业内人士对于区块链在农业领域的未来发展前景仍然满怀期待”从种种迹象来看，业内人士非常看好区块链在农业领域和场景里的应用。另外，还有政府官员也为区块链+农业打CALL。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	内蒙古蒙草生态环境（集团）股份有限公司董事长王召明表示，作为农业大国，要利用物联网、大数据、移动互联网、人工智能、区块链等现代信息技术，大力推动农业全产业链改造升级，为实施乡村振兴战略插上互联网的翅膀。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	可以肯定：区块链没有倒下，区块链在等待机会。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	业内专家指出，2019年有望成为区块链技术真正落地应用，走向产业化的一年。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	区块链诞生之初，外界都追捧：区块链是各个行业的救命稻草。尤其金融行业、食品行业，当然也包括农业领域。我们聊聊区块链解决农业什么问题？我们认为个有以下几个问题！\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	1农业领域看好区块链\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	1农产品可溯源\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	农产品溯源一直是农业的一个痛点问题。而区块链技术利可以对记录实现不可篡改，因此从农产品的生产端到流通端、消费者都有详实的数据，可以实现消费者明明白白消费，提高消费者购买的意愿。农产品溯源可以提升农产品安全性以及食品的安全性。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	2信息透明\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	农业领域除了可溯源之外，生产者与需求方的信息也存在不透明的问题。一旦区块链技术应用与农业。大家就可以通过大数据分析，建立种植户、采购商的信用评级参考；利用智能合约在种植户和采购商之间保证公平交易。同时，区块链技术可以提高农产品买卖双方的契约精神。另外，随着食品供应链中区块链的出现，这可以简化这一过程，因为数据管理系统，将一系列农民、加工商、分销商、监管机构、零售商和消费者纳入其雷达范围的数据管理系统变得更加透明。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	3降低成本\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	区块链技术运用之后，生产、流通等2大环节的成本会大大降低。比如，区块链技术解决信息自动存贮和数据库的功能，如此就减少了人工的投入和其他设施的投入。另外，区块链及应用实现万物互联，帮助生产商和渠道商降低各项开支。同时，生产和流通成本的降低，也会降低农产品的价格，最终还是消费者获利。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	因此，区块链技术在农业领域的应用等到各级人士的认同。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	2现在的区块链农业玩家\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	从以下多个案例来看，这些企业的确把区块链技术应用到用户服务中。他们希望借助区块连技术解决食品安全和可溯源，从而提高消费者对品牌的认可度。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	1沃尔玛\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	沃尔玛公司在2017年内在区块链技术领域作出了大量尝试。沃尔玛一直在与IBM合作，共同开发针对食品安全问题的区块连解决方案。比如，沃尔玛把区块链放在芒果、猪肉等生鲜农产品上。沃尔玛食品安全副总裁Frank Yiannas曾表示：“我们的客户理应拥有更加透明的供应链。我们认为在21世纪，以前那种一步一步去追溯源头的方式已经过时了。这是一项由技术支持的明智举措，它将极大地造福我们的客户，并彻底改变食品体系，使所有的相关者受益。”\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	2 Dreyfus\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	大宗商品交易公司Louis Dreyfus（路易达孚）宣布已试用由ING（荷兰国际集团）等一批金融机构开发的基于区块链的交易系统。Dreyfus使用区块链平台来完成与中国供应商的大宗大豆交易，极大地缩短了交易时间。同时，据参与测试的公司表示，这次测试涉及从美国运到中国的大豆，并在平台内保存所有相关文件（包括销售合同和信用证）。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	3可口可乐\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	2018年，可口可乐正在与美国国务院、区块链信托加速器（BTA）、区块链技术公司Bitfury集团以及崛起币（Emercoin）共同合作，推出一项基于区块链技术的试点项目。同时，可口可乐公司建立区块里的平台，以帮助确保道德的糖生产。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	4家乐福\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	2018年，欧洲最大的零售商家乐福已经开始采用区块链账本技术去追踪鸡肉、鸡蛋和西红柿从农场送到商店的全过程，并将在未来几年在其所有生鲜产品线上部署这种技术。比如，2018年3月，家乐福中国首款区块链产品——琯溪蜜柚，获得用户疯抢。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	5 Smart农场\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	中国农业已经迎来4.0时代，高科技融合成为农业发展的方向。上海华中农投农业科技有限公司旗下Smart农场大力推动区块链的应用。将区块链技术与农业相结合后，能最大限度地消除信息不对称，提高整个产业链的信息透明度和及时反应能力，从而实现整个产业的增值。减少农药投入，提高农产品品质。解决农业的痛点，解决农产品的食品安全、食品供给问题，真的能让中国人都尝到放心的味道。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	3未来走向\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	区块链去中心化等特性，将大幅降低互联网维护成本，提升农业物联网的智能化和规模化水平。同时，基于区块链技术的农产品追溯系统，解决了消费者对于产品的信任危机，让人们的餐桌更健康，更安全。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	另据前瞻产业研究院发布的《中国区块链行业商业模式创新与投资机会深度分析报告》统计数据显示，随着区块链应用场景扩展，预计2019年具有投入产出的区块链企业超过600家，产业规模有望超过8亿人民币。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	有人预测：2019年，“区块链技术”正逐渐从幕后走向台前。我们从2个方面来看：区块链技术迎来利好！\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	1）从大背景来看，国家政策打击比特币，但支持区块链技术在各个行业的应用。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	2）从行业来看，目前大数据和人工智能的发展，区块链技术也将会逐步与其他高科技项目融合赋能产业。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在农业领域，区块链农业又将会呈现哪些趋势和走向呢？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	1物联网＋无人机＋区块链\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	中国农业已经迎来4.0时代，高科技融合成为农业发展的方向。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	物联网＋无人机＋区块链的结合将有利于精准农业的发展，减少农药投入，提高农产品品质。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	其中，物流确保万物互联，无人机提供生产管理服务，而区块链提供记录和可溯源等技术。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	2区块链+数据+人工智能\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	区块链应用于农业，能最大限度地消除信息不对称，提高整个产业链的信息透明度和及时反应能力，从而实现整个产业的增值。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	而区块链+数据+人工智能的融合发展，可以推动农业大数据的价值最大化，降低投入成本。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	3区块链+农业金融\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	2月初，中国政府发布了“关于农村金融服务振兴的指导意见”。此次提出的新框架，是国家农村振兴计划中金融服务效率提高计划的一部分。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	同时，该指南据称将有助于促进农村金融部门中如区块链等新技术的应用，以“改善农业信贷风险的识别、监测、预警和处置水平”。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	该公告还预测，新技术将鼓励金融机构“为农村电子商务开发专用贷款产品和小额支付结算功能，并开辟农村电子商务资本链”。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	区块链+农业金融将会为小农户贷款提供便捷途径，为农业金融机构的征信带来真实性和可预测性。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	4区块链+农村物流\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	随着区块链、物联网、大数据等新兴技术与物流行业的深度融合，供应链正成为区块链技术最具潜力的应用场景之一。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	由于农村物流的小散，导致包裹丢失、农产品上行困难等窘况。但区块链技术可以解决这些问题。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	西南交通大学交通运输与物流学院副院长罗霞指出示，农村振兴是今年党中央非常重要的战略部署，与农村物流高质量发展紧密相关。加强云计算、区块链、人工智能等供应链智能化技术在农村物流中的应用，为农产品的生产、检测、周转、销售、品控、管理等提供智力支持。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	5区块链+农业供应链\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	这一类应用就是各大商场嫁接区块链的原因。比如：沃尔玛、家乐福等大型超市把整个生鲜和食品供应链纳入区块链管理，从而降低成本，提高产品的安全性。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	目前，美国农业巨头嘉吉等都在大力发展区块链+农业供应链金融的应用。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	总结一下，2019年区块链在农业领域的应用将会再次迎来爆发。但我们还要明一点：区块链只是一项技术，而不是赚钱的工具。在整个农业发展中，区块链只做赋能者，而不是主导者。如此，路子才会越走越宽！\r\n</p>',	'doc.png',	1.00,	21,	0,	0,	0,	'2019-12-03 14:13:27',	'admin',	14,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	1.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	4,	1,	0,	1),
(69,	'伊朗在叙利亚部署国产防空导弹 号称可拦截隐形战机',	'<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	电子商务飞速发展，快速增长的包裹数量与日渐减少的快递员数量已经不成正比。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	快递员的工资回报越来越高，为什么这个职业在近年来从事人员锐减呢？对此，有很多快递员反映，虽然能够得到很高的工资回报，但随着人们对服务水平的要求也越来越高，他们也越来越辛苦。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	同时，快递员的社会地位相对较低，随着人们文化水平及文化素养的逐渐提高，一些有学历有技能的人都已不太愿意做快递员。申通副总在7月25日召开的中国快递“最后一公里”峰会上就表示，现今快递行业的痛点已不仅是解决“最后一公里”的问题，而是怎样才能够招到更多的快递员。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	中国高速发展中，人口红利也在逐渐的减少，越来越多的事情都开始被智能化技术所取代，但快递行业是属于劳动密集型企业，非常依赖快递员。快递行业正处在用人难之际，双十一等各种电商狂欢节的到来无疑是让这些快递企业悲喜交加。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	智能快递柜提升末端物流配送能力，备受物流企业青睐\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	快递员不足是人口红利减少的必然结果，因此急切需要新兴技术缓解快递行业的压力，智能快递柜作为解决方案就这样“问世”了。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	智能快递柜在2012年萌芽，中邮速递易率先推出智能快递柜，在初期遭遇了很多的质疑和非议，但在包裹数量不断增长以及城市年轻劳动力不足的情况下，智能快递柜已经成为末端物流配送能力的重要补充，各路资本企业竞相涌入该市场，想分得一杯羹。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	2015年6月，顺丰、申通、中通、韵达、普洛斯投资5亿元成立丰巢科技；2016年10月，中集e栈、上海富友收件宝、江苏云柜组成创赢联盟，形成了以速递易、丰巢和创赢联盟为主的三巨头格局；2017年7月，中国邮政集团与驿宝网络入股速递易，中国邮政以50%股份控股速递易，“国家队”正式进入智能快递柜行业……智能快递柜已然成为物流企业人手必备的基础设施。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	国家邮政局10月17日发布的 《2018年9月中国快递发展指数报告》显示，快递企业与第三方创新末端投递形式，基本形成上门投递、智能箱投递、平台投递等多元末端服务体系，主要企业设立智能快件箱25万组，箱递率达到8.4%。高速增长的数据表明智能快递柜前期虽饱受争议，但后期已逐渐被民众所接受。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	智能快递柜突破派件瓶颈，效果显著\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	首先，智能快递柜降低了人力成本，减少了快递员的工作负荷。快递员的工作量和工作任务较为繁重，在人手不足的情况下一个快递员往往需要承担起更多的工作，经常超出本来的工作时间，因此快递公司需要对快递员支付较高的人力成本。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	智能快递了增加派件数量，在提高了快递员的工作效率的同时，也提高了他们的收入，在一定程度上缓解了“用人难”问题，降低人力成本。在这一点上，丰巢获取得的效果极为突出：在今年九月初，丰巢与链家进行合作并声称他们的日均派件量已高达900万+,这个数据对于快递行业来说无疑是一个巨大的进步。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	其次，智能快递柜提高了用户隐私保护力度，取件时间更随意。当今社会，人们对于隐私非常重视，而在传统的快递人员配送模式中，存在快递信息被其他人窃取或是快递在寄存的时候丢失等问题，智能快递柜保密性更强，能极大减少了这种问题的发生。再加上传统的配送模式中快递员配送的时间可能会和收件人在家的时间不对等，给收件人带来了困扰，智能快递柜投入使用使得忙碌的人们可以随时取件，极为方便。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	智能快递柜陷入困境：难盈利、争议大\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	智能快递柜诞生是时代进步的需要，也给我们的生活带来了巨大的改变，但很多问题也接踵而来。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	首先，盈利难。一方面是因为快递柜的设备生产成本高和在每一个小区内投放的租金比较高，快递柜的场地年租费也较高，同时维护费用也不低。过高的成本使智能快递柜不能为企业带来营收利润，这对每一个企业来说都是致命的打击。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	佼佼者丰巢和速递易均面临着巨大亏损：截止2017年9月30日，丰巢科技在该年9个月期间的营业收入为1.6亿元，净亏损从2016年的2.5亿元扩大到2.76亿元，负债总额扩大到12亿元；运营速递易项目的三泰科技也是出现常年亏损，2015 年亏损3792.8万元 ，2016 年亏损 12.69亿元，2017年第一季度亏损也将近3000万元。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	另一方面是用户往往不会愿意为此付费。用户认为在购买商品时已支付过运费，取快递时就不应该再支付额外的费用，使得快递柜的亏损日益增加。同时，蜂巢、速递易等快递柜也开始向快递员收取存放费用，其中速递易快递柜的收费标准为：大箱0.6元/件，中箱0.5元/件，小箱0.4元/件，但很多快递员不愿承担这些费用。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	其次，智能快递柜虽然提高了快递员配送快递的效率，但使得快递员很轻松的逃避了签收这一流程。用户无法进行当面进行签收，使得物品运输过程中出现的质量问题时的合法权益无法得到保障，收货时发现快递有问题不知该向谁反映。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	最后，在包裹数量的飞速增长的背景下，快递员如果像从前一样一件件把快递送到消费者手中显然是不太现实的事。所以现在的快递员在快递高峰时段一般都使用智能快递柜，不会打电话一一进行通知，在把物品投入快递柜时会由系统自动给用户发送取件通知，而如果快递员在放入物品时把用户的手机号输入错误，会导致用户无法接收到取件通知，从而超时取件。现在部分品牌快递柜超过一定的取件时限需要收取一定费用，这让用户难以接受。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	另外，有用户在使用丰巢快递柜时，页面会出现“打赏”等字样，价格以1、2、5元为不等，这样确实能为丰巢带来一定的收益，虽然不是强制收费并且设有“跳过”的字样，但由于字体过小，有引诱用户消费的嫌疑因此用户在使用过程易产生误解与不满。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	智能快递柜如何赢得“民心”？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	智能快递的问题柜已经严重影响后期的战略布局和发展，企业应当如何解决成了广泛关注的焦点。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	首先，智能快递柜最初出现时毫无营收利润，很大程度上是因为单纯的取件不可能有任何收入增长，但是现在智能快递柜的发展已涉及到寄件的环节，这意味着快递柜也可以从中赚取一定的利润。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	智能快递柜要想继续获得更大的盈利，应该继续为用户提供更多增值服务，让用户为此愿意付出相等的费用。比如，在各种人流量较大的公众场合，有很多用户因为手上提的东西过多有很大的不便，快递公司可以在这些场合投放寄存柜方便用户存放，并收取一定的费用，据了解蜂巢已经在试点，今年5月中标了杭州周边17个高铁站，总计36组寄存柜的订单。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	其次，面对快递柜无法当面签收的缺陷，快递柜企业应继续完善快递柜的基础硬件设施，比如在每一组快递柜上安装摄像头，用户在取包裹时可以将包裹在摄像头下展示，将来包裹质量出现问题时可以避免物流企业和用户之间产生不必要的纠纷。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	最后，针对部分用户不满快递员在未经允许的条件下投递快递柜的问题，早在2016年国家邮政局发布的《智能快件箱投递服务管理规定（暂行）》中就曾明确提出，“经营快递业务的企业在使用智能快件箱投递快件前，应当征得收件人明示同意”，同时用户有权利决定是否使用快递柜或是按指定地点取货，用户应该积极行使自己的权利。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	企业在这样的背景下应加大对快递人员基本服务知识的培训力度，同时加强对客服人员处理客诉的能力，及时处理客户问题并进行反馈。快递员在把包裹放入快递柜时应检查该快递是否为需要保鲜、即食类食品，一旦出现商品问题则由快递公司或快递员承担全部责任。面对取件通知收不到等问题，在首次投递后收件人未能提取的情况下，快递企业应及时取回快递，联系收件人后再提供投递服务。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	小结\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	时代与技术在发展中，任何行业的各个环节都应该往效率更高，成本更低道路上发展。物流末端的需求是多样化的，送货上门是主流，但智能快递柜的市场潜力也不可小觑。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	根据中商产业研究院发布的 《2018-2023年中国智能快递柜市场前景及投资机会研究报告》 ，预计2018年智能快递柜市场规模将达169亿元，到2020年，中国快递柜市场规模将达近300亿元。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	所以，丰巢等智能快递柜未来应加大沟通协调力度，在提高消费者满意度的同时，尽快解决盈利模式问题，尽可能地保证效率、成本、体验和信息的互动。\r\n</p>',	'doc.png',	0.00,	40,	0,	0,	0,	'2019-12-03 14:14:23',	'admin',	1,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	0.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	14,	1,	0,	1),
(70,	'银行系APP整改风起 备案试点划定个人信息四大红线',	'<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	今年5月，唱吧终于完成了将近一年半的上市辅导工作。网上有消息称，唱吧在一个月后，就会正式向证监会递交招股书，踏上A股创业板的上市征途。但眼看着2018年就快要过去，却迟迟未见唱吧上市的消息。对此，唱吧创始人陈华在接受媒体采访时表示，对唱吧上市问题不愿多谈，言外之意是唱吧在近期内可能不会寻求上市。这突如其来的转变，让人们疑惑不解。唱吧在完成一年多的漫长上市辅导期之后，为何不愿上市？其究竟打的是什么“算盘”？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	唱吧上市搁浅，原因为何？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	唱吧从2012年上线起，便风光无限。其在上线首日注册用户就超过10万，5天之内登顶AppStore排行榜。易观数据显示，直到2016年第3季度，唱吧还以53.6%用户渗透率位居移动K歌领域第一的位置。彼时，唱吧正如日中天，选择上市无疑是正确之举。然而世事无常，经过将近一年半的漫长辅导期，国内的在线K歌市场早已“物是人非”，唱吧已然错过了最佳的上市时机。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	其一，全民K歌抢了唱吧“风头”。众所周知，全民K歌背靠腾讯，可谓是含着“金钥匙”出生。全民K歌不仅拥有微信与QQ两大流量入口，还与QQ音乐共享丰富的音乐版权，在流量与音乐版权方面都有着天然的优势，是唱吧最强劲的对手。据了解，全民K歌自2014年上线起，其活跃人数一直高增猛涨，在2016年成功超越唱吧，并逐渐拉开差距。据易观数据，2018年第三季度，唱吧活跃用户为6560万人，而全民K歌活跃用户则为20705万人，是唱吧的三倍。面对全民K歌的“攻城略地”，唱吧显然处于不利地位。而全民K歌的赶超，可能打乱了唱吧的上市计划。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	其二，短视频平台的崛起，冲击整个互联网娱乐市场。近几年，由于快手、抖音等短视频平台的崛起，整个互联网娱乐市场变的更加“拥挤”，唱吧的K歌业务、直播业务等都受到了一定的影响。QuestMobile数据显示，2018年7月，短视频APP行业月度活跃用户规模为5.08亿人，而短视频APP行业总使用时长在移动互联网中的占比达到惊人的9.2%，要知道，就算是在线视频的占比也仅有9.5%。可见，短视频APP行业已经抢占了大量互联网用户的上网时长，唱吧无法视而不见。再加上全民K歌的存在，唱吧要想巩固自身地位并不容易，目前也很难有华丽的数据支撑，若是在此时上市，唱吧的估值可能并不理想。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	其三，互联网股市动荡不安。最近国内不少已经上市的互联网企业过的并不“如意”，如小米、拼多多和美团等企业都出现了市值大幅下滑的情况，就连腾讯、阿里巴巴等老牌互联网企业也没能避免。受此影响，唱吧此时选择不上市或许是明智之举。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	一方面，在国内互联网股市行情不利的情况下，唱吧此时上市无疑是逆水行舟，有着“流血破发”的风险；另一方面，今年国内的互联网公司纷纷申请上市形成了“上市潮”，如宝宝树、映客、小米和拼多多等，如此多的公司扎堆上市，吸引了不少资金注入，导致资本市场紧缩，也就是说投资人手里的钱越来越紧张。这也许会造成唱吧融资困难，难以得到理想的融资金额。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在这些问题影响下，唱吧暂时将上市的计划搁浅，等待更好的时机上市，或许是不错的选择。不过除了上述三个原因之外，也有业内人士猜测，唱吧之所以要搁浅上市，可能是其要放弃A股创业板，而选择赴港上市。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	港股市场火爆，令唱吧有所动摇？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	对于唱吧要赴港上市的猜测，也并不是没有依据。早在2015年，唱吧就曾想要赴美上市，但由于美国缺乏与唱吧对标的产品，而导致其估值过低，令唱吧有所顾虑。与之相比，当时国内的A股市场行情较好，且国内资本对互联网科技股也愈发青睐。所以再三思考后，唱吧毅然拆除了VIE架构，选择回国赶赴A股上市。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	时至今日，随着港交所在上市机制上的改革，首次接受同股不同权企业上市，为互联网企业打开了一扇大门，包括小米、美团点评、平安好医生和宝宝树等多家明星企业都选择在港股上市。而此时的唱吧或许面临着与三年前类似的选择题，是A股还是港股？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	据了解，上市A股要求较为严格，除了必须盈利三年才能申请IPO外，还必须同股同权。而现在的港股市场，除了支持同股不同权企业上市，其监管机构也更加独立透明和高效，公司一般在6到12个月就能完成上市过程，可以帮助企业更好地把握好上市时机。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	此外，A股实行的是“T+1”交易制度，股民们当天买进的股票当天不能卖出，且还有涨跌幅限制。而港股采用的则是“T+0”交易制度，在当天交易时段内，相关机构和股民们可以自由买卖，交易次数与涨跌幅均无限制，这种方式不仅能够提高市场的交易量，还能帮助投资者及时止损。所以二者相对比较来看，港股市场规则似乎更加灵活且合理化，能帮助企业有更好的发展。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	且从根本上来讲，企业上市无非就是希望借助资本的力量，获得更好、更快速的发展。而随着港交所改革，港股已经成为了众多互联网公司上市的首选。在此条件下，唱吧若是选择“跟风”，改赴港股上市，也不是没有可能。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	不过从目前来看，在市场竞争加剧、股市动荡等问题影响下，唱吧此时上市并不稳妥。所以暂时将上市计划搁浅，继续修炼“内功”，才是唱吧最好的选择。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	养精蓄锐，厚积薄发\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	目前，纵观整个移动K歌市场，已然是唱吧与全民K歌双雄称霸的局面，像天籁K歌、K米和酷狗唱唱等K歌产品已经难以给全民K歌、唱吧二者带来威胁。可见，唱吧在移动K歌领域还是有着非常明显的领先优势，只要其能够完善自身，加强功能创新，或许就能够摆脱全民K歌所带来的竞争压力，在互联网娱乐市场中走的更远，其上市之路也会变得更为平坦。对此，唱吧可以从以下三个方面入手。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	首先，丰富曲库资源，提高音乐品质。音乐版权是移动K歌行业的刚需，缺少相应的音乐版权，用户就无法得到理想的K歌体验。如在用户K歌时，一定会选择自己喜欢的音乐进行录唱，但用户若是在唱吧中搜不到自己想要唱的歌曲，在别无选择之下，用户就会选择用其他的K歌软件进行录唱，最终造成唱吧的用户流失。因此，唱吧要想缩小与全民K歌的差距，还需与相关的音乐版权公司合作，丰富自己的曲库资源。同时，唱吧还应继续提升APP内的伴唱、录音和修音等音乐品质，争取为用户提供更加优质的K歌享受，以此来留住和吸引更多用户。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	其次，加强线上、线下融合，丰富用户K歌体验。如今，唱吧正在大力布局线下市场，其不仅花费数千万元战略投资麦颂KTV，并实现了与麦颂KTV在社交、服务等多方面的合作，还大力布局线下移动迷你KTV业务，取得了不错的成效。据了解，唱吧不光在全国拥有400多家麦颂KTV门店，还在商场、超市和机场等公共场所布下了2万多台迷你K歌亭。不过唱吧虽然在线下布局极广，但其线下资源还未能与线上达到有效的结合。目前唱吧在APP内只提供了KTV包房预定、在线点歌和在线切歌等常用功能，还有很大的完善空间。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	对此，唱吧可以在APP内添加游戏点歌、K歌评比和K歌挑战赛等有趣功能，加强用户线下与线上的互动。同时，用户在麦颂KTV里演唱的歌曲最好也能保存在唱吧APP中，让用户可以在唱吧APP中发布并分享自己在麦颂KTV里的演唱歌曲，这不仅满足了用户的分享欲望，又加强了线上与线下的融合，可谓是一举两得。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	最后，走出海外，争夺更大的移动K歌市场。如今，唱吧已经在国内取得了不错的成绩，其知名度和影响力也都达到了一定的高点，所以唱吧要想再有突破，并不容易。在此情况下，唱吧若是向海外市场发起冲击不失为一个选择。一方面，目前海外的许多国家都缺少类似唱吧这样的K歌产品，还是一片蓝海，这对唱吧来说有着不错的发展机遇；另一方面，在全民K歌、抖音、快手等平台影响下，国内的互联网娱乐市场空间变窄，唱吧要想继续在此环境中发展将受到不小的阻碍。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	总的来说，虽然上市会为唱吧带来新的发展机遇，但在市场竞争加剧、股市动荡等问题影响下，此时上市，对唱吧来说有着较大风险。因此，唱吧只有继续精细化运营，加强线上线下融合，并等待时机成熟后再进行上市，才会迎来更好的发展。\r\n</p>',	'doc.png',	0.00,	16,	0,	0,	0,	'2019-12-03 14:17:25',	'admin',	3,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	0.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	10,	1,	0,	1),
(71,	'北京下月起可预约接种宫颈癌疫苗 售价580元1支',	'<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	换上炫彩外壳，装上多变口味的烟弹，上市多年的电子烟今年突然热度飙升，成了备受追捧的创投领域。除了罗永浩在发布会上顺势推销的福禄电子烟，2018年末到2019年初，还有近10个新兴电子烟品牌出现。在深圳华强北电子市场，出售电子烟的广告牌更是如雨后春笋般涌现。但面对日趋严密的控烟大网，创业者们能否咽得下“这口烟”仍存在极大变数。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\"> <strong>电子烟突然变网红</strong> \r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	蓝莓、菠萝、水蜜桃、绿豆冰棒、柠檬茶……说到这些，不少人会联想到口香糖或是冰淇淋，却几乎没人能想到，这些全都是电子烟推出的新口味。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	精巧如U盘或是一根签字笔，也不用点火，从口袋里掏出来，打开开关就能用——近一年来，以电子产品形象出现的电子烟成了创投领域的新网红。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	今年1月，罗永浩在子弹短信新版本“聊天宝”发布会上，顺势推销了一款名为福禄、由锤子科技二号人物朱萧木创业推出的电子烟产品。紧接着，同道大叔创始人蔡跃栋与黄太吉创始人赫畅推出的“YOOZ柚子”，5位自媒体人组成创始团队的“灵犀&nbsp;LINX”也纷纷杀入。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	猪年春节，常年浸淫在科技圈、创投圈的自媒体人士陈女士惊讶地发现，平日里不抽烟的她，竟然收到了3种不同的电子烟产品作为新年礼物。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在深圳华强北，曾经卖VR眼镜、贴牌手机和智能家居产品的柜台，纷纷开始转售电子烟。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	突如其来烧起来的电子烟，背后是资本不断添柴加火。2018年，国内有十几家电子烟公司获得资本青睐，总融资额达数亿元。Wel鲸鱼、YOOZ柚子、魔笛MOTI、TRYMIX反正、GOIN谷云、APOC……新兴的电子烟品牌让人目不暇接，俨然造就了岁末年初最火热的创业领域。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\"> <strong>风口背后的同质化</strong> \r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“电子烟界的iPhone”、“颜值爆表一口解馋”、“重新定义吸烟”……在各家打出的广告语中，几百元一支的电子烟似乎成了可供电子发烧友们品玩一番的电子玩具。然而，花哨热闹的营销语言背后，电子烟的实质技术并没有太大区别。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“花几个月到半年时间，联系供应商、备货、外观设计，剩下就不需要你再做什么了，几乎没有任何硬性投入，本质上是个非常‘轻’（投入）的生意。”早期投资人付强向媒体透露，做一个电子烟项目，对技术等原创能力的要求几乎没有门槛。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	多位行业人士透露，由于国内电子烟供应链已经被电子烟发展较为成熟的国外市场培育得非常完备，因此很多新创立品牌都是通过代工生产。有技术爱好者对几款热门电子烟进行评测后发现，几个品牌在开关控制、烟油技术等方面相差无几，只是烟弹、外壳颜色、口味等进行了不同的排列组合与拼凑。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“电子烟的产品结构并不复杂，主要构成也就是充电电池（烟杆）、雾化器还有烟油三部分。”新晋电子烟品牌灵犀创始人章晋源坦言，电子烟的制造门槛并不高，确实存在行业同质化问题，“灵犀LINX当前着重聚焦于品牌环节，属于产业链下游，希望设计的首款产品具有品牌辨识度。”\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\"> <strong>电子烟也有多重风险</strong> \r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“清肺水果味”、“健康清肺蒸汽烟”……稍加留意就会发现，不少电子烟公司将产品与健康挂上了钩。在他们口中，因抽烟承受健康风险的烟民可以通过电子烟追求潮流文化、拥有“健康生活方式”。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	电子烟是否能够像一些公司所说的那样起到“代烟”、“辅助戒烟”的功效？目前尚无定论。令人担忧的是，一些原本不吸烟的人因为对电子烟的好奇而加入了烟民行列。在游戏公司工作的白先生告诉记者，他的同事和合作伙伴里出现了好几位新一代“电子烟民”——而他们过去根本不碰香烟。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	北京营养师协会理事顾中一提醒，电子烟中虽然没有普通烟草燃烧所产生的焦油、一氧化碳等有害物，但仍然含有有毒、成瘾的尼古丁，对普通人特别是儿童、青少年仍然有危害。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	记者在一家电子烟的天猫店铺内发现，虽然商品详情页面的底部用黑色背景的字体写着“未满十八岁不允许购买”，但一不留神就会错过这一信息。并且，记者在尝试下单时，店铺对身份信息、年龄等方面毫无要求，消费者可以随意下单购买。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	顾中一还提醒，由于目前市场监管并没有完全到位，缺乏相关国家标准，电子烟产品中用到的原料、调味剂、工艺都较为随意，厂家很可能为了增加新奇体验加入一些对人体有害的物质。“哪怕是一些比较常见的添加剂，正常食用是安全的，吸入肺部却可能带来潜在风险。比如丙二醇是很常见的食品添加剂，但是燃烧后容易刺激呼吸道，一些电子烟的烟雾中也可能含有重金属。”\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	对创业者来说，更大的考验来自于市场的不确定性。在控烟大势下，多地已经将电子烟列入了管控范围。今年2月，继杭州、南宁等城市在公共场所禁止使用电子烟之后，深圳在其控制吸烟条例征求意见稿中将电子烟纳入了控烟“黑名单”。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	意识到道德、法律等多重风险，一些科技上市公司急于与电子烟划清界限。今年2月中旬，小米公司官方微博就对“小米旗下生态链公司将进军电子烟领域”一事进行回应，称“小米不会做电子烟，此事纯属谣言”。\r\n	</p>',	'doc.png',	1.00,	1,	0,	0,	0,	'2019-12-03 14:18:03',	'admin',	2,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	1.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	3,	1,	0,	1),
(72,	'杜家毫：确保十九大精神家喻户晓深入人心',	'<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	2018年可谓是中国智能音箱的元年。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	业内普遍认为，智能音箱是切入智能家居使用场景、并易于被用户接受的理想入口，而智能家居的开关一旦被打开，更多的产品和服务将快速进入消费者的日常生活，获得一个更多元的商业环境。因此，近两年国内外科技巨头、互联网巨头皆大力发展智能音箱，使得该领域得到飞跃式增长，并从小众逐渐走向大众。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	值得一提的是，智能音箱除了具有巨大的消费市场外，对于互联网巨头们来说更起到AI市场的“门票”的作用。在这个快节奏的时代，企业之间的竞争更加激烈，率先拥有某一行业的门票就相当于成功了一半。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	由此，继国外亚马逊、谷歌、Facebook、苹果等科技巨头布局智能音箱产业之后，国内如阿里、百度等巨头也纷纷入局，小度智能音箱、叮咚、天猫精灵等产品在市场活跃度直线上升，国内智能音箱市场一片繁荣，随后在去年打起了“智能音箱价格战”。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	全球互联网巨头共掀全球智能音箱浪潮\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	根据Strategy Analytics发布的《2018年第三季度全球智能音箱市场报告》，2018年第三季度全球智能音箱出货量达到2270万，同比增长197%，创历史新高。其中，亚马逊智能音箱的全球份额与2017年相比有大幅下降，但出货量一直在上涨，第三季度市场占有率依然最高，达到32%，而谷歌以23%的市场占有率紧追其后。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	值得一提的是，来自中国的阿里、百度、小米智能音箱出货量分别排在全球第三、第四、第五位。当中又以百度表现最为亮眼，其市场占有率从2018年Q2的1％增加到2018年Q3度的8％，超越小米，成为当之无愧的黑马。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	而根据eMarketer《2019年智能音箱市场趋势观察》的预测，2019年中国将拥有8550万智能音箱用户，超过美国7420万的用户数量。智能音箱在美国网民中的普及率为26.0%，远高中国的10.0%，因此未来中国智能音箱领域还有极大的发展空间。不过即便如此，国内企业想要在智能音箱领域进一步发展仍有极大挑战。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	首先，是亚马逊、谷歌、苹果等海外企业更加成熟的智能音箱产品的冲击。亚马逊于2014年11月发布了Echo音箱，揭开智能音箱的序幕，打了人工智能领域“领头羊”谷歌、设备领域“领导人”苹果一个措手不及，成为智能音箱领域的第一人，为其之后进军智能家居领域打下基础。随后谷歌、Facebook、苹果等科技公司纷纷跟进，相继推出GoogleHome、Portal、HomePod。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	而后，无论是亚马逊并购互联网路由器初创企业Eero，还是谷歌推出Google Wifi，都表明国外在智能家居领域发展正愈加成熟，由此给国内市场带来的冲击是巨大的。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	其次，是国内错综复杂的智能音箱市场而产生的原生阻力。国内智能音箱市场厂商繁杂，主要有五种类别：一是以BATJ等为主的互联网公司，希望通过语音这一入口建立智能生态，为既有的内容和服务寻找新市场；二是以科大讯飞为代表的，专注于技术开放平台建设的技术厂商；三是以喜马拉雅等内容厂商；四是主打智能家居的创业公司；五为以漫步者为代表的传统音箱厂家。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	与国外相比，国内智能音箱领域除了厂商更繁杂、竞争更激烈外，在时间上也有一定的滞后性。国内第一款智能音箱叮咚诞生于2015年，由京东与科大讯飞联合推出。此后国内智能音箱市场沉寂，直至2017年阿里试探性地推出天猫精灵，小米、百度等企业不甘落后，纷纷入场，国内智能音箱才进入密集发售期，一时间智能音箱领域热闹非凡，“百箱争鸣”。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	当先天不足遇上恶劣生存环境\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	当下，我们不能否认的是，随着家庭中联网设备的不断增加，有极大几率成为未来智能家居控制中枢的智能音箱有着非同一般的重要性。但古往今来，利益有多大，风险就有多大。对于如钥匙般的智能音箱领域来说，发展面前有三问需解答。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	首先，智能音箱如何“智能”？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	每当市场有了新的风口，就会出现无数跟风之人，智能音箱也不例外。为搭上智能音箱的顺风车，传统音箱厂家推出不少产品，只不过卖点都集中于音质，本末倒置。 另外，“语音识别技术”也是尚未完善，一方水土一方人，同一语种还有不同口音，更别提各地方言以及语境涉及到的自然语言理解问题。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	除此之外，还有人工智能和物联网领域中老生常谈的安全隐患问题，如数据存储、身份认证、敏感数据保护等，在此不多赘述。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	其次，智能音箱如何提高普及率与使用率？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	我们知道，物联网时代“未来智能家居的控制核心”这一定位是智能音箱如此火热的重要原因之一。而理想的智能家居生态并非是家居单品的智能化，而是彼此联动，达到互联互通互控的状态，但目前的智能家居系统仍旧处于互相独立的状态，使得智能音箱使用率不高，如同“鸡肋”。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	与国内相比，国外在此方面就先进得多，以美国为例，美国的智能家居行业有统一的标准协议，亚马逊的Echo可以直接接入各种智能家居设备，这也是为何美国智能音箱普及率远高中国的原因。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	最后，国内企业如何“走出去”？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在用户习惯方面，国内外有着不小的差异。以使用环境为例，国外用户居家环境多为开放式，美国家庭主妇在烹饪时都喜欢听音乐，因此智能音箱在国外的消费需求也相对较高。而国内，厨房客厅封闭性更高，生活环境相对嘈杂，相应地市场对智能音箱需求较低。此为国外厂家难以进入中国市场的重要原因之一，另一限制则是人机交互的“本土化”程度低。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	以苹果HomePod为例，虽然其Siri语音助手对中文的支持已经有一定成果，但在交互、理解能力等方面，与本土选手阿里、百度相比仍是落后。并且，以BAT为代表的国内企业拥有更多本土资源，境外企业如苹果，很难在中国有突破性进展。同理，国内企业想要走出去也会遇到同样的难题。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	综上，智能音箱可谓是“腹背受敌”，而现阶段各巨头发展智能音箱的主要目的并不是盈利，而是抢占更多的用户家庭，为未来AI生态建设进行数据铺垫。那么，中小企业如何在这场战争中存活呢？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	双重风暴下，智能音箱可靠内容过冬\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	前文提过，国内有一类以喜马拉雅为代表的注重内容的智能音箱厂商，笔者认为现阶段此类厂商可能更好存活。现今用户对智能音箱的主要需求还处于“听”的情况下，智能音箱很大程度上是内容生态之争。在此基础上，喜马拉雅以自身丰富的内容为基础，推出智能音箱小雅，将更容易在家庭场景中突围。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	虽然从整体上看，喜马拉雅与BATJ等互联网巨头在技术和未来AI整体布局上存在相当大的弱势，但由于各种原因的限制，国内用户对智能音箱的需求在接下来很长一段时间里，都将处于“听”的阶段。并且，智能音箱核心技术“语音识别”，从本质上来说也是内容的一部分。从另一角度看，喜马拉雅的竞争对手也并非是BATJ等互联网巨头，其在智能音箱领域的发展更多的是为了扩充自身音频业务，巩固自身在在线音频市场的地位。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	同样的，在内容资源上有着强大优势的还有腾讯，毕竟现阶段消费者购买智能音箱的主要用途就是内容消费和智能家居两方面。在此基础上，腾讯可将自身音乐、阅读和视频整合，为智能音箱做内容支持。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	除了内容消费，“智能音箱+教育”的模式发展空间也十分广阔，尤其是早教领域。抛开说烂了的在线教育，光是国人对子女教育的重视程度，就足以让智能音箱注意到“早教”这一领域。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	单从目前智能音箱市场情况来看，短时间内C端消费市场的表现都比不过B端。因此，如何在B端站稳脚跟再最终反哺C端，是智能音箱发展过程中相当重要的一点。站在这个角度上看，“智能音箱+早教”的未来十分令人期待。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	毕竟，国内早教行业师存在资水平有限，地域发展不平衡，多数幼师仅经过短期培训就上岗从业，专业化程度低等问题。若是将智能音箱与早教结合，它所承载的大量专业、系统、科学的早教课程，能完美弥补传统绘本、书籍、视频等的缺点，再加上其操作简单、安全性高、不损伤视力的优点，能让智能音箱成为早教过程中不可或缺的工具。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	当然，除了以上两个方向，智能音箱作为人工智能音频端的入口，能够发展的B端场景是十分丰富的。就此，在C端市场来临前，国内非巨头企业在智能音箱领域也有了新的突破口。那有没\r\n</p>',	'doc.png',	1.00,	7,	0,	0,	0,	'2019-12-03 14:18:52',	'admin',	4,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	1.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	4,	1,	0,	1),
(73,	'甘肃镇原回应“焚书”事件：将对当事人严肃追责',	'<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	社交网络下一步发展的未来在何方？6日，Facebook创始人扎克伯格给出了自己的答案。在一篇长达3200字的公开博客文章中，这家全球最大的社交网络的掌门人称，未来Facebook将专注于营造一个更为私密和安全的网络社交环境。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“当我思考网络的未来，我认为专注于隐私的通讯平台相比今天的开放平台，将变得更加重要，”扎克伯格写道：“今天我们已经看到私密消息、短故事分享和小规模群组是在线通讯交流发展最快的领域。”\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	尽管扎克伯格认为，开放社交网络在未来仍有一席之地，但更大的机会在于“建立一个首先专注于隐私的更为简单的平台。”\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	扎克伯格称，在过去15年间，Facebook和Instagram帮助建立了一个“数字化的公开广场“，但人们开始迫切需要更为私密的”数字化的客厅空间“。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	对于Facebook来说，这将是一个具有里程碑意义的转型，成立15年来，Facebook成功打造了全球最大的公开社交网络，并在此基础上建立起一家以广告业务为主的商业帝国。但近年来，随着一系列与用户数据隐私泄漏相关的丑闻接连爆发，Facebook开放社交模式遭遇到前所未有的严峻挑战。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	正是由于内外部坏境发生的变化，促使Facebook开始思考接下来的转型方向，如今，这家全球最大的社交网络通过其掌门人的一封公开信给出了解答。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“我认为未来的通讯将更多地转向私密的、加密的服务，这样人们在与别人交流时，对于信息的安全新、内容不会停留会更有信心，”扎克伯格说，“这是我希望我们能够帮助带来的未来。”\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	为了达成这一目标，扎克伯格称，Facebook即时通讯平台将向Whatsapp的模式靠拢，未来端到端的加密服务将贯穿于Facebook所有旗下包含即时通讯的业务功能，该表态印证了此前外界流传的Facebook计划打通旗下即时通讯功能的传言。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	扎克伯格称，计划按照打造WhatsApp的模式进行：专注于最为基本和私密的应用场景即时消息开始，让其尽可能的安全，然后在此之上建立更多让人们能够互动的方式，包括打电话、视频聊天、群组、故事、商业、支付最终成为更多私人服务的平台。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	为了实现这一转型目标，扎克伯格列出了数项准则，包括加密、缩短内容的存续、安全、互通和安全数据存储。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“我相信我们应该朝着建立这样一个未来世界而努力：人们可以私下说话并且知道他们的信息只会让他们希望看到的人看到并且不会永远存续下去，“扎克伯格说，”如果我们能够帮助世界朝着这个方向发展，我将会为我们所做出的努力感到自豪。“\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	以下为扎克伯格公开博客全文：\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	注重隐私的社交网络愿景\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	过去几年，我的重点一直是理解和应对Facebook面临的最大挑战。这意味着对关系到互联网未来的重要问题采取什么立场。在本文中，我将概述Facebook围绕建立以隐私为中心的信息和社交网络平台的愿景和原则。有许多的事情要做，在开发的进程中，我们承诺开放式的工作，并将与全社会的专家进行协商……\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	过去15年间，Facebook和Instagram一直在帮助人们与友人、社区和等同于数字城市广场中的兴趣联系在一起。但是人们也越来越想私下在相当于起居室的数字环境中进行交流。当我思考互联网的未来时，我认为一个注重隐私的交流平台将变得比今天的开放平台更加重要。隐私让人们有自由做自己，更自然地联系，而这些是我们建立社交网络的原因。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	今天，我们看到私有信息、短暂的故事和小型群组已成为在线通讯中增长最快的领域。这有许多原因。许多人更喜欢一对一交流，或者只是与几位朋友交流。人们对分享有永久记录的内容更加谨慎。我们也都希望能够私下和安全地进行支付。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	公共社交网络将继续在人们的生活中发挥重要作用--与你认识的每一个人联系；发现新的人、想法和内容；让人们有更广泛的发言权。人们每天都会发现有价值的内容，而且还有很多有用的服务可以构建在它们之上。但是现在，人们也想通过各种方式私下交流，这也让我们有机会打造一个首先专注于隐私、更简单的平台。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	我明白很多人不认为Facebook有能力、或者甚至不想构建这种以隐私为中心的平台，因为坦率地讲，我们目前在构建隐私保护服务方面没有很好的声誉，而且我们一直专注于更开放的共享工具。但是我们已多次表明，我们可以通过进化来打造人们真正想要的服务，包括私有信息和故事。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	我认为，通信的未来将越来越多地转向私有、加密服务。在此类服务中，人们可以确信他们对彼此说的话是安全的，他们的信息和内容不会永远存在。这是我希望我们能帮助实现的未来。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	我们计划用开发WhatsApp的方式来构建这一平台：专注于最基本和私有用例--消息--尽可能确保它的安全性，然后构建更多的方式让人们在此基础上进行互动，包括通话、视频聊天、群聊、故事、商业、支付、商务，最终成为许多其他类型的私有服务的平台。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	这个注重隐私的平台将围绕以下几个原则构建：\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	·私下互动：人们应该拥有简单、亲密的场所，在那里可以清楚地控制谁可以和他们交流，并且相信没有人可以接触到他们分享的内容。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	·加密：人们的私人通信应该是安全的。端到端加密防止任何人，包括我们在内，看到人们分享在我们服务中的内容。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	·减少永久性：人们应该感到自在，不应担心他们分享的内容会反过来伤害自己。因此，我们不会将信息或故事保留超过提供服务所需的时间，也不会超过人们希望它们留存的时间。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	·安全：人们应该期待我们会尽一切努力，在加密服务可能的范围内，确保他们在使用我们服务时的安全。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	·互操作：人们应该能够使用我们的任何应用联系他们的朋友，应该能够轻松安全地通过网络交流。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	·安全数据存储：人们应该期待我们不会在隐私和言论自由等人权记录薄弱的国家存储敏感数据，保护数据被不当访问。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	未来几年中，我们计划围绕这些想法重建更多的服务。在此行程中，我们面临的决定将意味着对关系到互联网未来的重要问题采取什么立场。我们清楚有很多权衡需要纠正，我们承诺与专家进行协商，并讨论最佳的前进方向。这需要一些时间，但我们不会关着门朝着这个方向发展。我们将尽可能以公开、合作地态度这样做，因为其中许多问题影响到社会的不同层面。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	私下互动是基础\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	要让一项服务感觉具备私密性质，绝不让用户怀疑在和谁交流。我们努力在所有产品中建立隐私属性，包括公共分享产品。消息服务的一个重要特性是，即使用户的联系人列表在扩充，用户的个人线程和群组仍然是私有的。随着时间的推移，用户的好友会逐渐发展，消息服务会优雅地发展，并保持亲密。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	这与更广泛的社交网络不同。在社交网络中，人们可以积累好友或追随者，直至服务更加公开。这非常适合许多重要的用途--告诉用户所有的朋友一些事情，在重要的话题上传递用户的声音，寻找有相似兴趣的人群，追踪创作者和媒体，买卖东西，组织筹款人，发展业务，或者让用户认识的每一个人在相同的地方得到好处。尽管如此，当用户一起看到所有这些经历时，感觉更像是一个城镇广场，而不是一个更私密的空间，比如客厅。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	我们有机会建立一个关注人们想要私下交流的所有方式的平台。这种隐私和亲密感不仅仅是技术特征--它被深深地融入到服务的整体感觉中。举例来说，在WhatsApp当中，我们的团队专注于在产品的各个方面创造一个亲密的环境。即使我们构建了允许更广泛分享的功能，这仍然是一种不太公开的体验。当团队开发群组功能时，他们设定了规模限制，以确保每一次互动都是私密的。当我们在WhatsApp上发布故事时，我们限制了公共内容，因为我们担心这种做法可能会削弱隐私感--即使这并没有真正改变用户和谁分享。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	几年后，我预计未来版本的Messenger和WhatsApp将成为人们在Facebook网络上交流的主要方式。我们致力于让这两款应用更快、更简单、更私密、更安全，包括端对端加密。然后，我们计划增加更多与好友、团体和企业私下交流的方式。如果这种进化成功，通过Facebook网络与用户的好友和家人互动，将会从根本上成为一种更加私密的体验。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	加密与安全\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	人们期望他们的私人通信是安全的，并且只被收方看到，而不是黑客、罪犯、过度干预的政府，甚至是操作正在使用的服务的人。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	人们越来越多的意识到，更多的实体可以访问自己的数据，就越容易被人滥用或被网络攻击泄露。一些人也越来越担心，技术可能会将权力集中在政府和像我们这样的公司手中。一些人担心我们的服务可能会访问他们的信息，并将其用于广告或其他他们不期望的方式。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	端到端加密是开发注重隐私的社交网络的重要工具。加密正在分散--它限制了像我们这样的服务看到流经的内容，并使其他人更难访问用户信息。这就是为什么加密在我们的网上生活中越来越重要，从银行到医疗健康服务。这也是为什么我们在收购WhatsApp后把端到端加密植入WhatsApp中的原因。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	去年，我曾与持不同政见者交流过。他们告诉我，加密是他们自由甚至活着的原因。一些政府经常对数据提出非法要求，当我们在法庭上驳回这些要求时，我们总存在败诉的可能--如果信息没有加密，我们要么必须交出数据，要么不遵守法庭规定导致员工被逮捕。这看起来很极端，但是我们曾有过这样的案例，一名员工就因为不提供对某人私有信息的访问而身陷囹圄。事实上，我们也无法访问这类信息，因为它是加密的。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	与此同时，在我们能够在所有消息服务中部署端到端加密之前，我们需要解决真正的安全问题。加密是保护隐私的有力工具，但也包括做坏事的人的隐私。当数十亿人使用同一服务连接时，他们中的一些人会将它滥用于真正可怕的事情，比如剥削儿童、恐怖主义和敲诈勒索。我们有责任与执法部门合作，并尽所能帮助防止这些行为。我们正努力通过检测活动模式或其他方式，来提高识别和阻止应用中不良行为的能力，即使我们看不到消息的内容，我们将继续对这项工作进行投资。但是我们面临着一个内在的权衡，因为当我们的安全系统能够看到这些信息时，我们永远也不会发现我们今天所做的所有潜在伤害。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	找到保护隐私和安全的正确方法，是社会在历史上一直努力解决的问题。这里还有许多悬而未决的问题，我们将与安全专家、执法部门和政府协商实施安全措施的最佳方式。我们还需要与其他平台合作，以确保整个行业能做出正确的事情。我们越是能创造一种共同的方法越好。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	总的来说，我相信为所有私人通信实施端到端加密是正确的。人们通过信息和电话完成一些最敏感的私人谈话，在网络安全威胁日益增加、许多国家政府干预过度的情况下，人们希望我们采取额外措施来保护他们最私密的数据。对我而言这似乎是对的，只要我们花时间构建适当的安全系统，尽可能在加密服务的范围内阻止不良行为。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	我们已开始在WhatsApp的基础上开发这些安全系统，在全面实施端到端加密之前，我们将在2019年及以后与专家讨论这些系统。随着我们从专家那里学到更多的知识，我们将最终确定如何推出这些系统。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	减少永久性\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	我们越来越相信在短时间内保存信息非常重要。人们想知道他们分享的信息不会反过来伤害他们，减少他们信息的存储和访问时间会有所帮助。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“永久性问题”开发社交工具的一个挑战是。随着时间的推移，我们积累了大量的信息和照片，它们在成为资产的同时，也成为了一种负担。例如而言，许多Facebook的老用户可能会有年轻时候的照片，这可能会让人尴尬。但是人们也非常喜欢记录他们的生活。如果Facebook和Instagram上的所有帖子都消失了，人们将无法获得他人分享的大量宝贵知识和经验。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	我认为有机会为私有通信平台设定一个新的标准--内容会自动过期或随时间归档。除非用户存档，否则故事会在24小时后过期，这让人们更自然地分享。这种理念可以扩展到所有私人内容。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	举例来说，在默认情况下，信息可以在一个月或一年后删除。这将降低用户的信息再次出现并让他以后尴尬的风险。当然，如果用户愿意，可以自己改变时间框架或者关闭线程的自动删除。如果用户愿意，我们还可以为用户提供选项，让他将个人信息在几秒钟或几分钟后设置为过期。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	限制我们存储消息元数据的时间也有意义。我们使用这些数据来运行我们的垃圾信息和安全系统，但我们并不总是需要长时间保留这些数据。解决方案的一个重要部分是首先收集较少的个人数据，这也是WhatsApp从一开始就建立的方式。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	互操作\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	人们希望能够选择他们用来与人交流的服务。然而，今天如果用户想在Facebook上给人们发信息，你必须使用Messenger；在Instagram上必须使用Direct；在WhatsApp上必须使用WhatsApp。我们想给人们一个选择，这样他们可以通过这些网络从他们喜欢的任何一款应用联系他们的朋友。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	互操作性有隐私和安全优势。举例来说，许多人使用Android上的Messenger收发短信。这些文本不能进行端到端加密，因为短息协议没有加密。然而，有了跨我们服务传递信息的能力，用户就可以从Messenger向WhatsApp中的某人的电话号码发送加密短信。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	这还可以提高许多体验中的便利性。在这些体验中，人们使用Facebook或Instagram作为他们的社交网络，WhatsApp作为他们首选的消息服务。举例来说，许多在市场上出售商品的人会列出他们的电话号码，这样人们就可以发送与购物相关的信息。这并不理想，因为用户要给陌生人提供电话号码。有了互操作性，用户就可以使用WhatsApp接收发送到Facebook账户的信息，而无需分享电话号码--买家也不用担心卖家是喜欢在哪个网络发信息。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	可以想象许多类似这样的简单体验--一个人在Instagram上发现了一家公司，并很容易过渡到他们喜欢的消息应用，以获得安全的支付和客户支持；另一个人想追上一个朋友，可以向他们发送一条消息，发送到他们喜欢的应用，而不必考虑这个人喜欢在哪里被联系；或者用户只需在Facebook和Instagram上发布一天的故事，就可以在一个地方得到好友的所有回复。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	今天，用户已可以通过Android上的Messenger发送和接收短信，我们希望在未来进一步扩展这一功能，或许包括新的电信RCS标准。然而，在这成为可能之前，我们需要解决几个问题。首先，苹果不允许应用在他们的设备上与短信交互操作，所以我们只能在Android上这样做。其次，我们需要确保互操作性不会损害人们已使用WhatsApp的加密预期。最后，它会在加密系统中造成安全漏洞和垃圾邮件漏洞，让人们从未知的应用中发送信息，因为我们的安全和安保系统看不到这些活动的模式。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	这些都是重大挑战，有许多问题需要进一步协商和讨论。但是，如果我们能够实现这一点，我们就可以给人们更多的选择，让他们使用喜欢的服务，以安全地联系到他们想要联系的人。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	安全数据存储\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	人们想知道他们的数据安全地存储在他们信任的地方。展望互联网和隐私的未来，我认为我们将做出的最重要的决定之一是：在哪里建立数据中心和存储人们的敏感数据。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在一个国家提供服务和在那里存储人们的数据有着重要的区别。当我们在世界各地建设基础设施时，我们选择不在有侵犯隐私或言论自由等人权记录的国家建设数据中心。如果我们在这些国家建立数据中心并存储敏感数据，而不仅仅是缓存非敏感数据，这可能会让这些政府更容易获取人们的信息。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	坚持这一原则可能意味着我们的服务在一些国家会受阻，或者我们不能很快进入其他国家。这是我们愿意做出的折衷。我们不认为在一些国家存储人们的数据是一个足够安全的基础，可以在其上建立如此重要的互联网基础设施。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	当然，保护最敏感数据的最佳方法是根本不存储它，这就是WhatsApp不存储任何加密密钥的原因，我们计划在以后的其他服务中也这样做。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	但是在更多国家存储数据也开创了一个先例，鼓励其他国家政府寻求更大程度地获取其公民的数据，从而削弱了全世界人民的隐私和安全保护。我认为，对于互联网和隐私的未来而言，我们的行业继续坚决反对把人们的数据存储在得不到安全保障的地方，这一点很重要。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	下一步举措\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在接下来的一年及以后，我们还要制定出与这些原则相关的许多细节和权衡。这项工作中的许多仍处于早期阶段，我们致力于与世界各国的专家、倡导者、行业合作伙伴和政府(包括执法部门和监管机构)协商，以正确做出这些决定。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	与此同时，通过这些原则开展工作只是构建以隐私为中心的社交平台的第一步。除此以外，我们还需要对在此基础上构建的所有服务进行深入思考--从人们如何支付和金融交易，到企业和广告的作用，再到我们如何为其他私人服务提供平台。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	但是，这些最初的问题得到正确答案是至关重要的。如果我们做得好，我们可以创建私人共享平台，这对于人们而言可能比我们建立的帮助他们更公开分享和联系的平台更重要。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	这意味着对关系到互联网未来的重要问题采取什么立场。作为一个社会，我们有机会阐明我们的立场，决定我们如何重视私人通信，以及谁来决定数据应该存储多长时间以及存储在哪里。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	我认为我们应该努力实现这样一个世界，让人们可以私下交谈，自由生活，知道他们的信息只会被他们想看到的人看到，而且不会永远停留在身边。如果我们能帮助世界朝着这个方向发展，我将为我们所取得的成就感到自豪。\r\n	</p>',	'doc.png',	1.00,	28,	0,	0,	0,	'2019-12-03 14:19:38',	'admin',	1,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	1.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	11,	1,	0,	1),
(74,	'到月球建核热推进传送器?NASA星际探索正稳步推进',	'<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	今年两会期间，明星委员们的提案再次将炮火对准了劣迹艺人、明星及影视数据造假、身价片酬等行业乱象，不过前方固然慷慨激愤，后方还是其乐融融，#明星该不该吃粉丝送的食物#、#明星被认错#等话题频繁被推上热搜，娱乐氛围依旧。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	但今年还是有些许不同，2018年影视连续震荡所牵引出的政策新规，将在今年集中落地并被检验效果，前段时间，吴秀波、翟天临事件又掀起公众对娱乐圈造假的口诛笔伐。换句话说，娱乐产业规则改写的时机，可能已经同时具备了政策自上而下和舆论自下而上的两个必要条件。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	若是如此，数据造假将成第一个靶子，而往后推，数据造假的一环如果被铲除，是否能动摇当前畸形的粉丝经济呢？这是值得业界探讨的。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	造假产业链的逆向思考\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	2019年开年，《人民日报》发表文章，矛头直指流量明星锁场、刷榜、买粉丝，而后其又连续发表微博，感慨“明星流量数据节节攀升，8亿网民不够用”。随之跟进的还有《光明日报》《北京日报》，而“紫光阁”则从1月5日-9日，连发4条微博，痛批流量明星，呼吁“没有高质量作品做支撑，那些拙劣的表演终将被揭穿”。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	影视产业春寒料峭，一场“打假运动”的兴起，或许正是今年的新风向。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	微博已率先做出反应，宣布针对转发、评论计数显示方式在内做出种种调整，而更早之前，爱奇艺和优酷停止了播放量的展示。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	这对于影视数据脱水进而回归合理无疑是一个有利信号，视频及社交平台本身就是流量造星、粉丝运营的核心媒介，隐藏播放量起码减掉了数据造假的一个需求。虽然不得不承认，这一举措对整个行业来讲，也只是让数据造假不至于假得太“难看”，但其释放的市场信号是积极的：影视数据造假的乱象，今年或许不会止于揭露。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	以此为基础，我们再来看影视产业数据造假的产业链。一般来讲，卖方一端通过雇佣技术型或人工型水军，提供刷流量业务，至于买方一端，央视将明星数据造假的推手，归为自发组建的粉丝组织和经纪公司安排成立的明星微博数据站。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	两方需求契合，流量明星通过这一番操作获取一定的人气和地位，从而掠取演艺资源。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	而提供演艺资源的制片方、投资方以及媒体平台，又因流量明星的参与而收割商业利益，当然，这其中更少不了购买数据用以打榜、投票、转发的过程。无奈的是，这已成为市场优胜劣汰的“规则”，如果粉丝的偶像数据不好，就会被其他艺人的粉丝“唱衰”。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	由此可以看出，流量经济是一个参与方都可获得经济效益的模式，这也决定了很难从内部去戳破流量泡沫。但如今政策导向下，很有可能从外部强制性切断数据造假产业链，若是如此，会对以流量为基础的粉丝经济造成什么伤害？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	我们可以逆向推断，假使数据归真，流量明星及其所产出的内容，在市场的反应能够一目了然，首先最可能放弃他们的就是内容生产方。因为对比靠实力说话的演员，流量明星原本与之天差地别的流量优势，很大程度上被削弱了，而今口碑反噬又日渐严重，制片人也不再经得起多次的扑街。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	相应地，流量明星的演艺资源一旦被缩减，曝光度大大降低，广告商、媒体以及平台很快便“闻风而动”。更关键的是，明星本人新粉难增、旧粉流失，长此以往就更没有商业价值了。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	流量经济还是粉丝经济？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	当娱乐产业的优胜劣汰逐渐被流量所左右，如果从流量数据本身出发，一定程度上是可以约束某些行业乱象的滋生。但是流量缩减、粉丝仍在。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	蔡徐坤被央视点名时，震慑是对业内的，粉丝看似不惧。真爱粉们一面为爱豆打抱不平，力挺蔡徐坤确实是个专注音乐的好歌手，甚至表示之前做了那么多公益怎么不提？另一面又将攻击点集中到微博上，强烈要求整改。不过，前者是顾左右而言他，后面则是祸水东引，实则都没什么逻辑。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	从这件事直观地看，粉丝本身就是流量的一部分，即使最大程度地将流量数据脱水，蔡徐坤、鹿晗这类当前比较符合年轻群体审美的明星，也仍有不在少数的粉丝存留，他们才是饭圈的核心。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	换句话说，粉丝即使不花钱为他们的偶像刷流量，他们还是有其它方式向外界传达和证明自家爱豆的价值，甚至可以简单的说，只要粉丝愿意为爱豆花钱，在制片人和品牌方眼里，明星便有商业价值。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	这主要是因为当前的影视行业中，<strong>粉丝看似处于被收割的产业下游，实则主导着偶像的人气和商业吸引力。</strong> \r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\"> <strong>一方面，粉丝已经参与到偶像的职业规划中，用自己的力量为偶像争取好资源。</strong>而市场也认可了这种做法，现在广告商、制片方最看重的，不再是明星的业务水平，而是背后的粉丝力量。所以，纵然市场能抛开流量数据，演员和明星粉丝群体的差别，也无法使商业资源偏向前者。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\"> <strong>另一方面，如今流量明星的粉丝展现出强大而可怖的集体力量，如果不再允许数据造假，他们对舆论的影响也能帮助明星维持流量再造。</strong>极端一点，像粉丝骂战、撕逼这种普遍现象，一经推手，在当前这个碎片化时代便是天然的流量爆发点。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	所以，<strong>数据打假所能纠正的也只是流量经济，而触及不到更深层次的粉丝经济。</strong> \r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	时至今日，粉丝和流量的先后产生顺序已经模糊，这就是数据造假导致的，不过粉丝是基础，流量经济可以说是在资本介入、疯狂膜拜粉丝效应之后被放大的形态。这和移动互联网时代流量为王的思维，实则异曲同工。不过移动互联网进入下半场的服务升级，娱乐产业的流量经济反而日渐衰颓了。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	明星“死于”粉丝？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\"> <strong>围绕粉丝和明星的行业规则及利益链一旦形成，实际上就连一个环节的整治都很难，更不要指望其内部会自我改进。</strong>但值得庆幸的是，当前流量经济之所以逐渐露出真相，在于其外部的反对力量日益强大，也催促市场形成一套新的淘汰法则。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	最明显的是电影界，流量明星的多番试水，让投资方再也经不起折腾。2016年“小鲜肉+大IP”的模式备受追捧，2017年参与暑期档大战的流量明星只有杨洋、李易峰两人，而到2018年暑期档、春节档，杨洋、鹿晗等人早已不见踪影。李易峰的《动物世界》即使备受肯定，票房仍不能回本。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	数据显示，2018年全国电影票房已经超过2017年总票房559.11亿元，创下新纪录，但票房前十的影片主演中均不见小鲜肉身影。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	流量明星开始被排斥在大荧幕之外，而且他们在业内留下的印象一旦被定性，投资人只会对他们避之不及。而下一个排斥流量的便是观众，这很容易让流量明星丧失转型的时机，甚至是永久被划在攻击的范围之内。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	这是口碑反噬的副作用，比如《创业时代》开播之初，很多人还没看剧，只知道有杨颖主演便给出了一星评价，迪丽热巴则一个人把《声临其境》的评分拉到了4.3。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	一个经典角色可以成就一个明星，但一个明星也有可能毁了众多角色，观众便将不满全部发泄到流量明星身上，反而不会再客观考虑是不是剧本、导演不行。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	不过作品口碑败光的更多是路人缘，而且市场通过这种副作用反噬的方式淘汰流量明星，毕竟是一个相对缓慢的过程。关键是，他们背后的死忠粉依然是“东山再起”的资本。<strong>所以一个流量明星的消失或死亡，完全取决于粉丝。</strong> \r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	事实也是如此，我们看到，<strong>人设崩塌是最近常见的最快导致明星坠落的方式，而人设本质就是为迎合粉丝存在。</strong>粉丝心理假说认为，追星一种身份认同，粉丝通过对名人的“镜像”认识自己，塑造价值观，而一旦粉丝发现这种“镜像”是虚假的，认同感瞬间就消失了，而且会有上当受骗的感觉。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	当然，粉丝也是善变的，他们自然而然流失，流量明星们也就被市场抛弃了。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\"> <strong>流量数据的虚假泡沫被戳破总归是好的，但娱乐行业的乱象却无法根治，终究是粉丝把明星捧得太高了。</strong> \r\n	</p>',	'doc.png',	1.00,	19,	0,	0,	0,	'2019-12-03 14:20:16',	'admin',	3,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	1.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	4,	1,	0,	1),
(75,	'朱丹再口误错喊陈立农为\"赵立农\" 致歉:谢谢你的包容',	'<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	你可能不知道咪蒙，但却一定知道她有一个月薪5万的助理。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	年初，在“寒门状元”事件之后，咪蒙就曾宣布关停微信公众号两个月，并永久关停微博。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	不想仅仅过了不到一个月，2月21日咪蒙以及旗下“才华有限青年”等微信账号就宣布将被永久关停。旗下美妆账号改名为“李粒粒LiLiLi”，咪蒙小号“好疼的咪蒙”则清空了所有内容。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	从咪蒙公布之前公布的报价来看，其微信公众号头条广告报价一度到达80万元，二条也有40万元。这次的账号注销还包括今日头条、凤凰号等等，并称咪蒙“不得转世”。咪蒙的商业帝国几乎被连根拔起。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	除了自媒体，同时可能就此终结的还有咪蒙刚刚开始的编剧生涯。2018年3月，柠萌影业曾经宣布，由咪蒙担任编剧的网剧《长大成人》正在筹备中。现在咪蒙被封，这部“神似”《欢乐颂》的作品最终何去何从也被画上了问号。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\"> <strong>“毒鸡汤女权”，这不只是咪蒙的专利</strong> \r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	正如我们上文所说，咪蒙还在积极谋求走向影视圈，成为编剧便是第一部。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	了解咪蒙的人都知道，咪蒙的文章一向以宣扬所谓“女权”为导向，用一碗一碗的鸡汤，挑动着公号中近600万女性粉丝的内心。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	作为一个影视的门外汉，咪蒙之所以开始进军影视当编剧，其实和中国影视，特别是网台剧当中 “大女主”等题材层出不穷有着直接关系。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	从《欢乐颂》里的五个姐妹，到《我的前半生》里的罗子君，从楚乔到关皮皮，不一而足。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	然而，在这些所谓的“大女主”或者“女权”剧却很少体现真正的女权，而或多或少的会体现出“咪蒙式女权”的感觉。 男一都会对我不离不弃，男二都会生死相依，男三都会“我的眼里只有你的桥段大行其道，靠男人上位的情节也充斥其中，女权成为了寄居在男权上的笑话。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	再有，许多职业剧也会加入大量爱情桥段，“谈判官”改谈恋爱，“猎头”改“猎对象”的情况也多次发生。这也正如咪蒙的风格，看似让人“自强不息”，实则只想让你成为“坐在宝马里笑的人”；看似是在不断激励，实际只是找准了观众的七寸，然后一颗颗的吃下早预备好的“致幻药丸”。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	但这样的剧情虽然满足了女性观众对于爱情内容的需要的同时，本身也局限了内容的发展。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	首先，这样的剧所有内容几乎都必须围绕爱情展开，亲情、职场、宫斗、武侠等本应该更重要的戏份反而成了陪衬。由此，很多所谓的职场剧、宫斗剧到头来都变成了无限尴尬的爱情剧。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	更重要的是，“咪蒙式的女权剧”并不是真正的男女平权，当女性意识进一步觉醒之后，就会开始逐渐摒弃这种价值观。正如《致橡树》中所说，“我如果爱你，绝不学攀援的凌霄花”。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	再次，随着90后以及更年轻观众的崛起，单身才是社会更加主流的形态。生活方式的改变也会影响大家对于影视剧的观看喜好。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	更进一步说，“大女主”实际上是披着女性思维的外衣，但实际上却站在男性立场的表现。女性是白莲花、傻白甜，需要靠男性，甚至众多男性实现目的，这其实是一种变向的“被包养”。托名女权，实际宣扬的却是一种并不合理的价值观。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	咪蒙已经悄然落幕，但“伪女权”却依然大量存在于影视剧之中。但随着品质口碑成为了市场主流，真正的女权影视剧登上舞台恐怕也不会太远了。\r\n</p>',	'doc.png',	1.00,	36,	0,	0,	0,	'2019-12-03 14:21:05',	'admin',	10,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	1.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	13,	1,	0,	1),
(76,	'特朗普：民主党的弹劾条款“太弱了” 真丢人现眼',	'<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	短视频行业的发展无疑已经进入到了深水区，以短视频变现为代表的全新发展正在把这个行业越来越多地放到了市场的前台。作为一种全新的内容表现形式，短视频在经历了资本乱战、巨头追捧之后，或许应该进入这个“年纪”。然而，变现并非易事，短视频变现更是难上加难。如果能够走出短视频变现的考验的泥淖，这个行业的发展无疑将会发展成熟。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	当然，如果仅仅只是一味地追求变现，而不去深究短视频本身的内在运行逻辑。所谓的短视频变现同样会陷入困境，火爆的短视频行业将会如同火爆的流量一样陷入表面的繁华。的确，几乎所有的商业模式都应该形成一个生态闭环，才能称得上是一个成熟的商业模式。如果仅仅只是停留在某个阶段的繁荣，所谓的商业模式仅仅只是一个概念，无法真正落地。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	我们看到当前以抖音、快手为代表的短视频行业巨头都在进行变现层面的探索，无论是社交，还是电商，对于短视频背后更加深层次的商业层面的探索正在成为一种发展的主流。不可否认的是，尽管短视频变现进行得如火如荼，但是依然逃不脱现实的尴尬，短视频行业的变现依然面临诸多挑战。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	从繁荣期到精耕期，短视频行业正在经历阵痛\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	作为一种在移动互联网时代的后半段崛起的内容表现形式，短视频行业的发展无疑备受追捧。无论是资本还是巨头，对于这种新式的内容展现形式都充满了好奇与期待。融资数额的不断增加、融资速度的不断加快都在说明市场对于短视频行业偏好程度。尽管短视频行业从一开始就被互联网巨头所青睐，但是，它的发展依然要经历所有的事物都会经历的阶段。从资本吹捧的繁荣期到商业变现的精耕期，短视频行业的发展无疑正在经历一次全新的阵痛。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	火爆的背后是短视频行业远离商业本质的尴尬。几乎所有的人都知道，短视频行业的发展一直都是一路高歌，无论是从用户获取上，还是用户日常的表现数据上，短视频行业的发展都是相当夺目耀眼。尽管短视频行业看上去异常火爆，但是火爆的背后却是变现困难的尴尬。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	从始至终短视频行业都在扮演着一种流量导流的角色，通过短视频将流量聚集在一起，再通过流量下沉到电商、社群等其他领域，从而实现真正意义上的变现。其实，从流量获取到流量导入已经有了许多的用户流失，再把这些流量落地到具体产品上又会有更多的流量流失。因此，仅仅只是将短视频看成是一个流量导入的工具，而不去从短视频本身着手，直接进行变现正在让短视频行业的发展陷入一种尴尬的境地里。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	当我们看到短视频平台动辄几亿的用户流量的时候，其实无法真正掩盖现实的尴尬。一味地看中短视频本身的流量价值，而忽略了更多新的探索，短视频行业正在陷入一场远离商业本质的尴尬。在流量红利已经见顶的大背景下，一味地去强调短视频行业的流量作用，无疑是一次与现实的抵抗。在流量已经被证明是一种无效资源的大背景下，短视频行业盲目地加大自身在流量上的作用，无疑是一场冒险。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	依附于巨头的怀抱让短视频缺少对于商业世界的认知。作为一种全新的内容展现形式，短视频行业从一开始就依附于互联网巨头。无论是资本投资，还是平台建设上，短视频始终都缺少自己独特的运行模式。虽然以互联网巨头作为靠山能够缓解在竞争激烈的市场当中沦陷的概率，但是如果仅仅只是一味地停留在巨头怀抱的温暖里，不去面对商业世界的残酷，短视频行业依然备受挑战。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	依附于巨头的怀抱，短视频行业仅仅只是一个内容层面的东西，它仅仅只是巨头的附庸，无法真正承担起自我寻找商业价值的重任。当巨头不再加持短视频行业的时候，它同样需要走入市场里，而不是一味地承担一个支撑者的角色。依附于互联网巨头的怀抱，短视频行业仅仅只是停留在表面繁荣的自嗨当中，不断增长的用后数据、不断增长的点赞数量、不断增加的用户浏览时长都让短视频行业感觉到自己是移动互联网后半段的王者。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	作为一种全新的内容展示形式，短视频始终都是一种内容。如果我们仅仅只是停留在巨头光环下的数据自嗨，而不去真正了解这些数据背后的真正原因。那么，当短视频行业真正进入到市场的时候，一切或许都将重新开始。当前，短视频行业正在经历的正是这样一个阶段。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	以内容为根本的短视频却无法具备内容的本质与意义。虽然短视频行业异常火爆，但是我们始终都不能忘记短视频始终都是一种内容表现形式。既然是一种内容，短视频行业从野蛮生长到精耕细作是一个必然的过程。在经历了几年的发展之后，我们却没有看到短视频行业的内容有显著提升的地方，有的仅仅只是在一些营销层面的小打小闹。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	当短视频在内容进化上出现瓶颈的时候，我们就去做商业变现上的相关尝试无疑将会把这个行业的问题和弊端全部都呈现在外面。作为一种内容展现形式，短视频行业在内容本身上缺少精耕细作和突破创新，只会把短视频行业的发展带入到一种相对艰难的境地里。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	我们看到现在的短视频的内容上依然缺少精细化的痕迹，有的仅仅只是千篇一律的雷同抑或是内容展现形式的俗套。如果仅仅只是把短视频行业仅仅停留在一种毫无进化的层面上，特别了缺少了作为内容本身所应该具备的特质，那么所谓的短视频必然将会失去原有的本质与意义。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	在经历了早期的野蛮生长、资本助推、巨头拥抱等一系列的发展之后，短视频行业的发展正在经历一场前所未有的平静期。这从另外一个角度说明短视频行业的发展并未真正跳出原有的发展套路，仅仅只是将互联网式的发展模式在极致上更进一步。突破短视频行业的发展困境，需要真正让短视频告别自嗨式的繁荣，真正回归内容本身，真正进入到商业世界的现实中历练。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	进入下半场的深水区，短视频的彷徨与退让\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	在告别了资本的加持之后，短视频行业的发展正在进入到下半场的深水区。早期的顺风顺水让短视频行业的发展难以抵挡现实的尴尬，一味地停留在数字上的繁荣，而忽略了内容本身的本质奥义，短视频行业的下半场无疑将会经历一场前所未有的彷徨与退让。但是，这并非是一件坏事，通过这种方式，我们增加能够知道短视频本质的东西是什么。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	短视频的彷徨：巨头扶持还是独立行走。短视频从诞生的那一天开始就始终没有摆脱巨头的光环，从某种意义上来讲是互联网巨头最终造就了短视频行业的今天。然而，一味地躲在互联网巨头建构的舒适区里，不去进行商业层面上的探索，所谓的短视频只会在自嗨的道路上越走越远。告别巨头的保护，真正进入到市场当中摸爬滚打，从而获得更多的生存技能或许对于短视频来讲至关重要。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	然而，如果摆脱互联网巨头的怀抱，短视频又很难在短时间内找到一条合适的路，对于处于变现关键期的短视频行业来讲，无疑是一个非常巨大的挑战。始终蜷曲在巨头的怀抱，毕竟不是一件长远的事情，短视频行业的真正未来依然在于本身的发展上。从这个逻辑来看，脱离巨头的怀抱，选择独立行走显然是一件非常明智的事情。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	可喜的是，深度参与到短视频行业发展中的人们早已明白了这其中的意义，我们看到以抖音、快手为代表的短视频平台开始更多地寻找基于自身优势和特色的发展道路，抖音做社交，快手做电商就是这一趋势的直接体现。尽管当下的发展态势不甚明朗，但是只要能够找到一条真正适合自己的发展道路，短视频行业的发展便会真正能够独立。&nbsp;\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	短视频的退让：坚守流量还是回归商业。从当下的发展情况来看，短视频真正吸引人的地方还是它裹挟流量的能力。投资机构和互联网巨头之所以不断加持短视频行业的重要一点同样是因为短视频本身能够在获取流量的成本日渐高企的时刻依然能够持续获得源源不断的流量。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	然而，虽然流量给短视频赢得了鲜花和掌声，但是流量的变现依然是横在短视频头上的达摩克利斯之剑。谈及流量变现就必然要回归到商业本身，如果仅仅只是在流量的海洋里进行无谓的自嗨，所谓的短视频只能是一个充满了美妙幻想的乌托邦，无法真正实现真正意义上的落地。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	是坚守流量还是回归商业，或许在残酷的商业面前，短视频行业将会最终退让，真正演变成为以商业为主导的存在。尽管这个过程会略显艰难，但是这才算是真正回归到了商业本身，而非仅仅只是沉醉在流量的理想国里。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	当短视频市场的繁华落尽，回归商业本质或许是当下正道。告别表面的虚假逻辑，真正把短视频行业的发展落地到具体的商业上，探索一条真正适合商业本质的发展道路，或许才是真正能够推动短视频行业发展正道所在。从这个逻辑上来看，当下短视频行业正在经历的这场彷徨与退让或许更像是在积蓄继续前行的能量。\r\n</p>',	'doc.png',	1.00,	9,	0,	0,	0,	'2019-12-03 14:21:49',	'admin',	14,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	1.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	3,	1,	0,	1),
(77,	'怪WTO“偏心”中国 美国把上诉机构整瘫了',	'<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	发展会掩盖一切问题，直到狂奔的脚步停下。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	2月15日，滴滴CEO程维对外表示，公司将做好过冬准备，并将对非主业进行“关停并转”，对业务重组带来的岗位重叠和绩效不达标的员工进行减员，整体裁员比例占到全员的15%，将涉及2000人左右。此外，从2012年创业以来一直处于亏损状态的滴滴，2018年仍然亏损，全年亏损总额高达109亿元，其中，补贴司机超过113亿元。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在收购优步中国以后，滴滴在网约车市场一家独大，市场占有率近九成；滴滴是全球融资额最大的未上市公司，一向“不差钱”；滴滴对每笔业务都会收取20%左右的抽成(Take Rate)，这也经常成为网约车司机抱怨甚至炮轰的对象……感觉“躺着就能把钱赚了”的滴滴，为何会如此巨亏？司机喊着不赚钱、平台又巨亏，网约车的问题究竟出在哪里？还有能走得通的商业模式吗？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	成立7年，融资20次，\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	融资额200亿美元\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	和其他公司多是被爆出后被迫承认窘境，或者裁员时只肯使用“优化、调整、末位淘汰”等字眼不同，滴滴主动“官宣”了巨亏和裁员的消息，数字还如此巨大。“地主家也没有余粮了？”“富家子都开始哭穷了？”社交媒体上一时哗然，有人唏嘘，有人不解。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在去年8月滴滴顺风车事件之后，程维也曾对外透露过一次滴滴的财务数据，他表示滴滴成立6年来，还没有实现过盈利，仅仅2018年上半年，公司的整体净亏损就超过40亿元人民币。滴滴出行业务对应的GMV(总交易额)平均Take Rate(抽成率)约为16%，但绝大部分作为补贴和红包返还给了司机和乘客，公司整体对应的GMV毛利率只有1.6%。他还透露，仅2018年上半年，包括司机高峰期补贴、接单和服务奖励、乘客优惠等在内的总补贴返还金额超过117亿元人民币。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	2017年，滴滴也曾透露过补贴总额，高达181亿元(包括司机端和乘客端)。但一些被媒体广泛引用、滴滴官方从未确认也从未辟谣的数据显示，2017年滴滴全年亏损额只有25亿元。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	一位滴滴内部人士告诉《中国经济周刊》记者：“公司虽然巨亏，但现在现金流应该是没问题的。即使一部分员工会面临被裁员，但公司给的补偿方案还是比较厚道的。说滴滴会成为下一个ofo那是不太可能的。”\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	据天眼查的统计数据显示，滴滴自2012年成立以来，截至目前已经完成了20次融资，金额总量超过200亿美元，是全球融资额最大的未上市公司。滴滴的估值也一度高达800亿美金，也是最快达到这个量级的独角兽公司。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	但这只独角兽也甚是烧钱。由于滴滴还不是上市公司，财务数据并不需要全部公开，但根据滴滴已公开的数据统计，滴滴6年来累计亏损额高达近390亿元。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	但上述人士也表示：“在2018年以前，利润和成本在滴滴确实不是重要的考核指标，市场占有率、日单量、用户数量、司机数量……这些才是关注的重点。但2018年开始，公司希望能够在年底冲刺整体盈利，至少实现‘微盈利’，所以对各个业务线也都提出了这样的要求。”\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	其实，这种变化也并不奇怪，因为彼时市场传闻，滴滴将会在2019年下半年实现IPO。但之后由于众所周知的原因，滴滴没能赶上这波上市热潮。“顺风车事件”背后的安全问题让滴滴停下了6年来一路狂奔的脚步。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	一年补贴113亿元，\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	司机感受到了吗？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	补贴仿佛是成就滴滴、也榨干滴滴的一道旋转门，补贴的打法让滴滴熬死了几乎所有竞争对手，并从尸骨堆中走出来，成为今天的滴滴；但现在，补贴似乎也正在熬干滴滴自己。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	与109亿元这个2018年滴滴全年亏损总额一同出现的还有一个数据：2018年滴滴补贴司机超过113亿元，这很容易让人认为两个数字之间有因果关系。但巨额亏损就是源于对司机的补贴吗？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	北京大学市场与网络经济研究中心研究员陈永伟对《中国经济周刊》分析认为，滴滴的亏损应该主要来自为了赢得用户信任和适应更强监管而付出的合规成本。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	陈永伟认为，滴滴的持续亏损主要有两方面的原因。“一是由滴滴本身的战略决定的，它的战略是先占有市场，然后利用规模效应去消化市场。滴滴的主业务是规模报酬递增的，这也决定了滴滴先占市场的模式。二是去年突发事件引发了监管加强，这让滴滴遭受了空前的监管压力，合规成本是巨大的，比如要求司机户口、车辆的轴距大小等。”他说。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	记者采访了几位滴滴司机，他们均表示，并没有觉得去年滴滴对司机的补贴突然增加了。一位滴滴“老司机”告诉记者，不同的司机能够拿到的补贴数量可能差别非常大。因为要想获得比较高的补贴收入并不容易，比如要在线时间长，至少10小时，这意味一定要是全职司机，身体要好还不能怕辛苦；再比如要在高峰时段多接单，也要多接受滴滴的派单，“这些活儿很多是根本不赚钱的，不给补贴，根本不会有人接。”他说。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在乘客端，很多人的感受则是：滴滴的车费越来越贵，但叫车却越来越难。记者对比了市场上最大的几家网约车公司的价格，以北京为例，相同时段和目的地，同档次车型，滴滴快车价格最低，其次是出租车价格，但两者差距已经不大了，相对最高的是易到易达车型的价格。而对于高端车型，滴滴礼橙专车也是最低的，其次是神州专车，首汽约车的价格则更高一些。这些高端车型的价格要高出普通车型50%左右。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在客户竞争层面，网约车平台的竞争无外乎两件事：价格和能否叫到车。而网约车平台要克服的最大难题就是高峰低谷时段的需求差异和城市潮汐效应的供给矛盾。因此，从逻辑上，网约车平台确实需要依赖补贴来调节运力，鼓励高峰时段有更多兼职司机补充运力，鼓励司机反潮汐增加热门地区的运力供给。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	根据中国信息通信研究院政策与经济研究所的调查显示，截至2018年7月，全国合规网约车数量约为17万辆，只占到总量的0.54%，而合规司机数量约为34万，只能占到司机总量的1.1%。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	据滴滴方面介绍，随着各地网约车新政的落地和执行越来越严格，运力不足问题日趋严重。而顺风车下线之后，兼职的网约车司机也大量减少。因此，滴滴为了吸引更多“合规”司机加入，以及运营中调整运力，不断出手补贴。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	滴滴收购ofo的可能性更小了\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	除了裁员，滴滴宣布要“关停并转”非主业的消息也引发了广泛的关注。到底哪些业务是滴滴的“非主业”，截至记者发稿，滴滴官方并未给出回应。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	一位滴滴前高管对《中国经济周刊》分析，对于滴滴“非主业”，很多人会首先想到外卖、酒旅、票务等“创新业务”，这确实可能是此次调整的重点，但应该还至于此，因为这些业务不足以涉及到2000人。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	据记者了解，2018年底，滴滴进行过一次架构调整。调整后，滴滴的主要业务被划为几大板块：网约车平台公司(快车、专车、豪华车事业部)、车主服务公司(小桔车服公司、汽车资产管理中心)、普惠出行与服务事业群(单车、电单车、公交、代驾、企业级业务)、出租车事业部、战略业务事业部(战略部、国际事业部、金融事业部)等。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	上述高管认为，普惠出行与服务事业群的业务也有可能被重点调整，“滴滴再去收购ofo的可能性更小了”。而国际业务和金融业务则会影响不大。“网约车这个生意受政策环境影响太大了，国际化等于给滴滴多设立几个backup，这边不亮可以那边亮，滴滴已经有完整完善的网约车技术和运营解决方案，在各国复制并不难。”他说。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	实际上，滴滴已经通过收购、投资本地出行平台的方式将业务拓展到东南亚、东欧、非洲、巴西、日本、美国、墨西哥、澳大利亚……程维也透露，安全技术、产品和线下司机管理及国际化等是滴滴未来的重点领域。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	陈永伟的看法是，滴滴确实涉足了不少并没有规模效应的行业，如果没有顺风车危机，可能也不会对滴滴带来太大的影响。但在严监管之下，安全合规成本大增，滴滴的顺风车业务还干脆就没了，这也带来商业损失。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	网约车也有赢利的商业模式\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	滴滴这头其实已经达到巨头规模的超级独角兽，至今仍未找到清晰的盈利模式。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	滴滴的设想是希望通过平台聚集大量用户，然后靠打造“出行生态”提供增值服务获得盈利。就像淘宝和微信，用户都可以免费使用，但同样可以赚得盆满钵满。于是，滴滴进行了很多尝试：做广告、做电商、做游戏、卖保险、卖理财、做金融……但这条路，至少现在，滴滴还并没有走通。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	但这并没有影响新选手们的热情。除了神州优车、易到、首汽约车等老运动员，2018年以来，美团、高德、携程、同程、嘀嗒、哈罗等都开始前赴后继地加入网约车混战，希望从滴滴的版图上咬下一块。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	此外，上汽、吉利、大众等在内的主机厂都已经进军网约车市场，宝马也成为首家在中国拿到网约车牌照的跨国品牌，赛道那端虽然通向哪里还不知道，但赛道仍然拥挤。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	虽然滴滴的日子不好过，易到更是彻底凉了，但行业内也有日子过得不错的玩家。比如神州优车，虽然此前也一直亏损，但到2017年，神州优车的亏损已大幅收窄了92.7%，仅亏损2.6亿元。而其2018年经营，截止到当年前三季度，神州优车营收达49.2亿元，利润总额2.8亿元，较上年同期增长149%，已经实现了4个季度的持续盈利。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“这其实也说明了网约车本身没问题，是有商业模式可以走得通的。不过行业发展还是需要政策支持。”陈永伟表示\r\n</p>',	'doc.png',	1.00,	7,	0,	0,	0,	'2019-12-03 14:22:37',	'admin',	26,	1,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	1.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	4,	1,	0,	1),
(78,	'新西兰火山再度喷发可能性仍高 当局暂缓善后工作',	'<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	对于当下环境以及未来发展，马云认为未来充满不确定性，企业家可能是世界上真正把握不确定性的群体，把不确定性变成确定性，很多人做企业是把机会做成灾难，灾难变成机会。真正看清楚，就不会悲观或者乐观，而是去寻找解决方案。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	抱怨和躲避解决不了问题，在危机关头，只有熬过挑战的企业，才有抗体。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	董事长郭广昌也认为今年的冬天有些不一样，他认为经济的确会很困难，这个冬天会非常冷。世界上要有一个救世主，就是市场，但在市场里，我们只能自救。企业家们现在必须要做的一件事，就是反省、是扪心自问：现在我们必须认真想想我们遇到的问题是什么？前五年我们又做了些什么？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	最后他相信中国的市场化程度一定会越来越高，民营企业的营商环境会越来越好。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\"> <strong>马云：熬过挑战的企业才有抗体</strong> \r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	今年，鲁冠球、冯根生、沈爱琴等老一辈浙商相继辞世。马云在演讲中表示，“过去一年，我们一直都在告别，告别了浙商当中开先锋之先，开天辟地的一些人物。在告别的时候我们在想，我们这一代浙商应该从他们身上继承些什么？是传说中浙商的8000亿资本吗？我想我们继承的不是资产，而是在继承和发扬浙商‘敢为天下先’、吃苦耐劳、创新奋斗的精神。”\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	他特别提到了当下的发展环境：\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“我们今天所遇到的困难其实和美国企业当年所经历的困难无法相比，和40年以前浙商面临的改革开放刚开始的困难环境无法相比，今天幸运得多。过去的40年，浙商是在中美合作的关系发展中起来的，<strong>未来的40年，我们浙商要在新型的中美关系中，在国内经济的转型升级当中，找到自己新的位置。</strong>这是挑战，也考验我们浙商的担当，也是浙商的自我升级迭代。这么多年来，浙商做得好，不仅是因为我们会吃苦，而是因为我们会学习，我们会应对变化。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	因为我们很清楚，只有变革才有我们的机会。任何变化，你把它当做灾难的时候，那就越来越不顺眼，当做机会的时候就越看越有意思。在危机关头，能够熬过困难，熬过挑战的企业才有抗体。总是抱怨自己没有遇上好的年代，这样的人永远不可能遇上更好的时代。”\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“经过这一轮的洗礼，能够活下来的企业，活下来的浙商，肯定已经不是过去的浙商，一定是未来的浙商。”马云说，浙商要超越商人，告别野蛮生长的市场，“<strong>今天社会进步，商人不能有钱就要干，而要有所为有所不为，要从商人走向企业家，以国家利益为重，以社会利益为重，以未来为重。</strong>相信大家一起相信未来，看见未来，拥有未来”，希望浙商要依靠家国情怀、责任感和价值取向而闻名世界。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在会上，谈到“风口论”时马云说，当一个还没有成立几天的小公司，就凭着几个故事、几个员工得到了几十亿美金的估值，什么都没有，还嫌少的时候，我们就进入了跨度期，要提前做准备；当一个企业拿自己公司80%的资产质押出去，拿钱去做与自己主业不一样的东西的时候，就要想到问题已经开始了。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	很少有企业能够越做越大、越做越好，因为很多人永远相信“赌博”，永远相信all in。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\"> <strong>郭广昌：这个冬天会非常冷，“过冬”要靠自己</strong> \r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在演讲中，郭广昌针对企业自身、企业创新、企业人才、企业发展四个方面，提了一些需要企业家们扪心自问的问题。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\"> <strong>以下为郭广昌演讲全文：</strong> \r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	今年是改革开放40周年。在过去40年里，我们浙商靠着“四千”精神，吃苦耐劳、不懈努力，应该说一直走得比较顺。前几年，虽然我们每年都说困难、“年年难过”，但实际上还是“年年过”。但这个冬天，我感觉有些不一样。尤其今年很多企业家朋友都出了问题，而且不是小企业，有些企业很不错，甚至是上百亿市值的上市公司。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	我就在想，到底怎么了？刚才陈龙教授也给大家详细说了外部环境的变化，那我们自己呢？这么多年来，我们一直说我们要改变自己，那我们改变了多少呢？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	所以我对现在经济的看法是：\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	第一，经济的确会很困难，这个冬天会非常冷。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	第二，世界上要有一个救世主，就是市场；而在市场里，能救你的只有你自己。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	所幸，党和国家已经很清楚的看到了这些问题和困难，也出台了一系列针对民营企业发展的政策和举措。所以，我判断未来的形势会好一些。但能否度过这个冬天，根本点还在于自己。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	作为我们自己，现在必须要做的一件事，是反省、是扪心自问。我觉得现在我们必须认真想想我们遇到的问题是什么？前五年我们又做了些什么？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	以下这四个问题，是这几年我自己一直在扪心自问的：\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	1、我们要扪心自问，我们到底花了多少时间在客户身上？花了多少时间在了解自己的产品上？花了多少时间在提升产品服务上？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	每个董事长，首先应该是自己公司的首席产品体验官。产品好不好，客户满意不满意？我们自己应该是最了解的。但这种了解绝不能依靠你的喜好和直觉，你需要花更多的时间跟客户去沟通。尤其产品销量不好，市场上又有很多竞争，你就特别需要更用心地体会产品。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	现在，我花时间最多的就是研究产品。经过这段时间的研究，我基本认为要造好产品，方法大致有两种：一种是做平台，但是能做成像阿里、腾讯这样大平台的企业毕竟是少数。第二就是花更多的时间去琢磨怎么做好产品。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	但如果做产品，我必须要强调一点：我们一定要做精品，一定要千锤百炼，一定要为客户创造价值。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	2、我们经常要扪心自问，我们花了多少钱在研发上？花了多少时间在学习新的业态上？花了多少时间去感受新的趋势和方向上？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	我相信，现在大家都很重视移动互联网。但我想问：我们的制造企业，有多少人真正懂得了移动互联网吗？移动互联网只是在淘宝上卖东西吗？马校长已经把阿里这家互联网企业做得这么好，但他还是会花大量的时间在研究线下商业、实体制造。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	所以说，我们千万不能因为取得了成绩，就不学习了。永远只有比别人学得更快，我们才能比别人走得更好、更远。现在客户的需求变化非常快，我们也进入了一个科技研发能快速转化为成果的时代。在这样的时代，技术的进步、产业的进步、市场逻辑的进步，逼着我们要不断学习。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	另一方面，一定要重视科技研发和创新。我们很多出问题的企业，虽然他们的公司已经很大，但总体感觉他们生产的大部分产品还是同质化、低科技的产品，而且他们以前一直是靠低毛利来不断扩大销量。但这个时代变化太快了，很可能你生产出来的不是产品，直接就是库存。所以，现在尤其要用科技创新来引领。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	3、我们要扪心自问，我们花了多少精力在组织升级和人才培养上？我们花了多少精力在引进高级人才上？花了多少精力在年轻人身上？我们有没有在90后、00后身上学到了什么？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	组织、人才，绝对是一家企业最核心的资产。因为所有的事都需要对的人去实现。而且根据市场的发展和变化，我们的组织需要不断升级，企业的人才要不断换仓。我们一定要吸收具备高能级、更在状态、更渴望成功的人。大家都有自己的团队，但我们花了多少精力在团队的升级上？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	我举个例子。复星的狼队这个赛季从英冠踢到了英超。但我突然发觉，英冠虽然踢得好，但是到英超以后，却碰到了很多的问题。为什么？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	因为英超要求我们球员的素质和英冠是不一样的。现在中国经济不管跟美国发生什么，都是一个比较长期且难以解决的问题。但不管怎么解决，中国经济已经在参与全球竞争了，客观上我们已经在踢“世界杯”了。这个时候，你的人才还是停留在原来的状态，不出问题不是很奇怪吗？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	4、最后，我们还要扪心自问：我们到底愿意不愿意慢下来，去做点慢的事情？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	改革开放40年，中国速度是大家津津乐道的，什么都发展得很快。这让我们已经习惯了快。比如我们看到马校长用十几年打造了一个世界级的巨无霸企业，大家都很想去复制他成功的路径。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	但全世界只有一个马云，谁都像他一样，这个世界还了得？所以你要知道，你自己该做什么，你有没有沉下心来做你该做的事？我们很多企业，我对他们做事的风格有一种感觉，就是All in，就是“赌”。这个“赌”不是说去赌场，而是说做企业很有“赌”性。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	之前的40年，因为整个市场在发展，一俊遮百丑，你很大概率赌成功了。但你千万不能把经济的大势当作你自己的能力，如果市场不好了，会怎么样？All in一下会很爽，但之后呢？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	我相信我们真的要沉下心，做对的事情，做难的事情，做需要时间积累的事情。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	当然，讲了这么多困难和问题之后，我还是对未来始终充满信心：\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	我坚定地相信，中国的市场化程度一定会越来越高，我们民营企业的营商环境会越来越好。包括我相信，不久的将来一定会减税，以降低企业的成本、激发企业活力。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	我坚定地相信，中国的企业家，尤其浙商，都非常能吃苦，只要我们真的加大创新，我们的未来会得到更多的发展。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	我坚定地相信，我们一定会融入全球。对于我们来说，尤其浙商，这是未来我们重要的方向。我们浙商不害怕去全球竞争，在越来越开放、越规范的市场，在全球化的融合中，全球浙商只会越来越好。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	这就像中国足球一样。中国足球要踢世界杯，只有让我们球员去全球踢球，才能得到真正的锻炼，而不只是在中超拿高工资。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	我坚定地相信，我们浙商有这份期望，我们浙商有这份能力，让我们一起努力。\r\n</p>',	'doc.png',	1.00,	30,	0,	0,	0,	'2019-12-26 09:37:40',	'admin',	71,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	1.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	12,	1,	0,	1),
(79,	'落马官员“借走”200万后退赃 风头一过又要走',	'<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	2015年，随着抢眼的小黄车突现北大校园，共享单车的概念迅速被普及，玩家接连冒头，巨额投资不断涌入，和高铁、移动支付、网购齐名<strong>“新四大发明”</strong>。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	热潮来得快，去得更快。今年，共享单车就进入了寒冬。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	4月，<strong>摩拜单车委身美团；小黄车ofo也节节败退，危机重重</strong>：海外业务全面收缩，并推出了多种激进的变现手段：公众号推送广告，将用户的押金与理财产品绑定，一再延迟押金退还期限。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	去年还大把烧钱的共享单车，转眼就凉凉了。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	共享单车出海遇阻，基础建设和政策规范是难以忽略的两大阻力。除了中国，世界上很难找到一个足够大的市场来支撑共享单车的盈利模式。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	但印度的创业者似乎有不同想法。<strong>从2017年开始，有近十年共享单车公司陆续出现，并先后拿到融资。</strong> \r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	班加罗尔的Yulu向Blume Ventures等投资者筹得资金，还获得Flipkart联合创始人Binny Bansal和谷歌前副总裁Amit Singhal的支持；另一家公司Bounce从红杉印度等投资者那里拿到了了总计1520万美元的资金；总部位于古尔冈的Mobycy去年12月也筹集了50万美元的种子资金。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\"> <strong>印度的共享单车市场正生机勃勃。</strong> \r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\"> <strong>融资热潮</strong> \r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	Amit Gupta是印度第一家独角兽Inmobi的联合创始人。在他创业十年、担任总裁级别职务的时候，他选择了急流勇退，<strong>创办了另一家公司，Yulu单车</strong>。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在班加罗尔地铁站和商务CBD附近，亮蓝色的Yulu单车随处可见。Amit告诉\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	志象网\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	，做共享单车，是为了<strong>“间接降低污染”</strong>。他出生和长大在印度北部的小城坎普尔，在今年6月被世界卫生组织盖章“全球污染最严重城市”，谈起家乡，他显得情绪激动。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	Yulu单车在前半个小时仅收费10卢比<strong>（约一元）</strong>，之后每半小时多收5卢比。用户下载Yulu应用扫码开车，结束骑行之后，需要将车子停放在离目的地最近的停车区。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	业内人士估计，印度的共享单车市场目前规模达12亿美元。<strong>主要的玩家除了Yulu，还有共享汽车公司Zoomca旗下的Pedl，Mobycy，Bounce和以及来自中国的摩拜单车。</strong> \r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“这个行业很有前景并且有利可图，Ola和Uber的成功证明了交通出行跟手机有可能同步发展。”Blume Ventures的投资人Sajith Pai对志象网说。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	最近入局的玩家是<strong>从踏板车共享起家的Bounce</strong>。今年6月，ofo退出印度市场，Bounce最近宣布收购了它在印度的资产。在收购之前，Bounce在就班加罗尔投放了500辆踏板车。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“从公交站或地铁站到办公室和家里的最后一英里的交通非常令人头疼，没有任何三轮车或出租车愿意走这么短的距离。”Bounce联合创始人Vivekananda HR告诉志象网。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“我们从ofo手中收购的自行车也将加入试点。”他说，45到60天内Bounce的应用将支持扫码使用单车。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	印度创业者从中国公司继承的，不仅是败局留下的遗产，还有先见之明的运营管理教训。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在浦那和班加罗尔，小蓝车Yulu和小绿车Pedl随处可见。一开始，用户可以把车停在任何地方，甚至是在路中间，引起了交通失序。Yulu不得已派出团队去搬运自行车并停放在适当的地方。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	这样一来，成本太高难以为继，Yulu吸取了教训，开始联合Pedl与当地政府合作，规划指定的停车区域。在班加罗尔，这样的停车区现在有500个，在全部的4个城市总数超过1000个。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\"> <strong>纠结的用户体验</strong> \r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	但也有的问题无法靠“继承”来解决，<strong>比如技术和运营失误</strong>。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在印度，<strong>共享单车的用户体验仍有待改善</strong>。志象网记者的亲身体验以及和其他用户交流后发现，包括刹车失灵、智能锁失灵、轮胎漏气等现象并不少见，而且停车区的分布也不够密集，有时候用户甚至需要在锁车之后再走一公里到目的地。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	Vivek Kumar是一名22岁的软件工程师，他最近刚从德里搬到了班加罗尔。刚到班加罗尔时，他一直骑着共享单车穿梭在城市中参加面试。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	一次去面试的路上，他发现单车的链条断了，这就十分尴尬了：他必须得先把车子停到指定的停车区域，否则软件会一直计费。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“我不得不把车子推到500米外的Pedl停车站，在锁这个坏车的时候又花了好多时间。”Kumar告诉志象网。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	但事实上，Yulu和Pedl也都有专人在维护单车，每隔四天维护一次，从而保持单车的良好运行状态。但Amit说，当公司进入一个区域时，维护的情况会不太稳定，“因为当地业务还没有完全稳定。”\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“在那些旧的区域，你会发现我们的自行车状况良好，大多数都能够很好运行。最近我们在电子城附近布局，那里聚集了一批大型IT公司，比如Infosys、Wipro等。我们需要四到六周的时间来完成布局。”Amit说。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	但相较中国，<strong>印度的交通基础设施普遍落后，这也给共享单车埋了一颗暗雷</strong>。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在印度，没有几个城市设置了自行车道；不像中国，骑行已经发展为一种健康、前卫的生活方式，印度的自行车还往往被视为穷人的通勤方式。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“我们之所以进入共享单车行业，是因为我们想成为一家多渠道出行平台。城市交通一直是政府和公民共同面临的挑战，我们希望能够大规模地解决这一问题并帮助完善基础设施建设。”Pedl运营增长部门负责人Rakshak N说。\r\n	</p>',	'doc.png',	0.00,	2,	0,	0,	1,	'2019-11-26 09:37:47',	'admin',	120,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	0.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	3,	1,	0,	1),
(80,	'大学生拒服兵役受罚：罚款 终身不得录为公务员',	'<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	互联网瞬息即变，互联网上的热点也是转变地相当的快，一个热点可能过了几天就不再有人关注了。这对于想凭借互联网走红的人或物来说，显然要付出更多的心血来维持热度。那么，各个引流渠道显然都在他们的考虑范围之内。对于商家而言，在互联网进行引流的最终目的不外乎都是卖货变现。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	因此，一些比较重要的引流渠道，都少不了商家们的身影；比如，。抖音作为2019年的平台，有着3.2亿日活跃用户，属于是自带。如今，抖音与微信、微博等巨大流量池并称，绝对是商家不容错过的流量池。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	商家在抖音平台上发布内容之后，就能通过发布内容来吸引用户前来关注，并进一步转化为粉丝，这样就能更方便商家引流变现。在抖音只能是通过发布优质内容来吸引用户关注，因为抖音采用的是智能社交推荐机制，只要发布的视频内容有趣，也可以获得大量的曝光。这就决定了粗制滥造的视频所获得的曝光量很少。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;text-align:center;\"=\"\"> <img src=\"http://demoall.adashuo.com/20090/uploads/allimg/c191107/15I0c2FD630-1E14.jpg\" width=\"450\" height=\"270\" border=\"0\" alt=\"抖音多闪培训：如何通过抖音进行带货-第1张图片-小七抖音培训\" title=\"抖音多闪培训：如何通过抖音进行带货-第1张图片-小七抖音培训\" style=\"height:270px;width:450px;\" /> \r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	因此，想要在抖音平台上获得大量的曝光，最简单的办法就是制作高质量的视频内容。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	拥有曝光，并不代表着是结束。恰恰相反，这只是开始，因为接下来的工作就是要引流变现了。目前，通过抖音引流的方式无非就只有这么几种：一是在视频内提及联系方式；二是在评论中回复；三是在私信回复等。但是，这几种引流方式都存在着被抖音删除、乃至封禁的风险。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	抖音多闪培训那么，到底有没有什么引流方式是没有风险的呢？或者换言之，有什么引流方式是抖音官方认可的呢？当然有!那就是抖音的电话拨打组件。这是抖音官方所推出的转化组件，经过设置就可以在抖音主页上展示，只要用户点击\"联系方式\"这个按钮就可以跳转至电话拨号界面，并显示相关号码，这无疑对商家引流变现提供了很大的便利。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	但比较遗憾的是，目前，这个功能并没有对所有的用户开放，只有认证了抖音企业蓝v号的用户才可以设置该功能。所以，商家如果是想开通\"电话拨打组件\"的功能，需要先开通抖音蓝v。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	抖音蓝v认证的申请流程如下：\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	第一，用需要认证蓝v的抖音账号登录抖音蓝v认证官网https://renzheng.douyin.com/。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	第二，填写企业认证公函，具体情况可以参考抖音官方的企业认证公函填写模板。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;text-align:center;\"=\"\"> <img src=\"http://demoall.adashuo.com/20090/uploads/allimg/c191107/15I0c2G0040-2J03.jpg\" width=\"450\" height=\"447\" border=\"0\" alt=\"抖音多闪培训：如何通过抖音进行带货-第2张图片-小七抖音培训\" title=\"抖音多闪培训：如何通过抖音进行带货-第2张图片-小七抖音培训\" style=\"height:447px;width:450px;\" /> \r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	第三，填写并提交认证资料，然后填写邀请码123456\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	第四，支付认证审核费用600元即可完成蓝v认证申请的提交。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	需要注意的是，抖音蓝v认证有部分禁入行业及需要额外提供认证资质证明的行业。禁入行业认证抖音蓝v将做认证失败处理。而需要额外提供认证资质证明的，如果碰巧没有，那么在提交认证申请后的30天内仍没有补充提交资质证明，也会当认证失败处理。而认证抖音蓝v失败，是不会进行退款的。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	认证抖音蓝v之后，除了可以获得电话拨打组件，还可以获得同步认证今日头条和、官网链接、商家页面、店铺POI地址、粉丝画像等蓝v权益。可以为天猫、淘宝、京东店铺以及线下店铺引流，构建企业商家的营销阵地，完成变现的目的。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;text-align:center;\"=\"\"> <img src=\"http://demoall.adashuo.com/20090/uploads/allimg/c191107/15I0c2G35440-31260.jpg\" width=\"450\" height=\"261\" border=\"0\" alt=\"抖音多闪培训：如何通过抖音进行带货-第3张图片-小七抖音培训\" title=\"抖音多闪培训：如何通过抖音进行带货-第3张图片-小七抖音培训\" style=\"height:261px;width:450px;\" /> \r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	抖音多闪培训因此，有意认证抖音蓝v的商家，最好是通过抖音蓝v认证代理商进行认证。\r\n</p>',	'doc.png',	0.00,	18,	0,	0,	0,	'2019-12-03 14:04:12',	'admin',	5,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	0.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	10,	1,	0,	1),
(81,	'新疆开行首趟至乌克兰中欧班列 预计运行15天',	'<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	众所周知，2017年至2018年，的大和商业价值日益凸显，各大机构纷纷注资抢占短视频市场，作为短视频流量增速最快的APP，其运营模式和商业市场更是备受关注。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	大数据，帮你快速打造抖音爆款\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	抖音作为新媒体的新洼地，虽然流量又达到一个新的峰值，但是入场抖音仍然是可以。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	而想在抖音机制中脱颖而出，关注的焦点更倾向于生产抖音内容的速度和质量，以及如何持续生产高质量的抖音内容。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	对于运营抖音而言，此时入场抖音阵地，更需要把控时间成本和运营方法。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	结合抖音大数据工具——西瓜短视频助手，在内容层面，可以在6小时内寻找到抖音视频爆款素材，结合热门迅速掌握抖音平台爆款元素，从而有效提升抖音成本。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	在领域定位上，可以根据榜单快速规划的运营方向，结合行业粉丝画像信息，进一步完善垂直领域差异化内容布局。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	抖音进阶创作技巧，及商业运作模式\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;text-align:center;\"=\"\"> <img src=\"http://demoall.adashuo.com/20090/uploads/allimg/c191107/15I0c2AcO0-53929.jpg\" width=\"450\" height=\"303\" border=\"0\" alt=\"抖音小店：抖音运营怎么进行流量变现-第1张图片-小七抖音培训\" title=\"抖音小店：抖音运营怎么进行流量变现-第1张图片-小七抖音培训\" style=\"height:303px;width:450px;\" /> \r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	根据对MCN机构平台发展中遇到各种情况，给现场的运营者和MCN机构提出以下3个方面建议：\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	1.稳扎稳打才是抖音号的运营之道\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	面对网络上出现的买粉刷量的现象，建议运营者和机构千万不要尝试。这样的行为，不仅影响抖音号的权重，也让后续陷入无效价值中。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	2.快速孵化KOL矩阵离不开内容运营\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	抖音小店面对快速内容运营的有效方法，也给出一些信息流量的操作模式，在信息的展示上，可以扩大挖掘地域，可以引入外国小众优质的平台信息资源，将优质内容分类整理成“剧本”分发旗下艺人进行高效运作，提升视频输出效率。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	3.强强合作是商业运作成型的有效方法\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	相比知识付费，广告和电商是抖音目前最有效的转化之一。在广告投放上，同MCN专业机构合作，会更有效的提升个人抖音号的商业价值转化能力。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	如何高格局快速转战短视频领域构建生态链\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	如何一手打造“从内容生产-IP孵化-推广产业化”短视频生态蓝图？\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;text-align:center;\"=\"\"> <img src=\"http://demoall.adashuo.com/20090/uploads/allimg/c191107/15I0c2B323F-B363.jpg\" width=\"450\" height=\"307\" border=\"0\" alt=\"抖音小店：抖音运营怎么进行流量变现-第2张图片-小七抖音培训\" title=\"抖音小店：抖音运营怎么进行流量变现-第2张图片-小七抖音培训\" style=\"height:307px;width:450px;\" /> \r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	a.建立完善的孵化流程。在常规签约流程上，增加达人定位分析和视频测试环节（颜值/技能/学习），保障达人较高的素质水平。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	b.专注用户市场资源。在媒体领域商业形式取决于上游形态，运营的方向取决于市场用户的需求，只有想明白定位，才能做清楚你的市场。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	c.专业商业变现评估。需要对行业的天花板有一定认知，对不具有的抖音大号，可以根据粉丝画像的年龄层，选择不同的市场的推广模式。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	最后，规范机构的商业合作模式，才能快速有效构建自己的商业帝国。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	网红大咖粉丝运营之道\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	抖音IP的成长过程3个关键点：\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	1、找准平台：分析各个平台的商业价值和受众群体，有效预估平台的价值的上升空间。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;text-align:center;\"=\"\"> <img src=\"http://demoall.adashuo.com/20090/uploads/allimg/c191107/15I0c2BC510-L234.jpg\" width=\"450\" height=\"303\" border=\"0\" alt=\"抖音小店：抖音运营怎么进行流量变现-第3张图片-小七抖音培训\" title=\"抖音小店：抖音运营怎么进行流量变现-第3张图片-小七抖音培训\" style=\"height:303px;width:450px;\" /> \r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	2.优质内容：视频种类，视频的风格，人设的塑造，再到更高层次基调定位，都是优质内容的保障。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	3.抓准用户心理：内容的输出上需要抓取社会的认同感，有共鸣的内容通常都可以引发用户的依赖性，可以在内容上找到归属感。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	抖音小店其次，需要制造亲切感，打造个舒服是场景内容更容易获取用户关注。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	最后，就是从心理学的角度出发，恰到好处运粉丝的独纵心理和占便宜的心态。\r\n	</p>',	'doc.png',	1.00,	22,	0,	0,	0,	'2019-12-03 14:07:30',	'admin',	3,	5,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	1.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	3,	1,	0,	1),
(82,	'马云、郭广昌最新演讲：过冬靠自己，只有熬过',	'<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	对于当下环境以及未来发展，马云认为未来充满不确定性，企业家可能是世界上真正把握不确定性的群体，把不确定性变成确定性，很多人做企业是把机会做成灾难，灾难变成机会。真正看清楚，就不会悲观或者乐观，而是去寻找解决方案。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	抱怨和躲避解决不了问题，在危机关头，只有熬过挑战的企业，才有抗体。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	董事长郭广昌也认为今年的冬天有些不一样，他认为经济的确会很困难，这个冬天会非常冷。世界上要有一个救世主，就是市场，但在市场里，我们只能自救。企业家们现在必须要做的一件事，就是反省、是扪心自问：现在我们必须认真想想我们遇到的问题是什么？前五年我们又做了些什么？\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	最后他相信中国的市场化程度一定会越来越高，民营企业的营商环境会越来越好。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	<strong>马云：熬过挑战的企业才有抗体</strong>\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	今年，鲁冠球、冯根生、沈爱琴等老一辈浙商相继辞世。马云在演讲中表示，“过去一年，我们一直都在告别，告别了浙商当中开先锋之先，开天辟地的一些人物。在告别的时候我们在想，我们这一代浙商应该从他们身上继承些什么？是传说中浙商的8000亿资本吗？我想我们继承的不是资产，而是在继承和发扬浙商‘敢为天下先’、吃苦耐劳、创新奋斗的精神。”\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	他特别提到了当下的发展环境：\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	“我们今天所遇到的困难其实和美国企业当年所经历的困难无法相比，和40年以前浙商面临的改革开放刚开始的困难环境无法相比，今天幸运得多。过去的40年，浙商是在中美合作的关系发展中起来的，<strong>未来的40年，我们浙商要在新型的中美关系中，在国内经济的转型升级当中，找到自己新的位置。</strong>这是挑战，也考验我们浙商的担当，也是浙商的自我升级迭代。这么多年来，浙商做得好，不仅是因为我们会吃苦，而是因为我们会学习，我们会应对变化。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	因为我们很清楚，只有变革才有我们的机会。任何变化，你把它当做灾难的时候，那就越来越不顺眼，当做机会的时候就越看越有意思。在危机关头，能够熬过困难，熬过挑战的企业才有抗体。总是抱怨自己没有遇上好的年代，这样的人永远不可能遇上更好的时代。”\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	“经过这一轮的洗礼，能够活下来的企业，活下来的浙商，肯定已经不是过去的浙商，一定是未来的浙商。”马云说，浙商要超越商人，告别野蛮生长的市场，“<strong>今天社会进步，商人不能有钱就要干，而要有所为有所不为，要从商人走向企业家，以国家利益为重，以社会利益为重，以未来为重。</strong>相信大家一起相信未来，看见未来，拥有未来”，希望浙商要依靠家国情怀、责任感和价值取向而闻名世界。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	在会上，谈到“风口论”时马云说，当一个还没有成立几天的小公司，就凭着几个故事、几个员工得到了几十亿美金的估值，什么都没有，还嫌少的时候，我们就进入了跨度期，要提前做准备；当一个企业拿自己公司80%的资产质押出去，拿钱去做与自己主业不一样的东西的时候，就要想到问题已经开始了。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	很少有企业能够越做越大、越做越好，因为很多人永远相信“赌博”，永远相信all in。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	<strong>郭广昌：这个冬天会非常冷，“过冬”要靠自己</strong>\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	在演讲中，郭广昌针对企业自身、企业创新、企业人才、企业发展四个方面，提了一些需要企业家们扪心自问的问题。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	<strong>以下为郭广昌演讲全文：</strong>\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	今年是改革开放40周年。在过去40年里，我们浙商靠着“四千”精神，吃苦耐劳、不懈努力，应该说一直走得比较顺。前几年，虽然我们每年都说困难、“年年难过”，但实际上还是“年年过”。但这个冬天，我感觉有些不一样。尤其今年很多企业家朋友都出了问题，而且不是小企业，有些企业很不错，甚至是上百亿市值的上市公司。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	我就在想，到底怎么了？刚才陈龙教授也给大家详细说了外部环境的变化，那我们自己呢？这么多年来，我们一直说我们要改变自己，那我们改变了多少呢？\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	所以我对现在经济的看法是：\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	第一，经济的确会很困难，这个冬天会非常冷。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	第二，世界上要有一个救世主，就是市场；而在市场里，能救你的只有你自己。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	所幸，党和国家已经很清楚的看到了这些问题和困难，也出台了一系列针对民营企业发展的政策和举措。所以，我判断未来的形势会好一些。但能否度过这个冬天，根本点还在于自己。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	作为我们自己，现在必须要做的一件事，是反省、是扪心自问。我觉得现在我们必须认真想想我们遇到的问题是什么？前五年我们又做了些什么？\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	以下这四个问题，是这几年我自己一直在扪心自问的：\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	1、我们要扪心自问，我们到底花了多少时间在客户身上？花了多少时间在了解自己的产品上？花了多少时间在提升产品服务上？\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	每个董事长，首先应该是自己公司的首席产品体验官。产品好不好，客户满意不满意？我们自己应该是最了解的。但这种了解绝不能依靠你的喜好和直觉，你需要花更多的时间跟客户去沟通。尤其产品销量不好，市场上又有很多竞争，你就特别需要更用心地体会产品。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	现在，我花时间最多的就是研究产品。经过这段时间的研究，我基本认为要造好产品，方法大致有两种：一种是做平台，但是能做成像阿里、腾讯这样大平台的企业毕竟是少数。第二就是花更多的时间去琢磨怎么做好产品。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	但如果做产品，我必须要强调一点：我们一定要做精品，一定要千锤百炼，一定要为客户创造价值。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	2、我们经常要扪心自问，我们花了多少钱在研发上？花了多少时间在学习新的业态上？花了多少时间去感受新的趋势和方向上？\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	我相信，现在大家都很重视移动互联网。但我想问：我们的制造企业，有多少人真正懂得了移动互联网吗？移动互联网只是在淘宝上卖东西吗？马校长已经把阿里这家互联网企业做得这么好，但他还是会花大量的时间在研究线下商业、实体制造。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	所以说，我们千万不能因为取得了成绩，就不学习了。永远只有比别人学得更快，我们才能比别人走得更好、更远。现在客户的需求变化非常快，我们也进入了一个科技研发能快速转化为成果的时代。在这样的时代，技术的进步、产业的进步、市场逻辑的进步，逼着我们要不断学习。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	另一方面，一定要重视科技研发和创新。我们很多出问题的企业，虽然他们的公司已经很大，但总体感觉他们生产的大部分产品还是同质化、低科技的产品，而且他们以前一直是靠低毛利来不断扩大销量。但这个时代变化太快了，很可能你生产出来的不是产品，直接就是库存。所以，现在尤其要用科技创新来引领。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	3、我们要扪心自问，我们花了多少精力在组织升级和人才培养上？我们花了多少精力在引进高级人才上？花了多少精力在年轻人身上？我们有没有在90后、00后身上学到了什么？\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	组织、人才，绝对是一家企业最核心的资产。因为所有的事都需要对的人去实现。而且根据市场的发展和变化，我们的组织需要不断升级，企业的人才要不断换仓。我们一定要吸收具备高能级、更在状态、更渴望成功的人。大家都有自己的团队，但我们花了多少精力在团队的升级上？\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	我举个例子。复星的狼队这个赛季从英冠踢到了英超。但我突然发觉，英冠虽然踢得好，但是到英超以后，却碰到了很多的问题。为什么？\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	因为英超要求我们球员的素质和英冠是不一样的。现在中国经济不管跟美国发生什么，都是一个比较长期且难以解决的问题。但不管怎么解决，中国经济已经在参与全球竞争了，客观上我们已经在踢“世界杯”了。这个时候，你的人才还是停留在原来的状态，不出问题不是很奇怪吗？\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	4、最后，我们还要扪心自问：我们到底愿意不愿意慢下来，去做点慢的事情？\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	改革开放40年，中国速度是大家津津乐道的，什么都发展得很快。这让我们已经习惯了快。比如我们看到马校长用十几年打造了一个世界级的巨无霸企业，大家都很想去复制他成功的路径。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	但全世界只有一个马云，谁都像他一样，这个世界还了得？所以你要知道，你自己该做什么，你有没有沉下心来做你该做的事？我们很多企业，我对他们做事的风格有一种感觉，就是All in，就是“赌”。这个“赌”不是说去赌场，而是说做企业很有“赌”性。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	之前的40年，因为整个市场在发展，一俊遮百丑，你很大概率赌成功了。但你千万不能把经济的大势当作你自己的能力，如果市场不好了，会怎么样？All in一下会很爽，但之后呢？\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	我相信我们真的要沉下心，做对的事情，做难的事情，做需要时间积累的事情。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	当然，讲了这么多困难和问题之后，我还是对未来始终充满信心：\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	我坚定地相信，中国的市场化程度一定会越来越高，我们民营企业的营商环境会越来越好。包括我相信，不久的将来一定会减税，以降低企业的成本、激发企业活力。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	我坚定地相信，中国的企业家，尤其浙商，都非常能吃苦，只要我们真的加大创新，我们的未来会得到更多的发展。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	我坚定地相信，我们一定会融入全球。对于我们来说，尤其浙商，这是未来我们重要的方向。我们浙商不害怕去全球竞争，在越来越开放、越规范的市场，在全球化的融合中，全球浙商只会越来越好。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	这就像中国足球一样。中国足球要踢世界杯，只有让我们球员去全球踢球，才能得到真正的锻炼，而不只是在中超拿高工资。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	我坚定地相信，我们浙商有这份期望，我们浙商有这份能力，让我们一起努力。\r\n</p>',	'doc.png',	1.00,	1,	0,	0,	0,	'2019-12-26 09:37:40',	'admin',	71,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	1.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	3,	1,	0,	1),
(83,	'国内首个PD-L1单抗获批上市 默沙东27亿美元收购',	'<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	带火了很多“爆款”产品，这些品牌和产品的销量大增，引得很多企业和品牌方们分外眼红。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	在这个为王的时代，早已成为了一个所有新媒体人无法避开的平台。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	抖音火遍大江南北，同时有无限的流量产生。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	大家撸粉的撸粉，变现的变现。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	但是现在越来越难了，\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;text-align:center;\"=\"\"> <img src=\"http://demoall.adashuo.com/20090/uploads/allimg/c191107/15I0c26340L0-1F53.jpg\" width=\"450\" height=\"198\" border=\"0\" alt=\"抖音运营团队：抖音运营思维攻略-第1张图片-小七抖音培训\" title=\"抖音运营团队：抖音运营思维攻略-第1张图片-小七抖音培训\" style=\"height:198px;width:450px;\" /> \r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	为什么？\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	竞争大呗！\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	团队拿到更好的权重才能有更多的曝光，才有上的机会。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	怎么拿到更多的曝光权重呢？\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	俗话说：知己知彼，百战不殆！\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	那我就先来了解一下抖音的排名算法是什么？\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	首先你要输出优质的内容，\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;text-align:center;\"=\"\"> <img src=\"http://demoall.adashuo.com/20090/uploads/allimg/c191107/15I0c263G60-26058.jpg\" width=\"450\" height=\"195\" border=\"0\" alt=\"抖音运营团队：抖音运营思维攻略-第2张图片-小七抖音培训\" title=\"抖音运营团队：抖音运营思维攻略-第2张图片-小七抖音培训\" style=\"height:195px;width:450px;\" /> \r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	关于内容今天就不讲了，本期讲的是抖音运营思维攻略。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	一、熟悉抖音\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	抖音运营团队熟悉抖音账号注册、认证、定位、布局、防封号/、最受欢迎内容等。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;text-align:center;\"=\"\"> <img src=\"http://demoall.adashuo.com/20090/uploads/allimg/c191107/15I0c26406150-31H2.jpg\" width=\"450\" height=\"266\" border=\"0\" alt=\"抖音运营团队：抖音运营思维攻略-第3张图片-小七抖音培训\" title=\"抖音运营团队：抖音运营思维攻略-第3张图片-小七抖音培训\" style=\"height:266px;width:450px;\" /> \r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	二、选题\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	1.选题的原则：关联性、热门性、新鲜感、人设感\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	2.选题来源：可从时事、同行火爆视频分析、段子、微博等渠道入手\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	3.拍摄及剧本套路\r\n</p>',	'doc.png',	1.00,	22,	0,	0,	0,	'2019-12-03 14:08:06',	'admin',	10,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	1.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	3,	1,	0,	1),
(84,	'官方首提 滨州将筹建渤海科技大学 可容纳66',	'<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	怎么在做？ &nbsp;借助商品橱窗和购物车，电商新物种——抖商蓬勃发展，但作为以算法推荐分发的平台，抖音缺少社交基因，那么抖音就注定与社交电商无缘吗？\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	社交对电商有何价值？\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	社交电商是相对于传统电商的概念——社交本身自带去中心化属性，由此延伸出来两个特征：裂变与私域流量。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	裂变来源于社交背后的人脉关系，不仅转化率远高于传统电商，更是能基于信任进行快速传播，也就是裂变获客；\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	而私域流量于商家不仅意味着跳出平台限制自主营销获客，私域流量还具有免费、优质、高黏性、可重复转化的属性。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;text-align:center;\"=\"\"> <img src=\"http://demoall.adashuo.com/20090/uploads/allimg/c191107/15I0c25W3510-551O.png\" width=\"450\" height=\"328\" border=\"0\" alt=\"抖商研习社：如何在抖音做社交电商？-第1张图片-小七抖音培训\" title=\"抖商研习社：如何在抖音做社交电商？-第1张图片-小七抖音培训\" style=\"height:328px;width:450px;\" /> \r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	抖音也能做社交电商吗？\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	1、社交土壤\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	抖商研习社需要指出的是，抖音虽然并非社交产品，但有人的地方就有社交——抖音好友与好友间、粉丝与红人间都有着浓厚的社交氛围，只不过抖音是以陌生人关系链组成的社交平台。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	同时抖音庞大且优质的用户群——以18-28年龄为主，多分布于一二线城市，且女性占比超过60%——配合内容的高传达效率，使得社交裂变有了肥沃的用户土壤。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	2、裂变载体\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	裂变的前提是有足够的用户基础——背靠抖音数亿活跃用户池，好的视频依托推荐算法，及话题、热榜、群聊等流量分发入口，能迅速成为爆款，进而触达更多潜在用户。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	裂变的关键在二次分享，而商品橱窗与购物车并没有相匹配的能力，这就需要借助抖音小程序了：除了可以驱动用户“”挂载小程序二次传播外，小程序的营销插件也自带裂变能力，进而打通裂变的闭环。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	怎么裂变起来？\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;text-align:center;\"=\"\"> <img src=\"http://demoall.adashuo.com/20090/uploads/allimg/c191107/15I0c2593MP-E412.png\" width=\"450\" height=\"331\" border=\"0\" alt=\"抖商研习社：如何在抖音做社交电商？-第2张图片-小七抖音培训\" title=\"抖商研习社：如何在抖音做社交电商？-第2张图片-小七抖音培训\" style=\"height:331px;width:450px;\" /> \r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	1、爆款视频引流\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	抖音卖货的基本逻辑是爆款短视频引流+小程序交易，而爆款视频主要取决于算法推荐，判定标准主要为完播率、点赞评论分享率等，与其辛苦摸索做视频，更便捷的方式则是通过与红人大V合作，以种草视频的方式引流。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	2、给用户裂变的动机\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	抖商研习社有了流量并形成转化后，还需要二次分享才能形成裂变，这就需要给用户一个分享“动机”，可以是折扣、优惠券、返现、赠礼等等，而小程序的营销插件如拼团、砍价、抽奖、分销等，则可以为商家提供裂变营销工具。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;text-align:center;\"=\"\"> <img src=\"http://demoall.adashuo.com/20090/uploads/allimg/c191107/15I0c25a5020-II2.png\" width=\"450\" height=\"319\" border=\"0\" alt=\"抖商研习社：如何在抖音做社交电商？-第3张图片-小七抖音培训\" title=\"抖商研习社：如何在抖音做社交电商？-第3张图片-小七抖音培训\" style=\"height:319px;width:450px;\" /> \r\n</p>',	'doc.png',	1.00,	35,	0,	0,	0,	'2019-12-03 14:08:36',	'admin',	11,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	1.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	13,	1,	0,	1),
(85,	'长沙开老年人维权绿色通道:六成律所成立工作站',	'<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	10月19日，京东宣布今年11.11大促将首次推出“京东拼购”等玩法。10月19日，美团点评官方微信小程序也正式上线了“好货拼团”板块。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	事实上，此前已经有包括阿里、苏宁、今日头条等多家互联网巨头切入了社交拼团业务。而这一切，在笔者看来，巨头们完全已经将拼购当成了获取用户流量的下一个杀手锏。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;text-align:center;\"=\"\"> <img border=\"0\" src=\"http://demoall.adashuo.com/25707/uploads/allimg/c191120/15J2314405K20-1L320.jpg\" style=\"height:auto !important;\" /> \r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	拼购成“香饽饽”\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	根据艾媒咨询发布的《2018Q1中国社交电商行业市场研究报告》显示，2018年中国社交零售用户规模将突破3亿人，年均复合增长率将达到44.2%。这也意味着，未来社交电商或仍将有巨大的增长空间。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	而作为社交电商的集中展现形式，拼购正凸显着自身鲜活的能量。这其中，最值得注意的就是拼购已经成为巨头最新切入的业务。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	具体来看，巨头们正在尝试性地推出自家相关的拼购业务。如果让消费者直接说出某个巨头旗下的拼购业务，可能会非常轻松。因为这些巨头推出的拼购应用，名字上大同小异——手淘特价版、京东拼购、苏宁拼购、今日头条的“值点”……\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	此外，支付宝联合淘宝上线拼购小程序“每日必抢”，网易则推出了“网易一起拼”。总的来看，它们还都是以“拼”、特价为主要特性，为自己烙印下超值的标签。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	而从数据上看，拼购在近段时间以来也成为电商行业的一个热词。根据速途研究院发布的《2018上半年国内拼购电商市场研究报告》显示，在巨头的入场下，它们不仅让自身拥有了亮眼表现，还让拼购行业获得了整体提升。从微信指数和百度指数看，各个巨头的拼购业务都有着显著提升。这也意味着，以布局消费分级市场为目标的拼购，成为了当下巨头眼中的“香饽饽”。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	巨头在拼购行业的试水，还反应在将自身的资源不断向拼购业务倾斜。比如，很多巨头都举办了优惠活动来吸引消费者，并展现自身拼购业务的特性。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	比如：京东拼购频道此前公布了双11玩法，旨在以流量传播扩散+提升订单为目标，通过打造贯穿双11的拼购寻宝乐园，同时引爆11.8拼购玩法狂欢日，为拼购小程序引流，帮助平台转化新用户并提升订单量。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;text-align:center;\"=\"\"> <img border=\"0\" src=\"http://demoall.adashuo.com/25707/uploads/allimg/c191120/15J231440B4F-1U327.jpg\" style=\"height:auto !important;\" /> \r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	苏宁拼购则将重点在直采直销生鲜商品上发力。在刚刚过去的双十拼购日，苏宁拼购一天卖出了40万个柚子，这坚定了其发展生鲜拼购的战略构想。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	因此，我们可以看到，在巨头的不断试水下，拼购这一社交电商模式已经变得迅速火爆。对于消费者来说，这也是一个消费变得多元化的好兆头。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	品质化渐成主流\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	其实，如果不戴“有色眼镜”去看拼购的话，其身上还是有很多亮点的。拼购以低价引入流量，通过关系网对商品进行分裂曝光，在满足多数人追求“低价”需求的同时，又大幅度增加中小商家和尾货的曝光率和购买率。也正因为如此，拼购在当下俨然成为购物模式中的一股新势力。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	但值得注意的是，在拼多多一家独大的时候，其商品质量、售后等饱受诟病。山寨、造假的问题，也造成了诸多负面影响。而在巨头纷纷入场的情况下，实际上也意味着拼购将进入下半场。在下半场开启的同时，拼购也将迎来全新的发展拐点。拼购在展现品质化的同时，也将成为巨头业务的补充，让它们构建更为完善的商业生态矩阵。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	对消费者利好的消息，在于品质化将成为拼购的常态。同时，品质化也将是巨头拼购业务的竞争发力点。不管是为了稳固消费者群体，还是出于维护自身品牌形象的考虑，巨头都不会再去牺牲商品质量和售后来实现低价。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	它们会尽力展示自身的物流实力、电商交易技术能力、核心交易链路、消费保障制度等，将供应链优势发挥到极致。最终，巨头的拼购业务将让消费者享受到具有更高性价比的品质好货，并由此实现真正的消费升级。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	此外，拼购业务的上线也是对巨头自身实力的加强。以美团拼团为例，其让美团实现了从虚拟商品向实物商品的过度，完成了自身商业边界的扩张。中国社科院财经院互联网经济研究室主任李勇坚表示，“过去用户可能只有在吃饭等时候才想到打开美团，但如果增加了商品类拼团，既有用户可能会在APP上停留更多的时间用于浏览商品”。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	而对于巨头而言，以往虽然在努力强调业务之间的整合，但缺少了某个版块后，业务之间总会有割裂感。拼购业务的出现，或许就能成为“黏合剂”，让巨头的业务实现融合发展。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;text-align:center;\"=\"\"> <img border=\"0\" src=\"http://demoall.adashuo.com/25707/uploads/allimg/c191120/15J231440I050-1c916.jpg\" style=\"height:auto !important;\" /> \r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	值得注意的是，对于巨头来说，它们此前都面临着各自不同的发展瓶颈。而要寻找创新增长点，就必须在流量上痛下苦功。拓展流量的最佳做法，就是通过开辟新业务获取。而拼购身为“引流大户”，自然被巨头所看重。在拼购行业的下半场，它们将争抢中高端消费人群，不断攫取新的流量。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	相信随着巨头纷纷切入拼购领域，后者也在加速下沉。而就发展趋势来看，只拼价格不拼质量的原始拼购模式注定被淘汰。在被巨头开启的下半场，拼购有望与消费升级概念的成熟、人均消费能力的提升高度契合。届时，拼购业务也将成为巨头比拼的另一立脚点。\r\n</p>',	'doc.png',	1.00,	15,	0,	0,	0,	'2019-12-03 14:09:59',	'admin',	0,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	1.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	10,	1,	0,	1),
(86,	'孟晚舟赢下一场法律战 加法院要检方提交更多证据',	'<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	11月5日，一项热搜出现在邦哥的微博首页，并且排名一路蹿升至第一，挂在榜首直至今日凌晨：6000多首歌从KTV下架。被下架歌曲中，《十年》、《泡沫》《死了都要爱》《听海》《K歌之王》等等大热歌曲赫然在列。许多媒体的标题用的是：你拿手的还能点么？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	而邦哥脑中也冒出了另一个问号：这些歌曲为什么被下架？谁主导了这次下架风波？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	一个民间组织，为何有权下架全国KTV的6000多首歌？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	这次下架风波毫无疑问是版权问题引起的：中国音像著作权集体管理协会（下称“音集协”）发出公告，要求KTV终端生产管理商和卡拉OK经营者在今年10月31日前，删除或者不向消费者提供6000多部音乐电视作品。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	乍一看这是一件好事，毕竟版权保护理应得到支持，即便6000多首歌的下架在短期内会给普通消费者带来一些麻烦，但依然有利于产业的良性发展。<strong>然而意外的是，邦哥就此与一位业内音乐创作者进行了解时，对方却对此次发出公告的“音集协”并不买账：这个协会其实不是国家的版权保护机构，之前还被央视曝光过收取高额版权费后，并没有给歌手支付费用，我对于之后钱的去向保留意见。</strong> \r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	业内人这样的评论，引起了邦哥的注意，我们随即找到了音集协官方微博，查看其回应此次事件的公告。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\"> <img alt=\"6609首歌从KTV下架，《十年》《泡沫》均中招，原因不止版权那么简单 \" border=\"0\" class=\"aligncenter\" src=\"http://demoall.adashuo.com/25707/uploads/allimg/c191120/15J231444420Z-10TG.jpg\" title=\"6609首歌从KTV下架，《十年》《泡沫》均中招，原因不止版权那么简单 \" style=\"height:auto !important;\" />众所周知，KTV使用他人音乐作品，需要依法取得授权。但全国KTV可以说是海量的，KTV所需要使用的作品也是海量的。实际经营中，要经营者自己去一对一地取得授权，说句实话，并不现实。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	音集协就是在这样的背景下成立的。我们查看了其官网资料，根据资料显示，该协会是会员制，注册会员后，协会可以帮助你进行统一的版权管理，对全国的KTV进行作品授权，或者进行相应的维权措施。但让邦哥十分惊诧的是，这次被下架的6609首歌，背后的版权所有者，没有一家是音集协的会员。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	换言之，<strong>音集协的权利范围本应是帮自己的会员授权和维权，这次却是向6609首他们本应管不着的歌，发放了“下架通知”</strong>……\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在音集协官方微博的回应公告中，这一消息得到了证实：\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\"> <img alt=\"6609首歌从KTV下架，《十年》《泡沫》均中招，原因不止版权那么简单 \" border=\"0\" class=\"aligncenter\" src=\"http://demoall.adashuo.com/25707/uploads/allimg/c191120/15J23144450T0-114138.jpg\" title=\"6609首歌从KTV下架，《十年》《泡沫》均中招，原因不止版权那么简单 \" style=\"height:auto !important;\" />这让邦哥不禁产生了一个疑问：不是音集协的会员，我的歌曲就不能在KTV里播放了么？音集协到底是一个什么样的组织，怎么会有这么大的权利，对非会员的作品也能进行下架处理？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	就此我们在其官网查找到了音集协的《协会章程》，章程总则中清晰地写明了音集协的性质：本团体是由依法享有音像节目著作权或者与著作权有关的权利人<strong>自愿结成的全国性、非营利性的社会组织</strong>。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	一个自愿结成的会员制民间组织，从法理上讲，应当并不具有行政执法权，按照常理本应无权对“非会员”的作品进行下架处理。而在音集协此次回应的公告中，对这一问题的描述如下：\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;text-align:center;\"=\"\"> <img alt=\"6609首歌从KTV下架，《十年》《泡沫》均中招，原因不止版权那么简单 \" border=\"0\" class=\"aligncenter\" src=\"http://demoall.adashuo.com/25707/uploads/allimg/c191120/15J2314445T30-12W41.jpg\" title=\"6609首歌从KTV下架，《十年》《泡沫》均中招，原因不止版权那么简单 \" style=\"height:auto !important;\" /> \r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	对此，邦哥咨询了法律方面的专家，对方表示：6000多首歌的权利人或其委托的代理公司对KTV经营者提起的单独诉讼，就法律关系上讲与音集协相互独立，并无关系。但公告中并未提到音集协与这6000多首歌的权利人或代理公司是否有委托关系，因此<strong>音集协此次的“下架通知”背后，是否有可能是接受了歌曲权利人本身的授权或委托，我们也不得而知。</strong> \r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	曾被众多媒体质疑、央视曝光高额版权费流向哪里？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\"> <strong>2006年，国家版权局规定，开始收取卡拉OK每包间一小时12元的歌曲版权费。我们日常去KTV的费用中，就包括了这部分版权费。</strong>那么这部分版权费收取后流向了哪里呢？根据文章开头从业者的说法，邦哥查阅了很多资料，发现这已经不是音集协第一次处于舆论中心。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	2009年，中央电视台连续多个栏目对音集协收取卡拉OK版权费的情况进行了报道；中央二套的《今日观察》栏目还播出了一期新闻专题节目《版权费还是保护费》，邀请两位专家，围绕卡拉OK版权收费及其分配问题。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	根据当时的报道，<strong>音集协自2007年开始收取KTV及卡拉OK版权费，至2009年，收取的版权费已达8000万元，但这笔钱的使用分配却很不透明，相当多歌手表示并未拿到应得的报酬，但作为集体管理组织的音集协却要收取高达50%的天价管理费。</strong> \r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在当时的采访中，音集协不愿详细说明收费方式以及对著作权人的返还方式。不过一位业内人士向央视记者透露，收费是通过一家叫做“天合文化”的公司进行的。根据公开资料，该公司成立于2007年8月，受音集协委托代收卡拉OK版权使用费。音集协负责授权，天合文化负责收费，二者形成一套KTV歌曲版权收费系统。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	而那时的国家版权局版权管理司王自强司长则认为音集协的做法有欠妥当，在接受记者采访时表示，“集体管理组织是一个非营利性机构，不能以组织企业来进行收费，只能建立自身的收费队伍。收费本体是你本身，你不能有一个第三者出来。”\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	那是音集协引起争议声浪最大的一次，此后也曾有过多家媒体跟踪报道过音集协收取版权费的相关内容。早在2008年就有北京中银律师事务所董正伟律师向国家工商总局、国家发改委举报，请求对音集协向KTV行业收取著作权使用费开展反垄断执法。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	而近两年，音集协受到的质疑更加密集了起来，2017年、2018年都有KTV联合状告天合公司（音集协的授权收费单位）进行行业和价格垄断，但最终都以天合的胜诉告终。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	有趣的是，<strong>音集协与天合文化的合作自2007年至2018年，11年间从未停止。但就在邦哥发稿前不久，音集协官网上出现了一份最新公告，终止了与天合文化的委托合作。</strong> \r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;text-align:center;\"=\"\"> <img alt=\"6609首歌从KTV下架，《十年》《泡沫》均中招，原因不止版权那么简单 \" border=\"0\" class=\"aligncenter\" src=\"http://demoall.adashuo.com/25707/uploads/allimg/c191120/15J231444A250-13U93.jpg\" title=\"6609首歌从KTV下架，《十年》《泡沫》均中招，原因不止版权那么简单 \" style=\"height:auto !important;\" /> \r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	被下架歌曲并非不能唱了，版权保护，路漫漫其修远兮\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	对于一个行业的健康发展来说，6609首无授权歌曲自KTV下架，理应得到支持。但版权收费的规范性、透明性，同样是应该得到重视领域。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在此次风波中，被认证为音集协副理事长的周亚平的微博发言，同样引发了相当多网友的不满：\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;text-align:center;\"=\"\"> <img alt=\"周亚平表示：希望权利人加入，而不加入的后果是“作品被摒弃在卡拉OK渠道之外”\" border=\"0\" class=\"aligncenter\" src=\"http://demoall.adashuo.com/25707/uploads/allimg/c191120/15J231444I530-14Kc.jpg\" title=\"6609首歌从KTV下架，《十年》《泡沫》均中招，原因不止版权那么简单 \" style=\"height:auto !important;\" /> \r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	周亚平表示：希望权利人加入，而不加入的后果是“作品被摒弃在卡拉OK渠道之外”\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在撰文的过程中，邦哥将此次下架的6609首歌曲完整名单下载了下来，发现实际上遭到下架的，只是该首歌曲的某些版本。例如周杰伦遭到下架的《告白气球》等歌，就仅限《中国新歌声》第一季播出版本被下架。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\"> <img alt=\"6609首歌从KTV下架，《十年》《泡沫》均中招，原因不止版权那么简单 \" border=\"0\" class=\"aligncenter\" src=\"http://demoall.adashuo.com/25707/uploads/allimg/c191120/15J231444PZ-15S59.jpg\" title=\"6609首歌从KTV下架，《十年》《泡沫》均中招，原因不止版权那么简单 \" style=\"height:auto !important;\" />虽然这样的版本限制让很多小伙伴产生了“虚惊一场”的感觉，但邦哥要提醒的是，<strong>版权制度的目的，以及所要保护的对象，是创作者和版权所有者的利益。权利人们的利益，决定了他们的生存环境。</strong>如果从业者无法生存，音乐产业的发展从何谈起？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	中国音乐版权保护之路，依然路漫漫其修远兮。\r\n	</p>',	'doc.png',	1.00,	26,	0,	0,	0,	'2019-12-03 14:10:31',	'admin',	3,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	1.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	11,	1,	0,	1),
(87,	'军报:学习贯彻十九大精神是当前首要政治任务',	'<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	人工智能时代已来，雷军为小米找的下一个风口是什么？成立相机部门能“干翻”华为吗?\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;text-align:center;\"=\"\"><br />\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	▲雷军在在故宫发布滑盖手机MIX3\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	作者 |马婧\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	编辑 |赵泽 杨砺\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在喊出“今年相机部门有没有年终奖，就看能不能干翻华为”之后，小米董事长雷军又发新手机了，这一次是在故宫。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	2018年10月25日，在故宫发布磁动力滑盖手机MIX3乾清宫户外发布会，雷军在现场有点激动，一个人solo了将近一个半小时。雷军在介绍手机后置相机时，突然天空中传来两声乌鸦叫，雷军忍不住笑场，说连鸟都在肯定小米手机，“这是我们第一次办的户外的发布会，还这么有趣啊。”\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	25日早间，小米集团发布公告称，预计到10月底，手机出货量将突破1亿台，提前两个月完成2018年全年目标。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	雷军在发布会上谈到，今年手机大厂商和小厂商之间的差距会拉大，主要原因是各家在相机、AI方面投入成本不同所致。今年5月，雷军在内部信中宣布，在手机部内成立单独的相机部，集中全公司优势资源，提升小米手机的拍照品质。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	雷军曾对相机部门的同事说，今年相机部门有没有年终奖，就看能不能干翻华为。25日下午更新了最新成绩，小米MiX3以103的成绩超过了华为P20。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	小米如何“干翻”华为呢？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	▲MIX3故宫乌鸦捣乱小米发布会现场 雷军笑场：连鸟都肯定了\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	未来高增速或不靠手机靠IoT\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	新京报：小米过去8年保持了高速的增长，未来还能有非常高的增速吗？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	雷军：我们对小米未来的高速增长很有信心。首先手机行业是一个很大的市场，2017年全球共销售手机14.7亿台，小米销售了9000多万台。随着5G时代的到来，手机市场可能再次迎来增长，虽然不会像过去增长那么快了，但这个市场即便不再增长，对于小米来说仍然有巨大的成长空间。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	其次，手机之外，小米在智能硬件和消费升级领域布局广泛，已经进入了100多个品类，建成了全球最大的IoT物联网平台。随着AI时代的来临，AI+IoT将产生巨大的价值，小米已经具备了一些优势。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	另外，小米在海外市场有巨大的机遇。小米手机已经进入了74个国家和地区，还有很多市场有待进入，我们的很多品类也还没有进入全球市场。随着小米一步一步进入新的市场，把新的市场做好，我觉得小米未来还有十倍以上的成长空间。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	新京报：我们注意到小米还在布局智能家居。有观点认为智能家居是个伪命题？你怎么看这个问题？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	雷军：“智能家居”不是一个新词，二十年前在国外就有了，只是一直没有推动。我们觉得背后主要原因是商业通道和技术通道没有打通，比如以前智能家居的成本非常高，家里必须重新装修一遍，这对消费者难以负担，此外，不同厂家的产品之间也很难互联互通。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	小米做了两件事情来解决，首先我们把一个个的产品智能化了，消费者买回家后，突然发现实现了智能家居，这是商业通道理顺了。另外，我们做了互联互通的模组，在技术上也打通了，小米智能家居产品由很多不同的公司生产，但只要用了这个模组就可以互联互通。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	智能家居目前只是刚起步，小米也只是刚跨过门槛，今后智能家居的发展空间可能远超我们想像。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	新京报：有人说，小米生态产品只是在做微创新，你怎么看这个问题？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	雷军：从我们创业的经验来看，成功背后都有不为人知的艰辛，哪怕是一点点成绩，都要付出巨大的努力。所以我觉得我们不要小看微创新，为了提升消费者的体验，哪怕仅仅是1%，我们也投入了100%的精力。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	小米立志要成为一家伟大的互联网公司，让全球每个人都享受科技带来的美好生我没有。我们只有全力以赴做好每一件小事，才是走在正确的道路上。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	下一个互联网浪潮是人工智能\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	新京报：如何看待互联网这20年来在中国的发展，如果用几个关键的时间点来划分，你会怎么划分？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	雷军：我觉得2007年苹果推出iPhone是个很重要的事件，智能手机的出现极大的改变了互联网，我判断手机会逐渐替代个人电脑，移动互联网的时代将会来临。2010年小米成立，2011年推出了第一代小米手机，我们推动了智能手机在中国的快速普及和品质提升，移动支付、电商、社交网络、短视频等行业在中国的蓬勃发展，都有赖于庞大的移动互联网人口，这方面小米做了一点贡献。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	新京报：互联网下一个浪潮会是什么？在这个浪潮下，小米的机会是什么？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	雷军：人工智能的时代已经到来了，人工智能也是小米最重要的战略，我们拥有四项巨大的优势，用户群、海量设备、海量的数据、对整个AI时代的认知，很早就重视了云服务和大数据。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	小米选择的突破口是IoT，也就是万物互联，我认为AI与IoT结合将形成AIoT，也就是万物智慧互联，在这个领域未来有着巨大的发展空间。小米已经建成了全球最大的消费物联网，连接了1.15亿台智能设备（不包含手机、平板和笔记本电脑），小米人工智能助理小爱同学月活跃设备超3000万，月唤醒计数超10亿次，累计唤醒次数超50亿次。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“天使投资人经历让我学会找风口”\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	新京报：从金山时代开始，业界对你的评价就是IT劳模，怎么看待这一评价？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	雷军：如果我们要实现与众不同的梦想，付出的不比别人多，怎么可能成功呢？我现在还是这样认为，创业并不光鲜，成功的企业家也不像大家想的，轻轻松松就成功了，哪怕一点点成绩，背后都要付出极大的努力。在成功的路上，其实只有这一个秘诀认真拼命地工作。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	新京报：天使投资人的身份对于创办小米有哪些帮助？创业者和投资人的思维方式最大的不同之处是什么？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	雷军：因为天使投资人做的就是看大势，找风口。我觉得创业要想五年后是什么样子？十年后是什么样子？什么是正确的事情，什么是正确的时间点？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	我当年是一个手机发烧友，认为手机上网是未来的趋势，未来10年是移动互联网的天下，那我接着就想应该做些什么？所以我用投资人的身份，去看谁在做移动互联网，去搞清楚移动互联网到底是什么，这个过程中我们越来越坚信移动互联网的未来，最终在2010年决定创办小米。\r\n</p>',	'doc.png',	1.00,	35,	0,	0,	0,	'2019-12-03 14:11:24',	'admin',	1,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	1.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	13,	1,	0,	1),
(88,	'名校贿赂风波再起 美加州母亲贿赂名校官员替儿子上课',	'<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	不在沉默中爆发，就在沉默中灭亡！\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	这句话来形容当下的区块链。2018年疯狂的区块链因受政策监管与打压，资本、媒体、甚至创业者都趋于冷静。或许，这就是黑暗里的爆发前夜吧。但这个前夜还很长很长…\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	最近一篇题为《业内人士：区块链逐步融入农业发展》文章引起我们的关注。该文提到：“截至目前，区块链已被应用于产品溯源、农业保险、农村金融、智能合约等多个场景。尽管目前区块链技术在农业领域的应用范围还较为有限，但是许多业内人士对于区块链在农业领域的未来发展前景仍然满怀期待”从种种迹象来看，业内人士非常看好区块链在农业领域和场景里的应用。另外，还有政府官员也为区块链+农业打CALL。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	内蒙古蒙草生态环境（集团）股份有限公司董事长王召明表示，作为农业大国，要利用物联网、大数据、移动互联网、人工智能、区块链等现代信息技术，大力推动农业全产业链改造升级，为实施乡村振兴战略插上互联网的翅膀。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	可以肯定：区块链没有倒下，区块链在等待机会。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	业内专家指出，2019年有望成为区块链技术真正落地应用，走向产业化的一年。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	区块链诞生之初，外界都追捧：区块链是各个行业的救命稻草。尤其金融行业、食品行业，当然也包括农业领域。我们聊聊区块链解决农业什么问题？我们认为个有以下几个问题！\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	1农业领域看好区块链\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	1农产品可溯源\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	农产品溯源一直是农业的一个痛点问题。而区块链技术利可以对记录实现不可篡改，因此从农产品的生产端到流通端、消费者都有详实的数据，可以实现消费者明明白白消费，提高消费者购买的意愿。农产品溯源可以提升农产品安全性以及食品的安全性。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	2信息透明\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	农业领域除了可溯源之外，生产者与需求方的信息也存在不透明的问题。一旦区块链技术应用与农业。大家就可以通过大数据分析，建立种植户、采购商的信用评级参考；利用智能合约在种植户和采购商之间保证公平交易。同时，区块链技术可以提高农产品买卖双方的契约精神。另外，随着食品供应链中区块链的出现，这可以简化这一过程，因为数据管理系统，将一系列农民、加工商、分销商、监管机构、零售商和消费者纳入其雷达范围的数据管理系统变得更加透明。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	3降低成本\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	区块链技术运用之后，生产、流通等2大环节的成本会大大降低。比如，区块链技术解决信息自动存贮和数据库的功能，如此就减少了人工的投入和其他设施的投入。另外，区块链及应用实现万物互联，帮助生产商和渠道商降低各项开支。同时，生产和流通成本的降低，也会降低农产品的价格，最终还是消费者获利。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	因此，区块链技术在农业领域的应用等到各级人士的认同。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	2现在的区块链农业玩家\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	从以下多个案例来看，这些企业的确把区块链技术应用到用户服务中。他们希望借助区块连技术解决食品安全和可溯源，从而提高消费者对品牌的认可度。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	1沃尔玛\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	沃尔玛公司在2017年内在区块链技术领域作出了大量尝试。沃尔玛一直在与IBM合作，共同开发针对食品安全问题的区块连解决方案。比如，沃尔玛把区块链放在芒果、猪肉等生鲜农产品上。沃尔玛食品安全副总裁Frank Yiannas曾表示：“我们的客户理应拥有更加透明的供应链。我们认为在21世纪，以前那种一步一步去追溯源头的方式已经过时了。这是一项由技术支持的明智举措，它将极大地造福我们的客户，并彻底改变食品体系，使所有的相关者受益。”\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	2 Dreyfus\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	大宗商品交易公司Louis Dreyfus（路易达孚）宣布已试用由ING（荷兰国际集团）等一批金融机构开发的基于区块链的交易系统。Dreyfus使用区块链平台来完成与中国供应商的大宗大豆交易，极大地缩短了交易时间。同时，据参与测试的公司表示，这次测试涉及从美国运到中国的大豆，并在平台内保存所有相关文件（包括销售合同和信用证）。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	3可口可乐\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	2018年，可口可乐正在与美国国务院、区块链信托加速器（BTA）、区块链技术公司Bitfury集团以及崛起币（Emercoin）共同合作，推出一项基于区块链技术的试点项目。同时，可口可乐公司建立区块里的平台，以帮助确保道德的糖生产。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	4家乐福\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	2018年，欧洲最大的零售商家乐福已经开始采用区块链账本技术去追踪鸡肉、鸡蛋和西红柿从农场送到商店的全过程，并将在未来几年在其所有生鲜产品线上部署这种技术。比如，2018年3月，家乐福中国首款区块链产品——琯溪蜜柚，获得用户疯抢。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	5 Smart农场\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	中国农业已经迎来4.0时代，高科技融合成为农业发展的方向。上海华中农投农业科技有限公司旗下Smart农场大力推动区块链的应用。将区块链技术与农业相结合后，能最大限度地消除信息不对称，提高整个产业链的信息透明度和及时反应能力，从而实现整个产业的增值。减少农药投入，提高农产品品质。解决农业的痛点，解决农产品的食品安全、食品供给问题，真的能让中国人都尝到放心的味道。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	3未来走向\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	区块链去中心化等特性，将大幅降低互联网维护成本，提升农业物联网的智能化和规模化水平。同时，基于区块链技术的农产品追溯系统，解决了消费者对于产品的信任危机，让人们的餐桌更健康，更安全。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	另据前瞻产业研究院发布的《中国区块链行业商业模式创新与投资机会深度分析报告》统计数据显示，随着区块链应用场景扩展，预计2019年具有投入产出的区块链企业超过600家，产业规模有望超过8亿人民币。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	有人预测：2019年，“区块链技术”正逐渐从幕后走向台前。我们从2个方面来看：区块链技术迎来利好！\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	1）从大背景来看，国家政策打击比特币，但支持区块链技术在各个行业的应用。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	2）从行业来看，目前大数据和人工智能的发展，区块链技术也将会逐步与其他高科技项目融合赋能产业。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在农业领域，区块链农业又将会呈现哪些趋势和走向呢？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	1物联网＋无人机＋区块链\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	中国农业已经迎来4.0时代，高科技融合成为农业发展的方向。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	物联网＋无人机＋区块链的结合将有利于精准农业的发展，减少农药投入，提高农产品品质。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	其中，物流确保万物互联，无人机提供生产管理服务，而区块链提供记录和可溯源等技术。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	2区块链+数据+人工智能\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	区块链应用于农业，能最大限度地消除信息不对称，提高整个产业链的信息透明度和及时反应能力，从而实现整个产业的增值。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	而区块链+数据+人工智能的融合发展，可以推动农业大数据的价值最大化，降低投入成本。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	3区块链+农业金融\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	2月初，中国政府发布了“关于农村金融服务振兴的指导意见”。此次提出的新框架，是国家农村振兴计划中金融服务效率提高计划的一部分。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	同时，该指南据称将有助于促进农村金融部门中如区块链等新技术的应用，以“改善农业信贷风险的识别、监测、预警和处置水平”。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	该公告还预测，新技术将鼓励金融机构“为农村电子商务开发专用贷款产品和小额支付结算功能，并开辟农村电子商务资本链”。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	区块链+农业金融将会为小农户贷款提供便捷途径，为农业金融机构的征信带来真实性和可预测性。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	4区块链+农村物流\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	随着区块链、物联网、大数据等新兴技术与物流行业的深度融合，供应链正成为区块链技术最具潜力的应用场景之一。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	由于农村物流的小散，导致包裹丢失、农产品上行困难等窘况。但区块链技术可以解决这些问题。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	西南交通大学交通运输与物流学院副院长罗霞指出示，农村振兴是今年党中央非常重要的战略部署，与农村物流高质量发展紧密相关。加强云计算、区块链、人工智能等供应链智能化技术在农村物流中的应用，为农产品的生产、检测、周转、销售、品控、管理等提供智力支持。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	5区块链+农业供应链\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	这一类应用就是各大商场嫁接区块链的原因。比如：沃尔玛、家乐福等大型超市把整个生鲜和食品供应链纳入区块链管理，从而降低成本，提高产品的安全性。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	目前，美国农业巨头嘉吉等都在大力发展区块链+农业供应链金融的应用。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	总结一下，2019年区块链在农业领域的应用将会再次迎来爆发。但我们还要明一点：区块链只是一项技术，而不是赚钱的工具。在整个农业发展中，区块链只做赋能者，而不是主导者。如此，路子才会越走越宽！\r\n</p>',	'doc.png',	1.00,	16,	0,	0,	0,	'2019-12-03 14:13:27',	'admin',	14,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	1.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	10,	1,	0,	1),
(89,	'俄国产客机图334为何没人要 跟中国运10下马很相似',	'<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	电子商务飞速发展，快速增长的包裹数量与日渐减少的快递员数量已经不成正比。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	快递员的工资回报越来越高，为什么这个职业在近年来从事人员锐减呢？对此，有很多快递员反映，虽然能够得到很高的工资回报，但随着人们对服务水平的要求也越来越高，他们也越来越辛苦。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	同时，快递员的社会地位相对较低，随着人们文化水平及文化素养的逐渐提高，一些有学历有技能的人都已不太愿意做快递员。申通副总在7月25日召开的中国快递“最后一公里”峰会上就表示，现今快递行业的痛点已不仅是解决“最后一公里”的问题，而是怎样才能够招到更多的快递员。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	中国高速发展中，人口红利也在逐渐的减少，越来越多的事情都开始被智能化技术所取代，但快递行业是属于劳动密集型企业，非常依赖快递员。快递行业正处在用人难之际，双十一等各种电商狂欢节的到来无疑是让这些快递企业悲喜交加。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	智能快递柜提升末端物流配送能力，备受物流企业青睐\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	快递员不足是人口红利减少的必然结果，因此急切需要新兴技术缓解快递行业的压力，智能快递柜作为解决方案就这样“问世”了。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	智能快递柜在2012年萌芽，中邮速递易率先推出智能快递柜，在初期遭遇了很多的质疑和非议，但在包裹数量不断增长以及城市年轻劳动力不足的情况下，智能快递柜已经成为末端物流配送能力的重要补充，各路资本企业竞相涌入该市场，想分得一杯羹。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	2015年6月，顺丰、申通、中通、韵达、普洛斯投资5亿元成立丰巢科技；2016年10月，中集e栈、上海富友收件宝、江苏云柜组成创赢联盟，形成了以速递易、丰巢和创赢联盟为主的三巨头格局；2017年7月，中国邮政集团与驿宝网络入股速递易，中国邮政以50%股份控股速递易，“国家队”正式进入智能快递柜行业……智能快递柜已然成为物流企业人手必备的基础设施。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	国家邮政局10月17日发布的 《2018年9月中国快递发展指数报告》显示，快递企业与第三方创新末端投递形式，基本形成上门投递、智能箱投递、平台投递等多元末端服务体系，主要企业设立智能快件箱25万组，箱递率达到8.4%。高速增长的数据表明智能快递柜前期虽饱受争议，但后期已逐渐被民众所接受。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	智能快递柜突破派件瓶颈，效果显著\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	首先，智能快递柜降低了人力成本，减少了快递员的工作负荷。快递员的工作量和工作任务较为繁重，在人手不足的情况下一个快递员往往需要承担起更多的工作，经常超出本来的工作时间，因此快递公司需要对快递员支付较高的人力成本。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	智能快递了增加派件数量，在提高了快递员的工作效率的同时，也提高了他们的收入，在一定程度上缓解了“用人难”问题，降低人力成本。在这一点上，丰巢获取得的效果极为突出：在今年九月初，丰巢与链家进行合作并声称他们的日均派件量已高达900万+,这个数据对于快递行业来说无疑是一个巨大的进步。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	其次，智能快递柜提高了用户隐私保护力度，取件时间更随意。当今社会，人们对于隐私非常重视，而在传统的快递人员配送模式中，存在快递信息被其他人窃取或是快递在寄存的时候丢失等问题，智能快递柜保密性更强，能极大减少了这种问题的发生。再加上传统的配送模式中快递员配送的时间可能会和收件人在家的时间不对等，给收件人带来了困扰，智能快递柜投入使用使得忙碌的人们可以随时取件，极为方便。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	智能快递柜陷入困境：难盈利、争议大\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	智能快递柜诞生是时代进步的需要，也给我们的生活带来了巨大的改变，但很多问题也接踵而来。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	首先，盈利难。一方面是因为快递柜的设备生产成本高和在每一个小区内投放的租金比较高，快递柜的场地年租费也较高，同时维护费用也不低。过高的成本使智能快递柜不能为企业带来营收利润，这对每一个企业来说都是致命的打击。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	佼佼者丰巢和速递易均面临着巨大亏损：截止2017年9月30日，丰巢科技在该年9个月期间的营业收入为1.6亿元，净亏损从2016年的2.5亿元扩大到2.76亿元，负债总额扩大到12亿元；运营速递易项目的三泰科技也是出现常年亏损，2015 年亏损3792.8万元 ，2016 年亏损 12.69亿元，2017年第一季度亏损也将近3000万元。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	另一方面是用户往往不会愿意为此付费。用户认为在购买商品时已支付过运费，取快递时就不应该再支付额外的费用，使得快递柜的亏损日益增加。同时，蜂巢、速递易等快递柜也开始向快递员收取存放费用，其中速递易快递柜的收费标准为：大箱0.6元/件，中箱0.5元/件，小箱0.4元/件，但很多快递员不愿承担这些费用。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	其次，智能快递柜虽然提高了快递员配送快递的效率，但使得快递员很轻松的逃避了签收这一流程。用户无法进行当面进行签收，使得物品运输过程中出现的质量问题时的合法权益无法得到保障，收货时发现快递有问题不知该向谁反映。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	最后，在包裹数量的飞速增长的背景下，快递员如果像从前一样一件件把快递送到消费者手中显然是不太现实的事。所以现在的快递员在快递高峰时段一般都使用智能快递柜，不会打电话一一进行通知，在把物品投入快递柜时会由系统自动给用户发送取件通知，而如果快递员在放入物品时把用户的手机号输入错误，会导致用户无法接收到取件通知，从而超时取件。现在部分品牌快递柜超过一定的取件时限需要收取一定费用，这让用户难以接受。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	另外，有用户在使用丰巢快递柜时，页面会出现“打赏”等字样，价格以1、2、5元为不等，这样确实能为丰巢带来一定的收益，虽然不是强制收费并且设有“跳过”的字样，但由于字体过小，有引诱用户消费的嫌疑因此用户在使用过程易产生误解与不满。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	智能快递柜如何赢得“民心”？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	智能快递的问题柜已经严重影响后期的战略布局和发展，企业应当如何解决成了广泛关注的焦点。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	首先，智能快递柜最初出现时毫无营收利润，很大程度上是因为单纯的取件不可能有任何收入增长，但是现在智能快递柜的发展已涉及到寄件的环节，这意味着快递柜也可以从中赚取一定的利润。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	智能快递柜要想继续获得更大的盈利，应该继续为用户提供更多增值服务，让用户为此愿意付出相等的费用。比如，在各种人流量较大的公众场合，有很多用户因为手上提的东西过多有很大的不便，快递公司可以在这些场合投放寄存柜方便用户存放，并收取一定的费用，据了解蜂巢已经在试点，今年5月中标了杭州周边17个高铁站，总计36组寄存柜的订单。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	其次，面对快递柜无法当面签收的缺陷，快递柜企业应继续完善快递柜的基础硬件设施，比如在每一组快递柜上安装摄像头，用户在取包裹时可以将包裹在摄像头下展示，将来包裹质量出现问题时可以避免物流企业和用户之间产生不必要的纠纷。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	最后，针对部分用户不满快递员在未经允许的条件下投递快递柜的问题，早在2016年国家邮政局发布的《智能快件箱投递服务管理规定（暂行）》中就曾明确提出，“经营快递业务的企业在使用智能快件箱投递快件前，应当征得收件人明示同意”，同时用户有权利决定是否使用快递柜或是按指定地点取货，用户应该积极行使自己的权利。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	企业在这样的背景下应加大对快递人员基本服务知识的培训力度，同时加强对客服人员处理客诉的能力，及时处理客户问题并进行反馈。快递员在把包裹放入快递柜时应检查该快递是否为需要保鲜、即食类食品，一旦出现商品问题则由快递公司或快递员承担全部责任。面对取件通知收不到等问题，在首次投递后收件人未能提取的情况下，快递企业应及时取回快递，联系收件人后再提供投递服务。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	小结\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	时代与技术在发展中，任何行业的各个环节都应该往效率更高，成本更低道路上发展。物流末端的需求是多样化的，送货上门是主流，但智能快递柜的市场潜力也不可小觑。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	根据中商产业研究院发布的 《2018-2023年中国智能快递柜市场前景及投资机会研究报告》 ，预计2018年智能快递柜市场规模将达169亿元，到2020年，中国快递柜市场规模将达近300亿元。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	所以，丰巢等智能快递柜未来应加大沟通协调力度，在提高消费者满意度的同时，尽快解决盈利模式问题，尽可能地保证效率、成本、体验和信息的互动。\r\n</p>',	'doc.png',	0.00,	25,	0,	0,	0,	'2019-12-03 14:14:23',	'admin',	1,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	0.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	10,	1,	0,	1),
(90,	'丽水原副市长林康听内部消息炒股被套 浮亏超千万',	'<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	今年5月，唱吧终于完成了将近一年半的上市辅导工作。网上有消息称，唱吧在一个月后，就会正式向证监会递交招股书，踏上A股创业板的上市征途。但眼看着2018年就快要过去，却迟迟未见唱吧上市的消息。对此，唱吧创始人陈华在接受媒体采访时表示，对唱吧上市问题不愿多谈，言外之意是唱吧在近期内可能不会寻求上市。这突如其来的转变，让人们疑惑不解。唱吧在完成一年多的漫长上市辅导期之后，为何不愿上市？其究竟打的是什么“算盘”？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	唱吧上市搁浅，原因为何？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	唱吧从2012年上线起，便风光无限。其在上线首日注册用户就超过10万，5天之内登顶AppStore排行榜。易观数据显示，直到2016年第3季度，唱吧还以53.6%用户渗透率位居移动K歌领域第一的位置。彼时，唱吧正如日中天，选择上市无疑是正确之举。然而世事无常，经过将近一年半的漫长辅导期，国内的在线K歌市场早已“物是人非”，唱吧已然错过了最佳的上市时机。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	其一，全民K歌抢了唱吧“风头”。众所周知，全民K歌背靠腾讯，可谓是含着“金钥匙”出生。全民K歌不仅拥有微信与QQ两大流量入口，还与QQ音乐共享丰富的音乐版权，在流量与音乐版权方面都有着天然的优势，是唱吧最强劲的对手。据了解，全民K歌自2014年上线起，其活跃人数一直高增猛涨，在2016年成功超越唱吧，并逐渐拉开差距。据易观数据，2018年第三季度，唱吧活跃用户为6560万人，而全民K歌活跃用户则为20705万人，是唱吧的三倍。面对全民K歌的“攻城略地”，唱吧显然处于不利地位。而全民K歌的赶超，可能打乱了唱吧的上市计划。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	其二，短视频平台的崛起，冲击整个互联网娱乐市场。近几年，由于快手、抖音等短视频平台的崛起，整个互联网娱乐市场变的更加“拥挤”，唱吧的K歌业务、直播业务等都受到了一定的影响。QuestMobile数据显示，2018年7月，短视频APP行业月度活跃用户规模为5.08亿人，而短视频APP行业总使用时长在移动互联网中的占比达到惊人的9.2%，要知道，就算是在线视频的占比也仅有9.5%。可见，短视频APP行业已经抢占了大量互联网用户的上网时长，唱吧无法视而不见。再加上全民K歌的存在，唱吧要想巩固自身地位并不容易，目前也很难有华丽的数据支撑，若是在此时上市，唱吧的估值可能并不理想。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	其三，互联网股市动荡不安。最近国内不少已经上市的互联网企业过的并不“如意”，如小米、拼多多和美团等企业都出现了市值大幅下滑的情况，就连腾讯、阿里巴巴等老牌互联网企业也没能避免。受此影响，唱吧此时选择不上市或许是明智之举。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	一方面，在国内互联网股市行情不利的情况下，唱吧此时上市无疑是逆水行舟，有着“流血破发”的风险；另一方面，今年国内的互联网公司纷纷申请上市形成了“上市潮”，如宝宝树、映客、小米和拼多多等，如此多的公司扎堆上市，吸引了不少资金注入，导致资本市场紧缩，也就是说投资人手里的钱越来越紧张。这也许会造成唱吧融资困难，难以得到理想的融资金额。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在这些问题影响下，唱吧暂时将上市的计划搁浅，等待更好的时机上市，或许是不错的选择。不过除了上述三个原因之外，也有业内人士猜测，唱吧之所以要搁浅上市，可能是其要放弃A股创业板，而选择赴港上市。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	港股市场火爆，令唱吧有所动摇？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	对于唱吧要赴港上市的猜测，也并不是没有依据。早在2015年，唱吧就曾想要赴美上市，但由于美国缺乏与唱吧对标的产品，而导致其估值过低，令唱吧有所顾虑。与之相比，当时国内的A股市场行情较好，且国内资本对互联网科技股也愈发青睐。所以再三思考后，唱吧毅然拆除了VIE架构，选择回国赶赴A股上市。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	时至今日，随着港交所在上市机制上的改革，首次接受同股不同权企业上市，为互联网企业打开了一扇大门，包括小米、美团点评、平安好医生和宝宝树等多家明星企业都选择在港股上市。而此时的唱吧或许面临着与三年前类似的选择题，是A股还是港股？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	据了解，上市A股要求较为严格，除了必须盈利三年才能申请IPO外，还必须同股同权。而现在的港股市场，除了支持同股不同权企业上市，其监管机构也更加独立透明和高效，公司一般在6到12个月就能完成上市过程，可以帮助企业更好地把握好上市时机。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	此外，A股实行的是“T+1”交易制度，股民们当天买进的股票当天不能卖出，且还有涨跌幅限制。而港股采用的则是“T+0”交易制度，在当天交易时段内，相关机构和股民们可以自由买卖，交易次数与涨跌幅均无限制，这种方式不仅能够提高市场的交易量，还能帮助投资者及时止损。所以二者相对比较来看，港股市场规则似乎更加灵活且合理化，能帮助企业有更好的发展。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	且从根本上来讲，企业上市无非就是希望借助资本的力量，获得更好、更快速的发展。而随着港交所改革，港股已经成为了众多互联网公司上市的首选。在此条件下，唱吧若是选择“跟风”，改赴港股上市，也不是没有可能。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	不过从目前来看，在市场竞争加剧、股市动荡等问题影响下，唱吧此时上市并不稳妥。所以暂时将上市计划搁浅，继续修炼“内功”，才是唱吧最好的选择。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	养精蓄锐，厚积薄发\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	目前，纵观整个移动K歌市场，已然是唱吧与全民K歌双雄称霸的局面，像天籁K歌、K米和酷狗唱唱等K歌产品已经难以给全民K歌、唱吧二者带来威胁。可见，唱吧在移动K歌领域还是有着非常明显的领先优势，只要其能够完善自身，加强功能创新，或许就能够摆脱全民K歌所带来的竞争压力，在互联网娱乐市场中走的更远，其上市之路也会变得更为平坦。对此，唱吧可以从以下三个方面入手。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	首先，丰富曲库资源，提高音乐品质。音乐版权是移动K歌行业的刚需，缺少相应的音乐版权，用户就无法得到理想的K歌体验。如在用户K歌时，一定会选择自己喜欢的音乐进行录唱，但用户若是在唱吧中搜不到自己想要唱的歌曲，在别无选择之下，用户就会选择用其他的K歌软件进行录唱，最终造成唱吧的用户流失。因此，唱吧要想缩小与全民K歌的差距，还需与相关的音乐版权公司合作，丰富自己的曲库资源。同时，唱吧还应继续提升APP内的伴唱、录音和修音等音乐品质，争取为用户提供更加优质的K歌享受，以此来留住和吸引更多用户。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	其次，加强线上、线下融合，丰富用户K歌体验。如今，唱吧正在大力布局线下市场，其不仅花费数千万元战略投资麦颂KTV，并实现了与麦颂KTV在社交、服务等多方面的合作，还大力布局线下移动迷你KTV业务，取得了不错的成效。据了解，唱吧不光在全国拥有400多家麦颂KTV门店，还在商场、超市和机场等公共场所布下了2万多台迷你K歌亭。不过唱吧虽然在线下布局极广，但其线下资源还未能与线上达到有效的结合。目前唱吧在APP内只提供了KTV包房预定、在线点歌和在线切歌等常用功能，还有很大的完善空间。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	对此，唱吧可以在APP内添加游戏点歌、K歌评比和K歌挑战赛等有趣功能，加强用户线下与线上的互动。同时，用户在麦颂KTV里演唱的歌曲最好也能保存在唱吧APP中，让用户可以在唱吧APP中发布并分享自己在麦颂KTV里的演唱歌曲，这不仅满足了用户的分享欲望，又加强了线上与线下的融合，可谓是一举两得。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	最后，走出海外，争夺更大的移动K歌市场。如今，唱吧已经在国内取得了不错的成绩，其知名度和影响力也都达到了一定的高点，所以唱吧要想再有突破，并不容易。在此情况下，唱吧若是向海外市场发起冲击不失为一个选择。一方面，目前海外的许多国家都缺少类似唱吧这样的K歌产品，还是一片蓝海，这对唱吧来说有着不错的发展机遇；另一方面，在全民K歌、抖音、快手等平台影响下，国内的互联网娱乐市场空间变窄，唱吧要想继续在此环境中发展将受到不小的阻碍。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	总的来说，虽然上市会为唱吧带来新的发展机遇，但在市场竞争加剧、股市动荡等问题影响下，此时上市，对唱吧来说有着较大风险。因此，唱吧只有继续精细化运营，加强线上线下融合，并等待时机成熟后再进行上市，才会迎来更好的发展。\r\n</p>',	'doc.png',	0.00,	39,	0,	0,	0,	'2019-12-03 14:17:25',	'admin',	3,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	0.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	14,	1,	0,	1),
(91,	'这张小男孩躺地上的照片 牵出英国举国关心的问题',	'<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	换上炫彩外壳，装上多变口味的烟弹，上市多年的电子烟今年突然热度飙升，成了备受追捧的创投领域。除了罗永浩在发布会上顺势推销的福禄电子烟，2018年末到2019年初，还有近10个新兴电子烟品牌出现。在深圳华强北电子市场，出售电子烟的广告牌更是如雨后春笋般涌现。但面对日趋严密的控烟大网，创业者们能否咽得下“这口烟”仍存在极大变数。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\"> <strong>电子烟突然变网红</strong> \r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	蓝莓、菠萝、水蜜桃、绿豆冰棒、柠檬茶……说到这些，不少人会联想到口香糖或是冰淇淋，却几乎没人能想到，这些全都是电子烟推出的新口味。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	精巧如U盘或是一根签字笔，也不用点火，从口袋里掏出来，打开开关就能用——近一年来，以电子产品形象出现的电子烟成了创投领域的新网红。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	今年1月，罗永浩在子弹短信新版本“聊天宝”发布会上，顺势推销了一款名为福禄、由锤子科技二号人物朱萧木创业推出的电子烟产品。紧接着，同道大叔创始人蔡跃栋与黄太吉创始人赫畅推出的“YOOZ柚子”，5位自媒体人组成创始团队的“灵犀&nbsp;LINX”也纷纷杀入。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	猪年春节，常年浸淫在科技圈、创投圈的自媒体人士陈女士惊讶地发现，平日里不抽烟的她，竟然收到了3种不同的电子烟产品作为新年礼物。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在深圳华强北，曾经卖VR眼镜、贴牌手机和智能家居产品的柜台，纷纷开始转售电子烟。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	突如其来烧起来的电子烟，背后是资本不断添柴加火。2018年，国内有十几家电子烟公司获得资本青睐，总融资额达数亿元。Wel鲸鱼、YOOZ柚子、魔笛MOTI、TRYMIX反正、GOIN谷云、APOC……新兴的电子烟品牌让人目不暇接，俨然造就了岁末年初最火热的创业领域。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\"> <strong>风口背后的同质化</strong> \r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“电子烟界的iPhone”、“颜值爆表一口解馋”、“重新定义吸烟”……在各家打出的广告语中，几百元一支的电子烟似乎成了可供电子发烧友们品玩一番的电子玩具。然而，花哨热闹的营销语言背后，电子烟的实质技术并没有太大区别。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“花几个月到半年时间，联系供应商、备货、外观设计，剩下就不需要你再做什么了，几乎没有任何硬性投入，本质上是个非常‘轻’（投入）的生意。”早期投资人付强向媒体透露，做一个电子烟项目，对技术等原创能力的要求几乎没有门槛。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	多位行业人士透露，由于国内电子烟供应链已经被电子烟发展较为成熟的国外市场培育得非常完备，因此很多新创立品牌都是通过代工生产。有技术爱好者对几款热门电子烟进行评测后发现，几个品牌在开关控制、烟油技术等方面相差无几，只是烟弹、外壳颜色、口味等进行了不同的排列组合与拼凑。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“电子烟的产品结构并不复杂，主要构成也就是充电电池（烟杆）、雾化器还有烟油三部分。”新晋电子烟品牌灵犀创始人章晋源坦言，电子烟的制造门槛并不高，确实存在行业同质化问题，“灵犀LINX当前着重聚焦于品牌环节，属于产业链下游，希望设计的首款产品具有品牌辨识度。”\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\"> <strong>电子烟也有多重风险</strong> \r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“清肺水果味”、“健康清肺蒸汽烟”……稍加留意就会发现，不少电子烟公司将产品与健康挂上了钩。在他们口中，因抽烟承受健康风险的烟民可以通过电子烟追求潮流文化、拥有“健康生活方式”。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	电子烟是否能够像一些公司所说的那样起到“代烟”、“辅助戒烟”的功效？目前尚无定论。令人担忧的是，一些原本不吸烟的人因为对电子烟的好奇而加入了烟民行列。在游戏公司工作的白先生告诉记者，他的同事和合作伙伴里出现了好几位新一代“电子烟民”——而他们过去根本不碰香烟。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	北京营养师协会理事顾中一提醒，电子烟中虽然没有普通烟草燃烧所产生的焦油、一氧化碳等有害物，但仍然含有有毒、成瘾的尼古丁，对普通人特别是儿童、青少年仍然有危害。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	记者在一家电子烟的天猫店铺内发现，虽然商品详情页面的底部用黑色背景的字体写着“未满十八岁不允许购买”，但一不留神就会错过这一信息。并且，记者在尝试下单时，店铺对身份信息、年龄等方面毫无要求，消费者可以随意下单购买。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	顾中一还提醒，由于目前市场监管并没有完全到位，缺乏相关国家标准，电子烟产品中用到的原料、调味剂、工艺都较为随意，厂家很可能为了增加新奇体验加入一些对人体有害的物质。“哪怕是一些比较常见的添加剂，正常食用是安全的，吸入肺部却可能带来潜在风险。比如丙二醇是很常见的食品添加剂，但是燃烧后容易刺激呼吸道，一些电子烟的烟雾中也可能含有重金属。”\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	对创业者来说，更大的考验来自于市场的不确定性。在控烟大势下，多地已经将电子烟列入了管控范围。今年2月，继杭州、南宁等城市在公共场所禁止使用电子烟之后，深圳在其控制吸烟条例征求意见稿中将电子烟纳入了控烟“黑名单”。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	意识到道德、法律等多重风险，一些科技上市公司急于与电子烟划清界限。今年2月中旬，小米公司官方微博就对“小米旗下生态链公司将进军电子烟领域”一事进行回应，称“小米不会做电子烟，此事纯属谣言”。\r\n	</p>',	'doc.png',	1.00,	37,	0,	0,	0,	'2019-12-03 14:18:03',	'admin',	2,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	1.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	13,	1,	0,	1),
(92,	'章莹颖案律师:警方掌握嫌犯说明如何杀人的录音',	'<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	2018年可谓是中国智能音箱的元年。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	业内普遍认为，智能音箱是切入智能家居使用场景、并易于被用户接受的理想入口，而智能家居的开关一旦被打开，更多的产品和服务将快速进入消费者的日常生活，获得一个更多元的商业环境。因此，近两年国内外科技巨头、互联网巨头皆大力发展智能音箱，使得该领域得到飞跃式增长，并从小众逐渐走向大众。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	值得一提的是，智能音箱除了具有巨大的消费市场外，对于互联网巨头们来说更起到AI市场的“门票”的作用。在这个快节奏的时代，企业之间的竞争更加激烈，率先拥有某一行业的门票就相当于成功了一半。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	由此，继国外亚马逊、谷歌、Facebook、苹果等科技巨头布局智能音箱产业之后，国内如阿里、百度等巨头也纷纷入局，小度智能音箱、叮咚、天猫精灵等产品在市场活跃度直线上升，国内智能音箱市场一片繁荣，随后在去年打起了“智能音箱价格战”。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	全球互联网巨头共掀全球智能音箱浪潮\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	根据Strategy Analytics发布的《2018年第三季度全球智能音箱市场报告》，2018年第三季度全球智能音箱出货量达到2270万，同比增长197%，创历史新高。其中，亚马逊智能音箱的全球份额与2017年相比有大幅下降，但出货量一直在上涨，第三季度市场占有率依然最高，达到32%，而谷歌以23%的市场占有率紧追其后。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	值得一提的是，来自中国的阿里、百度、小米智能音箱出货量分别排在全球第三、第四、第五位。当中又以百度表现最为亮眼，其市场占有率从2018年Q2的1％增加到2018年Q3度的8％，超越小米，成为当之无愧的黑马。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	而根据eMarketer《2019年智能音箱市场趋势观察》的预测，2019年中国将拥有8550万智能音箱用户，超过美国7420万的用户数量。智能音箱在美国网民中的普及率为26.0%，远高中国的10.0%，因此未来中国智能音箱领域还有极大的发展空间。不过即便如此，国内企业想要在智能音箱领域进一步发展仍有极大挑战。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	首先，是亚马逊、谷歌、苹果等海外企业更加成熟的智能音箱产品的冲击。亚马逊于2014年11月发布了Echo音箱，揭开智能音箱的序幕，打了人工智能领域“领头羊”谷歌、设备领域“领导人”苹果一个措手不及，成为智能音箱领域的第一人，为其之后进军智能家居领域打下基础。随后谷歌、Facebook、苹果等科技公司纷纷跟进，相继推出GoogleHome、Portal、HomePod。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	而后，无论是亚马逊并购互联网路由器初创企业Eero，还是谷歌推出Google Wifi，都表明国外在智能家居领域发展正愈加成熟，由此给国内市场带来的冲击是巨大的。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	其次，是国内错综复杂的智能音箱市场而产生的原生阻力。国内智能音箱市场厂商繁杂，主要有五种类别：一是以BATJ等为主的互联网公司，希望通过语音这一入口建立智能生态，为既有的内容和服务寻找新市场；二是以科大讯飞为代表的，专注于技术开放平台建设的技术厂商；三是以喜马拉雅等内容厂商；四是主打智能家居的创业公司；五为以漫步者为代表的传统音箱厂家。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	与国外相比，国内智能音箱领域除了厂商更繁杂、竞争更激烈外，在时间上也有一定的滞后性。国内第一款智能音箱叮咚诞生于2015年，由京东与科大讯飞联合推出。此后国内智能音箱市场沉寂，直至2017年阿里试探性地推出天猫精灵，小米、百度等企业不甘落后，纷纷入场，国内智能音箱才进入密集发售期，一时间智能音箱领域热闹非凡，“百箱争鸣”。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	当先天不足遇上恶劣生存环境\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	当下，我们不能否认的是，随着家庭中联网设备的不断增加，有极大几率成为未来智能家居控制中枢的智能音箱有着非同一般的重要性。但古往今来，利益有多大，风险就有多大。对于如钥匙般的智能音箱领域来说，发展面前有三问需解答。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	首先，智能音箱如何“智能”？\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	每当市场有了新的风口，就会出现无数跟风之人，智能音箱也不例外。为搭上智能音箱的顺风车，传统音箱厂家推出不少产品，只不过卖点都集中于音质，本末倒置。 另外，“语音识别技术”也是尚未完善，一方水土一方人，同一语种还有不同口音，更别提各地方言以及语境涉及到的自然语言理解问题。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	除此之外，还有人工智能和物联网领域中老生常谈的安全隐患问题，如数据存储、身份认证、敏感数据保护等，在此不多赘述。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	其次，智能音箱如何提高普及率与使用率？\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	我们知道，物联网时代“未来智能家居的控制核心”这一定位是智能音箱如此火热的重要原因之一。而理想的智能家居生态并非是家居单品的智能化，而是彼此联动，达到互联互通互控的状态，但目前的智能家居系统仍旧处于互相独立的状态，使得智能音箱使用率不高，如同“鸡肋”。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	与国内相比，国外在此方面就先进得多，以美国为例，美国的智能家居行业有统一的标准协议，亚马逊的Echo可以直接接入各种智能家居设备，这也是为何美国智能音箱普及率远高中国的原因。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	最后，国内企业如何“走出去”？\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	在用户习惯方面，国内外有着不小的差异。以使用环境为例，国外用户居家环境多为开放式，美国家庭主妇在烹饪时都喜欢听音乐，因此智能音箱在国外的消费需求也相对较高。而国内，厨房客厅封闭性更高，生活环境相对嘈杂，相应地市场对智能音箱需求较低。此为国外厂家难以进入中国市场的重要原因之一，另一限制则是人机交互的“本土化”程度低。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	以苹果HomePod为例，虽然其Siri语音助手对中文的支持已经有一定成果，但在交互、理解能力等方面，与本土选手阿里、百度相比仍是落后。并且，以BAT为代表的国内企业拥有更多本土资源，境外企业如苹果，很难在中国有突破性进展。同理，国内企业想要走出去也会遇到同样的难题。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	综上，智能音箱可谓是“腹背受敌”，而现阶段各巨头发展智能音箱的主要目的并不是盈利，而是抢占更多的用户家庭，为未来AI生态建设进行数据铺垫。那么，中小企业如何在这场战争中存活呢？\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	双重风暴下，智能音箱可靠内容过冬\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	前文提过，国内有一类以喜马拉雅为代表的注重内容的智能音箱厂商，笔者认为现阶段此类厂商可能更好存活。现今用户对智能音箱的主要需求还处于“听”的情况下，智能音箱很大程度上是内容生态之争。在此基础上，喜马拉雅以自身丰富的内容为基础，推出智能音箱小雅，将更容易在家庭场景中突围。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	虽然从整体上看，喜马拉雅与BATJ等互联网巨头在技术和未来AI整体布局上存在相当大的弱势，但由于各种原因的限制，国内用户对智能音箱的需求在接下来很长一段时间里，都将处于“听”的阶段。并且，智能音箱核心技术“语音识别”，从本质上来说也是内容的一部分。从另一角度看，喜马拉雅的竞争对手也并非是BATJ等互联网巨头，其在智能音箱领域的发展更多的是为了扩充自身音频业务，巩固自身在在线音频市场的地位。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	同样的，在内容资源上有着强大优势的还有腾讯，毕竟现阶段消费者购买智能音箱的主要用途就是内容消费和智能家居两方面。在此基础上，腾讯可将自身音乐、阅读和视频整合，为智能音箱做内容支持。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	除了内容消费，“智能音箱+教育”的模式发展空间也十分广阔，尤其是早教领域。抛开说烂了的在线教育，光是国人对子女教育的重视程度，就足以让智能音箱注意到“早教”这一领域。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	单从目前智能音箱市场情况来看，短时间内C端消费市场的表现都比不过B端。因此，如何在B端站稳脚跟再最终反哺C端，是智能音箱发展过程中相当重要的一点。站在这个角度上看，“智能音箱+早教”的未来十分令人期待。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	毕竟，国内早教行业师存在资水平有限，地域发展不平衡，多数幼师仅经过短期培训就上岗从业，专业化程度低等问题。若是将智能音箱与早教结合，它所承载的大量专业、系统、科学的早教课程，能完美弥补传统绘本、书籍、视频等的缺点，再加上其操作简单、安全性高、不损伤视力的优点，能让智能音箱成为早教过程中不可或缺的工具。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	当然，除了以上两个方向，智能音箱作为人工智能音频端的入口，能够发展的B端场景是十分丰富的。就此，在C端市场来临前，国内非巨头企业在智能音箱领域也有了新的突破口。那有没\r\n</p>',	'doc.png',	1.00,	9,	0,	0,	0,	'2019-12-03 14:18:52',	'admin',	4,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	1.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	3,	1,	0,	1),
(93,	'一次偶然的交通违法 小伙找到了失散26年亲生父母',	'<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	社交网络下一步发展的未来在何方？6日，Facebook创始人扎克伯格给出了自己的答案。在一篇长达3200字的公开博客文章中，这家全球最大的社交网络的掌门人称，未来Facebook将专注于营造一个更为私密和安全的网络社交环境。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“当我思考网络的未来，我认为专注于隐私的通讯平台相比今天的开放平台，将变得更加重要，”扎克伯格写道：“今天我们已经看到私密消息、短故事分享和小规模群组是在线通讯交流发展最快的领域。”\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	尽管扎克伯格认为，开放社交网络在未来仍有一席之地，但更大的机会在于“建立一个首先专注于隐私的更为简单的平台。”\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	扎克伯格称，在过去15年间，Facebook和Instagram帮助建立了一个“数字化的公开广场“，但人们开始迫切需要更为私密的”数字化的客厅空间“。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	对于Facebook来说，这将是一个具有里程碑意义的转型，成立15年来，Facebook成功打造了全球最大的公开社交网络，并在此基础上建立起一家以广告业务为主的商业帝国。但近年来，随着一系列与用户数据隐私泄漏相关的丑闻接连爆发，Facebook开放社交模式遭遇到前所未有的严峻挑战。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	正是由于内外部坏境发生的变化，促使Facebook开始思考接下来的转型方向，如今，这家全球最大的社交网络通过其掌门人的一封公开信给出了解答。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“我认为未来的通讯将更多地转向私密的、加密的服务，这样人们在与别人交流时，对于信息的安全新、内容不会停留会更有信心，”扎克伯格说，“这是我希望我们能够帮助带来的未来。”\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	为了达成这一目标，扎克伯格称，Facebook即时通讯平台将向Whatsapp的模式靠拢，未来端到端的加密服务将贯穿于Facebook所有旗下包含即时通讯的业务功能，该表态印证了此前外界流传的Facebook计划打通旗下即时通讯功能的传言。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	扎克伯格称，计划按照打造WhatsApp的模式进行：专注于最为基本和私密的应用场景即时消息开始，让其尽可能的安全，然后在此之上建立更多让人们能够互动的方式，包括打电话、视频聊天、群组、故事、商业、支付最终成为更多私人服务的平台。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	为了实现这一转型目标，扎克伯格列出了数项准则，包括加密、缩短内容的存续、安全、互通和安全数据存储。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“我相信我们应该朝着建立这样一个未来世界而努力：人们可以私下说话并且知道他们的信息只会让他们希望看到的人看到并且不会永远存续下去，“扎克伯格说，”如果我们能够帮助世界朝着这个方向发展，我将会为我们所做出的努力感到自豪。“\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	以下为扎克伯格公开博客全文：\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	注重隐私的社交网络愿景\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	过去几年，我的重点一直是理解和应对Facebook面临的最大挑战。这意味着对关系到互联网未来的重要问题采取什么立场。在本文中，我将概述Facebook围绕建立以隐私为中心的信息和社交网络平台的愿景和原则。有许多的事情要做，在开发的进程中，我们承诺开放式的工作，并将与全社会的专家进行协商……\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	过去15年间，Facebook和Instagram一直在帮助人们与友人、社区和等同于数字城市广场中的兴趣联系在一起。但是人们也越来越想私下在相当于起居室的数字环境中进行交流。当我思考互联网的未来时，我认为一个注重隐私的交流平台将变得比今天的开放平台更加重要。隐私让人们有自由做自己，更自然地联系，而这些是我们建立社交网络的原因。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	今天，我们看到私有信息、短暂的故事和小型群组已成为在线通讯中增长最快的领域。这有许多原因。许多人更喜欢一对一交流，或者只是与几位朋友交流。人们对分享有永久记录的内容更加谨慎。我们也都希望能够私下和安全地进行支付。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	公共社交网络将继续在人们的生活中发挥重要作用--与你认识的每一个人联系；发现新的人、想法和内容；让人们有更广泛的发言权。人们每天都会发现有价值的内容，而且还有很多有用的服务可以构建在它们之上。但是现在，人们也想通过各种方式私下交流，这也让我们有机会打造一个首先专注于隐私、更简单的平台。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	我明白很多人不认为Facebook有能力、或者甚至不想构建这种以隐私为中心的平台，因为坦率地讲，我们目前在构建隐私保护服务方面没有很好的声誉，而且我们一直专注于更开放的共享工具。但是我们已多次表明，我们可以通过进化来打造人们真正想要的服务，包括私有信息和故事。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	我认为，通信的未来将越来越多地转向私有、加密服务。在此类服务中，人们可以确信他们对彼此说的话是安全的，他们的信息和内容不会永远存在。这是我希望我们能帮助实现的未来。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	我们计划用开发WhatsApp的方式来构建这一平台：专注于最基本和私有用例--消息--尽可能确保它的安全性，然后构建更多的方式让人们在此基础上进行互动，包括通话、视频聊天、群聊、故事、商业、支付、商务，最终成为许多其他类型的私有服务的平台。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	这个注重隐私的平台将围绕以下几个原则构建：\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	·私下互动：人们应该拥有简单、亲密的场所，在那里可以清楚地控制谁可以和他们交流，并且相信没有人可以接触到他们分享的内容。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	·加密：人们的私人通信应该是安全的。端到端加密防止任何人，包括我们在内，看到人们分享在我们服务中的内容。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	·减少永久性：人们应该感到自在，不应担心他们分享的内容会反过来伤害自己。因此，我们不会将信息或故事保留超过提供服务所需的时间，也不会超过人们希望它们留存的时间。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	·安全：人们应该期待我们会尽一切努力，在加密服务可能的范围内，确保他们在使用我们服务时的安全。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	·互操作：人们应该能够使用我们的任何应用联系他们的朋友，应该能够轻松安全地通过网络交流。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	·安全数据存储：人们应该期待我们不会在隐私和言论自由等人权记录薄弱的国家存储敏感数据，保护数据被不当访问。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	未来几年中，我们计划围绕这些想法重建更多的服务。在此行程中，我们面临的决定将意味着对关系到互联网未来的重要问题采取什么立场。我们清楚有很多权衡需要纠正，我们承诺与专家进行协商，并讨论最佳的前进方向。这需要一些时间，但我们不会关着门朝着这个方向发展。我们将尽可能以公开、合作地态度这样做，因为其中许多问题影响到社会的不同层面。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	私下互动是基础\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	要让一项服务感觉具备私密性质，绝不让用户怀疑在和谁交流。我们努力在所有产品中建立隐私属性，包括公共分享产品。消息服务的一个重要特性是，即使用户的联系人列表在扩充，用户的个人线程和群组仍然是私有的。随着时间的推移，用户的好友会逐渐发展，消息服务会优雅地发展，并保持亲密。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	这与更广泛的社交网络不同。在社交网络中，人们可以积累好友或追随者，直至服务更加公开。这非常适合许多重要的用途--告诉用户所有的朋友一些事情，在重要的话题上传递用户的声音，寻找有相似兴趣的人群，追踪创作者和媒体，买卖东西，组织筹款人，发展业务，或者让用户认识的每一个人在相同的地方得到好处。尽管如此，当用户一起看到所有这些经历时，感觉更像是一个城镇广场，而不是一个更私密的空间，比如客厅。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	我们有机会建立一个关注人们想要私下交流的所有方式的平台。这种隐私和亲密感不仅仅是技术特征--它被深深地融入到服务的整体感觉中。举例来说，在WhatsApp当中，我们的团队专注于在产品的各个方面创造一个亲密的环境。即使我们构建了允许更广泛分享的功能，这仍然是一种不太公开的体验。当团队开发群组功能时，他们设定了规模限制，以确保每一次互动都是私密的。当我们在WhatsApp上发布故事时，我们限制了公共内容，因为我们担心这种做法可能会削弱隐私感--即使这并没有真正改变用户和谁分享。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	几年后，我预计未来版本的Messenger和WhatsApp将成为人们在Facebook网络上交流的主要方式。我们致力于让这两款应用更快、更简单、更私密、更安全，包括端对端加密。然后，我们计划增加更多与好友、团体和企业私下交流的方式。如果这种进化成功，通过Facebook网络与用户的好友和家人互动，将会从根本上成为一种更加私密的体验。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	加密与安全\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	人们期望他们的私人通信是安全的，并且只被收方看到，而不是黑客、罪犯、过度干预的政府，甚至是操作正在使用的服务的人。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	人们越来越多的意识到，更多的实体可以访问自己的数据，就越容易被人滥用或被网络攻击泄露。一些人也越来越担心，技术可能会将权力集中在政府和像我们这样的公司手中。一些人担心我们的服务可能会访问他们的信息，并将其用于广告或其他他们不期望的方式。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	端到端加密是开发注重隐私的社交网络的重要工具。加密正在分散--它限制了像我们这样的服务看到流经的内容，并使其他人更难访问用户信息。这就是为什么加密在我们的网上生活中越来越重要，从银行到医疗健康服务。这也是为什么我们在收购WhatsApp后把端到端加密植入WhatsApp中的原因。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	去年，我曾与持不同政见者交流过。他们告诉我，加密是他们自由甚至活着的原因。一些政府经常对数据提出非法要求，当我们在法庭上驳回这些要求时，我们总存在败诉的可能--如果信息没有加密，我们要么必须交出数据，要么不遵守法庭规定导致员工被逮捕。这看起来很极端，但是我们曾有过这样的案例，一名员工就因为不提供对某人私有信息的访问而身陷囹圄。事实上，我们也无法访问这类信息，因为它是加密的。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	与此同时，在我们能够在所有消息服务中部署端到端加密之前，我们需要解决真正的安全问题。加密是保护隐私的有力工具，但也包括做坏事的人的隐私。当数十亿人使用同一服务连接时，他们中的一些人会将它滥用于真正可怕的事情，比如剥削儿童、恐怖主义和敲诈勒索。我们有责任与执法部门合作，并尽所能帮助防止这些行为。我们正努力通过检测活动模式或其他方式，来提高识别和阻止应用中不良行为的能力，即使我们看不到消息的内容，我们将继续对这项工作进行投资。但是我们面临着一个内在的权衡，因为当我们的安全系统能够看到这些信息时，我们永远也不会发现我们今天所做的所有潜在伤害。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	找到保护隐私和安全的正确方法，是社会在历史上一直努力解决的问题。这里还有许多悬而未决的问题，我们将与安全专家、执法部门和政府协商实施安全措施的最佳方式。我们还需要与其他平台合作，以确保整个行业能做出正确的事情。我们越是能创造一种共同的方法越好。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	总的来说，我相信为所有私人通信实施端到端加密是正确的。人们通过信息和电话完成一些最敏感的私人谈话，在网络安全威胁日益增加、许多国家政府干预过度的情况下，人们希望我们采取额外措施来保护他们最私密的数据。对我而言这似乎是对的，只要我们花时间构建适当的安全系统，尽可能在加密服务的范围内阻止不良行为。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	我们已开始在WhatsApp的基础上开发这些安全系统，在全面实施端到端加密之前，我们将在2019年及以后与专家讨论这些系统。随着我们从专家那里学到更多的知识，我们将最终确定如何推出这些系统。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	减少永久性\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	我们越来越相信在短时间内保存信息非常重要。人们想知道他们分享的信息不会反过来伤害他们，减少他们信息的存储和访问时间会有所帮助。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“永久性问题”开发社交工具的一个挑战是。随着时间的推移，我们积累了大量的信息和照片，它们在成为资产的同时，也成为了一种负担。例如而言，许多Facebook的老用户可能会有年轻时候的照片，这可能会让人尴尬。但是人们也非常喜欢记录他们的生活。如果Facebook和Instagram上的所有帖子都消失了，人们将无法获得他人分享的大量宝贵知识和经验。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	我认为有机会为私有通信平台设定一个新的标准--内容会自动过期或随时间归档。除非用户存档，否则故事会在24小时后过期，这让人们更自然地分享。这种理念可以扩展到所有私人内容。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	举例来说，在默认情况下，信息可以在一个月或一年后删除。这将降低用户的信息再次出现并让他以后尴尬的风险。当然，如果用户愿意，可以自己改变时间框架或者关闭线程的自动删除。如果用户愿意，我们还可以为用户提供选项，让他将个人信息在几秒钟或几分钟后设置为过期。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	限制我们存储消息元数据的时间也有意义。我们使用这些数据来运行我们的垃圾信息和安全系统，但我们并不总是需要长时间保留这些数据。解决方案的一个重要部分是首先收集较少的个人数据，这也是WhatsApp从一开始就建立的方式。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	互操作\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	人们希望能够选择他们用来与人交流的服务。然而，今天如果用户想在Facebook上给人们发信息，你必须使用Messenger；在Instagram上必须使用Direct；在WhatsApp上必须使用WhatsApp。我们想给人们一个选择，这样他们可以通过这些网络从他们喜欢的任何一款应用联系他们的朋友。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	互操作性有隐私和安全优势。举例来说，许多人使用Android上的Messenger收发短信。这些文本不能进行端到端加密，因为短息协议没有加密。然而，有了跨我们服务传递信息的能力，用户就可以从Messenger向WhatsApp中的某人的电话号码发送加密短信。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	这还可以提高许多体验中的便利性。在这些体验中，人们使用Facebook或Instagram作为他们的社交网络，WhatsApp作为他们首选的消息服务。举例来说，许多在市场上出售商品的人会列出他们的电话号码，这样人们就可以发送与购物相关的信息。这并不理想，因为用户要给陌生人提供电话号码。有了互操作性，用户就可以使用WhatsApp接收发送到Facebook账户的信息，而无需分享电话号码--买家也不用担心卖家是喜欢在哪个网络发信息。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	可以想象许多类似这样的简单体验--一个人在Instagram上发现了一家公司，并很容易过渡到他们喜欢的消息应用，以获得安全的支付和客户支持；另一个人想追上一个朋友，可以向他们发送一条消息，发送到他们喜欢的应用，而不必考虑这个人喜欢在哪里被联系；或者用户只需在Facebook和Instagram上发布一天的故事，就可以在一个地方得到好友的所有回复。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	今天，用户已可以通过Android上的Messenger发送和接收短信，我们希望在未来进一步扩展这一功能，或许包括新的电信RCS标准。然而，在这成为可能之前，我们需要解决几个问题。首先，苹果不允许应用在他们的设备上与短信交互操作，所以我们只能在Android上这样做。其次，我们需要确保互操作性不会损害人们已使用WhatsApp的加密预期。最后，它会在加密系统中造成安全漏洞和垃圾邮件漏洞，让人们从未知的应用中发送信息，因为我们的安全和安保系统看不到这些活动的模式。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	这些都是重大挑战，有许多问题需要进一步协商和讨论。但是，如果我们能够实现这一点，我们就可以给人们更多的选择，让他们使用喜欢的服务，以安全地联系到他们想要联系的人。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	安全数据存储\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	人们想知道他们的数据安全地存储在他们信任的地方。展望互联网和隐私的未来，我认为我们将做出的最重要的决定之一是：在哪里建立数据中心和存储人们的敏感数据。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在一个国家提供服务和在那里存储人们的数据有着重要的区别。当我们在世界各地建设基础设施时，我们选择不在有侵犯隐私或言论自由等人权记录的国家建设数据中心。如果我们在这些国家建立数据中心并存储敏感数据，而不仅仅是缓存非敏感数据，这可能会让这些政府更容易获取人们的信息。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	坚持这一原则可能意味着我们的服务在一些国家会受阻，或者我们不能很快进入其他国家。这是我们愿意做出的折衷。我们不认为在一些国家存储人们的数据是一个足够安全的基础，可以在其上建立如此重要的互联网基础设施。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	当然，保护最敏感数据的最佳方法是根本不存储它，这就是WhatsApp不存储任何加密密钥的原因，我们计划在以后的其他服务中也这样做。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	但是在更多国家存储数据也开创了一个先例，鼓励其他国家政府寻求更大程度地获取其公民的数据，从而削弱了全世界人民的隐私和安全保护。我认为，对于互联网和隐私的未来而言，我们的行业继续坚决反对把人们的数据存储在得不到安全保障的地方，这一点很重要。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	下一步举措\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在接下来的一年及以后，我们还要制定出与这些原则相关的许多细节和权衡。这项工作中的许多仍处于早期阶段，我们致力于与世界各国的专家、倡导者、行业合作伙伴和政府(包括执法部门和监管机构)协商，以正确做出这些决定。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	与此同时，通过这些原则开展工作只是构建以隐私为中心的社交平台的第一步。除此以外，我们还需要对在此基础上构建的所有服务进行深入思考--从人们如何支付和金融交易，到企业和广告的作用，再到我们如何为其他私人服务提供平台。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	但是，这些最初的问题得到正确答案是至关重要的。如果我们做得好，我们可以创建私人共享平台，这对于人们而言可能比我们建立的帮助他们更公开分享和联系的平台更重要。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	这意味着对关系到互联网未来的重要问题采取什么立场。作为一个社会，我们有机会阐明我们的立场，决定我们如何重视私人通信，以及谁来决定数据应该存储多长时间以及存储在哪里。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	我认为我们应该努力实现这样一个世界，让人们可以私下交谈，自由生活，知道他们的信息只会被他们想看到的人看到，而且不会永远停留在身边。如果我们能帮助世界朝着这个方向发展，我将为我们所取得的成就感到自豪。\r\n	</p>',	'doc.png',	1.00,	18,	0,	0,	0,	'2019-12-03 14:19:38',	'admin',	1,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	1.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	10,	1,	0,	1),
(94,	'新西兰火山震动加剧 或有6具遗体被火山灰覆盖',	'<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	今年两会期间，明星委员们的提案再次将炮火对准了劣迹艺人、明星及影视数据造假、身价片酬等行业乱象，不过前方固然慷慨激愤，后方还是其乐融融，#明星该不该吃粉丝送的食物#、#明星被认错#等话题频繁被推上热搜，娱乐氛围依旧。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	但今年还是有些许不同，2018年影视连续震荡所牵引出的政策新规，将在今年集中落地并被检验效果，前段时间，吴秀波、翟天临事件又掀起公众对娱乐圈造假的口诛笔伐。换句话说，娱乐产业规则改写的时机，可能已经同时具备了政策自上而下和舆论自下而上的两个必要条件。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	若是如此，数据造假将成第一个靶子，而往后推，数据造假的一环如果被铲除，是否能动摇当前畸形的粉丝经济呢？这是值得业界探讨的。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	造假产业链的逆向思考\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	2019年开年，《人民日报》发表文章，矛头直指流量明星锁场、刷榜、买粉丝，而后其又连续发表微博，感慨“明星流量数据节节攀升，8亿网民不够用”。随之跟进的还有《光明日报》《北京日报》，而“紫光阁”则从1月5日-9日，连发4条微博，痛批流量明星，呼吁“没有高质量作品做支撑，那些拙劣的表演终将被揭穿”。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	影视产业春寒料峭，一场“打假运动”的兴起，或许正是今年的新风向。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	微博已率先做出反应，宣布针对转发、评论计数显示方式在内做出种种调整，而更早之前，爱奇艺和优酷停止了播放量的展示。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	这对于影视数据脱水进而回归合理无疑是一个有利信号，视频及社交平台本身就是流量造星、粉丝运营的核心媒介，隐藏播放量起码减掉了数据造假的一个需求。虽然不得不承认，这一举措对整个行业来讲，也只是让数据造假不至于假得太“难看”，但其释放的市场信号是积极的：影视数据造假的乱象，今年或许不会止于揭露。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	以此为基础，我们再来看影视产业数据造假的产业链。一般来讲，卖方一端通过雇佣技术型或人工型水军，提供刷流量业务，至于买方一端，央视将明星数据造假的推手，归为自发组建的粉丝组织和经纪公司安排成立的明星微博数据站。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	两方需求契合，流量明星通过这一番操作获取一定的人气和地位，从而掠取演艺资源。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	而提供演艺资源的制片方、投资方以及媒体平台，又因流量明星的参与而收割商业利益，当然，这其中更少不了购买数据用以打榜、投票、转发的过程。无奈的是，这已成为市场优胜劣汰的“规则”，如果粉丝的偶像数据不好，就会被其他艺人的粉丝“唱衰”。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	由此可以看出，流量经济是一个参与方都可获得经济效益的模式，这也决定了很难从内部去戳破流量泡沫。但如今政策导向下，很有可能从外部强制性切断数据造假产业链，若是如此，会对以流量为基础的粉丝经济造成什么伤害？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	我们可以逆向推断，假使数据归真，流量明星及其所产出的内容，在市场的反应能够一目了然，首先最可能放弃他们的就是内容生产方。因为对比靠实力说话的演员，流量明星原本与之天差地别的流量优势，很大程度上被削弱了，而今口碑反噬又日渐严重，制片人也不再经得起多次的扑街。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	相应地，流量明星的演艺资源一旦被缩减，曝光度大大降低，广告商、媒体以及平台很快便“闻风而动”。更关键的是，明星本人新粉难增、旧粉流失，长此以往就更没有商业价值了。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	流量经济还是粉丝经济？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	当娱乐产业的优胜劣汰逐渐被流量所左右，如果从流量数据本身出发，一定程度上是可以约束某些行业乱象的滋生。但是流量缩减、粉丝仍在。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	蔡徐坤被央视点名时，震慑是对业内的，粉丝看似不惧。真爱粉们一面为爱豆打抱不平，力挺蔡徐坤确实是个专注音乐的好歌手，甚至表示之前做了那么多公益怎么不提？另一面又将攻击点集中到微博上，强烈要求整改。不过，前者是顾左右而言他，后面则是祸水东引，实则都没什么逻辑。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	从这件事直观地看，粉丝本身就是流量的一部分，即使最大程度地将流量数据脱水，蔡徐坤、鹿晗这类当前比较符合年轻群体审美的明星，也仍有不在少数的粉丝存留，他们才是饭圈的核心。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	换句话说，粉丝即使不花钱为他们的偶像刷流量，他们还是有其它方式向外界传达和证明自家爱豆的价值，甚至可以简单的说，只要粉丝愿意为爱豆花钱，在制片人和品牌方眼里，明星便有商业价值。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	这主要是因为当前的影视行业中，<strong>粉丝看似处于被收割的产业下游，实则主导着偶像的人气和商业吸引力。</strong> \r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\"> <strong>一方面，粉丝已经参与到偶像的职业规划中，用自己的力量为偶像争取好资源。</strong>而市场也认可了这种做法，现在广告商、制片方最看重的，不再是明星的业务水平，而是背后的粉丝力量。所以，纵然市场能抛开流量数据，演员和明星粉丝群体的差别，也无法使商业资源偏向前者。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\"> <strong>另一方面，如今流量明星的粉丝展现出强大而可怖的集体力量，如果不再允许数据造假，他们对舆论的影响也能帮助明星维持流量再造。</strong>极端一点，像粉丝骂战、撕逼这种普遍现象，一经推手，在当前这个碎片化时代便是天然的流量爆发点。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	所以，<strong>数据打假所能纠正的也只是流量经济，而触及不到更深层次的粉丝经济。</strong> \r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	时至今日，粉丝和流量的先后产生顺序已经模糊，这就是数据造假导致的，不过粉丝是基础，流量经济可以说是在资本介入、疯狂膜拜粉丝效应之后被放大的形态。这和移动互联网时代流量为王的思维，实则异曲同工。不过移动互联网进入下半场的服务升级，娱乐产业的流量经济反而日渐衰颓了。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	明星“死于”粉丝？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\"> <strong>围绕粉丝和明星的行业规则及利益链一旦形成，实际上就连一个环节的整治都很难，更不要指望其内部会自我改进。</strong>但值得庆幸的是，当前流量经济之所以逐渐露出真相，在于其外部的反对力量日益强大，也催促市场形成一套新的淘汰法则。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	最明显的是电影界，流量明星的多番试水，让投资方再也经不起折腾。2016年“小鲜肉+大IP”的模式备受追捧，2017年参与暑期档大战的流量明星只有杨洋、李易峰两人，而到2018年暑期档、春节档，杨洋、鹿晗等人早已不见踪影。李易峰的《动物世界》即使备受肯定，票房仍不能回本。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	数据显示，2018年全国电影票房已经超过2017年总票房559.11亿元，创下新纪录，但票房前十的影片主演中均不见小鲜肉身影。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	流量明星开始被排斥在大荧幕之外，而且他们在业内留下的印象一旦被定性，投资人只会对他们避之不及。而下一个排斥流量的便是观众，这很容易让流量明星丧失转型的时机，甚至是永久被划在攻击的范围之内。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	这是口碑反噬的副作用，比如《创业时代》开播之初，很多人还没看剧，只知道有杨颖主演便给出了一星评价，迪丽热巴则一个人把《声临其境》的评分拉到了4.3。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	一个经典角色可以成就一个明星，但一个明星也有可能毁了众多角色，观众便将不满全部发泄到流量明星身上，反而不会再客观考虑是不是剧本、导演不行。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	不过作品口碑败光的更多是路人缘，而且市场通过这种副作用反噬的方式淘汰流量明星，毕竟是一个相对缓慢的过程。关键是，他们背后的死忠粉依然是“东山再起”的资本。<strong>所以一个流量明星的消失或死亡，完全取决于粉丝。</strong> \r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	事实也是如此，我们看到，<strong>人设崩塌是最近常见的最快导致明星坠落的方式，而人设本质就是为迎合粉丝存在。</strong>粉丝心理假说认为，追星一种身份认同，粉丝通过对名人的“镜像”认识自己，塑造价值观，而一旦粉丝发现这种“镜像”是虚假的，认同感瞬间就消失了，而且会有上当受骗的感觉。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	当然，粉丝也是善变的，他们自然而然流失，流量明星们也就被市场抛弃了。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\"> <strong>流量数据的虚假泡沫被戳破总归是好的，但娱乐行业的乱象却无法根治，终究是粉丝把明星捧得太高了。</strong> \r\n	</p>',	'doc.png',	1.00,	29,	0,	0,	0,	'2019-12-03 14:20:16',	'admin',	3,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	1.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	11,	1,	0,	1),
(95,	'欧冠-国米负巴萨进欧联杯 利物浦2-0头名 切尔西出线',	'<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	你可能不知道咪蒙，但却一定知道她有一个月薪5万的助理。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	年初，在“寒门状元”事件之后，咪蒙就曾宣布关停微信公众号两个月，并永久关停微博。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	不想仅仅过了不到一个月，2月21日咪蒙以及旗下“才华有限青年”等微信账号就宣布将被永久关停。旗下美妆账号改名为“李粒粒LiLiLi”，咪蒙小号“好疼的咪蒙”则清空了所有内容。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	从咪蒙公布之前公布的报价来看，其微信公众号头条广告报价一度到达80万元，二条也有40万元。这次的账号注销还包括今日头条、凤凰号等等，并称咪蒙“不得转世”。咪蒙的商业帝国几乎被连根拔起。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	除了自媒体，同时可能就此终结的还有咪蒙刚刚开始的编剧生涯。2018年3月，柠萌影业曾经宣布，由咪蒙担任编剧的网剧《长大成人》正在筹备中。现在咪蒙被封，这部“神似”《欢乐颂》的作品最终何去何从也被画上了问号。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	<strong>“毒鸡汤女权”，这不只是咪蒙的专利</strong>\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	正如我们上文所说，咪蒙还在积极谋求走向影视圈，成为编剧便是第一部。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	了解咪蒙的人都知道，咪蒙的文章一向以宣扬所谓“女权”为导向，用一碗一碗的鸡汤，挑动着公号中近600万女性粉丝的内心。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	作为一个影视的门外汉，咪蒙之所以开始进军影视当编剧，其实和中国影视，特别是网台剧当中 “大女主”等题材层出不穷有着直接关系。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	从《欢乐颂》里的五个姐妹，到《我的前半生》里的罗子君，从楚乔到关皮皮，不一而足。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	然而，在这些所谓的“大女主”或者“女权”剧却很少体现真正的女权，而或多或少的会体现出“咪蒙式女权”的感觉。 男一都会对我不离不弃，男二都会生死相依，男三都会“我的眼里只有你的桥段大行其道，靠男人上位的情节也充斥其中，女权成为了寄居在男权上的笑话。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	再有，许多职业剧也会加入大量爱情桥段，“谈判官”改谈恋爱，“猎头”改“猎对象”的情况也多次发生。这也正如咪蒙的风格，看似让人“自强不息”，实则只想让你成为“坐在宝马里笑的人”；看似是在不断激励，实际只是找准了观众的七寸，然后一颗颗的吃下早预备好的“致幻药丸”。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	但这样的剧情虽然满足了女性观众对于爱情内容的需要的同时，本身也局限了内容的发展。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	首先，这样的剧所有内容几乎都必须围绕爱情展开，亲情、职场、宫斗、武侠等本应该更重要的戏份反而成了陪衬。由此，很多所谓的职场剧、宫斗剧到头来都变成了无限尴尬的爱情剧。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	更重要的是，“咪蒙式的女权剧”并不是真正的男女平权，当女性意识进一步觉醒之后，就会开始逐渐摒弃这种价值观。正如《致橡树》中所说，“我如果爱你，绝不学攀援的凌霄花”。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	再次，随着90后以及更年轻观众的崛起，单身才是社会更加主流的形态。生活方式的改变也会影响大家对于影视剧的观看喜好。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	更进一步说，“大女主”实际上是披着女性思维的外衣，但实际上却站在男性立场的表现。女性是白莲花、傻白甜，需要靠男性，甚至众多男性实现目的，这其实是一种变向的“被包养”。托名女权，实际宣扬的却是一种并不合理的价值观。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	咪蒙已经悄然落幕，但“伪女权”却依然大量存在于影视剧之中。但随着品质口碑成为了市场主流，真正的女权影视剧登上舞台恐怕也不会太远了。\r\n</p>',	'doc.png',	1.00,	8,	0,	0,	0,	'2019-12-03 14:21:05',	'admin',	10,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	1.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	3,	1,	0,	1);
INSERT INTO `sl_news` (`N_id`, `N_title`, `N_content`, `N_pic`, `N_price`, `N_sort`, `N_del`, `N_order`, `N_long`, `N_date`, `N_author`, `N_view`, `N_preview`, `N_mid`, `N_sh`, `N_tag`, `N_fx`, `N_video`, `N_top`, `N_tpl`, `N_shuxing`, `N_keywords`, `N_description`, `N_price2`, `N_vshow`, `N_ds`, `N_dsintro`, `N_uncopy`, `N_sort2`, `N_unlogin`, `N_viponly`, `N_vip`) VALUES
(96,	'西班牙发生“史诗级闹剧” 中国早已表达立场',	'<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	短视频行业的发展无疑已经进入到了深水区，以短视频变现为代表的全新发展正在把这个行业越来越多地放到了市场的前台。作为一种全新的内容表现形式，短视频在经历了资本乱战、巨头追捧之后，或许应该进入这个“年纪”。然而，变现并非易事，短视频变现更是难上加难。如果能够走出短视频变现的考验的泥淖，这个行业的发展无疑将会发展成熟。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	当然，如果仅仅只是一味地追求变现，而不去深究短视频本身的内在运行逻辑。所谓的短视频变现同样会陷入困境，火爆的短视频行业将会如同火爆的流量一样陷入表面的繁华。的确，几乎所有的商业模式都应该形成一个生态闭环，才能称得上是一个成熟的商业模式。如果仅仅只是停留在某个阶段的繁荣，所谓的商业模式仅仅只是一个概念，无法真正落地。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	我们看到当前以抖音、快手为代表的短视频行业巨头都在进行变现层面的探索，无论是社交，还是电商，对于短视频背后更加深层次的商业层面的探索正在成为一种发展的主流。不可否认的是，尽管短视频变现进行得如火如荼，但是依然逃不脱现实的尴尬，短视频行业的变现依然面临诸多挑战。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	从繁荣期到精耕期，短视频行业正在经历阵痛\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	作为一种在移动互联网时代的后半段崛起的内容表现形式，短视频行业的发展无疑备受追捧。无论是资本还是巨头，对于这种新式的内容展现形式都充满了好奇与期待。融资数额的不断增加、融资速度的不断加快都在说明市场对于短视频行业偏好程度。尽管短视频行业从一开始就被互联网巨头所青睐，但是，它的发展依然要经历所有的事物都会经历的阶段。从资本吹捧的繁荣期到商业变现的精耕期，短视频行业的发展无疑正在经历一次全新的阵痛。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	火爆的背后是短视频行业远离商业本质的尴尬。几乎所有的人都知道，短视频行业的发展一直都是一路高歌，无论是从用户获取上，还是用户日常的表现数据上，短视频行业的发展都是相当夺目耀眼。尽管短视频行业看上去异常火爆，但是火爆的背后却是变现困难的尴尬。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	从始至终短视频行业都在扮演着一种流量导流的角色，通过短视频将流量聚集在一起，再通过流量下沉到电商、社群等其他领域，从而实现真正意义上的变现。其实，从流量获取到流量导入已经有了许多的用户流失，再把这些流量落地到具体产品上又会有更多的流量流失。因此，仅仅只是将短视频看成是一个流量导入的工具，而不去从短视频本身着手，直接进行变现正在让短视频行业的发展陷入一种尴尬的境地里。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	当我们看到短视频平台动辄几亿的用户流量的时候，其实无法真正掩盖现实的尴尬。一味地看中短视频本身的流量价值，而忽略了更多新的探索，短视频行业正在陷入一场远离商业本质的尴尬。在流量红利已经见顶的大背景下，一味地去强调短视频行业的流量作用，无疑是一次与现实的抵抗。在流量已经被证明是一种无效资源的大背景下，短视频行业盲目地加大自身在流量上的作用，无疑是一场冒险。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	依附于巨头的怀抱让短视频缺少对于商业世界的认知。作为一种全新的内容展现形式，短视频行业从一开始就依附于互联网巨头。无论是资本投资，还是平台建设上，短视频始终都缺少自己独特的运行模式。虽然以互联网巨头作为靠山能够缓解在竞争激烈的市场当中沦陷的概率，但是如果仅仅只是一味地停留在巨头怀抱的温暖里，不去面对商业世界的残酷，短视频行业依然备受挑战。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	依附于巨头的怀抱，短视频行业仅仅只是一个内容层面的东西，它仅仅只是巨头的附庸，无法真正承担起自我寻找商业价值的重任。当巨头不再加持短视频行业的时候，它同样需要走入市场里，而不是一味地承担一个支撑者的角色。依附于互联网巨头的怀抱，短视频行业仅仅只是停留在表面繁荣的自嗨当中，不断增长的用后数据、不断增长的点赞数量、不断增加的用户浏览时长都让短视频行业感觉到自己是移动互联网后半段的王者。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	作为一种全新的内容展示形式，短视频始终都是一种内容。如果我们仅仅只是停留在巨头光环下的数据自嗨，而不去真正了解这些数据背后的真正原因。那么，当短视频行业真正进入到市场的时候，一切或许都将重新开始。当前，短视频行业正在经历的正是这样一个阶段。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	以内容为根本的短视频却无法具备内容的本质与意义。虽然短视频行业异常火爆，但是我们始终都不能忘记短视频始终都是一种内容表现形式。既然是一种内容，短视频行业从野蛮生长到精耕细作是一个必然的过程。在经历了几年的发展之后，我们却没有看到短视频行业的内容有显著提升的地方，有的仅仅只是在一些营销层面的小打小闹。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	当短视频在内容进化上出现瓶颈的时候，我们就去做商业变现上的相关尝试无疑将会把这个行业的问题和弊端全部都呈现在外面。作为一种内容展现形式，短视频行业在内容本身上缺少精耕细作和突破创新，只会把短视频行业的发展带入到一种相对艰难的境地里。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	我们看到现在的短视频的内容上依然缺少精细化的痕迹，有的仅仅只是千篇一律的雷同抑或是内容展现形式的俗套。如果仅仅只是把短视频行业仅仅停留在一种毫无进化的层面上，特别了缺少了作为内容本身所应该具备的特质，那么所谓的短视频必然将会失去原有的本质与意义。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	在经历了早期的野蛮生长、资本助推、巨头拥抱等一系列的发展之后，短视频行业的发展正在经历一场前所未有的平静期。这从另外一个角度说明短视频行业的发展并未真正跳出原有的发展套路，仅仅只是将互联网式的发展模式在极致上更进一步。突破短视频行业的发展困境，需要真正让短视频告别自嗨式的繁荣，真正回归内容本身，真正进入到商业世界的现实中历练。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	进入下半场的深水区，短视频的彷徨与退让\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	在告别了资本的加持之后，短视频行业的发展正在进入到下半场的深水区。早期的顺风顺水让短视频行业的发展难以抵挡现实的尴尬，一味地停留在数字上的繁荣，而忽略了内容本身的本质奥义，短视频行业的下半场无疑将会经历一场前所未有的彷徨与退让。但是，这并非是一件坏事，通过这种方式，我们增加能够知道短视频本质的东西是什么。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	短视频的彷徨：巨头扶持还是独立行走。短视频从诞生的那一天开始就始终没有摆脱巨头的光环，从某种意义上来讲是互联网巨头最终造就了短视频行业的今天。然而，一味地躲在互联网巨头建构的舒适区里，不去进行商业层面上的探索，所谓的短视频只会在自嗨的道路上越走越远。告别巨头的保护，真正进入到市场当中摸爬滚打，从而获得更多的生存技能或许对于短视频来讲至关重要。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	然而，如果摆脱互联网巨头的怀抱，短视频又很难在短时间内找到一条合适的路，对于处于变现关键期的短视频行业来讲，无疑是一个非常巨大的挑战。始终蜷曲在巨头的怀抱，毕竟不是一件长远的事情，短视频行业的真正未来依然在于本身的发展上。从这个逻辑来看，脱离巨头的怀抱，选择独立行走显然是一件非常明智的事情。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	可喜的是，深度参与到短视频行业发展中的人们早已明白了这其中的意义，我们看到以抖音、快手为代表的短视频平台开始更多地寻找基于自身优势和特色的发展道路，抖音做社交，快手做电商就是这一趋势的直接体现。尽管当下的发展态势不甚明朗，但是只要能够找到一条真正适合自己的发展道路，短视频行业的发展便会真正能够独立。&nbsp;\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	短视频的退让：坚守流量还是回归商业。从当下的发展情况来看，短视频真正吸引人的地方还是它裹挟流量的能力。投资机构和互联网巨头之所以不断加持短视频行业的重要一点同样是因为短视频本身能够在获取流量的成本日渐高企的时刻依然能够持续获得源源不断的流量。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	然而，虽然流量给短视频赢得了鲜花和掌声，但是流量的变现依然是横在短视频头上的达摩克利斯之剑。谈及流量变现就必然要回归到商业本身，如果仅仅只是在流量的海洋里进行无谓的自嗨，所谓的短视频只能是一个充满了美妙幻想的乌托邦，无法真正实现真正意义上的落地。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	是坚守流量还是回归商业，或许在残酷的商业面前，短视频行业将会最终退让，真正演变成为以商业为主导的存在。尽管这个过程会略显艰难，但是这才算是真正回归到了商业本身，而非仅仅只是沉醉在流量的理想国里。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	当短视频市场的繁华落尽，回归商业本质或许是当下正道。告别表面的虚假逻辑，真正把短视频行业的发展落地到具体的商业上，探索一条真正适合商业本质的发展道路，或许才是真正能够推动短视频行业发展正道所在。从这个逻辑上来看，当下短视频行业正在经历的这场彷徨与退让或许更像是在积蓄继续前行的能量。\r\n</p>',	'doc.png',	1.00,	9,	0,	0,	0,	'2019-12-03 14:21:49',	'admin',	14,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	1.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	3,	1,	0,	1),
(97,	'民调支持率达标 这个华裔参选人获初选辩论资格',	'<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	发展会掩盖一切问题，直到狂奔的脚步停下。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	2月15日，滴滴CEO程维对外表示，公司将做好过冬准备，并将对非主业进行“关停并转”，对业务重组带来的岗位重叠和绩效不达标的员工进行减员，整体裁员比例占到全员的15%，将涉及2000人左右。此外，从2012年创业以来一直处于亏损状态的滴滴，2018年仍然亏损，全年亏损总额高达109亿元，其中，补贴司机超过113亿元。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在收购优步中国以后，滴滴在网约车市场一家独大，市场占有率近九成；滴滴是全球融资额最大的未上市公司，一向“不差钱”；滴滴对每笔业务都会收取20%左右的抽成(Take Rate)，这也经常成为网约车司机抱怨甚至炮轰的对象……感觉“躺着就能把钱赚了”的滴滴，为何会如此巨亏？司机喊着不赚钱、平台又巨亏，网约车的问题究竟出在哪里？还有能走得通的商业模式吗？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	成立7年，融资20次，\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	融资额200亿美元\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	和其他公司多是被爆出后被迫承认窘境，或者裁员时只肯使用“优化、调整、末位淘汰”等字眼不同，滴滴主动“官宣”了巨亏和裁员的消息，数字还如此巨大。“地主家也没有余粮了？”“富家子都开始哭穷了？”社交媒体上一时哗然，有人唏嘘，有人不解。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在去年8月滴滴顺风车事件之后，程维也曾对外透露过一次滴滴的财务数据，他表示滴滴成立6年来，还没有实现过盈利，仅仅2018年上半年，公司的整体净亏损就超过40亿元人民币。滴滴出行业务对应的GMV(总交易额)平均Take Rate(抽成率)约为16%，但绝大部分作为补贴和红包返还给了司机和乘客，公司整体对应的GMV毛利率只有1.6%。他还透露，仅2018年上半年，包括司机高峰期补贴、接单和服务奖励、乘客优惠等在内的总补贴返还金额超过117亿元人民币。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	2017年，滴滴也曾透露过补贴总额，高达181亿元(包括司机端和乘客端)。但一些被媒体广泛引用、滴滴官方从未确认也从未辟谣的数据显示，2017年滴滴全年亏损额只有25亿元。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	一位滴滴内部人士告诉《中国经济周刊》记者：“公司虽然巨亏，但现在现金流应该是没问题的。即使一部分员工会面临被裁员，但公司给的补偿方案还是比较厚道的。说滴滴会成为下一个ofo那是不太可能的。”\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	据天眼查的统计数据显示，滴滴自2012年成立以来，截至目前已经完成了20次融资，金额总量超过200亿美元，是全球融资额最大的未上市公司。滴滴的估值也一度高达800亿美金，也是最快达到这个量级的独角兽公司。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	但这只独角兽也甚是烧钱。由于滴滴还不是上市公司，财务数据并不需要全部公开，但根据滴滴已公开的数据统计，滴滴6年来累计亏损额高达近390亿元。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	但上述人士也表示：“在2018年以前，利润和成本在滴滴确实不是重要的考核指标，市场占有率、日单量、用户数量、司机数量……这些才是关注的重点。但2018年开始，公司希望能够在年底冲刺整体盈利，至少实现‘微盈利’，所以对各个业务线也都提出了这样的要求。”\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	其实，这种变化也并不奇怪，因为彼时市场传闻，滴滴将会在2019年下半年实现IPO。但之后由于众所周知的原因，滴滴没能赶上这波上市热潮。“顺风车事件”背后的安全问题让滴滴停下了6年来一路狂奔的脚步。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	一年补贴113亿元，\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	司机感受到了吗？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	补贴仿佛是成就滴滴、也榨干滴滴的一道旋转门，补贴的打法让滴滴熬死了几乎所有竞争对手，并从尸骨堆中走出来，成为今天的滴滴；但现在，补贴似乎也正在熬干滴滴自己。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	与109亿元这个2018年滴滴全年亏损总额一同出现的还有一个数据：2018年滴滴补贴司机超过113亿元，这很容易让人认为两个数字之间有因果关系。但巨额亏损就是源于对司机的补贴吗？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	北京大学市场与网络经济研究中心研究员陈永伟对《中国经济周刊》分析认为，滴滴的亏损应该主要来自为了赢得用户信任和适应更强监管而付出的合规成本。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	陈永伟认为，滴滴的持续亏损主要有两方面的原因。“一是由滴滴本身的战略决定的，它的战略是先占有市场，然后利用规模效应去消化市场。滴滴的主业务是规模报酬递增的，这也决定了滴滴先占市场的模式。二是去年突发事件引发了监管加强，这让滴滴遭受了空前的监管压力，合规成本是巨大的，比如要求司机户口、车辆的轴距大小等。”他说。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	记者采访了几位滴滴司机，他们均表示，并没有觉得去年滴滴对司机的补贴突然增加了。一位滴滴“老司机”告诉记者，不同的司机能够拿到的补贴数量可能差别非常大。因为要想获得比较高的补贴收入并不容易，比如要在线时间长，至少10小时，这意味一定要是全职司机，身体要好还不能怕辛苦；再比如要在高峰时段多接单，也要多接受滴滴的派单，“这些活儿很多是根本不赚钱的，不给补贴，根本不会有人接。”他说。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在乘客端，很多人的感受则是：滴滴的车费越来越贵，但叫车却越来越难。记者对比了市场上最大的几家网约车公司的价格，以北京为例，相同时段和目的地，同档次车型，滴滴快车价格最低，其次是出租车价格，但两者差距已经不大了，相对最高的是易到易达车型的价格。而对于高端车型，滴滴礼橙专车也是最低的，其次是神州专车，首汽约车的价格则更高一些。这些高端车型的价格要高出普通车型50%左右。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在客户竞争层面，网约车平台的竞争无外乎两件事：价格和能否叫到车。而网约车平台要克服的最大难题就是高峰低谷时段的需求差异和城市潮汐效应的供给矛盾。因此，从逻辑上，网约车平台确实需要依赖补贴来调节运力，鼓励高峰时段有更多兼职司机补充运力，鼓励司机反潮汐增加热门地区的运力供给。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	根据中国信息通信研究院政策与经济研究所的调查显示，截至2018年7月，全国合规网约车数量约为17万辆，只占到总量的0.54%，而合规司机数量约为34万，只能占到司机总量的1.1%。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	据滴滴方面介绍，随着各地网约车新政的落地和执行越来越严格，运力不足问题日趋严重。而顺风车下线之后，兼职的网约车司机也大量减少。因此，滴滴为了吸引更多“合规”司机加入，以及运营中调整运力，不断出手补贴。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	滴滴收购ofo的可能性更小了\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	除了裁员，滴滴宣布要“关停并转”非主业的消息也引发了广泛的关注。到底哪些业务是滴滴的“非主业”，截至记者发稿，滴滴官方并未给出回应。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	一位滴滴前高管对《中国经济周刊》分析，对于滴滴“非主业”，很多人会首先想到外卖、酒旅、票务等“创新业务”，这确实可能是此次调整的重点，但应该还至于此，因为这些业务不足以涉及到2000人。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	据记者了解，2018年底，滴滴进行过一次架构调整。调整后，滴滴的主要业务被划为几大板块：网约车平台公司(快车、专车、豪华车事业部)、车主服务公司(小桔车服公司、汽车资产管理中心)、普惠出行与服务事业群(单车、电单车、公交、代驾、企业级业务)、出租车事业部、战略业务事业部(战略部、国际事业部、金融事业部)等。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	上述高管认为，普惠出行与服务事业群的业务也有可能被重点调整，“滴滴再去收购ofo的可能性更小了”。而国际业务和金融业务则会影响不大。“网约车这个生意受政策环境影响太大了，国际化等于给滴滴多设立几个backup，这边不亮可以那边亮，滴滴已经有完整完善的网约车技术和运营解决方案，在各国复制并不难。”他说。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	实际上，滴滴已经通过收购、投资本地出行平台的方式将业务拓展到东南亚、东欧、非洲、巴西、日本、美国、墨西哥、澳大利亚……程维也透露，安全技术、产品和线下司机管理及国际化等是滴滴未来的重点领域。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	陈永伟的看法是，滴滴确实涉足了不少并没有规模效应的行业，如果没有顺风车危机，可能也不会对滴滴带来太大的影响。但在严监管之下，安全合规成本大增，滴滴的顺风车业务还干脆就没了，这也带来商业损失。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	网约车也有赢利的商业模式\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	滴滴这头其实已经达到巨头规模的超级独角兽，至今仍未找到清晰的盈利模式。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	滴滴的设想是希望通过平台聚集大量用户，然后靠打造“出行生态”提供增值服务获得盈利。就像淘宝和微信，用户都可以免费使用，但同样可以赚得盆满钵满。于是，滴滴进行了很多尝试：做广告、做电商、做游戏、卖保险、卖理财、做金融……但这条路，至少现在，滴滴还并没有走通。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	但这并没有影响新选手们的热情。除了神州优车、易到、首汽约车等老运动员，2018年以来，美团、高德、携程、同程、嘀嗒、哈罗等都开始前赴后继地加入网约车混战，希望从滴滴的版图上咬下一块。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	此外，上汽、吉利、大众等在内的主机厂都已经进军网约车市场，宝马也成为首家在中国拿到网约车牌照的跨国品牌，赛道那端虽然通向哪里还不知道，但赛道仍然拥挤。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	虽然滴滴的日子不好过，易到更是彻底凉了，但行业内也有日子过得不错的玩家。比如神州优车，虽然此前也一直亏损，但到2017年，神州优车的亏损已大幅收窄了92.7%，仅亏损2.6亿元。而其2018年经营，截止到当年前三季度，神州优车营收达49.2亿元，利润总额2.8亿元，较上年同期增长149%，已经实现了4个季度的持续盈利。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“这其实也说明了网约车本身没问题，是有商业模式可以走得通的。不过行业发展还是需要政策支持。”陈永伟表示\r\n</p>',	'doc.png',	1.00,	38,	0,	0,	0,	'2019-12-03 14:22:37',	'admin',	26,	1,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	1.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	14,	1,	0,	1),
(98,	'北大教授林坚:大数据可对国土空间规划实施监管',	'<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	2015年，随着抢眼的小黄车突现北大校园，共享单车的概念迅速被普及，玩家接连冒头，巨额投资不断涌入，和高铁、移动支付、网购齐名<strong>“新四大发明”</strong>。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	热潮来得快，去得更快。今年，共享单车就进入了寒冬。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	4月，<strong>摩拜单车委身美团；小黄车ofo也节节败退，危机重重</strong>：海外业务全面收缩，并推出了多种激进的变现手段：公众号推送广告，将用户的押金与理财产品绑定，一再延迟押金退还期限。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	去年还大把烧钱的共享单车，转眼就凉凉了。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	共享单车出海遇阻，基础建设和政策规范是难以忽略的两大阻力。除了中国，世界上很难找到一个足够大的市场来支撑共享单车的盈利模式。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	但印度的创业者似乎有不同想法。<strong>从2017年开始，有近十年共享单车公司陆续出现，并先后拿到融资。</strong> \r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	班加罗尔的Yulu向Blume Ventures等投资者筹得资金，还获得Flipkart联合创始人Binny Bansal和谷歌前副总裁Amit Singhal的支持；另一家公司Bounce从红杉印度等投资者那里拿到了了总计1520万美元的资金；总部位于古尔冈的Mobycy去年12月也筹集了50万美元的种子资金。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\"> <strong>印度的共享单车市场正生机勃勃。</strong> \r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\"> <strong>融资热潮</strong> \r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	Amit Gupta是印度第一家独角兽Inmobi的联合创始人。在他创业十年、担任总裁级别职务的时候，他选择了急流勇退，<strong>创办了另一家公司，Yulu单车</strong>。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在班加罗尔地铁站和商务CBD附近，亮蓝色的Yulu单车随处可见。Amit告诉\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	志象网\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	，做共享单车，是为了<strong>“间接降低污染”</strong>。他出生和长大在印度北部的小城坎普尔，在今年6月被世界卫生组织盖章“全球污染最严重城市”，谈起家乡，他显得情绪激动。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	Yulu单车在前半个小时仅收费10卢比<strong>（约一元）</strong>，之后每半小时多收5卢比。用户下载Yulu应用扫码开车，结束骑行之后，需要将车子停放在离目的地最近的停车区。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	业内人士估计，印度的共享单车市场目前规模达12亿美元。<strong>主要的玩家除了Yulu，还有共享汽车公司Zoomca旗下的Pedl，Mobycy，Bounce和以及来自中国的摩拜单车。</strong> \r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“这个行业很有前景并且有利可图，Ola和Uber的成功证明了交通出行跟手机有可能同步发展。”Blume Ventures的投资人Sajith Pai对志象网说。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	最近入局的玩家是<strong>从踏板车共享起家的Bounce</strong>。今年6月，ofo退出印度市场，Bounce最近宣布收购了它在印度的资产。在收购之前，Bounce在就班加罗尔投放了500辆踏板车。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“从公交站或地铁站到办公室和家里的最后一英里的交通非常令人头疼，没有任何三轮车或出租车愿意走这么短的距离。”Bounce联合创始人Vivekananda HR告诉志象网。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“我们从ofo手中收购的自行车也将加入试点。”他说，45到60天内Bounce的应用将支持扫码使用单车。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	印度创业者从中国公司继承的，不仅是败局留下的遗产，还有先见之明的运营管理教训。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在浦那和班加罗尔，小蓝车Yulu和小绿车Pedl随处可见。一开始，用户可以把车停在任何地方，甚至是在路中间，引起了交通失序。Yulu不得已派出团队去搬运自行车并停放在适当的地方。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	这样一来，成本太高难以为继，Yulu吸取了教训，开始联合Pedl与当地政府合作，规划指定的停车区域。在班加罗尔，这样的停车区现在有500个，在全部的4个城市总数超过1000个。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\"> <strong>纠结的用户体验</strong> \r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	但也有的问题无法靠“继承”来解决，<strong>比如技术和运营失误</strong>。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在印度，<strong>共享单车的用户体验仍有待改善</strong>。志象网记者的亲身体验以及和其他用户交流后发现，包括刹车失灵、智能锁失灵、轮胎漏气等现象并不少见，而且停车区的分布也不够密集，有时候用户甚至需要在锁车之后再走一公里到目的地。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	Vivek Kumar是一名22岁的软件工程师，他最近刚从德里搬到了班加罗尔。刚到班加罗尔时，他一直骑着共享单车穿梭在城市中参加面试。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	一次去面试的路上，他发现单车的链条断了，这就十分尴尬了：他必须得先把车子停到指定的停车区域，否则软件会一直计费。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“我不得不把车子推到500米外的Pedl停车站，在锁这个坏车的时候又花了好多时间。”Kumar告诉志象网。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	但事实上，Yulu和Pedl也都有专人在维护单车，每隔四天维护一次，从而保持单车的良好运行状态。但Amit说，当公司进入一个区域时，维护的情况会不太稳定，“因为当地业务还没有完全稳定。”\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“在那些旧的区域，你会发现我们的自行车状况良好，大多数都能够很好运行。最近我们在电子城附近布局，那里聚集了一批大型IT公司，比如Infosys、Wipro等。我们需要四到六周的时间来完成布局。”Amit说。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	但相较中国，<strong>印度的交通基础设施普遍落后，这也给共享单车埋了一颗暗雷</strong>。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在印度，没有几个城市设置了自行车道；不像中国，骑行已经发展为一种健康、前卫的生活方式，印度的自行车还往往被视为穷人的通勤方式。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“我们之所以进入共享单车行业，是因为我们想成为一家多渠道出行平台。城市交通一直是政府和公民共同面临的挑战，我们希望能够大规模地解决这一问题并帮助完善基础设施建设。”Pedl运营增长部门负责人Rakshak N说。\r\n	</p>',	'doc.png',	0.00,	15,	0,	0,	1,	'2019-11-26 09:37:47',	'admin',	119,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	0.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	10,	1,	0,	1),
(99,	'29省份2016年平均工资出炉 北京居首河南垫底',	'<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	互联网瞬息即变，互联网上的热点也是转变地相当的快，一个热点可能过了几天就不再有人关注了。这对于想凭借互联网走红的人或物来说，显然要付出更多的心血来维持热度。那么，各个引流渠道显然都在他们的考虑范围之内。对于商家而言，在互联网进行引流的最终目的不外乎都是卖货变现。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	因此，一些比较重要的引流渠道，都少不了商家们的身影；比如，。抖音作为2019年的平台，有着3.2亿日活跃用户，属于是自带。如今，抖音与微信、微博等巨大流量池并称，绝对是商家不容错过的流量池。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	商家在抖音平台上发布内容之后，就能通过发布内容来吸引用户前来关注，并进一步转化为粉丝，这样就能更方便商家引流变现。在抖音只能是通过发布优质内容来吸引用户关注，因为抖音采用的是智能社交推荐机制，只要发布的视频内容有趣，也可以获得大量的曝光。这就决定了粗制滥造的视频所获得的曝光量很少。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;text-align:center;\"=\"\"> <img src=\"http://demoall.adashuo.com/20090/uploads/allimg/c191107/15I0c2FD630-1E14.jpg\" width=\"450\" height=\"270\" border=\"0\" alt=\"抖音多闪培训：如何通过抖音进行带货-第1张图片-小七抖音培训\" title=\"抖音多闪培训：如何通过抖音进行带货-第1张图片-小七抖音培训\" style=\"height:270px;width:450px;\" /> \r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	因此，想要在抖音平台上获得大量的曝光，最简单的办法就是制作高质量的视频内容。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	拥有曝光，并不代表着是结束。恰恰相反，这只是开始，因为接下来的工作就是要引流变现了。目前，通过抖音引流的方式无非就只有这么几种：一是在视频内提及联系方式；二是在评论中回复；三是在私信回复等。但是，这几种引流方式都存在着被抖音删除、乃至封禁的风险。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	抖音多闪培训那么，到底有没有什么引流方式是没有风险的呢？或者换言之，有什么引流方式是抖音官方认可的呢？当然有!那就是抖音的电话拨打组件。这是抖音官方所推出的转化组件，经过设置就可以在抖音主页上展示，只要用户点击\"联系方式\"这个按钮就可以跳转至电话拨号界面，并显示相关号码，这无疑对商家引流变现提供了很大的便利。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	但比较遗憾的是，目前，这个功能并没有对所有的用户开放，只有认证了抖音企业蓝v号的用户才可以设置该功能。所以，商家如果是想开通\"电话拨打组件\"的功能，需要先开通抖音蓝v。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	抖音蓝v认证的申请流程如下：\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	第一，用需要认证蓝v的抖音账号登录抖音蓝v认证官网https://renzheng.douyin.com/。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	第二，填写企业认证公函，具体情况可以参考抖音官方的企业认证公函填写模板。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;text-align:center;\"=\"\"> <img src=\"http://demoall.adashuo.com/20090/uploads/allimg/c191107/15I0c2G0040-2J03.jpg\" width=\"450\" height=\"447\" border=\"0\" alt=\"抖音多闪培训：如何通过抖音进行带货-第2张图片-小七抖音培训\" title=\"抖音多闪培训：如何通过抖音进行带货-第2张图片-小七抖音培训\" style=\"height:447px;width:450px;\" /> \r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	第三，填写并提交认证资料，然后填写邀请码123456\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	第四，支付认证审核费用600元即可完成蓝v认证申请的提交。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	需要注意的是，抖音蓝v认证有部分禁入行业及需要额外提供认证资质证明的行业。禁入行业认证抖音蓝v将做认证失败处理。而需要额外提供认证资质证明的，如果碰巧没有，那么在提交认证申请后的30天内仍没有补充提交资质证明，也会当认证失败处理。而认证抖音蓝v失败，是不会进行退款的。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	认证抖音蓝v之后，除了可以获得电话拨打组件，还可以获得同步认证今日头条和、官网链接、商家页面、店铺POI地址、粉丝画像等蓝v权益。可以为天猫、淘宝、京东店铺以及线下店铺引流，构建企业商家的营销阵地，完成变现的目的。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;text-align:center;\"=\"\"> <img src=\"http://demoall.adashuo.com/20090/uploads/allimg/c191107/15I0c2G35440-31260.jpg\" width=\"450\" height=\"261\" border=\"0\" alt=\"抖音多闪培训：如何通过抖音进行带货-第3张图片-小七抖音培训\" title=\"抖音多闪培训：如何通过抖音进行带货-第3张图片-小七抖音培训\" style=\"height:261px;width:450px;\" /> \r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	抖音多闪培训因此，有意认证抖音蓝v的商家，最好是通过抖音蓝v认证代理商进行认证。\r\n</p>',	'doc.png',	0.00,	31,	0,	0,	0,	'2019-12-03 14:04:12',	'admin',	5,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	0.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	12,	1,	0,	1),
(100,	'印度海军拟加强在印度洋长期部署 抗衡中国影响力',	'<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	众所周知，2017年至2018年，的大和商业价值日益凸显，各大机构纷纷注资抢占短视频市场，作为短视频流量增速最快的APP，其运营模式和商业市场更是备受关注。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	大数据，帮你快速打造抖音爆款\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	抖音作为新媒体的新洼地，虽然流量又达到一个新的峰值，但是入场抖音仍然是可以。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	而想在抖音机制中脱颖而出，关注的焦点更倾向于生产抖音内容的速度和质量，以及如何持续生产高质量的抖音内容。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	对于运营抖音而言，此时入场抖音阵地，更需要把控时间成本和运营方法。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	结合抖音大数据工具——西瓜短视频助手，在内容层面，可以在6小时内寻找到抖音视频爆款素材，结合热门迅速掌握抖音平台爆款元素，从而有效提升抖音成本。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	在领域定位上，可以根据榜单快速规划的运营方向，结合行业粉丝画像信息，进一步完善垂直领域差异化内容布局。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	抖音进阶创作技巧，及商业运作模式\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;text-align:center;\"=\"\"> <img src=\"http://demoall.adashuo.com/20090/uploads/allimg/c191107/15I0c2AcO0-53929.jpg\" width=\"450\" height=\"303\" border=\"0\" alt=\"抖音小店：抖音运营怎么进行流量变现-第1张图片-小七抖音培训\" title=\"抖音小店：抖音运营怎么进行流量变现-第1张图片-小七抖音培训\" style=\"height:303px;width:450px;\" /> \r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	根据对MCN机构平台发展中遇到各种情况，给现场的运营者和MCN机构提出以下3个方面建议：\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	1.稳扎稳打才是抖音号的运营之道\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	面对网络上出现的买粉刷量的现象，建议运营者和机构千万不要尝试。这样的行为，不仅影响抖音号的权重，也让后续陷入无效价值中。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	2.快速孵化KOL矩阵离不开内容运营\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	抖音小店面对快速内容运营的有效方法，也给出一些信息流量的操作模式，在信息的展示上，可以扩大挖掘地域，可以引入外国小众优质的平台信息资源，将优质内容分类整理成“剧本”分发旗下艺人进行高效运作，提升视频输出效率。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	3.强强合作是商业运作成型的有效方法\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	相比知识付费，广告和电商是抖音目前最有效的转化之一。在广告投放上，同MCN专业机构合作，会更有效的提升个人抖音号的商业价值转化能力。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	如何高格局快速转战短视频领域构建生态链\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	如何一手打造“从内容生产-IP孵化-推广产业化”短视频生态蓝图？\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;text-align:center;\"=\"\"> <img src=\"http://demoall.adashuo.com/20090/uploads/allimg/c191107/15I0c2B323F-B363.jpg\" width=\"450\" height=\"307\" border=\"0\" alt=\"抖音小店：抖音运营怎么进行流量变现-第2张图片-小七抖音培训\" title=\"抖音小店：抖音运营怎么进行流量变现-第2张图片-小七抖音培训\" style=\"height:307px;width:450px;\" /> \r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	a.建立完善的孵化流程。在常规签约流程上，增加达人定位分析和视频测试环节（颜值/技能/学习），保障达人较高的素质水平。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	b.专注用户市场资源。在媒体领域商业形式取决于上游形态，运营的方向取决于市场用户的需求，只有想明白定位，才能做清楚你的市场。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	c.专业商业变现评估。需要对行业的天花板有一定认知，对不具有的抖音大号，可以根据粉丝画像的年龄层，选择不同的市场的推广模式。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	最后，规范机构的商业合作模式，才能快速有效构建自己的商业帝国。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	网红大咖粉丝运营之道\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	抖音IP的成长过程3个关键点：\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	1、找准平台：分析各个平台的商业价值和受众群体，有效预估平台的价值的上升空间。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;text-align:center;\"=\"\"> <img src=\"http://demoall.adashuo.com/20090/uploads/allimg/c191107/15I0c2BC510-L234.jpg\" width=\"450\" height=\"303\" border=\"0\" alt=\"抖音小店：抖音运营怎么进行流量变现-第3张图片-小七抖音培训\" title=\"抖音小店：抖音运营怎么进行流量变现-第3张图片-小七抖音培训\" style=\"height:303px;width:450px;\" /> \r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	2.优质内容：视频种类，视频的风格，人设的塑造，再到更高层次基调定位，都是优质内容的保障。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	3.抓准用户心理：内容的输出上需要抓取社会的认同感，有共鸣的内容通常都可以引发用户的依赖性，可以在内容上找到归属感。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	抖音小店其次，需要制造亲切感，打造个舒服是场景内容更容易获取用户关注。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	最后，就是从心理学的角度出发，恰到好处运粉丝的独纵心理和占便宜的心态。\r\n	</p>',	'doc.png',	1.00,	5,	0,	0,	0,	'2019-12-03 14:07:30',	'admin',	4,	5,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	1.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	4,	1,	0,	1),
(101,	'贝尼特斯：利物浦必夺英超冠军 没人能与他们抗衡',	'<p style=\"color:#333333;font-family:&quot;font-size:16px;background-color:#FFFFFF;\">\r\n	带火了很多“爆款”产品，这些品牌和产品的销量大增，引得很多企业和品牌方们分外眼红。&nbsp;&nbsp;\r\n</p>\r\n<p style=\"color:#333333;font-family:&quot;font-size:16px;background-color:#FFFFFF;\">\r\n	在这个为王的时代，早已成为了一个所有新媒体人无法避开的平台。&nbsp;&nbsp;\r\n</p>\r\n<p style=\"color:#333333;font-family:&quot;font-size:16px;background-color:#FFFFFF;\">\r\n	抖音火遍大江南北，同时有无限的流量产生。&nbsp;&nbsp;\r\n</p>\r\n<p style=\"color:#333333;font-family:&quot;font-size:16px;background-color:#FFFFFF;\">\r\n	大家撸粉的撸粉，变现的变现。&nbsp;&nbsp;\r\n</p>\r\n<p style=\"color:#333333;font-family:&quot;font-size:16px;background-color:#FFFFFF;\">\r\n	但是现在越来越难了，&nbsp;&nbsp;\r\n</p>\r\n<p style=\"color:#333333;font-family:&quot;font-size:16px;background-color:#FFFFFF;text-align:center;\">\r\n	<img src=\"http://demoall.adashuo.com/20090/uploads/allimg/c191107/15I0c26340L0-1F53.jpg\" width=\"450\" height=\"198\" border=\"0\" alt=\"抖音运营团队：抖音运营思维攻略-第1张图片-小七抖音培训\" title=\"抖音运营团队：抖音运营思维攻略-第1张图片-小七抖音培训\" style=\"height:198px;width:450px;\" />\r\n</p>\r\n<p style=\"color:#333333;font-family:&quot;font-size:16px;background-color:#FFFFFF;\">\r\n	为什么？&nbsp;&nbsp;\r\n</p>\r\n<p style=\"color:#333333;font-family:&quot;font-size:16px;background-color:#FFFFFF;\">\r\n	竞争大呗！&nbsp;&nbsp;\r\n</p>\r\n<p style=\"color:#333333;font-family:&quot;font-size:16px;background-color:#FFFFFF;\">\r\n	团队拿到更好的权重才能有更多的曝光，才有上的机会。&nbsp;&nbsp;\r\n</p>\r\n<p style=\"color:#333333;font-family:&quot;font-size:16px;background-color:#FFFFFF;\">\r\n	怎么拿到更多的曝光权重呢？&nbsp;&nbsp;\r\n</p>\r\n<p style=\"color:#333333;font-family:&quot;font-size:16px;background-color:#FFFFFF;\">\r\n	俗话说：知己知彼，百战不殆！&nbsp;&nbsp;\r\n</p>\r\n<p style=\"color:#333333;font-family:&quot;font-size:16px;background-color:#FFFFFF;\">\r\n	那我就先来了解一下抖音的排名算法是什么？&nbsp;&nbsp;\r\n</p>\r\n<p style=\"color:#333333;font-family:&quot;font-size:16px;background-color:#FFFFFF;\">\r\n	首先你要输出优质的内容，&nbsp;&nbsp;\r\n</p>\r\n<p style=\"color:#333333;font-family:&quot;font-size:16px;background-color:#FFFFFF;text-align:center;\">\r\n	<img src=\"http://demoall.adashuo.com/20090/uploads/allimg/c191107/15I0c263G60-26058.jpg\" width=\"450\" height=\"195\" border=\"0\" alt=\"抖音运营团队：抖音运营思维攻略-第2张图片-小七抖音培训\" title=\"抖音运营团队：抖音运营思维攻略-第2张图片-小七抖音培训\" style=\"height:195px;width:450px;\" />\r\n</p>\r\n<p style=\"color:#333333;font-family:&quot;font-size:16px;background-color:#FFFFFF;\">\r\n	关于内容今天就不讲了，本期讲的是抖音运营思维攻略。&nbsp;&nbsp;\r\n</p>\r\n<p style=\"color:#333333;font-family:&quot;font-size:16px;background-color:#FFFFFF;\">\r\n	一、熟悉抖音&nbsp;&nbsp;\r\n</p>\r\n<p style=\"color:#333333;font-family:&quot;font-size:16px;background-color:#FFFFFF;\">\r\n	抖音运营团队熟悉抖音账号注册、认证、定位、布局、防封号/、最受欢迎内容等。&nbsp;&nbsp;\r\n</p>\r\n<p style=\"color:#333333;font-family:&quot;font-size:16px;background-color:#FFFFFF;text-align:center;\">\r\n	<img src=\"http://demoall.adashuo.com/20090/uploads/allimg/c191107/15I0c26406150-31H2.jpg\" width=\"450\" height=\"266\" border=\"0\" alt=\"抖音运营团队：抖音运营思维攻略-第3张图片-小七抖音培训\" title=\"抖音运营团队：抖音运营思维攻略-第3张图片-小七抖音培训\" style=\"height:266px;width:450px;\" />\r\n</p>\r\n<p style=\"color:#333333;font-family:&quot;font-size:16px;background-color:#FFFFFF;\">\r\n	二、选题&nbsp;&nbsp;\r\n</p>\r\n<p style=\"color:#333333;font-family:&quot;font-size:16px;background-color:#FFFFFF;\">\r\n	1.选题的原则：关联性、热门性、新鲜感、人设感&nbsp;&nbsp;\r\n</p>\r\n<p style=\"color:#333333;font-family:&quot;font-size:16px;background-color:#FFFFFF;\">\r\n	2.选题来源：可从时事、同行火爆视频分析、段子、微博等渠道入手&nbsp;&nbsp;\r\n</p>\r\n<p style=\"color:#333333;font-family:&quot;font-size:16px;background-color:#FFFFFF;\">\r\n	3.拍摄及剧本套路&nbsp;&nbsp;\r\n</p>',	'doc.png',	1.00,	5,	0,	0,	0,	'2019-12-03 14:08:06',	'admin',	10,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	1.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	4,	1,	0,	1),
(102,	'下岗女工学籍疑被冒用多年：对方系教师 警方介入',	'<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	怎么在做？ &nbsp;借助商品橱窗和购物车，电商新物种——抖商蓬勃发展，但作为以算法推荐分发的平台，抖音缺少社交基因，那么抖音就注定与社交电商无缘吗？\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	社交对电商有何价值？\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	社交电商是相对于传统电商的概念——社交本身自带去中心化属性，由此延伸出来两个特征：裂变与私域流量。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	裂变来源于社交背后的人脉关系，不仅转化率远高于传统电商，更是能基于信任进行快速传播，也就是裂变获客；\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	而私域流量于商家不仅意味着跳出平台限制自主营销获客，私域流量还具有免费、优质、高黏性、可重复转化的属性。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;text-align:center;\"=\"\"> <img src=\"http://demoall.adashuo.com/20090/uploads/allimg/c191107/15I0c25W3510-551O.png\" width=\"450\" height=\"328\" border=\"0\" alt=\"抖商研习社：如何在抖音做社交电商？-第1张图片-小七抖音培训\" title=\"抖商研习社：如何在抖音做社交电商？-第1张图片-小七抖音培训\" style=\"height:328px;width:450px;\" /> \r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	抖音也能做社交电商吗？\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	1、社交土壤\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	抖商研习社需要指出的是，抖音虽然并非社交产品，但有人的地方就有社交——抖音好友与好友间、粉丝与红人间都有着浓厚的社交氛围，只不过抖音是以陌生人关系链组成的社交平台。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	同时抖音庞大且优质的用户群——以18-28年龄为主，多分布于一二线城市，且女性占比超过60%——配合内容的高传达效率，使得社交裂变有了肥沃的用户土壤。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	2、裂变载体\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	裂变的前提是有足够的用户基础——背靠抖音数亿活跃用户池，好的视频依托推荐算法，及话题、热榜、群聊等流量分发入口，能迅速成为爆款，进而触达更多潜在用户。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	裂变的关键在二次分享，而商品橱窗与购物车并没有相匹配的能力，这就需要借助抖音小程序了：除了可以驱动用户“”挂载小程序二次传播外，小程序的营销插件也自带裂变能力，进而打通裂变的闭环。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	怎么裂变起来？\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;text-align:center;\"=\"\"> <img src=\"http://demoall.adashuo.com/20090/uploads/allimg/c191107/15I0c2593MP-E412.png\" width=\"450\" height=\"331\" border=\"0\" alt=\"抖商研习社：如何在抖音做社交电商？-第2张图片-小七抖音培训\" title=\"抖商研习社：如何在抖音做社交电商？-第2张图片-小七抖音培训\" style=\"height:331px;width:450px;\" /> \r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	1、爆款视频引流\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	抖音卖货的基本逻辑是爆款短视频引流+小程序交易，而爆款视频主要取决于算法推荐，判定标准主要为完播率、点赞评论分享率等，与其辛苦摸索做视频，更便捷的方式则是通过与红人大V合作，以种草视频的方式引流。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	2、给用户裂变的动机\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	抖商研习社有了流量并形成转化后，还需要二次分享才能形成裂变，这就需要给用户一个分享“动机”，可以是折扣、优惠券、返现、赠礼等等，而小程序的营销插件如拼团、砍价、抽奖、分销等，则可以为商家提供裂变营销工具。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;text-align:center;\"=\"\"> <img src=\"http://demoall.adashuo.com/20090/uploads/allimg/c191107/15I0c25a5020-II2.png\" width=\"450\" height=\"319\" border=\"0\" alt=\"抖商研习社：如何在抖音做社交电商？-第3张图片-小七抖音培训\" title=\"抖商研习社：如何在抖音做社交电商？-第3张图片-小七抖音培训\" style=\"height:319px;width:450px;\" /> \r\n</p>',	'doc.png',	1.00,	31,	0,	0,	0,	'2019-12-03 14:08:36',	'admin',	11,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	1.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	12,	1,	0,	1),
(103,	'浙江设生态文明干部学院:绿水青山就是金山银山',	'<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	10月19日，京东宣布今年11.11大促将首次推出“京东拼购”等玩法。10月19日，美团点评官方微信小程序也正式上线了“好货拼团”板块。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	事实上，此前已经有包括阿里、苏宁、今日头条等多家互联网巨头切入了社交拼团业务。而这一切，在笔者看来，巨头们完全已经将拼购当成了获取用户流量的下一个杀手锏。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;text-align:center;\">\r\n	<img border=\"0\" src=\"http://demoall.adashuo.com/25707/uploads/allimg/c191120/15J2314405K20-1L320.jpg\" style=\"height:auto !important;\" />\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	拼购成“香饽饽”\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	根据艾媒咨询发布的《2018Q1中国社交电商行业市场研究报告》显示，2018年中国社交零售用户规模将突破3亿人，年均复合增长率将达到44.2%。这也意味着，未来社交电商或仍将有巨大的增长空间。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	而作为社交电商的集中展现形式，拼购正凸显着自身鲜活的能量。这其中，最值得注意的就是拼购已经成为巨头最新切入的业务。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	具体来看，巨头们正在尝试性地推出自家相关的拼购业务。如果让消费者直接说出某个巨头旗下的拼购业务，可能会非常轻松。因为这些巨头推出的拼购应用，名字上大同小异——手淘特价版、京东拼购、苏宁拼购、今日头条的“值点”……\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	此外，支付宝联合淘宝上线拼购小程序“每日必抢”，网易则推出了“网易一起拼”。总的来看，它们还都是以“拼”、特价为主要特性，为自己烙印下超值的标签。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	而从数据上看，拼购在近段时间以来也成为电商行业的一个热词。根据速途研究院发布的《2018上半年国内拼购电商市场研究报告》显示，在巨头的入场下，它们不仅让自身拥有了亮眼表现，还让拼购行业获得了整体提升。从微信指数和百度指数看，各个巨头的拼购业务都有着显著提升。这也意味着，以布局消费分级市场为目标的拼购，成为了当下巨头眼中的“香饽饽”。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	巨头在拼购行业的试水，还反应在将自身的资源不断向拼购业务倾斜。比如，很多巨头都举办了优惠活动来吸引消费者，并展现自身拼购业务的特性。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	比如：京东拼购频道此前公布了双11玩法，旨在以流量传播扩散+提升订单为目标，通过打造贯穿双11的拼购寻宝乐园，同时引爆11.8拼购玩法狂欢日，为拼购小程序引流，帮助平台转化新用户并提升订单量。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;text-align:center;\">\r\n	<img border=\"0\" src=\"http://demoall.adashuo.com/25707/uploads/allimg/c191120/15J231440B4F-1U327.jpg\" style=\"height:auto !important;\" />\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	苏宁拼购则将重点在直采直销生鲜商品上发力。在刚刚过去的双十拼购日，苏宁拼购一天卖出了40万个柚子，这坚定了其发展生鲜拼购的战略构想。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	因此，我们可以看到，在巨头的不断试水下，拼购这一社交电商模式已经变得迅速火爆。对于消费者来说，这也是一个消费变得多元化的好兆头。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	品质化渐成主流\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	其实，如果不戴“有色眼镜”去看拼购的话，其身上还是有很多亮点的。拼购以低价引入流量，通过关系网对商品进行分裂曝光，在满足多数人追求“低价”需求的同时，又大幅度增加中小商家和尾货的曝光率和购买率。也正因为如此，拼购在当下俨然成为购物模式中的一股新势力。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	但值得注意的是，在拼多多一家独大的时候，其商品质量、售后等饱受诟病。山寨、造假的问题，也造成了诸多负面影响。而在巨头纷纷入场的情况下，实际上也意味着拼购将进入下半场。在下半场开启的同时，拼购也将迎来全新的发展拐点。拼购在展现品质化的同时，也将成为巨头业务的补充，让它们构建更为完善的商业生态矩阵。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	对消费者利好的消息，在于品质化将成为拼购的常态。同时，品质化也将是巨头拼购业务的竞争发力点。不管是为了稳固消费者群体，还是出于维护自身品牌形象的考虑，巨头都不会再去牺牲商品质量和售后来实现低价。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	它们会尽力展示自身的物流实力、电商交易技术能力、核心交易链路、消费保障制度等，将供应链优势发挥到极致。最终，巨头的拼购业务将让消费者享受到具有更高性价比的品质好货，并由此实现真正的消费升级。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	此外，拼购业务的上线也是对巨头自身实力的加强。以美团拼团为例，其让美团实现了从虚拟商品向实物商品的过度，完成了自身商业边界的扩张。中国社科院财经院互联网经济研究室主任李勇坚表示，“过去用户可能只有在吃饭等时候才想到打开美团，但如果增加了商品类拼团，既有用户可能会在APP上停留更多的时间用于浏览商品”。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	而对于巨头而言，以往虽然在努力强调业务之间的整合，但缺少了某个版块后，业务之间总会有割裂感。拼购业务的出现，或许就能成为“黏合剂”，让巨头的业务实现融合发展。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;text-align:center;\">\r\n	<img border=\"0\" src=\"http://demoall.adashuo.com/25707/uploads/allimg/c191120/15J231440I050-1c916.jpg\" style=\"height:auto !important;\" />\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	值得注意的是，对于巨头来说，它们此前都面临着各自不同的发展瓶颈。而要寻找创新增长点，就必须在流量上痛下苦功。拓展流量的最佳做法，就是通过开辟新业务获取。而拼购身为“引流大户”，自然被巨头所看重。在拼购行业的下半场，它们将争抢中高端消费人群，不断攫取新的流量。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	相信随着巨头纷纷切入拼购领域，后者也在加速下沉。而就发展趋势来看，只拼价格不拼质量的原始拼购模式注定被淘汰。在被巨头开启的下半场，拼购有望与消费升级概念的成熟、人均消费能力的提升高度契合。届时，拼购业务也将成为巨头比拼的另一立脚点。\r\n</p>',	'doc.png',	1.00,	7,	0,	0,	0,	'2019-12-03 14:09:59',	'admin',	0,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	1.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	4,	1,	0,	1),
(104,	'甘肃两部门：布病发病率回升 加大联防联控力度',	'<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	11月5日，一项热搜出现在邦哥的微博首页，并且排名一路蹿升至第一，挂在榜首直至今日凌晨：6000多首歌从KTV下架。被下架歌曲中，《十年》、《泡沫》《死了都要爱》《听海》《K歌之王》等等大热歌曲赫然在列。许多媒体的标题用的是：你拿手的还能点么？\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	而邦哥脑中也冒出了另一个问号：这些歌曲为什么被下架？谁主导了这次下架风波？\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	一个民间组织，为何有权下架全国KTV的6000多首歌？\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	这次下架风波毫无疑问是版权问题引起的：中国音像著作权集体管理协会（下称“音集协”）发出公告，要求KTV终端生产管理商和卡拉OK经营者在今年10月31日前，删除或者不向消费者提供6000多部音乐电视作品。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	乍一看这是一件好事，毕竟版权保护理应得到支持，即便6000多首歌的下架在短期内会给普通消费者带来一些麻烦，但依然有利于产业的良性发展。<strong>然而意外的是，邦哥就此与一位业内音乐创作者进行了解时，对方却对此次发出公告的“音集协”并不买账：这个协会其实不是国家的版权保护机构，之前还被央视曝光过收取高额版权费后，并没有给歌手支付费用，我对于之后钱的去向保留意见。</strong>\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	业内人这样的评论，引起了邦哥的注意，我们随即找到了音集协官方微博，查看其回应此次事件的公告。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	<img alt=\"6609首歌从KTV下架，《十年》《泡沫》均中招，原因不止版权那么简单 \" border=\"0\" class=\"aligncenter\" src=\"http://demoall.adashuo.com/25707/uploads/allimg/c191120/15J231444420Z-10TG.jpg\" title=\"6609首歌从KTV下架，《十年》《泡沫》均中招，原因不止版权那么简单 \" style=\"height:auto !important;\" />众所周知，KTV使用他人音乐作品，需要依法取得授权。但全国KTV可以说是海量的，KTV所需要使用的作品也是海量的。实际经营中，要经营者自己去一对一地取得授权，说句实话，并不现实。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	音集协就是在这样的背景下成立的。我们查看了其官网资料，根据资料显示，该协会是会员制，注册会员后，协会可以帮助你进行统一的版权管理，对全国的KTV进行作品授权，或者进行相应的维权措施。但让邦哥十分惊诧的是，这次被下架的6609首歌，背后的版权所有者，没有一家是音集协的会员。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	换言之，<strong>音集协的权利范围本应是帮自己的会员授权和维权，这次却是向6609首他们本应管不着的歌，发放了“下架通知”</strong>……\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	在音集协官方微博的回应公告中，这一消息得到了证实：\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	<img alt=\"6609首歌从KTV下架，《十年》《泡沫》均中招，原因不止版权那么简单 \" border=\"0\" class=\"aligncenter\" src=\"http://demoall.adashuo.com/25707/uploads/allimg/c191120/15J23144450T0-114138.jpg\" title=\"6609首歌从KTV下架，《十年》《泡沫》均中招，原因不止版权那么简单 \" style=\"height:auto !important;\" />这让邦哥不禁产生了一个疑问：不是音集协的会员，我的歌曲就不能在KTV里播放了么？音集协到底是一个什么样的组织，怎么会有这么大的权利，对非会员的作品也能进行下架处理？\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	就此我们在其官网查找到了音集协的《协会章程》，章程总则中清晰地写明了音集协的性质：本团体是由依法享有音像节目著作权或者与著作权有关的权利人<strong>自愿结成的全国性、非营利性的社会组织</strong>。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	一个自愿结成的会员制民间组织，从法理上讲，应当并不具有行政执法权，按照常理本应无权对“非会员”的作品进行下架处理。而在音集协此次回应的公告中，对这一问题的描述如下：\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;text-align:center;\">\r\n	<img alt=\"6609首歌从KTV下架，《十年》《泡沫》均中招，原因不止版权那么简单 \" border=\"0\" class=\"aligncenter\" src=\"http://demoall.adashuo.com/25707/uploads/allimg/c191120/15J2314445T30-12W41.jpg\" title=\"6609首歌从KTV下架，《十年》《泡沫》均中招，原因不止版权那么简单 \" style=\"height:auto !important;\" />\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	对此，邦哥咨询了法律方面的专家，对方表示：6000多首歌的权利人或其委托的代理公司对KTV经营者提起的单独诉讼，就法律关系上讲与音集协相互独立，并无关系。但公告中并未提到音集协与这6000多首歌的权利人或代理公司是否有委托关系，因此<strong>音集协此次的“下架通知”背后，是否有可能是接受了歌曲权利人本身的授权或委托，我们也不得而知。</strong>\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	曾被众多媒体质疑、央视曝光高额版权费流向哪里？\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	<strong>2006年，国家版权局规定，开始收取卡拉OK每包间一小时12元的歌曲版权费。我们日常去KTV的费用中，就包括了这部分版权费。</strong>那么这部分版权费收取后流向了哪里呢？根据文章开头从业者的说法，邦哥查阅了很多资料，发现这已经不是音集协第一次处于舆论中心。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	2009年，中央电视台连续多个栏目对音集协收取卡拉OK版权费的情况进行了报道；中央二套的《今日观察》栏目还播出了一期新闻专题节目《版权费还是保护费》，邀请两位专家，围绕卡拉OK版权收费及其分配问题。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	根据当时的报道，<strong>音集协自2007年开始收取KTV及卡拉OK版权费，至2009年，收取的版权费已达8000万元，但这笔钱的使用分配却很不透明，相当多歌手表示并未拿到应得的报酬，但作为集体管理组织的音集协却要收取高达50%的天价管理费。</strong>\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	在当时的采访中，音集协不愿详细说明收费方式以及对著作权人的返还方式。不过一位业内人士向央视记者透露，收费是通过一家叫做“天合文化”的公司进行的。根据公开资料，该公司成立于2007年8月，受音集协委托代收卡拉OK版权使用费。音集协负责授权，天合文化负责收费，二者形成一套KTV歌曲版权收费系统。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	而那时的国家版权局版权管理司王自强司长则认为音集协的做法有欠妥当，在接受记者采访时表示，“集体管理组织是一个非营利性机构，不能以组织企业来进行收费，只能建立自身的收费队伍。收费本体是你本身，你不能有一个第三者出来。”\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	那是音集协引起争议声浪最大的一次，此后也曾有过多家媒体跟踪报道过音集协收取版权费的相关内容。早在2008年就有北京中银律师事务所董正伟律师向国家工商总局、国家发改委举报，请求对音集协向KTV行业收取著作权使用费开展反垄断执法。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	而近两年，音集协受到的质疑更加密集了起来，2017年、2018年都有KTV联合状告天合公司（音集协的授权收费单位）进行行业和价格垄断，但最终都以天合的胜诉告终。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	有趣的是，<strong>音集协与天合文化的合作自2007年至2018年，11年间从未停止。但就在邦哥发稿前不久，音集协官网上出现了一份最新公告，终止了与天合文化的委托合作。</strong>\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;text-align:center;\">\r\n	<img alt=\"6609首歌从KTV下架，《十年》《泡沫》均中招，原因不止版权那么简单 \" border=\"0\" class=\"aligncenter\" src=\"http://demoall.adashuo.com/25707/uploads/allimg/c191120/15J231444A250-13U93.jpg\" title=\"6609首歌从KTV下架，《十年》《泡沫》均中招，原因不止版权那么简单 \" style=\"height:auto !important;\" />\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	被下架歌曲并非不能唱了，版权保护，路漫漫其修远兮\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	对于一个行业的健康发展来说，6609首无授权歌曲自KTV下架，理应得到支持。但版权收费的规范性、透明性，同样是应该得到重视领域。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	在此次风波中，被认证为音集协副理事长的周亚平的微博发言，同样引发了相当多网友的不满：\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;text-align:center;\">\r\n	<img alt=\"周亚平表示：希望权利人加入，而不加入的后果是“作品被摒弃在卡拉OK渠道之外”\" border=\"0\" class=\"aligncenter\" src=\"http://demoall.adashuo.com/25707/uploads/allimg/c191120/15J231444I530-14Kc.jpg\" title=\"6609首歌从KTV下架，《十年》《泡沫》均中招，原因不止版权那么简单 \" style=\"height:auto !important;\" />\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	周亚平表示：希望权利人加入，而不加入的后果是“作品被摒弃在卡拉OK渠道之外”\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	在撰文的过程中，邦哥将此次下架的6609首歌曲完整名单下载了下来，发现实际上遭到下架的，只是该首歌曲的某些版本。例如周杰伦遭到下架的《告白气球》等歌，就仅限《中国新歌声》第一季播出版本被下架。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	<img alt=\"6609首歌从KTV下架，《十年》《泡沫》均中招，原因不止版权那么简单 \" border=\"0\" class=\"aligncenter\" src=\"http://demoall.adashuo.com/25707/uploads/allimg/c191120/15J231444PZ-15S59.jpg\" title=\"6609首歌从KTV下架，《十年》《泡沫》均中招，原因不止版权那么简单 \" style=\"height:auto !important;\" />虽然这样的版本限制让很多小伙伴产生了“虚惊一场”的感觉，但邦哥要提醒的是，<strong>版权制度的目的，以及所要保护的对象，是创作者和版权所有者的利益。权利人们的利益，决定了他们的生存环境。</strong>如果从业者无法生存，音乐产业的发展从何谈起？\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	中国音乐版权保护之路，依然路漫漫其修远兮。\r\n</p>',	'doc.png',	1.00,	6,	0,	0,	0,	'2019-12-03 14:10:31',	'admin',	3,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	1.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	4,	1,	0,	1),
(105,	'杭州首宗租赁住房地块昨拍卖 成交价5049元/平米',	'<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	人工智能时代已来，雷军为小米找的下一个风口是什么？成立相机部门能“干翻”华为吗?\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;text-align:center;\"=\"\"><br />\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	▲雷军在在故宫发布滑盖手机MIX3\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	作者 |马婧\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	编辑 |赵泽 杨砺\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在喊出“今年相机部门有没有年终奖，就看能不能干翻华为”之后，小米董事长雷军又发新手机了，这一次是在故宫。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	2018年10月25日，在故宫发布磁动力滑盖手机MIX3乾清宫户外发布会，雷军在现场有点激动，一个人solo了将近一个半小时。雷军在介绍手机后置相机时，突然天空中传来两声乌鸦叫，雷军忍不住笑场，说连鸟都在肯定小米手机，“这是我们第一次办的户外的发布会，还这么有趣啊。”\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	25日早间，小米集团发布公告称，预计到10月底，手机出货量将突破1亿台，提前两个月完成2018年全年目标。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	雷军在发布会上谈到，今年手机大厂商和小厂商之间的差距会拉大，主要原因是各家在相机、AI方面投入成本不同所致。今年5月，雷军在内部信中宣布，在手机部内成立单独的相机部，集中全公司优势资源，提升小米手机的拍照品质。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	雷军曾对相机部门的同事说，今年相机部门有没有年终奖，就看能不能干翻华为。25日下午更新了最新成绩，小米MiX3以103的成绩超过了华为P20。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	小米如何“干翻”华为呢？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	▲MIX3故宫乌鸦捣乱小米发布会现场 雷军笑场：连鸟都肯定了\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	未来高增速或不靠手机靠IoT\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	新京报：小米过去8年保持了高速的增长，未来还能有非常高的增速吗？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	雷军：我们对小米未来的高速增长很有信心。首先手机行业是一个很大的市场，2017年全球共销售手机14.7亿台，小米销售了9000多万台。随着5G时代的到来，手机市场可能再次迎来增长，虽然不会像过去增长那么快了，但这个市场即便不再增长，对于小米来说仍然有巨大的成长空间。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	其次，手机之外，小米在智能硬件和消费升级领域布局广泛，已经进入了100多个品类，建成了全球最大的IoT物联网平台。随着AI时代的来临，AI+IoT将产生巨大的价值，小米已经具备了一些优势。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	另外，小米在海外市场有巨大的机遇。小米手机已经进入了74个国家和地区，还有很多市场有待进入，我们的很多品类也还没有进入全球市场。随着小米一步一步进入新的市场，把新的市场做好，我觉得小米未来还有十倍以上的成长空间。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	新京报：我们注意到小米还在布局智能家居。有观点认为智能家居是个伪命题？你怎么看这个问题？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	雷军：“智能家居”不是一个新词，二十年前在国外就有了，只是一直没有推动。我们觉得背后主要原因是商业通道和技术通道没有打通，比如以前智能家居的成本非常高，家里必须重新装修一遍，这对消费者难以负担，此外，不同厂家的产品之间也很难互联互通。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	小米做了两件事情来解决，首先我们把一个个的产品智能化了，消费者买回家后，突然发现实现了智能家居，这是商业通道理顺了。另外，我们做了互联互通的模组，在技术上也打通了，小米智能家居产品由很多不同的公司生产，但只要用了这个模组就可以互联互通。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	智能家居目前只是刚起步，小米也只是刚跨过门槛，今后智能家居的发展空间可能远超我们想像。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	新京报：有人说，小米生态产品只是在做微创新，你怎么看这个问题？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	雷军：从我们创业的经验来看，成功背后都有不为人知的艰辛，哪怕是一点点成绩，都要付出巨大的努力。所以我觉得我们不要小看微创新，为了提升消费者的体验，哪怕仅仅是1%，我们也投入了100%的精力。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	小米立志要成为一家伟大的互联网公司，让全球每个人都享受科技带来的美好生我没有。我们只有全力以赴做好每一件小事，才是走在正确的道路上。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	下一个互联网浪潮是人工智能\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	新京报：如何看待互联网这20年来在中国的发展，如果用几个关键的时间点来划分，你会怎么划分？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	雷军：我觉得2007年苹果推出iPhone是个很重要的事件，智能手机的出现极大的改变了互联网，我判断手机会逐渐替代个人电脑，移动互联网的时代将会来临。2010年小米成立，2011年推出了第一代小米手机，我们推动了智能手机在中国的快速普及和品质提升，移动支付、电商、社交网络、短视频等行业在中国的蓬勃发展，都有赖于庞大的移动互联网人口，这方面小米做了一点贡献。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	新京报：互联网下一个浪潮会是什么？在这个浪潮下，小米的机会是什么？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	雷军：人工智能的时代已经到来了，人工智能也是小米最重要的战略，我们拥有四项巨大的优势，用户群、海量设备、海量的数据、对整个AI时代的认知，很早就重视了云服务和大数据。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	小米选择的突破口是IoT，也就是万物互联，我认为AI与IoT结合将形成AIoT，也就是万物智慧互联，在这个领域未来有着巨大的发展空间。小米已经建成了全球最大的消费物联网，连接了1.15亿台智能设备（不包含手机、平板和笔记本电脑），小米人工智能助理小爱同学月活跃设备超3000万，月唤醒计数超10亿次，累计唤醒次数超50亿次。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“天使投资人经历让我学会找风口”\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	新京报：从金山时代开始，业界对你的评价就是IT劳模，怎么看待这一评价？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	雷军：如果我们要实现与众不同的梦想，付出的不比别人多，怎么可能成功呢？我现在还是这样认为，创业并不光鲜，成功的企业家也不像大家想的，轻轻松松就成功了，哪怕一点点成绩，背后都要付出极大的努力。在成功的路上，其实只有这一个秘诀认真拼命地工作。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	新京报：天使投资人的身份对于创办小米有哪些帮助？创业者和投资人的思维方式最大的不同之处是什么？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	雷军：因为天使投资人做的就是看大势，找风口。我觉得创业要想五年后是什么样子？十年后是什么样子？什么是正确的事情，什么是正确的时间点？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	我当年是一个手机发烧友，认为手机上网是未来的趋势，未来10年是移动互联网的天下，那我接着就想应该做些什么？所以我用投资人的身份，去看谁在做移动互联网，去搞清楚移动互联网到底是什么，这个过程中我们越来越坚信移动互联网的未来，最终在2010年决定创办小米。\r\n</p>',	'doc.png',	1.00,	6,	0,	0,	0,	'2019-12-03 14:11:24',	'admin',	1,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	1.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	4,	1,	0,	1),
(106,	'2019最美表演:胡歌一人饰三角 易烊千玺:下部戏有压力',	'<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	不在沉默中爆发，就在沉默中灭亡！\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	这句话来形容当下的区块链。2018年疯狂的区块链因受政策监管与打压，资本、媒体、甚至创业者都趋于冷静。或许，这就是黑暗里的爆发前夜吧。但这个前夜还很长很长…\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	最近一篇题为《业内人士：区块链逐步融入农业发展》文章引起我们的关注。该文提到：“截至目前，区块链已被应用于产品溯源、农业保险、农村金融、智能合约等多个场景。尽管目前区块链技术在农业领域的应用范围还较为有限，但是许多业内人士对于区块链在农业领域的未来发展前景仍然满怀期待”从种种迹象来看，业内人士非常看好区块链在农业领域和场景里的应用。另外，还有政府官员也为区块链+农业打CALL。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	内蒙古蒙草生态环境（集团）股份有限公司董事长王召明表示，作为农业大国，要利用物联网、大数据、移动互联网、人工智能、区块链等现代信息技术，大力推动农业全产业链改造升级，为实施乡村振兴战略插上互联网的翅膀。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	可以肯定：区块链没有倒下，区块链在等待机会。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	业内专家指出，2019年有望成为区块链技术真正落地应用，走向产业化的一年。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	区块链诞生之初，外界都追捧：区块链是各个行业的救命稻草。尤其金融行业、食品行业，当然也包括农业领域。我们聊聊区块链解决农业什么问题？我们认为个有以下几个问题！\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	1农业领域看好区块链\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	1农产品可溯源\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	农产品溯源一直是农业的一个痛点问题。而区块链技术利可以对记录实现不可篡改，因此从农产品的生产端到流通端、消费者都有详实的数据，可以实现消费者明明白白消费，提高消费者购买的意愿。农产品溯源可以提升农产品安全性以及食品的安全性。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	2信息透明\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	农业领域除了可溯源之外，生产者与需求方的信息也存在不透明的问题。一旦区块链技术应用与农业。大家就可以通过大数据分析，建立种植户、采购商的信用评级参考；利用智能合约在种植户和采购商之间保证公平交易。同时，区块链技术可以提高农产品买卖双方的契约精神。另外，随着食品供应链中区块链的出现，这可以简化这一过程，因为数据管理系统，将一系列农民、加工商、分销商、监管机构、零售商和消费者纳入其雷达范围的数据管理系统变得更加透明。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	3降低成本\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	区块链技术运用之后，生产、流通等2大环节的成本会大大降低。比如，区块链技术解决信息自动存贮和数据库的功能，如此就减少了人工的投入和其他设施的投入。另外，区块链及应用实现万物互联，帮助生产商和渠道商降低各项开支。同时，生产和流通成本的降低，也会降低农产品的价格，最终还是消费者获利。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	因此，区块链技术在农业领域的应用等到各级人士的认同。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	2现在的区块链农业玩家\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	从以下多个案例来看，这些企业的确把区块链技术应用到用户服务中。他们希望借助区块连技术解决食品安全和可溯源，从而提高消费者对品牌的认可度。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	1沃尔玛\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	沃尔玛公司在2017年内在区块链技术领域作出了大量尝试。沃尔玛一直在与IBM合作，共同开发针对食品安全问题的区块连解决方案。比如，沃尔玛把区块链放在芒果、猪肉等生鲜农产品上。沃尔玛食品安全副总裁Frank Yiannas曾表示：“我们的客户理应拥有更加透明的供应链。我们认为在21世纪，以前那种一步一步去追溯源头的方式已经过时了。这是一项由技术支持的明智举措，它将极大地造福我们的客户，并彻底改变食品体系，使所有的相关者受益。”\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	2 Dreyfus\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	大宗商品交易公司Louis Dreyfus（路易达孚）宣布已试用由ING（荷兰国际集团）等一批金融机构开发的基于区块链的交易系统。Dreyfus使用区块链平台来完成与中国供应商的大宗大豆交易，极大地缩短了交易时间。同时，据参与测试的公司表示，这次测试涉及从美国运到中国的大豆，并在平台内保存所有相关文件（包括销售合同和信用证）。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	3可口可乐\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	2018年，可口可乐正在与美国国务院、区块链信托加速器（BTA）、区块链技术公司Bitfury集团以及崛起币（Emercoin）共同合作，推出一项基于区块链技术的试点项目。同时，可口可乐公司建立区块里的平台，以帮助确保道德的糖生产。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	4家乐福\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	2018年，欧洲最大的零售商家乐福已经开始采用区块链账本技术去追踪鸡肉、鸡蛋和西红柿从农场送到商店的全过程，并将在未来几年在其所有生鲜产品线上部署这种技术。比如，2018年3月，家乐福中国首款区块链产品——琯溪蜜柚，获得用户疯抢。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	5 Smart农场\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	中国农业已经迎来4.0时代，高科技融合成为农业发展的方向。上海华中农投农业科技有限公司旗下Smart农场大力推动区块链的应用。将区块链技术与农业相结合后，能最大限度地消除信息不对称，提高整个产业链的信息透明度和及时反应能力，从而实现整个产业的增值。减少农药投入，提高农产品品质。解决农业的痛点，解决农产品的食品安全、食品供给问题，真的能让中国人都尝到放心的味道。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	3未来走向\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	区块链去中心化等特性，将大幅降低互联网维护成本，提升农业物联网的智能化和规模化水平。同时，基于区块链技术的农产品追溯系统，解决了消费者对于产品的信任危机，让人们的餐桌更健康，更安全。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	另据前瞻产业研究院发布的《中国区块链行业商业模式创新与投资机会深度分析报告》统计数据显示，随着区块链应用场景扩展，预计2019年具有投入产出的区块链企业超过600家，产业规模有望超过8亿人民币。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	有人预测：2019年，“区块链技术”正逐渐从幕后走向台前。我们从2个方面来看：区块链技术迎来利好！\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	1）从大背景来看，国家政策打击比特币，但支持区块链技术在各个行业的应用。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	2）从行业来看，目前大数据和人工智能的发展，区块链技术也将会逐步与其他高科技项目融合赋能产业。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	在农业领域，区块链农业又将会呈现哪些趋势和走向呢？\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	1物联网＋无人机＋区块链\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	中国农业已经迎来4.0时代，高科技融合成为农业发展的方向。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	物联网＋无人机＋区块链的结合将有利于精准农业的发展，减少农药投入，提高农产品品质。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	其中，物流确保万物互联，无人机提供生产管理服务，而区块链提供记录和可溯源等技术。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	2区块链+数据+人工智能\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	区块链应用于农业，能最大限度地消除信息不对称，提高整个产业链的信息透明度和及时反应能力，从而实现整个产业的增值。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	而区块链+数据+人工智能的融合发展，可以推动农业大数据的价值最大化，降低投入成本。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	3区块链+农业金融\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	2月初，中国政府发布了“关于农村金融服务振兴的指导意见”。此次提出的新框架，是国家农村振兴计划中金融服务效率提高计划的一部分。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	同时，该指南据称将有助于促进农村金融部门中如区块链等新技术的应用，以“改善农业信贷风险的识别、监测、预警和处置水平”。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	该公告还预测，新技术将鼓励金融机构“为农村电子商务开发专用贷款产品和小额支付结算功能，并开辟农村电子商务资本链”。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	区块链+农业金融将会为小农户贷款提供便捷途径，为农业金融机构的征信带来真实性和可预测性。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	4区块链+农村物流\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	随着区块链、物联网、大数据等新兴技术与物流行业的深度融合，供应链正成为区块链技术最具潜力的应用场景之一。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	由于农村物流的小散，导致包裹丢失、农产品上行困难等窘况。但区块链技术可以解决这些问题。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	西南交通大学交通运输与物流学院副院长罗霞指出示，农村振兴是今年党中央非常重要的战略部署，与农村物流高质量发展紧密相关。加强云计算、区块链、人工智能等供应链智能化技术在农村物流中的应用，为农产品的生产、检测、周转、销售、品控、管理等提供智力支持。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	5区块链+农业供应链\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	这一类应用就是各大商场嫁接区块链的原因。比如：沃尔玛、家乐福等大型超市把整个生鲜和食品供应链纳入区块链管理，从而降低成本，提高产品的安全性。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	目前，美国农业巨头嘉吉等都在大力发展区块链+农业供应链金融的应用。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	总结一下，2019年区块链在农业领域的应用将会再次迎来爆发。但我们还要明一点：区块链只是一项技术，而不是赚钱的工具。在整个农业发展中，区块链只做赋能者，而不是主导者。如此，路子才会越走越宽！\r\n</p>',	'doc.png',	1.00,	6,	0,	0,	0,	'2019-12-03 14:13:27',	'admin',	14,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	1.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	4,	1,	0,	1),
(107,	'秋冬润肺吃百合 空气污染或增加孕早期流产风险',	'<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	电子商务飞速发展，快速增长的包裹数量与日渐减少的快递员数量已经不成正比。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	快递员的工资回报越来越高，为什么这个职业在近年来从事人员锐减呢？对此，有很多快递员反映，虽然能够得到很高的工资回报，但随着人们对服务水平的要求也越来越高，他们也越来越辛苦。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	同时，快递员的社会地位相对较低，随着人们文化水平及文化素养的逐渐提高，一些有学历有技能的人都已不太愿意做快递员。申通副总在7月25日召开的中国快递“最后一公里”峰会上就表示，现今快递行业的痛点已不仅是解决“最后一公里”的问题，而是怎样才能够招到更多的快递员。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	中国高速发展中，人口红利也在逐渐的减少，越来越多的事情都开始被智能化技术所取代，但快递行业是属于劳动密集型企业，非常依赖快递员。快递行业正处在用人难之际，双十一等各种电商狂欢节的到来无疑是让这些快递企业悲喜交加。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	智能快递柜提升末端物流配送能力，备受物流企业青睐\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	快递员不足是人口红利减少的必然结果，因此急切需要新兴技术缓解快递行业的压力，智能快递柜作为解决方案就这样“问世”了。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	智能快递柜在2012年萌芽，中邮速递易率先推出智能快递柜，在初期遭遇了很多的质疑和非议，但在包裹数量不断增长以及城市年轻劳动力不足的情况下，智能快递柜已经成为末端物流配送能力的重要补充，各路资本企业竞相涌入该市场，想分得一杯羹。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	2015年6月，顺丰、申通、中通、韵达、普洛斯投资5亿元成立丰巢科技；2016年10月，中集e栈、上海富友收件宝、江苏云柜组成创赢联盟，形成了以速递易、丰巢和创赢联盟为主的三巨头格局；2017年7月，中国邮政集团与驿宝网络入股速递易，中国邮政以50%股份控股速递易，“国家队”正式进入智能快递柜行业……智能快递柜已然成为物流企业人手必备的基础设施。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	国家邮政局10月17日发布的 《2018年9月中国快递发展指数报告》显示，快递企业与第三方创新末端投递形式，基本形成上门投递、智能箱投递、平台投递等多元末端服务体系，主要企业设立智能快件箱25万组，箱递率达到8.4%。高速增长的数据表明智能快递柜前期虽饱受争议，但后期已逐渐被民众所接受。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	智能快递柜突破派件瓶颈，效果显著\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	首先，智能快递柜降低了人力成本，减少了快递员的工作负荷。快递员的工作量和工作任务较为繁重，在人手不足的情况下一个快递员往往需要承担起更多的工作，经常超出本来的工作时间，因此快递公司需要对快递员支付较高的人力成本。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	智能快递了增加派件数量，在提高了快递员的工作效率的同时，也提高了他们的收入，在一定程度上缓解了“用人难”问题，降低人力成本。在这一点上，丰巢获取得的效果极为突出：在今年九月初，丰巢与链家进行合作并声称他们的日均派件量已高达900万+,这个数据对于快递行业来说无疑是一个巨大的进步。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	其次，智能快递柜提高了用户隐私保护力度，取件时间更随意。当今社会，人们对于隐私非常重视，而在传统的快递人员配送模式中，存在快递信息被其他人窃取或是快递在寄存的时候丢失等问题，智能快递柜保密性更强，能极大减少了这种问题的发生。再加上传统的配送模式中快递员配送的时间可能会和收件人在家的时间不对等，给收件人带来了困扰，智能快递柜投入使用使得忙碌的人们可以随时取件，极为方便。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	智能快递柜陷入困境：难盈利、争议大\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	智能快递柜诞生是时代进步的需要，也给我们的生活带来了巨大的改变，但很多问题也接踵而来。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	首先，盈利难。一方面是因为快递柜的设备生产成本高和在每一个小区内投放的租金比较高，快递柜的场地年租费也较高，同时维护费用也不低。过高的成本使智能快递柜不能为企业带来营收利润，这对每一个企业来说都是致命的打击。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	佼佼者丰巢和速递易均面临着巨大亏损：截止2017年9月30日，丰巢科技在该年9个月期间的营业收入为1.6亿元，净亏损从2016年的2.5亿元扩大到2.76亿元，负债总额扩大到12亿元；运营速递易项目的三泰科技也是出现常年亏损，2015 年亏损3792.8万元 ，2016 年亏损 12.69亿元，2017年第一季度亏损也将近3000万元。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	另一方面是用户往往不会愿意为此付费。用户认为在购买商品时已支付过运费，取快递时就不应该再支付额外的费用，使得快递柜的亏损日益增加。同时，蜂巢、速递易等快递柜也开始向快递员收取存放费用，其中速递易快递柜的收费标准为：大箱0.6元/件，中箱0.5元/件，小箱0.4元/件，但很多快递员不愿承担这些费用。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	其次，智能快递柜虽然提高了快递员配送快递的效率，但使得快递员很轻松的逃避了签收这一流程。用户无法进行当面进行签收，使得物品运输过程中出现的质量问题时的合法权益无法得到保障，收货时发现快递有问题不知该向谁反映。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	最后，在包裹数量的飞速增长的背景下，快递员如果像从前一样一件件把快递送到消费者手中显然是不太现实的事。所以现在的快递员在快递高峰时段一般都使用智能快递柜，不会打电话一一进行通知，在把物品投入快递柜时会由系统自动给用户发送取件通知，而如果快递员在放入物品时把用户的手机号输入错误，会导致用户无法接收到取件通知，从而超时取件。现在部分品牌快递柜超过一定的取件时限需要收取一定费用，这让用户难以接受。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	另外，有用户在使用丰巢快递柜时，页面会出现“打赏”等字样，价格以1、2、5元为不等，这样确实能为丰巢带来一定的收益，虽然不是强制收费并且设有“跳过”的字样，但由于字体过小，有引诱用户消费的嫌疑因此用户在使用过程易产生误解与不满。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	智能快递柜如何赢得“民心”？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	智能快递的问题柜已经严重影响后期的战略布局和发展，企业应当如何解决成了广泛关注的焦点。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	首先，智能快递柜最初出现时毫无营收利润，很大程度上是因为单纯的取件不可能有任何收入增长，但是现在智能快递柜的发展已涉及到寄件的环节，这意味着快递柜也可以从中赚取一定的利润。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	智能快递柜要想继续获得更大的盈利，应该继续为用户提供更多增值服务，让用户为此愿意付出相等的费用。比如，在各种人流量较大的公众场合，有很多用户因为手上提的东西过多有很大的不便，快递公司可以在这些场合投放寄存柜方便用户存放，并收取一定的费用，据了解蜂巢已经在试点，今年5月中标了杭州周边17个高铁站，总计36组寄存柜的订单。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	其次，面对快递柜无法当面签收的缺陷，快递柜企业应继续完善快递柜的基础硬件设施，比如在每一组快递柜上安装摄像头，用户在取包裹时可以将包裹在摄像头下展示，将来包裹质量出现问题时可以避免物流企业和用户之间产生不必要的纠纷。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	最后，针对部分用户不满快递员在未经允许的条件下投递快递柜的问题，早在2016年国家邮政局发布的《智能快件箱投递服务管理规定（暂行）》中就曾明确提出，“经营快递业务的企业在使用智能快件箱投递快件前，应当征得收件人明示同意”，同时用户有权利决定是否使用快递柜或是按指定地点取货，用户应该积极行使自己的权利。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	企业在这样的背景下应加大对快递人员基本服务知识的培训力度，同时加强对客服人员处理客诉的能力，及时处理客户问题并进行反馈。快递员在把包裹放入快递柜时应检查该快递是否为需要保鲜、即食类食品，一旦出现商品问题则由快递公司或快递员承担全部责任。面对取件通知收不到等问题，在首次投递后收件人未能提取的情况下，快递企业应及时取回快递，联系收件人后再提供投递服务。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	小结\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	时代与技术在发展中，任何行业的各个环节都应该往效率更高，成本更低道路上发展。物流末端的需求是多样化的，送货上门是主流，但智能快递柜的市场潜力也不可小觑。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	根据中商产业研究院发布的 《2018-2023年中国智能快递柜市场前景及投资机会研究报告》 ，预计2018年智能快递柜市场规模将达169亿元，到2020年，中国快递柜市场规模将达近300亿元。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	所以，丰巢等智能快递柜未来应加大沟通协调力度，在提高消费者满意度的同时，尽快解决盈利模式问题，尽可能地保证效率、成本、体验和信息的互动。\r\n</p>',	'doc.png',	0.00,	37,	0,	0,	0,	'2019-12-03 14:14:23',	'admin',	1,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	0.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	13,	1,	0,	1),
(108,	'研报频道: 金麒麟分析师 天风快递策略:挖三四线潜能',	'<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	今年5月，唱吧终于完成了将近一年半的上市辅导工作。网上有消息称，唱吧在一个月后，就会正式向证监会递交招股书，踏上A股创业板的上市征途。但眼看着2018年就快要过去，却迟迟未见唱吧上市的消息。对此，唱吧创始人陈华在接受媒体采访时表示，对唱吧上市问题不愿多谈，言外之意是唱吧在近期内可能不会寻求上市。这突如其来的转变，让人们疑惑不解。唱吧在完成一年多的漫长上市辅导期之后，为何不愿上市？其究竟打的是什么“算盘”？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	唱吧上市搁浅，原因为何？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	唱吧从2012年上线起，便风光无限。其在上线首日注册用户就超过10万，5天之内登顶AppStore排行榜。易观数据显示，直到2016年第3季度，唱吧还以53.6%用户渗透率位居移动K歌领域第一的位置。彼时，唱吧正如日中天，选择上市无疑是正确之举。然而世事无常，经过将近一年半的漫长辅导期，国内的在线K歌市场早已“物是人非”，唱吧已然错过了最佳的上市时机。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	其一，全民K歌抢了唱吧“风头”。众所周知，全民K歌背靠腾讯，可谓是含着“金钥匙”出生。全民K歌不仅拥有微信与QQ两大流量入口，还与QQ音乐共享丰富的音乐版权，在流量与音乐版权方面都有着天然的优势，是唱吧最强劲的对手。据了解，全民K歌自2014年上线起，其活跃人数一直高增猛涨，在2016年成功超越唱吧，并逐渐拉开差距。据易观数据，2018年第三季度，唱吧活跃用户为6560万人，而全民K歌活跃用户则为20705万人，是唱吧的三倍。面对全民K歌的“攻城略地”，唱吧显然处于不利地位。而全民K歌的赶超，可能打乱了唱吧的上市计划。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	其二，短视频平台的崛起，冲击整个互联网娱乐市场。近几年，由于快手、抖音等短视频平台的崛起，整个互联网娱乐市场变的更加“拥挤”，唱吧的K歌业务、直播业务等都受到了一定的影响。QuestMobile数据显示，2018年7月，短视频APP行业月度活跃用户规模为5.08亿人，而短视频APP行业总使用时长在移动互联网中的占比达到惊人的9.2%，要知道，就算是在线视频的占比也仅有9.5%。可见，短视频APP行业已经抢占了大量互联网用户的上网时长，唱吧无法视而不见。再加上全民K歌的存在，唱吧要想巩固自身地位并不容易，目前也很难有华丽的数据支撑，若是在此时上市，唱吧的估值可能并不理想。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	其三，互联网股市动荡不安。最近国内不少已经上市的互联网企业过的并不“如意”，如小米、拼多多和美团等企业都出现了市值大幅下滑的情况，就连腾讯、阿里巴巴等老牌互联网企业也没能避免。受此影响，唱吧此时选择不上市或许是明智之举。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	一方面，在国内互联网股市行情不利的情况下，唱吧此时上市无疑是逆水行舟，有着“流血破发”的风险；另一方面，今年国内的互联网公司纷纷申请上市形成了“上市潮”，如宝宝树、映客、小米和拼多多等，如此多的公司扎堆上市，吸引了不少资金注入，导致资本市场紧缩，也就是说投资人手里的钱越来越紧张。这也许会造成唱吧融资困难，难以得到理想的融资金额。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在这些问题影响下，唱吧暂时将上市的计划搁浅，等待更好的时机上市，或许是不错的选择。不过除了上述三个原因之外，也有业内人士猜测，唱吧之所以要搁浅上市，可能是其要放弃A股创业板，而选择赴港上市。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	港股市场火爆，令唱吧有所动摇？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	对于唱吧要赴港上市的猜测，也并不是没有依据。早在2015年，唱吧就曾想要赴美上市，但由于美国缺乏与唱吧对标的产品，而导致其估值过低，令唱吧有所顾虑。与之相比，当时国内的A股市场行情较好，且国内资本对互联网科技股也愈发青睐。所以再三思考后，唱吧毅然拆除了VIE架构，选择回国赶赴A股上市。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	时至今日，随着港交所在上市机制上的改革，首次接受同股不同权企业上市，为互联网企业打开了一扇大门，包括小米、美团点评、平安好医生和宝宝树等多家明星企业都选择在港股上市。而此时的唱吧或许面临着与三年前类似的选择题，是A股还是港股？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	据了解，上市A股要求较为严格，除了必须盈利三年才能申请IPO外，还必须同股同权。而现在的港股市场，除了支持同股不同权企业上市，其监管机构也更加独立透明和高效，公司一般在6到12个月就能完成上市过程，可以帮助企业更好地把握好上市时机。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	此外，A股实行的是“T+1”交易制度，股民们当天买进的股票当天不能卖出，且还有涨跌幅限制。而港股采用的则是“T+0”交易制度，在当天交易时段内，相关机构和股民们可以自由买卖，交易次数与涨跌幅均无限制，这种方式不仅能够提高市场的交易量，还能帮助投资者及时止损。所以二者相对比较来看，港股市场规则似乎更加灵活且合理化，能帮助企业有更好的发展。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	且从根本上来讲，企业上市无非就是希望借助资本的力量，获得更好、更快速的发展。而随着港交所改革，港股已经成为了众多互联网公司上市的首选。在此条件下，唱吧若是选择“跟风”，改赴港股上市，也不是没有可能。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	不过从目前来看，在市场竞争加剧、股市动荡等问题影响下，唱吧此时上市并不稳妥。所以暂时将上市计划搁浅，继续修炼“内功”，才是唱吧最好的选择。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	养精蓄锐，厚积薄发\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	目前，纵观整个移动K歌市场，已然是唱吧与全民K歌双雄称霸的局面，像天籁K歌、K米和酷狗唱唱等K歌产品已经难以给全民K歌、唱吧二者带来威胁。可见，唱吧在移动K歌领域还是有着非常明显的领先优势，只要其能够完善自身，加强功能创新，或许就能够摆脱全民K歌所带来的竞争压力，在互联网娱乐市场中走的更远，其上市之路也会变得更为平坦。对此，唱吧可以从以下三个方面入手。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	首先，丰富曲库资源，提高音乐品质。音乐版权是移动K歌行业的刚需，缺少相应的音乐版权，用户就无法得到理想的K歌体验。如在用户K歌时，一定会选择自己喜欢的音乐进行录唱，但用户若是在唱吧中搜不到自己想要唱的歌曲，在别无选择之下，用户就会选择用其他的K歌软件进行录唱，最终造成唱吧的用户流失。因此，唱吧要想缩小与全民K歌的差距，还需与相关的音乐版权公司合作，丰富自己的曲库资源。同时，唱吧还应继续提升APP内的伴唱、录音和修音等音乐品质，争取为用户提供更加优质的K歌享受，以此来留住和吸引更多用户。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	其次，加强线上、线下融合，丰富用户K歌体验。如今，唱吧正在大力布局线下市场，其不仅花费数千万元战略投资麦颂KTV，并实现了与麦颂KTV在社交、服务等多方面的合作，还大力布局线下移动迷你KTV业务，取得了不错的成效。据了解，唱吧不光在全国拥有400多家麦颂KTV门店，还在商场、超市和机场等公共场所布下了2万多台迷你K歌亭。不过唱吧虽然在线下布局极广，但其线下资源还未能与线上达到有效的结合。目前唱吧在APP内只提供了KTV包房预定、在线点歌和在线切歌等常用功能，还有很大的完善空间。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	对此，唱吧可以在APP内添加游戏点歌、K歌评比和K歌挑战赛等有趣功能，加强用户线下与线上的互动。同时，用户在麦颂KTV里演唱的歌曲最好也能保存在唱吧APP中，让用户可以在唱吧APP中发布并分享自己在麦颂KTV里的演唱歌曲，这不仅满足了用户的分享欲望，又加强了线上与线下的融合，可谓是一举两得。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	最后，走出海外，争夺更大的移动K歌市场。如今，唱吧已经在国内取得了不错的成绩，其知名度和影响力也都达到了一定的高点，所以唱吧要想再有突破，并不容易。在此情况下，唱吧若是向海外市场发起冲击不失为一个选择。一方面，目前海外的许多国家都缺少类似唱吧这样的K歌产品，还是一片蓝海，这对唱吧来说有着不错的发展机遇；另一方面，在全民K歌、抖音、快手等平台影响下，国内的互联网娱乐市场空间变窄，唱吧要想继续在此环境中发展将受到不小的阻碍。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	总的来说，虽然上市会为唱吧带来新的发展机遇，但在市场竞争加剧、股市动荡等问题影响下，此时上市，对唱吧来说有着较大风险。因此，唱吧只有继续精细化运营，加强线上线下融合，并等待时机成熟后再进行上市，才会迎来更好的发展。\r\n</p>',	'doc.png',	0.00,	40,	0,	0,	0,	'2019-12-03 14:17:25',	'admin',	3,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	0.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	14,	1,	0,	1),
(109,	'新华国际时评：谁让“WTO皇冠上的明珠”黯然失色',	'<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	换上炫彩外壳，装上多变口味的烟弹，上市多年的电子烟今年突然热度飙升，成了备受追捧的创投领域。除了罗永浩在发布会上顺势推销的福禄电子烟，2018年末到2019年初，还有近10个新兴电子烟品牌出现。在深圳华强北电子市场，出售电子烟的广告牌更是如雨后春笋般涌现。但面对日趋严密的控烟大网，创业者们能否咽得下“这口烟”仍存在极大变数。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\"> <strong>电子烟突然变网红</strong> \r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	蓝莓、菠萝、水蜜桃、绿豆冰棒、柠檬茶……说到这些，不少人会联想到口香糖或是冰淇淋，却几乎没人能想到，这些全都是电子烟推出的新口味。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	精巧如U盘或是一根签字笔，也不用点火，从口袋里掏出来，打开开关就能用——近一年来，以电子产品形象出现的电子烟成了创投领域的新网红。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	今年1月，罗永浩在子弹短信新版本“聊天宝”发布会上，顺势推销了一款名为福禄、由锤子科技二号人物朱萧木创业推出的电子烟产品。紧接着，同道大叔创始人蔡跃栋与黄太吉创始人赫畅推出的“YOOZ柚子”，5位自媒体人组成创始团队的“灵犀&nbsp;LINX”也纷纷杀入。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	猪年春节，常年浸淫在科技圈、创投圈的自媒体人士陈女士惊讶地发现，平日里不抽烟的她，竟然收到了3种不同的电子烟产品作为新年礼物。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在深圳华强北，曾经卖VR眼镜、贴牌手机和智能家居产品的柜台，纷纷开始转售电子烟。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	突如其来烧起来的电子烟，背后是资本不断添柴加火。2018年，国内有十几家电子烟公司获得资本青睐，总融资额达数亿元。Wel鲸鱼、YOOZ柚子、魔笛MOTI、TRYMIX反正、GOIN谷云、APOC……新兴的电子烟品牌让人目不暇接，俨然造就了岁末年初最火热的创业领域。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\"> <strong>风口背后的同质化</strong> \r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“电子烟界的iPhone”、“颜值爆表一口解馋”、“重新定义吸烟”……在各家打出的广告语中，几百元一支的电子烟似乎成了可供电子发烧友们品玩一番的电子玩具。然而，花哨热闹的营销语言背后，电子烟的实质技术并没有太大区别。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“花几个月到半年时间，联系供应商、备货、外观设计，剩下就不需要你再做什么了，几乎没有任何硬性投入，本质上是个非常‘轻’（投入）的生意。”早期投资人付强向媒体透露，做一个电子烟项目，对技术等原创能力的要求几乎没有门槛。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	多位行业人士透露，由于国内电子烟供应链已经被电子烟发展较为成熟的国外市场培育得非常完备，因此很多新创立品牌都是通过代工生产。有技术爱好者对几款热门电子烟进行评测后发现，几个品牌在开关控制、烟油技术等方面相差无几，只是烟弹、外壳颜色、口味等进行了不同的排列组合与拼凑。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“电子烟的产品结构并不复杂，主要构成也就是充电电池（烟杆）、雾化器还有烟油三部分。”新晋电子烟品牌灵犀创始人章晋源坦言，电子烟的制造门槛并不高，确实存在行业同质化问题，“灵犀LINX当前着重聚焦于品牌环节，属于产业链下游，希望设计的首款产品具有品牌辨识度。”\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\"> <strong>电子烟也有多重风险</strong> \r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“清肺水果味”、“健康清肺蒸汽烟”……稍加留意就会发现，不少电子烟公司将产品与健康挂上了钩。在他们口中，因抽烟承受健康风险的烟民可以通过电子烟追求潮流文化、拥有“健康生活方式”。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	电子烟是否能够像一些公司所说的那样起到“代烟”、“辅助戒烟”的功效？目前尚无定论。令人担忧的是，一些原本不吸烟的人因为对电子烟的好奇而加入了烟民行列。在游戏公司工作的白先生告诉记者，他的同事和合作伙伴里出现了好几位新一代“电子烟民”——而他们过去根本不碰香烟。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	北京营养师协会理事顾中一提醒，电子烟中虽然没有普通烟草燃烧所产生的焦油、一氧化碳等有害物，但仍然含有有毒、成瘾的尼古丁，对普通人特别是儿童、青少年仍然有危害。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	记者在一家电子烟的天猫店铺内发现，虽然商品详情页面的底部用黑色背景的字体写着“未满十八岁不允许购买”，但一不留神就会错过这一信息。并且，记者在尝试下单时，店铺对身份信息、年龄等方面毫无要求，消费者可以随意下单购买。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	顾中一还提醒，由于目前市场监管并没有完全到位，缺乏相关国家标准，电子烟产品中用到的原料、调味剂、工艺都较为随意，厂家很可能为了增加新奇体验加入一些对人体有害的物质。“哪怕是一些比较常见的添加剂，正常食用是安全的，吸入肺部却可能带来潜在风险。比如丙二醇是很常见的食品添加剂，但是燃烧后容易刺激呼吸道，一些电子烟的烟雾中也可能含有重金属。”\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	对创业者来说，更大的考验来自于市场的不确定性。在控烟大势下，多地已经将电子烟列入了管控范围。今年2月，继杭州、南宁等城市在公共场所禁止使用电子烟之后，深圳在其控制吸烟条例征求意见稿中将电子烟纳入了控烟“黑名单”。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	意识到道德、法律等多重风险，一些科技上市公司急于与电子烟划清界限。今年2月中旬，小米公司官方微博就对“小米旗下生态链公司将进军电子烟领域”一事进行回应，称“小米不会做电子烟，此事纯属谣言”。\r\n	</p>',	'doc.png',	1.00,	1,	0,	0,	0,	'2019-12-03 14:18:03',	'admin',	2,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	1.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	3,	1,	0,	1),
(110,	'河北唐山发生2.6级地震 震源深度14千米',	'<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	2018年可谓是中国智能音箱的元年。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	业内普遍认为，智能音箱是切入智能家居使用场景、并易于被用户接受的理想入口，而智能家居的开关一旦被打开，更多的产品和服务将快速进入消费者的日常生活，获得一个更多元的商业环境。因此，近两年国内外科技巨头、互联网巨头皆大力发展智能音箱，使得该领域得到飞跃式增长，并从小众逐渐走向大众。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	值得一提的是，智能音箱除了具有巨大的消费市场外，对于互联网巨头们来说更起到AI市场的“门票”的作用。在这个快节奏的时代，企业之间的竞争更加激烈，率先拥有某一行业的门票就相当于成功了一半。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	由此，继国外亚马逊、谷歌、Facebook、苹果等科技巨头布局智能音箱产业之后，国内如阿里、百度等巨头也纷纷入局，小度智能音箱、叮咚、天猫精灵等产品在市场活跃度直线上升，国内智能音箱市场一片繁荣，随后在去年打起了“智能音箱价格战”。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	全球互联网巨头共掀全球智能音箱浪潮\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	根据Strategy Analytics发布的《2018年第三季度全球智能音箱市场报告》，2018年第三季度全球智能音箱出货量达到2270万，同比增长197%，创历史新高。其中，亚马逊智能音箱的全球份额与2017年相比有大幅下降，但出货量一直在上涨，第三季度市场占有率依然最高，达到32%，而谷歌以23%的市场占有率紧追其后。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	值得一提的是，来自中国的阿里、百度、小米智能音箱出货量分别排在全球第三、第四、第五位。当中又以百度表现最为亮眼，其市场占有率从2018年Q2的1％增加到2018年Q3度的8％，超越小米，成为当之无愧的黑马。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	而根据eMarketer《2019年智能音箱市场趋势观察》的预测，2019年中国将拥有8550万智能音箱用户，超过美国7420万的用户数量。智能音箱在美国网民中的普及率为26.0%，远高中国的10.0%，因此未来中国智能音箱领域还有极大的发展空间。不过即便如此，国内企业想要在智能音箱领域进一步发展仍有极大挑战。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	首先，是亚马逊、谷歌、苹果等海外企业更加成熟的智能音箱产品的冲击。亚马逊于2014年11月发布了Echo音箱，揭开智能音箱的序幕，打了人工智能领域“领头羊”谷歌、设备领域“领导人”苹果一个措手不及，成为智能音箱领域的第一人，为其之后进军智能家居领域打下基础。随后谷歌、Facebook、苹果等科技公司纷纷跟进，相继推出GoogleHome、Portal、HomePod。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	而后，无论是亚马逊并购互联网路由器初创企业Eero，还是谷歌推出Google Wifi，都表明国外在智能家居领域发展正愈加成熟，由此给国内市场带来的冲击是巨大的。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	其次，是国内错综复杂的智能音箱市场而产生的原生阻力。国内智能音箱市场厂商繁杂，主要有五种类别：一是以BATJ等为主的互联网公司，希望通过语音这一入口建立智能生态，为既有的内容和服务寻找新市场；二是以科大讯飞为代表的，专注于技术开放平台建设的技术厂商；三是以喜马拉雅等内容厂商；四是主打智能家居的创业公司；五为以漫步者为代表的传统音箱厂家。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	与国外相比，国内智能音箱领域除了厂商更繁杂、竞争更激烈外，在时间上也有一定的滞后性。国内第一款智能音箱叮咚诞生于2015年，由京东与科大讯飞联合推出。此后国内智能音箱市场沉寂，直至2017年阿里试探性地推出天猫精灵，小米、百度等企业不甘落后，纷纷入场，国内智能音箱才进入密集发售期，一时间智能音箱领域热闹非凡，“百箱争鸣”。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	当先天不足遇上恶劣生存环境\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	当下，我们不能否认的是，随着家庭中联网设备的不断增加，有极大几率成为未来智能家居控制中枢的智能音箱有着非同一般的重要性。但古往今来，利益有多大，风险就有多大。对于如钥匙般的智能音箱领域来说，发展面前有三问需解答。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	首先，智能音箱如何“智能”？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	每当市场有了新的风口，就会出现无数跟风之人，智能音箱也不例外。为搭上智能音箱的顺风车，传统音箱厂家推出不少产品，只不过卖点都集中于音质，本末倒置。 另外，“语音识别技术”也是尚未完善，一方水土一方人，同一语种还有不同口音，更别提各地方言以及语境涉及到的自然语言理解问题。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	除此之外，还有人工智能和物联网领域中老生常谈的安全隐患问题，如数据存储、身份认证、敏感数据保护等，在此不多赘述。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	其次，智能音箱如何提高普及率与使用率？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	我们知道，物联网时代“未来智能家居的控制核心”这一定位是智能音箱如此火热的重要原因之一。而理想的智能家居生态并非是家居单品的智能化，而是彼此联动，达到互联互通互控的状态，但目前的智能家居系统仍旧处于互相独立的状态，使得智能音箱使用率不高，如同“鸡肋”。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	与国内相比，国外在此方面就先进得多，以美国为例，美国的智能家居行业有统一的标准协议，亚马逊的Echo可以直接接入各种智能家居设备，这也是为何美国智能音箱普及率远高中国的原因。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	最后，国内企业如何“走出去”？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在用户习惯方面，国内外有着不小的差异。以使用环境为例，国外用户居家环境多为开放式，美国家庭主妇在烹饪时都喜欢听音乐，因此智能音箱在国外的消费需求也相对较高。而国内，厨房客厅封闭性更高，生活环境相对嘈杂，相应地市场对智能音箱需求较低。此为国外厂家难以进入中国市场的重要原因之一，另一限制则是人机交互的“本土化”程度低。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	以苹果HomePod为例，虽然其Siri语音助手对中文的支持已经有一定成果，但在交互、理解能力等方面，与本土选手阿里、百度相比仍是落后。并且，以BAT为代表的国内企业拥有更多本土资源，境外企业如苹果，很难在中国有突破性进展。同理，国内企业想要走出去也会遇到同样的难题。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	综上，智能音箱可谓是“腹背受敌”，而现阶段各巨头发展智能音箱的主要目的并不是盈利，而是抢占更多的用户家庭，为未来AI生态建设进行数据铺垫。那么，中小企业如何在这场战争中存活呢？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	双重风暴下，智能音箱可靠内容过冬\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	前文提过，国内有一类以喜马拉雅为代表的注重内容的智能音箱厂商，笔者认为现阶段此类厂商可能更好存活。现今用户对智能音箱的主要需求还处于“听”的情况下，智能音箱很大程度上是内容生态之争。在此基础上，喜马拉雅以自身丰富的内容为基础，推出智能音箱小雅，将更容易在家庭场景中突围。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	虽然从整体上看，喜马拉雅与BATJ等互联网巨头在技术和未来AI整体布局上存在相当大的弱势，但由于各种原因的限制，国内用户对智能音箱的需求在接下来很长一段时间里，都将处于“听”的阶段。并且，智能音箱核心技术“语音识别”，从本质上来说也是内容的一部分。从另一角度看，喜马拉雅的竞争对手也并非是BATJ等互联网巨头，其在智能音箱领域的发展更多的是为了扩充自身音频业务，巩固自身在在线音频市场的地位。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	同样的，在内容资源上有着强大优势的还有腾讯，毕竟现阶段消费者购买智能音箱的主要用途就是内容消费和智能家居两方面。在此基础上，腾讯可将自身音乐、阅读和视频整合，为智能音箱做内容支持。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	除了内容消费，“智能音箱+教育”的模式发展空间也十分广阔，尤其是早教领域。抛开说烂了的在线教育，光是国人对子女教育的重视程度，就足以让智能音箱注意到“早教”这一领域。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	单从目前智能音箱市场情况来看，短时间内C端消费市场的表现都比不过B端。因此，如何在B端站稳脚跟再最终反哺C端，是智能音箱发展过程中相当重要的一点。站在这个角度上看，“智能音箱+早教”的未来十分令人期待。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	毕竟，国内早教行业师存在资水平有限，地域发展不平衡，多数幼师仅经过短期培训就上岗从业，专业化程度低等问题。若是将智能音箱与早教结合，它所承载的大量专业、系统、科学的早教课程，能完美弥补传统绘本、书籍、视频等的缺点，再加上其操作简单、安全性高、不损伤视力的优点，能让智能音箱成为早教过程中不可或缺的工具。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	当然，除了以上两个方向，智能音箱作为人工智能音频端的入口，能够发展的B端场景是十分丰富的。就此，在C端市场来临前，国内非巨头企业在智能音箱领域也有了新的突破口。那有没\r\n</p>',	'doc.png',	1.00,	21,	0,	0,	0,	'2019-12-03 14:18:52',	'admin',	4,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	1.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	4,	1,	0,	1),
(111,	'女子被男友从家里打到楼道 警方：男子被行拘5日',	'<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	社交网络下一步发展的未来在何方？6日，Facebook创始人扎克伯格给出了自己的答案。在一篇长达3200字的公开博客文章中，这家全球最大的社交网络的掌门人称，未来Facebook将专注于营造一个更为私密和安全的网络社交环境。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“当我思考网络的未来，我认为专注于隐私的通讯平台相比今天的开放平台，将变得更加重要，”扎克伯格写道：“今天我们已经看到私密消息、短故事分享和小规模群组是在线通讯交流发展最快的领域。”\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	尽管扎克伯格认为，开放社交网络在未来仍有一席之地，但更大的机会在于“建立一个首先专注于隐私的更为简单的平台。”\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	扎克伯格称，在过去15年间，Facebook和Instagram帮助建立了一个“数字化的公开广场“，但人们开始迫切需要更为私密的”数字化的客厅空间“。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	对于Facebook来说，这将是一个具有里程碑意义的转型，成立15年来，Facebook成功打造了全球最大的公开社交网络，并在此基础上建立起一家以广告业务为主的商业帝国。但近年来，随着一系列与用户数据隐私泄漏相关的丑闻接连爆发，Facebook开放社交模式遭遇到前所未有的严峻挑战。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	正是由于内外部坏境发生的变化，促使Facebook开始思考接下来的转型方向，如今，这家全球最大的社交网络通过其掌门人的一封公开信给出了解答。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“我认为未来的通讯将更多地转向私密的、加密的服务，这样人们在与别人交流时，对于信息的安全新、内容不会停留会更有信心，”扎克伯格说，“这是我希望我们能够帮助带来的未来。”\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	为了达成这一目标，扎克伯格称，Facebook即时通讯平台将向Whatsapp的模式靠拢，未来端到端的加密服务将贯穿于Facebook所有旗下包含即时通讯的业务功能，该表态印证了此前外界流传的Facebook计划打通旗下即时通讯功能的传言。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	扎克伯格称，计划按照打造WhatsApp的模式进行：专注于最为基本和私密的应用场景即时消息开始，让其尽可能的安全，然后在此之上建立更多让人们能够互动的方式，包括打电话、视频聊天、群组、故事、商业、支付最终成为更多私人服务的平台。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	为了实现这一转型目标，扎克伯格列出了数项准则，包括加密、缩短内容的存续、安全、互通和安全数据存储。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“我相信我们应该朝着建立这样一个未来世界而努力：人们可以私下说话并且知道他们的信息只会让他们希望看到的人看到并且不会永远存续下去，“扎克伯格说，”如果我们能够帮助世界朝着这个方向发展，我将会为我们所做出的努力感到自豪。“\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	以下为扎克伯格公开博客全文：\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	注重隐私的社交网络愿景\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	过去几年，我的重点一直是理解和应对Facebook面临的最大挑战。这意味着对关系到互联网未来的重要问题采取什么立场。在本文中，我将概述Facebook围绕建立以隐私为中心的信息和社交网络平台的愿景和原则。有许多的事情要做，在开发的进程中，我们承诺开放式的工作，并将与全社会的专家进行协商……\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	过去15年间，Facebook和Instagram一直在帮助人们与友人、社区和等同于数字城市广场中的兴趣联系在一起。但是人们也越来越想私下在相当于起居室的数字环境中进行交流。当我思考互联网的未来时，我认为一个注重隐私的交流平台将变得比今天的开放平台更加重要。隐私让人们有自由做自己，更自然地联系，而这些是我们建立社交网络的原因。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	今天，我们看到私有信息、短暂的故事和小型群组已成为在线通讯中增长最快的领域。这有许多原因。许多人更喜欢一对一交流，或者只是与几位朋友交流。人们对分享有永久记录的内容更加谨慎。我们也都希望能够私下和安全地进行支付。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	公共社交网络将继续在人们的生活中发挥重要作用--与你认识的每一个人联系；发现新的人、想法和内容；让人们有更广泛的发言权。人们每天都会发现有价值的内容，而且还有很多有用的服务可以构建在它们之上。但是现在，人们也想通过各种方式私下交流，这也让我们有机会打造一个首先专注于隐私、更简单的平台。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	我明白很多人不认为Facebook有能力、或者甚至不想构建这种以隐私为中心的平台，因为坦率地讲，我们目前在构建隐私保护服务方面没有很好的声誉，而且我们一直专注于更开放的共享工具。但是我们已多次表明，我们可以通过进化来打造人们真正想要的服务，包括私有信息和故事。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	我认为，通信的未来将越来越多地转向私有、加密服务。在此类服务中，人们可以确信他们对彼此说的话是安全的，他们的信息和内容不会永远存在。这是我希望我们能帮助实现的未来。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	我们计划用开发WhatsApp的方式来构建这一平台：专注于最基本和私有用例--消息--尽可能确保它的安全性，然后构建更多的方式让人们在此基础上进行互动，包括通话、视频聊天、群聊、故事、商业、支付、商务，最终成为许多其他类型的私有服务的平台。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	这个注重隐私的平台将围绕以下几个原则构建：\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	·私下互动：人们应该拥有简单、亲密的场所，在那里可以清楚地控制谁可以和他们交流，并且相信没有人可以接触到他们分享的内容。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	·加密：人们的私人通信应该是安全的。端到端加密防止任何人，包括我们在内，看到人们分享在我们服务中的内容。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	·减少永久性：人们应该感到自在，不应担心他们分享的内容会反过来伤害自己。因此，我们不会将信息或故事保留超过提供服务所需的时间，也不会超过人们希望它们留存的时间。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	·安全：人们应该期待我们会尽一切努力，在加密服务可能的范围内，确保他们在使用我们服务时的安全。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	·互操作：人们应该能够使用我们的任何应用联系他们的朋友，应该能够轻松安全地通过网络交流。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	·安全数据存储：人们应该期待我们不会在隐私和言论自由等人权记录薄弱的国家存储敏感数据，保护数据被不当访问。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	未来几年中，我们计划围绕这些想法重建更多的服务。在此行程中，我们面临的决定将意味着对关系到互联网未来的重要问题采取什么立场。我们清楚有很多权衡需要纠正，我们承诺与专家进行协商，并讨论最佳的前进方向。这需要一些时间，但我们不会关着门朝着这个方向发展。我们将尽可能以公开、合作地态度这样做，因为其中许多问题影响到社会的不同层面。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	私下互动是基础\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	要让一项服务感觉具备私密性质，绝不让用户怀疑在和谁交流。我们努力在所有产品中建立隐私属性，包括公共分享产品。消息服务的一个重要特性是，即使用户的联系人列表在扩充，用户的个人线程和群组仍然是私有的。随着时间的推移，用户的好友会逐渐发展，消息服务会优雅地发展，并保持亲密。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	这与更广泛的社交网络不同。在社交网络中，人们可以积累好友或追随者，直至服务更加公开。这非常适合许多重要的用途--告诉用户所有的朋友一些事情，在重要的话题上传递用户的声音，寻找有相似兴趣的人群，追踪创作者和媒体，买卖东西，组织筹款人，发展业务，或者让用户认识的每一个人在相同的地方得到好处。尽管如此，当用户一起看到所有这些经历时，感觉更像是一个城镇广场，而不是一个更私密的空间，比如客厅。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	我们有机会建立一个关注人们想要私下交流的所有方式的平台。这种隐私和亲密感不仅仅是技术特征--它被深深地融入到服务的整体感觉中。举例来说，在WhatsApp当中，我们的团队专注于在产品的各个方面创造一个亲密的环境。即使我们构建了允许更广泛分享的功能，这仍然是一种不太公开的体验。当团队开发群组功能时，他们设定了规模限制，以确保每一次互动都是私密的。当我们在WhatsApp上发布故事时，我们限制了公共内容，因为我们担心这种做法可能会削弱隐私感--即使这并没有真正改变用户和谁分享。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	几年后，我预计未来版本的Messenger和WhatsApp将成为人们在Facebook网络上交流的主要方式。我们致力于让这两款应用更快、更简单、更私密、更安全，包括端对端加密。然后，我们计划增加更多与好友、团体和企业私下交流的方式。如果这种进化成功，通过Facebook网络与用户的好友和家人互动，将会从根本上成为一种更加私密的体验。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	加密与安全\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	人们期望他们的私人通信是安全的，并且只被收方看到，而不是黑客、罪犯、过度干预的政府，甚至是操作正在使用的服务的人。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	人们越来越多的意识到，更多的实体可以访问自己的数据，就越容易被人滥用或被网络攻击泄露。一些人也越来越担心，技术可能会将权力集中在政府和像我们这样的公司手中。一些人担心我们的服务可能会访问他们的信息，并将其用于广告或其他他们不期望的方式。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	端到端加密是开发注重隐私的社交网络的重要工具。加密正在分散--它限制了像我们这样的服务看到流经的内容，并使其他人更难访问用户信息。这就是为什么加密在我们的网上生活中越来越重要，从银行到医疗健康服务。这也是为什么我们在收购WhatsApp后把端到端加密植入WhatsApp中的原因。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	去年，我曾与持不同政见者交流过。他们告诉我，加密是他们自由甚至活着的原因。一些政府经常对数据提出非法要求，当我们在法庭上驳回这些要求时，我们总存在败诉的可能--如果信息没有加密，我们要么必须交出数据，要么不遵守法庭规定导致员工被逮捕。这看起来很极端，但是我们曾有过这样的案例，一名员工就因为不提供对某人私有信息的访问而身陷囹圄。事实上，我们也无法访问这类信息，因为它是加密的。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	与此同时，在我们能够在所有消息服务中部署端到端加密之前，我们需要解决真正的安全问题。加密是保护隐私的有力工具，但也包括做坏事的人的隐私。当数十亿人使用同一服务连接时，他们中的一些人会将它滥用于真正可怕的事情，比如剥削儿童、恐怖主义和敲诈勒索。我们有责任与执法部门合作，并尽所能帮助防止这些行为。我们正努力通过检测活动模式或其他方式，来提高识别和阻止应用中不良行为的能力，即使我们看不到消息的内容，我们将继续对这项工作进行投资。但是我们面临着一个内在的权衡，因为当我们的安全系统能够看到这些信息时，我们永远也不会发现我们今天所做的所有潜在伤害。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	找到保护隐私和安全的正确方法，是社会在历史上一直努力解决的问题。这里还有许多悬而未决的问题，我们将与安全专家、执法部门和政府协商实施安全措施的最佳方式。我们还需要与其他平台合作，以确保整个行业能做出正确的事情。我们越是能创造一种共同的方法越好。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	总的来说，我相信为所有私人通信实施端到端加密是正确的。人们通过信息和电话完成一些最敏感的私人谈话，在网络安全威胁日益增加、许多国家政府干预过度的情况下，人们希望我们采取额外措施来保护他们最私密的数据。对我而言这似乎是对的，只要我们花时间构建适当的安全系统，尽可能在加密服务的范围内阻止不良行为。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	我们已开始在WhatsApp的基础上开发这些安全系统，在全面实施端到端加密之前，我们将在2019年及以后与专家讨论这些系统。随着我们从专家那里学到更多的知识，我们将最终确定如何推出这些系统。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	减少永久性\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	我们越来越相信在短时间内保存信息非常重要。人们想知道他们分享的信息不会反过来伤害他们，减少他们信息的存储和访问时间会有所帮助。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“永久性问题”开发社交工具的一个挑战是。随着时间的推移，我们积累了大量的信息和照片，它们在成为资产的同时，也成为了一种负担。例如而言，许多Facebook的老用户可能会有年轻时候的照片，这可能会让人尴尬。但是人们也非常喜欢记录他们的生活。如果Facebook和Instagram上的所有帖子都消失了，人们将无法获得他人分享的大量宝贵知识和经验。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	我认为有机会为私有通信平台设定一个新的标准--内容会自动过期或随时间归档。除非用户存档，否则故事会在24小时后过期，这让人们更自然地分享。这种理念可以扩展到所有私人内容。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	举例来说，在默认情况下，信息可以在一个月或一年后删除。这将降低用户的信息再次出现并让他以后尴尬的风险。当然，如果用户愿意，可以自己改变时间框架或者关闭线程的自动删除。如果用户愿意，我们还可以为用户提供选项，让他将个人信息在几秒钟或几分钟后设置为过期。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	限制我们存储消息元数据的时间也有意义。我们使用这些数据来运行我们的垃圾信息和安全系统，但我们并不总是需要长时间保留这些数据。解决方案的一个重要部分是首先收集较少的个人数据，这也是WhatsApp从一开始就建立的方式。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	互操作\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	人们希望能够选择他们用来与人交流的服务。然而，今天如果用户想在Facebook上给人们发信息，你必须使用Messenger；在Instagram上必须使用Direct；在WhatsApp上必须使用WhatsApp。我们想给人们一个选择，这样他们可以通过这些网络从他们喜欢的任何一款应用联系他们的朋友。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	互操作性有隐私和安全优势。举例来说，许多人使用Android上的Messenger收发短信。这些文本不能进行端到端加密，因为短息协议没有加密。然而，有了跨我们服务传递信息的能力，用户就可以从Messenger向WhatsApp中的某人的电话号码发送加密短信。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	这还可以提高许多体验中的便利性。在这些体验中，人们使用Facebook或Instagram作为他们的社交网络，WhatsApp作为他们首选的消息服务。举例来说，许多在市场上出售商品的人会列出他们的电话号码，这样人们就可以发送与购物相关的信息。这并不理想，因为用户要给陌生人提供电话号码。有了互操作性，用户就可以使用WhatsApp接收发送到Facebook账户的信息，而无需分享电话号码--买家也不用担心卖家是喜欢在哪个网络发信息。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	可以想象许多类似这样的简单体验--一个人在Instagram上发现了一家公司，并很容易过渡到他们喜欢的消息应用，以获得安全的支付和客户支持；另一个人想追上一个朋友，可以向他们发送一条消息，发送到他们喜欢的应用，而不必考虑这个人喜欢在哪里被联系；或者用户只需在Facebook和Instagram上发布一天的故事，就可以在一个地方得到好友的所有回复。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	今天，用户已可以通过Android上的Messenger发送和接收短信，我们希望在未来进一步扩展这一功能，或许包括新的电信RCS标准。然而，在这成为可能之前，我们需要解决几个问题。首先，苹果不允许应用在他们的设备上与短信交互操作，所以我们只能在Android上这样做。其次，我们需要确保互操作性不会损害人们已使用WhatsApp的加密预期。最后，它会在加密系统中造成安全漏洞和垃圾邮件漏洞，让人们从未知的应用中发送信息，因为我们的安全和安保系统看不到这些活动的模式。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	这些都是重大挑战，有许多问题需要进一步协商和讨论。但是，如果我们能够实现这一点，我们就可以给人们更多的选择，让他们使用喜欢的服务，以安全地联系到他们想要联系的人。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	安全数据存储\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	人们想知道他们的数据安全地存储在他们信任的地方。展望互联网和隐私的未来，我认为我们将做出的最重要的决定之一是：在哪里建立数据中心和存储人们的敏感数据。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在一个国家提供服务和在那里存储人们的数据有着重要的区别。当我们在世界各地建设基础设施时，我们选择不在有侵犯隐私或言论自由等人权记录的国家建设数据中心。如果我们在这些国家建立数据中心并存储敏感数据，而不仅仅是缓存非敏感数据，这可能会让这些政府更容易获取人们的信息。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	坚持这一原则可能意味着我们的服务在一些国家会受阻，或者我们不能很快进入其他国家。这是我们愿意做出的折衷。我们不认为在一些国家存储人们的数据是一个足够安全的基础，可以在其上建立如此重要的互联网基础设施。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	当然，保护最敏感数据的最佳方法是根本不存储它，这就是WhatsApp不存储任何加密密钥的原因，我们计划在以后的其他服务中也这样做。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	但是在更多国家存储数据也开创了一个先例，鼓励其他国家政府寻求更大程度地获取其公民的数据，从而削弱了全世界人民的隐私和安全保护。我认为，对于互联网和隐私的未来而言，我们的行业继续坚决反对把人们的数据存储在得不到安全保障的地方，这一点很重要。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	下一步举措\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在接下来的一年及以后，我们还要制定出与这些原则相关的许多细节和权衡。这项工作中的许多仍处于早期阶段，我们致力于与世界各国的专家、倡导者、行业合作伙伴和政府(包括执法部门和监管机构)协商，以正确做出这些决定。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	与此同时，通过这些原则开展工作只是构建以隐私为中心的社交平台的第一步。除此以外，我们还需要对在此基础上构建的所有服务进行深入思考--从人们如何支付和金融交易，到企业和广告的作用，再到我们如何为其他私人服务提供平台。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	但是，这些最初的问题得到正确答案是至关重要的。如果我们做得好，我们可以创建私人共享平台，这对于人们而言可能比我们建立的帮助他们更公开分享和联系的平台更重要。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	这意味着对关系到互联网未来的重要问题采取什么立场。作为一个社会，我们有机会阐明我们的立场，决定我们如何重视私人通信，以及谁来决定数据应该存储多长时间以及存储在哪里。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	我认为我们应该努力实现这样一个世界，让人们可以私下交谈，自由生活，知道他们的信息只会被他们想看到的人看到，而且不会永远停留在身边。如果我们能帮助世界朝着这个方向发展，我将为我们所取得的成就感到自豪。\r\n	</p>',	'doc.png',	1.00,	19,	0,	0,	0,	'2019-12-03 14:19:38',	'admin',	1,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	1.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	4,	1,	0,	1),
(112,	'中国陆军晋升6位中将 中央候补委员在列(图)',	'<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	今年两会期间，明星委员们的提案再次将炮火对准了劣迹艺人、明星及影视数据造假、身价片酬等行业乱象，不过前方固然慷慨激愤，后方还是其乐融融，#明星该不该吃粉丝送的食物#、#明星被认错#等话题频繁被推上热搜，娱乐氛围依旧。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	但今年还是有些许不同，2018年影视连续震荡所牵引出的政策新规，将在今年集中落地并被检验效果，前段时间，吴秀波、翟天临事件又掀起公众对娱乐圈造假的口诛笔伐。换句话说，娱乐产业规则改写的时机，可能已经同时具备了政策自上而下和舆论自下而上的两个必要条件。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	若是如此，数据造假将成第一个靶子，而往后推，数据造假的一环如果被铲除，是否能动摇当前畸形的粉丝经济呢？这是值得业界探讨的。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	造假产业链的逆向思考\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	2019年开年，《人民日报》发表文章，矛头直指流量明星锁场、刷榜、买粉丝，而后其又连续发表微博，感慨“明星流量数据节节攀升，8亿网民不够用”。随之跟进的还有《光明日报》《北京日报》，而“紫光阁”则从1月5日-9日，连发4条微博，痛批流量明星，呼吁“没有高质量作品做支撑，那些拙劣的表演终将被揭穿”。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	影视产业春寒料峭，一场“打假运动”的兴起，或许正是今年的新风向。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	微博已率先做出反应，宣布针对转发、评论计数显示方式在内做出种种调整，而更早之前，爱奇艺和优酷停止了播放量的展示。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	这对于影视数据脱水进而回归合理无疑是一个有利信号，视频及社交平台本身就是流量造星、粉丝运营的核心媒介，隐藏播放量起码减掉了数据造假的一个需求。虽然不得不承认，这一举措对整个行业来讲，也只是让数据造假不至于假得太“难看”，但其释放的市场信号是积极的：影视数据造假的乱象，今年或许不会止于揭露。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	以此为基础，我们再来看影视产业数据造假的产业链。一般来讲，卖方一端通过雇佣技术型或人工型水军，提供刷流量业务，至于买方一端，央视将明星数据造假的推手，归为自发组建的粉丝组织和经纪公司安排成立的明星微博数据站。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	两方需求契合，流量明星通过这一番操作获取一定的人气和地位，从而掠取演艺资源。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	而提供演艺资源的制片方、投资方以及媒体平台，又因流量明星的参与而收割商业利益，当然，这其中更少不了购买数据用以打榜、投票、转发的过程。无奈的是，这已成为市场优胜劣汰的“规则”，如果粉丝的偶像数据不好，就会被其他艺人的粉丝“唱衰”。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	由此可以看出，流量经济是一个参与方都可获得经济效益的模式，这也决定了很难从内部去戳破流量泡沫。但如今政策导向下，很有可能从外部强制性切断数据造假产业链，若是如此，会对以流量为基础的粉丝经济造成什么伤害？\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	我们可以逆向推断，假使数据归真，流量明星及其所产出的内容，在市场的反应能够一目了然，首先最可能放弃他们的就是内容生产方。因为对比靠实力说话的演员，流量明星原本与之天差地别的流量优势，很大程度上被削弱了，而今口碑反噬又日渐严重，制片人也不再经得起多次的扑街。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	相应地，流量明星的演艺资源一旦被缩减，曝光度大大降低，广告商、媒体以及平台很快便“闻风而动”。更关键的是，明星本人新粉难增、旧粉流失，长此以往就更没有商业价值了。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	流量经济还是粉丝经济？\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	当娱乐产业的优胜劣汰逐渐被流量所左右，如果从流量数据本身出发，一定程度上是可以约束某些行业乱象的滋生。但是流量缩减、粉丝仍在。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	蔡徐坤被央视点名时，震慑是对业内的，粉丝看似不惧。真爱粉们一面为爱豆打抱不平，力挺蔡徐坤确实是个专注音乐的好歌手，甚至表示之前做了那么多公益怎么不提？另一面又将攻击点集中到微博上，强烈要求整改。不过，前者是顾左右而言他，后面则是祸水东引，实则都没什么逻辑。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	从这件事直观地看，粉丝本身就是流量的一部分，即使最大程度地将流量数据脱水，蔡徐坤、鹿晗这类当前比较符合年轻群体审美的明星，也仍有不在少数的粉丝存留，他们才是饭圈的核心。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	换句话说，粉丝即使不花钱为他们的偶像刷流量，他们还是有其它方式向外界传达和证明自家爱豆的价值，甚至可以简单的说，只要粉丝愿意为爱豆花钱，在制片人和品牌方眼里，明星便有商业价值。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	这主要是因为当前的影视行业中，<strong>粉丝看似处于被收割的产业下游，实则主导着偶像的人气和商业吸引力。</strong>\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	<strong>一方面，粉丝已经参与到偶像的职业规划中，用自己的力量为偶像争取好资源。</strong>而市场也认可了这种做法，现在广告商、制片方最看重的，不再是明星的业务水平，而是背后的粉丝力量。所以，纵然市场能抛开流量数据，演员和明星粉丝群体的差别，也无法使商业资源偏向前者。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	<strong>另一方面，如今流量明星的粉丝展现出强大而可怖的集体力量，如果不再允许数据造假，他们对舆论的影响也能帮助明星维持流量再造。</strong>极端一点，像粉丝骂战、撕逼这种普遍现象，一经推手，在当前这个碎片化时代便是天然的流量爆发点。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	所以，<strong>数据打假所能纠正的也只是流量经济，而触及不到更深层次的粉丝经济。</strong>\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	时至今日，粉丝和流量的先后产生顺序已经模糊，这就是数据造假导致的，不过粉丝是基础，流量经济可以说是在资本介入、疯狂膜拜粉丝效应之后被放大的形态。这和移动互联网时代流量为王的思维，实则异曲同工。不过移动互联网进入下半场的服务升级，娱乐产业的流量经济反而日渐衰颓了。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	明星“死于”粉丝？\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	<strong>围绕粉丝和明星的行业规则及利益链一旦形成，实际上就连一个环节的整治都很难，更不要指望其内部会自我改进。</strong>但值得庆幸的是，当前流量经济之所以逐渐露出真相，在于其外部的反对力量日益强大，也催促市场形成一套新的淘汰法则。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	最明显的是电影界，流量明星的多番试水，让投资方再也经不起折腾。2016年“小鲜肉+大IP”的模式备受追捧，2017年参与暑期档大战的流量明星只有杨洋、李易峰两人，而到2018年暑期档、春节档，杨洋、鹿晗等人早已不见踪影。李易峰的《动物世界》即使备受肯定，票房仍不能回本。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	数据显示，2018年全国电影票房已经超过2017年总票房559.11亿元，创下新纪录，但票房前十的影片主演中均不见小鲜肉身影。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	流量明星开始被排斥在大荧幕之外，而且他们在业内留下的印象一旦被定性，投资人只会对他们避之不及。而下一个排斥流量的便是观众，这很容易让流量明星丧失转型的时机，甚至是永久被划在攻击的范围之内。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	这是口碑反噬的副作用，比如《创业时代》开播之初，很多人还没看剧，只知道有杨颖主演便给出了一星评价，迪丽热巴则一个人把《声临其境》的评分拉到了4.3。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	一个经典角色可以成就一个明星，但一个明星也有可能毁了众多角色，观众便将不满全部发泄到流量明星身上，反而不会再客观考虑是不是剧本、导演不行。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	不过作品口碑败光的更多是路人缘，而且市场通过这种副作用反噬的方式淘汰流量明星，毕竟是一个相对缓慢的过程。关键是，他们背后的死忠粉依然是“东山再起”的资本。<strong>所以一个流量明星的消失或死亡，完全取决于粉丝。</strong>\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	事实也是如此，我们看到，<strong>人设崩塌是最近常见的最快导致明星坠落的方式，而人设本质就是为迎合粉丝存在。</strong>粉丝心理假说认为，追星一种身份认同，粉丝通过对名人的“镜像”认识自己，塑造价值观，而一旦粉丝发现这种“镜像”是虚假的，认同感瞬间就消失了，而且会有上当受骗的感觉。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	当然，粉丝也是善变的，他们自然而然流失，流量明星们也就被市场抛弃了。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	<strong>流量数据的虚假泡沫被戳破总归是好的，但娱乐行业的乱象却无法根治，终究是粉丝把明星捧得太高了。</strong>\r\n</p>',	'doc.png',	1.00,	8,	0,	0,	0,	'2019-12-03 14:20:16',	'admin',	3,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	1.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	3,	1,	0,	1),
(113,	'CBA-富兰克林四双山西负新疆 北京3连胜 辽宁胜同曦',	'<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	你可能不知道咪蒙，但却一定知道她有一个月薪5万的助理。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	年初，在“寒门状元”事件之后，咪蒙就曾宣布关停微信公众号两个月，并永久关停微博。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	不想仅仅过了不到一个月，2月21日咪蒙以及旗下“才华有限青年”等微信账号就宣布将被永久关停。旗下美妆账号改名为“李粒粒LiLiLi”，咪蒙小号“好疼的咪蒙”则清空了所有内容。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	从咪蒙公布之前公布的报价来看，其微信公众号头条广告报价一度到达80万元，二条也有40万元。这次的账号注销还包括今日头条、凤凰号等等，并称咪蒙“不得转世”。咪蒙的商业帝国几乎被连根拔起。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	除了自媒体，同时可能就此终结的还有咪蒙刚刚开始的编剧生涯。2018年3月，柠萌影业曾经宣布，由咪蒙担任编剧的网剧《长大成人》正在筹备中。现在咪蒙被封，这部“神似”《欢乐颂》的作品最终何去何从也被画上了问号。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\"> <strong>“毒鸡汤女权”，这不只是咪蒙的专利</strong> \r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	正如我们上文所说，咪蒙还在积极谋求走向影视圈，成为编剧便是第一部。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	了解咪蒙的人都知道，咪蒙的文章一向以宣扬所谓“女权”为导向，用一碗一碗的鸡汤，挑动着公号中近600万女性粉丝的内心。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	作为一个影视的门外汉，咪蒙之所以开始进军影视当编剧，其实和中国影视，特别是网台剧当中 “大女主”等题材层出不穷有着直接关系。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	从《欢乐颂》里的五个姐妹，到《我的前半生》里的罗子君，从楚乔到关皮皮，不一而足。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	然而，在这些所谓的“大女主”或者“女权”剧却很少体现真正的女权，而或多或少的会体现出“咪蒙式女权”的感觉。 男一都会对我不离不弃，男二都会生死相依，男三都会“我的眼里只有你的桥段大行其道，靠男人上位的情节也充斥其中，女权成为了寄居在男权上的笑话。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	再有，许多职业剧也会加入大量爱情桥段，“谈判官”改谈恋爱，“猎头”改“猎对象”的情况也多次发生。这也正如咪蒙的风格，看似让人“自强不息”，实则只想让你成为“坐在宝马里笑的人”；看似是在不断激励，实际只是找准了观众的七寸，然后一颗颗的吃下早预备好的“致幻药丸”。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	但这样的剧情虽然满足了女性观众对于爱情内容的需要的同时，本身也局限了内容的发展。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	首先，这样的剧所有内容几乎都必须围绕爱情展开，亲情、职场、宫斗、武侠等本应该更重要的戏份反而成了陪衬。由此，很多所谓的职场剧、宫斗剧到头来都变成了无限尴尬的爱情剧。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	更重要的是，“咪蒙式的女权剧”并不是真正的男女平权，当女性意识进一步觉醒之后，就会开始逐渐摒弃这种价值观。正如《致橡树》中所说，“我如果爱你，绝不学攀援的凌霄花”。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	再次，随着90后以及更年轻观众的崛起，单身才是社会更加主流的形态。生活方式的改变也会影响大家对于影视剧的观看喜好。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	更进一步说，“大女主”实际上是披着女性思维的外衣，但实际上却站在男性立场的表现。女性是白莲花、傻白甜，需要靠男性，甚至众多男性实现目的，这其实是一种变向的“被包养”。托名女权，实际宣扬的却是一种并不合理的价值观。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	咪蒙已经悄然落幕，但“伪女权”却依然大量存在于影视剧之中。但随着品质口碑成为了市场主流，真正的女权影视剧登上舞台恐怕也不会太远了。\r\n</p>',	'doc.png',	1.00,	22,	0,	0,	0,	'2019-12-03 14:21:05',	'admin',	10,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	1.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	3,	1,	0,	1),
(114,	'短视频的彷徨与退让：积蓄力量，正待春暖花开',	'<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	短视频行业的发展无疑已经进入到了深水区，以短视频变现为代表的全新发展正在把这个行业越来越多地放到了市场的前台。作为一种全新的内容表现形式，短视频在经历了资本乱战、巨头追捧之后，或许应该进入这个“年纪”。然而，变现并非易事，短视频变现更是难上加难。如果能够走出短视频变现的考验的泥淖，这个行业的发展无疑将会发展成熟。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	当然，如果仅仅只是一味地追求变现，而不去深究短视频本身的内在运行逻辑。所谓的短视频变现同样会陷入困境，火爆的短视频行业将会如同火爆的流量一样陷入表面的繁华。的确，几乎所有的商业模式都应该形成一个生态闭环，才能称得上是一个成熟的商业模式。如果仅仅只是停留在某个阶段的繁荣，所谓的商业模式仅仅只是一个概念，无法真正落地。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	我们看到当前以抖音、快手为代表的短视频行业巨头都在进行变现层面的探索，无论是社交，还是电商，对于短视频背后更加深层次的商业层面的探索正在成为一种发展的主流。不可否认的是，尽管短视频变现进行得如火如荼，但是依然逃不脱现实的尴尬，短视频行业的变现依然面临诸多挑战。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	从繁荣期到精耕期，短视频行业正在经历阵痛\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	作为一种在移动互联网时代的后半段崛起的内容表现形式，短视频行业的发展无疑备受追捧。无论是资本还是巨头，对于这种新式的内容展现形式都充满了好奇与期待。融资数额的不断增加、融资速度的不断加快都在说明市场对于短视频行业偏好程度。尽管短视频行业从一开始就被互联网巨头所青睐，但是，它的发展依然要经历所有的事物都会经历的阶段。从资本吹捧的繁荣期到商业变现的精耕期，短视频行业的发展无疑正在经历一次全新的阵痛。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	火爆的背后是短视频行业远离商业本质的尴尬。几乎所有的人都知道，短视频行业的发展一直都是一路高歌，无论是从用户获取上，还是用户日常的表现数据上，短视频行业的发展都是相当夺目耀眼。尽管短视频行业看上去异常火爆，但是火爆的背后却是变现困难的尴尬。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	从始至终短视频行业都在扮演着一种流量导流的角色，通过短视频将流量聚集在一起，再通过流量下沉到电商、社群等其他领域，从而实现真正意义上的变现。其实，从流量获取到流量导入已经有了许多的用户流失，再把这些流量落地到具体产品上又会有更多的流量流失。因此，仅仅只是将短视频看成是一个流量导入的工具，而不去从短视频本身着手，直接进行变现正在让短视频行业的发展陷入一种尴尬的境地里。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	当我们看到短视频平台动辄几亿的用户流量的时候，其实无法真正掩盖现实的尴尬。一味地看中短视频本身的流量价值，而忽略了更多新的探索，短视频行业正在陷入一场远离商业本质的尴尬。在流量红利已经见顶的大背景下，一味地去强调短视频行业的流量作用，无疑是一次与现实的抵抗。在流量已经被证明是一种无效资源的大背景下，短视频行业盲目地加大自身在流量上的作用，无疑是一场冒险。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	依附于巨头的怀抱让短视频缺少对于商业世界的认知。作为一种全新的内容展现形式，短视频行业从一开始就依附于互联网巨头。无论是资本投资，还是平台建设上，短视频始终都缺少自己独特的运行模式。虽然以互联网巨头作为靠山能够缓解在竞争激烈的市场当中沦陷的概率，但是如果仅仅只是一味地停留在巨头怀抱的温暖里，不去面对商业世界的残酷，短视频行业依然备受挑战。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	依附于巨头的怀抱，短视频行业仅仅只是一个内容层面的东西，它仅仅只是巨头的附庸，无法真正承担起自我寻找商业价值的重任。当巨头不再加持短视频行业的时候，它同样需要走入市场里，而不是一味地承担一个支撑者的角色。依附于互联网巨头的怀抱，短视频行业仅仅只是停留在表面繁荣的自嗨当中，不断增长的用后数据、不断增长的点赞数量、不断增加的用户浏览时长都让短视频行业感觉到自己是移动互联网后半段的王者。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	作为一种全新的内容展示形式，短视频始终都是一种内容。如果我们仅仅只是停留在巨头光环下的数据自嗨，而不去真正了解这些数据背后的真正原因。那么，当短视频行业真正进入到市场的时候，一切或许都将重新开始。当前，短视频行业正在经历的正是这样一个阶段。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	以内容为根本的短视频却无法具备内容的本质与意义。虽然短视频行业异常火爆，但是我们始终都不能忘记短视频始终都是一种内容表现形式。既然是一种内容，短视频行业从野蛮生长到精耕细作是一个必然的过程。在经历了几年的发展之后，我们却没有看到短视频行业的内容有显著提升的地方，有的仅仅只是在一些营销层面的小打小闹。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	当短视频在内容进化上出现瓶颈的时候，我们就去做商业变现上的相关尝试无疑将会把这个行业的问题和弊端全部都呈现在外面。作为一种内容展现形式，短视频行业在内容本身上缺少精耕细作和突破创新，只会把短视频行业的发展带入到一种相对艰难的境地里。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	我们看到现在的短视频的内容上依然缺少精细化的痕迹，有的仅仅只是千篇一律的雷同抑或是内容展现形式的俗套。如果仅仅只是把短视频行业仅仅停留在一种毫无进化的层面上，特别了缺少了作为内容本身所应该具备的特质，那么所谓的短视频必然将会失去原有的本质与意义。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	在经历了早期的野蛮生长、资本助推、巨头拥抱等一系列的发展之后，短视频行业的发展正在经历一场前所未有的平静期。这从另外一个角度说明短视频行业的发展并未真正跳出原有的发展套路，仅仅只是将互联网式的发展模式在极致上更进一步。突破短视频行业的发展困境，需要真正让短视频告别自嗨式的繁荣，真正回归内容本身，真正进入到商业世界的现实中历练。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	进入下半场的深水区，短视频的彷徨与退让\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	在告别了资本的加持之后，短视频行业的发展正在进入到下半场的深水区。早期的顺风顺水让短视频行业的发展难以抵挡现实的尴尬，一味地停留在数字上的繁荣，而忽略了内容本身的本质奥义，短视频行业的下半场无疑将会经历一场前所未有的彷徨与退让。但是，这并非是一件坏事，通过这种方式，我们增加能够知道短视频本质的东西是什么。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	短视频的彷徨：巨头扶持还是独立行走。短视频从诞生的那一天开始就始终没有摆脱巨头的光环，从某种意义上来讲是互联网巨头最终造就了短视频行业的今天。然而，一味地躲在互联网巨头建构的舒适区里，不去进行商业层面上的探索，所谓的短视频只会在自嗨的道路上越走越远。告别巨头的保护，真正进入到市场当中摸爬滚打，从而获得更多的生存技能或许对于短视频来讲至关重要。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	然而，如果摆脱互联网巨头的怀抱，短视频又很难在短时间内找到一条合适的路，对于处于变现关键期的短视频行业来讲，无疑是一个非常巨大的挑战。始终蜷曲在巨头的怀抱，毕竟不是一件长远的事情，短视频行业的真正未来依然在于本身的发展上。从这个逻辑来看，脱离巨头的怀抱，选择独立行走显然是一件非常明智的事情。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	可喜的是，深度参与到短视频行业发展中的人们早已明白了这其中的意义，我们看到以抖音、快手为代表的短视频平台开始更多地寻找基于自身优势和特色的发展道路，抖音做社交，快手做电商就是这一趋势的直接体现。尽管当下的发展态势不甚明朗，但是只要能够找到一条真正适合自己的发展道路，短视频行业的发展便会真正能够独立。&nbsp;\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	短视频的退让：坚守流量还是回归商业。从当下的发展情况来看，短视频真正吸引人的地方还是它裹挟流量的能力。投资机构和互联网巨头之所以不断加持短视频行业的重要一点同样是因为短视频本身能够在获取流量的成本日渐高企的时刻依然能够持续获得源源不断的流量。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	然而，虽然流量给短视频赢得了鲜花和掌声，但是流量的变现依然是横在短视频头上的达摩克利斯之剑。谈及流量变现就必然要回归到商业本身，如果仅仅只是在流量的海洋里进行无谓的自嗨，所谓的短视频只能是一个充满了美妙幻想的乌托邦，无法真正实现真正意义上的落地。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	是坚守流量还是回归商业，或许在残酷的商业面前，短视频行业将会最终退让，真正演变成为以商业为主导的存在。尽管这个过程会略显艰难，但是这才算是真正回归到了商业本身，而非仅仅只是沉醉在流量的理想国里。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	当短视频市场的繁华落尽，回归商业本质或许是当下正道。告别表面的虚假逻辑，真正把短视频行业的发展落地到具体的商业上，探索一条真正适合商业本质的发展道路，或许才是真正能够推动短视频行业发展正道所在。从这个逻辑上来看，当下短视频行业正在经历的这场彷徨与退让或许更像是在积蓄继续前行的能量。\r\n</p>',	'doc.png',	1.00,	9,	0,	0,	0,	'2019-12-03 14:21:49',	'admin',	14,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	1.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	3,	1,	0,	1),
(115,	'滴滴“官宣”巨亏——是卖惨，还是真难',	'<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	发展会掩盖一切问题，直到狂奔的脚步停下。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	2月15日，滴滴CEO程维对外表示，公司将做好过冬准备，并将对非主业进行“关停并转”，对业务重组带来的岗位重叠和绩效不达标的员工进行减员，整体裁员比例占到全员的15%，将涉及2000人左右。此外，从2012年创业以来一直处于亏损状态的滴滴，2018年仍然亏损，全年亏损总额高达109亿元，其中，补贴司机超过113亿元。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在收购优步中国以后，滴滴在网约车市场一家独大，市场占有率近九成；滴滴是全球融资额最大的未上市公司，一向“不差钱”；滴滴对每笔业务都会收取20%左右的抽成(Take Rate)，这也经常成为网约车司机抱怨甚至炮轰的对象……感觉“躺着就能把钱赚了”的滴滴，为何会如此巨亏？司机喊着不赚钱、平台又巨亏，网约车的问题究竟出在哪里？还有能走得通的商业模式吗？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	成立7年，融资20次，\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	融资额200亿美元\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	和其他公司多是被爆出后被迫承认窘境，或者裁员时只肯使用“优化、调整、末位淘汰”等字眼不同，滴滴主动“官宣”了巨亏和裁员的消息，数字还如此巨大。“地主家也没有余粮了？”“富家子都开始哭穷了？”社交媒体上一时哗然，有人唏嘘，有人不解。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在去年8月滴滴顺风车事件之后，程维也曾对外透露过一次滴滴的财务数据，他表示滴滴成立6年来，还没有实现过盈利，仅仅2018年上半年，公司的整体净亏损就超过40亿元人民币。滴滴出行业务对应的GMV(总交易额)平均Take Rate(抽成率)约为16%，但绝大部分作为补贴和红包返还给了司机和乘客，公司整体对应的GMV毛利率只有1.6%。他还透露，仅2018年上半年，包括司机高峰期补贴、接单和服务奖励、乘客优惠等在内的总补贴返还金额超过117亿元人民币。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	2017年，滴滴也曾透露过补贴总额，高达181亿元(包括司机端和乘客端)。但一些被媒体广泛引用、滴滴官方从未确认也从未辟谣的数据显示，2017年滴滴全年亏损额只有25亿元。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	一位滴滴内部人士告诉《中国经济周刊》记者：“公司虽然巨亏，但现在现金流应该是没问题的。即使一部分员工会面临被裁员，但公司给的补偿方案还是比较厚道的。说滴滴会成为下一个ofo那是不太可能的。”\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	据天眼查的统计数据显示，滴滴自2012年成立以来，截至目前已经完成了20次融资，金额总量超过200亿美元，是全球融资额最大的未上市公司。滴滴的估值也一度高达800亿美金，也是最快达到这个量级的独角兽公司。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	但这只独角兽也甚是烧钱。由于滴滴还不是上市公司，财务数据并不需要全部公开，但根据滴滴已公开的数据统计，滴滴6年来累计亏损额高达近390亿元。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	但上述人士也表示：“在2018年以前，利润和成本在滴滴确实不是重要的考核指标，市场占有率、日单量、用户数量、司机数量……这些才是关注的重点。但2018年开始，公司希望能够在年底冲刺整体盈利，至少实现‘微盈利’，所以对各个业务线也都提出了这样的要求。”\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	其实，这种变化也并不奇怪，因为彼时市场传闻，滴滴将会在2019年下半年实现IPO。但之后由于众所周知的原因，滴滴没能赶上这波上市热潮。“顺风车事件”背后的安全问题让滴滴停下了6年来一路狂奔的脚步。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	一年补贴113亿元，\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	司机感受到了吗？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	补贴仿佛是成就滴滴、也榨干滴滴的一道旋转门，补贴的打法让滴滴熬死了几乎所有竞争对手，并从尸骨堆中走出来，成为今天的滴滴；但现在，补贴似乎也正在熬干滴滴自己。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	与109亿元这个2018年滴滴全年亏损总额一同出现的还有一个数据：2018年滴滴补贴司机超过113亿元，这很容易让人认为两个数字之间有因果关系。但巨额亏损就是源于对司机的补贴吗？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	北京大学市场与网络经济研究中心研究员陈永伟对《中国经济周刊》分析认为，滴滴的亏损应该主要来自为了赢得用户信任和适应更强监管而付出的合规成本。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	陈永伟认为，滴滴的持续亏损主要有两方面的原因。“一是由滴滴本身的战略决定的，它的战略是先占有市场，然后利用规模效应去消化市场。滴滴的主业务是规模报酬递增的，这也决定了滴滴先占市场的模式。二是去年突发事件引发了监管加强，这让滴滴遭受了空前的监管压力，合规成本是巨大的，比如要求司机户口、车辆的轴距大小等。”他说。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	记者采访了几位滴滴司机，他们均表示，并没有觉得去年滴滴对司机的补贴突然增加了。一位滴滴“老司机”告诉记者，不同的司机能够拿到的补贴数量可能差别非常大。因为要想获得比较高的补贴收入并不容易，比如要在线时间长，至少10小时，这意味一定要是全职司机，身体要好还不能怕辛苦；再比如要在高峰时段多接单，也要多接受滴滴的派单，“这些活儿很多是根本不赚钱的，不给补贴，根本不会有人接。”他说。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在乘客端，很多人的感受则是：滴滴的车费越来越贵，但叫车却越来越难。记者对比了市场上最大的几家网约车公司的价格，以北京为例，相同时段和目的地，同档次车型，滴滴快车价格最低，其次是出租车价格，但两者差距已经不大了，相对最高的是易到易达车型的价格。而对于高端车型，滴滴礼橙专车也是最低的，其次是神州专车，首汽约车的价格则更高一些。这些高端车型的价格要高出普通车型50%左右。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在客户竞争层面，网约车平台的竞争无外乎两件事：价格和能否叫到车。而网约车平台要克服的最大难题就是高峰低谷时段的需求差异和城市潮汐效应的供给矛盾。因此，从逻辑上，网约车平台确实需要依赖补贴来调节运力，鼓励高峰时段有更多兼职司机补充运力，鼓励司机反潮汐增加热门地区的运力供给。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	根据中国信息通信研究院政策与经济研究所的调查显示，截至2018年7月，全国合规网约车数量约为17万辆，只占到总量的0.54%，而合规司机数量约为34万，只能占到司机总量的1.1%。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	据滴滴方面介绍，随着各地网约车新政的落地和执行越来越严格，运力不足问题日趋严重。而顺风车下线之后，兼职的网约车司机也大量减少。因此，滴滴为了吸引更多“合规”司机加入，以及运营中调整运力，不断出手补贴。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	滴滴收购ofo的可能性更小了\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	除了裁员，滴滴宣布要“关停并转”非主业的消息也引发了广泛的关注。到底哪些业务是滴滴的“非主业”，截至记者发稿，滴滴官方并未给出回应。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	一位滴滴前高管对《中国经济周刊》分析，对于滴滴“非主业”，很多人会首先想到外卖、酒旅、票务等“创新业务”，这确实可能是此次调整的重点，但应该还至于此，因为这些业务不足以涉及到2000人。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	据记者了解，2018年底，滴滴进行过一次架构调整。调整后，滴滴的主要业务被划为几大板块：网约车平台公司(快车、专车、豪华车事业部)、车主服务公司(小桔车服公司、汽车资产管理中心)、普惠出行与服务事业群(单车、电单车、公交、代驾、企业级业务)、出租车事业部、战略业务事业部(战略部、国际事业部、金融事业部)等。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	上述高管认为，普惠出行与服务事业群的业务也有可能被重点调整，“滴滴再去收购ofo的可能性更小了”。而国际业务和金融业务则会影响不大。“网约车这个生意受政策环境影响太大了，国际化等于给滴滴多设立几个backup，这边不亮可以那边亮，滴滴已经有完整完善的网约车技术和运营解决方案，在各国复制并不难。”他说。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	实际上，滴滴已经通过收购、投资本地出行平台的方式将业务拓展到东南亚、东欧、非洲、巴西、日本、美国、墨西哥、澳大利亚……程维也透露，安全技术、产品和线下司机管理及国际化等是滴滴未来的重点领域。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	陈永伟的看法是，滴滴确实涉足了不少并没有规模效应的行业，如果没有顺风车危机，可能也不会对滴滴带来太大的影响。但在严监管之下，安全合规成本大增，滴滴的顺风车业务还干脆就没了，这也带来商业损失。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	网约车也有赢利的商业模式\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	滴滴这头其实已经达到巨头规模的超级独角兽，至今仍未找到清晰的盈利模式。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	滴滴的设想是希望通过平台聚集大量用户，然后靠打造“出行生态”提供增值服务获得盈利。就像淘宝和微信，用户都可以免费使用，但同样可以赚得盆满钵满。于是，滴滴进行了很多尝试：做广告、做电商、做游戏、卖保险、卖理财、做金融……但这条路，至少现在，滴滴还并没有走通。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	但这并没有影响新选手们的热情。除了神州优车、易到、首汽约车等老运动员，2018年以来，美团、高德、携程、同程、嘀嗒、哈罗等都开始前赴后继地加入网约车混战，希望从滴滴的版图上咬下一块。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	此外，上汽、吉利、大众等在内的主机厂都已经进军网约车市场，宝马也成为首家在中国拿到网约车牌照的跨国品牌，赛道那端虽然通向哪里还不知道，但赛道仍然拥挤。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	虽然滴滴的日子不好过，易到更是彻底凉了，但行业内也有日子过得不错的玩家。比如神州优车，虽然此前也一直亏损，但到2017年，神州优车的亏损已大幅收窄了92.7%，仅亏损2.6亿元。而其2018年经营，截止到当年前三季度，神州优车营收达49.2亿元，利润总额2.8亿元，较上年同期增长149%，已经实现了4个季度的持续盈利。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“这其实也说明了网约车本身没问题，是有商业模式可以走得通的。不过行业发展还是需要政策支持。”陈永伟表示\r\n</p>',	'doc.png',	1.00,	34,	0,	0,	0,	'2019-12-03 14:22:37',	'admin',	26,	1,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	1.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	13,	1,	0,	1),
(116,	'食药监总局：26家企业的27批次中药饮片不合格',	'<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	对于当下环境以及未来发展，马云认为未来充满不确定性，企业家可能是世界上真正把握不确定性的群体，把不确定性变成确定性，很多人做企业是把机会做成灾难，灾难变成机会。真正看清楚，就不会悲观或者乐观，而是去寻找解决方案。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	抱怨和躲避解决不了问题，在危机关头，只有熬过挑战的企业，才有抗体。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	董事长郭广昌也认为今年的冬天有些不一样，他认为经济的确会很困难，这个冬天会非常冷。世界上要有一个救世主，就是市场，但在市场里，我们只能自救。企业家们现在必须要做的一件事，就是反省、是扪心自问：现在我们必须认真想想我们遇到的问题是什么？前五年我们又做了些什么？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	最后他相信中国的市场化程度一定会越来越高，民营企业的营商环境会越来越好。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\"> <strong>马云：熬过挑战的企业才有抗体</strong> \r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	今年，鲁冠球、冯根生、沈爱琴等老一辈浙商相继辞世。马云在演讲中表示，“过去一年，我们一直都在告别，告别了浙商当中开先锋之先，开天辟地的一些人物。在告别的时候我们在想，我们这一代浙商应该从他们身上继承些什么？是传说中浙商的8000亿资本吗？我想我们继承的不是资产，而是在继承和发扬浙商‘敢为天下先’、吃苦耐劳、创新奋斗的精神。”\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	他特别提到了当下的发展环境：\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“我们今天所遇到的困难其实和美国企业当年所经历的困难无法相比，和40年以前浙商面临的改革开放刚开始的困难环境无法相比，今天幸运得多。过去的40年，浙商是在中美合作的关系发展中起来的，<strong>未来的40年，我们浙商要在新型的中美关系中，在国内经济的转型升级当中，找到自己新的位置。</strong>这是挑战，也考验我们浙商的担当，也是浙商的自我升级迭代。这么多年来，浙商做得好，不仅是因为我们会吃苦，而是因为我们会学习，我们会应对变化。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	因为我们很清楚，只有变革才有我们的机会。任何变化，你把它当做灾难的时候，那就越来越不顺眼，当做机会的时候就越看越有意思。在危机关头，能够熬过困难，熬过挑战的企业才有抗体。总是抱怨自己没有遇上好的年代，这样的人永远不可能遇上更好的时代。”\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“经过这一轮的洗礼，能够活下来的企业，活下来的浙商，肯定已经不是过去的浙商，一定是未来的浙商。”马云说，浙商要超越商人，告别野蛮生长的市场，“<strong>今天社会进步，商人不能有钱就要干，而要有所为有所不为，要从商人走向企业家，以国家利益为重，以社会利益为重，以未来为重。</strong>相信大家一起相信未来，看见未来，拥有未来”，希望浙商要依靠家国情怀、责任感和价值取向而闻名世界。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在会上，谈到“风口论”时马云说，当一个还没有成立几天的小公司，就凭着几个故事、几个员工得到了几十亿美金的估值，什么都没有，还嫌少的时候，我们就进入了跨度期，要提前做准备；当一个企业拿自己公司80%的资产质押出去，拿钱去做与自己主业不一样的东西的时候，就要想到问题已经开始了。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	很少有企业能够越做越大、越做越好，因为很多人永远相信“赌博”，永远相信all in。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\"> <strong>郭广昌：这个冬天会非常冷，“过冬”要靠自己</strong> \r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在演讲中，郭广昌针对企业自身、企业创新、企业人才、企业发展四个方面，提了一些需要企业家们扪心自问的问题。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\"> <strong>以下为郭广昌演讲全文：</strong> \r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	今年是改革开放40周年。在过去40年里，我们浙商靠着“四千”精神，吃苦耐劳、不懈努力，应该说一直走得比较顺。前几年，虽然我们每年都说困难、“年年难过”，但实际上还是“年年过”。但这个冬天，我感觉有些不一样。尤其今年很多企业家朋友都出了问题，而且不是小企业，有些企业很不错，甚至是上百亿市值的上市公司。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	我就在想，到底怎么了？刚才陈龙教授也给大家详细说了外部环境的变化，那我们自己呢？这么多年来，我们一直说我们要改变自己，那我们改变了多少呢？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	所以我对现在经济的看法是：\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	第一，经济的确会很困难，这个冬天会非常冷。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	第二，世界上要有一个救世主，就是市场；而在市场里，能救你的只有你自己。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	所幸，党和国家已经很清楚的看到了这些问题和困难，也出台了一系列针对民营企业发展的政策和举措。所以，我判断未来的形势会好一些。但能否度过这个冬天，根本点还在于自己。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	作为我们自己，现在必须要做的一件事，是反省、是扪心自问。我觉得现在我们必须认真想想我们遇到的问题是什么？前五年我们又做了些什么？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	以下这四个问题，是这几年我自己一直在扪心自问的：\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	1、我们要扪心自问，我们到底花了多少时间在客户身上？花了多少时间在了解自己的产品上？花了多少时间在提升产品服务上？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	每个董事长，首先应该是自己公司的首席产品体验官。产品好不好，客户满意不满意？我们自己应该是最了解的。但这种了解绝不能依靠你的喜好和直觉，你需要花更多的时间跟客户去沟通。尤其产品销量不好，市场上又有很多竞争，你就特别需要更用心地体会产品。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	现在，我花时间最多的就是研究产品。经过这段时间的研究，我基本认为要造好产品，方法大致有两种：一种是做平台，但是能做成像阿里、腾讯这样大平台的企业毕竟是少数。第二就是花更多的时间去琢磨怎么做好产品。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	但如果做产品，我必须要强调一点：我们一定要做精品，一定要千锤百炼，一定要为客户创造价值。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	2、我们经常要扪心自问，我们花了多少钱在研发上？花了多少时间在学习新的业态上？花了多少时间去感受新的趋势和方向上？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	我相信，现在大家都很重视移动互联网。但我想问：我们的制造企业，有多少人真正懂得了移动互联网吗？移动互联网只是在淘宝上卖东西吗？马校长已经把阿里这家互联网企业做得这么好，但他还是会花大量的时间在研究线下商业、实体制造。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	所以说，我们千万不能因为取得了成绩，就不学习了。永远只有比别人学得更快，我们才能比别人走得更好、更远。现在客户的需求变化非常快，我们也进入了一个科技研发能快速转化为成果的时代。在这样的时代，技术的进步、产业的进步、市场逻辑的进步，逼着我们要不断学习。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	另一方面，一定要重视科技研发和创新。我们很多出问题的企业，虽然他们的公司已经很大，但总体感觉他们生产的大部分产品还是同质化、低科技的产品，而且他们以前一直是靠低毛利来不断扩大销量。但这个时代变化太快了，很可能你生产出来的不是产品，直接就是库存。所以，现在尤其要用科技创新来引领。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	3、我们要扪心自问，我们花了多少精力在组织升级和人才培养上？我们花了多少精力在引进高级人才上？花了多少精力在年轻人身上？我们有没有在90后、00后身上学到了什么？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	组织、人才，绝对是一家企业最核心的资产。因为所有的事都需要对的人去实现。而且根据市场的发展和变化，我们的组织需要不断升级，企业的人才要不断换仓。我们一定要吸收具备高能级、更在状态、更渴望成功的人。大家都有自己的团队，但我们花了多少精力在团队的升级上？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	我举个例子。复星的狼队这个赛季从英冠踢到了英超。但我突然发觉，英冠虽然踢得好，但是到英超以后，却碰到了很多的问题。为什么？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	因为英超要求我们球员的素质和英冠是不一样的。现在中国经济不管跟美国发生什么，都是一个比较长期且难以解决的问题。但不管怎么解决，中国经济已经在参与全球竞争了，客观上我们已经在踢“世界杯”了。这个时候，你的人才还是停留在原来的状态，不出问题不是很奇怪吗？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	4、最后，我们还要扪心自问：我们到底愿意不愿意慢下来，去做点慢的事情？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	改革开放40年，中国速度是大家津津乐道的，什么都发展得很快。这让我们已经习惯了快。比如我们看到马校长用十几年打造了一个世界级的巨无霸企业，大家都很想去复制他成功的路径。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	但全世界只有一个马云，谁都像他一样，这个世界还了得？所以你要知道，你自己该做什么，你有没有沉下心来做你该做的事？我们很多企业，我对他们做事的风格有一种感觉，就是All in，就是“赌”。这个“赌”不是说去赌场，而是说做企业很有“赌”性。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	之前的40年，因为整个市场在发展，一俊遮百丑，你很大概率赌成功了。但你千万不能把经济的大势当作你自己的能力，如果市场不好了，会怎么样？All in一下会很爽，但之后呢？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	我相信我们真的要沉下心，做对的事情，做难的事情，做需要时间积累的事情。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	当然，讲了这么多困难和问题之后，我还是对未来始终充满信心：\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	我坚定地相信，中国的市场化程度一定会越来越高，我们民营企业的营商环境会越来越好。包括我相信，不久的将来一定会减税，以降低企业的成本、激发企业活力。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	我坚定地相信，中国的企业家，尤其浙商，都非常能吃苦，只要我们真的加大创新，我们的未来会得到更多的发展。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	我坚定地相信，我们一定会融入全球。对于我们来说，尤其浙商，这是未来我们重要的方向。我们浙商不害怕去全球竞争，在越来越开放、越规范的市场，在全球化的融合中，全球浙商只会越来越好。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	这就像中国足球一样。中国足球要踢世界杯，只有让我们球员去全球踢球，才能得到真正的锻炼，而不只是在中超拿高工资。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	我坚定地相信，我们浙商有这份期望，我们浙商有这份能力，让我们一起努力。\r\n</p>',	'doc.png',	1.00,	25,	0,	0,	0,	'2019-12-26 09:37:40',	'admin',	71,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	1.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	10,	1,	0,	1),
(117,	'北京前8月追回外逃人员25人 追回赃款433万元',	'<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	2015年，随着抢眼的小黄车突现北大校园，共享单车的概念迅速被普及，玩家接连冒头，巨额投资不断涌入，和高铁、移动支付、网购齐名<strong>“新四大发明”</strong>。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	热潮来得快，去得更快。今年，共享单车就进入了寒冬。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	4月，<strong>摩拜单车委身美团；小黄车ofo也节节败退，危机重重</strong>：海外业务全面收缩，并推出了多种激进的变现手段：公众号推送广告，将用户的押金与理财产品绑定，一再延迟押金退还期限。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	去年还大把烧钱的共享单车，转眼就凉凉了。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	共享单车出海遇阻，基础建设和政策规范是难以忽略的两大阻力。除了中国，世界上很难找到一个足够大的市场来支撑共享单车的盈利模式。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	但印度的创业者似乎有不同想法。<strong>从2017年开始，有近十年共享单车公司陆续出现，并先后拿到融资。</strong> \r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	班加罗尔的Yulu向Blume Ventures等投资者筹得资金，还获得Flipkart联合创始人Binny Bansal和谷歌前副总裁Amit Singhal的支持；另一家公司Bounce从红杉印度等投资者那里拿到了了总计1520万美元的资金；总部位于古尔冈的Mobycy去年12月也筹集了50万美元的种子资金。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\"> <strong>印度的共享单车市场正生机勃勃。</strong> \r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\"> <strong>融资热潮</strong> \r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	Amit Gupta是印度第一家独角兽Inmobi的联合创始人。在他创业十年、担任总裁级别职务的时候，他选择了急流勇退，<strong>创办了另一家公司，Yulu单车</strong>。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在班加罗尔地铁站和商务CBD附近，亮蓝色的Yulu单车随处可见。Amit告诉\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	志象网\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	，做共享单车，是为了<strong>“间接降低污染”</strong>。他出生和长大在印度北部的小城坎普尔，在今年6月被世界卫生组织盖章“全球污染最严重城市”，谈起家乡，他显得情绪激动。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	Yulu单车在前半个小时仅收费10卢比<strong>（约一元）</strong>，之后每半小时多收5卢比。用户下载Yulu应用扫码开车，结束骑行之后，需要将车子停放在离目的地最近的停车区。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	业内人士估计，印度的共享单车市场目前规模达12亿美元。<strong>主要的玩家除了Yulu，还有共享汽车公司Zoomca旗下的Pedl，Mobycy，Bounce和以及来自中国的摩拜单车。</strong> \r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“这个行业很有前景并且有利可图，Ola和Uber的成功证明了交通出行跟手机有可能同步发展。”Blume Ventures的投资人Sajith Pai对志象网说。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	最近入局的玩家是<strong>从踏板车共享起家的Bounce</strong>。今年6月，ofo退出印度市场，Bounce最近宣布收购了它在印度的资产。在收购之前，Bounce在就班加罗尔投放了500辆踏板车。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“从公交站或地铁站到办公室和家里的最后一英里的交通非常令人头疼，没有任何三轮车或出租车愿意走这么短的距离。”Bounce联合创始人Vivekananda HR告诉志象网。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“我们从ofo手中收购的自行车也将加入试点。”他说，45到60天内Bounce的应用将支持扫码使用单车。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	印度创业者从中国公司继承的，不仅是败局留下的遗产，还有先见之明的运营管理教训。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在浦那和班加罗尔，小蓝车Yulu和小绿车Pedl随处可见。一开始，用户可以把车停在任何地方，甚至是在路中间，引起了交通失序。Yulu不得已派出团队去搬运自行车并停放在适当的地方。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	这样一来，成本太高难以为继，Yulu吸取了教训，开始联合Pedl与当地政府合作，规划指定的停车区域。在班加罗尔，这样的停车区现在有500个，在全部的4个城市总数超过1000个。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\"> <strong>纠结的用户体验</strong> \r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	但也有的问题无法靠“继承”来解决，<strong>比如技术和运营失误</strong>。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在印度，<strong>共享单车的用户体验仍有待改善</strong>。志象网记者的亲身体验以及和其他用户交流后发现，包括刹车失灵、智能锁失灵、轮胎漏气等现象并不少见，而且停车区的分布也不够密集，有时候用户甚至需要在锁车之后再走一公里到目的地。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	Vivek Kumar是一名22岁的软件工程师，他最近刚从德里搬到了班加罗尔。刚到班加罗尔时，他一直骑着共享单车穿梭在城市中参加面试。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	一次去面试的路上，他发现单车的链条断了，这就十分尴尬了：他必须得先把车子停到指定的停车区域，否则软件会一直计费。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“我不得不把车子推到500米外的Pedl停车站，在锁这个坏车的时候又花了好多时间。”Kumar告诉志象网。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	但事实上，Yulu和Pedl也都有专人在维护单车，每隔四天维护一次，从而保持单车的良好运行状态。但Amit说，当公司进入一个区域时，维护的情况会不太稳定，“因为当地业务还没有完全稳定。”\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“在那些旧的区域，你会发现我们的自行车状况良好，大多数都能够很好运行。最近我们在电子城附近布局，那里聚集了一批大型IT公司，比如Infosys、Wipro等。我们需要四到六周的时间来完成布局。”Amit说。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	但相较中国，<strong>印度的交通基础设施普遍落后，这也给共享单车埋了一颗暗雷</strong>。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在印度，没有几个城市设置了自行车道；不像中国，骑行已经发展为一种健康、前卫的生活方式，印度的自行车还往往被视为穷人的通勤方式。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“我们之所以进入共享单车行业，是因为我们想成为一家多渠道出行平台。城市交通一直是政府和公民共同面临的挑战，我们希望能够大规模地解决这一问题并帮助完善基础设施建设。”Pedl运营增长部门负责人Rakshak N说。\r\n	</p>',	'doc.png',	0.00,	34,	0,	0,	1,	'2019-11-26 09:37:47',	'admin',	119,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	0.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	13,	1,	0,	1),
(118,	'北京市公安局延庆分局刑侦支队长赵琳飞被查',	'<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	互联网瞬息即变，互联网上的热点也是转变地相当的快，一个热点可能过了几天就不再有人关注了。这对于想凭借互联网走红的人或物来说，显然要付出更多的心血来维持热度。那么，各个引流渠道显然都在他们的考虑范围之内。对于商家而言，在互联网进行引流的最终目的不外乎都是卖货变现。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	因此，一些比较重要的引流渠道，都少不了商家们的身影；比如，。抖音作为2019年的平台，有着3.2亿日活跃用户，属于是自带。如今，抖音与微信、微博等巨大流量池并称，绝对是商家不容错过的流量池。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	商家在抖音平台上发布内容之后，就能通过发布内容来吸引用户前来关注，并进一步转化为粉丝，这样就能更方便商家引流变现。在抖音只能是通过发布优质内容来吸引用户关注，因为抖音采用的是智能社交推荐机制，只要发布的视频内容有趣，也可以获得大量的曝光。这就决定了粗制滥造的视频所获得的曝光量很少。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;text-align:center;\"=\"\"> <img src=\"http://demoall.adashuo.com/20090/uploads/allimg/c191107/15I0c2FD630-1E14.jpg\" width=\"450\" height=\"270\" border=\"0\" alt=\"抖音多闪培训：如何通过抖音进行带货-第1张图片-小七抖音培训\" title=\"抖音多闪培训：如何通过抖音进行带货-第1张图片-小七抖音培训\" style=\"height:270px;width:450px;\" /> \r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	因此，想要在抖音平台上获得大量的曝光，最简单的办法就是制作高质量的视频内容。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	拥有曝光，并不代表着是结束。恰恰相反，这只是开始，因为接下来的工作就是要引流变现了。目前，通过抖音引流的方式无非就只有这么几种：一是在视频内提及联系方式；二是在评论中回复；三是在私信回复等。但是，这几种引流方式都存在着被抖音删除、乃至封禁的风险。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	抖音多闪培训那么，到底有没有什么引流方式是没有风险的呢？或者换言之，有什么引流方式是抖音官方认可的呢？当然有!那就是抖音的电话拨打组件。这是抖音官方所推出的转化组件，经过设置就可以在抖音主页上展示，只要用户点击\"联系方式\"这个按钮就可以跳转至电话拨号界面，并显示相关号码，这无疑对商家引流变现提供了很大的便利。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	但比较遗憾的是，目前，这个功能并没有对所有的用户开放，只有认证了抖音企业蓝v号的用户才可以设置该功能。所以，商家如果是想开通\"电话拨打组件\"的功能，需要先开通抖音蓝v。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	抖音蓝v认证的申请流程如下：\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	第一，用需要认证蓝v的抖音账号登录抖音蓝v认证官网https://renzheng.douyin.com/。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	第二，填写企业认证公函，具体情况可以参考抖音官方的企业认证公函填写模板。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;text-align:center;\"=\"\"> <img src=\"http://demoall.adashuo.com/20090/uploads/allimg/c191107/15I0c2G0040-2J03.jpg\" width=\"450\" height=\"447\" border=\"0\" alt=\"抖音多闪培训：如何通过抖音进行带货-第2张图片-小七抖音培训\" title=\"抖音多闪培训：如何通过抖音进行带货-第2张图片-小七抖音培训\" style=\"height:447px;width:450px;\" /> \r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	第三，填写并提交认证资料，然后填写邀请码123456\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	第四，支付认证审核费用600元即可完成蓝v认证申请的提交。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	需要注意的是，抖音蓝v认证有部分禁入行业及需要额外提供认证资质证明的行业。禁入行业认证抖音蓝v将做认证失败处理。而需要额外提供认证资质证明的，如果碰巧没有，那么在提交认证申请后的30天内仍没有补充提交资质证明，也会当认证失败处理。而认证抖音蓝v失败，是不会进行退款的。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	认证抖音蓝v之后，除了可以获得电话拨打组件，还可以获得同步认证今日头条和、官网链接、商家页面、店铺POI地址、粉丝画像等蓝v权益。可以为天猫、淘宝、京东店铺以及线下店铺引流，构建企业商家的营销阵地，完成变现的目的。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;text-align:center;\"=\"\"> <img src=\"http://demoall.adashuo.com/20090/uploads/allimg/c191107/15I0c2G35440-31260.jpg\" width=\"450\" height=\"261\" border=\"0\" alt=\"抖音多闪培训：如何通过抖音进行带货-第3张图片-小七抖音培训\" title=\"抖音多闪培训：如何通过抖音进行带货-第3张图片-小七抖音培训\" style=\"height:261px;width:450px;\" /> \r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	抖音多闪培训因此，有意认证抖音蓝v的商家，最好是通过抖音蓝v认证代理商进行认证。\r\n</p>',	'doc.png',	0.00,	5,	0,	0,	0,	'2019-12-03 14:04:12',	'admin',	5,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	0.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	4,	1,	0,	1),
(119,	'日本神钢被曝造假 江西退运一批日本进口设备',	'<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	众所周知，2017年至2018年，的大和商业价值日益凸显，各大机构纷纷注资抢占短视频市场，作为短视频流量增速最快的APP，其运营模式和商业市场更是备受关注。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	大数据，帮你快速打造抖音爆款\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	抖音作为新媒体的新洼地，虽然流量又达到一个新的峰值，但是入场抖音仍然是可以。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	而想在抖音机制中脱颖而出，关注的焦点更倾向于生产抖音内容的速度和质量，以及如何持续生产高质量的抖音内容。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	对于运营抖音而言，此时入场抖音阵地，更需要把控时间成本和运营方法。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	结合抖音大数据工具——西瓜短视频助手，在内容层面，可以在6小时内寻找到抖音视频爆款素材，结合热门迅速掌握抖音平台爆款元素，从而有效提升抖音成本。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	在领域定位上，可以根据榜单快速规划的运营方向，结合行业粉丝画像信息，进一步完善垂直领域差异化内容布局。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	抖音进阶创作技巧，及商业运作模式\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;text-align:center;\"=\"\"> <img src=\"http://demoall.adashuo.com/20090/uploads/allimg/c191107/15I0c2AcO0-53929.jpg\" width=\"450\" height=\"303\" border=\"0\" alt=\"抖音小店：抖音运营怎么进行流量变现-第1张图片-小七抖音培训\" title=\"抖音小店：抖音运营怎么进行流量变现-第1张图片-小七抖音培训\" style=\"height:303px;width:450px;\" /> \r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	根据对MCN机构平台发展中遇到各种情况，给现场的运营者和MCN机构提出以下3个方面建议：\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	1.稳扎稳打才是抖音号的运营之道\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	面对网络上出现的买粉刷量的现象，建议运营者和机构千万不要尝试。这样的行为，不仅影响抖音号的权重，也让后续陷入无效价值中。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	2.快速孵化KOL矩阵离不开内容运营\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	抖音小店面对快速内容运营的有效方法，也给出一些信息流量的操作模式，在信息的展示上，可以扩大挖掘地域，可以引入外国小众优质的平台信息资源，将优质内容分类整理成“剧本”分发旗下艺人进行高效运作，提升视频输出效率。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	3.强强合作是商业运作成型的有效方法\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	相比知识付费，广告和电商是抖音目前最有效的转化之一。在广告投放上，同MCN专业机构合作，会更有效的提升个人抖音号的商业价值转化能力。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	如何高格局快速转战短视频领域构建生态链\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	如何一手打造“从内容生产-IP孵化-推广产业化”短视频生态蓝图？\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;text-align:center;\"=\"\"> <img src=\"http://demoall.adashuo.com/20090/uploads/allimg/c191107/15I0c2B323F-B363.jpg\" width=\"450\" height=\"307\" border=\"0\" alt=\"抖音小店：抖音运营怎么进行流量变现-第2张图片-小七抖音培训\" title=\"抖音小店：抖音运营怎么进行流量变现-第2张图片-小七抖音培训\" style=\"height:307px;width:450px;\" /> \r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	a.建立完善的孵化流程。在常规签约流程上，增加达人定位分析和视频测试环节（颜值/技能/学习），保障达人较高的素质水平。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	b.专注用户市场资源。在媒体领域商业形式取决于上游形态，运营的方向取决于市场用户的需求，只有想明白定位，才能做清楚你的市场。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	c.专业商业变现评估。需要对行业的天花板有一定认知，对不具有的抖音大号，可以根据粉丝画像的年龄层，选择不同的市场的推广模式。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	最后，规范机构的商业合作模式，才能快速有效构建自己的商业帝国。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	网红大咖粉丝运营之道\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	抖音IP的成长过程3个关键点：\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	1、找准平台：分析各个平台的商业价值和受众群体，有效预估平台的价值的上升空间。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;text-align:center;\"=\"\"> <img src=\"http://demoall.adashuo.com/20090/uploads/allimg/c191107/15I0c2BC510-L234.jpg\" width=\"450\" height=\"303\" border=\"0\" alt=\"抖音小店：抖音运营怎么进行流量变现-第3张图片-小七抖音培训\" title=\"抖音小店：抖音运营怎么进行流量变现-第3张图片-小七抖音培训\" style=\"height:303px;width:450px;\" /> \r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	2.优质内容：视频种类，视频的风格，人设的塑造，再到更高层次基调定位，都是优质内容的保障。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	3.抓准用户心理：内容的输出上需要抓取社会的认同感，有共鸣的内容通常都可以引发用户的依赖性，可以在内容上找到归属感。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	抖音小店其次，需要制造亲切感，打造个舒服是场景内容更容易获取用户关注。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	最后，就是从心理学的角度出发，恰到好处运粉丝的独纵心理和占便宜的心态。\r\n	</p>',	'doc.png',	1.00,	27,	0,	0,	0,	'2019-12-03 14:07:30',	'admin',	3,	5,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	1.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	11,	1,	0,	1),
(120,	'安徽4市人大政府政协将换届 省委派出考察组',	'<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	对于当下环境以及未来发展，马云认为未来充满不确定性，企业家可能是世界上真正把握不确定性的群体，把不确定性变成确定性，很多人做企业是把机会做成灾难，灾难变成机会。真正看清楚，就不会悲观或者乐观，而是去寻找解决方案。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	抱怨和躲避解决不了问题，在危机关头，只有熬过挑战的企业，才有抗体。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	董事长郭广昌也认为今年的冬天有些不一样，他认为经济的确会很困难，这个冬天会非常冷。世界上要有一个救世主，就是市场，但在市场里，我们只能自救。企业家们现在必须要做的一件事，就是反省、是扪心自问：现在我们必须认真想想我们遇到的问题是什么？前五年我们又做了些什么？\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	最后他相信中国的市场化程度一定会越来越高，民营企业的营商环境会越来越好。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	<strong>马云：熬过挑战的企业才有抗体</strong>\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	今年，鲁冠球、冯根生、沈爱琴等老一辈浙商相继辞世。马云在演讲中表示，“过去一年，我们一直都在告别，告别了浙商当中开先锋之先，开天辟地的一些人物。在告别的时候我们在想，我们这一代浙商应该从他们身上继承些什么？是传说中浙商的8000亿资本吗？我想我们继承的不是资产，而是在继承和发扬浙商‘敢为天下先’、吃苦耐劳、创新奋斗的精神。”\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	他特别提到了当下的发展环境：\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	“我们今天所遇到的困难其实和美国企业当年所经历的困难无法相比，和40年以前浙商面临的改革开放刚开始的困难环境无法相比，今天幸运得多。过去的40年，浙商是在中美合作的关系发展中起来的，<strong>未来的40年，我们浙商要在新型的中美关系中，在国内经济的转型升级当中，找到自己新的位置。</strong>这是挑战，也考验我们浙商的担当，也是浙商的自我升级迭代。这么多年来，浙商做得好，不仅是因为我们会吃苦，而是因为我们会学习，我们会应对变化。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	因为我们很清楚，只有变革才有我们的机会。任何变化，你把它当做灾难的时候，那就越来越不顺眼，当做机会的时候就越看越有意思。在危机关头，能够熬过困难，熬过挑战的企业才有抗体。总是抱怨自己没有遇上好的年代，这样的人永远不可能遇上更好的时代。”\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	“经过这一轮的洗礼，能够活下来的企业，活下来的浙商，肯定已经不是过去的浙商，一定是未来的浙商。”马云说，浙商要超越商人，告别野蛮生长的市场，“<strong>今天社会进步，商人不能有钱就要干，而要有所为有所不为，要从商人走向企业家，以国家利益为重，以社会利益为重，以未来为重。</strong>相信大家一起相信未来，看见未来，拥有未来”，希望浙商要依靠家国情怀、责任感和价值取向而闻名世界。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	在会上，谈到“风口论”时马云说，当一个还没有成立几天的小公司，就凭着几个故事、几个员工得到了几十亿美金的估值，什么都没有，还嫌少的时候，我们就进入了跨度期，要提前做准备；当一个企业拿自己公司80%的资产质押出去，拿钱去做与自己主业不一样的东西的时候，就要想到问题已经开始了。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	很少有企业能够越做越大、越做越好，因为很多人永远相信“赌博”，永远相信all in。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	<strong>郭广昌：这个冬天会非常冷，“过冬”要靠自己</strong>\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	在演讲中，郭广昌针对企业自身、企业创新、企业人才、企业发展四个方面，提了一些需要企业家们扪心自问的问题。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	<strong>以下为郭广昌演讲全文：</strong>\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	今年是改革开放40周年。在过去40年里，我们浙商靠着“四千”精神，吃苦耐劳、不懈努力，应该说一直走得比较顺。前几年，虽然我们每年都说困难、“年年难过”，但实际上还是“年年过”。但这个冬天，我感觉有些不一样。尤其今年很多企业家朋友都出了问题，而且不是小企业，有些企业很不错，甚至是上百亿市值的上市公司。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	我就在想，到底怎么了？刚才陈龙教授也给大家详细说了外部环境的变化，那我们自己呢？这么多年来，我们一直说我们要改变自己，那我们改变了多少呢？\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	所以我对现在经济的看法是：\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	第一，经济的确会很困难，这个冬天会非常冷。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	第二，世界上要有一个救世主，就是市场；而在市场里，能救你的只有你自己。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	所幸，党和国家已经很清楚的看到了这些问题和困难，也出台了一系列针对民营企业发展的政策和举措。所以，我判断未来的形势会好一些。但能否度过这个冬天，根本点还在于自己。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	作为我们自己，现在必须要做的一件事，是反省、是扪心自问。我觉得现在我们必须认真想想我们遇到的问题是什么？前五年我们又做了些什么？\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	以下这四个问题，是这几年我自己一直在扪心自问的：\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	1、我们要扪心自问，我们到底花了多少时间在客户身上？花了多少时间在了解自己的产品上？花了多少时间在提升产品服务上？\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	每个董事长，首先应该是自己公司的首席产品体验官。产品好不好，客户满意不满意？我们自己应该是最了解的。但这种了解绝不能依靠你的喜好和直觉，你需要花更多的时间跟客户去沟通。尤其产品销量不好，市场上又有很多竞争，你就特别需要更用心地体会产品。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	现在，我花时间最多的就是研究产品。经过这段时间的研究，我基本认为要造好产品，方法大致有两种：一种是做平台，但是能做成像阿里、腾讯这样大平台的企业毕竟是少数。第二就是花更多的时间去琢磨怎么做好产品。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	但如果做产品，我必须要强调一点：我们一定要做精品，一定要千锤百炼，一定要为客户创造价值。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	2、我们经常要扪心自问，我们花了多少钱在研发上？花了多少时间在学习新的业态上？花了多少时间去感受新的趋势和方向上？\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	我相信，现在大家都很重视移动互联网。但我想问：我们的制造企业，有多少人真正懂得了移动互联网吗？移动互联网只是在淘宝上卖东西吗？马校长已经把阿里这家互联网企业做得这么好，但他还是会花大量的时间在研究线下商业、实体制造。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	所以说，我们千万不能因为取得了成绩，就不学习了。永远只有比别人学得更快，我们才能比别人走得更好、更远。现在客户的需求变化非常快，我们也进入了一个科技研发能快速转化为成果的时代。在这样的时代，技术的进步、产业的进步、市场逻辑的进步，逼着我们要不断学习。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	另一方面，一定要重视科技研发和创新。我们很多出问题的企业，虽然他们的公司已经很大，但总体感觉他们生产的大部分产品还是同质化、低科技的产品，而且他们以前一直是靠低毛利来不断扩大销量。但这个时代变化太快了，很可能你生产出来的不是产品，直接就是库存。所以，现在尤其要用科技创新来引领。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	3、我们要扪心自问，我们花了多少精力在组织升级和人才培养上？我们花了多少精力在引进高级人才上？花了多少精力在年轻人身上？我们有没有在90后、00后身上学到了什么？\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	组织、人才，绝对是一家企业最核心的资产。因为所有的事都需要对的人去实现。而且根据市场的发展和变化，我们的组织需要不断升级，企业的人才要不断换仓。我们一定要吸收具备高能级、更在状态、更渴望成功的人。大家都有自己的团队，但我们花了多少精力在团队的升级上？\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	我举个例子。复星的狼队这个赛季从英冠踢到了英超。但我突然发觉，英冠虽然踢得好，但是到英超以后，却碰到了很多的问题。为什么？\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	因为英超要求我们球员的素质和英冠是不一样的。现在中国经济不管跟美国发生什么，都是一个比较长期且难以解决的问题。但不管怎么解决，中国经济已经在参与全球竞争了，客观上我们已经在踢“世界杯”了。这个时候，你的人才还是停留在原来的状态，不出问题不是很奇怪吗？\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	4、最后，我们还要扪心自问：我们到底愿意不愿意慢下来，去做点慢的事情？\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	改革开放40年，中国速度是大家津津乐道的，什么都发展得很快。这让我们已经习惯了快。比如我们看到马校长用十几年打造了一个世界级的巨无霸企业，大家都很想去复制他成功的路径。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	但全世界只有一个马云，谁都像他一样，这个世界还了得？所以你要知道，你自己该做什么，你有没有沉下心来做你该做的事？我们很多企业，我对他们做事的风格有一种感觉，就是All in，就是“赌”。这个“赌”不是说去赌场，而是说做企业很有“赌”性。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	之前的40年，因为整个市场在发展，一俊遮百丑，你很大概率赌成功了。但你千万不能把经济的大势当作你自己的能力，如果市场不好了，会怎么样？All in一下会很爽，但之后呢？\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	我相信我们真的要沉下心，做对的事情，做难的事情，做需要时间积累的事情。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	当然，讲了这么多困难和问题之后，我还是对未来始终充满信心：\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	我坚定地相信，中国的市场化程度一定会越来越高，我们民营企业的营商环境会越来越好。包括我相信，不久的将来一定会减税，以降低企业的成本、激发企业活力。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	我坚定地相信，中国的企业家，尤其浙商，都非常能吃苦，只要我们真的加大创新，我们的未来会得到更多的发展。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	我坚定地相信，我们一定会融入全球。对于我们来说，尤其浙商，这是未来我们重要的方向。我们浙商不害怕去全球竞争，在越来越开放、越规范的市场，在全球化的融合中，全球浙商只会越来越好。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	这就像中国足球一样。中国足球要踢世界杯，只有让我们球员去全球踢球，才能得到真正的锻炼，而不只是在中超拿高工资。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	我坚定地相信，我们浙商有这份期望，我们浙商有这份能力，让我们一起努力。\r\n</p>',	'doc.png',	1.00,	1,	0,	0,	0,	'2019-12-26 09:37:40',	'admin',	71,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	1.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	3,	1,	0,	1),
(121,	'神吐槽:再让炮带就进季后赛了!管理层坐不住了',	'<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	带火了很多“爆款”产品，这些品牌和产品的销量大增，引得很多企业和品牌方们分外眼红。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	在这个为王的时代，早已成为了一个所有新媒体人无法避开的平台。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	抖音火遍大江南北，同时有无限的流量产生。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	大家撸粉的撸粉，变现的变现。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	但是现在越来越难了，\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;text-align:center;\"=\"\"> <img src=\"http://demoall.adashuo.com/20090/uploads/allimg/c191107/15I0c26340L0-1F53.jpg\" width=\"450\" height=\"198\" border=\"0\" alt=\"抖音运营团队：抖音运营思维攻略-第1张图片-小七抖音培训\" title=\"抖音运营团队：抖音运营思维攻略-第1张图片-小七抖音培训\" style=\"height:198px;width:450px;\" /> \r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	为什么？\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	竞争大呗！\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	团队拿到更好的权重才能有更多的曝光，才有上的机会。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	怎么拿到更多的曝光权重呢？\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	俗话说：知己知彼，百战不殆！\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	那我就先来了解一下抖音的排名算法是什么？\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	首先你要输出优质的内容，\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;text-align:center;\"=\"\"> <img src=\"http://demoall.adashuo.com/20090/uploads/allimg/c191107/15I0c263G60-26058.jpg\" width=\"450\" height=\"195\" border=\"0\" alt=\"抖音运营团队：抖音运营思维攻略-第2张图片-小七抖音培训\" title=\"抖音运营团队：抖音运营思维攻略-第2张图片-小七抖音培训\" style=\"height:195px;width:450px;\" /> \r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	关于内容今天就不讲了，本期讲的是抖音运营思维攻略。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	一、熟悉抖音\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	抖音运营团队熟悉抖音账号注册、认证、定位、布局、防封号/、最受欢迎内容等。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;text-align:center;\"=\"\"> <img src=\"http://demoall.adashuo.com/20090/uploads/allimg/c191107/15I0c26406150-31H2.jpg\" width=\"450\" height=\"266\" border=\"0\" alt=\"抖音运营团队：抖音运营思维攻略-第3张图片-小七抖音培训\" title=\"抖音运营团队：抖音运营思维攻略-第3张图片-小七抖音培训\" style=\"height:266px;width:450px;\" /> \r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	二、选题\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	1.选题的原则：关联性、热门性、新鲜感、人设感\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	2.选题来源：可从时事、同行火爆视频分析、段子、微博等渠道入手\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	3.拍摄及剧本套路\r\n</p>',	'doc.png',	1.00,	26,	0,	0,	0,	'2019-12-03 14:08:06',	'admin',	10,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	1.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	11,	1,	0,	1),
(122,	'詹皇:11年总决我失去对篮球热爱 曝勒夫渴望联手甜瓜',	'<p style=\"color:#333333;font-family:&quot;font-size:16px;background-color:#FFFFFF;\">\r\n	怎么在做？ &nbsp;借助商品橱窗和购物车，电商新物种——抖商蓬勃发展，但作为以算法推荐分发的平台，抖音缺少社交基因，那么抖音就注定与社交电商无缘吗？ &nbsp;\r\n</p>\r\n<p style=\"color:#333333;font-family:&quot;font-size:16px;background-color:#FFFFFF;\">\r\n	社交对电商有何价值？ &nbsp;\r\n</p>\r\n<p style=\"color:#333333;font-family:&quot;font-size:16px;background-color:#FFFFFF;\">\r\n	社交电商是相对于传统电商的概念——社交本身自带去中心化属性，由此延伸出来两个特征：裂变与私域流量。 &nbsp;\r\n</p>\r\n<p style=\"color:#333333;font-family:&quot;font-size:16px;background-color:#FFFFFF;\">\r\n	裂变来源于社交背后的人脉关系，不仅转化率远高于传统电商，更是能基于信任进行快速传播，也就是裂变获客； &nbsp;\r\n</p>\r\n<p style=\"color:#333333;font-family:&quot;font-size:16px;background-color:#FFFFFF;\">\r\n	而私域流量于商家不仅意味着跳出平台限制自主营销获客，私域流量还具有免费、优质、高黏性、可重复转化的属性。\r\n</p>\r\n<p style=\"color:#333333;font-family:&quot;font-size:16px;background-color:#FFFFFF;text-align:center;\">\r\n	<img src=\"http://demoall.adashuo.com/20090/uploads/allimg/c191107/15I0c25W3510-551O.png\" width=\"450\" height=\"328\" border=\"0\" alt=\"抖商研习社：如何在抖音做社交电商？-第1张图片-小七抖音培训\" title=\"抖商研习社：如何在抖音做社交电商？-第1张图片-小七抖音培训\" style=\"height:328px;width:450px;\" />&nbsp;&nbsp;\r\n</p>\r\n<p style=\"color:#333333;font-family:&quot;font-size:16px;background-color:#FFFFFF;\">\r\n	抖音也能做社交电商吗？ &nbsp;\r\n</p>\r\n<p style=\"color:#333333;font-family:&quot;font-size:16px;background-color:#FFFFFF;\">\r\n	1、社交土壤 &nbsp;\r\n</p>\r\n<p style=\"color:#333333;font-family:&quot;font-size:16px;background-color:#FFFFFF;\">\r\n	抖商研习社需要指出的是，抖音虽然并非社交产品，但有人的地方就有社交——抖音好友与好友间、粉丝与红人间都有着浓厚的社交氛围，只不过抖音是以陌生人关系链组成的社交平台。 &nbsp;\r\n</p>\r\n<p style=\"color:#333333;font-family:&quot;font-size:16px;background-color:#FFFFFF;\">\r\n	同时抖音庞大且优质的用户群——以18-28年龄为主，多分布于一二线城市，且女性占比超过60%——配合内容的高传达效率，使得社交裂变有了肥沃的用户土壤。 &nbsp;\r\n</p>\r\n<p style=\"color:#333333;font-family:&quot;font-size:16px;background-color:#FFFFFF;\">\r\n	2、裂变载体 &nbsp;\r\n</p>\r\n<p style=\"color:#333333;font-family:&quot;font-size:16px;background-color:#FFFFFF;\">\r\n	裂变的前提是有足够的用户基础——背靠抖音数亿活跃用户池，好的视频依托推荐算法，及话题、热榜、群聊等流量分发入口，能迅速成为爆款，进而触达更多潜在用户。 &nbsp;\r\n</p>\r\n<p style=\"color:#333333;font-family:&quot;font-size:16px;background-color:#FFFFFF;\">\r\n	裂变的关键在二次分享，而商品橱窗与购物车并没有相匹配的能力，这就需要借助抖音小程序了：除了可以驱动用户“”挂载小程序二次传播外，小程序的营销插件也自带裂变能力，进而打通裂变的闭环。 &nbsp;\r\n</p>\r\n<p style=\"color:#333333;font-family:&quot;font-size:16px;background-color:#FFFFFF;\">\r\n	怎么裂变起来？ &nbsp;\r\n</p>\r\n<p style=\"color:#333333;font-family:&quot;font-size:16px;background-color:#FFFFFF;text-align:center;\">\r\n	<img src=\"http://demoall.adashuo.com/20090/uploads/allimg/c191107/15I0c2593MP-E412.png\" width=\"450\" height=\"331\" border=\"0\" alt=\"抖商研习社：如何在抖音做社交电商？-第2张图片-小七抖音培训\" title=\"抖商研习社：如何在抖音做社交电商？-第2张图片-小七抖音培训\" style=\"height:331px;width:450px;\" />\r\n</p>\r\n<p style=\"color:#333333;font-family:&quot;font-size:16px;background-color:#FFFFFF;\">\r\n	1、爆款视频引流 &nbsp;\r\n</p>\r\n<p style=\"color:#333333;font-family:&quot;font-size:16px;background-color:#FFFFFF;\">\r\n	抖音卖货的基本逻辑是爆款短视频引流+小程序交易，而爆款视频主要取决于算法推荐，判定标准主要为完播率、点赞评论分享率等，与其辛苦摸索做视频，更便捷的方式则是通过与红人大V合作，以种草视频的方式引流。 &nbsp;\r\n</p>\r\n<p style=\"color:#333333;font-family:&quot;font-size:16px;background-color:#FFFFFF;\">\r\n	2、给用户裂变的动机 &nbsp;\r\n</p>\r\n<p style=\"color:#333333;font-family:&quot;font-size:16px;background-color:#FFFFFF;\">\r\n	抖商研习社有了流量并形成转化后，还需要二次分享才能形成裂变，这就需要给用户一个分享“动机”，可以是折扣、优惠券、返现、赠礼等等，而小程序的营销插件如拼团、砍价、抽奖、分销等，则可以为商家提供裂变营销工具。\r\n</p>\r\n<p style=\"color:#333333;font-family:&quot;font-size:16px;background-color:#FFFFFF;text-align:center;\">\r\n	<img src=\"http://demoall.adashuo.com/20090/uploads/allimg/c191107/15I0c25a5020-II2.png\" width=\"450\" height=\"319\" border=\"0\" alt=\"抖商研习社：如何在抖音做社交电商？-第3张图片-小七抖音培训\" title=\"抖商研习社：如何在抖音做社交电商？-第3张图片-小七抖音培训\" style=\"height:319px;width:450px;\" />\r\n</p>',	'doc.png',	1.00,	5,	0,	0,	0,	'2019-12-03 14:08:36',	'admin',	11,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	1.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	4,	1,	0,	1),
(123,	'“拼购”为何成为电商博弈的又一杀手锏？',	'<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	10月19日，京东宣布今年11.11大促将首次推出“京东拼购”等玩法。10月19日，美团点评官方微信小程序也正式上线了“好货拼团”板块。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	事实上，此前已经有包括阿里、苏宁、今日头条等多家互联网巨头切入了社交拼团业务。而这一切，在笔者看来，巨头们完全已经将拼购当成了获取用户流量的下一个杀手锏。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;text-align:center;\"=\"\"> <img border=\"0\" src=\"http://demoall.adashuo.com/25707/uploads/allimg/c191120/15J2314405K20-1L320.jpg\" style=\"height:auto !important;\" /> \r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	拼购成“香饽饽”\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	根据艾媒咨询发布的《2018Q1中国社交电商行业市场研究报告》显示，2018年中国社交零售用户规模将突破3亿人，年均复合增长率将达到44.2%。这也意味着，未来社交电商或仍将有巨大的增长空间。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	而作为社交电商的集中展现形式，拼购正凸显着自身鲜活的能量。这其中，最值得注意的就是拼购已经成为巨头最新切入的业务。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	具体来看，巨头们正在尝试性地推出自家相关的拼购业务。如果让消费者直接说出某个巨头旗下的拼购业务，可能会非常轻松。因为这些巨头推出的拼购应用，名字上大同小异——手淘特价版、京东拼购、苏宁拼购、今日头条的“值点”……\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	此外，支付宝联合淘宝上线拼购小程序“每日必抢”，网易则推出了“网易一起拼”。总的来看，它们还都是以“拼”、特价为主要特性，为自己烙印下超值的标签。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	而从数据上看，拼购在近段时间以来也成为电商行业的一个热词。根据速途研究院发布的《2018上半年国内拼购电商市场研究报告》显示，在巨头的入场下，它们不仅让自身拥有了亮眼表现，还让拼购行业获得了整体提升。从微信指数和百度指数看，各个巨头的拼购业务都有着显著提升。这也意味着，以布局消费分级市场为目标的拼购，成为了当下巨头眼中的“香饽饽”。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	巨头在拼购行业的试水，还反应在将自身的资源不断向拼购业务倾斜。比如，很多巨头都举办了优惠活动来吸引消费者，并展现自身拼购业务的特性。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	比如：京东拼购频道此前公布了双11玩法，旨在以流量传播扩散+提升订单为目标，通过打造贯穿双11的拼购寻宝乐园，同时引爆11.8拼购玩法狂欢日，为拼购小程序引流，帮助平台转化新用户并提升订单量。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;text-align:center;\"=\"\"> <img border=\"0\" src=\"http://demoall.adashuo.com/25707/uploads/allimg/c191120/15J231440B4F-1U327.jpg\" style=\"height:auto !important;\" /> \r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	苏宁拼购则将重点在直采直销生鲜商品上发力。在刚刚过去的双十拼购日，苏宁拼购一天卖出了40万个柚子，这坚定了其发展生鲜拼购的战略构想。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	因此，我们可以看到，在巨头的不断试水下，拼购这一社交电商模式已经变得迅速火爆。对于消费者来说，这也是一个消费变得多元化的好兆头。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	品质化渐成主流\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	其实，如果不戴“有色眼镜”去看拼购的话，其身上还是有很多亮点的。拼购以低价引入流量，通过关系网对商品进行分裂曝光，在满足多数人追求“低价”需求的同时，又大幅度增加中小商家和尾货的曝光率和购买率。也正因为如此，拼购在当下俨然成为购物模式中的一股新势力。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	但值得注意的是，在拼多多一家独大的时候，其商品质量、售后等饱受诟病。山寨、造假的问题，也造成了诸多负面影响。而在巨头纷纷入场的情况下，实际上也意味着拼购将进入下半场。在下半场开启的同时，拼购也将迎来全新的发展拐点。拼购在展现品质化的同时，也将成为巨头业务的补充，让它们构建更为完善的商业生态矩阵。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	对消费者利好的消息，在于品质化将成为拼购的常态。同时，品质化也将是巨头拼购业务的竞争发力点。不管是为了稳固消费者群体，还是出于维护自身品牌形象的考虑，巨头都不会再去牺牲商品质量和售后来实现低价。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	它们会尽力展示自身的物流实力、电商交易技术能力、核心交易链路、消费保障制度等，将供应链优势发挥到极致。最终，巨头的拼购业务将让消费者享受到具有更高性价比的品质好货，并由此实现真正的消费升级。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	此外，拼购业务的上线也是对巨头自身实力的加强。以美团拼团为例，其让美团实现了从虚拟商品向实物商品的过度，完成了自身商业边界的扩张。中国社科院财经院互联网经济研究室主任李勇坚表示，“过去用户可能只有在吃饭等时候才想到打开美团，但如果增加了商品类拼团，既有用户可能会在APP上停留更多的时间用于浏览商品”。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	而对于巨头而言，以往虽然在努力强调业务之间的整合，但缺少了某个版块后，业务之间总会有割裂感。拼购业务的出现，或许就能成为“黏合剂”，让巨头的业务实现融合发展。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;text-align:center;\"=\"\"> <img border=\"0\" src=\"http://demoall.adashuo.com/25707/uploads/allimg/c191120/15J231440I050-1c916.jpg\" style=\"height:auto !important;\" /> \r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	值得注意的是，对于巨头来说，它们此前都面临着各自不同的发展瓶颈。而要寻找创新增长点，就必须在流量上痛下苦功。拓展流量的最佳做法，就是通过开辟新业务获取。而拼购身为“引流大户”，自然被巨头所看重。在拼购行业的下半场，它们将争抢中高端消费人群，不断攫取新的流量。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	相信随着巨头纷纷切入拼购领域，后者也在加速下沉。而就发展趋势来看，只拼价格不拼质量的原始拼购模式注定被淘汰。在被巨头开启的下半场，拼购有望与消费升级概念的成熟、人均消费能力的提升高度契合。届时，拼购业务也将成为巨头比拼的另一立脚点。\r\n</p>',	'doc.png',	1.00,	26,	0,	0,	0,	'2019-12-03 14:09:59',	'admin',	0,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	1.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	11,	1,	0,	1),
(124,	'甘肃两部门：布病等人畜共患病发病率回升',	'<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	11月5日，一项热搜出现在邦哥的微博首页，并且排名一路蹿升至第一，挂在榜首直至今日凌晨：6000多首歌从KTV下架。被下架歌曲中，《十年》、《泡沫》《死了都要爱》《听海》《K歌之王》等等大热歌曲赫然在列。许多媒体的标题用的是：你拿手的还能点么？\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	而邦哥脑中也冒出了另一个问号：这些歌曲为什么被下架？谁主导了这次下架风波？\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	一个民间组织，为何有权下架全国KTV的6000多首歌？\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	这次下架风波毫无疑问是版权问题引起的：中国音像著作权集体管理协会（下称“音集协”）发出公告，要求KTV终端生产管理商和卡拉OK经营者在今年10月31日前，删除或者不向消费者提供6000多部音乐电视作品。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	乍一看这是一件好事，毕竟版权保护理应得到支持，即便6000多首歌的下架在短期内会给普通消费者带来一些麻烦，但依然有利于产业的良性发展。<strong>然而意外的是，邦哥就此与一位业内音乐创作者进行了解时，对方却对此次发出公告的“音集协”并不买账：这个协会其实不是国家的版权保护机构，之前还被央视曝光过收取高额版权费后，并没有给歌手支付费用，我对于之后钱的去向保留意见。</strong>\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	业内人这样的评论，引起了邦哥的注意，我们随即找到了音集协官方微博，查看其回应此次事件的公告。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	<img alt=\"6609首歌从KTV下架，《十年》《泡沫》均中招，原因不止版权那么简单 \" border=\"0\" class=\"aligncenter\" src=\"http://demoall.adashuo.com/25707/uploads/allimg/c191120/15J231444420Z-10TG.jpg\" title=\"6609首歌从KTV下架，《十年》《泡沫》均中招，原因不止版权那么简单 \" style=\"height:auto !important;\" />众所周知，KTV使用他人音乐作品，需要依法取得授权。但全国KTV可以说是海量的，KTV所需要使用的作品也是海量的。实际经营中，要经营者自己去一对一地取得授权，说句实话，并不现实。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	音集协就是在这样的背景下成立的。我们查看了其官网资料，根据资料显示，该协会是会员制，注册会员后，协会可以帮助你进行统一的版权管理，对全国的KTV进行作品授权，或者进行相应的维权措施。但让邦哥十分惊诧的是，这次被下架的6609首歌，背后的版权所有者，没有一家是音集协的会员。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	换言之，<strong>音集协的权利范围本应是帮自己的会员授权和维权，这次却是向6609首他们本应管不着的歌，发放了“下架通知”</strong>……\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	在音集协官方微博的回应公告中，这一消息得到了证实：\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	<img alt=\"6609首歌从KTV下架，《十年》《泡沫》均中招，原因不止版权那么简单 \" border=\"0\" class=\"aligncenter\" src=\"http://demoall.adashuo.com/25707/uploads/allimg/c191120/15J23144450T0-114138.jpg\" title=\"6609首歌从KTV下架，《十年》《泡沫》均中招，原因不止版权那么简单 \" style=\"height:auto !important;\" />这让邦哥不禁产生了一个疑问：不是音集协的会员，我的歌曲就不能在KTV里播放了么？音集协到底是一个什么样的组织，怎么会有这么大的权利，对非会员的作品也能进行下架处理？\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	就此我们在其官网查找到了音集协的《协会章程》，章程总则中清晰地写明了音集协的性质：本团体是由依法享有音像节目著作权或者与著作权有关的权利人<strong>自愿结成的全国性、非营利性的社会组织</strong>。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	一个自愿结成的会员制民间组织，从法理上讲，应当并不具有行政执法权，按照常理本应无权对“非会员”的作品进行下架处理。而在音集协此次回应的公告中，对这一问题的描述如下：\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;text-align:center;\">\r\n	<img alt=\"6609首歌从KTV下架，《十年》《泡沫》均中招，原因不止版权那么简单 \" border=\"0\" class=\"aligncenter\" src=\"http://demoall.adashuo.com/25707/uploads/allimg/c191120/15J2314445T30-12W41.jpg\" title=\"6609首歌从KTV下架，《十年》《泡沫》均中招，原因不止版权那么简单 \" style=\"height:auto !important;\" />\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	对此，邦哥咨询了法律方面的专家，对方表示：6000多首歌的权利人或其委托的代理公司对KTV经营者提起的单独诉讼，就法律关系上讲与音集协相互独立，并无关系。但公告中并未提到音集协与这6000多首歌的权利人或代理公司是否有委托关系，因此<strong>音集协此次的“下架通知”背后，是否有可能是接受了歌曲权利人本身的授权或委托，我们也不得而知。</strong>\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	曾被众多媒体质疑、央视曝光高额版权费流向哪里？\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	<strong>2006年，国家版权局规定，开始收取卡拉OK每包间一小时12元的歌曲版权费。我们日常去KTV的费用中，就包括了这部分版权费。</strong>那么这部分版权费收取后流向了哪里呢？根据文章开头从业者的说法，邦哥查阅了很多资料，发现这已经不是音集协第一次处于舆论中心。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	2009年，中央电视台连续多个栏目对音集协收取卡拉OK版权费的情况进行了报道；中央二套的《今日观察》栏目还播出了一期新闻专题节目《版权费还是保护费》，邀请两位专家，围绕卡拉OK版权收费及其分配问题。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	根据当时的报道，<strong>音集协自2007年开始收取KTV及卡拉OK版权费，至2009年，收取的版权费已达8000万元，但这笔钱的使用分配却很不透明，相当多歌手表示并未拿到应得的报酬，但作为集体管理组织的音集协却要收取高达50%的天价管理费。</strong>\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	在当时的采访中，音集协不愿详细说明收费方式以及对著作权人的返还方式。不过一位业内人士向央视记者透露，收费是通过一家叫做“天合文化”的公司进行的。根据公开资料，该公司成立于2007年8月，受音集协委托代收卡拉OK版权使用费。音集协负责授权，天合文化负责收费，二者形成一套KTV歌曲版权收费系统。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	而那时的国家版权局版权管理司王自强司长则认为音集协的做法有欠妥当，在接受记者采访时表示，“集体管理组织是一个非营利性机构，不能以组织企业来进行收费，只能建立自身的收费队伍。收费本体是你本身，你不能有一个第三者出来。”\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	那是音集协引起争议声浪最大的一次，此后也曾有过多家媒体跟踪报道过音集协收取版权费的相关内容。早在2008年就有北京中银律师事务所董正伟律师向国家工商总局、国家发改委举报，请求对音集协向KTV行业收取著作权使用费开展反垄断执法。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	而近两年，音集协受到的质疑更加密集了起来，2017年、2018年都有KTV联合状告天合公司（音集协的授权收费单位）进行行业和价格垄断，但最终都以天合的胜诉告终。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	有趣的是，<strong>音集协与天合文化的合作自2007年至2018年，11年间从未停止。但就在邦哥发稿前不久，音集协官网上出现了一份最新公告，终止了与天合文化的委托合作。</strong>\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;text-align:center;\">\r\n	<img alt=\"6609首歌从KTV下架，《十年》《泡沫》均中招，原因不止版权那么简单 \" border=\"0\" class=\"aligncenter\" src=\"http://demoall.adashuo.com/25707/uploads/allimg/c191120/15J231444A250-13U93.jpg\" title=\"6609首歌从KTV下架，《十年》《泡沫》均中招，原因不止版权那么简单 \" style=\"height:auto !important;\" />\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	被下架歌曲并非不能唱了，版权保护，路漫漫其修远兮\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	对于一个行业的健康发展来说，6609首无授权歌曲自KTV下架，理应得到支持。但版权收费的规范性、透明性，同样是应该得到重视领域。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	在此次风波中，被认证为音集协副理事长的周亚平的微博发言，同样引发了相当多网友的不满：\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;text-align:center;\">\r\n	<img alt=\"周亚平表示：希望权利人加入，而不加入的后果是“作品被摒弃在卡拉OK渠道之外”\" border=\"0\" class=\"aligncenter\" src=\"http://demoall.adashuo.com/25707/uploads/allimg/c191120/15J231444I530-14Kc.jpg\" title=\"6609首歌从KTV下架，《十年》《泡沫》均中招，原因不止版权那么简单 \" style=\"height:auto !important;\" />\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	周亚平表示：希望权利人加入，而不加入的后果是“作品被摒弃在卡拉OK渠道之外”\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	在撰文的过程中，邦哥将此次下架的6609首歌曲完整名单下载了下来，发现实际上遭到下架的，只是该首歌曲的某些版本。例如周杰伦遭到下架的《告白气球》等歌，就仅限《中国新歌声》第一季播出版本被下架。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	<img alt=\"6609首歌从KTV下架，《十年》《泡沫》均中招，原因不止版权那么简单 \" border=\"0\" class=\"aligncenter\" src=\"http://demoall.adashuo.com/25707/uploads/allimg/c191120/15J231444PZ-15S59.jpg\" title=\"6609首歌从KTV下架，《十年》《泡沫》均中招，原因不止版权那么简单 \" style=\"height:auto !important;\" />虽然这样的版本限制让很多小伙伴产生了“虚惊一场”的感觉，但邦哥要提醒的是，<strong>版权制度的目的，以及所要保护的对象，是创作者和版权所有者的利益。权利人们的利益，决定了他们的生存环境。</strong>如果从业者无法生存，音乐产业的发展从何谈起？\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	中国音乐版权保护之路，依然路漫漫其修远兮。\r\n</p>',	'doc.png',	1.00,	6,	0,	0,	0,	'2019-12-03 14:10:31',	'admin',	3,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	1.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	4,	1,	0,	1),
(125,	'雷军：天使投资人经历让我学会找风口 小米未来',	'<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	人工智能时代已来，雷军为小米找的下一个风口是什么？成立相机部门能“干翻”华为吗?\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;text-align:center;\"=\"\"><br />\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	▲雷军在在故宫发布滑盖手机MIX3\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	作者 |马婧\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	编辑 |赵泽 杨砺\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在喊出“今年相机部门有没有年终奖，就看能不能干翻华为”之后，小米董事长雷军又发新手机了，这一次是在故宫。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	2018年10月25日，在故宫发布磁动力滑盖手机MIX3乾清宫户外发布会，雷军在现场有点激动，一个人solo了将近一个半小时。雷军在介绍手机后置相机时，突然天空中传来两声乌鸦叫，雷军忍不住笑场，说连鸟都在肯定小米手机，“这是我们第一次办的户外的发布会，还这么有趣啊。”\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	25日早间，小米集团发布公告称，预计到10月底，手机出货量将突破1亿台，提前两个月完成2018年全年目标。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	雷军在发布会上谈到，今年手机大厂商和小厂商之间的差距会拉大，主要原因是各家在相机、AI方面投入成本不同所致。今年5月，雷军在内部信中宣布，在手机部内成立单独的相机部，集中全公司优势资源，提升小米手机的拍照品质。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	雷军曾对相机部门的同事说，今年相机部门有没有年终奖，就看能不能干翻华为。25日下午更新了最新成绩，小米MiX3以103的成绩超过了华为P20。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	小米如何“干翻”华为呢？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	▲MIX3故宫乌鸦捣乱小米发布会现场 雷军笑场：连鸟都肯定了\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	未来高增速或不靠手机靠IoT\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	新京报：小米过去8年保持了高速的增长，未来还能有非常高的增速吗？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	雷军：我们对小米未来的高速增长很有信心。首先手机行业是一个很大的市场，2017年全球共销售手机14.7亿台，小米销售了9000多万台。随着5G时代的到来，手机市场可能再次迎来增长，虽然不会像过去增长那么快了，但这个市场即便不再增长，对于小米来说仍然有巨大的成长空间。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	其次，手机之外，小米在智能硬件和消费升级领域布局广泛，已经进入了100多个品类，建成了全球最大的IoT物联网平台。随着AI时代的来临，AI+IoT将产生巨大的价值，小米已经具备了一些优势。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	另外，小米在海外市场有巨大的机遇。小米手机已经进入了74个国家和地区，还有很多市场有待进入，我们的很多品类也还没有进入全球市场。随着小米一步一步进入新的市场，把新的市场做好，我觉得小米未来还有十倍以上的成长空间。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	新京报：我们注意到小米还在布局智能家居。有观点认为智能家居是个伪命题？你怎么看这个问题？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	雷军：“智能家居”不是一个新词，二十年前在国外就有了，只是一直没有推动。我们觉得背后主要原因是商业通道和技术通道没有打通，比如以前智能家居的成本非常高，家里必须重新装修一遍，这对消费者难以负担，此外，不同厂家的产品之间也很难互联互通。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	小米做了两件事情来解决，首先我们把一个个的产品智能化了，消费者买回家后，突然发现实现了智能家居，这是商业通道理顺了。另外，我们做了互联互通的模组，在技术上也打通了，小米智能家居产品由很多不同的公司生产，但只要用了这个模组就可以互联互通。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	智能家居目前只是刚起步，小米也只是刚跨过门槛，今后智能家居的发展空间可能远超我们想像。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	新京报：有人说，小米生态产品只是在做微创新，你怎么看这个问题？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	雷军：从我们创业的经验来看，成功背后都有不为人知的艰辛，哪怕是一点点成绩，都要付出巨大的努力。所以我觉得我们不要小看微创新，为了提升消费者的体验，哪怕仅仅是1%，我们也投入了100%的精力。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	小米立志要成为一家伟大的互联网公司，让全球每个人都享受科技带来的美好生我没有。我们只有全力以赴做好每一件小事，才是走在正确的道路上。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	下一个互联网浪潮是人工智能\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	新京报：如何看待互联网这20年来在中国的发展，如果用几个关键的时间点来划分，你会怎么划分？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	雷军：我觉得2007年苹果推出iPhone是个很重要的事件，智能手机的出现极大的改变了互联网，我判断手机会逐渐替代个人电脑，移动互联网的时代将会来临。2010年小米成立，2011年推出了第一代小米手机，我们推动了智能手机在中国的快速普及和品质提升，移动支付、电商、社交网络、短视频等行业在中国的蓬勃发展，都有赖于庞大的移动互联网人口，这方面小米做了一点贡献。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	新京报：互联网下一个浪潮会是什么？在这个浪潮下，小米的机会是什么？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	雷军：人工智能的时代已经到来了，人工智能也是小米最重要的战略，我们拥有四项巨大的优势，用户群、海量设备、海量的数据、对整个AI时代的认知，很早就重视了云服务和大数据。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	小米选择的突破口是IoT，也就是万物互联，我认为AI与IoT结合将形成AIoT，也就是万物智慧互联，在这个领域未来有着巨大的发展空间。小米已经建成了全球最大的消费物联网，连接了1.15亿台智能设备（不包含手机、平板和笔记本电脑），小米人工智能助理小爱同学月活跃设备超3000万，月唤醒计数超10亿次，累计唤醒次数超50亿次。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“天使投资人经历让我学会找风口”\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	新京报：从金山时代开始，业界对你的评价就是IT劳模，怎么看待这一评价？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	雷军：如果我们要实现与众不同的梦想，付出的不比别人多，怎么可能成功呢？我现在还是这样认为，创业并不光鲜，成功的企业家也不像大家想的，轻轻松松就成功了，哪怕一点点成绩，背后都要付出极大的努力。在成功的路上，其实只有这一个秘诀认真拼命地工作。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	新京报：天使投资人的身份对于创办小米有哪些帮助？创业者和投资人的思维方式最大的不同之处是什么？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	雷军：因为天使投资人做的就是看大势，找风口。我觉得创业要想五年后是什么样子？十年后是什么样子？什么是正确的事情，什么是正确的时间点？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	我当年是一个手机发烧友，认为手机上网是未来的趋势，未来10年是移动互联网的天下，那我接着就想应该做些什么？所以我用投资人的身份，去看谁在做移动互联网，去搞清楚移动互联网到底是什么，这个过程中我们越来越坚信移动互联网的未来，最终在2010年决定创办小米。\r\n</p>',	'doc.png',	1.00,	27,	0,	0,	0,	'2019-12-03 14:11:24',	'admin',	1,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	1.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	11,	1,	0,	1),
(126,	'杨幂与魏大勋暗戳戳发糖 前夫刘恺威工作室发这八个字',	'<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	不在沉默中爆发，就在沉默中灭亡！\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	这句话来形容当下的区块链。2018年疯狂的区块链因受政策监管与打压，资本、媒体、甚至创业者都趋于冷静。或许，这就是黑暗里的爆发前夜吧。但这个前夜还很长很长…\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	最近一篇题为《业内人士：区块链逐步融入农业发展》文章引起我们的关注。该文提到：“截至目前，区块链已被应用于产品溯源、农业保险、农村金融、智能合约等多个场景。尽管目前区块链技术在农业领域的应用范围还较为有限，但是许多业内人士对于区块链在农业领域的未来发展前景仍然满怀期待”从种种迹象来看，业内人士非常看好区块链在农业领域和场景里的应用。另外，还有政府官员也为区块链+农业打CALL。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	内蒙古蒙草生态环境（集团）股份有限公司董事长王召明表示，作为农业大国，要利用物联网、大数据、移动互联网、人工智能、区块链等现代信息技术，大力推动农业全产业链改造升级，为实施乡村振兴战略插上互联网的翅膀。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	可以肯定：区块链没有倒下，区块链在等待机会。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	业内专家指出，2019年有望成为区块链技术真正落地应用，走向产业化的一年。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	区块链诞生之初，外界都追捧：区块链是各个行业的救命稻草。尤其金融行业、食品行业，当然也包括农业领域。我们聊聊区块链解决农业什么问题？我们认为个有以下几个问题！\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	1农业领域看好区块链\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	1农产品可溯源\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	农产品溯源一直是农业的一个痛点问题。而区块链技术利可以对记录实现不可篡改，因此从农产品的生产端到流通端、消费者都有详实的数据，可以实现消费者明明白白消费，提高消费者购买的意愿。农产品溯源可以提升农产品安全性以及食品的安全性。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	2信息透明\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	农业领域除了可溯源之外，生产者与需求方的信息也存在不透明的问题。一旦区块链技术应用与农业。大家就可以通过大数据分析，建立种植户、采购商的信用评级参考；利用智能合约在种植户和采购商之间保证公平交易。同时，区块链技术可以提高农产品买卖双方的契约精神。另外，随着食品供应链中区块链的出现，这可以简化这一过程，因为数据管理系统，将一系列农民、加工商、分销商、监管机构、零售商和消费者纳入其雷达范围的数据管理系统变得更加透明。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	3降低成本\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	区块链技术运用之后，生产、流通等2大环节的成本会大大降低。比如，区块链技术解决信息自动存贮和数据库的功能，如此就减少了人工的投入和其他设施的投入。另外，区块链及应用实现万物互联，帮助生产商和渠道商降低各项开支。同时，生产和流通成本的降低，也会降低农产品的价格，最终还是消费者获利。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	因此，区块链技术在农业领域的应用等到各级人士的认同。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	2现在的区块链农业玩家\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	从以下多个案例来看，这些企业的确把区块链技术应用到用户服务中。他们希望借助区块连技术解决食品安全和可溯源，从而提高消费者对品牌的认可度。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	1沃尔玛\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	沃尔玛公司在2017年内在区块链技术领域作出了大量尝试。沃尔玛一直在与IBM合作，共同开发针对食品安全问题的区块连解决方案。比如，沃尔玛把区块链放在芒果、猪肉等生鲜农产品上。沃尔玛食品安全副总裁Frank Yiannas曾表示：“我们的客户理应拥有更加透明的供应链。我们认为在21世纪，以前那种一步一步去追溯源头的方式已经过时了。这是一项由技术支持的明智举措，它将极大地造福我们的客户，并彻底改变食品体系，使所有的相关者受益。”\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	2 Dreyfus\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	大宗商品交易公司Louis Dreyfus（路易达孚）宣布已试用由ING（荷兰国际集团）等一批金融机构开发的基于区块链的交易系统。Dreyfus使用区块链平台来完成与中国供应商的大宗大豆交易，极大地缩短了交易时间。同时，据参与测试的公司表示，这次测试涉及从美国运到中国的大豆，并在平台内保存所有相关文件（包括销售合同和信用证）。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	3可口可乐\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	2018年，可口可乐正在与美国国务院、区块链信托加速器（BTA）、区块链技术公司Bitfury集团以及崛起币（Emercoin）共同合作，推出一项基于区块链技术的试点项目。同时，可口可乐公司建立区块里的平台，以帮助确保道德的糖生产。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	4家乐福\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	2018年，欧洲最大的零售商家乐福已经开始采用区块链账本技术去追踪鸡肉、鸡蛋和西红柿从农场送到商店的全过程，并将在未来几年在其所有生鲜产品线上部署这种技术。比如，2018年3月，家乐福中国首款区块链产品——琯溪蜜柚，获得用户疯抢。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	5 Smart农场\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	中国农业已经迎来4.0时代，高科技融合成为农业发展的方向。上海华中农投农业科技有限公司旗下Smart农场大力推动区块链的应用。将区块链技术与农业相结合后，能最大限度地消除信息不对称，提高整个产业链的信息透明度和及时反应能力，从而实现整个产业的增值。减少农药投入，提高农产品品质。解决农业的痛点，解决农产品的食品安全、食品供给问题，真的能让中国人都尝到放心的味道。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	3未来走向\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	区块链去中心化等特性，将大幅降低互联网维护成本，提升农业物联网的智能化和规模化水平。同时，基于区块链技术的农产品追溯系统，解决了消费者对于产品的信任危机，让人们的餐桌更健康，更安全。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	另据前瞻产业研究院发布的《中国区块链行业商业模式创新与投资机会深度分析报告》统计数据显示，随着区块链应用场景扩展，预计2019年具有投入产出的区块链企业超过600家，产业规模有望超过8亿人民币。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	有人预测：2019年，“区块链技术”正逐渐从幕后走向台前。我们从2个方面来看：区块链技术迎来利好！\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	1）从大背景来看，国家政策打击比特币，但支持区块链技术在各个行业的应用。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	2）从行业来看，目前大数据和人工智能的发展，区块链技术也将会逐步与其他高科技项目融合赋能产业。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	在农业领域，区块链农业又将会呈现哪些趋势和走向呢？\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	1物联网＋无人机＋区块链\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	中国农业已经迎来4.0时代，高科技融合成为农业发展的方向。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	物联网＋无人机＋区块链的结合将有利于精准农业的发展，减少农药投入，提高农产品品质。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	其中，物流确保万物互联，无人机提供生产管理服务，而区块链提供记录和可溯源等技术。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	2区块链+数据+人工智能\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	区块链应用于农业，能最大限度地消除信息不对称，提高整个产业链的信息透明度和及时反应能力，从而实现整个产业的增值。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	而区块链+数据+人工智能的融合发展，可以推动农业大数据的价值最大化，降低投入成本。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	3区块链+农业金融\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	2月初，中国政府发布了“关于农村金融服务振兴的指导意见”。此次提出的新框架，是国家农村振兴计划中金融服务效率提高计划的一部分。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	同时，该指南据称将有助于促进农村金融部门中如区块链等新技术的应用，以“改善农业信贷风险的识别、监测、预警和处置水平”。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	该公告还预测，新技术将鼓励金融机构“为农村电子商务开发专用贷款产品和小额支付结算功能，并开辟农村电子商务资本链”。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	区块链+农业金融将会为小农户贷款提供便捷途径，为农业金融机构的征信带来真实性和可预测性。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	4区块链+农村物流\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	随着区块链、物联网、大数据等新兴技术与物流行业的深度融合，供应链正成为区块链技术最具潜力的应用场景之一。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	由于农村物流的小散，导致包裹丢失、农产品上行困难等窘况。但区块链技术可以解决这些问题。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	西南交通大学交通运输与物流学院副院长罗霞指出示，农村振兴是今年党中央非常重要的战略部署，与农村物流高质量发展紧密相关。加强云计算、区块链、人工智能等供应链智能化技术在农村物流中的应用，为农产品的生产、检测、周转、销售、品控、管理等提供智力支持。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	5区块链+农业供应链\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	这一类应用就是各大商场嫁接区块链的原因。比如：沃尔玛、家乐福等大型超市把整个生鲜和食品供应链纳入区块链管理，从而降低成本，提高产品的安全性。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	目前，美国农业巨头嘉吉等都在大力发展区块链+农业供应链金融的应用。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	总结一下，2019年区块链在农业领域的应用将会再次迎来爆发。但我们还要明一点：区块链只是一项技术，而不是赚钱的工具。在整个农业发展中，区块链只做赋能者，而不是主导者。如此，路子才会越走越宽！\r\n</p>',	'doc.png',	1.00,	6,	0,	0,	0,	'2019-12-03 14:13:27',	'admin',	14,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	1.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	4,	1,	0,	1),
(127,	'口臭和胃癌有关系吗 给糖尿病患者的吃糖建议',	'<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	电子商务飞速发展，快速增长的包裹数量与日渐减少的快递员数量已经不成正比。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	快递员的工资回报越来越高，为什么这个职业在近年来从事人员锐减呢？对此，有很多快递员反映，虽然能够得到很高的工资回报，但随着人们对服务水平的要求也越来越高，他们也越来越辛苦。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	同时，快递员的社会地位相对较低，随着人们文化水平及文化素养的逐渐提高，一些有学历有技能的人都已不太愿意做快递员。申通副总在7月25日召开的中国快递“最后一公里”峰会上就表示，现今快递行业的痛点已不仅是解决“最后一公里”的问题，而是怎样才能够招到更多的快递员。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	中国高速发展中，人口红利也在逐渐的减少，越来越多的事情都开始被智能化技术所取代，但快递行业是属于劳动密集型企业，非常依赖快递员。快递行业正处在用人难之际，双十一等各种电商狂欢节的到来无疑是让这些快递企业悲喜交加。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	智能快递柜提升末端物流配送能力，备受物流企业青睐\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	快递员不足是人口红利减少的必然结果，因此急切需要新兴技术缓解快递行业的压力，智能快递柜作为解决方案就这样“问世”了。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	智能快递柜在2012年萌芽，中邮速递易率先推出智能快递柜，在初期遭遇了很多的质疑和非议，但在包裹数量不断增长以及城市年轻劳动力不足的情况下，智能快递柜已经成为末端物流配送能力的重要补充，各路资本企业竞相涌入该市场，想分得一杯羹。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	2015年6月，顺丰、申通、中通、韵达、普洛斯投资5亿元成立丰巢科技；2016年10月，中集e栈、上海富友收件宝、江苏云柜组成创赢联盟，形成了以速递易、丰巢和创赢联盟为主的三巨头格局；2017年7月，中国邮政集团与驿宝网络入股速递易，中国邮政以50%股份控股速递易，“国家队”正式进入智能快递柜行业……智能快递柜已然成为物流企业人手必备的基础设施。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	国家邮政局10月17日发布的 《2018年9月中国快递发展指数报告》显示，快递企业与第三方创新末端投递形式，基本形成上门投递、智能箱投递、平台投递等多元末端服务体系，主要企业设立智能快件箱25万组，箱递率达到8.4%。高速增长的数据表明智能快递柜前期虽饱受争议，但后期已逐渐被民众所接受。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	智能快递柜突破派件瓶颈，效果显著\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	首先，智能快递柜降低了人力成本，减少了快递员的工作负荷。快递员的工作量和工作任务较为繁重，在人手不足的情况下一个快递员往往需要承担起更多的工作，经常超出本来的工作时间，因此快递公司需要对快递员支付较高的人力成本。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	智能快递了增加派件数量，在提高了快递员的工作效率的同时，也提高了他们的收入，在一定程度上缓解了“用人难”问题，降低人力成本。在这一点上，丰巢获取得的效果极为突出：在今年九月初，丰巢与链家进行合作并声称他们的日均派件量已高达900万+,这个数据对于快递行业来说无疑是一个巨大的进步。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	其次，智能快递柜提高了用户隐私保护力度，取件时间更随意。当今社会，人们对于隐私非常重视，而在传统的快递人员配送模式中，存在快递信息被其他人窃取或是快递在寄存的时候丢失等问题，智能快递柜保密性更强，能极大减少了这种问题的发生。再加上传统的配送模式中快递员配送的时间可能会和收件人在家的时间不对等，给收件人带来了困扰，智能快递柜投入使用使得忙碌的人们可以随时取件，极为方便。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	智能快递柜陷入困境：难盈利、争议大\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	智能快递柜诞生是时代进步的需要，也给我们的生活带来了巨大的改变，但很多问题也接踵而来。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	首先，盈利难。一方面是因为快递柜的设备生产成本高和在每一个小区内投放的租金比较高，快递柜的场地年租费也较高，同时维护费用也不低。过高的成本使智能快递柜不能为企业带来营收利润，这对每一个企业来说都是致命的打击。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	佼佼者丰巢和速递易均面临着巨大亏损：截止2017年9月30日，丰巢科技在该年9个月期间的营业收入为1.6亿元，净亏损从2016年的2.5亿元扩大到2.76亿元，负债总额扩大到12亿元；运营速递易项目的三泰科技也是出现常年亏损，2015 年亏损3792.8万元 ，2016 年亏损 12.69亿元，2017年第一季度亏损也将近3000万元。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	另一方面是用户往往不会愿意为此付费。用户认为在购买商品时已支付过运费，取快递时就不应该再支付额外的费用，使得快递柜的亏损日益增加。同时，蜂巢、速递易等快递柜也开始向快递员收取存放费用，其中速递易快递柜的收费标准为：大箱0.6元/件，中箱0.5元/件，小箱0.4元/件，但很多快递员不愿承担这些费用。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	其次，智能快递柜虽然提高了快递员配送快递的效率，但使得快递员很轻松的逃避了签收这一流程。用户无法进行当面进行签收，使得物品运输过程中出现的质量问题时的合法权益无法得到保障，收货时发现快递有问题不知该向谁反映。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	最后，在包裹数量的飞速增长的背景下，快递员如果像从前一样一件件把快递送到消费者手中显然是不太现实的事。所以现在的快递员在快递高峰时段一般都使用智能快递柜，不会打电话一一进行通知，在把物品投入快递柜时会由系统自动给用户发送取件通知，而如果快递员在放入物品时把用户的手机号输入错误，会导致用户无法接收到取件通知，从而超时取件。现在部分品牌快递柜超过一定的取件时限需要收取一定费用，这让用户难以接受。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	另外，有用户在使用丰巢快递柜时，页面会出现“打赏”等字样，价格以1、2、5元为不等，这样确实能为丰巢带来一定的收益，虽然不是强制收费并且设有“跳过”的字样，但由于字体过小，有引诱用户消费的嫌疑因此用户在使用过程易产生误解与不满。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	智能快递柜如何赢得“民心”？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	智能快递的问题柜已经严重影响后期的战略布局和发展，企业应当如何解决成了广泛关注的焦点。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	首先，智能快递柜最初出现时毫无营收利润，很大程度上是因为单纯的取件不可能有任何收入增长，但是现在智能快递柜的发展已涉及到寄件的环节，这意味着快递柜也可以从中赚取一定的利润。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	智能快递柜要想继续获得更大的盈利，应该继续为用户提供更多增值服务，让用户为此愿意付出相等的费用。比如，在各种人流量较大的公众场合，有很多用户因为手上提的东西过多有很大的不便，快递公司可以在这些场合投放寄存柜方便用户存放，并收取一定的费用，据了解蜂巢已经在试点，今年5月中标了杭州周边17个高铁站，总计36组寄存柜的订单。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	其次，面对快递柜无法当面签收的缺陷，快递柜企业应继续完善快递柜的基础硬件设施，比如在每一组快递柜上安装摄像头，用户在取包裹时可以将包裹在摄像头下展示，将来包裹质量出现问题时可以避免物流企业和用户之间产生不必要的纠纷。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	最后，针对部分用户不满快递员在未经允许的条件下投递快递柜的问题，早在2016年国家邮政局发布的《智能快件箱投递服务管理规定（暂行）》中就曾明确提出，“经营快递业务的企业在使用智能快件箱投递快件前，应当征得收件人明示同意”，同时用户有权利决定是否使用快递柜或是按指定地点取货，用户应该积极行使自己的权利。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	企业在这样的背景下应加大对快递人员基本服务知识的培训力度，同时加强对客服人员处理客诉的能力，及时处理客户问题并进行反馈。快递员在把包裹放入快递柜时应检查该快递是否为需要保鲜、即食类食品，一旦出现商品问题则由快递公司或快递员承担全部责任。面对取件通知收不到等问题，在首次投递后收件人未能提取的情况下，快递企业应及时取回快递，联系收件人后再提供投递服务。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	小结\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	时代与技术在发展中，任何行业的各个环节都应该往效率更高，成本更低道路上发展。物流末端的需求是多样化的，送货上门是主流，但智能快递柜的市场潜力也不可小觑。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	根据中商产业研究院发布的 《2018-2023年中国智能快递柜市场前景及投资机会研究报告》 ，预计2018年智能快递柜市场规模将达169亿元，到2020年，中国快递柜市场规模将达近300亿元。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	所以，丰巢等智能快递柜未来应加大沟通协调力度，在提高消费者满意度的同时，尽快解决盈利模式问题，尽可能地保证效率、成本、体验和信息的互动。\r\n</p>',	'doc.png',	0.00,	33,	0,	0,	0,	'2019-12-03 14:14:23',	'admin',	1,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	0.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	12,	1,	0,	1),
(128,	'上市搁浅背后：唱吧、全民K歌们的在线K歌如今活',	'<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	今年5月，唱吧终于完成了将近一年半的上市辅导工作。网上有消息称，唱吧在一个月后，就会正式向证监会递交招股书，踏上A股创业板的上市征途。但眼看着2018年就快要过去，却迟迟未见唱吧上市的消息。对此，唱吧创始人陈华在接受媒体采访时表示，对唱吧上市问题不愿多谈，言外之意是唱吧在近期内可能不会寻求上市。这突如其来的转变，让人们疑惑不解。唱吧在完成一年多的漫长上市辅导期之后，为何不愿上市？其究竟打的是什么“算盘”？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	唱吧上市搁浅，原因为何？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	唱吧从2012年上线起，便风光无限。其在上线首日注册用户就超过10万，5天之内登顶AppStore排行榜。易观数据显示，直到2016年第3季度，唱吧还以53.6%用户渗透率位居移动K歌领域第一的位置。彼时，唱吧正如日中天，选择上市无疑是正确之举。然而世事无常，经过将近一年半的漫长辅导期，国内的在线K歌市场早已“物是人非”，唱吧已然错过了最佳的上市时机。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	其一，全民K歌抢了唱吧“风头”。众所周知，全民K歌背靠腾讯，可谓是含着“金钥匙”出生。全民K歌不仅拥有微信与QQ两大流量入口，还与QQ音乐共享丰富的音乐版权，在流量与音乐版权方面都有着天然的优势，是唱吧最强劲的对手。据了解，全民K歌自2014年上线起，其活跃人数一直高增猛涨，在2016年成功超越唱吧，并逐渐拉开差距。据易观数据，2018年第三季度，唱吧活跃用户为6560万人，而全民K歌活跃用户则为20705万人，是唱吧的三倍。面对全民K歌的“攻城略地”，唱吧显然处于不利地位。而全民K歌的赶超，可能打乱了唱吧的上市计划。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	其二，短视频平台的崛起，冲击整个互联网娱乐市场。近几年，由于快手、抖音等短视频平台的崛起，整个互联网娱乐市场变的更加“拥挤”，唱吧的K歌业务、直播业务等都受到了一定的影响。QuestMobile数据显示，2018年7月，短视频APP行业月度活跃用户规模为5.08亿人，而短视频APP行业总使用时长在移动互联网中的占比达到惊人的9.2%，要知道，就算是在线视频的占比也仅有9.5%。可见，短视频APP行业已经抢占了大量互联网用户的上网时长，唱吧无法视而不见。再加上全民K歌的存在，唱吧要想巩固自身地位并不容易，目前也很难有华丽的数据支撑，若是在此时上市，唱吧的估值可能并不理想。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	其三，互联网股市动荡不安。最近国内不少已经上市的互联网企业过的并不“如意”，如小米、拼多多和美团等企业都出现了市值大幅下滑的情况，就连腾讯、阿里巴巴等老牌互联网企业也没能避免。受此影响，唱吧此时选择不上市或许是明智之举。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	一方面，在国内互联网股市行情不利的情况下，唱吧此时上市无疑是逆水行舟，有着“流血破发”的风险；另一方面，今年国内的互联网公司纷纷申请上市形成了“上市潮”，如宝宝树、映客、小米和拼多多等，如此多的公司扎堆上市，吸引了不少资金注入，导致资本市场紧缩，也就是说投资人手里的钱越来越紧张。这也许会造成唱吧融资困难，难以得到理想的融资金额。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在这些问题影响下，唱吧暂时将上市的计划搁浅，等待更好的时机上市，或许是不错的选择。不过除了上述三个原因之外，也有业内人士猜测，唱吧之所以要搁浅上市，可能是其要放弃A股创业板，而选择赴港上市。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	港股市场火爆，令唱吧有所动摇？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	对于唱吧要赴港上市的猜测，也并不是没有依据。早在2015年，唱吧就曾想要赴美上市，但由于美国缺乏与唱吧对标的产品，而导致其估值过低，令唱吧有所顾虑。与之相比，当时国内的A股市场行情较好，且国内资本对互联网科技股也愈发青睐。所以再三思考后，唱吧毅然拆除了VIE架构，选择回国赶赴A股上市。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	时至今日，随着港交所在上市机制上的改革，首次接受同股不同权企业上市，为互联网企业打开了一扇大门，包括小米、美团点评、平安好医生和宝宝树等多家明星企业都选择在港股上市。而此时的唱吧或许面临着与三年前类似的选择题，是A股还是港股？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	据了解，上市A股要求较为严格，除了必须盈利三年才能申请IPO外，还必须同股同权。而现在的港股市场，除了支持同股不同权企业上市，其监管机构也更加独立透明和高效，公司一般在6到12个月就能完成上市过程，可以帮助企业更好地把握好上市时机。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	此外，A股实行的是“T+1”交易制度，股民们当天买进的股票当天不能卖出，且还有涨跌幅限制。而港股采用的则是“T+0”交易制度，在当天交易时段内，相关机构和股民们可以自由买卖，交易次数与涨跌幅均无限制，这种方式不仅能够提高市场的交易量，还能帮助投资者及时止损。所以二者相对比较来看，港股市场规则似乎更加灵活且合理化，能帮助企业有更好的发展。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	且从根本上来讲，企业上市无非就是希望借助资本的力量，获得更好、更快速的发展。而随着港交所改革，港股已经成为了众多互联网公司上市的首选。在此条件下，唱吧若是选择“跟风”，改赴港股上市，也不是没有可能。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	不过从目前来看，在市场竞争加剧、股市动荡等问题影响下，唱吧此时上市并不稳妥。所以暂时将上市计划搁浅，继续修炼“内功”，才是唱吧最好的选择。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	养精蓄锐，厚积薄发\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	目前，纵观整个移动K歌市场，已然是唱吧与全民K歌双雄称霸的局面，像天籁K歌、K米和酷狗唱唱等K歌产品已经难以给全民K歌、唱吧二者带来威胁。可见，唱吧在移动K歌领域还是有着非常明显的领先优势，只要其能够完善自身，加强功能创新，或许就能够摆脱全民K歌所带来的竞争压力，在互联网娱乐市场中走的更远，其上市之路也会变得更为平坦。对此，唱吧可以从以下三个方面入手。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	首先，丰富曲库资源，提高音乐品质。音乐版权是移动K歌行业的刚需，缺少相应的音乐版权，用户就无法得到理想的K歌体验。如在用户K歌时，一定会选择自己喜欢的音乐进行录唱，但用户若是在唱吧中搜不到自己想要唱的歌曲，在别无选择之下，用户就会选择用其他的K歌软件进行录唱，最终造成唱吧的用户流失。因此，唱吧要想缩小与全民K歌的差距，还需与相关的音乐版权公司合作，丰富自己的曲库资源。同时，唱吧还应继续提升APP内的伴唱、录音和修音等音乐品质，争取为用户提供更加优质的K歌享受，以此来留住和吸引更多用户。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	其次，加强线上、线下融合，丰富用户K歌体验。如今，唱吧正在大力布局线下市场，其不仅花费数千万元战略投资麦颂KTV，并实现了与麦颂KTV在社交、服务等多方面的合作，还大力布局线下移动迷你KTV业务，取得了不错的成效。据了解，唱吧不光在全国拥有400多家麦颂KTV门店，还在商场、超市和机场等公共场所布下了2万多台迷你K歌亭。不过唱吧虽然在线下布局极广，但其线下资源还未能与线上达到有效的结合。目前唱吧在APP内只提供了KTV包房预定、在线点歌和在线切歌等常用功能，还有很大的完善空间。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	对此，唱吧可以在APP内添加游戏点歌、K歌评比和K歌挑战赛等有趣功能，加强用户线下与线上的互动。同时，用户在麦颂KTV里演唱的歌曲最好也能保存在唱吧APP中，让用户可以在唱吧APP中发布并分享自己在麦颂KTV里的演唱歌曲，这不仅满足了用户的分享欲望，又加强了线上与线下的融合，可谓是一举两得。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	最后，走出海外，争夺更大的移动K歌市场。如今，唱吧已经在国内取得了不错的成绩，其知名度和影响力也都达到了一定的高点，所以唱吧要想再有突破，并不容易。在此情况下，唱吧若是向海外市场发起冲击不失为一个选择。一方面，目前海外的许多国家都缺少类似唱吧这样的K歌产品，还是一片蓝海，这对唱吧来说有着不错的发展机遇；另一方面，在全民K歌、抖音、快手等平台影响下，国内的互联网娱乐市场空间变窄，唱吧要想继续在此环境中发展将受到不小的阻碍。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	总的来说，虽然上市会为唱吧带来新的发展机遇，但在市场竞争加剧、股市动荡等问题影响下，此时上市，对唱吧来说有着较大风险。因此，唱吧只有继续精细化运营，加强线上线下融合，并等待时机成熟后再进行上市，才会迎来更好的发展。\r\n</p>',	'doc.png',	0.00,	41,	0,	0,	0,	'2019-12-03 14:17:25',	'admin',	3,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	0.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	14,	1,	0,	1),
(129,	'方志敏长孙斥地方巨资建方志敏干部学院:形象工程',	'<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	换上炫彩外壳，装上多变口味的烟弹，上市多年的电子烟今年突然热度飙升，成了备受追捧的创投领域。除了罗永浩在发布会上顺势推销的福禄电子烟，2018年末到2019年初，还有近10个新兴电子烟品牌出现。在深圳华强北电子市场，出售电子烟的广告牌更是如雨后春笋般涌现。但面对日趋严密的控烟大网，创业者们能否咽得下“这口烟”仍存在极大变数。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\"> <strong>电子烟突然变网红</strong> \r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	蓝莓、菠萝、水蜜桃、绿豆冰棒、柠檬茶……说到这些，不少人会联想到口香糖或是冰淇淋，却几乎没人能想到，这些全都是电子烟推出的新口味。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	精巧如U盘或是一根签字笔，也不用点火，从口袋里掏出来，打开开关就能用——近一年来，以电子产品形象出现的电子烟成了创投领域的新网红。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	今年1月，罗永浩在子弹短信新版本“聊天宝”发布会上，顺势推销了一款名为福禄、由锤子科技二号人物朱萧木创业推出的电子烟产品。紧接着，同道大叔创始人蔡跃栋与黄太吉创始人赫畅推出的“YOOZ柚子”，5位自媒体人组成创始团队的“灵犀&nbsp;LINX”也纷纷杀入。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	猪年春节，常年浸淫在科技圈、创投圈的自媒体人士陈女士惊讶地发现，平日里不抽烟的她，竟然收到了3种不同的电子烟产品作为新年礼物。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在深圳华强北，曾经卖VR眼镜、贴牌手机和智能家居产品的柜台，纷纷开始转售电子烟。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	突如其来烧起来的电子烟，背后是资本不断添柴加火。2018年，国内有十几家电子烟公司获得资本青睐，总融资额达数亿元。Wel鲸鱼、YOOZ柚子、魔笛MOTI、TRYMIX反正、GOIN谷云、APOC……新兴的电子烟品牌让人目不暇接，俨然造就了岁末年初最火热的创业领域。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\"> <strong>风口背后的同质化</strong> \r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“电子烟界的iPhone”、“颜值爆表一口解馋”、“重新定义吸烟”……在各家打出的广告语中，几百元一支的电子烟似乎成了可供电子发烧友们品玩一番的电子玩具。然而，花哨热闹的营销语言背后，电子烟的实质技术并没有太大区别。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“花几个月到半年时间，联系供应商、备货、外观设计，剩下就不需要你再做什么了，几乎没有任何硬性投入，本质上是个非常‘轻’（投入）的生意。”早期投资人付强向媒体透露，做一个电子烟项目，对技术等原创能力的要求几乎没有门槛。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	多位行业人士透露，由于国内电子烟供应链已经被电子烟发展较为成熟的国外市场培育得非常完备，因此很多新创立品牌都是通过代工生产。有技术爱好者对几款热门电子烟进行评测后发现，几个品牌在开关控制、烟油技术等方面相差无几，只是烟弹、外壳颜色、口味等进行了不同的排列组合与拼凑。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“电子烟的产品结构并不复杂，主要构成也就是充电电池（烟杆）、雾化器还有烟油三部分。”新晋电子烟品牌灵犀创始人章晋源坦言，电子烟的制造门槛并不高，确实存在行业同质化问题，“灵犀LINX当前着重聚焦于品牌环节，属于产业链下游，希望设计的首款产品具有品牌辨识度。”\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\"> <strong>电子烟也有多重风险</strong> \r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“清肺水果味”、“健康清肺蒸汽烟”……稍加留意就会发现，不少电子烟公司将产品与健康挂上了钩。在他们口中，因抽烟承受健康风险的烟民可以通过电子烟追求潮流文化、拥有“健康生活方式”。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	电子烟是否能够像一些公司所说的那样起到“代烟”、“辅助戒烟”的功效？目前尚无定论。令人担忧的是，一些原本不吸烟的人因为对电子烟的好奇而加入了烟民行列。在游戏公司工作的白先生告诉记者，他的同事和合作伙伴里出现了好几位新一代“电子烟民”——而他们过去根本不碰香烟。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	北京营养师协会理事顾中一提醒，电子烟中虽然没有普通烟草燃烧所产生的焦油、一氧化碳等有害物，但仍然含有有毒、成瘾的尼古丁，对普通人特别是儿童、青少年仍然有危害。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	记者在一家电子烟的天猫店铺内发现，虽然商品详情页面的底部用黑色背景的字体写着“未满十八岁不允许购买”，但一不留神就会错过这一信息。并且，记者在尝试下单时，店铺对身份信息、年龄等方面毫无要求，消费者可以随意下单购买。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	顾中一还提醒，由于目前市场监管并没有完全到位，缺乏相关国家标准，电子烟产品中用到的原料、调味剂、工艺都较为随意，厂家很可能为了增加新奇体验加入一些对人体有害的物质。“哪怕是一些比较常见的添加剂，正常食用是安全的，吸入肺部却可能带来潜在风险。比如丙二醇是很常见的食品添加剂，但是燃烧后容易刺激呼吸道，一些电子烟的烟雾中也可能含有重金属。”\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	对创业者来说，更大的考验来自于市场的不确定性。在控烟大势下，多地已经将电子烟列入了管控范围。今年2月，继杭州、南宁等城市在公共场所禁止使用电子烟之后，深圳在其控制吸烟条例征求意见稿中将电子烟纳入了控烟“黑名单”。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	意识到道德、法律等多重风险，一些科技上市公司急于与电子烟划清界限。今年2月中旬，小米公司官方微博就对“小米旗下生态链公司将进军电子烟领域”一事进行回应，称“小米不会做电子烟，此事纯属谣言”。\r\n	</p>',	'doc.png',	1.00,	1,	0,	0,	0,	'2019-12-03 14:18:03',	'admin',	2,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	1.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	3,	1,	0,	1),
(130,	'北京发布追逃成绩单：追逃66人 阻止42人外逃',	'<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	2018年可谓是中国智能音箱的元年。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	业内普遍认为，智能音箱是切入智能家居使用场景、并易于被用户接受的理想入口，而智能家居的开关一旦被打开，更多的产品和服务将快速进入消费者的日常生活，获得一个更多元的商业环境。因此，近两年国内外科技巨头、互联网巨头皆大力发展智能音箱，使得该领域得到飞跃式增长，并从小众逐渐走向大众。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	值得一提的是，智能音箱除了具有巨大的消费市场外，对于互联网巨头们来说更起到AI市场的“门票”的作用。在这个快节奏的时代，企业之间的竞争更加激烈，率先拥有某一行业的门票就相当于成功了一半。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	由此，继国外亚马逊、谷歌、Facebook、苹果等科技巨头布局智能音箱产业之后，国内如阿里、百度等巨头也纷纷入局，小度智能音箱、叮咚、天猫精灵等产品在市场活跃度直线上升，国内智能音箱市场一片繁荣，随后在去年打起了“智能音箱价格战”。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	全球互联网巨头共掀全球智能音箱浪潮\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	根据Strategy Analytics发布的《2018年第三季度全球智能音箱市场报告》，2018年第三季度全球智能音箱出货量达到2270万，同比增长197%，创历史新高。其中，亚马逊智能音箱的全球份额与2017年相比有大幅下降，但出货量一直在上涨，第三季度市场占有率依然最高，达到32%，而谷歌以23%的市场占有率紧追其后。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	值得一提的是，来自中国的阿里、百度、小米智能音箱出货量分别排在全球第三、第四、第五位。当中又以百度表现最为亮眼，其市场占有率从2018年Q2的1％增加到2018年Q3度的8％，超越小米，成为当之无愧的黑马。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	而根据eMarketer《2019年智能音箱市场趋势观察》的预测，2019年中国将拥有8550万智能音箱用户，超过美国7420万的用户数量。智能音箱在美国网民中的普及率为26.0%，远高中国的10.0%，因此未来中国智能音箱领域还有极大的发展空间。不过即便如此，国内企业想要在智能音箱领域进一步发展仍有极大挑战。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	首先，是亚马逊、谷歌、苹果等海外企业更加成熟的智能音箱产品的冲击。亚马逊于2014年11月发布了Echo音箱，揭开智能音箱的序幕，打了人工智能领域“领头羊”谷歌、设备领域“领导人”苹果一个措手不及，成为智能音箱领域的第一人，为其之后进军智能家居领域打下基础。随后谷歌、Facebook、苹果等科技公司纷纷跟进，相继推出GoogleHome、Portal、HomePod。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	而后，无论是亚马逊并购互联网路由器初创企业Eero，还是谷歌推出Google Wifi，都表明国外在智能家居领域发展正愈加成熟，由此给国内市场带来的冲击是巨大的。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	其次，是国内错综复杂的智能音箱市场而产生的原生阻力。国内智能音箱市场厂商繁杂，主要有五种类别：一是以BATJ等为主的互联网公司，希望通过语音这一入口建立智能生态，为既有的内容和服务寻找新市场；二是以科大讯飞为代表的，专注于技术开放平台建设的技术厂商；三是以喜马拉雅等内容厂商；四是主打智能家居的创业公司；五为以漫步者为代表的传统音箱厂家。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	与国外相比，国内智能音箱领域除了厂商更繁杂、竞争更激烈外，在时间上也有一定的滞后性。国内第一款智能音箱叮咚诞生于2015年，由京东与科大讯飞联合推出。此后国内智能音箱市场沉寂，直至2017年阿里试探性地推出天猫精灵，小米、百度等企业不甘落后，纷纷入场，国内智能音箱才进入密集发售期，一时间智能音箱领域热闹非凡，“百箱争鸣”。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	当先天不足遇上恶劣生存环境\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	当下，我们不能否认的是，随着家庭中联网设备的不断增加，有极大几率成为未来智能家居控制中枢的智能音箱有着非同一般的重要性。但古往今来，利益有多大，风险就有多大。对于如钥匙般的智能音箱领域来说，发展面前有三问需解答。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	首先，智能音箱如何“智能”？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	每当市场有了新的风口，就会出现无数跟风之人，智能音箱也不例外。为搭上智能音箱的顺风车，传统音箱厂家推出不少产品，只不过卖点都集中于音质，本末倒置。 另外，“语音识别技术”也是尚未完善，一方水土一方人，同一语种还有不同口音，更别提各地方言以及语境涉及到的自然语言理解问题。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	除此之外，还有人工智能和物联网领域中老生常谈的安全隐患问题，如数据存储、身份认证、敏感数据保护等，在此不多赘述。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	其次，智能音箱如何提高普及率与使用率？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	我们知道，物联网时代“未来智能家居的控制核心”这一定位是智能音箱如此火热的重要原因之一。而理想的智能家居生态并非是家居单品的智能化，而是彼此联动，达到互联互通互控的状态，但目前的智能家居系统仍旧处于互相独立的状态，使得智能音箱使用率不高，如同“鸡肋”。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	与国内相比，国外在此方面就先进得多，以美国为例，美国的智能家居行业有统一的标准协议，亚马逊的Echo可以直接接入各种智能家居设备，这也是为何美国智能音箱普及率远高中国的原因。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	最后，国内企业如何“走出去”？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在用户习惯方面，国内外有着不小的差异。以使用环境为例，国外用户居家环境多为开放式，美国家庭主妇在烹饪时都喜欢听音乐，因此智能音箱在国外的消费需求也相对较高。而国内，厨房客厅封闭性更高，生活环境相对嘈杂，相应地市场对智能音箱需求较低。此为国外厂家难以进入中国市场的重要原因之一，另一限制则是人机交互的“本土化”程度低。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	以苹果HomePod为例，虽然其Siri语音助手对中文的支持已经有一定成果，但在交互、理解能力等方面，与本土选手阿里、百度相比仍是落后。并且，以BAT为代表的国内企业拥有更多本土资源，境外企业如苹果，很难在中国有突破性进展。同理，国内企业想要走出去也会遇到同样的难题。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	综上，智能音箱可谓是“腹背受敌”，而现阶段各巨头发展智能音箱的主要目的并不是盈利，而是抢占更多的用户家庭，为未来AI生态建设进行数据铺垫。那么，中小企业如何在这场战争中存活呢？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	双重风暴下，智能音箱可靠内容过冬\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	前文提过，国内有一类以喜马拉雅为代表的注重内容的智能音箱厂商，笔者认为现阶段此类厂商可能更好存活。现今用户对智能音箱的主要需求还处于“听”的情况下，智能音箱很大程度上是内容生态之争。在此基础上，喜马拉雅以自身丰富的内容为基础，推出智能音箱小雅，将更容易在家庭场景中突围。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	虽然从整体上看，喜马拉雅与BATJ等互联网巨头在技术和未来AI整体布局上存在相当大的弱势，但由于各种原因的限制，国内用户对智能音箱的需求在接下来很长一段时间里，都将处于“听”的阶段。并且，智能音箱核心技术“语音识别”，从本质上来说也是内容的一部分。从另一角度看，喜马拉雅的竞争对手也并非是BATJ等互联网巨头，其在智能音箱领域的发展更多的是为了扩充自身音频业务，巩固自身在在线音频市场的地位。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	同样的，在内容资源上有着强大优势的还有腾讯，毕竟现阶段消费者购买智能音箱的主要用途就是内容消费和智能家居两方面。在此基础上，腾讯可将自身音乐、阅读和视频整合，为智能音箱做内容支持。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	除了内容消费，“智能音箱+教育”的模式发展空间也十分广阔，尤其是早教领域。抛开说烂了的在线教育，光是国人对子女教育的重视程度，就足以让智能音箱注意到“早教”这一领域。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	单从目前智能音箱市场情况来看，短时间内C端消费市场的表现都比不过B端。因此，如何在B端站稳脚跟再最终反哺C端，是智能音箱发展过程中相当重要的一点。站在这个角度上看，“智能音箱+早教”的未来十分令人期待。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	毕竟，国内早教行业师存在资水平有限，地域发展不平衡，多数幼师仅经过短期培训就上岗从业，专业化程度低等问题。若是将智能音箱与早教结合，它所承载的大量专业、系统、科学的早教课程，能完美弥补传统绘本、书籍、视频等的缺点，再加上其操作简单、安全性高、不损伤视力的优点，能让智能音箱成为早教过程中不可或缺的工具。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	当然，除了以上两个方向，智能音箱作为人工智能音频端的入口，能够发展的B端场景是十分丰富的。就此，在C端市场来临前，国内非巨头企业在智能音箱领域也有了新的突破口。那有没\r\n</p>',	'doc.png',	1.00,	19,	0,	0,	0,	'2019-12-03 14:18:52',	'admin',	4,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	1.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	4,	1,	0,	1),
(131,	'还剩8条命？小猫洗衣机里被“洗”20分钟幸存(图)',	'<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	社交网络下一步发展的未来在何方？6日，Facebook创始人扎克伯格给出了自己的答案。在一篇长达3200字的公开博客文章中，这家全球最大的社交网络的掌门人称，未来Facebook将专注于营造一个更为私密和安全的网络社交环境。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	“当我思考网络的未来，我认为专注于隐私的通讯平台相比今天的开放平台，将变得更加重要，”扎克伯格写道：“今天我们已经看到私密消息、短故事分享和小规模群组是在线通讯交流发展最快的领域。”\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	尽管扎克伯格认为，开放社交网络在未来仍有一席之地，但更大的机会在于“建立一个首先专注于隐私的更为简单的平台。”\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	扎克伯格称，在过去15年间，Facebook和Instagram帮助建立了一个“数字化的公开广场“，但人们开始迫切需要更为私密的”数字化的客厅空间“。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	对于Facebook来说，这将是一个具有里程碑意义的转型，成立15年来，Facebook成功打造了全球最大的公开社交网络，并在此基础上建立起一家以广告业务为主的商业帝国。但近年来，随着一系列与用户数据隐私泄漏相关的丑闻接连爆发，Facebook开放社交模式遭遇到前所未有的严峻挑战。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	正是由于内外部坏境发生的变化，促使Facebook开始思考接下来的转型方向，如今，这家全球最大的社交网络通过其掌门人的一封公开信给出了解答。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	“我认为未来的通讯将更多地转向私密的、加密的服务，这样人们在与别人交流时，对于信息的安全新、内容不会停留会更有信心，”扎克伯格说，“这是我希望我们能够帮助带来的未来。”\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	为了达成这一目标，扎克伯格称，Facebook即时通讯平台将向Whatsapp的模式靠拢，未来端到端的加密服务将贯穿于Facebook所有旗下包含即时通讯的业务功能，该表态印证了此前外界流传的Facebook计划打通旗下即时通讯功能的传言。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	扎克伯格称，计划按照打造WhatsApp的模式进行：专注于最为基本和私密的应用场景即时消息开始，让其尽可能的安全，然后在此之上建立更多让人们能够互动的方式，包括打电话、视频聊天、群组、故事、商业、支付最终成为更多私人服务的平台。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	为了实现这一转型目标，扎克伯格列出了数项准则，包括加密、缩短内容的存续、安全、互通和安全数据存储。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	“我相信我们应该朝着建立这样一个未来世界而努力：人们可以私下说话并且知道他们的信息只会让他们希望看到的人看到并且不会永远存续下去，“扎克伯格说，”如果我们能够帮助世界朝着这个方向发展，我将会为我们所做出的努力感到自豪。“\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	以下为扎克伯格公开博客全文：\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	注重隐私的社交网络愿景\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	过去几年，我的重点一直是理解和应对Facebook面临的最大挑战。这意味着对关系到互联网未来的重要问题采取什么立场。在本文中，我将概述Facebook围绕建立以隐私为中心的信息和社交网络平台的愿景和原则。有许多的事情要做，在开发的进程中，我们承诺开放式的工作，并将与全社会的专家进行协商……\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	过去15年间，Facebook和Instagram一直在帮助人们与友人、社区和等同于数字城市广场中的兴趣联系在一起。但是人们也越来越想私下在相当于起居室的数字环境中进行交流。当我思考互联网的未来时，我认为一个注重隐私的交流平台将变得比今天的开放平台更加重要。隐私让人们有自由做自己，更自然地联系，而这些是我们建立社交网络的原因。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	今天，我们看到私有信息、短暂的故事和小型群组已成为在线通讯中增长最快的领域。这有许多原因。许多人更喜欢一对一交流，或者只是与几位朋友交流。人们对分享有永久记录的内容更加谨慎。我们也都希望能够私下和安全地进行支付。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	公共社交网络将继续在人们的生活中发挥重要作用--与你认识的每一个人联系；发现新的人、想法和内容；让人们有更广泛的发言权。人们每天都会发现有价值的内容，而且还有很多有用的服务可以构建在它们之上。但是现在，人们也想通过各种方式私下交流，这也让我们有机会打造一个首先专注于隐私、更简单的平台。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	我明白很多人不认为Facebook有能力、或者甚至不想构建这种以隐私为中心的平台，因为坦率地讲，我们目前在构建隐私保护服务方面没有很好的声誉，而且我们一直专注于更开放的共享工具。但是我们已多次表明，我们可以通过进化来打造人们真正想要的服务，包括私有信息和故事。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	我认为，通信的未来将越来越多地转向私有、加密服务。在此类服务中，人们可以确信他们对彼此说的话是安全的，他们的信息和内容不会永远存在。这是我希望我们能帮助实现的未来。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	我们计划用开发WhatsApp的方式来构建这一平台：专注于最基本和私有用例--消息--尽可能确保它的安全性，然后构建更多的方式让人们在此基础上进行互动，包括通话、视频聊天、群聊、故事、商业、支付、商务，最终成为许多其他类型的私有服务的平台。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	这个注重隐私的平台将围绕以下几个原则构建：\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	·私下互动：人们应该拥有简单、亲密的场所，在那里可以清楚地控制谁可以和他们交流，并且相信没有人可以接触到他们分享的内容。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	·加密：人们的私人通信应该是安全的。端到端加密防止任何人，包括我们在内，看到人们分享在我们服务中的内容。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	·减少永久性：人们应该感到自在，不应担心他们分享的内容会反过来伤害自己。因此，我们不会将信息或故事保留超过提供服务所需的时间，也不会超过人们希望它们留存的时间。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	·安全：人们应该期待我们会尽一切努力，在加密服务可能的范围内，确保他们在使用我们服务时的安全。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	·互操作：人们应该能够使用我们的任何应用联系他们的朋友，应该能够轻松安全地通过网络交流。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	·安全数据存储：人们应该期待我们不会在隐私和言论自由等人权记录薄弱的国家存储敏感数据，保护数据被不当访问。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	未来几年中，我们计划围绕这些想法重建更多的服务。在此行程中，我们面临的决定将意味着对关系到互联网未来的重要问题采取什么立场。我们清楚有很多权衡需要纠正，我们承诺与专家进行协商，并讨论最佳的前进方向。这需要一些时间，但我们不会关着门朝着这个方向发展。我们将尽可能以公开、合作地态度这样做，因为其中许多问题影响到社会的不同层面。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	私下互动是基础\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	要让一项服务感觉具备私密性质，绝不让用户怀疑在和谁交流。我们努力在所有产品中建立隐私属性，包括公共分享产品。消息服务的一个重要特性是，即使用户的联系人列表在扩充，用户的个人线程和群组仍然是私有的。随着时间的推移，用户的好友会逐渐发展，消息服务会优雅地发展，并保持亲密。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	这与更广泛的社交网络不同。在社交网络中，人们可以积累好友或追随者，直至服务更加公开。这非常适合许多重要的用途--告诉用户所有的朋友一些事情，在重要的话题上传递用户的声音，寻找有相似兴趣的人群，追踪创作者和媒体，买卖东西，组织筹款人，发展业务，或者让用户认识的每一个人在相同的地方得到好处。尽管如此，当用户一起看到所有这些经历时，感觉更像是一个城镇广场，而不是一个更私密的空间，比如客厅。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	我们有机会建立一个关注人们想要私下交流的所有方式的平台。这种隐私和亲密感不仅仅是技术特征--它被深深地融入到服务的整体感觉中。举例来说，在WhatsApp当中，我们的团队专注于在产品的各个方面创造一个亲密的环境。即使我们构建了允许更广泛分享的功能，这仍然是一种不太公开的体验。当团队开发群组功能时，他们设定了规模限制，以确保每一次互动都是私密的。当我们在WhatsApp上发布故事时，我们限制了公共内容，因为我们担心这种做法可能会削弱隐私感--即使这并没有真正改变用户和谁分享。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	几年后，我预计未来版本的Messenger和WhatsApp将成为人们在Facebook网络上交流的主要方式。我们致力于让这两款应用更快、更简单、更私密、更安全，包括端对端加密。然后，我们计划增加更多与好友、团体和企业私下交流的方式。如果这种进化成功，通过Facebook网络与用户的好友和家人互动，将会从根本上成为一种更加私密的体验。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	加密与安全\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	人们期望他们的私人通信是安全的，并且只被收方看到，而不是黑客、罪犯、过度干预的政府，甚至是操作正在使用的服务的人。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	人们越来越多的意识到，更多的实体可以访问自己的数据，就越容易被人滥用或被网络攻击泄露。一些人也越来越担心，技术可能会将权力集中在政府和像我们这样的公司手中。一些人担心我们的服务可能会访问他们的信息，并将其用于广告或其他他们不期望的方式。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	端到端加密是开发注重隐私的社交网络的重要工具。加密正在分散--它限制了像我们这样的服务看到流经的内容，并使其他人更难访问用户信息。这就是为什么加密在我们的网上生活中越来越重要，从银行到医疗健康服务。这也是为什么我们在收购WhatsApp后把端到端加密植入WhatsApp中的原因。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	去年，我曾与持不同政见者交流过。他们告诉我，加密是他们自由甚至活着的原因。一些政府经常对数据提出非法要求，当我们在法庭上驳回这些要求时，我们总存在败诉的可能--如果信息没有加密，我们要么必须交出数据，要么不遵守法庭规定导致员工被逮捕。这看起来很极端，但是我们曾有过这样的案例，一名员工就因为不提供对某人私有信息的访问而身陷囹圄。事实上，我们也无法访问这类信息，因为它是加密的。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	与此同时，在我们能够在所有消息服务中部署端到端加密之前，我们需要解决真正的安全问题。加密是保护隐私的有力工具，但也包括做坏事的人的隐私。当数十亿人使用同一服务连接时，他们中的一些人会将它滥用于真正可怕的事情，比如剥削儿童、恐怖主义和敲诈勒索。我们有责任与执法部门合作，并尽所能帮助防止这些行为。我们正努力通过检测活动模式或其他方式，来提高识别和阻止应用中不良行为的能力，即使我们看不到消息的内容，我们将继续对这项工作进行投资。但是我们面临着一个内在的权衡，因为当我们的安全系统能够看到这些信息时，我们永远也不会发现我们今天所做的所有潜在伤害。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	找到保护隐私和安全的正确方法，是社会在历史上一直努力解决的问题。这里还有许多悬而未决的问题，我们将与安全专家、执法部门和政府协商实施安全措施的最佳方式。我们还需要与其他平台合作，以确保整个行业能做出正确的事情。我们越是能创造一种共同的方法越好。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	总的来说，我相信为所有私人通信实施端到端加密是正确的。人们通过信息和电话完成一些最敏感的私人谈话，在网络安全威胁日益增加、许多国家政府干预过度的情况下，人们希望我们采取额外措施来保护他们最私密的数据。对我而言这似乎是对的，只要我们花时间构建适当的安全系统，尽可能在加密服务的范围内阻止不良行为。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	我们已开始在WhatsApp的基础上开发这些安全系统，在全面实施端到端加密之前，我们将在2019年及以后与专家讨论这些系统。随着我们从专家那里学到更多的知识，我们将最终确定如何推出这些系统。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	减少永久性\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	我们越来越相信在短时间内保存信息非常重要。人们想知道他们分享的信息不会反过来伤害他们，减少他们信息的存储和访问时间会有所帮助。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	“永久性问题”开发社交工具的一个挑战是。随着时间的推移，我们积累了大量的信息和照片，它们在成为资产的同时，也成为了一种负担。例如而言，许多Facebook的老用户可能会有年轻时候的照片，这可能会让人尴尬。但是人们也非常喜欢记录他们的生活。如果Facebook和Instagram上的所有帖子都消失了，人们将无法获得他人分享的大量宝贵知识和经验。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	我认为有机会为私有通信平台设定一个新的标准--内容会自动过期或随时间归档。除非用户存档，否则故事会在24小时后过期，这让人们更自然地分享。这种理念可以扩展到所有私人内容。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	举例来说，在默认情况下，信息可以在一个月或一年后删除。这将降低用户的信息再次出现并让他以后尴尬的风险。当然，如果用户愿意，可以自己改变时间框架或者关闭线程的自动删除。如果用户愿意，我们还可以为用户提供选项，让他将个人信息在几秒钟或几分钟后设置为过期。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	限制我们存储消息元数据的时间也有意义。我们使用这些数据来运行我们的垃圾信息和安全系统，但我们并不总是需要长时间保留这些数据。解决方案的一个重要部分是首先收集较少的个人数据，这也是WhatsApp从一开始就建立的方式。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	互操作\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	人们希望能够选择他们用来与人交流的服务。然而，今天如果用户想在Facebook上给人们发信息，你必须使用Messenger；在Instagram上必须使用Direct；在WhatsApp上必须使用WhatsApp。我们想给人们一个选择，这样他们可以通过这些网络从他们喜欢的任何一款应用联系他们的朋友。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	互操作性有隐私和安全优势。举例来说，许多人使用Android上的Messenger收发短信。这些文本不能进行端到端加密，因为短息协议没有加密。然而，有了跨我们服务传递信息的能力，用户就可以从Messenger向WhatsApp中的某人的电话号码发送加密短信。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	这还可以提高许多体验中的便利性。在这些体验中，人们使用Facebook或Instagram作为他们的社交网络，WhatsApp作为他们首选的消息服务。举例来说，许多在市场上出售商品的人会列出他们的电话号码，这样人们就可以发送与购物相关的信息。这并不理想，因为用户要给陌生人提供电话号码。有了互操作性，用户就可以使用WhatsApp接收发送到Facebook账户的信息，而无需分享电话号码--买家也不用担心卖家是喜欢在哪个网络发信息。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	可以想象许多类似这样的简单体验--一个人在Instagram上发现了一家公司，并很容易过渡到他们喜欢的消息应用，以获得安全的支付和客户支持；另一个人想追上一个朋友，可以向他们发送一条消息，发送到他们喜欢的应用，而不必考虑这个人喜欢在哪里被联系；或者用户只需在Facebook和Instagram上发布一天的故事，就可以在一个地方得到好友的所有回复。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	今天，用户已可以通过Android上的Messenger发送和接收短信，我们希望在未来进一步扩展这一功能，或许包括新的电信RCS标准。然而，在这成为可能之前，我们需要解决几个问题。首先，苹果不允许应用在他们的设备上与短信交互操作，所以我们只能在Android上这样做。其次，我们需要确保互操作性不会损害人们已使用WhatsApp的加密预期。最后，它会在加密系统中造成安全漏洞和垃圾邮件漏洞，让人们从未知的应用中发送信息，因为我们的安全和安保系统看不到这些活动的模式。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	这些都是重大挑战，有许多问题需要进一步协商和讨论。但是，如果我们能够实现这一点，我们就可以给人们更多的选择，让他们使用喜欢的服务，以安全地联系到他们想要联系的人。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	安全数据存储\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	人们想知道他们的数据安全地存储在他们信任的地方。展望互联网和隐私的未来，我认为我们将做出的最重要的决定之一是：在哪里建立数据中心和存储人们的敏感数据。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	在一个国家提供服务和在那里存储人们的数据有着重要的区别。当我们在世界各地建设基础设施时，我们选择不在有侵犯隐私或言论自由等人权记录的国家建设数据中心。如果我们在这些国家建立数据中心并存储敏感数据，而不仅仅是缓存非敏感数据，这可能会让这些政府更容易获取人们的信息。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	坚持这一原则可能意味着我们的服务在一些国家会受阻，或者我们不能很快进入其他国家。这是我们愿意做出的折衷。我们不认为在一些国家存储人们的数据是一个足够安全的基础，可以在其上建立如此重要的互联网基础设施。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	当然，保护最敏感数据的最佳方法是根本不存储它，这就是WhatsApp不存储任何加密密钥的原因，我们计划在以后的其他服务中也这样做。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	但是在更多国家存储数据也开创了一个先例，鼓励其他国家政府寻求更大程度地获取其公民的数据，从而削弱了全世界人民的隐私和安全保护。我认为，对于互联网和隐私的未来而言，我们的行业继续坚决反对把人们的数据存储在得不到安全保障的地方，这一点很重要。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	下一步举措\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	在接下来的一年及以后，我们还要制定出与这些原则相关的许多细节和权衡。这项工作中的许多仍处于早期阶段，我们致力于与世界各国的专家、倡导者、行业合作伙伴和政府(包括执法部门和监管机构)协商，以正确做出这些决定。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	与此同时，通过这些原则开展工作只是构建以隐私为中心的社交平台的第一步。除此以外，我们还需要对在此基础上构建的所有服务进行深入思考--从人们如何支付和金融交易，到企业和广告的作用，再到我们如何为其他私人服务提供平台。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	但是，这些最初的问题得到正确答案是至关重要的。如果我们做得好，我们可以创建私人共享平台，这对于人们而言可能比我们建立的帮助他们更公开分享和联系的平台更重要。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	这意味着对关系到互联网未来的重要问题采取什么立场。作为一个社会，我们有机会阐明我们的立场，决定我们如何重视私人通信，以及谁来决定数据应该存储多长时间以及存储在哪里。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	我认为我们应该努力实现这样一个世界，让人们可以私下交谈，自由生活，知道他们的信息只会被他们想看到的人看到，而且不会永远停留在身边。如果我们能帮助世界朝着这个方向发展，我将为我们所取得的成就感到自豪。\r\n</p>',	'doc.png',	1.00,	8,	0,	0,	0,	'2019-12-03 14:19:38',	'admin',	1,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	1.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	3,	1,	0,	1),
(132,	'中国新型舰载侦察无人机曝光 还能当预警机用(图)',	'<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	今年两会期间，明星委员们的提案再次将炮火对准了劣迹艺人、明星及影视数据造假、身价片酬等行业乱象，不过前方固然慷慨激愤，后方还是其乐融融，#明星该不该吃粉丝送的食物#、#明星被认错#等话题频繁被推上热搜，娱乐氛围依旧。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	但今年还是有些许不同，2018年影视连续震荡所牵引出的政策新规，将在今年集中落地并被检验效果，前段时间，吴秀波、翟天临事件又掀起公众对娱乐圈造假的口诛笔伐。换句话说，娱乐产业规则改写的时机，可能已经同时具备了政策自上而下和舆论自下而上的两个必要条件。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	若是如此，数据造假将成第一个靶子，而往后推，数据造假的一环如果被铲除，是否能动摇当前畸形的粉丝经济呢？这是值得业界探讨的。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	造假产业链的逆向思考\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	2019年开年，《人民日报》发表文章，矛头直指流量明星锁场、刷榜、买粉丝，而后其又连续发表微博，感慨“明星流量数据节节攀升，8亿网民不够用”。随之跟进的还有《光明日报》《北京日报》，而“紫光阁”则从1月5日-9日，连发4条微博，痛批流量明星，呼吁“没有高质量作品做支撑，那些拙劣的表演终将被揭穿”。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	影视产业春寒料峭，一场“打假运动”的兴起，或许正是今年的新风向。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	微博已率先做出反应，宣布针对转发、评论计数显示方式在内做出种种调整，而更早之前，爱奇艺和优酷停止了播放量的展示。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	这对于影视数据脱水进而回归合理无疑是一个有利信号，视频及社交平台本身就是流量造星、粉丝运营的核心媒介，隐藏播放量起码减掉了数据造假的一个需求。虽然不得不承认，这一举措对整个行业来讲，也只是让数据造假不至于假得太“难看”，但其释放的市场信号是积极的：影视数据造假的乱象，今年或许不会止于揭露。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	以此为基础，我们再来看影视产业数据造假的产业链。一般来讲，卖方一端通过雇佣技术型或人工型水军，提供刷流量业务，至于买方一端，央视将明星数据造假的推手，归为自发组建的粉丝组织和经纪公司安排成立的明星微博数据站。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	两方需求契合，流量明星通过这一番操作获取一定的人气和地位，从而掠取演艺资源。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	而提供演艺资源的制片方、投资方以及媒体平台，又因流量明星的参与而收割商业利益，当然，这其中更少不了购买数据用以打榜、投票、转发的过程。无奈的是，这已成为市场优胜劣汰的“规则”，如果粉丝的偶像数据不好，就会被其他艺人的粉丝“唱衰”。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	由此可以看出，流量经济是一个参与方都可获得经济效益的模式，这也决定了很难从内部去戳破流量泡沫。但如今政策导向下，很有可能从外部强制性切断数据造假产业链，若是如此，会对以流量为基础的粉丝经济造成什么伤害？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	我们可以逆向推断，假使数据归真，流量明星及其所产出的内容，在市场的反应能够一目了然，首先最可能放弃他们的就是内容生产方。因为对比靠实力说话的演员，流量明星原本与之天差地别的流量优势，很大程度上被削弱了，而今口碑反噬又日渐严重，制片人也不再经得起多次的扑街。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	相应地，流量明星的演艺资源一旦被缩减，曝光度大大降低，广告商、媒体以及平台很快便“闻风而动”。更关键的是，明星本人新粉难增、旧粉流失，长此以往就更没有商业价值了。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	流量经济还是粉丝经济？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	当娱乐产业的优胜劣汰逐渐被流量所左右，如果从流量数据本身出发，一定程度上是可以约束某些行业乱象的滋生。但是流量缩减、粉丝仍在。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	蔡徐坤被央视点名时，震慑是对业内的，粉丝看似不惧。真爱粉们一面为爱豆打抱不平，力挺蔡徐坤确实是个专注音乐的好歌手，甚至表示之前做了那么多公益怎么不提？另一面又将攻击点集中到微博上，强烈要求整改。不过，前者是顾左右而言他，后面则是祸水东引，实则都没什么逻辑。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	从这件事直观地看，粉丝本身就是流量的一部分，即使最大程度地将流量数据脱水，蔡徐坤、鹿晗这类当前比较符合年轻群体审美的明星，也仍有不在少数的粉丝存留，他们才是饭圈的核心。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	换句话说，粉丝即使不花钱为他们的偶像刷流量，他们还是有其它方式向外界传达和证明自家爱豆的价值，甚至可以简单的说，只要粉丝愿意为爱豆花钱，在制片人和品牌方眼里，明星便有商业价值。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	这主要是因为当前的影视行业中，<strong>粉丝看似处于被收割的产业下游，实则主导着偶像的人气和商业吸引力。</strong> \r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\"> <strong>一方面，粉丝已经参与到偶像的职业规划中，用自己的力量为偶像争取好资源。</strong>而市场也认可了这种做法，现在广告商、制片方最看重的，不再是明星的业务水平，而是背后的粉丝力量。所以，纵然市场能抛开流量数据，演员和明星粉丝群体的差别，也无法使商业资源偏向前者。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\"> <strong>另一方面，如今流量明星的粉丝展现出强大而可怖的集体力量，如果不再允许数据造假，他们对舆论的影响也能帮助明星维持流量再造。</strong>极端一点，像粉丝骂战、撕逼这种普遍现象，一经推手，在当前这个碎片化时代便是天然的流量爆发点。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	所以，<strong>数据打假所能纠正的也只是流量经济，而触及不到更深层次的粉丝经济。</strong> \r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	时至今日，粉丝和流量的先后产生顺序已经模糊，这就是数据造假导致的，不过粉丝是基础，流量经济可以说是在资本介入、疯狂膜拜粉丝效应之后被放大的形态。这和移动互联网时代流量为王的思维，实则异曲同工。不过移动互联网进入下半场的服务升级，娱乐产业的流量经济反而日渐衰颓了。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	明星“死于”粉丝？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\"> <strong>围绕粉丝和明星的行业规则及利益链一旦形成，实际上就连一个环节的整治都很难，更不要指望其内部会自我改进。</strong>但值得庆幸的是，当前流量经济之所以逐渐露出真相，在于其外部的反对力量日益强大，也催促市场形成一套新的淘汰法则。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	最明显的是电影界，流量明星的多番试水，让投资方再也经不起折腾。2016年“小鲜肉+大IP”的模式备受追捧，2017年参与暑期档大战的流量明星只有杨洋、李易峰两人，而到2018年暑期档、春节档，杨洋、鹿晗等人早已不见踪影。李易峰的《动物世界》即使备受肯定，票房仍不能回本。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	数据显示，2018年全国电影票房已经超过2017年总票房559.11亿元，创下新纪录，但票房前十的影片主演中均不见小鲜肉身影。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	流量明星开始被排斥在大荧幕之外，而且他们在业内留下的印象一旦被定性，投资人只会对他们避之不及。而下一个排斥流量的便是观众，这很容易让流量明星丧失转型的时机，甚至是永久被划在攻击的范围之内。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	这是口碑反噬的副作用，比如《创业时代》开播之初，很多人还没看剧，只知道有杨颖主演便给出了一星评价，迪丽热巴则一个人把《声临其境》的评分拉到了4.3。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	一个经典角色可以成就一个明星，但一个明星也有可能毁了众多角色，观众便将不满全部发泄到流量明星身上，反而不会再客观考虑是不是剧本、导演不行。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	不过作品口碑败光的更多是路人缘，而且市场通过这种副作用反噬的方式淘汰流量明星，毕竟是一个相对缓慢的过程。关键是，他们背后的死忠粉依然是“东山再起”的资本。<strong>所以一个流量明星的消失或死亡，完全取决于粉丝。</strong> \r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	事实也是如此，我们看到，<strong>人设崩塌是最近常见的最快导致明星坠落的方式，而人设本质就是为迎合粉丝存在。</strong>粉丝心理假说认为，追星一种身份认同，粉丝通过对名人的“镜像”认识自己，塑造价值观，而一旦粉丝发现这种“镜像”是虚假的，认同感瞬间就消失了，而且会有上当受骗的感觉。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	当然，粉丝也是善变的，他们自然而然流失，流量明星们也就被市场抛弃了。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\"> <strong>流量数据的虚假泡沫被戳破总归是好的，但娱乐行业的乱象却无法根治，终究是粉丝把明星捧得太高了。</strong> \r\n	</p>',	'doc.png',	1.00,	37,	0,	0,	0,	'2019-12-03 14:20:16',	'admin',	3,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	1.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	13,	1,	0,	1),
(133,	'东亚杯-董学升破门中国1-2日本 亚冠抽签:恒大PK水原',	'<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	你可能不知道咪蒙，但却一定知道她有一个月薪5万的助理。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	年初，在“寒门状元”事件之后，咪蒙就曾宣布关停微信公众号两个月，并永久关停微博。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	不想仅仅过了不到一个月，2月21日咪蒙以及旗下“才华有限青年”等微信账号就宣布将被永久关停。旗下美妆账号改名为“李粒粒LiLiLi”，咪蒙小号“好疼的咪蒙”则清空了所有内容。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	从咪蒙公布之前公布的报价来看，其微信公众号头条广告报价一度到达80万元，二条也有40万元。这次的账号注销还包括今日头条、凤凰号等等，并称咪蒙“不得转世”。咪蒙的商业帝国几乎被连根拔起。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	除了自媒体，同时可能就此终结的还有咪蒙刚刚开始的编剧生涯。2018年3月，柠萌影业曾经宣布，由咪蒙担任编剧的网剧《长大成人》正在筹备中。现在咪蒙被封，这部“神似”《欢乐颂》的作品最终何去何从也被画上了问号。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\"> <strong>“毒鸡汤女权”，这不只是咪蒙的专利</strong> \r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	正如我们上文所说，咪蒙还在积极谋求走向影视圈，成为编剧便是第一部。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	了解咪蒙的人都知道，咪蒙的文章一向以宣扬所谓“女权”为导向，用一碗一碗的鸡汤，挑动着公号中近600万女性粉丝的内心。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	作为一个影视的门外汉，咪蒙之所以开始进军影视当编剧，其实和中国影视，特别是网台剧当中 “大女主”等题材层出不穷有着直接关系。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	从《欢乐颂》里的五个姐妹，到《我的前半生》里的罗子君，从楚乔到关皮皮，不一而足。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	然而，在这些所谓的“大女主”或者“女权”剧却很少体现真正的女权，而或多或少的会体现出“咪蒙式女权”的感觉。 男一都会对我不离不弃，男二都会生死相依，男三都会“我的眼里只有你的桥段大行其道，靠男人上位的情节也充斥其中，女权成为了寄居在男权上的笑话。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	再有，许多职业剧也会加入大量爱情桥段，“谈判官”改谈恋爱，“猎头”改“猎对象”的情况也多次发生。这也正如咪蒙的风格，看似让人“自强不息”，实则只想让你成为“坐在宝马里笑的人”；看似是在不断激励，实际只是找准了观众的七寸，然后一颗颗的吃下早预备好的“致幻药丸”。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	但这样的剧情虽然满足了女性观众对于爱情内容的需要的同时，本身也局限了内容的发展。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	首先，这样的剧所有内容几乎都必须围绕爱情展开，亲情、职场、宫斗、武侠等本应该更重要的戏份反而成了陪衬。由此，很多所谓的职场剧、宫斗剧到头来都变成了无限尴尬的爱情剧。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	更重要的是，“咪蒙式的女权剧”并不是真正的男女平权，当女性意识进一步觉醒之后，就会开始逐渐摒弃这种价值观。正如《致橡树》中所说，“我如果爱你，绝不学攀援的凌霄花”。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	再次，随着90后以及更年轻观众的崛起，单身才是社会更加主流的形态。生活方式的改变也会影响大家对于影视剧的观看喜好。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	更进一步说，“大女主”实际上是披着女性思维的外衣，但实际上却站在男性立场的表现。女性是白莲花、傻白甜，需要靠男性，甚至众多男性实现目的，这其实是一种变向的“被包养”。托名女权，实际宣扬的却是一种并不合理的价值观。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	咪蒙已经悄然落幕，但“伪女权”却依然大量存在于影视剧之中。但随着品质口碑成为了市场主流，真正的女权影视剧登上舞台恐怕也不会太远了。\r\n</p>',	'doc.png',	1.00,	24,	0,	0,	0,	'2019-12-03 14:21:05',	'admin',	10,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	1.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	10,	1,	0,	1),
(134,	'普氏野马数量恢复至400余匹 历史比大熊猫还悠久',	'<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	短视频行业的发展无疑已经进入到了深水区，以短视频变现为代表的全新发展正在把这个行业越来越多地放到了市场的前台。作为一种全新的内容表现形式，短视频在经历了资本乱战、巨头追捧之后，或许应该进入这个“年纪”。然而，变现并非易事，短视频变现更是难上加难。如果能够走出短视频变现的考验的泥淖，这个行业的发展无疑将会发展成熟。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	当然，如果仅仅只是一味地追求变现，而不去深究短视频本身的内在运行逻辑。所谓的短视频变现同样会陷入困境，火爆的短视频行业将会如同火爆的流量一样陷入表面的繁华。的确，几乎所有的商业模式都应该形成一个生态闭环，才能称得上是一个成熟的商业模式。如果仅仅只是停留在某个阶段的繁荣，所谓的商业模式仅仅只是一个概念，无法真正落地。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	我们看到当前以抖音、快手为代表的短视频行业巨头都在进行变现层面的探索，无论是社交，还是电商，对于短视频背后更加深层次的商业层面的探索正在成为一种发展的主流。不可否认的是，尽管短视频变现进行得如火如荼，但是依然逃不脱现实的尴尬，短视频行业的变现依然面临诸多挑战。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	从繁荣期到精耕期，短视频行业正在经历阵痛\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	作为一种在移动互联网时代的后半段崛起的内容表现形式，短视频行业的发展无疑备受追捧。无论是资本还是巨头，对于这种新式的内容展现形式都充满了好奇与期待。融资数额的不断增加、融资速度的不断加快都在说明市场对于短视频行业偏好程度。尽管短视频行业从一开始就被互联网巨头所青睐，但是，它的发展依然要经历所有的事物都会经历的阶段。从资本吹捧的繁荣期到商业变现的精耕期，短视频行业的发展无疑正在经历一次全新的阵痛。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	火爆的背后是短视频行业远离商业本质的尴尬。几乎所有的人都知道，短视频行业的发展一直都是一路高歌，无论是从用户获取上，还是用户日常的表现数据上，短视频行业的发展都是相当夺目耀眼。尽管短视频行业看上去异常火爆，但是火爆的背后却是变现困难的尴尬。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	从始至终短视频行业都在扮演着一种流量导流的角色，通过短视频将流量聚集在一起，再通过流量下沉到电商、社群等其他领域，从而实现真正意义上的变现。其实，从流量获取到流量导入已经有了许多的用户流失，再把这些流量落地到具体产品上又会有更多的流量流失。因此，仅仅只是将短视频看成是一个流量导入的工具，而不去从短视频本身着手，直接进行变现正在让短视频行业的发展陷入一种尴尬的境地里。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	当我们看到短视频平台动辄几亿的用户流量的时候，其实无法真正掩盖现实的尴尬。一味地看中短视频本身的流量价值，而忽略了更多新的探索，短视频行业正在陷入一场远离商业本质的尴尬。在流量红利已经见顶的大背景下，一味地去强调短视频行业的流量作用，无疑是一次与现实的抵抗。在流量已经被证明是一种无效资源的大背景下，短视频行业盲目地加大自身在流量上的作用，无疑是一场冒险。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	依附于巨头的怀抱让短视频缺少对于商业世界的认知。作为一种全新的内容展现形式，短视频行业从一开始就依附于互联网巨头。无论是资本投资，还是平台建设上，短视频始终都缺少自己独特的运行模式。虽然以互联网巨头作为靠山能够缓解在竞争激烈的市场当中沦陷的概率，但是如果仅仅只是一味地停留在巨头怀抱的温暖里，不去面对商业世界的残酷，短视频行业依然备受挑战。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	依附于巨头的怀抱，短视频行业仅仅只是一个内容层面的东西，它仅仅只是巨头的附庸，无法真正承担起自我寻找商业价值的重任。当巨头不再加持短视频行业的时候，它同样需要走入市场里，而不是一味地承担一个支撑者的角色。依附于互联网巨头的怀抱，短视频行业仅仅只是停留在表面繁荣的自嗨当中，不断增长的用后数据、不断增长的点赞数量、不断增加的用户浏览时长都让短视频行业感觉到自己是移动互联网后半段的王者。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	作为一种全新的内容展示形式，短视频始终都是一种内容。如果我们仅仅只是停留在巨头光环下的数据自嗨，而不去真正了解这些数据背后的真正原因。那么，当短视频行业真正进入到市场的时候，一切或许都将重新开始。当前，短视频行业正在经历的正是这样一个阶段。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	以内容为根本的短视频却无法具备内容的本质与意义。虽然短视频行业异常火爆，但是我们始终都不能忘记短视频始终都是一种内容表现形式。既然是一种内容，短视频行业从野蛮生长到精耕细作是一个必然的过程。在经历了几年的发展之后，我们却没有看到短视频行业的内容有显著提升的地方，有的仅仅只是在一些营销层面的小打小闹。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	当短视频在内容进化上出现瓶颈的时候，我们就去做商业变现上的相关尝试无疑将会把这个行业的问题和弊端全部都呈现在外面。作为一种内容展现形式，短视频行业在内容本身上缺少精耕细作和突破创新，只会把短视频行业的发展带入到一种相对艰难的境地里。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	我们看到现在的短视频的内容上依然缺少精细化的痕迹，有的仅仅只是千篇一律的雷同抑或是内容展现形式的俗套。如果仅仅只是把短视频行业仅仅停留在一种毫无进化的层面上，特别了缺少了作为内容本身所应该具备的特质，那么所谓的短视频必然将会失去原有的本质与意义。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在经历了早期的野蛮生长、资本助推、巨头拥抱等一系列的发展之后，短视频行业的发展正在经历一场前所未有的平静期。这从另外一个角度说明短视频行业的发展并未真正跳出原有的发展套路，仅仅只是将互联网式的发展模式在极致上更进一步。突破短视频行业的发展困境，需要真正让短视频告别自嗨式的繁荣，真正回归内容本身，真正进入到商业世界的现实中历练。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	进入下半场的深水区，短视频的彷徨与退让\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在告别了资本的加持之后，短视频行业的发展正在进入到下半场的深水区。早期的顺风顺水让短视频行业的发展难以抵挡现实的尴尬，一味地停留在数字上的繁荣，而忽略了内容本身的本质奥义，短视频行业的下半场无疑将会经历一场前所未有的彷徨与退让。但是，这并非是一件坏事，通过这种方式，我们增加能够知道短视频本质的东西是什么。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	短视频的彷徨：巨头扶持还是独立行走。短视频从诞生的那一天开始就始终没有摆脱巨头的光环，从某种意义上来讲是互联网巨头最终造就了短视频行业的今天。然而，一味地躲在互联网巨头建构的舒适区里，不去进行商业层面上的探索，所谓的短视频只会在自嗨的道路上越走越远。告别巨头的保护，真正进入到市场当中摸爬滚打，从而获得更多的生存技能或许对于短视频来讲至关重要。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	然而，如果摆脱互联网巨头的怀抱，短视频又很难在短时间内找到一条合适的路，对于处于变现关键期的短视频行业来讲，无疑是一个非常巨大的挑战。始终蜷曲在巨头的怀抱，毕竟不是一件长远的事情，短视频行业的真正未来依然在于本身的发展上。从这个逻辑来看，脱离巨头的怀抱，选择独立行走显然是一件非常明智的事情。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	可喜的是，深度参与到短视频行业发展中的人们早已明白了这其中的意义，我们看到以抖音、快手为代表的短视频平台开始更多地寻找基于自身优势和特色的发展道路，抖音做社交，快手做电商就是这一趋势的直接体现。尽管当下的发展态势不甚明朗，但是只要能够找到一条真正适合自己的发展道路，短视频行业的发展便会真正能够独立。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	短视频的退让：坚守流量还是回归商业。从当下的发展情况来看，短视频真正吸引人的地方还是它裹挟流量的能力。投资机构和互联网巨头之所以不断加持短视频行业的重要一点同样是因为短视频本身能够在获取流量的成本日渐高企的时刻依然能够持续获得源源不断的流量。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	然而，虽然流量给短视频赢得了鲜花和掌声，但是流量的变现依然是横在短视频头上的达摩克利斯之剑。谈及流量变现就必然要回归到商业本身，如果仅仅只是在流量的海洋里进行无谓的自嗨，所谓的短视频只能是一个充满了美妙幻想的乌托邦，无法真正实现真正意义上的落地。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	是坚守流量还是回归商业，或许在残酷的商业面前，短视频行业将会最终退让，真正演变成为以商业为主导的存在。尽管这个过程会略显艰难，但是这才算是真正回归到了商业本身，而非仅仅只是沉醉在流量的理想国里。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	当短视频市场的繁华落尽，回归商业本质或许是当下正道。告别表面的虚假逻辑，真正把短视频行业的发展落地到具体的商业上，探索一条真正适合商业本质的发展道路，或许才是真正能够推动短视频行业发展正道所在。从这个逻辑上来看，当下短视频行业正在经历的这场彷徨与退让或许更像是在积蓄继续前行的能量。\r\n</p>',	'doc.png',	1.00,	34,	0,	0,	0,	'2019-12-03 14:21:49',	'admin',	14,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	1.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	13,	1,	0,	1),
(135,	'韩日将举行出口政策局长级对话 能否解决引关注',	'<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	发展会掩盖一切问题，直到狂奔的脚步停下。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	2月15日，滴滴CEO程维对外表示，公司将做好过冬准备，并将对非主业进行“关停并转”，对业务重组带来的岗位重叠和绩效不达标的员工进行减员，整体裁员比例占到全员的15%，将涉及2000人左右。此外，从2012年创业以来一直处于亏损状态的滴滴，2018年仍然亏损，全年亏损总额高达109亿元，其中，补贴司机超过113亿元。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在收购优步中国以后，滴滴在网约车市场一家独大，市场占有率近九成；滴滴是全球融资额最大的未上市公司，一向“不差钱”；滴滴对每笔业务都会收取20%左右的抽成(Take Rate)，这也经常成为网约车司机抱怨甚至炮轰的对象……感觉“躺着就能把钱赚了”的滴滴，为何会如此巨亏？司机喊着不赚钱、平台又巨亏，网约车的问题究竟出在哪里？还有能走得通的商业模式吗？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	成立7年，融资20次，\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	融资额200亿美元\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	和其他公司多是被爆出后被迫承认窘境，或者裁员时只肯使用“优化、调整、末位淘汰”等字眼不同，滴滴主动“官宣”了巨亏和裁员的消息，数字还如此巨大。“地主家也没有余粮了？”“富家子都开始哭穷了？”社交媒体上一时哗然，有人唏嘘，有人不解。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在去年8月滴滴顺风车事件之后，程维也曾对外透露过一次滴滴的财务数据，他表示滴滴成立6年来，还没有实现过盈利，仅仅2018年上半年，公司的整体净亏损就超过40亿元人民币。滴滴出行业务对应的GMV(总交易额)平均Take Rate(抽成率)约为16%，但绝大部分作为补贴和红包返还给了司机和乘客，公司整体对应的GMV毛利率只有1.6%。他还透露，仅2018年上半年，包括司机高峰期补贴、接单和服务奖励、乘客优惠等在内的总补贴返还金额超过117亿元人民币。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	2017年，滴滴也曾透露过补贴总额，高达181亿元(包括司机端和乘客端)。但一些被媒体广泛引用、滴滴官方从未确认也从未辟谣的数据显示，2017年滴滴全年亏损额只有25亿元。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	一位滴滴内部人士告诉《中国经济周刊》记者：“公司虽然巨亏，但现在现金流应该是没问题的。即使一部分员工会面临被裁员，但公司给的补偿方案还是比较厚道的。说滴滴会成为下一个ofo那是不太可能的。”\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	据天眼查的统计数据显示，滴滴自2012年成立以来，截至目前已经完成了20次融资，金额总量超过200亿美元，是全球融资额最大的未上市公司。滴滴的估值也一度高达800亿美金，也是最快达到这个量级的独角兽公司。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	但这只独角兽也甚是烧钱。由于滴滴还不是上市公司，财务数据并不需要全部公开，但根据滴滴已公开的数据统计，滴滴6年来累计亏损额高达近390亿元。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	但上述人士也表示：“在2018年以前，利润和成本在滴滴确实不是重要的考核指标，市场占有率、日单量、用户数量、司机数量……这些才是关注的重点。但2018年开始，公司希望能够在年底冲刺整体盈利，至少实现‘微盈利’，所以对各个业务线也都提出了这样的要求。”\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	其实，这种变化也并不奇怪，因为彼时市场传闻，滴滴将会在2019年下半年实现IPO。但之后由于众所周知的原因，滴滴没能赶上这波上市热潮。“顺风车事件”背后的安全问题让滴滴停下了6年来一路狂奔的脚步。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	一年补贴113亿元，\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	司机感受到了吗？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	补贴仿佛是成就滴滴、也榨干滴滴的一道旋转门，补贴的打法让滴滴熬死了几乎所有竞争对手，并从尸骨堆中走出来，成为今天的滴滴；但现在，补贴似乎也正在熬干滴滴自己。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	与109亿元这个2018年滴滴全年亏损总额一同出现的还有一个数据：2018年滴滴补贴司机超过113亿元，这很容易让人认为两个数字之间有因果关系。但巨额亏损就是源于对司机的补贴吗？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	北京大学市场与网络经济研究中心研究员陈永伟对《中国经济周刊》分析认为，滴滴的亏损应该主要来自为了赢得用户信任和适应更强监管而付出的合规成本。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	陈永伟认为，滴滴的持续亏损主要有两方面的原因。“一是由滴滴本身的战略决定的，它的战略是先占有市场，然后利用规模效应去消化市场。滴滴的主业务是规模报酬递增的，这也决定了滴滴先占市场的模式。二是去年突发事件引发了监管加强，这让滴滴遭受了空前的监管压力，合规成本是巨大的，比如要求司机户口、车辆的轴距大小等。”他说。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	记者采访了几位滴滴司机，他们均表示，并没有觉得去年滴滴对司机的补贴突然增加了。一位滴滴“老司机”告诉记者，不同的司机能够拿到的补贴数量可能差别非常大。因为要想获得比较高的补贴收入并不容易，比如要在线时间长，至少10小时，这意味一定要是全职司机，身体要好还不能怕辛苦；再比如要在高峰时段多接单，也要多接受滴滴的派单，“这些活儿很多是根本不赚钱的，不给补贴，根本不会有人接。”他说。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在乘客端，很多人的感受则是：滴滴的车费越来越贵，但叫车却越来越难。记者对比了市场上最大的几家网约车公司的价格，以北京为例，相同时段和目的地，同档次车型，滴滴快车价格最低，其次是出租车价格，但两者差距已经不大了，相对最高的是易到易达车型的价格。而对于高端车型，滴滴礼橙专车也是最低的，其次是神州专车，首汽约车的价格则更高一些。这些高端车型的价格要高出普通车型50%左右。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在客户竞争层面，网约车平台的竞争无外乎两件事：价格和能否叫到车。而网约车平台要克服的最大难题就是高峰低谷时段的需求差异和城市潮汐效应的供给矛盾。因此，从逻辑上，网约车平台确实需要依赖补贴来调节运力，鼓励高峰时段有更多兼职司机补充运力，鼓励司机反潮汐增加热门地区的运力供给。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	根据中国信息通信研究院政策与经济研究所的调查显示，截至2018年7月，全国合规网约车数量约为17万辆，只占到总量的0.54%，而合规司机数量约为34万，只能占到司机总量的1.1%。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	据滴滴方面介绍，随着各地网约车新政的落地和执行越来越严格，运力不足问题日趋严重。而顺风车下线之后，兼职的网约车司机也大量减少。因此，滴滴为了吸引更多“合规”司机加入，以及运营中调整运力，不断出手补贴。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	滴滴收购ofo的可能性更小了\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	除了裁员，滴滴宣布要“关停并转”非主业的消息也引发了广泛的关注。到底哪些业务是滴滴的“非主业”，截至记者发稿，滴滴官方并未给出回应。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	一位滴滴前高管对《中国经济周刊》分析，对于滴滴“非主业”，很多人会首先想到外卖、酒旅、票务等“创新业务”，这确实可能是此次调整的重点，但应该还至于此，因为这些业务不足以涉及到2000人。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	据记者了解，2018年底，滴滴进行过一次架构调整。调整后，滴滴的主要业务被划为几大板块：网约车平台公司(快车、专车、豪华车事业部)、车主服务公司(小桔车服公司、汽车资产管理中心)、普惠出行与服务事业群(单车、电单车、公交、代驾、企业级业务)、出租车事业部、战略业务事业部(战略部、国际事业部、金融事业部)等。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	上述高管认为，普惠出行与服务事业群的业务也有可能被重点调整，“滴滴再去收购ofo的可能性更小了”。而国际业务和金融业务则会影响不大。“网约车这个生意受政策环境影响太大了，国际化等于给滴滴多设立几个backup，这边不亮可以那边亮，滴滴已经有完整完善的网约车技术和运营解决方案，在各国复制并不难。”他说。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	实际上，滴滴已经通过收购、投资本地出行平台的方式将业务拓展到东南亚、东欧、非洲、巴西、日本、美国、墨西哥、澳大利亚……程维也透露，安全技术、产品和线下司机管理及国际化等是滴滴未来的重点领域。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	陈永伟的看法是，滴滴确实涉足了不少并没有规模效应的行业，如果没有顺风车危机，可能也不会对滴滴带来太大的影响。但在严监管之下，安全合规成本大增，滴滴的顺风车业务还干脆就没了，这也带来商业损失。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	网约车也有赢利的商业模式\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	滴滴这头其实已经达到巨头规模的超级独角兽，至今仍未找到清晰的盈利模式。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	滴滴的设想是希望通过平台聚集大量用户，然后靠打造“出行生态”提供增值服务获得盈利。就像淘宝和微信，用户都可以免费使用，但同样可以赚得盆满钵满。于是，滴滴进行了很多尝试：做广告、做电商、做游戏、卖保险、卖理财、做金融……但这条路，至少现在，滴滴还并没有走通。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	但这并没有影响新选手们的热情。除了神州优车、易到、首汽约车等老运动员，2018年以来，美团、高德、携程、同程、嘀嗒、哈罗等都开始前赴后继地加入网约车混战，希望从滴滴的版图上咬下一块。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	此外，上汽、吉利、大众等在内的主机厂都已经进军网约车市场，宝马也成为首家在中国拿到网约车牌照的跨国品牌，赛道那端虽然通向哪里还不知道，但赛道仍然拥挤。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	虽然滴滴的日子不好过，易到更是彻底凉了，但行业内也有日子过得不错的玩家。比如神州优车，虽然此前也一直亏损，但到2017年，神州优车的亏损已大幅收窄了92.7%，仅亏损2.6亿元。而其2018年经营，截止到当年前三季度，神州优车营收达49.2亿元，利润总额2.8亿元，较上年同期增长149%，已经实现了4个季度的持续盈利。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“这其实也说明了网约车本身没问题，是有商业模式可以走得通的。不过行业发展还是需要政策支持。”陈永伟表示\r\n</p>',	'doc.png',	1.00,	15,	0,	0,	0,	'2019-12-03 14:22:37',	'admin',	26,	1,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	1.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	10,	1,	0,	1),
(136,	'华鼎奖陈宝国惠英红获最佳男女主 郑爽出席联合国大会',	'<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	2015年，随着抢眼的小黄车突现北大校园，共享单车的概念迅速被普及，玩家接连冒头，巨额投资不断涌入，和高铁、移动支付、网购齐名<strong>“新四大发明”</strong>。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	热潮来得快，去得更快。今年，共享单车就进入了寒冬。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	4月，<strong>摩拜单车委身美团；小黄车ofo也节节败退，危机重重</strong>：海外业务全面收缩，并推出了多种激进的变现手段：公众号推送广告，将用户的押金与理财产品绑定，一再延迟押金退还期限。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	去年还大把烧钱的共享单车，转眼就凉凉了。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	共享单车出海遇阻，基础建设和政策规范是难以忽略的两大阻力。除了中国，世界上很难找到一个足够大的市场来支撑共享单车的盈利模式。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	但印度的创业者似乎有不同想法。<strong>从2017年开始，有近十年共享单车公司陆续出现，并先后拿到融资。</strong> \r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	班加罗尔的Yulu向Blume Ventures等投资者筹得资金，还获得Flipkart联合创始人Binny Bansal和谷歌前副总裁Amit Singhal的支持；另一家公司Bounce从红杉印度等投资者那里拿到了了总计1520万美元的资金；总部位于古尔冈的Mobycy去年12月也筹集了50万美元的种子资金。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\"> <strong>印度的共享单车市场正生机勃勃。</strong> \r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\"> <strong>融资热潮</strong> \r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	Amit Gupta是印度第一家独角兽Inmobi的联合创始人。在他创业十年、担任总裁级别职务的时候，他选择了急流勇退，<strong>创办了另一家公司，Yulu单车</strong>。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在班加罗尔地铁站和商务CBD附近，亮蓝色的Yulu单车随处可见。Amit告诉\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	志象网\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	，做共享单车，是为了<strong>“间接降低污染”</strong>。他出生和长大在印度北部的小城坎普尔，在今年6月被世界卫生组织盖章“全球污染最严重城市”，谈起家乡，他显得情绪激动。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	Yulu单车在前半个小时仅收费10卢比<strong>（约一元）</strong>，之后每半小时多收5卢比。用户下载Yulu应用扫码开车，结束骑行之后，需要将车子停放在离目的地最近的停车区。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	业内人士估计，印度的共享单车市场目前规模达12亿美元。<strong>主要的玩家除了Yulu，还有共享汽车公司Zoomca旗下的Pedl，Mobycy，Bounce和以及来自中国的摩拜单车。</strong> \r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“这个行业很有前景并且有利可图，Ola和Uber的成功证明了交通出行跟手机有可能同步发展。”Blume Ventures的投资人Sajith Pai对志象网说。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	最近入局的玩家是<strong>从踏板车共享起家的Bounce</strong>。今年6月，ofo退出印度市场，Bounce最近宣布收购了它在印度的资产。在收购之前，Bounce在就班加罗尔投放了500辆踏板车。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“从公交站或地铁站到办公室和家里的最后一英里的交通非常令人头疼，没有任何三轮车或出租车愿意走这么短的距离。”Bounce联合创始人Vivekananda HR告诉志象网。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“我们从ofo手中收购的自行车也将加入试点。”他说，45到60天内Bounce的应用将支持扫码使用单车。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	印度创业者从中国公司继承的，不仅是败局留下的遗产，还有先见之明的运营管理教训。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在浦那和班加罗尔，小蓝车Yulu和小绿车Pedl随处可见。一开始，用户可以把车停在任何地方，甚至是在路中间，引起了交通失序。Yulu不得已派出团队去搬运自行车并停放在适当的地方。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	这样一来，成本太高难以为继，Yulu吸取了教训，开始联合Pedl与当地政府合作，规划指定的停车区域。在班加罗尔，这样的停车区现在有500个，在全部的4个城市总数超过1000个。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\"> <strong>纠结的用户体验</strong> \r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	但也有的问题无法靠“继承”来解决，<strong>比如技术和运营失误</strong>。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在印度，<strong>共享单车的用户体验仍有待改善</strong>。志象网记者的亲身体验以及和其他用户交流后发现，包括刹车失灵、智能锁失灵、轮胎漏气等现象并不少见，而且停车区的分布也不够密集，有时候用户甚至需要在锁车之后再走一公里到目的地。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	Vivek Kumar是一名22岁的软件工程师，他最近刚从德里搬到了班加罗尔。刚到班加罗尔时，他一直骑着共享单车穿梭在城市中参加面试。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	一次去面试的路上，他发现单车的链条断了，这就十分尴尬了：他必须得先把车子停到指定的停车区域，否则软件会一直计费。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“我不得不把车子推到500米外的Pedl停车站，在锁这个坏车的时候又花了好多时间。”Kumar告诉志象网。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	但事实上，Yulu和Pedl也都有专人在维护单车，每隔四天维护一次，从而保持单车的良好运行状态。但Amit说，当公司进入一个区域时，维护的情况会不太稳定，“因为当地业务还没有完全稳定。”\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“在那些旧的区域，你会发现我们的自行车状况良好，大多数都能够很好运行。最近我们在电子城附近布局，那里聚集了一批大型IT公司，比如Infosys、Wipro等。我们需要四到六周的时间来完成布局。”Amit说。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	但相较中国，<strong>印度的交通基础设施普遍落后，这也给共享单车埋了一颗暗雷</strong>。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在印度，没有几个城市设置了自行车道；不像中国，骑行已经发展为一种健康、前卫的生活方式，印度的自行车还往往被视为穷人的通勤方式。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“我们之所以进入共享单车行业，是因为我们想成为一家多渠道出行平台。城市交通一直是政府和公民共同面临的挑战，我们希望能够大规模地解决这一问题并帮助完善基础设施建设。”Pedl运营增长部门负责人Rakshak N说。\r\n	</p>',	'doc.png',	0.00,	2,	0,	0,	1,	'2019-11-26 09:37:47',	'admin',	119,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	0.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	3,	1,	0,	1),
(137,	'抖音多闪培训：如何通过抖音进行带货',	'<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	互联网瞬息即变，互联网上的热点也是转变地相当的快，一个热点可能过了几天就不再有人关注了。这对于想凭借互联网走红的人或物来说，显然要付出更多的心血来维持热度。那么，各个引流渠道显然都在他们的考虑范围之内。对于商家而言，在互联网进行引流的最终目的不外乎都是卖货变现。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	因此，一些比较重要的引流渠道，都少不了商家们的身影；比如，。抖音作为2019年的平台，有着3.2亿日活跃用户，属于是自带。如今，抖音与微信、微博等巨大流量池并称，绝对是商家不容错过的流量池。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	商家在抖音平台上发布内容之后，就能通过发布内容来吸引用户前来关注，并进一步转化为粉丝，这样就能更方便商家引流变现。在抖音只能是通过发布优质内容来吸引用户关注，因为抖音采用的是智能社交推荐机制，只要发布的视频内容有趣，也可以获得大量的曝光。这就决定了粗制滥造的视频所获得的曝光量很少。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;text-align:center;\"=\"\"> <img src=\"http://demoall.adashuo.com/20090/uploads/allimg/c191107/15I0c2FD630-1E14.jpg\" width=\"450\" height=\"270\" border=\"0\" alt=\"抖音多闪培训：如何通过抖音进行带货-第1张图片-小七抖音培训\" title=\"抖音多闪培训：如何通过抖音进行带货-第1张图片-小七抖音培训\" style=\"height:270px;width:450px;\" /> \r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	因此，想要在抖音平台上获得大量的曝光，最简单的办法就是制作高质量的视频内容。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	拥有曝光，并不代表着是结束。恰恰相反，这只是开始，因为接下来的工作就是要引流变现了。目前，通过抖音引流的方式无非就只有这么几种：一是在视频内提及联系方式；二是在评论中回复；三是在私信回复等。但是，这几种引流方式都存在着被抖音删除、乃至封禁的风险。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	抖音多闪培训那么，到底有没有什么引流方式是没有风险的呢？或者换言之，有什么引流方式是抖音官方认可的呢？当然有!那就是抖音的电话拨打组件。这是抖音官方所推出的转化组件，经过设置就可以在抖音主页上展示，只要用户点击\"联系方式\"这个按钮就可以跳转至电话拨号界面，并显示相关号码，这无疑对商家引流变现提供了很大的便利。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	但比较遗憾的是，目前，这个功能并没有对所有的用户开放，只有认证了抖音企业蓝v号的用户才可以设置该功能。所以，商家如果是想开通\"电话拨打组件\"的功能，需要先开通抖音蓝v。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	抖音蓝v认证的申请流程如下：\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	第一，用需要认证蓝v的抖音账号登录抖音蓝v认证官网https://renzheng.douyin.com/。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	第二，填写企业认证公函，具体情况可以参考抖音官方的企业认证公函填写模板。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;text-align:center;\"=\"\"> <img src=\"http://demoall.adashuo.com/20090/uploads/allimg/c191107/15I0c2G0040-2J03.jpg\" width=\"450\" height=\"447\" border=\"0\" alt=\"抖音多闪培训：如何通过抖音进行带货-第2张图片-小七抖音培训\" title=\"抖音多闪培训：如何通过抖音进行带货-第2张图片-小七抖音培训\" style=\"height:447px;width:450px;\" /> \r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	第三，填写并提交认证资料，然后填写邀请码123456\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	第四，支付认证审核费用600元即可完成蓝v认证申请的提交。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	需要注意的是，抖音蓝v认证有部分禁入行业及需要额外提供认证资质证明的行业。禁入行业认证抖音蓝v将做认证失败处理。而需要额外提供认证资质证明的，如果碰巧没有，那么在提交认证申请后的30天内仍没有补充提交资质证明，也会当认证失败处理。而认证抖音蓝v失败，是不会进行退款的。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	认证抖音蓝v之后，除了可以获得电话拨打组件，还可以获得同步认证今日头条和、官网链接、商家页面、店铺POI地址、粉丝画像等蓝v权益。可以为天猫、淘宝、京东店铺以及线下店铺引流，构建企业商家的营销阵地，完成变现的目的。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;text-align:center;\"=\"\"> <img src=\"http://demoall.adashuo.com/20090/uploads/allimg/c191107/15I0c2G35440-31260.jpg\" width=\"450\" height=\"261\" border=\"0\" alt=\"抖音多闪培训：如何通过抖音进行带货-第3张图片-小七抖音培训\" title=\"抖音多闪培训：如何通过抖音进行带货-第3张图片-小七抖音培训\" style=\"height:261px;width:450px;\" /> \r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	抖音多闪培训因此，有意认证抖音蓝v的商家，最好是通过抖音蓝v认证代理商进行认证。\r\n</p>',	'doc.png',	0.00,	20,	0,	0,	0,	'2019-12-03 14:04:12',	'admin',	5,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	0.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	4,	1,	0,	1),
(138,	'抖音小店：抖音运营怎么进行流量变现',	'<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	众所周知，2017年至2018年，的大和商业价值日益凸显，各大机构纷纷注资抢占短视频市场，作为短视频流量增速最快的APP，其运营模式和商业市场更是备受关注。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	大数据，帮你快速打造抖音爆款\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	抖音作为新媒体的新洼地，虽然流量又达到一个新的峰值，但是入场抖音仍然是可以。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	而想在抖音机制中脱颖而出，关注的焦点更倾向于生产抖音内容的速度和质量，以及如何持续生产高质量的抖音内容。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	对于运营抖音而言，此时入场抖音阵地，更需要把控时间成本和运营方法。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	结合抖音大数据工具——西瓜短视频助手，在内容层面，可以在6小时内寻找到抖音视频爆款素材，结合热门迅速掌握抖音平台爆款元素，从而有效提升抖音成本。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	在领域定位上，可以根据榜单快速规划的运营方向，结合行业粉丝画像信息，进一步完善垂直领域差异化内容布局。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	抖音进阶创作技巧，及商业运作模式\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;text-align:center;\"=\"\"> <img src=\"http://demoall.adashuo.com/20090/uploads/allimg/c191107/15I0c2AcO0-53929.jpg\" width=\"450\" height=\"303\" border=\"0\" alt=\"抖音小店：抖音运营怎么进行流量变现-第1张图片-小七抖音培训\" title=\"抖音小店：抖音运营怎么进行流量变现-第1张图片-小七抖音培训\" style=\"height:303px;width:450px;\" /> \r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	根据对MCN机构平台发展中遇到各种情况，给现场的运营者和MCN机构提出以下3个方面建议：\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	1.稳扎稳打才是抖音号的运营之道\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	面对网络上出现的买粉刷量的现象，建议运营者和机构千万不要尝试。这样的行为，不仅影响抖音号的权重，也让后续陷入无效价值中。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	2.快速孵化KOL矩阵离不开内容运营\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	抖音小店面对快速内容运营的有效方法，也给出一些信息流量的操作模式，在信息的展示上，可以扩大挖掘地域，可以引入外国小众优质的平台信息资源，将优质内容分类整理成“剧本”分发旗下艺人进行高效运作，提升视频输出效率。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	3.强强合作是商业运作成型的有效方法\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	相比知识付费，广告和电商是抖音目前最有效的转化之一。在广告投放上，同MCN专业机构合作，会更有效的提升个人抖音号的商业价值转化能力。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	如何高格局快速转战短视频领域构建生态链\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	如何一手打造“从内容生产-IP孵化-推广产业化”短视频生态蓝图？\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;text-align:center;\"=\"\"> <img src=\"http://demoall.adashuo.com/20090/uploads/allimg/c191107/15I0c2B323F-B363.jpg\" width=\"450\" height=\"307\" border=\"0\" alt=\"抖音小店：抖音运营怎么进行流量变现-第2张图片-小七抖音培训\" title=\"抖音小店：抖音运营怎么进行流量变现-第2张图片-小七抖音培训\" style=\"height:307px;width:450px;\" /> \r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	a.建立完善的孵化流程。在常规签约流程上，增加达人定位分析和视频测试环节（颜值/技能/学习），保障达人较高的素质水平。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	b.专注用户市场资源。在媒体领域商业形式取决于上游形态，运营的方向取决于市场用户的需求，只有想明白定位，才能做清楚你的市场。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	c.专业商业变现评估。需要对行业的天花板有一定认知，对不具有的抖音大号，可以根据粉丝画像的年龄层，选择不同的市场的推广模式。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	最后，规范机构的商业合作模式，才能快速有效构建自己的商业帝国。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	网红大咖粉丝运营之道\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	抖音IP的成长过程3个关键点：\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	1、找准平台：分析各个平台的商业价值和受众群体，有效预估平台的价值的上升空间。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;text-align:center;\"=\"\"> <img src=\"http://demoall.adashuo.com/20090/uploads/allimg/c191107/15I0c2BC510-L234.jpg\" width=\"450\" height=\"303\" border=\"0\" alt=\"抖音小店：抖音运营怎么进行流量变现-第3张图片-小七抖音培训\" title=\"抖音小店：抖音运营怎么进行流量变现-第3张图片-小七抖音培训\" style=\"height:303px;width:450px;\" /> \r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	2.优质内容：视频种类，视频的风格，人设的塑造，再到更高层次基调定位，都是优质内容的保障。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	3.抓准用户心理：内容的输出上需要抓取社会的认同感，有共鸣的内容通常都可以引发用户的依赖性，可以在内容上找到归属感。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	抖音小店其次，需要制造亲切感，打造个舒服是场景内容更容易获取用户关注。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	最后，就是从心理学的角度出发，恰到好处运粉丝的独纵心理和占便宜的心态。\r\n	</p>',	'doc.png',	1.00,	39,	0,	0,	0,	'2019-12-03 14:07:30',	'admin',	3,	5,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	1.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	14,	1,	0,	1),
(139,	'抖音运营团队：抖音运营思维攻略',	'<p style=\"color:#333333;font-family:&quot;font-size:16px;background-color:#FFFFFF;\">\r\n	带火了很多“爆款”产品，这些品牌和产品的销量大增，引得很多企业和品牌方们分外眼红。&nbsp;&nbsp;\r\n</p>\r\n<p style=\"color:#333333;font-family:&quot;font-size:16px;background-color:#FFFFFF;\">\r\n	在这个为王的时代，早已成为了一个所有新媒体人无法避开的平台。&nbsp;&nbsp;\r\n</p>\r\n<p style=\"color:#333333;font-family:&quot;font-size:16px;background-color:#FFFFFF;\">\r\n	抖音火遍大江南北，同时有无限的流量产生。&nbsp;&nbsp;\r\n</p>\r\n<p style=\"color:#333333;font-family:&quot;font-size:16px;background-color:#FFFFFF;\">\r\n	大家撸粉的撸粉，变现的变现。&nbsp;&nbsp;\r\n</p>\r\n<p style=\"color:#333333;font-family:&quot;font-size:16px;background-color:#FFFFFF;\">\r\n	但是现在越来越难了，&nbsp;&nbsp;\r\n</p>\r\n<p style=\"color:#333333;font-family:&quot;font-size:16px;background-color:#FFFFFF;text-align:center;\">\r\n	<img src=\"http://demoall.adashuo.com/20090/uploads/allimg/c191107/15I0c26340L0-1F53.jpg\" width=\"450\" height=\"198\" border=\"0\" alt=\"抖音运营团队：抖音运营思维攻略-第1张图片-小七抖音培训\" title=\"抖音运营团队：抖音运营思维攻略-第1张图片-小七抖音培训\" style=\"height:198px;width:450px;\" />\r\n</p>\r\n<p style=\"color:#333333;font-family:&quot;font-size:16px;background-color:#FFFFFF;\">\r\n	为什么？&nbsp;&nbsp;\r\n</p>\r\n<p style=\"color:#333333;font-family:&quot;font-size:16px;background-color:#FFFFFF;\">\r\n	竞争大呗！&nbsp;&nbsp;\r\n</p>\r\n<p style=\"color:#333333;font-family:&quot;font-size:16px;background-color:#FFFFFF;\">\r\n	团队拿到更好的权重才能有更多的曝光，才有上的机会。&nbsp;&nbsp;\r\n</p>\r\n<p style=\"color:#333333;font-family:&quot;font-size:16px;background-color:#FFFFFF;\">\r\n	怎么拿到更多的曝光权重呢？&nbsp;&nbsp;\r\n</p>\r\n<p style=\"color:#333333;font-family:&quot;font-size:16px;background-color:#FFFFFF;\">\r\n	俗话说：知己知彼，百战不殆！&nbsp;&nbsp;\r\n</p>\r\n<p style=\"color:#333333;font-family:&quot;font-size:16px;background-color:#FFFFFF;\">\r\n	那我就先来了解一下抖音的排名算法是什么？&nbsp;&nbsp;\r\n</p>\r\n<p style=\"color:#333333;font-family:&quot;font-size:16px;background-color:#FFFFFF;\">\r\n	首先你要输出优质的内容，&nbsp;&nbsp;\r\n</p>\r\n<p style=\"color:#333333;font-family:&quot;font-size:16px;background-color:#FFFFFF;text-align:center;\">\r\n	<img src=\"http://demoall.adashuo.com/20090/uploads/allimg/c191107/15I0c263G60-26058.jpg\" width=\"450\" height=\"195\" border=\"0\" alt=\"抖音运营团队：抖音运营思维攻略-第2张图片-小七抖音培训\" title=\"抖音运营团队：抖音运营思维攻略-第2张图片-小七抖音培训\" style=\"height:195px;width:450px;\" />\r\n</p>\r\n<p style=\"color:#333333;font-family:&quot;font-size:16px;background-color:#FFFFFF;\">\r\n	关于内容今天就不讲了，本期讲的是抖音运营思维攻略。&nbsp;&nbsp;\r\n</p>\r\n<p style=\"color:#333333;font-family:&quot;font-size:16px;background-color:#FFFFFF;\">\r\n	一、熟悉抖音&nbsp;&nbsp;\r\n</p>\r\n<p style=\"color:#333333;font-family:&quot;font-size:16px;background-color:#FFFFFF;\">\r\n	抖音运营团队熟悉抖音账号注册、认证、定位、布局、防封号/、最受欢迎内容等。&nbsp;&nbsp;\r\n</p>\r\n<p style=\"color:#333333;font-family:&quot;font-size:16px;background-color:#FFFFFF;text-align:center;\">\r\n	<img src=\"http://demoall.adashuo.com/20090/uploads/allimg/c191107/15I0c26406150-31H2.jpg\" width=\"450\" height=\"266\" border=\"0\" alt=\"抖音运营团队：抖音运营思维攻略-第3张图片-小七抖音培训\" title=\"抖音运营团队：抖音运营思维攻略-第3张图片-小七抖音培训\" style=\"height:266px;width:450px;\" />\r\n</p>\r\n<p style=\"color:#333333;font-family:&quot;font-size:16px;background-color:#FFFFFF;\">\r\n	二、选题&nbsp;&nbsp;\r\n</p>\r\n<p style=\"color:#333333;font-family:&quot;font-size:16px;background-color:#FFFFFF;\">\r\n	1.选题的原则：关联性、热门性、新鲜感、人设感&nbsp;&nbsp;\r\n</p>\r\n<p style=\"color:#333333;font-family:&quot;font-size:16px;background-color:#FFFFFF;\">\r\n	2.选题来源：可从时事、同行火爆视频分析、段子、微博等渠道入手&nbsp;&nbsp;\r\n</p>\r\n<p style=\"color:#333333;font-family:&quot;font-size:16px;background-color:#FFFFFF;\">\r\n	3.拍摄及剧本套路&nbsp;&nbsp;\r\n</p>',	'doc.png',	1.00,	5,	0,	0,	0,	'2019-12-03 14:08:06',	'admin',	10,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	1.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	4,	1,	0,	1),
(140,	'抖商研习社：如何在抖音做社交电商？',	'<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	怎么在做？ &nbsp;借助商品橱窗和购物车，电商新物种——抖商蓬勃发展，但作为以算法推荐分发的平台，抖音缺少社交基因，那么抖音就注定与社交电商无缘吗？\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	社交对电商有何价值？\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	社交电商是相对于传统电商的概念——社交本身自带去中心化属性，由此延伸出来两个特征：裂变与私域流量。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	裂变来源于社交背后的人脉关系，不仅转化率远高于传统电商，更是能基于信任进行快速传播，也就是裂变获客；\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	而私域流量于商家不仅意味着跳出平台限制自主营销获客，私域流量还具有免费、优质、高黏性、可重复转化的属性。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;text-align:center;\"=\"\"> <img src=\"http://demoall.adashuo.com/20090/uploads/allimg/c191107/15I0c25W3510-551O.png\" width=\"450\" height=\"328\" border=\"0\" alt=\"抖商研习社：如何在抖音做社交电商？-第1张图片-小七抖音培训\" title=\"抖商研习社：如何在抖音做社交电商？-第1张图片-小七抖音培训\" style=\"height:328px;width:450px;\" /> \r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	抖音也能做社交电商吗？\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	1、社交土壤\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	抖商研习社需要指出的是，抖音虽然并非社交产品，但有人的地方就有社交——抖音好友与好友间、粉丝与红人间都有着浓厚的社交氛围，只不过抖音是以陌生人关系链组成的社交平台。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	同时抖音庞大且优质的用户群——以18-28年龄为主，多分布于一二线城市，且女性占比超过60%——配合内容的高传达效率，使得社交裂变有了肥沃的用户土壤。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	2、裂变载体\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	裂变的前提是有足够的用户基础——背靠抖音数亿活跃用户池，好的视频依托推荐算法，及话题、热榜、群聊等流量分发入口，能迅速成为爆款，进而触达更多潜在用户。\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	裂变的关键在二次分享，而商品橱窗与购物车并没有相匹配的能力，这就需要借助抖音小程序了：除了可以驱动用户“”挂载小程序二次传播外，小程序的营销插件也自带裂变能力，进而打通裂变的闭环。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	怎么裂变起来？\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;text-align:center;\"=\"\"> <img src=\"http://demoall.adashuo.com/20090/uploads/allimg/c191107/15I0c2593MP-E412.png\" width=\"450\" height=\"331\" border=\"0\" alt=\"抖商研习社：如何在抖音做社交电商？-第2张图片-小七抖音培训\" title=\"抖商研习社：如何在抖音做社交电商？-第2张图片-小七抖音培训\" style=\"height:331px;width:450px;\" /> \r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	1、爆款视频引流\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	抖音卖货的基本逻辑是爆款短视频引流+小程序交易，而爆款视频主要取决于算法推荐，判定标准主要为完播率、点赞评论分享率等，与其辛苦摸索做视频，更便捷的方式则是通过与红人大V合作，以种草视频的方式引流。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	2、给用户裂变的动机\r\n</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;\"=\"\">\r\n	抖商研习社有了流量并形成转化后，还需要二次分享才能形成裂变，这就需要给用户一个分享“动机”，可以是折扣、优惠券、返现、赠礼等等，而小程序的营销插件如拼团、砍价、抽奖、分销等，则可以为商家提供裂变营销工具。\r\n	</p>\r\n<p style=\"color:#333333;font-family:\" font-size:16px;background-color:#ffffff;text-align:center;\"=\"\"> <img src=\"http://demoall.adashuo.com/20090/uploads/allimg/c191107/15I0c25a5020-II2.png\" width=\"450\" height=\"319\" border=\"0\" alt=\"抖商研习社：如何在抖音做社交电商？-第3张图片-小七抖音培训\" title=\"抖商研习社：如何在抖音做社交电商？-第3张图片-小七抖音培训\" style=\"height:319px;width:450px;\" /> \r\n</p>',	'doc.png',	1.00,	20,	0,	0,	0,	'2019-12-03 14:08:36',	'admin',	12,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	1.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	4,	1,	0,	1),
(141,	'西藏政协原副主席周岐顺逝世 习近平表示慰问',	'<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	10月19日，京东宣布今年11.11大促将首次推出“京东拼购”等玩法。10月19日，美团点评官方微信小程序也正式上线了“好货拼团”板块。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	事实上，此前已经有包括阿里、苏宁、今日头条等多家互联网巨头切入了社交拼团业务。而这一切，在笔者看来，巨头们完全已经将拼购当成了获取用户流量的下一个杀手锏。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;text-align:center;\">\r\n	<img border=\"0\" src=\"http://demoall.adashuo.com/25707/uploads/allimg/c191120/15J2314405K20-1L320.jpg\" style=\"height:auto !important;\" />\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	拼购成“香饽饽”\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	根据艾媒咨询发布的《2018Q1中国社交电商行业市场研究报告》显示，2018年中国社交零售用户规模将突破3亿人，年均复合增长率将达到44.2%。这也意味着，未来社交电商或仍将有巨大的增长空间。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	而作为社交电商的集中展现形式，拼购正凸显着自身鲜活的能量。这其中，最值得注意的就是拼购已经成为巨头最新切入的业务。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	具体来看，巨头们正在尝试性地推出自家相关的拼购业务。如果让消费者直接说出某个巨头旗下的拼购业务，可能会非常轻松。因为这些巨头推出的拼购应用，名字上大同小异——手淘特价版、京东拼购、苏宁拼购、今日头条的“值点”……\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	此外，支付宝联合淘宝上线拼购小程序“每日必抢”，网易则推出了“网易一起拼”。总的来看，它们还都是以“拼”、特价为主要特性，为自己烙印下超值的标签。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	而从数据上看，拼购在近段时间以来也成为电商行业的一个热词。根据速途研究院发布的《2018上半年国内拼购电商市场研究报告》显示，在巨头的入场下，它们不仅让自身拥有了亮眼表现，还让拼购行业获得了整体提升。从微信指数和百度指数看，各个巨头的拼购业务都有着显著提升。这也意味着，以布局消费分级市场为目标的拼购，成为了当下巨头眼中的“香饽饽”。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	巨头在拼购行业的试水，还反应在将自身的资源不断向拼购业务倾斜。比如，很多巨头都举办了优惠活动来吸引消费者，并展现自身拼购业务的特性。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	比如：京东拼购频道此前公布了双11玩法，旨在以流量传播扩散+提升订单为目标，通过打造贯穿双11的拼购寻宝乐园，同时引爆11.8拼购玩法狂欢日，为拼购小程序引流，帮助平台转化新用户并提升订单量。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;text-align:center;\">\r\n	<img border=\"0\" src=\"http://demoall.adashuo.com/25707/uploads/allimg/c191120/15J231440B4F-1U327.jpg\" style=\"height:auto !important;\" />\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	苏宁拼购则将重点在直采直销生鲜商品上发力。在刚刚过去的双十拼购日，苏宁拼购一天卖出了40万个柚子，这坚定了其发展生鲜拼购的战略构想。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	因此，我们可以看到，在巨头的不断试水下，拼购这一社交电商模式已经变得迅速火爆。对于消费者来说，这也是一个消费变得多元化的好兆头。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	品质化渐成主流\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	其实，如果不戴“有色眼镜”去看拼购的话，其身上还是有很多亮点的。拼购以低价引入流量，通过关系网对商品进行分裂曝光，在满足多数人追求“低价”需求的同时，又大幅度增加中小商家和尾货的曝光率和购买率。也正因为如此，拼购在当下俨然成为购物模式中的一股新势力。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	但值得注意的是，在拼多多一家独大的时候，其商品质量、售后等饱受诟病。山寨、造假的问题，也造成了诸多负面影响。而在巨头纷纷入场的情况下，实际上也意味着拼购将进入下半场。在下半场开启的同时，拼购也将迎来全新的发展拐点。拼购在展现品质化的同时，也将成为巨头业务的补充，让它们构建更为完善的商业生态矩阵。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	对消费者利好的消息，在于品质化将成为拼购的常态。同时，品质化也将是巨头拼购业务的竞争发力点。不管是为了稳固消费者群体，还是出于维护自身品牌形象的考虑，巨头都不会再去牺牲商品质量和售后来实现低价。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	它们会尽力展示自身的物流实力、电商交易技术能力、核心交易链路、消费保障制度等，将供应链优势发挥到极致。最终，巨头的拼购业务将让消费者享受到具有更高性价比的品质好货，并由此实现真正的消费升级。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	此外，拼购业务的上线也是对巨头自身实力的加强。以美团拼团为例，其让美团实现了从虚拟商品向实物商品的过度，完成了自身商业边界的扩张。中国社科院财经院互联网经济研究室主任李勇坚表示，“过去用户可能只有在吃饭等时候才想到打开美团，但如果增加了商品类拼团，既有用户可能会在APP上停留更多的时间用于浏览商品”。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	而对于巨头而言，以往虽然在努力强调业务之间的整合，但缺少了某个版块后，业务之间总会有割裂感。拼购业务的出现，或许就能成为“黏合剂”，让巨头的业务实现融合发展。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;text-align:center;\">\r\n	<img border=\"0\" src=\"http://demoall.adashuo.com/25707/uploads/allimg/c191120/15J231440I050-1c916.jpg\" style=\"height:auto !important;\" />\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	值得注意的是，对于巨头来说，它们此前都面临着各自不同的发展瓶颈。而要寻找创新增长点，就必须在流量上痛下苦功。拓展流量的最佳做法，就是通过开辟新业务获取。而拼购身为“引流大户”，自然被巨头所看重。在拼购行业的下半场，它们将争抢中高端消费人群，不断攫取新的流量。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	相信随着巨头纷纷切入拼购领域，后者也在加速下沉。而就发展趋势来看，只拼价格不拼质量的原始拼购模式注定被淘汰。在被巨头开启的下半场，拼购有望与消费升级概念的成熟、人均消费能力的提升高度契合。届时，拼购业务也将成为巨头比拼的另一立脚点。\r\n</p>',	'doc.png',	1.00,	7,	0,	0,	0,	'2019-12-03 14:09:59',	'admin',	0,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	1.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	4,	1,	0,	1),
(142,	'6609首歌从KTV下架，《十年》《泡沫》均中招',	'<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	11月5日，一项热搜出现在邦哥的微博首页，并且排名一路蹿升至第一，挂在榜首直至今日凌晨：6000多首歌从KTV下架。被下架歌曲中，《十年》、《泡沫》《死了都要爱》《听海》《K歌之王》等等大热歌曲赫然在列。许多媒体的标题用的是：你拿手的还能点么？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	而邦哥脑中也冒出了另一个问号：这些歌曲为什么被下架？谁主导了这次下架风波？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	一个民间组织，为何有权下架全国KTV的6000多首歌？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	这次下架风波毫无疑问是版权问题引起的：中国音像著作权集体管理协会（下称“音集协”）发出公告，要求KTV终端生产管理商和卡拉OK经营者在今年10月31日前，删除或者不向消费者提供6000多部音乐电视作品。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	乍一看这是一件好事，毕竟版权保护理应得到支持，即便6000多首歌的下架在短期内会给普通消费者带来一些麻烦，但依然有利于产业的良性发展。<strong>然而意外的是，邦哥就此与一位业内音乐创作者进行了解时，对方却对此次发出公告的“音集协”并不买账：这个协会其实不是国家的版权保护机构，之前还被央视曝光过收取高额版权费后，并没有给歌手支付费用，我对于之后钱的去向保留意见。</strong> \r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	业内人这样的评论，引起了邦哥的注意，我们随即找到了音集协官方微博，查看其回应此次事件的公告。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\"> <img alt=\"6609首歌从KTV下架，《十年》《泡沫》均中招，原因不止版权那么简单 \" border=\"0\" class=\"aligncenter\" src=\"http://demoall.adashuo.com/25707/uploads/allimg/c191120/15J231444420Z-10TG.jpg\" title=\"6609首歌从KTV下架，《十年》《泡沫》均中招，原因不止版权那么简单 \" style=\"height:auto !important;\" />众所周知，KTV使用他人音乐作品，需要依法取得授权。但全国KTV可以说是海量的，KTV所需要使用的作品也是海量的。实际经营中，要经营者自己去一对一地取得授权，说句实话，并不现实。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	音集协就是在这样的背景下成立的。我们查看了其官网资料，根据资料显示，该协会是会员制，注册会员后，协会可以帮助你进行统一的版权管理，对全国的KTV进行作品授权，或者进行相应的维权措施。但让邦哥十分惊诧的是，这次被下架的6609首歌，背后的版权所有者，没有一家是音集协的会员。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	换言之，<strong>音集协的权利范围本应是帮自己的会员授权和维权，这次却是向6609首他们本应管不着的歌，发放了“下架通知”</strong>……\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在音集协官方微博的回应公告中，这一消息得到了证实：\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\"> <img alt=\"6609首歌从KTV下架，《十年》《泡沫》均中招，原因不止版权那么简单 \" border=\"0\" class=\"aligncenter\" src=\"http://demoall.adashuo.com/25707/uploads/allimg/c191120/15J23144450T0-114138.jpg\" title=\"6609首歌从KTV下架，《十年》《泡沫》均中招，原因不止版权那么简单 \" style=\"height:auto !important;\" />这让邦哥不禁产生了一个疑问：不是音集协的会员，我的歌曲就不能在KTV里播放了么？音集协到底是一个什么样的组织，怎么会有这么大的权利，对非会员的作品也能进行下架处理？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	就此我们在其官网查找到了音集协的《协会章程》，章程总则中清晰地写明了音集协的性质：本团体是由依法享有音像节目著作权或者与著作权有关的权利人<strong>自愿结成的全国性、非营利性的社会组织</strong>。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	一个自愿结成的会员制民间组织，从法理上讲，应当并不具有行政执法权，按照常理本应无权对“非会员”的作品进行下架处理。而在音集协此次回应的公告中，对这一问题的描述如下：\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;text-align:center;\"=\"\"> <img alt=\"6609首歌从KTV下架，《十年》《泡沫》均中招，原因不止版权那么简单 \" border=\"0\" class=\"aligncenter\" src=\"http://demoall.adashuo.com/25707/uploads/allimg/c191120/15J2314445T30-12W41.jpg\" title=\"6609首歌从KTV下架，《十年》《泡沫》均中招，原因不止版权那么简单 \" style=\"height:auto !important;\" /> \r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	对此，邦哥咨询了法律方面的专家，对方表示：6000多首歌的权利人或其委托的代理公司对KTV经营者提起的单独诉讼，就法律关系上讲与音集协相互独立，并无关系。但公告中并未提到音集协与这6000多首歌的权利人或代理公司是否有委托关系，因此<strong>音集协此次的“下架通知”背后，是否有可能是接受了歌曲权利人本身的授权或委托，我们也不得而知。</strong> \r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	曾被众多媒体质疑、央视曝光高额版权费流向哪里？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\"> <strong>2006年，国家版权局规定，开始收取卡拉OK每包间一小时12元的歌曲版权费。我们日常去KTV的费用中，就包括了这部分版权费。</strong>那么这部分版权费收取后流向了哪里呢？根据文章开头从业者的说法，邦哥查阅了很多资料，发现这已经不是音集协第一次处于舆论中心。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	2009年，中央电视台连续多个栏目对音集协收取卡拉OK版权费的情况进行了报道；中央二套的《今日观察》栏目还播出了一期新闻专题节目《版权费还是保护费》，邀请两位专家，围绕卡拉OK版权收费及其分配问题。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	根据当时的报道，<strong>音集协自2007年开始收取KTV及卡拉OK版权费，至2009年，收取的版权费已达8000万元，但这笔钱的使用分配却很不透明，相当多歌手表示并未拿到应得的报酬，但作为集体管理组织的音集协却要收取高达50%的天价管理费。</strong> \r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在当时的采访中，音集协不愿详细说明收费方式以及对著作权人的返还方式。不过一位业内人士向央视记者透露，收费是通过一家叫做“天合文化”的公司进行的。根据公开资料，该公司成立于2007年8月，受音集协委托代收卡拉OK版权使用费。音集协负责授权，天合文化负责收费，二者形成一套KTV歌曲版权收费系统。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	而那时的国家版权局版权管理司王自强司长则认为音集协的做法有欠妥当，在接受记者采访时表示，“集体管理组织是一个非营利性机构，不能以组织企业来进行收费，只能建立自身的收费队伍。收费本体是你本身，你不能有一个第三者出来。”\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	那是音集协引起争议声浪最大的一次，此后也曾有过多家媒体跟踪报道过音集协收取版权费的相关内容。早在2008年就有北京中银律师事务所董正伟律师向国家工商总局、国家发改委举报，请求对音集协向KTV行业收取著作权使用费开展反垄断执法。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	而近两年，音集协受到的质疑更加密集了起来，2017年、2018年都有KTV联合状告天合公司（音集协的授权收费单位）进行行业和价格垄断，但最终都以天合的胜诉告终。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	有趣的是，<strong>音集协与天合文化的合作自2007年至2018年，11年间从未停止。但就在邦哥发稿前不久，音集协官网上出现了一份最新公告，终止了与天合文化的委托合作。</strong> \r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;text-align:center;\"=\"\"> <img alt=\"6609首歌从KTV下架，《十年》《泡沫》均中招，原因不止版权那么简单 \" border=\"0\" class=\"aligncenter\" src=\"http://demoall.adashuo.com/25707/uploads/allimg/c191120/15J231444A250-13U93.jpg\" title=\"6609首歌从KTV下架，《十年》《泡沫》均中招，原因不止版权那么简单 \" style=\"height:auto !important;\" /> \r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	被下架歌曲并非不能唱了，版权保护，路漫漫其修远兮\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	对于一个行业的健康发展来说，6609首无授权歌曲自KTV下架，理应得到支持。但版权收费的规范性、透明性，同样是应该得到重视领域。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在此次风波中，被认证为音集协副理事长的周亚平的微博发言，同样引发了相当多网友的不满：\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;text-align:center;\"=\"\"> <img alt=\"周亚平表示：希望权利人加入，而不加入的后果是“作品被摒弃在卡拉OK渠道之外”\" border=\"0\" class=\"aligncenter\" src=\"http://demoall.adashuo.com/25707/uploads/allimg/c191120/15J231444I530-14Kc.jpg\" title=\"6609首歌从KTV下架，《十年》《泡沫》均中招，原因不止版权那么简单 \" style=\"height:auto !important;\" /> \r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	周亚平表示：希望权利人加入，而不加入的后果是“作品被摒弃在卡拉OK渠道之外”\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在撰文的过程中，邦哥将此次下架的6609首歌曲完整名单下载了下来，发现实际上遭到下架的，只是该首歌曲的某些版本。例如周杰伦遭到下架的《告白气球》等歌，就仅限《中国新歌声》第一季播出版本被下架。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\"> <img alt=\"6609首歌从KTV下架，《十年》《泡沫》均中招，原因不止版权那么简单 \" border=\"0\" class=\"aligncenter\" src=\"http://demoall.adashuo.com/25707/uploads/allimg/c191120/15J231444PZ-15S59.jpg\" title=\"6609首歌从KTV下架，《十年》《泡沫》均中招，原因不止版权那么简单 \" style=\"height:auto !important;\" />虽然这样的版本限制让很多小伙伴产生了“虚惊一场”的感觉，但邦哥要提醒的是，<strong>版权制度的目的，以及所要保护的对象，是创作者和版权所有者的利益。权利人们的利益，决定了他们的生存环境。</strong>如果从业者无法生存，音乐产业的发展从何谈起？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	中国音乐版权保护之路，依然路漫漫其修远兮。\r\n	</p>',	'doc.png',	1.00,	15,	0,	0,	0,	'2019-12-03 14:10:31',	'admin',	3,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	1.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	10,	1,	0,	1),
(143,	'多家快递推隐私面单 个人信息用星号或笑脸代替',	'<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	人工智能时代已来，雷军为小米找的下一个风口是什么？成立相机部门能“干翻”华为吗?\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;text-align:center;\"=\"\"><br />\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	▲雷军在在故宫发布滑盖手机MIX3\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	作者 |马婧\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	编辑 |赵泽 杨砺\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在喊出“今年相机部门有没有年终奖，就看能不能干翻华为”之后，小米董事长雷军又发新手机了，这一次是在故宫。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	2018年10月25日，在故宫发布磁动力滑盖手机MIX3乾清宫户外发布会，雷军在现场有点激动，一个人solo了将近一个半小时。雷军在介绍手机后置相机时，突然天空中传来两声乌鸦叫，雷军忍不住笑场，说连鸟都在肯定小米手机，“这是我们第一次办的户外的发布会，还这么有趣啊。”\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	25日早间，小米集团发布公告称，预计到10月底，手机出货量将突破1亿台，提前两个月完成2018年全年目标。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	雷军在发布会上谈到，今年手机大厂商和小厂商之间的差距会拉大，主要原因是各家在相机、AI方面投入成本不同所致。今年5月，雷军在内部信中宣布，在手机部内成立单独的相机部，集中全公司优势资源，提升小米手机的拍照品质。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	雷军曾对相机部门的同事说，今年相机部门有没有年终奖，就看能不能干翻华为。25日下午更新了最新成绩，小米MiX3以103的成绩超过了华为P20。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	小米如何“干翻”华为呢？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	▲MIX3故宫乌鸦捣乱小米发布会现场 雷军笑场：连鸟都肯定了\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	未来高增速或不靠手机靠IoT\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	新京报：小米过去8年保持了高速的增长，未来还能有非常高的增速吗？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	雷军：我们对小米未来的高速增长很有信心。首先手机行业是一个很大的市场，2017年全球共销售手机14.7亿台，小米销售了9000多万台。随着5G时代的到来，手机市场可能再次迎来增长，虽然不会像过去增长那么快了，但这个市场即便不再增长，对于小米来说仍然有巨大的成长空间。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	其次，手机之外，小米在智能硬件和消费升级领域布局广泛，已经进入了100多个品类，建成了全球最大的IoT物联网平台。随着AI时代的来临，AI+IoT将产生巨大的价值，小米已经具备了一些优势。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	另外，小米在海外市场有巨大的机遇。小米手机已经进入了74个国家和地区，还有很多市场有待进入，我们的很多品类也还没有进入全球市场。随着小米一步一步进入新的市场，把新的市场做好，我觉得小米未来还有十倍以上的成长空间。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	新京报：我们注意到小米还在布局智能家居。有观点认为智能家居是个伪命题？你怎么看这个问题？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	雷军：“智能家居”不是一个新词，二十年前在国外就有了，只是一直没有推动。我们觉得背后主要原因是商业通道和技术通道没有打通，比如以前智能家居的成本非常高，家里必须重新装修一遍，这对消费者难以负担，此外，不同厂家的产品之间也很难互联互通。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	小米做了两件事情来解决，首先我们把一个个的产品智能化了，消费者买回家后，突然发现实现了智能家居，这是商业通道理顺了。另外，我们做了互联互通的模组，在技术上也打通了，小米智能家居产品由很多不同的公司生产，但只要用了这个模组就可以互联互通。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	智能家居目前只是刚起步，小米也只是刚跨过门槛，今后智能家居的发展空间可能远超我们想像。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	新京报：有人说，小米生态产品只是在做微创新，你怎么看这个问题？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	雷军：从我们创业的经验来看，成功背后都有不为人知的艰辛，哪怕是一点点成绩，都要付出巨大的努力。所以我觉得我们不要小看微创新，为了提升消费者的体验，哪怕仅仅是1%，我们也投入了100%的精力。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	小米立志要成为一家伟大的互联网公司，让全球每个人都享受科技带来的美好生我没有。我们只有全力以赴做好每一件小事，才是走在正确的道路上。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	下一个互联网浪潮是人工智能\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	新京报：如何看待互联网这20年来在中国的发展，如果用几个关键的时间点来划分，你会怎么划分？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	雷军：我觉得2007年苹果推出iPhone是个很重要的事件，智能手机的出现极大的改变了互联网，我判断手机会逐渐替代个人电脑，移动互联网的时代将会来临。2010年小米成立，2011年推出了第一代小米手机，我们推动了智能手机在中国的快速普及和品质提升，移动支付、电商、社交网络、短视频等行业在中国的蓬勃发展，都有赖于庞大的移动互联网人口，这方面小米做了一点贡献。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	新京报：互联网下一个浪潮会是什么？在这个浪潮下，小米的机会是什么？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	雷军：人工智能的时代已经到来了，人工智能也是小米最重要的战略，我们拥有四项巨大的优势，用户群、海量设备、海量的数据、对整个AI时代的认知，很早就重视了云服务和大数据。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	小米选择的突破口是IoT，也就是万物互联，我认为AI与IoT结合将形成AIoT，也就是万物智慧互联，在这个领域未来有着巨大的发展空间。小米已经建成了全球最大的消费物联网，连接了1.15亿台智能设备（不包含手机、平板和笔记本电脑），小米人工智能助理小爱同学月活跃设备超3000万，月唤醒计数超10亿次，累计唤醒次数超50亿次。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“天使投资人经历让我学会找风口”\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	新京报：从金山时代开始，业界对你的评价就是IT劳模，怎么看待这一评价？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	雷军：如果我们要实现与众不同的梦想，付出的不比别人多，怎么可能成功呢？我现在还是这样认为，创业并不光鲜，成功的企业家也不像大家想的，轻轻松松就成功了，哪怕一点点成绩，背后都要付出极大的努力。在成功的路上，其实只有这一个秘诀认真拼命地工作。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	新京报：天使投资人的身份对于创办小米有哪些帮助？创业者和投资人的思维方式最大的不同之处是什么？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	雷军：因为天使投资人做的就是看大势，找风口。我觉得创业要想五年后是什么样子？十年后是什么样子？什么是正确的事情，什么是正确的时间点？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	我当年是一个手机发烧友，认为手机上网是未来的趋势，未来10年是移动互联网的天下，那我接着就想应该做些什么？所以我用投资人的身份，去看谁在做移动互联网，去搞清楚移动互联网到底是什么，这个过程中我们越来越坚信移动互联网的未来，最终在2010年决定创办小米。\r\n</p>',	'doc.png',	1.00,	6,	0,	0,	0,	'2019-12-03 14:11:24',	'admin',	1,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	1.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	4,	1,	0,	1),
(144,	'图:倪妮秀香肩 林允儿红裙美艳 宋祖儿抹胸纱裙仙气足',	'<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	不在沉默中爆发，就在沉默中灭亡！\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	这句话来形容当下的区块链。2018年疯狂的区块链因受政策监管与打压，资本、媒体、甚至创业者都趋于冷静。或许，这就是黑暗里的爆发前夜吧。但这个前夜还很长很长…\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	最近一篇题为《业内人士：区块链逐步融入农业发展》文章引起我们的关注。该文提到：“截至目前，区块链已被应用于产品溯源、农业保险、农村金融、智能合约等多个场景。尽管目前区块链技术在农业领域的应用范围还较为有限，但是许多业内人士对于区块链在农业领域的未来发展前景仍然满怀期待”从种种迹象来看，业内人士非常看好区块链在农业领域和场景里的应用。另外，还有政府官员也为区块链+农业打CALL。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	内蒙古蒙草生态环境（集团）股份有限公司董事长王召明表示，作为农业大国，要利用物联网、大数据、移动互联网、人工智能、区块链等现代信息技术，大力推动农业全产业链改造升级，为实施乡村振兴战略插上互联网的翅膀。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	可以肯定：区块链没有倒下，区块链在等待机会。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	业内专家指出，2019年有望成为区块链技术真正落地应用，走向产业化的一年。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	区块链诞生之初，外界都追捧：区块链是各个行业的救命稻草。尤其金融行业、食品行业，当然也包括农业领域。我们聊聊区块链解决农业什么问题？我们认为个有以下几个问题！\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	1农业领域看好区块链\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	1农产品可溯源\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	农产品溯源一直是农业的一个痛点问题。而区块链技术利可以对记录实现不可篡改，因此从农产品的生产端到流通端、消费者都有详实的数据，可以实现消费者明明白白消费，提高消费者购买的意愿。农产品溯源可以提升农产品安全性以及食品的安全性。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	2信息透明\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	农业领域除了可溯源之外，生产者与需求方的信息也存在不透明的问题。一旦区块链技术应用与农业。大家就可以通过大数据分析，建立种植户、采购商的信用评级参考；利用智能合约在种植户和采购商之间保证公平交易。同时，区块链技术可以提高农产品买卖双方的契约精神。另外，随着食品供应链中区块链的出现，这可以简化这一过程，因为数据管理系统，将一系列农民、加工商、分销商、监管机构、零售商和消费者纳入其雷达范围的数据管理系统变得更加透明。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	3降低成本\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	区块链技术运用之后，生产、流通等2大环节的成本会大大降低。比如，区块链技术解决信息自动存贮和数据库的功能，如此就减少了人工的投入和其他设施的投入。另外，区块链及应用实现万物互联，帮助生产商和渠道商降低各项开支。同时，生产和流通成本的降低，也会降低农产品的价格，最终还是消费者获利。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	因此，区块链技术在农业领域的应用等到各级人士的认同。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	2现在的区块链农业玩家\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	从以下多个案例来看，这些企业的确把区块链技术应用到用户服务中。他们希望借助区块连技术解决食品安全和可溯源，从而提高消费者对品牌的认可度。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	1沃尔玛\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	沃尔玛公司在2017年内在区块链技术领域作出了大量尝试。沃尔玛一直在与IBM合作，共同开发针对食品安全问题的区块连解决方案。比如，沃尔玛把区块链放在芒果、猪肉等生鲜农产品上。沃尔玛食品安全副总裁Frank Yiannas曾表示：“我们的客户理应拥有更加透明的供应链。我们认为在21世纪，以前那种一步一步去追溯源头的方式已经过时了。这是一项由技术支持的明智举措，它将极大地造福我们的客户，并彻底改变食品体系，使所有的相关者受益。”\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	2 Dreyfus\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	大宗商品交易公司Louis Dreyfus（路易达孚）宣布已试用由ING（荷兰国际集团）等一批金融机构开发的基于区块链的交易系统。Dreyfus使用区块链平台来完成与中国供应商的大宗大豆交易，极大地缩短了交易时间。同时，据参与测试的公司表示，这次测试涉及从美国运到中国的大豆，并在平台内保存所有相关文件（包括销售合同和信用证）。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	3可口可乐\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	2018年，可口可乐正在与美国国务院、区块链信托加速器（BTA）、区块链技术公司Bitfury集团以及崛起币（Emercoin）共同合作，推出一项基于区块链技术的试点项目。同时，可口可乐公司建立区块里的平台，以帮助确保道德的糖生产。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	4家乐福\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	2018年，欧洲最大的零售商家乐福已经开始采用区块链账本技术去追踪鸡肉、鸡蛋和西红柿从农场送到商店的全过程，并将在未来几年在其所有生鲜产品线上部署这种技术。比如，2018年3月，家乐福中国首款区块链产品——琯溪蜜柚，获得用户疯抢。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	5 Smart农场\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	中国农业已经迎来4.0时代，高科技融合成为农业发展的方向。上海华中农投农业科技有限公司旗下Smart农场大力推动区块链的应用。将区块链技术与农业相结合后，能最大限度地消除信息不对称，提高整个产业链的信息透明度和及时反应能力，从而实现整个产业的增值。减少农药投入，提高农产品品质。解决农业的痛点，解决农产品的食品安全、食品供给问题，真的能让中国人都尝到放心的味道。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	3未来走向\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	区块链去中心化等特性，将大幅降低互联网维护成本，提升农业物联网的智能化和规模化水平。同时，基于区块链技术的农产品追溯系统，解决了消费者对于产品的信任危机，让人们的餐桌更健康，更安全。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	另据前瞻产业研究院发布的《中国区块链行业商业模式创新与投资机会深度分析报告》统计数据显示，随着区块链应用场景扩展，预计2019年具有投入产出的区块链企业超过600家，产业规模有望超过8亿人民币。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	有人预测：2019年，“区块链技术”正逐渐从幕后走向台前。我们从2个方面来看：区块链技术迎来利好！\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	1）从大背景来看，国家政策打击比特币，但支持区块链技术在各个行业的应用。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	2）从行业来看，目前大数据和人工智能的发展，区块链技术也将会逐步与其他高科技项目融合赋能产业。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在农业领域，区块链农业又将会呈现哪些趋势和走向呢？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	1物联网＋无人机＋区块链\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	中国农业已经迎来4.0时代，高科技融合成为农业发展的方向。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	物联网＋无人机＋区块链的结合将有利于精准农业的发展，减少农药投入，提高农产品品质。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	其中，物流确保万物互联，无人机提供生产管理服务，而区块链提供记录和可溯源等技术。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	2区块链+数据+人工智能\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	区块链应用于农业，能最大限度地消除信息不对称，提高整个产业链的信息透明度和及时反应能力，从而实现整个产业的增值。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	而区块链+数据+人工智能的融合发展，可以推动农业大数据的价值最大化，降低投入成本。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	3区块链+农业金融\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	2月初，中国政府发布了“关于农村金融服务振兴的指导意见”。此次提出的新框架，是国家农村振兴计划中金融服务效率提高计划的一部分。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	同时，该指南据称将有助于促进农村金融部门中如区块链等新技术的应用，以“改善农业信贷风险的识别、监测、预警和处置水平”。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	该公告还预测，新技术将鼓励金融机构“为农村电子商务开发专用贷款产品和小额支付结算功能，并开辟农村电子商务资本链”。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	区块链+农业金融将会为小农户贷款提供便捷途径，为农业金融机构的征信带来真实性和可预测性。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	4区块链+农村物流\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	随着区块链、物联网、大数据等新兴技术与物流行业的深度融合，供应链正成为区块链技术最具潜力的应用场景之一。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	由于农村物流的小散，导致包裹丢失、农产品上行困难等窘况。但区块链技术可以解决这些问题。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	西南交通大学交通运输与物流学院副院长罗霞指出示，农村振兴是今年党中央非常重要的战略部署，与农村物流高质量发展紧密相关。加强云计算、区块链、人工智能等供应链智能化技术在农村物流中的应用，为农产品的生产、检测、周转、销售、品控、管理等提供智力支持。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	5区块链+农业供应链\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	这一类应用就是各大商场嫁接区块链的原因。比如：沃尔玛、家乐福等大型超市把整个生鲜和食品供应链纳入区块链管理，从而降低成本，提高产品的安全性。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	目前，美国农业巨头嘉吉等都在大力发展区块链+农业供应链金融的应用。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	总结一下，2019年区块链在农业领域的应用将会再次迎来爆发。但我们还要明一点：区块链只是一项技术，而不是赚钱的工具。在整个农业发展中，区块链只做赋能者，而不是主导者。如此，路子才会越走越宽！\r\n</p>',	'doc.png',	1.00,	23,	0,	0,	0,	'2019-12-03 14:13:27',	'admin',	14,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	1.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	3,	1,	0,	1),
(145,	'詹姆斯自曝精神状态曾出现问题 一度不爱打球',	'<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	电子商务飞速发展，快速增长的包裹数量与日渐减少的快递员数量已经不成正比。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	快递员的工资回报越来越高，为什么这个职业在近年来从事人员锐减呢？对此，有很多快递员反映，虽然能够得到很高的工资回报，但随着人们对服务水平的要求也越来越高，他们也越来越辛苦。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	同时，快递员的社会地位相对较低，随着人们文化水平及文化素养的逐渐提高，一些有学历有技能的人都已不太愿意做快递员。申通副总在7月25日召开的中国快递“最后一公里”峰会上就表示，现今快递行业的痛点已不仅是解决“最后一公里”的问题，而是怎样才能够招到更多的快递员。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	中国高速发展中，人口红利也在逐渐的减少，越来越多的事情都开始被智能化技术所取代，但快递行业是属于劳动密集型企业，非常依赖快递员。快递行业正处在用人难之际，双十一等各种电商狂欢节的到来无疑是让这些快递企业悲喜交加。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	智能快递柜提升末端物流配送能力，备受物流企业青睐\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	快递员不足是人口红利减少的必然结果，因此急切需要新兴技术缓解快递行业的压力，智能快递柜作为解决方案就这样“问世”了。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	智能快递柜在2012年萌芽，中邮速递易率先推出智能快递柜，在初期遭遇了很多的质疑和非议，但在包裹数量不断增长以及城市年轻劳动力不足的情况下，智能快递柜已经成为末端物流配送能力的重要补充，各路资本企业竞相涌入该市场，想分得一杯羹。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	2015年6月，顺丰、申通、中通、韵达、普洛斯投资5亿元成立丰巢科技；2016年10月，中集e栈、上海富友收件宝、江苏云柜组成创赢联盟，形成了以速递易、丰巢和创赢联盟为主的三巨头格局；2017年7月，中国邮政集团与驿宝网络入股速递易，中国邮政以50%股份控股速递易，“国家队”正式进入智能快递柜行业……智能快递柜已然成为物流企业人手必备的基础设施。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	国家邮政局10月17日发布的 《2018年9月中国快递发展指数报告》显示，快递企业与第三方创新末端投递形式，基本形成上门投递、智能箱投递、平台投递等多元末端服务体系，主要企业设立智能快件箱25万组，箱递率达到8.4%。高速增长的数据表明智能快递柜前期虽饱受争议，但后期已逐渐被民众所接受。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	智能快递柜突破派件瓶颈，效果显著\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	首先，智能快递柜降低了人力成本，减少了快递员的工作负荷。快递员的工作量和工作任务较为繁重，在人手不足的情况下一个快递员往往需要承担起更多的工作，经常超出本来的工作时间，因此快递公司需要对快递员支付较高的人力成本。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	智能快递了增加派件数量，在提高了快递员的工作效率的同时，也提高了他们的收入，在一定程度上缓解了“用人难”问题，降低人力成本。在这一点上，丰巢获取得的效果极为突出：在今年九月初，丰巢与链家进行合作并声称他们的日均派件量已高达900万+,这个数据对于快递行业来说无疑是一个巨大的进步。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	其次，智能快递柜提高了用户隐私保护力度，取件时间更随意。当今社会，人们对于隐私非常重视，而在传统的快递人员配送模式中，存在快递信息被其他人窃取或是快递在寄存的时候丢失等问题，智能快递柜保密性更强，能极大减少了这种问题的发生。再加上传统的配送模式中快递员配送的时间可能会和收件人在家的时间不对等，给收件人带来了困扰，智能快递柜投入使用使得忙碌的人们可以随时取件，极为方便。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	智能快递柜陷入困境：难盈利、争议大\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	智能快递柜诞生是时代进步的需要，也给我们的生活带来了巨大的改变，但很多问题也接踵而来。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	首先，盈利难。一方面是因为快递柜的设备生产成本高和在每一个小区内投放的租金比较高，快递柜的场地年租费也较高，同时维护费用也不低。过高的成本使智能快递柜不能为企业带来营收利润，这对每一个企业来说都是致命的打击。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	佼佼者丰巢和速递易均面临着巨大亏损：截止2017年9月30日，丰巢科技在该年9个月期间的营业收入为1.6亿元，净亏损从2016年的2.5亿元扩大到2.76亿元，负债总额扩大到12亿元；运营速递易项目的三泰科技也是出现常年亏损，2015 年亏损3792.8万元 ，2016 年亏损 12.69亿元，2017年第一季度亏损也将近3000万元。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	另一方面是用户往往不会愿意为此付费。用户认为在购买商品时已支付过运费，取快递时就不应该再支付额外的费用，使得快递柜的亏损日益增加。同时，蜂巢、速递易等快递柜也开始向快递员收取存放费用，其中速递易快递柜的收费标准为：大箱0.6元/件，中箱0.5元/件，小箱0.4元/件，但很多快递员不愿承担这些费用。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	其次，智能快递柜虽然提高了快递员配送快递的效率，但使得快递员很轻松的逃避了签收这一流程。用户无法进行当面进行签收，使得物品运输过程中出现的质量问题时的合法权益无法得到保障，收货时发现快递有问题不知该向谁反映。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	最后，在包裹数量的飞速增长的背景下，快递员如果像从前一样一件件把快递送到消费者手中显然是不太现实的事。所以现在的快递员在快递高峰时段一般都使用智能快递柜，不会打电话一一进行通知，在把物品投入快递柜时会由系统自动给用户发送取件通知，而如果快递员在放入物品时把用户的手机号输入错误，会导致用户无法接收到取件通知，从而超时取件。现在部分品牌快递柜超过一定的取件时限需要收取一定费用，这让用户难以接受。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	另外，有用户在使用丰巢快递柜时，页面会出现“打赏”等字样，价格以1、2、5元为不等，这样确实能为丰巢带来一定的收益，虽然不是强制收费并且设有“跳过”的字样，但由于字体过小，有引诱用户消费的嫌疑因此用户在使用过程易产生误解与不满。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	智能快递柜如何赢得“民心”？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	智能快递的问题柜已经严重影响后期的战略布局和发展，企业应当如何解决成了广泛关注的焦点。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	首先，智能快递柜最初出现时毫无营收利润，很大程度上是因为单纯的取件不可能有任何收入增长，但是现在智能快递柜的发展已涉及到寄件的环节，这意味着快递柜也可以从中赚取一定的利润。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	智能快递柜要想继续获得更大的盈利，应该继续为用户提供更多增值服务，让用户为此愿意付出相等的费用。比如，在各种人流量较大的公众场合，有很多用户因为手上提的东西过多有很大的不便，快递公司可以在这些场合投放寄存柜方便用户存放，并收取一定的费用，据了解蜂巢已经在试点，今年5月中标了杭州周边17个高铁站，总计36组寄存柜的订单。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	其次，面对快递柜无法当面签收的缺陷，快递柜企业应继续完善快递柜的基础硬件设施，比如在每一组快递柜上安装摄像头，用户在取包裹时可以将包裹在摄像头下展示，将来包裹质量出现问题时可以避免物流企业和用户之间产生不必要的纠纷。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	最后，针对部分用户不满快递员在未经允许的条件下投递快递柜的问题，早在2016年国家邮政局发布的《智能快件箱投递服务管理规定（暂行）》中就曾明确提出，“经营快递业务的企业在使用智能快件箱投递快件前，应当征得收件人明示同意”，同时用户有权利决定是否使用快递柜或是按指定地点取货，用户应该积极行使自己的权利。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	企业在这样的背景下应加大对快递人员基本服务知识的培训力度，同时加强对客服人员处理客诉的能力，及时处理客户问题并进行反馈。快递员在把包裹放入快递柜时应检查该快递是否为需要保鲜、即食类食品，一旦出现商品问题则由快递公司或快递员承担全部责任。面对取件通知收不到等问题，在首次投递后收件人未能提取的情况下，快递企业应及时取回快递，联系收件人后再提供投递服务。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	小结\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	时代与技术在发展中，任何行业的各个环节都应该往效率更高，成本更低道路上发展。物流末端的需求是多样化的，送货上门是主流，但智能快递柜的市场潜力也不可小觑。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	根据中商产业研究院发布的 《2018-2023年中国智能快递柜市场前景及投资机会研究报告》 ，预计2018年智能快递柜市场规模将达169亿元，到2020年，中国快递柜市场规模将达近300亿元。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	所以，丰巢等智能快递柜未来应加大沟通协调力度，在提高消费者满意度的同时，尽快解决盈利模式问题，尽可能地保证效率、成本、体验和信息的互动。\r\n</p>',	'doc.png',	0.00,	28,	0,	0,	0,	'2019-12-03 14:14:23',	'admin',	1,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	0.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	11,	1,	0,	1),
(146,	'2019科技风云榜 谁是年度最佳风投机构？ 观众报名',	'<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	今年5月，唱吧终于完成了将近一年半的上市辅导工作。网上有消息称，唱吧在一个月后，就会正式向证监会递交招股书，踏上A股创业板的上市征途。但眼看着2018年就快要过去，却迟迟未见唱吧上市的消息。对此，唱吧创始人陈华在接受媒体采访时表示，对唱吧上市问题不愿多谈，言外之意是唱吧在近期内可能不会寻求上市。这突如其来的转变，让人们疑惑不解。唱吧在完成一年多的漫长上市辅导期之后，为何不愿上市？其究竟打的是什么“算盘”？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	唱吧上市搁浅，原因为何？\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	唱吧从2012年上线起，便风光无限。其在上线首日注册用户就超过10万，5天之内登顶AppStore排行榜。易观数据显示，直到2016年第3季度，唱吧还以53.6%用户渗透率位居移动K歌领域第一的位置。彼时，唱吧正如日中天，选择上市无疑是正确之举。然而世事无常，经过将近一年半的漫长辅导期，国内的在线K歌市场早已“物是人非”，唱吧已然错过了最佳的上市时机。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	其一，全民K歌抢了唱吧“风头”。众所周知，全民K歌背靠腾讯，可谓是含着“金钥匙”出生。全民K歌不仅拥有微信与QQ两大流量入口，还与QQ音乐共享丰富的音乐版权，在流量与音乐版权方面都有着天然的优势，是唱吧最强劲的对手。据了解，全民K歌自2014年上线起，其活跃人数一直高增猛涨，在2016年成功超越唱吧，并逐渐拉开差距。据易观数据，2018年第三季度，唱吧活跃用户为6560万人，而全民K歌活跃用户则为20705万人，是唱吧的三倍。面对全民K歌的“攻城略地”，唱吧显然处于不利地位。而全民K歌的赶超，可能打乱了唱吧的上市计划。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	其二，短视频平台的崛起，冲击整个互联网娱乐市场。近几年，由于快手、抖音等短视频平台的崛起，整个互联网娱乐市场变的更加“拥挤”，唱吧的K歌业务、直播业务等都受到了一定的影响。QuestMobile数据显示，2018年7月，短视频APP行业月度活跃用户规模为5.08亿人，而短视频APP行业总使用时长在移动互联网中的占比达到惊人的9.2%，要知道，就算是在线视频的占比也仅有9.5%。可见，短视频APP行业已经抢占了大量互联网用户的上网时长，唱吧无法视而不见。再加上全民K歌的存在，唱吧要想巩固自身地位并不容易，目前也很难有华丽的数据支撑，若是在此时上市，唱吧的估值可能并不理想。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	其三，互联网股市动荡不安。最近国内不少已经上市的互联网企业过的并不“如意”，如小米、拼多多和美团等企业都出现了市值大幅下滑的情况，就连腾讯、阿里巴巴等老牌互联网企业也没能避免。受此影响，唱吧此时选择不上市或许是明智之举。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	一方面，在国内互联网股市行情不利的情况下，唱吧此时上市无疑是逆水行舟，有着“流血破发”的风险；另一方面，今年国内的互联网公司纷纷申请上市形成了“上市潮”，如宝宝树、映客、小米和拼多多等，如此多的公司扎堆上市，吸引了不少资金注入，导致资本市场紧缩，也就是说投资人手里的钱越来越紧张。这也许会造成唱吧融资困难，难以得到理想的融资金额。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在这些问题影响下，唱吧暂时将上市的计划搁浅，等待更好的时机上市，或许是不错的选择。不过除了上述三个原因之外，也有业内人士猜测，唱吧之所以要搁浅上市，可能是其要放弃A股创业板，而选择赴港上市。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	港股市场火爆，令唱吧有所动摇？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	对于唱吧要赴港上市的猜测，也并不是没有依据。早在2015年，唱吧就曾想要赴美上市，但由于美国缺乏与唱吧对标的产品，而导致其估值过低，令唱吧有所顾虑。与之相比，当时国内的A股市场行情较好，且国内资本对互联网科技股也愈发青睐。所以再三思考后，唱吧毅然拆除了VIE架构，选择回国赶赴A股上市。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	时至今日，随着港交所在上市机制上的改革，首次接受同股不同权企业上市，为互联网企业打开了一扇大门，包括小米、美团点评、平安好医生和宝宝树等多家明星企业都选择在港股上市。而此时的唱吧或许面临着与三年前类似的选择题，是A股还是港股？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	据了解，上市A股要求较为严格，除了必须盈利三年才能申请IPO外，还必须同股同权。而现在的港股市场，除了支持同股不同权企业上市，其监管机构也更加独立透明和高效，公司一般在6到12个月就能完成上市过程，可以帮助企业更好地把握好上市时机。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	此外，A股实行的是“T+1”交易制度，股民们当天买进的股票当天不能卖出，且还有涨跌幅限制。而港股采用的则是“T+0”交易制度，在当天交易时段内，相关机构和股民们可以自由买卖，交易次数与涨跌幅均无限制，这种方式不仅能够提高市场的交易量，还能帮助投资者及时止损。所以二者相对比较来看，港股市场规则似乎更加灵活且合理化，能帮助企业有更好的发展。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	且从根本上来讲，企业上市无非就是希望借助资本的力量，获得更好、更快速的发展。而随着港交所改革，港股已经成为了众多互联网公司上市的首选。在此条件下，唱吧若是选择“跟风”，改赴港股上市，也不是没有可能。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	不过从目前来看，在市场竞争加剧、股市动荡等问题影响下，唱吧此时上市并不稳妥。所以暂时将上市计划搁浅，继续修炼“内功”，才是唱吧最好的选择。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	养精蓄锐，厚积薄发\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	目前，纵观整个移动K歌市场，已然是唱吧与全民K歌双雄称霸的局面，像天籁K歌、K米和酷狗唱唱等K歌产品已经难以给全民K歌、唱吧二者带来威胁。可见，唱吧在移动K歌领域还是有着非常明显的领先优势，只要其能够完善自身，加强功能创新，或许就能够摆脱全民K歌所带来的竞争压力，在互联网娱乐市场中走的更远，其上市之路也会变得更为平坦。对此，唱吧可以从以下三个方面入手。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	首先，丰富曲库资源，提高音乐品质。音乐版权是移动K歌行业的刚需，缺少相应的音乐版权，用户就无法得到理想的K歌体验。如在用户K歌时，一定会选择自己喜欢的音乐进行录唱，但用户若是在唱吧中搜不到自己想要唱的歌曲，在别无选择之下，用户就会选择用其他的K歌软件进行录唱，最终造成唱吧的用户流失。因此，唱吧要想缩小与全民K歌的差距，还需与相关的音乐版权公司合作，丰富自己的曲库资源。同时，唱吧还应继续提升APP内的伴唱、录音和修音等音乐品质，争取为用户提供更加优质的K歌享受，以此来留住和吸引更多用户。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	其次，加强线上、线下融合，丰富用户K歌体验。如今，唱吧正在大力布局线下市场，其不仅花费数千万元战略投资麦颂KTV，并实现了与麦颂KTV在社交、服务等多方面的合作，还大力布局线下移动迷你KTV业务，取得了不错的成效。据了解，唱吧不光在全国拥有400多家麦颂KTV门店，还在商场、超市和机场等公共场所布下了2万多台迷你K歌亭。不过唱吧虽然在线下布局极广，但其线下资源还未能与线上达到有效的结合。目前唱吧在APP内只提供了KTV包房预定、在线点歌和在线切歌等常用功能，还有很大的完善空间。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	对此，唱吧可以在APP内添加游戏点歌、K歌评比和K歌挑战赛等有趣功能，加强用户线下与线上的互动。同时，用户在麦颂KTV里演唱的歌曲最好也能保存在唱吧APP中，让用户可以在唱吧APP中发布并分享自己在麦颂KTV里的演唱歌曲，这不仅满足了用户的分享欲望，又加强了线上与线下的融合，可谓是一举两得。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	最后，走出海外，争夺更大的移动K歌市场。如今，唱吧已经在国内取得了不错的成绩，其知名度和影响力也都达到了一定的高点，所以唱吧要想再有突破，并不容易。在此情况下，唱吧若是向海外市场发起冲击不失为一个选择。一方面，目前海外的许多国家都缺少类似唱吧这样的K歌产品，还是一片蓝海，这对唱吧来说有着不错的发展机遇；另一方面，在全民K歌、抖音、快手等平台影响下，国内的互联网娱乐市场空间变窄，唱吧要想继续在此环境中发展将受到不小的阻碍。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	总的来说，虽然上市会为唱吧带来新的发展机遇，但在市场竞争加剧、股市动荡等问题影响下，此时上市，对唱吧来说有着较大风险。因此，唱吧只有继续精细化运营，加强线上线下融合，并等待时机成熟后再进行上市，才会迎来更好的发展。\r\n</p>',	'doc.png',	0.00,	15,	0,	0,	0,	'2019-12-03 14:17:25',	'admin',	3,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	0.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	10,	1,	0,	1),
(147,	'风口还是泡沫？华强北各式柜台纷纷转售电子烟',	'<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	换上炫彩外壳，装上多变口味的烟弹，上市多年的电子烟今年突然热度飙升，成了备受追捧的创投领域。除了罗永浩在发布会上顺势推销的福禄电子烟，2018年末到2019年初，还有近10个新兴电子烟品牌出现。在深圳华强北电子市场，出售电子烟的广告牌更是如雨后春笋般涌现。但面对日趋严密的控烟大网，创业者们能否咽得下“这口烟”仍存在极大变数。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\"> <strong>电子烟突然变网红</strong> \r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	蓝莓、菠萝、水蜜桃、绿豆冰棒、柠檬茶……说到这些，不少人会联想到口香糖或是冰淇淋，却几乎没人能想到，这些全都是电子烟推出的新口味。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	精巧如U盘或是一根签字笔，也不用点火，从口袋里掏出来，打开开关就能用——近一年来，以电子产品形象出现的电子烟成了创投领域的新网红。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	今年1月，罗永浩在子弹短信新版本“聊天宝”发布会上，顺势推销了一款名为福禄、由锤子科技二号人物朱萧木创业推出的电子烟产品。紧接着，同道大叔创始人蔡跃栋与黄太吉创始人赫畅推出的“YOOZ柚子”，5位自媒体人组成创始团队的“灵犀&nbsp;LINX”也纷纷杀入。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	猪年春节，常年浸淫在科技圈、创投圈的自媒体人士陈女士惊讶地发现，平日里不抽烟的她，竟然收到了3种不同的电子烟产品作为新年礼物。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在深圳华强北，曾经卖VR眼镜、贴牌手机和智能家居产品的柜台，纷纷开始转售电子烟。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	突如其来烧起来的电子烟，背后是资本不断添柴加火。2018年，国内有十几家电子烟公司获得资本青睐，总融资额达数亿元。Wel鲸鱼、YOOZ柚子、魔笛MOTI、TRYMIX反正、GOIN谷云、APOC……新兴的电子烟品牌让人目不暇接，俨然造就了岁末年初最火热的创业领域。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\"> <strong>风口背后的同质化</strong> \r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“电子烟界的iPhone”、“颜值爆表一口解馋”、“重新定义吸烟”……在各家打出的广告语中，几百元一支的电子烟似乎成了可供电子发烧友们品玩一番的电子玩具。然而，花哨热闹的营销语言背后，电子烟的实质技术并没有太大区别。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“花几个月到半年时间，联系供应商、备货、外观设计，剩下就不需要你再做什么了，几乎没有任何硬性投入，本质上是个非常‘轻’（投入）的生意。”早期投资人付强向媒体透露，做一个电子烟项目，对技术等原创能力的要求几乎没有门槛。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	多位行业人士透露，由于国内电子烟供应链已经被电子烟发展较为成熟的国外市场培育得非常完备，因此很多新创立品牌都是通过代工生产。有技术爱好者对几款热门电子烟进行评测后发现，几个品牌在开关控制、烟油技术等方面相差无几，只是烟弹、外壳颜色、口味等进行了不同的排列组合与拼凑。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“电子烟的产品结构并不复杂，主要构成也就是充电电池（烟杆）、雾化器还有烟油三部分。”新晋电子烟品牌灵犀创始人章晋源坦言，电子烟的制造门槛并不高，确实存在行业同质化问题，“灵犀LINX当前着重聚焦于品牌环节，属于产业链下游，希望设计的首款产品具有品牌辨识度。”\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\"> <strong>电子烟也有多重风险</strong> \r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“清肺水果味”、“健康清肺蒸汽烟”……稍加留意就会发现，不少电子烟公司将产品与健康挂上了钩。在他们口中，因抽烟承受健康风险的烟民可以通过电子烟追求潮流文化、拥有“健康生活方式”。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	电子烟是否能够像一些公司所说的那样起到“代烟”、“辅助戒烟”的功效？目前尚无定论。令人担忧的是，一些原本不吸烟的人因为对电子烟的好奇而加入了烟民行列。在游戏公司工作的白先生告诉记者，他的同事和合作伙伴里出现了好几位新一代“电子烟民”——而他们过去根本不碰香烟。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	北京营养师协会理事顾中一提醒，电子烟中虽然没有普通烟草燃烧所产生的焦油、一氧化碳等有害物，但仍然含有有毒、成瘾的尼古丁，对普通人特别是儿童、青少年仍然有危害。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	记者在一家电子烟的天猫店铺内发现，虽然商品详情页面的底部用黑色背景的字体写着“未满十八岁不允许购买”，但一不留神就会错过这一信息。并且，记者在尝试下单时，店铺对身份信息、年龄等方面毫无要求，消费者可以随意下单购买。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	顾中一还提醒，由于目前市场监管并没有完全到位，缺乏相关国家标准，电子烟产品中用到的原料、调味剂、工艺都较为随意，厂家很可能为了增加新奇体验加入一些对人体有害的物质。“哪怕是一些比较常见的添加剂，正常食用是安全的，吸入肺部却可能带来潜在风险。比如丙二醇是很常见的食品添加剂，但是燃烧后容易刺激呼吸道，一些电子烟的烟雾中也可能含有重金属。”\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	对创业者来说，更大的考验来自于市场的不确定性。在控烟大势下，多地已经将电子烟列入了管控范围。今年2月，继杭州、南宁等城市在公共场所禁止使用电子烟之后，深圳在其控制吸烟条例征求意见稿中将电子烟纳入了控烟“黑名单”。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	意识到道德、法律等多重风险，一些科技上市公司急于与电子烟划清界限。今年2月中旬，小米公司官方微博就对“小米旗下生态链公司将进军电子烟领域”一事进行回应，称“小米不会做电子烟，此事纯属谣言”。\r\n	</p>',	'doc.png',	1.00,	21,	0,	0,	0,	'2019-12-03 14:18:03',	'admin',	2,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	1.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	4,	1,	0,	1),
(148,	'无视乱港分子碰瓷 柏林动物园公开熊猫宝宝名字',	'<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	2018年可谓是中国智能音箱的元年。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	业内普遍认为，智能音箱是切入智能家居使用场景、并易于被用户接受的理想入口，而智能家居的开关一旦被打开，更多的产品和服务将快速进入消费者的日常生活，获得一个更多元的商业环境。因此，近两年国内外科技巨头、互联网巨头皆大力发展智能音箱，使得该领域得到飞跃式增长，并从小众逐渐走向大众。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	值得一提的是，智能音箱除了具有巨大的消费市场外，对于互联网巨头们来说更起到AI市场的“门票”的作用。在这个快节奏的时代，企业之间的竞争更加激烈，率先拥有某一行业的门票就相当于成功了一半。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	由此，继国外亚马逊、谷歌、Facebook、苹果等科技巨头布局智能音箱产业之后，国内如阿里、百度等巨头也纷纷入局，小度智能音箱、叮咚、天猫精灵等产品在市场活跃度直线上升，国内智能音箱市场一片繁荣，随后在去年打起了“智能音箱价格战”。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	全球互联网巨头共掀全球智能音箱浪潮\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	根据Strategy Analytics发布的《2018年第三季度全球智能音箱市场报告》，2018年第三季度全球智能音箱出货量达到2270万，同比增长197%，创历史新高。其中，亚马逊智能音箱的全球份额与2017年相比有大幅下降，但出货量一直在上涨，第三季度市场占有率依然最高，达到32%，而谷歌以23%的市场占有率紧追其后。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	值得一提的是，来自中国的阿里、百度、小米智能音箱出货量分别排在全球第三、第四、第五位。当中又以百度表现最为亮眼，其市场占有率从2018年Q2的1％增加到2018年Q3度的8％，超越小米，成为当之无愧的黑马。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	而根据eMarketer《2019年智能音箱市场趋势观察》的预测，2019年中国将拥有8550万智能音箱用户，超过美国7420万的用户数量。智能音箱在美国网民中的普及率为26.0%，远高中国的10.0%，因此未来中国智能音箱领域还有极大的发展空间。不过即便如此，国内企业想要在智能音箱领域进一步发展仍有极大挑战。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	首先，是亚马逊、谷歌、苹果等海外企业更加成熟的智能音箱产品的冲击。亚马逊于2014年11月发布了Echo音箱，揭开智能音箱的序幕，打了人工智能领域“领头羊”谷歌、设备领域“领导人”苹果一个措手不及，成为智能音箱领域的第一人，为其之后进军智能家居领域打下基础。随后谷歌、Facebook、苹果等科技公司纷纷跟进，相继推出GoogleHome、Portal、HomePod。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	而后，无论是亚马逊并购互联网路由器初创企业Eero，还是谷歌推出Google Wifi，都表明国外在智能家居领域发展正愈加成熟，由此给国内市场带来的冲击是巨大的。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	其次，是国内错综复杂的智能音箱市场而产生的原生阻力。国内智能音箱市场厂商繁杂，主要有五种类别：一是以BATJ等为主的互联网公司，希望通过语音这一入口建立智能生态，为既有的内容和服务寻找新市场；二是以科大讯飞为代表的，专注于技术开放平台建设的技术厂商；三是以喜马拉雅等内容厂商；四是主打智能家居的创业公司；五为以漫步者为代表的传统音箱厂家。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	与国外相比，国内智能音箱领域除了厂商更繁杂、竞争更激烈外，在时间上也有一定的滞后性。国内第一款智能音箱叮咚诞生于2015年，由京东与科大讯飞联合推出。此后国内智能音箱市场沉寂，直至2017年阿里试探性地推出天猫精灵，小米、百度等企业不甘落后，纷纷入场，国内智能音箱才进入密集发售期，一时间智能音箱领域热闹非凡，“百箱争鸣”。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	当先天不足遇上恶劣生存环境\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	当下，我们不能否认的是，随着家庭中联网设备的不断增加，有极大几率成为未来智能家居控制中枢的智能音箱有着非同一般的重要性。但古往今来，利益有多大，风险就有多大。对于如钥匙般的智能音箱领域来说，发展面前有三问需解答。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	首先，智能音箱如何“智能”？\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	每当市场有了新的风口，就会出现无数跟风之人，智能音箱也不例外。为搭上智能音箱的顺风车，传统音箱厂家推出不少产品，只不过卖点都集中于音质，本末倒置。 另外，“语音识别技术”也是尚未完善，一方水土一方人，同一语种还有不同口音，更别提各地方言以及语境涉及到的自然语言理解问题。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	除此之外，还有人工智能和物联网领域中老生常谈的安全隐患问题，如数据存储、身份认证、敏感数据保护等，在此不多赘述。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	其次，智能音箱如何提高普及率与使用率？\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	我们知道，物联网时代“未来智能家居的控制核心”这一定位是智能音箱如此火热的重要原因之一。而理想的智能家居生态并非是家居单品的智能化，而是彼此联动，达到互联互通互控的状态，但目前的智能家居系统仍旧处于互相独立的状态，使得智能音箱使用率不高，如同“鸡肋”。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	与国内相比，国外在此方面就先进得多，以美国为例，美国的智能家居行业有统一的标准协议，亚马逊的Echo可以直接接入各种智能家居设备，这也是为何美国智能音箱普及率远高中国的原因。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	最后，国内企业如何“走出去”？\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	在用户习惯方面，国内外有着不小的差异。以使用环境为例，国外用户居家环境多为开放式，美国家庭主妇在烹饪时都喜欢听音乐，因此智能音箱在国外的消费需求也相对较高。而国内，厨房客厅封闭性更高，生活环境相对嘈杂，相应地市场对智能音箱需求较低。此为国外厂家难以进入中国市场的重要原因之一，另一限制则是人机交互的“本土化”程度低。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	以苹果HomePod为例，虽然其Siri语音助手对中文的支持已经有一定成果，但在交互、理解能力等方面，与本土选手阿里、百度相比仍是落后。并且，以BAT为代表的国内企业拥有更多本土资源，境外企业如苹果，很难在中国有突破性进展。同理，国内企业想要走出去也会遇到同样的难题。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	综上，智能音箱可谓是“腹背受敌”，而现阶段各巨头发展智能音箱的主要目的并不是盈利，而是抢占更多的用户家庭，为未来AI生态建设进行数据铺垫。那么，中小企业如何在这场战争中存活呢？\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	双重风暴下，智能音箱可靠内容过冬\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	前文提过，国内有一类以喜马拉雅为代表的注重内容的智能音箱厂商，笔者认为现阶段此类厂商可能更好存活。现今用户对智能音箱的主要需求还处于“听”的情况下，智能音箱很大程度上是内容生态之争。在此基础上，喜马拉雅以自身丰富的内容为基础，推出智能音箱小雅，将更容易在家庭场景中突围。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	虽然从整体上看，喜马拉雅与BATJ等互联网巨头在技术和未来AI整体布局上存在相当大的弱势，但由于各种原因的限制，国内用户对智能音箱的需求在接下来很长一段时间里，都将处于“听”的阶段。并且，智能音箱核心技术“语音识别”，从本质上来说也是内容的一部分。从另一角度看，喜马拉雅的竞争对手也并非是BATJ等互联网巨头，其在智能音箱领域的发展更多的是为了扩充自身音频业务，巩固自身在在线音频市场的地位。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	同样的，在内容资源上有着强大优势的还有腾讯，毕竟现阶段消费者购买智能音箱的主要用途就是内容消费和智能家居两方面。在此基础上，腾讯可将自身音乐、阅读和视频整合，为智能音箱做内容支持。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	除了内容消费，“智能音箱+教育”的模式发展空间也十分广阔，尤其是早教领域。抛开说烂了的在线教育，光是国人对子女教育的重视程度，就足以让智能音箱注意到“早教”这一领域。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	单从目前智能音箱市场情况来看，短时间内C端消费市场的表现都比不过B端。因此，如何在B端站稳脚跟再最终反哺C端，是智能音箱发展过程中相当重要的一点。站在这个角度上看，“智能音箱+早教”的未来十分令人期待。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	毕竟，国内早教行业师存在资水平有限，地域发展不平衡，多数幼师仅经过短期培训就上岗从业，专业化程度低等问题。若是将智能音箱与早教结合，它所承载的大量专业、系统、科学的早教课程，能完美弥补传统绘本、书籍、视频等的缺点，再加上其操作简单、安全性高、不损伤视力的优点，能让智能音箱成为早教过程中不可或缺的工具。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	当然，除了以上两个方向，智能音箱作为人工智能音频端的入口，能够发展的B端场景是十分丰富的。就此，在C端市场来临前，国内非巨头企业在智能音箱领域也有了新的突破口。那有没\r\n</p>',	'doc.png',	1.00,	9,	0,	0,	0,	'2019-12-03 14:18:52',	'admin',	4,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	1.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	3,	1,	0,	1),
(149,	'扎克伯格阐述FB社交下一站：让交流更私密、更安',	'<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	社交网络下一步发展的未来在何方？6日，Facebook创始人扎克伯格给出了自己的答案。在一篇长达3200字的公开博客文章中，这家全球最大的社交网络的掌门人称，未来Facebook将专注于营造一个更为私密和安全的网络社交环境。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“当我思考网络的未来，我认为专注于隐私的通讯平台相比今天的开放平台，将变得更加重要，”扎克伯格写道：“今天我们已经看到私密消息、短故事分享和小规模群组是在线通讯交流发展最快的领域。”\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	尽管扎克伯格认为，开放社交网络在未来仍有一席之地，但更大的机会在于“建立一个首先专注于隐私的更为简单的平台。”\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	扎克伯格称，在过去15年间，Facebook和Instagram帮助建立了一个“数字化的公开广场“，但人们开始迫切需要更为私密的”数字化的客厅空间“。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	对于Facebook来说，这将是一个具有里程碑意义的转型，成立15年来，Facebook成功打造了全球最大的公开社交网络，并在此基础上建立起一家以广告业务为主的商业帝国。但近年来，随着一系列与用户数据隐私泄漏相关的丑闻接连爆发，Facebook开放社交模式遭遇到前所未有的严峻挑战。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	正是由于内外部坏境发生的变化，促使Facebook开始思考接下来的转型方向，如今，这家全球最大的社交网络通过其掌门人的一封公开信给出了解答。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“我认为未来的通讯将更多地转向私密的、加密的服务，这样人们在与别人交流时，对于信息的安全新、内容不会停留会更有信心，”扎克伯格说，“这是我希望我们能够帮助带来的未来。”\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	为了达成这一目标，扎克伯格称，Facebook即时通讯平台将向Whatsapp的模式靠拢，未来端到端的加密服务将贯穿于Facebook所有旗下包含即时通讯的业务功能，该表态印证了此前外界流传的Facebook计划打通旗下即时通讯功能的传言。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	扎克伯格称，计划按照打造WhatsApp的模式进行：专注于最为基本和私密的应用场景即时消息开始，让其尽可能的安全，然后在此之上建立更多让人们能够互动的方式，包括打电话、视频聊天、群组、故事、商业、支付最终成为更多私人服务的平台。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	为了实现这一转型目标，扎克伯格列出了数项准则，包括加密、缩短内容的存续、安全、互通和安全数据存储。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“我相信我们应该朝着建立这样一个未来世界而努力：人们可以私下说话并且知道他们的信息只会让他们希望看到的人看到并且不会永远存续下去，“扎克伯格说，”如果我们能够帮助世界朝着这个方向发展，我将会为我们所做出的努力感到自豪。“\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	以下为扎克伯格公开博客全文：\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	注重隐私的社交网络愿景\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	过去几年，我的重点一直是理解和应对Facebook面临的最大挑战。这意味着对关系到互联网未来的重要问题采取什么立场。在本文中，我将概述Facebook围绕建立以隐私为中心的信息和社交网络平台的愿景和原则。有许多的事情要做，在开发的进程中，我们承诺开放式的工作，并将与全社会的专家进行协商……\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	过去15年间，Facebook和Instagram一直在帮助人们与友人、社区和等同于数字城市广场中的兴趣联系在一起。但是人们也越来越想私下在相当于起居室的数字环境中进行交流。当我思考互联网的未来时，我认为一个注重隐私的交流平台将变得比今天的开放平台更加重要。隐私让人们有自由做自己，更自然地联系，而这些是我们建立社交网络的原因。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	今天，我们看到私有信息、短暂的故事和小型群组已成为在线通讯中增长最快的领域。这有许多原因。许多人更喜欢一对一交流，或者只是与几位朋友交流。人们对分享有永久记录的内容更加谨慎。我们也都希望能够私下和安全地进行支付。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	公共社交网络将继续在人们的生活中发挥重要作用--与你认识的每一个人联系；发现新的人、想法和内容；让人们有更广泛的发言权。人们每天都会发现有价值的内容，而且还有很多有用的服务可以构建在它们之上。但是现在，人们也想通过各种方式私下交流，这也让我们有机会打造一个首先专注于隐私、更简单的平台。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	我明白很多人不认为Facebook有能力、或者甚至不想构建这种以隐私为中心的平台，因为坦率地讲，我们目前在构建隐私保护服务方面没有很好的声誉，而且我们一直专注于更开放的共享工具。但是我们已多次表明，我们可以通过进化来打造人们真正想要的服务，包括私有信息和故事。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	我认为，通信的未来将越来越多地转向私有、加密服务。在此类服务中，人们可以确信他们对彼此说的话是安全的，他们的信息和内容不会永远存在。这是我希望我们能帮助实现的未来。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	我们计划用开发WhatsApp的方式来构建这一平台：专注于最基本和私有用例--消息--尽可能确保它的安全性，然后构建更多的方式让人们在此基础上进行互动，包括通话、视频聊天、群聊、故事、商业、支付、商务，最终成为许多其他类型的私有服务的平台。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	这个注重隐私的平台将围绕以下几个原则构建：\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	·私下互动：人们应该拥有简单、亲密的场所，在那里可以清楚地控制谁可以和他们交流，并且相信没有人可以接触到他们分享的内容。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	·加密：人们的私人通信应该是安全的。端到端加密防止任何人，包括我们在内，看到人们分享在我们服务中的内容。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	·减少永久性：人们应该感到自在，不应担心他们分享的内容会反过来伤害自己。因此，我们不会将信息或故事保留超过提供服务所需的时间，也不会超过人们希望它们留存的时间。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	·安全：人们应该期待我们会尽一切努力，在加密服务可能的范围内，确保他们在使用我们服务时的安全。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	·互操作：人们应该能够使用我们的任何应用联系他们的朋友，应该能够轻松安全地通过网络交流。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	·安全数据存储：人们应该期待我们不会在隐私和言论自由等人权记录薄弱的国家存储敏感数据，保护数据被不当访问。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	未来几年中，我们计划围绕这些想法重建更多的服务。在此行程中，我们面临的决定将意味着对关系到互联网未来的重要问题采取什么立场。我们清楚有很多权衡需要纠正，我们承诺与专家进行协商，并讨论最佳的前进方向。这需要一些时间，但我们不会关着门朝着这个方向发展。我们将尽可能以公开、合作地态度这样做，因为其中许多问题影响到社会的不同层面。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	私下互动是基础\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	要让一项服务感觉具备私密性质，绝不让用户怀疑在和谁交流。我们努力在所有产品中建立隐私属性，包括公共分享产品。消息服务的一个重要特性是，即使用户的联系人列表在扩充，用户的个人线程和群组仍然是私有的。随着时间的推移，用户的好友会逐渐发展，消息服务会优雅地发展，并保持亲密。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	这与更广泛的社交网络不同。在社交网络中，人们可以积累好友或追随者，直至服务更加公开。这非常适合许多重要的用途--告诉用户所有的朋友一些事情，在重要的话题上传递用户的声音，寻找有相似兴趣的人群，追踪创作者和媒体，买卖东西，组织筹款人，发展业务，或者让用户认识的每一个人在相同的地方得到好处。尽管如此，当用户一起看到所有这些经历时，感觉更像是一个城镇广场，而不是一个更私密的空间，比如客厅。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	我们有机会建立一个关注人们想要私下交流的所有方式的平台。这种隐私和亲密感不仅仅是技术特征--它被深深地融入到服务的整体感觉中。举例来说，在WhatsApp当中，我们的团队专注于在产品的各个方面创造一个亲密的环境。即使我们构建了允许更广泛分享的功能，这仍然是一种不太公开的体验。当团队开发群组功能时，他们设定了规模限制，以确保每一次互动都是私密的。当我们在WhatsApp上发布故事时，我们限制了公共内容，因为我们担心这种做法可能会削弱隐私感--即使这并没有真正改变用户和谁分享。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	几年后，我预计未来版本的Messenger和WhatsApp将成为人们在Facebook网络上交流的主要方式。我们致力于让这两款应用更快、更简单、更私密、更安全，包括端对端加密。然后，我们计划增加更多与好友、团体和企业私下交流的方式。如果这种进化成功，通过Facebook网络与用户的好友和家人互动，将会从根本上成为一种更加私密的体验。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	加密与安全\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	人们期望他们的私人通信是安全的，并且只被收方看到，而不是黑客、罪犯、过度干预的政府，甚至是操作正在使用的服务的人。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	人们越来越多的意识到，更多的实体可以访问自己的数据，就越容易被人滥用或被网络攻击泄露。一些人也越来越担心，技术可能会将权力集中在政府和像我们这样的公司手中。一些人担心我们的服务可能会访问他们的信息，并将其用于广告或其他他们不期望的方式。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	端到端加密是开发注重隐私的社交网络的重要工具。加密正在分散--它限制了像我们这样的服务看到流经的内容，并使其他人更难访问用户信息。这就是为什么加密在我们的网上生活中越来越重要，从银行到医疗健康服务。这也是为什么我们在收购WhatsApp后把端到端加密植入WhatsApp中的原因。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	去年，我曾与持不同政见者交流过。他们告诉我，加密是他们自由甚至活着的原因。一些政府经常对数据提出非法要求，当我们在法庭上驳回这些要求时，我们总存在败诉的可能--如果信息没有加密，我们要么必须交出数据，要么不遵守法庭规定导致员工被逮捕。这看起来很极端，但是我们曾有过这样的案例，一名员工就因为不提供对某人私有信息的访问而身陷囹圄。事实上，我们也无法访问这类信息，因为它是加密的。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	与此同时，在我们能够在所有消息服务中部署端到端加密之前，我们需要解决真正的安全问题。加密是保护隐私的有力工具，但也包括做坏事的人的隐私。当数十亿人使用同一服务连接时，他们中的一些人会将它滥用于真正可怕的事情，比如剥削儿童、恐怖主义和敲诈勒索。我们有责任与执法部门合作，并尽所能帮助防止这些行为。我们正努力通过检测活动模式或其他方式，来提高识别和阻止应用中不良行为的能力，即使我们看不到消息的内容，我们将继续对这项工作进行投资。但是我们面临着一个内在的权衡，因为当我们的安全系统能够看到这些信息时，我们永远也不会发现我们今天所做的所有潜在伤害。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	找到保护隐私和安全的正确方法，是社会在历史上一直努力解决的问题。这里还有许多悬而未决的问题，我们将与安全专家、执法部门和政府协商实施安全措施的最佳方式。我们还需要与其他平台合作，以确保整个行业能做出正确的事情。我们越是能创造一种共同的方法越好。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	总的来说，我相信为所有私人通信实施端到端加密是正确的。人们通过信息和电话完成一些最敏感的私人谈话，在网络安全威胁日益增加、许多国家政府干预过度的情况下，人们希望我们采取额外措施来保护他们最私密的数据。对我而言这似乎是对的，只要我们花时间构建适当的安全系统，尽可能在加密服务的范围内阻止不良行为。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	我们已开始在WhatsApp的基础上开发这些安全系统，在全面实施端到端加密之前，我们将在2019年及以后与专家讨论这些系统。随着我们从专家那里学到更多的知识，我们将最终确定如何推出这些系统。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	减少永久性\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	我们越来越相信在短时间内保存信息非常重要。人们想知道他们分享的信息不会反过来伤害他们，减少他们信息的存储和访问时间会有所帮助。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“永久性问题”开发社交工具的一个挑战是。随着时间的推移，我们积累了大量的信息和照片，它们在成为资产的同时，也成为了一种负担。例如而言，许多Facebook的老用户可能会有年轻时候的照片，这可能会让人尴尬。但是人们也非常喜欢记录他们的生活。如果Facebook和Instagram上的所有帖子都消失了，人们将无法获得他人分享的大量宝贵知识和经验。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	我认为有机会为私有通信平台设定一个新的标准--内容会自动过期或随时间归档。除非用户存档，否则故事会在24小时后过期，这让人们更自然地分享。这种理念可以扩展到所有私人内容。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	举例来说，在默认情况下，信息可以在一个月或一年后删除。这将降低用户的信息再次出现并让他以后尴尬的风险。当然，如果用户愿意，可以自己改变时间框架或者关闭线程的自动删除。如果用户愿意，我们还可以为用户提供选项，让他将个人信息在几秒钟或几分钟后设置为过期。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	限制我们存储消息元数据的时间也有意义。我们使用这些数据来运行我们的垃圾信息和安全系统，但我们并不总是需要长时间保留这些数据。解决方案的一个重要部分是首先收集较少的个人数据，这也是WhatsApp从一开始就建立的方式。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	互操作\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	人们希望能够选择他们用来与人交流的服务。然而，今天如果用户想在Facebook上给人们发信息，你必须使用Messenger；在Instagram上必须使用Direct；在WhatsApp上必须使用WhatsApp。我们想给人们一个选择，这样他们可以通过这些网络从他们喜欢的任何一款应用联系他们的朋友。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	互操作性有隐私和安全优势。举例来说，许多人使用Android上的Messenger收发短信。这些文本不能进行端到端加密，因为短息协议没有加密。然而，有了跨我们服务传递信息的能力，用户就可以从Messenger向WhatsApp中的某人的电话号码发送加密短信。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	这还可以提高许多体验中的便利性。在这些体验中，人们使用Facebook或Instagram作为他们的社交网络，WhatsApp作为他们首选的消息服务。举例来说，许多在市场上出售商品的人会列出他们的电话号码，这样人们就可以发送与购物相关的信息。这并不理想，因为用户要给陌生人提供电话号码。有了互操作性，用户就可以使用WhatsApp接收发送到Facebook账户的信息，而无需分享电话号码--买家也不用担心卖家是喜欢在哪个网络发信息。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	可以想象许多类似这样的简单体验--一个人在Instagram上发现了一家公司，并很容易过渡到他们喜欢的消息应用，以获得安全的支付和客户支持；另一个人想追上一个朋友，可以向他们发送一条消息，发送到他们喜欢的应用，而不必考虑这个人喜欢在哪里被联系；或者用户只需在Facebook和Instagram上发布一天的故事，就可以在一个地方得到好友的所有回复。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	今天，用户已可以通过Android上的Messenger发送和接收短信，我们希望在未来进一步扩展这一功能，或许包括新的电信RCS标准。然而，在这成为可能之前，我们需要解决几个问题。首先，苹果不允许应用在他们的设备上与短信交互操作，所以我们只能在Android上这样做。其次，我们需要确保互操作性不会损害人们已使用WhatsApp的加密预期。最后，它会在加密系统中造成安全漏洞和垃圾邮件漏洞，让人们从未知的应用中发送信息，因为我们的安全和安保系统看不到这些活动的模式。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	这些都是重大挑战，有许多问题需要进一步协商和讨论。但是，如果我们能够实现这一点，我们就可以给人们更多的选择，让他们使用喜欢的服务，以安全地联系到他们想要联系的人。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	安全数据存储\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	人们想知道他们的数据安全地存储在他们信任的地方。展望互联网和隐私的未来，我认为我们将做出的最重要的决定之一是：在哪里建立数据中心和存储人们的敏感数据。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在一个国家提供服务和在那里存储人们的数据有着重要的区别。当我们在世界各地建设基础设施时，我们选择不在有侵犯隐私或言论自由等人权记录的国家建设数据中心。如果我们在这些国家建立数据中心并存储敏感数据，而不仅仅是缓存非敏感数据，这可能会让这些政府更容易获取人们的信息。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	坚持这一原则可能意味着我们的服务在一些国家会受阻，或者我们不能很快进入其他国家。这是我们愿意做出的折衷。我们不认为在一些国家存储人们的数据是一个足够安全的基础，可以在其上建立如此重要的互联网基础设施。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	当然，保护最敏感数据的最佳方法是根本不存储它，这就是WhatsApp不存储任何加密密钥的原因，我们计划在以后的其他服务中也这样做。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	但是在更多国家存储数据也开创了一个先例，鼓励其他国家政府寻求更大程度地获取其公民的数据，从而削弱了全世界人民的隐私和安全保护。我认为，对于互联网和隐私的未来而言，我们的行业继续坚决反对把人们的数据存储在得不到安全保障的地方，这一点很重要。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	下一步举措\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在接下来的一年及以后，我们还要制定出与这些原则相关的许多细节和权衡。这项工作中的许多仍处于早期阶段，我们致力于与世界各国的专家、倡导者、行业合作伙伴和政府(包括执法部门和监管机构)协商，以正确做出这些决定。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	与此同时，通过这些原则开展工作只是构建以隐私为中心的社交平台的第一步。除此以外，我们还需要对在此基础上构建的所有服务进行深入思考--从人们如何支付和金融交易，到企业和广告的作用，再到我们如何为其他私人服务提供平台。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	但是，这些最初的问题得到正确答案是至关重要的。如果我们做得好，我们可以创建私人共享平台，这对于人们而言可能比我们建立的帮助他们更公开分享和联系的平台更重要。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	这意味着对关系到互联网未来的重要问题采取什么立场。作为一个社会，我们有机会阐明我们的立场，决定我们如何重视私人通信，以及谁来决定数据应该存储多长时间以及存储在哪里。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	我认为我们应该努力实现这样一个世界，让人们可以私下交谈，自由生活，知道他们的信息只会被他们想看到的人看到，而且不会永远停留在身边。如果我们能帮助世界朝着这个方向发展，我将为我们所取得的成就感到自豪。\r\n	</p>',	'doc.png',	1.00,	41,	0,	0,	0,	'2019-12-03 14:19:38',	'admin',	2,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	1.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	14,	1,	0,	1),
(150,	'流量造假危在旦夕，粉丝经济“永垂不朽”',	'<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	今年两会期间，明星委员们的提案再次将炮火对准了劣迹艺人、明星及影视数据造假、身价片酬等行业乱象，不过前方固然慷慨激愤，后方还是其乐融融，#明星该不该吃粉丝送的食物#、#明星被认错#等话题频繁被推上热搜，娱乐氛围依旧。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	但今年还是有些许不同，2018年影视连续震荡所牵引出的政策新规，将在今年集中落地并被检验效果，前段时间，吴秀波、翟天临事件又掀起公众对娱乐圈造假的口诛笔伐。换句话说，娱乐产业规则改写的时机，可能已经同时具备了政策自上而下和舆论自下而上的两个必要条件。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	若是如此，数据造假将成第一个靶子，而往后推，数据造假的一环如果被铲除，是否能动摇当前畸形的粉丝经济呢？这是值得业界探讨的。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	造假产业链的逆向思考\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	2019年开年，《人民日报》发表文章，矛头直指流量明星锁场、刷榜、买粉丝，而后其又连续发表微博，感慨“明星流量数据节节攀升，8亿网民不够用”。随之跟进的还有《光明日报》《北京日报》，而“紫光阁”则从1月5日-9日，连发4条微博，痛批流量明星，呼吁“没有高质量作品做支撑，那些拙劣的表演终将被揭穿”。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	影视产业春寒料峭，一场“打假运动”的兴起，或许正是今年的新风向。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	微博已率先做出反应，宣布针对转发、评论计数显示方式在内做出种种调整，而更早之前，爱奇艺和优酷停止了播放量的展示。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	这对于影视数据脱水进而回归合理无疑是一个有利信号，视频及社交平台本身就是流量造星、粉丝运营的核心媒介，隐藏播放量起码减掉了数据造假的一个需求。虽然不得不承认，这一举措对整个行业来讲，也只是让数据造假不至于假得太“难看”，但其释放的市场信号是积极的：影视数据造假的乱象，今年或许不会止于揭露。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	以此为基础，我们再来看影视产业数据造假的产业链。一般来讲，卖方一端通过雇佣技术型或人工型水军，提供刷流量业务，至于买方一端，央视将明星数据造假的推手，归为自发组建的粉丝组织和经纪公司安排成立的明星微博数据站。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	两方需求契合，流量明星通过这一番操作获取一定的人气和地位，从而掠取演艺资源。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	而提供演艺资源的制片方、投资方以及媒体平台，又因流量明星的参与而收割商业利益，当然，这其中更少不了购买数据用以打榜、投票、转发的过程。无奈的是，这已成为市场优胜劣汰的“规则”，如果粉丝的偶像数据不好，就会被其他艺人的粉丝“唱衰”。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	由此可以看出，流量经济是一个参与方都可获得经济效益的模式，这也决定了很难从内部去戳破流量泡沫。但如今政策导向下，很有可能从外部强制性切断数据造假产业链，若是如此，会对以流量为基础的粉丝经济造成什么伤害？\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	我们可以逆向推断，假使数据归真，流量明星及其所产出的内容，在市场的反应能够一目了然，首先最可能放弃他们的就是内容生产方。因为对比靠实力说话的演员，流量明星原本与之天差地别的流量优势，很大程度上被削弱了，而今口碑反噬又日渐严重，制片人也不再经得起多次的扑街。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	相应地，流量明星的演艺资源一旦被缩减，曝光度大大降低，广告商、媒体以及平台很快便“闻风而动”。更关键的是，明星本人新粉难增、旧粉流失，长此以往就更没有商业价值了。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	流量经济还是粉丝经济？\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	当娱乐产业的优胜劣汰逐渐被流量所左右，如果从流量数据本身出发，一定程度上是可以约束某些行业乱象的滋生。但是流量缩减、粉丝仍在。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	蔡徐坤被央视点名时，震慑是对业内的，粉丝看似不惧。真爱粉们一面为爱豆打抱不平，力挺蔡徐坤确实是个专注音乐的好歌手，甚至表示之前做了那么多公益怎么不提？另一面又将攻击点集中到微博上，强烈要求整改。不过，前者是顾左右而言他，后面则是祸水东引，实则都没什么逻辑。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	从这件事直观地看，粉丝本身就是流量的一部分，即使最大程度地将流量数据脱水，蔡徐坤、鹿晗这类当前比较符合年轻群体审美的明星，也仍有不在少数的粉丝存留，他们才是饭圈的核心。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	换句话说，粉丝即使不花钱为他们的偶像刷流量，他们还是有其它方式向外界传达和证明自家爱豆的价值，甚至可以简单的说，只要粉丝愿意为爱豆花钱，在制片人和品牌方眼里，明星便有商业价值。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	这主要是因为当前的影视行业中，<strong>粉丝看似处于被收割的产业下游，实则主导着偶像的人气和商业吸引力。</strong>\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	<strong>一方面，粉丝已经参与到偶像的职业规划中，用自己的力量为偶像争取好资源。</strong>而市场也认可了这种做法，现在广告商、制片方最看重的，不再是明星的业务水平，而是背后的粉丝力量。所以，纵然市场能抛开流量数据，演员和明星粉丝群体的差别，也无法使商业资源偏向前者。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	<strong>另一方面，如今流量明星的粉丝展现出强大而可怖的集体力量，如果不再允许数据造假，他们对舆论的影响也能帮助明星维持流量再造。</strong>极端一点，像粉丝骂战、撕逼这种普遍现象，一经推手，在当前这个碎片化时代便是天然的流量爆发点。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	所以，<strong>数据打假所能纠正的也只是流量经济，而触及不到更深层次的粉丝经济。</strong>\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	时至今日，粉丝和流量的先后产生顺序已经模糊，这就是数据造假导致的，不过粉丝是基础，流量经济可以说是在资本介入、疯狂膜拜粉丝效应之后被放大的形态。这和移动互联网时代流量为王的思维，实则异曲同工。不过移动互联网进入下半场的服务升级，娱乐产业的流量经济反而日渐衰颓了。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	明星“死于”粉丝？\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	<strong>围绕粉丝和明星的行业规则及利益链一旦形成，实际上就连一个环节的整治都很难，更不要指望其内部会自我改进。</strong>但值得庆幸的是，当前流量经济之所以逐渐露出真相，在于其外部的反对力量日益强大，也催促市场形成一套新的淘汰法则。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	最明显的是电影界，流量明星的多番试水，让投资方再也经不起折腾。2016年“小鲜肉+大IP”的模式备受追捧，2017年参与暑期档大战的流量明星只有杨洋、李易峰两人，而到2018年暑期档、春节档，杨洋、鹿晗等人早已不见踪影。李易峰的《动物世界》即使备受肯定，票房仍不能回本。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	数据显示，2018年全国电影票房已经超过2017年总票房559.11亿元，创下新纪录，但票房前十的影片主演中均不见小鲜肉身影。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	流量明星开始被排斥在大荧幕之外，而且他们在业内留下的印象一旦被定性，投资人只会对他们避之不及。而下一个排斥流量的便是观众，这很容易让流量明星丧失转型的时机，甚至是永久被划在攻击的范围之内。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	这是口碑反噬的副作用，比如《创业时代》开播之初，很多人还没看剧，只知道有杨颖主演便给出了一星评价，迪丽热巴则一个人把《声临其境》的评分拉到了4.3。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	一个经典角色可以成就一个明星，但一个明星也有可能毁了众多角色，观众便将不满全部发泄到流量明星身上，反而不会再客观考虑是不是剧本、导演不行。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	不过作品口碑败光的更多是路人缘，而且市场通过这种副作用反噬的方式淘汰流量明星，毕竟是一个相对缓慢的过程。关键是，他们背后的死忠粉依然是“东山再起”的资本。<strong>所以一个流量明星的消失或死亡，完全取决于粉丝。</strong>\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	事实也是如此，我们看到，<strong>人设崩塌是最近常见的最快导致明星坠落的方式，而人设本质就是为迎合粉丝存在。</strong>粉丝心理假说认为，追星一种身份认同，粉丝通过对名人的“镜像”认识自己，塑造价值观，而一旦粉丝发现这种“镜像”是虚假的，认同感瞬间就消失了，而且会有上当受骗的感觉。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	当然，粉丝也是善变的，他们自然而然流失，流量明星们也就被市场抛弃了。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	<strong>流量数据的虚假泡沫被戳破总归是好的，但娱乐行业的乱象却无法根治，终究是粉丝把明星捧得太高了。</strong>\r\n</p>',	'doc.png',	1.00,	8,	0,	0,	0,	'2019-12-03 14:20:16',	'admin',	3,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	1.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	3,	1,	0,	1),
(151,	'咪蒙关停，靠“伪女权”挣钱还能撑多久',	'<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	你可能不知道咪蒙，但却一定知道她有一个月薪5万的助理。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	年初，在“寒门状元”事件之后，咪蒙就曾宣布关停微信公众号两个月，并永久关停微博。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	不想仅仅过了不到一个月，2月21日咪蒙以及旗下“才华有限青年”等微信账号就宣布将被永久关停。旗下美妆账号改名为“李粒粒LiLiLi”，咪蒙小号“好疼的咪蒙”则清空了所有内容。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	从咪蒙公布之前公布的报价来看，其微信公众号头条广告报价一度到达80万元，二条也有40万元。这次的账号注销还包括今日头条、凤凰号等等，并称咪蒙“不得转世”。咪蒙的商业帝国几乎被连根拔起。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	除了自媒体，同时可能就此终结的还有咪蒙刚刚开始的编剧生涯。2018年3月，柠萌影业曾经宣布，由咪蒙担任编剧的网剧《长大成人》正在筹备中。现在咪蒙被封，这部“神似”《欢乐颂》的作品最终何去何从也被画上了问号。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\"> <strong>“毒鸡汤女权”，这不只是咪蒙的专利</strong> \r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	正如我们上文所说，咪蒙还在积极谋求走向影视圈，成为编剧便是第一部。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	了解咪蒙的人都知道，咪蒙的文章一向以宣扬所谓“女权”为导向，用一碗一碗的鸡汤，挑动着公号中近600万女性粉丝的内心。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	作为一个影视的门外汉，咪蒙之所以开始进军影视当编剧，其实和中国影视，特别是网台剧当中 “大女主”等题材层出不穷有着直接关系。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	从《欢乐颂》里的五个姐妹，到《我的前半生》里的罗子君，从楚乔到关皮皮，不一而足。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	然而，在这些所谓的“大女主”或者“女权”剧却很少体现真正的女权，而或多或少的会体现出“咪蒙式女权”的感觉。 男一都会对我不离不弃，男二都会生死相依，男三都会“我的眼里只有你的桥段大行其道，靠男人上位的情节也充斥其中，女权成为了寄居在男权上的笑话。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	再有，许多职业剧也会加入大量爱情桥段，“谈判官”改谈恋爱，“猎头”改“猎对象”的情况也多次发生。这也正如咪蒙的风格，看似让人“自强不息”，实则只想让你成为“坐在宝马里笑的人”；看似是在不断激励，实际只是找准了观众的七寸，然后一颗颗的吃下早预备好的“致幻药丸”。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	但这样的剧情虽然满足了女性观众对于爱情内容的需要的同时，本身也局限了内容的发展。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	首先，这样的剧所有内容几乎都必须围绕爱情展开，亲情、职场、宫斗、武侠等本应该更重要的戏份反而成了陪衬。由此，很多所谓的职场剧、宫斗剧到头来都变成了无限尴尬的爱情剧。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	更重要的是，“咪蒙式的女权剧”并不是真正的男女平权，当女性意识进一步觉醒之后，就会开始逐渐摒弃这种价值观。正如《致橡树》中所说，“我如果爱你，绝不学攀援的凌霄花”。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	再次，随着90后以及更年轻观众的崛起，单身才是社会更加主流的形态。生活方式的改变也会影响大家对于影视剧的观看喜好。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	更进一步说，“大女主”实际上是披着女性思维的外衣，但实际上却站在男性立场的表现。女性是白莲花、傻白甜，需要靠男性，甚至众多男性实现目的，这其实是一种变向的“被包养”。托名女权，实际宣扬的却是一种并不合理的价值观。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	咪蒙已经悄然落幕，但“伪女权”却依然大量存在于影视剧之中。但随着品质口碑成为了市场主流，真正的女权影视剧登上舞台恐怕也不会太远了。\r\n</p>',	'doc.png',	1.00,	19,	0,	0,	0,	'2019-12-03 14:21:05',	'admin',	11,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	1.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	4,	1,	0,	1),
(152,	'捷克医院枪击致7死3伤 抢手在警方逼近时开枪自杀',	'<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	短视频行业的发展无疑已经进入到了深水区，以短视频变现为代表的全新发展正在把这个行业越来越多地放到了市场的前台。作为一种全新的内容表现形式，短视频在经历了资本乱战、巨头追捧之后，或许应该进入这个“年纪”。然而，变现并非易事，短视频变现更是难上加难。如果能够走出短视频变现的考验的泥淖，这个行业的发展无疑将会发展成熟。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	当然，如果仅仅只是一味地追求变现，而不去深究短视频本身的内在运行逻辑。所谓的短视频变现同样会陷入困境，火爆的短视频行业将会如同火爆的流量一样陷入表面的繁华。的确，几乎所有的商业模式都应该形成一个生态闭环，才能称得上是一个成熟的商业模式。如果仅仅只是停留在某个阶段的繁荣，所谓的商业模式仅仅只是一个概念，无法真正落地。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	我们看到当前以抖音、快手为代表的短视频行业巨头都在进行变现层面的探索，无论是社交，还是电商，对于短视频背后更加深层次的商业层面的探索正在成为一种发展的主流。不可否认的是，尽管短视频变现进行得如火如荼，但是依然逃不脱现实的尴尬，短视频行业的变现依然面临诸多挑战。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	从繁荣期到精耕期，短视频行业正在经历阵痛\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	作为一种在移动互联网时代的后半段崛起的内容表现形式，短视频行业的发展无疑备受追捧。无论是资本还是巨头，对于这种新式的内容展现形式都充满了好奇与期待。融资数额的不断增加、融资速度的不断加快都在说明市场对于短视频行业偏好程度。尽管短视频行业从一开始就被互联网巨头所青睐，但是，它的发展依然要经历所有的事物都会经历的阶段。从资本吹捧的繁荣期到商业变现的精耕期，短视频行业的发展无疑正在经历一次全新的阵痛。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	火爆的背后是短视频行业远离商业本质的尴尬。几乎所有的人都知道，短视频行业的发展一直都是一路高歌，无论是从用户获取上，还是用户日常的表现数据上，短视频行业的发展都是相当夺目耀眼。尽管短视频行业看上去异常火爆，但是火爆的背后却是变现困难的尴尬。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	从始至终短视频行业都在扮演着一种流量导流的角色，通过短视频将流量聚集在一起，再通过流量下沉到电商、社群等其他领域，从而实现真正意义上的变现。其实，从流量获取到流量导入已经有了许多的用户流失，再把这些流量落地到具体产品上又会有更多的流量流失。因此，仅仅只是将短视频看成是一个流量导入的工具，而不去从短视频本身着手，直接进行变现正在让短视频行业的发展陷入一种尴尬的境地里。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	当我们看到短视频平台动辄几亿的用户流量的时候，其实无法真正掩盖现实的尴尬。一味地看中短视频本身的流量价值，而忽略了更多新的探索，短视频行业正在陷入一场远离商业本质的尴尬。在流量红利已经见顶的大背景下，一味地去强调短视频行业的流量作用，无疑是一次与现实的抵抗。在流量已经被证明是一种无效资源的大背景下，短视频行业盲目地加大自身在流量上的作用，无疑是一场冒险。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	依附于巨头的怀抱让短视频缺少对于商业世界的认知。作为一种全新的内容展现形式，短视频行业从一开始就依附于互联网巨头。无论是资本投资，还是平台建设上，短视频始终都缺少自己独特的运行模式。虽然以互联网巨头作为靠山能够缓解在竞争激烈的市场当中沦陷的概率，但是如果仅仅只是一味地停留在巨头怀抱的温暖里，不去面对商业世界的残酷，短视频行业依然备受挑战。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	依附于巨头的怀抱，短视频行业仅仅只是一个内容层面的东西，它仅仅只是巨头的附庸，无法真正承担起自我寻找商业价值的重任。当巨头不再加持短视频行业的时候，它同样需要走入市场里，而不是一味地承担一个支撑者的角色。依附于互联网巨头的怀抱，短视频行业仅仅只是停留在表面繁荣的自嗨当中，不断增长的用后数据、不断增长的点赞数量、不断增加的用户浏览时长都让短视频行业感觉到自己是移动互联网后半段的王者。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	作为一种全新的内容展示形式，短视频始终都是一种内容。如果我们仅仅只是停留在巨头光环下的数据自嗨，而不去真正了解这些数据背后的真正原因。那么，当短视频行业真正进入到市场的时候，一切或许都将重新开始。当前，短视频行业正在经历的正是这样一个阶段。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	以内容为根本的短视频却无法具备内容的本质与意义。虽然短视频行业异常火爆，但是我们始终都不能忘记短视频始终都是一种内容表现形式。既然是一种内容，短视频行业从野蛮生长到精耕细作是一个必然的过程。在经历了几年的发展之后，我们却没有看到短视频行业的内容有显著提升的地方，有的仅仅只是在一些营销层面的小打小闹。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	当短视频在内容进化上出现瓶颈的时候，我们就去做商业变现上的相关尝试无疑将会把这个行业的问题和弊端全部都呈现在外面。作为一种内容展现形式，短视频行业在内容本身上缺少精耕细作和突破创新，只会把短视频行业的发展带入到一种相对艰难的境地里。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	我们看到现在的短视频的内容上依然缺少精细化的痕迹，有的仅仅只是千篇一律的雷同抑或是内容展现形式的俗套。如果仅仅只是把短视频行业仅仅停留在一种毫无进化的层面上，特别了缺少了作为内容本身所应该具备的特质，那么所谓的短视频必然将会失去原有的本质与意义。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	在经历了早期的野蛮生长、资本助推、巨头拥抱等一系列的发展之后，短视频行业的发展正在经历一场前所未有的平静期。这从另外一个角度说明短视频行业的发展并未真正跳出原有的发展套路，仅仅只是将互联网式的发展模式在极致上更进一步。突破短视频行业的发展困境，需要真正让短视频告别自嗨式的繁荣，真正回归内容本身，真正进入到商业世界的现实中历练。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	进入下半场的深水区，短视频的彷徨与退让\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	在告别了资本的加持之后，短视频行业的发展正在进入到下半场的深水区。早期的顺风顺水让短视频行业的发展难以抵挡现实的尴尬，一味地停留在数字上的繁荣，而忽略了内容本身的本质奥义，短视频行业的下半场无疑将会经历一场前所未有的彷徨与退让。但是，这并非是一件坏事，通过这种方式，我们增加能够知道短视频本质的东西是什么。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	短视频的彷徨：巨头扶持还是独立行走。短视频从诞生的那一天开始就始终没有摆脱巨头的光环，从某种意义上来讲是互联网巨头最终造就了短视频行业的今天。然而，一味地躲在互联网巨头建构的舒适区里，不去进行商业层面上的探索，所谓的短视频只会在自嗨的道路上越走越远。告别巨头的保护，真正进入到市场当中摸爬滚打，从而获得更多的生存技能或许对于短视频来讲至关重要。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	然而，如果摆脱互联网巨头的怀抱，短视频又很难在短时间内找到一条合适的路，对于处于变现关键期的短视频行业来讲，无疑是一个非常巨大的挑战。始终蜷曲在巨头的怀抱，毕竟不是一件长远的事情，短视频行业的真正未来依然在于本身的发展上。从这个逻辑来看，脱离巨头的怀抱，选择独立行走显然是一件非常明智的事情。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	可喜的是，深度参与到短视频行业发展中的人们早已明白了这其中的意义，我们看到以抖音、快手为代表的短视频平台开始更多地寻找基于自身优势和特色的发展道路，抖音做社交，快手做电商就是这一趋势的直接体现。尽管当下的发展态势不甚明朗，但是只要能够找到一条真正适合自己的发展道路，短视频行业的发展便会真正能够独立。&nbsp;\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	短视频的退让：坚守流量还是回归商业。从当下的发展情况来看，短视频真正吸引人的地方还是它裹挟流量的能力。投资机构和互联网巨头之所以不断加持短视频行业的重要一点同样是因为短视频本身能够在获取流量的成本日渐高企的时刻依然能够持续获得源源不断的流量。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	然而，虽然流量给短视频赢得了鲜花和掌声，但是流量的变现依然是横在短视频头上的达摩克利斯之剑。谈及流量变现就必然要回归到商业本身，如果仅仅只是在流量的海洋里进行无谓的自嗨，所谓的短视频只能是一个充满了美妙幻想的乌托邦，无法真正实现真正意义上的落地。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	是坚守流量还是回归商业，或许在残酷的商业面前，短视频行业将会最终退让，真正演变成为以商业为主导的存在。尽管这个过程会略显艰难，但是这才算是真正回归到了商业本身，而非仅仅只是沉醉在流量的理想国里。\r\n</p>\r\n<p style=\"color:#505050;font-family:&quot;font-size:15px;background-color:#FFFFFF;\">\r\n	当短视频市场的繁华落尽，回归商业本质或许是当下正道。告别表面的虚假逻辑，真正把短视频行业的发展落地到具体的商业上，探索一条真正适合商业本质的发展道路，或许才是真正能够推动短视频行业发展正道所在。从这个逻辑上来看，当下短视频行业正在经历的这场彷徨与退让或许更像是在积蓄继续前行的能量。\r\n</p>',	'doc.png',	1.00,	9,	0,	0,	0,	'2019-12-03 14:21:49',	'admin',	14,	0,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	1.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	3,	1,	0,	1),
(153,	'美国一公司送员工1000万美元奖金 平均一人拿5万',	'<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	发展会掩盖一切问题，直到狂奔的脚步停下。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	2月15日，滴滴CEO程维对外表示，公司将做好过冬准备，并将对非主业进行“关停并转”，对业务重组带来的岗位重叠和绩效不达标的员工进行减员，整体裁员比例占到全员的15%，将涉及2000人左右。此外，从2012年创业以来一直处于亏损状态的滴滴，2018年仍然亏损，全年亏损总额高达109亿元，其中，补贴司机超过113亿元。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在收购优步中国以后，滴滴在网约车市场一家独大，市场占有率近九成；滴滴是全球融资额最大的未上市公司，一向“不差钱”；滴滴对每笔业务都会收取20%左右的抽成(Take Rate)，这也经常成为网约车司机抱怨甚至炮轰的对象……感觉“躺着就能把钱赚了”的滴滴，为何会如此巨亏？司机喊着不赚钱、平台又巨亏，网约车的问题究竟出在哪里？还有能走得通的商业模式吗？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	成立7年，融资20次，\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	融资额200亿美元\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	和其他公司多是被爆出后被迫承认窘境，或者裁员时只肯使用“优化、调整、末位淘汰”等字眼不同，滴滴主动“官宣”了巨亏和裁员的消息，数字还如此巨大。“地主家也没有余粮了？”“富家子都开始哭穷了？”社交媒体上一时哗然，有人唏嘘，有人不解。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在去年8月滴滴顺风车事件之后，程维也曾对外透露过一次滴滴的财务数据，他表示滴滴成立6年来，还没有实现过盈利，仅仅2018年上半年，公司的整体净亏损就超过40亿元人民币。滴滴出行业务对应的GMV(总交易额)平均Take Rate(抽成率)约为16%，但绝大部分作为补贴和红包返还给了司机和乘客，公司整体对应的GMV毛利率只有1.6%。他还透露，仅2018年上半年，包括司机高峰期补贴、接单和服务奖励、乘客优惠等在内的总补贴返还金额超过117亿元人民币。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	2017年，滴滴也曾透露过补贴总额，高达181亿元(包括司机端和乘客端)。但一些被媒体广泛引用、滴滴官方从未确认也从未辟谣的数据显示，2017年滴滴全年亏损额只有25亿元。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	一位滴滴内部人士告诉《中国经济周刊》记者：“公司虽然巨亏，但现在现金流应该是没问题的。即使一部分员工会面临被裁员，但公司给的补偿方案还是比较厚道的。说滴滴会成为下一个ofo那是不太可能的。”\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	据天眼查的统计数据显示，滴滴自2012年成立以来，截至目前已经完成了20次融资，金额总量超过200亿美元，是全球融资额最大的未上市公司。滴滴的估值也一度高达800亿美金，也是最快达到这个量级的独角兽公司。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	但这只独角兽也甚是烧钱。由于滴滴还不是上市公司，财务数据并不需要全部公开，但根据滴滴已公开的数据统计，滴滴6年来累计亏损额高达近390亿元。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	但上述人士也表示：“在2018年以前，利润和成本在滴滴确实不是重要的考核指标，市场占有率、日单量、用户数量、司机数量……这些才是关注的重点。但2018年开始，公司希望能够在年底冲刺整体盈利，至少实现‘微盈利’，所以对各个业务线也都提出了这样的要求。”\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	其实，这种变化也并不奇怪，因为彼时市场传闻，滴滴将会在2019年下半年实现IPO。但之后由于众所周知的原因，滴滴没能赶上这波上市热潮。“顺风车事件”背后的安全问题让滴滴停下了6年来一路狂奔的脚步。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	一年补贴113亿元，\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	司机感受到了吗？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	补贴仿佛是成就滴滴、也榨干滴滴的一道旋转门，补贴的打法让滴滴熬死了几乎所有竞争对手，并从尸骨堆中走出来，成为今天的滴滴；但现在，补贴似乎也正在熬干滴滴自己。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	与109亿元这个2018年滴滴全年亏损总额一同出现的还有一个数据：2018年滴滴补贴司机超过113亿元，这很容易让人认为两个数字之间有因果关系。但巨额亏损就是源于对司机的补贴吗？\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	北京大学市场与网络经济研究中心研究员陈永伟对《中国经济周刊》分析认为，滴滴的亏损应该主要来自为了赢得用户信任和适应更强监管而付出的合规成本。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	陈永伟认为，滴滴的持续亏损主要有两方面的原因。“一是由滴滴本身的战略决定的，它的战略是先占有市场，然后利用规模效应去消化市场。滴滴的主业务是规模报酬递增的，这也决定了滴滴先占市场的模式。二是去年突发事件引发了监管加强，这让滴滴遭受了空前的监管压力，合规成本是巨大的，比如要求司机户口、车辆的轴距大小等。”他说。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	记者采访了几位滴滴司机，他们均表示，并没有觉得去年滴滴对司机的补贴突然增加了。一位滴滴“老司机”告诉记者，不同的司机能够拿到的补贴数量可能差别非常大。因为要想获得比较高的补贴收入并不容易，比如要在线时间长，至少10小时，这意味一定要是全职司机，身体要好还不能怕辛苦；再比如要在高峰时段多接单，也要多接受滴滴的派单，“这些活儿很多是根本不赚钱的，不给补贴，根本不会有人接。”他说。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在乘客端，很多人的感受则是：滴滴的车费越来越贵，但叫车却越来越难。记者对比了市场上最大的几家网约车公司的价格，以北京为例，相同时段和目的地，同档次车型，滴滴快车价格最低，其次是出租车价格，但两者差距已经不大了，相对最高的是易到易达车型的价格。而对于高端车型，滴滴礼橙专车也是最低的，其次是神州专车，首汽约车的价格则更高一些。这些高端车型的价格要高出普通车型50%左右。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	在客户竞争层面，网约车平台的竞争无外乎两件事：价格和能否叫到车。而网约车平台要克服的最大难题就是高峰低谷时段的需求差异和城市潮汐效应的供给矛盾。因此，从逻辑上，网约车平台确实需要依赖补贴来调节运力，鼓励高峰时段有更多兼职司机补充运力，鼓励司机反潮汐增加热门地区的运力供给。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	根据中国信息通信研究院政策与经济研究所的调查显示，截至2018年7月，全国合规网约车数量约为17万辆，只占到总量的0.54%，而合规司机数量约为34万，只能占到司机总量的1.1%。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	据滴滴方面介绍，随着各地网约车新政的落地和执行越来越严格，运力不足问题日趋严重。而顺风车下线之后，兼职的网约车司机也大量减少。因此，滴滴为了吸引更多“合规”司机加入，以及运营中调整运力，不断出手补贴。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	滴滴收购ofo的可能性更小了\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	除了裁员，滴滴宣布要“关停并转”非主业的消息也引发了广泛的关注。到底哪些业务是滴滴的“非主业”，截至记者发稿，滴滴官方并未给出回应。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	一位滴滴前高管对《中国经济周刊》分析，对于滴滴“非主业”，很多人会首先想到外卖、酒旅、票务等“创新业务”，这确实可能是此次调整的重点，但应该还至于此，因为这些业务不足以涉及到2000人。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	据记者了解，2018年底，滴滴进行过一次架构调整。调整后，滴滴的主要业务被划为几大板块：网约车平台公司(快车、专车、豪华车事业部)、车主服务公司(小桔车服公司、汽车资产管理中心)、普惠出行与服务事业群(单车、电单车、公交、代驾、企业级业务)、出租车事业部、战略业务事业部(战略部、国际事业部、金融事业部)等。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	上述高管认为，普惠出行与服务事业群的业务也有可能被重点调整，“滴滴再去收购ofo的可能性更小了”。而国际业务和金融业务则会影响不大。“网约车这个生意受政策环境影响太大了，国际化等于给滴滴多设立几个backup，这边不亮可以那边亮，滴滴已经有完整完善的网约车技术和运营解决方案，在各国复制并不难。”他说。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	实际上，滴滴已经通过收购、投资本地出行平台的方式将业务拓展到东南亚、东欧、非洲、巴西、日本、美国、墨西哥、澳大利亚……程维也透露，安全技术、产品和线下司机管理及国际化等是滴滴未来的重点领域。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	陈永伟的看法是，滴滴确实涉足了不少并没有规模效应的行业，如果没有顺风车危机，可能也不会对滴滴带来太大的影响。但在严监管之下，安全合规成本大增，滴滴的顺风车业务还干脆就没了，这也带来商业损失。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	网约车也有赢利的商业模式\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	滴滴这头其实已经达到巨头规模的超级独角兽，至今仍未找到清晰的盈利模式。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	滴滴的设想是希望通过平台聚集大量用户，然后靠打造“出行生态”提供增值服务获得盈利。就像淘宝和微信，用户都可以免费使用，但同样可以赚得盆满钵满。于是，滴滴进行了很多尝试：做广告、做电商、做游戏、卖保险、卖理财、做金融……但这条路，至少现在，滴滴还并没有走通。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	但这并没有影响新选手们的热情。除了神州优车、易到、首汽约车等老运动员，2018年以来，美团、高德、携程、同程、嘀嗒、哈罗等都开始前赴后继地加入网约车混战，希望从滴滴的版图上咬下一块。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	此外，上汽、吉利、大众等在内的主机厂都已经进军网约车市场，宝马也成为首家在中国拿到网约车牌照的跨国品牌，赛道那端虽然通向哪里还不知道，但赛道仍然拥挤。\r\n</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	虽然滴滴的日子不好过，易到更是彻底凉了，但行业内也有日子过得不错的玩家。比如神州优车，虽然此前也一直亏损，但到2017年，神州优车的亏损已大幅收窄了92.7%，仅亏损2.6亿元。而其2018年经营，截止到当年前三季度，神州优车营收达49.2亿元，利润总额2.8亿元，较上年同期增长149%，已经实现了4个季度的持续盈利。\r\n	</p>\r\n<p style=\"color:#505050;font-family:\" font-size:15px;background-color:#ffffff;\"=\"\">\r\n	“这其实也说明了网约车本身没问题，是有商业模式可以走得通的。不过行业发展还是需要政策支持。”陈永伟表示\r\n</p>',	'doc.png',	1.00,	7,	0,	0,	0,	'2019-12-03 14:22:37',	'admin',	27,	1,	0,	1,	'',	1,	'',	0,	0,	'',	'',	'',	1.00,	0,	0,	'文章很值，打赏犒劳作者一下！',	0,	4,	1,	0,	1);

DROP TABLE IF EXISTS `sl_note`;
CREATE TABLE `sl_note` (
  `N_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `N_mid` int(10) DEFAULT '0',
  `N_course` int(10) DEFAULT '0',
  `N_page` int(10) DEFAULT '0',
  `N_time` datetime DEFAULT NULL,
  `N_content` text,
  PRIMARY KEY (`N_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `sl_nsort`;
CREATE TABLE `sl_nsort` (
  `S_id` int(11) NOT NULL AUTO_INCREMENT,
  `S_title` text NOT NULL,
  `S_content` text NOT NULL,
  `S_pic` text NOT NULL,
  `S_del` int(11) NOT NULL DEFAULT '0',
  `S_sub` int(11) NOT NULL DEFAULT '0',
  `S_order` int(11) NOT NULL DEFAULT '0',
  `S_show` int(11) DEFAULT '1',
  `S_keywords` varchar(200) DEFAULT NULL,
  `S_icon` text,
  PRIMARY KEY (`S_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `sl_nsort` (`S_id`, `S_title`, `S_content`, `S_pic`, `S_del`, `S_sub`, `S_order`, `S_show`, `S_keywords`, `S_icon`) VALUES
(1,	'电影',	'电商',	'20191203110156Nd.jpg',	0,	3,	2,	1,	'',	'20191203110156Nd.jpg'),
(2,	'明星',	'洞察',	'20191203110115is.jpg',	0,	3,	1,	1,	'',	'20191203110115is.jpg'),
(3,	'娱乐',	'文章主分类',	'nopic.png',	0,	0,	2,	1,	'',	'nopic.png'),
(4,	'新闻',	'主分类2',	'20191203105555pq.jpg',	0,	0,	1,	1,	'',	'20191203105555pq.jpg'),
(5,	'国际',	'子分类',	'20191203105628g7.png',	0,	4,	1,	1,	'',	'20191203105628g7.png'),
(6,	'社会',	'公众号运营',	'20191203105727Gp.jpg',	0,	4,	2,	1,	'',	'20191203105727Gp.jpg'),
(7,	'军事',	'网店运营',	'20191203110014lv.jpg',	0,	4,	3,	1,	'',	'20191203110014lv.jpg'),
(8,	'综艺',	'营销',	'20191203110230IO.jpg',	0,	3,	4,	1,	'',	'20191203110230IO.jpg'),
(9,	'电视',	'职场',	'20191203110301wA.jpg',	0,	3,	3,	1,	'',	'20191203110301wA.jpg'),
(10,	'科技',	'',	'nopic.png',	0,	0,	3,	1,	'',	'nopic.png'),
(11,	'财经