core_toQueryPair = function(key, value) {
	if (typeof value == 'undefined') {
		return key;
	}
	return key + '=' + encodeURIComponent(value === null ? '' : String(value));
}

function core_toQueryString(obj) {
	var ret = [];
	for (var key in obj) {
		key = encodeURIComponent(key);
		var values = obj[key];
		if (values && values.constructor == Array) { //数组 
			var queryValues = [];
			for (var i = 0, len = values.length, value; i < len; i++) {
				value = values[i];
				queryValues.push(core_toQueryPair(key, value));
			}
			ret = concat(queryValues);
		} else { //字符串 
			ret.push(core_toQueryPair(key, values));
		}
	}
	return ret.join('&');
}

function core_json(url, args, callback, ispost, ispost2) {
	var url = url;
	if (ispost) {

	} else {
		if (ispost2) {
			ispost = true;
		}
	}
	if (ispost) {

	} else {
		if (args) {
			var params = args;
			if (typeof(params) == 'object') {
				url += "&" + core_toQueryString(params);
			} else if (typeof(params) == 'string') {
				url += "&" + params
			}
		}
	}
	var op = {
		url: url,
		type: ispost ? 'post' : 'get',
		dataType: 'json',
		cache: false,
		beforeSend: function() {

		},
		error: function() {

		}
	}

	if (args && ispost) {
		op.data = args;
	}

	if (callback) {
		op.success = function(data) {
			callback(data);
		}
	}
	$.ajax(op);
}

function tpl(tpldata, datas) {
	return template(tpldata, datas);
}

function tip_show(msg, position, duration) {
	if (!msg) {
		var m = document.getElementById('core_show_div');
		var d = 200000;
		m.style.webkitTransition = '-webkit-transform ' + d + 's ease-in, opacity ' + d + 's ease-in';
		m.style.opacity = '0';
		setTimeout(function() {
			document.body.removeChild(m)
		}, d * 1000000);
		return;
	}
	if (position != 'bottom' && position != 'middle' && position != 'top') {
		position = 'bottom';
	}

	duration = isNaN(duration) ? 1999 : duration;
	var m = document.createElement('div');
	m.id = 'core_show_div';
	m.innerHTML = msg;
	var css = "width:66%; font-size:14px;min-width:150px; background:#000; opacity:0.7; padding: 6px; overflow:hidden; color:#fff; text-align:center; border-radius:5px; position:fixed; left:17%; z-index:999999;box-shadow:3px 3px 4px #d9d9d9;-webkit-box-shadow: 3px 3px 4px #d9d9d9;-moz-box-shadow: 3px 3px 4px #d9d9d9;";
	if (position == 'top') {
		css += "top:10%; ";
	} else if (position == 'bottom') {
		css += "bottom:8%; ";
	} else if (position == 'middle') {
		css += "top:50%;margin-top:-18px;";
	}
	m.style.cssText = css;
	document.body.appendChild(m);
	if (duration != 0) {
		setTimeout(function() {
			var d = 0.2;
			m.style.webkitTransition = '-webkit-transform ' + d + 's ease-in, opacity ' + d + 's ease-in';
			m.style.opacity = '0';
			setTimeout(function() {
				document.body.removeChild(m)
			}, d * 10000000);
		}, duration);
	}

}

function tip_succs(msg) {
    var html = '<div class="menu-hider menu-active"></div>';
	html += '<div class="menu menu-box-modal rounded-m menu-active" style="height: 168px; width: 250px;">';
	html += '<h1 class="text-center mt-3 pt-2">';
	html += '<i class="fa fa-check-circle color-green-dark fa-3x"></i>';
	html += '</h1>';
	html += '<h3 class="text-center pt-2">'+ msg +'</h3>';
	html += '</div>';
	var div = $(html);
	$(document.body).append(div);
	setTimeout(function() {
		$(".menu-active").remove();
	}, 1000);
}

function tip_error(msg) {
    var html = '<div class="menu-hider menu-active"></div>';
	html += '<div class="menu menu-box-modal rounded-m menu-active" style="height: 168px; width: 250px;">';
	html += '<h1 class="text-center mt-3 pt-2">';
	html += '<i class="fa fa-times-circle olor-green-dark fa-3x"></i>';
	html += '</h1>';
	html += '<h3 class="text-center pt-2">'+ msg +'</h3>';
	html += '</div>';
	var div = $(html);
	$(document.body).append(div);
	setTimeout(function() {
		$(".menu-active").remove();
	}, 1000);
}

function tip_confirm(msg, callback) {
	var html = '<div class="menu-hider menu-active"></div>';
    html += '<div class="menu menu-box-modal rounded-m menu-active" style="height: 238px; width: 320px;">';
    html += '<h1 class="text-center mt-4"><i class="fa fa-3x fa-question-circle scale-box color-blue-dark shadow-xl rounded-circle"></i></h1>';
    html += '<h3 class="text-center my-3 font-700">'+ msg +'</h3>';
    html += '<div class="row mb-0 mr-3 ml-3">';
    html += '<div class="col-6">';
    html += '<a href="javascript:;" data-action="cancel" class="btn close-menu btn-full btn-m bg-red-dark font-600 rounded-s">取 消</a>';
    html += '</div>';
    html += '<div class="col-6">';
    html += '<a href="javascript:;" data-action="ok" class="btn close-menu btn-full btn-m bg-green-dark font-600 rounded-s">确 认</a>';
    html += '</div>';
    html += '</div>';
    html += '</div>';
	var div = $(html);
	$(document.body).append(div);
	div.find('.close-menu').unbind('click').click(function() {
		var action = $(this).data('action');
		if (action == 'ok') {
			if (callback) {
				callback();
			}
		}
		div.remove();
	});
}

function tip_alert(msg, callback) {
    var html = '<div class="weui-mask"></div>';
    html += '<div class="weui-dialog">';
    html += '<div class="weui-dialog__bd">';
	html += msg;
	html += '</div>';
    html += '<div class="weui-dialog__ft">';
    html += '<div class="weui-dialog__btn btn-default" data-action="ok">确 认</div>';	
    html += '</div>';
    html += '</div>';

	var div = $(html);
	$(document.body).append(div);
	div.find('.weui-dialog__btn').unbind('click').click(function() {
		var action = $(this).data('action');
		if (action == 'ok') {
			if (callback) {
				callback();
			}
		}
		div.remove();
	});
}

function tip_message(msg,url) {
    var html = '<div class="menu-hider menu-active"></div>';
	html += '<div class="menu menu-box-modal rounded-m menu-active" style="height: 168px; width: 250px;">';
	html += '<h1 class="text-center mt-3 pt-2">';
	html += '<i class="fa fa-check-circle color-green-dark fa-3x"></i>';
	html += '</h1>';
	html += '<h3 class="text-center pt-2">'+ msg +'</h3>';
	html += '</div>';
	var div = $(html);
	$(document.body).append(div);
	setTimeout(function() {
		location.href = url;
	}, 1000);
}

function tip_con(name,message,type,color,msg,url) {
    var html = '<div class="menu-hider menu-active"></div>';
    html += '<div class="menu menu-box-modal '+ color +' rounded-m menu-active" style="height: 250px;width: 300px;">';
    html += '<h1 class="text-center mt-4"><i class="fa fa-3x '+ type +' scale-box color-white shadow-xl rounded-circle"></i></h1>';
    html += '<h1 class="text-center mt-2 text-uppercase color-white font-700">'+ name +'</h1>';
    html += '<p class="boxed-text-l color-white opacity-70 mb-1">'+ message +'</p>';
	html += '<a href="javascript:;" data-action="ok" class="close-menu btn btn-m btn-center-l button-s shadow-l rounded-s text-uppercase font-600 bg-white color-black">'+ msg +'</a>';
    html += '</div>';
	var div = $(html);
	$(document.body).append(div);
	div.find('.close-menu').unbind('click').click(function() {
		var action = $(this).data('action');
		if (action == 'ok') {
			location.href = url
		}
		div.remove();
	});
}

function tip_ispay(msg, url) {
    var html = '<div class="menu-hider menu-active"></div>';
    html += '<div class="menu menu-box-modal rounded-m menu-active" style="height: 238px; width: 320px;">';
    html += '<h1 class="text-center mt-4"><i class="fa fa-3x fa-question-circle scale-box color-blue-dark shadow-xl rounded-circle"></i></h1>';
    html += '<h3 class="text-center my-3 font-700">'+ msg +'</h3>';
    html += '<div class="row mb-0 mr-3 ml-3">';
    html += '<div class="col-6">';
    html += '<a href="javascript:;" data-action="cancel" class="btn close-menu btn-full btn-m color-red-dark border-red-dark font-600 rounded-s">未支付成功</a>';
    html += '</div>';
    html += '<div class="col-6">';
    html += '<a href="javascript:;" data-action="ok" class="btn close-menu btn-full btn-m color-green-dark border-green-dark font-600 rounded-s">已支付成功</a>';
    html += '</div>';
    html += '</div>';
    html += '</div>';
	var div = $(html);
	$(document.body).append(div);
	div.find('.close-menu').unbind('click').click(function() {
		var action = $(this).data('action');
		if (action == 'ok') {
			location.href = url
		}
		div.remove();
	});
}

function tip_confirms(msg, url) {
    var html = '<div class="menu-hider menu-active"></div>';
    html += '<div class="menu menu-box-modal rounded-m menu-active" style="height: 238px; width: 320px;">';
    html += '<h1 class="text-center mt-4"><i class="fa fa-3x fa-question-circle scale-box color-blue-dark shadow-xl rounded-circle"></i></h1>';
    html += '<h3 class="text-center my-3 font-700">'+ msg +'</h3>';
    html += '<div class="row mb-0 mr-3 ml-3">';
    html += '<div class="col-6">';
    html += '<a href="javascript:;" data-action="cancel" class="btn close-menu btn-full btn-m color-red-dark border-red-dark font-600 rounded-s">取 消</a>';
    html += '</div>';
    html += '<div class="col-6">';
    html += '<a href="javascript:;" data-action="ok" class="btn close-menu btn-full btn-m color-green-dark border-green-dark font-600 rounded-s">确 认</a>';
    html += '</div>';
    html += '</div>';
    html += '</div>';
	var div = $(html);
	$(document.body).append(div);
	div.find('.close-menu').unbind('click').click(function() {
		var action = $(this).data('action');
		if (action == 'ok') {
			location.href = url
		}
		div.remove();
	});
}
