<?php
/**
 * ------------------------ 
 *  版权所有  www.tecmz.com
 *  商业版本请购买正版授权使用
 * ------------------------
*/ namespace Module\Member\Admin\Controller; use Illuminate\Routing\Controller; use ModStart\Admin\Auth\AdminPermission; use ModStart\Admin\Concern\HasAdminQuickCRUD; use ModStart\Admin\Layout\AdminConfigBuilder; use ModStart\Admin\Layout\AdminCRUDBuilder; use ModStart\Admin\Layout\AdminDialogPage; use ModStart\Core\Assets\AssetsUtil; use ModStart\Core\Dao\ModelUtil; use ModStart\Core\Exception\BizException; use ModStart\Core\Input\InputPackage; use ModStart\Core\Input\Request; use ModStart\Core\Input\Response; use ModStart\Core\Type\TypeUtil; use ModStart\Core\Util\ArrayUtil; use ModStart\Core\Util\ColorUtil; use ModStart\Core\Util\CRUDUtil; use ModStart\Core\Util\EventUtil; use ModStart\Core\Util\RandomUtil; use ModStart\Core\Util\TimeUtil; use ModStart\Field\AbstractField; use ModStart\Field\AutoRenderedFieldValue; use ModStart\Field\Select; use ModStart\Field\Type\FieldRenderMode; use ModStart\Form\Form; use ModStart\Grid\Displayer\ItemOperate; use ModStart\Grid\GridFilter; use ModStart\Module\ModuleManager; use ModStart\Repository\Filter\RepositoryFilter; use ModStart\Support\Concern\HasFields; use ModStart\Widget\TextDialogRequest; use Module\Member\Config\MemberAdminList; use Module\Member\Config\MemberOauth; use Module\Member\Events\MemberUserRegisteredEvent; use Module\Member\Events\MemberUserVipChangeEvent; use Module\Member\Provider\MemberAdminShowPanel\MemberAdminShowPanelProvider; use Module\Member\Type\Gender; use Module\Member\Type\MemberStatus; use Module\Member\Util\MemberGroupUtil; use Module\Member\Util\MemberMessageUtil; use Module\Member\Util\MemberUtil; use Module\Member\Util\MemberVipUtil; use Module\Vendor\QuickRun\Export\ExportHandle; class MemberController extends Controller { use HasAdminQuickCRUD; protected function crud(AdminCRUDBuilder $P2vse) { $P2vse->init('member_user')->field(function ($P2vse) { $P2vse->id('id', 'ID'); MemberAdminList::callGridField($P2vse); $P2vse->display('avatar', '头像')->hookRendering(function (AbstractField $jJyrp, $YaV4m, $DbHm9) { $Bew60 = AssetsUtil::fixOrDefault($YaV4m->avatar, 'asset/image/avatar.svg'); $JmFMc = AssetsUtil::fixOrDefault($YaV4m->avatarBig, 'asset/image/avatar.svg'); return AutoRenderedFieldValue::make("<a href='{$JmFMc}' class='tw-inline-block' data-image-preview>\n                        <img src='{$Bew60}' class='tw-rounded-full tw-w-8 tw-h-8 tw-shadow'></a>"); }); $P2vse->text('username', '用户名')->required()->ruleUnique('member_user')->hookRendering(function (AbstractField $jJyrp, $YaV4m, $DbHm9) { switch ($jJyrp->renderMode()) { case FieldRenderMode::GRID: case FieldRenderMode::DETAIL: return AutoRenderedFieldValue::make(TextDialogRequest::make('primary', htmlspecialchars($YaV4m->username), modstart_admin_url('member/show', array('_id' => $YaV4m->id)))->width('90%')->height('90%')->render()); break; } }); $P2vse->text('email', '邮箱'); $P2vse->text('phone', '手机'); $P2vse->text('nickname', '昵称'); if (MemberOauth::hasEnableItems()) { $P2vse->display('_oauth', '授权')->hookRendering(function (AbstractField $jJyrp, $YaV4m, $DbHm9) { $Uvvg3 = array(); $UZHBa = MemberUtil::listOauths($YaV4m->id); foreach ($UZHBa as $AaFBy) { goto yeCpg; KqF1o: if (empty($ubZ7m)) { $ubZ7m = ColorUtil::pick($AaFBy['type']); } goto Rw9WU; du4HT: $SRIGb = MemberOauth::getByOauthKey($AaFBy['type']); goto WnhYk; yeCpg: $ubZ7m = null; goto VMdpt; WnhYk: if ($SRIGb) { $ubZ7m = $SRIGb->color(); $H_jRb = $SRIGb->title(); } goto KqF1o; VMdpt: $H_jRb = $AaFBy['type']; goto du4HT; Rw9WU: $Uvvg3[] = '<a style="color:' . $ubZ7m . ';" href="javascript:;" data-tip-popover="' . $H_jRb . '"><i class="iconfont icon-dot"></i></a>'; goto BB1tZ; BB1tZ: } return join('', $Uvvg3); }); } $P2vse->type('status', '状态')->type(MemberStatus::class, array(MemberStatus::NORMAL => 'success', MemberStatus::FORBIDDEN => 'danger'))->required(); $dSDEp = ModuleManager::getModuleConfig('Member', 'groupEnable', false); if ($dSDEp) { $P2vse->radio('groupId', '分组')->options(MemberGroupUtil::mapIdTitle())->required(); } $scVGG = ModuleManager::getModuleConfig('Member', 'vipEnable', false); if ($scVGG) { $P2vse->radio('vipId', 'VIP')->options(MemberVipUtil::mapTitle())->required(); $P2vse->date('vipExpire', 'VIP过期'); } $P2vse->display('registerIp', '注册IP'); $P2vse->display('created_at', '注册时间'); $P2vse->canBatchSelect(true); $P2vse->batchOperatePrepend('<button class="btn" data-batch-confirm="确认禁用 %d 个用户？" data-batch-operate="' . modstart_admin_url('member/status_forbidden') . '"><i class="iconfont icon-warning"></i> 禁用</button>'); })->repositoryFilter(function (RepositoryFilter $mHisM) { $mHisM->where(array('isDeleted' => false)); })->gridFilter(function (GridFilter $mHisM) { $mHisM->eq('id', L('ID')); $mHisM->like('username', '用户名'); $mHisM->like('email', '邮箱')->autoHide(true); $mHisM->like('phone', '手机')->autoHide(true); $mHisM->eq('status', '状态')->autoHide(true)->select(MemberStatus::class); if (ModuleManager::getModuleConfig('Member', 'groupEnable', false)) { $mHisM->eq('groupId', '分组')->autoHide(true)->select(MemberGroupUtil::mapIdTitle()); } if (ModuleManager::getModuleConfig('Member', 'vipEnable', false)) { $mHisM->eq('vipId', 'VIP')->autoHide(true)->select(MemberVipUtil::mapTitle()); } })->operateFixed('right')->hookItemOperateRendering(function (ItemOperate $CVjnG) { $YaV4m = $CVjnG->item(); $CVjnG->prepend(TextDialogRequest::make('primary', '查看', modstart_admin_url('member/show', array('_id' => $YaV4m->id)))->width('90%')->height('90%')->render()); })->title('用户管理')->canShow(false)->canDelete(true)->canEdit(false)->canExport(ModuleManager::getModuleConfig('Member', 'exportEnable', false)); } public function selectRemote() { return Select::optionRemoteHandleModel('member_user', 'id', 'username'); } public function add(AdminDialogPage $iXUoW) { goto Egldz; yYuv2: $NX6uw->layoutPanel('高级', function (Form $NX6uw) { $NX6uw->text('nickname', '昵称'); $NX6uw->radio('status', '状态')->optionType(MemberStatus::class)->defaultValue(MemberStatus::NORMAL); if (ModuleManager::getModuleConfig('Member', 'groupEnable', false)) { $NX6uw->radio('groupId', '分组')->options(MemberGroupUtil::mapIdTitle())->required(); } if (ModuleManager::getModuleConfig('Member', 'vipEnable', false)) { $NX6uw->radio('vipId', 'VIP')->options(MemberVipUtil::mapTitle())->required(); $NX6uw->date('vipExpire', 'VIP过期'); } }); goto PTi0X; Rxik9: return $iXUoW->pageTitle('创建用户')->body($NX6uw)->handleForm($NX6uw, function (Form $NX6uw) { AdminPermission::demoCheck(); $avcnU = $NX6uw->dataForming(); $f33J4 = !empty($avcnU['username']) ? $avcnU['username'] : null; $I2nM5 = !empty($avcnU['phone']) ? $avcnU['phone'] : null; $ww4tY = !empty($avcnU['email']) ? $avcnU['email'] : null; $Gjx3d = ArrayUtil::keepKeys($avcnU, array('nickname', 'groupId', 'status', 'vipId', 'vipExpire')); $rhLXE = MemberUtil::register($f33J4, $I2nM5, $ww4tY, $avcnU['password']); BizException::throwsIfResponseError($rhLXE); if (!empty($Gjx3d)) { if (isset($Gjx3d['vipExpire']) && TimeUtil::isDateEmpty($Gjx3d['vipExpire'])) { $Gjx3d['vipExpire'] = null; } MemberUtil::update($rhLXE['data']['id'], $Gjx3d); } EventUtil::fire(new MemberUserRegisteredEvent($rhLXE['data']['id'])); return Response::redirect(CRUDUtil::jsDialogCloseAndParentGridRefresh()); }); goto lX3fS; Egldz: $NX6uw = Form::make(''); goto isN_x; isN_x: $NX6uw->layoutPanel('基础（用户、手机、邮箱不能同时为空）', function (Form $NX6uw) { $NX6uw->text('username', '用户名'); $NX6uw->text('phone', '手机'); $NX6uw->text('email', '邮箱'); $NX6uw->text('password', '初始密码')->defaultValue(RandomUtil::lowerString(8)); }); goto yYuv2; PTi0X: $NX6uw->showSubmit(false)->showReset(false); goto Rxik9; lX3fS: } public function edit(AdminDialogPage $iXUoW) { goto PrbQS; si1ib: $NX6uw->showSubmit(false)->showReset(false); goto hAiHm; MdpF2: if (Request::isPost()) { goto dXAjD; DZCWi: switch ($Km8YS->getTrimString('_action')) { case 'itemCellEdit': goto TI0nh; EbuDy: if (!empty($Gszjy)) { MemberUtil::update($QqUVI['id'], $Gszjy); } goto fnd_I; TI0nh: $Gszjy = array(); goto bGxce; bGxce: switch ($Km8YS->getTrimString('column')) { case 'status': $Gszjy['status'] = $Km8YS->getInteger('value'); break; } goto EbuDy; fnd_I: return Response::generateSuccess(); goto XFtCm; XFtCm: } goto Wh13_; E3SNA: $Km8YS = InputPackage::buildFromInput(); goto DZCWi; dXAjD: AdminPermission::demoCheck(); goto E3SNA; Wh13_: } goto SWH6T; SWH6T: $NX6uw = Form::make(''); goto O9S3b; Az7V9: $NX6uw->layoutPanel('高级', function (Form $NX6uw) { $NX6uw->text('nickname', '昵称'); $NX6uw->radio('status', '状态')->optionType(MemberStatus::class)->defaultValue(MemberStatus::NORMAL); if (ModuleManager::getModuleConfig('Member', 'groupEnable', false)) { $NX6uw->radio('groupId', '分组')->options(MemberGroupUtil::mapIdTitle())->required(); } if (ModuleManager::getModuleConfig('Member', 'vipEnable', false)) { $NX6uw->radio('vipId', 'VIP')->options(MemberVipUtil::mapTitle())->required(); $NX6uw->date('vipExpire', 'VIP过期')->help('VIP过期留空表示永久'); } }); goto NGIIB; NGIIB: $NX6uw->item($QqUVI)->fillFields(); goto si1ib; O9S3b: $NX6uw->layoutPanel('基础', function (Form $NX6uw) { $NX6uw->display('id', '用户ID')->addable(true); $NX6uw->text('username', '用户名'); $NX6uw->text('phone', '手机'); $NX6uw->text('email', '邮箱'); }); goto Az7V9; hAiHm: return $iXUoW->pageTitle('修改信息')->body($NX6uw)->handleForm($NX6uw, function (Form $NX6uw) use($QqUVI) { AdminPermission::demoCheck(); $avcnU = $NX6uw->dataForming(); $XWzh1 = ArrayUtil::keepKeys($avcnU, array('username', 'phone', 'email')); $Gjx3d = ArrayUtil::keepKeys($avcnU, array('nickname', 'groupId', 'status', 'vipId', 'vipExpire')); $rhLXE = MemberUtil::updateBasicWithUniqueCheck($QqUVI['id'], $XWzh1); BizException::throwsIfResponseError($rhLXE); if (isset($Gjx3d['vipExpire']) && TimeUtil::isDateEmpty($Gjx3d['vipExpire'])) { $Gjx3d['vipExpire'] = null; } if ($QqUVI['vipId'] != $Gjx3d['vipId']) { MemberUserVipChangeEvent::fire($QqUVI['id'], $QqUVI['vipId'], $Gjx3d['vipId']); } MemberUtil::update($QqUVI['id'], $Gjx3d); return Response::redirect(CRUDUtil::jsDialogCloseAndParentRefresh()); }); goto GmLWe; PrbQS: $QqUVI = ModelUtil::get('member_user', CRUDUtil::id()); goto c0qSv; c0qSv: BizException::throwsIfEmpty('用户不存在', $QqUVI); goto MdpF2; GmLWe: } public function select(AdminDialogPage $iXUoW) { goto CSbVc; LoLb2: return $iXUoW->pageTitle('选择用户')->body($W3CVY); goto IrTwQ; VQdSZ: $W3CVY->canSingleSelectItem(true); goto t2HWd; pDtjz: if (Request::isPost()) { return $W3CVY->request(); } goto LoLb2; CSbVc: $W3CVY = $this->grid(); goto KlKYL; KlKYL: $W3CVY->disableCUD(); goto VQdSZ; t2HWd: CRUDUtil::registerGridResource($W3CVY, '\\' . __CLASS__); goto pDtjz; IrTwQ: } public function search() { goto p_Oyp; HQ_aM: $r2pbP = array(); goto mWELr; Y1li3: $fPAoT = MemberUtil::paginate(1, 10, $r2pbP); goto fClGc; cFAJP: $HWB1S = $Km8YS->getTrimString('keywords'); goto HQ_aM; fClGc: $MCyeh = array_map(function ($YaV4m) { return array('value' => intval($YaV4m['id']), 'name' => htmlspecialchars(MemberUtil::viewName($YaV4m)), 'avatar' => AssetsUtil::fixOrDefault($YaV4m['avatar'], 'asset/image/avatar.svg')); }, $fPAoT['records']); goto xNy_H; xNy_H: return Response::jsonSuccessData($MCyeh); goto NmFJC; p_Oyp: $Km8YS = InputPackage::buildFromInput(); goto cFAJP; mWELr: $r2pbP['whereOperate'] = array('username', 'like', "%{$HWB1S}%"); goto Y1li3; NmFJC: } public function resetPassword(AdminConfigBuilder $P2vse) { goto Q12B5; ztiyD: $QqUVI = MemberUtil::get($gZ39D); goto Ii5sI; JDEhD: $P2vse->text('passwordNew', '新密码')->required()->defaultValue(RandomUtil::upperString(6)); goto hMRoZ; hMRoZ: if (Request::isPost()) { return $P2vse->formRequest(function (Form $NX6uw) use($QqUVI) { AdminPermission::demoCheck(); $avcnU = $NX6uw->dataForming(); $rhLXE = MemberUtil::changePassword($QqUVI['id'], $avcnU['passwordNew'], null, true); BizException::throwsIfResponseError($rhLXE); return Response::redirect(CRUDUtil::jsDialogClose()); }); } goto FgxlF; Ii5sI: BizException::throwsIfEmpty('用户不存在', $QqUVI); goto uL_sc; FgxlF: return $P2vse; goto uT71l; uL_sc: $P2vse->useDialog(); goto zwEla; zwEla: $P2vse->pageTitle('重置密码'); goto JDEhD; Q12B5: $gZ39D = CRUDUtil::id(); goto ztiyD; uT71l: } public function sendMessage(AdminConfigBuilder $P2vse) { goto HBi7u; tZcMI: $P2vse->useDialog(); goto ogj2X; B11qh: $P2vse->richHtml('content', '消息内容')->required(); goto aEZbp; ibEN2: return $P2vse; goto dH23v; ogj2X: $P2vse->pageTitle('发送消息'); goto B11qh; aEZbp: if (Request::isPost()) { return $P2vse->formRequest(function (Form $NX6uw) use($QqUVI) { AdminPermission::demoCheck(); $avcnU = $NX6uw->dataForming(); $rhLXE = MemberMessageUtil::send($QqUVI['id'], $avcnU['content']); BizException::throwsIfResponseError($rhLXE); return Response::redirect(CRUDUtil::jsDialogClose()); }); } goto ibEN2; df4ON: $QqUVI = MemberUtil::get($gZ39D); goto n7JNt; n7JNt: BizException::throwsIfEmpty('用户不存在', $QqUVI); goto tZcMI; HBi7u: $gZ39D = CRUDUtil::id(); goto df4ON; dH23v: } public function show() { goto VtozA; yIqcl: $DFTdi = MemberAdminShowPanelProvider::listAll(); goto WMxG9; VtozA: $lLaeU = MemberUtil::get(CRUDUtil::id()); goto yIqcl; WMxG9: return view('module::Member.View.admin.memberUser.show', array('record' => $lLaeU, 'showPanelProviders' => $DFTdi)); goto yGqov; yGqov: } public function delete() { goto lTXkD; lTXkD: AdminPermission::demoCheck(); goto T86IG; T86IG: MemberUtil::delete(CRUDUtil::id()); goto wDUED; wDUED: return Response::redirect(CRUDUtil::jsGridRefresh()); goto v05ge; v05ge: } public function statusForbidden() { goto mUCTk; mUCTk: AdminPermission::demoCheck(); goto Z85rs; Z85rs: MemberUtil::updateStatus(CRUDUtil::ids(), MemberStatus::FORBIDDEN); goto QLaAD; QLaAD: return Response::redirect(CRUDUtil::jsGridRefresh()); goto KAmAu; KAmAu: } public function export(ExportHandle $Df7Bd) { $Eq0Re = array('ID', '用户名', '邮箱', '手机', '注册时间', '性别', '姓名', '签名'); return $Df7Bd->withPageTitle('导出用户信息')->withDefaultExportName('用户信息')->withHeadTitles($Eq0Re)->handleFetch(function ($iXUoW, $VUK_X, $N8UD0, $w6bW5) { $jyBel = ModelUtil::model('member_user'); $jyBel = $jyBel->where(array('isDeleted' => false))->orderBy('id', 'desc'); foreach ($N8UD0 as $ihQxK) { if (!empty($ihQxK['id']['eq'])) { $jyBel = $jyBel->where('id', $ihQxK['id']['eq']); } elseif (!empty($ihQxK['status']['eq'])) { $jyBel = $jyBel->where('status', $ihQxK['status']['eq']); } elseif (!empty($ihQxK['groupId']['eq'])) { $jyBel = $jyBel->where('groupId', $ihQxK['groupId']['eq']); } elseif (!empty($ihQxK['vipId']['eq'])) { $jyBel = $jyBel->where('vipId', $ihQxK['vipId']['eq']); } elseif (!empty($ihQxK['username']['like'])) { $jyBel = $jyBel->where('username', 'like', '%' . $ihQxK['username']['like'] . '%'); } elseif (!empty($ihQxK['email']['like'])) { $jyBel = $jyBel->where('email', 'like', '%' . $ihQxK['email']['like'] . '%'); } elseif (!empty($ihQxK['phone']['like'])) { $jyBel = $jyBel->where('phone', 'like', '%' . $ihQxK['phone']['like'] . '%'); } } $AzbSd = $jyBel->paginate($VUK_X, array('*'), 'page', $iXUoW)->toArray(); $sT6YU = array(); foreach ($AzbSd['data'] as $YaV4m) { goto b33RZ; G0kq5: $vetOJ[] = $YaV4m['realname']; goto pL_G2; b33RZ: $vetOJ = array(); goto s9hCJ; QlGQe: $vetOJ[] = $YaV4m['username']; goto sW_bQ; pL_G2: $vetOJ[] = $YaV4m['signature']; goto TzyiE; TzyiE: $sT6YU[] = $vetOJ; goto oH1_i; sW_bQ: $vetOJ[] = $YaV4m['email']; goto BaoBZ; sq_sB: $vetOJ[] = TypeUtil::name(Gender::class, $YaV4m['gender']); goto G0kq5; upixL: $vetOJ[] = $YaV4m['created_at']; goto sq_sB; BaoBZ: $vetOJ[] = $YaV4m['phone']; goto upixL; s9hCJ: $vetOJ[] = $YaV4m['id']; goto QlGQe; oH1_i: } return array('list' => $sT6YU, 'total' => $AzbSd['total']); })->performCommon(); } }