<?php
/**
 * ------------------------ 
 *  版权所有  www.tecmz.com
 *  商业版本请购买正版授权使用
 * ------------------------
*/ namespace Module\Member\Util; use Carbon\Carbon; use Illuminate\Support\Facades\Cache; use Illuminate\Support\Str; use Intervention\Image\Facades\Image; use ModStart\Core\Assets\AssetsUtil; use ModStart\Core\Dao\ModelUtil; use ModStart\Core\Exception\BizException; use ModStart\Core\Input\Request; use ModStart\Core\Input\Response; use ModStart\Core\Util\AgentUtil; use ModStart\Core\Util\ArrayUtil; use ModStart\Core\Util\EncodeUtil; use ModStart\Core\Util\FormatUtil; use ModStart\Core\Util\LockUtil; use ModStart\Core\Util\RandomUtil; use ModStart\Core\Util\SerializeUtil; use ModStart\Core\Util\StrUtil; use ModStart\Data\DataManager; use ModStart\Data\Event\DataFileUploadedEvent; use Module\Member\Events\MemberUserLoginAttemptEvent; use Module\Member\Events\MemberUserLoginFailedEvent; use Module\Member\Type\MemberMessageStatus; use Module\Member\Type\MemberPasswordStrength; use Module\Member\Type\MemberStatus; use Module\Vendor\Type\DeviceType; class MemberUtil { public static function total() { return Cache::remember('MemberUserTotal', 60, function () { return ModelUtil::count('member_user'); }); } public static function get($gZ39D) { return ModelUtil::get('member_user', array('id' => $gZ39D)); } public static function getCached($gZ39D) { return Cache::remember('MemberUser:' . $gZ39D, 60, function () use($gZ39D) { return self::get($gZ39D); }); } public static function processDefault(&$QqUVI) { goto HlE0j; ZgpqC: if (empty($QqUVI['nickname'])) { $QqUVI['nickname'] = $QqUVI['username']; } goto kOVYC; qRj_L: if (empty($QqUVI['avatarMedium'])) { $QqUVI['avatarMedium'] = AssetsUtil::fixFull('asset/image/avatar.svg', false); } goto iOa9V; iOa9V: if (empty($QqUVI['avatarBig'])) { $QqUVI['avatarBig'] = AssetsUtil::fixFull('asset/image/avatar.svg', false); } goto ksxBu; kOVYC: if (empty($QqUVI['avatar'])) { $QqUVI['avatar'] = AssetsUtil::fixFull('asset/image/avatar.svg', false); } goto qRj_L; HlE0j: if (empty($QqUVI)) { return; } goto ZgpqC; ksxBu: } private static function processBasicFields($fjmq9) { goto TRhZb; Iq9du: return $fjmq9; goto Cn7kb; TRhZb: $k8vXJ = array('id', 'username', 'avatar', 'created_at', 'signature', 'nickname'); goto pnxdt; pnxdt: if (null === $fjmq9) { $fjmq9 = $k8vXJ; } else { goto zL2MQ; VPxCk: foreach ($fjmq9 as $KAKiA) { if ('<basic>' == $KAKiA) { $W_1PA = array_merge($W_1PA, $k8vXJ); } else { $W_1PA[] = $KAKiA; } } goto KUrZL; zL2MQ: $W_1PA = array(); goto VPxCk; KUrZL: $fjmq9 = $W_1PA; goto Jtk0y; Jtk0y: } goto Iq9du; Cn7kb: } public static function fixAvatar($NEM_n) { return AssetsUtil::fixFullOrDefault($NEM_n, 'asset/image/avatar.svg'); } public static function getBasic($gZ39D, $fjmq9 = null) { goto QZgyv; QZgyv: $fjmq9 = self::processBasicFields($fjmq9); goto qA6Wp; qA6Wp: $YaV4m = self::get($gZ39D); goto aXJjj; yJsAY: foreach ($fjmq9 as $RBLil) { if (isset($YaV4m[$RBLil])) { $AzbSd[$RBLil] = $YaV4m[$RBLil]; } else { $AzbSd[$RBLil] = null; } } goto s9fZj; aXJjj: if (empty($YaV4m)) { return null; } goto Yz6Nn; H9JzD: $YaV4m['avatar'] = self::fixAvatar($YaV4m['avatar']); goto L0pyG; Yz6Nn: if (empty($YaV4m['nickname'])) { $YaV4m['nickname'] = $YaV4m['username']; } goto H9JzD; L0pyG: $AzbSd = array(); goto yJsAY; s9fZj: return $AzbSd; goto gzfVU; gzfVU: } public static function listViewName($FN9bz) { goto YeKfa; nNHUT: foreach ($fstQg as $QqUVI) { $Iwq1e[] = self::viewName($QqUVI); } goto AlNgj; YeKfa: $Iwq1e = array(); goto FMR5l; AlNgj: return $Iwq1e; goto I1JIG; FMR5l: $fstQg = ModelUtil::allIn('member_user', 'id', $FN9bz); goto nNHUT; I1JIG: } public static function listUsers($FN9bz) { return ModelUtil::allIn('member_user', 'id', $FN9bz); } public static function convertOneToBasic($QqUVI) { return array('id' => $QqUVI['id'], 'username' => $QqUVI['username'], 'nickname' => empty($QqUVI['nickname']) ? $QqUVI['username'] : $QqUVI['nickname'], 'created_at' => $QqUVI['created_at'], 'signature' => isset($QqUVI['signature']) ? $QqUVI['signature'] : null, 'avatar' => AssetsUtil::fixFullOrDefault($QqUVI['avatar'], 'asset/image/avatar.svg')); } public static function convertToBasic($fstQg) { return array_map(function ($YaV4m) { return array('id' => $YaV4m['id'], 'username' => $YaV4m['username'], 'nickname' => empty($YaV4m['nickname']) ? $YaV4m['username'] : $YaV4m['nickname'], 'created_at' => $YaV4m['created_at'], 'signature' => isset($YaV4m['signature']) ? $YaV4m['signature'] : null, 'avatar' => AssetsUtil::fixFullOrDefault($YaV4m['avatar'], 'asset/image/avatar.svg')); }, $fstQg); } public static function listUsersBasic($FN9bz) { return self::convertToBasic(self::listUsers($FN9bz)); } public static function getViewName($gZ39D) { return self::viewName(self::get($gZ39D)); } public static function viewName($QqUVI) { goto cQmxL; Fi4Xi: if (!empty($QqUVI['nickname'])) { return $QqUVI['nickname']; } goto NG_gF; cQmxL: if ($QqUVI && is_numeric($QqUVI)) { return self::getViewName($QqUVI); } goto vkJzT; G6MtD: return "ID-{$QqUVI['id']}"; goto TM0nU; NG_gF: if (!empty($QqUVI['username'])) { return $QqUVI['username']; } goto G6MtD; vkJzT: if (empty($QqUVI)) { return '-'; } goto Fi4Xi; TM0nU: } public static function update($gZ39D, $avcnU) { return ModelUtil::update('member_user', array('id' => $gZ39D), $avcnU); } public static function updateBasicWithUniqueCheck($gZ39D, $avcnU) { goto DZh3q; OpwgT: return Response::generate(0, 'ok'); goto HPdFR; q93iu: self::update($gZ39D, $avcnU); goto OpwgT; BJnj6: foreach (array('username' => '用户名', 'phone' => '手机', 'email' => '邮箱') as $jJyrp => $KPazB) { if (isset($avcnU[$jJyrp])) { goto GRJRy; Y90iJ: if (count($r0V_P) > 1) { return Response::generate(-1, $KPazB . '重复'); } goto pXr3p; sQTOo: $r0V_P = ModelUtil::all('member_user', array($jJyrp => $avcnU[$jJyrp])); goto Y90iJ; GRJRy: if (empty($avcnU[$jJyrp])) { $avcnU[$jJyrp] = null; continue; } goto sQTOo; pXr3p: if (count($r0V_P) == 1) { if ($r0V_P[0]['id'] != $gZ39D) { return Response::generate(-1, $KPazB . '重复'); } } goto SX5GX; SX5GX: } } goto q93iu; DZh3q: if (empty($avcnU)) { return Response::generate(0, 'ok'); } goto BJnj6; HPdFR: } public static function login($f33J4 = '', $I2nM5 = '', $ww4tY = '', $SoauJ = '') { goto Hq5dm; z2xNz: if ($QqUVI['password'] != EncodeUtil::md5WithSalt($SoauJ, $QqUVI['passwordSalt'])) { MemberUserLoginFailedEvent::fire($QqUVI['id'], $QqUVI['username'], Request::ip(), AgentUtil::getUserAgent()); return Response::generate(-7, '登录失败:用户名或密码错误'); } goto iW2Ux; ftwVm: if ($ww4tY) { if (!FormatUtil::isEmail($ww4tY)) { return Response::generate(-3, '邮箱格式不正确'); } $dNpGx = array('email' => $ww4tY); } else { if ($I2nM5) { if (!preg_match('/(^1[0-9]{10}$)/', $I2nM5)) { return Response::generate(-4, '手机格式不正确'); } $dNpGx = array('phone' => $I2nM5); } else { if ($f33J4) { if (strpos($f33J4, '@') !== false) { return Response::generate(-5, '用户名格式不正确'); } $dNpGx = array('username' => $f33J4); } } } goto QseJc; XxmH1: if (!($ww4tY || $I2nM5 || $f33J4)) { return Response::generate(-1, '所有登录字段均为空'); } goto e15Qq; QseJc: $QqUVI = ModelUtil::get('member_user', $dNpGx); goto w4Nhe; X7WjK: $I2nM5 = trim($I2nM5); goto EkzrQ; Hq5dm: $ww4tY = trim($ww4tY); goto X7WjK; pN74s: return Response::generateSuccessData($QqUVI); goto tQ4Ac; EkzrQ: $f33J4 = trim($f33J4); goto XxmH1; iW2Ux: switch ($QqUVI['status']) { case MemberStatus::FORBIDDEN: return Response::generateError(-8, '登录失败:当前用户已被禁用'); } goto pN74s; w4Nhe: if (empty($QqUVI)) { return Response::generate(-6, '登录失败:用户名或密码错误'); } goto y6GHC; y6GHC: MemberUserLoginAttemptEvent::fire($QqUVI['id'], Request::ip(), AgentUtil::getUserAgent()); goto z2xNz; e15Qq: if (!$SoauJ) { return Response::generate(-2, '密码为空'); } goto ftwVm; tQ4Ac: } public static function autoSetUsernameNickname($shbIl, $JnQ6d) { goto tzzuA; wP6iG: if (preg_match('/\\{.*\\}/', $JnQ6d)) { goto zykqS; L8Ypv: $oFNWf = array('{Phone}' => $QqUVI['phone'], '{Phone4}' => substr($QqUVI['phone'], 7), '{Uid}' => $QqUVI['id']); goto JL0_j; zykqS: $QqUVI = self::get($shbIl); goto L8Ypv; GuTEl: $coOkL = 0; goto NcVXw; JL0_j: $JnQ6d = str_replace(array_keys($oFNWf), array_values($oFNWf), $JnQ6d); goto GuTEl; NcVXw: } goto kJBX9; kJBX9: self::suggestUsernameNickname($shbIl, $JnQ6d, $coOkL); goto Kucj3; tzzuA: $coOkL = 6; goto wP6iG; Kucj3: } public static function getSuggestUsernameNickname($aUb2M) { goto CFtCq; lOZJo: for ($i0YzC = 0; $i0YzC < 20; $i0YzC++) { $HwTKj = ModelUtil::model('member_user')->where(array('username' => $JnQ6d))->orWhere(array('nickname' => $JnQ6d))->first(); if (empty($HwTKj)) { return $JnQ6d; } $JnQ6d = $JnQ6d . Str::random(1); } goto Ndmg7; Ndmg7: return $JnQ6d . Str::random(10); goto S99SB; CFtCq: $JnQ6d = $aUb2M . Str::random(1); goto lOZJo; S99SB: } private static function suggestUsernameNickname($shbIl, $aeXlE = '用户', $coOkL = 6) { goto OvYfq; vxrdx: ModelUtil::update('member_user', $shbIl, array('username' => $JnQ6d, 'nickname' => $JnQ6d)); goto pfAVz; OvYfq: if ($coOkL > 0) { $JnQ6d = $aeXlE . RandomUtil::string($coOkL); } else { $JnQ6d = $aeXlE; } goto jvBkQ; jvBkQ: for ($i0YzC = 0; $i0YzC < 20; $i0YzC++) { $HwTKj = ModelUtil::model('member_user')->where(array('username' => $JnQ6d))->orWhere(array('nickname' => $JnQ6d))->first(); if (empty($HwTKj)) { break; } $JnQ6d = $JnQ6d . Str::random(1); } goto vxrdx; pfAVz: } public static function registerId($gZ39D, $avcnU = array()) { $QqUVI = ModelUtil::insert('member_user', array_merge(array('id' => $gZ39D, 'status' => MemberStatus::NORMAL, 'vipId' => MemberVipUtil::defaultVipId(), 'groupId' => MemberGroupUtil::defaultGroupId(), 'isDeleted' => false), $avcnU)); return Response::generate(0, 'ok', $QqUVI); } public static function registerUsername($f33J4) { return self::register($f33J4, '', '', '', true); } public static function registerUsernameQuick($f33J4) { goto xOoQT; xOoQT: $mkuYz = $f33J4; goto Gl7sj; cR8da: return Response::generateError('注册失败'); goto YUPoy; Gl7sj: for ($i0YzC = 0; $i0YzC < 10; $i0YzC++) { $rhLXE = self::register($mkuYz, '', '', '', true); if ($rhLXE['code']) { $mkuYz = $mkuYz . Str::random(1); } else { return $rhLXE; } } goto cR8da; YUPoy: } public static function register($f33J4 = '', $I2nM5 = '', $ww4tY = '', $SoauJ = '', $agyDp = false) { goto SUbeT; ucNfN: if (!$agyDp) { goto XB3wY; ttpYg: $rhLXE = self::passwordStrengthCheck($SoauJ); goto DJ0XJ; XB3wY: if (empty($SoauJ)) { return Response::generate(-3, '密码不合法'); } goto ttpYg; DJ0XJ: if (Response::isError($rhLXE)) { return Response::generate(-1, $rhLXE['msg']); } goto Z3ywy; Z3ywy: } goto XBuAx; BW1Wn: $f33J4 = trim($f33J4); goto HRaGq; QklIS: if ($f33J4) { goto XXA_a; auioB: if (Str::contains($f33J4, '@')) { return Response::generate(-1, '用户名不能包含特殊字符'); } goto rLqVp; rLqVp: if (preg_match('/^[0-9]{11}$/', $f33J4)) { return Response::generate(-1, '用户名不能为纯数字'); } goto weMDs; XXA_a: $rhLXE = self::uniqueCheck('username', $f33J4); goto qy_YE; DTQGh: if (strlen($f33J4) < modstart_config('Member_UsernameMinLength', 3)) { return Response::generate(-1, '用户名至少3个字符'); } goto auioB; qy_YE: if ($rhLXE['code']) { return $rhLXE; } goto DTQGh; weMDs: } else { $f33J4 = null; } goto ucNfN; d2kqt: if ($I2nM5) { $rhLXE = self::uniqueCheck('phone', $I2nM5); if ($rhLXE['code']) { return $rhLXE; } } else { $I2nM5 = null; } goto QklIS; yNAft: return Response::generate(0, 'ok', $QqUVI); goto ivOxX; SUbeT: $ww4tY = trim($ww4tY); goto OJnU_; OJnU_: $I2nM5 = trim($I2nM5); goto BW1Wn; vqxW_: if ($ww4tY) { $rhLXE = self::uniqueCheck('email', $ww4tY); if ($rhLXE['code']) { return $rhLXE; } } else { $ww4tY = null; } goto d2kqt; HRaGq: if (!($ww4tY || $I2nM5 || $f33J4)) { return Response::generate(-1, '所有注册字段均为空'); } goto vqxW_; XBuAx: $CnlFu = Str::random(16); goto H_Y5C; H_Y5C: $QqUVI = ModelUtil::insert('member_user', array('status' => MemberStatus::NORMAL, 'username' => $f33J4, 'email' => $ww4tY, 'phone' => $I2nM5, 'password' => $agyDp ? null : EncodeUtil::md5WithSalt($SoauJ, $CnlFu), 'passwordSalt' => $agyDp ? null : $CnlFu, 'vipId' => MemberVipUtil::defaultVipId(), 'groupId' => MemberGroupUtil::defaultGroupId(), 'isDeleted' => false)); goto yNAft; ivOxX: } public static function uniqueCheck($HWA34, $jkY57, $tBAv0 = 0) { goto pUcwz; AH6WE: switch ($HWA34) { case 'email': if (!FormatUtil::isEmail($jkY57)) { return Response::generate(-1, '邮箱格式不正确'); } break; case 'phone': if (!preg_match('/(^1[0-9]{10}$)/', $jkY57)) { return Response::generate(-1, '手机格式不正确'); } break; case 'username': if (strpos($jkY57, '@') !== false) { return Response::generate(-1, '用户名格式不正确'); } break; case 'nickname': break; default: return Response::generate(-1, '未能识别的类型' . $HWA34); } goto HCPfn; JQv1C: if (empty($QqUVI)) { return Response::generate(0, 'ok'); } goto hyZSY; wFxrN: return Response::generate(-2, $PB0mV[$HWA34] . '已经被占用'); goto jAnHZ; HYrG2: if ($tBAv0 == $QqUVI['id']) { return Response::generate(0, 'ok'); } goto wFxrN; HCPfn: $QqUVI = ModelUtil::get('member_user', array($HWA34 => $jkY57)); goto JQv1C; pUcwz: $jkY57 = trim($jkY57); goto AH6WE; hyZSY: $PB0mV = array('username' => '用户名', 'email' => '邮箱', 'phone' => '手机号'); goto HYrG2; jAnHZ: } public static function getByUsername($f33J4) { return ModelUtil::get('member_user', array('username' => $f33J4)); } public static function getByEmail($ww4tY) { return ModelUtil::get('member_user', array('email' => $ww4tY)); } public static function getByPhone($I2nM5) { return ModelUtil::get('member_user', array('phone' => $I2nM5)); } public static function changeNickname($shbIl, $E56iV) { goto q3BB0; zeRAA: if (Response::isError($rhLXE)) { return $rhLXE; } goto MqiT4; MqiT4: ModelUtil::update('member_user', $shbIl, array('nickname' => $E56iV)); goto iEnoz; iEnoz: return Response::generate(0, 'ok'); goto DeMFK; q3BB0: $rhLXE = self::uniqueCheck('nickname', $E56iV, $shbIl); goto zeRAA; DeMFK: } public static function changePassword($shbIl, $hWe64, $yMGeP = null, $padSA = false) { goto A9dO9; umCCs: $QqUVI = ModelUtil::get('member_user', array('id' => $shbIl)); goto CuhvP; CuhvP: if (empty($QqUVI)) { return Response::generate(-1, '用户不存在'); } goto OVRe_; OVRe_: if (empty($hWe64)) { return Response::generate(-1, '新密码为空'); } goto BCmm3; Vs1L3: $CnlFu = Str::random(16); goto n5TKr; BCmm3: $rhLXE = self::passwordStrengthCheck($hWe64); goto Y58FP; L9Fal: if (!$padSA && EncodeUtil::md5WithSalt($yMGeP, $QqUVI['passwordSalt']) != $QqUVI['password']) { return Response::generate(-1, '旧密码不正确'); } goto Vs1L3; n5TKr: ModelUtil::update('member_user', array('id' => $QqUVI['id']), array('passwordSalt' => $CnlFu, 'password' => EncodeUtil::md5WithSalt($hWe64, $CnlFu))); goto mPxPI; A9dO9: if (!$padSA && empty($yMGeP)) { return Response::generate(-1, '旧密码不能为空'); } goto umCCs; mPxPI: return Response::generate(0, 'ok'); goto RwT6A; Y58FP: if (Response::isError($rhLXE)) { return Response::generate(-1, $rhLXE['msg']); } goto L9Fal; RwT6A: } public static function setAvatar($mJcY3, $lIBWg, $BEl82 = 'jpg') { goto ynsSu; ynsSu: if (!in_array($BEl82, array('jpg', 'jpeg', 'png', 'gif'))) { return Response::generate(-1, '图片格式不正确'); } goto gNVxL; cqtHf: $S9KoU = DataManager::upload('image', 'U' . $mJcY3 . '_AvatarBig.' . $BEl82, $VvyP0, null, $CTKZC); goto uFxpe; RdB6G: $VvyP0 = (string) Image::make($lIBWg)->resize(400, 400)->encode($BEl82, 75); goto D8YAn; bLrOn: if ($rhLXE['code']) { goto VusDc; VusDc: DataManager::deleteById($S9KoU['data']['id']); goto rr7nn; rr7nn: DataManager::deleteById($J4laQ['data']['id']); goto uyfzl; uyfzl: if ($S9KoU['code']) { return Response::generate(-1, '头像存储失败（' . $rhLXE['msg'] . '）'); } goto TvBsg; TvBsg: } goto GChCP; CSv93: if (empty($lIBWg)) { return Response::generate(-1, '图片数据为空'); } goto RdB6G; uFxpe: if ($S9KoU['code']) { return Response::generate(-1, '头像存储失败（' . $S9KoU['msg'] . '）'); } goto EdAra; gNVxL: $QqUVI = self::get($mJcY3); goto RNmnA; EdAra: $J4laQ = DataManager::upload('image', 'U' . $mJcY3 . '_AvatarMiddle.' . $BEl82, $oZaix, null, $CTKZC); goto NZhYM; RNmnA: if (empty($QqUVI)) { return Response::generate(-1, '用户不存在'); } goto CSv93; d6Cks: $rhLXE = DataManager::upload('image', 'U_' . $mJcY3 . '_Avatar.' . $BEl82, $ICUxJ, null, $CTKZC); goto bLrOn; D8YAn: $oZaix = (string) Image::make($lIBWg)->resize(200, 200)->encode($BEl82, 75); goto Hs4o9; lLlun: return Response::generateSuccess(); goto UIwAk; GChCP: self::update($QqUVI['id'], array('avatarBig' => $S9KoU['data']['fullPath'], 'avatarMedium' => $J4laQ['data']['fullPath'], 'avatar' => $rhLXE['data']['fullPath'])); goto lLlun; Hs4o9: $ICUxJ = (string) Image::make($lIBWg)->resize(50, 50)->encode($BEl82, 75); goto LXNsL; LXNsL: $CTKZC = array('eventOpt' => array(DataFileUploadedEvent::OPT_IMAGE_COMPRESS_IGNORE => true, DataFileUploadedEvent::OPT_IMAGE_WATERMARK_IGNORE => true)); goto cqtHf; NZhYM: if ($J4laQ['code']) { DataManager::deleteById($S9KoU['data']['id']); if ($S9KoU['code']) { return Response::generate(-1, '头像存储失败（' . $J4laQ['msg'] . '）'); } } goto d6Cks; UIwAk: } public static function findUsers($wcztl) { goto g5jeE; VoDoo: foreach ($fstQg as &$hf7kA) { $IOhAU[$hf7kA->id] = $hf7kA->toArray(); } goto fw0Uw; g5jeE: if (empty($wcztl)) { return array(); } goto IeESZ; IeESZ: $IOhAU = array(); goto EFLwB; fw0Uw: return $IOhAU; goto A2YQx; EFLwB: $fstQg = ModelUtil::model('member_user')->whereIn('id', $wcztl)->get(); goto VoDoo; A2YQx: } public static function filterUserIds($wcztl) { goto eYA88; TvBVE: $fstQg = ModelUtil::model('member_user')->whereIn('id', $wcztl)->get(array('id')); goto QIl9O; QIl9O: foreach ($fstQg as &$hf7kA) { $oFNWf[$hf7kA->id] = true; } goto Emqqx; izK9w: $oFNWf = array(); goto TvBVE; eYA88: if (empty($wcztl)) { return array(); } goto izK9w; Emqqx: return array_keys($oFNWf); goto gR0IH; gR0IH: } public static function mergeMemberUsers(&$MCyeh, $r8h8Q = 'memberUserId', $xxfaf = '_memberUser') { ModelUtil::join($MCyeh, $r8h8Q, $xxfaf, 'member_user', 'id'); } public static function mergeMemberUserBasics(&$MCyeh, $r8h8Q = 'memberUserId', $xxfaf = '_memberUser', $fjmq9 = null) { $fjmq9 = self::processBasicFields($fjmq9); if (is_array($MCyeh)) { ModelUtil::join($MCyeh, $r8h8Q, $xxfaf, 'member_user', 'id'); foreach ($MCyeh as $KAKiA => $Iim2u) { goto m0q8T; KQGX0: if (empty($QqUVI['avatar'])) { $QqUVI['avatar'] = AssetsUtil::fixFull('asset/image/avatar.svg'); } else { $QqUVI['avatar'] = AssetsUtil::fixFull($QqUVI['avatar']); } goto QwkJe; QwkJe: $MCyeh[$KAKiA][$xxfaf] = $QqUVI; goto djNny; S2qlT: if (empty($QqUVI['nickname'])) { $QqUVI['nickname'] = $QqUVI['username']; } goto KQGX0; m0q8T: if (empty($Iim2u[$xxfaf])) { continue; } goto IVxzz; IVxzz: $QqUVI = ArrayUtil::keepKeys($Iim2u[$xxfaf], $fjmq9); goto S2qlT; djNny: } } else { ModelUtil::joinItems($MCyeh, $r8h8Q, $xxfaf, 'member_user', 'id'); foreach ($MCyeh as $YaV4m) { goto d_B3L; Eg3Oc: if (empty($QqUVI['nickname'])) { $QqUVI['nickname'] = $QqUVI['username']; } goto lcfZn; ciu0H: $YaV4m->{$xxfaf} = $QqUVI; goto mb1Kr; d_B3L: if (empty($YaV4m->{$xxfaf})) { continue; } goto tULzl; lcfZn: if (empty($QqUVI['avatar'])) { $QqUVI['avatar'] = AssetsUtil::fixFull('asset/image/avatar.svg'); } else { $QqUVI['avatar'] = AssetsUtil::fixFull($QqUVI['avatar']); } goto ciu0H; tULzl: $QqUVI = ArrayUtil::keepKeys($YaV4m->{$xxfaf}, $fjmq9); goto Eg3Oc; mb1Kr: } } } public static function insert($avcnU) { return ModelUtil::insert('member_user', $avcnU); } public static function getIdByOauth($y_ytt, $OFkk8) { goto RQ2tp; cJRDC: if (empty($QjHVP)) { return 0; } goto hzlvk; hzlvk: return intval($QjHVP['memberUserId']); goto Nd6Ne; RQ2tp: $QjHVP = ModelUtil::get('member_oauth', array('type' => $y_ytt, 'openId' => $OFkk8)); goto cJRDC; Nd6Ne: } public static function getIdByOauthAndCheck($y_ytt, $OFkk8) { goto xqk_g; Gwa01: MemberUtil::forgetOauth($y_ytt, $OFkk8); goto s2ZhY; xqk_g: $shbIl = self::getIdByOauth($y_ytt, $OFkk8); goto KWYUR; s2ZhY: return 0; goto rZYCW; KWYUR: if (self::get($shbIl)) { return $shbIl; } goto Gwa01; rZYCW: } public static function getOauthOpenId($shbIl, $y_ytt) { goto IelCc; JwGav: $QjHVP = ModelUtil::get('member_oauth', $dNpGx); goto OMc7A; IelCc: $dNpGx = array('memberUserId' => $shbIl, 'type' => $y_ytt); goto JwGav; OMc7A: if (empty($QjHVP)) { return null; } goto TOI3V; TOI3V: return $QjHVP['openId']; goto RqAIn; RqAIn: } public static function getOauth($shbIl, $y_ytt) { $dNpGx = array('memberUserId' => $shbIl, 'type' => $y_ytt); return ModelUtil::get('member_oauth', $dNpGx); } public static function listOauths($shbIl) { return ModelUtil::all('member_oauth', array('memberUserId' => $shbIl), array('*'), array('type', 'asc')); } public static function putOauth($shbIl, $y_ytt, $OFkk8, $Yee6d = array()) { goto H4hnG; Jug7c: $QjHVP = ModelUtil::get('member_oauth', $dNpGx); goto ygmR4; r0p84: if (empty($QjHVP)) { ModelUtil::delete('member_oauth', array('type' => $y_ytt, 'openId' => $OFkk8)); ModelUtil::insert('member_oauth', array_merge($dNpGx, $Gszjy)); } else { if ($QjHVP['openId'] != $OFkk8) { ModelUtil::update('member_oauth', $QjHVP['id'], $Gszjy); } } goto gg29b; ygmR4: $Gszjy = array_merge(array('openId' => $OFkk8), $Yee6d); goto r0p84; gg29b: LockUtil::release($Es2nO); goto a9jXt; H4DBv: $Es2nO = "MemberOauth:{$shbIl}"; goto TWL3W; TWL3W: if (!LockUtil::acquire($Es2nO)) { BizException::throws('正在处理中，请稍后再试'); } goto Jug7c; H4hnG: $dNpGx = array('memberUserId' => $shbIl, 'type' => $y_ytt); goto H4DBv; a9jXt: } public static function forgetOauth($y_ytt, $OFkk8) { ModelUtil::delete('member_oauth', array('type' => $y_ytt, 'openId' => $OFkk8)); } public static function updateNewMessageStatus($shbIl) { ModelUtil::update('member_user', array('id' => $shbIl), array('newMessageCount' => ModelUtil::count('member_message', array('userId' => $shbIl, 'status' => MemberMessageStatus::UNREAD)))); } public static function updateNewChatMsgStatus($shbIl) { if (modstart_module_enabled('MemberChat')) { ModelUtil::update('member_user', array('id' => $shbIl), array('newChatMsgCount' => ModelUtil::sum('member_chat', 'unreadMsgCount', array('memberUserId' => $shbIl)))); } } public static function paginate($iXUoW, $VUK_X, $r2pbP = array()) { return ModelUtil::paginate('member_user', $iXUoW, $VUK_X, $r2pbP); } public static function updateStatus($f_h4I, $Zz43T) { goto Gtx_9; kUBxW: if (empty($f_h4I)) { return; } goto ke5cx; Gtx_9: if (!is_array($f_h4I)) { $f_h4I = array($f_h4I); } goto kUBxW; ke5cx: ModelUtil::model('member_user')->whereIn('id', $f_h4I)->update(array('status' => $Zz43T)); goto bqrnQ; bqrnQ: } public static function delete($shbIl) { goto CBV2S; CBV2S: $QqUVI = self::get($shbIl); goto IQTdM; L5uxH: $fVlI0 = ModelUtil::all('member_oauth', array('memberUserId' => $QqUVI['id'])); goto QyXqR; iF2bB: ModelUtil::insert('member_deleted', array('id' => $QqUVI['id'], 'username' => $QqUVI['username'], 'phone' => $QqUVI['phone'], 'email' => $QqUVI['email'], 'content' => SerializeUtil::jsonEncode($ybjC4))); goto dcqRd; zcQ2b: $ybjC4 = array(); goto L5uxH; sDWS9: ModelUtil::transactionCommit(); goto NI8fP; IQTdM: BizException::throwsIfEmpty('用户不存在', $QqUVI); goto pUp8Q; QyXqR: $ybjC4['oauth'] = ArrayUtil::keepItemsKeys($fVlI0, array('type', 'openId', 'infoUsername', 'infoAvatar')); goto iF2bB; dcqRd: ModelUtil::update('member_user', $shbIl, array('deleteAtTime' => 0, 'isDeleted' => true, 'username' => null, 'phone' => null, 'email' => null)); goto sDWS9; pUp8Q: ModelUtil::transactionBegin(); goto zcQ2b; NI8fP: } public static function fireLogin($shbIl) { goto lAyGZ; Yo2vQ: ModelUtil::update('member_user', $shbIl, array('lastLoginTime' => Carbon::now(), 'lastLoginIp' => StrUtil::mbLimit($M5qLk, 20))); goto PsONd; lAyGZ: $M5qLk = Request::ip(); goto Yo2vQ; PsONd: ModelUtil::insert('member_login_log', array('memberUserId' => $shbIl, 'deviceType' => DeviceType::current(), 'ip' => StrUtil::mbLimit($M5qLk, 20), 'userAgent' => StrUtil::mbLimit(AgentUtil::getUserAgent(), 400))); goto lG0Lu; lG0Lu: } public static function passwordStrengthCheck($SoauJ) { goto gvl2n; KRubE: switch ($TGrrv) { case MemberPasswordStrength::NO_LIMIT: break; case MemberPasswordStrength::STRENGTH_2: if (StrUtil::passwordStrength($SoauJ) < 2) { return Response::generateError('密码必须包含 大写/小写/数字/特殊字符 2种以上'); } break; case MemberPasswordStrength::STRENGTH_3: if (StrUtil::passwordStrength($SoauJ) < 3) { return Response::generateError('密码必须包含 大写/小写/数字/特殊字符 3种以上'); } break; } goto uj1Fx; gvl2n: $tV08j = modstart_config('Member_PasswordLengthMin', 0); goto OQNzm; Y5qb6: $TGrrv = modstart_config('Member_PasswordStrength', MemberPasswordStrength::NO_LIMIT); goto KRubE; OQNzm: if ($tV08j > 0) { if (strlen($SoauJ) < $tV08j) { return Response::generateError('密码长度不能小于' . $tV08j . '位'); } } goto Y5qb6; uj1Fx: return Response::generateSuccess(); goto iqpCn; iqpCn: } }