<?php
/**
 * ------------------------ 
 *  版权所有  www.tecmz.com
 *  商业版本请购买正版授权使用
 * ------------------------
*/ namespace Module\PayCenter\Admin\Controller; use Illuminate\Routing\Controller; use Illuminate\Support\Facades\Log; use ModStart\Admin\Auth\AdminPermission; use ModStart\Admin\Concern\HasAdminQuickCRUD; use ModStart\Admin\Layout\AdminCRUDBuilder; use ModStart\Core\Dao\ModelUtil; use ModStart\Core\Exception\BizException; use ModStart\Core\Input\Response; use ModStart\Core\Util\CRUDUtil; use ModStart\Core\Util\EventUtil; use ModStart\Core\Util\SerializeUtil; use ModStart\Grid\Displayer\ItemOperate; use ModStart\Grid\GridFilter; use ModStart\Repository\Filter\RepositoryFilter; use ModStart\Support\Concern\HasFields; use ModStart\Widget\TextAjaxRequest; use Module\PayCenter\Biz\PayCenterBiz; use Module\PayCenter\Events\OrderPayedEvent; use Module\PayCenter\Type\PayOrderStatus; use Module\PayCenter\Type\PayType; class PayOrderController extends Controller { use HasAdminQuickCRUD; protected function crud(AdminCRUDBuilder $P2vse) { $P2vse->init('pay_order')->field(function ($P2vse) { $P2vse->id('id', '结算ID'); $P2vse->select('biz', '业务')->options(PayCenterBiz::allMap()); $P2vse->text('bizId', '业务订单ID'); $P2vse->type('status', '状态')->type(PayOrderStatus::class); $P2vse->type('payType', '支付类型')->type(PayType::class); $P2vse->currency('feeTotal', '金额'); $P2vse->text('body', '内容'); $P2vse->display('created_at', L('Created At')); $P2vse->display('updated_at', L('Updated At'))->listable(false); })->gridFilter(function (GridFilter $mHisM) { $mHisM->eq('id', '结算ID'); $mHisM->eq('biz', '业务')->select(PayCenterBiz::allMap()); $mHisM->eq('bizId', '业务订单ID'); $mHisM->eq('status', '状态')->select(PayOrderStatus::class); $mHisM->eq('payType', '支付类型')->select(PayType::class); })->operateFixed('right')->hookItemOperateRendering(function (ItemOperate $CVjnG) { $YaV4m = $CVjnG->item(); switch ($YaV4m->status) { case PayOrderStatus::PAYED: goto t433x; t433x: $CVjnG->push(TextAjaxRequest::danger('退款', action('\\' . __CLASS__ . '@refund', array('_id' => $YaV4m->id)), '确定标记退款？<br />标记退款后，需要手动在支付宝/微信等三方支付平台人工处理退款')); goto CyCly; CyCly: if (!$YaV4m->eventNotified) { $CVjnG->push(TextAjaxRequest::danger('重新触发事件', action('\\' . __CLASS__ . '@fireEvent', array('_id' => $YaV4m->id)), '确定重新触发支付？')); } goto lBJxD; lBJxD: break; goto uaOcS; uaOcS: } })->disableCUD()->title('全部订单'); } public function refund() { goto LciJB; SgKh9: $v9Xk2 = ModelUtil::get('pay_order', $gZ39D); goto VbtMU; D_0ze: BizException::throwsIf('订单状态错误', $v9Xk2['status'] != PayOrderStatus::PAYED); goto Vc9Gv; uD8Pl: return Response::redirect(CRUDUtil::jsGridRefresh()); goto UpDYa; VbtMU: BizException::throwsIfEmpty('订单不存在', $v9Xk2); goto D_0ze; Vc9Gv: ModelUtil::update('pay_order', $v9Xk2['id'], array('status' => PayOrderStatus::REFUND_SUCCESS)); goto uD8Pl; ZJpNV: $gZ39D = CRUDUtil::id(); goto SgKh9; LciJB: AdminPermission::demoCheck(); goto ZJpNV; UpDYa: } public function fireEvent() { goto PqYyC; PqYyC: AdminPermission::demoCheck(); goto HK2Uk; sc6yP: BizException::throwsIf('订单状态错误', $v9Xk2['status'] != PayOrderStatus::PAYED); goto K3cwg; K3cwg: $zt93p = new OrderPayedEvent(); goto cA3uT; k54yk: EventUtil::fire($zt93p); goto FP02p; ehZaV: $v9Xk2 = ModelUtil::get('pay_order', $gZ39D); goto Tft2C; rytfS: return Response::redirect(CRUDUtil::jsGridRefresh()); goto m7eW8; Tft2C: BizException::throwsIfEmpty('订单不存在', $v9Xk2); goto sc6yP; FP02p: Log::info('PayCenter.FireEventFromAdmin.OrderPayedEvent - ' . SerializeUtil::jsonEncode($zt93p, JSON_UNESCAPED_UNICODE)); goto Glnj2; cA3uT: $zt93p->biz = $v9Xk2['biz']; goto pi89M; Fnc7q: $zt93p->order = $v9Xk2; goto k54yk; Glnj2: ModelUtil::update('pay_order', $v9Xk2['id'], array('eventNotified' => true)); goto rytfS; HK2Uk: $gZ39D = CRUDUtil::id(); goto ehZaV; pi89M: $zt93p->bizId = $v9Xk2['bizId']; goto Fnc7q; m7eW8: } }