<?php
namespace Latrell\Alipay\Mobile; class SdkPayment { private $__https_verify_url = 'https://mapi.alipay.com/gateway.do?service=notify_verify&'; private $__http_verify_url = 'http://notify.alipay.com/trade/notify_query.do?'; private $service = 'mobile.securitypay.pay'; private $partner; private $_input_charset = 'UTF-8'; private $sign_type = 'RSA'; private $private_key_path; private $public_key_path; private $notify_url; private $out_trade_no; private $subject; private $payment_type = 1; private $seller_id; private $total_fee; private $body; private $show_url; private $anti_phishing_key; private $exter_invoke_ip; private $key; private $transport; private $cacert; public function __construct() { $this->cacert = getcwd() . '\\cacert.pem'; } public function getPayPara() { $parameter = array( 'service' => $this->service, 'partner' => trim($this->partner), 'payment_type' => $this->payment_type, 'notify_url' => $this->notify_url, 'seller_id' => $this->seller_id, 'out_trade_no' => $this->out_trade_no, 'subject' => $this->subject, 'total_fee' => $this->total_fee, 'body' => $this->body, 'show_url' => $this->show_url, 'anti_phishing_key' => $this->anti_phishing_key, 'exter_invoke_ip' => $this->exter_invoke_ip, '_input_charset' => trim(strtolower($this->_input_charset)) ); $para = $this->buildRequestPara($parameter); return $this->createLinkstringUrlencode($para); } public function verify() { if (empty($_POST) && empty($_GET)) { return false; } $data = $_POST ? : $_GET; $is_sign = $this->getSignVeryfy($data, $data['sign']); $response_txt = 'true'; if (! empty($data['notify_id'])) { $response_txt = $this->getResponse($data['notify_id']); } if (preg_match('/true$/i', $response_txt) && $is_sign) { return true; } else { return false; } } public function setBody($body) { $this->body = $body; return $this; } public function setNotifyUrl($notify_url) { $this->notify_url = $notify_url; return $this; } public function setOutTradeNo($out_trade_no) { $this->out_trade_no = $out_trade_no; return $this; } public function setPartner($partner) { $this->partner = $partner; return $this; } public function setPrivateKeyPath($private_key_path) { $this->private_key_path = $private_key_path; return $this; } public function setPublicKeyPath($public_key_path) { $this->public_key_path = $public_key_path; return $this; } public function setSellerId($seller_id) { $this->seller_id = $seller_id; return $this; } public function setSubject($subject) { $this->subject = $subject; return $this; } public function setTotalFee($total_fee) { $this->total_fee = $total_fee; return $this; } public function setSignType($sign_type) { $this->sign_type = $sign_type; return $this; } private function buildRequestPara($para_temp) { $para_filter = $this->paraFilter($para_temp); $para_sort = $this->argSort($para_filter); $mysign = $this->buildRequestMysign($para_sort); $para_sort['sign'] = $mysign; $para_sort['sign_type'] = strtoupper(trim($this->sign_type)); return $para_sort; } private function buildRequestMysign($para_sort) { $prestr = $this->createLinkstring($para_sort); $mysign = ''; switch (strtoupper(trim($this->sign_type))) { case 'MD5': $mysign = $this->md5Sign($prestr, $this->key); break; case 'RSA': $mysign = $this->rsaSign($prestr, trim($this->private_key_path)); break; default: $mysign = ''; } return $mysign; } function getSignVeryfy($para_temp, $sign) { $para_filter = $this->paraFilter($para_temp); $para_sort = $this->argSort($para_filter); $prestr = $this->createLinkstring($para_sort); $is_sgin = false; switch (strtoupper(trim($this->sign_type))) { case 'MD5': $is_sgin = $this->md5Verify($prestr, $sign, $this->key); break; case 'RSA': $is_sgin = $this->rsaVerify($prestr, $this->public_key_path, $sign); break; default: $is_sgin = false; } return $is_sgin; } private function paraFilter($para) { $para_filter = array(); while ((list ($key, $val) = each($para)) == true) { if ($key == 'sign' || $key == 'sign_type' || $val == '') { continue; } else { $para_filter[$key] = $para[$key]; } } return $para_filter; } private function argSort($para) { ksort($para); reset($para); return $para; } private function rsaVerify($data, $public_key_path, $sign) { $pubKey = file_get_contents($public_key_path); $res = openssl_get_publickey($pubKey); $result = (bool) openssl_verify($data, base64_decode($sign), $res); openssl_free_key($res); return $result; } private function rsaSign($data, $private_key_path) { $priKey = file_get_contents($private_key_path); $res = openssl_get_privatekey($priKey); openssl_sign($data, $sign, $res); openssl_free_key($res); $sign = base64_encode($sign); return $sign; } private function createLinkstring($para) { $arg = ''; while ((list ($key, $val) = each($para)) == true) { $arg .= $key . '=' . $val . '&'; } $arg = substr($arg, 0, count($arg) - 2); if (function_exists('get_magic_quotes_gpc') && get_magic_quotes_gpc()) { $arg = stripslashes($arg); } return $arg; } private function createLinkstringUrlencode($para) { $arg = ''; while ((list ($key, $val) = each($para)) == true) { $arg .= $key . '=' . urlencode($val) . '&'; } $arg = substr($arg, 0, count($arg) - 2); if (function_exists('get_magic_quotes_gpc') && get_magic_quotes_gpc()) { $arg = stripslashes($arg); } return $arg; } private function getResponse($notify_id) { $transport = strtolower(trim($this->transport)); $partner = trim($this->partner); $veryfy_url = ''; if ($transport == 'https') { $veryfy_url = $this->__https_verify_url; } else { $veryfy_url = $this->__http_verify_url; } $veryfy_url = $veryfy_url . 'partner=' . $partner . '&notify_id=' . $notify_id; $response_txt = $this->getHttpResponseGET($veryfy_url, $this->cacert); return $response_txt; } private function getHttpResponseGET($url, $cacert_url) { $curl = curl_init($url); curl_setopt($curl, CURLOPT_HEADER, 0); curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1); curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, true); curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, 2); curl_setopt($curl, CURLOPT_CAINFO, $cacert_url); $responseText = curl_exec($curl); curl_close($curl); return $responseText; } } 