<?php
namespace Payment\Common\Ali\Data; use Payment\Common\BaseData; use Payment\Utils\ArrayUtil; use Payment\Utils\Rsa2Encrypt; use Payment\Utils\RsaEncrypt; abstract class AliBaseData extends BaseData { public function getData() { $data = parent::getData(); $data = ArrayUtil::arraySort($data); return $data; } protected function makeSign($signStr) { switch ($this->signType) { case 'RSA': $rsa = new RsaEncrypt($this->rsaPrivateKey); $sign = $rsa->encrypt($signStr); break; case 'RSA2': $rsa = new Rsa2Encrypt($this->rsaPrivateKey); $sign = $rsa->encrypt($signStr); break; default: $sign = ''; } return $sign; } protected function buildData() { $bizContent = $this->getBizContent(); $bizContent = ArrayUtil::paraFilter($bizContent); $signData = [ 'app_id' => $this->appId, 'method' => $this->method, 'format' => $this->format, 'charset' => $this->charset, 'sign_type' => $this->signType, 'timestamp' => $this->timestamp, 'version' => $this->version, 'notify_url' => $this->notifyUrl, 'biz_content' => json_encode($bizContent, JSON_UNESCAPED_UNICODE), ]; if (in_array($this->method, ['alipay.trade.page.pay', 'alipay.trade.wap.pay'])) { $signData['return_url'] = $this->returnUrl; } $this->retData = ArrayUtil::paraFilter($signData); } abstract protected function getBizContent(); } 