<?php
namespace Payment\Common\Ali\Data; use Payment\Common\PayException; use Payment\Config; class TransData extends AliBaseData { protected function checkDataParam() { $transNo = $this->trans_no; $payeeType = $this->payee_type; $payeeAccount = $this->payee_account; $amount = $this->amount; $remark = $this->remark; if (empty($transNo)) { throw new PayException('请传入 商户转账唯一订单号'); } if (empty($payeeType) || ! in_array($payeeType, ['ALIPAY_USERID', 'ALIPAY_LOGONID'])) { throw new PayException('请传入收款账户类型'); } if (empty($payeeAccount)) { throw new PayException('请传入转账帐号'); } if (empty($amount) || bccomp($amount, 0, 2) !== 1) { throw new PayException('请输入转账金额，且大于0'); } if (bccomp($amount, Config::TRANS_FEE, 2) !== -1 && empty($remark)) { throw new PayException('转账金额大于等于' . Config::TRANS_FEE, '必须设置 remark'); } } protected function getBizContent() { $content = [ 'out_biz_no' => $this->trans_no, 'payee_type' => strtoupper($this->payee_type), 'payee_account' => $this->payee_account, 'amount' => $this->amount, 'payer_show_name' => $this->payer_show_name, 'payer_real_name' => $this->payer_real_name, 'payee_real_name' => $this->payee_real_name, 'remark' => $this->remark, ]; return $content; } } 