<?php
namespace Payment\Common; use Payment\Config; use Payment\Utils\ArrayUtil; abstract class BaseData { protected $data; protected $retData; protected $channel; public function __construct(ConfigInterface $config, array $reqData) { if ($config instanceof WxConfig) { $this->channel = Config::WECHAT_PAY; } elseif ($config instanceof AliConfig) { $this->channel = Config::ALI_PAY; } elseif ($config instanceof CmbConfig) { $this->channel = Config::CMB_PAY; } elseif ($config instanceof CcbConfig) { $this->channel = Config::CCB_PAY; } $this->data = array_merge($config->toArray(), $reqData); try { $this->checkDataParam(); } catch (PayException $e) { throw $e; } } public function __get($name) { if (isset($this->data[$name])) { return $this->data[$name]; } return null; } public function __set($name, $value) { $this->data[$name] = $value; } public function setSign() { $this->buildData(); if ($this->channel === Config::CMB_PAY) { $data = $this->retData['reqData']; } else { $data = $this->retData; } $values = ArrayUtil::removeKeys($data, ['sign']); $values = ArrayUtil::arraySort($values); $signStr = ArrayUtil::createLinkstring($values); $this->retData['sign'] = $this->makeSign($signStr); } public function getData() { return $this->retData; } abstract protected function makeSign($signStr); abstract protected function buildData(); abstract protected function checkDataParam(); } 