<?php
namespace Payment\Query\Ali; use Payment\Common\Ali\AliBaseStrategy; use Payment\Common\Ali\Data\Query\ChargeQueryData; use Payment\Common\PayException; use Payment\Config; use Payment\Utils\ArrayUtil; class AliChargeQuery extends AliBaseStrategy { protected $method = 'alipay.trade.query'; public function getBuildDataClass() { $this->config->method = $this->method; return ChargeQueryData::class; } protected function retData(array $data) { $data = parent::retData($data); try { $ret = $this->sendReq($data); } catch (PayException $e) { throw $e; } if ($this->config->returnRaw) { $ret['channel'] = Config::ALI_CHARGE; return $ret; } return $this->createBackData($ret); } protected function createBackData(array $data) { if ($data['code'] !== '10000') { return [ 'is_success' => 'F', 'error' => $data['sub_msg'], 'channel' => Config::ALI_CHARGE, ]; } $retData = [ 'is_success' => 'T', 'response' => [ 'channel' => Config::ALI_CHARGE, 'transaction_id' => $data['trade_no'], 'order_no' => $data['out_trade_no'], 'logon_id' => $data['buyer_logon_id'], 'trade_state' => $this->getTradeStatus($data['trade_status']), 'amount' => $data['total_amount'], 'receipt_amount' => $data['receipt_amount'], 'pay_amount' => ArrayUtil::get($data, 'buyer_pay_amount'), 'point_amount' => ArrayUtil::get($data, 'point_amount'), 'invoice_amount' => ArrayUtil::get($data, 'invoice_amount'), 'time_end' => ArrayUtil::get($data, 'send_pay_date'), 'store_id' => ArrayUtil::get($data, 'store_id'), 'terminal_id' => ArrayUtil::get($data, 'terminal_id'), 'store_name' => ArrayUtil::get($data, 'store_name'), 'buyer_id' => ArrayUtil::get($data, 'buyer_user_id'), 'fund_bill_list' => ArrayUtil::get($data, 'fund_bill_list', []), ], ]; return $retData; } } 