<?php
namespace Payment\Query\Wx; use Payment\Common\Weixin\Data\Query\RefundQueryData; use Payment\Common\Weixin\WxBaseStrategy; use Payment\Common\WxConfig; use Payment\Config; class WxRefundQuery extends WxBaseStrategy { protected $reqUrl = 'https://api.mch.weixin.qq.com/{debug}/pay/refundquery'; public function getBuildDataClass() { return RefundQueryData::class; } protected function retData(array $data) { if ($this->config->returnRaw) { $data['channel'] = Config::WX_REFUND; return $data; } if ($data['return_code'] != 'SUCCESS') { return $retData = [ 'is_success' => 'F', 'error' => $data['return_msg'], 'channel' => Config::WX_REFUND, ]; } if ($data['result_code'] != 'SUCCESS') { return $retData = [ 'is_success' => 'F', 'error' => $data['err_code_des'], 'channel' => Config::WX_REFUND, ]; } return $this->createBackData($data); } protected function createBackData(array $data) { $refund_count = $data['refund_count']; $totalFee = bcdiv($data['total_fee'], 100, 2); $refundFee = bcdiv($data['refund_fee'], 100, 2); $refundData = []; for ($i = 0; $i<$refund_count; $i++) { $refund_no = 'out_refund_no_' . $i; $refund_id = 'refund_id_' . $i; $refund_channel = 'refund_channel_' . $i; $refund_fee = 'refund_fee_' . $i; $refund_status = 'refund_status_' . $i; $recv_accout = 'refund_recv_accout_' . $i; $fee = bcdiv($refund_fee, 100, 2); $refundData[] = [ 'refund_no' => $data[$refund_no], 'refund_id' => $data[$refund_id], 'refund_channel' => $data[$refund_channel], 'refund_fee' => $fee, 'refund_status' => strtolower($data[$refund_status]), 'recv_accout' => $data[$recv_accout], ]; } $retData = [ 'is_success' => 'T', 'response' => [ 'amount' => $totalFee, 'order_no' => $data['out_trade_no'], 'transaction_id' => $data['transaction_id'], 'refund_count' => $data['refund_count'], 'refund_fee' => $refundFee, 'refund_data' => $refundData, 'channel' => Config::WX_REFUND, ], ]; return $retData; } } 