<?php
namespace Payment; use Payment\Common\BaseStrategy; use Payment\Common\PayException; use Payment\Query\Ali\AliChargeQuery; use Payment\Query\Ali\AliRefundQuery; use Payment\Query\Ali\AliTransferQuery; use Payment\Query\Cmb\CmbChargeQuery; use Payment\Query\Cmb\CmbRefundQuery; use Payment\Query\Wx\WxChargeQuery; use Payment\Query\Wx\WxRefundQuery; use Payment\Query\Wx\WxTransferQuery; use Payment\Query\Wx\WxRedQuery; class QueryContext { protected $query; public function initQuery($channel, array $config) { try { switch ($channel) { case Config::ALI_CHARGE: $this->query = new AliChargeQuery($config); break; case Config::ALI_REFUND: $this->query = new AliRefundQuery($config); break; case Config::ALI_TRANSFER: $this->query = new AliTransferQuery($config); break; case Config::WX_CHARGE: $this->query = new WxChargeQuery($config); break; case Config::WX_REFUND: $this->query = new WxRefundQuery($config); break; case Config::WX_TRANSFER: $this->query = new WxTransferQuery($config); break; case Config::WX_RED: $this->query = new WxRedQuery($config); break; case Config::CMB_CHARGE: $this->query = new CmbChargeQuery($config); break; case Config::CMB_REFUND: $this->query = new CmbRefundQuery($config); break; default: throw new PayException('当前仅支持：ALI_CHARGE ALI_REFUND WX_CHARGE WX_REFUND WX_TRANSFER WX_RED CMB_CHARGE CMB_REFUND'); } } catch (PayException $e) { throw $e; } } public function query(array $data) { if (! $this->query instanceof BaseStrategy) { throw new PayException('请检查初始化是否正确'); } try { return $this->query->handle($data); } catch (PayException $e) { throw $e; } } } 