<?php
/**
 * ------------------------ 
 *  版权所有  www.tecmz.com
 *  商业版本请购买正版授权使用
 * ------------------------
*/ namespace Module\Shop\Admin\Controller; use Illuminate\Routing\Controller; use ModStart\Admin\Auth\AdminPermission; use ModStart\Admin\Concern\HasAdminQuickCRUD; use ModStart\Admin\Layout\AdminConfigBuilder; use ModStart\Admin\Layout\AdminCRUDBuilder; use ModStart\Admin\Layout\AdminPage; use ModStart\Core\Dao\ModelUtil; use ModStart\Core\Exception\BizException; use ModStart\Core\Input\Request; use ModStart\Core\Input\Response; use ModStart\Core\Type\TypeUtil; use ModStart\Core\Util\ArrayUtil; use ModStart\Core\Util\CRUDUtil; use ModStart\Field\AbstractField; use ModStart\Field\AutoRenderedFieldValue; use ModStart\Form\Form; use ModStart\Grid\Displayer\ItemOperate; use ModStart\Grid\GridFilter; use ModStart\Repository\Filter\RepositoryFilter; use ModStart\Repository\RepositoryUtil; use ModStart\Support\Concern\HasFields; use ModStart\Widget\TextAjaxRequest; use ModStart\Widget\TextDialogRequest; use Module\Express\Util\ExpressUtil; use Module\Member\Util\MemberCmsUtil; use Module\Member\Util\MemberUtil; use Module\Shop\Util\GoodsUtil; use Module\Shop\Util\OrderUtil; use Module\Vendor\Type\OrderStatus; class OrderController extends Controller { use HasAdminQuickCRUD; protected function crud(AdminCRUDBuilder $P2vse) { $P2vse->init('order')->field(function ($P2vse) { $P2vse->id('id', '业务订单ID'); $P2vse->display('created_at', '时间'); $P2vse->display('sn', '订单号')->width(200); $P2vse->display('memberUserId', '用户')->hookRendering(function (AbstractField $jJyrp, $YaV4m, $DbHm9) { return MemberCmsUtil::showFromId($YaV4m->memberUserId); })->width(200); $P2vse->display('_goods', '商品')->hookRendering(function (AbstractField $jJyrp, $YaV4m, $DbHm9) { $Mzjiy = OrderUtil::getOrderInfo($YaV4m->id); return AutoRenderedFieldValue::makeView('module::Shop.View.admin.order.listGoodsItem', array('item' => $YaV4m, 'orderInfo' => $Mzjiy)); })->width(350); $P2vse->type('status', '状态')->type(OrderStatus::class)->editable(false); $P2vse->display('totalFee', '总价')->editable(true); $P2vse->decimal('payFee', '支付价格'); })->gridFilter(function (GridFilter $mHisM) { $mHisM->eq('id', '业务订单ID'); $mHisM->eq('sn', '订单号'); })->hookItemOperateRendering(function (ItemOperate $CVjnG) { $YaV4m = $CVjnG->item(); $CVjnG->getField()->width(300); switch ($YaV4m->status) { case OrderStatus::WAIT_PAY: goto GkJGm; GkJGm: $CVjnG->prepend(TextDialogRequest::primary('修改价格', action('\\' . __CLASS__ . '@edit', array('_id' => $YaV4m->id)))); goto YkvCj; b5O1v: break; goto pDZkl; YkvCj: $CVjnG->prepend(TextAjaxRequest::danger('关闭订单', action('\\' . __CLASS__ . '@cancel', array('_id' => $YaV4m->id)))); goto b5O1v; pDZkl: case OrderStatus::WAIT_SHIPPING: $CVjnG->prepend(TextDialogRequest::primary('确认发货', action('\\' . __CLASS__ . '@shipping', array('_id' => $YaV4m->id)))); break; case OrderStatus::WAIT_CONFIRM: goto ANPNR; L32ha: break; goto RYjd9; LkNp8: $CVjnG->prepend(TextDialogRequest::primary('修改物流', action('\\' . __CLASS__ . '@shipping', array('_id' => $YaV4m->id)))); goto L32ha; ANPNR: $CVjnG->prepend(TextAjaxRequest::primary('确认收货', action('\\' . __CLASS__ . '@confirm', array('_id' => $YaV4m->id)))); goto LkNp8; RYjd9: } $CVjnG->push(TextDialogRequest::make('primary', '详情/打印', action('\\' . __CLASS__ . '@detail', array('_id' => $YaV4m->id)))->size('big')); })->operateFixed('right')->title('订单管理')->canShow(false)->canDelete(false)->canAdd(false); } private function listForStatus($Zz43T) { goto nO29x; rt9bO: $W3CVY->gridFilter(function (GridFilter $mHisM) { $mHisM->clearFilter(); $mHisM->eq('id', L('ID')); $mHisM->eq('sn', '订单号'); }); goto FAFCj; UNquR: $W3CVY->build(); goto cd0u4; FAFCj: CRUDUtil::registerGridResource($W3CVY, '\\' . __CLASS__); goto s8qN1; Hsirf: return app(AdminPage::class)->pageTitle(TypeUtil::name(OrderStatus::class, $Zz43T))->body($W3CVY); goto VJt5w; s8qN1: if (Request::isPost()) { return $W3CVY->request(); } goto Hsirf; nO29x: $W3CVY = $this->grid(); goto UNquR; cd0u4: $W3CVY->repositoryFilter(function (RepositoryFilter $mHisM) use($Zz43T) { $mHisM->where('status', $Zz43T); }); goto rt9bO; VJt5w: } public function cancel() { goto npIes; xFq_0: switch ($v9Xk2['status']) { case OrderStatus::WAIT_PAY: ModelUtil::update('order', array('id' => $gZ39D), array('status' => OrderStatus::CANCEL)); return Response::redirect(CRUDUtil::jsGridRefresh()); } goto pb4uT; npIes: AdminPermission::demoCheck(); goto E521M; VSpWQ: $v9Xk2 = ModelUtil::get('order', array('id' => $gZ39D)); goto EvBZ7; E521M: $gZ39D = CRUDUtil::id(); goto VSpWQ; pb4uT: return Response::jsonError('订单状态错误'); goto ndPxj; EvBZ7: BizException::throwsIfEmpty('订单不存在', $v9Xk2); goto xFq_0; ndPxj: } public function confirm() { goto wVca1; ZaoSn: switch ($v9Xk2['status']) { case OrderStatus::WAIT_CONFIRM: ModelUtil::update('order', array('id' => $gZ39D), array('status' => OrderStatus::COMPLETED)); return Response::redirect(CRUDUtil::jsGridRefresh()); } goto tz8_0; wVca1: AdminPermission::demoCheck(); goto OCN4E; Dv9s7: BizException::throwsIfEmpty('订单不存在', $v9Xk2); goto ZaoSn; uw6Yj: $v9Xk2 = ModelUtil::get('order', array('id' => $gZ39D)); goto Dv9s7; OCN4E: $gZ39D = CRUDUtil::id(); goto uw6Yj; tz8_0: return Response::jsonError('订单状态错误'); goto aRE6w; aRE6w: } public function listWaitPay() { return $this->listForStatus(OrderStatus::WAIT_PAY); } public function listWaitShipping() { return $this->listForStatus(OrderStatus::WAIT_SHIPPING); } public function listWaitConfirm() { return $this->listForStatus(OrderStatus::WAIT_CONFIRM); } public function listCompleted() { return $this->listForStatus(OrderStatus::COMPLETED); } public function listCancelExpired() { return $this->listForStatus(OrderStatus::CANCEL_EXPIRED); } public function listCancel() { return $this->listForStatus(OrderStatus::CANCEL); } public function shipping(AdminConfigBuilder $P2vse) { goto l4Zml; dQL6X: $P2vse->select('shippingName', '物流公司')->options(ExpressUtil::listEnableMap()); goto wJCqw; LUTaI: $P2vse->pageTitle('物流设置'); goto dQL6X; wJCqw: $P2vse->text('shippingCode', '物流单号'); goto tnDPx; l4Zml: $v9Xk2 = ModelUtil::get('order', CRUDUtil::id()); goto x_NJT; GxXCW: $P2vse->useDialog(); goto LUTaI; tnDPx: $YaV4m = RepositoryUtil::itemFromArray(ArrayUtil::keepKeys($v9Xk2, array('shippingName', 'shippingCode'))); goto ElKn3; x_NJT: BizException::throwsIfEmpty('订单不存在', $v9Xk2); goto GxXCW; ElKn3: return $P2vse->perform($YaV4m, function (Form $NX6uw) { AdminPermission::demoCheck(); ModelUtil::update('order', CRUDUtil::id(), array_merge($NX6uw->dataForming(), array('status' => OrderStatus::WAIT_CONFIRM))); return Response::redirect(CRUDUtil::jsDialogCloseAndParentGridRefresh()); }); goto qM5Yp; qM5Yp: } public function detail() { goto a3dA8; Tv0I2: $QqUVI = MemberUtil::get($lLaeU['memberUserId']); goto mur6w; a3dA8: $lLaeU = OrderUtil::getOrderInfo(CRUDUtil::id()); goto Tv0I2; mur6w: return view('module::Shop.View.admin.order.detail', array('memberUser' => $QqUVI, 'record' => $lLaeU)); goto UjvIw; UjvIw: } }