@if(empty($records))
    <div class="ub-empty">
        <div class="icon"><i class="iconfont icon-empty-box"></i></div>
        <div class="text">暂无记录</div>
    </div>
@endif
<div class="row j-goods-list">
    @foreach($records as $record)
        <div class="col-md-3 col-6">
            <div class="margin-bottom tw-p-6 tw-bg-white hover:tw-shadow-lg tw-transform tw-duration-200 lg:hover:tw--translate-y-1">
                <a class="ub-cover-1-1" href="{{modstart_web_url('goods/'.$record['id'])}}" style="background-image:url({{\ModStart\Core\Assets\AssetsUtil::fix($record['cover'])}})"></a>
                <div class="tw-flex tw-pt-2">
                    <div class="tw-flex-grow tw-w-full">
                        <a href="{{modstart_web_url('goods/'.$record['id'])}}"
                           class="tw-block title tw-text-gray-900 tw-truncate tw-overflow-ellipsis tw-w-full tw-pr-8 tw-text-lg">{{$record['title']}}</a>
                        <div class="ub-text-primary margin-top">￥{{$record['price']}}</div>
                    </div>
                    <div>
                        <a href="{{modstart_web_url('goods/'.$record['id'])}}" class="tw-block tw-border ub-text-primary tw-w-8 tw-h-8 tw-leading-8 tw-text-center tw-border-solid tw-border-gray-200 ub-text-primary tw-rounded-full tw--ml-8 ub-border-primary">
                            <i class="iconfont icon-cart "></i>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    @endforeach
</div>
