@extends($_viewFrame)

@section('pageTitleMain')提交订单@endsection
@section('pageKeywords')提交订单@endsection
@section('pageDescription')提交订单@endsection

@section('bodyContent')

    <div class="ub-container">

        <div class="ub-breadcrumb">
            <a href="{{modstart_web_url('goods')}}">商品</a>
            <a href="{{modstart_web_url('cart')}}">我的购物车</a>
            <a class="active" href="{{modstart_web_url('cart/checkout')}}">提交订单</a>
        </div>

        <div style="max-width:800px;margin:0 auto;">
            <form action="{{modstart_api_url('cart/checkout')}}" data-ajax-form method="post">
                <div class="ub-panel">
                    <div class="head">
                        <div class="title">收货地址</div>
                    </div>
                    <div class="body">
                        <div class="row">
                            <script>
                                window.__grids = {
                                    get:function(index){
                                        return {
                                            lister:{
                                                refresh:function () {
                                                    window.location.reload();
                                                }
                                            }
                                        };
                                    }
                                };
                            </script>
                            @foreach($memberAddressList as $memberAddressIndex=>$memberAddress)
                                <div class="col-md-6">
                                    <div class="tw-bg-white tw-rounded-lg tw-mb-2 tw-box tw-px-5 tw-py-3 tw-mb-3 tw-zoom-in tw-border-2 tw-border-solid tw-border-gray-100"
                                        onclick="$(this).find('input').prop('checked',true);">
                                        <div class="tw-flex tw-items-center">
                                            <div class="tw-mr-2">
                                                <input type="radio" name="addressId" @if(!$memberAddressIndex) checked @endif value="{{$memberAddress['id']}}" />
                                            </div>
                                            <div class="tw-font-medium">
                                                {{$memberAddress['name']}}
                                            </div>
                                            <div class="tw-flex-grow tw-text-right">
                                                <i class="iconfont icon-phone"></i>
                                                {{$memberAddress['phone']}}
                                            </div>
                                        </div>
                                        <div class="tw-pt-2 tw-text-gray-400">
                                            {{$memberAddress['area']}}
                                            {{$memberAddress['detail']}}
                                            {{$memberAddress['post']}}
                                        </div>
                                        <div class="tw-text-right">
                                            <a href="javascript:;" data-dialog-request="{{modstart_web_url('member_address/edit?_id='.$memberAddress['id'])}}" class="ub-lister-action ub-text-muted">编辑</a>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                            <div class="col-md-6">
                                <div class="tw-bg-white tw-rounded-lg tw-mb-2 tw-box tw-px-5 tw-py-3 tw-mb-3 tw-zoom-in tw-border-2 tw-border-solid tw-border-gray-100" data-repeat="3">
                                    <a style="line-height:72px;display:block;color:#999;text-align:center;" href="javascript:;" data-dialog-request="{{modstart_web_url('member_address/add')}}">
                                        添加新地址
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="ub-panel">
                    <div class="head">
                        <div class="title">商品信息</div>
                    </div>
                    <div class="body">
                        @foreach($carts as $cart)
                            <div class="tw-bg-white tw-mb-2 tw-rounded-sm tw-border-solid tw-border-gray-100 tw-border-0 tw-border-b">
                                <div class="tw-p-2">
                                    <div class="tw-p-2 tw-flex">
                                        <div class="tw-w-16 tw-flex-shrink-0">
                                            <div class="ub-cover-1-1" style="background-image:url({{\ModStart\Core\Assets\AssetsUtil::fix($cart['_goods']['cover'])}})"></div>
                                        </div>
                                        <div class="tw-flex-grow tw-pl-2">
                                            <div class="">{{$cart['_goods']['title']}}</div>
                                            <div class="tw-text-gray-400">
                                                @if(!empty($cart['spec']))
                                                    @foreach($cart['spec'] as $k=>$v)
                                                        {{$k}}：{{$v}}
                                                    @endforeach
                                                @endif
                                            </div>
                                        </div>
                                        <div class="tw-w-16 tw-flex-shrink-0 tw-text-right">
                                            <div class="tw-text-black tw-text-sm">￥{{$cart['goodsSpecPrice']}}</div>
                                            <div class="tw-text-gray-400">x{{$cart['amount']}}</div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
                <div class="ub-panel">
                    <div class="head">
                        <div class="title">订单结算</div>
                    </div>
                    <div class="body">
                        @if(modstart_module_enabled('Voucher') && !empty($voucherItemList))
                            <div class="ub-pair">
                                <div class="name">优惠券</div>
                                <div class="value">
                                    @foreach($voucherItemList as $voucherItem)
                                        <label class="tw-inline-block tw-bg-yellow-100 tw-rounded tw-leading-8 tw-px-2 tw-b-1 tw-text-yellow-600">
                                            <input type="checkbox" data-voucher-item name="voucherItemUsed[]" class="tw-align-middle" @if(!empty($voucherItemIdsUsed)&&in_array($voucherItem['id'],$voucherItemIdsUsed)) checked @endif value="{{$voucherItem['id']}}" />
                                            {{$voucherItem['_voucher']['title']}}
                                        </label>
                                    @endforeach
                                </div>
                            </div>
                            <script>
                                $(function(){
                                    $('[data-voucher-item]').on('change',function(){
                                        var voucherItemIds = [];
                                        $('[data-voucher-item]:checked').each(function(i,o){
                                            voucherItemIds.push($(o).val());
                                        });
                                        $('[data-fee-total]').text('-');
                                        $('[data-fee-shipping]').text('-');
                                        $('[data-fee-all]').text('-');
                                        MS.api.post('{{modstart_api_url('cart/checkout_voucher')}}',{voucherItemIds:voucherItemIds.join(',')},function(res){
                                            MS.api.defaultCallback(res,{
                                                success:function(res){
                                                    $('[data-fee-total]').text(res.data.feeTotal);
                                                    $('[data-fee-shipping]').text(res.data.feeShipping);
                                                    $('[data-fee-all]').text(res.data.feeAll);
                                                }
                                            });
                                        });
                                    });
                                });
                            </script>
                        @endif
                        <div class="ub-pair">
                            <div class="name">总费用</div>
                            <div class="value">￥<span data-fee-total>{{sprintf('%.2f',$feeTotal)}}</span></div>
                        </div>
                        <div class="ub-pair">
                            <div class="name">邮费</div>
                            <div class="value">￥<span data-fee-shipping>{{sprintf('%.2f',$feeShipping)}}</span></div>
                        </div>
                        <div class="ub-pair">
                            <div class="name">合集</div>
                            <div class="value ub-text-primary ub-text-bold">￥<span  data-fee-all>{{sprintf('%.2f',$feeAll)}}</span></div>
                        </div>
                        <div class="margin-top tw-text-center">
                            <button class="btn btn-lg btn-primary" type="submit">提交支付</button>
                        </div>
                    </div>
                </div>
            </form>
        </div>

    </div>

@endsection





