@extends($_viewFrame)

@if($keywords)
    @section('pageTitleMain'){{'搜索“'.$keywords.'”'}}@endsection
    @section('pageKeywords'){{'搜索“'.$keywords.'”'}}@endsection
    @section('pageDescription'){{'搜索“'.$keywords.'”'}}@endsection
@elseif($currentCategory)
    @section('pageTitleMain'){{$currentCategory['title']}}@endsection
    @section('pageKeywords'){{$currentCategory['title']}}@endsection
    @section('pageDescription'){{$currentCategory['title']}}@endsection
@else
    @section('pageTitleMain')商品@endsection
    @section('pageKeywords')商品@endsection
    @section('pageDescription')商品@endsection
@endif

{!! \ModStart\ModStart::js('asset/vendor/jqueryMark.js') !!}
{!! \ModStart\ModStart::style('[data-markjs]{color:red !important;background:transparent;}') !!}
{!! \ModStart\ModStart::script("$('.j-goods-list .title').mark(".\ModStart\Core\Util\SerializeUtil::jsonEncode($keywords).",{});") !!}

@section('bodyContent')

    <div class="ub-container">

        @if($keywords)
            <div class="tw-p-4 tw-rounded tw-bg-white margin-top">
                <div class="ub-search-block-a">
                    <input class="input" type="text" value="{{$keywords}}" placeholder="搜索 内容" onkeypress="if(event.keyCode===13){window.location.href='{{modstart_web_url('goods')}}?keywords='+window.api.util.urlencode($(this).val());}" />
                    <a class="search-btn" href="javascript:;"
                       onclick="window.location.href='{{modstart_web_url('goods')}}?keywords='+window.api.util.urlencode($(this).prev().val());">
                        <span class="iconfont icon-search"></span>
                        搜索
                    </a>
                </div>
                <div class="tw-mt-4">
                    搜索 <span class="ub-text-primary">{{$keywords}}</span> ，共找到 <span class="ub-text-primary">{{$total}}</span> 条记录
                </div>
            </div>
        @else
            <div class="ub-nav margin-top">
                <a class="item @if(!$currentCategory) active @endif" href="{{modstart_web_url('goods')}}">全部</a>
                @foreach($categoryTree as $item)
                    <a class="item @if($currentCategory && ($currentCategory['id']==$item['id']||$currentCategory['pid']==$item['id'])) active @endif" href="?categoryId={{$item['id']}}">{{$item['title']}}</a>
                @endforeach
            </div>
            @foreach($categoryTree as $item)
                @if($currentCategory && ($currentCategory['id']==$item['id'] || $currentCategory['pid']==$item['id']))
                    <div class="ub-nav tw-border-t tw-border-0 tw-border-solid tw-border-gray-100">
                        <a class="item @if($currentCategory && $currentCategory['id']==$item['id']) active @endif" href="?categoryId={{$item['pid']}}">全部</a>
                        @if(!empty($item['_child']))
                            @foreach($item['_child'] as $item2)
                                <a class="item @if($currentCategory['id']==$item2['id']) active @endif" href="?categoryId={{$item2['id']}}">{{$item2['title']}}</a>
                            @endforeach
                        @endif
                    </div>
                @endif
            @endforeach
        @endif

        <div class="ub-panel transparent margin-top">
            <div class="body margin-top">
                @include('module::Shop.View.inc.goodsRecords',['records'=>$records])
            </div>
        </div>

        <div class="ub-page">
            {!! $pageHtml !!}
        </div>

    </div>

@endsection

