@extends($_viewFrame)

@section('pageTitle'){{modstart_config('siteName').' - '.modstart_config('siteSlogan')}}@endsection

@section('bodyContent')

    {!! \ModStart\ModStart::css('vendor/Shop/style/shop.css') !!}
    <div class="ub-container margin-top">
        <div class="pb-home-banner">
            <div class="left-menu">
                @foreach(\Module\Shop\Util\GoodsCategoryUtil::tree() as $category)
                    <div class="item">
                        <a href="{{modstart_web_url('goods',['categoryId'=>$category['id']])}}" class="item-title">
                            <i class="iconfont icon-angle-right"></i>
                            {{$category['title']}}
                        </a>
                        <div class="item-children">
                            <div class="row">
                                @if(!empty($category['_child']))
                                    @foreach($category['_child'] as $c)
                                        <div class="col-md-3">
                                            <a class="child-item" href="{{modstart_web_url('goods',['categoryId'=>$c['id']])}}">
                                                <span class="cover ub-cover-1-1 tw-w-8" style="background-image:url( {{\ModStart\Core\Assets\AssetsUtil::fix($c['cover'])}} );"></span>
                                                <span class="text">{{$c['title']}}</span>
                                            </a>
                                        </div>
                                    @endforeach
                                @endif
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
            <div class="right-banner">
                {!! \Module\Banner\View\BannerView::basic('shopHome') !!}
            </div>
        </div>
    </div>

    @if(modstart_module_enabled('Ad'))
        <div class="ub-container margin-top">
            {!! \Module\Ad\View\AdView::simple('shopHome') !!}
        </div>
    @endif


    <?php $recommends = \Module\Shop\Util\GoodsUtil::recommendGoods(); ?>
    @if(!empty($recommends))
        <div class="ub-container margin-top">
            <div class="ub-panel transparent">
                <div class="head">
                    <div class="title">
                        <i class="iconfont icon-gift"></i>
                        推荐
                    </div>
                </div>
                <div class="body">
                    @include('module::Shop.View.inc.goodsRecords',['records'=>$recommends])
                </div>
            </div>
        </div>
    @endif

    @foreach(\Module\Shop\Util\GoodsCategoryUtil::treeHome() as $category)
        <div class="ub-container margin-top">
            <div class="ub-panel transparent">
                <div class="head">
                    <div class="more">
                        <a href="{{modstart_web_url('goods',['categoryId'=>$category['id']])}}" class="ub-text-muted">
                            查看更多
                            <i class="iconfont icon-angle-right"></i>
                        </a>
                    </div>
                    <div class="title">{{$category['title']}}</div>
                </div>
                <div class="body">
                    @include('module::Shop.View.inc.goodsRecords',['records'=>\Module\Shop\Util\GoodsUtil::listLatestByCategoryId($category['id'],4)])
                </div>
            </div>
        </div>
    @endforeach

    @if(modstart_module_enabled('Partner'))
        <div class="ub-container">
            {!! \Module\Partner\View\PartnerView::simple(\Module\Shop\Provider\ShopPartnerPositionProvider::NAME) !!}
        </div>
    @endif

@endsection
