<?php
/**
 * ------------------------ 
 *  版权所有  www.tecmz.com
 *  商业版本请购买正版授权使用
 * ------------------------
*/ namespace Illuminate\Database\Schema\Grammars; use Illuminate\Support\Fluent; use Illuminate\Database\Connection; use Illuminate\Database\Schema\Blueprint; class MySqlGrammar extends Grammar { protected $modifiers = array('Unsigned', 'Charset', 'Collate', 'Nullable', 'Default', 'Increment', 'Comment', 'After', 'First'); protected $serials = array('bigInteger', 'integer', 'mediumInteger', 'smallInteger', 'tinyInteger'); public function compileTableExists() { return 'select * from information_schema.tables where table_schema = ? and table_name = ?'; } public function compileColumnExists() { return 'select column_name as `column_name` from information_schema.columns where table_schema = ? and table_name = ?'; } public function compileCreate(Blueprint $Z3DzT, Fluent $oC2Lv, Connection $GU5eI) { goto KiQXa; KiQXa: $MP7eK = implode(', ', $this->getColumns($Z3DzT)); goto YXkYB; YXkYB: $NZxnR = $Z3DzT->temporary ? 'create temporary' : 'create'; goto uz3iS; vBwGL: return $NZxnR; goto XZbEe; uz3iS: $NZxnR .= ' table ' . $this->wrapTable($Z3DzT) . " ({$MP7eK})"; goto MoU8T; MoU8T: $NZxnR = $this->compileCreateEncoding($NZxnR, $GU5eI, $Z3DzT); goto iNfoB; iNfoB: if (isset($Z3DzT->engine)) { $NZxnR .= ' engine = ' . $Z3DzT->engine; } goto vBwGL; XZbEe: } protected function compileCreateEncoding($NZxnR, Connection $GU5eI, Blueprint $Z3DzT) { goto n_aJu; TkqT2: if (isset($Z3DzT->collation)) { $NZxnR .= ' collate ' . $Z3DzT->collation; } elseif (!is_null($dOdSh = $GU5eI->getConfig('collation'))) { $NZxnR .= ' collate ' . $dOdSh; } goto n95t1; n95t1: return $NZxnR; goto FCrfL; n_aJu: if (isset($Z3DzT->charset)) { $NZxnR .= ' default character set ' . $Z3DzT->charset; } elseif (!is_null($goNXp = $GU5eI->getConfig('charset'))) { $NZxnR .= ' default character set ' . $goNXp; } goto TkqT2; FCrfL: } public function compileAdd(Blueprint $Z3DzT, Fluent $oC2Lv) { goto vPmp4; FOhqc: return 'alter table ' . $loNjC . ' ' . implode(', ', $MP7eK); goto ibw3s; vPmp4: $loNjC = $this->wrapTable($Z3DzT); goto UHIkE; UHIkE: $MP7eK = $this->prefixArray('add', $this->getColumns($Z3DzT)); goto FOhqc; ibw3s: } public function compilePrimary(Blueprint $Z3DzT, Fluent $oC2Lv) { $oC2Lv->name(null); return $this->compileKey($Z3DzT, $oC2Lv, 'primary key'); } public function compileUnique(Blueprint $Z3DzT, Fluent $oC2Lv) { return $this->compileKey($Z3DzT, $oC2Lv, 'unique'); } public function compileIndex(Blueprint $Z3DzT, Fluent $oC2Lv) { return $this->compileKey($Z3DzT, $oC2Lv, 'index'); } protected function compileKey(Blueprint $Z3DzT, Fluent $oC2Lv, $BYzWI) { goto Vnd_S; AflX3: return "alter table {$loNjC} add {$BYzWI} `{$oC2Lv->index}`({$MP7eK})"; goto euYyo; jwFAE: $loNjC = $this->wrapTable($Z3DzT); goto AflX3; Vnd_S: $MP7eK = $this->columnize($oC2Lv->columns); goto jwFAE; euYyo: } public function compileDrop(Blueprint $Z3DzT, Fluent $oC2Lv) { return 'drop table ' . $this->wrapTable($Z3DzT); } public function compileDropIfExists(Blueprint $Z3DzT, Fluent $oC2Lv) { return 'drop table if exists ' . $this->wrapTable($Z3DzT); } public function compileDropColumn(Blueprint $Z3DzT, Fluent $oC2Lv) { goto uhWHb; E5qcU: return 'alter table ' . $loNjC . ' ' . implode(', ', $MP7eK); goto iMwPG; uhWHb: $MP7eK = $this->prefixArray('drop', $this->wrapArray($oC2Lv->columns)); goto MvlwD; MvlwD: $loNjC = $this->wrapTable($Z3DzT); goto E5qcU; iMwPG: } public function compileDropPrimary(Blueprint $Z3DzT, Fluent $oC2Lv) { return 'alter table ' . $this->wrapTable($Z3DzT) . ' drop primary key'; } public function compileDropUnique(Blueprint $Z3DzT, Fluent $oC2Lv) { $loNjC = $this->wrapTable($Z3DzT); return "alter table {$loNjC} drop index `{$oC2Lv->index}`"; } public function compileDropIndex(Blueprint $Z3DzT, Fluent $oC2Lv) { $loNjC = $this->wrapTable($Z3DzT); return "alter table {$loNjC} drop index `{$oC2Lv->index}`"; } public function compileDropForeign(Blueprint $Z3DzT, Fluent $oC2Lv) { $loNjC = $this->wrapTable($Z3DzT); return "alter table {$loNjC} drop foreign key `{$oC2Lv->index}`"; } public function compileRename(Blueprint $Z3DzT, Fluent $oC2Lv) { $E_44J = $this->wrapTable($Z3DzT); return "rename table {$E_44J} to " . $this->wrapTable($oC2Lv->to); } protected function typeChar(Fluent $GR5Ef) { return "char({$GR5Ef->length})"; } protected function typeString(Fluent $GR5Ef) { return "varchar({$GR5Ef->length})"; } protected function typeText(Fluent $GR5Ef) { return 'text'; } protected function typeMediumText(Fluent $GR5Ef) { return 'mediumtext'; } protected function typeLongText(Fluent $GR5Ef) { return 'longtext'; } protected function typeBigInteger(Fluent $GR5Ef) { return 'bigint'; } protected function typeInteger(Fluent $GR5Ef) { return 'int'; } protected function typeMediumInteger(Fluent $GR5Ef) { return 'mediumint'; } protected function typeTinyInteger(Fluent $GR5Ef) { return 'tinyint'; } protected function typeSmallInteger(Fluent $GR5Ef) { return 'smallint'; } protected function typeFloat(Fluent $GR5Ef) { return $this->typeDouble($GR5Ef); } protected function typeDouble(Fluent $GR5Ef) { if ($GR5Ef->total && $GR5Ef->places) { return "double({$GR5Ef->total}, {$GR5Ef->places})"; } return 'double'; } protected function typeDecimal(Fluent $GR5Ef) { return "decimal({$GR5Ef->total}, {$GR5Ef->places})"; } protected function typeBoolean(Fluent $GR5Ef) { return 'tinyint(1)'; } protected function typeEnum(Fluent $GR5Ef) { return 'enum(\'' . implode('\', \'', $GR5Ef->allowed) . '\')'; } protected function typeJson(Fluent $GR5Ef) { return 'text'; } protected function typeJsonb(Fluent $GR5Ef) { return 'text'; } protected function typeDate(Fluent $GR5Ef) { return 'date'; } protected function typeDateTime(Fluent $GR5Ef) { return 'datetime'; } protected function typeDateTimeTz(Fluent $GR5Ef) { return 'datetime'; } protected function typeTime(Fluent $GR5Ef) { return 'time'; } protected function typeTimeTz(Fluent $GR5Ef) { return 'time'; } protected function typeTimestamp(Fluent $GR5Ef) { goto yGRhA; uM7g2: return 'timestamp'; goto M39sB; yGRhA: if ($GR5Ef->useCurrent) { return 'timestamp default CURRENT_TIMESTAMP'; } goto lnVbm; lnVbm: if (!$GR5Ef->nullable && $GR5Ef->default === null) { return 'timestamp default 0'; } goto uM7g2; M39sB: } protected function typeTimestampTz(Fluent $GR5Ef) { goto Mv2se; dUmDR: if (!$GR5Ef->nullable && $GR5Ef->default === null) { return 'timestamp default 0'; } goto Me0XB; Me0XB: return 'timestamp'; goto zXk13; Mv2se: if ($GR5Ef->useCurrent) { return 'timestamp default CURRENT_TIMESTAMP'; } goto dUmDR; zXk13: } protected function typeBinary(Fluent $GR5Ef) { return 'blob'; } protected function typeUuid(Fluent $GR5Ef) { return 'char(36)'; } protected function modifyUnsigned(Blueprint $Z3DzT, Fluent $GR5Ef) { if ($GR5Ef->unsigned) { return ' unsigned'; } } protected function modifyCharset(Blueprint $Z3DzT, Fluent $GR5Ef) { if (!is_null($GR5Ef->charset)) { return ' character set ' . $GR5Ef->charset; } } protected function modifyCollate(Blueprint $Z3DzT, Fluent $GR5Ef) { if (!is_null($GR5Ef->collation)) { return ' collate ' . $GR5Ef->collation; } } protected function modifyNullable(Blueprint $Z3DzT, Fluent $GR5Ef) { return $GR5Ef->nullable ? ' null' : ' not null'; } protected function modifyDefault(Blueprint $Z3DzT, Fluent $GR5Ef) { if (!is_null($GR5Ef->default)) { return ' default ' . $this->getDefaultValue($GR5Ef->default); } } protected function modifyIncrement(Blueprint $Z3DzT, Fluent $GR5Ef) { if (in_array($GR5Ef->type, $this->serials) && $GR5Ef->autoIncrement) { return ' auto_increment primary key'; } } protected function modifyFirst(Blueprint $Z3DzT, Fluent $GR5Ef) { if (!is_null($GR5Ef->first)) { return ' first'; } } protected function modifyAfter(Blueprint $Z3DzT, Fluent $GR5Ef) { if (!is_null($GR5Ef->after)) { return ' after ' . $this->wrap($GR5Ef->after); } } protected function modifyComment(Blueprint $Z3DzT, Fluent $GR5Ef) { if (!is_null($GR5Ef->comment)) { return ' comment "' . $GR5Ef->comment . '"'; } } protected function wrapValue($cBDsM) { if ($cBDsM === '*') { return $cBDsM; } return '`' . str_replace('`', '``', $cBDsM) . '`'; } }