<?php
/**
 * ------------------------ 
 *  版权所有  www.tecmz.com
 *  商业版本请购买正版授权使用
 * ------------------------
*/ namespace ModStart\Admin\Controller; use Illuminate\Routing\Controller; use Illuminate\Support\Str; use ModStart\Admin\Auth\Admin; use ModStart\Admin\Auth\AdminPermission; use ModStart\Admin\Concern\HasAdminCRUD; use ModStart\Admin\Model\AdminUser; use ModStart\Admin\Provider\AdminUserConfigProvider; use ModStart\Core\Exception\BizException; use ModStart\Core\Util\ConvertUtil; use ModStart\Core\Util\CRUDUtil; use ModStart\Core\Util\RandomUtil; use ModStart\Core\Util\RenderUtil; use ModStart\Detail\Detail; use ModStart\Field\AbstractField; use ModStart\Form\Form; use ModStart\Grid\Displayer\ItemOperate; use ModStart\Grid\Grid; use ModStart\Grid\GridFilter; class AdminUserController extends Controller { use HasAdminCRUD; protected function grid() { goto hZttL; hZttL: $H0Ja4 = new Grid(AdminUser::class, function (Grid $H0Ja4) { $H0Ja4->display('id', L('ID'))->sortable(true)->width(80); $H0Ja4->text('username', L('Username')); if (modstart_config('AdminManagerEnhance_EnablePhone', false)) { $H0Ja4->text('phone', L('Phone')); } if (modstart_config('AdminManagerEnhance_EnableEmail', false)) { $H0Ja4->text('email', L('Email')); } $H0Ja4->tags('roles', L('Roles'))->hookFormatValue(function ($cBDsM, AbstractField $Ldet7) { $P1uVJ = $Ldet7->item(); if (AdminPermission::isFounder($P1uVJ->id)) { return array(L('Admin Founder')); } return collect($cBDsM)->pluck('name')->toArray(); }); if (!AdminUserConfigProvider::isEmpty()) { $H0Ja4->display('config', '配置')->hookRendering(function (AbstractField $Ldet7, $P1uVJ, $C6OV7) { return RenderUtil::view('modstart::admin.user.configGrid', array('item' => $P1uVJ)); }); } $H0Ja4->text('lastLoginTime', L('Last Login Time')); $H0Ja4->text('lastLoginIp', L('Last Login Ip')); $H0Ja4->gridFilter(function (GridFilter $DMbpM) { $DMbpM->eq('id', L('ID')); $DMbpM->like('username', L('Username')); }); $H0Ja4->hookItemOperateRendering(function (ItemOperate $YfCSR) { if (AdminPermission::isFounder($YfCSR->item()->id)) { $YfCSR->canDelete(false); } }); }); goto YI3FA; y7B72: return $H0Ja4; goto JRJmx; ivhRo: $H0Ja4->title(L('Admin User')); goto y7B72; YI3FA: if (AdminPermission::isNotPermit('AdminUserManage')) { $H0Ja4->canAdd(false)->canEdit(false)->canDelete(false); } goto ivhRo; JRJmx: } protected function form() { goto kjloM; tQ_WK: $dBWZm->title(L('Admin User')); goto BygO0; BygO0: return $dBWZm; goto SLzvS; Rk3Eb: if (AdminPermission::isNotPermit('AdminUserManage')) { $dBWZm->canAdd(false)->canEdit(false)->canDelete(false); } goto tQ_WK; kjloM: $dBWZm = new Form(AdminUser::class, function (Form $dBWZm) { $dBWZm->text('username', L('Username'))->required()->rules('unique:admin_user,username,' . CRUDUtil::id()); $dBWZm->text('password', L('Password'))->rules($dBWZm->isModeAdd() ? 'required' : '')->placeholder($dBWZm->isModeAdd() ? '' : L('Keep Old Password If Empty'))->value($dBWZm->isModeAdd() ? RandomUtil::string(6) : '')->hookFormatValue(function ($cBDsM, AbstractField $Ldet7) { return ''; }); if (modstart_config('AdminManagerEnhance_EnablePhone', false)) { $dBWZm->text('phone', L('Phone'))->ruleUnique('admin_user'); } if (modstart_config('AdminManagerEnhance_EnableEmail', false)) { $dBWZm->text('email', L('Email'))->ruleUnique('admin_user'); } $P1uVJ = $dBWZm->item(); $Ll3S0 = $dBWZm->checkbox('roles', L('Roles'))->optionModel('admin_role')->hookValueUnserialize(function ($cBDsM, AbstractField $Ldet7) { return $cBDsM->map(function ($rGypx) { return $rGypx['id']; }); })->hookValueSerialize(function ($cBDsM, AbstractField $Ldet7) { return ConvertUtil::toArray($cBDsM); }); if ($dBWZm->isModeEdit() && AdminPermission::isFounder($P1uVJ->id)) { $Ll3S0->editable(false); } if (!AdminUserConfigProvider::isEmpty()) { $dBWZm->display('config', '配置')->hookRendering(function (AbstractField $Ldet7, $P1uVJ, $C6OV7) { return RenderUtil::view('modstart::admin.user.configForm', array('item' => $P1uVJ)); })->formShowOnly(true); } $dBWZm->display('created_at', L('Created At'))->editable(true); $dBWZm->hookSaving(function (Form $dBWZm) { if ($dBWZm->isModeAdd()) { goto GTb5c; GTb5c: $dTnlu = $dBWZm->dataAdding(); goto yb_tr; sgHM_: $dBWZm->dataAdding($dTnlu); goto dBJmH; H4ta8: $dTnlu['password'] = Admin::passwordEncrypt($dTnlu['password'], $dTnlu['passwordSalt']); goto sgHM_; yb_tr: $dTnlu['passwordSalt'] = Str::random(16); goto H4ta8; dBJmH: } else { if ($dBWZm->isModeEdit()) { goto uzQgm; uzQgm: $dTnlu = $dBWZm->dataEditing(); goto j4BFO; JOMhO: $dBWZm->dataEditing($dTnlu); goto zRzZU; j4BFO: if ($dTnlu['password']) { $dTnlu['passwordSalt'] = Str::random(16); $dTnlu['password'] = Admin::passwordEncrypt($dTnlu['password'], $dTnlu['passwordSalt']); } else { unset($dTnlu['password']); } goto JOMhO; zRzZU: } } }); $dBWZm->hookDeleting(function (Form $dBWZm) { $dBWZm->item()->each(function ($P1uVJ) { if (AdminPermission::isFounder($P1uVJ->id)) { BizException::throws(L('Admin Founder Delete Forbidden')); } }); }); $dBWZm->hookSaved(function (Form $dBWZm) { $P1uVJ = $dBWZm->item(); foreach (AdminUserConfigProvider::listAll() as $HPglu) { $HPglu->saved($P1uVJ); } }); $dBWZm->hookDeleted(function (Form $dBWZm) { $dBWZm->item()->each(function ($P1uVJ) { foreach (AdminUserConfigProvider::listAll() as $HPglu) { $HPglu->deleted($P1uVJ); } }); }); }); goto Rk3Eb; SLzvS: } protected function detail() { goto QIrK3; TleE6: return $MSE_o; goto fWiFe; QIrK3: $MSE_o = new Detail(AdminUser::class, function (Detail $MSE_o) { $MSE_o->display('id', L('ID')); $MSE_o->text('username', L('Username')); if (modstart_config('AdminManagerEnhance_EnablePhone', false)) { $MSE_o->text('phone', L('Phone')); } if (modstart_config('AdminManagerEnhance_EnableEmail', false)) { $MSE_o->text('email', L('Email')); } $MSE_o->tags('roles', L('Roles'))->hookFormatValue(function ($cBDsM, AbstractField $Ldet7) { $P1uVJ = $Ldet7->item(); if (AdminPermission::isFounder($P1uVJ->id)) { return array(L('Admin Founder')); } return collect($cBDsM)->pluck('name')->toArray(); }); if (!AdminUserConfigProvider::isEmpty()) { $MSE_o->display('config', '配置')->hookRendering(function (AbstractField $Ldet7, $P1uVJ, $C6OV7) { return RenderUtil::view('modstart::admin.user.configDetail', array('item' => $P1uVJ)); }); } $MSE_o->display('created_at', L('Created At')); $MSE_o->display('updated_at', L('Updated At')); }); goto migtN; migtN: $MSE_o->title(L('Admin User')); goto TleE6; fWiFe: } }