<?php
/**
 * ------------------------ 
 *  版权所有  www.tecmz.com
 *  商业版本请购买正版授权使用
 * ------------------------
*/ namespace Module\Tracking\Admin\Controller; use Illuminate\Routing\Controller; use Maatwebsite\Excel\Facades\Excel; use ModStart\Admin\Auth\AdminPermission; use ModStart\Admin\Concern\HasAdminQuickCRUD; use ModStart\Admin\Layout\AdminCRUDBuilder; use ModStart\Admin\Layout\AdminPage; use ModStart\Core\Dao\ModelUtil; use ModStart\Core\Exception\BizException; use ModStart\Core\Input\Request; use ModStart\Core\Input\Response; use ModStart\Core\Util\RandomUtil; use ModStart\Field\AbstractField; use ModStart\Field\Type\FieldRenderMode; use ModStart\Form\Form; use ModStart\Grid\GridFilter; use ModStart\ModStart; use ModStart\Support\Concern\HasFields; use ModStart\Widget\Box; use Module\Tracking\Type\CodeBatchIdentityType; use Module\Tracking\Type\CodeCreateCodeType; use Module\Tracking\Type\CodeTransportCodeType; use Module\Tracking\Type\CodeVerifyCodeType; use Module\Tracking\Util\CodeUtil; class CodeController extends Controller { use HasAdminQuickCRUD; protected function crud(AdminCRUDBuilder $P0Vsm) { ModStart::js('asset/common/qrcode.js'); $P0Vsm->init('tracking_code')->field(function ($P0Vsm) { $P0Vsm->id('id', 'ID'); $P0Vsm->text('code', '防伪码')->required()->ruleUnique('tracking_code')->hookRendering(function (AbstractField $aR4e2, $lDvaK, $POXOb) { switch ($aR4e2->renderMode()) { case FieldRenderMode::GRID: goto POxei; JNS0B: $sdWRv = "<a href='javascript:;' data-qrcode-content='{$g07a9}'><i class='iconfont icon-qr-code'></i></a>"; goto rcJvx; POxei: $g07a9 = Request::domainUrl() . modstart_web_url('tracking/show/code_' . $lDvaK->code); goto JNS0B; rcJvx: return '<code>' . $lDvaK->code . "</code> {$sdWRv}"; goto dRPNB; dRPNB: } })->width(200); $P0Vsm->text('batch', '批次')->required(); $P0Vsm->text('verifyCode', '校验码'); $P0Vsm->text('transportCode', '物流码')->required()->ruleUnique('tracking_code'); $P0Vsm->select('productId', '产品')->required()->optionModel('tracking_product', 'id', 'title'); $P0Vsm->select('agentId', '经销商')->required()->optionModel('tracking_agent', 'id', 'name'); $P0Vsm->switch('enable', '启用')->required()->optionsYesNo(); $P0Vsm->datetime('enableTime', '启用时间'); $P0Vsm->display('created_at', L('Created At'))->listable(false); $P0Vsm->display('updated_at', L('Updated At'))->listable(false); })->gridFilter(function (GridFilter $roX32) { $roX32->eq('id', L('ID')); $roX32->like('code', '防伪码'); $roX32->like('batch', '批次'); $roX32->like('transportCode', '物流码'); })->title('防伪码'); } public function create(AdminPage $DNh5u) { goto vIqxR; bqIwc: $ypG_B->text('codePrefix', '防伪码前缀')->defaultValue('')->help('如 CODE，建议2-4位,如果不要，可以不填写'); goto qW6Fu; UYcaJ: $ypG_B->select('agentId', '产品所属经销商')->optionModel('tracking_agent', 'id', 'name')->help('可在防伪码不变的情况下批量修改。'); goto Tn5IE; DFtVR: $ypG_B->number('count', '生成数量')->defaultValue(1)->help('建议一次生成10万条以内。')->required(); goto NnkK8; dZqKp: $ypG_B->text('batch', '生成批次')->defaultValue(date('YmdHis'))->help('自动按时间生成,也可手工指定，方便溯源按批次调用等。')->required(); goto bBaUg; MPYeB: $ypG_B->select('verifyCodeType', '校验码样式')->optionType(CodeVerifyCodeType::class)->defaultValue(CodeVerifyCodeType::NONE)->when('!=', CodeVerifyCodeType::NONE, function (Form $ypG_B) { $ypG_B->number('verifyCodeLength', '校验码长度')->defaultValue(6)->help('物流码可辅助防伪码管理等操作'); }); goto a7nx1; vIqxR: $ypG_B = Form::make('')->formClass('wide'); goto dZqKp; qW6Fu: $ypG_B->number('codeLength', '防伪码长度')->defaultValue(12)->help('建议8-18位，改长度为包含前缀的长度')->required(); goto MPYeB; mMIEw: if (Request::isPost()) { return $ypG_B->formRequest(function (Form $ypG_B) { AdminPermission::demoCheck(); $xJzrK = $ypG_B->dataForming(); $xJzrK['codePrefix'] = trim($xJzrK['codePrefix']); BizException::throwsIf('防伪码长度不符合规范', $xJzrK['codeLength'] < 8 || $xJzrK['codeLength'] > 50); BizException::throwsIf('防伪码长度不符合规范', $xJzrK['codeLength'] <= strlen($xJzrK['codePrefix'])); BizException::throwsIf('物流码长度不符合规范', $xJzrK['transportCodeLength'] < 8 || $xJzrK['transportCodeLength'] > 50); BizException::throwsIf('生成数量不符合规范', $xJzrK['count'] < 1 || $xJzrK['count'] > 100000); $ylMpb = $xJzrK['codeLength'] - strlen($xJzrK['codePrefix']); $BybWE = 0; $Dj64C = array('code' => '', 'batch' => $xJzrK['batch'], 'transportCode' => '', 'productId' => $xJzrK['productId'], 'agentId' => $xJzrK['agentId'], 'enable' => $xJzrK['enable']); if ($Dj64C['enable']) { $Dj64C['enableTime'] = date('Y-m-d H:i:s'); } ModelUtil::transactionBegin(); for ($QiYh5 = 0; $QiYh5 < $xJzrK['count']; $QiYh5++) { $K7MHN = array('code' => $xJzrK['codePrefix'], 'verifyCode' => '', 'transportCode' => ''); switch ($xJzrK['codeType']) { case CodeCreateCodeType::PREFIX_ALPHABET_UPPER: $K7MHN['code'] .= RandomUtil::upperChar($ylMpb); break; case CodeCreateCodeType::PREFIX_NUMBER: $K7MHN['code'] .= RandomUtil::number($ylMpb); break; case CodeCreateCodeType::PREFIX_NUMBER_ALPHABET_UPPER: $K7MHN['code'] .= RandomUtil::upperString($ylMpb); break; default: BizException::throws('防伪码生成方式错误'); } switch ($xJzrK['verifyCodeType']) { case CodeVerifyCodeType::NUMBER: $K7MHN['verifyCode'] = RandomUtil::number($xJzrK['verifyCodeLength']); break; } switch ($xJzrK['transportCodeType']) { case CodeTransportCodeType::NUMBER: $K7MHN['transportCode'] = RandomUtil::number($xJzrK['transportCodeLength']); break; case CodeTransportCodeType::NUMBER_ALPHABET: $K7MHN['transportCode'] = RandomUtil::upperString($xJzrK['transportCodeLength']); break; default: BizException::throws('物流码样式错误'); } try { ModelUtil::insert('tracking_code', array_merge($Dj64C, $K7MHN)); $BybWE = 0; } catch (\Exception $Q19lV) { $QiYh5--; $BybWE++; } if ($BybWE > 5) { ModelUtil::transactionRollback(); return Response::generateError('失败次数太多，请重试'); } } ModelUtil::transactionCommit(); return Response::generate(0, '批量生成防伪码成功', null, action('\\' . __CLASS__ . '@index')); }); } goto kbNLn; NnkK8: $ypG_B->select('productId', '防伪码所属产品')->optionModel('tracking_product', 'id', 'title')->help('可在防伪码不变的情况下批量修改。')->required(); goto UYcaJ; kbNLn: return $DNh5u->pageTitle('批量生成防伪码')->body(new Box($ypG_B, '批量生成防伪码')); goto mdxAV; dBNSW: $ypG_B->number('transportCodeLength', '物流码长度')->defaultValue(8)->help('物流码可用于扫码发货，流程记录和溯源管理等')->required(); goto DFtVR; a7nx1: $ypG_B->select('transportCodeType', '物流码样式')->optionType(CodeTransportCodeType::class)->required(); goto dBNSW; Tn5IE: $ypG_B->switch('enable', '是否启用防伪码')->optionsYesNo()->help('只有启用的防伪码才能查询到。')->defaultValue(true); goto mMIEw; bBaUg: $ypG_B->select('codeType', '防伪码生成方式')->optionType(CodeCreateCodeType::class)->required(); goto bqIwc; mdxAV: } public function modify(AdminPage $DNh5u) { goto l6vs5; z4BYX: $ypG_B->display('_', '修改为')->addable(true); goto pWB0C; H_zNj: $ypG_B->switch('enableChange', '修改状态')->when(true, function (Form $ypG_B) { $ypG_B->switch('enable', '是否启用')->help(''); }); goto WIkwE; MKYqM: return $DNh5u->pageTitle('批量修改防伪码')->row(new Box($ypG_B, '批量修改防伪码')); goto mV221; ASVX8: if (Request::isPost()) { return $ypG_B->formRequest(function (Form $ypG_B) { AdminPermission::demoCheck(); $xJzrK = $ypG_B->dataForming(); $umZPe = array(); if (isset($xJzrK['productIdChange']) && $xJzrK['productIdChange']) { $umZPe['productId'] = $xJzrK['productId']; } if (isset($xJzrK['agentIdChange']) && $xJzrK['agentIdChange']) { $umZPe['agentId'] = $xJzrK['agentId']; } if (isset($xJzrK['enableChange']) && $xJzrK['enableChange']) { $umZPe['enable'] = $xJzrK['enable']; } if (isset($xJzrK['enableTimeChange']) && $xJzrK['enableTimeChange']) { $umZPe['enableTime'] = $xJzrK['enableTime']; } if (empty($umZPe)) { return Response::generateError('请至少选择一项修改'); } $VShxB = ModelUtil::model('tracking_code'); switch ($xJzrK['modifyType']) { case CodeBatchIdentityType::TRANSPORT_CODE: goto tofRA; YeeJG: break; goto h9qPm; NP7G2: $VShxB = $VShxB->whereIn('transportCode', $xJzrK['fromTransportCodeTransportCodes']); goto YeeJG; tofRA: BizException::throwsIfEmpty('物流码为空', $xJzrK['fromTransportCodeTransportCodes']); goto NP7G2; h9qPm: case CodeBatchIdentityType::ID_RANGE: goto bjGiU; miiCc: $VShxB = $VShxB->where('id', '>=', $xJzrK['fromIdRangeStart'])->where('id', '<=', $xJzrK['fromIdRangeEnd']); goto wjgxn; wjgxn: break; goto d1Qiq; bjGiU: BizException::throwsIfEmpty('ID范围最小值为空', $xJzrK['fromIdRangeStart']); goto aWbgV; aWbgV: BizException::throwsIfEmpty('ID范围最大值为空', $xJzrK['fromIdRangeEnd']); goto miiCc; d1Qiq: case CodeBatchIdentityType::BATCH: goto Sz9tR; Sz9tR: BizException::throwsIfEmpty('批次为空', $xJzrK['fromBatchBatch']); goto tlekM; tlekM: $VShxB = $VShxB->where('batch', $xJzrK['fromBatchBatch']); goto yVnNQ; yVnNQ: break; goto ZNpQP; ZNpQP: case CodeBatchIdentityType::PRODUCT: goto rVTcO; JJIkw: $VShxB = $VShxB->where('productId', $xJzrK['fromProductProductId']); goto eAHCX; rVTcO: BizException::throwsIfEmpty('批次为空', $xJzrK['fromProductProductId']); goto JJIkw; eAHCX: break; goto ozfOA; ozfOA: case CodeBatchIdentityType::CREATE_TIME: goto m8f_z; K1JtB: BizException::throwsIfEmpty('创建结束时间为空', $xJzrK['fromCreateTimeEnd']); goto dk36b; UMFQX: break; goto aLua6; dk36b: $VShxB = $VShxB->where('created_at', '>=', $xJzrK['fromCreateTimeStart'])->where('created_at', '<=', $xJzrK['fromCreateTimeEnd']); goto UMFQX; m8f_z: BizException::throwsIfEmpty('创建开始时间为空', $xJzrK['fromCreateTimeStart']); goto K1JtB; aLua6: default: BizException::throws('防伪码范围为空'); } $gfK5X = intval($VShxB->update($umZPe)); return Response::generateSuccess('成功更新 ' . $gfK5X . ' 条记录'); }); } goto MKYqM; pWB0C: $ypG_B->switch('productIdChange', '修改所属产品')->when(true, function (Form $ypG_B) { $ypG_B->select('productId', '防伪码所属产品')->optionModel('tracking_product', 'id', 'title')->help('可在防伪码不变的情况下批量修改。'); }); goto HH4x2; a1LfR: $ypG_B->radio('modifyType', '防伪码范围')->optionType(CodeBatchIdentityType::class)->defaultValue(CodeBatchIdentityType::TRANSPORT_CODE)->when(CodeBatchIdentityType::TRANSPORT_CODE, function (Form $ypG_B) { $ypG_B->textarea('fromTransportCodeTransportCodes', '录入物流码')->placeholder('一行一个，回车换行 , 支持扫描枪')->help('录入物流码，支持扫描枪'); })->when(CodeBatchIdentityType::ID_RANGE, function (Form $ypG_B) { $ypG_B->number('fromIdRangeStart', 'ID范围最小值')->placeholder('')->help('包含该值'); $ypG_B->number('fromIdRangeEnd', 'ID范围最大值')->placeholder('')->help('包含该值'); })->when(CodeBatchIdentityType::BATCH, function (Form $ypG_B) { $ypG_B->text('fromBatchBatch', '批次')->help('录入物流码，支持扫描枪'); })->when(CodeBatchIdentityType::PRODUCT, function (Form $ypG_B) { $ypG_B->select('fromProductProductId', '防伪码所属产品')->optionModel('tracking_product', 'id', 'title'); })->when(CodeBatchIdentityType::CREATE_TIME, function (Form $ypG_B) { $ypG_B->datetime('fromCreateTimeStart', '创建开始时间')->help('包含该时间'); $ypG_B->datetime('fromCreateTimeEnd', '创建结束时间')->help('包含该时间'); }); goto z4BYX; l6vs5: $ypG_B = Form::make('')->formClass('wide'); goto a1LfR; HH4x2: $ypG_B->switch('agentIdChange', '修改所属经销商')->when(true, function (Form $ypG_B) { $ypG_B->select('agentId', '产品所属经销商')->optionModel('tracking_agent', 'id', 'name')->help('可在防伪码不变的情况下批量修改。'); }); goto H_zNj; WIkwE: $ypG_B->switch('enableTimeChange', '修改启用时间')->when(true, function (Form $ypG_B) { $ypG_B->datetime('enableTime', '启用时间')->help(''); }); goto ASVX8; mV221: } public function export(AdminPage $DNh5u) { goto YFVUZ; qMh8Z: $ypG_B->radio('modifyType', '防伪码范围')->optionType(CodeBatchIdentityType::class)->defaultValue(CodeBatchIdentityType::TRANSPORT_CODE)->when(CodeBatchIdentityType::TRANSPORT_CODE, function (Form $ypG_B) { $ypG_B->textarea('fromTransportCodeTransportCodes', '录入物流码')->placeholder('一行一个，回车换行 , 支持扫描枪')->help('录入物流码，支持扫描枪'); })->when(CodeBatchIdentityType::ID_RANGE, function (Form $ypG_B) { $ypG_B->number('fromIdRangeStart', 'ID范围最小值')->placeholder('')->help('包含该值'); $ypG_B->number('fromIdRangeEnd', 'ID范围最大值')->placeholder('')->help('包含该值'); })->when(CodeBatchIdentityType::BATCH, function (Form $ypG_B) { $ypG_B->text('fromBatchBatch', '批次')->help('录入物流码，支持扫描枪'); })->when(CodeBatchIdentityType::PRODUCT, function (Form $ypG_B) { $ypG_B->select('fromProductProductId', '防伪码所属产品')->optionModel('tracking_product', 'id', 'title'); })->when(CodeBatchIdentityType::CREATE_TIME, function (Form $ypG_B) { $ypG_B->datetime('fromCreateTimeStart', '创建开始时间')->help('包含该时间'); $ypG_B->datetime('fromCreateTimeEnd', '创建结束时间')->help('包含该时间'); }); goto TnALR; TnALR: if (Request::isPost()) { goto FlAxE; PP13l: ModelUtil::join($i7_Nb, 'productId', '_product', 'tracking_product'); goto rexua; gP66s: $yCUD1 = $yCUD1->getData(true); goto x3mFs; x3mFs: $i7_Nb = $yCUD1['data']['records']; goto PP13l; cFDJZ: if (Response::isError($yCUD1)) { return Response::sendFromGenerate($yCUD1); } goto gP66s; EBFpI: $rD8we = array(array('ID', '二维码', '防伪码', '批次', '校验码', '物流码', '创建时间', '产品', '经销商', '启用')); goto Ldvi5; Ldvi5: foreach ($i7_Nb as $gH1Sv) { $rD8we[] = array($gH1Sv['id'], Request::domainUrl() . modstart_web_url('tracking/show/code_' . $gH1Sv['code']), $gH1Sv['code'], $gH1Sv['batch'], $gH1Sv['verifyCode'], $gH1Sv['transportCode'], $gH1Sv['created_at'], $gH1Sv['_product'] ? $gH1Sv['_product']['title'] : $gH1Sv['productId'], $gH1Sv['_agent'] ? $gH1Sv['_agent']['name'] : $gH1Sv['agentId'], $gH1Sv['enable'] ? '是' : '否'); } goto kY3XC; rexua: ModelUtil::join($i7_Nb, 'agentId', '_agent', 'tracking_agent'); goto EBFpI; FlAxE: $yCUD1 = $ypG_B->formRequest(function (Form $ypG_B) { AdminPermission::demoCheck(); $xJzrK = $ypG_B->dataForming(); $VShxB = ModelUtil::model('tracking_code'); switch ($xJzrK['modifyType']) { case CodeBatchIdentityType::TRANSPORT_CODE: goto mIwDU; T1Lj4: break; goto PyHjJ; mIwDU: BizException::throwsIfEmpty('物流码为空', $xJzrK['fromTransportCodeTransportCodes']); goto BmzLW; BmzLW: $wnO4c = CodeUtil::transportCodeTextToCodes($xJzrK['fromTransportCodeTransportCodes']); goto LnCxU; YFii0: $VShxB = $VShxB->whereIn('transportCode', $wnO4c); goto T1Lj4; LnCxU: BizException::throwsIfEmpty('物流码为空', $wnO4c); goto YFii0; PyHjJ: case CodeBatchIdentityType::ID_RANGE: goto f0WBI; Fk5XZ: BizException::throwsIfEmpty('ID范围最大值为空', $xJzrK['fromIdRangeEnd']); goto iZ1wP; VHizB: break; goto K2FtR; f0WBI: BizException::throwsIfEmpty('ID范围最小值为空', $xJzrK['fromIdRangeStart']); goto Fk5XZ; iZ1wP: $VShxB = $VShxB->where('id', '>=', $xJzrK['fromIdRangeStart'])->where('id', '<=', $xJzrK['fromIdRangeEnd']); goto VHizB; K2FtR: case CodeBatchIdentityType::BATCH: goto sr0Yl; sr0Yl: BizException::throwsIfEmpty('批次为空', $xJzrK['fromBatchBatch']); goto Yz2y6; Yz2y6: $VShxB = $VShxB->where('batch', $xJzrK['fromBatchBatch']); goto lbRFn; lbRFn: break; goto hygOu; hygOu: case CodeBatchIdentityType::PRODUCT: goto zzocB; BnT2V: break; goto amxjY; MDT0I: $VShxB = $VShxB->where('productId', $xJzrK['fromProductProductId']); goto BnT2V; zzocB: BizException::throwsIfEmpty('批次为空', $xJzrK['fromProductProductId']); goto MDT0I; amxjY: case CodeBatchIdentityType::CREATE_TIME: goto dvfNj; dvfNj: BizException::throwsIfEmpty('创建开始时间为空', $xJzrK['fromCreateTimeStart']); goto Ky1de; goUhe: break; goto YVD1V; Ky1de: BizException::throwsIfEmpty('创建结束时间为空', $xJzrK['fromCreateTimeEnd']); goto XC6iC; XC6iC: $VShxB = $VShxB->where('created_at', '>=', $xJzrK['fromCreateTimeStart'])->where('created_at', '<=', $xJzrK['fromCreateTimeEnd']); goto goUhe; YVD1V: default: BizException::throws('防伪码范围为空'); } return Response::generateSuccessData(array('records' => $VShxB->get(array('*'))->toArray())); }); goto cFDJZ; kY3XC: return Excel::create('防伪码_' . date('Ymd_His'), function ($exOma) use($rD8we) { $exOma->sheet('Data', function ($wEPp7) use($rD8we) { $xva_F = array(); for ($QiYh5 = 0; $QiYh5 < count($rD8we[0]); $QiYh5++) { $xva_F[\PHPExcel_Cell::stringFromColumnIndex($QiYh5)] = '@'; } $wEPp7->setColumnFormat($xva_F); $wEPp7->setAutoSize(true); $wEPp7->rows($rD8we, true); }); })->export('xlsx'); goto oHM1w; oHM1w: } goto jAKhM; jAKhM: $ypG_B->ajax(false); goto yV3V9; YFVUZ: $ypG_B = Form::make('')->formClass('wide'); goto qMh8Z; yV3V9: return $DNh5u->pageTitle('批量导出防伪码')->row(new Box($ypG_B, '批量导出防伪码')); goto ylYrB; ylYrB: } }