<?php
/**
 * ------------------------ 
 *  版权所有  www.tecmz.com
 *  商业版本请购买正版授权使用
 * ------------------------
*/ namespace Illuminate\Database\Schema\Grammars; use Illuminate\Support\Fluent; use Illuminate\Database\Connection; use Illuminate\Database\Schema\Blueprint; class MySqlGrammar extends Grammar { protected $modifiers = array('Unsigned', 'Charset', 'Collate', 'Nullable', 'Default', 'Increment', 'Comment', 'After', 'First'); protected $serials = array('bigInteger', 'integer', 'mediumInteger', 'smallInteger', 'tinyInteger'); public function compileTableExists() { return 'select * from information_schema.tables where table_schema = ? and table_name = ?'; } public function compileColumnExists() { return 'select column_name as `column_name` from information_schema.columns where table_schema = ? and table_name = ?'; } public function compileCreate(Blueprint $uIA2j, Fluent $KSRN6, Connection $pqoX9) { goto fYn5i; sLuL2: $or7wn = $this->compileCreateEncoding($or7wn, $pqoX9, $uIA2j); goto y0d4M; xdJ0N: $or7wn = $uIA2j->temporary ? 'create temporary' : 'create'; goto ilgpC; y0d4M: if (isset($uIA2j->engine)) { $or7wn .= ' engine = ' . $uIA2j->engine; } goto xlcuI; fYn5i: $hSGtJ = implode(', ', $this->getColumns($uIA2j)); goto xdJ0N; ilgpC: $or7wn .= ' table ' . $this->wrapTable($uIA2j) . " ({$hSGtJ})"; goto sLuL2; xlcuI: return $or7wn; goto k88d2; k88d2: } protected function compileCreateEncoding($or7wn, Connection $pqoX9, Blueprint $uIA2j) { goto riAgk; riAgk: if (isset($uIA2j->charset)) { $or7wn .= ' default character set ' . $uIA2j->charset; } elseif (!is_null($y_5J3 = $pqoX9->getConfig('charset'))) { $or7wn .= ' default character set ' . $y_5J3; } goto LL28E; LL28E: if (isset($uIA2j->collation)) { $or7wn .= ' collate ' . $uIA2j->collation; } elseif (!is_null($WWzfa = $pqoX9->getConfig('collation'))) { $or7wn .= ' collate ' . $WWzfa; } goto NL0ip; NL0ip: return $or7wn; goto r10HW; r10HW: } public function compileAdd(Blueprint $uIA2j, Fluent $KSRN6) { goto oGI_2; oGI_2: $zWXdn = $this->wrapTable($uIA2j); goto TGABu; TGABu: $hSGtJ = $this->prefixArray('add', $this->getColumns($uIA2j)); goto tC3vT; tC3vT: return 'alter table ' . $zWXdn . ' ' . implode(', ', $hSGtJ); goto Ggih3; Ggih3: } public function compilePrimary(Blueprint $uIA2j, Fluent $KSRN6) { $KSRN6->name(null); return $this->compileKey($uIA2j, $KSRN6, 'primary key'); } public function compileUnique(Blueprint $uIA2j, Fluent $KSRN6) { return $this->compileKey($uIA2j, $KSRN6, 'unique'); } public function compileIndex(Blueprint $uIA2j, Fluent $KSRN6) { return $this->compileKey($uIA2j, $KSRN6, 'index'); } protected function compileKey(Blueprint $uIA2j, Fluent $KSRN6, $bOB5d) { goto VJLsy; VJLsy: $hSGtJ = $this->columnize($KSRN6->columns); goto WU3XW; WU3XW: $zWXdn = $this->wrapTable($uIA2j); goto JRkzf; JRkzf: return "alter table {$zWXdn} add {$bOB5d} `{$KSRN6->index}`({$hSGtJ})"; goto pZNpv; pZNpv: } public function compileDrop(Blueprint $uIA2j, Fluent $KSRN6) { return 'drop table ' . $this->wrapTable($uIA2j); } public function compileDropIfExists(Blueprint $uIA2j, Fluent $KSRN6) { return 'drop table if exists ' . $this->wrapTable($uIA2j); } public function compileDropColumn(Blueprint $uIA2j, Fluent $KSRN6) { goto iixug; RFxDD: return 'alter table ' . $zWXdn . ' ' . implode(', ', $hSGtJ); goto RzRkY; iixug: $hSGtJ = $this->prefixArray('drop', $this->wrapArray($KSRN6->columns)); goto o7kK4; o7kK4: $zWXdn = $this->wrapTable($uIA2j); goto RFxDD; RzRkY: } public function compileDropPrimary(Blueprint $uIA2j, Fluent $KSRN6) { return 'alter table ' . $this->wrapTable($uIA2j) . ' drop primary key'; } public function compileDropUnique(Blueprint $uIA2j, Fluent $KSRN6) { $zWXdn = $this->wrapTable($uIA2j); return "alter table {$zWXdn} drop index `{$KSRN6->index}`"; } public function compileDropIndex(Blueprint $uIA2j, Fluent $KSRN6) { $zWXdn = $this->wrapTable($uIA2j); return "alter table {$zWXdn} drop index `{$KSRN6->index}`"; } public function compileDropForeign(Blueprint $uIA2j, Fluent $KSRN6) { $zWXdn = $this->wrapTable($uIA2j); return "alter table {$zWXdn} drop foreign key `{$KSRN6->index}`"; } public function compileRename(Blueprint $uIA2j, Fluent $KSRN6) { $S7Ck8 = $this->wrapTable($uIA2j); return "rename table {$S7Ck8} to " . $this->wrapTable($KSRN6->to); } protected function typeChar(Fluent $gnky8) { return "char({$gnky8->length})"; } protected function typeString(Fluent $gnky8) { return "varchar({$gnky8->length})"; } protected function typeText(Fluent $gnky8) { return 'text'; } protected function typeMediumText(Fluent $gnky8) { return 'mediumtext'; } protected function typeLongText(Fluent $gnky8) { return 'longtext'; } protected function typeBigInteger(Fluent $gnky8) { return 'bigint'; } protected function typeInteger(Fluent $gnky8) { return 'int'; } protected function typeMediumInteger(Fluent $gnky8) { return 'mediumint'; } protected function typeTinyInteger(Fluent $gnky8) { return 'tinyint'; } protected function typeSmallInteger(Fluent $gnky8) { return 'smallint'; } protected function typeFloat(Fluent $gnky8) { return $this->typeDouble($gnky8); } protected function typeDouble(Fluent $gnky8) { if ($gnky8->total && $gnky8->places) { return "double({$gnky8->total}, {$gnky8->places})"; } return 'double'; } protected function typeDecimal(Fluent $gnky8) { return "decimal({$gnky8->total}, {$gnky8->places})"; } protected function typeBoolean(Fluent $gnky8) { return 'tinyint(1)'; } protected function typeEnum(Fluent $gnky8) { return 'enum(\'' . implode('\', \'', $gnky8->allowed) . '\')'; } protected function typeJson(Fluent $gnky8) { return 'text'; } protected function typeJsonb(Fluent $gnky8) { return 'text'; } protected function typeDate(Fluent $gnky8) { return 'date'; } protected function typeDateTime(Fluent $gnky8) { return 'datetime'; } protected function typeDateTimeTz(Fluent $gnky8) { return 'datetime'; } protected function typeTime(Fluent $gnky8) { return 'time'; } protected function typeTimeTz(Fluent $gnky8) { return 'time'; } protected function typeTimestamp(Fluent $gnky8) { goto dqZ1x; u8Aue: if (!$gnky8->nullable && $gnky8->default === null) { return 'timestamp default 0'; } goto D9iaa; dqZ1x: if ($gnky8->useCurrent) { return 'timestamp default CURRENT_TIMESTAMP'; } goto u8Aue; D9iaa: return 'timestamp'; goto Ul5FE; Ul5FE: } protected function typeTimestampTz(Fluent $gnky8) { goto beSHZ; xgWue: if (!$gnky8->nullable && $gnky8->default === null) { return 'timestamp default 0'; } goto O0XdO; beSHZ: if ($gnky8->useCurrent) { return 'timestamp default CURRENT_TIMESTAMP'; } goto xgWue; O0XdO: return 'timestamp'; goto r1Xm7; r1Xm7: } protected function typeBinary(Fluent $gnky8) { return 'blob'; } protected function typeUuid(Fluent $gnky8) { return 'char(36)'; } protected function modifyUnsigned(Blueprint $uIA2j, Fluent $gnky8) { if ($gnky8->unsigned) { return ' unsigned'; } } protected function modifyCharset(Blueprint $uIA2j, Fluent $gnky8) { if (!is_null($gnky8->charset)) { return ' character set ' . $gnky8->charset; } } protected function modifyCollate(Blueprint $uIA2j, Fluent $gnky8) { if (!is_null($gnky8->collation)) { return ' collate ' . $gnky8->collation; } } protected function modifyNullable(Blueprint $uIA2j, Fluent $gnky8) { return $gnky8->nullable ? ' null' : ' not null'; } protected function modifyDefault(Blueprint $uIA2j, Fluent $gnky8) { if (!is_null($gnky8->default)) { return ' default ' . $this->getDefaultValue($gnky8->default); } } protected function modifyIncrement(Blueprint $uIA2j, Fluent $gnky8) { if (in_array($gnky8->type, $this->serials) && $gnky8->autoIncrement) { return ' auto_increment primary key'; } } protected function modifyFirst(Blueprint $uIA2j, Fluent $gnky8) { if (!is_null($gnky8->first)) { return ' first'; } } protected function modifyAfter(Blueprint $uIA2j, Fluent $gnky8) { if (!is_null($gnky8->after)) { return ' after ' . $this->wrap($gnky8->after); } } protected function modifyComment(Blueprint $uIA2j, Fluent $gnky8) { if (!is_null($gnky8->comment)) { return ' comment "' . $gnky8->comment . '"'; } } protected function wrapValue($FT9zA) { if ($FT9zA === '*') { return $FT9zA; } return '`' . str_replace('`', '``', $FT9zA) . '`'; } }