<?php
global $dou;

if ($dou->field_exist('fragment', 'fragment_name'))
    $dou->query("ALTER TABLE " . $dou->table('fragment') . " CHANGE `fragment_name` `name` VARCHAR( 150 ) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT ''");

if (!$dou->field_exist('fragment', 'box'))
    $dou->query("ALTER TABLE " . $dou->table('fragment') . " ADD `box` VARCHAR( 60 ) NOT NULL DEFAULT '' AFTER `link`");

if (!$dou->field_exist('fragment', 'home'))
    $dou->query("ALTER TABLE " . $dou->table('fragment') . " ADD `home` TINYINT( 1 ) UNSIGNED NOT NULL DEFAULT '1' AFTER `box`");

if (!$dou->field_exist('fragment', 'class'))
    $dou->query("ALTER TABLE " . $dou->table('fragment') . " ADD `class` VARCHAR( 60 ) NOT NULL DEFAULT '' AFTER `home`");

if (!$dou->field_exist('fragment', 'lock'))
    $dou->query("ALTER TABLE " . $dou->table('fragment') . " ADD `lock` TINYINT( 1 ) UNSIGNED NOT NULL DEFAULT '0' AFTER `class`");

if (!$dou->field_exist('page', 'editor_code'))
    $dou->query("ALTER TABLE " . $dou->table('page') . " ADD `editor_code` VARCHAR( 60 ) NOT NULL DEFAULT '' AFTER `description`");

if (!$dou->field_exist('page', 'mode'))
    $dou->query("ALTER TABLE " . $dou->table('page') . " ADD `mode` VARCHAR( 60 ) NOT NULL DEFAULT '' AFTER `editor_code`");

// 数据库升级
$dou->query("ALTER TABLE " . $dou->table('nav') . " CHANGE `type` `type` VARCHAR( 60 ) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL");

// 删除多余文件
if (file_exists($box_init = ROOT_PATH . 'include/box.init.php'))
    @unlink($box_init);

if (file_exists($fragment_init = ROOT_PATH . 'include/fragment.init.php'))
    @unlink($fragment_init);

// 复制碎片里的二维码到images目录
if (file_exists($fragment_weixin_img = ROOT_PATH . 'images/fragment/weixin.png'))
    $dou->copy_dir($fragment_weixin_img, ROOT_PATH . 'images/upload/weixin.png');

// 升级伪静态规则
if (file_exists($file_htaccess = ROOT_PATH . '_update/rewrite/.htaccess') && file_exists(ROOT_PATH . '.htaccess'))
    copy($file_htaccess, ROOT_PATH . '.htaccess');
if (file_exists($file_httpd = ROOT_PATH . '_update/rewrite/httpd.ini') && file_exists(ROOT_PATH . 'httpd.ini'))
    copy($file_httpd, ROOT_PATH . 'httpd.ini');
if (file_exists($file_web = ROOT_PATH . '_update/rewrite/web.config') && file_exists(ROOT_PATH . 'web.config'))
    copy($file_web, ROOT_PATH . 'web.config');
 
?>