<?php
/**
 * DouPHP
 * --------------------------------------------------------------------------------------------------
 * 版权所有 2013-2018 漳州豆壳网络科技有限公司，并保留所有权利。
 * 网站地址: http://www.douphp.com
 * --------------------------------------------------------------------------------------------------
 * 这不是一个自由软件！您只能在遵守授权协议前提下对程序代码进行修改和使用；不允许对程序代码以任何形式任何目的的再发布。
 * 授权协议: http://www.douphp.com/license.html
 * --------------------------------------------------------------------------------------------------
 * Author: DouCo Co.,Ltd.
 * Release Date: 2024-09-30
 */
if (!defined('IN_DOUCO')) {
    die('Hacking attempt');
}
class Action extends Common {
    /**
     * +----------------------------------------------------------
     * 清除缓存及已编译模板
     * +----------------------------------------------------------
     */
    function dou_clear_cache($dir) {
        $dir = realpath($dir);
        if (!$dir || !@ is_dir($dir))
            return 0;
        $handle = @ opendir($dir);
        if ($dir[strlen($dir) - 1] != DIRECTORY_SEPARATOR)
            $dir .= DIRECTORY_SEPARATOR;
        while ($file = @ readdir($handle)) {
            if ($file != '.' && $file != '..') {
                if (@ is_dir($dir . $file) && !is_link($dir . $file))
                    $this->dou_clear_cache($dir . $file);
                else
                    @ unlink($dir . $file);
            }
        }
        closedir($handle);
    }
 
    /**
     * +----------------------------------------------------------
     * 复制或剪切目录
     * +----------------------------------------------------------
     * $source_dir 要复制的路径
     * $destination_dir 复制文件的目的地
     * $del_source 如果删除原路径就相当于剪切
     * $skip 如果已经存在则跳过
     * $destination_exists 目的文件已经存在
     * +----------------------------------------------------------
     */
    function copy_dir($source_dir, $destination_dir, $del_source = false, $skip = false, $destination_exists = false) {
        if (!$source_dir || !@is_dir($source_dir)) return 0;
        if (!is_dir($destination_dir)) mkdir($destination_dir);
        
        // 如果目录结尾不包含 / 就给它加上
        if ($source_dir[strlen($source_dir) - 1] != DIRECTORY_SEPARATOR) $source_dir .= DIRECTORY_SEPARATOR;
        if ($destination_dir) {
            if (!@is_dir($destination_dir)) return 0;
            if ($destination_dir[strlen($destination_dir) - 1] != DIRECTORY_SEPARATOR) $destination_dir .= DIRECTORY_SEPARATOR;
        }
     
        if ($handle = @opendir($source_dir)) {
            while (($file = @readdir($handle)) !== false) {
                if ($file != '.' && $file != '..') {
                    if (@is_dir($source_dir . $file) && !is_link($source_dir . $file)) {
                        $this->copy_dir($source_dir . $file, $destination_dir . $file, $del_source, $skip, $destination_exists);
                    } else {
                        // 多重文件复制模式
                        if ($skip) { // 跳过模式
                            if (!file_exists($destination_dir . $file))
                                copy($source_dir . $file, $destination_dir . $file);
                        } elseif ($destination_exists) { // 必须目的文件已经存在
                            if (file_exists($destination_dir . $file))
                                copy($source_dir . $file, $destination_dir . $file);
                        } else {
                            copy($source_dir . $file, $destination_dir . $file);
                        }
                        
                        if ($del_source) @unlink($source_dir . $file); // 剪切
                    }
                }
            }
            closedir($handle);
         
            if ($del_source) @rmdir($source_dir); // 剪切
        }
    }

}
?>