<?php
/**
 * DouPHP
 * --------------------------------------------------------------------------------------------------
 * 版权所有 2013-2024 漳州豆壳网络科技有限公司，并保留所有权利。
 * 网站地址: http://www.douphp.com
 * --------------------------------------------------------------------------------------------------
 * 这不是一个自由软件！您只能在遵守授权协议前提下对程序代码进行修改和使用；不允许对程序代码以任何形式任何目的的再发布。
 * 授权协议: http://www.douphp.com/license.html
 * --------------------------------------------------------------------------------------------------
 * Author: DouCo Co.,Ltd.
 * Release Date: 2024-09-30
 */
class Rewrite {
    /**
     * +----------------------------------------------------------
     * 格式化URL
     * +----------------------------------------------------------
     * $route 伪静态后的URL
     * +----------------------------------------------------------
     */
    function format($module, $parts, $route) {
        // 单页面
        if (preg_match("/^([a-z0-9-]+)\.html$/", $route)) {
            $mark['module'] = 'page';
            $mark['unique_id'] = str_replace('.html', '', $route);
        } else {
            $module_from_url = $parts[0]; // 通过URL直接获取的模块名
            
            // 简单模块
            if (in_array($module, $GLOBALS['_MODULE']['single'])) {
                if (preg_match("/^$module_from_url\/([0-9]+)$/", $route)) {
                    $mark['module'] = $module;
                    $mark['rec'] = 'detail';
                    $mark['id'] = $parts[1];
                } elseif (preg_match("/^$module_from_url(\/)*(o)*([0-9]*)(\/)*$/", $route)) {
                    $mark['module'] = $module;
                    $mark['page'] = str_replace('o', '', $parts[1]);
                } elseif (preg_match("/^$module_from_url\/([a-z0-9_-]+)(\/)*(o)*([0-9]*)(\/)*$/", $route)) {
                    $mark['module'] = $module;
                    $mark['rec'] = $parts[1];
                    $mark['page'] = str_replace('o', '', $parts[2]);
                }
            }
         
            // 栏目模块
            elseif (in_array($module, $GLOBALS['_MODULE']['column']) && $module != 'item') {
                if (preg_match("/^$module_from_url\/([a-z0-9-]*)(\/)*([0-9]+)\.html$/", $route)) {
                    $mark['module'] = $module;
                    $mark['unique_id'] = preg_match("/^([a-z0-9-])$/", $parts[1]) ? $parts[1] : '';
                    $mark['id'] = str_replace('.html', '', basename($route));
                } elseif (preg_match("/^$module_from_url(\/)*(o)*([0-9]*)(\/)*$/", $route)) {
                    $mark['module'] = $module . '_category';
                    $mark['page'] = str_replace('o', '', $parts[1]);
                } elseif (preg_match("/^$module_from_url\/([a-z0-9-]+)(\/)*(o)*([0-9]*)(\/)*$/", $route)) {
                    $mark['module'] = $module . '_category';
                    $mark['unique_id'] = $parts[1];
                    $mark['page'] = str_replace('o', '', $parts[2]);
                }
            }
         
            // 万能内容模块
            elseif ($GLOBALS['_OPEN']['item']) {
                if (preg_match("/^item\/([0-9]+)\.html$/", $route)) {
                    $mark['module'] = 'item';
                    $mark['id'] = str_replace('.html', '', basename($route));
                } elseif (preg_match("/^([a-z0-9-]+)(\/)*(o)*([0-9]*)(\/)*$/", $route)) {
                    $mark['module'] = 'item_category';
                    $mark['unique_id'] = $parts[0];
                    $mark['page'] = str_replace('o', '', $parts[1]);
                }
            }
        }
        
        return $mark;
    }

    /**
     * +----------------------------------------------------------
     * 获取当前模块名
     * +----------------------------------------------------------
     */
    function module_info($parts, $route) {
        $_MODULE = $this->module();
        
        if (preg_match("/^([a-z0-9-]+)\.html$/", $route)) {
            $info['module'] = $cur = 'page';
            $info['cur'] = 'page';
        } else {
            $info['module'] = $parts[0] == 'news' ? 'article' : $parts[0];
            if (in_array($info['module'], $_MODULE['column'])) {
                if (preg_match("/\.html$/", $route)) {
                    $info['cur'] = $info['module'];
                } else {
                    $info['cur'] = $info['module'] . '_category';
                }
            } else {
                $info['cur'] = $info['module'];
            }
        }
        
        return $info;
    }

    /**
     * +----------------------------------------------------------
     * 系统模块
     * +----------------------------------------------------------
     */
    function module() {
        // 读取系统文件
        $content = file('data/system.php');
        foreach ($content as $line) {
            $line = trim($line);
            if (strpos($line, ':') !== false) {
                $arr = explode(':', $line);
                $setting[$arr[0]] = explode(',', $arr[1]);
            }
        }

        $module['column'] = $setting['column_module'];
        $module['single'] = $setting['single_module'];

        return $module;
    }
}

?>