<?php
/**
 * DouPHP
 * --------------------------------------------------------------------------------------------------
 * 版权所有 2013-2024 漳州豆壳网络科技有限公司，并保留所有权利。
 * 网站地址: http://www.douphp.com
 * --------------------------------------------------------------------------------------------------
 * 这不是一个自由软件！您只能在遵守授权协议前提下对程序代码进行修改和使用；不允许对程序代码以任何形式任何目的的再发布。
 * 授权协议: http://www.douphp.com/license.html
 * --------------------------------------------------------------------------------------------------
 * Author: DouCo Co.,Ltd.
 * Release Date: 2024-09-30
 */
define('IN_DOUCO', true);

if (isset($_REQUEST['route'])) {
    $_ROUTE = $_REQUEST['route'];
    $_PARTS = explode('/', $_ROUTE);
        
    if (preg_match("/^[a-zA-Z]{2}-[a-zA-Z]{2}$/", $_PARTS[0])) {
        $_LANG_FROM_ROUTE = $_PARTS[0];
        array_splice($_PARTS, 0, 1);
        $_ROUTE = implode('/', $_PARTS);
    }
 
    $_IS_HOME = isset($_LANG_FROM_ROUTE) && !$_PARTS[0] ? true : false;
} else {
    $_IS_HOME = true;
}

// 强制在移动端中显示PC版
if (isset($_REQUEST['mobile'])) {
    setcookie('client', 'pc');
    $_COOKIE['client'] = 'pc';
}

/**
 * +----------------------------------------------------------
 * 站点首页
 * +----------------------------------------------------------
 */
if ($_IS_HOME) {
    $_CUR = 'index';
    require (dirname(__FILE__) . '/include/init.php');
    $smarty->assign('cur', $_CUR);

    // 如果存在搜索词则转入搜索页面
    if (isset($_REQUEST['s'])) {
        if ($check->is_search_keyword($keyword = trim($_REQUEST['s']))) {
            require (ROOT_PATH . 'include/search.inc.php');
            exit;
        } else {
            $dou->dou_msg($_LANG['search_keyword_wrong']);
        }
    }

    // 获取关于我们信息
    $sql = "SELECT * FROM " . $dou->table('page') . " WHERE id = '1'";
    $query = $dou->query($sql);
    $about = $dou->fetch_array($query);

    // 多语言
    $about = $dou->lang_box($about, 'page_name', 'title, description, content');

    // 写入到index数组
    $index['about_name'] = $about['page_name'];
    $index['about_content'] = $about['description'] ? $about['description'] : $dou->dou_substr($about['content'], 300, false); // 这里的300数值不能设置得过大，否则会造成程序卡死
    $index['about_link'] = $dou->rewrite_url('page', '1');
    $index['cur'] = true;

    // 代码扩展，此文件不会随着系统升级被覆盖
    if (file_exists($code_include_file = ROOT_PATH . '..code.php'))
        require ($code_include_file);

    // 赋值给模板-meta和title信息
    $smarty->assign('page_title', $dou->page_title());
    $smarty->assign('keywords', $_CFG['site_keywords']);
    $smarty->assign('description', $_CFG['site_description']);

    // 赋值给模板-导航栏
    $smarty->assign('nav_top_list', $dou->get_nav('top'));
    $smarty->assign('nav_middle_list', $dou->get_nav('middle'));
    $smarty->assign('nav_bottom_list', $dou->get_nav('bottom'));

    // 赋值给模板-数据
    $smarty->assign('show_list', $dou->get_show_list());
    $smarty->assign('link', $dou->get_link_list());
    $smarty->assign('index', $index);
    $smarty->assign('recommend_product', $dou->get_list('product', 'ALL', $_DISPLAY['home_product'], 'sort ASC'));
    $smarty->assign('recommend_article', $dou->get_list('article', 'ALL', $_DISPLAY['home_article'], 'sort ASC'));

    $smarty->display('index.dwt');
}

/**
 * +----------------------------------------------------------
 * 伪静态入口
 * +----------------------------------------------------------
 */
else {
    define('REWRITE', true);
    
    // 实例化伪静态类
    include_once ('include/rewrite.class.php');
    $dou_rewrite = new Rewrite();
 
    // 判断当前是哪个模块
    $_MODULE_INFO = $dou_rewrite->module_info($_PARTS, $_ROUTE);
    
    $_CUR = $_MODULE_INFO['cur'];
    require (dirname(__FILE__) . '/include/init.php');
 
    $_REWRITE = $dou_rewrite->format($_MODULE_INFO['module'], $_PARTS, $_ROUTE);
    
    if ($_REWRITE['module'] && file_exists($original_file = ROOT_PATH . $_REWRITE['module'] . '.php')) {
        // 请求格式化
        foreach ($_REWRITE as $key => $value) {
            if ($value)
                $_REQUEST[$key] = $value;
        }
        
        // 加载模块
        require ($original_file);
    } else {
        $dou->dou_msg('page_wrong', HOME_URL);
    }
}

?>