// pages/article_category/article_category.js
// 获取全局的应用实例
const app = getApp();

// 引入utils全局函数
var dou = require('../../utils/util.js');

Page({
  data: {
    article_category: [],
    article_list: [],
    cat_id: '',
    page: 1, // 初始页默认值为1
    nomore: false
  },
 
  onLoad: function(options) {
    var that = this
        
    wx.setNavigationBarTitle({
      title: app.title.article
    })
    
    // 显示转发按钮
    dou.showShareMenu()
   
    wx.request({
      url: app.mp_url + 'databox.php?rec=common',
      success: function(res) {
        that.setData({
          lang: res.data.lang,
          site: res.data.site
        })
      },
    })
    
    if (options.cat_id) {
      that.setData({
        cat_id: options.cat_id
      })
    }
    
    that.loadData()
  },
 
  onShow: function () {
    var that = this;
    
    // 在tabBar第三个图标中显示购物车数量
    dou.showCartNumber()
  },

  // 获取数据
  loadData: function(concat = false, page = '') {
    var that = this;
    var cat_id = that.data.cat_id;
   
    wx.request({
      url: app.mp_url + 'article_category.php',
      data: {
        user_id: wx.getStorageSync('user_id'),
        shell: wx.getStorageSync('shell'),
        cat_id: cat_id,
        page: page ? page : that.data.page, // 从数据里获取当前页数
      },
      header: {
        'Connect-Key' : wx.getStorageSync('connect_key')
      },
      success: function(res) {
        // 设置转发标题缓存
        wx.setStorageSync('shareTitle', res.data.title)
        
        if (concat) {
          var dataBox = that.data.article_list; // 从data获取当前datalist数组
          var dataNew = res.data.article_list; // 从此次请求返回的数据中获取新数组
          
          if (dataNew) {
            dataBox = dataBox.concat(dataNew); // 合并数组
          } else {
            that.setData({
              nomore: true
            })
          }
        } else {
          dataBox = res.data.article_list;
        }
        
        that.setData({
          article_list: dataBox,
          article_category: res.data.article_category,
          cate_info: res.data.cate_info,
          cat_id: res.data.cat_id,
          loadpage: false
        })
       
        that.scrollLeft(that.data.currentNav) // 载入当前nav是第几个，计算左侧位置
      },
      fail: function() {
        
      }
    })
  },

  // 传入参数重新加载
  douMenu: function(e) {
    this.setData({
      cat_id: e.currentTarget.dataset.catid,
      page: 1,
      nomore: false,
      currentNav: e.currentTarget.dataset.index
    })
    this.loadData()
  },

  // 载入当前nav是第几个，计算左侧位置
  scrollLeft: function(currentNav = 1) {
    var that = this;

    // 获取导航的初始位置
    const query = wx.createSelectorQuery()
    query.selectAll('.navScroll .item').boundingClientRect();
    query.exec(function(res) {
      var num = 0
      // 计算当前nav左侧view宽度总和
      for (var i = 0; i < currentNav; i++) {
        num += res[0][i].width
      }

      that.setData({
        scrollLeft: Math.ceil(num)
      })
    })
  },
 
  onReachBottom: function () { // 触底开始下一页
    var that = this;
    
    if (!that.data.nomore) {
      var page = that.data.page + 1; // 获取当前页数并+1
    
      that.setData({
        page: page, // 更新当前页数
        loadpage: true,//加载动画的显示
      })

      setTimeout (
        function() { //注意function这里不能缺少
          that.loadData(true); // 重新调用请求获取下一页数据
        },1000
      )
    }
  },
 
  // 非tabBar的页面，可以带参数
  douNavigateTo: function(e) {
    var url = e.currentTarget.dataset.url;
    wx.navigateTo({
      url: url
    })
  }

})