// pages/product_category/product_category.js
// 获取应用实例
const app = getApp()

// 引入utils全局函数
var utils = require('../../utils/util.js');

Page({
  data: {
    keyword: '',
    b: '',
    s: '',
    search_list: [],
    page: 1, // 初始页默认值为1
    nomore: false,
  },
 
  onLoad: function(options) {
    var that = this
    
    // 显示转发按钮
    utils.showShareMenu()
   
    wx.request({
      url: app.mp_url + 'databox.php?rec=common',
      success: function(res) {
        that.setData({
          lang: res.data.lang,
          site: res.data.site
        })
        wx.setNavigationBarTitle({
          title: res.data.lang.search
        })
      },
    })
    
    if (options.keyword) {
      that.setData({
        keyword: options.keyword
      })
    }
    
    that.loadData()
  },

  // 获取数据
  loadData: function(concat = false, page = '') {
    var that = this;
    
    wx.request({
      url: app.mp_url + 'search.php',
      data: {
        user_id: wx.getStorageSync('user_id'),
        shell: wx.getStorageSync('shell'),
        keyword: that.data.keyword,
        b: that.data.b,
        s: that.data.s,
        page: page ? page : that.data.page, // 从数据里获取当前页数
      },
      header: {
        "Connect-Key" : wx.getStorageSync('connect_key')
      },
      success: function(res) {
        wx.setNavigationBarTitle({
          title: res.data.title
        })
        
        if (concat) {
          var dataBox = that.data.search_list; // 从data获取当前datalist数组
          var dataNew = res.data.search_list; // 从此次请求返回的数据中获取新数组
          
          if (dataNew) {
            dataBox = dataBox.concat(dataNew); // 合并数组
          } else {
            that.setData({
              nomore: true
            })
          }
        } else {
          dataBox = res.data.search_list;
        }
        
        that.setData({
          search_list: dataBox,
          sort_list: res.data.sort_list,
          loading: false
        })
      },
    })
  },

  // 排序
  douSort: function(e) {
    this.setData({
      b: e.currentTarget.dataset.b,
      s: e.currentTarget.dataset.s,
      page: 1,
      nomore: false
    })
    
    this.loadData(false, 1)
  },
 
  onReachBottom: function () { // 触底开始下一页
    var that = this;
    
    if (!that.data.nomore) {
      var page = that.data.page + 1; // 获取当前页数并+1
    
      that.setData({
        page: page, // 更新当前页数
        loading: true,//加载动画的显示
      })
      
      setTimeout (
        function() { //注意function这里不能缺少
          that.loadData(true); // 重新调用请求获取下一页数据
        },1000
      )
    }
  },
 
  // 非tabBar的页面，可以带参数
  douNavigateTo: function(e) {
    var url = e.currentTarget.dataset.url;
    wx.navigateTo({
      url: url
    })
  }

})