// search.js
// 获取应用实例
const app = getApp()

// 引入utils全局函数
var utils = require('../../utils/util.js');

Page({
  /**
   * 页面的初始数据
   */
  data: {
    keyword: '',
    keyword_list: []
  },
  
  onLoad: function(options) {
    var that = this

    // 显示转发按钮
    utils.showShareMenu()

    wx.request({
      url: app.mp_url + 'databox.php?rec=common',
      success: function(res) {
        that.setData({
          lang: res.data.lang,
          site: res.data.site
        })
      },
    })
   
    that.setData({
      keyword: options.keyword
    })

  },
 
  onShow: function () {
    var that = this;
   
    that.setData({
      keyword_list: wx.getStorageSync('keyword_list') ? wx.getStorageSync('keyword_list') : []
    })
  },
    
  // 搜索
  douSearch: function(e) {
    let keyword_list = this.data.keyword_list;
    if (keyword_list.indexOf(e.detail.value.keyword)) {
      keyword_list.splice(0, 0, e.detail.value.keyword);
    }
    
    this.setData({
      keyword: e.detail.value.keyword,
      keyword_list: keyword_list
    })
    
    wx.setStorageSync('keyword_list', keyword_list)
   
    wx.navigateTo({
      url: '/pages/search/list?keyword=' + e.detail.value.keyword
    })
  },

  // 传入参数重新加载
  douKeyword: function(e) {
    this.setData({
      keyword: e.currentTarget.dataset.keyword
    })
    
    wx.navigateTo({
      url: '/pages/search/list?keyword=' + e.currentTarget.dataset.keyword
    })
  },
    
  // 删除搜索历史
  delHistory: function(e) {
    this.setData({
      keyword_list: []
    })
    
    wx.setStorageSync('keyword_list', [])
  },

  // 设置转发标题
  onShareAppMessage: function (options) {
    return {
      title: wx.getStorageSync('shareTitle')
    }
  }

})