<?php
/**
 * DouPHP
 * --------------------------------------------------------------------------------------------------
 * 版权所有 2013-2019 漳州豆壳网络科技有限公司，并保留所有权利。
 * 网站地址: http://www.dou.co
 * --------------------------------------------------------------------------------------------------
 * 这不是一个自由软件！您只能在遵守授权协议前提下对程序代码进行修改和使用；不允许对程序代码以任何形式任何目的的再发布。
 * 授权协议：http://www.dou.co/license.html
 * --------------------------------------------------------------------------------------------------
 * Author: DouCo
 * Release Date: 2019-01-08
 */
define('IN_DOUCO', true);

require (dirname(__FILE__) . '/include/init.php');

// rec操作项的初始化
$rec = $check->is_rec($_REQUEST['rec']) ? $_REQUEST['rec'] : '';

// 通用信息调用
if ($rec == 'common') {
    $data['lang'] = $_LANG;
    $data['site'] = $_CFG;
    $data['param'] = $_PARAM;
    $data['open'] = $_OPEN;
    $data['box_list'] = $_BOX_LIST;
    $data['fragment'] = $_FRAGMENT;
    $data['nav_list'] = $dou->get_nav_miniprogram('miniprogram_top');
}

// 获取购物车数量
elseif ($rec == 'cart_number') {
    // 权限验证
    $callback = $dou_user->check_login_state();
    if ($callback['msg'] == 'ok') {
        $user_id = $callback['user_id'];
    } else {
        $data['wrong'] = $_LANG['login_timeout'];
        die(json_encode($data));
    }

    if ($user_id) {
        $data['cart_number'] = $dou->get_one("SELECT SUM(item_number) FROM " . $dou->table('order_cart') . "WHERE user_id = '$user_id'"); // wx.setTabBarBadge必须使用字符串格式
    } else {
        $data['cart_number'] = 0;
    }
}

// 短信TOKEN
elseif ($rec == 'sms_token') {
    $data['sms'] = $sms->sms_token_set(); // 短信验证码令牌
}

// 评论列表
elseif ($rec == 'comment_list') {
    if ($_OPEN['comment']) {
        require (ROOT_PATH . 'include/comment.class.php');
        $module = $check->is_letter($_REQUEST['module']) ? trim($_REQUEST['module']) : exit;
        $item_id = $check->is_number($_REQUEST['item_id']) ? trim($_REQUEST['item_id']) : exit;
        $page = $check->is_number($_REQUEST['page']) ? trim($_REQUEST['page']) : 1;
        $comment = new Comment();
        $data['comment_list'] = $comment->get_comment_list($module, $item_id, 10, $page);
    } else {
        $data['comment_list'] = array();
    }
}

echo json_encode($data);

?>