<?php
/**
 * DouPHP
 * --------------------------------------------------------------------------------------------------
 * 版权所有 2013-2019 漳州豆壳网络科技有限公司，并保留所有权利。
 * 网站地址: http://www.dou.co
 * --------------------------------------------------------------------------------------------------
 * 这不是一个自由软件！您只能在遵守授权协议前提下对程序代码进行修改和使用；不允许对程序代码以任何形式任何目的的再发布。
 * 授权协议：http://www.dou.co/license.html
 * --------------------------------------------------------------------------------------------------
 * Author: DouCo
 * Release Date: 2019-01-08
 */
if (!defined('IN_DOUCO')) {
    die('Hacking attempt');
}

// 显示除了E_NOTICE(提示)和E_WARNING(警告)外的所有错误
error_reporting(E_ALL ^ (E_NOTICE | E_WARNING));

// 关闭 set_magic_quotes_runtime
if (version_compare(PHP_VERSION, '5.3.0', '<')) {
   set_magic_quotes_runtime(0);
} else {
   ini_set('magic_quotes_runtime', 0);
}

// 调整时区
if (version_compare(PHP_VERSION, '5.1', '>=')) date_default_timezone_set('PRC'); 

// 移动版标记
define('IS_MINIPROGRAM', true);

// 判断传输协议
define('HTTP', ((!empty($_SERVER['HTTPS']) && strtolower($_SERVER['HTTPS']) !== 'off') || (isset($_SERVER['HTTP_X_FORWARDED_PROTO']) && $_SERVER['HTTP_X_FORWARDED_PROTO'] === 'https' ) || (!empty($_SERVER['HTTP_FRONT_END_HTTPS']) && strtolower($_SERVER['HTTP_FRONT_END_HTTPS']) !== 'off')) ? 'https://' : 'http://');

// 载入配置文件与定义小程序URL
include_once ('../data/config.php');
define('MINIPROGRAM_URL', dirname(HTTP . $_SERVER['HTTP_HOST'] . $_SERVER['PHP_SELF']) . "/");

// 定义DouPHP基础常量
define('ROOT_PATH', str_replace(MINIPROGRAM_PATH . '/include/init.php', '', str_replace('\\', '/', __FILE__)));
define('ROOT_URL', preg_replace('/\/' . MINIPROGRAM_PATH . '\/*$/', '/', MINIPROGRAM_URL));

if (!file_exists(ROOT_PATH . "data/install.lock")) {
    header("Location: " . ROOT_URL . "install/index.php\n");
    exit();
}

// 载入DouPHP核心文件
require (ROOT_PATH . 'include/smarty.class.php');
require (ROOT_PATH . 'include/mysql.class.php');
require (ROOT_PATH . 'include/common.class.php');
require (ROOT_PATH . MINIPROGRAM_PATH . '/include/action.class.php');
require (ROOT_PATH . 'include/check.class.php');
require (ROOT_PATH . 'include/firewall.class.php');

// 实例化DouPHP核心类
$dou = new Action($dbhost, $dbuser, $dbpass, $dbname, $prefix, DOU_CHARSET);
$check = new Check();
$firewall = new Firewall();

// 定义系统标识
define('DOU_SHELL', $dou->get_one("SELECT value FROM " . $dou->table('config') . " WHERE name = 'hash_code'"));
define('DOU_ID', 'mini' . '_' . substr(md5(DOU_SHELL . 'miniprogram'), 0, 5));

// 读取站点信息
$_CFG = $dou->get_config();
$_PARAM = $dou->parameter(); // 参数设置

if (!defined('EXIT_INIT')) {
    // 设置页面缓存和编码
    header('Cache-control: private');
    header('Content-type: text/html; charset=' . DOU_CHARSET);
    
    // 豆壳防火墙
    $firewall->dou_firewall();
    
    // 系统模块
    $_MODULE = $dou->dou_module();
    
    // 载入语言文件
    foreach ((array) $_MODULE['lang'] as $lang_file) {
        require ($lang_file); // 载入系统语言文件
    }
    $_LANG['copyright'] = preg_replace('/d%/Ums', $_CFG['site_name'], $_LANG['copyright']);
 
    // 底部版权信息
    $_LANG['powered_by'] = $dou->decompile(array(0x50, 0x6f, 0x77, 0x65, 0x72, 0x65, 0x64, 0x20, 0x62, 0x79)) . ' DouPHP';
    if (file_exists($cdkey_file = ROOT_PATH . 'data/..cdkey.php')) {
        include_once ($cdkey_file);
        $decompile_init = $dou->decompile($_CDKEY);

        if ($decompile_init == substr(md5(DOU_SHELL), 16) . $_CFG['douphp_version'] . $dou->format_url(ROOT_URL)) {
            $_LANG['powered_by'] = '';
        }
    }
    
    // 初始化
    if (file_exists($user_class_file = ROOT_PATH . 'include/user.class.php')) {
        require ($user_class_file);
        require (ROOT_PATH . MINIPROGRAM_PATH . '/include/user.miniprogram.class.php');
        $dou_user = new DouUserMiniprogram();
    }

    // 如果存在自定义类则载入
    if (file_exists($other_class_file = ROOT_PATH . 'include/other.class.php')) {
          require ($other_class_file);
          $other = new Other();
    }

    // 短信服务
    if (file_exists($sms_class_file = ROOT_PATH . 'include/sms.class.php') && isset($_POST['storage_sms_token'])) {
        require ($sms_class_file);
        $sms = new Sms('miniprogram', $_POST['storage_sms_token']);
    }
    
    if (file_exists($cdkey_file = ROOT_PATH . 'data/..cdkey.php')) {
        include_once ($cdkey_file);
        $decompile_init = $dou->decompile($_CDKEY);

        if ($decompile_init == substr(md5(DOU_SHELL), 16) . $_CFG['douphp_version'] . $dou->format_url(ROOT_URL)) {
            $_AUTHORIZED = true;
        }
    }
 
    // 判断是否关闭站点
    if ($_CFG['site_closed']) {
        // 设置页面编码
        header('Content-type: text/html; charset=' . DOU_CHARSET);
        
        echo "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\"><div style=\"margin: 200px; text-align: center; font-size: 14px\"><p>" . $_LANG['site_closed'] . "</p><p></p></div>";
        exit();
    }
    
    // 通用信息调用
    $_URL = $dou->dou_url();
    $_URL['catalog'] = $dou->rewrite_url('catalog');
    $_OPEN = $_MODULE['open']; // 模块开启状态
    $_OPEN['offlinepay'] = $dou->value_exist('plugin', 'unique_id', 'offlinepay');
    $_DISPLAY = unserialize($_CFG['mobile_display']); // 显示设置
    $_DEFINED = unserialize($_CFG['defined']); // 自定义属性
    $_BOX_LIST = $dou->get_box();
    $_FRAGMENT = $dou->get_fragment();
    $_LANG_MENU = $dou->get_lang_menu($_CUR_LANG['pack']);
}

// 开启缓冲区
ob_start();
?>