<?php
/**
 * DouPHP
 * --------------------------------------------------------------------------------------------------
 * 版权所有 2013-2019 漳州豆壳网络科技有限公司，并保留所有权利。
 * 网站地址: http://www.dou.co
 * --------------------------------------------------------------------------------------------------
 * 这不是一个自由软件！您只能在遵守授权协议前提下对程序代码进行修改和使用；不允许对程序代码以任何形式任何目的的再发布。
 * 授权协议：http://www.dou.co/license.html
 * --------------------------------------------------------------------------------------------------
 * Author: DouCo
 * Release Date: 2019-01-08
 */
define('IN_DOUCO', true);

require (dirname(__FILE__) . '/include/init.php');

// rec操作项的初始化
$rec = $check->is_rec($_REQUEST['rec']) ? $_REQUEST['rec'] : 'default';

// 验证并获取合法的ID，如果不合法将其设定为-1
$id = $firewall->get_legal_id('product', $_REQUEST['id'], $_REQUEST['unique_id']);
if ($id == -1)
    exit;
    
// 获取登录信息
if ($_OPEN['user']) 
    $user_id = $dou_user->check_login_state();

/**
 * +----------------------------------------------------------
 * 商品详情
 * +----------------------------------------------------------
 */
if ($rec == 'default') {
    // 获取产品信息
    $product = $dou->get_row('product', '*', "id = '$id'");
    $level_price = $dou->level_price($product['level_price'], $user_id); // 会员等级价格

    // 格式化数据
    $product['price_format'] = $product['price'] > 0 ? $dou->price_format($product['price']) : $_LANG['price_discuss'];
    $product['level_price'] = $level_price ? $dou->price_format($level_price) : '';
    $product['add_time'] = date("Y-m-d", $product['add_time']);
    $product['image'] = $dou->dou_file($product['image']);

    // 格式化自定义参数
    foreach (explode(',', $product['defined']) as $row) {
        $row = explode('：', str_replace(":", "：", $row));

        if ($row['1']) {
            $defined[] = array (
                    "arr" => $row['0'],
                    "value" => $row['1'] 
            );
        }
    }

    // 数据封装
    $data['defined'] = $defined;
    $data['title'] = $_LANG['product_detail'];
    $data['product'] = $product;
    $data['open']['order'] = $_OPEN['order'];
}

/**
 * +----------------------------------------------------------
 * 规格属性
 * +----------------------------------------------------------
 */
elseif ($rec == 'attribute_list') {
    $attribute_data = get_object_vars(json_decode(str_replace("\\", "", $_REQUEST['attribute_data'])));
    
    // 获取产品信息
    $product = $dou->get_row('product', 'id, cat_id, price, point', "id = '$id'");

    // 数据
    $product_price = $product['price'];
    $product_point = $product['point'];
    $money_exchange_point = $product['point'] / $product['price'];

    // 款式属性模块
    if ($_OPEN['attribute']) {
        include_once (ROOT_PATH . 'include/attribute.class.php');
        $dou_attribute = new Attribute();
        $attribute_list = $dou_attribute->get_attribute_list($product['cat_id'], $product['id'], 'common', $attribute_data);
        foreach ($attribute_list as $attribute) {
            $product_price = $product_price + $attribute['selected_value_price_change'];
            $product_point = $product_point + $attribute['selected_value_price_change'] * $money_exchange_point;
        }
    }
 
    // 数据封装
    $data['attribute_list'] = $attribute_list;
    $data['product_price'] = $dou->price_format($product_price);
    $data['product_point'] = ceil($product_point);
}

echo json_encode($data);

?>