<?php
/**
 * DouPHP
 * --------------------------------------------------------------------------------------------------
 * 版权所有 2013-2019 漳州豆壳网络科技有限公司，并保留所有权利。
 * 网站地址: http://www.dou.co
 * --------------------------------------------------------------------------------------------------
 * 这不是一个自由软件！您只能在遵守授权协议前提下对程序代码进行修改和使用；不允许对程序代码以任何形式任何目的的再发布。
 * 授权协议：http://www.dou.co/license.html
 * --------------------------------------------------------------------------------------------------
 * Author: DouCo
 * Release Date: 2019-01-08
 */
define('IN_DOUCO', true);

require (dirname(__FILE__) . '/include/init.php');

// rec操作项的初始化
$rec = $check->is_rec($_REQUEST['rec']) ? $_REQUEST['rec'] : 'default';

// 获取登录信息
if ($_OPEN['user']) 
    $user_id = $dou_user->check_login_state();

// 验证并获取合法的ID，如果不合法将其设定为-1
$cat_id = $firewall->get_legal_id('product_category', $_REQUEST['cat_id'], $_REQUEST['unique_id']);
if ($cat_id == -1 || $cat_id == 0)
    $cat_id = $dou->get_one("SELECT cat_id FROM " . $dou->table('product_category') . " ORDER BY sort ASC, cat_id ASC");

$where = ' WHERE cat_id IN (' . $cat_id . $dou->dou_child_id('product_category', $cat_id) . ')';

// 排序
$dou_sort = $dou->dou_sort('sales, price, add_time, sort', 'price', 'sort ASC, id DESC', $_REQUEST['b'], $_REQUEST['s'], '/pages/search/list');

// 未加入分页条件的SQL语句
$sql = "SELECT * FROM " . $dou->table('product') . $where . $dou_sort['sql'];

// 获取分页信息
$page = $check->is_number($_REQUEST['page']) ? trim($_REQUEST['page']) : 1;
$limit = $dou->pager($sql, 6, $page);

/* 获取产品列表 */
$sql = $sql . $limit; // 加入分页条件的SQL语句
$query = $dou->query($sql);
while ($row = $dou->fetch_array($query)) {
    // 多语言
    $row = $dou->lang_box($row, 'product', 'name, content, description');
    
    // 如果描述不存在则自动从详细介绍中截取
    $description = $row['description'] ? $row['description'] : $dou->dou_substr($row['content'], 150, false);
    
    // 等级价格
    $level_price = $dou->level_price($row['level_price']); // 会员等级价格
    
    // 对应的分类信息
    $cate_info_row = $dou->get_row('product_category', 'cat_id, cat_name', "cat_id = '$row[cat_id]'");
    $cate_info_row['url'] = $dou->rewrite_url_miniprogram('product_category', $row['cat_id']);
    
    $product_list[] = array (
            "id" => $row['id'],
            "cat_id" => $row['cat_id'],
            "name" => $row['name'],
            "defined" => $dou->format_defined($row['defined']),
            "price" => $row['price'] > 0 ? $dou->price_format($row['price']) : $_LANG['price_discuss'],
            "level_price" => $level_price ? $dou->price_format($level_price) : '',
            "thumb" => $dou->dou_file($row['image'], true),
            "image" => $dou->dou_file($row['image']),
            "defined" => $dou->format_defined($row['defined']),
            "add_time" => date("Y-m-d", $row['add_time']),
            "description" => $description,
            "url" => $dou->rewrite_url_miniprogram('product', $row['id']),
            "cate_info" => $cate_info_row
    );
}

// 获取分类信息
$cate_info = $dou->get_row('product_category', '*', "cat_id = '$cat_id'");

// 数据封装
$data['title'] = $cate_info ? $cate_info['cat_name'] : $_LANG['product'];
$data['cat_id'] = $cat_id;
$data['sort_list'] = $dou_sort['field'];
$data['product_list'] = $product_list;
$data['product_category'] = $dou->get_category('product_category', 0, $cat_id);
$data['cate_info'] = $cate_info;

echo json_encode($data);

?>