<?php
/**
 * DouPHP
 * --------------------------------------------------------------------------------------------------
 * 版权所有 2013-2024 漳州豆壳网络科技有限公司，并保留所有权利。
 * 网站地址: http://www.douphp.com
 * --------------------------------------------------------------------------------------------------
 * 这不是一个自由软件！您只能在遵守授权协议前提下对程序代码进行修改和使用；不允许对程序代码以任何形式任何目的的再发布。
 * 授权协议: http://www.douphp.com/license.html
 * --------------------------------------------------------------------------------------------------
 * Author: DouCo Co.,Ltd.
 * Release Date: 2024-09-30
 */
define('IN_DOUCO', true);

require (dirname(__FILE__) . '/include/init.php');

// rec操作项的初始化
$rec = $check->is_rec($_REQUEST['rec']) ? $_REQUEST['rec'] : 'default';

// 获取登录信息
if ($_OPEN['user']) 
    $user_id = $dou_user->check_login_state();

$module = $_PARAM['search_module'] ? $_PARAM['search_module'] : 'product';

// 搜索关键词
if ($_REQUEST['keyword']) {
    if (!$check->is_search_keyword($keyword = trim($_REQUEST['keyword']))) {
        $data['wrong'] = $_LANG['illegal'];
            die(json_encode($data));
    }
    
    $where = $module == 'product' ? " WHERE name LIKE '%$keyword%'" : " WHERE title LIKE '%$keyword%'";
}

// 排序
$dou_sort = $dou->dou_sort('sales, price, add_time, sort', 'price', 'sort ASC, id DESC', $_REQUEST['b'], $_REQUEST['s']);

// 未加入分页条件的SQL语句
$sql = "SELECT * FROM " . $dou->table($module) . $where . $dou_sort['sql'];

// 获取分页信息
$page = $check->is_number($_REQUEST['page']) ? trim($_REQUEST['page']) : 1;
$limit = $dou->pager($sql, 10, $page);

/* 获取搜索结果列表 */
$sql = $sql . $limit; // 加入分页条件的SQL语句
$query = $dou->query($sql);
while ($row = $dou->fetch_array($query)) {
    $url = $dou->rewrite_url($module, $row['id']);
    $add_time = date("Y-m-d", $row['add_time']);
    $add_time_short = date("m-d", $row['add_time']);
    $description = $row['description'] ? $row['description'] : $dou->dou_substr($row['content'], 150);
    $price = $row['price'] > 0 ? $dou->price_format($row['price']) : $_LANG['price_discuss'];
    $thumb = $dou->dou_file($row['image'], true);

    // 对应的分类信息
    $cate_info_row = $dou->get_row($module . '_category', 'cat_id, cat_name', "cat_id = '$row[cat_id]'");
    $cate_info_row['url'] = $dou->rewrite_url($module . '_category', $row['cat_id']);

    $search_list[] = array (
            "id" => $row['id'],
            "cat_id" => $row['cat_id'],
            "module" => $row['module'],
            "name" => $row['name'] ? $row['name'] : $row['title'],
            "title" => $row['title'] ? $row['title'] : $row['name'],
            "price" => $price,
            "image" => $module == 'product' ? $thumb : $dou->dou_file($row['image']),
            "thumb" => $thumb,
            "add_time" => $add_time,
            "add_time_short" => $add_time_short,
            "time" => $dou->format_time($row['add_time']),
            "click" => $row['click'],
            "description" => $description,
            "url" => $url,
            "cate_info" => $cate_info_row
    );
}
// 数据封装
$data['sort_list'] = $dou_sort['field'];
$data['sql'] = $sql;
$data['search_list'] = $search_list;
$data['title'] = $keyword ? preg_replace('/d%/Ums', $keyword, $_LANG['search_results']) : $_LANG[$module];

echo json_encode($data);

?>