-- ----------------------------
-- Table structure for sd_ad
-- ----------------------------
DROP TABLE IF EXISTS `sd_ad`;
CREATE TABLE `sd_ad` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `title` varchar(50) DEFAULT '',
  `datalist` text,
  `ordnum` int(10) DEFAULT '0',
  `islock` int(10) DEFAULT '0',
  `akey` varchar(10) DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;;

-- ----------------------------
-- Table structure for sd_admin
-- ----------------------------
DROP TABLE IF EXISTS `sd_admin`;
CREATE TABLE `sd_admin` (
  `adminid` int(10) NOT NULL AUTO_INCREMENT,
  `adminname` varchar(50) DEFAULT '',
  `adminpass` varchar(50) DEFAULT '',
  `penname` varchar(20) DEFAULT '',
  `pid` int(10) DEFAULT '0',
  `logintimes` int(10) DEFAULT '0',
  `lastlogindate` int(10) DEFAULT '0',
  `lastloginip` varchar(50) DEFAULT '',
  `islock` int(10) DEFAULT '0',
  `readonly` smallint(1) DEFAULT '0',
  PRIMARY KEY (`adminid`),
  KEY `adminname` (`adminname`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;;

-- ----------------------------
-- Table structure for sd_admin_log
-- ----------------------------
DROP TABLE IF EXISTS `sd_admin_log`;
CREATE TABLE `sd_admin_log` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `title` varchar(50) DEFAULT '',
  `url` varchar(255) DEFAULT '',
  `msg` varchar(255) DEFAULT '',
  `ip` varchar(50) DEFAULT '',
  `createdate` int(10) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;;

-- ----------------------------
-- Table structure for sd_admin_login_log
-- ----------------------------
DROP TABLE IF EXISTS `sd_admin_login_log`;
CREATE TABLE `sd_admin_login_log` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `loginname` varchar(50) DEFAULT '',
  `loginip` varchar(50) DEFAULT '',
  `logindate` int(10) DEFAULT '0',
  `loginmsg` varchar(255) DEFAULT '',
  `loginstate` int(1) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;;

-- ----------------------------
-- Table structure for sd_admin_menu
-- ----------------------------
DROP TABLE IF EXISTS `sd_admin_menu`;
CREATE TABLE `sd_admin_menu` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `title` varchar(50) DEFAULT '',
  `cname` varchar(50) DEFAULT '',
  `aname` varchar(50) DEFAULT '',
  `dname` varchar(255) DEFAULT '',
  `followid` int(10) DEFAULT '0',
  `ordnum` int(10) DEFAULT '0',
  `islock` int(10) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;;

-- ----------------------------
-- Table structure for sd_admin_part
-- ----------------------------
DROP TABLE IF EXISTS `sd_admin_part`;
CREATE TABLE `sd_admin_part` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `title` varchar(50) DEFAULT '',
  `ordnum` int(10) DEFAULT '0',
  `page_list` text,
  `cate_list` text,
  `pagelever` varchar(50) DEFAULT '',
  `pagelock` smallint(1) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;;

-- ----------------------------
-- Table structure for sd_alias
-- ----------------------------
DROP TABLE IF EXISTS `sd_alias`;
CREATE TABLE `sd_alias` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `alias` varchar(50) DEFAULT '',
  `app` varchar(255) DEFAULT '',
  `sid` int(10) DEFAULT '0',
  `types` int(10) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `alias` (`alias`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;;

-- ----------------------------
-- Table structure for sd_attachment
-- ----------------------------
DROP TABLE IF EXISTS `sd_attachment`;
CREATE TABLE `sd_attachment` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT '1：图片，2：视频，3：其他文件',
  `file_url` varchar(255) DEFAULT '',
  `file_name` varchar(255) DEFAULT '' COMMENT '文件名',
  `file_ext` varchar(50) DEFAULT '' COMMENT '后缀',
  `file_size` int(10) DEFAULT '0',
  `file_type` int(10) DEFAULT '0' COMMENT '1：图片，2：视频，3：其他',
  `file_update` int(10) DEFAULT '0' COMMENT '上传的日期',
  `file_local` int(10) DEFAULT '0' COMMENT '存放位置（1：本地，2：阿里云，3：七牛云）',
  `file_adminid` int(10) DEFAULT '0',
  `file_userid` int(10) DEFAULT '0',
  `file_ip` varchar(50) DEFAULT '' COMMENT '传者上IP',
  `gid` int(10) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `type` (`file_type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;;

-- ----------------------------
-- Table structure for sd_attachment_group
-- ----------------------------
DROP TABLE IF EXISTS `sd_attachment_group`;
CREATE TABLE `sd_attachment_group` (
  `aid` int(10) NOT NULL AUTO_INCREMENT,
  `gname` varchar(50) DEFAULT '',
  `ordnum` int(10) DEFAULT '0',
  `islock` smallint(1) DEFAULT '0',
  PRIMARY KEY (`aid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;;

-- ----------------------------
-- Table structure for sd_auth
-- ----------------------------
DROP TABLE IF EXISTS `sd_auth`;
CREATE TABLE `sd_auth` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `ckey` varchar(50) DEFAULT '',
  `cval` text,
  `cdate` varchar(255) DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;;

-- ----------------------------
-- Table structure for sd_auto_key
-- ----------------------------
DROP TABLE IF EXISTS `sd_auto_key`;
CREATE TABLE `sd_auto_key` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `title` varchar(50) DEFAULT '',
  `reply_type` int(10) DEFAULT '0',
  `reply_text` text,
  `reply_id` int(10) DEFAULT '0',
  `matchtype` int(10) DEFAULT '0',
  `ordnum` int(10) DEFAULT '0',
  `islock` int(10) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;;

-- ----------------------------
-- Table structure for sd_auto_reply
-- ----------------------------
DROP TABLE IF EXISTS `sd_auto_reply`;
CREATE TABLE `sd_auto_reply` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `reply_key` varchar(50) DEFAULT '',
  `reply_type` int(10) DEFAULT '0',
  `reply_text` text,
  `reply_id` int(10) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;;

-- ----------------------------
-- Table structure for sd_badword
-- ----------------------------
DROP TABLE IF EXISTS `sd_badword`;
CREATE TABLE `sd_badword` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `words` mediumtext,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;;

-- ----------------------------
-- Table structure for sd_bbs
-- ----------------------------
DROP TABLE IF EXISTS `sd_bbs`;
CREATE TABLE `sd_bbs` (
  `bbs_id` int(10) NOT NULL AUTO_INCREMENT,
  `fid` int(10) DEFAULT '0',
  `title` varchar(255) DEFAULT '',
  `userid` int(10) DEFAULT '0',
  `islock` tinyint(4) DEFAULT '0',
  `ontop` tinyint(4) DEFAULT '0',
  `isnice` tinyint(4) DEFAULT '0',
  `hits` int(10) DEFAULT '0',
  `replynum` int(10) DEFAULT '0',
  `createdate` int(10) DEFAULT '0',
  PRIMARY KEY (`bbs_id`),
  KEY `title` (`title`),
  KEY `islock` (`islock`),
  KEY `fid` (`fid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;;

-- ----------------------------
-- Table structure for sd_bbs_cate
-- ----------------------------
DROP TABLE IF EXISTS `sd_bbs_cate`;
CREATE TABLE `sd_bbs_cate` (
  `cateid` int(10) NOT NULL AUTO_INCREMENT,
  `catename` varchar(50) DEFAULT '',
  `seotitle` varchar(255) DEFAULT '',
  `seokey` varchar(255) DEFAULT '',
  `seodesc` varchar(255) DEFAULT '',
  `ordnum` int(10) DEFAULT '0',
  `isshow` tinyint(4) DEFAULT '0',
  `view_group` varchar(255) DEFAULT '',
  `post_group` varchar(255) DEFAULT '',
  `reply_group` varchar(255) DEFAULT '',
  `cate_icon` varchar(255) DEFAULT '',
  PRIMARY KEY (`cateid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;;

-- ----------------------------
-- Table structure for sd_bbs_reply
-- ----------------------------
DROP TABLE IF EXISTS `sd_bbs_reply`;
CREATE TABLE `sd_bbs_reply` (
  `replyid` int(10) NOT NULL AUTO_INCREMENT,
  `bbsid` int(10) DEFAULT '0',
  `userid` int(10) DEFAULT '0',
  `istopic` tinyint(4) DEFAULT '0' COMMENT '是否为主题',
  `content` mediumtext,
  `reply` text,
  `createdate` int(10) DEFAULT '0',
  `islock` int(10) DEFAULT '0',
  PRIMARY KEY (`replyid`),
  KEY `bbsid` (`bbsid`),
  KEY `istopic` (`istopic`),
  KEY `islock` (`islock`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;;

-- ----------------------------
-- Table structure for sd_book
-- ----------------------------
DROP TABLE IF EXISTS `sd_book`;
CREATE TABLE `sd_book` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `truename` varchar(50) DEFAULT '',
  `tel` varchar(20) DEFAULT '',
  `mobile` varchar(11) DEFAULT '',
  `remark` text,
  `reply` text,
  `ontop` int(10) DEFAULT '0',
  `islock` int(10) DEFAULT '0',
  `createdate` int(10) DEFAULT '0',
  `postip` varchar(20) DEFAULT '',
  `replydate` int(10) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;;

-- ----------------------------
-- Table structure for sd_category
-- ----------------------------
DROP TABLE IF EXISTS `sd_category`;
CREATE TABLE `sd_category` (
  `cateid` int(10) NOT NULL AUTO_INCREMENT,
  `catename` varchar(50) DEFAULT '',
  `followid` int(10) DEFAULT '0',
  `catenum` int(10) DEFAULT '0',
  `catetype` int(11) DEFAULT '0',
  `cateurl` varchar(255) DEFAULT '',
  `catepage` int(10) DEFAULT '0',
  `catelist` varchar(255) DEFAULT '',
  `cateshow` varchar(255) DEFAULT '',
  `catetitle` varchar(255) DEFAULT '',
  `catekey` varchar(255) DEFAULT '',
  `catedesc` varchar(255) DEFAULT '',
  `isshow` int(10) DEFAULT '0',
  `isblank` int(10) DEFAULT '0',
  `isfilter` int(10) DEFAULT '0',
  `catedomain` varchar(255) DEFAULT '',
  `cate_extend` int(10) DEFAULT '0',
  `cate_groupid` varchar(50) DEFAULT '',
  `myename` varchar(255) DEFAULT '',
  `myfoot` varchar(255) DEFAULT '',
  `mycatepic` varchar(255) DEFAULT '',
  `mycateimg` varchar(255) DEFAULT '',
  PRIMARY KEY (`cateid`),
  KEY `followid` (`followid`),
  KEY `ordnum` (`catenum`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;;

-- ----------------------------
-- Table structure for sd_category_field
-- ----------------------------
DROP TABLE IF EXISTS `sd_category_field`;
CREATE TABLE `sd_category_field` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `field_title` varchar(50) DEFAULT '',
  `field_key` varchar(50) DEFAULT '',
  `field_type` int(50) DEFAULT '0',
  `field_length` int(10) DEFAULT '0',
  `field_upload_type` int(10) DEFAULT '0',
  `field_default` varchar(255) DEFAULT '',
  `field_list` text,
  `field_sql` varchar(255) DEFAULT '',
  `field_tips` varchar(255) DEFAULT '',
  `field_rule` int(10) DEFAULT '0',
  `field_radio` int(10) DEFAULT '0',
  `field_editor` int(10) DEFAULT '0',
  `ordnum` int(10) DEFAULT '0',
  `islock` int(10) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;;

-- ----------------------------
-- Table structure for sd_city
-- ----------------------------
DROP TABLE IF EXISTS `sd_city`;
CREATE TABLE `sd_city` (
  `cateid` int(10) NOT NULL AUTO_INCREMENT COMMENT '区域主键',
  `name` varchar(20) DEFAULT '' COMMENT '区域名称',
  `followid` int(10) DEFAULT '0' COMMENT '上级',
  `ordnum` int(10) DEFAULT '0',
  `site_open` smallint(1) DEFAULT '0' COMMENT '是否开启分站功能',
  `site_root` varchar(50) DEFAULT '' COMMENT '路径',
  `site_domain` smallint(1) DEFAULT '0' COMMENT '是否绑定域名',
  `issys` smallint(1) DEFAULT '0',
  `site_self` smallint(1) DEFAULT '0',
  `site_title` varchar(255) DEFAULT '',
  `site_key` varchar(255) DEFAULT '',
  `site_desc` varchar(255) DEFAULT '',
  PRIMARY KEY (`cateid`),
  KEY `followid` (`followid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;;

-- ----------------------------
-- Table structure for sd_code
-- ----------------------------
DROP TABLE IF EXISTS `sd_code`;
CREATE TABLE `sd_code` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `email` varchar(255) DEFAULT '',
  `code` varchar(50) DEFAULT '',
  `types` int(10) DEFAULT '0',
  `createdate` int(10) DEFAULT '0',
  `isover` int(10) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;;

-- ----------------------------
-- Table structure for sd_config
-- ----------------------------
DROP TABLE IF EXISTS `sd_config`;
CREATE TABLE `sd_config` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `gid` int(10) DEFAULT '0',
  `ckey` varchar(50) DEFAULT '',
  `ctitle` varchar(50) DEFAULT '',
  `cvalue` text,
  `ordnum` int(10) DEFAULT '0',
  `ctype` int(10) DEFAULT '0',
  `dvalue` text,
  `dtext` varchar(255) DEFAULT '',
  `rtype` int(10) DEFAULT '0',
  `utype` int(10) DEFAULT '0',
  `islock` int(10) DEFAULT '0',
  `issys` int(10) DEFAULT '0',
  `ishide` smallint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `ckey` (`ckey`),
  KEY `gid` (`gid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;;

-- ----------------------------
-- Table structure for sd_config_group
-- ----------------------------
DROP TABLE IF EXISTS `sd_config_group`;
CREATE TABLE `sd_config_group` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `gname` varchar(50) DEFAULT '',
  `ordnum` int(10) DEFAULT '0',
  `gkey` varchar(50) DEFAULT '',
  `islock` int(10) DEFAULT '0',
  `types` int(1) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;;

-- ----------------------------
-- Table structure for sd_content
-- ----------------------------
DROP TABLE IF EXISTS `sd_content`;
CREATE TABLE `sd_content` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT '',
  `pic` varchar(255) DEFAULT '',
  `ispic` int(10) DEFAULT '0',
  `classid` int(10) DEFAULT '0',
  `hits` int(10) DEFAULT '0',
  `islock` int(10) DEFAULT '0',
  `ontop` int(10) DEFAULT '0',
  `isnice` int(10) DEFAULT '0',
  `ordnum` int(10) DEFAULT '0',
  `upnum` int(10) DEFAULT '0',
  `downnum` int(10) DEFAULT '0',
  `isurl` int(10) DEFAULT '0',
  `url` varchar(255) DEFAULT '',
  `createdate` int(10) DEFAULT '0',
  `lastupdate` int(10) DEFAULT '0',
  `intro` text,
  `tags` varchar(255) DEFAULT '',
  `seotitle` varchar(255) DEFAULT '',
  `seokey` varchar(255) DEFAULT '',
  `seodesc` varchar(255) DEFAULT '',
  `alias` varchar(50) DEFAULT '',
  `showskin` varchar(255) DEFAULT '',
  `extend` text,
  `subid` varchar(255) DEFAULT '',
  `adminid` int(10) DEFAULT '0',
  `isauto` int(10) DEFAULT '0',
  `view_groupid` varchar(50) DEFAULT '',
  `tagslist` varchar(500) DEFAULT '',
  `ispush` int(10) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `order` (`id`,`ontop`,`ordnum`,`classid`,`islock`),
  KEY `ontop` (`id`,`ontop`),
  KEY `ordnum` (`id`,`ordnum`),
  KEY `where` (`islock`,`classid`,`id`,`subid`),
  KEY `subid` (`subid`),
  KEY `isauto` (`islock`,`isauto`,`createdate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;;

-- ----------------------------
-- Table structure for sd_extend
-- ----------------------------
DROP TABLE IF EXISTS `sd_extend`;
CREATE TABLE `sd_extend` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `title` varchar(50) DEFAULT '',
  `ordnum` int(10) DEFAULT '0',
  `islock` int(10) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;;

-- ----------------------------
-- Table structure for sd_extend_field
-- ----------------------------
DROP TABLE IF EXISTS `sd_extend_field`;
CREATE TABLE `sd_extend_field` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `eid` int(10) DEFAULT '0',
  `field_title` varchar(50) DEFAULT '',
  `field_key` varchar(50) DEFAULT '',
  `field_type` int(10) DEFAULT '0',
  `field_list` text,
  `field_default` varchar(50) DEFAULT '',
  `ordnum` int(10) DEFAULT '0',
  `islock` int(10) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;;

-- ----------------------------
-- Table structure for sd_form
-- ----------------------------
DROP TABLE IF EXISTS `sd_form`;
CREATE TABLE `sd_form` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `title` varchar(50) DEFAULT '',
  `tablename` varchar(255) DEFAULT '',
  `add_skins` varchar(255) DEFAULT '',
  `list_skins` varchar(255) DEFAULT '',
  `show_skins` varchar(255) DEFAULT '',
  `seotitle` varchar(255) DEFAULT '',
  `seokey` varchar(255) DEFAULT '',
  `seodesc` varchar(255) DEFAULT '',
  `iscode` int(10) DEFAULT '0',
  `backway` int(10) DEFAULT '0',
  `mid` int(10) DEFAULT '0',
  `ordnum` int(10) DEFAULT '0',
  `islock` int(10) DEFAULT '0',
  `isuser` smallint(1) DEFAULT '0',
  `publish_state` smallint(1) DEFAULT '0',
  `publish_limit` int(10) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;;

-- ----------------------------
-- Table structure for sd_form_field
-- ----------------------------
DROP TABLE IF EXISTS `sd_form_field`;
CREATE TABLE `sd_form_field` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `form_id` int(10) DEFAULT '0',
  `field_title` varchar(50) DEFAULT '',
  `field_key` varchar(50) DEFAULT '',
  `field_type` int(50) DEFAULT '0',
  `field_length` int(10) DEFAULT '0',
  `field_upload_type` int(10) DEFAULT '0',
  `field_default` varchar(255) DEFAULT '',
  `field_list` text,
  `field_sql` varchar(255) DEFAULT '',
  `field_tips` varchar(255) DEFAULT '',
  `field_rule` int(10) DEFAULT '0',
  `field_radio` int(10) DEFAULT '0',
  `field_editor` int(10) DEFAULT '0',
  `field_filter` int(10) DEFAULT '0',
  `field_table` varchar(50) DEFAULT '',
  `field_join` varchar(255) DEFAULT '',
  `field_where` varchar(255) DEFAULT '',
  `field_order` varchar(255) DEFAULT '',
  `field_value` varchar(50) DEFAULT '',
  `field_label` varchar(50) DEFAULT '',
  `islist` int(10) DEFAULT '0',
  `ordnum` int(10) DEFAULT '0',
  `islock` int(10) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;;

-- ----------------------------
-- Table structure for sd_form_resume
-- ----------------------------
DROP TABLE IF EXISTS `sd_form_resume`;
CREATE TABLE `sd_form_resume` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `postip` varchar(50) DEFAULT '',
  `ordnum` int(10) DEFAULT '0',
  `islock` int(10) DEFAULT '0',
  `createdate` int(10) DEFAULT '0',
  `lastupdate` int(10) DEFAULT '0',
  `my_title` varchar(255) DEFAULT '',
  `my_truename` varchar(20) DEFAULT '',
  `my_sex` int(10) DEFAULT '0',
  `my_age` int(10) DEFAULT '0',
  `my_mobile` varchar(11) DEFAULT '',
  `my_education` int(10) DEFAULT '0',
  `my_work_exp` text,
  `my_intro` text,
  `userid` int(10) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;;

-- ----------------------------
-- Table structure for sd_inquiry
-- ----------------------------
DROP TABLE IF EXISTS `sd_inquiry`;
CREATE TABLE `sd_inquiry` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT '',
  `truename` varchar(50) DEFAULT '',
  `mobile` varchar(20) DEFAULT '',
  `remark` text,
  `createdate` int(10) DEFAULT '0',
  `isover` int(10) DEFAULT '0',
  `postip` varchar(50) DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;;

-- ----------------------------
-- Table structure for sd_link
-- ----------------------------
DROP TABLE IF EXISTS `sd_link`;
CREATE TABLE `sd_link` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `webname` varchar(50) DEFAULT '',
  `weblogo` varchar(255) DEFAULT '',
  `weburl` varchar(255) DEFAULT '',
  `islogo` int(10) DEFAULT '0',
  `classid` int(10) DEFAULT '0',
  `ordnum` int(10) DEFAULT '0',
  `islock` int(10) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;;

-- ----------------------------
-- Table structure for sd_mass
-- ----------------------------
DROP TABLE IF EXISTS `sd_mass`;
CREATE TABLE `sd_mass` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `title` int(10) DEFAULT '0',
  `mass_type` int(10) DEFAULT '0',
  `mass_text` text,
  `mass_id` int(10) DEFAULT '0',
  `isover` int(10) DEFAULT '0',
  `total_num` int(10) DEFAULT '0',
  `success_num` int(10) DEFAULT '0',
  `fail_num` int(10) DEFAULT '0',
  `msg_id` varchar(255) DEFAULT '',
  `post_type` smallint(2) DEFAULT '0',
  `wxname` varchar(255) DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;;

-- ----------------------------
-- Table structure for sd_mater
-- ----------------------------
DROP TABLE IF EXISTS `sd_mater`;
CREATE TABLE `sd_mater` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `title` varchar(50) DEFAULT '',
  `media_id` varchar(255) DEFAULT '',
  `islock` int(10) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;;

-- ----------------------------
-- Table structure for sd_mater_data
-- ----------------------------
DROP TABLE IF EXISTS `sd_mater_data`;
CREATE TABLE `sd_mater_data` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `cid` int(10) DEFAULT '0',
  `title` varchar(255) DEFAULT '',
  `pic` varchar(255) DEFAULT '',
  `intro` varchar(255) DEFAULT '',
  `content` text,
  `url` varchar(1000) DEFAULT '',
  `ordnum` int(10) DEFAULT '0',
  `piclist` text,
  `media_id` varchar(255) DEFAULT '',
  `media_date` int(10) DEFAULT '0',
  `islock` int(10) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;;

-- ----------------------------
-- Table structure for sd_model
-- ----------------------------
DROP TABLE IF EXISTS `sd_model`;
CREATE TABLE `sd_model` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `title` varchar(50) DEFAULT '',
  `tablename` varchar(50) DEFAULT '',
  `model_desc` varchar(255) DEFAULT '',
  `list_skins` varchar(255) DEFAULT '',
  `show_skins` varchar(255) DEFAULT '',
  `form_group` varchar(255) DEFAULT '',
  `ordnum` int(10) DEFAULT '0',
  `islock` int(10) DEFAULT '0',
  `issys` int(10) DEFAULT '0',
  `leverstate` smallint(1) DEFAULT '0',
  `buystate` smallint(1) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;;

-- ----------------------------
-- Table structure for sd_model_field
-- ----------------------------
DROP TABLE IF EXISTS `sd_model_field`;
CREATE TABLE `sd_model_field` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `model_id` int(10) DEFAULT '0',
  `field_title` varchar(50) DEFAULT '',
  `field_key` varchar(50) DEFAULT '',
  `field_type` int(50) DEFAULT '0',
  `field_length` int(10) DEFAULT '0',
  `field_upload_type` int(10) DEFAULT '0',
  `field_default` varchar(255) DEFAULT '',
  `field_list` text,
  `field_sql` varchar(255) DEFAULT '',
  `field_tips` varchar(255) DEFAULT '',
  `field_rule` int(10) DEFAULT '0',
  `field_radio` int(10) DEFAULT '0',
  `field_editor` int(10) DEFAULT '0',
  `field_group` int(10) DEFAULT '0',
  `field_filter` int(10) DEFAULT '0',
  `field_table` varchar(50) DEFAULT '',
  `field_join` varchar(255) DEFAULT '',
  `field_where` varchar(255) DEFAULT '',
  `field_order` varchar(255) DEFAULT '',
  `field_value` varchar(50) DEFAULT '',
  `field_label` varchar(50) DEFAULT '',
  `ordnum` int(10) DEFAULT '0',
  `islock` int(10) DEFAULT '0',
  `issys` int(10) DEFAULT '0',
  `isbase` int(10) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;;

-- ----------------------------
-- Table structure for sd_model_job
-- ----------------------------
DROP TABLE IF EXISTS `sd_model_job`;
CREATE TABLE `sd_model_job` (
  `jobid` int(10) NOT NULL AUTO_INCREMENT,
  `cid` int(10) DEFAULT '0',
  `content` mediumtext,
  `work_address` varchar(50) DEFAULT '',
  `work_nature` varchar(50) DEFAULT '',
  `work_education` varchar(50) DEFAULT '',
  `work_money` varchar(50) DEFAULT '',
  `work_age` varchar(50) DEFAULT '',
  `work_num` varchar(50) DEFAULT '',
  PRIMARY KEY (`jobid`),
  UNIQUE KEY `cid` (`cid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;;

-- ----------------------------
-- Table structure for sd_model_news
-- ----------------------------
DROP TABLE IF EXISTS `sd_model_news`;
CREATE TABLE `sd_model_news` (
  `newsid` int(10) NOT NULL AUTO_INCREMENT,
  `cid` int(10) DEFAULT '0',
  `price` decimal(10,2) DEFAULT '0.00',
  `content` mediumtext,
  PRIMARY KEY (`newsid`),
  UNIQUE KEY `cid` (`cid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;;

-- ----------------------------
-- Table structure for sd_model_page
-- ----------------------------
DROP TABLE IF EXISTS `sd_model_page`;
CREATE TABLE `sd_model_page` (
  `pageid` int(10) NOT NULL AUTO_INCREMENT,
  `cid` int(10) DEFAULT '0',
  `piclist` text,
  `content` mediumtext,
  PRIMARY KEY (`pageid`),
  UNIQUE KEY `cid` (`cid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;;

-- ----------------------------
-- Table structure for sd_model_pro
-- ----------------------------
DROP TABLE IF EXISTS `sd_model_pro`;
CREATE TABLE `sd_model_pro` (
  `proid` int(10) NOT NULL AUTO_INCREMENT,
  `cid` int(10) DEFAULT '0',
  `price` decimal(10,2) DEFAULT '0.00',
  `content` mediumtext,
  `piclist` text,
  PRIMARY KEY (`proid`),
  UNIQUE KEY `cid` (`cid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;;

-- ----------------------------
-- Table structure for sd_onlinepay
-- ----------------------------
DROP TABLE IF EXISTS `sd_onlinepay`;
CREATE TABLE `sd_onlinepay` (
  `aid` int(10) NOT NULL AUTO_INCREMENT,
  `orderid` varchar(50) DEFAULT '',
  `pay_no` varchar(50) DEFAULT '',
  `paytype` smallint(1) DEFAULT '0',
  `ispay` smallint(1) DEFAULT '0',
  `createdate` int(10) DEFAULT '0',
  `payway` varchar(100) DEFAULT '',
  `paymoney` decimal(10,2) DEFAULT '0.00',
  PRIMARY KEY (`aid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;;

-- ----------------------------
-- Table structure for sd_order
-- ----------------------------
DROP TABLE IF EXISTS `sd_order`;
CREATE TABLE `sd_order` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `orderid` varchar(50) DEFAULT '',
  `pro_name` varchar(255) DEFAULT '',
  `pro_num` int(10) DEFAULT '0',
  `pro_price` decimal(10,2) DEFAULT '0.00',
  `truename` varchar(50) DEFAULT '',
  `mobile` varchar(20) DEFAULT '',
  `address` varchar(255) DEFAULT '',
  `remark` text,
  `createdate` int(10) DEFAULT '0',
  `isover` int(10) DEFAULT '0',
  `ispay` int(10) DEFAULT '0',
  `payway` varchar(50) DEFAULT '',
  `trade_no` varchar(255) DEFAULT '',
  `postip` varchar(50) DEFAULT '',
  `userid` int(10) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;;

-- ----------------------------
-- Table structure for sd_order_buy
-- ----------------------------
DROP TABLE IF EXISTS `sd_order_buy`;
CREATE TABLE `sd_order_buy` (
  `aid` int(10) NOT NULL AUTO_INCREMENT,
  `orderid` varchar(255) DEFAULT '',
  `userid` int(10) DEFAULT '0',
  `paymoney` decimal(10,2) DEFAULT '0.00',
  `cid` int(10) DEFAULT '0',
  `ispay` int(10) DEFAULT '0',
  `createdate` int(10) DEFAULT '0',
  PRIMARY KEY (`aid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;;

-- ----------------------------
-- Table structure for sd_sitelink
-- ----------------------------
DROP TABLE IF EXISTS `sd_sitelink`;
CREATE TABLE `sd_sitelink` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `title` varchar(50) DEFAULT '',
  `url` varchar(255) DEFAULT '',
  `num` int(10) DEFAULT '0',
  `ordnum` int(10) DEFAULT '0',
  `islock` int(10) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;;

-- ----------------------------
-- Table structure for sd_tags
-- ----------------------------
DROP TABLE IF EXISTS `sd_tags`;
CREATE TABLE `sd_tags` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `title` varchar(50) DEFAULT '',
  `hits` int(10) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `id` (`id`),
  KEY `title` (`title`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;;

-- ----------------------------
-- Table structure for sd_temp_mail
-- ----------------------------
DROP TABLE IF EXISTS `sd_temp_mail`;
CREATE TABLE `sd_temp_mail` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `title` varchar(50) DEFAULT '',
  `mail_title` varchar(255) DEFAULT '',
  `mail_content` text,
  `islock` int(10) DEFAULT '0',
  `mkey` varchar(50) DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `id` (`id`),
  KEY `mkey` (`mkey`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;;

-- ----------------------------
-- Table structure for sd_user
-- ----------------------------
DROP TABLE IF EXISTS `sd_user`;
CREATE TABLE `sd_user` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `uname` varchar(50) DEFAULT '',
  `upass` varchar(50) DEFAULT '',
  `umoney` decimal(10,2) DEFAULT '0.00',
  `uemail` varchar(50) DEFAULT '',
  `uface` varchar(255) DEFAULT '',
  `uid` int(10) DEFAULT '0',
  `islock` int(10) DEFAULT '0',
  `regdate` int(10) DEFAULT '0',
  `regip` varchar(50) DEFAULT '',
  `lastlogindate` int(10) DEFAULT '0',
  `lastloginip` varchar(50) DEFAULT '',
  `logintimes` int(10) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `uname` (`uname`),
  KEY `uid` (`uid`),
  KEY `islock` (`islock`),
  KEY `uemail` (`uemail`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;;

-- ----------------------------
-- Table structure for sd_user_buy
-- ----------------------------
DROP TABLE IF EXISTS `sd_user_buy`;
CREATE TABLE `sd_user_buy` (
  `aid` int(10) NOT NULL AUTO_INCREMENT,
  `cid` int(10) DEFAULT '0',
  `userid` int(10) DEFAULT '0',
  `createdate` int(10) DEFAULT '0',
  PRIMARY KEY (`aid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;;

-- ----------------------------
-- Table structure for sd_user_group
-- ----------------------------
DROP TABLE IF EXISTS `sd_user_group`;
CREATE TABLE `sd_user_group` (
  `gid` int(10) NOT NULL AUTO_INCREMENT,
  `gname` varchar(50) DEFAULT '',
  `ordnum` int(10) DEFAULT '0',
  PRIMARY KEY (`gid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;;

-- ----------------------------
-- Table structure for sd_user_login
-- ----------------------------
DROP TABLE IF EXISTS `sd_user_login`;
CREATE TABLE `sd_user_login` (
  `oid` int(10) NOT NULL AUTO_INCREMENT,
  `userid` int(10) DEFAULT '0',
  `type` varchar(10) DEFAULT '',
  `openid` varchar(255) DEFAULT '',
  `unionid` varchar(255) DEFAULT '',
  `session_key` varchar(255) DEFAULT '',
  `loginkey` varchar(255) DEFAULT '',
  PRIMARY KEY (`oid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;;

-- ----------------------------
-- Table structure for sd_user_money
-- ----------------------------
DROP TABLE IF EXISTS `sd_user_money`;
CREATE TABLE `sd_user_money` (
  `aid` int(10) NOT NULL AUTO_INCREMENT,
  `types` smallint(1) DEFAULT '0',
  `title` varchar(255) DEFAULT '',
  `userid` int(10) DEFAULT '0',
  `amount` decimal(10,2) DEFAULT '0.00',
  `oldmoney` decimal(10,2) DEFAULT '0.00',
  `newmoney` decimal(10,2) DEFAULT '0.00',
  `createdate` int(10) DEFAULT '0',
  PRIMARY KEY (`aid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;;

-- ----------------------------
-- Table structure for sd_user_pay
-- ----------------------------
DROP TABLE IF EXISTS `sd_user_pay`;
CREATE TABLE `sd_user_pay` (
  `aid` int(10) NOT NULL AUTO_INCREMENT,
  `orderid` varchar(50) DEFAULT '',
  `userid` int(10) DEFAULT '0',
  `paymoney` decimal(10,2) DEFAULT '0.00',
  `createdate` int(10) DEFAULT '0',
  `ispay` smallint(1) DEFAULT '0',
  `payway` varchar(50) DEFAULT '',
  `paydate` int(10) DEFAULT '0',
  `trade_no` varchar(255) DEFAULT '',
  PRIMARY KEY (`aid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;;

-- ----------------------------
-- Table structure for sd_wx_menu
-- ----------------------------
DROP TABLE IF EXISTS `sd_wx_menu`;
CREATE TABLE `sd_wx_menu` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `title` varchar(20) DEFAULT '',
  `followid` int(10) DEFAULT '0',
  `sonnum` int(10) DEFAULT '0',
  `reply_type` int(10) DEFAULT '0',
  `reply_text` text,
  `reply_id` int(10) DEFAULT '0',
  `reply_url` text,
  `appid` varchar(255) DEFAULT '',
  `pagepath` varchar(255) DEFAULT '',
  `ordnum` int(10) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;;

-- ----------------------------
-- Records 
-- ----------------------------
INSERT INTO `sd_ad` VALUES ('1', 'Pc站Banner', '{\"1\":{\"image\":\"/upfile/a.jpg\",\"desc\":\"\",\"url\":\"\"},\"2\":{\"image\":\"/upfile/b.jpg\",\"desc\":\"\",\"url\":\"\"},\"3\":{\"image\":\"/upfile/c.jpg\",\"desc\":\"\",\"url\":\"\"}}', '1', '1', 'pc');
INSERT INTO `sd_ad` VALUES ('2', '手机站Banner', '{\"1\":{\"image\":\"/upfile/a1.jpg\",\"desc\":\"\",\"url\":\"\"},\"2\":{\"image\":\"/upfile/b1.jpg\",\"desc\":\"\",\"url\":\"\"},\"3\":{\"image\":\"/upfile/c1.jpg\",\"desc\":\"\",\"url\":\"\"}}', '2', '1', 'mobile');
INSERT INTO `sd_ad` VALUES ('3', '小程序Banner', '{\"1\":{\"image\":\"/upfile/a1.jpg\",\"desc\":\"\",\"url\":\"\"},\"2\":{\"image\":\"/upfile/b1.jpg\",\"desc\":\"\",\"url\":\"\"},\"3\":{\"image\":\"/upfile/c1.jpg\",\"desc\":\"\",\"url\":\"\"}}', '3', '1', 'open');









INSERT INTO `sd_admin_menu` VALUES ('1', '网站管理', '', '', '', '0', '1', '1');
INSERT INTO `sd_admin_menu` VALUES ('2', '栏目管理', '', '', '', '0', '3', '1');
INSERT INTO `sd_admin_menu` VALUES ('3', '内容管理', '', '', '', '0', '5', '1');
INSERT INTO `sd_admin_menu` VALUES ('4', '扩展管理', '', '', '', '0', '15', '1');
INSERT INTO `sd_admin_menu` VALUES ('6', '模板插件', '', '', '', '0', '17', '1');
INSERT INTO `sd_admin_menu` VALUES ('7', '网站设置', 'config', 'index', '', '1', '1', '1');
INSERT INTO `sd_admin_menu` VALUES ('17', '设置分组', 'configgroup', 'index', '', '71', '5', '1');
INSERT INTO `sd_admin_menu` VALUES ('19', '栏目管理', 'category', 'index', '', '2', '1', '1');
INSERT INTO `sd_admin_menu` VALUES ('20', '模型管理', 'model', 'index', '', '2', '5', '1');
INSERT INTO `sd_admin_menu` VALUES ('21', '内容管理', 'content', 'index', '', '3', '1', '1');
INSERT INTO `sd_admin_menu` VALUES ('24', '回收站', 'content', 'recycle', '', '3', '3', '1');
INSERT INTO `sd_admin_menu` VALUES ('25', '友情链接', 'link', 'index', '', '4', '1', '1');
INSERT INTO `sd_admin_menu` VALUES ('26', '留言管理', 'book', 'index', '', '4', '3', '1');
INSERT INTO `sd_admin_menu` VALUES ('31', '表单管理', 'form', 'index', '', '2', '7', '1');
INSERT INTO `sd_admin_menu` VALUES ('32', '询价管理', 'inquiry', 'index', '', '4', '5', '1');
INSERT INTO `sd_admin_menu` VALUES ('33', '订单管理', 'order', 'index', '', '4', '7', '0');
INSERT INTO `sd_admin_menu` VALUES ('34', '广告管理', 'ad', 'index', '', '4', '9', '1');
INSERT INTO `sd_admin_menu` VALUES ('35', '部门管理', 'part', 'index', '', '1', '7', '1');
INSERT INTO `sd_admin_menu` VALUES ('36', '插件列表', 'plug', 'index', '', '6', '5', '1');
INSERT INTO `sd_admin_menu` VALUES ('37', '后台用户', 'admin', 'index', '', '1', '9', '1');
INSERT INTO `sd_admin_menu` VALUES ('38', '模板管理', 'theme', 'index', '', '6', '1', '1');
INSERT INTO `sd_admin_menu` VALUES ('39', '后台菜单', 'menu', 'index', '', '71', '13', '1');
INSERT INTO `sd_admin_menu` VALUES ('40', '栏目扩展', 'catefield', 'index', '', '2', '3', '1');
INSERT INTO `sd_admin_menu` VALUES ('41', '区块管理', 'block', 'index', '', '3', '5', '1');
INSERT INTO `sd_admin_menu` VALUES ('42', '微信公众号', '', '', '', '0', '9', '0');
INSERT INTO `sd_admin_menu` VALUES ('43', '素材管理', 'wxmater', 'index', '', '42', '1', '1');
INSERT INTO `sd_admin_menu` VALUES ('44', '关注回复', 'wxsubscribe', 'index', '', '42', '3', '1');
INSERT INTO `sd_admin_menu` VALUES ('45', '自动回复', 'wxauto', 'index', '', '42', '5', '1');
INSERT INTO `sd_admin_menu` VALUES ('46', '关键字回复', 'wxkey', 'index', '', '42', '7', '1');
INSERT INTO `sd_admin_menu` VALUES ('47', '菜单管理', 'wxmenu', 'index', '', '42', '9', '1');
INSERT INTO `sd_admin_menu` VALUES ('48', '内容扩展', 'extend', 'index', '', '2', '9', '1');
INSERT INTO `sd_admin_menu` VALUES ('49', '标签管理', 'tags', 'index', '', '4', '11', '1');
INSERT INTO `sd_admin_menu` VALUES ('50', '群发管理', 'wxmass', 'index', '', '42', '11', '1');
INSERT INTO `sd_admin_menu` VALUES ('51', '管理日志', 'log', 'index', '', '71', '15', '1');
INSERT INTO `sd_admin_menu` VALUES ('52', '错误日志', 'logerror', 'index', '', '71', '17', '1');
INSERT INTO `sd_admin_menu` VALUES ('53', '邮件模板', 'mail', 'index', '', '6', '3', '1');
INSERT INTO `sd_admin_menu` VALUES ('54', '缓存管理', 'cache', 'index', '', '71', '21', '1');
INSERT INTO `sd_admin_menu` VALUES ('55', '内链管理', 'sitelink', 'index', '', '4', '13', '1');
INSERT INTO `sd_admin_menu` VALUES ('57', '会员管理', '', '', '', '0', '7', '0');
INSERT INTO `sd_admin_menu` VALUES ('58', '会员管理', 'user', 'index', '', '57', '1', '1');
INSERT INTO `sd_admin_menu` VALUES ('59', '会员组管理', 'usergroup', 'index', '', '57', '3', '1');
INSERT INTO `sd_admin_menu` VALUES ('60', '会员设置', 'userconfig', 'index', '', '57', '5', '1');
INSERT INTO `sd_admin_menu` VALUES ('62', '社区管理', '', '', '', '0', '11', '0');
INSERT INTO `sd_admin_menu` VALUES ('63', '社区设置', 'bbsconfig', 'index', '', '62', '1', '1');
INSERT INTO `sd_admin_menu` VALUES ('64', '社区分类', 'bbscate', 'index', '', '62', '3', '1');
INSERT INTO `sd_admin_menu` VALUES ('65', '主题管理', 'bbs', 'index', '', '62', '5', '1');
INSERT INTO `sd_admin_menu` VALUES ('66', '帖子管理', 'bbstopic', 'index', '', '62', '7', '1');
INSERT INTO `sd_admin_menu` VALUES ('67', '城市分站', '', '', '', '0', '13', '0');
INSERT INTO `sd_admin_menu` VALUES ('68', '分站设置', 'cityconfig', 'index', '', '67', '1', '1');
INSERT INTO `sd_admin_menu` VALUES ('69', '城市管理', 'city', 'index', '', '67', '3', '1');
INSERT INTO `sd_admin_menu` VALUES ('70', '接口设置', 'api', 'index', '', '1', '3', '0');
INSERT INTO `sd_admin_menu` VALUES ('71', '系统管理', 'api', 'index', '', '0', '19', '1');
INSERT INTO `sd_admin_menu` VALUES ('72', '财务管理', 'usermoney', 'index', '', '57', '7', '1');
INSERT INTO `sd_admin_menu` VALUES ('73', '充值记录', 'userpay', 'index', '', '57', '9', '1');
INSERT INTO `sd_admin_menu` VALUES ('74', '购买记录', 'userbuy', 'index', '', '57', '11', '1');
INSERT INTO `sd_admin_menu` VALUES ('75', '支付记录', 'useronline', 'index', '', '57', '13', '1');
INSERT INTO `sd_alias` VALUES ('1', 'book', 'other/book', '0', '0');
INSERT INTO `sd_alias` VALUES ('2', 'sitemap', 'other/sitemap', '0', '0');
INSERT INTO `sd_alias` VALUES ('3', 'search', 'other/search', '0', '0');
INSERT INTO `sd_alias` VALUES ('4', 'tags', 'other/tags', '0', '0');
INSERT INTO `sd_alias` VALUES ('5', 'user', 'user/index', '0', '0');
INSERT INTO `sd_alias` VALUES ('6', 'login', 'user/login', '0', '0');
INSERT INTO `sd_alias` VALUES ('7', 'reg', 'user/reg', '0', '0');
INSERT INTO `sd_alias` VALUES ('8', 'getpass', 'user/getpass', '0', '0');
INSERT INTO `sd_alias` VALUES ('9', 'editpass', 'user/editpass', '0', '0');
INSERT INTO `sd_alias` VALUES ('10', 'editemail', 'user/editemail', '0', '0');
INSERT INTO `sd_alias` VALUES ('11', 'out', 'user/out', '0', '0');
INSERT INTO `sd_alias` VALUES ('12', 'bbs', 'bbs/index', '0', '0');
INSERT INTO `sd_alias` VALUES ('13', 'bbsadd', 'bbs/add', '0', '0');
INSERT INTO `sd_alias` VALUES ('14', 'bbsshow', 'bbs/show', '0', '0');
INSERT INTO `sd_alias` VALUES ('15', 'bbsedit', 'bbs/edit', '0', '0');
INSERT INTO `sd_alias` VALUES ('16', 'myorder', 'user/myorder', '0', '0');
INSERT INTO `sd_alias` VALUES ('17', 'city', 'index/city', '0', '0');
INSERT INTO `sd_alias` VALUES ('18', 'taglist', 'other/taglist', '0', '0');
INSERT INTO `sd_alias` VALUES ('19', 'pay', 'user/pay', '0', '0');
INSERT INTO `sd_alias` VALUES ('20', 'mymoney', 'user/mymoney', '0', '0');
INSERT INTO `sd_alias` VALUES ('21', 'product', 'category', '2', '1');
INSERT INTO `sd_alias` VALUES ('22', 'about', 'category', '1', '1');
INSERT INTO `sd_alias` VALUES ('23', 'news', 'category', '3', '1');
INSERT INTO `sd_alias` VALUES ('24', 'case', 'category', '4', '1');
INSERT INTO `sd_alias` VALUES ('25', 'job', 'category', '5', '1');
INSERT INTO `sd_alias` VALUES ('26', 'contact', 'category', '6', '1');
INSERT INTO `sd_attachment` VALUES ('1', '/upfile/2021/03/1614686776931.jpg', 'p1.jpg', '.jpg', '42743', '1', '1614686776', '1', '1', '0', '0.0.0.0', '0');
INSERT INTO `sd_attachment` VALUES ('2', '/upfile/2021/03/1614686777942.jpg', 'p3.jpg', '.jpg', '35396', '1', '1614686777', '1', '1', '0', '0.0.0.0', '0');
INSERT INTO `sd_attachment` VALUES ('3', '/upfile/2021/03/1614686777801.jpg', 'p4.jpg', '.jpg', '66736', '1', '1614686777', '1', '1', '0', '0.0.0.0', '0');
INSERT INTO `sd_attachment` VALUES ('4', '/upfile/2021/03/1614686777363.jpg', 'p2.jpg', '.jpg', '31971', '1', '1614686777', '1', '1', '0', '0.0.0.0', '0');
INSERT INTO `sd_attachment` VALUES ('5', '/upfile/2021/03/1614686777502.jpg', 'p5.jpg', '.jpg', '35164', '1', '1614686777', '1', '1', '0', '0.0.0.0', '0');
INSERT INTO `sd_attachment` VALUES ('6', '/upfile/2021/03/1614686777144.jpg', 'p6.jpg', '.jpg', '24511', '1', '1614686777', '1', '1', '0', '0.0.0.0', '0');
INSERT INTO `sd_attachment` VALUES ('7', '/upfile/2021/03/1614686777990.jpg', 'p7.jpg', '.jpg', '42788', '1', '1614686777', '1', '1', '0', '0.0.0.0', '0');
INSERT INTO `sd_attachment` VALUES ('8', '/upfile/2021/03/1614686777329.jpg', 'p8.jpg', '.jpg', '56545', '1', '1614686777', '1', '1', '0', '0.0.0.0', '0');
INSERT INTO `sd_attachment` VALUES ('9', '/upfile/2021/03/1614686777815.jpg', 'p9.jpg', '.jpg', '33761', '1', '1614686777', '1', '1', '0', '0.0.0.0', '0');
INSERT INTO `sd_attachment` VALUES ('10', '/upfile/2021/03/1614686777786.jpg', 'p10.jpg', '.jpg', '33361', '1', '1614686777', '1', '1', '0', '0.0.0.0', '0');
INSERT INTO `sd_attachment` VALUES ('11', '/upfile/2021/03/1614686777126.jpg', 'p13.jpg', '.jpg', '37466', '1', '1614686777', '1', '1', '0', '0.0.0.0', '0');
INSERT INTO `sd_attachment` VALUES ('12', '/upfile/2021/03/1614686778545.jpg', 'p14.jpg', '.jpg', '44409', '1', '1614686778', '1', '1', '0', '0.0.0.0', '0');
INSERT INTO `sd_attachment` VALUES ('13', '/upfile/2021/03/1614686778735.jpg', 'p15.jpg', '.jpg', '28667', '1', '1614686778', '1', '1', '0', '0.0.0.0', '0');
INSERT INTO `sd_attachment` VALUES ('14', '/upfile/2021/03/1614686778250.jpg', 'p16.jpg', '.jpg', '38852', '1', '1614686778', '1', '1', '0', '0.0.0.0', '0');
INSERT INTO `sd_attachment` VALUES ('15', '/upfile/2021/03/1614759114836.jpg', 'wx.jpg', '.jpg', '37489', '1', '1614759114', '1', '1', '0', '0.0.0.0', '0');
INSERT INTO `sd_attachment` VALUES ('16', '/upfile/2021/03/1614759164289.jpg', 'ry1.jpg', '.jpg', '186136', '1', '1614759164', '1', '1', '0', '0.0.0.0', '0');
INSERT INTO `sd_attachment` VALUES ('17', '/upfile/2021/03/1614759164957.jpg', 'ry3.jpg', '.jpg', '171515', '1', '1614759164', '1', '1', '0', '0.0.0.0', '0');
INSERT INTO `sd_attachment` VALUES ('18', '/upfile/2021/03/1614759164328.jpg', 'ry4.jpg', '.jpg', '88317', '1', '1614759164', '1', '1', '0', '0.0.0.0', '0');
INSERT INTO `sd_attachment` VALUES ('19', '/upfile/2021/03/1614759164221.jpg', 'ry2.jpg', '.jpg', '220006', '1', '1614759164', '1', '1', '0', '0.0.0.0', '0');
INSERT INTO `sd_attachment` VALUES ('20', '/upfile/2021/03/1614759164797.jpg', 'ry5.jpg', '.jpg', '241733', '1', '1614759164', '1', '1', '0', '0.0.0.0', '0');
INSERT INTO `sd_attachment` VALUES ('21', '/upfile/2021/03/1614759165373.jpg', 'ry6.jpg', '.jpg', '338245', '1', '1614759165', '1', '1', '0', '0.0.0.0', '0');
INSERT INTO `sd_attachment` VALUES ('22', '/upfile/2021/03/1614769413951.jpg', 'fdg.jpg', '.jpg', '85025', '1', '1614769413', '1', '1', '0', '0.0.0.0', '0');
INSERT INTO `sd_auto_reply` VALUES ('1', 'subscribe', '0', '', '0');
INSERT INTO `sd_auto_reply` VALUES ('2', 'auto', '0', '', '0');
INSERT INTO `sd_badword` VALUES ('1', '');
INSERT INTO `sd_category` VALUES ('1', '关于我们', '0', '0', '-1', 'about', '20', '', '', '', '', '', '1', '0', '0', '', '0', '', '', '', '', '');
INSERT INTO `sd_category` VALUES ('2', '产品展示', '0', '0', '2', 'product', '12', '', '', '', '', '', '1', '0', '0', '', '0', '', '', '', '', '');
INSERT INTO `sd_category` VALUES ('3', '新闻资讯', '0', '0', '1', 'news', '10', '', '', '', '', '', '1', '0', '0', '', '0', '', '', '', '', '');
INSERT INTO `sd_category` VALUES ('4', '工程案例', '0', '0', '1', 'case', '12', 'content/news/list_pic.php', '', '', '', '', '1', '0', '0', '', '0', '', '', '', '', '');
INSERT INTO `sd_category` VALUES ('5', '人才招聘', '0', '0', '3', 'job', '20', '', '', '', '', '', '1', '0', '0', '', '0', '', '', '', '', '');
INSERT INTO `sd_category` VALUES ('6', '联系我们', '0', '0', '-1', 'contact', '20', '', '', '', '', '', '1', '0', '0', '', '0', '', '', '', '', '');
INSERT INTO `sd_category` VALUES ('7', '公司简介', '1', '0', '-1', '', '20', '', '', '', '', '', '1', '0', '0', '', '0', '', '', '', '', '');
INSERT INTO `sd_category` VALUES ('8', '企业文化', '1', '0', '-1', '', '20', '', '', '', '', '', '1', '0', '0', '', '0', '', '', '', '', '');
INSERT INTO `sd_category` VALUES ('9', '荣誉资质', '1', '0', '-1', '', '20', '', '', '', '', '', '1', '0', '0', '', '0', '', '', '', '', '');
INSERT INTO `sd_category` VALUES ('10', '产品分类一', '2', '0', '2', '', '12', '', '', '', '', '', '1', '0', '0', '', '0', '', '', '', '', '');
INSERT INTO `sd_category` VALUES ('11', '产品分类二', '2', '0', '2', '', '12', '', '', '', '', '', '1', '0', '0', '', '0', '', '', '', '', '');
INSERT INTO `sd_category` VALUES ('12', '产品分类三', '2', '0', '2', '', '12', '', '', '', '', '', '1', '0', '0', '', '0', '', '', '', '', '');
INSERT INTO `sd_category` VALUES ('13', '产品分类四', '2', '0', '2', '', '12', '', '', '', '', '', '1', '0', '0', '', '0', '', '', '', '', '');
INSERT INTO `sd_category` VALUES ('14', '产品分类五', '2', '0', '2', '', '12', '', '', '', '', '', '1', '0', '0', '', '0', '', '', '', '', '');
INSERT INTO `sd_category` VALUES ('15', '产品分类六', '2', '0', '2', '', '12', '', '', '', '', '', '1', '0', '0', '', '0', '', '', '', '', '');
INSERT INTO `sd_category` VALUES ('16', '产品分类一1', '10', '0', '2', '', '12', '', '', '', '', '', '1', '0', '0', '', '0', '', '', '', '', '');
INSERT INTO `sd_category` VALUES ('17', '产品分类一2', '10', '0', '2', '', '12', '', '', '', '', '', '1', '0', '0', '', '0', '', '', '', '', '');
INSERT INTO `sd_category` VALUES ('18', '产品分类一3', '10', '0', '2', '', '12', '', '', '', '', '', '1', '0', '0', '', '0', '', '', '', '', '');
INSERT INTO `sd_category` VALUES ('19', '产品分类一4', '10', '0', '2', '', '12', '', '', '', '', '', '1', '0', '0', '', '0', '', '', '', '', '');
INSERT INTO `sd_category` VALUES ('20', '公司动态', '3', '0', '1', '', '10', '', '', '', '', '', '1', '0', '0', '', '0', '', '', '', '', '');
INSERT INTO `sd_category` VALUES ('21', '行业资讯', '3', '0', '1', '', '10', '', '', '', '', '', '1', '0', '0', '', '0', '', '', '', '', '');
INSERT INTO `sd_category` VALUES ('22', '常见问题', '3', '0', '1', '', '10', '', '', '', '', '', '1', '0', '0', '', '0', '', '', '', '', '');
INSERT INTO `sd_category` VALUES ('23', '用人理念', '5', '0', '-1', '', '20', '', '', '', '', '', '1', '0', '0', '', '0', '', '', '', '', '');
INSERT INTO `sd_category` VALUES ('24', '人才招聘', '5', '0', '3', '', '20', '', '', '', '', '', '1', '0', '0', '', '0', '', '', '', '', '');
INSERT INTO `sd_category_field` VALUES ('1', '英文名称', 'myename', '1', '0', '0', '', '', '', '建议一级栏目填写', '0', '0', '0', '0', '1');
INSERT INTO `sd_category_field` VALUES ('2', '底部导航菜单', 'myfoot', '9', '0', '0', '', '显示|1,隐藏|0', 'TEXT(255) DEFAULT NULL', '导航菜单是否在底部显示', '0', '1', '0', '0', '1');
INSERT INTO `sd_category_field` VALUES ('3', '栏目banner', 'mycatepic', '5', '0', '1', '', '', 'TEXT(255) DEFAULT NULL', '内页顶部下方栏目banner', '0', '1', '0', '0', '1');
INSERT INTO `sd_category_field` VALUES ('4', '栏目缩略图', 'mycateimg', '5', '0', '1', '', '', 'TEXT(255) DEFAULT NULL', '', '0', '1', '0', '0', '1');
INSERT INTO `sd_config` VALUES ('1', '1', 'web_line', '网站设置', '', '1', '9', '', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('2', '1', 'web_open', '网站开关', '1', '3', '6', '网站开启|1,网站关闭|0', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('3', '1', 'web_close', '关闭原因', '临时维护，预计开放时间：16:00', '5', '5', '', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('4', '1', 'web_name', '网站名称', '您的网站名称', '7', '1', '', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('5', '1', 'web_logo', '网站Logo', '/upfile/02logo.png', '9', '4', '', '', '1', '1', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('6', '1', 'web_icp', 'ICP备案号', '', '13', '1', '', '', '1', '1', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('7', '1', 'seo_line', '优化设置', '', '23', '9', '', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('8', '1', 'seo_title', '优化标题', '', '25', '1', '', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('9', '1', 'seo_key', '网站关键字', '', '27', '5', '', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('10', '1', 'seo_desc', '网站描述', '', '29', '5', '', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('11', '2', 'url_mode', 'Url模式', '1', '1', '6', '普通模式（例: /?m=home）|1,PathInfo模式（例: /index.php/news.html）|2,伪静态模式（例: /news.html）|3', '', '2', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('12', '2', 'url_mid', 'Url间隔符', '/', '3', '8', '/|/,-|-,_|_', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('13', '2', 'url_ext', '内容Url后缀', '.html', '7', '8', '无后缀|,.html|.html,/|/', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('14', '3', 'mail_type', '发送方式', '0', '0', '6', '关闭|0,开启|2', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('15', '3', 'mail_name', '发件人姓名', '', '0', '1', '', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('16', '3', 'mail_sign', '邮件签名', '', '0', '5', '', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('17', '3', 'mail_spilt', '邮件头分隔符', '1', '0', '8', '使用CRLF作为分隔符(通常为Windows主机)|1,使用LF作为分隔符(通常为Unix/Linux主机)|2,使用CR作为分隔符(通常为Mac主机)|3', '', '2', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('18', '3', 'mail_smtp', 'SMTP服务器', '', '0', '1', '', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('19', '3', 'mail_user', '用户名', '', '0', '1', '', '填写邮箱全称，如：test@qq.com', '1', '0', '1', '1', '1');
INSERT INTO `sd_config` VALUES ('20', '3', 'mail_pass', '密码/授权码', '', '0', '1', '', '', '1', '0', '1', '1', '1');
INSERT INTO `sd_config` VALUES ('21', '3', 'mail_auth', '验证', '1', '0', '6', '是|1,否|0', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('22', '3', 'mail_port', '端口', '25', '0', '1', '', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('23', '4', 'upload_line', '上传设置', '', '0', '9', '', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('24', '4', 'upload_image_max', '图像最大上传', '2', '0', '1', '', '单位：M', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('25', '4', 'upload_video_max', '视频最大上传', '10', '0', '1', '', '单位：M', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('26', '4', 'upload_file_max', '附件最大上传', '10', '0', '1', '', '单位：M', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('27', '4', 'upload_file_folder', '储存方式', '2', '0', '6', '按 年 目录，如：2016/14731414801.jpg|1,按 年/月 目录，如：2016/10/14731414801.jpg|2,按 年/月/日 目录，如：2016/10/21/14731414801.jpg|3', '', '2', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('28', '4', 'thumb_line', '压缩设置', '', '0', '9', '', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('29', '4', 'thumb_open', '等比压缩', '0', '0', '6', '开启|1,关闭|0', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('30', '4', 'thumb_min', '压缩宽度', '600', '0', '1', '', '图片会被压缩成这个宽度', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('31', '4', 'water_line', '水印设置', '', '0', '9', '', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('32', '4', 'water_open', '水印开关', '0', '0', '6', '开启|1,关闭|0', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('33', '4', 'water_width', '最小宽度', '400', '0', '1', '', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('34', '4', 'water_height', '最小高度', '100', '0', '1', '', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('35', '4', 'water_opacity', '透明度', '60', '0', '1', '', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('36', '4', 'water_position', '水印位置', '0', '0', '8', '随机显示|0,顶部居左|1,顶部居中|2,顶部居右|3,中部居左|4,中部居中|5,中部居右|6,底部居左|7,底部居中|8,底部居右|9', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('37', '4', 'water_logo', '水印Logo', '/upfile/mobile.png', '0', '4', '', '', '1', '1', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('38', '5', 'mobile_open', '开关', '1', '1', '6', '开启|1,关闭|0', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('39', '5', 'mobile_domain', '绑定域名', '', '5', '1', '', '例：m.baidu.com', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('40', '6', 'weixin_appid', 'AppID(应用ID)', '', '0', '1', '', '', '1', '0', '1', '1', '1');
INSERT INTO `sd_config` VALUES ('41', '6', 'weixin_appsecret', 'AppSecret(应用密钥)', '', '0', '1', '', '', '1', '0', '1', '1', '1');
INSERT INTO `sd_config` VALUES ('42', '6', 'weixin_token', 'Token(令牌)', '', '0', '1', '', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('43', '6', 'weixin_id', '公众号的微信号', '', '0', '1', '', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('44', '6', 'weixin_qrcode', '公众号二维码', '/upfile/2021/03/1614759114836.jpg', '0', '4', '', '', '1', '1', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('45', '7', 'link_logo', 'LOGO链接', '1', '0', '6', '开启|1,关闭|0', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('46', '7', 'link_class', '分类开关', '0', '0', '6', '开启|1,关闭|0', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('47', '7', 'link_class_data', '链接分类', '首页链接|1\r合作伙伴|2', '0', '5', '', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('48', '8', 'ct_company', '公司名称', '您的公司名称', '0', '1', '', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('49', '8', 'ct_tel', '服务热线', '400-1234-5678', '0', '1', '', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('50', '8', 'ct_fax', '传真号码', '', '0', '1', '', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('51', '8', 'ct_mobile', '手机号码', '139-1234-5678', '0', '1', '', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('52', '8', 'ct_email', '电子邮箱', 'youemail@qq.com', '0', '1', '', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('53', '8', 'ct_address', '公司地址', '您的公司地址', '0', '1', '', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('54', '5', 'mobile_auto', '自动识别', '1', '7', '6', '开启|1,关闭|0', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('55', '5', 'mobile_logo', '手机站LOGO', '/upfile/02mlogo.jpg', '9', '4', '', '', '1', '1', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('56', '3', 'mail_admin', '管理员邮箱', '', '0', '1', '', '不能和上面的用户名相同', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('57', '2', 'url_line', '路由映射', '', '9', '9', '', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('58', '2', 'url_list', '模型列表页', 'list', '11', '1', '', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('59', '2', 'url_show', '模型内容页', 'show', '13', '1', '', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('60', '9', 'admin_code', '后台登录验证码', '1', '2', '6', '图形验证码|1,谷歌验证码|3,关闭|2', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('61', '9', 'admin_logintimes', '登录尝试次数', '10', '4', '1', '', '超过次数后禁止登录', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('62', '9', 'admin_log', '自动清理日志时间', '30', '5', '1', '', '单位为天，超过多少天的自动清理', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('63', '1', 'count_line', '流量统计', '', '31', '9', '', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('64', '1', 'count_code', '统计代码', '', '33', '5', '', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('65', '1', 'home_line', '其他设置', '', '35', '9', '', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('66', '1', 'home_video', '首页视频/图片', 'https://cms.sdcms.cn/upfile/2020/08/1597194275517.mp4', '11', '4', '', '请上传mp4格式视频，大小建议5M以内，如果没有视频可以上传图片', '1', '3', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('67', '10', 'pay_open', '接口状态', '0', '1', '6', '开启|1,关闭|0', '关闭后以下设置无效，在线支付接口均需要企业（含个体工商户）身份才能申请到', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('68', '10', 'pay_alipay_line', '支付宝接口（含电脑网站支付和手机网站支付）', '', '3', '9', '', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('69', '10', 'pay_alipay_open', '是否开启', '0', '5', '6', '开启|1,关闭|0', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('70', '10', 'pay_alipay_appid', 'AppID', '', '7', '1', '', '', '1', '0', '1', '1', '1');
INSERT INTO `sd_config` VALUES ('73', '10', 'pay_alipay_biz', '接口授权码', '', '11', '5', '', '支付宝支付接口授权码通过官网购买，未授权时接只能支付0.01元', '1', '0', '1', '1', '1');
INSERT INTO `sd_config` VALUES ('74', '10', 'pay_wxpay_line', '微信支付接口（含扫码支付、公众号支付和微信H5支付）', '', '13', '9', '', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('75', '10', 'pay_wxpay_open', '是否开启', '0', '15', '6', '开启|1,关闭|0', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('76', '10', 'pay_wxpay_appid', '商户号', '', '17', '1', '', '', '1', '0', '1', '1', '1');
INSERT INTO `sd_config` VALUES ('77', '10', 'pay_wxpay_key', '密钥', '', '19', '1', '', '长度为32位，必须包含：大小写字母和数字', '1', '0', '1', '1', '1');
INSERT INTO `sd_config` VALUES ('78', '10', 'pay_wxpay_biz', '接口授权码', '', '21', '5', '', '微信支付接口授权码通过官网购买，未授权时接只能支付0.01元', '1', '0', '1', '1', '1');
INSERT INTO `sd_config` VALUES ('79', '1', 'web_domain', '站点主域名', '', '19', '1', '', '例：www.baidu.com，使用栏目绑定域名时，必须配置主域名', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('80', '1', 'content_subid', '内容副栏目', '0', '37', '6', '开启|1,关闭|0', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('81', '11', 'file_way', '存储方式', 'local', '0', '8', '本地存储|local,阿里云Oss|oss,七牛云|qiniu', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('82', '11', 'file_oss_line', '阿里云OSS', '', '0', '9', '', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('83', '11', 'file_oss_appid', 'Access Key ID', '', '0', '1', '', '', '1', '0', '1', '1', '1');
INSERT INTO `sd_config` VALUES ('84', '11', 'file_oss_appkey', 'Access Key Secret', '', '0', '1', '', '', '1', '0', '1', '1', '1');
INSERT INTO `sd_config` VALUES ('85', '11', 'file_oss_bucket', 'Bucket', '', '0', '1', '', '', '1', '0', '1', '1', '1');
INSERT INTO `sd_config` VALUES ('86', '11', 'file_oss_domain', '用户域名', '', '0', '1', '', '例：http://file.baidu.com', '1', '0', '1', '1', '1');
INSERT INTO `sd_config` VALUES ('87', '11', 'file_oss_url', 'OSS 域名', '', '0', '1', '', '例：http://test.oss-cn-hangzhou.aliyuncs.com', '1', '0', '1', '1', '1');
INSERT INTO `sd_config` VALUES ('88', '11', 'file_qiniu_line', '七牛云存储', '', '0', '9', '', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('89', '11', 'file_qiniu_appid', 'AccessKey', '', '0', '1', '', '', '1', '0', '1', '1', '1');
INSERT INTO `sd_config` VALUES ('90', '11', 'file_qiniu_appkey', 'Secret Key', '', '0', '1', '', '', '1', '0', '1', '1', '1');
INSERT INTO `sd_config` VALUES ('91', '11', 'file_qiniu_bucket', 'Bucket', '', '0', '1', '', '', '1', '0', '1', '1', '1');
INSERT INTO `sd_config` VALUES ('92', '11', 'file_qiniu_domain', '用户域名', '', '0', '1', '', '可以使用绑定的域名，也可以使用测试域名，例：http://file.baidu.com', '1', '0', '1', '1', '1');
INSERT INTO `sd_config` VALUES ('93', '11', 'file_qiniu_url', '上传地址', '', '0', '1', '', '例：http://upload.qiniu.com', '1', '0', '1', '1', '1');
INSERT INTO `sd_config` VALUES ('94', '12', 'user_open', '开放注册', '1', '0', '6', '开放注册|1,关闭注册|2', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('95', '12', 'user_reg_type', '注册审核', '1', '0', '6', '直接通过|1,邮箱验证|2,管理员审核|3', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('96', '12', 'user_badname', '禁止注册的用户名', 'sdcms|admin|ceo|cto|boss|fuck|cao', '0', '5', '', '多个请用“|”间隔', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('97', '12', 'user_reg_group', '加入用户组', '1', '0', '8', '默认用户组|0', '注册后默认加入哪个会员组', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('98', '12', 'user_reg_auth', '注册验证码', '1', '0', '6', '开启|1,关闭|2', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('99', '12', 'user_login_auth', '登录验证码', '1', '0', '6', '开启|1,关闭|2', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('100', '12', 'user_getpass_auth', '忘记密码验证码', '1', '0', '6', '开启|1,关闭|2', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('101', '13', 'api_qq_line', 'QQ登录接口', '', '0', '9', '', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('102', '13', 'api_qq_open', '接口状态', '0', '0', '6', '开启|1,关闭|0', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('103', '13', 'api_qq_appid', 'AppId', '', '0', '1', '', '', '1', '0', '1', '1', '1');
INSERT INTO `sd_config` VALUES ('104', '13', 'api_qq_key', 'AppKey', '', '0', '1', '', '', '1', '0', '1', '1', '1');
INSERT INTO `sd_config` VALUES ('105', '13', 'api_weibo_line', '微博登录接口', '', '0', '9', '', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('106', '13', 'api_weibo_open', '接口状态', '0', '0', '6', '开启|1,关闭|0', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('107', '13', 'api_weibo_appid', 'App Key', '', '0', '1', '', '', '1', '0', '1', '1', '1');
INSERT INTO `sd_config` VALUES ('108', '13', 'api_weibo_key', 'App Secret', '', '0', '1', '', '', '1', '0', '1', '1', '1');
INSERT INTO `sd_config` VALUES ('109', '14', 'bbs_open', '社区开关', '1', '0', '6', '开启|1,关闭|0', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('110', '14', 'bbs_close', '关闭原因', '社区维护中', '0', '5', '', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('111', '14', 'bbs_webname', '社区名称', '社区名称', '0', '1', '', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('112', '14', 'bbs_seotitle', '优化标题', '', '0', '1', '', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('113', '14', 'bbs_seokey', '关键字', '', '0', '5', '', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('114', '14', 'bbs_seodesc', '描述', '', '0', '5', '', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('115', '14', 'bbs_newpost', '发帖时间间隔', '5', '0', '1', '', '单位：分钟', '1', '0', '1', '0', '0');
INSERT INTO `sd_config` VALUES ('116', '14', 'bbs_replypost', '回帖时间间隔', '1', '0', '1', '', '单位：分钟', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('117', '14', 'bbs_post_lock', '发帖需要审核', '1', '0', '6', '不需要审核|1,需要审核|0', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('118', '6', 'web_share_pic', '微信分享图片', '', '0', '4', '', '微信分享默认图片，建议尺寸：100*100', '1', '1', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('119', '4', 'water_piclist', '组图水印', '0', '0', '6', '开启|1,关闭|0', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('120', '1', 'web_order_login', '下单设置', '0', '41', '6', '会员才能下单|1,任何人都可下单|0', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('121', '13', 'api_weixin_line', '微信扫码登录接口（Pc网站使用，需要申请开发者认证，创建网站应用）', '', '0', '9', '', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('122', '13', 'api_weixin_open', '接口状态', '0', '0', '6', '开启|1,关闭|0', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('123', '13', 'api_weixin_appid', 'AppID', '', '0', '1', '', '', '1', '0', '1', '1', '1');
INSERT INTO `sd_config` VALUES ('124', '13', 'api_weixin_appkey', 'AppSecret', '', '0', '1', '', '', '1', '0', '1', '1', '1');
INSERT INTO `sd_config` VALUES ('125', '13', 'api_wx_line', ' 微信公众号登录接口（在微信公众号内访问使用，需要公众号通过认证）', '', '0', '9', '', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('126', '13', 'api_wx_open', '接口状态', '0', '0', '6', '开启|1,关闭|0', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('129', '15', 'city_domain', '分站根域名', '', '5', '1', '', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('130', '15', 'city_class', '栏目加城市名', '0', '7', '6', '开启|1,关闭|0', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('131', '15', 'city_content', '内容加城市名', '0', '9', '6', '开启|1,关闭|0', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('132', '2', 'url_cate_ext', '栏目及别名后缀', '/', '5', '8', '无后缀|,.html|.html,/|/', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('133', '4', 'thumb_auto', '自动缩略图', '0', '0', '6', '开启|1,关闭|0', '开启后前台自动生成图片缩略图', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('134', '6', 'weixin_cache', '微信数据缓存', '1', '0', '6', '开启|1,关闭|0', '多个网站同时使用同一个公众号时，请关闭。', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('135', '14', 'bbs_post_code', '发帖验证码', '1', '0', '6', '开启|1,关闭|0', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('136', '14', 'bbs_reply_code', '回帖验证码', '0', '0', '6', '开启|1,关闭|0', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('137', '16', 'open_line', '公共设置', '', '0', '9', '', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('138', '16', 'open_appkey', '通信密钥', '', '0', '1', '', '小程序通信密钥，不可为空', '1', '0', '1', '1', '1');
INSERT INTO `sd_config` VALUES ('139', '16', 'open_debug', '调试开关', '0', '0', '6', '开启|1,关闭|0', '本地调试时，请开启', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('140', '16', 'open_bizcode', '小程序授权码', '', '0', '5', '', '在正式域名下使用小程序，需要经过授权', '1', '0', '1', '1', '1');
INSERT INTO `sd_config` VALUES ('141', '16', 'open_weixin_line', '微信小程序', '', '0', '9', '', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('142', '16', 'open_weixin_appid', 'AppID', '', '0', '1', '', '小程序ID', '1', '0', '1', '1', '1');
INSERT INTO `sd_config` VALUES ('143', '16', 'open_weixin_appsecret', 'AppSecret', '', '0', '1', '', '小程序密钥', '1', '0', '1', '1', '1');
INSERT INTO `sd_config` VALUES ('145', '1', 'web_domain_line', '域名相关', '', '15', '9', '', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('146', '1', 'web_http', 'Http类型', 'http://', '17', '6', 'Http://|http://,Https://|https://', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('147', '1', 'web_domains', '副域名', '', '21', '5', '', '一行一条，格式：www.baidu.com 或 baidu.com，副域名会自动跳转到主域名', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('148', '5', 'mobile_http', 'Http类型', 'http://', '3', '6', 'Http://|http://,Https://|https://', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('149', '16', 'open_baidu_line', '百度小程序', '', '0', '9', '', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('150', '16', 'open_baidu_appid', 'App ID', '', '0', '1', '', '智能小程序ID', '1', '0', '1', '1', '1');
INSERT INTO `sd_config` VALUES ('151', '16', 'open_baidu_appkey', 'App Key', '', '0', '1', '', '', '1', '0', '1', '1', '1');
INSERT INTO `sd_config` VALUES ('152', '16', 'open_baidu_appsecret', 'App Secret', '', '0', '1', '', '智能小程序密匙', '1', '0', '1', '1', '1');
INSERT INTO `sd_config` VALUES ('159', '10', 'pay_baidu_line', '百度收银台（小程序使用）', '', '23', '9', '', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('160', '10', 'pay_baidu_open', '是否开启', '0', '25', '6', '开启|1,关闭|0', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('161', '10', 'pay_baidu_dealid', 'dealId', '', '27', '1', '', '', '1', '0', '1', '1', '1');
INSERT INTO `sd_config` VALUES ('162', '10', 'pay_baidu_appkey', 'APP KEY', '', '29', '1', '', '', '1', '0', '1', '1', '1');
INSERT INTO `sd_config` VALUES ('163', '10', 'pay_baidu_public_key', '平台公钥', '', '31', '5', '', '', '1', '0', '1', '1', '1');
INSERT INTO `sd_config` VALUES ('164', '10', 'pay_baidu_private_key', '开发者私钥', '', '33', '5', '', '', '1', '0', '1', '1', '1');
INSERT INTO `sd_config` VALUES ('165', '10', 'pay_baidu_biz', '接口授权码', '', '35', '5', '', '百度收银台接口授权码通过官网购买，未授权时接只能支付0.01元', '1', '0', '1', '1', '1');
INSERT INTO `sd_config` VALUES ('166', '15', 'city_class_mid', '栏目连接符', '', '11', '1', '', '分站栏目在城市名称后的连接字符', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('167', '15', 'city_content_mid', '内容连接符', '', '13', '1', '', '分站内容在城市名称后的连接字符', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('168', '13', 'api_wx_autologin', '免注册绑定', '0', '0', '6', '开启|1,关闭|0', '微信公众号内访问登录免注册', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('169', '1', 'category_http', '栏目Http类型', 'http://', '21', '6', 'Http://|http://,Https://|https://', '当栏目使用域名绑定功能时使用', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('170', '15', 'city_open', '分站开关', '1', '1', '6', '开启|1,关闭|0', '关闭后前台不显示', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('171', '15', 'city_http', '分站Http类型', 'http://', '3', '6', 'Http://|http://,Https://|https://', '当分站绑定域名时使用', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('172', '16', 'open_douyin_line', '抖音小程序', '', '0', '9', '', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('173', '16', 'open_douyin_appid', 'AppID', '', '0', '1', '', '小程序AppID', '1', '0', '1', '1', '1');
INSERT INTO `sd_config` VALUES ('174', '16', 'open_douyin_appsecret', 'AppSecret', '', '0', '1', '', '小程序AppSecret', '1', '0', '1', '1', '1');
INSERT INTO `sd_config` VALUES ('175', '10', 'pay_douyin_line', '抖音支付接口（小程序使用，担保接口）', '', '37', '9', '', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('176', '10', 'pay_douyin_open', '是否开启', '0', '39', '6', '开启|1,关闭|0', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('178', '10', 'pay_douyin_token', 'Token(令牌)', '', '41', '1', '', '', '1', '0', '1', '1', '1');
INSERT INTO `sd_config` VALUES ('179', '10', 'pay_douyin_salt', 'SALT', '', '43', '1', '', '', '1', '0', '1', '1', '1');
INSERT INTO `sd_config` VALUES ('180', '6', 'weixin_share_open', '分享开关', '1', '0', '6', '开启|1,关闭|0', '微信内访问分享开关', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('181', '12', 'user_default_face', '默认头像', '/upfile/noface.gif', '0', '4', '', '会员默认头像', '1', '1', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('182', '1', 'cssam', 'CSS3动画效果', '1', '66', '6', '开启|1,关闭|0', '页面滚动动画载入效果，浏览器需支持 CSS3 动画', '1', '0', '1', '0', '0');
INSERT INTO `sd_config` VALUES ('183', '17', 'ysaimg', '优势图片1', '/img/ys1.jpg', '4', '4', '', '宽度960px 高度450px', '1', '1', '1', '0', '0');
INSERT INTO `sd_config` VALUES ('184', '17', 'ysatxt', '优势文字1', '实力雄厚\r\n集研发、生产、加工、销售为一体的现代化企业，引进国内外先进设备设有全国优良的检测试验室，全面满足公司产品的全方位的检测需要', '5', '5', '', '独立标题，使用回车换行隔开', '1', '0', '1', '0', '0');
INSERT INTO `sd_config` VALUES ('185', '17', 'ysbimg', '优势图片2', '/img/ys2.jpg', '6', '4', '', '宽度960px 高度450px', '1', '1', '1', '0', '0');
INSERT INTO `sd_config` VALUES ('186', '17', 'ysbtxt', '优势文字2', '经验丰富\r\n公司以品质优良、效率优良、信誉优良、服务优良为宗旨，建立严格全面的质量管理体系，多年来深受客户信任', '7', '5', '', '独立标题，使用回车换行隔开', '1', '0', '1', '0', '0');
INSERT INTO `sd_config` VALUES ('187', '17', 'yscimg', '优势图片3', '/img/ys3.jpg', '8', '4', '', '宽度960px 高度450px', '1', '1', '1', '0', '0');
INSERT INTO `sd_config` VALUES ('188', '17', 'ysctxt', '优势文字3', '质量保证\r\n产品尺寸严格依照ISO标准，在生产流程的各个环节我们根据客户的要求，进行了进行细化的品质管控。我们奉行“客户至上，品质优先”的生产原则', '9', '5', '', '独立标题，使用回车换行隔开', '1', '0', '1', '0', '0');
INSERT INTO `sd_config` VALUES ('189', '17', 'ysdimg', '优势图片4', '/img/ys4.jpg', '10', '4', '', '宽度960px 高度450px', '1', '1', '1', '0', '0');
INSERT INTO `sd_config` VALUES ('190', '17', 'ysdtxt', '优势文字4', '完善服务\r\n“用真心服务，让客户感动”为服务理念，深化品牌建设，愿与国内外相关行业展开各种形式的技术交流与合作，建立互利共赢，长期稳定的战略伙伴关系', '11', '5', '', '独立标题，使用回车换行隔开', '1', '0', '1', '0', '0');
INSERT INTO `sd_config` VALUES ('191', '8', 'qqhm', 'QQ号码', '631897379', '0', '1', '', 'QQ客服', '1', '0', '1', '0', '0');
INSERT INTO `sd_config` VALUES ('192', '1', 'defimg', '栏目默认banner', '/img/banner.jpg', '12', '4', '', '栏目banner不上传图片，显示的统一图片，高度360px；宽度不限', '1', '1', '1', '0', '0');
INSERT INTO `sd_config` VALUES ('193', '17', 'yswt', '优势文图', '', '1', '9', '', '', '1', '0', '1', '0', '0');
INSERT INTO `sd_config` VALUES ('194', '17', 'ysbt', '优势标题', '选择我们的四大理由！\r\n施工、技术服务、检测、研发、售后于一体的品牌企业，质高价实服务好', '3', '5', '', '独立标题，使用回车换行隔开', '1', '0', '1', '0', '0');
INSERT INTO `sd_config` VALUES ('195', '17', 'isys', '优势开关', '1', '2', '6', '开启|1,关闭|0', '', '1', '0', '1', '0', '0');
INSERT INTO `sd_config` VALUES ('196', '17', 'gssj', '公司数据', '', '12', '9', '', '', '1', '0', '1', '0', '0');
INSERT INTO `sd_config` VALUES ('197', '17', 'gssjtxt', '数据统计', '2016\r\n年\r\n公司成立\r\n1000\r\n万\r\n注册资本\r\n98\r\n人\r\n专业技术人员\r\n169\r\n家\r\n成功合作案例', '14', '5', '', '独立标题，使用回车换行隔开', '1', '0', '1', '0', '0');
INSERT INTO `sd_config` VALUES ('198', '17', 'issj', '数据开关', '1', '13', '6', '开启|1,关闭|0', '', '1', '0', '1', '0', '0');
INSERT INTO `sd_config` VALUES ('199', '9', 'admin_code_google', '谷歌密钥', '', '3', '1', '', '如果使用：谷歌验证码，请点击【生成】按钮生成密钥，然后通过【身份验证器】APP，扫描二维码', '1', '0', '1', '1', '1');
INSERT INTO `sd_config` VALUES ('200', '9', 'admin_logo', '后台Logo', '/public/admin/images/logo.png', '1', '4', '', '建议尺寸：200*40', '1', '1', '1', '1', '1');
INSERT INTO `sd_config` VALUES ('201', '10', 'pay_alipay_public', '支付宝公钥', '', '7', '5', '', '', '1', '0', '1', '1', '1');
INSERT INTO `sd_config` VALUES ('202', '10', 'pay_alipay_private', '商户私钥', '', '7', '5', '', '', '1', '0', '1', '1', '1');
INSERT INTO `sd_config` VALUES ('203', '1', 'beian_line', '公安备案号', '', '13', '9', '', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('204', '1', 'beian_num', '备案号', '', '13', '1', '', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('205', '1', 'beian_url', '备案链接', '', '13', '1', '', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config_group` VALUES ('1', '基本设置', '0', '0', '1', '1');
INSERT INTO `sd_config_group` VALUES ('2', '运行模式', '0', '0', '1', '1');
INSERT INTO `sd_config_group` VALUES ('3', '邮件设置', '0', '0', '1', '1');
INSERT INTO `sd_config_group` VALUES ('4', '附件设置', '0', '0', '1', '1');
INSERT INTO `sd_config_group` VALUES ('5', '手机站', '0', '0', '1', '1');
INSERT INTO `sd_config_group` VALUES ('6', '微信设置', '0', '0', '1', '2');
INSERT INTO `sd_config_group` VALUES ('7', '友情链接', '0', 'link', '1', '0');
INSERT INTO `sd_config_group` VALUES ('8', '联系方式', '0', '0', '1', '1');
INSERT INTO `sd_config_group` VALUES ('9', '后台相关', '0', '0', '1', '1');
INSERT INTO `sd_config_group` VALUES ('10', '支付接口', '0', '0', '1', '2');
INSERT INTO `sd_config_group` VALUES ('11', '云存储', '0', '0', '1', '2');
INSERT INTO `sd_config_group` VALUES ('12', '会员设置', '0', 'user', '1', '0');
INSERT INTO `sd_config_group` VALUES ('13', '快捷登录', '0', '0', '1', '2');
INSERT INTO `sd_config_group` VALUES ('14', '社区设置', '0', 'bbs', '1', '0');
INSERT INTO `sd_config_group` VALUES ('15', '城市分站', '0', 'city', '1', '0');
INSERT INTO `sd_config_group` VALUES ('16', '小程序接口', '0', '0', '1', '2');
INSERT INTO `sd_config_group` VALUES ('17', '首页文图', '0', '0', '1', '1');
INSERT INTO `sd_content` VALUES ('1', '产品标题10【后台可添加、修改、删除】', '/upfile/2021/03/1614686777815.jpg', '1', '16', '0', '1', '0', '0', '0', '0', '0', '0', '', '1652672208', '1652672208', '产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关', '', '', '', '', '', '', 'a:0:{}', '', '1', '0', '', '[]', '0');
INSERT INTO `sd_content` VALUES ('2', '产品标题9【后台可添加、修改、删除】', '/upfile/2021/03/1614686777329.jpg', '1', '16', '0', '1', '0', '0', '0', '0', '0', '0', '', '1652672208', '1652672208', '产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关', '', '', '', '', '', '', 'a:0:{}', '', '1', '0', '', '[]', '0');
INSERT INTO `sd_content` VALUES ('3', '产品标题8【后台可添加、修改、删除】', '/upfile/2021/03/1614686777990.jpg', '1', '16', '0', '1', '0', '0', '0', '0', '0', '0', '', '1652672208', '1652672208', '产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关', '', '', '', '', '', '', 'a:0:{}', '', '1', '0', '', '[]', '0');
INSERT INTO `sd_content` VALUES ('4', '产品标题7【后台可添加、修改、删除】', '/upfile/2021/03/1614686777144.jpg', '1', '16', '0', '1', '0', '0', '0', '0', '0', '0', '', '1652672208', '1652672208', '产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关', '', '', '', '', '', '', 'a:0:{}', '', '1', '0', '', '[]', '0');
INSERT INTO `sd_content` VALUES ('5', '产品标题6【后台可添加、修改、删除】', '/upfile/2021/03/1614686777502.jpg', '1', '16', '1', '1', '0', '0', '0', '0', '0', '0', '', '1652672208', '1652672208', '产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关', '', '', '', '', '', '', 'a:0:{}', '', '1', '0', '', '[]', '0');
INSERT INTO `sd_content` VALUES ('6', '产品标题5【后台可添加、修改、删除】', '/upfile/2021/03/1614686777801.jpg', '1', '16', '0', '1', '0', '0', '0', '0', '0', '0', '', '1652672208', '1652672208', '产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关', '', '', '', '', '', '', 'a:0:{}', '', '1', '0', '', '[]', '0');
INSERT INTO `sd_content` VALUES ('7', '产品标题4【后台可添加、修改、删除】', '/upfile/2021/03/1614686777942.jpg', '1', '16', '0', '1', '0', '0', '0', '0', '0', '0', '', '1652672208', '1652672208', '产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关', '', '', '', '', '', '', 'a:0:{}', '', '1', '0', '', '[]', '0');
INSERT INTO `sd_content` VALUES ('8', '产品标题3【后台可添加、修改、删除】', '/upfile/2021/03/1614686777363.jpg', '1', '16', '1', '1', '0', '0', '0', '0', '0', '0', '', '1652672208', '1652672208', '产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关', '', '', '', '', '', '', 'a:0:{}', '', '1', '0', '', '[]', '0');
INSERT INTO `sd_content` VALUES ('9', '产品标题2【后台可添加、修改、删除】', '/upfile/2021/03/1614686776931.jpg', '1', '16', '10', '1', '0', '0', '0', '0', '0', '0', '', '1652672208', '1652672208', '产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关', '产品,热门关键词', '', '', '', '', '', 'a:0:{}', '', '1', '0', '', '[{\"name\":\"产品\",\"id\":\"4\"},{\"name\":\"热门关键词\",\"id\":\"3\"}]', '0');
INSERT INTO `sd_content` VALUES ('10', '新闻相关标题12【后台可添加、修改、删除】', '', '0', '20', '0', '1', '0', '0', '0', '0', '0', '0', '', '1652672208', '1652672208', '这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关', '', '', '', '', '', '', 'a:0:{}', '', '1', '0', '', '[]', '0');
INSERT INTO `sd_content` VALUES ('11', '工程案例标题10【后台可添加、修改、删除】', '/upfile/2021/03/1614686777990.jpg', '1', '4', '0', '1', '0', '0', '0', '0', '0', '0', '', '1652672208', '1652672208', '工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关', '', '', '', '', '', '', 'a:0:{}', '', '1', '0', '', '[]', '0');
INSERT INTO `sd_content` VALUES ('12', '工程案例标题9【后台可添加、修改、删除】', '/upfile/2021/03/1614686777329.jpg', '1', '4', '0', '1', '0', '0', '0', '0', '0', '0', '', '1652672208', '1652672208', '工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关', '', '', '', '', '', '', 'a:0:{}', '', '1', '0', '', '[]', '0');
INSERT INTO `sd_content` VALUES ('13', '工程案例标题8【后台可添加、修改、删除】', '/upfile/2021/03/1614686777815.jpg', '1', '4', '0', '1', '0', '0', '0', '0', '0', '0', '', '1652672208', '1652672208', '工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关', '', '', '', '', '', '', 'a:0:{}', '', '1', '0', '', '[]', '0');
INSERT INTO `sd_content` VALUES ('14', '工程案例标题7【后台可添加、修改、删除】', '/upfile/2021/03/1614686777786.jpg', '1', '4', '0', '1', '0', '0', '0', '0', '0', '0', '', '1652672208', '1652672208', '工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关', '', '', '', '', '', '', 'a:0:{}', '', '1', '0', '', '[]', '0');
INSERT INTO `sd_content` VALUES ('15', '工程案例标题6【后台可添加、修改、删除】', '/upfile/2021/03/1614686777126.jpg', '1', '4', '0', '1', '0', '0', '0', '0', '0', '0', '', '1652672208', '1652672208', '工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关', '', '', '', '', '', '', 'a:0:{}', '', '1', '0', '', '[]', '0');
INSERT INTO `sd_content` VALUES ('16', '工程案例标题5【后台可添加、修改、删除】', '/upfile/2021/03/1614686778545.jpg', '1', '4', '0', '1', '0', '0', '0', '0', '0', '0', '', '1652672208', '1652672208', '工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关', '', '', '', '', '', '', 'a:0:{}', '', '1', '0', '', '[]', '0');
INSERT INTO `sd_content` VALUES ('17', '工程案例标题4【后台可添加、修改、删除】', '/upfile/2021/03/1614686778735.jpg', '1', '4', '0', '1', '0', '0', '0', '0', '0', '0', '', '1652672208', '1652672208', '工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关', '', '', '', '', '', '', 'a:0:{}', '', '1', '0', '', '[]', '0');
INSERT INTO `sd_content` VALUES ('18', '工程案例标题3【后台可添加、修改、删除】', '/upfile/2021/03/1614686778250.jpg', '1', '4', '0', '1', '0', '0', '0', '0', '0', '0', '', '1652672208', '1652672208', '工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关', '', '', '', '', '', '', 'a:0:{}', '', '1', '0', '', '[]', '0');
INSERT INTO `sd_content` VALUES ('19', '新闻相关标题11【后台可添加、修改、删除】', '', '0', '20', '1', '1', '0', '0', '0', '1', '0', '0', '', '1652672208', '1652672208', '这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关', '', '', '', '', '', '', 'a:0:{}', '', '1', '0', '', '[]', '0');
INSERT INTO `sd_content` VALUES ('20', '新闻相关标题10【后台可添加、修改、删除】', '/upfile/2021/03/1614686777801.jpg', '1', '20', '0', '1', '0', '0', '0', '0', '0', '0', '', '1652672208', '1652672208', '这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关', '', '', '', '', '', '', 'a:0:{}', '', '1', '0', '', '[]', '0');
INSERT INTO `sd_content` VALUES ('21', '新闻相关标题9【后台可添加、修改、删除】', '', '0', '20', '0', '1', '0', '0', '0', '0', '0', '0', '', '1652672208', '1652672208', '这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关', '', '', '', '', '', '', 'a:0:{}', '', '1', '0', '', '[]', '0');
INSERT INTO `sd_content` VALUES ('22', '新闻相关标题8【后台可添加、修改、删除】', '', '0', '20', '0', '1', '0', '0', '0', '0', '0', '0', '', '1652672208', '1652672208', '这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关', '', '', '', '', '', '', 'a:0:{}', '', '1', '0', '', '[]', '0');
INSERT INTO `sd_content` VALUES ('23', '新闻相关标题7【后台可添加、修改、删除】', '', '0', '20', '0', '1', '0', '0', '0', '0', '0', '0', '', '1652672208', '1652672208', '这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关', '', '', '', '', '', '', 'a:0:{}', '', '1', '0', '', '[]', '0');
INSERT INTO `sd_content` VALUES ('24', '新闻相关标题6【后台可添加、修改、删除】', '/upfile/2021/03/1614686777942.jpg', '1', '20', '0', '1', '0', '0', '0', '0', '0', '0', '', '1652672208', '1652672208', '这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关', '', '', '', '', '', '', 'a:0:{}', '', '1', '0', '', '[]', '0');
INSERT INTO `sd_content` VALUES ('25', '新闻相关标题5【后台可添加、修改、删除】', '/upfile/2021/03/1614686776931.jpg', '1', '20', '0', '1', '0', '0', '0', '2', '0', '0', '', '1652672208', '1652672208', '这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关', '新闻,焦点图,热门关键词', '', '', '', '', '', 'a:0:{}', '', '1', '0', '', '[{\"name\":\"新闻\",\"id\":\"1\"},{\"name\":\"焦点图\",\"id\":\"2\"},{\"name\":\"热门关键词\",\"id\":\"3\"}]', '0');
INSERT INTO `sd_content` VALUES ('26', '产品测试工程师', '', '0', '24', '3', '1', '0', '0', '0', '0', '0', '0', '', '1652672208', '1652672208', '<p>1、本科及以上学历，电子或类似专业，10年以上燃热产品开发或测试经验；</p><p>2、熟悉燃气热水器相关的标准和法律法规要求；</p><p>3、组织协调能力好，有良好的服务意识和团队合作精神、较强的执行力；</p><p>4、英语口语及应用熟练。</p><p><br/></p>', '销售', '', '', '', '', '', 'a:0:{}', '', '1', '0', '', '[{\"name\":\"销售\",\"id\":\"5\"}]', '0');
INSERT INTO `sd_content` VALUES ('27', '自动化工程师', '', '0', '24', '12', '1', '0', '0', '0', '3', '0', '0', '', '1652672208', '1652672208', '<p>1、本科及以上学历，电子或类似专业，10年以上燃热产品开发或测试经验；</p><p>2、熟悉燃气热水器相关的标准和法律法规要求；</p><p>3、组织协调能力好，有良好的服务意识和团队合作精神、较强的执行力；</p><p>4、英语口语及应用熟练。</p><p><br/></p>', '销售', '', '', '', '', '', 'a:0:{}', '', '1', '0', '', '[{\"name\":\"销售\",\"id\":\"5\"}]', '0');
INSERT INTO `sd_content` VALUES ('28', '产品标题1【后台可添加、修改、删除】', '/upfile/2021/03/1614686778250.jpg', '1', '16', '22', '1', '0', '0', '0', '0', '0', '0', '', '1652672208', '1652672208', '产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关', '', '', '', '', '', '', 'a:0:{}', '', '1', '0', '', '[]', '0');
INSERT INTO `sd_content` VALUES ('29', '新闻相关标题4【后台可添加、修改、删除】', '', '0', '20', '0', '1', '0', '0', '0', '0', '0', '0', '', '1652672208', '1652672208', '这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关', '', '', '', '', '', '', 'a:0:{}', '', '1', '0', '', '[]', '0');
INSERT INTO `sd_content` VALUES ('30', '新闻相关标题3【后台可添加、修改、删除】', '', '0', '20', '0', '1', '0', '0', '0', '0', '0', '0', '', '1652672208', '1652672208', '这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关', '', '', '', '', '', '', 'a:0:{}', '', '1', '0', '', '[]', '0');
INSERT INTO `sd_content` VALUES ('31', '新闻相关标题2【后台可添加、修改、删除】', '/upfile/2021/03/1614686777990.jpg', '1', '20', '1', '1', '0', '0', '0', '2', '0', '0', '', '1652672208', '1652672208', '这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关', '', '', '', '', '', '', 'a:0:{}', '', '1', '0', '', '[]', '0');
INSERT INTO `sd_content` VALUES ('32', '新闻相关标题1【后台可添加、修改、删除】', '/upfile/2021/03/1614686777126.jpg', '1', '20', '2', '1', '0', '0', '0', '1', '0', '0', '', '1652672208', '1652672208', '这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关', '', '', '', '', '', '', 'a:0:{}', '', '1', '0', '', '[]', '0');
INSERT INTO `sd_content` VALUES ('33', '工程案例标题2【后台可添加、修改、删除】', '/upfile/2021/03/1614686777363.jpg', '1', '4', '0', '1', '0', '0', '0', '1', '0', '0', '', '1652672208', '1652672208', '工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关', '', '', '', '', '', '', 'a:0:{}', '', '1', '0', '', '[]', '0');
INSERT INTO `sd_content` VALUES ('34', '工程案例标题1【后台可添加、修改、删除】', '/upfile/2021/03/1614686777801.jpg', '1', '4', '2', '1', '0', '0', '0', '2', '0', '0', '', '1652672208', '1652672208', '工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关', '', '', '', '', '', '', 'a:0:{}', '', '1', '0', '', '[]', '0');
INSERT INTO `sd_content` VALUES ('35', '常见问题相关标题8【后台可添加、修改、删除】', '', '0', '22', '0', '1', '0', '0', '0', '0', '0', '0', '', '1652672208', '1652672208', '常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关', '', '', '', '', '', '', 'a:0:{}', '', '1', '0', '', '[]', '0');
INSERT INTO `sd_content` VALUES ('36', '常见问题相关标题7【后台可添加、修改、删除】', '', '0', '22', '0', '1', '0', '0', '0', '0', '0', '0', '', '1652672208', '1652672208', '常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关', '', '', '', '', '', '', 'a:0:{}', '', '1', '0', '', '[]', '0');
INSERT INTO `sd_content` VALUES ('37', '常见问题相关标题6【后台可添加、修改、删除】', '', '0', '22', '0', '1', '0', '0', '0', '0', '0', '0', '', '1652672208', '1652672208', '常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关', '', '', '', '', '', '', 'a:0:{}', '', '1', '0', '', '[]', '0');
INSERT INTO `sd_content` VALUES ('38', '常见问题相关标题5【后台可添加、修改、删除】', '', '0', '22', '0', '1', '0', '0', '0', '0', '0', '0', '', '1652672208', '1652672208', '常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关', '', '', '', '', '', '', 'a:0:{}', '', '1', '0', '', '[]', '0');
INSERT INTO `sd_content` VALUES ('39', '常见问题相关标题4【后台可添加、修改、删除】', '', '0', '22', '0', '1', '0', '0', '0', '0', '0', '0', '', '1652672208', '1652672208', '常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关', '', '', '', '', '', '', 'a:0:{}', '', '1', '0', '', '[]', '0');
INSERT INTO `sd_content` VALUES ('40', '常见问题相关标题3【后台可添加、修改、删除】', '', '0', '22', '0', '1', '0', '0', '0', '0', '0', '0', '', '1652672208', '1652672208', '常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关', '', '', '', '', '', '', 'a:0:{}', '', '1', '0', '', '[]', '0');
INSERT INTO `sd_content` VALUES ('41', '常见问题相关标题2【后台可添加、修改、删除】', '', '0', '22', '0', '1', '0', '0', '0', '0', '0', '0', '', '1652672208', '1652672208', '常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关', '', '', '', '', '', '', 'a:0:{}', '', '1', '0', '', '[]', '0');
INSERT INTO `sd_content` VALUES ('42', '常见问题相关标题1【后台可添加、修改、删除】', '', '0', '22', '1', '1', '0', '0', '0', '1', '0', '0', '', '1652672208', '1652672208', '常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关', '', '', '', '', '', '', 'a:0:{}', '', '1', '0', '', '[]', '0');
INSERT INTO `sd_content` VALUES ('43', '行业资讯相关标题信息12【后台可修改、添加、删除】', '', '0', '21', '0', '1', '0', '0', '0', '0', '0', '0', '', '1652672208', '1652672208', '行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关', '', '', '', '', '', '', 'a:0:{}', '', '1', '0', '', '[]', '0');
INSERT INTO `sd_content` VALUES ('44', '行业资讯相关标题信息11【后台可修改、添加、删除】', '', '0', '21', '0', '1', '0', '0', '0', '0', '0', '0', '', '1652672208', '1652672208', '行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关', '', '', '', '', '', '', 'a:0:{}', '', '1', '0', '', '[]', '0');
INSERT INTO `sd_content` VALUES ('45', '行业资讯相关标题信息10【后台可修改、添加、删除】', '', '0', '21', '0', '1', '0', '0', '0', '0', '0', '0', '', '1652672208', '1652672208', '行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关', '', '', '', '', '', '', 'a:0:{}', '', '1', '0', '', '[]', '0');
INSERT INTO `sd_content` VALUES ('46', '行业资讯相关标题信息9【后台可修改、添加、删除】', '', '0', '21', '1', '1', '0', '0', '0', '0', '0', '0', '', '1652672208', '1652672208', '行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关', '', '', '', '', '', '', 'a:0:{}', '', '1', '0', '', '[]', '0');
INSERT INTO `sd_content` VALUES ('47', '行业资讯相关标题信息8【后台可修改、添加、删除】', '', '0', '21', '2', '1', '0', '0', '0', '0', '0', '0', '', '1652672208', '1652672208', '行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关', '', '', '', '', '', '', 'a:0:{}', '', '1', '0', '', '[]', '0');
INSERT INTO `sd_content` VALUES ('48', '行业资讯相关标题信息7【后台可修改、添加、删除】', '/upfile/2021/03/1614686777801.jpg', '1', '21', '6', '1', '0', '0', '0', '1', '0', '0', '', '1652672208', '1652672208', '行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关', '', '', '', '', '', '', 'a:0:{}', '', '1', '0', '', '[]', '0');
INSERT INTO `sd_content` VALUES ('49', '行业资讯相关标题信息6【后台可修改、添加、删除】', '', '0', '21', '0', '1', '0', '0', '0', '0', '0', '0', '', '1652672208', '1652672208', '行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关', '', '', '', '', '', '', 'a:0:{}', '', '1', '0', '', '[]', '0');
INSERT INTO `sd_content` VALUES ('50', '行业资讯相关标题信息5【后台可修改、添加、删除】', '', '0', '21', '0', '1', '0', '0', '0', '0', '0', '0', '', '1652672208', '1652672208', '行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关', '', '', '', '', '', '', 'a:0:{}', '', '1', '0', '', '[]', '0');
INSERT INTO `sd_content` VALUES ('51', '行业资讯相关标题信息4【后台可修改、添加、删除】', '', '0', '21', '6', '1', '0', '0', '0', '0', '0', '0', '', '1652672208', '1652672208', '行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关', '', '', '', '', '', '', 'a:0:{}', '', '1', '0', '', '[]', '0');
INSERT INTO `sd_content` VALUES ('52', '行业资讯相关标题信息3【后台可修改、添加、删除】', '', '0', '21', '0', '1', '0', '0', '0', '0', '0', '0', '', '1652672208', '1652672208', '行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关', '', '', '', '', '', '', 'a:0:{}', '', '1', '0', '', '[]', '0');
INSERT INTO `sd_content` VALUES ('53', '行业资讯相关标题信息2【后台可修改、添加、删除】', '', '0', '21', '0', '1', '0', '0', '0', '0', '0', '0', '', '1652672208', '1652672208', '行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关', '', '', '', '', '', '', 'a:0:{}', '', '1', '0', '', '[]', '0');
INSERT INTO `sd_content` VALUES ('54', '行业资讯相关标题信息1【后台可修改、添加、删除】', '/upfile/2021/03/1614686777786.jpg', '1', '21', '6', '1', '0', '0', '0', '1', '0', '0', '', '1652672208', '1678583244', '行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关', '', '', '', '', '', '', 'a:0:{}', '', '1', '0', '', '[]', '0');
INSERT INTO `sd_form` VALUES ('1', '简历', 'resume', '', '', '', '', '', '', '1', '2', '0', '0', '1', '0', '0', '1');
INSERT INTO `sd_form_field` VALUES ('1', '1', '申请职位', 'my_title', '1', '0', '0', '{php:get.jobname}', '', 'TEXT(255) NOT NULL', '', '1', '1', '0', '0', '', '', '', '', '', '', '1', '0', '1');
INSERT INTO `sd_form_field` VALUES ('2', '1', '姓名', 'my_truename', '1', '20', '0', '', '', 'TEXT(20) NOT NULL', '', '1', '1', '0', '0', '', '', '', '', '', '', '1', '0', '1');
INSERT INTO `sd_form_field` VALUES ('3', '1', '性别', 'my_sex', '11', '0', '0', '', '男|1,女|2', 'int(10) NOT NULL', '', '1', '1', '0', '0', '', '', '', '', '', '', '0', '0', '1');
INSERT INTO `sd_form_field` VALUES ('4', '1', '年龄', 'my_age', '3', '2', '0', '', '', 'int(10) NOT NULL', '', '3', '1', '0', '0', '', '', '', '', '', '', '1', '0', '1');
INSERT INTO `sd_form_field` VALUES ('5', '1', '手机', 'my_mobile', '1', '11', '0', '', '', 'TEXT(11) NOT NULL', '', '6', '1', '0', '0', '', '', '', '', '', '', '1', '0', '1');
INSERT INTO `sd_form_field` VALUES ('6', '1', '学历', 'my_education', '11', '0', '0', '', '大专|1,本科|2,硕士|3,博士|4', 'int(10) NOT NULL', '', '1', '1', '0', '0', '', '', '', '', '', '', '0', '0', '1');
INSERT INTO `sd_form_field` VALUES ('7', '1', '工作经验', 'my_work_exp', '8', '0', '0', '', '', 'text NOT NULL', '', '1', '1', '0', '0', '', '', '', '', '', '', '0', '0', '1');
INSERT INTO `sd_form_field` VALUES ('8', '1', '自我评价', 'my_intro', '8', '0', '0', '', '', 'text NOT NULL', '', '1', '1', '0', '0', '', '', '', '', '', '', '0', '0', '1');
INSERT INTO `sd_model` VALUES ('1', '文章模型', 'news', '', 'content/news/list.php', 'content/news/show.php', '基本设置|1,SEO设置|2,可选设置|3', '0', '1', '1', '1', '1');
INSERT INTO `sd_model` VALUES ('2', '产品模型', 'pro', '', 'content/pro/list.php', 'content/pro/show.php', '基本设置|1,SEO设置|2,可选设置|3', '0', '1', '1', '0', '0');
INSERT INTO `sd_model` VALUES ('3', '招聘模型', 'job', '', 'content/job/list.php', 'content/job/show.php', '基本设置|1,SEO设置|2,可选设置|3', '0', '1', '1', '0', '0');
INSERT INTO `sd_model_field` VALUES ('1', '1', '标题', 'title', '1', '255', '0', '', '', '', '', '1', '1', '0', '1', '0', '', '', '', '', '', '', '1', '1', '1', '1');
INSERT INTO `sd_model_field` VALUES ('2', '1', '正文', 'content', '12', '0', '0', '', '', '', '', '0', '1', '2', '1', '0', '', '', '', '', '', '', '3', '1', '1', '0');
INSERT INTO `sd_model_field` VALUES ('3', '1', '缩略图', 'pic', '5', '255', '1', '', '', '', '', '0', '1', '0', '1', '0', '', '', '', '', '', '', '5', '1', '1', '1');
INSERT INTO `sd_model_field` VALUES ('4', '1', '标签', 'tags', '1', '255', '0', '', '', '', '多个标签请使用英文逗号隔开，不能超过10个', '0', '1', '0', '1', '0', '', '', '', '', '', '', '7', '1', '1', '1');
INSERT INTO `sd_model_field` VALUES ('5', '1', '摘要', 'intro', '8', '0', '0', '', '', '', '', '0', '1', '0', '1', '0', '', '', '', '', '', '', '9', '1', '1', '1');
INSERT INTO `sd_model_field` VALUES ('6', '1', '状态', 'islock', '9', '0', '0', '1', '立即发布|1,存为草稿|0', '', '', '0', '1', '0', '1', '0', '', '', '', '', '', '', '11', '1', '1', '1');
INSERT INTO `sd_model_field` VALUES ('7', '1', '优化标题', 'seotitle', '1', '255', '0', '', '', '', '', '0', '1', '0', '2', '0', '', '', '', '', '', '', '13', '1', '1', '1');
INSERT INTO `sd_model_field` VALUES ('8', '1', '关键字', 'seokey', '8', '0', '0', '', '', '', '', '0', '1', '0', '2', '0', '', '', '', '', '', '', '15', '1', '1', '1');
INSERT INTO `sd_model_field` VALUES ('9', '1', '描述', 'seodesc', '8', '0', '0', '', '', '', '', '0', '1', '0', '2', '0', '', '', '', '', '', '', '17', '1', '1', '1');
INSERT INTO `sd_model_field` VALUES ('10', '1', '别名', 'alias', '1', '50', '0', '', '', '', '', '0', '1', '0', '2', '0', '', '', '', '', '', '', '19', '1', '1', '1');
INSERT INTO `sd_model_field` VALUES ('11', '1', '外链', 'url', '1', '255', '0', '', '', '', '添加外链时，将不显示正文内容', '0', '1', '0', '3', '0', '', '', '', '', '', '', '21', '1', '1', '1');
INSERT INTO `sd_model_field` VALUES ('12', '1', '人气', 'hits', '3', '10', '0', '0', '', '', '', '0', '1', '0', '3', '0', '', '', '', '', '', '', '23', '1', '1', '1');
INSERT INTO `sd_model_field` VALUES ('13', '1', '赞数量', 'upnum', '3', '10', '0', '0', '', '', '', '0', '1', '0', '3', '0', '', '', '', '', '', '', '25', '1', '1', '1');
INSERT INTO `sd_model_field` VALUES ('14', '1', '踩数量', 'downnum', '3', '10', '0', '0', '', '', '', '0', '1', '0', '3', '0', '', '', '', '', '', '', '27', '1', '1', '1');
INSERT INTO `sd_model_field` VALUES ('15', '1', '排序', 'ordnum', '3', '10', '0', '0', '', '', '数字越大越靠前', '0', '1', '0', '3', '0', '', '', '', '', '', '', '29', '1', '1', '1');
INSERT INTO `sd_model_field` VALUES ('16', '1', '置顶', 'ontop', '9', '0', '0', '0', '否|0,是|1', '', '', '0', '1', '0', '3', '0', '', '', '', '', '', '', '31', '1', '1', '1');
INSERT INTO `sd_model_field` VALUES ('17', '1', '推荐', 'isnice', '9', '0', '0', '0', '否|0,是|1', '', '', '0', '1', '0', '3', '0', '', '', '', '', '', '', '33', '1', '1', '1');
INSERT INTO `sd_model_field` VALUES ('18', '1', '发布日期', 'createdate', '2', '0', '0', '{php:now}', '', '', '', '0', '1', '0', '3', '0', '', '', '', '', '', '', '35', '1', '1', '1');
INSERT INTO `sd_model_field` VALUES ('19', '1', '内容页模板', 'showskin', '1', '255', '0', '', '', '', '', '0', '1', '0', '3', '0', '', '', '', '', '', '', '37', '1', '1', '1');
INSERT INTO `sd_model_field` VALUES ('20', '2', '标题', 'title', '1', '255', '0', '', '', '', '', '1', '1', '0', '1', '0', '', '', '', '', '', '', '1', '1', '1', '1');
INSERT INTO `sd_model_field` VALUES ('21', '2', '组图', 'piclist', '13', '0', '0', '', '', '', '', '0', '1', '0', '1', '0', '', '', '', '', '', '', '3', '1', '1', '0');
INSERT INTO `sd_model_field` VALUES ('22', '2', '正文', 'content', '12', '0', '0', '', '', '', '', '0', '1', '2', '1', '0', '', '', '', '', '', '', '5', '1', '1', '0');
INSERT INTO `sd_model_field` VALUES ('23', '2', '简介', 'intro', '8', '0', '0', '', '', '', '', '0', '1', '0', '1', '0', '', '', '', '', '', '', '7', '1', '1', '1');
INSERT INTO `sd_model_field` VALUES ('24', '2', '缩略图', 'pic', '5', '255', '1', '', '', '', '', '0', '1', '0', '1', '0', '', '', '', '', '', '', '9', '1', '1', '1');
INSERT INTO `sd_model_field` VALUES ('25', '2', '价格', 'price', '4', '10', '1', '', '', '', '单位：元', '1', '1', '0', '1', '0', '', '', '', '', '', '', '11', '1', '1', '0');
INSERT INTO `sd_model_field` VALUES ('26', '2', '标签', 'tags', '1', '255', '0', '', '', '', '多个标签请使用英文逗号隔开，不能超过10个', '0', '1', '0', '1', '0', '', '', '', '', '', '', '13', '1', '1', '1');
INSERT INTO `sd_model_field` VALUES ('27', '2', '状态', 'islock', '9', '0', '0', '1', '立即发布|1,存为草稿|0', '', '', '0', '1', '0', '1', '0', '', '', '', '', '', '', '15', '1', '1', '1');
INSERT INTO `sd_model_field` VALUES ('28', '2', '优化标题', 'seotitle', '1', '255', '0', '', '', '', '', '0', '1', '0', '2', '0', '', '', '', '', '', '', '17', '1', '1', '1');
INSERT INTO `sd_model_field` VALUES ('29', '2', '关键字', 'seokey', '8', '0', '0', '', '', '', '', '0', '1', '0', '2', '0', '', '', '', '', '', '', '19', '1', '1', '1');
INSERT INTO `sd_model_field` VALUES ('30', '2', '描述', 'seodesc', '8', '0', '0', '', '', '', '', '0', '1', '0', '2', '0', '', '', '', '', '', '', '21', '1', '1', '1');
INSERT INTO `sd_model_field` VALUES ('31', '2', '别名', 'alias', '1', '50', '0', '', '', '', '', '0', '1', '0', '2', '0', '', '', '', '', '', '', '23', '1', '1', '1');
INSERT INTO `sd_model_field` VALUES ('32', '2', '外链', 'url', '1', '255', '0', '', '', '', '添加外链时，将不显示正文内容', '0', '1', '0', '3', '0', '', '', '', '', '', '', '25', '1', '1', '1');
INSERT INTO `sd_model_field` VALUES ('33', '2', '人气', 'hits', '3', '10', '0', '0', '', '', '', '0', '1', '0', '3', '0', '', '', '', '', '', '', '27', '1', '1', '1');
INSERT INTO `sd_model_field` VALUES ('34', '2', '赞数量', 'upnum', '3', '10', '0', '0', '', '', '', '0', '1', '0', '3', '0', '', '', '', '', '', '', '29', '1', '1', '1');
INSERT INTO `sd_model_field` VALUES ('35', '2', '踩数量', 'downnum', '3', '10', '0', '0', '', '', '', '0', '1', '0', '3', '0', '', '', '', '', '', '', '31', '1', '1', '1');
INSERT INTO `sd_model_field` VALUES ('36', '2', '排序', 'ordnum', '3', '10', '0', '0', '', '', '数字越大越靠前', '0', '1', '0', '3', '0', '', '', '', '', '', '', '33', '1', '1', '1');
INSERT INTO `sd_model_field` VALUES ('37', '2', '置顶', 'ontop', '9', '0', '0', '0', '否|0,是|1', '', '', '0', '1', '0', '3', '0', '', '', '', '', '', '', '35', '1', '1', '1');
INSERT INTO `sd_model_field` VALUES ('38', '2', '推荐', 'isnice', '9', '0', '0', '0', '否|0,是|1', '', '', '0', '1', '0', '3', '0', '', '', '', '', '', '', '37', '1', '1', '1');
INSERT INTO `sd_model_field` VALUES ('39', '2', '发布日期', 'createdate', '2', '0', '0', '{php:now}', '', '', '', '0', '1', '0', '3', '0', '', '', '', '', '', '', '39', '1', '1', '1');
INSERT INTO `sd_model_field` VALUES ('40', '2', '内容页模板', 'showskin', '1', '255', '0', '', '', '', '', '0', '1', '0', '3', '0', '', '', '', '', '', '', '41', '1', '1', '1');
INSERT INTO `sd_model_field` VALUES ('43', '3', '职位名称', 'title', '1', '255', '0', '', '', '', '', '1', '1', '0', '1', '0', '', '', '', '', '', '', '1', '1', '1', '1');
INSERT INTO `sd_model_field` VALUES ('44', '3', '工作内容', 'content', '12', '0', '0', '', '', '', '', '0', '1', '1', '1', '0', '', '', '', '', '', '', '15', '1', '1', '0');
INSERT INTO `sd_model_field` VALUES ('45', '3', '缩略图', 'pic', '5', '0', '1', '', '', '', '', '0', '1', '0', '3', '0', '', '', '', '', '', '', '49', '1', '1', '1');
INSERT INTO `sd_model_field` VALUES ('46', '3', '标签', 'tags', '1', '255', '0', '', '', '', '多个标签请使用英文逗号隔开，不能超过10个', '0', '1', '0', '1', '0', '', '', '', '', '', '', '19', '1', '1', '1');
INSERT INTO `sd_model_field` VALUES ('47', '3', '任职要求', 'intro', '12', '0', '0', '', '', '', '', '0', '1', '1', '1', '0', '', '', '', '', '', '', '17', '1', '1', '1');
INSERT INTO `sd_model_field` VALUES ('48', '3', '状态', 'islock', '9', '0', '0', '1', '立即发布|1,存为草稿|0', '', '', '0', '1', '0', '1', '0', '', '', '', '', '', '', '21', '1', '1', '1');
INSERT INTO `sd_model_field` VALUES ('49', '3', '优化标题', 'seotitle', '1', '0', '0', '', '', '', '', '0', '1', '0', '2', '0', '', '', '', '', '', '', '23', '1', '1', '1');
INSERT INTO `sd_model_field` VALUES ('50', '3', '关键字', 'seokey', '8', '0', '0', '', '', '', '', '0', '1', '0', '2', '0', '', '', '', '', '', '', '25', '1', '1', '1');
INSERT INTO `sd_model_field` VALUES ('51', '3', '描述', 'seodesc', '8', '0', '0', '', '', '', '', '0', '1', '0', '2', '0', '', '', '', '', '', '', '27', '1', '1', '1');
INSERT INTO `sd_model_field` VALUES ('52', '3', '别名', 'alias', '1', '50', '0', '', '', '', '', '0', '1', '0', '2', '0', '', '', '', '', '', '', '29', '1', '1', '1');
INSERT INTO `sd_model_field` VALUES ('53', '3', '外链', 'url', '1', '255', '0', '', '', '', '添加外链时，将不显示正文内容', '0', '1', '0', '3', '0', '', '', '', '', '', '', '31', '1', '1', '1');
INSERT INTO `sd_model_field` VALUES ('54', '3', '人气', 'hits', '3', '10', '0', '0', '', '', '', '0', '1', '0', '3', '0', '', '', '', '', '', '', '33', '1', '1', '1');
INSERT INTO `sd_model_field` VALUES ('55', '3', '赞数量', 'upnum', '3', '0', '0', '0', '', '', '', '0', '1', '0', '3', '0', '', '', '', '', '', '', '35', '1', '1', '1');
INSERT INTO `sd_model_field` VALUES ('56', '3', '踩数量', 'downnum', '3', '0', '0', '0', '', '', '', '0', '1', '0', '3', '0', '', '', '', '', '', '', '37', '1', '1', '1');
INSERT INTO `sd_model_field` VALUES ('57', '3', '排序', 'ordnum', '3', '0', '0', '0', '', '', '数字越大越靠前', '0', '1', '0', '3', '0', '', '', '', '', '', '', '39', '1', '1', '1');
INSERT INTO `sd_model_field` VALUES ('58', '3', '置顶', 'ontop', '9', '0', '0', '0', '否|0,是|1', '', '', '0', '1', '0', '3', '0', '', '', '', '', '', '', '41', '1', '1', '1');
INSERT INTO `sd_model_field` VALUES ('59', '3', '推荐', 'isnice', '9', '0', '0', '0', '否|0,是|1', '', '', '0', '1', '0', '3', '0', '', '', '', '', '', '', '43', '1', '1', '1');
INSERT INTO `sd_model_field` VALUES ('60', '3', '发布日期', 'createdate', '2', '0', '0', '{php:now}', '', '', '', '0', '1', '0', '3', '0', '', '', '', '', '', '', '45', '1', '1', '1');
INSERT INTO `sd_model_field` VALUES ('61', '3', '内容页模板', 'showskin', '1', '0', '0', '', '', '', '', '0', '1', '0', '3', '0', '', '', '', '', '', '', '47', '1', '1', '1');
INSERT INTO `sd_model_field` VALUES ('62', '3', '工作地点', 'work_address', '1', '50', '0', '', '', '', '', '1', '1', '0', '1', '0', '', '', '', '', '', '', '3', '1', '1', '0');
INSERT INTO `sd_model_field` VALUES ('63', '3', '工作性质', 'work_nature', '11', '0', '0', '全职', '全职|全职,兼职|兼职', '', '', '1', '1', '0', '1', '0', '', '', '', '', '', '', '5', '1', '1', '0');
INSERT INTO `sd_model_field` VALUES ('64', '3', '学历要求', 'work_education', '11', '0', '0', '不限', '不限|不限,高中及以上|高中及以上,大专及以上|大专及以上,本科及以上|本科及以上,大专及以上|大专及以上', '', '', '1', '1', '0', '1', '0', '', '', '', '', '', '', '7', '1', '1', '0');
INSERT INTO `sd_model_field` VALUES ('65', '3', '薪资待遇', 'work_money', '11', '0', '0', '面议', '面议|面议,2000-3000元/月|2000-3000元/月,3000-5000元/月|3000-5000元/月,5000-8000元/月|5000-8000元/月,8000-10000元/月|8000-10000元/月,10000-20000元/月|10000-20000元/月,20000-50000元/月|20000-50000元/月', '', '', '1', '1', '0', '1', '0', '', '', '', '', '', '', '9', '1', '1', '0');
INSERT INTO `sd_model_field` VALUES ('66', '3', '工作年限', 'work_age', '11', '0', '0', '不限', '不限|不限,1年及以上|1年及以上,2年及以上|2年及以上,3年及以上|3年及以上,4年及以上|4年及以上,5年及以上|5年及以上', '', '', '1', '1', '0', '1', '0', '', '', '', '', '', '', '11', '1', '1', '0');
INSERT INTO `sd_model_field` VALUES ('67', '3', '招聘人数', 'work_num', '11', '0', '0', '若干', '若干|若干,1|1,2|2,3|3,4|4,5|5,6|6,7|7,8|8,9|9,10|10', '', '', '1', '1', '0', '1', '0', '', '', '', '', '', '', '13', '1', '1', '0');
INSERT INTO `sd_model_field` VALUES ('68', '1', '购买价格', 'price', '4', '10', '1', '0', '', '', '单位：元', '4', '1', '0', '1', '0', '', '', '', '', '', '', '10', '1', '1', '0');
INSERT INTO `sd_model_job` VALUES ('1', '26', '<p>1、负责海外市场使用及环境调研，并转化为产品标准；<br/>2、负责海外产品竞品比对及性能、可靠性验证；<br/>3、负责海外产品的品质把关，参与外销产品开发全过程。</p>', '上海', '全职', '本科及以上', '10000-20000元/月', '1年及以上', '若干');
INSERT INTO `sd_model_job` VALUES ('2', '27', '<p>1、负责海外市场使用及环境调研，并转化为产品标准；<br/>2、负责海外产品竞品比对及性能、可靠性验证；<br/>3、负责海外产品的品质把关，参与外销产品开发全过程。</p>', '上海', '全职', '大专及以上', '8000-10000元/月', '不限', '5');
INSERT INTO `sd_model_news` VALUES ('1', '10', '0', '<p>这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容</p>');
INSERT INTO `sd_model_news` VALUES ('2', '11', '0', '<p style=\"text-align: center;\"><img src=\"/upfile/2021/03/1614686777990.jpg\"/></p><p>工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容</p>');
INSERT INTO `sd_model_news` VALUES ('3', '12', '0', '<p style=\"text-align: center;\"><img src=\"/upfile/2021/03/1614686777329.jpg\"/></p><p>工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容</p>');
INSERT INTO `sd_model_news` VALUES ('4', '13', '0', '<p style=\"text-align: center;\"><img src=\"/upfile/2021/03/1614686777815.jpg\"/></p><p>工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容</p>');
INSERT INTO `sd_model_news` VALUES ('5', '14', '0', '<p style=\"text-align: center;\"><img src=\"/upfile/2021/03/1614686777786.jpg\"/></p><p>工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容</p>');
INSERT INTO `sd_model_news` VALUES ('6', '15', '0', '<p><img src=\"/upfile/2021/03/1614686777126.jpg\"/></p><p>工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容</p>');
INSERT INTO `sd_model_news` VALUES ('7', '16', '0', '<p><img src=\"/upfile/2021/03/1614686778545.jpg\"/></p><p>工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容</p>');
INSERT INTO `sd_model_news` VALUES ('8', '17', '0', '<p style=\"text-align: center;\"><img src=\"/upfile/2021/03/1614686778735.jpg\"/></p><p>工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容</p>');
INSERT INTO `sd_model_news` VALUES ('9', '18', '0', '<p style=\"text-align: center;\"><img src=\"/upfile/2021/03/1614686778250.jpg\"/></p><p>工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容</p>');
INSERT INTO `sd_model_news` VALUES ('10', '19', '0', '<p>这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容</p>');
INSERT INTO `sd_model_news` VALUES ('11', '20', '0', '<p>这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容</p>');
INSERT INTO `sd_model_news` VALUES ('12', '21', '0', '<p>这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容</p>');
INSERT INTO `sd_model_news` VALUES ('13', '22', '0', '<p>这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容</p>');
INSERT INTO `sd_model_news` VALUES ('14', '23', '0', '<p>这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容</p>');
INSERT INTO `sd_model_news` VALUES ('15', '24', '0', '<p>这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容</p>');
INSERT INTO `sd_model_news` VALUES ('16', '25', '0', '<p>这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容</p>');
INSERT INTO `sd_model_news` VALUES ('17', '29', '0', '<p>这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容</p>');
INSERT INTO `sd_model_news` VALUES ('18', '30', '0', '<p>这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容</p>');
INSERT INTO `sd_model_news` VALUES ('19', '31', '0', '<p>这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容</p>');
INSERT INTO `sd_model_news` VALUES ('20', '32', '0', '<p>这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容 这里填写相关的新闻信息内容</p>');
INSERT INTO `sd_model_news` VALUES ('21', '33', '0', '<p style=\"text-align: center;\"><img src=\"/upfile/2021/03/1614686777363.jpg\"/></p><p>工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容</p>');
INSERT INTO `sd_model_news` VALUES ('22', '34', '0', '<p style=\"text-align: center;\"><img src=\"/upfile/2021/03/1614686777801.jpg\"/></p><p>工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容工程案例相关内容</p>');
INSERT INTO `sd_model_news` VALUES ('23', '35', '0', '<p>常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息</p>');
INSERT INTO `sd_model_news` VALUES ('24', '36', '0', '<p>常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息</p>');
INSERT INTO `sd_model_news` VALUES ('25', '37', '0', '<p>常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息</p>');
INSERT INTO `sd_model_news` VALUES ('26', '38', '0', '<p>常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息</p>');
INSERT INTO `sd_model_news` VALUES ('27', '39', '0', '<p>常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息</p>');
INSERT INTO `sd_model_news` VALUES ('28', '40', '0', '<p>常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息</p>');
INSERT INTO `sd_model_news` VALUES ('29', '41', '0', '<p>常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息</p>');
INSERT INTO `sd_model_news` VALUES ('30', '42', '0', '<p>常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息常见问题相关内容信息</p>');
INSERT INTO `sd_model_news` VALUES ('31', '43', '0', '<p>行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息</p>');
INSERT INTO `sd_model_news` VALUES ('32', '44', '0', '<p>行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息</p>');
INSERT INTO `sd_model_news` VALUES ('33', '45', '0', '<p>行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息</p>');
INSERT INTO `sd_model_news` VALUES ('34', '46', '0', '<p>行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息</p>');
INSERT INTO `sd_model_news` VALUES ('35', '47', '0', '<p>行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息</p>');
INSERT INTO `sd_model_news` VALUES ('36', '48', '0', '<p>行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息</p>');
INSERT INTO `sd_model_news` VALUES ('37', '49', '0', '<p>行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息</p>');
INSERT INTO `sd_model_news` VALUES ('38', '50', '0', '<p>行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息</p>');
INSERT INTO `sd_model_news` VALUES ('39', '51', '0', '<p>行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息</p>');
INSERT INTO `sd_model_news` VALUES ('40', '52', '0', '<p>行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息</p>');
INSERT INTO `sd_model_news` VALUES ('41', '53', '0', '<p>行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息</p>');
INSERT INTO `sd_model_news` VALUES ('42', '54', '0', '<p>行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息行业资讯相关内容信息</p>');
INSERT INTO `sd_model_page` VALUES ('1', '9', '{\"1\":{\"image\":\"/upfile/2021/03/1614759164289.jpg\",\"desc\":\"证书名称1\"},\"2\":{\"image\":\"/upfile/2021/03/1614759164957.jpg\",\"desc\":\"证书名称2\"},\"3\":{\"image\":\"/upfile/2021/03/1614759164328.jpg\",\"desc\":\"证书名称3\"},\"4\":{\"image\":\"/upfile/2021/03/1614759164221.jpg\",\"desc\":\"证书名称4\"},\"6\":{\"image\":\"/upfile/2021/03/1614759165373.jpg\",\"desc\":\"证书名称5\"},\"5\":{\"image\":\"/upfile/2021/03/1614759164797.jpg\",\"desc\":\"证书名称6\"}}', '<p><br/></p>');
INSERT INTO `sd_model_page` VALUES ('2', '7', '\"\"', '<p><img src=\"/upfile/2021/03/1614769413951.jpg\"/></p><p><strong><span style=\"font-size: 18px;\">梵蒂冈城国</span></strong>，罗马教廷的所在地，位于罗马西北角的梵蒂冈高地上，面积0.44平方公里，常住人口约800人，大多为神职人员。梵蒂冈原为中世纪教宗国的中心，1870年教宗国领土并入意大利后，教宗退居梵蒂冈；1929年同意大利签订《拉特兰条约》，成为独立国家。梵蒂冈是全球领土面积最小、人口最少的国家。</p><p>梵蒂冈究竟是多小？北京市土地面积为16410.54平方公里，梵蒂冈仅是其1/37297。公元476年，西罗马帝国的末代皇帝被逼退位，帝国灭亡。最终在意大利民族统一战争中，罗马城被意大利吞并，教皇国只剩下小小的梵蒂冈。这时候教皇将自己禁锢在梵蒂冈城堡内，并不屈服。梵蒂冈城国成立。</p>_sdcms_content_page_<p>梵蒂冈是以教宗为君主的政教合一的主权国家。中央机构设有国务院、圣部、理事会等。</p><p>国务院是教宗直接领导的工作机构，协助教宗行使职权，主管内政和外交事务，由枢机主教衔的国务卿领导。国务卿由教宗任命，管理梵蒂冈行政并掌管教宗枢密事务。圣部负责处理天主教的各种日常事务，各部由部长负责，下设秘书长和副秘书长。现有信理部、万民福音部、东方教会部、礼仪与圣事部、圣职部、修会部、主教部、册封圣人部、天主教教育部等9个圣部。</p><p>理事会负责处理一些专门事务，包括平信徒理事会、正义和平理事会、家庭理事会、跨宗教对话理事会、新福音推广理事会等12个理事会。各理事会由主席负责，一般由枢机主教担任，任期5年，下设秘书长和副秘书长。</p><p>梵蒂冈国旗由两个面积相等的竖长方形组成，靠旗杆侧为黄色，另一侧则为白色，绘有教宗的牧徽。国徽是背衬着红色的教宗保禄六世的宗徽。国歌为《教宗进行曲》。</p><p><br/></p>');
INSERT INTO `sd_model_page` VALUES ('3', '8', '\"\"', '<p>企业文化本质，是通过企业制度的严格执行衍生而成，制度上的强制或激励最终促使群体产生某一行为自觉，这一群体的行为自觉便组成了企业文化。企业文化的本质在东堂策《企业文化一字解》中得到深刻印证，其中也详细道出企业文化产生机理。<br/></p><p><strong><span style=\"font-size: 18px;\">产生</span></strong><br/></p><p>企业领导者把“文化变化人”的功能应用于企业，以解决现代企业管理中的问题，就有了企业文化。企业管理理论和企业文化管理理论都追求效益。但前者为追求效益而把人当作客体，后者为追求效益把文化概念自觉应用于企业，把具有丰富创造性的人作为管理理论的中心。这种指导思想反映到企业管理中去，就有了人们称之为企业文化的种种观念。</p><p><strong><span style=\"font-size: 18px;\">认识</span></strong><br/></p><p>从企业文化的现实出发，进行深入的调查研究，把握企业文化各种现象之间的本质联系。依据实践经验，从感性认识到理性认识，进行科学的概括、总结。</p><p><strong><span style=\"font-size: 18px;\">意义</span></strong><br/></p><p>一．企业文化能激发员工的使命感。不管是什么企业都有它的责任和使命，企业使命感是全体员工工作的目标和方向，是企业不断发展或前进的动力之源。</p><p>二．企业文化能凝聚员工的归属感。企业文化的作用就是通过企业价值观的提炼和传播，让一群来自不同地方的人共同追求同一个梦想。</p><p>三．企业文化能加强员工的责任感。企业要通过大量的资料和文件宣传员工责任感的重要性，管理人员要给全体员工灌输责任意识，危机意识和团队意识，要让大家清楚地认识企业是全体员工共同的企业。</p><p>四．企业文化能赋予员工的荣誉感。每个人都要在自己的工作岗位，工作领域，多做贡献，多出成绩，多追求荣誉感。</p><p>五．企业文化能实现员工的成就感。一个企业的繁荣昌盛关系到每一个公司员工的生存，企业繁荣了，员工们就会引以为豪，会更积极努力的进取，荣耀越高，成就感就越大，越明显。</p>');
INSERT INTO `sd_model_page` VALUES ('4', '23', '\"\"', '<p><strong><span style=\"font-size: 18px;\">用人理念：</span></strong></p><p>1、以德为先，专业为本，激情进取，追求卓越<br/>2、诚信专业、简单务实，团队协作，激情感恩<br/>3、主动敬业、追求卓越</p><p><br/><strong><span style=\"font-size: 18px;\">用人原则：</span></strong></p><p>第一条：有德有才，破格重用，有德无才，培养使用，有才无德，限制录用，无德有才，坚持不用；<br/>第二条：以事业留人、以感情留人、以待遇留人</p>');
INSERT INTO `sd_model_page` VALUES ('5', '6', '\"\"', '<p><span style=\"font-size: 18px;\"><strong>某某某科技有限公司</strong><br>电话：010-12345678<br>地址：北京市朝阳区CBD国际大厦</span></p>\r\n<p><iframe src=\"/?m=plug&c=index&a=index&p=map\" frameborder=\"0\" width=\"100%\" height=\"400\" scrolling=\"no\"></iframe></p>');
INSERT INTO `sd_model_pro` VALUES ('1', '1', '0', '<p>产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍</p>', '{\"6\":{\"image\":\"/upfile/2021/03/1614686777815.jpg\",\"desc\":\"\"},\"4\":{\"image\":\"/upfile/2021/03/1614686777363.jpg\",\"desc\":\"\"},\"2\":{\"image\":\"/upfile/2021/03/1614686777942.jpg\",\"desc\":\"\"},\"3\":{\"image\":\"/upfile/2021/03/1614686777801.jpg\",\"desc\":\"\"}}');
INSERT INTO `sd_model_pro` VALUES ('2', '2', '0', '<p>产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍</p>', '{\"6\":{\"image\":\"/upfile/2021/03/1614686777329.jpg\",\"desc\":\"\"},\"4\":{\"image\":\"/upfile/2021/03/1614686777363.jpg\",\"desc\":\"\"},\"2\":{\"image\":\"/upfile/2021/03/1614686777942.jpg\",\"desc\":\"\"},\"3\":{\"image\":\"/upfile/2021/03/1614686777801.jpg\",\"desc\":\"\"}}');
INSERT INTO `sd_model_pro` VALUES ('3', '3', '0', '<p>产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍</p>', '{\"6\":{\"image\":\"/upfile/2021/03/1614686777990.jpg\",\"desc\":\"\"},\"3\":{\"image\":\"/upfile/2021/03/1614686777801.jpg\",\"desc\":\"\"},\"2\":{\"image\":\"/upfile/2021/03/1614686777942.jpg\",\"desc\":\"\"},\"4\":{\"image\":\"/upfile/2021/03/1614686777363.jpg\",\"desc\":\"\"}}');
INSERT INTO `sd_model_pro` VALUES ('4', '4', '0', '<p>产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍</p>', '{\"6\":{\"image\":\"/upfile/2021/03/1614686777144.jpg\",\"desc\":\"\"},\"2\":{\"image\":\"/upfile/2021/03/1614686777942.jpg\",\"desc\":\"\"},\"3\":{\"image\":\"/upfile/2021/03/1614686777801.jpg\",\"desc\":\"\"},\"4\":{\"image\":\"/upfile/2021/03/1614686777363.jpg\",\"desc\":\"\"}}');
INSERT INTO `sd_model_pro` VALUES ('5', '5', '0', '<p>产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍</p>', '{\"6\":{\"image\":\"/upfile/2021/03/1614686777502.jpg\",\"desc\":\"\"},\"2\":{\"image\":\"/upfile/2021/03/1614686777942.jpg\",\"desc\":\"\"},\"3\":{\"image\":\"/upfile/2021/03/1614686777801.jpg\",\"desc\":\"\"},\"4\":{\"image\":\"/upfile/2021/03/1614686777363.jpg\",\"desc\":\"\"}}');
INSERT INTO `sd_model_pro` VALUES ('6', '6', '0', '<p>产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍</p>', '{\"3\":{\"image\":\"/upfile/2021/03/1614686777801.jpg\",\"desc\":\"\"},\"5\":{\"image\":\"/upfile/2021/03/1614686777502.jpg\",\"desc\":\"\"},\"2\":{\"image\":\"/upfile/2021/03/1614686777942.jpg\",\"desc\":\"\"},\"4\":{\"image\":\"/upfile/2021/03/1614686777363.jpg\",\"desc\":\"\"}}');
INSERT INTO `sd_model_pro` VALUES ('7', '7', '0', '<p>产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍</p>', '{\"2\":{\"image\":\"/upfile/2021/03/1614686777942.jpg\",\"desc\":\"\"},\"5\":{\"image\":\"/upfile/2021/03/1614686777502.jpg\",\"desc\":\"\"},\"3\":{\"image\":\"/upfile/2021/03/1614686777801.jpg\",\"desc\":\"\"},\"4\":{\"image\":\"/upfile/2021/03/1614686777363.jpg\",\"desc\":\"\"}}');
INSERT INTO `sd_model_pro` VALUES ('8', '8', '0', '<p>产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍</p>', '{\"4\":{\"image\":\"/upfile/2021/03/1614686777363.jpg\",\"desc\":\"\"},\"2\":{\"image\":\"/upfile/2021/03/1614686777942.jpg\",\"desc\":\"\"},\"3\":{\"image\":\"/upfile/2021/03/1614686777801.jpg\",\"desc\":\"\"},\"5\":{\"image\":\"/upfile/2021/03/1614686777502.jpg\",\"desc\":\"\"}}');
INSERT INTO `sd_model_pro` VALUES ('9', '9', '0', '<p>产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍</p>', '{\"3\":{\"image\":\"/upfile/2021/03/1614686777801.jpg\",\"desc\":\"\"},\"2\":{\"image\":\"/upfile/2021/03/1614686777942.jpg\",\"desc\":\"\"},\"4\":{\"image\":\"/upfile/2021/03/1614686777363.jpg\",\"desc\":\"\"},\"5\":{\"image\":\"/upfile/2021/03/1614686777502.jpg\",\"desc\":\"\"}}');
INSERT INTO `sd_model_pro` VALUES ('10', '28', '0', '<p>产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍产品相关介绍</p>', '{\"7\":{\"image\":\"/upfile/2021/03/1614686778250.jpg\",\"desc\":\"\"},\"4\":{\"image\":\"/upfile/2021/03/1614686777363.jpg\",\"desc\":\"\"},\"2\":{\"image\":\"/upfile/2021/03/1614686777942.jpg\",\"desc\":\"\"},\"3\":{\"image\":\"/upfile/2021/03/1614686777801.jpg\",\"desc\":\"\"}}');
INSERT INTO `sd_tags` VALUES ('1', '新闻', '1');
INSERT INTO `sd_tags` VALUES ('2', '焦点图', '1');
INSERT INTO `sd_tags` VALUES ('3', '热门关键词', '2');
INSERT INTO `sd_tags` VALUES ('4', '产品', '1');
INSERT INTO `sd_tags` VALUES ('5', '销售', '2');
INSERT INTO `sd_temp_mail` VALUES ('1', '留言提醒', '有一条新的留言需要处理', '<p>姓　名：$name<br/>手　机：$mobile<br/>电　话：$tel<br/>内　容：$remark</p>', '1', 'book');
INSERT INTO `sd_temp_mail` VALUES ('2', '询价提醒', '有一条新的询价需要处理', '<p>产　品：$proname<br/>姓　名：$name<br/>手　机：$mobile<br/>备　注：$remark</p>', '1', 'inquiry');
INSERT INTO `sd_temp_mail` VALUES ('3', '订单提醒', '有一条新的订单需要处理', '<p>订单号：$orderid<br/>产　品：$proname<br/>数　量：$num<br/>金　额：$money<br/>姓　名：$name<br/>手　机：$mobile<br/>地　址：$address<br/>备　注：$remark</p>', '1', 'order');
INSERT INTO `sd_temp_mail` VALUES ('4', '用户注册', '账号注册邮箱验证', '<p>您正在进行【注册账户】邮箱验证：<br/>您的验证码是：$code<br/>如本邮件非您操作响应，请忽略。</p>', '1', 'reg');
INSERT INTO `sd_temp_mail` VALUES ('5', '找回密码', '账户找回密码邮箱验证', '<p>您正在进行【找回密码】邮箱验证：<br/>您的验证码是：$code<br/>如本邮件非您操作响应，请忽略。</p>', '1', 'getpass');
INSERT INTO `sd_user` VALUES ('1', '12345', '827ccb0eea8a706c4c34a16891f84e7b', '0', '12345@qq.com', '', '1', '1', '1614947723', '0.0.0.0', '1615253512', '0.0.0.0', '1');
INSERT INTO `sd_user` VALUES ('2', '123456', 'e10adc3949ba59abbe56e057f20f883e', '0', '123456@qq.com', '', '2', '1', '1614947741', '0.0.0.0', '1614947741', '', '0');
INSERT INTO `sd_user_group` VALUES ('1', '普通会员', '0');
INSERT INTO `sd_user_group` VALUES ('2', 'Vip会员', '0');
INSERT INTO `sd_link` VALUES ('1', 'sdcms官网', '', 'https://www.sdcms.net', '0', '0', '0', '1');
INSERT INTO `sd_link` VALUES ('2', '极品模板', '', 'https://www.nicemb.com', '0', '0', '0', '1');