
// 图片上传demo
jQuery(function() {
    var $ = jQuery,
        $list = $('#list_pre'),

        // 缩略图大小
        thumbnailWidth = 300,
        thumbnailHeight = 300,

        // Web Uploader实例
        uploader;

    // 初始化Web Uploader
    uploader = WebUploader.create({

        // 自动上传。
        auto: true,
		
		//运行方式
		runtimeOrder:"html5",

        // 文件接收服务端。
        server: serverurl,

        // 选择文件的按钮。可选。
        // 内部根据当前运行是创建，可能是input元素，也可能是flash.
        pick: '#filePicker',
        // 只允许选择文件，可选。
        accept: {
            title: '文件类型',
            extensions: 'gif,jpg,jpeg,png,zip,rar,7z,gz,tar,swf,mp4,flv,doc,docx,xls,xlsx,ppt,pptx,apk,iso,pdf,txt,pem,ico',
            mimeTypes: ''
        },
		compress:false,
		resize: false
    });

    // 当有文件添加进来的时候
    uploader.on( 'fileQueued', function( file ) {
		var html='<div class="piclist-item" data-url="" title="'+file.name+'" id="' +file.id+ '"><div class="piclist-image"><a><img/></a></div><div class="piclist-body"><div class="piclist-title text-hide">'+file.name+'</div></div>';
        var $li = $(html),
            $img = $li.find('img');

        $list.append( $li );

        // 创建缩略图
        uploader.makeThumb( file, function( error, src ) {
            if ( error ) {
                $img.replaceWith('<span>不能预览</span>');
                return;
            }

            $img.attr( 'src', src );
        }, thumbnailWidth, thumbnailHeight );
    });

    // 文件上传过程中创建进度条实时显示。
    uploader.on( 'uploadProgress', function( file, percentage )
	{
        var $li = $( '#'+file.id ),
            $percent = $li.find('.progress span');

        // 避免重复创建
        if ( !$percent.length ) {
            $percent = $('<div class="progress progress-sm progress-radius progress-red progress-striped"><div class="progress-bar" style="width:0%;"></div></div>')
                    .appendTo( $li )
                    .find('.progress-bar');
        }

        $percent.css( 'width', percentage * 100 + '%' );
    });
	

    // 文件上传失败，现实上传出错。
    uploader.on( 'uploadError', function( file )
	{
        var $li = $( '#'+file.id ),
            $error = $li.find('.error');

        // 避免重复创建
        if ( !$error.length ) {
            $error = $('<div class="error"></div>').appendTo( $li );
        }
		$li.addClass('disabled');
        $error.text('服务器异常');
    });
	
	uploader.on( 'uploadAccept', function( file, response )
	{
		var file=file.file;
		if(response.state=='success')
		{
			$( '#'+file.id ).addClass('hover').attr("data-url",response.msg);
			choose();
			//alert(response.msg)
		}
		else
		{
			
			 var $li = $( '#'+file.id ),
            $error = $li.find('.error');
	
			// 避免重复创建
			if ( !$error.length ) {
				$error = $('<div class="error"></div>').appendTo( $li );
			}
			$li.addClass('disabled');
			$error.html(response.msg);
		}
		
	});

    // 完成上传完了，成功或者失败，先删除进度条。
    uploader.on( 'uploadComplete', function( file ) {
        $( '#'+file.id ).find('.progress').remove();
    });
});