/**
 * This file is part of the NocoBase (R) project.
 * Copyright (c) 2020-2024 NocoBase Co., Ltd.
 * Authors: NocoBase Team.
 *
 * This project is dual-licensed under AGPL-3.0 and NocoBase Commercial License.
 * For more information, please refer to: https://www.nocobase.com/agreement.
 */

import { Icon } from '@nocobase/client';
import React from 'react';

const RadarChart = () => (
  <svg width="1em" height="1em" fill="currentColor" aria-hidden="true" focusable="false" viewBox="0 0 1024 1024">
    <path d="M523 573.5c-3.9 0.7-7.9 1.1-12 1.1-5.3 0-10.4-0.6-15.2-1.8l-62.2 189.7 167.4-76L523 573.5z"></path>
    <path d="M398.3 767.3l68.9-210.1c-6.4-6-11.5-13.3-15-21.4l-192.6 52.7L398.3 767.3z"></path>
    <path d="M528 448.9c4.1 1.1 8 2.6 11.7 4.5l72.5-61.8L528 263.7 528 448.9z"></path>
    <path d="M259.6 555.4 447.3 504c0.4-4.2 1.3-8.3 2.5-12.2L270.9 373.4 259.6 555.4z"></path>
    <path d="M655.5 396.7l208.3 185.7 30.2 4.8c4.8-24.6 7.4-49.9 7.4-75.9 0-95.9-34.6-183.7-92-251.6L655.5 396.7z"></path>
    <path d="M794.4 563.4 630.9 417.7l-67 57.1c5.6 8.3 9.3 18 10.6 28.4L794.4 563.4z"></path>
    <path d="M496 448.4 496 239.6l-218.8 99.6 189.4 125.4C474.7 456.8 484.8 451.1 496 448.4z"></path>
    <path d="M619.3 713.3 420 803.8l-19.1 81.6c35 10.3 72.1 15.9 110.4 15.9 74.4 0 143.9-20.8 203-56.9L619.3 713.3z"></path>
    <path d="M648.7 699.5l92.3 127.2c63.3-46.2 112.2-111 138.6-186.4L648.7 699.5z"></path>
    <path d="M386.2 804 226.1 597.7l-87.9 27.4c34.9 114.7 121.3 207 232.2 250L386.2 804z"></path>
    <path d="M226.9 564.3 240.2 353l-64.4-40.5c-34.6 58.2-54.4 126.2-54.4 198.8 0 28.4 3 56.2 8.8 82.9L226.9 564.3z"></path>
    <path d="M842.8 609.8l-272.7-74.7c-4 9.5-10.1 17.9-17.9 24.4l77.3 112.1L842.8 609.8z"></path>
    <path d="M528 205.4l108.8 165.2 151-134.5c-67-67.3-158.4-110.2-259.7-114.5L528.1 205.4z"></path>
    <path d="M245.7 318.4l250.3-114 0-82.8c-125 4.8-234.8 68.5-302.8 164L245.7 318.4z"></path>
  </svg>
);
const FunnelChart = () => (
  <svg width="1em" height="1em" fill="currentColor" aria-hidden="true" focusable="false" viewBox="0 0 1024 1024">
    <path d="M533.6 784.5c6.6 16.4-1.3 35-17.6 41.7l0 0c-16.4 6.6-35-1.3-41.7-17.6L129.9 236c-6.6-16.4 1.3-35 17.6-41.7l0 0c16.4-6.6 35 1.3 41.7 17.6L533.6 784.5z"></path>
    <path d="M536 812.2c-6.9 16.3-25.7 23.9-41.9 17l0 0c-16.3-6.9-23.9-25.7-17-41.9l357.6-575.7c6.9-16.3 25.7-23.9 41.9-17l0 0c16.3 6.9 23.9 25.7 17 41.9L536 812.2z"></path>
    <path d="M895.4 224c0 17.7-14.3 32-32 32l-704 0c-17.7 0-32-14.3-32-32l0 0c0-17.7 14.3-32 32-32l704 0C881 192 895.4 206.3 895.4 224L895.4 224z"></path>
    <path d="M278.6 384l465 0 0 64-465 0 0-64Z"></path>
    <path d="M391.6 576l232.5 0 0 64-232.5 0 0-64Z"></path>
  </svg>
);
const ScatterChart = () => (
  <svg width="1em" height="1em" fill="currentColor" aria-hidden="true" focusable="false" viewBox="0 0 1024 1024">
    <path d="M191 864c0 17.7-14.3 32-32 32l0 0c-17.7 0-32-14.3-32-32L127 160c0-17.7 14.3-32 32-32l0 0c17.7 0 32 14.3 32 32L191 864z"></path>
    <path d="M159 896c-17.7 0-32-14.3-32-32l0 0c0-17.7 14.3-32 32-32l712 0c17.7 0 32 14.3 32 32l0 0c0 17.7-14.3 32-32 32L159 896z"></path>
    <path d="M745.6 765.9"></path>
    <path d="M307.6 244.3m-48 0a48 48 0 1 0 96 0 48 48 0 1 0-96 0Z"></path>
    <path d="M560 479.2m-48 0a48 48 0 1 0 96 0 48 48 0 1 0-96 0Z"></path>
    <path d="M391.9 387.7m-48 0a48 48 0 1 0 96 0 48 48 0 1 0-96 0Z"></path>
    <path d="M540.4 244.3m-48 0a48 48 0 1 0 96 0 48 48 0 1 0-96 0Z"></path>
    <path d="M732.9 292.3m-48 0a48 48 0 1 0 96 0 48 48 0 1 0-96 0Z"></path>
    <path d="M792.9 717.9m-48 0a48 48 0 1 0 96 0 48 48 0 1 0-96 0Z"></path>
    <path d="M307.6 527.2m-48 0a48 48 0 1 0 96 0 48 48 0 1 0-96 0Z"></path>
    <path d="M439.9 662.4m-48 0a48 48 0 1 0 96 0 48 48 0 1 0-96 0Z"></path>
  </svg>
);
const ColumnChart = () => (
  <svg width="1em" height="1em" fill="currentColor" aria-hidden="true" focusable="false" viewBox="0 0 1024 1024">
    <path d="M191 864c0 17.7-14.3 32-32 32l0 0c-17.7 0-32-14.3-32-32L127 160c0-17.7 14.3-32 32-32l0 0c17.7 0 32 14.3 32 32L191 864z"></path>
    <path d="M159 896c-17.7 0-32-14.3-32-32l0 0c0-17.7 14.3-32 32-32l712 0c17.7 0 32 14.3 32 32l0 0c0 17.7-14.3 32-32 32L159 896z"></path>
    <path d="M745.6 765.9"></path>
    <path d="M342.1 734.3c0 17.5-14.2 31.7-31.7 31.7l0 0c-17.5 0-31.7-14.2-31.7-31.7L278.7 489c0-17.5 14.2-31.7 31.7-31.7l0 0c17.5 0 31.7 14.2 31.7 31.7L342.1 734.3z"></path>
    <path d="M493.8 734.3c0 17.5-14.2 31.7-31.7 31.7l0 0c-17.5 0-31.7-14.2-31.7-31.7L430.4 387c0-17.5 14.2-31.7 31.7-31.7l0 0c17.5 0 31.7 14.2 31.7 31.7L493.8 734.3z"></path>
    <path d="M797.3 734.3c0 17.5-14.2 31.7-31.7 31.7l0 0c-17.5 0-31.7-14.2-31.7-31.7L733.9 234.5c0-17.5 14.2-31.7 31.7-31.7l0 0c17.5 0 31.7 14.2 31.7 31.7L797.3 734.3z"></path>
    <path d="M645.5 734.3c0 17.5-14.2 31.7-31.7 31.7l0 0c-17.5 0-31.7-14.2-31.7-31.7l0-97.2c0-17.5 14.2-31.7 31.7-31.7l0 0c17.5 0 31.7 14.2 31.7 31.7L645.5 734.3z"></path>
  </svg>
);

const BarChart = () => (
  <svg width="1em" height="1em" fill="currentColor" aria-hidden="true" focusable="false" viewBox="0 0 1024 1024">
    <path d="M131.072 156.16c0-17.92 14.336-31.744 31.744-31.744 17.92 0 31.744 14.336 31.744 31.744v712.192c0 17.92-14.336 31.744-31.744 31.744-17.92 0-31.744-14.336-31.744-31.744V156.16zM292.864 338.944c-17.408 0-31.744-14.336-31.744-31.744 0-17.408 14.336-31.744 31.744-31.744h245.248c17.408 0 31.744 14.336 31.744 31.744 0 17.408-14.336 31.744-31.744 31.744h-245.248zM292.864 490.496c-17.408 0-31.744-14.336-31.744-31.744 0-17.408 14.336-31.744 31.744-31.744H640c17.408 0 31.744 14.336 31.744 31.744 0 17.408-14.336 31.744-31.744 31.744h-347.136zM292.864 794.112c-17.408 0-31.744-14.336-31.744-31.744 0-17.408 14.336-31.744 31.744-31.744h499.712c17.408 0 31.744 14.336 31.744 31.744 0 17.408-14.336 31.744-31.744 31.744h-499.712zM292.864 642.56c-17.408 0-31.744-14.336-31.744-31.744 0-17.408 14.336-31.744 31.744-31.744h97.28c17.408 0 31.744 14.336 31.744 31.744 0 17.408-14.336 31.744-31.744 31.744h-97.28z"></path>
  </svg>
);

const LineChart = () => (
  <svg width="1em" height="1em" fill="currentColor" aria-hidden="true" focusable="false" viewBox="0 0 1024 1024">
    <path d="M191 864c0 17.7-14.3 32-32 32l0 0c-17.7 0-32-14.3-32-32L127 160c0-17.7 14.3-32 32-32l0 0c17.7 0 32 14.3 32 32L191 864z"></path>
    <path d="M159 896c-17.7 0-32-14.3-32-32l0 0c0-17.7 14.3-32 32-32l712 0c17.7 0 32 14.3 32 32l0 0c0 17.7-14.3 32-32 32L159 896z"></path>
    <path d="M307.1 686.3c-12.4 12.4-32.4 12.4-44.8 0l0 0c-12.4-12.4-12.4-32.4 0-44.8l173.4-173.4c12.4-12.4 32.4-12.4 44.8 0l0 0c12.4 12.4 12.4 32.4 0 44.8L307.1 686.3z"></path>
    <path d="M608.8 640c-12.4 12.4-32.4 12.4-44.8 0l0 0c-12.4-12.4-12.4-32.4 0-44.8l212.7-212.7c12.4-12.4 32.4-12.4 44.8 0l0 0c12.4 12.4 12.4 32.4 0 44.8L608.8 640z"></path>
    <path d="M608 595.3c12.4 12.4 12.4 32.4 0 44.8l0 0c-12.4 12.4-32.4 12.4-44.8 0L436 512.8c-12.4-12.4-12.4-32.4 0-44.8l0 0c12.4-12.4 32.4-12.4 44.8 0L608 595.3z"></path>
  </svg>
);

const PieChart = () => (
  <svg width="1em" height="1em" fill="currentColor" aria-hidden="true" focusable="false" viewBox="0 0 1024 1024">
    <path d="M489.7 511 489 511 489 126.9c-201 12.3-360.1 179.2-360.1 383.3 0 212.1 171.9 384 384 384 106.5 0 202.9-43.4 272.5-113.4L489.7 511z"></path>
    <path d="M773.1 237.2l6-6c-62.7-59.6-143.5-95.8-228.2-104l0 304.7L773.1 237.2z"></path>
    <path d="M819.5 281.6 564.1 505.1 822 739c3-4 5.9-8.1 8.7-12.3 41.4-61.3 65.6-135.2 65.6-214.7C896.3 425.6 867.7 345.8 819.5 281.6z"></path>
  </svg>
);

const AreaChart = () => (
  <svg width="1em" height="1em" fill="currentColor" aria-hidden="true" focusable="false" viewBox="0 0 1024 1024">
    <path d="M191 864c0 17.7-14.3 32-32 32l0 0c-17.7 0-32-14.3-32-32L127 160c0-17.7 14.3-32 32-32l0 0c17.7 0 32 14.3 32 32L191 864z"></path>
    <path d="M159 896c-17.7 0-32-14.3-32-32l0 0c0-17.7 14.3-32 32-32l712 0c17.7 0 32 14.3 32 32l0 0c0 17.7-14.3 32-32 32L159 896z"></path>
    <path d="M830.6 338.2 830.6 338.2c0.9-9.2-2.1-18.6-9.1-25.7-12.4-12.4-32.4-12.4-44.8 0L586 503.3 480.8 398.1c-6.2-6.2-14.4-9.3-22.5-9.3-8.1 0-16.3 3.1-22.5 9.3L262.4 571.5c-6 6-9.1 13.8-9.3 21.6 0 0.1 0 0.1 0 0.2l0 111.8c0 35.3 28.7 64 64 64l449.7 0c33.8 0 61.4-26.1 63.8-59.3l0 0 0-0.2c0.1-1.5 0.2-3 0.2-4.5L830.8 593.3c0-0.3-0.1-0.7-0.2-1L830.6 338.2z"></path>
  </svg>
);

Icon.register({
  'icon-area': (props) => <Icon component={AreaChart} {...props} />,
  'icon-pie': (props) => <Icon component={PieChart} {...props} />,
  'icon-radar': (props) => <Icon component={RadarChart} {...props} />,
  'icon-funnel': (props) => <Icon component={FunnelChart} {...props} />,
  'icon-line': (props) => <Icon component={LineChart} {...props} />,
  'icon-bar': (props) => <Icon component={BarChart} {...props} />,
  'icon-column': (props) => <Icon component={ColumnChart} {...props} />,
  'icon-scatter': (props) => <Icon component={ScatterChart} {...props} />,
});
