/**
 * This file is part of the NocoBase (R) project.
 * Copyright (c) 2020-2024 NocoBase Co., Ltd.
 * Authors: NocoBase Team.
 *
 * This project is dual-licensed under AGPL-3.0 and NocoBase Commercial License.
 * For more information, please refer to: https://www.nocobase.com/agreement.
 */

import { useTranslation } from 'react-i18next';

export const usePluginUtils = () => {
  const { t } = useTranslation('multi-app-share-collection');

  return { t };
};

export const i18nText = (text) => {
  return `{{t("${text}", { ns: 'multi-app-share-collection' })}}`;
};
