/**
 * This file is part of the NocoBase (R) project.
 * Copyright (c) 2020-2024 NocoBase Co., Ltd.
 * Authors: NocoBase Team.
 *
 * This project is dual-licensed under AGPL-3.0 and NocoBase Commercial License.
 * For more information, please refer to: https://www.nocobase.com/agreement.
 */

import * as React from 'react';

function Brush(props) {
  return /*#__PURE__*/ React.createElement(
    'svg',
    Object.assign(
      {
        width: '1em',
        height: '1em',
        viewBox: '0 0 14 18',
        xmlns: 'http://www.w3.org/2000/svg',
        xmlnsXlink: 'http://www.w3.org/1999/xlink',
      },
      props,
      {
        style: Object.assign(
          {
            verticalAlign: '-0.125em',
          },
          props.style,
        ),
        className: ['nanqu-token-panel-icon', props.className].filter(Boolean).join(' '),
      },
    ),
    /*#__PURE__*/ React.createElement(
      'g',
      {
        id: 'Brush-\u9875\u9762-1',
        stroke: 'none',
        strokeWidth: 1,
        fill: 'none',
        fillRule: 'evenodd',
        fillOpacity: 0.649999976,
      },
      /*#__PURE__*/ React.createElement(
        'g',
        {
          id: 'Brush-\u4E3B\u9898\u7F16\u8F91\u5668---\u591A\u4E3B\u9898',
          transform: 'translate(-17.000000, -121.000000)',
          fill: 'currentColor',
          fillRule: 'nonzero',
        },
        /*#__PURE__*/ React.createElement(
          'g',
          {
            id: 'Brush-brush',
            transform: 'translate(14.000000, 120.000000)',
          },
          /*#__PURE__*/ React.createElement('path', {
            d:
              'M8.20652175,3.2826087 L8.20652175,4.10326086 C8.20652175,4.55649455 7.83910325,4.92391304 7.38586957,4.92391304 C6.93263588,4.92391304 6.56521738,4.55649455 6.56521738,4.10326086 L6.56521738,3.2826087 L4.92391304,3.2826087 L4.92391304,8.20652175 L14.7717391,8.20652175 L14.7717391,3.2826087 L13.1304348,3.2826087 L13.1304348,5.74456522 C13.1304348,6.19779891 12.7630163,6.5652174 12.3097826,6.5652174 C11.8565489,6.5652174 11.4891304,6.19779891 11.4891304,5.74456522 L11.4891304,3.2826087 L8.20652175,3.2826087 Z M4.92391304,9.84782609 L4.92391304,11.4891304 L7.72233695,11.4891304 C8.08431263,11.4890155 8.42799204,11.6482243 8.66197039,11.9244136 C8.89594874,12.2006029 8.99650752,12.5657753 8.93690217,12.9228098 L8.60043479,14.9399728 C8.51784643,15.435105 8.73592476,15.9322123 9.15616576,16.2067558 C9.57640676,16.4812994 10.1192454,16.4812994 10.5394864,16.2067558 C10.9597274,15.9322123 11.1778057,15.435105 11.0952174,14.9399728 L10.75875,12.9228098 C10.6991446,12.5657753 10.7997034,12.2006029 11.0336818,11.9244136 C11.2676601,11.6482243 11.6113395,11.4890155 11.9733152,11.4891304 L14.7717391,11.4891304 L14.7717391,9.84782609 L4.92391304,9.84782609 Z M12.7143641,14.6699783 C12.9035912,15.807501 12.4022968,16.9492894 11.4368082,17.5798421 C10.4713197,18.2103948 9.2243325,18.2103948 8.25884395,17.5798421 C7.2933554,16.9492894 6.79206095,15.807501 6.98128804,14.6699783 L7.23815217,13.1304348 L4.92391304,13.1304348 C4.48861206,13.1304348 4.07113988,12.9575121 3.76333561,12.6497079 C3.45553133,12.3419036 3.2826087,11.9244314 3.2826087,11.4891304 L3.2826087,3.2826087 C3.2826087,2.84730772 3.45553133,2.42983554 3.76333561,2.12203126 C4.07113988,1.81422698 4.48861206,1.64130434 4.92391304,1.64130434 L14.7717391,1.64130434 C15.2070401,1.64130434 15.6245123,1.81422698 15.9323166,2.12203126 C16.2401208,2.42983554 16.4130435,2.84730772 16.4130435,3.2826087 L16.4130435,11.4891304 C16.4130435,11.9244314 16.2401208,12.3419036 15.9323166,12.6497079 C15.6245123,12.9575121 15.2070401,13.1304348 14.7717391,13.1304348 L12.4575,13.1304348 L12.7143641,14.6699783 L12.7143641,14.6699783 Z',
            id: 'Brush-\u5F62\u72B6',
          }),
        ),
      ),
    ),
  );
}

export default Brush;
