#include "stdafx.h"
#include "http_service.h"
#include "http_servlet.h"
#include "master_service.h"

//////////////////////////////////////////////////////////////////////////////
// 

char *var_cfg_redis_addrs;
char *var_cfg_libcrypto_path;
char *var_cfg_libx509_path;
char *var_cfg_libssl_path;
char *var_cfg_crt_file;
char *var_cfg_key_file;
char *var_cfg_html_path;

acl::master_str_tbl var_conf_str_tab[] = {
	{ "redis_addrs", "127.0.0.1:6379", &var_cfg_redis_addrs },
	{ "libcrypto_path", "", &var_cfg_libcrypto_path },
	{ "libx509_path", "", &var_cfg_libx509_path},
	{ "libssl_path", "", &var_cfg_libssl_path },
	{ "crt_file", "", &var_cfg_crt_file },
	{ "key_file", "", &var_cfg_key_file },
	{ "html_path", "./html", &var_cfg_html_path },

	{ 0, 0, 0 }
};

int   var_cfg_use_redis_session;
int   var_cfg_ssl_session_cache;

acl::master_bool_tbl var_conf_bool_tab[] = {
	{ "use_redis_session", 1, &var_cfg_use_redis_session },
	{ "ssl_session_cache", 1, &var_cfg_ssl_session_cache },

	{ 0, 0, 0 }
};

int   var_cfg_conn_timeout;
int   var_cfg_rw_timeout;
int   var_cfg_max_threads;

acl::master_int_tbl var_conf_int_tab[] = {
	{ "rw_timeout", 120, &var_cfg_rw_timeout, 0, 0 },
	{ "ioctl_max_threads", 128, &var_cfg_max_threads, 0, 0 },

	{ 0, 0 , 0 , 0, 0 }
};

long long int   var_cfg_int64;
acl::master_int64_tbl var_conf_int64_tab[] = {
	{ "int64", 120, &var_cfg_int64, 0, 0 },

	{ 0, 0 , 0 , 0, 0 }
};

//////////////////////////////////////////////////////////////////////////////

master_service::master_service(void)
{
	redis_   = NULL;
	conf_    = NULL;
	service_ = new http_service;
}

master_service::~master_service(void)
{
	delete conf_;
	delete service_;
}

http_service& master_service::get_service(void) const
{
	return *service_;
}

bool master_service::thread_on_read(acl::socket_stream* conn)
{
	http_servlet* servlet = (http_servlet*) conn->get_ctx();
	if (servlet == NULL) {
		logger_fatal("servlet null!");
	}

	return servlet->doRun();
}

acl::sslbase_io* master_service::setup_ssl(acl::socket_stream& conn,
		acl::sslbase_conf& conf)
{
	acl::sslbase_io* hook = (acl::sslbase_io*) conn.get_hook();
	if (hook != NULL) {
		return hook;
	}

	// ʹ SSL ʽҪ SSL IO ע
	// У ssl io 滻 stream Ĭϵĵײ IO 

	//logger("begin setup ssl hook...");

	//  SSL ַʽ
	acl::sslbase_io* ssl = conf.create(false);
	if (conn.setup_hook(ssl) == ssl) {
		logger_error("setup_hook error!");
		ssl->destroy();
		return NULL;
	}

	if (!ssl->handshake()) {
		logger_error("ssl handshake failed");
		return NULL;
	}

	if (!ssl->handshake_ok()) {
		logger("handshake trying again...");
		return NULL;
	}

	logger("handshake_ok");

	return ssl;
}

bool master_service::thread_on_accept(acl::socket_stream* conn)
{
	logger("connect from %s, fd: %d", conn->get_peer(true),
		conn->sock_handle());

	if (conf_) {
		acl::sslbase_io* ssl = setup_ssl(*conn, *conf_);
		if (ssl == NULL) {
			return false;
		}
	}

	conn->set_rw_timeout(var_cfg_rw_timeout);
	if (var_cfg_rw_timeout > 0) {
		conn->set_tcp_non_blocking(true);
	}

	acl::session* session;
	if (var_cfg_use_redis_session) {
		session = new acl::redis_session(*redis_);
	} else {
		session = new acl::memcache_session("127.0.0.1:11211");
	}

	http_servlet* servlet = new http_servlet(*service_, conn, session);
	conn->set_ctx(servlet);

	return true;
}

bool master_service::thread_on_timeout(acl::socket_stream* conn)
{
	logger("read timeout from %s, fd: %d", conn->get_peer(),
		conn->sock_handle());
	return false;
}

void master_service::thread_on_close(acl::socket_stream* conn)
{
	logger("disconnect from %s, fd: %d", conn->get_peer(),
		conn->sock_handle());

	http_servlet* servlet = (http_servlet*) conn->get_ctx();
	acl::session* session = &servlet->getSession();
	delete session;
	delete servlet;
}

void master_service::thread_on_init(void)
{
}

void master_service::thread_on_exit(void)
{
}

void master_service::proc_on_listen(acl::server_socket& ss)
{
	logger(">>>listen %s ok<<<", ss.get_addr());
}

void master_service::proc_on_init(void)
{
	// create redis cluster for session cluster
	redis_ = new acl::redis_client_cluster;
	redis_->init(NULL, var_cfg_redis_addrs, var_cfg_max_threads,
		var_cfg_conn_timeout, var_cfg_rw_timeout);

	// ʼ SSL 

	if (var_cfg_crt_file == NULL || *var_cfg_crt_file == 0
		|| var_cfg_key_file == NULL || *var_cfg_key_file == 0) {
		logger("not use SSL mode");
		return;
	}

	if (strstr(var_cfg_libssl_path, "mbedtls")) {
		acl::mbedtls_conf::set_libpath(var_cfg_libcrypto_path,
			var_cfg_libx509_path, var_cfg_libssl_path);
		if (!acl::mbedtls_conf::load()) {
			logger_error("load %s error", var_cfg_libssl_path);
			return;
		}

		conf_ = new acl::mbedtls_conf(true);
	} else if (strstr(var_cfg_libssl_path, "polarssl")) {
		acl::polarssl_conf::set_libpath(var_cfg_libssl_path);
		if (!acl::polarssl_conf::load()) {
			logger_error("load %s error", var_cfg_libssl_path);
			return;
		}

		conf_ = new acl::polarssl_conf();
	}

	// ˵ SSL Ự湦
	conf_->enable_cache(var_cfg_ssl_session_cache);

	// ӱط֤
	if (!conf_->add_cert(var_cfg_crt_file)) {
		logger_error("add cert failed, crt: %s, key: %s",
			var_cfg_crt_file, var_cfg_key_file);
		delete conf_;
		conf_ = NULL;
		return;
	}
	logger("load cert ok, crt: %s, key: %s",
		var_cfg_crt_file, var_cfg_key_file);

	// ӱطԿ
	if (!conf_->set_key(var_cfg_key_file)) {
		logger_error("set private key error");
		delete conf_;
		conf_ = NULL;
	}
}

void master_service::proc_on_exit(void)
{
	delete redis_;
}

bool master_service::proc_exit_timer(size_t nclients, size_t nthreads)
{
	if (nclients == 0) {
		logger("clients count: %d, threads count: %d",
			(int) nclients, (int) nthreads);
		return true;
	}

	return false;
}

bool master_service::proc_on_sighup(acl::string&)
{
	logger(">>>proc_on_sighup<<<");
	return true;
}
