#pragma once

class http_service;

class master_service : public acl::master_threads
{
public:
	master_service(void);
	~master_service(void);

	http_service& get_service(void) const;

protected:
	/**
	 * @override
	 * 麯ĳͻݿɶرջʱô˺
	 * @param stream {socket_stream*}
	 * @return {bool}  false ʾغҪرӣ
	 *  ʾҪֳӣӦӦ÷ false
	 */
	bool thread_on_read(acl::socket_stream* stream);

	/**
	 * @override
	 * ̳߳еĳ̻߳һʱĻص
	 * һЩʼ
	 * @param stream {socket_stream*}
	 * @return {bool}  false ʾҪرӣ
	 *  ؽٴ thread_main 
	 */
	bool thread_on_accept(acl::socket_stream* stream);

	/**
	 * @override
	 * ĳӵ IO дʱʱĻصú true 
	 * ʾȴһζдϣرո
	 * @param stream {socket_stream*}
	 * @return {bool}  false ʾҪرӣ
	 *  ؽٴ thread_main 
	 */
	bool thread_on_timeout(acl::socket_stream* stream);

	/**
	 * @override
	 * ĳ̰߳󶨵ӹرʱĻص
	 * @param stream {socket_stream*}
	 */
	void thread_on_close(acl::socket_stream* stream);

	/**
	 * @override
	 * ̳߳һ̱߳ʱĻص
	 */
	void thread_on_init(void);

	/**
	 * @override
	 * ̳߳һ߳˳ʱĻص
	 */
	void thread_on_exit(void);

	/**
	 * @override
	 * ڽʱÿɹһصַñ
	 * @param ss {acl::server_socket&} 
	 */
	void proc_on_listen(acl::server_socket& ss);

	/**
	 * @override
	 * лûݺõĻص˺ʱ
	 * ȨΪͨ޼
	 */
	void proc_on_init(void);

	/**
	 * @override
	 * ӽҪ˳ʱܽص˺ܾӽǷ˳ȡڣ
	 * 1) ˺ true ӽ˳
	 * 2) ӽпͻӶѹرգӽ˳
	 * 3) 鿴ļе(ioctl_quick_abort) 0 
	 *    ӽ˳
	 * 4) пͻӹرպ˳
	 * @param ncleints {size_t} ǰӵĿͻ˸
	 * @param nthreads {size_t} ǰ̳߳зæĹ̸߳
	 * @return {bool}  false ʾǰӽ̻˳ʾǰ
	 *  ӽ̿˳
	 */
	bool proc_exit_timer(size_t nclients, size_t nthreads);

	/**
	 * @override
	 * ˳ǰõĻص
	 */
	void proc_on_exit(void);

	/**
	 * @override
	 * յ SIGHUP źźĻص
	 */
	bool proc_on_sighup(acl::string&);

private:
	// redis Ⱥ
	acl::redis_client_cluster* redis_;
	acl::sslbase_conf* conf_;
	http_service* service_;

	acl::sslbase_io* setup_ssl(acl::socket_stream& conn,
		acl::sslbase_conf& conf);
};
