#ifndef ACL_MBOX_INCLUDE_H
#define ACL_MBOX_INCLUDE_H

#ifdef __cplusplus
extern "C" {
#endif

#include "acl_define.h"

typedef struct ACL_MBOX ACL_MBOX;

/**
 * Ϣж
 * @return {ACL_MBOX}
 */
ACL_API ACL_MBOX *acl_mbox_create(void);

#define	ACL_MBOX_T_SPSC		0	/* ߵ */
#define	ACL_MBOX_T_MPSC		1	/* ߵ */

ACL_API ACL_MBOX *acl_mbox_create2(unsigned type);

/**
 * ͷϢж
 * @param mbox {ACL_MBOX*} Ϣж
 * @param free_fn {void (*)(void*)} ǿʱͷŵǰϢеĶ
 */
ACL_API void acl_mbox_free(ACL_MBOX *mbox, void (*free_fn)(void*));

/**
 * ϢӶ̬Ϣ
 * @param mbox {ACL_MBOX*} Ϣж
 * @param msg {void*}
 * @return {int} ͳɹ 0򷵻 -1
 */
ACL_API int acl_mbox_send(ACL_MBOX *mbox, void *msg);

/**
 * ϢжȡϢ
 * @param mbox {ACL_MBOX*} Ϣж
 * @param timeout {int} ȴʱʱ(뼶) < 0 һֱȴֱ
 * @param success {int*} 洢ǷɹĽ 0 ʾ 0 ʾɹ
 * @return {void*} ضϢ NULL ʱж success ֵԴ
 *  ж϶Ƿɹط NULL ʾɹһϢ
 */
ACL_API void *acl_mbox_read(ACL_MBOX *mbox, int timeout, int *success);

/**
 * õǰϢѾɹ͵Ϣ
 * @param mbox {ACL_MBOX*} Ϣж
 * @return {size_t}
 */
ACL_API size_t acl_mbox_nsend(ACL_MBOX *mbox);

/**
 * õǰϢѾɹյϢ
 * @param mbox {ACL_MBOX*} Ϣж
 * @return {size_t}
 */
ACL_API size_t acl_mbox_nread(ACL_MBOX *mbox);

#ifdef __cplusplus
}
#endif

#endif
