#ifndef	ACL_MYLOG_INCLUDE_H
#define	ACL_MYLOG_INCLUDE_H

#include <stdarg.h>

#ifdef  __cplusplus
extern "C" {
#endif

#include "acl_define.h"
#include "acl_vstream.h"

#ifdef	ACL_UNIX
#include <netinet/in.h>
#endif

typedef struct ACL_LOG ACL_LOG;

/**
 * ǰʱת־¼ʽʱʽ
 * @param buf {char*} ڴ洢
 * @param size {size_t} buf ĿռС
 */
ACL_API void acl_logtime_fmt(char *buf, size_t size);

/**
 * Ƿ¼߳IDţĬǲ¼
 * @param onoff {int}  0 ʾ¼߳ID򲻼¼
 */
ACL_API void acl_log_add_tid(int onoff);

/**
 * ־ļ
 * @param fp {ACL_VSTREAM *} ļ
 * @param plog_pre {const char*} ־¼ϢǰʾϢý
 */
ACL_API void acl_log_fp_set(ACL_VSTREAM *fp, const char *plog_pre);

/**
 * ־ļ
 * @param recipients {const char*} ־б "|" ָ
 *  ǱļԶ׽ӿڣ:
 *  /tmp/test.log|UDP:127.0.0.1:12345|TCP:127.0.0.1:12345|UNIX:/tmp/test.sock
 *  Ҫ־ͬʱ /tmp/test.log, UDP:127.0.0.1:12345,
 *  TCP:127.0.0.1:12345  UNIX:/tmp/test.sock ĸ־
 * @param plog_pre {const char*} ־¼ϢǰʾϢý
 *  дֵ
 */
ACL_API int acl_open_log(const char *recipients, const char *plog_pre);

/**
 * ڵ acl_open_log ǰԵñ趨־ fd Ƿ
 * acl_close_on_execȱʡ»Զ acl_close_on_exec
 * @param yes {int}  0 ʾ acl_close_on_execʾ
 */
ACL_API void acl_log_close_onexec(int yes);

/**
 * д־
 * @param fmt {const char*} ʽ
 * @param ... 
 * @return {int} д־ļ
 */
ACL_API int ACL_PRINTF(1, 2) acl_write_to_log(const char *fmt, ...);

/**
 * д־
 * @param info {const char*} ־ϢʾϢ
 * @param fmt {const char*} ʽ
 * @param ap {va_list} б
 * @return {int} д־ļ
 */
ACL_API int acl_write_to_log2(const char *info, const char *fmt, va_list ap);

/**
 * ر־ļ
 */
ACL_API void acl_close_log(void);

ACL_API ACL_ARRAY *acl_log_get_streams(void);
ACL_API void acl_log_free_streams(ACL_ARRAY *a);

#ifdef  __cplusplus
}
#endif

#endif


