#ifndef	ACL_XINETD_CFG_INCLUDE_H
#define	ACL_XINETD_CFG_INCLUDE_H

#ifdef	__cplusplus
extern "C" {
#endif

#include "acl_define.h"
#include "acl_array.h"

/**
 * ļͶ
 */
typedef struct ACL_XINETD_CFG_PARSER ACL_XINETD_CFG_PARSER;

/**
 * : Ҫ 
 * @param xcp ṹָ, Ϊ
 * @param name ı
 * @return ļ
 */
ACL_API const char *acl_xinetd_cfg_get(const ACL_XINETD_CFG_PARSER *xcp, const char *name);

/**
 * : Ҫ飬һӦֵʱ
 * @param xcp ṹָ, Ϊ
 * @param name ı
 * @return ļݶ̬
 */
ACL_API const ACL_ARRAY *acl_xinetd_cfg_get_ex(const ACL_XINETD_CFG_PARSER *xcp, const char *name);

/**
 * : ļлöӦĳһֵλõ
 * @param xcp ṹָ, Ϊ
 * @param idx λֵ
 * @param ppname ָָĵַı
 * @param ppvalue ָָĵַı
 * @return  0: OK, -1: ERR
 */
ACL_API int acl_xinetd_cfg_index(const ACL_XINETD_CFG_PARSER *xcp,
			int idx,
			char **ppname,
			char **ppvalue);

/**
 * : ļ
 * @param xcp ṹָ, Ϊ
 * @return ļ
 */
ACL_API int acl_xinetd_cfg_size(const ACL_XINETD_CFG_PARSER *xcp);

/**
 * : ͷɽṹָָڴռ
 * @param xcp ṹָ
 */
ACL_API void acl_xinetd_cfg_free(ACL_XINETD_CFG_PARSER *xcp);

/**
 * : ȡļн
 * @param pathname ļļ
 * @return ѾļĽṹָ
 */
ACL_API ACL_XINETD_CFG_PARSER *acl_xinetd_cfg_load(const char *pathname);

/**
 * ṹ
 */
typedef struct ACL_CFG_INT_TABLE {
	const char *name;
	int  defval;
	int *target;
	int  min;
	int  max;
} ACL_CFG_INT_TABLE;

/**
 * 64 λṹ
 */
typedef struct ACL_CFG_INT64_TABLE {
	const char *name;
	acl_int64  defval;
	acl_int64 *target;
	acl_int64  min;
	acl_int64  max;
} ACL_CFG_INT64_TABLE;

/**
 * ַṹ
 */
typedef struct ACL_CFG_STR_TABLE {
	const char *name;
	const char *defval;
	char **target;
} ACL_CFG_STR_TABLE;

/**
 * ṹ
 */
typedef struct ACL_CFG_BOOL_TABLE {
	const char *name;
	int   defval;
	int  *target;
} ACL_CFG_BOOL_TABLE;

/* in acl_xinetd_params.c */

/**
 * ļжȡ͵ı
 * @param cfg {ACL_XINETD_CFG_PARSER*} ΪʱĬֵиֵ
 * @param table {ACL_CFG_INT_TABLE*}
 */
ACL_API void acl_xinetd_params_int_table(ACL_XINETD_CFG_PARSER *cfg,
	ACL_CFG_INT_TABLE *table);

/**
 * ļжȡ 64 λ͵ı
 * @param cfg {ACL_XINETD_CFG_PARSER*} ΪʱĬֵиֵ
 * @param table {ACL_CFG_INT64_TABLE*}
 */
ACL_API void acl_xinetd_params_int64_table(ACL_XINETD_CFG_PARSER *cfg,
	ACL_CFG_INT64_TABLE *table);

/**
* ļжȡַ͵ı
* @param cfg {ACL_XINETD_CFG_PARSER*} ΪʱĬֵиֵ
* @param table {ACL_CFG_STR_TABLE*}
*/
ACL_API void  acl_xinetd_params_str_table(ACL_XINETD_CFG_PARSER *cfg,
	ACL_CFG_STR_TABLE *table);

/**
* ļжȡBOOL͵ı
* @param cfg {ACL_XINETD_CFG_PARSER*} ΪʱĬֵиֵ
* @param table {ACL_CFG_BOOL_TABLE*}
*/
ACL_API void  acl_xinetd_params_bool_table(ACL_XINETD_CFG_PARSER *cfg,
	ACL_CFG_BOOL_TABLE *table);

#ifdef	__cplusplus
}
#endif

#endif

