#pragma once

typedef enum
{
	DB_OK,                  // 
	DB_ERR_OPEN_DB,         // ݿʧ
	DB_ERR_CREATE_DB,       // ݿʧ
	DB_ERR_CREATE_TBL,      // ݱʧ
	DB_ERR_DB_NO_EXIST,     // ݿⲻ
	DB_ERR_TBL_NO_EXIST,    // ݱ
	DB_ERR_IDX_NO_EXIST,    // 
} db_error_t;

class db_result
{
public:
	db_result(void) {}
	~db_result(void) {}
};

/**
 * ࣬ඨ˴洢صĽӿ
 */
class db_driver
{
public:
	db_driver(void) {}
	virtual ~db_driver(void) {};

	/**
	 * ݿ⼰ݱݿδ򴴽µݿ⣬
	 * ڸݿϴµݱݱҲڸݱϴ
	 * µҲڣֱӷȷ
	 * @param dbname {const char*} ݿ
	 * @param tbl {const char* tbl} ݱ
	 * @param idx {const char* idx} ݱֵݱ
	 *  򴴽µĻڸѾڵ
	 * @param idx_unique {bool} ֶǷҪΨһ
	 * @param user {const char*} 򿪸ݿ˺
	 * @param pass {const char*} 򿪸ݿ˺
	 * @return {bool} Ƿɹ
	 */
	virtual bool create(const char* dbname, const char* tbl,
			const char* idx, bool idx_unique = false,
			const char* user = NULL, const char* pass = NULL) = 0;

	/**
	 * ݿ⼰ݱݿ⡢ݱ򷵻ʧ
	 * @param dbname {const char*} ݿ
	 * @param tbl {const char* tbl} ݱ
	 * @param idx {const char*} ֶ
	 * @param user {const char*} 򿪸ݿ˺
	 * @param pass {const char*} 򿪸ݿ˺
	 * @return {bool} Ƿɹ
	 */
	virtual bool open(const char* dbname, const char*tbl, const char* idx,
			const char* user = NULL, const char* pass = NULL) = 0;

	/**
	 * ӻ޸ݣֵӦݲʱݣ޸
	 * Ϊµ
	 * @param idx_value {const char*} ֵӦ open е
	 * @param data {cost void*} ݵַ
	 * @param dlen {size_t} data ݳ
	 * @return {bool}  false ʾʧܣԭ last_error() 
	 */
	virtual bool set(const char* idx_value, const void* data, size_t dlen) = 0;

	/**
	 * ֵ
	 * @param idx_value {const char*} ֵӦ open 򿪵ֶ
	 * @return {db_result*} 洢ѯֵǿʾѯɹ
	 *  Ҫһ db_result еĺòѯ
	 *  NULL ʾҪ last_error() óԭ
	 */
	virtual db_result* get(const char* idx_value) = 0;

	/**
	 * ֵɾݣͬʱɾصֵ
	 * @param idx_value {const char*} Ӧ open еֶεֵ
	 * @return {bool}  false ʾʧܣԭ last_error() ã
	 *  ɾ affect_count() 
	 */
	virtual bool del(const char* idx_value) = 0;

	/**
	 * ڵ set/del ʱô˺ԻӰļ¼ get
	 * ûбҪô˺
	 * @return {int} ֵ >= 0 ʾӰ¼
	 */
	virtual size_t affect_count() const = 0;

	/**
	 * ô˺ϴβĴ
	 * @return {db_error_t} 
	 */
	virtual db_error_t last_error() const = 0;

private:
};
